/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.service.OrgDependencyService;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component(value="OrgDependencyService")
public class OrgDependencyServiceImpl
implements OrgDependencyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrgDependencyServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TFSservice tfsService;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private RTItemFetchService rtItemFetchService;
    @Autowired
    private TFSUtils tfsUtils;

    public Map<String, Object> fetchItemDependencies(Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        String itemId = (String)params.get("itemId");
        String almAccountId = (String)params.get("almAccountId");
        Query query0 = new Query();
        query0.addCriteria((CriteriaDefinition)Criteria.where((String)"isOrg").is((Object)true));
        query0.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"sourceBacklogItemId").is((Object)itemId), Criteria.where((String)"targetBacklogItemId").is((Object)itemId)});
        query0.addCriteria((CriteriaDefinition)criteria);
        List links = this.mongoTemplate.find(query0, ItemJiraDependency.class);
        result.put("success", true);
        result.put("links", links);
        ArrayList<ObjectId> otherItemIdsToLoad = new ArrayList<ObjectId>();
        HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
        otherItemIdsToLoad.add(new ObjectId(itemId));
        if (PropertyValidator.isValid((Collection)links)) {
            for (ItemJiraDependency link : links) {
                if (PropertyValidator.isValid((Object)link.getSourceBacklogItemId()) && link.getSourceBacklogItemId().equals(itemId) && PropertyValidator.isValid((Object)link.getTargetBacklogItemId()) && !duplicationCheckMap.containsKey(link.getTargetBacklogItemId())) {
                    duplicationCheckMap.put(link.getTargetBacklogItemId(), link.getTargetBacklogItemId());
                    otherItemIdsToLoad.add(new ObjectId(link.getTargetBacklogItemId()));
                }
                if (!PropertyValidator.isValid((Object)link.getTargetBacklogItemId()) || !link.getTargetBacklogItemId().equals(itemId) || !PropertyValidator.isValid((Object)link.getSourceBacklogItemId()) || duplicationCheckMap.containsKey(link.getSourceBacklogItemId())) continue;
                duplicationCheckMap.put(link.getSourceBacklogItemId(), link.getSourceBacklogItemId());
                otherItemIdsToLoad.add(new ObjectId(link.getSourceBacklogItemId()));
            }
        }
        if (PropertyValidator.isValid(otherItemIdsToLoad)) {
            Query itemQuery = new Query();
            itemQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            itemQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(otherItemIdsToLoad));
            List items = this.mongoTemplate.find(itemQuery, BacklogItem.class);
            result.put("items", items);
        }
        if (PropertyValidator.isValid((Object)almAccountId)) {
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            HashMap linkTypesResult = this.tfsService.retrieveJiraIssueLinkTypesList(almAccount, false);
            if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
                result.put("tfsALMErrorCode", linkTypesResult.get("tfsALMErrorCode"));
                result.put("tfsALMErrorMessage", linkTypesResult.get("tfsALMErrorMessage"));
            } else {
                result.put("tfsLinkTypes", linkTypesResult.get("linkTypes"));
            }
        }
        return result;
    }

    public Map<String, Object> searchBacklogTargets(Map<String, Object> params) throws Exception {
        String searchText = (String)params.get("searchText");
        String almId = (String)params.get("almId");
        String releaseTrainId = (String)params.get("releaseTrainId");
        String currentItemId = (String)params.get("currentItemId");
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("searchText", PropertyValidator.isValid((Object)searchText) ? searchText : "");
        if (PropertyValidator.isValid((Object)almId)) {
            queryParams.put("almId", almId);
        }
        queryParams.put("releaseTrainId", releaseTrainId);
        queryParams.put("almOnly", true);
        Map resultMap = this.rtItemFetchService.searchBacklogItems(queryParams);
        List items = (List)resultMap.get("items");
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query0 = new Query();
        query0.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"sourceBacklogItemId").is((Object)currentItemId), Criteria.where((String)"targetBacklogItemId").is((Object)currentItemId)});
        query0.addCriteria((CriteriaDefinition)criteria);
        query0.addCriteria((CriteriaDefinition)Criteria.where((String)"isOrg").is((Object)true));
        List links = this.mongoTemplate.find(query0, ItemJiraDependency.class);
        HashMap<String, Boolean> linkItemByIdMap = new HashMap<String, Boolean>();
        linkItemByIdMap.put(currentItemId, true);
        if (PropertyValidator.isValid((Collection)links)) {
            for (ItemJiraDependency link2 : links) {
                if (PropertyValidator.isValid((Object)link2.getSourceBacklogItemId())) {
                    linkItemByIdMap.put(link2.getSourceBacklogItemId(), true);
                }
                if (!PropertyValidator.isValid((Object)link2.getTargetBacklogItemId())) continue;
                linkItemByIdMap.put(link2.getTargetBacklogItemId(), true);
            }
        }
        if (PropertyValidator.isValid((Collection)items)) {
            ArrayList<BacklogItem> finalitems = new ArrayList<BacklogItem>();
            for (BacklogItem item : items) {
                List parentLinks;
                BaseItemLink parentLink;
                boolean isItemValid = true;
                if (PropertyValidator.isValid((Object)item.getParentRelationMap()) && PropertyValidator.isValid((Collection)((Collection)item.getParentRelationMap().get(releaseTrainId))) && (parentLink = (BaseItemLink)(parentLinks = (List)item.getParentRelationMap().get(releaseTrainId)).stream().filter(link -> link.getBacklogItemId().toString().equals(currentItemId)).findFirst().orElse(null)) != null) {
                    isItemValid = false;
                }
                if (linkItemByIdMap.containsKey(item.getId())) {
                    isItemValid = false;
                }
                if (!isItemValid) continue;
                finalitems.add(item);
            }
            resultMap.put("items", finalitems);
        }
        return resultMap;
    }

    public Map<String, Object> updateItemJiraDependency(ItemJiraDependency payload) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String dependencyId = payload.getId();
        if (!PropertyValidator.isValid((Object)dependencyId)) {
            result.put("success", false);
            result.put("message", "dependencyId is required");
            return result;
        }
        ItemJiraDependency dep = this.itemJiraDependencyRepository.findById(dependencyId);
        if (!PropertyValidator.isValid((Object)dep)) {
            result.put("success", false);
            result.put("message", "Dependency not found");
            return result;
        }
        dep.setWfStatus(payload.getWfStatus());
        dep.setResponsible(payload.getResponsible());
        dep.setReporter(payload.getReporter());
        dep.setDescription(payload.getDescription());
        dep.setRichDescription(payload.getRichDescription());
        dep.setRaisedOn(payload.getRaisedOn());
        dep.setDueDate(payload.getDueDate());
        dep = (ItemJiraDependency)this.itemJiraDependencyRepository.save((Object)dep);
        result.put("success", true);
        result.put("dependency", dep);
        return result;
    }

    public Map<String, Object> deleteItemJiraDependency(Map<String, Object> params) throws Exception {
        List deps;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String dependencyId = (String)params.get("dependencyId");
        String almAccountId = (String)params.get("almAccountId");
        if (!PropertyValidator.isValid((Object)dependencyId)) {
            result.put("success", false);
            result.put("message", "dependencyId is required");
            return result;
        }
        ItemJiraDependency dependency = (ItemJiraDependency)this.mongoTemplate.findById((Object)dependencyId, ItemJiraDependency.class);
        if (!PropertyValidator.isValid((Object)dependency)) {
            result.put("success", false);
            result.put("message", "Dependency not found");
            return result;
        }
        ArrayList<String> dependencyIdsToDelete = new ArrayList<String>();
        dependencyIdsToDelete.add(dependencyId);
        ArrayList<String> backlogItemIdsToUpdate = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)dependency.getSourceBacklogItemId())) {
            backlogItemIdsToUpdate.add(dependency.getSourceBacklogItemId());
        }
        if (PropertyValidator.isValid((Object)dependency.getTargetBacklogItemId())) {
            backlogItemIdsToUpdate.add(dependency.getTargetBacklogItemId());
        }
        if (PropertyValidator.isValid(backlogItemIdsToUpdate)) {
            Query updateQuery = new Query();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            updateQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            updateQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(backlogItemIdsToUpdate));
            List items = this.mongoTemplate.find(updateQuery, BacklogItem.class);
            if (PropertyValidator.isValid((Collection)items)) {
                for (BacklogItem item : items) {
                    if (!PropertyValidator.isValid((Collection)item.getDependencyLinkIds())) continue;
                    item.getDependencyLinkIds().removeIf(functionId -> dependencyIdsToDelete.contains(functionId));
                }
                this.backlogItemRepository.save((Iterable)items);
            }
        }
        if (Boolean.TRUE.equals(dependency.getIsTFS())) {
            try {
                if (PropertyValidator.isValid((Object)dependency.getSourceTFSItem()) && PropertyValidator.isValid((Object)dependency.getTargetTFSItem())) {
                    String tfsSourceId = dependency.getSourceTFSItem().getTfsId();
                    String tfsTargetId = dependency.getTargetTFSItem().getTfsId();
                    AlmAccount almAccount = null;
                    if (PropertyValidator.isValid((Object)almAccountId)) {
                        almAccount = this.almAccountRepository.findById(almAccountId);
                    } else if (PropertyValidator.isValid((Object)dependency.getAlmId())) {
                        almAccount = this.almAccountRepository.findById(dependency.getAlmId());
                    }
                    if (PropertyValidator.isValid((Object)almAccount)) {
                        AlmAccount finalAlmAccount = almAccount;
                        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to remove relation in TFS while deleting dependency: " + StringUtils.getTraceString((Throwable)e));
            }
        }
        if (PropertyValidator.isValid(dependencyIdsToDelete) && PropertyValidator.isValid((Collection)(deps = this.itemJiraDependencyRepository.findByIdIn(dependencyIdsToDelete)))) {
            this.itemJiraDependencyRepository.delete((Iterable)deps);
        }
        result.put("success", true);
        result.put("deletedIds", dependencyIdsToDelete);
        return result;
    }

    public Map<String, Object> createItemJiraDependency(BacklogItem backlogItem) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> itemIdsToFetch = new ArrayList<String>();
        itemIdsToFetch.add(backlogItem.getId());
        AlmAccount almAccount = this.almAccountRepository.findById(backlogItem.getAlmAccountId());
        if (PropertyValidator.isValid((Collection)backlogItem.getDependencyLinks())) {
            for (ItemJiraDependency link : backlogItem.getDependencyLinks()) {
                link.setId(ObjectId.get().toString());
                link.setIsOrg(Boolean.valueOf(true));
                link.setIsTFS(Boolean.valueOf(true));
                link.setAlmId(almAccount.getId());
                if (link.getSourceBacklogItemId().equals(backlogItem.getId())) {
                    itemIdsToFetch.add(link.getTargetBacklogItemId());
                    continue;
                }
                itemIdsToFetch.add(link.getSourceBacklogItemId());
            }
        }
        List links = this.itemJiraDependencyRepository.save((Iterable)backlogItem.getDependencyLinks());
        result.put("links", links);
        List backlogItems = this.backlogItemRepository.findByIdIn(itemIdsToFetch);
        HashMap backlogItemMapById = new HashMap();
        backlogItems.forEach(item -> backlogItemMapById.put(item.getId(), item));
        for (ItemJiraDependency link : backlogItem.getDependencyLinks()) {
            BacklogItem targetItem;
            BacklogItem sourceItem = (BacklogItem)backlogItemMapById.get(link.getSourceBacklogItemId());
            if (sourceItem != null) {
                if (sourceItem.getDependencyLinkIds() == null) {
                    sourceItem.setDependencyLinkIds(new ArrayList());
                }
                sourceItem.getDependencyLinkIds().add(link.getId());
            }
            if ((targetItem = (BacklogItem)backlogItemMapById.get(link.getTargetBacklogItemId())) == null) continue;
            if (targetItem.getDependencyLinkIds() == null) {
                targetItem.setDependencyLinkIds(new ArrayList());
            }
            targetItem.getDependencyLinkIds().add(link.getId());
        }
        backlogItems = this.backlogItemRepository.save((Iterable)backlogItems);
        result.put("items", backlogItems);
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return result;
    }

    private Item addRelationLinkInTFS(BacklogItem actionItem, AlmAccount almAccount, HashMap<String, Object> fields, BacklogItem targetItem) {
        try {
            TFSResponse response = this.tfsUtils.updateItemInTFS(actionItem.getAlmItemId(), fields, almAccount);
            if (response.getStatusCode() == 200 || response.getStatusCode() == 201) {
                LOGGER.info("Successfully added relation link in TFS for item {}", (Object)actionItem.getAlmItemId());
            } else {
                LOGGER.error("Failed to add relation link in TFS for item {}. Status: {}, Response: {}", new Object[]{actionItem.getAlmItemId(), response.getStatusCode(), response.getContent()});
            }
        }
        catch (ViztrendJiraException vje) {
            LOGGER.error("Exception while adding relation link in TFS for item {}: {}", (Object)actionItem.getAlmItemId(), (Object)StringUtils.getTraceString((Throwable)vje));
            if (actionItem.getFields() == null) {
                actionItem.setFields(new HashMap());
            }
            actionItem.getFields().put("AlmErrorMesaage", vje.getMessage());
            actionItem.getFields().put("AlmSyncError", Boolean.TRUE);
            this.backlogItemRepository.save((Object)actionItem);
        }
        return null;
    }

    public Map<String, Object> loadAlmLinkTypes(String almAccountId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (!PropertyValidator.isValid((Object)almAccountId)) {
                result.put("success", false);
                result.put("error", "ALM Account ID is required");
                return result;
            }
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            if (!PropertyValidator.isValid((Object)almAccount)) {
                result.put("success", false);
                result.put("error", "ALM Account not found");
                return result;
            }
            if ("tfs".equalsIgnoreCase(almAccount.getType())) {
                HashMap linkTypesResult = this.tfsService.retrieveJiraIssueLinkTypesList(almAccount, false);
                if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
                    result.put("success", false);
                    result.put("tfsALMErrorCode", linkTypesResult.get("tfsALMErrorCode"));
                    result.put("tfsALMErrorMessage", linkTypesResult.get("tfsALMErrorMessage"));
                } else {
                    result.put("success", true);
                    result.put("linkTypes", linkTypesResult.get("linkTypes"));
                    result.put("almType", "tfs");
                }
            } else {
                result.put("success", false);
                result.put("error", "Link types loading is only supported for Azure DevOps (TFS) ALM type");
                result.put("almType", almAccount.getType());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading ALM link types: " + StringUtils.getTraceString((Throwable)e));
            result.put("success", false);
            result.put("error", "Error loading link types: " + e.getMessage());
        }
        return result;
    }

    public Map<String, Object> saveDependencyLinkTypes(Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String almAccountId = (String)params.get("almAccountId");
            List linkTypes = (List)params.get("linkTypes");
            if (!PropertyValidator.isValid((Object)almAccountId)) {
                result.put("success", false);
                result.put("error", "ALM Account ID is required");
                return result;
            }
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            if (!PropertyValidator.isValid((Object)almAccount)) {
                result.put("success", false);
                result.put("error", "ALM Account not found");
                return result;
            }
            if (!"tfs".equalsIgnoreCase(almAccount.getType())) {
                result.put("success", false);
                result.put("error", "Dependency link types are only supported for Azure DevOps (TFS) ALM type");
                result.put("almType", almAccount.getType());
                return result;
            }
            almAccount.setDependencyLinkTypes(linkTypes);
            this.almAccountRepository.save((Object)almAccount);
            result.put("success", true);
            result.put("message", "Dependency link types saved successfully");
            result.put("dependencyLinkTypes", linkTypes);
            LOGGER.info("Saved " + (linkTypes != null ? linkTypes.size() : 0) + " dependency link types for ALM account: " + almAccountId);
        }
        catch (Exception e) {
            LOGGER.error("Error saving dependency link types: " + StringUtils.getTraceString((Throwable)e));
            result.put("success", false);
            result.put("error", "Error saving dependency link types: " + e.getMessage());
        }
        return result;
    }

    public Map<String, Object> fetchDependenciesWithItemIds(Map<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        List itemIds = (List)params.get("itemIds");
        String almAccountId = (String)params.get("almAccountId");
        if (!PropertyValidator.isValid((Collection)itemIds) || itemIds.isEmpty()) {
            result.put("success", false);
            result.put("message", "itemIds is required and must not be empty");
            return result;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"sourceBacklogItemId").in((Collection)itemIds), Criteria.where((String)"targetBacklogItemId").in((Collection)itemIds)});
        query.addCriteria((CriteriaDefinition)criteria);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isOrg").is((Object)true));
        List links = this.mongoTemplate.find(query, ItemJiraDependency.class);
        result.put("success", true);
        result.put("links", links);
        if (PropertyValidator.isValid((Object)almAccountId)) {
            AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
            HashMap linkTypesResult = this.tfsService.retrieveJiraIssueLinkTypesList(almAccount, false);
            if (PropertyValidator.isValid(linkTypesResult.get("tfsALMErrorCode"))) {
                result.put("tfsALMErrorCode", linkTypesResult.get("tfsALMErrorCode"));
                result.put("tfsALMErrorMessage", linkTypesResult.get("tfsALMErrorMessage"));
            } else {
                result.put("tfsLinkTypes", linkTypesResult.get("linkTypes"));
            }
        }
        return result;
    }

    static /* synthetic */ TFSservice access$000(OrgDependencyServiceImpl x0) {
        return x0.tfsService;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ Item access$200(OrgDependencyServiceImpl x0, BacklogItem x1, AlmAccount x2, HashMap x3, BacklogItem x4) {
        return x0.addRelationLinkInTFS(x1, x2, x3, x4);
    }
}

