/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumWorkSpaceType;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.ModuleConfiguration;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.StatsExclusion;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.StrategicThemePriority;
import com.viztrend.safe.persistence.entity.StrategicThemesType;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatus;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatusRepository;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.projections.BaseItemProjectionBaseItemLinks;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.ModuleConfigurationRepository;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.ObjectiveServiceDAO;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatsExclusionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.StrategicThemePriorityRepository;
import com.viztrend.safe.persistence.repository.StrategicThemesTypeRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TimeSeriesRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceTypeRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.ChangeLogSyncServiceImpl;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.ObjectiveServiceImpl;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.TimeSeriesUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.Attachment;
import com.viztrend.safe.vos.ObjectiveServiceVO;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ObjectiveServiceImpl
implements ObjectiveService {
    private final ConcurrentHashMap<String, Boolean> themeExportCancellationFlags = new ConcurrentHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveServiceImpl.class);
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ModuleConfigurationRepository objectiveMenuPermissionsRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkSpaceTypeRepository workSpaceTypeRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private RTItemFetchService itemFetchService;
    @Autowired
    private ModuleConfigurationRepository moduleConfigurationRepository;
    @Autowired
    private ExportService exportService;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    private ObjectiveCustomViewRepository objectiveCustomViewRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private StatsExclusionRepository statsExclusionRepository;
    @Autowired
    private ObjectiveServiceDAO objectiveServiceDAO;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private StrategicThemesTypeRepository strategicThemesTypeRepository;
    @Autowired
    private StrategicThemePriorityRepository strategicThemePriorityRepository;
    @Autowired
    private TimeSeriesRepository timeSeriesRepository;
    @Autowired
    private TimeSeriesSyncStatusRepository timeSeriesSyncStatusRepository;
    @Autowired
    private ChangeLogSyncServiceImpl changeLogServiceImpl;
    @Autowired
    private ConversationRepository conversationRepository;

    public HashMap<String, Object> getObjectiveEditModalTemplate(String sessionId) throws Exception {
        List<Object> subFieldsForOverview;
        List<Fields> fields;
        int currentCode;
        Object field;
        int i;
        List existingFields;
        List existingSubFields;
        Fields timePeriodField;
        ArrayList<String> whereInClause = new ArrayList<String>();
        whereInClause.add(EnumKendis.GROUP_OBJECTIVE.getCode());
        whereInClause.add(EnumKendis.OBJECTIVE.getCode());
        whereInClause.add(EnumKendis.OBJECTIVE_KEY_RESULT.getCode());
        List itemTypes = this.itemTypeRepository.findByTitleIn(whereInClause);
        Session session = this.sessionRepository.findById(sessionId);
        ItemType objectiveItemType = new ItemType();
        ItemType objectiveGroupItemType = new ItemType();
        ItemType okrItemType = new ItemType();
        if (itemTypes.size() > 0) {
            for (ItemType it : itemTypes) {
                if (it.getTitle().equals(EnumKendis.OBJECTIVE.getCode())) {
                    objectiveItemType = it;
                    continue;
                }
                if (it.getTitle().equals(EnumKendis.GROUP_OBJECTIVE.getCode())) {
                    objectiveGroupItemType = it;
                    continue;
                }
                if (!it.getTitle().equals(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) continue;
                okrItemType = it;
            }
        }
        if (!PropertyValidator.isValid((Object)objectiveGroupItemType.getId())) {
            objectiveGroupItemType.setTitle(EnumKendis.GROUP_OBJECTIVE.getCode());
            objectiveGroupItemType.setNested(false);
            objectiveGroupItemType = (ItemType)this.itemTypeRepository.save((Object)objectiveGroupItemType);
        }
        if (!PropertyValidator.isValid((Object)objectiveItemType.getId())) {
            objectiveItemType.setTitle(EnumKendis.OBJECTIVE.getCode());
            objectiveItemType.setNested(false);
            objectiveItemType = (ItemType)this.itemTypeRepository.save((Object)objectiveItemType);
        }
        if (!PropertyValidator.isValid((Object)okrItemType.getId())) {
            okrItemType.setTitle(EnumKendis.OBJECTIVE_KEY_RESULT.getCode());
            okrItemType.setNested(false);
            okrItemType = (ItemType)this.itemTypeRepository.save((Object)okrItemType);
        }
        List okrWorkFlowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.OBJECTIVE_KEY_RESULT.getCode());
        List okrStatuses = new ArrayList();
        if (!PropertyValidator.isValid((Collection)okrWorkFlowList)) {
            okrWorkFlowList.add(this.createDefaultKeyResultsWorkflow());
        }
        okrStatuses = this.statusRepository.findByWorkFlow((WorkFlow)okrWorkFlowList.get(0));
        List objWorkFlowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.OBJECTIVE.getCode());
        List objStatuses = new ArrayList();
        if (!PropertyValidator.isValid((Collection)objWorkFlowList)) {
            objWorkFlowList.add(this.createDefaultObjectiveWorkflow());
        }
        objStatuses = this.statusRepository.findByWorkFlow((WorkFlow)objWorkFlowList.get(0));
        List objGrpWorkFlowList = this.workFlowRepository.findAllByWorkflowType(EnumKendis.GROUP_OBJECTIVE.getCode());
        List objGrpStatuses = new ArrayList();
        if (!PropertyValidator.isValid((Collection)objGrpWorkFlowList)) {
            objGrpWorkFlowList.add(this.createDefaultObjectiveGroupWorkflow());
        }
        objGrpStatuses = this.statusRepository.findByWorkFlow((WorkFlow)objGrpWorkFlowList.get(0));
        List fieldTemplates = this.fieldTemplateRepository.findByTypeIn(whereInClause);
        FieldTemplate objFT = new FieldTemplate();
        FieldTemplate objGroupFT = new FieldTemplate();
        FieldTemplate okrFT = new FieldTemplate();
        if (fieldTemplates.size() > 0) {
            for (FieldTemplate ft : fieldTemplates) {
                if (ft.getType().equals("Objective")) {
                    objFT = ft;
                    continue;
                }
                if (ft.getType().equals("group_objective")) {
                    objGroupFT = ft;
                    continue;
                }
                if (!ft.getType().equals("KR")) continue;
                okrFT = ft;
            }
        }
        if (PropertyValidator.isValid((Object)objFT.getId()) && !PropertyValidator.isValid((Object)(timePeriodField = (Fields)(existingSubFields = ((Fields)(existingFields = objFT.getConfiguredFields()).get(0)).getGroupFields()).stream().filter(f -> f.getTitle().equals("Time Period")).findAny().orElse(null)))) {
            int startDateIndex = -1;
            for (i = 0; i < existingSubFields.size(); ++i) {
                if (!"Start Date".equals(((Fields)existingSubFields.get(i)).getTitle())) continue;
                startDateIndex = i;
                break;
            }
            if (startDateIndex != -1) {
                existingSubFields.add(startDateIndex, new Fields("4", "Time Period", "time-period", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
                for (i = startDateIndex + 1; i < existingSubFields.size(); ++i) {
                    field = (Fields)existingSubFields.get(i);
                    currentCode = Integer.parseInt(field.getCode());
                    field.setCode(String.valueOf(currentCode + 1));
                }
            }
            existingSubFields = this.fieldsRepository.save((Iterable)existingSubFields);
            ((Fields)existingFields.get(0)).setGroupFields(existingSubFields);
            existingFields = this.fieldsRepository.save((Iterable)existingFields);
            objFT.setConfiguredFields(existingFields);
            objFT.setType("Objective");
            objFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)objFT);
        }
        if (!PropertyValidator.isValid((Object)objGroupFT.getId())) {
            fields = new ArrayList<Fields>();
            fields.add(new Fields("1", "", "colorpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("2", "Title", "textfield", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("3", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("4", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            fields.add(new Fields("5", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            fields = this.fieldsRepository.save(fields);
            objGroupFT.setConfiguredFields(fields);
            objGroupFT.setType("group_objective");
            objGroupFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)objGroupFT);
        }
        if (!PropertyValidator.isValid((Object)objFT.getId())) {
            fields = new ArrayList();
            ArrayList<String> typeOptions = new ArrayList<String>();
            typeOptions.add("Committed");
            typeOptions.add("Uncommitted");
            fields.add(new Fields("1", "Overview", "", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, null));
            fields.add(new Fields("3", "Business Value", "", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, null));
            fields = this.fieldsRepository.save(fields);
            subFieldsForOverview = new ArrayList<Fields>();
            subFieldsForOverview.add(new Fields("1", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("2", "Type", "singleselect", typeOptions, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("3", "Objective Groups", "teams-and-groups", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("4", "Time Period", "time-period", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("5", "Start Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 3, null));
            subFieldsForOverview.add(new Fields("6", "End Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 3, null));
            subFieldsForOverview.add(new Fields("7", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("8", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 7, null));
            subFieldsForOverview = this.fieldsRepository.save(subFieldsForOverview);
            List<Object> subFieldsForBusinessValue = new ArrayList<Fields>();
            subFieldsForBusinessValue.add(new Fields("1", "BV Plan", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 1, null));
            subFieldsForBusinessValue.add(new Fields("2", "BV Actual", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 1, null));
            subFieldsForBusinessValue = this.fieldsRepository.save(subFieldsForBusinessValue);
            ((Fields)fields.get(0)).setGroupFields(subFieldsForOverview);
            ((Fields)fields.get(1)).setGroupFields(subFieldsForBusinessValue);
            fields = this.fieldsRepository.save(fields);
            objFT.setConfiguredFields(fields);
            objFT.setType("Objective");
            objFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)objFT);
        }
        if (PropertyValidator.isValid((Object)okrFT.getId()) && !PropertyValidator.isValid((Object)(timePeriodField = (Fields)(existingSubFields = ((Fields)(existingFields = okrFT.getConfiguredFields()).get(0)).getGroupFields()).stream().filter(f -> f.getTitle().equals("Time Period")).findAny().orElse(null)))) {
            int startDateIndex = -1;
            for (i = 0; i < existingSubFields.size(); ++i) {
                if (!"Start Date".equals(((Fields)existingSubFields.get(i)).getTitle())) continue;
                startDateIndex = i;
                break;
            }
            if (startDateIndex != -1) {
                existingSubFields.add(startDateIndex, new Fields("2", "Time Period", "time-period", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
                for (i = startDateIndex + 1; i < existingSubFields.size(); ++i) {
                    field = (Fields)existingSubFields.get(i);
                    currentCode = Integer.parseInt(field.getCode());
                    field.setCode(String.valueOf(currentCode + 1));
                }
            }
            existingSubFields = this.fieldsRepository.save((Iterable)existingSubFields);
            ((Fields)existingFields.get(0)).setGroupFields(existingSubFields);
            existingFields = this.fieldsRepository.save((Iterable)existingFields);
            okrFT.setConfiguredFields(existingFields);
            okrFT.setType("Objective");
            okrFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)okrFT);
        }
        if (!PropertyValidator.isValid((Object)okrFT.getId())) {
            ArrayList<String> progressOptions = new ArrayList<String>();
            progressOptions.add("Target");
            progressOptions.add("By Items");
            progressOptions.add("By Objectives");
            List fields2 = new ArrayList<Fields>();
            fields2.add(new Fields("1", "Overview", "", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, null));
            fields2.add(new Fields("2", "Progress Criteria", "", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, null));
            fields2.add(new Fields("3", "Business Value", "", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, null));
            fields2 = this.fieldsRepository.save(fields2);
            subFieldsForOverview = new ArrayList();
            subFieldsForOverview.add(new Fields("1", "Status", "status", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("2", "Time Period", "time-period", new ArrayList(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("3", "Start Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 3, null));
            subFieldsForOverview.add(new Fields("4", "End Date", "datepicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 3, null));
            subFieldsForOverview.add(new Fields("5", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            subFieldsForOverview.add(new Fields("6", "Description", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 7, null));
            subFieldsForOverview = this.fieldsRepository.save(subFieldsForOverview);
            List<Object> subFieldsForProgressCriteria = new ArrayList<Fields>();
            subFieldsForProgressCriteria.add(new Fields("1", "Progress Criteria", "singleselect", progressOptions, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, null, 4, null));
            subFieldsForProgressCriteria.add(new Fields("5", "Start", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, "Target", 4, null));
            subFieldsForProgressCriteria.add(new Fields("2", "Target Value", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, "Target", 4, null));
            subFieldsForProgressCriteria.add(new Fields("3", "Unit", "textfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, "Target", 4, null));
            subFieldsForProgressCriteria.add(new Fields("4", "Progress", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, "Target", 4, null));
            subFieldsForProgressCriteria = this.fieldsRepository.save(subFieldsForProgressCriteria);
            List<Object> subFieldsForBusinessValue = new ArrayList<Fields>();
            subFieldsForBusinessValue.add(new Fields("1", "BV Plan", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 1, null));
            subFieldsForBusinessValue.add(new Fields("2", "BV Actual", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 1, null));
            subFieldsForBusinessValue = this.fieldsRepository.save(subFieldsForBusinessValue);
            ((Fields)fields2.get(0)).setGroupFields(subFieldsForOverview);
            ((Fields)fields2.get(1)).setGroupFields(subFieldsForProgressCriteria);
            ((Fields)fields2.get(2)).setGroupFields(subFieldsForBusinessValue);
            fields2 = this.fieldsRepository.save(fields2);
            okrFT.setConfiguredFields(fields2);
            okrFT.setType("KR");
            okrFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)okrFT);
        }
        ArrayList<ItemType> itemTypeList = new ArrayList<ItemType>();
        itemTypeList.add(objectiveItemType);
        itemTypeList.add(objectiveGroupItemType);
        itemTypeList.add(okrItemType);
        List itemTypeSchemeList = this.itemTypeSchemeRepository.findByItemTypeIn(itemTypeList);
        ItemTypeScheme objectiveItemTypeScheme = new ItemTypeScheme();
        ItemTypeScheme objectiveGroupItemTypeScheme = new ItemTypeScheme();
        ItemTypeScheme okrItemTypeScheme = new ItemTypeScheme();
        if (itemTypeSchemeList.size() > 0) {
            for (ItemTypeScheme itemTypeScheme : itemTypeSchemeList) {
                if (itemTypeScheme.getItemType().equals((Object)objectiveItemType)) {
                    objectiveItemTypeScheme = itemTypeScheme;
                    continue;
                }
                if (itemTypeScheme.getItemType().equals((Object)objectiveGroupItemType)) {
                    objectiveGroupItemTypeScheme = itemTypeScheme;
                    continue;
                }
                if (!itemTypeScheme.getItemType().equals((Object)okrItemType)) continue;
                okrItemTypeScheme = itemTypeScheme;
            }
        }
        if (!PropertyValidator.isValid((Object)objectiveItemTypeScheme.getId())) {
            objectiveItemTypeScheme.setItemType(objectiveItemType);
            objectiveItemTypeScheme.setFieldsTemplate(objFT);
            if (objWorkFlowList.size() > 0) {
                objectiveItemTypeScheme.setWorkflow((WorkFlow)objWorkFlowList.get(0));
            }
            objectiveItemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)objectiveItemTypeScheme);
        }
        if (!PropertyValidator.isValid((Object)objectiveGroupItemTypeScheme.getId())) {
            objectiveGroupItemTypeScheme.setItemType(objectiveGroupItemType);
            if (objGrpWorkFlowList.size() > 0) {
                objectiveGroupItemTypeScheme.setWorkflow((WorkFlow)objGrpWorkFlowList.get(0));
            }
            objectiveGroupItemTypeScheme.setFieldsTemplate(objGroupFT);
            objectiveGroupItemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)objectiveGroupItemTypeScheme);
        }
        if (!PropertyValidator.isValid((Object)okrItemTypeScheme.getId())) {
            okrItemTypeScheme.setItemType(okrItemType);
            if (okrWorkFlowList.size() > 0) {
                okrItemTypeScheme.setWorkflow((WorkFlow)okrWorkFlowList.get(0));
            }
            okrItemTypeScheme.setFieldsTemplate(okrFT);
            okrItemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)okrItemTypeScheme);
        } else if (PropertyValidator.isValid((Object)session) && PropertyValidator.isValid((Object)okrItemTypeScheme.getFieldsTemplate())) {
            for (Fields field2 : okrItemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
                if (!field2.getTitle().equals("Progress Criteria")) continue;
                for (Fields groupedField : field2.getGroupFields()) {
                    if (!groupedField.getTitle().equals("Progress Criteria")) continue;
                    List options = groupedField.getOptions();
                    options.remove(2);
                    groupedField.setOptions(options);
                }
            }
        }
        HashMap<String, Object> jsonResponse = new HashMap<String, Object>();
        HashMap objResponse = new HashMap();
        HashMap<String, Object> objGroupResponse = new HashMap<String, Object>();
        HashMap okrResponse = new HashMap();
        objResponse.put("statuses", objStatuses);
        objResponse.put("scheme", objectiveItemTypeScheme);
        objGroupResponse.put("scheme", objectiveGroupItemTypeScheme);
        objGroupResponse.put("statuses", objGrpStatuses);
        okrResponse.put("statuses", okrStatuses);
        okrResponse.put("scheme", okrItemTypeScheme);
        jsonResponse.put("objectiveTemplate", objResponse);
        jsonResponse.put("groupTemplate", objGroupResponse);
        jsonResponse.put("okrTemplate", okrResponse);
        ModuleConfiguration objectiveMenuPermission = this.moduleConfigurationRepository.findOneBySessionId(sessionId);
        if (!PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            objectiveMenuPermission = new ModuleConfiguration();
            if (!PropertyValidator.isValid((Object)sessionId)) {
                sessionId = "-1";
            }
            if (sessionId.equals("-1") || !PropertyValidator.isValid((Object)session)) {
                objectiveMenuPermission.setOkrEnabled(true);
                objectiveMenuPermission.setOkrBVAchievementEnabled(false);
                objectiveMenuPermission.setBVAchievementEnabled(false);
            } else {
                objectiveMenuPermission.setOkrEnabled(false);
                objectiveMenuPermission.setOkrBVAchievementEnabled(true);
                objectiveMenuPermission.setBVAchievementEnabled(true);
            }
            objectiveMenuPermission.setStatusEnabled(true);
            objectiveMenuPermission.setProgressEnabled(true);
            objectiveMenuPermission.setUnCommittedEnabled(true);
            objectiveMenuPermission.setSessionId(sessionId);
            this.moduleConfigurationRepository.save((Object)objectiveMenuPermission);
        }
        jsonResponse.put("objectiveMenuOptions", objectiveMenuPermission);
        return jsonResponse;
    }

    public HashMap<ModuleConfiguration, Object> updateMenuPermissionBySessionId(HashMap<String, String> body) throws Exception {
        Boolean status;
        HashMap<ModuleConfiguration, Object> jsonResponse = new HashMap<ModuleConfiguration, Object>();
        ModuleConfiguration objectiveMenuPermission = new ModuleConfiguration();
        if (PropertyValidator.isValid((Object)body.get("sessionId"))) {
            objectiveMenuPermission.setSessionId(body.get("sessionId"));
        }
        objectiveMenuPermission = this.moduleConfigurationRepository.findOneBySessionId(objectiveMenuPermission.getSessionId());
        AuditLog auditLogEntry = new AuditLog();
        auditLogEntry.setSessionId(objectiveMenuPermission.getSessionId());
        if (PropertyValidator.isValid((Object)body.get("isBVAchievementEnabled"))) {
            Boolean bvAchievement = Boolean.parseBoolean(body.get("isBVAchievementEnabled"));
            objectiveMenuPermission.setBVAchievementEnabled(bvAchievement.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Objective BV Achievement " + (bvAchievement != false ? "enabled" : "disabled"));
        }
        if (PropertyValidator.isValid((Object)body.get("isUnCommittedEnabled"))) {
            Boolean uncommitted = Boolean.parseBoolean(body.get("isUnCommittedEnabled"));
            objectiveMenuPermission.setUnCommittedEnabled(uncommitted.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Uncommitted Objectives " + (uncommitted != false ? "enabled" : "disabled"));
        }
        if (PropertyValidator.isValid((Object)body.get("isStatusEnabled"))) {
            status = Boolean.parseBoolean(body.get("isStatusEnabled"));
            objectiveMenuPermission.setStatusEnabled(status.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Objective Status " + (status != false ? "enabled" : "disabled"));
        }
        if (PropertyValidator.isValid((Object)body.get("isProgressEnabled"))) {
            Boolean progress = Boolean.parseBoolean(body.get("isProgressEnabled"));
            objectiveMenuPermission.setProgressEnabled(progress.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Objective Progress " + (progress != false ? "enabled" : "disabled"));
        }
        if (PropertyValidator.isValid((Object)body.get("isOkrEnabled"))) {
            Boolean okrEnabled = Boolean.parseBoolean(body.get("isOkrEnabled"));
            objectiveMenuPermission.setOkrEnabled(okrEnabled.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Key Results " + (okrEnabled != false ? "enabled" : "disabled"));
        }
        if (PropertyValidator.isValid((Object)body.get("isOkrBVAchievementEnabled"))) {
            Boolean okrBvAchievement = Boolean.parseBoolean(body.get("isOkrBVAchievementEnabled"));
            objectiveMenuPermission.setOkrBVAchievementEnabled(okrBvAchievement.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Key Results BV Achievement " + (okrBvAchievement != false ? "enabled" : "disabled"));
        }
        if (PropertyValidator.isValid((Object)body.get("isOkrStatusEnabled"))) {
            status = Boolean.parseBoolean(body.get("isOkrStatusEnabled"));
            objectiveMenuPermission.setOkrStatusEnabled(status.booleanValue());
            auditLogEntry.setEventType("OBJECTIVE_SETTINGS_UPDATE");
            auditLogEntry.setEventText("Key Results Status " + (status != false ? "enabled" : "disabled"));
        }
        this.moduleConfigurationRepository.save((Object)objectiveMenuPermission);
        this.auditLogRepository.save((Object)auditLogEntry);
        jsonResponse.put(objectiveMenuPermission, "success");
        return jsonResponse;
    }

    public List<Object> fetchObjectivesForApi(List<Session> sessions, Map<String, Team> teams, Map<String, Container> sprints, Map<String, String[]> params) throws Exception {
        String completionType = null;
        if (PropertyValidator.isValid((String[])params.get("completionType")) && params.get("completionType").length > 0) {
            completionType = params.get("completionType")[0];
        }
        ArrayList groups = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", EnumKendis.LINKED_ITEM_STATUS.name());
        map.put("2", EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name());
        map.put("3", EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name());
        map.put("4", EnumKendis.TEAM_STORY_STATUS.name());
        map.put("5", EnumKendis.TEAM_STORY_ESTIMATE.name());
        map.put("6", EnumKendis.OBJ_KR_WEIGHTS_FORMULA.name());
        ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessions.get(0).getId());
        ArrayList reportData = new ArrayList();
        try {
            if (PropertyValidator.isValid((Object)completionType)) {
                Integer type = new Integer(completionType);
                completionType = (String)map.get(String.valueOf(type));
            }
        }
        catch (Exception e) {
            completionType = null;
        }
        Boolean isOkrEnabled = false;
        boolean isAchievement = false;
        if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
            isAchievement = Boolean.TRUE.equals(objectiveMenuPermission.getBVAchievementEnabled());
        }
        if (!PropertyValidator.isValid((Object)completionType) && !isOkrEnabled.booleanValue()) {
            completionType = (String)map.get("2");
        }
        if (EnumKendis.OBJ_KR_WEIGHTS_FORMULA.name().equals(completionType)) {
            completionType = isOkrEnabled != false ? null : (String)map.get("2");
        }
        HashMap groupCompletions = new HashMap();
        ArrayList groupIds = new ArrayList();
        try {
            this.processOKRs(2, reportData, sessions.get(0).getId(), completionType, teams, sprints, groupCompletions, groupIds, objectiveMenuPermission);
            HashMap<String, Integer> location = new HashMap<String, Integer>();
            for (HashMap objective : reportData) {
                String groupId = (String)objective.get("groupId");
                if (location.get(groupId) == null) {
                    HashMap<String, Object> group = new HashMap<String, Object>();
                    group.put("id", groupId);
                    group.put("title", objective.get("groupName"));
                    group.put("type", objective.get("groupType"));
                    group.put("status", objective.get("group_status"));
                    Double bv = (Double)groupCompletions.get(groupId + "_bvPlan");
                    Double actual = (Double)groupCompletions.get(groupId + "_bvActual");
                    if (bv == null) {
                        bv = 0.0;
                    }
                    if (actual == null) {
                        actual = 0.0;
                    }
                    group.put("bvPlan", bv);
                    group.put("bvActual", actual);
                    if (isAchievement) {
                        group.put("achievement", KendisUtils.getPercentage((Double)actual, (Double)bv));
                    }
                    group.put("completion", groupCompletions.get(groupId));
                    group.put("objectives", new ArrayList());
                    groups.add(group);
                    location.put(groupId, groups.size() - 1);
                }
                Integer index = (Integer)location.get(groupId);
                ((List)((Map)groups.get(index)).get("objectives")).add(objective);
                objective.remove("groupId");
                objective.remove("groupName");
                objective.remove("groupType");
                objective.remove("group_status");
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return (List)mapper.convertValue(groups, List.class);
    }

    private List<Map> getObjectiveLinkedItems(BaseItem objective, Map<String, Object> excludedItems, Map<String, Team> teams, Map<String, Container> sprints) {
        ArrayList<Map> links = new ArrayList<Map>();
        if (PropertyValidator.isValid((Collection)objective.getLinkedItems())) {
            for (Item item : objective.getLinkedItems()) {
                if (!this.verifyItemsToExclude(item, excludedItems).booleanValue()) continue;
                Map o = item.toMap(teams, sprints);
                Double sp = 0.0;
                if (item.getSubItems() != null) {
                    for (Item sub : item.getSubItems()) {
                        ArrayList<Map> list = (ArrayList<Map>)o.get("subItems");
                        if (list == null) {
                            list = new ArrayList<Map>();
                            o.put("subItems", list);
                        }
                        list.add(sub.toMap(teams, sprints));
                        if (sub.getStoryPoints() == null) continue;
                        sp = sp + sub.getStoryPoints();
                    }
                }
                o.put("storyPoints", sp);
                o.put("completion", KendisUtils.getPercentage((Double)((Double)item.getLastUpdatedValue("subDone")), (Double)((Double)item.getLastUpdatedValue("subTotal"))));
                links.add(o);
            }
        }
        return links;
    }

    private String getObjectiveLinkedItemIds(BaseItem objective, Map<String, Object> excludedItems) {
        ArrayList<String> linkedItemIds = new ArrayList<String>();
        String linkedItemIdsString = "";
        if (PropertyValidator.isValid((Collection)objective.getLinkedItems())) {
            for (Item item : objective.getLinkedItems()) {
                if (!this.verifyItemsToExclude(item, excludedItems).booleanValue()) continue;
                if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                    linkedItemIds.add(item.getJiraKey());
                    continue;
                }
                if (PropertyValidator.isValid((Object)item.getTfsId())) {
                    linkedItemIds.add(item.getTfsId());
                    continue;
                }
                linkedItemIds.add(item.getTitle());
            }
            linkedItemIdsString = String.join((CharSequence)",", linkedItemIds);
        }
        return linkedItemIdsString;
    }

    public void processOKRs(int exportType, List<HashMap<String, Object>> reportData, String sessionId, String completionCriteria, Map<String, Team> teams, Map<String, Container> sprints, HashMap<String, Double> groupCompletions, List<Object> groupIds, ModuleConfiguration objectiveMenuPermission) {
        ArrayList<String> okrLinkedObjectivesIdsMap = new ArrayList<String>();
        List okrWeightsList = new ArrayList();
        List groupWeightsList = new ArrayList();
        List objectiveGroups = this.getObjectivesList(sessionId);
        boolean isTeamParam = true;
        boolean isJSON = exportType == 2;
        String[] krCols = null;
        String[] oCols = null;
        if (isJSON) {
            krCols = new String[]{"id", "title", "status", "description", "bvPlan", "bvActual"};
            oCols = new String[]{"id", "title", "type", "status", "description", "bvPlan", "bvActual", "groupId", "groupName", "groupType", "group_status"};
        } else {
            krCols = new String[]{"keyResultId", "keyResult", "okrStatus", "okrDescription", "okrBvPlanned", "okrBvActual"};
            oCols = new String[]{"objectiveId", "objectiveName", "objectiveType", "objectiveStatus", "objectiveDescription", "bvPlan", "bvActual", "groupId", "groupName", "groupType"};
        }
        for (BaseItem group : objectiveGroups) {
            groupIds.add(group.getId());
            if (!PropertyValidator.isValid((Collection)group.getBaseItemList())) continue;
            for (BaseItem obj : group.getBaseItemList()) {
                if (!PropertyValidator.isValid((Collection)obj.getBaseItemList())) continue;
                for (BaseItem okr : obj.getBaseItemList()) {
                    if (!PropertyValidator.isValid((Collection)okr.getBaseItemLinks())) continue;
                    for (BaseItemLink link : okr.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
                        okrLinkedObjectivesIdsMap.add(link.getBaseItemId());
                    }
                }
            }
        }
        List okrProgressCriteriaGroupFields = this.getOkrProgressCriteriaGroupFields();
        ArrayList<String> teamIds = new ArrayList<String>();
        if (teams == null) {
            isTeamParam = false;
            teams = new HashMap<String, Team>();
        }
        if (PropertyValidator.isValid((Object)completionCriteria) && (completionCriteria.equals(EnumKendis.TEAM_STORY_STATUS.name()) || completionCriteria.equals(EnumKendis.TEAM_STORY_ESTIMATE.name())) || !PropertyValidator.isValid((Object)completionCriteria)) {
            for (Object group : objectiveGroups) {
                List grpBaseItemLinks = group.getBaseItemLinks();
                if (grpBaseItemLinks.size() <= 0 || !PropertyValidator.isValid((Object)((BaseItemLink)grpBaseItemLinks.get(0)).getTeamId()) || teams.get(((BaseItemLink)grpBaseItemLinks.get(0)).getTeamId()) != null) continue;
                teamIds.add(((BaseItemLink)grpBaseItemLinks.get(0)).getTeamId());
            }
        }
        if (PropertyValidator.isValid(teamIds)) {
            List objectiveTeams = new ArrayList();
            objectiveTeams = this.teamRepository.findByIdIn(teamIds);
            for (Team team : objectiveTeams) {
                teams.put(team.getId(), team);
            }
        }
        StatsExclusion statsExclusion = this.statsExclusionRepository.findBySessionIdAndViewType(sessionId, "Objectives");
        Map excludedItems = null;
        if (PropertyValidator.isValid((Object)statsExclusion)) {
            excludedItems = statsExclusion.getExcludedItems();
        }
        for (BaseItem group : objectiveGroups) {
            if (!PropertyValidator.isValid((Collection)group.getBaseItemList())) continue;
            if (!objectiveMenuPermission.getUnCommittedEnabled()) {
                List objList = group.getBaseItemList();
                HashMap<String, Boolean> uncommittedObjById = new HashMap<String, Boolean>();
                for (int i = objList.size() - 1; i >= 0; --i) {
                    if (!((BaseItem)objList.get(i)).getType().equals("Objective-Uncommitted")) continue;
                    uncommittedObjById.put(((BaseItem)objList.get(i)).getId(), true);
                    objList.remove(i);
                }
                if (!uncommittedObjById.isEmpty()) {
                    group.setBaseItemList(objList);
                    List links = group.getBaseItemLinks();
                    for (int i = links.size() - 1; i >= 0; --i) {
                        if (!uncommittedObjById.containsKey(((BaseItemLink)links.get(i)).getBaseItemId())) continue;
                        links.remove(i);
                    }
                    group.setBaseItemLinks(links);
                }
            }
            groupWeightsList.clear();
            groupWeightsList = this.getWeightsListOfObjectiveOrGroup(group, Boolean.valueOf(false));
            Double valueOfXForGroup = this.calculateValueOfSingleX(groupWeightsList);
            HashMap calculationCounts = new HashMap();
            Double groupCompletion = 0.0;
            Team objTeam = null;
            if (PropertyValidator.isValid((Object)((BaseItemLink)group.getBaseItemLinks().get(0)).getTeamId())) {
                objTeam = teams.get(((BaseItemLink)group.getBaseItemLinks().get(0)).getTeamId());
            }
            for (BaseItem _obj : group.getBaseItemList()) {
                HashMap groupTempMap = new HashMap();
                for (HashMap groupWeightMap : groupWeightsList) {
                    if (!((String)groupWeightMap.get("baseItemId")).equals(_obj.getId())) continue;
                    groupTempMap = groupWeightMap;
                }
                okrWeightsList.clear();
                Boolean isItemLinked = PropertyValidator.isValid((Collection)_obj.getLinkedItems());
                okrWeightsList = this.getWeightsListOfObjectiveOrGroup(_obj, isItemLinked);
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put(oCols[7], group.getId());
                info.put(oCols[8], group.getTitle());
                info.put("sequence", group.getSequence());
                Double completion = 0.0;
                info.put(oCols[0], _obj.getKey());
                info.put(oCols[1], _obj.getTitle());
                info.put(oCols[2], _obj.getType());
                if (PropertyValidator.isValid((Object)_obj.getStatus())) {
                    if (isJSON) {
                        info.put(oCols[3], _obj.getStatus().toSimpleObject());
                    } else {
                        info.put(oCols[3], _obj.getStatus().getTitle());
                    }
                }
                if (PropertyValidator.isValid((Object)_obj.getDescription())) {
                    info.put(oCols[4], KendisUtils.parseRichText((String)_obj.getDescription()));
                }
                info.put(oCols[5], _obj.getBvPlan());
                info.put(oCols[6], _obj.getBvActual());
                if (isJSON && oCols.length > 10) {
                    if (PropertyValidator.isValid((Object)group.getStatus())) {
                        info.put(oCols[10], group.getStatus().toSimpleObject());
                    }
                    if (groupCompletions.get(group.getId() + "_" + oCols[5]) == null) {
                        groupCompletions.put(group.getId() + "_" + oCols[5], 0.0);
                    }
                    if (groupCompletions.get(group.getId() + "_" + oCols[6]) == null) {
                        groupCompletions.put(group.getId() + "_" + oCols[6], 0.0);
                    }
                    if ("Objective-Committed".equals(_obj.getType())) {
                        groupCompletions.put(group.getId() + "_" + oCols[5], groupCompletions.get(group.getId() + "_" + oCols[5]) + _obj.getBvPlan());
                    }
                    groupCompletions.put(group.getId() + "_" + oCols[6], groupCompletions.get(group.getId() + "_" + oCols[6]) + _obj.getBvActual());
                }
                if (PropertyValidator.isValid((Collection)group.getBaseItemLinks()) && group.getBaseItemLinks().size() > 0) {
                    if (((BaseItemLink)group.getBaseItemLinks().get(0)).getTeamId().equals("0")) {
                        info.put(oCols[9], "CustomGroup");
                    } else {
                        info.put(oCols[9], "TeamGroup");
                    }
                }
                Double objCompletion = 0.0;
                Double objLinkedOkrCompletion = 0.0;
                Double valueOfX = 1.0;
                HashMap calculationData = this.calculateCompletion(_obj, isJSON, completionCriteria, objTeam, teams, sprints, excludedItems);
                List linkedItems = (List)calculationData.remove("linkedItems");
                if (PropertyValidator.isValid((Object)completionCriteria)) {
                    objCompletion = (Double)calculationData.get("completion");
                    for (Map.Entry set : calculationData.entrySet()) {
                        if (((String)set.getKey()).equals("completion")) continue;
                        Double sum = calculationCounts.getOrDefault(set.getKey(), 0.0) + (Double)set.getValue();
                        calculationCounts.put(set.getKey(), sum);
                    }
                } else {
                    valueOfX = this.calculateValueOfSingleX(okrWeightsList);
                    objCompletion = (Double)calculationData.get("completion") * (_obj.getLinkedCardWeights() * valueOfX / 100.0);
                }
                if (isJSON) {
                    info.put("linkedItems", linkedItems);
                } else {
                    info.put("linkedItems", this.getObjectiveLinkedItemIds(_obj, excludedItems));
                }
                if (PropertyValidator.isValid((Collection)_obj.getBaseItemList())) {
                    Map<String, HashMap> okrInfo = null;
                    ArrayList<Map<String, HashMap>> okrs = null;
                    if (isJSON) {
                        okrs = new ArrayList<Map<String, HashMap>>();
                        info.put("linkedOkrs", okrs);
                    } else {
                        okrInfo = info;
                    }
                    for (BaseItem okr : _obj.getBaseItemList()) {
                        HashMap okcCals = this.calculateCompletion(okr, isJSON, null, null, teams, sprints, excludedItems);
                        Double okrCompletion = this.calculateOkrCompletion(okr, isJSON, (Double)okcCals.get("completion"), okrWeightsList, excludedItems);
                        HashMap tempMap = new HashMap();
                        for (HashMap okrWeightMap : okrWeightsList) {
                            if (!((String)okrWeightMap.get("baseItemId")).equals(okr.getId())) continue;
                            tempMap = okrWeightMap;
                        }
                        if (PropertyValidator.isValid(tempMap)) {
                            objLinkedOkrCompletion = objLinkedOkrCompletion + okrCompletion * (Double.parseDouble((String)tempMap.get("weightage")) * valueOfX / 100.0);
                        }
                        if (!isJSON) continue;
                        okrInfo = new HashMap();
                        okrs.add(okrInfo);
                        if (okr.getLastUpdate() != null) {
                            okrInfo.putAll(okr.getLastUpdate());
                        }
                        okrInfo.put("linkedItems", (HashMap)okcCals.get("linkedItems"));
                    }
                    for (int i = 0; i < _obj.getBaseItemList().size(); ++i) {
                        BaseItem okr;
                        okr = (BaseItem)_obj.getBaseItemList().get(i);
                        if (isJSON) {
                            okrInfo = (Map)okrs.get(i);
                        }
                        okrInfo.put(krCols[0], (HashMap)((Object)okr.getKey()));
                        okrInfo.put(krCols[1], (HashMap)((Object)okr.getTitle()));
                        if (PropertyValidator.isValid((Object)okr.getStatus())) {
                            if (isJSON) {
                                okrInfo.put(krCols[2], okr.getStatus().toSimpleObject());
                            } else {
                                okrInfo.put(krCols[2], (HashMap)((Object)okr.getStatus().getTitle()));
                            }
                        }
                        if (PropertyValidator.isValid((Object)okr.getDescription())) {
                            okrInfo.put(krCols[3], (HashMap)((Object)KendisUtils.parseRichText((String)okr.getDescription())));
                        } else {
                            okrInfo.put(krCols[3], (HashMap)((Object)""));
                        }
                        if (PropertyValidator.isValid((Object)okr.getBvPlan())) {
                            okrInfo.put(krCols[4], (HashMap)((Object)okr.getBvPlan()));
                        } else {
                            okrInfo.put(krCols[4], (HashMap)((Object)Double.valueOf(0.0)));
                        }
                        if (PropertyValidator.isValid((Object)okr.getBvActual())) {
                            okrInfo.put(krCols[5], (HashMap)((Object)okr.getBvActual()));
                        } else {
                            okrInfo.put(krCols[5], (HashMap)((Object)Double.valueOf(0.0)));
                        }
                        boolean use_completion = false;
                        if (isJSON) {
                            use_completion = i == _obj.getBaseItemList().size() - 1;
                        } else {
                            info.put("keyResultLinkCardsId", this.getObjectiveLinkedItemIds(okr, excludedItems));
                            use_completion = true;
                            if (PropertyValidator.isValid((Object)okr.getFields())) {
                                for (Fields groupField : okrProgressCriteriaGroupFields) {
                                    if (groupField.getTitle().equals("Target Value")) {
                                        if (PropertyValidator.isValid(okr.getFields().get(groupField.getId())) && PropertyValidator.isValid(okr.getFields().get(groupField.getId()))) {
                                            okrInfo.put("targetValue", (HashMap)okr.getFields().get(groupField.getId()));
                                            continue;
                                        }
                                        okrInfo.put("targetValue", (HashMap)((Object)""));
                                        continue;
                                    }
                                    if (!groupField.getTitle().equals("Progress")) continue;
                                    if (PropertyValidator.isValid(okr.getFields().get(groupField.getId())) && PropertyValidator.isValid(okr.getFields().get(groupField.getId()))) {
                                        okrInfo.put("progress", (HashMap)okr.getFields().get(groupField.getId()));
                                        continue;
                                    }
                                    okrInfo.put("progress", (HashMap)((Object)""));
                                }
                            } else {
                                okrInfo.put("targetValue", (HashMap)((Object)""));
                                okrInfo.put("progress", (HashMap)((Object)""));
                            }
                        }
                        if (!use_completion) continue;
                        completion = !PropertyValidator.isValid((Object)completionCriteria) ? Double.valueOf(objCompletion + objLinkedOkrCompletion) : objCompletion;
                        completion = (double)Math.round(completion * 100.0) / 100.0;
                        info.put("completion", completion);
                        reportData.add(new HashMap(info));
                    }
                } else {
                    completion = objCompletion;
                    completion = (double)Math.round(completion * 100.0) / 100.0;
                    info.put("completion", completion);
                    reportData.add(info);
                }
                if (PropertyValidator.isValid((Object)completionCriteria)) continue;
                groupCompletion = groupCompletion + completion * (Double.parseDouble((String)groupTempMap.get("weightage")) * valueOfXForGroup / 100.0);
            }
            if (PropertyValidator.isValid((Object)completionCriteria)) {
                groupCompletion = this.calculateCompletionOnOldFormulas(calculationCounts, completionCriteria);
            }
            groupCompletions.put(group.getId(), (double)Math.round(groupCompletion * 100.0) / 100.0);
        }
    }

    public HashMap<String, Object> exportReport(HashMap<String, Object> requestBody) throws Exception {
        ArrayList reportData = new ArrayList();
        String sessionId = (String)requestBody.get("sessionId");
        String completionCriteria = (String)requestBody.get("completionCriteria");
        HashMap groupCompletions = new HashMap();
        ArrayList groupIds = new ArrayList();
        ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessionId);
        Boolean isOkrEnabled = false;
        if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
        }
        String type = (String)requestBody.get("type");
        int exportType = -1;
        exportType = "json".equals(type) ? 2 : ("xls".equals(type) ? 1 : 0);
        this.processOKRs(exportType, reportData, sessionId, completionCriteria, null, null, groupCompletions, groupIds, objectiveMenuPermission);
        1 columnsList = new /* Unavailable Anonymous Inner Class!! */;
        if (isOkrEnabled.booleanValue()) {
            2 okrColumnsList = new /* Unavailable Anonymous Inner Class!! */;
            columnsList.addAll(okrColumnsList);
        }
        String filePath = this.exportService.exportNewObjectiveData(exportType, reportData, (List)columnsList, sessionId, groupIds, groupCompletions);
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String format = ".csv";
        if (exportType == 1) {
            format = ".xls";
        }
        String downloadName = AlmUtils.cleanText((String)("Obj_" + formatter.format(new Date()))) + format;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
        data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
        return data;
    }

    private Boolean verifyItemsToExclude(Item item, Map<String, Object> excludeItemsData) {
        block20: {
            try {
                if (!PropertyValidator.isValid((Object)item) || !PropertyValidator.isValid((Object)item.getStatus()) || !PropertyValidator.isValid((Object)item.getStatus().getCategory()) || item.getStatus().getCategory().equals("Misc")) break block20;
                if (PropertyValidator.isValid(excludeItemsData)) {
                    ArrayList featurePlan = (ArrayList)excludeItemsData.get("featurePlan");
                    if (PropertyValidator.isValid((Collection)featurePlan) && featurePlan.size() == 2) {
                        return false;
                    }
                    if (PropertyValidator.isValid((Object)item) && item.getType().equals("Feature")) {
                        HashMap statusExclusionMap;
                        HashMap featuresIssueType = (HashMap)excludeItemsData.get("featuresIssueType");
                        ArrayList cardTypes = (ArrayList)excludeItemsData.get("cardType");
                        int cardTypeIndex = -1;
                        int cardTypeFeatureIndex = -1;
                        if (PropertyValidator.isValid((Collection)cardTypes)) {
                            for (int i = 0; i < cardTypes.size(); ++i) {
                                Map cardType = (Map)cardTypes.get(i);
                                if (((String)cardType.get("title")).equals("Feature")) {
                                    cardTypeFeatureIndex = i;
                                    continue;
                                }
                                if (!PropertyValidator.isValid((Object)item.getIssueType()) || !((String)cardType.get("title")).equals(item.getIssueType().getTitle())) continue;
                                cardTypeIndex = i;
                            }
                        }
                        Boolean statusExclusion = PropertyValidator.isValid((Object)(statusExclusionMap = (HashMap)excludeItemsData.get("featuresStatus"))) && PropertyValidator.isValid(statusExclusionMap.get(item.getStatus().getTitle()));
                        if ((!PropertyValidator.isValid((Object)item.getJiraIssueTypeId()) && !PropertyValidator.isValid((Object)item.getTfsItemType()) || !PropertyValidator.isValid((Object)excludeItemsData.get("featuresIssueType")) || PropertyValidator.isValid((Object)item.getJiraIssueTypeId()) && !PropertyValidator.isValid(featuresIssueType.get(item.getJiraIssueTypeId().toString())) || PropertyValidator.isValid((Object)item.getTfsItemType()) && !PropertyValidator.isValid(featuresIssueType.get(item.getTfsItemType().toString()))) && (!PropertyValidator.isValid((Object)excludeItemsData.get("featuresStatus")) || !statusExclusion.booleanValue()) && (PropertyValidator.isValid((Object)item.getIssueType()) && cardTypeIndex == -1 || PropertyValidator.isValid((Object)item.getIssueType()) && item.getIssueType().isArchive() || !PropertyValidator.isValid((Object)item.getIssueType()) && cardTypeFeatureIndex == -1)) {
                            return true;
                        }
                    } else if (PropertyValidator.isValid((Object)item) && item.getType().equals("UserStory")) {
                        ArrayList storyPlan = (ArrayList)excludeItemsData.get("storyPlan");
                        if (PropertyValidator.isValid((Collection)storyPlan)) {
                            if (storyPlan.size() == 2) {
                                return false;
                            }
                            Boolean isItemPlanned = false;
                            int indexOfPlannedStroy = -1;
                            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                                for (int i = 0; i < item.getTeamContainers().size(); ++i) {
                                    TeamContainer tc = (TeamContainer)item.getTeamContainers().get(i);
                                    if (!PropertyValidator.isValid((Object)tc.getTeam()) || !PropertyValidator.isValid((Object)tc.getContainer())) continue;
                                    indexOfPlannedStroy = i;
                                    break;
                                }
                            }
                            isItemPlanned = indexOfPlannedStroy > -1;
                            int indexOfUnplannedStroyExclusion = -1;
                            int indexOfPlannedStroyExclusion = -1;
                            for (int i = 0; i < storyPlan.size(); ++i) {
                                HashMap exclusionStoryEntry = (HashMap)storyPlan.get(i);
                                if (!PropertyValidator.isValid(exclusionStoryEntry.get("id"))) continue;
                                if (((String)exclusionStoryEntry.get("id")).equals("unplanned")) {
                                    indexOfUnplannedStroyExclusion = i;
                                    continue;
                                }
                                if (!((String)exclusionStoryEntry.get("id")).equals("planned")) continue;
                                indexOfPlannedStroyExclusion = i;
                            }
                            if (indexOfUnplannedStroyExclusion > -1 && !isItemPlanned.booleanValue()) {
                                return false;
                            }
                            if (indexOfPlannedStroyExclusion > -1 && isItemPlanned.booleanValue()) {
                                return false;
                            }
                        }
                        HashMap storyIssueType = (HashMap)excludeItemsData.get("storyIssueType");
                        HashMap statusExclusionMap = (HashMap)excludeItemsData.get("storyStatus");
                        Boolean statusExclusion = PropertyValidator.isValid((Object)statusExclusionMap) && PropertyValidator.isValid(statusExclusionMap.get(item.getStatus().getTitle()));
                        if ((!PropertyValidator.isValid((Object)item.getJiraIssueTypeId()) && !PropertyValidator.isValid((Object)item.getTfsItemType()) || !PropertyValidator.isValid((Object)excludeItemsData.get("storyIssueType")) || PropertyValidator.isValid((Object)item.getJiraIssueTypeId()) && !PropertyValidator.isValid(storyIssueType.get(item.getJiraIssueTypeId().toString())) || PropertyValidator.isValid((Object)item.getTfsItemType()) && !PropertyValidator.isValid(storyIssueType.get(item.getTfsItemType().toString()))) && (!PropertyValidator.isValid((Object)excludeItemsData.get("storyStatus")) || !statusExclusion.booleanValue())) {
                            return true;
                        }
                    }
                    break block20;
                }
                return true;
            }
            catch (Exception e) {
                String err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
                return true;
            }
        }
        return false;
    }

    @Transactional
    public BaseItem createObjectiveGroup(BaseItem baseItem) throws Exception {
        ObjectiveCustomView customView;
        BaseItem objectiveGroup;
        HashMap<String, String> pushJson = new HashMap<String, String>();
        HashMap pushMeta = new HashMap();
        AuditLog auditLogEntry = new AuditLog();
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        ObjectMapper mapper = new ObjectMapper();
        3 T = new /* Unavailable Anonymous Inner Class!! */;
        if (PropertyValidator.isValid((Object)baseItem.getMetaMap())) {
            pushMeta = (HashMap)gson.fromJson(baseItem.getMetaMap(), T.getType());
        }
        String sessionId = pushMeta.get("sessionId").toString();
        String viewId = null;
        if (pushMeta.containsKey("viewId")) {
            viewId = (String)pushMeta.get("viewId");
        }
        String collectionId = pushMeta.getOrDefault("collectionId", null);
        ItemType itemType = this.itemTypeRepository.findByTitle(EnumKendis.GROUP_OBJECTIVE.getCode());
        if (itemType == null) {
            ItemType type1 = new ItemType();
            type1.setTitle(EnumKendis.GROUP_OBJECTIVE.getCode());
            itemType = (ItemType)this.itemTypeRepository.save((Object)type1);
        }
        baseItem.setItemType(itemType);
        String teamId = pushMeta.get("teamId").toString();
        if (!teamId.equals("0") && !teamId.equals("0.0")) {
            BaseItemLink groupLink = this.baseItemLinkRepository.findBySessionIdAndTeamIdAndType(sessionId, teamId, baseItem.getType());
            if (!PropertyValidator.isValid((Object)groupLink)) {
                for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)baseItemLink) || PropertyValidator.isValid((Object)baseItemLink.getLinkType())) continue;
                    baseItemLink.setLinkType(EnumKendis.SESSION_LINK_OBJECTIVE.getCode());
                }
                this.baseItemLinkRepository.save((Iterable)baseItem.getBaseItemLinks());
                objectiveGroup = (BaseItem)this.baseItemRepository.save((Object)baseItem);
                Team team = (Team)this.teamRepository.findOne((Serializable)((Object)teamId));
                if (PropertyValidator.isValid((Object)team)) {
                    auditLogEntry.setEventType("OBJECTIVE_TEAM_GROUP_ADD");
                    auditLogEntry.setEventText("Objective for Team " + team.getTitle() + " added");
                    auditLogEntry.setSessionId(sessionId);
                    this.auditLogRepository.save((Object)auditLogEntry);
                }
            } else {
                ArrayList<BaseItemLink> baseItemLinks = new ArrayList<BaseItemLink>();
                baseItemLinks.add(groupLink);
                List objGroupList = this.fetchObjectives(Boolean.valueOf(false), sessionId, Boolean.valueOf(true), baseItemLinks, null, Boolean.valueOf(false), null, null);
                objectiveGroup = (BaseItem)objGroupList.get(0);
            }
        } else {
            for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)baseItemLink) || PropertyValidator.isValid((Object)baseItemLink.getLinkType())) continue;
                baseItemLink.setLinkType(EnumKendis.SESSION_LINK_OBJECTIVE.getCode());
            }
            this.baseItemLinkRepository.save((Iterable)baseItem.getBaseItemLinks());
            objectiveGroup = (BaseItem)this.baseItemRepository.save((Object)baseItem);
            auditLogEntry.setEventType("CUSTOM_OBJECTIVE_ADD");
            auditLogEntry.setEventText("Custom Objective " + baseItem.getTitle() + " added");
            auditLogEntry.setSessionId(sessionId);
            this.auditLogRepository.save((Object)auditLogEntry);
        }
        if (PropertyValidator.isValid((Object)viewId) && PropertyValidator.isValid((Object)(customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)viewId))))) {
            ArrayList<BaseItemLink> itemLinks = new ArrayList<BaseItemLink>();
            if (customView.getBaseItemLinks() == null) {
                customView.setBaseItemLinks(new ArrayList());
            }
            BaseItemLink link = new BaseItemLink();
            link.setId(ObjectId.get().toString());
            link.setType("objective-group");
            link.setBaseItemId(objectiveGroup.getId());
            itemLinks.add(link);
            customView.getBaseItemLinks().add(link);
            if (objectiveGroup.getBaseItemLinks() == null) {
                objectiveGroup.setBaseItemLinks(new ArrayList());
            }
            link = new BaseItemLink();
            link.setId(ObjectId.get().toString());
            link.setType("custom-view");
            link.setBaseItemId(customView.getId());
            itemLinks.add(link);
            objectiveGroup.getBaseItemLinks().add(link);
            if (PropertyValidator.isValid((Object)collectionId)) {
                if (!PropertyValidator.isValid((Collection)customView.getLinkedCollections())) {
                    customView.setLinkedCollections(new ArrayList());
                }
                if (!customView.getLinkedCollections().contains(collectionId)) {
                    customView.getLinkedCollections().add(collectionId);
                }
            }
            this.baseItemLinkRepository.save(itemLinks);
            this.baseItemRepository.save((Object)objectiveGroup);
            this.objectiveCustomViewRepository.save((Object)customView);
        }
        if (!pushMeta.isEmpty()) {
            pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
            pushJson.put("metaMap", gson.toJson((Object)pushMeta));
        }
        pushJson.put("push", "Self");
        pushJson.put("action", "createObjectiveGroup");
        pushJson.put("data", (String)objectiveGroup);
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
        }
        return objectiveGroup;
    }

    public HashMap<String, Object> loadObjectivesListBySessionIdAndItemId(String sessionId, String itemId, String jiraKey, String tfsId) {
        try {
            Item item;
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            LOGGER.debug("Fetching Objective Groups for session Id -> " + sessionId);
            List objectiveGroupList = new ArrayList();
            List filteredGroupList = new ArrayList();
            ArrayList<String> teamsList = new ArrayList<String>();
            Session session = this.sessionRepository.findById(sessionId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(session.getActiveSessionBoard())));
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Collection)sessionBoard.getTeams()) && sessionBoard.getTeams().size() > 0) {
                for (Team team : sessionBoard.getTeams()) {
                    teamsList.add(team.getId());
                }
            }
            if (PropertyValidator.isValid((Object)(item = this.itemRepository.findByIdOrJiraKeyOrTfsId(itemId, jiraKey, tfsId)))) {
                objectiveGroupList = this.fetchObjectives(Boolean.valueOf(false), sessionId, Boolean.valueOf(true), null, null, Boolean.valueOf(false), null, null);
                filteredGroupList = this.filteredObjectivesGroupsList(objectiveGroupList, sessionId, jiraKey, tfsId, itemId, teamsList);
            }
            LOGGER.debug("Preparing Response Data");
            responseData.put("objectiveGroups", filteredGroupList);
            return responseData;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public HashMap<String, Object> loadOldStateObjectivesListBySessionIdAndItemId(String sessionId, String sessionBoardId, String itemId, String jiraKey, String tfsId) throws JsonProcessingException {
        try {
            Item item;
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            LOGGER.debug("Fetching Objective Groups for session Id -> " + sessionId);
            ArrayList<BaseItem> objectiveGroupList = new ArrayList<BaseItem>();
            List filteredGroupList = new ArrayList();
            ArrayList<String> teamsList = new ArrayList<String>();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardId)));
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Collection)sessionBoard.getTeams()) && sessionBoard.getTeams().size() > 0) {
                for (Team team : sessionBoard.getTeams()) {
                    teamsList.add(team.getId());
                }
            }
            if (PropertyValidator.isValid((Object)(item = this.itemRepository.findByIdOrJiraKeyOrTfsId(itemId, jiraKey, tfsId)))) {
                ObjectMapper mapper = new ObjectMapper();
                String objectives = MongoSyncUtils.retrieveData((String)("old_state_objectives_" + sessionBoardId), (AppConfig.MongoConfig)this.mongoConfig);
                HashMap objectivesData = (HashMap)mapper.readValue(objectives, HashMap.class);
                List objectiveGroupListData = (List)objectivesData.get("objectiveGroups");
                for (LinkedHashMap objGrp : objectiveGroupListData) {
                    BaseItem baseItem = (BaseItem)mapper.convertValue((Object)objGrp, BaseItem.class);
                    objectiveGroupList.add(baseItem);
                }
                filteredGroupList = this.filteredObjectivesGroupsList(objectiveGroupList, sessionId, jiraKey, tfsId, itemId, teamsList);
            }
            LOGGER.debug("Preparing Response Data");
            responseData.put("objectiveGroups", filteredGroupList);
            return responseData;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    private void applyTimePeriodFilterOnObjectives(List<String> baseItemLinks, List<Integer> years, List<String> uniqueTags, HashMap<String, BaseItem> parentGroupMap, String objTimePeriodFieldId, String krTimePeriodFieldId, Boolean byObjectives, Boolean byKrs) {
        List baseItems = this.baseItemRepository.findByIdIn(baseItemLinks);
        if (PropertyValidator.isValid((Collection)baseItems)) {
            ArrayList<String> subBaseItemIds = new ArrayList<String>();
            for (BaseItem baseItem : baseItems) {
                String tag;
                Integer selectedYear;
                Map valueMap;
                if (baseItem.getTitle().equals("onj")) {
                    LOGGER.debug("name : " + baseItem.getTitle());
                }
                LOGGER.debug("name : " + baseItem.getTitle());
                BaseItem parentGroup = parentGroupMap.get(baseItem.getId());
                if (!PropertyValidator.isValid((Object)parentGroup)) continue;
                if (baseItem.getType().equals("Objective-Committed")) {
                    if (byObjectives.booleanValue() && PropertyValidator.isValid((Object)baseItem.getFields()) && baseItem.getFields().containsKey(objTimePeriodFieldId)) {
                        valueMap = (Map)baseItem.getFields().get(objTimePeriodFieldId);
                        selectedYear = (Integer)valueMap.get("selectedYear");
                        tag = (String)valueMap.get("title");
                        if (years.contains(selectedYear) && uniqueTags.contains(tag)) {
                            parentGroup.setIncludeInFilter(true);
                        }
                    }
                } else if (baseItem.getType().equals("KR") && byKrs.booleanValue() && PropertyValidator.isValid((Object)baseItem.getFields()) && baseItem.getFields().containsKey(krTimePeriodFieldId)) {
                    valueMap = (Map)baseItem.getFields().get(krTimePeriodFieldId);
                    selectedYear = (Integer)valueMap.get("selectedYear");
                    tag = (String)valueMap.get("title");
                    if (years.contains(selectedYear) && uniqueTags.contains(tag)) {
                        parentGroup.setIncludeInFilter(true);
                    }
                }
                if (!PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) continue;
                for (BaseItemLink itemLink : baseItem.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)itemLink) || !PropertyValidator.isValid((Object)itemLink.getLinkType()) || !itemLink.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) && !itemLink.getLinkType().equals(EnumKendis.PARENT_OKR.getCode())) continue;
                    subBaseItemIds.add(itemLink.getBaseItemId());
                    parentGroupMap.put(itemLink.getBaseItemId(), parentGroup);
                }
            }
            if (PropertyValidator.isValid(subBaseItemIds)) {
                this.applyTimePeriodFilterOnObjectives(subBaseItemIds, years, uniqueTags, parentGroupMap, objTimePeriodFieldId, krTimePeriodFieldId, byObjectives, byKrs);
            }
        }
    }

    private List<BaseItem> filterListOfObjecttivesAccordingToTimePeriods(HashMap<String, Object> requestBody, List<BaseItem> objectives, int listType) {
        Map timeperiods;
        if (requestBody.containsKey("timeperiods") && PropertyValidator.isValid((Object)(timeperiods = (Map)requestBody.get("timeperiods"))) && !timeperiods.isEmpty()) {
            Set years = timeperiods.keySet();
            HashMap<String, String> dupCheckMap = new HashMap<String, String>();
            ArrayList<String> uniqueTags = new ArrayList<String>();
            ArrayList<Integer> uniqueYears = new ArrayList<Integer>();
            for (String year : years) {
                uniqueYears.add(Integer.parseInt(year));
                List tags = (List)timeperiods.get(year);
                for (String tag : tags) {
                    if (dupCheckMap.containsKey(tag)) continue;
                    dupCheckMap.put(tag, tag);
                    uniqueTags.add(tag);
                }
            }
            HashMap<String, BaseItem> parentGroupMap = new HashMap<String, BaseItem>();
            if (PropertyValidator.isValid(uniqueYears) && PropertyValidator.isValid(uniqueTags)) {
                String objectiveTimePeriodFieldId = (String)requestBody.get("timePeriodFieldId");
                String krTimePeriodFieldId = (String)requestBody.get("timePeriodKRFieldId");
                Boolean byObjectives = (Boolean)requestBody.get("byObjectives");
                Boolean byKrs = (Boolean)requestBody.get("byKrs");
                ArrayList<String> subObjectiveIds = new ArrayList<String>();
                for (BaseItem objective : objectives) {
                    String tag;
                    Integer selectedYear;
                    Map valueMap;
                    if (byObjectives.booleanValue() && objective.getType().equals("Objective-Committed")) {
                        if (byObjectives.booleanValue() && PropertyValidator.isValid((Object)objective.getFields()) && objective.getFields().containsKey(objectiveTimePeriodFieldId)) {
                            valueMap = (Map)objective.getFields().get(objectiveTimePeriodFieldId);
                            selectedYear = (Integer)valueMap.get("selectedYear");
                            tag = (String)valueMap.get("title");
                            if (uniqueYears.contains(selectedYear) && uniqueTags.contains(tag)) {
                                objective.setIncludeInFilter(true);
                            }
                        }
                    } else if (objective.getType().equals("KR") && byKrs.booleanValue() && PropertyValidator.isValid((Object)objective.getFields()) && objective.getFields().containsKey(krTimePeriodFieldId)) {
                        valueMap = (Map)objective.getFields().get(krTimePeriodFieldId);
                        selectedYear = (Integer)valueMap.get("selectedYear");
                        tag = (String)valueMap.get("title");
                        if (uniqueYears.contains(selectedYear) && uniqueTags.contains(tag)) {
                            objective.setIncludeInFilter(true);
                        }
                    }
                    if (!PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) continue;
                    for (BaseItemLink itemLink : objective.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)itemLink) || !PropertyValidator.isValid((Object)itemLink.getLinkType())) continue;
                        if (listType == 0 && itemLink.getLinkType().equals(EnumKendis.CHILD_GROUP_OBJECTIVE.getCode())) {
                            subObjectiveIds.add(itemLink.getBaseItemId());
                            parentGroupMap.put(itemLink.getBaseItemId(), objective);
                            continue;
                        }
                        if (listType == 1 && itemLink.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode())) {
                            subObjectiveIds.add(itemLink.getBaseItemId());
                            parentGroupMap.put(itemLink.getBaseItemId(), objective);
                            continue;
                        }
                        if (listType != 2 || !itemLink.getLinkType().equals(EnumKendis.PARENT_OKR.getCode())) continue;
                        subObjectiveIds.add(itemLink.getBaseItemId());
                        parentGroupMap.put(itemLink.getBaseItemId(), objective);
                    }
                }
                if (PropertyValidator.isValid(subObjectiveIds)) {
                    this.applyTimePeriodFilterOnObjectives(subObjectiveIds, uniqueYears, uniqueTags, parentGroupMap, objectiveTimePeriodFieldId, krTimePeriodFieldId, byObjectives, byKrs);
                }
                objectives = objectives.stream().filter(bItem -> bItem.isIncludeInFilter()).collect(Collectors.toList());
            }
        }
        return objectives;
    }

    private List<BaseItem> filterObjectivesByFieldId(List<BaseItem> objectives, String fieldId, Object fieldValue, String fieldIdentifier) throws Exception {
        if (fieldValue instanceof List && ((List)fieldValue).isEmpty()) {
            return new ArrayList<BaseItem>(objectives);
        }
        ArrayList<BaseItem> filteredObjectives = new ArrayList<BaseItem>();
        for (BaseItem objective : objectives) {
            Map valueMap;
            if (!PropertyValidator.isValid((Object)objective.getFields()) || !objective.getFields().containsKey(fieldId) || !PropertyValidator.isValid((Object)(valueMap = (Map)objective.getFields().get(fieldId))) || !valueMap.containsKey(fieldIdentifier)) continue;
            Object value = valueMap.get(fieldIdentifier);
            if (fieldValue instanceof List) {
                List fieldValueList = (List)fieldValue;
                if (!fieldValueList.contains(value)) continue;
                filteredObjectives.add(objective);
                continue;
            }
            if (!fieldValue.equals(value)) continue;
            filteredObjectives.add(objective);
        }
        return filteredObjectives;
    }

    public HashMap<String, Object> loadObjectivesListByObjectId(HashMap<String, Object> requestBody) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            String sessionId = (String)requestBody.get("sessionId");
            Boolean isMockingMode = (Boolean)requestBody.get("isMockingMode");
            String viewId = (String)requestBody.get("viewId");
            String viewKey = (String)requestBody.get("viewKey");
            String responsibleFieldId = (String)requestBody.get("responsibleFieldId");
            Boolean includePreliminaryCounts = (Boolean)requestBody.get("includePreliminaryCounts");
            LOGGER.debug("Fetching Objective Groups for session Id -> " + sessionId);
            List objectiveGroupList = this.fetchObjectives(Boolean.valueOf(false), sessionId, Boolean.valueOf(true), null, null, isMockingMode, viewId, viewKey);
            objectiveGroupList = this.applyAllObjectiveFilters(requestBody, objectiveGroupList, 0);
            HashSet<String> artIds = new HashSet<String>();
            HashSet<String> linkedSessionIds = new HashSet<String>();
            for (Object grp : objectiveGroupList) {
                if (!PropertyValidator.isValid((Collection)grp.getBaseItemList())) continue;
                for (BaseItem obj : grp.getBaseItemList()) {
                    if (!PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) continue;
                    for (BaseItemLink link : obj.getBaseItemLinks()) {
                        if (PropertyValidator.isValid((Object)link.getLinkType()) && link.getLinkType().equals(EnumKendis.ART_LINK_OBJECTIVE.getCode()) && !link.isArchive()) {
                            artIds.add(link.getSessionId());
                        }
                        if (!PropertyValidator.isValid((Object)link.getLinkType()) || !link.getLinkType().equals(EnumKendis.LINKED_SESSION.getCode()) || link.isArchive()) continue;
                        linkedSessionIds.add(link.getSessionId());
                    }
                }
                if (!PropertyValidator.isValid((Collection)grp.getBaseItemLinks())) continue;
                for (BaseItemLink link : grp.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link.getLinkType()) || !link.getLinkType().equals(EnumKendis.ART_LINK_OBJECTIVE.getCode()) || link.isArchive()) continue;
                    artIds.add(link.getSessionId());
                }
            }
            artIds.remove("-1");
            List departments = this.workSpaceRepository.findByIdIn(new ArrayList(artIds));
            for (WorkSpace dpt : departments) {
                artIds.remove(dpt.getId());
            }
            if (PropertyValidator.isValid(artIds)) {
                List batches = this.baseItemRepository.findBatchesByIdIn(new ArrayList(artIds));
                responseData.put("batches", batches);
            }
            if (PropertyValidator.isValid(linkedSessionIds)) {
                List linkedSessions = this.sessionRepository.findSessionsByIdIn(new ArrayList(linkedSessionIds));
                responseData.put("sessions", linkedSessions);
                List sessionBoards = this.sessionBoardRepository.findBoardsForTeamsBySessionIn(linkedSessions);
                responseData.put("sessionBoards", sessionBoards);
            }
            HashMap preliminaryCounts = new HashMap();
            if (PropertyValidator.isValid((Object)includePreliminaryCounts) && includePreliminaryCounts.booleanValue() && PropertyValidator.isValid((Collection)objectiveGroupList)) {
                List groupIds = objectiveGroupList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                preliminaryCounts = this.getObjectiveGroupLinkedObjectivesCount(groupIds, requestBody);
                LOGGER.debug("Preparing Response Data with preliminary counts");
                responseData.put("preliminaryCounts", preliminaryCounts);
            } else {
                LOGGER.debug("Preparing Response Data without preliminary counts");
            }
            responseData.put("objectiveGroups", objectiveGroupList);
            return responseData;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public List<BaseItem> applyAllObjectiveFilters(HashMap<String, Object> requestBody, List<BaseItem> objectives, int level) throws Exception {
        objectives = this.filterListOfObjecttivesAccordingToTimePeriods(requestBody, objectives, level);
        Set criteriaMatched = this.getObjectiveCriteriaMatchedIds(requestBody, objectives, level);
        Set timeMatched = objectives.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        Set finalMatched = this.intersectNonNull(new Set[]{timeMatched, criteriaMatched});
        for (BaseItem item : objectives) {
            item.setIncludeInFilter(finalMatched.contains(item.getId()));
        }
        return objectives.stream().filter(BaseItem::isIncludeInFilter).collect(Collectors.toList());
    }

    @SafeVarargs
    private final Set<String> intersectNonNull(Set<String> ... sets) {
        return Arrays.stream(sets).filter(Objects::nonNull).reduce((a, b) -> {
            a.retainAll((Collection<?>)b);
            return a;
        }).orElse(Collections.emptySet());
    }

    private boolean passesFilter(BaseItem objective, FilterContext ctx) throws Exception {
        boolean matchResponsible = true;
        boolean matchStatus = true;
        boolean matchCollections = true;
        boolean matchSearch = true;
        if (ctx.hasResponsibles()) {
            String responsibleId = null;
            if (objective.getType().equals("Objective-Committed") && objective.getFields().containsKey(ctx.responsibleFieldId)) {
                responsibleId = (String)((Map)objective.getFields().get(ctx.responsibleFieldId)).get("id");
            } else if (objective.getType().equals("KR") && objective.getFields().containsKey(ctx.krResponsibleFieldId)) {
                responsibleId = (String)((Map)objective.getFields().get(ctx.krResponsibleFieldId)).get("id");
            }
            boolean bl = matchResponsible = responsibleId != null && ctx.responsibles.contains(responsibleId);
        }
        if (ctx.hasStatuses()) {
            boolean bl = matchStatus = PropertyValidator.isValid((Object)objective.getStatus()) && ctx.statuses.contains(objective.getStatus().getId());
        }
        if (ctx.hasCollections() && PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) {
            matchCollections = objective.getBaseItemLinks().stream().anyMatch(link -> EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getSessionId()) && ctx.collections.contains(link.getSessionId()));
        }
        if (ctx.hasSearchQuery()) {
            String title = objective.getTitle() != null ? objective.getTitle().toLowerCase() : "";
            String key = objective.getKey() != null ? objective.getKey().toLowerCase() : "";
            matchSearch = title.contains(ctx.searchQuery) || key.contains(ctx.searchQuery);
        }
        return !(ctx.hasResponsibles() && !matchResponsible || ctx.hasStatuses() && !matchStatus || ctx.hasCollections() && !matchCollections || ctx.hasSearchQuery() && !matchSearch);
    }

    private Set<String> getObjectiveCriteriaMatchedIds(HashMap<String, Object> request, List<BaseItem> objectives, int level) throws Exception {
        FilterContext ctx = new FilterContext(null);
        ctx.responsibles = (List)request.get("responsibles");
        ctx.statuses = (List)request.get("statuses");
        ctx.collections = (List)request.get("collections");
        ctx.responsibleFieldId = (String)request.get("responsibleFieldId");
        ctx.krResponsibleFieldId = (String)request.get("krResponsibleFieldId");
        ctx.searchQuery = request.containsKey("searchQuery") ? ((String)request.get("searchQuery")).toLowerCase() : null;
        HashSet<String> matchedIds = new HashSet<String>();
        HashSet<String> subObjectiveIds = new HashSet<String>();
        HashMap<String, BaseItem> parentGroupMap = new HashMap<String, BaseItem>();
        for (BaseItem item : objectives) {
            if (this.passesFilter(item, ctx)) {
                matchedIds.add(item.getId());
            }
            if (level != 0 || !PropertyValidator.isValid((Collection)item.getBaseItemLinks())) continue;
            for (BaseItemLink link : item.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || !EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType())) continue;
                subObjectiveIds.add(link.getBaseItemId());
                parentGroupMap.put(link.getBaseItemId(), item);
            }
        }
        if (!subObjectiveIds.isEmpty()) {
            List subObjs = this.baseItemRepository.findByIdIn(new ArrayList(subObjectiveIds));
            for (BaseItem sub : subObjs) {
                BaseItem parent;
                if (!this.passesFilter(sub, ctx) || (parent = (BaseItem)parentGroupMap.get(sub.getId())) == null) continue;
                matchedIds.add(parent.getId());
            }
        }
        return matchedIds;
    }

    private List<BaseItem> filterObjectivesUsingObjectiveFilters(HashMap<String, Object> request, List<BaseItem> objectives, int level) throws Exception {
        FilterContext ctx = new FilterContext(null);
        ctx.responsibles = (List)request.get("responsibles");
        ctx.statuses = (List)request.get("statuses");
        ctx.collections = (List)request.get("collections");
        ctx.responsibleFieldId = (String)request.get("responsibleFieldId");
        ctx.krResponsibleFieldId = (String)request.get("krResponsibleFieldId");
        HashMap<String, BaseItem> parentGroupMap = new HashMap<String, BaseItem>();
        HashSet<String> subObjectiveIds = new HashSet<String>();
        for (BaseItem objective : objectives) {
            boolean isMatched = this.passesFilter(objective, ctx);
            if (isMatched) {
                objective.setIncludeInFilter(true);
            }
            if (level != 0 || !PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) continue;
            for (BaseItemLink link : objective.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || !EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType())) continue;
                subObjectiveIds.add(link.getBaseItemId());
                parentGroupMap.put(link.getBaseItemId(), objective);
            }
        }
        if (!subObjectiveIds.isEmpty()) {
            this.applyObjectiveFilterOnObjectives(new ArrayList(subObjectiveIds), parentGroupMap, ctx);
        }
        return objectives.stream().filter(BaseItem::isIncludeInFilter).collect(Collectors.toList());
    }

    private void applyObjectiveFilterOnObjectives(ArrayList<String> subObjectiveIds, Map<String, BaseItem> parentGroupMap, FilterContext ctx) throws Exception {
        List objectives = this.baseItemRepository.findByIdIn(subObjectiveIds);
        for (BaseItem obj : objectives) {
            BaseItem parent = parentGroupMap.get(obj.getId());
            if (!PropertyValidator.isValid((Object)parent) || !this.passesFilter(obj, ctx)) continue;
            parent.setIncludeInFilter(true);
        }
    }

    public HashMap<String, Object> loadObjectivesListBySessionId(String sessionId, String requestId, String sessionBoardId) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            ArrayList<BaseItem> filteredObjectiveGroupList = new ArrayList<BaseItem>();
            ArrayList<String> teamsMap = new ArrayList<String>();
            LOGGER.debug("Fetching Objective Groups for session Id -> " + sessionId);
            List objectiveGroupList = this.fetchObjectives(Boolean.valueOf(false), sessionId, Boolean.valueOf(true), null, requestId, Boolean.valueOf(false), null, null);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardId)));
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Collection)sessionBoard.getTeams()) && sessionBoard.getTeams().size() > 0) {
                for (Team team : sessionBoard.getTeams()) {
                    teamsMap.add(team.getId());
                }
            }
            if (objectiveGroupList.size() > 0) {
                for (BaseItem objGroup : objectiveGroupList) {
                    BaseItemLink teamIdLink = null;
                    for (BaseItemLink link : objGroup.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getTeamId())) continue;
                        teamIdLink = link;
                        break;
                    }
                    if (PropertyValidator.isValid(teamIdLink) && PropertyValidator.isValid((Object)teamIdLink.getTeamId()) && teamIdLink.getTeamId().equals("0")) {
                        filteredObjectiveGroupList.add(objGroup);
                        continue;
                    }
                    if (!PropertyValidator.isValid(teamIdLink) || !PropertyValidator.isValid((Object)teamIdLink.getTeamId()) || !teamsMap.contains(teamIdLink.getTeamId())) continue;
                    filteredObjectiveGroupList.add(objGroup);
                }
            }
            LOGGER.debug("Preparing Response Data");
            responseData.put("objectiveGroups", filteredObjectiveGroupList);
            return responseData;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public Map<String, Map<String, Object>> fetchNewObjectiveDataForBoards(List<String> activeSessionBoardIds, List<String> sessionIds, String tenant) {
        try {
            HashMap<String, Map<String, Object>> responseData = new HashMap<String, Map<String, Object>>();
            HashMap teamsMapAgainstSessions = new HashMap();
            Map objGrpAgainstSessionId = this.fetchObjectivesForBoards(sessionIds, Boolean.valueOf(true), tenant, Boolean.valueOf(false));
            Map sessionBoardMapBySessionId = this.objectiveServiceDAO.findSessionBoardsMapByIdIn(activeSessionBoardIds, tenant);
            for (String key : objGrpAgainstSessionId.keySet()) {
                SessionBoard sessionBoard = (SessionBoard)sessionBoardMapBySessionId.get(key);
                teamsMapAgainstSessions.put(key, new HashSet());
                if (!PropertyValidator.isValid((Collection)sessionBoard.getTeams())) continue;
                for (Team team : sessionBoard.getTeams()) {
                    ((Set)teamsMapAgainstSessions.get(key)).add(team.getId());
                }
            }
            for (String sessionId : sessionIds) {
                List objectiveGroupList = (List)objGrpAgainstSessionId.get(sessionId);
                LinkedList<BaseItem> filteredObjectiveGroupList = new LinkedList<BaseItem>();
                HashMap<String, LinkedList<BaseItem>> responseDataForSession = new HashMap<String, LinkedList<BaseItem>>();
                if (PropertyValidator.isValid((Collection)objectiveGroupList)) {
                    Set teamsMap = (Set)teamsMapAgainstSessions.get(sessionId);
                    for (BaseItem objGroup : objectiveGroupList) {
                        BaseItemLink teamIdLink = null;
                        for (BaseItemLink link : objGroup.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getTeamId())) continue;
                            teamIdLink = link;
                            break;
                        }
                        if (PropertyValidator.isValid(teamIdLink) && PropertyValidator.isValid((Object)teamIdLink.getTeamId()) && teamIdLink.getTeamId().equals("0")) {
                            filteredObjectiveGroupList.add(objGroup);
                            continue;
                        }
                        if (!PropertyValidator.isValid(teamIdLink) || !PropertyValidator.isValid((Object)teamIdLink.getTeamId()) || !teamsMap.contains(teamIdLink.getTeamId())) continue;
                        filteredObjectiveGroupList.add(objGroup);
                    }
                }
                responseDataForSession.put("objectiveGroups", filteredObjectiveGroupList);
                responseData.put(sessionId, responseDataForSession);
            }
            return responseData;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public HashMap<String, Object> loadObjectivesId(HashMap<String, String> requestBody) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            String objectiveId = requestBody.get("objectiveId");
            Optional<String> requestId = Optional.ofNullable(requestBody.get("requestId"));
            Boolean isMockingMode = null != requestBody.get("isMockingMode");
            Boolean fetchPIs = null != requestBody.get("fetchPIs");
            if (PropertyValidator.isValid((Object)objectiveId) && PropertyValidator.isValid(requestId)) {
                LOGGER.debug("Fetching Objective for Id -> " + objectiveId);
                BaseItem objective = this.fetchObjective(Boolean.valueOf(false), objectiveId, Boolean.valueOf(true), requestId, isMockingMode);
                if (fetchPIs.booleanValue()) {
                    HashSet<String> sessionIds = new HashSet<String>();
                    if (PropertyValidator.isValid((Collection)objective.getBaseItemList())) {
                        for (BaseItem obj : objective.getBaseItemList()) {
                            if (!PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) continue;
                            for (BaseItemLink link : obj.getBaseItemLinks()) {
                                if ((!EnumKendis.OBJECTIVE.getCode().equals(link.getType()) || !EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getSessionId())) && (!EnumKendis.OBJECTIVE.getCode().equals(link.getType()) || !PropertyValidator.isValid((Object)link.getSessionBoardId()))) continue;
                                sessionIds.add(link.getSessionId());
                            }
                        }
                        if (PropertyValidator.isValid(sessionIds)) {
                            List sessions = this.sessionRepository.findMinimalSessionsByIdIn(new ArrayList(sessionIds));
                            HashMap<String, Session> sessionMapById = new HashMap<String, Session>();
                            for (Session session : sessions) {
                                sessionMapById.put(session.getId(), session);
                            }
                            responseData.put("sessionMapById", sessionMapById);
                        }
                    }
                }
                if (isMockingMode.booleanValue()) {
                    List users;
                    ArrayList<String> userEmails = new ArrayList<String>();
                    if (PropertyValidator.isValid((Object)objective.getCreatedBy())) {
                        userEmails.add(objective.getCreatedBy());
                    }
                    if (PropertyValidator.isValid((Object)objective.getUpdatedBy()) && !userEmails.contains(objective.getUpdatedBy())) {
                        userEmails.add(objective.getUpdatedBy());
                    }
                    if (PropertyValidator.isValid(userEmails) && PropertyValidator.isValid((Collection)(users = this.userRepository.findByUserNameIgnoreCaseIn(userEmails)))) {
                        for (User user : users) {
                            if (!PropertyValidator.isValid((Object)user.getUserName()) || !PropertyValidator.isValid((Object)user.getFullName())) continue;
                            if (user.getUserName().equals(objective.getCreatedBy()) && user.getUserName().equals(objective.getUpdatedBy())) {
                                objective.setCreatedBy(user.getFullName());
                                objective.setUpdatedBy(user.getFullName());
                                continue;
                            }
                            if (user.getUserName().equals(objective.getCreatedBy())) {
                                objective.setCreatedBy(user.getFullName());
                                continue;
                            }
                            objective.setUpdatedBy(user.getFullName());
                        }
                    }
                }
                LOGGER.debug("Preparing Response Data");
                responseData.put("objective", objective);
            }
            return responseData;
        }
        catch (KendisException e) {
            LOGGER.debug(e.getStackTrace().toString());
            throw e;
        }
        catch (Exception e) {
            LOGGER.debug(e.getStackTrace().toString());
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public HashMap<String, Object> loadObjectivesByIds(HashMap<String, Object> requestBody) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            List objectiveIds = (List)requestBody.get("objectiveIds");
            Optional<String> requestId = Optional.ofNullable((String)requestBody.get("requestId"));
            Boolean isMockingMode = null != requestBody.get("isMockingMode");
            Boolean fetchPIs = null != requestBody.get("fetchPIs");
            if (PropertyValidator.isValid((Collection)objectiveIds) && !objectiveIds.isEmpty()) {
                LOGGER.debug("Fetching Objectives for Ids -> " + objectiveIds);
                List objectives = this.baseItemRepository.findByIdIn(objectiveIds);
                ArrayList<BaseItem> processedObjectives = new ArrayList<BaseItem>();
                for (Object objective : objectives) {
                    if (objective == null) continue;
                    BaseItem processedObjective = this.fetchObjective(Boolean.valueOf(false), objective.getId(), Boolean.valueOf(true), requestId, isMockingMode);
                    processedObjectives.add(processedObjective);
                }
                if (fetchPIs.booleanValue() && !processedObjectives.isEmpty()) {
                    HashSet<String> sessionIds = new HashSet<String>();
                    for (BaseItem objective : processedObjectives) {
                        if (!PropertyValidator.isValid((Collection)objective.getBaseItemList())) continue;
                        for (BaseItem obj : objective.getBaseItemList()) {
                            if (!PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) continue;
                            for (BaseItemLink link : obj.getBaseItemLinks()) {
                                if ((!EnumKendis.OBJECTIVE.getCode().equals(link.getType()) || !EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getSessionId())) && (!EnumKendis.OBJECTIVE.getCode().equals(link.getType()) || !PropertyValidator.isValid((Object)link.getSessionBoardId())) || !PropertyValidator.isValid((Object)link.getSessionId())) continue;
                                sessionIds.add(link.getSessionId());
                            }
                        }
                    }
                    if (PropertyValidator.isValid(sessionIds)) {
                        List sessions = this.sessionRepository.findMinimalSessionsByIdIn(new ArrayList(sessionIds));
                        HashMap<String, Session> sessionMapById = new HashMap<String, Session>();
                        Iterator iterator = sessions.iterator();
                        while (iterator.hasNext()) {
                            Session session = (Session)iterator.next();
                            sessionMapById.put(session.getId(), session);
                        }
                        responseData.put("sessionMapById", sessionMapById);
                    }
                }
                if (isMockingMode.booleanValue()) {
                    HashSet<String> allUserEmails = new HashSet<String>();
                    for (BaseItem objective : processedObjectives) {
                        if (PropertyValidator.isValid((Object)objective.getCreatedBy())) {
                            allUserEmails.add(objective.getCreatedBy());
                        }
                        if (!PropertyValidator.isValid((Object)objective.getUpdatedBy()) || allUserEmails.contains(objective.getUpdatedBy())) continue;
                        allUserEmails.add(objective.getUpdatedBy());
                    }
                    if (PropertyValidator.isValid(allUserEmails)) {
                        List users = this.userRepository.findByUserNameIgnoreCaseIn(new ArrayList(allUserEmails));
                        HashMap<String, User> userMap = new HashMap<String, User>();
                        if (PropertyValidator.isValid((Collection)users)) {
                            for (User user : users) {
                                if (!PropertyValidator.isValid((Object)user.getUserName()) || !PropertyValidator.isValid((Object)user.getFullName())) continue;
                                userMap.put(user.getUserName(), user);
                            }
                        }
                        for (BaseItem objective : processedObjectives) {
                            User createdByUser = (User)userMap.get(objective.getCreatedBy());
                            User updatedByUser = (User)userMap.get(objective.getUpdatedBy());
                            if (createdByUser != null) {
                                objective.setCreatedBy(createdByUser.getFullName());
                            }
                            if (updatedByUser == null) continue;
                            objective.setUpdatedBy(updatedByUser.getFullName());
                        }
                    }
                }
                LOGGER.debug("Preparing Response Data for batch objectives");
                responseData.put("objectives", processedObjectives);
            }
            return responseData;
        }
        catch (KendisException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public HashMap<String, Object> loadObjectivesListBySolutionId(String solutionId) {
        try {
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionId));
            LOGGER.debug("Fetching Objective Groups for solution Id -> " + solutionId);
            List objectiveGroupList = this.fetchObjectives(Boolean.valueOf(true), solutionId, solutionBoard.getOkrEnabled(), null, null, Boolean.valueOf(false), null, null);
            LOGGER.debug("Preparing Response Data");
            responseData.put("objectiveGroups", objectiveGroupList);
            return responseData;
        }
        catch (KendisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KendisException("Internal Server Error------" + e.getMessage());
        }
    }

    public HashMap<String, Object> loadObjectivesGroupData(HashMap<String, Object> requestBody) {
        String sessionId = (String)requestBody.get("sessionId");
        Boolean isMockingMode = (Boolean)requestBody.get("isMockingMode");
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        ArrayList<String> teamsList = new ArrayList<String>();
        ArrayList<BaseItem> filteredGroupList = new ArrayList<BaseItem>();
        List groupBaseItemLinks = this.baseItemLinkRepository.findBySessionIdAndType(sessionId, "Objective-Group");
        List groupList = this.baseItemRepository.findGroupsByBaseItemLinksIn(groupBaseItemLinks);
        if (!isMockingMode.booleanValue()) {
            Session session = this.sessionRepository.findById(sessionId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(session.getActiveSessionBoard())));
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Collection)sessionBoard.getTeams()) && sessionBoard.getTeams().size() > 0) {
                for (Team team : sessionBoard.getTeams()) {
                    teamsList.add(team.getId());
                }
            }
            if (groupList.size() > 0) {
                for (BaseItem objGroup : groupList) {
                    BaseItemLink teamIdLink = null;
                    for (BaseItemLink link : objGroup.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getTeamId())) continue;
                        teamIdLink = link;
                        break;
                    }
                    if (PropertyValidator.isValid(teamIdLink) && PropertyValidator.isValid((Object)teamIdLink.getTeamId()) && teamIdLink.getTeamId().equals("0")) {
                        filteredGroupList.add(objGroup);
                        continue;
                    }
                    if (!PropertyValidator.isValid(teamIdLink) || !PropertyValidator.isValid((Object)teamIdLink.getTeamId()) || !teamsList.contains(teamIdLink.getTeamId())) continue;
                    filteredGroupList.add(objGroup);
                }
            }
            responseData.put("objectiveGroupsList", filteredGroupList);
        } else {
            responseData.put("objectiveGroupsList", groupList);
        }
        return responseData;
    }

    private List<ObjectId> filterObjectiveIdsWithLinkedItems(List<BaseItemLink> baseItemLinks, Map<String, List<BaseItem>> objectiveMappedByGroup, List<BaseItem> objectiveGroupList, Map<String, BaseItemLink> groupBaseItemIds) {
        ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
        if (!PropertyValidator.isValid(baseItemLinks) || !PropertyValidator.isValid(objectiveGroupList)) {
            return objectiveIds;
        }
        for (BaseItem objectiveGroup : objectiveGroupList) {
            objectiveGroup.links(groupBaseItemIds);
            for (BaseItemLink link : objectiveGroup.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive()) continue;
                objectiveMappedByGroup.computeIfAbsent(link.getBaseItemId(), k -> new ArrayList()).add(objectiveGroup);
                objectiveIds.add(new ObjectId(link.getBaseItemId()));
            }
            Status status = objectiveGroup.getStatus();
            status = new Status(status.getId(), status.getTitle(), status.getColor(), status.getCategory());
            objectiveGroup.setStatus(status);
        }
        return objectiveIds;
    }

    private void processObjectiveList(List<ObjectiveServiceVO> objectiveServiceVOList, Map<String, List<BaseItem>> objectiveListForSessions, Map<String, ModuleConfiguration> objectiveMenuPermissionsMap, boolean isMockingMode, boolean isOkrEnabled) {
        for (ObjectiveServiceVO objectiveServiceVO : objectiveServiceVOList) {
            List<BaseItem> objectivesList = objectiveListForSessions.get(objectiveServiceVO.getSessionId());
            ModuleConfiguration objectiveMenuPermission = objectiveMenuPermissionsMap.get(objectiveServiceVO.getSessionId());
            if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
                isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
            }
            if (!PropertyValidator.isValid(objectivesList)) continue;
            for (BaseItem objective : objectivesList) {
                if (PropertyValidator.isValid((Object)objective.getStatus())) {
                    Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                    objective.setStatus(status);
                }
                if (!isMockingMode) {
                    objective.links(objectiveServiceVO.getGroupBaseItemIds());
                }
                if (!PropertyValidator.isValid((Collection)((Collection)objectiveServiceVO.getObjectiveMappedByGroup().get(objective.getId())))) continue;
                List parents = (List)objectiveServiceVO.getObjectiveMappedByGroup().get(objective.getId());
                for (BaseItem parent : parents) {
                    this.setBaseItemInParent(parent, objective);
                    if (!isOkrEnabled) continue;
                    for (int i = objective.getBaseItemLinks().size() - 1; i >= 0; --i) {
                        BaseItemLink link = (BaseItemLink)objective.getBaseItemLinks().get(i);
                        if (link.isArchive()) {
                            objective.getBaseItemLinks().remove(i);
                            continue;
                        }
                        if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getLinkType()) || link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode())) continue;
                        objectiveServiceVO.getKeyResultsIds().add(new ObjectId(link.getBaseItemId()));
                        objectiveServiceVO.getKeyResultMappedByObjective().put(link.getBaseItemId(), objective);
                    }
                }
            }
        }
    }

    private void processKrData(List<ObjectiveServiceVO> objectiveServiceVOList, Map<String, List<BaseItem>> kRListForSessions, Map<String, ModuleConfiguration> objectiveMenuPermissionsMap, boolean isOkrEnabled, boolean isMockingMode) {
        for (ObjectiveServiceVO objectiveServiceVO : objectiveServiceVOList) {
            ModuleConfiguration objectiveMenuPermission = objectiveMenuPermissionsMap.get(objectiveServiceVO.getSessionId());
            if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
                isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
            }
            if (!isOkrEnabled || !PropertyValidator.isValid((Collection)objectiveServiceVO.getKeyResultsIds())) continue;
            List<BaseItem> keyResultsList = kRListForSessions.get(objectiveServiceVO.getSessionId());
            keyResultsList.forEach(keyResult -> {
                if (!isMockingMode) {
                    keyResult.links(objectiveServiceVO.getGroupBaseItemIds());
                }
                if (PropertyValidator.isValid((Object)keyResult.getStatus())) {
                    Status status = new Status(keyResult.getStatus().getId(), keyResult.getStatus().getTitle(), keyResult.getStatus().getColor(), keyResult.getStatus().getCategory());
                    keyResult.setStatus(status);
                }
                this.setBaseItemInParent((BaseItem)objectiveServiceVO.getKeyResultMappedByObjective().get(keyResult.getId()), keyResult);
            });
        }
    }

    private Map<String, List<BaseItem>> fetchObjectivesForBoards(List<String> sessionIds, Boolean isOkrEnabled, String tenant, Boolean isMockingMode) {
        List objectiveMenuPermissions = this.objectiveMenuPermissionsRepository.findBySessionIdIn(sessionIds);
        Map<String, ModuleConfiguration> objectiveMenuPermissionsMap = objectiveMenuPermissions.stream().filter(obj -> sessionIds.contains(obj.getSessionId())).collect(Collectors.toMap(ModuleConfiguration::getSessionId, obj -> obj, (a, b) -> a));
        HashMap objectiveAndOkrBaseItemLinks = new HashMap();
        HashMap baseItemLinks = new HashMap();
        HashMap groupBaseItemId = new HashMap();
        this.objectiveServiceDAO.loadBaseItemLinksBySessionIdInAndType(sessionIds, objectiveAndOkrBaseItemLinks, baseItemLinks, groupBaseItemId);
        Map objectiveGroupListAgainstSessionId = this.objectiveServiceDAO.findObjectiveGroupListForSessionByBaseItemLinks(baseItemLinks);
        ArrayList<ObjectiveServiceVO> objectiveServiceVOList = new ArrayList<ObjectiveServiceVO>(sessionIds.size());
        for (String sessionId : sessionIds) {
            ObjectiveServiceVO vo = new ObjectiveServiceVO();
            vo.setSessionId(sessionId);
            vo.setTenant(tenant);
            vo.setBaseItemLinks(baseItemLinks.getOrDefault(sessionId, Collections.emptyList()));
            vo.setObjectiveAndOkrBaseItemLinks(objectiveAndOkrBaseItemLinks.getOrDefault(sessionId, Collections.emptyList()));
            vo.setGroupBaseItemIds(groupBaseItemId.getOrDefault(sessionId, Collections.emptyMap()));
            List objectiveIds = this.filterObjectiveIdsWithLinkedItems(vo.getBaseItemLinks(), vo.getObjectiveMappedByGroup(), (List)objectiveGroupListAgainstSessionId.get(sessionId), vo.getGroupBaseItemIds());
            vo.setObjectiveIds(objectiveIds);
            objectiveServiceVOList.add(vo);
        }
        Map objectiveListForSessions = this.objectiveServiceDAO.loadBaseItemsForAllSessions(objectiveServiceVOList, false);
        this.processObjectiveList(objectiveServiceVOList, objectiveListForSessions, objectiveMenuPermissionsMap, isMockingMode.booleanValue(), isOkrEnabled.booleanValue());
        if (Boolean.TRUE.equals(isOkrEnabled)) {
            Map krListForSessions = this.objectiveServiceDAO.loadBaseItemsForAllSessions(objectiveServiceVOList, true);
            this.processKrData(objectiveServiceVOList, krListForSessions, objectiveMenuPermissionsMap, isOkrEnabled.booleanValue(), isMockingMode.booleanValue());
        }
        this.fetchObjGroupsWithLinkedItemsForAllSessions(objectiveGroupListAgainstSessionId, objectiveServiceVOList);
        return objectiveGroupListAgainstSessionId;
    }

    public ObjectiveCustomView getCustomViewIdByKey(String key) throws Exception {
        return this.objectiveCustomViewRepository.findByKey(key);
    }

    private List<BaseItem> fetchObjectives(Boolean isSolutionBoard, String sessionId, Boolean isOkrEnabled, List<BaseItemLink> itemLinks, String requestId, Boolean isMockingMode, String viewId, String viewKey) {
        ArrayList<BaseItemLink> objectiveAndOkrBaseItemLinks;
        List<Object> objectiveGroupList;
        block34: {
            block35: {
                List list;
                List all;
                ArrayList<BaseItemLink> baseItemLinks;
                objectiveGroupList = new ArrayList<BaseItem>();
                ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
                objectiveAndOkrBaseItemLinks = new ArrayList<BaseItemLink>();
                HashMap<String, BaseItemLink> groupBaseItemIds = new HashMap<String, BaseItemLink>();
                ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessionId);
                if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
                    isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
                }
                if (itemLinks == null) {
                    baseItemLinks = new ArrayList<BaseItemLink>();
                    all = this.loadBaseItemLinksBySessionIdAndType(isSolutionBoard, sessionId);
                    for (BaseItemLink baseItemLink : all) {
                        if (PropertyValidator.isValid((Object)baseItemLink) && PropertyValidator.isValid((Object)baseItemLink.getItemId())) {
                            objectiveAndOkrBaseItemLinks.add(baseItemLink);
                        }
                        if (PropertyValidator.isValid((Object)baseItemLink.getType()) && baseItemLink.getType().equals("Objective-Group")) {
                            baseItemLinks.add(baseItemLink);
                        }
                        groupBaseItemIds.put(baseItemLink.getId(), baseItemLink);
                    }
                } else {
                    baseItemLinks = new ArrayList();
                    all = itemLinks;
                    for (BaseItemLink baseItemLink : all) {
                        if (PropertyValidator.isValid((Object)baseItemLink) && PropertyValidator.isValid((Object)baseItemLink.getItemId())) {
                            objectiveAndOkrBaseItemLinks.add(baseItemLink);
                        }
                        if (PropertyValidator.isValid((Object)baseItemLink.getType()) && baseItemLink.getType().equals("Objective-Group")) {
                            baseItemLinks.add(baseItemLink);
                        }
                        groupBaseItemIds.put(baseItemLink.getId(), baseItemLink);
                    }
                }
                if (!PropertyValidator.isValid(baseItemLinks)) break block34;
                if (viewId == null && viewKey == null) {
                    objectiveGroupList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
                } else {
                    ObjectiveCustomView customView = null;
                    if (viewId == null && viewKey != null) {
                        customView = this.objectiveCustomViewRepository.findByKey(viewKey);
                    } else if (viewId != null) {
                        customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)viewId));
                    }
                    if (viewId != null && viewId.equals("-1")) {
                        objectiveGroupList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
                        ArrayList<BaseItem> arrayList = new ArrayList<BaseItem>();
                        if (PropertyValidator.isValid(objectiveGroupList)) {
                            for (BaseItem baseItem : objectiveGroupList) {
                                BaseItemLink cvLink;
                                if (!PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks()) || (cvLink = (BaseItemLink)baseItem.getBaseItemLinks().stream().filter(link -> link.getType() != null && link.getType().equals("custom-view")).findFirst().orElse(null)) != null) continue;
                                arrayList.add(baseItem);
                            }
                        }
                        objectiveGroupList = arrayList;
                    } else if (PropertyValidator.isValid(customView)) {
                        ArrayList<ObjectId> arrayList = new ArrayList<ObjectId>();
                        if (PropertyValidator.isValid((Collection)customView.getBaseItemLinks())) {
                            for (BaseItemLink baseItemLink : customView.getBaseItemLinks()) {
                                if (!PropertyValidator.isValid((Object)baseItemLink) || !baseItemLink.getType().equals("objective-group")) continue;
                                arrayList.add(new ObjectId(baseItemLink.getBaseItemId()));
                            }
                        }
                        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                        String string = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemLinks").in(baseItemLinks));
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(arrayList));
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").in(new Object[]{string}));
                        query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
                        objectiveGroupList = this.mongoTemplate.find(query, BaseItem.class);
                    }
                }
                LOGGER.debug("Objective Groups of size " + objectiveGroupList.size() + " Found");
                if (!PropertyValidator.isValid(objectiveGroupList)) break block34;
                if (isMockingMode.booleanValue()) break block35;
                LOGGER.debug("Going to fetch Objectives With Linked Items With in a Group............");
                HashMap<String, List> objectiveMappedByGroup = new HashMap<String, List>();
                for (BaseItem baseItem : objectiveGroupList) {
                    baseItem.links(groupBaseItemIds);
                    for (Object link3 : baseItem.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link3.getBaseItemId()) || link3.isArchive()) continue;
                        if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(link3.getBaseItemId())))) {
                            objectiveMappedByGroup.put(link3.getBaseItemId(), new ArrayList());
                        }
                        List objGroups = (List)objectiveMappedByGroup.get(link3.getBaseItemId());
                        objGroups.add(baseItem);
                        objectiveMappedByGroup.put(link3.getBaseItemId(), objGroups);
                        objectiveIds.add(new ObjectId(link3.getBaseItemId()));
                    }
                    Status status = baseItem.getStatus();
                    if (!PropertyValidator.isValid((Object)status)) continue;
                    Status status2 = new Status(status.getId(), status.getTitle(), status.getColor(), status.getCategory());
                    baseItem.setStatus(status2);
                }
                if (!PropertyValidator.isValid(objectiveIds) || !PropertyValidator.isValid((Collection)(list = this.loadObjectivesByBaseItemId(objectiveIds)))) break block34;
                HashMap<String, BaseItem> hashMap = new HashMap<String, BaseItem>();
                ArrayList<ObjectId> arrayList = new ArrayList<ObjectId>();
                for (BaseItem objective : list) {
                    if (PropertyValidator.isValid((Object)objective.getStatus())) {
                        Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                        objective.setStatus(status);
                    }
                    if (!isMockingMode.booleanValue()) {
                        objective.links(groupBaseItemIds);
                    }
                    if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(objective.getId())))) continue;
                    List parents = (List)objectiveMappedByGroup.get(objective.getId());
                    for (BaseItem parent : parents) {
                        this.setBaseItemInParent(parent, objective);
                        if (!isOkrEnabled.booleanValue()) continue;
                        for (int i = objective.getBaseItemLinks().size() - 1; i >= 0; --i) {
                            BaseItemLink link4 = (BaseItemLink)objective.getBaseItemLinks().get(i);
                            if (link4.isArchive()) {
                                objective.getBaseItemLinks().remove(i);
                                continue;
                            }
                            if (!PropertyValidator.isValid((Object)link4) || !PropertyValidator.isValid((Object)link4.getBaseItemId()) || link4.isArchive() || !PropertyValidator.isValid((Object)link4.getLinkType()) || link4.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || link4.getLinkType().equals(EnumKendis.CHILD_OKR.getCode())) continue;
                            arrayList.add(new ObjectId(link4.getBaseItemId()));
                            hashMap.put(link4.getBaseItemId(), objective);
                        }
                    }
                }
                if (!isOkrEnabled.booleanValue() || !PropertyValidator.isValid(arrayList)) break block34;
                List keyResultsList = this.loadObjectivesByBaseItemId(arrayList);
                keyResultsList.forEach(keyResult -> {
                    if (!isMockingMode.booleanValue()) {
                        keyResult.links((Map)groupBaseItemIds);
                    }
                    if (PropertyValidator.isValid((Object)keyResult.getStatus())) {
                        Status status = new Status(keyResult.getStatus().getId(), keyResult.getStatus().getTitle(), keyResult.getStatus().getColor(), keyResult.getStatus().getCategory());
                        keyResult.setStatus(status);
                    }
                    this.setBaseItemInParent((BaseItem)keyResultMappedByObjective.get(keyResult.getId()), keyResult);
                });
                break block34;
            }
            for (BaseItem baseItem : objectiveGroupList) {
                Status status3 = baseItem.getStatus();
                status3 = new Status(status3.getId(), status3.getTitle(), status3.getColor(), status3.getCategory());
                baseItem.setStatus(status3);
            }
        }
        if (!isMockingMode.booleanValue()) {
            if (requestId != null) {
                objectiveAndOkrBaseItemLinks.sort(Comparator.comparing(BaseItemLink::getSequence));
                this.fetchObjGroupsWithLinkedItemsInThread(objectiveGroupList, objectiveAndOkrBaseItemLinks, requestId);
            } else {
                this.fetchObjGroupsWithLinkedItems(objectiveGroupList, objectiveAndOkrBaseItemLinks);
            }
        }
        return objectiveGroupList;
    }

    private List<BaseItem> fetchObjectivesListAndKR(Boolean isSolutionBoard, String sessionId) {
        List<Object> objectiveList = new ArrayList<BaseItem>();
        ArrayList<BaseItemLink> objectiveAndOkrBaseItemLinks = new ArrayList<BaseItemLink>();
        HashMap<String, BaseItemLink> groupBaseItemIds = new HashMap<String, BaseItemLink>();
        ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessionId);
        Boolean isOkrEnabled = false;
        if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
        }
        ArrayList<BaseItemLink> baseItemLinks = new ArrayList<BaseItemLink>();
        List all = this.loadBaseItemLinksBySessionIdAndType(isSolutionBoard, sessionId);
        for (BaseItemLink baseItemLink : all) {
            if (PropertyValidator.isValid((Object)baseItemLink) && PropertyValidator.isValid((Object)baseItemLink.getItemId())) {
                objectiveAndOkrBaseItemLinks.add(baseItemLink);
            }
            if (PropertyValidator.isValid((Object)baseItemLink.getType()) && (baseItemLink.getType().equals("Objective") || baseItemLink.getType().equals("KR"))) {
                baseItemLinks.add(baseItemLink);
            }
            groupBaseItemIds.put(baseItemLink.getId(), baseItemLink);
        }
        if (PropertyValidator.isValid(baseItemLinks)) {
            objectiveList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
            LOGGER.debug("Objective Groups of size " + objectiveList.size() + " Found");
        }
        return objectiveList;
    }

    private void fetchObjGroupsWithLinkedItemsInThread(List<BaseItem> objectiveGroupList, List<BaseItemLink> objectiveAndOkrBaseItemLinks, String requestId) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void fetchObjGroupsWithLinkedItemsForAllSessions(Map<String, List<BaseItem>> objectiveListForSessions, List<ObjectiveServiceVO> objectiveServiceVOList) {
        HashMap linkedItemsByItemIdForSessions = new HashMap();
        HashMap linkedItemsByJiraKeyOrTfsIdForSessions = new HashMap();
        this.fetchLinkedItemsForSessions(objectiveServiceVOList);
        objectiveServiceVOList.forEach(objectiveServiceVO -> {
            HashMap<String, Item> linkedItemsByItemId = new HashMap<String, Item>();
            HashMap<String, Item> linkedItemsByJiraKeyOrTfsId = new HashMap<String, Item>();
            List linkedItems = objectiveServiceVO.getLinkedItems();
            for (Item item : linkedItems) {
                linkedItemsByItemId.put(item.getId(), item);
                if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                    linkedItemsByJiraKeyOrTfsId.put(item.getJiraKey(), item);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                linkedItemsByJiraKeyOrTfsId.put(item.getTfsId(), item);
            }
            linkedItemsByItemIdForSessions.put(objectiveServiceVO.getSessionId(), linkedItemsByItemId);
            linkedItemsByJiraKeyOrTfsIdForSessions.put(objectiveServiceVO.getSessionId(), linkedItemsByJiraKeyOrTfsId);
        });
        for (String sessionId : objectiveListForSessions.keySet()) {
            List<BaseItem> objectiveGroupList = objectiveListForSessions.get(sessionId);
            Map linkedItemsByItemId = (Map)linkedItemsByItemIdForSessions.get(sessionId);
            Map linkedItemsByJiraKeyOrTfsId = (Map)linkedItemsByJiraKeyOrTfsIdForSessions.get(sessionId);
            for (BaseItem objGrp : objectiveGroupList) {
                if (!PropertyValidator.isValid((Collection)objGrp.getBaseItemList())) continue;
                for (BaseItem obj : objGrp.getBaseItemList()) {
                    this.setLinkedItemsMapForOkr(obj, linkedItemsByItemId, linkedItemsByJiraKeyOrTfsId, new HashMap());
                }
            }
        }
    }

    public HashMap<String, Object> fetchObjGroupsWithLinkedItems(List<BaseItem> objectiveGroupList, List<BaseItemLink> objectiveAndOkrBaseItemLinks) {
        HashMap activeBoardItemsMap = new HashMap();
        HashMap<String, Object> objAndKrLinkedItemsMap = new HashMap<String, Object>();
        activeBoardItemsMap = this.fetchLinkedItems(null, objectiveAndOkrBaseItemLinks);
        HashMap<String, Item> linkedItemsByItemId = new HashMap<String, Item>();
        HashMap<String, Item> linkedItemsByJiraKeyOrTfsId = new HashMap<String, Item>();
        List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
        if (PropertyValidator.isValid((Collection)linkedItems)) {
            HashMap<String, Integer> baseItemLinkOrder = new HashMap<String, Integer>();
            for (int i = 0; i < objectiveAndOkrBaseItemLinks.size(); ++i) {
                baseItemLinkOrder.put(objectiveAndOkrBaseItemLinks.get(i).getItemId(), i);
            }
            linkedItems.sort(Comparator.comparingInt(item -> baseItemLinkOrder.getOrDefault(item.getId(), Integer.MAX_VALUE)));
            activeBoardItemsMap.put("linkedItems", linkedItems);
        }
        for (Item item2 : linkedItems) {
            linkedItemsByItemId.put(item2.getId(), item2);
            if (PropertyValidator.isValid((Object)item2.getJiraKey())) {
                linkedItemsByJiraKeyOrTfsId.put(item2.getJiraKey(), item2);
                continue;
            }
            if (!PropertyValidator.isValid((Object)item2.getTfsId())) continue;
            linkedItemsByJiraKeyOrTfsId.put(item2.getTfsId(), item2);
        }
        for (BaseItem objGrp : objectiveGroupList) {
            if (!PropertyValidator.isValid((Collection)objGrp.getBaseItemList())) continue;
            for (BaseItem obj : objGrp.getBaseItemList()) {
                this.setLinkedItemsMapForOkr(obj, linkedItemsByItemId, linkedItemsByJiraKeyOrTfsId, objAndKrLinkedItemsMap);
            }
        }
        return objAndKrLinkedItemsMap;
    }

    public void setLinkedItemsMapForOkr(BaseItem obj, Map<String, Item> linkedItemsByItemId, Map<String, Item> linkedItemsByJiraKeyOrTfsId, HashMap<String, Object> objAndKrLinkedItemsMap) {
        if (!PropertyValidator.isValid((Object)objAndKrLinkedItemsMap.get(obj.getId()))) {
            HashMap<String, Cloneable> objectiveLinkedItemsMap = new HashMap<String, Cloneable>();
            ArrayList<Item> objLinkedItems = new ArrayList<Item>();
            ArrayList<String> objLinkedItemIds = new ArrayList<String>();
            HashMap objLinkedItemsById = new HashMap();
            List links = obj.getBaseItemLinks().stream().filter(Objects::nonNull).sorted(Comparator.comparing(BaseItemLink::getSequence)).collect(Collectors.toList());
            obj.setBaseItemLinks(links);
            if (PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                for (BaseItemLink baseItemLink : obj.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)baseItemLink.getItemId()) || baseItemLink.isArchive()) continue;
                    objLinkedItemIds.add(baseItemLink.getItemId());
                    Boolean itemAdded = false;
                    Item item = linkedItemsByItemId.get(baseItemLink.getItemId());
                    if (PropertyValidator.isValid((Object)item)) {
                        objLinkedItems.add(item);
                        itemAdded = true;
                    }
                    if (PropertyValidator.isValid((Object)baseItemLink.getLinkedItemById()) && !itemAdded.booleanValue()) {
                        HashMap linkedItemById = (HashMap)baseItemLink.getLinkedItemById();
                        String key = "";
                        ArrayList linkedItemByIdValues = linkedItemById.values().stream().collect(Collectors.toCollection(ArrayList::new));
                        if (PropertyValidator.isValid((Object)linkedItemById) && !PropertyValidator.isValid((Object)item)) {
                            if (PropertyValidator.isValid(linkedItemByIdValues.get(0))) {
                                HashMap linkedItemValue = (HashMap)linkedItemByIdValues.get(0);
                                if (PropertyValidator.isValid(linkedItemValue.get("jiraKey"))) {
                                    key = (String)linkedItemValue.get("jiraKey");
                                } else if (PropertyValidator.isValid(linkedItemValue.get("tfsId"))) {
                                    key = (String)linkedItemValue.get("tfsId");
                                }
                            }
                            item = linkedItemsByJiraKeyOrTfsId.get(key);
                        }
                        if (PropertyValidator.isValid((Object)item)) {
                            itemAdded = PropertyValidator.isValid(linkedItemById.get(item.getId())) || PropertyValidator.isValid(linkedItemById.get(item.getOriginItemId())) || PropertyValidator.isValid(linkedItemById.get(item.getDuplicateOfId()));
                        }
                        if (item != null && PropertyValidator.isValid((Object)key) && (key.equals(item.getTfsId()) || key.equals(item.getJiraKey()))) {
                            objLinkedItems.add(item);
                        } else if (!itemAdded.booleanValue()) {
                            objLinkedItemsById.putAll(baseItemLink.getLinkedItemById());
                        }
                    }
                    if (!PropertyValidator.isValid(objLinkedItems) || !PropertyValidator.isValid((Object)baseItemLink.getLinkedItem())) continue;
                    objLinkedItems.add(baseItemLink.getLinkedItem());
                }
                objectiveLinkedItemsMap.put("linkedItems", objLinkedItems);
                objectiveLinkedItemsMap.put("linkedItemsIds", objLinkedItemIds);
                objectiveLinkedItemsMap.put("linkedItemsById", objLinkedItemsById);
                objAndKrLinkedItemsMap.put(obj.getId(), objectiveLinkedItemsMap);
                obj.setLinkedItems(objLinkedItems);
                obj.setLinkedItemsIds(objLinkedItemIds);
                obj.setLinkedItemsById(objLinkedItemsById);
            }
            if (PropertyValidator.isValid((Collection)obj.getBaseItemList())) {
                for (BaseItem kr : obj.getBaseItemList()) {
                    HashMap<String, Cloneable> krLinkedItemsMap = new HashMap<String, Cloneable>();
                    ArrayList<Item> krLinkedItems = new ArrayList<Item>();
                    ArrayList<String> krLinkedItemIds = new ArrayList<String>();
                    HashMap krLinkedItemsById = new HashMap();
                    if (!PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) continue;
                    kr.setBaseItemLinks(kr.getBaseItemLinks().stream().filter(Objects::nonNull).collect(Collectors.toList()));
                    kr.getBaseItemLinks().sort(Comparator.comparing(BaseItemLink::getSequence));
                    for (BaseItemLink baseItemLink : kr.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)baseItemLink.getItemId()) || baseItemLink.isArchive()) continue;
                        krLinkedItemIds.add(baseItemLink.getItemId());
                        Boolean itemAdded = false;
                        Item item = linkedItemsByItemId.get(baseItemLink.getItemId());
                        if (PropertyValidator.isValid((Object)item)) {
                            krLinkedItems.add(item);
                            itemAdded = true;
                        }
                        if (PropertyValidator.isValid((Object)baseItemLink.getLinkedItemById()) && !itemAdded.booleanValue()) {
                            HashMap linkedItemById = (HashMap)baseItemLink.getLinkedItemById();
                            String key = "";
                            ArrayList linkedItemByIdValues = linkedItemById.values().stream().collect(Collectors.toCollection(ArrayList::new));
                            if (PropertyValidator.isValid((Object)linkedItemById) && !PropertyValidator.isValid((Object)item)) {
                                if (PropertyValidator.isValid(linkedItemByIdValues.get(0))) {
                                    HashMap linkedItemValue = (HashMap)linkedItemByIdValues.get(0);
                                    if (PropertyValidator.isValid(linkedItemValue.get("jiraKey"))) {
                                        key = (String)linkedItemValue.get("jiraKey");
                                    } else if (PropertyValidator.isValid(linkedItemValue.get("tfsId"))) {
                                        key = (String)linkedItemValue.get("tfsId");
                                    }
                                }
                                item = linkedItemsByJiraKeyOrTfsId.get(key);
                            }
                            if (PropertyValidator.isValid((Object)item)) {
                                itemAdded = PropertyValidator.isValid(linkedItemById.get(item.getId())) || PropertyValidator.isValid(linkedItemById.get(item.getOriginItemId())) || PropertyValidator.isValid(linkedItemById.get(item.getDuplicateOfId()));
                            }
                            if (item != null && PropertyValidator.isValid((Object)key) && (key.equals(item.getTfsId()) || key.equals(item.getJiraKey()))) {
                                krLinkedItems.add(item);
                            } else if (!itemAdded.booleanValue()) {
                                krLinkedItemsById.putAll(baseItemLink.getLinkedItemById());
                            }
                        }
                        if (!PropertyValidator.isValid(krLinkedItems) || !PropertyValidator.isValid((Object)baseItemLink.getLinkedItem())) continue;
                        krLinkedItems.add(baseItemLink.getLinkedItem());
                    }
                    krLinkedItemsMap.put("linkedItems", krLinkedItems);
                    krLinkedItemsMap.put("linkedItemsIds", krLinkedItemIds);
                    krLinkedItemsMap.put("linkedItemsById", krLinkedItemsById);
                    objAndKrLinkedItemsMap.put(kr.getId(), krLinkedItemsMap);
                    kr.setLinkedItems(krLinkedItems);
                    kr.setLinkedItemsIds(krLinkedItemIds);
                    kr.setLinkedItemsById(krLinkedItemsById);
                }
            }
        }
    }

    private BaseItem fetchObjective(Boolean isSolutionBoard, String id, Boolean isOkrEnabled, Optional<String> requestId, Boolean isMockingMode) {
        BaseItem objective = new BaseItem();
        ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
        ArrayList<BaseItemLink> objectiveAndOkrBaseItemLinks = new ArrayList<BaseItemLink>();
        objective = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
        if (!PropertyValidator.isValid((Object)objective)) {
            return objective;
        }
        if (PropertyValidator.isValid((Object)objective.getStatus())) {
            Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
            objective.setStatus(status);
        }
        HashMap<String, BaseItem> objectiveMappedByGroup = new HashMap<String, BaseItem>();
        ArrayList<BaseItemLink> linksToRemove = new ArrayList<BaseItemLink>();
        List links = objective.getBaseItemLinks().stream().filter(Objects::nonNull).collect(Collectors.toList());
        objective.setBaseItemLinks(links);
        objective = (BaseItem)this.baseItemRepository.save((Object)objective);
        for (BaseItemLink link : objective.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)link)) continue;
            if (PropertyValidator.isValid((Object)link.getItemId())) {
                objectiveAndOkrBaseItemLinks.add(link);
            }
            if (!(!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getLinkType()) || link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode()) || link.getLinkType().equals(EnumKendis.PARENT_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode()) || EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()))) {
                objectiveMappedByGroup.put(link.getBaseItemId(), objective);
                objectiveIds.add(new ObjectId(link.getBaseItemId()));
            }
            if (!link.isArchive()) continue;
            linksToRemove.add(link);
        }
        if (linksToRemove.size() > 0) {
            objective.getBaseItemLinks().removeAll(linksToRemove);
        }
        List objectivesList = this.loadObjectivesByBaseItemId(objectiveIds);
        objectivesList.forEach(obj -> {
            if (PropertyValidator.isValid((Object)obj.getStatus())) {
                Status status = new Status(obj.getStatus().getId(), obj.getStatus().getTitle(), obj.getStatus().getColor(), obj.getStatus().getCategory());
                obj.setStatus(status);
            }
            this.setBaseItemInParent((BaseItem)objectiveMappedByGroup.get(obj.getId()), obj);
            if (PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                obj.getBaseItemLinks().forEach(link -> {
                    if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getItemId())) {
                        objectiveAndOkrBaseItemLinks.add((BaseItemLink)link);
                    }
                });
            }
        });
        List objectiveBaseItemLinks = this.findByBaseItemId(objective.getId());
        List selectedLinkedGroups = this.baseItemRepository.findGroupsByBaseItemLinksIn(objectiveBaseItemLinks);
        objective.setSelectedLinkedGroups(selectedLinkedGroups);
        if (!isMockingMode.booleanValue()) {
            if (PropertyValidator.isValid(requestId) && requestId.isPresent()) {
                this.fetchObjectiveWithLinkedItemsInThread(objective, objectiveAndOkrBaseItemLinks, requestId);
            } else {
                this.fetchObjectiveWithLinkedItems(objective, objectiveAndOkrBaseItemLinks);
            }
        } else {
            this.calculationForSingleItem(objective, requestId);
        }
        return objective;
    }

    private void fetchObjectiveWithLinkedItemsInThread(BaseItem objective, List<BaseItemLink> objectiveAndOkrBaseItemLinks, Optional<String> requestId) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private HashMap<String, Object> fetchObjectiveWithLinkedItems(BaseItem objective, List<BaseItemLink> objectiveAndOkrBaseItemLinks) {
        HashMap activeBoardItemsMap = new HashMap();
        HashMap<String, Object> objAndKrLinkedItemsMap = new HashMap<String, Object>();
        activeBoardItemsMap = this.fetchLinkedItems(null, objectiveAndOkrBaseItemLinks);
        HashMap<String, Item> linkedItemsByItemId = new HashMap<String, Item>();
        HashMap<String, Item> linkedItemsByJiraKeyOrTfsId = new HashMap<String, Item>();
        List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
        for (Item item : linkedItems) {
            linkedItemsByItemId.put(item.getId(), item);
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                linkedItemsByJiraKeyOrTfsId.put(item.getJiraKey(), item);
                continue;
            }
            if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
            linkedItemsByJiraKeyOrTfsId.put(item.getTfsId(), item);
        }
        this.setLinkedItemsMapForOkr(objective, linkedItemsByItemId, linkedItemsByJiraKeyOrTfsId, objAndKrLinkedItemsMap);
        return objAndKrLinkedItemsMap;
    }

    public void setBaseItemInParent(BaseItem parent, BaseItem keyResult) {
        List baseItemList = parent.getBaseItemList();
        if (PropertyValidator.isValid((Collection)baseItemList) && baseItemList.size() > 0) {
            baseItemList.add(keyResult);
        } else {
            ArrayList<BaseItem> keyResults = new ArrayList<BaseItem>();
            keyResults.add(keyResult);
            parent.setBaseItemList(keyResults);
        }
    }

    public List<BaseItem> loadObjectivesByBaseItemId(List<ObjectId> baseItemIds) {
        Query query = new Query();
        Sort sort = new Sort(Sort.Direction.ASC, new String[]{"sequence"});
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(baseItemIds)).with(sort);
        return this.mongoTemplate.find(query, BaseItem.class);
    }

    public List<BaseItemLink> loadBaseItemLinksBySessionIdAndType(Boolean isSolutionBoard, String sessionId) {
        ArrayList<String> linkTypeCodes = new ArrayList<String>();
        linkTypeCodes.add(EnumKendis.ART_LINK_OBJECTIVE.getCode());
        linkTypeCodes.add(EnumKendis.SESSION_LINK_OBJECTIVE.getCode());
        linkTypeCodes.add(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode());
        linkTypeCodes.add(EnumKendis.CHILD_GROUP_OBJECTIVE.getCode());
        linkTypeCodes.add(EnumKendis.PARENT_OBJECTIVE.getCode());
        linkTypeCodes.add(EnumKendis.CHILD_OBJECTIVE.getCode());
        linkTypeCodes.add(EnumKendis.PARENT_OKR.getCode());
        linkTypeCodes.add(EnumKendis.CHILD_OKR.getCode());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkType").in(linkTypeCodes));
        if (isSolutionBoard.booleanValue()) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionId").is((Object)sessionId));
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        }
        return this.mongoTemplate.find(query, BaseItemLink.class);
    }

    public HashMap<String, Object> loadObjectivesTemplate() {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        ItemType itemType = this.itemTypeRepository.findByTitle(EnumKendis.OBJECTIVE.getCode());
        ItemTypeScheme itemTypeScheme = new ItemTypeScheme();
        if (itemType == null) {
            ItemType type1 = new ItemType();
            type1.setTitle(EnumKendis.OBJECTIVE.getCode());
            itemType = (ItemType)this.itemTypeRepository.save((Object)type1);
            itemTypeScheme.setItemType(itemType);
            itemTypeScheme.setWorkflow(null);
        }
        ArrayList<ItemType> itemTypeList = new ArrayList<ItemType>();
        itemTypeList.add(itemType);
        responseData.put("itemTypeList", itemTypeList);
        FieldTemplate template = this.fieldTemplateRepository.findByType("Objective");
        if (template == null) {
            LOGGER.debug("NO Template Found for Objectives Creating New Template....");
            template = new FieldTemplate();
            List<Object> fields = new ArrayList<Fields>();
            fields.add(new Fields("3", "Title", "simpleEditor", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("1", "BV Plan", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("2", "BV Actual", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields = this.fieldsRepository.save(fields);
            LOGGER.debug("Configured fields for Objectives Template");
            template.setConfiguredFields(fields);
            template.setType("Objective");
            template = (FieldTemplate)this.fieldTemplateRepository.save((Object)template);
            LOGGER.debug("Template Created For Objectives.");
            itemTypeScheme.setFieldsTemplate(template);
            this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
        }
        LOGGER.debug("Returning Template for Objectives");
        LOGGER.debug("Preparing Response Data");
        responseData.put("template", template);
        return responseData;
    }

    @Transactional
    public void deleteObjectiveById(HashMap<String, String> requestBody) throws Exception {
        try {
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            HashMap pushMeta = new HashMap();
            HashMap<String, BaseItem> dataMap = new HashMap<String, BaseItem>();
            HashMap objEmailContent = new HashMap();
            Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            ObjectMapper mapper = new ObjectMapper();
            6 T = new /* Unavailable Anonymous Inner Class!! */;
            if (requestBody.containsKey("metaMap")) {
                pushMeta = (HashMap)gson.fromJson(requestBody.get("metaMap"), T.getType());
            }
            if (!PropertyValidator.isValid((Object)requestBody.get("objId"))) {
                return;
            }
            BaseItem objective = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)requestBody.get("objId")));
            if (PropertyValidator.isValid((Object)objective) && PropertyValidator.isValid((Object)objective.getItemType()) && EnumKendis.GROUP_OBJECTIVE.getCode().equals(objective.getItemType().getTitle()) && objective.getIsDefaultGroup().booleanValue()) {
                return;
            }
            HashSet<String> recepientEmails = new HashSet<String>();
            recepientEmails.add(objective.getCreatedBy());
            String isObjectiveUnlink = requestBody.get("unlinkObjective");
            if (PropertyValidator.isValid((Object)isObjectiveUnlink)) {
                BaseItem parentKR = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)requestBody.get("groupId")));
                if (PropertyValidator.isValid((Object)parentKR) && PropertyValidator.isValid((Collection)parentKR.getBaseItemLinks()) && PropertyValidator.isValid((Object)objective) && PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) {
                    for (BaseItemLink krLink : parentKR.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)krLink) || !EnumKendis.PARENT_OKR.getCode().equals(krLink.getLinkType()) && !EnumKendis.CHILD_OBJECTIVE.getCode().equals(krLink.getLinkType()) || !objective.getId().equals(krLink.getBaseItemId()) || krLink.isArchive()) continue;
                        krLink.setArchive(true);
                        this.baseItemLinkRepository.save((Object)krLink);
                        break;
                    }
                    for (BaseItemLink objLink : objective.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)objLink) || !EnumKendis.CHILD_OKR.getCode().equals(objLink.getLinkType()) && !EnumKendis.PARENT_OBJECTIVE.getCode().equals(objLink.getLinkType()) || !parentKR.getId().equals(objLink.getBaseItemId()) || objLink.isArchive()) continue;
                        objLink.setArchive(true);
                        this.baseItemLinkRepository.save((Object)objLink);
                        break;
                    }
                }
                this.changeLogServiceImpl.updateBaseItem(objective.getId());
            } else if (objective.getType().contains("Objective") && !PropertyValidator.isValid((Object)isObjectiveUnlink)) {
                ObjectiveCustomView linkedView;
                objective.setArchive(true);
                this.baseItemRepository.save((Object)objective);
                String collectionId = null;
                for (BaseItemLink link : objective.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link)) continue;
                    if (!PropertyValidator.isValid((Object)link.getBaseItemId())) {
                        link.setArchive(true);
                        this.baseItemLinkRepository.save((Object)link);
                        dataMap.put("deletedItem", objective);
                    }
                    if (!EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) || "-1".equals(link.getSessionId())) continue;
                    collectionId = link.getSessionId();
                }
                String linkedCustomViewId = objective.getLinkedCustomView();
                if (PropertyValidator.isValid((Object)linkedCustomViewId) && PropertyValidator.isValid(collectionId) && PropertyValidator.isValid((Object)(linkedView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)linkedCustomViewId)))) && PropertyValidator.isValid((Collection)linkedView.getLinkedCollections())) {
                    String finalCollectionId = collectionId;
                    linkedView.getLinkedCollections().removeIf(id -> id.equals(finalCollectionId));
                    this.objectiveCustomViewRepository.save((Object)linkedView);
                }
                if (PropertyValidator.isValid((Object)objective.getItemType()) && EnumKendis.OBJECTIVE.getCode().equals(objective.getItemType().getTitle())) {
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkType").is((Object)EnumKendis.CHILD_GROUP_OBJECTIVE.getCode()));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").is((Object)objective.getId()));
                    List parentBaseItemLinks = this.mongoTemplate.find(query, BaseItemLink.class);
                    if (PropertyValidator.isValid((Collection)parentBaseItemLinks)) {
                        for (BaseItemLink link : parentBaseItemLinks) {
                            if (!PropertyValidator.isValid((Object)link) || link.isArchive()) continue;
                            link.setArchive(true);
                            this.baseItemLinkRepository.save((Object)link);
                        }
                    }
                }
                if (PropertyValidator.isValid((Object)objective.getItemType()) && objective.getItemType().getTitle().equals(EnumKendis.GROUP_OBJECTIVE.getCode())) {
                    AuditLog auditLogEntry = new AuditLog();
                    String sessionId = pushMeta.get("sessionId").toString();
                    BaseItemLink teamLink = objective.getBaseItemLinks().stream().filter(baseItemLink -> !"0".equals(baseItemLink.getTeamId()) && null != baseItemLink.getTeamId()).findAny().orElse(null);
                    if (PropertyValidator.isValid((Object)teamLink)) {
                        Team team = (Team)this.teamRepository.findOne((Serializable)((Object)teamLink.getTeamId()));
                        auditLogEntry.setEventType("OBJECTIVE_TEAM_GROUP_DELETE");
                        auditLogEntry.setEventText("Objective for Team " + team.getTitle() + " deleted");
                    } else {
                        auditLogEntry.setEventType("CUSTOM_OBJECTIVE_DELETE");
                        auditLogEntry.setEventText("Custom Objective " + objective.getTitle() + " deleted");
                    }
                    auditLogEntry.setSessionId(sessionId);
                    this.auditLogRepository.save((Object)auditLogEntry);
                }
            } else {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").is((Object)objective.getId()));
                List linkedItem = this.mongoTemplate.find(query, BaseItemLink.class);
                BaseItem group = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)requestBody.get("groupId")));
                if (PropertyValidator.isValid((Object)group)) {
                    for (BaseItemLink link : group.getBaseItemLinks()) {
                        for (BaseItemLink item : linkedItem) {
                            if (!link.getId().equals(item.getId())) continue;
                            item.setArchive(true);
                            this.baseItemLinkRepository.save((Object)item);
                            dataMap.put("deletedItem", objective);
                            dataMap.put("parentItem", group);
                        }
                    }
                }
                objective.setArchive(true);
                this.baseItemRepository.save((Object)objective);
            }
            if (!pushMeta.isEmpty()) {
                pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
                pushJson.put("metaMap", gson.toJson((Object)pushMeta));
            }
            pushJson.put("push", "Self");
            pushJson.put("action", "deleteObjective");
            pushJson.put("data", dataMap);
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                String err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Objective delete error " + e.getMessage());
            throw e;
        }
    }

    public HashMap<String, Object> removeObjectiveRelationFromSession(HashMap<String, String> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            BaseItem objective;
            String objectiveId = requestBody.get("objectiveId");
            String linkedCollectionId = requestBody.get("linkedCollectionId");
            if (PropertyValidator.isValid((Object)objectiveId) && PropertyValidator.isValid((Object)linkedCollectionId) && PropertyValidator.isValid((Object)(objective = this.baseItemRepository.findById(objectiveId)))) {
                ArrayList<BaseItemLink> baseItemLinksToRemove = new ArrayList<BaseItemLink>();
                for (BaseItemLink link : objective.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link) || !EnumKendis.LINKED_SESSION.getCode().equals(link.getLinkType()) || !linkedCollectionId.equals(link.getSessionId())) continue;
                    link.setArchive(true);
                    baseItemLinksToRemove.add(link);
                    this.baseItemLinkRepository.save((Object)link);
                }
                List updateBaseItemLinks = objective.getBaseItemLinks();
                updateBaseItemLinks.removeAll(baseItemLinksToRemove);
                objective.setBaseItemLinks(updateBaseItemLinks);
                response.put("updatedObjective", objective);
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Remove Objective Relation From Session Error " + e.getMessage());
            response.put("Error occurred at server end while removing PI association of current objective: ", e.getMessage());
            throw e;
        }
        return response;
    }

    @Transactional
    public void removeObjectiveRelation(HashMap<String, String> requestBody) {
        try {
            BaseItem objective;
            String objectiveId = requestBody.get("objectiveId");
            String linkedCollectionId = requestBody.get("linkedCollectionId");
            if (PropertyValidator.isValid((Object)objectiveId) && PropertyValidator.isValid((Object)linkedCollectionId) && PropertyValidator.isValid((Object)(objective = this.baseItemRepository.findById(objectiveId)))) {
                ArrayList<String> linkedGroupIds = new ArrayList<String>();
                for (BaseItemLink link : objective.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link)) continue;
                    if (EnumKendis.PARENT_GROUP_OBJECTIVE.getCode().equals(link.getLinkType()) && linkedCollectionId.equals(link.getSessionId()) && PropertyValidator.isValid((Object)link.getBaseItemId())) {
                        link.setArchive(true);
                        this.baseItemLinkRepository.save((Object)link);
                        linkedGroupIds.add(link.getBaseItemId());
                    }
                    if (!EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) || !linkedCollectionId.equals(link.getSessionId())) continue;
                    link.setArchive(true);
                    this.baseItemLinkRepository.save((Object)link);
                }
                if (PropertyValidator.isValid(linkedGroupIds)) {
                    List linkedGroups = this.baseItemRepository.findByIdIn(linkedGroupIds);
                    for (BaseItem linkedGroup : linkedGroups) {
                        if (!PropertyValidator.isValid((Object)linkedGroup)) continue;
                        for (BaseItemLink groupLink : linkedGroup.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)groupLink) || !EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(groupLink.getLinkType()) || !objectiveId.equals(groupLink.getBaseItemId())) continue;
                            groupLink.setArchive(true);
                            this.baseItemLinkRepository.save((Object)groupLink);
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Remove Objective Relation Error " + e.getMessage());
            throw e;
        }
    }

    public HashMap<String, Object> saveWeightsOfObjAndOkr(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String parentItemId = (String)requestBody.get("parentItemId");
            BaseItem parentItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)parentItemId));
            List listOfWeights = (List)requestBody.get("listOfWeights");
            for (Map item : listOfWeights) {
                String baseItemId = (String)item.get("baseItemId");
                Double baseItemWeight = Double.valueOf(item.get("baseItemWeight").toString());
                if (baseItemId.equals("-1")) {
                    parentItem.setLinkedCardWeights(baseItemWeight);
                    this.baseItemRepository.save((Object)parentItem);
                    response.put("parentItem", parentItem);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)baseItemId) || !PropertyValidator.isValid((Object)baseItemWeight)) continue;
                BaseItemLink newItemLink = new BaseItemLink();
                List baseItemList = parentItem.getBaseItemLinks();
                if (!PropertyValidator.isValid((Collection)baseItemList)) continue;
                for (BaseItemLink link : baseItemList) {
                    if (!PropertyValidator.isValid((Object)link) || !baseItemId.equals(link.getBaseItemId())) continue;
                    newItemLink = link;
                    newItemLink.setWeightage(baseItemWeight);
                    this.baseItemLinkRepository.save((Object)newItemLink);
                    break;
                }
                this.changeLogServiceImpl.updateBaseItem(parentItemId);
                response.put("parentItem", parentItem);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while saving weights of KR");
            throw e;
        }
        return response;
    }

    public HashMap<String, Object> linkToTeamsAndGroups(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            HashMap<String, Object> pushJson = new HashMap<String, Object>();
            HashMap pushMeta = new HashMap();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            ObjectMapper mapper = new ObjectMapper();
            7 T = new /* Unavailable Anonymous Inner Class!! */;
            String metaMap = (String)requestBody.get("metaMap");
            if (PropertyValidator.isValid((Object)metaMap)) {
                pushMeta = (HashMap)gson.fromJson(metaMap, T.getType());
            }
            String baseItemId = (String)requestBody.get("baseItemId");
            String sessionId = (String)requestBody.get("sessionId");
            ArrayList teamAndGroupBaseItemIds = (ArrayList)requestBody.get("teamAndGroupBaseItemIds");
            ArrayList teamsAndGroupOptionIds = (ArrayList)requestBody.get("teamsAndGroupOptionIds");
            BaseItem objective = this.fetchObjective(Boolean.valueOf(false), baseItemId, Boolean.valueOf(true), null, Boolean.valueOf(false));
            List teamsAndGroups = this.baseItemRepository.findByIdIn((List)teamAndGroupBaseItemIds);
            ArrayList unSelectedGroupIds = new ArrayList(teamsAndGroupOptionIds);
            unSelectedGroupIds.removeAll(teamAndGroupBaseItemIds);
            List unSelectedGroups = this.baseItemRepository.findByIdIn(unSelectedGroupIds);
            if (PropertyValidator.isValid((Object)objective)) {
                if (PropertyValidator.isValid((Collection)teamsAndGroups)) {
                    for (Object tG : teamsAndGroups) {
                        Boolean linkExists = false;
                        for (BaseItemLink tGLink : tG.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)tGLink.getBaseItemId()) || !tGLink.getBaseItemId().equals(baseItemId)) continue;
                            linkExists = true;
                            if (!tGLink.isArchive()) break;
                            tGLink.setArchive(false);
                            this.baseItemLinkRepository.save((Object)tGLink);
                            dataMap.put("linkedObjective", objective);
                            dataMap.put("linkedGroup", tG);
                            response.put("linkedObjective", objective);
                            response.put("linkedGroup", tG);
                            break;
                        }
                        if (linkExists.booleanValue()) continue;
                        BaseItemLink newLinkForGroup = new BaseItemLink();
                        BaseItemLink newLinkForObj = new BaseItemLink();
                        newLinkForGroup.setSessionId(sessionId);
                        newLinkForGroup.setBaseItemId(baseItemId);
                        newLinkForGroup.setLinkType(EnumKendis.CHILD_GROUP_OBJECTIVE.getCode());
                        newLinkForGroup = (BaseItemLink)this.baseItemLinkRepository.save((Object)newLinkForGroup);
                        List grpBaseItemLinks = tG.getBaseItemLinks();
                        grpBaseItemLinks.add(newLinkForGroup);
                        tG.setBaseItemLinks(grpBaseItemLinks);
                        newLinkForObj.setSessionId(sessionId);
                        newLinkForObj.setBaseItemId(tG.getId());
                        newLinkForObj.setLinkType(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode());
                        newLinkForObj = (BaseItemLink)this.baseItemLinkRepository.save((Object)newLinkForObj);
                        List objBaseItemLinks = objective.getBaseItemLinks();
                        objBaseItemLinks.add(newLinkForObj);
                        objective.setBaseItemLinks(objBaseItemLinks);
                        dataMap.put("linkedObjective", objective);
                        dataMap.put("linkedGroup", tG);
                        response.put("linkedObjective", objective);
                        response.put("linkedGroup", tG);
                    }
                    teamsAndGroups = this.baseItemRepository.save((Iterable)teamsAndGroups);
                    objective = (BaseItem)this.baseItemRepository.save((Object)objective);
                    response.put("teamsAndGroups", teamsAndGroups);
                    dataMap.put("teamsAndGroups", teamsAndGroups);
                } else {
                    response.put("error", "Selected Groups not exist");
                }
            } else {
                response.put("error", "Objective does not exist");
            }
            if (unSelectedGroups.size() > 0) {
                ArrayList<BaseItemLink> linksToRemove = new ArrayList<BaseItemLink>();
                for (BaseItem group : unSelectedGroups) {
                    for (BaseItemLink gLink : group.getBaseItemLinks()) {
                        BaseItemLink biLink;
                        if (!PropertyValidator.isValid((Object)gLink.getBaseItemId()) || !gLink.getBaseItemId().equals(baseItemId) || !PropertyValidator.isValid((Object)(biLink = (BaseItemLink)this.baseItemLinkRepository.findOne((Serializable)((Object)gLink.getId()))))) continue;
                        biLink.setArchive(true);
                        this.baseItemLinkRepository.save((Object)biLink);
                        dataMap.put("unLinkedObjective", objective);
                        dataMap.put("unLinkedGroup", group);
                        response.put("unLinkedObjective", objective);
                        response.put("unLinkedGroup", group);
                    }
                    for (BaseItemLink link : objective.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || !link.getBaseItemId().equals(group.getId())) continue;
                        link.setArchive(true);
                        linksToRemove.add(link);
                    }
                }
                this.baseItemLinkRepository.save(linksToRemove);
                this.changeLogServiceImpl.updateBaseItems(unSelectedGroupIds);
            }
            if (!pushMeta.isEmpty()) {
                pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
                pushJson.put("metaMap", gson.toJson((Object)pushMeta));
            }
            pushJson.put("push", "Self");
            pushJson.put("action", "linkToTeamAndGroups");
            pushJson.put("data", dataMap);
            try {
                PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
            }
            catch (JsonProcessingException e) {
                String err = StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while saving weights of KR");
            throw e;
        }
        return response;
    }

    private void fetchLinkedItemsForSessions(List<ObjectiveServiceVO> objectiveServiceVOList) {
        Map sessionMap = this.objectiveServiceDAO.findSessionsByBaseItemLinksOfAllSessions(objectiveServiceVOList);
        HashMap<String, Boolean> addFieldInItem = new HashMap<String, Boolean>();
        addFieldInItem.put("featureStoryPoints", false);
        this.externalEntitiesService.setActiveBoardItemsForAllSessions(sessionMap, objectiveServiceVOList, addFieldInItem);
        String tenant = PropertyValidator.isValid(objectiveServiceVOList) ? objectiveServiceVOList.get(0).getTenant() : null;
        objectiveServiceVOList.forEach(objectiveServiceVO -> {
            List linkedItems = objectiveServiceVO.getLinkedItems();
            if (PropertyValidator.isValid((Collection)linkedItems)) {
                LinkedList<String> parentIds = new LinkedList<String>();
                for (Item item : linkedItems) {
                    if (!item.getType().equals("Feature")) continue;
                    parentIds.add(item.getId());
                }
                objectiveServiceVO.setParentIds(parentIds);
            }
        });
        this.externalEntitiesService.fetchChildItemsGroupedByParentIdForSessions(objectiveServiceVOList, tenant);
        objectiveServiceVOList.forEach(objectiveServiceVO -> {
            Map parentChildItemsMap = objectiveServiceVO.getParentChildItemsMap();
            List linkedItems = objectiveServiceVO.getLinkedItems();
            if (PropertyValidator.isValid((Object)parentChildItemsMap)) {
                for (Item item : linkedItems) {
                    if (!item.getType().equals("Feature") || !PropertyValidator.isValid((Collection)((Collection)parentChildItemsMap.get(item.getId())))) continue;
                    item.setSubItems((List)parentChildItemsMap.get(item.getId()));
                }
            }
            objectiveServiceVO.setLinkedItems(linkedItems);
        });
    }

    public HashMap<String, Object> fetchLinkedItems(BaseItem objective, List<BaseItemLink> objectiveAndKrLinks) {
        HashMap activeBoardItemsMap = new HashMap();
        HashSet<String> sessionIds = new HashSet<String>();
        List<Object> baseItemLinks = new ArrayList();
        if (PropertyValidator.isValid((Object)objective)) {
            baseItemLinks = objective.getBaseItemLinks();
        } else if (PropertyValidator.isValid(objectiveAndKrLinks)) {
            baseItemLinks = objectiveAndKrLinks;
        }
        if (PropertyValidator.isValid(baseItemLinks)) {
            for (BaseItemLink baseItemLink : baseItemLinks) {
                if (!PropertyValidator.isValid((Object)baseItemLink.getSessionId())) continue;
                sessionIds.add(baseItemLink.getSessionId());
            }
        }
        List sessions = this.sessionRepository.findByIdIn(new ArrayList(sessionIds));
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("sessionBoards", false);
        hashMap.put("featureStoryPoints", false);
        activeBoardItemsMap = this.externalEntitiesService.setActiveBoardItems(objective, sessions, null, new HashMap(), objectiveAndKrLinks, hashMap);
        List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
        if (PropertyValidator.isValid((Collection)linkedItems)) {
            Map parentChildItemsMap;
            ArrayList<String> parentIds = new ArrayList<String>();
            for (Item item2 : linkedItems) {
                if (!item2.getType().equals("Feature")) continue;
                parentIds.add(item2.getId());
            }
            String tenant = null;
            if (PropertyValidator.isValid((Collection)sessions)) {
                tenant = ((Session)sessions.get(0)).getTenant();
            }
            if (PropertyValidator.isValid((Object)(parentChildItemsMap = this.externalEntitiesService.fetchChildItemsGroupedByParentId(parentIds, tenant)))) {
                for (Item item3 : linkedItems) {
                    if (!item3.getType().equals("Feature") || !PropertyValidator.isValid((Collection)((Collection)parentChildItemsMap.get(item3.getId())))) continue;
                    item3.setSubItems((List)parentChildItemsMap.get(item3.getId()));
                }
            }
            baseItemLinks.sort(Comparator.comparing(BaseItemLink::getSequence));
            HashMap<String, Integer> baseItemLinkOrder = new HashMap<String, Integer>();
            for (int i = 0; i < baseItemLinks.size(); ++i) {
                baseItemLinkOrder.put(((BaseItemLink)baseItemLinks.get(i)).getItemId(), i);
            }
            linkedItems.sort(Comparator.comparingInt(item -> baseItemLinkOrder.getOrDefault(item.getId(), Integer.MAX_VALUE)));
            activeBoardItemsMap.put("linkedItems", linkedItems);
        }
        if (PropertyValidator.isValid((Object)objective)) {
            List linkedItemIds = (List)activeBoardItemsMap.get("linkedItemsIds");
            HashMap linkedItemsById = (HashMap)activeBoardItemsMap.get("linkedItemsById");
            objective.setLinkedItems(linkedItems);
            objective.setLinkedItemsIds(linkedItemIds);
            objective.setLinkedItemsById((Map)linkedItemsById);
        }
        return activeBoardItemsMap;
    }

    public BaseItem fetchBaseItemsForObjective(HashMap<String, Object> requestBody) throws Exception {
        if (PropertyValidator.isValid((Object)requestBody.get("id"))) {
            String id = (String)requestBody.get("id");
            BaseItem item = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
            HashMap baseItemIdToLinksMap = (HashMap)requestBody.get("baseItemIdToLinksMap");
            List baseItems = new ArrayList();
            if (PropertyValidator.isValid((Object)baseItemIdToLinksMap)) {
                Set baseItemIds = baseItemIdToLinksMap.keySet();
                baseItems = this.baseItemRepository.findByIdIn(new ArrayList(baseItemIds));
                for (BaseItem baseItem : baseItems) {
                    String baseItemLink = (String)baseItemIdToLinksMap.get(baseItem.getId());
                    ObjectMapper map = new ObjectMapper();
                    BaseItemLink baseItemLinksWithLinkTypes = new BaseItemLink();
                    baseItemLinksWithLinkTypes = (BaseItemLink)map.readValue(baseItemLink, BaseItemLink.class);
                    baseItemLinksWithLinkTypes = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLinksWithLinkTypes);
                    if (PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
                        List oldAndNewLinks = baseItem.getBaseItemLinks();
                        oldAndNewLinks.add(baseItemLinksWithLinkTypes);
                        baseItem.setBaseItemLinks(oldAndNewLinks);
                        continue;
                    }
                    ArrayList<BaseItemLink> baseItemLinks = new ArrayList<BaseItemLink>();
                    baseItemLinks.add(baseItemLinksWithLinkTypes);
                    baseItem.setBaseItemLinks(baseItemLinks);
                }
                baseItems = this.baseItemRepository.save(baseItems);
            }
            this.fetchLinkedItems(item, null);
            this.fetchBaseItemList(item);
            return item;
        }
        return null;
    }

    private void fetchBaseItemList(BaseItem objective) {
        ArrayList<String> baseItemIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) {
            for (BaseItemLink baseItemLink : objective.getBaseItemLinks()) {
                if (baseItemLink.isArchive() || !PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !baseItemLink.getLinkType().equals(EnumKendis.PARENT_OKR.getCode())) continue;
                baseItemIds.add(baseItemLink.getBaseItemId());
            }
            List baseItemList = this.baseItemRepository.findByIdIn(baseItemIds);
            objective.setBaseItemList(baseItemList);
        }
    }

    public BaseItem fetchLinkedItemsForObjective(String id) {
        BaseItem objective = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)objective)) {
            this.fetchLinkedItems(objective, null);
            if (PropertyValidator.isValid((Object)objective.getStatus())) {
                Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                objective.setStatus(status);
            }
        } else {
            throw new KendisException("Objective not found.");
        }
        return objective;
    }

    public Boolean isBackLogItemLinked(String objId) {
        BaseItem objective = this.baseItemRepository.findById(objId);
        if (PropertyValidator.isValid((Object)objective)) {
            for (BaseItemLink link : objective.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || !EnumKendis.BACKLOG_ITEM.getCode().equals(link.getLinkType())) continue;
                return true;
            }
        }
        return false;
    }

    public Session enableOkr(Session body) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)body.getId()));
        if (!PropertyValidator.isValid((Object)session)) {
            throw new KendisException("Session not found.");
        }
        session.setOkrEnabled(body.getOkrEnabled());
        this.sessionRepository.save((Object)session);
        return session;
    }

    public SolutionBoard enableOkrForSolution(SolutionBoard body) {
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)body.getId()));
        if (!PropertyValidator.isValid((Object)solutionBoard)) {
            throw new KendisException("SolutionBoard not found.");
        }
        solutionBoard.setOkrEnabled(body.getOkrEnabled());
        this.solutionBoardRepository.save((Object)solutionBoard);
        return solutionBoard;
    }

    public Session enableUncommittedObj(Session body) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)body.getId()));
        if (!PropertyValidator.isValid((Object)session)) {
            throw new KendisException("Session not found.");
        }
        session.setUncommittedObjEnabled(body.getUncommittedObjEnabled());
        this.sessionRepository.save((Object)session);
        return session;
    }

    public SolutionBoard enableUncommittedObjForSolution(SolutionBoard body) {
        SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)body.getId()));
        if (!PropertyValidator.isValid((Object)solutionBoard)) {
            throw new KendisException("SolutionBoard not found.");
        }
        solutionBoard.setUncommittedObjEnabled(body.getUncommittedObjEnabled());
        this.solutionBoardRepository.save((Object)solutionBoard);
        return solutionBoard;
    }

    public HashMap<String, Object> getDefaultCustomViewWorkFlow() throws Exception {
        List themePriorities;
        Optional<StrategicThemesType> defaultType;
        List themesTypes;
        List customViewWorkFlows = this.workFlowRepository.findAllByWorkflowType(EnumKendis.STRATEGIC_THEME.getCode());
        if (!PropertyValidator.isValid((Collection)customViewWorkFlows)) {
            customViewWorkFlows.add(this.createDefaultCustomViewWorkflow());
        }
        if (!PropertyValidator.isValid((Collection)(themesTypes = this.strategicThemesTypeRepository.findAll()))) {
            themesTypes.addAll(this.createDefaultCustomViewTypes());
        }
        if (!(defaultType = themesTypes.stream().filter(StrategicThemesType::getDefault).findFirst()).isPresent()) {
            StrategicThemesType newDefaultType = new StrategicThemesType();
            newDefaultType.setTitle("Not Specified");
            newDefaultType.setDefault(Boolean.valueOf(true));
            newDefaultType = (StrategicThemesType)this.strategicThemesTypeRepository.save((Object)newDefaultType);
            themesTypes.add(newDefaultType);
        }
        if (!PropertyValidator.isValid((Collection)(themePriorities = this.strategicThemePriorityRepository.findAll()))) {
            themePriorities.addAll(this.createDefaultCustomViewPriorities());
        }
        List customViewStatuses = this.statusRepository.findByWorkFlow((WorkFlow)customViewWorkFlows.get(0));
        HashMap<String, Object> response = new HashMap<String, Object>();
        themesTypes.sort(Comparator.comparing(StrategicThemesType::getSequence));
        themePriorities.sort(Comparator.comparing(StrategicThemePriority::getSequence));
        response.put("statuses", customViewStatuses);
        response.put("workflow", customViewWorkFlows.get(0));
        response.put("themeTypes", themesTypes);
        response.put("themePriorities", themePriorities);
        response.put("success", true);
        return response;
    }

    public List<StrategicThemePriority> createDefaultCustomViewPriorities() throws Exception {
        List<StrategicThemePriority> themePriorities = Arrays.asList(this.createStrategicThemePriority("Critical"), this.createStrategicThemePriority("High"), this.createStrategicThemePriority("Medium"), this.createStrategicThemePriority("Low"), this.createStrategicThemePriority("Optional"));
        return this.strategicThemePriorityRepository.save(themePriorities);
    }

    private StrategicThemePriority createStrategicThemePriority(String title) {
        StrategicThemePriority priority = new StrategicThemePriority();
        priority.setTitle(title);
        return priority;
    }

    public List<StrategicThemesType> createDefaultCustomViewTypes() throws Exception {
        List<StrategicThemesType> themesTypes = Arrays.asList(this.createStrategicThemeType("Not Specified", true), this.createStrategicThemeType("Growth & Expansion", false), this.createStrategicThemeType("Operational Efficiency", false), this.createStrategicThemeType("Customer Experience & Engagement", false), this.createStrategicThemeType("Technology & Innovation", false), this.createStrategicThemeType("Regulatory & Compliance", false), this.createStrategicThemeType("Sustainability & Social Impact", false));
        return this.strategicThemesTypeRepository.save(themesTypes);
    }

    private StrategicThemesType createStrategicThemeType(String title, boolean isDefault) {
        StrategicThemesType type = new StrategicThemesType();
        type.setTitle(title);
        type.setDefault(Boolean.valueOf(isDefault));
        return type;
    }

    public WorkFlow createDefaultCustomViewWorkflow() throws Exception {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Strategic Theme Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType(EnumKendis.STRATEGIC_THEME.getCode());
        defaultScheme.setLegacyThemeEnabled(false);
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        List<Status> statuses = Arrays.asList(this.createStatus("ToDo", "Draft", defaultScheme), this.createStatus("ToDo", "Proposed", defaultScheme), this.createStatus("ToDo", "On Hold", defaultScheme), this.createStatus("InProgress", "In Progress", defaultScheme), this.createStatus("InProgress", "At Risk", defaultScheme), this.createStatus("Done", "Completed", defaultScheme), this.createStatus("Done", "Archived", defaultScheme));
        this.statusRepository.save(statuses);
        return defaultScheme;
    }

    private Status createStatus(String category, String title, WorkFlow defaultScheme) {
        Status status = new Status();
        status.setCategory(category);
        status.setTitle(title);
        status.setArchive(false);
        status.setWorkFlow(defaultScheme);
        return status;
    }

    public WorkFlow createDefaultObjectiveGroupWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Objective Group Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType(EnumKendis.GROUP_OBJECTIVE.getCode());
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (int j = 0; j < 3; ++j) {
            Status status;
            if (j == 0) {
                Status status2 = new Status();
                status2.setCategory("ToDo");
                status2.setArchive(false);
                status2.setWorkFlow(defaultScheme);
                status2.setTitle("Not Started");
                statusList.add(status2);
                continue;
            }
            if (j == 1) {
                for (int i = 0; i < 4; ++i) {
                    status = new Status();
                    status.setCategory("InProgress");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("On Track");
                    } else if (i == 1) {
                        status.setTitle("Off Track");
                    } else if (i == 2) {
                        status.setTitle("At Risk");
                    } else if (i == 3) {
                        status.setTitle("Requires Attention");
                    }
                    statusList.add(status);
                }
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                status = new Status();
                status.setCategory("Done");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                if (i == 0) {
                    status.setTitle("Achieved");
                } else if (i == 1) {
                    status.setTitle("Partially Achieved");
                } else if (i == 2) {
                    status.setTitle("Not Achieved");
                }
                statusList.add(status);
            }
        }
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    public WorkFlow createDefaultObjectiveWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Objective Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType(EnumKendis.OBJECTIVE.getCode());
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (int j = 0; j < 3; ++j) {
            Status status;
            if (j == 0) {
                Status status2 = new Status();
                status2.setCategory("ToDo");
                status2.setArchive(false);
                status2.setWorkFlow(defaultScheme);
                status2.setTitle("Not Started");
                statusList.add(status2);
                continue;
            }
            if (j == 1) {
                for (int i = 0; i < 4; ++i) {
                    status = new Status();
                    status.setCategory("InProgress");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("On Track");
                    } else if (i == 1) {
                        status.setTitle("Off Track");
                    } else if (i == 2) {
                        status.setTitle("At Risk");
                    } else if (i == 3) {
                        status.setTitle("Requires Attention");
                    }
                    statusList.add(status);
                }
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                status = new Status();
                status.setCategory("Done");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                if (i == 0) {
                    status.setTitle("Achieved");
                } else if (i == 1) {
                    status.setTitle("Partially Achieved");
                } else if (i == 2) {
                    status.setTitle("Not Achieved");
                }
                statusList.add(status);
            }
        }
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    public WorkFlow createDefaultKeyResultsWorkflow() {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle("Default Key Results Workflow");
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType(EnumKendis.OBJECTIVE_KEY_RESULT.getCode());
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (int j = 0; j < 3; ++j) {
            Status status;
            if (j == 0) {
                Status status2 = new Status();
                status2.setCategory("ToDo");
                status2.setArchive(false);
                status2.setWorkFlow(defaultScheme);
                status2.setTitle("Not Started");
                statusList.add(status2);
                continue;
            }
            if (j == 1) {
                for (int i = 0; i < 4; ++i) {
                    status = new Status();
                    status.setCategory("InProgress");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("On Track");
                    } else if (i == 1) {
                        status.setTitle("Off Track");
                    } else if (i == 2) {
                        status.setTitle("At Risk");
                    } else if (i == 3) {
                        status.setTitle("Requires Attention");
                    }
                    statusList.add(status);
                }
                continue;
            }
            for (int i = 0; i < 3; ++i) {
                status = new Status();
                status.setCategory("Done");
                status.setArchive(false);
                status.setWorkFlow(defaultScheme);
                if (i == 0) {
                    status.setTitle("Achieved");
                } else if (i == 1) {
                    status.setTitle("Partially Achieved");
                } else if (i == 2) {
                    status.setTitle("Not Achieved");
                }
                statusList.add(status);
            }
        }
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        this.statusRepository.save(statusList);
        return defaultScheme;
    }

    public List<BaseItemLink> findByBaseItemId(String objectiveId) {
        ArrayList<BaseItemLink> baseItemLinks = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").is((Object)objectiveId));
        baseItemLinks = this.mongoTemplate.find(query, BaseItemLink.class);
        return baseItemLinks;
    }

    public List<BaseItem> updateObjectiveGroupsByIds(HashMap<String, String> requestBody) {
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        HashMap pushMeta = new HashMap();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        ObjectMapper mapper = new ObjectMapper();
        8 T = new /* Unavailable Anonymous Inner Class!! */;
        String fromGroupId = requestBody.get("fromId");
        String toGroupId = requestBody.get("toId");
        String objId = requestBody.get("objectiveId");
        String metaMap = requestBody.get("metaMap");
        if (PropertyValidator.isValid((Object)metaMap)) {
            pushMeta = (HashMap)gson.fromJson(metaMap, T.getType());
        }
        ArrayList<BaseItem> updatedGroups = new ArrayList();
        BaseItem fromGroup = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)fromGroupId));
        BaseItem toGroup = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)toGroupId));
        BaseItemLink movedObj = new BaseItemLink();
        if (PropertyValidator.isValid((Object)fromGroup)) {
            for (BaseItemLink baseItemLink : fromGroup.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)baseItemLink) || !PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) || !baseItemLink.getBaseItemId().equals(objId)) continue;
                movedObj = baseItemLink;
            }
        }
        fromGroup.getBaseItemLinks().remove(movedObj);
        toGroup.getBaseItemLinks().add(movedObj);
        this.baseItemRepository.save((Object)fromGroup);
        this.baseItemRepository.save((Object)toGroup);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add(fromGroupId);
        groupIds.add(toGroupId);
        updatedGroups = this.baseItemRepository.findByIdIn(groupIds);
        dataMap.put("fromGroup", fromGroup);
        dataMap.put("toGroup", toGroup);
        dataMap.put("movedObjId", objId);
        if (!pushMeta.isEmpty()) {
            pushMeta.put("event", EnumKendis.NEW_OBJECTIVES.getCode());
            pushJson.put("metaMap", gson.toJson((Object)pushMeta));
        }
        pushJson.put("push", "Self");
        pushJson.put("action", "updateObjectiveGroups");
        pushJson.put("data", dataMap);
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            String err = StringUtils.getTraceString((Throwable)e);
            LOGGER.error(err);
        }
        return updatedGroups;
    }

    public List<BaseItem> getObjectivesList(String sessionId) {
        List objectiveGroupList = this.fetchObjectives(Boolean.valueOf(false), sessionId, Boolean.valueOf(true), null, null, Boolean.valueOf(false), null, null);
        return objectiveGroupList;
    }

    public HashMap<String, Object> calculateCompletion(BaseItem obj, boolean isJSON, String completionCriteria, Team objectiveTeam, Map<String, Team> teams, Map<String, Container> sprints, Map<String, Object> excludedItems) {
        HashMap<String, Object> completionData = new HashMap<String, Object>();
        Double completion = 0.0;
        Double doneItems = 0.0;
        Double totalDoneItems = 0.0;
        Double doneChildItems = 0.0;
        Double totalChildItems = 0.0;
        Double doneStoryPoints = 0.0;
        Double totalStoryPoints = 0.0;
        Double doneTeamItems = 0.0;
        Double totalTeamItems = 0.0;
        Double doneTeamItemsStoryPoints = 0.0;
        Double totalTeamItemsStoryPoints = 0.0;
        ArrayList<Map> linkedItems = isJSON ? new ArrayList<Map>() : null;
        HashMap iteratedStoriesMap = new HashMap();
        if (!PropertyValidator.isValid((Object)completionCriteria)) {
            completionCriteria = obj.getCompletionCriteria();
        }
        if (obj != null && obj.getLinkedItems() != null) {
            for (Item item : obj.getLinkedItems()) {
                if (!this.verifyItemsToExclude(item, excludedItems).booleanValue()) continue;
                Double[] sum = null;
                Double points = 0.0;
                Double subDone = null;
                Double subTotal = null;
                ArrayList<Map> subItems = null;
                if (isJSON) {
                    subItems = new ArrayList<Map>();
                }
                if (completionCriteria.equals(EnumKendis.LINKED_ITEM_STATUS.name())) {
                    sum = new Double[]{0.0, 0.0};
                    this.countObjectiveItem(item, Double.valueOf(1.0), sum, null);
                    if (isJSON && !Item.Type.UserStory.name().equals(item.getType()) && item.getSubItems() != null && item.getSubItems().size() > 0) {
                        for (Item subItem : item.getSubItems()) {
                            if (!this.verifyItemsToExclude(subItem, excludedItems).booleanValue()) continue;
                            if (subItem.getStoryPoints() != null) {
                                points = points + subItem.getStoryPoints();
                            }
                            subItems.add(subItem.toMap(teams, sprints));
                        }
                    }
                } else {
                    sum = new Double[]{0.0, 0.0};
                    if (Item.Type.UserStory.name().equals(item.getType())) {
                        if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name())) {
                            this.countObjectiveItem(item, Double.valueOf(1.0), sum, iteratedStoriesMap);
                        } else if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name())) {
                            this.countObjectiveItem(item, item.getStoryPoints(), sum, iteratedStoriesMap);
                        } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_STATUS.name())) {
                            this.countObjectiveItemByTeam(item, Double.valueOf(1.0), sum, objectiveTeam, iteratedStoriesMap);
                        } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_ESTIMATE.name())) {
                            this.countObjectiveItemByTeam(item, item.getStoryPoints(), sum, objectiveTeam, iteratedStoriesMap);
                        }
                    } else if (item.getSubItems() != null && item.getSubItems().size() > 0) {
                        sum = new Double[]{0.0, 0.0};
                        for (Item subItem : item.getSubItems()) {
                            if (!this.verifyItemsToExclude(subItem, excludedItems).booleanValue()) continue;
                            if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name())) {
                                this.countObjectiveItem(subItem, Double.valueOf(1.0), sum, iteratedStoriesMap);
                            } else if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name())) {
                                this.countObjectiveItem(subItem, subItem.getStoryPoints(), sum, iteratedStoriesMap);
                            } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_STATUS.name())) {
                                this.countObjectiveItemByTeam(subItem, Double.valueOf(1.0), sum, objectiveTeam, iteratedStoriesMap);
                            } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_ESTIMATE.name())) {
                                this.countObjectiveItemByTeam(subItem, subItem.getStoryPoints(), sum, objectiveTeam, iteratedStoriesMap);
                            }
                            if (!isJSON) continue;
                            if (subItem.getStoryPoints() != null) {
                                points = points + subItem.getStoryPoints();
                            }
                            subItems.add(subItem.toMap(teams, sprints));
                        }
                        if (isJSON) {
                            subDone = sum[1];
                            subTotal = sum[0];
                        }
                    }
                }
                if (sum != null) {
                    if (completionCriteria.equals(EnumKendis.LINKED_ITEM_STATUS.name())) {
                        totalDoneItems = totalDoneItems + sum[0];
                        doneItems = doneItems + sum[1];
                    } else if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name())) {
                        totalChildItems = totalChildItems + sum[0];
                        doneChildItems = doneChildItems + sum[1];
                    } else if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name())) {
                        totalStoryPoints = totalStoryPoints + sum[0];
                        doneStoryPoints = doneStoryPoints + sum[1];
                    } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_STATUS.name())) {
                        totalTeamItems = totalTeamItems + sum[0];
                        doneTeamItems = doneTeamItems + sum[1];
                    } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_ESTIMATE.name())) {
                        totalTeamItemsStoryPoints = totalTeamItemsStoryPoints + sum[0];
                        doneTeamItemsStoryPoints = doneTeamItemsStoryPoints + sum[1];
                    }
                }
                if (!isJSON) continue;
                Map o = item.toMap(teams, sprints);
                if (subItems != null && subItems.size() > 0) {
                    o.put("subItems", subItems);
                    o.put("storyPoints", points);
                }
                o.put("completion", KendisUtils.getPercentage(subDone, subTotal));
                linkedItems.add(o);
            }
        }
        if (completionCriteria.equals(EnumKendis.LINKED_ITEM_STATUS.name())) {
            if (totalDoneItems > 0.0) {
                completion = doneItems / totalDoneItems * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name())) {
            if (totalChildItems > 0.0) {
                completion = doneChildItems / totalChildItems * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals(EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name())) {
            if (totalStoryPoints > 0.0) {
                completion = doneStoryPoints / totalStoryPoints * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_STATUS.name())) {
            if (totalTeamItems > 0.0) {
                completion = doneTeamItems / totalTeamItems * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals(EnumKendis.TEAM_STORY_ESTIMATE.name()) && totalTeamItemsStoryPoints > 0.0) {
            completion = doneTeamItemsStoryPoints / totalTeamItemsStoryPoints * 100.0;
            completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
        }
        completionData.put("doneItems", doneItems);
        completionData.put("totalDoneItems", totalDoneItems);
        completionData.put("doneChildItems", doneChildItems);
        completionData.put("totalChildItems", totalChildItems);
        completionData.put("doneStoryPoints", doneStoryPoints);
        completionData.put("totalStoryPoints", totalStoryPoints);
        completionData.put("doneTeamItems", doneTeamItems);
        completionData.put("totalTeamItems", totalTeamItems);
        completionData.put("doneTeamItemsStoryPoints", doneTeamItemsStoryPoints);
        completionData.put("totalTeamItemsStoryPoints", totalTeamItemsStoryPoints);
        completionData.put("completion", completion);
        if (isJSON) {
            completionData.put("linkedItems", linkedItems);
        }
        return completionData;
    }

    private void countObjectiveItem(Item item, Double value, Double[] holder, Map<String, Boolean> iteratedStoriesMap) {
        if (holder == null) {
            holder = new Double[]{0.0, 0.0};
        }
        Double points = 0.0;
        if (value != null) {
            points = value;
        }
        if (iteratedStoriesMap == null || !iteratedStoriesMap.containsKey(item.getId())) {
            Double[] doubleArray = holder;
            Double.valueOf(doubleArray[0] + points);
            if (item.getStatus() != null && "Done".equals(item.getStatus().getCategory())) {
                doubleArray = holder;
                Double.valueOf(doubleArray[1] + points);
            }
            if (iteratedStoriesMap != null) {
                iteratedStoriesMap.put(item.getId(), true);
            }
        }
    }

    private void countObjectiveItemByTeam(Item item, Double value, Double[] holder, Team team, Map<String, Boolean> iteratedStoriesMap) {
        if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)team.getId())) {
            if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
                boolean isTeamStory = false;
                for (int i = 0; i < item.getTeamContainers().size() && !(isTeamStory = ((TeamContainer)item.getTeamContainers().get(i)).getTeam().getId().equals(team.getId())); ++i) {
                }
                if (isTeamStory) {
                    this.countObjectiveItem(item, value, holder, iteratedStoriesMap);
                }
            }
        } else {
            this.countObjectiveItem(item, value, holder, iteratedStoriesMap);
        }
    }

    public List<HashMap<String, String>> getWeightsListOfObjectiveOrGroup(BaseItem obj, Boolean isItemLinked) {
        ArrayList<HashMap<String, String>> okrWeightsList = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> objLinkCardWeight = new HashMap<String, String>();
        for (BaseItemLink link : obj.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId()) || !PropertyValidator.isValid((Object)link.getLinkType()) || !EnumKendis.PARENT_OBJECTIVE.getCode().equals(link.getLinkType()) && !EnumKendis.CHILD_OBJECTIVE.getCode().equals(link.getLinkType()) && !EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType())) continue;
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.put("baseItemId", link.getBaseItemId());
            newMap.put("weightage", link.getWeightage().toString());
            okrWeightsList.add(newMap);
        }
        if (isItemLinked.booleanValue()) {
            objLinkCardWeight.put("weightage", obj.getLinkedCardWeights().toString());
            objLinkCardWeight.put("baseItemId", "-1");
            okrWeightsList.add(objLinkCardWeight);
        }
        return okrWeightsList;
    }

    public Double calculateValueOfSingleX(List<HashMap<String, String>> weightsList) {
        int sumOfAssignedWeights = 0;
        Double valueOfX = 0.0;
        for (HashMap<String, String> item : weightsList) {
            if (!(Double.parseDouble(item.get("weightage")) > 0.0)) continue;
            sumOfAssignedWeights = (int)((double)sumOfAssignedWeights + Double.parseDouble(item.get("weightage")));
        }
        if (sumOfAssignedWeights > 0) {
            valueOfX = 100.0 / (double)sumOfAssignedWeights;
        }
        return valueOfX;
    }

    public Double calculateOkrCompletion(BaseItem okr, boolean isJSON, Double completion, List<HashMap<String, String>> okrWeightList, Map<String, Object> excludeItemsData) {
        Double okrCompletion = 0.0;
        Double targetValue = 0.0;
        Double progressValue = 0.0;
        Double startValue = 0.0;
        String progressCriteriaFieldToShow = "";
        List okrProgressCriteriaGroupFields = this.getOkrProgressCriteriaGroupFields();
        if (PropertyValidator.isValid((Object)okr.getFields())) {
            for (Fields groupField : okrProgressCriteriaGroupFields) {
                if (groupField.getTitle().equals("Progress Criteria")) {
                    progressCriteriaFieldToShow = (String)okr.getFields().get(groupField.getId());
                    continue;
                }
                if (groupField.getTitle().equals("Target Value")) {
                    if (!PropertyValidator.isValid(okr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(okr.getFields().get(groupField.getId()))) continue;
                    targetValue = Double.parseDouble(okr.getFields().get(groupField.getId()).toString());
                    continue;
                }
                if (groupField.getTitle().equals("Progress")) {
                    if (!PropertyValidator.isValid(okr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(okr.getFields().get(groupField.getId()))) continue;
                    progressValue = Double.parseDouble(okr.getFields().get(groupField.getId()).toString());
                    continue;
                }
                if (!groupField.getTitle().equals("Start") || !PropertyValidator.isValid(okr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(okr.getFields().get(groupField.getId()))) continue;
                startValue = Double.parseDouble(okr.getFields().get(groupField.getId()).toString());
            }
            if (PropertyValidator.isValid((Object)progressCriteriaFieldToShow) && progressCriteriaFieldToShow.equals("By Objectives")) {
                Double valueOfX = this.calculateValueOfSingleX(okrWeightList);
                HashMap<Object, Object> temp = new HashMap();
                for (HashMap<String, String> hm : okrWeightList) {
                    if (!hm.get("baseItemId").equals(okr.getId())) continue;
                    temp = hm;
                }
                if (PropertyValidator.isValid(temp)) {
                    okrCompletion = okrCompletion + completion * (Double.parseDouble((String)temp.get("weightage")) * valueOfX / 100.0);
                }
                progressCriteriaFieldToShow = null;
            } else if (PropertyValidator.isValid((Object)progressCriteriaFieldToShow) && progressCriteriaFieldToShow.equals("By Items")) {
                Double okrCompletionValue;
                okrCompletion = okrCompletionValue = completion;
                progressCriteriaFieldToShow = null;
            } else if (PropertyValidator.isValid((Object)progressCriteriaFieldToShow) && progressCriteriaFieldToShow.equals("Target") && !Double.isNaN(targetValue) && !Double.isNaN(progressValue)) {
                if (Double.isNaN(startValue) || startValue.equals(targetValue)) {
                    if (targetValue != 0.0) {
                        okrCompletion = progressValue / targetValue * 100.0;
                    }
                } else if (!Double.isNaN(startValue)) {
                    okrCompletion = startValue < targetValue ? Double.valueOf((progressValue - startValue) / (targetValue - startValue) * 100.0) : Double.valueOf((startValue - progressValue) / (startValue - targetValue) * 100.0);
                }
            }
        }
        if (isJSON) {
            okr.setLastUpdate(new HashMap());
            okr.getLastUpdate().put("completion", okrCompletion);
            if (progressCriteriaFieldToShow != null) {
                okr.getLastUpdate().put("targetValue", targetValue);
                okr.getLastUpdate().put("progress", progressValue);
                if (startValue != null && startValue > 0.0) {
                    okr.getLastUpdate().put("start", startValue);
                }
            }
        }
        return (double)Math.round(okrCompletion * 100.0) / 100.0;
    }

    public HashMap<String, Object> getAllObjectivesAndKR(HashMap<String, Object> params) {
        WorkSpace ws;
        HashMap<String, Object> response = new HashMap<String, Object>();
        String contextId = null;
        Boolean isMockingMode = false;
        if (params.containsKey("contextId")) {
            contextId = params.get("contextId").toString();
        }
        if (params.containsKey("isMockingMode")) {
            isMockingMode = (Boolean)params.get("isMockingMode");
        }
        if (PropertyValidator.isValid((Object)(ws = this.workSpaceRepository.findByIsModuleIsTrueAndModuleType(EnumWorkSpaceType.OBJECTIVES.getValue()))) && contextId.equals(ws.getId())) {
            contextId = "-1";
        }
        if (PropertyValidator.isValid((Object)contextId)) {
            HashSet<BaseItem> objectivesAndKr = new HashSet<BaseItem>();
            List objectiveGroups = this.getObjectiveGroupsWithoutItems(isMockingMode, contextId);
            for (int i = 0; i < objectiveGroups.size(); ++i) {
                List objectives = ((BaseItem)objectiveGroups.get(i)).getBaseItemList();
                if (!PropertyValidator.isValid((Collection)objectives)) continue;
                for (int j = 0; j < objectives.size(); ++j) {
                    BaseItem obj = (BaseItem)objectives.get(j);
                    BaseItem objMin = new BaseItem(obj.getId(), obj.getKey(), obj.getTitle(), obj.getItemType(), obj.getBaseItemLinks(), obj.getStatus());
                    if (objectivesAndKr.contains(objMin)) continue;
                    objectivesAndKr.add(objMin);
                    List keyResults = obj.getBaseItemList();
                    if (!PropertyValidator.isValid((Collection)keyResults)) continue;
                    for (int k = 0; k < keyResults.size(); ++k) {
                        BaseItem kr = (BaseItem)keyResults.get(k);
                        BaseItem krMin = new BaseItem(kr.getId(), kr.getKey(), kr.getTitle(), kr.getItemType(), kr.getBaseItemLinks(), kr.getStatus());
                        objectivesAndKr.add(krMin);
                    }
                }
            }
            response.put("objectives", objectivesAndKr);
        } else {
            response.put("error", "Invalid Objective Context");
        }
        return response;
    }

    public List<BaseItem> getObjectivesListByOkrBaseItemIds(List<String> okrLinkedObjectivesIds) {
        List linkedObjectives = this.baseItemRepository.findByIdIn(okrLinkedObjectivesIds);
        return linkedObjectives;
    }

    public List<Fields> getOkrProgressCriteriaGroupFields() {
        ItemType okrItemType = this.itemTypeRepository.findByTitle("KR");
        ItemTypeScheme okrItemTypeScheme = this.itemTypeSchemeRepository.findByItemType(okrItemType);
        ArrayList<Fields> okrProgressCriteriaGroupFields = new ArrayList<Fields>();
        for (Fields field : okrItemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
            if (!field.getTitle().equals("Progress Criteria")) continue;
            okrProgressCriteriaGroupFields.addAll(field.getGroupFields());
            break;
        }
        return okrProgressCriteriaGroupFields;
    }

    public HashMap<String, Object> checkOkrParentLinks(HashMap<String, Object> requestBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList objectiveIds = (ArrayList)requestBody.get("objectiveIds");
        String okrId = (String)requestBody.get("okrId");
        String sessionId = (String)requestBody.get("sessionId");
        Set objectivesInTree = new HashSet();
        objectivesInTree = this.checkExistenceOfItemInTree(okrId, sessionId, (List)objectiveIds, "up");
        objectivesInTree.addAll(this.checkExistenceOfItemInTree(okrId, sessionId, (List)objectiveIds, "down"));
        response.put("existingObjectives", objectivesInTree);
        return response;
    }

    public Set<String> checkExistenceOfItemInTree(String itemId, String sessionId, List<String> objectiveIds, String mode) {
        HashSet<String> objectivesInTree;
        block16: {
            List<Object> filteredLinks;
            BaseItem item;
            block14: {
                block15: {
                    item = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)itemId));
                    filteredLinks = new ArrayList();
                    objectivesInTree = new HashSet<String>();
                    if (!mode.equals("up")) break block14;
                    if (!PropertyValidator.isValid((Object)item) || !PropertyValidator.isValid((Object)item.getItemType()) || !EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(item.getItemType().getTitle())) break block15;
                    filteredLinks = item.getBaseItemLinks().stream().filter(link -> EnumKendis.PARENT_OBJECTIVE.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive()).collect(Collectors.toList());
                    for (BaseItemLink baseItemLink : filteredLinks) {
                        if (objectiveIds.contains(baseItemLink.getBaseItemId())) {
                            objectivesInTree.add(baseItemLink.getBaseItemId());
                        }
                        objectivesInTree.addAll(this.checkExistenceOfItemInTree(baseItemLink.getBaseItemId(), sessionId, objectiveIds, mode));
                    }
                    break block16;
                }
                if (!PropertyValidator.isValid((Object)item) || !PropertyValidator.isValid((Object)item.getItemType()) || !EnumKendis.OBJECTIVE.getCode().equals(item.getItemType().getTitle())) break block16;
                if (objectiveIds.contains(item.getId())) {
                    objectivesInTree.add(item.getId());
                }
                if (!PropertyValidator.isValid(filteredLinks = item.getBaseItemLinks().stream().filter(link -> EnumKendis.CHILD_OKR.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive()).collect(Collectors.toList()))) {
                    return objectivesInTree;
                }
                for (BaseItemLink baseItemLink : filteredLinks) {
                    objectivesInTree.addAll(this.checkExistenceOfItemInTree(baseItemLink.getBaseItemId(), sessionId, objectiveIds, mode));
                }
                break block16;
            }
            if (mode.equals("down")) {
                if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Object)item.getItemType()) && EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(item.getItemType().getTitle())) {
                    filteredLinks = item.getBaseItemLinks().stream().filter(link -> EnumKendis.PARENT_OKR.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive()).collect(Collectors.toList());
                    for (BaseItemLink baseItemLink : filteredLinks) {
                        if (objectiveIds.contains(baseItemLink.getBaseItemId())) {
                            objectivesInTree.add(baseItemLink.getBaseItemId());
                            continue;
                        }
                        objectivesInTree.addAll(this.checkExistenceOfItemInTree(baseItemLink.getBaseItemId(), sessionId, objectiveIds, mode));
                    }
                } else if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Object)item.getItemType()) && EnumKendis.OBJECTIVE.getCode().equals(item.getItemType().getTitle())) {
                    if (objectiveIds.contains(item.getId())) {
                        objectivesInTree.add(item.getId());
                    }
                    if (!PropertyValidator.isValid(filteredLinks = item.getBaseItemLinks().stream().filter(link -> (EnumKendis.CHILD_OBJECTIVE.getCode().equals(link.getLinkType()) || EnumKendis.PARENT_OKR.getCode().equals(link.getLinkType())) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive()).collect(Collectors.toList()))) {
                        return objectivesInTree;
                    }
                    for (BaseItemLink baseItemLink : filteredLinks) {
                        objectivesInTree.addAll(this.checkExistenceOfItemInTree(baseItemLink.getBaseItemId(), sessionId, objectiveIds, mode));
                    }
                }
            }
        }
        return objectivesInTree;
    }

    public void copyObjectivesBaseItemLink(Map<String, String> newItemsIdsMapByOldId, String sessionId) {
        List okrBaseItemLinks = this.baseItemLinkRepository.findBySessionIdAndItemIdIsNotNull(sessionId);
        for (BaseItemLink okrLink : okrBaseItemLinks) {
            if (!PropertyValidator.isValid((Object)newItemsIdsMapByOldId.get(okrLink.getItemId()))) continue;
            Map linkedItemById = okrLink.getLinkedItemById();
            Object obj = linkedItemById.remove(okrLink.getItemId());
            if (PropertyValidator.isValid(obj)) {
                HashMap linkedItemByIdUpdated = (HashMap)obj;
                if (PropertyValidator.isValid(linkedItemByIdUpdated.get("localId"))) {
                    linkedItemByIdUpdated.put("localId", newItemsIdsMapByOldId.get(okrLink.getItemId()));
                }
                linkedItemById.put(newItemsIdsMapByOldId.get(okrLink.getItemId()), linkedItemByIdUpdated);
            }
            okrLink.setItemId(newItemsIdsMapByOldId.get(okrLink.getItemId()));
        }
        this.baseItemLinkRepository.save((Iterable)okrBaseItemLinks);
    }

    public HashMap<String, Object> loadObjectivesListByWsId(String wsId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)wsId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"Objective-Group"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkType").is((Object)EnumKendis.ART_LINK_OBJECTIVE.getCode()));
        List baseItemLinks = this.mongoTemplate.find(query, BaseItemLink.class);
        List objectiveGroupList = this.baseItemRepository.findItemsByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
        response.put("objectiveGroups", objectiveGroupList);
        return response;
    }

    public HashMap<String, Object> loadObjectiveRelationDetails(String objId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        BaseItem objective = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)objId));
        if (PropertyValidator.isValid((Object)objective)) {
            ArrayList<ObjectId> workspaceIds = new ArrayList<ObjectId>();
            ArrayList<String> linkedObjParentIds = new ArrayList<String>();
            ArrayList<String> linkedSessionIds = new ArrayList<String>();
            for (BaseItemLink link : objective.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link)) continue;
                if (EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) && !link.isArchive() && !"-1".equals(link.getSessionId())) {
                    workspaceIds.add(new ObjectId(link.getSessionId()));
                    continue;
                }
                if (EnumKendis.CHILD_OKR.getCode().equals(link.getLinkType()) && !link.isArchive() && PropertyValidator.isValid((Object)link.getBaseItemId())) {
                    linkedObjParentIds.add(link.getBaseItemId());
                    continue;
                }
                if (!EnumKendis.LINKED_SESSION.getCode().equals(link.getLinkType()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getSessionId())) continue;
                linkedSessionIds.add(link.getSessionId());
            }
            if (PropertyValidator.isValid(workspaceIds)) {
                DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(WorkSpace.class));
                AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
                pipeline.add(new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", workspaceIds)).append("tenant", (Object)tenant)));
                pipeline.add(new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$toString", (Object)"$type.$id")).append("data", (Object)new BasicDBObject("$push", (Object)"$$ROOT"))));
                HashMap workSpaceMap = new HashMap();
                Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);
                while (dbCursor.hasNext()) {
                    WorkSpaceType type;
                    DBObject dbObject = (DBObject)dbCursor.next();
                    String workSpaceTypeId = (String)dbObject.get("_id");
                    if (!PropertyValidator.isValid((Object)workSpaceTypeId) || !PropertyValidator.isValid((Object)(type = this.workSpaceTypeRepository.findById(workSpaceTypeId)))) continue;
                    List data = (List)dbObject.get("data");
                    ArrayList<WorkSpace> workSpaces = new ArrayList<WorkSpace>();
                    for (DBObject document : data) {
                        WorkSpace workSpace = (WorkSpace)this.mongoTemplate.getConverter().read(WorkSpace.class, (Object)document);
                        workSpaces.add(workSpace);
                    }
                    workSpaceMap.put(type.getTitle(), workSpaces);
                }
                HashMap linkedBatchesMap = new HashMap();
                ArrayList<BaseItem> linkedBatches = new ArrayList<BaseItem>();
                collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BaseItem.class));
                ArrayList<BasicDBObject> batchPipeline = new ArrayList<BasicDBObject>();
                batchPipeline.add(new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", workspaceIds)).append("tenant", (Object)tenant)));
                dbCursor = collection.aggregate(batchPipeline, aggregationOptions);
                while (dbCursor.hasNext()) {
                    DBObject dbObject = (DBObject)dbCursor.next();
                    String baseItemType = (String)dbObject.get("type");
                    if (!PropertyValidator.isValid((Object)baseItemType) || !EnumBaseItemTypes.BATCH_GROUP.getName().equals(baseItemType) && !EnumBaseItemTypes.BATCH.getName().equals(baseItemType)) continue;
                    BaseItem linkedBatch = (BaseItem)this.mongoTemplate.getConverter().read(BaseItem.class, (Object)dbObject);
                    linkedBatches.add(linkedBatch);
                    linkedBatchesMap.put("Batches", linkedBatches);
                }
                response.put("linkedWorkSpaces", workSpaceMap);
                response.put("linkedBatches", linkedBatchesMap);
            }
            if (PropertyValidator.isValid(linkedObjParentIds)) {
                List linkedOKRs = this.fetchLinkedOkrs(linkedObjParentIds);
                response.put("linkedOkrs", linkedOKRs);
            }
            if (PropertyValidator.isValid(linkedSessionIds)) {
                List linkedPIs = this.sessionRepository.findSessionsByIdIn(linkedSessionIds);
                response.put("linkedPIs", linkedPIs);
            }
        }
        return response;
    }

    private List<Map<String, BaseItem>> fetchLinkedOkrs(List<String> linkedObjParentIds) {
        List keyResults = new ArrayList();
        List parentObjs = new ArrayList();
        ArrayList objIds = new ArrayList();
        HashMap parentIdsByKrMap = new HashMap();
        keyResults = this.baseItemRepository.findByIdIn(linkedObjParentIds);
        for (Object kr : keyResults) {
            if (!PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) continue;
            kr.getBaseItemLinks().forEach(arg_0 -> ObjectiveServiceImpl.lambda$fetchLinkedOkrs$25(objIds, parentIdsByKrMap, (BaseItem)kr, arg_0));
        }
        parentObjs = this.baseItemRepository.findByIdIn(objIds);
        HashMap<String, BaseItem> objMapById = new HashMap<String, BaseItem>();
        for (BaseItem obj : parentObjs) {
            objMapById.put(obj.getId(), obj);
        }
        ArrayList<Map<String, BaseItem>> linkedOKRs = new ArrayList<Map<String, BaseItem>>();
        for (BaseItem kr : keyResults) {
            HashMap<String, BaseItem> okr = new HashMap<String, BaseItem>();
            okr.put("child", kr);
            BaseItem parent = (BaseItem)objMapById.get(parentIdsByKrMap.get(kr.getId()));
            okr.put("parent", parent);
            linkedOKRs.add(okr);
        }
        return linkedOKRs;
    }

    public HashMap<String, Object> getLinkedOkrs(String objId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        BaseItem objective = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)objId));
        if (PropertyValidator.isValid((Object)objective)) {
            ArrayList<ObjectId> workspaceIds = new ArrayList<ObjectId>();
            ArrayList<String> linkedObjParentIds = new ArrayList<String>();
            for (BaseItemLink link : objective.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link)) continue;
                if (EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) && !link.isArchive() && !"-1".equals(link.getSessionId())) {
                    workspaceIds.add(new ObjectId(link.getSessionId()));
                    continue;
                }
                if (!EnumKendis.CHILD_OKR.getCode().equals(link.getLinkType()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
                linkedObjParentIds.add(link.getBaseItemId());
            }
            if (PropertyValidator.isValid(linkedObjParentIds)) {
                List linkedOKRs = this.fetchLinkedOkrs(linkedObjParentIds);
                response.put("linkedOkrs", linkedOKRs);
            }
        }
        return response;
    }

    public HashMap<String, Object> saveRelationships(HashMap<String, Object> requestBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List selectedGroups = (List)requestBody.get("groups");
        List selectedSessions = (List)requestBody.get("sessions");
        String objId = (String)requestBody.get("objId");
        BaseItem objective = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)objId));
        if (PropertyValidator.isValid((Object)objective)) {
            if (PropertyValidator.isValid((Collection)selectedSessions)) {
                List objBaseItemLinks = objective.getBaseItemLinks();
                List<BaseItemLink> newLinkedSessions = new ArrayList();
                for (String sessionId : selectedSessions) {
                    BaseItemLink sessionLink = objBaseItemLinks.stream().filter(link -> sessionId.equals(link.getSessionId()) && EnumKendis.LINKED_SESSION.getCode().equals(link.getLinkType())).findAny().orElse(null);
                    if (!PropertyValidator.isValid((Object)sessionLink)) {
                        BaseItemLink link2 = new BaseItemLink();
                        link2.setSessionId(sessionId);
                        link2.setLinkType(EnumKendis.LINKED_SESSION.getCode());
                        newLinkedSessions.add(link2);
                        continue;
                    }
                    if (!sessionLink.isArchive()) continue;
                    sessionLink.setArchive(false);
                    this.baseItemLinkRepository.save((Object)sessionLink);
                }
                List linkedSessions = this.sessionRepository.findByIdIn(selectedSessions);
                HashMap<String, Session> linkedSessionsMap = new HashMap<String, Session>();
                for (Session session : linkedSessions) {
                    linkedSessionsMap.put(session.getId(), session);
                }
                newLinkedSessions = this.baseItemLinkRepository.save(newLinkedSessions);
                objBaseItemLinks.addAll(newLinkedSessions);
                objective.setBaseItemLinks(objBaseItemLinks);
                objective = (BaseItem)this.baseItemRepository.save((Object)objective);
                response.put("updatedObjective", objective);
                response.put("linkedSessionsMap", linkedSessionsMap);
            }
            if (PropertyValidator.isValid((Collection)selectedGroups)) {
                for (HashMap grp : selectedGroups) {
                    String objGrpId;
                    String sessionId;
                    if (PropertyValidator.isValid(grp.get("id")) && ((String)grp.get("id")).equals("-1")) {
                        List objLinks;
                        String sessionId2 = (String)grp.get("parentId");
                        BaseItem defaultGrp = this.baseItemRepository.findByIsDefaultGroup(Boolean.valueOf(true));
                        if (!PropertyValidator.isValid((Object)defaultGrp)) {
                            defaultGrp = new BaseItem();
                            defaultGrp.setTitle("Default Group");
                            defaultGrp.setType("Objective-Group");
                            defaultGrp.setIsDefaultGroup(Boolean.valueOf(true));
                            ItemType itemType = this.itemTypeRepository.findByTitle("group_objective");
                            defaultGrp.setItemType(itemType);
                            ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(itemType);
                            List objGrpStatuses = this.statusRepository.findByWorkFlow(itemTypeScheme.getWorkflow());
                            Status firstNotDoneStatus = objGrpStatuses.stream().filter(status -> "ToDo".equals(status.getCategory())).findAny().orElse(null);
                            defaultGrp.setStatus(firstNotDoneStatus);
                            Object objGrpLinks = new ArrayList();
                            objGrpLinks.add(new BaseItemLink(sessionId2, EnumKendis.ART_LINK_OBJECTIVE.getCode(), "0", "Objective-Group"));
                            objGrpLinks = this.baseItemLinkRepository.save((Iterable)objGrpLinks);
                            defaultGrp.setBaseItemLinks((List)objGrpLinks);
                            defaultGrp = (BaseItem)this.baseItemRepository.save((Object)defaultGrp);
                        } else {
                            List objGrpBaseItemLinks = defaultGrp.getBaseItemLinks();
                            BaseItemLink groupLink = objGrpBaseItemLinks.stream().filter(link -> sessionId2.equals(link.getSessionId()) && "Objective-Group".equals(link.getType()) && "0".equals(link.getTeamId())).findAny().orElse(null);
                            if (!PropertyValidator.isValid((Object)groupLink)) {
                                groupLink = new BaseItemLink(sessionId2, EnumKendis.ART_LINK_OBJECTIVE.getCode(), "0", "Objective-Group");
                                groupLink = (BaseItemLink)this.baseItemLinkRepository.save((Object)groupLink);
                                objGrpBaseItemLinks.add(groupLink);
                                defaultGrp.setBaseItemLinks(objGrpBaseItemLinks);
                                defaultGrp = (BaseItem)this.baseItemRepository.save((Object)defaultGrp);
                            } else if (groupLink.isArchive()) {
                                groupLink.setArchive(false);
                                this.baseItemLinkRepository.save((Object)groupLink);
                            }
                        }
                        if (PropertyValidator.isValid((Collection)defaultGrp.getBaseItemLinks())) {
                            BaseItemLink objLink = defaultGrp.getBaseItemLinks().stream().filter(link -> sessionId2.equals(link.getSessionId()) && EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType()) && "0".equals(link.getTeamId()) && objId.equals(link.getBaseItemId())).findAny().orElse(null);
                            if (!PropertyValidator.isValid((Object)objLink)) {
                                objLink = new BaseItemLink(sessionId2, EnumKendis.CHILD_GROUP_OBJECTIVE.getCode(), "0", objId, null);
                                objLink = (BaseItemLink)this.baseItemLinkRepository.save((Object)objLink);
                                List objGrpBaseItemLinks = defaultGrp.getBaseItemLinks();
                                objGrpBaseItemLinks.add(objLink);
                                defaultGrp.setBaseItemLinks(objGrpBaseItemLinks);
                                defaultGrp = (BaseItem)this.baseItemRepository.save((Object)defaultGrp);
                            } else if (objLink.isArchive()) {
                                objLink.setArchive(false);
                                this.baseItemLinkRepository.save((Object)objLink);
                            }
                        }
                        if (!PropertyValidator.isValid((Collection)(objLinks = objective.getBaseItemLinks()))) continue;
                        objGrpId = defaultGrp.getId();
                        BaseItemLink defaultObjLink = null;
                        BaseItemLink linkToGroup = null;
                        for (BaseItemLink link3 : objective.getBaseItemLinks()) {
                            if (sessionId2.equals(link3.getSessionId()) && EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link3.getLinkType()) && "0".equals(link3.getTeamId()) && EnumKendis.OBJECTIVE.getCode().equals(link3.getType())) {
                                defaultObjLink = link3;
                                continue;
                            }
                            if (!sessionId2.equals(link3.getSessionId()) || !EnumKendis.PARENT_GROUP_OBJECTIVE.getCode().equals(link3.getLinkType()) || !"0".equals(link3.getTeamId()) || !objGrpId.equals(link3.getBaseItemId())) continue;
                            linkToGroup = link3;
                        }
                        if (!PropertyValidator.isValid(linkToGroup)) {
                            List<Object> newLinks = new ArrayList<BaseItemLink>();
                            newLinks.add(new BaseItemLink(sessionId2, EnumKendis.PARENT_GROUP_OBJECTIVE.getCode(), "0", objGrpId, null));
                            if (!PropertyValidator.isValid(defaultObjLink)) {
                                newLinks.add(new BaseItemLink(sessionId2, EnumKendis.ART_LINK_OBJECTIVE.getCode(), "0", EnumKendis.OBJECTIVE.getCode()));
                            }
                            newLinks = this.baseItemLinkRepository.save(newLinks);
                            objLinks.addAll(newLinks);
                            objective.setBaseItemLinks(objLinks);
                            objective = (BaseItem)this.baseItemRepository.save((Object)objective);
                            continue;
                        }
                        ArrayList<BaseItemLink> filteredObjLinks = new ArrayList<BaseItemLink>();
                        BaseItemLink groupLink = defaultGrp.getBaseItemLinks().stream().filter(link -> sessionId2.equals(link.getSessionId()) && EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType()) && "0".equals(link.getTeamId()) && objId.equals(link.getBaseItemId())).findAny().orElse(null);
                        if (PropertyValidator.isValid((Object)groupLink)) {
                            filteredObjLinks.add(groupLink);
                        }
                        filteredObjLinks.add(defaultObjLink);
                        filteredObjLinks.add(linkToGroup);
                        for (BaseItemLink link4 : filteredObjLinks) {
                            link4.setArchive(false);
                        }
                        this.baseItemLinkRepository.save(filteredObjLinks);
                        continue;
                    }
                    String id = (String)grp.get("id");
                    sessionId = (String)grp.get("parentId");
                    BaseItem objGrp = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
                    objGrpId = objGrp.getId();
                    List objLinks = objective.getBaseItemLinks();
                    if (!PropertyValidator.isValid((Collection)objLinks)) continue;
                    BaseItemLink defaultObjLink = null;
                    BaseItemLink linkToGroup = null;
                    for (BaseItemLink link5 : objective.getBaseItemLinks()) {
                        if (sessionId.equals(link5.getSessionId()) && EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link5.getLinkType()) && "0".equals(link5.getTeamId()) && EnumKendis.OBJECTIVE.getCode().equals(link5.getType())) {
                            defaultObjLink = link5;
                            continue;
                        }
                        if (!sessionId.equals(link5.getSessionId()) || !EnumKendis.PARENT_GROUP_OBJECTIVE.getCode().equals(link5.getLinkType()) || !"0".equals(link5.getTeamId()) || !objGrpId.equals(link5.getBaseItemId())) continue;
                        linkToGroup = link5;
                    }
                    if (!PropertyValidator.isValid(linkToGroup)) {
                        List objGrpLinks = objGrp.getBaseItemLinks();
                        List links = new ArrayList<BaseItemLink>();
                        links.add(new BaseItemLink(sessionId, EnumKendis.CHILD_GROUP_OBJECTIVE.getCode(), "0", objId, null));
                        links.add(new BaseItemLink(sessionId, EnumKendis.PARENT_GROUP_OBJECTIVE.getCode(), "0", objGrpId, null));
                        if (!PropertyValidator.isValid((Object)defaultObjLink)) {
                            links.add(new BaseItemLink(sessionId, EnumKendis.ART_LINK_OBJECTIVE.getCode(), "0", EnumKendis.OBJECTIVE.getCode()));
                        }
                        links = this.baseItemLinkRepository.save(links);
                        if (PropertyValidator.isValid((Collection)objGrpLinks)) {
                            objGrpLinks.add(links.get(0));
                        }
                        if (PropertyValidator.isValid((Collection)objLinks)) {
                            objLinks.add(links.get(1));
                            if (!PropertyValidator.isValid((Object)defaultObjLink)) {
                                objLinks.add(links.get(2));
                            }
                        }
                        objGrp.setBaseItemLinks(objGrpLinks);
                        objective.setBaseItemLinks(objLinks);
                        objGrp = (BaseItem)this.baseItemRepository.save((Object)objGrp);
                        objective = (BaseItem)this.baseItemRepository.save((Object)objective);
                        continue;
                    }
                    ArrayList<BaseItemLink> filteredObjLinks = new ArrayList<BaseItemLink>();
                    BaseItemLink groupLink = objGrp.getBaseItemLinks().stream().filter(link -> sessionId.equals(link.getSessionId()) && EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType()) && "0".equals(link.getTeamId()) && objId.equals(link.getBaseItemId())).findAny().orElse(null);
                    if (PropertyValidator.isValid((Object)groupLink)) {
                        filteredObjLinks.add(groupLink);
                    }
                    filteredObjLinks.add(defaultObjLink);
                    filteredObjLinks.add(linkToGroup);
                    for (BaseItemLink link6 : filteredObjLinks) {
                        link6.setArchive(false);
                    }
                    this.baseItemLinkRepository.save(filteredObjLinks);
                }
            }
        }
        return response;
    }

    private void calculationForSingleItem(BaseItem okr, Optional<String> requestId) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public HashMap<String, Double> calculateOkrAndGroupCompletion(List<BaseItem> objectiveGroupList, String sessionId, Map<String, BaseItem> piObjectivesById) throws Exception {
        HashMap<String, Double> completionById = new HashMap<String, Double>();
        try {
            Object itemObjectIds;
            Object backlogItems;
            Object krLinkedItemIds;
            HashMap itemIdsByRt = new HashMap();
            HashMap<String, Object> okrLinkedItemMapByOkrId = new HashMap<String, Object>();
            HashMap<String, Object> okrProgressCriteriaById = new HashMap<String, Object>();
            List okrProgressCriteriaGroupFields = this.getOkrProgressCriteriaGroupFields();
            for (Map.Entry<String, BaseItem> piObjEntry : piObjectivesById.entrySet()) {
                BaseItem piObj = piObjEntry.getValue();
                if (!PropertyValidator.isValid((Collection)piObj.getBaseItemList())) continue;
                block3: for (BaseItem piObjKeyResult : piObj.getBaseItemList()) {
                    Object progressCriteriaFieldToShow = "";
                    if (!PropertyValidator.isValid((Object)piObjKeyResult.getFields())) continue;
                    for (Fields groupField : okrProgressCriteriaGroupFields) {
                        if (!groupField.getTitle().equals("Progress Criteria")) continue;
                        progressCriteriaFieldToShow = (String)piObjKeyResult.getFields().get(groupField.getId());
                        okrProgressCriteriaById.put(piObjKeyResult.getId(), progressCriteriaFieldToShow);
                        continue block3;
                    }
                }
            }
            for (BaseItem objGrp : objectiveGroupList) {
                if (!PropertyValidator.isValid((Collection)objGrp.getBaseItemList())) continue;
                for (BaseItem obj2 : objGrp.getBaseItemList()) {
                    ArrayList<String> objLinkedItemIds = new ArrayList<String>();
                    if (PropertyValidator.isValid((Collection)obj2.getBaseItemLinks())) {
                        for (BaseItemLink link : obj2.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                            Set<String> itemIds = new HashSet<String>();
                            if (PropertyValidator.isValid((Collection)((Collection)itemIdsByRt.get(link.getReleaseTrainId())))) {
                                itemIds = (Set)itemIdsByRt.get(link.getReleaseTrainId());
                            }
                            itemIds.add(link.getBaseItemId());
                            objLinkedItemIds.add(link.getBaseItemId());
                            itemIdsByRt.put(link.getReleaseTrainId(), itemIds);
                        }
                        okrLinkedItemMapByOkrId.put(obj2.getId(), objLinkedItemIds);
                    }
                    if (!PropertyValidator.isValid((Collection)obj2.getBaseItemList())) continue;
                    for (BaseItem kr : obj2.getBaseItemList()) {
                        Set<String> itemIds;
                        String progressCriteriaFieldToShow = "";
                        krLinkedItemIds = new ArrayList();
                        if (kr.getType().contains("Objective") || PropertyValidator.isValid((Object)kr.getItemType()) && kr.getItemType().getTitle().equals("Objective")) {
                            if (!PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) continue;
                            for (BaseItemLink link : kr.getBaseItemLinks()) {
                                if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                                itemIds = new HashSet<String>();
                                if (PropertyValidator.isValid((Collection)((Collection)itemIdsByRt.get(link.getReleaseTrainId())))) {
                                    itemIds = (Set)itemIdsByRt.get(link.getReleaseTrainId());
                                }
                                itemIds.add(link.getBaseItemId());
                                objLinkedItemIds.add(link.getBaseItemId());
                                itemIdsByRt.put(link.getReleaseTrainId(), itemIds);
                                krLinkedItemIds.add(link.getBaseItemId());
                            }
                            okrLinkedItemMapByOkrId.put(kr.getId(), krLinkedItemIds);
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)kr.getFields())) {
                            for (Fields groupField : okrProgressCriteriaGroupFields) {
                                if (!groupField.getTitle().equals("Progress Criteria")) continue;
                                progressCriteriaFieldToShow = (String)kr.getFields().get(groupField.getId());
                                okrProgressCriteriaById.put(kr.getId(), progressCriteriaFieldToShow);
                                break;
                            }
                        }
                        if (!PropertyValidator.isValid((Object)progressCriteriaFieldToShow) || !progressCriteriaFieldToShow.equals("By Items") || !PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) continue;
                        for (BaseItemLink link : kr.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                            if (PropertyValidator.isValid((Object)link) && !link.isArchive() && "backLogItem".equals(link.getLinkType())) {
                                itemIds = new HashSet();
                                if (PropertyValidator.isValid((Collection)((Collection)itemIdsByRt.get(link.getReleaseTrainId())))) {
                                    itemIds = (Set)itemIdsByRt.get(link.getReleaseTrainId());
                                }
                                itemIds.add(link.getBaseItemId());
                                objLinkedItemIds.add(link.getBaseItemId());
                                itemIdsByRt.put(link.getReleaseTrainId(), itemIds);
                            }
                            krLinkedItemIds.add(link.getBaseItemId());
                        }
                        okrLinkedItemMapByOkrId.put(kr.getId(), krLinkedItemIds);
                    }
                }
            }
            HashMap<String, Object> backlogItemsByRt = new HashMap<String, Object>();
            HashMap<String, BacklogItem> childItemsById = new HashMap<String, BacklogItem>();
            for (String key : itemIdsByRt.keySet()) {
                Set itemIds = (Set)itemIdsByRt.get(key);
                ArrayList<ObjectId> objectItemIds = new ArrayList<ObjectId>();
                for (String itemId : itemIds) {
                    objectItemIds.add(new ObjectId(itemId));
                }
                backlogItems = this.itemFetchService.findBacklogItemsByItemIdsIn(key, objectItemIds);
                itemObjectIds = new ArrayList();
                krLinkedItemIds = backlogItems.iterator();
                while (krLinkedItemIds.hasNext()) {
                    BacklogItem item = (BacklogItem)krLinkedItemIds.next();
                    itemObjectIds.add(new ObjectId(item.getId()));
                }
                List childrenBacklogItems = this.itemFetchService.childBacklogItems(key, (List)itemObjectIds);
                for (BacklogItem child : childrenBacklogItems) {
                    childItemsById.put(child.getId(), child);
                }
                backlogItemsByRt.put(key, backlogItems);
            }
            HashMap backlogItemsByIdMapForRt = new HashMap();
            for (String key : backlogItemsByRt.keySet()) {
                HashMap<String, BacklogItem> backlogItemMapById = new HashMap<String, BacklogItem>();
                if (!PropertyValidator.isValid((Collection)((Collection)backlogItemsByRt.get(key)))) continue;
                backlogItems = (List)backlogItemsByRt.get(key);
                itemObjectIds = backlogItems.iterator();
                while (itemObjectIds.hasNext()) {
                    BacklogItem item = (BacklogItem)itemObjectIds.next();
                    backlogItemMapById.put(item.getId(), item);
                }
                backlogItemsByIdMapForRt.put(key, backlogItemMapById);
            }
            for (BaseItem objGrp : objectiveGroupList) {
                HashMap<String, Double> objWeights = new HashMap<String, Double>();
                for (BaseItemLink link : objGrp.getBaseItemLinks()) {
                    if (link.isArchive() || !EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType())) continue;
                    objWeights.put(link.getBaseItemId(), link.getWeightage());
                }
                Double grpCompletion = 0.0;
                Boolean groupCompletionErrorr = false;
                if (PropertyValidator.isValid((Collection)objGrp.getBaseItemList())) {
                    Iterator iterator = objWeights.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        boolean keyExistsInList = objGrp.getBaseItemList().stream().anyMatch(obj -> obj.getId().equals(key));
                        if (keyExistsInList) continue;
                        iterator.remove();
                    }
                    Double valueOfX = this.calculateValueOfX(objWeights);
                    for (BaseItem obj3 : objGrp.getBaseItemList()) {
                        HashMap<String, Boolean> objectiveEncountered = new HashMap<String, Boolean>();
                        objectiveEncountered.put(obj3.getId(), true);
                        Double objCompletion = this.calculateOkrCompletion(obj3, backlogItemsByIdMapForRt, okrProgressCriteriaGroupFields, okrProgressCriteriaById, completionById, childItemsById, piObjectivesById, objectiveEncountered, okrLinkedItemMapByOkrId);
                        if (!PropertyValidator.isValid((Object)completionById.get("error" + obj3.getId()))) {
                            completionById.put(obj3.getId(), (double)Math.round(objCompletion * 100.0) / 100.0);
                            Double objWeight = (Double)objWeights.get(obj3.getId());
                            grpCompletion = grpCompletion + objCompletion * objWeight * valueOfX / 100.0;
                            continue;
                        }
                        groupCompletionErrorr = true;
                    }
                }
                if (groupCompletionErrorr.booleanValue()) {
                    completionById.put("error" + objGrp.getId(), 1.0);
                    completionById.put(objGrp.getId(), 0.0);
                    continue;
                }
                completionById.put(objGrp.getId(), (double)Math.round(grpCompletion * 100.0) / 100.0);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return completionById;
    }

    public Double calculateOkrCompletion(BaseItem obj, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, List<Fields> okrProgressCriteriaGroupFields, Map<String, String> krProgressCriteriaById, HashMap<String, Double> completionById, Map<String, BacklogItem> childItemsById, Map<String, BaseItem> piObjectivesById, Map<String, Boolean> objectiveEncountered, Map<String, List<String>> okrLinkedItemMapByOkrId) throws Exception {
        Double objCompletion = 0.0;
        try {
            if (PropertyValidator.isValid(completionById) && PropertyValidator.isValid((Object)completionById.get(obj.getId()))) {
                objCompletion = completionById.get(obj.getId());
            } else if (PropertyValidator.isValid((Object)obj)) {
                Double linkedCardsWeights = obj.getLinkedCardWeights();
                Double objLinkedItemsCompletion = 0.0;
                HashMap<String, Double> krWeights = new HashMap<String, Double>();
                if (PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                    for (BaseItemLink link2 : obj.getBaseItemLinks()) {
                        if (link2.isArchive() || !EnumKendis.CHILD_OBJECTIVE.getCode().equals(link2.getLinkType()) && !EnumKendis.PARENT_OKR.getCode().equals(link2.getLinkType())) continue;
                        krWeights.put(link2.getBaseItemId(), link2.getWeightage());
                    }
                }
                Map completionResponse = new HashMap();
                Boolean isItemLinked = false;
                if (!PropertyValidator.isValid((Collection)okrLinkedItemMapByOkrId.get(obj.getId()))) {
                    HashMap linkedItemsMapByArt = new HashMap();
                    obj.getBaseItemLinks().forEach(link -> {
                        if (PropertyValidator.isValid((Object)link) && !link.isArchive() && PropertyValidator.isValid((Object)link.getLinkType()) && EnumKendis.BACKLOG_ITEM.getCode().equals(link.getLinkType())) {
                            Set<String> itemIds = new HashSet<String>();
                            if (PropertyValidator.isValid((Collection)((Collection)linkedItemsMapByArt.get(link.getReleaseTrainId())))) {
                                itemIds = (Set)linkedItemsMapByArt.get(link.getReleaseTrainId());
                            }
                            itemIds.add(link.getBaseItemId());
                            linkedItemsMapByArt.put(link.getReleaseTrainId(), itemIds);
                        }
                    });
                    if (!linkedItemsMapByArt.isEmpty()) {
                        HashMap<String, List> backlogItemsByRt = new HashMap<String, List>();
                        HashMap childItemsWithIdMap = new HashMap();
                        for (String key : linkedItemsMapByArt.keySet()) {
                            Set itemIds = (Set)linkedItemsMapByArt.get(key);
                            ArrayList<ObjectId> objectItemIds = new ArrayList<ObjectId>();
                            for (String itemId : itemIds) {
                                objectItemIds.add(new ObjectId(itemId));
                            }
                            List backlogItems = this.itemFetchService.findBacklogItemsByItemIdsIn(key, objectItemIds);
                            ArrayList<ObjectId> itemObjectIds = new ArrayList<ObjectId>();
                            for (BacklogItem item : backlogItems) {
                                itemObjectIds.add(new ObjectId(item.getId()));
                            }
                            List childrenBacklogItems = this.itemFetchService.childBacklogItems(key, itemObjectIds);
                            for (BacklogItem child : childrenBacklogItems) {
                                childItemsById.put(child.getId(), child);
                            }
                            backlogItemsByRt.put(key, backlogItems);
                        }
                        for (String key : backlogItemsByRt.keySet()) {
                            HashMap<String, BacklogItem> backlogItemMapById = new HashMap<String, BacklogItem>();
                            if (!PropertyValidator.isValid((Collection)((Collection)backlogItemsByRt.get(key)))) continue;
                            List backlogItems = (List)backlogItemsByRt.get(key);
                            for (BacklogItem item : backlogItems) {
                                backlogItemMapById.put(item.getId(), item);
                            }
                            backlogItemsByIdMapForRt.put(key, backlogItemMapById);
                        }
                    }
                }
                if (PropertyValidator.isValid((Collection)obj.getLinkedItems())) {
                    HashMap okcCals = this.calculateCompletion(obj, false, null, null, null, null, null);
                    objLinkedItemsCompletion = (Double)okcCals.get("completion");
                    isItemLinked = true;
                    this.processAndStoreReleaseTrainCompletion(obj, backlogItemsByIdMapForRt, childItemsById, completionById);
                } else {
                    completionResponse = this.calculateLinkedItemCompletion(obj, obj.getCompletionCriteria(), backlogItemsByIdMapForRt, childItemsById, Boolean.valueOf(false));
                    objLinkedItemsCompletion = (Double)completionResponse.get("completion");
                    isItemLinked = (Boolean)completionResponse.get("isItemLinked");
                    this.extractAndStoreReleaseTrainCompletions(completionResponse, obj, completionById);
                }
                completionById.put("linkedItemsCompletion_" + obj.getId(), objLinkedItemsCompletion);
                if (PropertyValidator.isValid((Object)isItemLinked) && isItemLinked.booleanValue()) {
                    krWeights.put("linkedItems", obj.getLinkedCardWeights());
                }
                if (!PropertyValidator.isValid((Collection)obj.getBaseItemList()) && PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                    List linkedKrIds = obj.getBaseItemLinks().stream().filter(link -> PropertyValidator.isValid((Object)link.getLinkType()) && (EnumKendis.CHILD_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) || EnumKendis.PARENT_OKR.getCode().equalsIgnoreCase(link.getLinkType()))).map(BaseItemLink::getBaseItemId).collect(Collectors.toList());
                    List linkedOKRs = this.baseItemRepository.findByIdIn(linkedKrIds);
                    obj.setBaseItemList(linkedOKRs);
                }
                Double krValueOfX = 100.0;
                if (PropertyValidator.isValid((Collection)obj.getBaseItemList())) {
                    Iterator iterator = krWeights.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String key = (String)entry.getKey();
                        boolean keyExistsInList = obj.getBaseItemList().stream().anyMatch(kr -> kr.getId().equals(key) || "linkedItems".equals(key));
                        if (keyExistsInList) continue;
                        iterator.remove();
                    }
                    krValueOfX = this.calculateValueOfX(krWeights);
                }
                if (PropertyValidator.isValid((Object)isItemLinked) && isItemLinked.booleanValue()) {
                    objLinkedItemsCompletion = objLinkedItemsCompletion * linkedCardsWeights * krValueOfX / 100.0;
                    objCompletion = objCompletion + objLinkedItemsCompletion;
                }
                if (PropertyValidator.isValid((Collection)obj.getBaseItemList())) {
                    for (BaseItem kr2 : obj.getBaseItemList()) {
                        Double krCompletion = 0.0;
                        if (kr2.getType().contains("Objective") || PropertyValidator.isValid((Object)kr2.getItemType()) && kr2.getItemType().getTitle().equals("Objective")) {
                            BaseItem kr22 = null;
                            kr22 = PropertyValidator.isValid((Object)piObjectivesById.get(kr2.getId())) ? piObjectivesById.get(kr2.getId()) : kr2;
                            krCompletion = this.calculateOkrCompletion(kr22, backlogItemsByIdMapForRt, okrProgressCriteriaGroupFields, krProgressCriteriaById, completionById, childItemsById, piObjectivesById, objectiveEncountered, okrLinkedItemMapByOkrId);
                            completionById.put(kr2.getId(), krCompletion);
                        } else {
                            krCompletion = this.calculateKrCompletion(kr2, backlogItemsByIdMapForRt, okrProgressCriteriaGroupFields, krProgressCriteriaById, completionById, childItemsById, piObjectivesById, objectiveEncountered, okrLinkedItemMapByOkrId);
                            completionById.put(kr2.getId(), krCompletion);
                        }
                        if (!PropertyValidator.isValid((Object)completionById.get("error" + kr2.getId()))) {
                            Double krWeight = (Double)krWeights.get(kr2.getId());
                            if (kr2.getType().contains("Objective") || PropertyValidator.isValid((Object)kr2.getItemType()) && kr2.getItemType().getTitle().equals("Objective")) {
                                krWeight = PropertyValidator.isValid((Object)krWeight) ? krWeight : 1.0;
                            }
                            objCompletion = objCompletion + krCompletion * krWeight * krValueOfX / 100.0;
                            completionById.put(kr2.getId(), (double)Math.round(krCompletion * 100.0) / 100.0);
                            continue;
                        }
                        completionById.put("error" + obj.getId(), 1.0);
                        completionById.put(obj.getId(), 0.0);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return objCompletion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Double calculateKrCompletion(BaseItem kr, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, List<Fields> okrProgressCriteriaGroupFields, Map<String, String> krProgressCriteriaById, HashMap<String, Double> completionById, Map<String, BacklogItem> childItemsById, Map<String, BaseItem> piObjectivesById, Map<String, Boolean> objectiveEncountered, Map<String, List<String>> okrLinkedItemMapByOkrId) throws Exception {
        Double startValue;
        Double progressValue;
        Double targetValue;
        Double krCompletion;
        block26: {
            Iterator<Fields> iterator;
            block27: {
                block24: {
                    Iterator iterator2;
                    HashMap<String, List> backlogItemsByRt;
                    HashMap linkedItemsMapByArt;
                    block25: {
                        krCompletion = 0.0;
                        try {
                            if (!PropertyValidator.isValid((Object)krProgressCriteriaById.get(kr.getId())) && PropertyValidator.isValid((Object)kr.getFields())) {
                                for (Fields groupField : okrProgressCriteriaGroupFields) {
                                    if (!groupField.getTitle().equals("Progress Criteria")) continue;
                                    String progressCriteriaFieldToShow = (String)kr.getFields().get(groupField.getId());
                                    krProgressCriteriaById.put(kr.getId(), progressCriteriaFieldToShow);
                                    break;
                                }
                            }
                            if ("By Items".equals(krProgressCriteriaById.get(kr.getId()))) {
                                if (PropertyValidator.isValid((Collection)okrLinkedItemMapByOkrId.get(kr.getId()))) break block24;
                                linkedItemsMapByArt = new HashMap();
                                kr.getBaseItemLinks().forEach(link -> {
                                    if (PropertyValidator.isValid((Object)link) && !link.isArchive() && PropertyValidator.isValid((Object)link.getLinkType()) && EnumKendis.BACKLOG_ITEM.getCode().equals(link.getLinkType())) {
                                        Set<String> itemIds = new HashSet<String>();
                                        if (PropertyValidator.isValid((Collection)((Collection)linkedItemsMapByArt.get(link.getReleaseTrainId())))) {
                                            itemIds = (Set)linkedItemsMapByArt.get(link.getReleaseTrainId());
                                        }
                                        itemIds.add(link.getBaseItemId());
                                        linkedItemsMapByArt.put(link.getReleaseTrainId(), itemIds);
                                    }
                                });
                                if (linkedItemsMapByArt.isEmpty()) break block24;
                                backlogItemsByRt = new HashMap<String, List>();
                                HashMap childItemsWithIdMap = new HashMap();
                                iterator2 = linkedItemsMapByArt.keySet().iterator();
                                break block25;
                            }
                            if ("Target".equals(krProgressCriteriaById.get(kr.getId()))) {
                                targetValue = 0.0;
                                progressValue = 0.0;
                                startValue = 0.0;
                                if (!PropertyValidator.isValid((Object)kr.getFields())) break block26;
                                iterator = okrProgressCriteriaGroupFields.iterator();
                                break block27;
                            }
                            if (!"By Objectives".equals(krProgressCriteriaById.get(kr.getId()))) return krCompletion;
                            if (!PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) return krCompletion;
                            int totalLinkedObj = 0;
                            Double completionTotal = 0.0;
                            Iterator iterator3 = kr.getBaseItemLinks().iterator();
                            while (true) {
                                if (!iterator3.hasNext()) {
                                    if (totalLinkedObj <= 0) return krCompletion;
                                    return completionTotal / (double)totalLinkedObj;
                                }
                                BaseItemLink link2 = (BaseItemLink)iterator3.next();
                                if (!PropertyValidator.isValid((Object)link2.getBaseItemId()) || link2.isArchive() || !PropertyValidator.isValid((Object)link2.getLinkType()) || !link2.getLinkType().equals(EnumKendis.PARENT_OKR.getCode())) continue;
                                if (PropertyValidator.isValid((Object)piObjectivesById.get(link2.getBaseItemId()))) {
                                    block28: {
                                        if (!PropertyValidator.isValid((Object)completionById.get(link2.getBaseItemId()))) {
                                            if (objectiveEncountered.getOrDefault(link2.getBaseItemId(), false).booleanValue()) {
                                                completionById.put("error" + kr.getId(), 2.0);
                                                completionById.put("error" + link2.getBaseItemId(), 1.0);
                                                completionById.put(kr.getId(), 0.0);
                                                completionById.put(link2.getBaseItemId(), 0.0);
                                                continue;
                                            }
                                            objectiveEncountered.put(link2.getBaseItemId(), true);
                                            Double objCompletion = this.calculateOkrCompletion(piObjectivesById.get(link2.getBaseItemId()), backlogItemsByIdMapForRt, okrProgressCriteriaGroupFields, krProgressCriteriaById, completionById, childItemsById, piObjectivesById, objectiveEncountered, okrLinkedItemMapByOkrId);
                                            if (!PropertyValidator.isValid((Object)completionById.get("error" + link2.getBaseItemId()))) {
                                                completionTotal = completionTotal + objCompletion;
                                                completionById.put(link2.getBaseItemId(), (double)Math.round(objCompletion * 100.0) / 100.0);
                                                break block28;
                                            } else {
                                                completionById.put("error" + kr.getId(), 1.0);
                                                continue;
                                            }
                                        }
                                        completionTotal = completionTotal + completionById.get(link2.getBaseItemId());
                                    }
                                    ++totalLinkedObj;
                                    continue;
                                }
                                if (!objectiveEncountered.getOrDefault(link2.getBaseItemId(), false).booleanValue()) continue;
                                completionById.put("error" + kr.getId(), 2.0);
                                completionById.put("error" + link2.getBaseItemId(), 1.0);
                                completionById.put(kr.getId(), 0.0);
                                completionById.put(link2.getBaseItemId(), 0.0);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                            throw e;
                        }
                    }
                    while (iterator2.hasNext()) {
                        String key = (String)iterator2.next();
                        Set itemIds = (Set)linkedItemsMapByArt.get(key);
                        ArrayList<ObjectId> objectItemIds = new ArrayList<ObjectId>();
                        for (String itemId : itemIds) {
                            objectItemIds.add(new ObjectId(itemId));
                        }
                        List backlogItems = this.itemFetchService.findBacklogItemsByItemIdsIn(key, objectItemIds);
                        ArrayList<ObjectId> itemObjectIds = new ArrayList<ObjectId>();
                        for (BacklogItem item : backlogItems) {
                            itemObjectIds.add(new ObjectId(item.getId()));
                        }
                        List childrenBacklogItems = this.itemFetchService.childBacklogItems(key, itemObjectIds);
                        for (BacklogItem child : childrenBacklogItems) {
                            childItemsById.put(child.getId(), child);
                        }
                        backlogItemsByRt.put(key, backlogItems);
                    }
                    for (String key : backlogItemsByRt.keySet()) {
                        HashMap<String, BacklogItem> backlogItemMapById = new HashMap<String, BacklogItem>();
                        if (!PropertyValidator.isValid((Collection)((Collection)backlogItemsByRt.get(key)))) continue;
                        List backlogItems = (List)backlogItemsByRt.get(key);
                        for (BacklogItem item : backlogItems) {
                            backlogItemMapById.put(item.getId(), item);
                        }
                        backlogItemsByIdMapForRt.put(key, backlogItemMapById);
                    }
                }
                if (PropertyValidator.isValid((Collection)kr.getLinkedItems())) {
                    HashMap okcCals = this.calculateCompletion(kr, false, null, null, null, null, null);
                    krCompletion = (Double)okcCals.get("completion");
                    this.processAndStoreReleaseTrainCompletion(kr, backlogItemsByIdMapForRt, childItemsById, completionById);
                    return krCompletion;
                }
                Map completionResponse = this.calculateLinkedItemCompletion(kr, kr.getCompletionCriteria(), backlogItemsByIdMapForRt, childItemsById, Boolean.valueOf(false));
                krCompletion = (Double)completionResponse.get("completion");
                this.extractAndStoreReleaseTrainCompletions(completionResponse, kr, completionById);
                return krCompletion;
            }
            while (iterator.hasNext()) {
                Fields groupField = iterator.next();
                if (groupField.getTitle().equals("Target Value")) {
                    if (!PropertyValidator.isValid(kr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(kr.getFields().get(groupField.getId()))) continue;
                    targetValue = Double.parseDouble(kr.getFields().get(groupField.getId()).toString());
                    continue;
                }
                if (groupField.getTitle().equals("Progress")) {
                    if (!PropertyValidator.isValid(kr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(kr.getFields().get(groupField.getId()))) continue;
                    progressValue = Double.parseDouble(kr.getFields().get(groupField.getId()).toString());
                    continue;
                }
                if (!groupField.getTitle().equals("Start") || !PropertyValidator.isValid(kr.getFields().get(groupField.getId())) || !PropertyValidator.isValid(kr.getFields().get(groupField.getId()))) continue;
                startValue = Double.parseDouble(kr.getFields().get(groupField.getId()).toString());
            }
        }
        if (Double.isNaN(targetValue)) return krCompletion;
        if (Double.isNaN(progressValue)) return krCompletion;
        if (!(targetValue > 0.0)) return krCompletion;
        if (Double.isNaN(startValue) || startValue.equals(targetValue)) {
            if (targetValue == 0.0) return krCompletion;
            return progressValue / targetValue * 100.0;
        }
        if (Double.isNaN(startValue)) return krCompletion;
        if (!(startValue < targetValue)) return (startValue - progressValue) / (startValue - targetValue) * 100.0;
        return (progressValue - startValue) / (targetValue - startValue) * 100.0;
    }

    private void processAndStoreReleaseTrainCompletion(BaseItem item, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, Map<String, BacklogItem> childItemsById, Map<String, Double> completionById) throws Exception {
        Map releaseTrainCompletions = this.calculateReleaseTrainSpecificCompletion(item, backlogItemsByIdMapForRt, childItemsById);
        this.storeReleaseTrainCompletions(releaseTrainCompletions, item.getId(), completionById);
    }

    private void extractAndStoreReleaseTrainCompletions(Map<String, Object> completionResponse, BaseItem item, Map<String, Double> completionById) throws Exception {
        Map releaseTrainCompletions = (Map)completionResponse.get("releaseTrainCompletions");
        this.storeReleaseTrainCompletions(releaseTrainCompletions, item.getId(), completionById);
    }

    private void storeReleaseTrainCompletions(Map<String, Double> releaseTrainCompletions, String itemId, Map<String, Double> completionById) throws Exception {
        if (PropertyValidator.isValid(releaseTrainCompletions)) {
            for (Map.Entry<String, Double> entry : releaseTrainCompletions.entrySet()) {
                String releaseTrainId = entry.getKey();
                Double rtCompletion = entry.getValue();
                completionById.put("linkedItemsCompletion_" + itemId + "_" + releaseTrainId, rtCompletion);
            }
        }
    }

    private Map<String, Object> calculateLinkedItemCompletion(BaseItem okr, String completionBy, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, Map<String, BacklogItem> childItemsById, Boolean calculateAll) throws Exception {
        try {
            boolean _isMiscStatus;
            Status cstatus;
            BacklogItem child;
            String childId;
            List children;
            Map itemChildren;
            Status status;
            Map<String, BacklogItem> backlogItemMapById;
            String releaseTrainId;
            String itemId;
            Integer totalLinkedItems;
            HashMap<String, Object> response = new HashMap<String, Object>();
            Double completion = 0.0;
            Double completionByLinkedItemStatus = 0.0;
            Double completionByLinkedItemStoriesStatus = 0.0;
            Double completionByLinkedItemStoriesEstimate = 0.0;
            Map releaseTrainCompletions = new HashMap();
            releaseTrainCompletions = this.calculateReleaseTrainSpecificCompletion(okr, backlogItemsByIdMapForRt, childItemsById);
            if (EnumKendis.LINKED_ITEM_STATUS.name().equals(completionBy) || calculateAll.booleanValue()) {
                Double objTotalLinked = 0.0;
                Double objDoneLinked = 0.0;
                for (BaseItemLink link : okr.getBaseItemLinks()) {
                    BacklogItem item;
                    if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                    String itemId2 = link.getBaseItemId();
                    String releaseTrainId2 = link.getReleaseTrainId();
                    Map<String, BacklogItem> backlogItemMapById2 = backlogItemsByIdMapForRt.get(releaseTrainId2);
                    if (!PropertyValidator.isValid(backlogItemMapById2) || !PropertyValidator.isValid((Object)(item = backlogItemMapById2.get(itemId2)))) continue;
                    boolean isMiscStatus = false;
                    Status status2 = item.getStatus();
                    if (PropertyValidator.isValid((Object)status2)) {
                        if (PropertyValidator.isValid((Object)status2.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status2.getCategoryMappingByCollectionId().get(releaseTrainId2))) {
                            status2.setCategory((String)status2.getCategoryMappingByCollectionId().get(releaseTrainId2));
                        }
                        if (item.getStatus().getCategory().equals("Misc")) {
                            isMiscStatus = true;
                        }
                    }
                    if (isMiscStatus) continue;
                    objTotalLinked = objTotalLinked + 1.0;
                    if (!PropertyValidator.isValid((Object)status2) || !"Done".equals(item.getStatus().getCategory())) continue;
                    objDoneLinked = objDoneLinked + 1.0;
                }
                if (objTotalLinked > 0.0) {
                    completionByLinkedItemStatus = objDoneLinked / objTotalLinked * 100.0;
                    completionByLinkedItemStatus = (double)Math.round(completionByLinkedItemStatus * 100.0) / 100.0;
                    if (calculateAll.booleanValue()) {
                        response.put("completionByLinkedItemStatus", completionByLinkedItemStatus);
                    }
                    response.put("isItemLinked", true);
                }
            }
            if (EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name().equals(completionBy) || calculateAll.booleanValue()) {
                Double totalDoneStories = 0.0;
                Double totalStories = 0.0;
                totalLinkedItems = 0;
                for (BaseItemLink link : okr.getBaseItemLinks()) {
                    BacklogItem item;
                    if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                    itemId = link.getBaseItemId();
                    releaseTrainId = link.getReleaseTrainId();
                    backlogItemMapById = backlogItemsByIdMapForRt.get(link.getReleaseTrainId());
                    if (!PropertyValidator.isValid(backlogItemMapById) || !PropertyValidator.isValid((Object)(item = backlogItemMapById.get(itemId)))) continue;
                    boolean isMiscStatus = false;
                    status = item.getStatus();
                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                        if (PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                            status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                        }
                        if (status.getCategory().equals("Misc")) {
                            isMiscStatus = true;
                        }
                    }
                    if (!isMiscStatus) {
                        totalLinkedItems = totalLinkedItems + 1;
                    }
                    if (!PropertyValidator.isValid((Collection)((Collection)(itemChildren = item.getChildRelationMap()).get(link.getReleaseTrainId())))) continue;
                    children = (List)itemChildren.get(link.getReleaseTrainId());
                    for (BaseItemLink childLink : children) {
                        childId = childLink.getBacklogItemId().toString();
                        if (!PropertyValidator.isValid(childItemsById) || !PropertyValidator.isValid((Object)childItemsById.get(childId))) continue;
                        child = childItemsById.get(childId);
                        cstatus = child.getStatus();
                        _isMiscStatus = false;
                        if (!PropertyValidator.isValid((Object)cstatus)) continue;
                        if (PropertyValidator.isValid((Object)cstatus)) {
                            if (PropertyValidator.isValid((Object)cstatus.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(cstatus.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                                cstatus.setCategory((String)cstatus.getCategoryMappingByCollectionId().get(releaseTrainId));
                            }
                            if (cstatus.getCategory().equals("Misc")) {
                                _isMiscStatus = true;
                            }
                        }
                        if (_isMiscStatus) continue;
                        totalStories = totalStories + 1.0;
                        if (!PropertyValidator.isValid((Object)cstatus) || !"Done".equals(cstatus.getCategory())) continue;
                        totalDoneStories = totalDoneStories + 1.0;
                    }
                }
                if (totalLinkedItems > 0) {
                    response.put("isItemLinked", true);
                }
                if (totalStories > 0.0) {
                    completionByLinkedItemStoriesStatus = totalDoneStories / totalStories * 100.0;
                    completionByLinkedItemStoriesStatus = (double)Math.round(completionByLinkedItemStoriesStatus * 100.0) / 100.0;
                    if (calculateAll.booleanValue()) {
                        response.put("completionByLinkedItemStoriesStatus", completionByLinkedItemStoriesStatus);
                    }
                }
            }
            if (EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name().equals(completionBy) || calculateAll.booleanValue()) {
                Double totalDoneStoryPts = 0.0;
                Double totalStoryPts = 0.0;
                totalLinkedItems = 0;
                for (BaseItemLink link : okr.getBaseItemLinks()) {
                    BacklogItem item;
                    if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                    itemId = link.getBaseItemId();
                    releaseTrainId = link.getReleaseTrainId();
                    backlogItemMapById = backlogItemsByIdMapForRt.get(link.getReleaseTrainId());
                    if (!PropertyValidator.isValid(backlogItemMapById) || !PropertyValidator.isValid((Object)(item = backlogItemMapById.get(itemId)))) continue;
                    boolean isMiscStatus = false;
                    status = item.getStatus();
                    if (PropertyValidator.isValid((Object)item.getStatus())) {
                        if (PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                            status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                        }
                        if (item.getStatus().getCategory().equals("Misc")) {
                            isMiscStatus = true;
                        }
                    }
                    if (!isMiscStatus) {
                        totalLinkedItems = totalLinkedItems + 1;
                    }
                    if (!PropertyValidator.isValid((Collection)((Collection)(itemChildren = item.getChildRelationMap()).get(link.getReleaseTrainId())))) continue;
                    children = (List)itemChildren.get(link.getReleaseTrainId());
                    for (BaseItemLink childLink : children) {
                        childId = childLink.getBacklogItemId().toString();
                        if (!PropertyValidator.isValid(childItemsById) || !PropertyValidator.isValid((Object)childItemsById.get(childId))) continue;
                        child = childItemsById.get(childId);
                        cstatus = child.getStatus();
                        _isMiscStatus = false;
                        if (!PropertyValidator.isValid((Object)cstatus)) continue;
                        if (PropertyValidator.isValid((Object)cstatus)) {
                            if (PropertyValidator.isValid((Object)cstatus.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(cstatus.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                                cstatus.setCategory((String)cstatus.getCategoryMappingByCollectionId().get(releaseTrainId));
                            }
                            if (cstatus.getCategory().equals("Misc")) {
                                _isMiscStatus = true;
                            }
                        }
                        if (_isMiscStatus) continue;
                        totalStoryPts = totalStoryPts + child.getStoryPoints();
                        if (!PropertyValidator.isValid((Object)cstatus) || !"Done".equals(cstatus.getCategory())) continue;
                        totalDoneStoryPts = totalDoneStoryPts + child.getStoryPoints();
                    }
                }
                if (totalLinkedItems > 0) {
                    response.put("isItemLinked", true);
                }
                if (totalStoryPts > 0.0) {
                    completionByLinkedItemStoriesEstimate = totalDoneStoryPts / totalStoryPts * 100.0;
                    completionByLinkedItemStoriesEstimate = (double)Math.round(completionByLinkedItemStoriesEstimate * 100.0) / 100.0;
                    if (calculateAll.booleanValue()) {
                        response.put("completionByLinkedItemStoriesEstimate", completionByLinkedItemStoriesEstimate);
                    }
                }
            }
            if (EnumKendis.LINKED_ITEM_STATUS.name().equals(completionBy)) {
                completion = completionByLinkedItemStatus;
            } else if (EnumKendis.CHILDREN_LINKED_ITEM_STATUS.name().equals(completionBy)) {
                completion = completionByLinkedItemStoriesStatus;
            } else if (EnumKendis.CHILDREN_LINKED_ITEM_ESTIMATE.name().equals(completionBy)) {
                completion = completionByLinkedItemStoriesEstimate;
            }
            response.put("completion", completion);
            response.put("releaseTrainCompletions", releaseTrainCompletions);
            return response;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private Map<String, Double> calculateReleaseTrainSpecificCompletion(BaseItem okr, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, Map<String, BacklogItem> childItemsById) throws Exception {
        String releaseTrainId;
        HashMap<String, Double> releaseTrainCompletions = new HashMap<String, Double>();
        String completionCriteria = okr.getCompletionCriteria();
        if (completionCriteria == null || completionCriteria.trim().isEmpty()) {
            completionCriteria = "LINKED_ITEM_STATUS";
        }
        HashMap<String, List> linksByReleaseTrain = new HashMap<String, List>();
        for (BaseItemLink baseItemLink : okr.getBaseItemLinks()) {
            if (!PropertyValidator.isValid((Object)baseItemLink) || baseItemLink.isArchive() || !"backLogItem".equals(baseItemLink.getLinkType())) continue;
            releaseTrainId = baseItemLink.getReleaseTrainId();
            linksByReleaseTrain.computeIfAbsent(releaseTrainId, k -> new ArrayList()).add(baseItemLink);
        }
        for (Map.Entry entry : linksByReleaseTrain.entrySet()) {
            releaseTrainId = (String)entry.getKey();
            List linksForRT = (List)entry.getValue();
            Double rtCompletion = 0.0;
            rtCompletion = "LINKED_ITEM_STATUS".equals(completionCriteria) ? this.calculateLinkedItemStatusCompletion(linksForRT, releaseTrainId, backlogItemsByIdMapForRt) : ("CHILDREN_LINKED_ITEM_STATUS".equals(completionCriteria) ? this.calculateChildrenLinkedItemStatusCompletion(linksForRT, releaseTrainId, backlogItemsByIdMapForRt, childItemsById) : ("CHILDREN_LINKED_ITEM_ESTIMATE".equals(completionCriteria) ? this.calculateChildrenLinkedItemEstimateCompletion(linksForRT, releaseTrainId, backlogItemsByIdMapForRt, childItemsById) : this.calculateLinkedItemStatusCompletion(linksForRT, releaseTrainId, backlogItemsByIdMapForRt)));
            releaseTrainCompletions.put(releaseTrainId, rtCompletion);
        }
        return releaseTrainCompletions;
    }

    private Double calculateLinkedItemStatusCompletion(List<BaseItemLink> linksForRT, String releaseTrainId, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt) throws Exception {
        Double rtTotalLinked = 0.0;
        Double rtDoneLinked = 0.0;
        for (BaseItemLink link : linksForRT) {
            BacklogItem item;
            String itemId = link.getBaseItemId();
            Map<String, BacklogItem> backlogItemMapById = backlogItemsByIdMapForRt.get(releaseTrainId);
            if (!PropertyValidator.isValid(backlogItemMapById) || !PropertyValidator.isValid((Object)(item = backlogItemMapById.get(itemId)))) continue;
            boolean isMiscStatus = false;
            Status status = item.getStatus();
            if (PropertyValidator.isValid((Object)status)) {
                if (PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                    status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                }
                if (item.getStatus().getCategory().equals("Misc")) {
                    isMiscStatus = true;
                }
            }
            if (isMiscStatus) continue;
            rtTotalLinked = rtTotalLinked + 1.0;
            if (!PropertyValidator.isValid((Object)status) || !"Done".equals(item.getStatus().getCategory())) continue;
            rtDoneLinked = rtDoneLinked + 1.0;
        }
        if (rtTotalLinked > 0.0) {
            Double rtCompletion = rtDoneLinked / rtTotalLinked * 100.0;
            return (double)Math.round(rtCompletion * 100.0) / 100.0;
        }
        return 0.0;
    }

    private Double calculateChildrenLinkedItemStatusCompletion(List<BaseItemLink> linksForRT, String releaseTrainId, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, Map<String, BacklogItem> childItemsById) throws Exception {
        Double totalDoneStories = 0.0;
        Double totalStories = 0.0;
        for (BaseItemLink link : linksForRT) {
            Map itemChildren;
            BacklogItem item;
            String itemId = link.getBaseItemId();
            Map<String, BacklogItem> backlogItemMapById = backlogItemsByIdMapForRt.get(releaseTrainId);
            if (!PropertyValidator.isValid(backlogItemMapById) || !PropertyValidator.isValid((Object)(item = backlogItemMapById.get(itemId))) || !PropertyValidator.isValid((Collection)((Collection)(itemChildren = item.getChildRelationMap()).get(releaseTrainId)))) continue;
            List children = (List)itemChildren.get(releaseTrainId);
            for (BaseItemLink childLink : children) {
                String childId = childLink.getBacklogItemId().toString();
                if (!PropertyValidator.isValid(childItemsById) || !PropertyValidator.isValid((Object)childItemsById.get(childId))) continue;
                BacklogItem child = childItemsById.get(childId);
                Status cstatus = child.getStatus();
                boolean _isMiscStatus = false;
                if (!PropertyValidator.isValid((Object)cstatus)) continue;
                if (PropertyValidator.isValid((Object)cstatus)) {
                    if (PropertyValidator.isValid((Object)cstatus.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(cstatus.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                        cstatus.setCategory((String)cstatus.getCategoryMappingByCollectionId().get(releaseTrainId));
                    }
                    if (cstatus.getCategory().equals("Misc")) {
                        _isMiscStatus = true;
                    }
                }
                if (_isMiscStatus) continue;
                totalStories = totalStories + 1.0;
                if (!PropertyValidator.isValid((Object)cstatus) || !"Done".equals(cstatus.getCategory())) continue;
                totalDoneStories = totalDoneStories + 1.0;
            }
        }
        if (totalStories > 0.0) {
            Double rtCompletion = totalDoneStories / totalStories * 100.0;
            return (double)Math.round(rtCompletion * 100.0) / 100.0;
        }
        return 0.0;
    }

    private Double calculateChildrenLinkedItemEstimateCompletion(List<BaseItemLink> linksForRT, String releaseTrainId, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, Map<String, BacklogItem> childItemsById) throws Exception {
        List allItemIds = linksForRT.stream().map(BaseItemLink::getBaseItemId).collect(Collectors.toList());
        Map rollupDataByItemId = this.fetchRollupDataForItems(allItemIds, releaseTrainId);
        double[] summary = this.calculateStoryPointsFromLinks(linksForRT, backlogItemsByIdMapForRt, rollupDataByItemId);
        double totalStoryPoints = summary[0];
        double doneStoryPoints = summary[1];
        if (totalStoryPoints > 0.0) {
            Double rtCompletion = doneStoryPoints / totalStoryPoints * 100.0;
            Double roundedCompletion = (double)Math.round(rtCompletion * 100.0) / 100.0;
            return roundedCompletion;
        }
        return 0.0;
    }

    private Map<String, Map<String, Object>> fetchRollupDataForItems(List<String> allItemIds, String releaseTrainId) throws Exception {
        Map resultData;
        HashMap<String, Map<String, Object>> rollupDataByItemId = new HashMap<String, Map<String, Object>>();
        if (allItemIds.isEmpty()) {
            return rollupDataByItemId;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> innerRule = new HashMap<String, Object>();
        innerRule.put("key", "itemIds");
        innerRule.put("type", "array");
        innerRule.put("value", allItemIds);
        ArrayList<HashMap<String, Object>> rules = new ArrayList<HashMap<String, Object>>();
        rules.add(innerRule);
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("rules", rules);
        filter.put("condition", "AND");
        params.put("filter", filter);
        params.put("rollupStoryPointsArray", true);
        params.put("rollupBatches", true);
        params.put("rollupSprints", true);
        params.put("loadStatuses", true);
        params.put("sortBy", "sequence");
        params.put("sortOrder", "1");
        Map result = this.itemFetchService.getBacklogItemsWithLevel(releaseTrainId, params);
        if (result != null && result.get("result") != null && (resultData = (Map)result.get("result")).get("items") != null) {
            List itemsData = (List)resultData.get("items");
            for (Map itemData : itemsData) {
                Object itemIdObj = itemData.get("id");
                String itemId = null;
                if (itemIdObj != null) {
                    itemId = itemIdObj instanceof String ? (String)itemIdObj : itemIdObj.toString();
                }
                String title = (String)itemData.get("title");
                Object leafStoryPoints = itemData.get("leafStoryPoints");
                Object leafStoryPointsArray = itemData.get("leafStoryPointsArray");
                Object childStoryPoints = itemData.get("childStoryPoints");
                Object childStoryPointsByStatus = itemData.get("childStoryPointsByStatus");
                Object childrenStatuses = itemData.get("childrenStatuses");
                if (itemId != null) {
                    rollupDataByItemId.put(itemId, itemData);
                    continue;
                }
                LOGGER.warn("Item ID is null for item with title: {}", (Object)title);
            }
        }
        return rollupDataByItemId;
    }

    private double[] calculateStoryPointsFromLinks(List<BaseItemLink> linksForRT, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt, Map<String, Map<String, Object>> rollupDataByItemId) throws Exception {
        double totalStoryPoints = 0.0;
        double doneStoryPoints = 0.0;
        HashSet<String> allStatusIds = new HashSet<String>();
        HashMap<String, List> leafArrayCache = new HashMap<String, List>();
        for (BaseItemLink link : linksForRT) {
            List leafStoryPointsArray;
            BacklogItem item = this.getItemFromLink(link, backlogItemsByIdMapForRt);
            if (item == null || !PropertyValidator.isValid((Collection)(leafStoryPointsArray = this.getLeafStoryPointsArray(item, rollupDataByItemId)))) continue;
            leafArrayCache.put(item.getId(), leafStoryPointsArray);
            for (Map spMap : leafStoryPointsArray) {
                String statusId = (String)spMap.get("status");
                if (!PropertyValidator.isValid((Object)statusId)) continue;
                allStatusIds.add(statusId);
            }
        }
        HashMap<String, Status> allStatusesMap = new HashMap<String, Status>();
        if (!allStatusIds.isEmpty()) {
            List fetchedStatuses = this.statusRepository.findProjectedByIdIn(new ArrayList(allStatusIds));
            for (Status status : fetchedStatuses) {
                allStatusesMap.put(status.getId(), status);
            }
        }
        for (BaseItemLink link : linksForRT) {
            String linkReleaseTrainId = link.getReleaseTrainId();
            BacklogItem item = this.getItemFromLink(link, backlogItemsByIdMapForRt);
            if (item == null) continue;
            totalStoryPoints += this.getItemLeafStoryPoints(item, rollupDataByItemId).doubleValue();
            List leafStoryPointsArray = (List)leafArrayCache.get(item.getId());
            if (leafStoryPointsArray == null) continue;
            doneStoryPoints += this.calculateDoneStoryPoints(leafStoryPointsArray, allStatusesMap, linkReleaseTrainId).doubleValue();
        }
        return new double[]{totalStoryPoints, doneStoryPoints};
    }

    private BacklogItem getItemFromLink(BaseItemLink link, Map<String, Map<String, BacklogItem>> backlogItemsByIdMapForRt) throws Exception {
        BacklogItem item;
        String itemId = link.getBaseItemId();
        String linkReleaseTrainId = link.getReleaseTrainId();
        Map<String, BacklogItem> backlogItemMapById = backlogItemsByIdMapForRt.get(linkReleaseTrainId);
        if (PropertyValidator.isValid(backlogItemMapById) && PropertyValidator.isValid((Object)(item = backlogItemMapById.get(itemId)))) {
            return item;
        }
        return null;
    }

    private List<Map<String, Object>> getLeafStoryPointsArray(BacklogItem item, Map<String, Map<String, Object>> rollupDataByItemId) throws Exception {
        Map<String, Object> itemData;
        Object leafStoryPointsArrayObj = null;
        String itemId = item.getId();
        if (item.getFields() != null && item.getFields().containsKey("leafStoryPointsArray")) {
            leafStoryPointsArrayObj = item.getFields().get("leafStoryPointsArray");
        } else if (rollupDataByItemId.containsKey(itemId) && (itemData = rollupDataByItemId.get(itemId)).containsKey("leafStoryPointsArray")) {
            leafStoryPointsArrayObj = itemData.get("leafStoryPointsArray");
        }
        if (PropertyValidator.isValid(leafStoryPointsArrayObj)) {
            return (List)leafStoryPointsArrayObj;
        }
        return null;
    }

    private Double calculateDoneStoryPoints(List<Map<String, Object>> leafStoryPointsArray, Map<String, Status> allStatusesMap, String linkReleaseTrainId) throws Exception {
        double doneStoryPoints = 0.0;
        if (!PropertyValidator.isValid(leafStoryPointsArray)) {
            return doneStoryPoints;
        }
        HashMap<String, Status> statusMapForContext = new HashMap<String, Status>();
        for (Map<String, Object> storyPointsByStatus : leafStoryPointsArray) {
            String statusId = (String)storyPointsByStatus.get("status");
            if (!PropertyValidator.isValid((Object)statusId) || !allStatusesMap.containsKey(statusId)) continue;
            Status status = statusMapForContext.computeIfAbsent(statusId, id -> {
                Status originalStatus = (Status)allStatusesMap.get(id);
                Status contextualStatus = new Status(originalStatus);
                if (PropertyValidator.isValid((Object)contextualStatus.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(contextualStatus.getCategoryMappingByCollectionId().get(linkReleaseTrainId))) {
                    contextualStatus.setCategory((String)contextualStatus.getCategoryMappingByCollectionId().get(linkReleaseTrainId));
                }
                return contextualStatus;
            });
            Double storyPoints = storyPointsByStatus.get("storyPoints") != null ? Double.valueOf(storyPointsByStatus.get("storyPoints").toString()) : 0.0;
            if (!"Done".equals(status.getCategory())) continue;
            doneStoryPoints += storyPoints.doubleValue();
        }
        return doneStoryPoints;
    }

    private Double getItemLeafStoryPoints(BacklogItem item, Map<String, Map<String, Object>> rollupDataByItemId) throws Exception {
        Map<String, Object> itemData;
        Object leafStoryPointsObj = null;
        String itemId = item.getId();
        Double itemLeafStoryPoints = 0.0;
        if (item.getFields() != null && item.getFields().containsKey("leafStoryPoints")) {
            leafStoryPointsObj = item.getFields().get("leafStoryPoints");
        } else if (rollupDataByItemId.containsKey(itemId) && (itemData = rollupDataByItemId.get(itemId)).containsKey("leafStoryPoints")) {
            leafStoryPointsObj = itemData.get("leafStoryPoints");
        }
        if (leafStoryPointsObj != null) {
            itemLeafStoryPoints = Double.valueOf(leafStoryPointsObj.toString());
        }
        return itemLeafStoryPoints;
    }

    private Double calculateValueOfX(HashMap<String, Double> objWeights) {
        Double x = 0.0;
        Double sum = 0.0;
        for (Double weight : objWeights.values()) {
            sum = sum + weight;
        }
        sum = sum == 0.0 ? 1.0 : sum;
        x = 100.0 / sum;
        return x;
    }

    public HashMap<String, Object> getPrioritizedObjectives(String sessionId, Boolean isObjListingView) {
        List objectivesList;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        ArrayList<String> linkTypeCodes = new ArrayList<String>();
        linkTypeCodes.add(EnumKendis.LINKED_SESSION.getCode());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"linkType").in(linkTypeCodes));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        List baseItemLinks = this.mongoTemplate.find(query, BaseItemLink.class);
        List groupList = new ArrayList();
        if (isObjListingView.booleanValue()) {
            objectivesList = this.baseItemRepository.findByBaseItemLinksIn(baseItemLinks);
            if (PropertyValidator.isValid((Collection)objectivesList)) {
                HashMap objectiveGroupMap = new HashMap();
                HashSet<ObjectId> groupIds = new HashSet<ObjectId>();
                for (BaseItem objective : objectivesList) {
                    if (!PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) continue;
                    for (BaseItemLink link2 : objective.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link2) || !EnumKendis.PARENT_GROUP_OBJECTIVE.getCode().equals(link2.getLinkType()) || !PropertyValidator.isValid((Object)link2.getBaseItemId())) continue;
                        groupIds.add(new ObjectId(link2.getBaseItemId()));
                    }
                }
                groupList = this.loadObjectivesByBaseItemId(new ArrayList(groupIds));
                if (PropertyValidator.isValid(groupList)) {
                    for (BaseItem group : groupList) {
                        objectiveGroupMap.put(group.getId(), group);
                    }
                }
                for (BaseItem objective : objectivesList) {
                    if (!PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) continue;
                    for (BaseItemLink link2 : objective.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link2) || !EnumKendis.PARENT_GROUP_OBJECTIVE.getCode().equals(link2.getLinkType()) || !PropertyValidator.isValid((Object)link2.getBaseItemId()) || !PropertyValidator.isValid(objectiveGroupMap.get(link2.getBaseItemId()))) continue;
                        this.setBaseItemInParent((BaseItem)objectiveGroupMap.get(link2.getBaseItemId()), objective);
                    }
                }
            }
        } else {
            objectivesList = this.baseItemRepository.findBaseItemsByBaseItemLinksIn(baseItemLinks);
            for (BaseItem objective : objectivesList) {
                if (!PropertyValidator.isValid((Object)objective.getStatus())) continue;
                Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                objective.setStatus(status);
            }
        }
        if (PropertyValidator.isValid((Collection)objectivesList)) {
            List keyResultsList;
            HashMap keyResultMappedByObjective = new HashMap();
            ArrayList keyResultsIds = new ArrayList();
            for (BaseItem objective : objectivesList) {
                objective.getBaseItemLinks().forEach(link -> {
                    if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive() && PropertyValidator.isValid((Object)link.getLinkType()) && !link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) && !link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode())) {
                        keyResultsIds.add(new ObjectId(link.getBaseItemId()));
                        keyResultMappedByObjective.put(link.getBaseItemId(), objective);
                    }
                });
            }
            if (PropertyValidator.isValid(keyResultsIds) && PropertyValidator.isValid(keyResultMappedByObjective) && PropertyValidator.isValid((Collection)(keyResultsList = this.loadObjectivesByBaseItemId(keyResultsIds)))) {
                keyResultsList.forEach(keyResult -> {
                    if (PropertyValidator.isValid((Object)keyResult.getStatus())) {
                        Status status = new Status(keyResult.getStatus().getId(), keyResult.getStatus().getTitle(), keyResult.getStatus().getColor(), keyResult.getStatus().getCategory());
                        keyResult.setStatus(status);
                    }
                    this.setBaseItemInParent((BaseItem)keyResultMappedByObjective.get(keyResult.getId()), keyResult);
                });
            }
        }
        if (isObjListingView.booleanValue() && PropertyValidator.isValid(groupList) && groupList.size() > 0) {
            responseJson.put("objectiveGroupList", groupList);
        } else {
            responseJson.put("objectives", objectivesList);
        }
        return responseJson;
    }

    public HashMap<String, Object> linkPIObjectivesToGlobalKR(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List globalKrIds = requestBody.getOrDefault("globalKrIds", new ArrayList());
        String linkedObjectiveId = (String)requestBody.get("linkedObjectiveId");
        List removeKrIds = requestBody.getOrDefault("removedKrIds", new ArrayList());
        BaseItem linkedObjective = this.baseItemRepository.findById(linkedObjectiveId);
        if (!PropertyValidator.isValid((Object)linkedObjective)) {
            return responseJson;
        }
        List currentObjectiveLinks = PropertyValidator.isValid((Collection)linkedObjective.getBaseItemLinks()) ? linkedObjective.getBaseItemLinks() : new ArrayList();
        for (String removeKrId : removeKrIds) {
            Iterator iterator = currentObjectiveLinks.iterator();
            while (iterator.hasNext()) {
                BaseItemLink link2 = (BaseItemLink)iterator.next();
                if (!PropertyValidator.isValid((Object)link2.getBaseItemId()) || !link2.getBaseItemId().equals(removeKrId) || !EnumKendis.CHILD_OKR.getCode().equals(link2.getLinkType())) continue;
                iterator.remove();
            }
            BaseItem kr = this.baseItemRepository.findById(removeKrId);
            if (!PropertyValidator.isValid((Object)kr)) continue;
            List krLinks = PropertyValidator.isValid((Collection)kr.getBaseItemLinks()) ? kr.getBaseItemLinks() : new ArrayList();
            Iterator krIterator = krLinks.iterator();
            while (krIterator.hasNext()) {
                BaseItemLink link3 = (BaseItemLink)krIterator.next();
                if (!PropertyValidator.isValid((Object)link3.getBaseItemId()) || !link3.getBaseItemId().equals(linkedObjectiveId) || !EnumKendis.PARENT_OKR.getCode().equals(link3.getLinkType())) continue;
                krIterator.remove();
            }
            kr.setBaseItemLinks(krLinks);
            this.baseItemRepository.save((Object)kr);
        }
        List selectedKRs = this.baseItemRepository.findByIdIn(globalKrIds);
        Set alreadyLinkedKRIds = currentObjectiveLinks.stream().filter(link -> EnumKendis.CHILD_OKR.getCode().equals(link.getLinkType())).map(BaseItemLink::getBaseItemId).collect(Collectors.toSet());
        for (BaseItem kr : selectedKRs) {
            if (alreadyLinkedKRIds.contains(kr.getId())) continue;
            BaseItemLink newLinkForKr = new BaseItemLink("-1", EnumKendis.PARENT_OKR.getCode(), linkedObjectiveId);
            newLinkForKr = (BaseItemLink)this.baseItemLinkRepository.save((Object)newLinkForKr);
            List krLinks = PropertyValidator.isValid((Collection)kr.getBaseItemLinks()) ? kr.getBaseItemLinks() : new ArrayList();
            krLinks.add(newLinkForKr);
            kr.setBaseItemLinks(krLinks);
            this.baseItemRepository.save((Object)kr);
            BaseItemLink newLinkForObjective = new BaseItemLink("-1", EnumKendis.CHILD_OKR.getCode(), kr.getId());
            newLinkForObjective = (BaseItemLink)this.baseItemLinkRepository.save((Object)newLinkForObjective);
            currentObjectiveLinks.add(newLinkForObjective);
        }
        linkedObjective.setBaseItemLinks(currentObjectiveLinks);
        this.baseItemRepository.save((Object)linkedObjective);
        responseJson.put("updatedObjective", linkedObjective);
        responseJson.put("updatedKRList", selectedKRs);
        return responseJson;
    }

    public HashMap<String, Object> calculateCompletionForSelectGroups(HashMap<String, Object> requestBody) throws Exception {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            HashMap completionById = new HashMap();
            String sessionId = (String)requestBody.get("sessionId");
            List groupIds = (List)requestBody.get("groupIds");
            ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
            List objectiveGroupList = this.baseItemRepository.findByIdIn(groupIds);
            if (PropertyValidator.isValid((Collection)objectiveGroupList)) {
                List objectivesList;
                HashMap piObjectivesById = new HashMap();
                HashMap<String, List> objectiveMappedByGroup = new HashMap<String, List>();
                for (BaseItem objectiveGroup : objectiveGroupList) {
                    for (Object link2 : objectiveGroup.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link2.getBaseItemId()) || link2.isArchive() || !PropertyValidator.isValid((Object)link2.getLinkType()) || !link2.getLinkType().equals(EnumKendis.CHILD_GROUP_OBJECTIVE.getCode())) continue;
                        if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(link2.getBaseItemId())))) {
                            objectiveMappedByGroup.put(link2.getBaseItemId(), new ArrayList());
                        }
                        List objGroups = (List)objectiveMappedByGroup.get(link2.getBaseItemId());
                        objGroups.add(objectiveGroup);
                        objectiveMappedByGroup.put(link2.getBaseItemId(), objGroups);
                        objectiveIds.add(new ObjectId(link2.getBaseItemId()));
                    }
                }
                if (PropertyValidator.isValid(objectiveIds) && PropertyValidator.isValid((Collection)(objectivesList = this.loadObjectivesByBaseItemId(objectiveIds)))) {
                    HashMap keyResultMappedByObjective = new HashMap();
                    ArrayList keyResultsIds = new ArrayList();
                    for (BaseItem objective : objectivesList) {
                        if (PropertyValidator.isValid((Object)objective.getStatus())) {
                            Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                            objective.setStatus(status);
                        }
                        if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(objective.getId())))) continue;
                        List parents = (List)objectiveMappedByGroup.get(objective.getId());
                        for (BaseItem parent : parents) {
                            this.setBaseItemInParent(parent, objective);
                            objective.getBaseItemLinks().forEach(link -> {
                                if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive() && PropertyValidator.isValid((Object)link.getLinkType()) && !link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) && !link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode()) && !link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())) {
                                    keyResultsIds.add(new ObjectId(link.getBaseItemId()));
                                    keyResultMappedByObjective.put(link.getBaseItemId(), objective);
                                }
                            });
                        }
                    }
                    if (PropertyValidator.isValid(keyResultsIds)) {
                        ArrayList objectiveIdsToFetch = new ArrayList();
                        List keyResultsList = this.loadObjectivesByBaseItemId(keyResultsIds);
                        keyResultsList.forEach(keyResult -> {
                            if (PropertyValidator.isValid((Object)keyResult.getStatus())) {
                                Status status = new Status(keyResult.getStatus().getId(), keyResult.getStatus().getTitle(), keyResult.getStatus().getColor(), keyResult.getStatus().getCategory());
                                keyResult.setStatus(status);
                            }
                            this.setBaseItemInParent((BaseItem)keyResultMappedByObjective.get(keyResult.getId()), keyResult);
                            if (keyResult.getItemType().getTitle().equals(EnumKendis.OBJECTIVE.getCode())) {
                                objectiveIdsToFetch.add(new ObjectId(keyResult.getId()));
                            } else {
                                for (BaseItemLink link : keyResult.getBaseItemLinks()) {
                                    if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getLinkType()) || !link.getLinkType().equals(EnumKendis.PARENT_OKR.getCode())) continue;
                                    objectiveIdsToFetch.add(new ObjectId(link.getBaseItemId()));
                                }
                            }
                        });
                        this.fetchPIObjectives(objectiveIdsToFetch, piObjectivesById);
                    }
                }
                completionById = this.calculateOkrAndGroupCompletion(objectiveGroupList, sessionId, piObjectivesById);
            }
            response.put("completionById", completionById);
            return response;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    public void fetchPIObjectives(List<ObjectId> objectiveIdsToFetch, Map<String, BaseItem> piObjectivesById) throws Exception {
        try {
            List objList = this.loadObjectivesByBaseItemId(objectiveIdsToFetch);
            ArrayList linksForItems = new ArrayList();
            if (PropertyValidator.isValid((Collection)objList)) {
                HashMap krMappedByObjective = new HashMap();
                ArrayList krIds = new ArrayList();
                for (BaseItem obj : objList) {
                    if (PropertyValidator.isValid((Object)obj.getStatus())) {
                        Status status = new Status(obj.getStatus().getId(), obj.getStatus().getTitle(), obj.getStatus().getColor(), obj.getStatus().getCategory());
                        obj.setStatus(status);
                    }
                    obj.getBaseItemLinks().forEach(link -> {
                        if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive() && PropertyValidator.isValid((Object)link.getLinkType()) && !link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) && !link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode())) {
                            krIds.add(new ObjectId(link.getBaseItemId()));
                            krMappedByObjective.put(link.getBaseItemId(), obj);
                        }
                        if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getItemId())) {
                            linksForItems.add(link);
                        }
                    });
                }
                if (PropertyValidator.isValid(krIds)) {
                    List krList = this.loadObjectivesByBaseItemId(krIds);
                    krList.forEach(kr -> {
                        if (PropertyValidator.isValid((Object)kr.getStatus())) {
                            Status status = new Status(kr.getStatus().getId(), kr.getStatus().getTitle(), kr.getStatus().getColor(), kr.getStatus().getCategory());
                            kr.setStatus(status);
                        }
                        this.setBaseItemInParent((BaseItem)krMappedByObjective.get(kr.getId()), kr);
                        kr.getBaseItemLinks().forEach(link -> {
                            if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getItemId())) {
                                linksForItems.add(link);
                            }
                        });
                    });
                }
                HashMap activeBoardItemsMap = new HashMap();
                HashMap objAndKrLinkedItemsMap = new HashMap();
                activeBoardItemsMap = this.fetchLinkedItems(null, linksForItems);
                ArrayList<ObjectId> nestedObjectivesIds = new ArrayList<ObjectId>();
                for (BaseItem obj : objList) {
                    piObjectivesById.put(obj.getId(), obj);
                    HashMap<String, Item> linkedItemsByItemId = new HashMap<String, Item>();
                    HashMap<String, Item> linkedItemsByJiraKeyOrTfsId = new HashMap<String, Item>();
                    List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
                    for (Item item : linkedItems) {
                        linkedItemsByItemId.put(item.getId(), item);
                        if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                            linkedItemsByJiraKeyOrTfsId.put(item.getJiraKey(), item);
                            continue;
                        }
                        if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                        linkedItemsByJiraKeyOrTfsId.put(item.getTfsId(), item);
                    }
                    this.setLinkedItemsMapForOkr(obj, linkedItemsByItemId, linkedItemsByJiraKeyOrTfsId, objAndKrLinkedItemsMap);
                    if (!PropertyValidator.isValid((Collection)obj.getBaseItemList())) continue;
                    for (BaseItem kr2 : obj.getBaseItemList()) {
                        HashMap<String, Item> linkedItemsByItemIdKR = new HashMap<String, Item>();
                        HashMap<String, Item> linkedItemsByJiraKeyOrTfsIdKR = new HashMap<String, Item>();
                        if (PropertyValidator.isValid((Collection)kr2.getBaseItemLinks())) {
                            for (BaseItemLink krLink : kr2.getBaseItemLinks()) {
                                if (krLink.isArchive() || !PropertyValidator.isValid((Object)krLink.getLinkType()) || !krLink.getLinkType().equals(EnumKendis.PARENT_OKR.getCode()) || PropertyValidator.isValid((Object)piObjectivesById.get(krLink.getBaseItemId()))) continue;
                                nestedObjectivesIds.add(new ObjectId(krLink.getBaseItemId()));
                            }
                        }
                        List linkedItemsKR = (List)activeBoardItemsMap.get("linkedItems");
                        for (Item item : linkedItemsKR) {
                            linkedItemsByItemIdKR.put(item.getId(), item);
                            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                                linkedItemsByJiraKeyOrTfsIdKR.put(item.getJiraKey(), item);
                            } else if (PropertyValidator.isValid((Object)item.getTfsId())) {
                                linkedItemsByJiraKeyOrTfsIdKR.put(item.getTfsId(), item);
                            }
                            this.setLinkedItemsMapForOkr(kr2, linkedItemsByJiraKeyOrTfsId, linkedItemsByJiraKeyOrTfsIdKR, objAndKrLinkedItemsMap);
                        }
                    }
                }
                if (PropertyValidator.isValid(nestedObjectivesIds)) {
                    this.fetchPIObjectives(nestedObjectivesIds, piObjectivesById);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    public HashMap<String, Object> getObjectivesOfGroup(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List objectiveList = new ArrayList();
        String sessionId = (String)requestBody.get("sessionId");
        String groupId = (String)requestBody.get("groupId");
        if (PropertyValidator.isValid((Object)sessionId) && PropertyValidator.isValid((Object)groupId)) {
            List baseItemLinks = this.baseItemLinkRepository.findBySessionIdAndBaseItemId(sessionId, groupId);
            objectiveList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
        }
        response.put("objectives", objectiveList);
        return response;
    }

    public HashMap<String, Object> getObjectivesBySearchQuery(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String searchQuery = (String)requestBody.get("searchQuery");
        String itemTypeId = (String)requestBody.get("itemTypeId");
        Integer pageIndex = (Integer)requestBody.get("pageIndex");
        Integer pageSize = (Integer)requestBody.get("pageSize");
        PageRequest pageable = new PageRequest(pageIndex.intValue(), pageSize.intValue());
        Query query = new Query();
        query.with((Pageable)pageable);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        String options = "i";
        Criteria criteria1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(searchQuery, options), Criteria.where((String)"key").regex(searchQuery, options)});
        query.addCriteria((CriteriaDefinition)criteria1);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemType.$id").is((Object)new ObjectId(itemTypeId)));
        query.fields().include("id");
        query.fields().include("title");
        query.fields().include("key");
        query.fields().include("baseItemLinks");
        List objectives = this.mongoTemplate.find(query, BaseItem.class);
        HashMap<String, BaseItem> objMapById = new HashMap<String, BaseItem>();
        HashSet<ObjectId> baseItemIdsForGroups = new HashSet<ObjectId>();
        for (BaseItem obj : objectives) {
            if (PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                for (BaseItemLink link : obj.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link) || !EnumKendis.PARENT_GROUP_OBJECTIVE.getCode().equals(link.getLinkType())) continue;
                    baseItemIdsForGroups.add(new ObjectId(link.getBaseItemId()));
                }
            }
            objMapById.put(obj.getId(), obj);
        }
        Query query2 = new Query();
        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(baseItemIdsForGroups));
        query2.fields().include("id");
        query2.fields().include("title");
        query2.fields().include("baseItemLinks");
        List objectiveGroups = this.mongoTemplate.find(query2, BaseItem.class);
        HashMap<String, ArrayList<BaseItem>> objectiveGroupsByObjId = new HashMap<String, ArrayList<BaseItem>>();
        for (BaseItem grp : objectiveGroups) {
            if (!PropertyValidator.isValid((Collection)grp.getBaseItemLinks())) continue;
            for (BaseItemLink link : grp.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || !EnumKendis.CHILD_GROUP_OBJECTIVE.getCode().equals(link.getLinkType()) || !PropertyValidator.isValid(objMapById.get(link.getBaseItemId()))) continue;
                ArrayList<BaseItem> groupsOfObjective = (ArrayList<BaseItem>)objectiveGroupsByObjId.get(link.getBaseItemId());
                if (groupsOfObjective == null) {
                    groupsOfObjective = new ArrayList<BaseItem>();
                }
                groupsOfObjective.add(grp);
                objectiveGroupsByObjId.put(link.getBaseItemId(), groupsOfObjective);
            }
        }
        response.put("objectives", objectives);
        response.put("objectiveGroupsByObjId", objectiveGroupsByObjId);
        return response;
    }

    public HashMap<String, Object> updateKrTemplate() throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        FieldTemplate fieldTemplate = this.fieldTemplateRepository.findByType(EnumKendis.OBJECTIVE_KEY_RESULT.getCode());
        Fields progressField = (Fields)fieldTemplate.getConfiguredFields().get(1);
        List grpFields = progressField.getGroupFields();
        if (((Fields)grpFields.get(1)).getTitle().equals("Start")) {
            response.put("startField", grpFields.get(1));
        } else {
            Fields startField = new Fields("5", "Start", "numberfield", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, "Target", 4, null);
            startField = (Fields)this.fieldsRepository.save((Object)startField);
            grpFields.add(1, startField);
            progressField.setGroupFields(grpFields);
            progressField = (Fields)this.fieldsRepository.save((Object)progressField);
            response.put("startField", startField);
        }
        return response;
    }

    public HashMap<String, Object> getObjectivesWithTrimedLinkedItems(String sessionId) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        Session session = this.sessionRepository.findById(sessionId);
        if (session.getLoadOldObjectivesView().equals(false)) {
            ArrayList<BaseItem> responseList = new ArrayList<BaseItem>();
            List allBaseItemLinks = this.loadBaseItemLinksBySessionIdAndType(Boolean.valueOf(false), sessionId);
            HashMap<String, BaseItemLink> groupBaseItemLinkMapByIds = new HashMap<String, BaseItemLink>();
            HashMap<String, BaseItemLink> baseItemLinkMapByIds = new HashMap<String, BaseItemLink>();
            ArrayList<BaseItemLink> listOfBaseItemLinkIds = new ArrayList<BaseItemLink>();
            for (BaseItemLink baseItemLink : allBaseItemLinks) {
                if (PropertyValidator.isValid((Object)baseItemLink.getTeamId())) {
                    groupBaseItemLinkMapByIds.put(baseItemLink.getId().toString(), baseItemLink);
                }
                baseItemLinkMapByIds.put(baseItemLink.getId().toString(), baseItemLink);
                listOfBaseItemLinkIds.add(baseItemLink);
            }
            List listOfAllBaseItemOfBoard = this.baseItemRepository.findByBaseItemLinksIn(listOfBaseItemLinkIds);
            ArrayList<BaseItem> listOfObjGroup = new ArrayList<BaseItem>();
            HashMap<String, BaseItem> baseItemsMapByIds = new HashMap<String, BaseItem>();
            HashMap krWeightsInAllObjectives = new HashMap();
            if (PropertyValidator.isValid((Collection)listOfAllBaseItemOfBoard)) {
                for (BaseItem objGroup : listOfAllBaseItemOfBoard) {
                    if (PropertyValidator.isValid((Collection)objGroup.getBaseItemLinks())) {
                        for (BaseItemLink baseItemLink : objGroup.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)baseItemLink) || !PropertyValidator.isValid(groupBaseItemLinkMapByIds.get(baseItemLink.getId()))) continue;
                            listOfObjGroup.add(objGroup);
                            break;
                        }
                    }
                    baseItemsMapByIds.put(objGroup.getId().toString(), objGroup);
                }
                for (BaseItem baseItemGroup : listOfObjGroup) {
                    ArrayList<BaseItem> listSubObjectiveData = new ArrayList<BaseItem>();
                    ArrayList<String> linkedTeamId = new ArrayList<String>();
                    HashMap<String, Double> weightsOflinkObjectives = new HashMap<String, Double>();
                    if (PropertyValidator.isValid((Object)baseItemGroup) && PropertyValidator.isValid((Collection)baseItemGroup.getBaseItemLinks())) {
                        HashMap krWeightsInSubObjectivesMapById = new HashMap();
                        for (BaseItemLink baseItemLink : baseItemGroup.getBaseItemLinks()) {
                            if (PropertyValidator.isValid((Object)baseItemLink) && !baseItemLink.isArchive() && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && PropertyValidator.isValid(baseItemsMapByIds.get(baseItemLink.getBaseItemId()))) {
                                BaseItem copySubObjective = new BaseItem((BaseItem)baseItemsMapByIds.get(baseItemLink.getBaseItemId()));
                                ArrayList<String> linkedItems = new ArrayList<String>();
                                HashMap<String, String> linkedItemsIdsMapByKeys = new HashMap<String, String>();
                                ArrayList<BaseItem> linkedBaseItemList = new ArrayList<BaseItem>();
                                if (PropertyValidator.isValid((Object)copySubObjective) && PropertyValidator.isValid((Collection)copySubObjective.getBaseItemLinks())) {
                                    HashMap<String, Double> krWeightsSubObjectives = new HashMap<String, Double>();
                                    for (BaseItemLink subObjectiveBaseItemLink : copySubObjective.getBaseItemLinks()) {
                                        if (PropertyValidator.isValid((Object)subObjectiveBaseItemLink) && PropertyValidator.isValid((Object)subObjectiveBaseItemLink.getItemId()) && !subObjectiveBaseItemLink.isArchive()) {
                                            linkedItems.add(subObjectiveBaseItemLink.getItemId().toString());
                                            if (!PropertyValidator.isValid((Object)subObjectiveBaseItemLink.getLinkedItemById())) continue;
                                            Map linkedItemByIdMap = subObjectiveBaseItemLink.getLinkedItemById();
                                            for (Object itemData : linkedItemByIdMap.values()) {
                                                Map linkedItemById = (Map)itemData;
                                                linkedItemsIdsMapByKeys.put(subObjectiveBaseItemLink.getItemId().toString(), linkedItemById.get("key").toString());
                                            }
                                            continue;
                                        }
                                        if (!PropertyValidator.isValid((Object)subObjectiveBaseItemLink) || !PropertyValidator.isValid((Object)subObjectiveBaseItemLink.getBaseItemId()) || subObjectiveBaseItemLink.isArchive() || !EnumKendis.CHILD_OBJECTIVE.getCode().equals(subObjectiveBaseItemLink.getLinkType()) || !PropertyValidator.isValid(baseItemsMapByIds.get(subObjectiveBaseItemLink.getBaseItemId()))) continue;
                                        BaseItem copySubObjectiveKR = new BaseItem((BaseItem)baseItemsMapByIds.get(subObjectiveBaseItemLink.getBaseItemId()));
                                        ArrayList<String> linkedItemsWithKr = new ArrayList<String>();
                                        HashMap<String, String> linkedItemsIdsMapByKeysWithKr = new HashMap<String, String>();
                                        krWeightsSubObjectives.put(String.valueOf(copySubObjectiveKR.getId()), subObjectiveBaseItemLink.getWeightage());
                                        if (!PropertyValidator.isValid((Object)copySubObjectiveKR.getType().equals(EnumKendis.OBJECTIVE_KEY_RESULT.getCode()))) continue;
                                        if (PropertyValidator.isValid((Object)copySubObjectiveKR) && PropertyValidator.isValid((Collection)copySubObjectiveKR.getBaseItemLinks())) {
                                            for (BaseItemLink subObjectiveBaseItemLinkWithKr : copySubObjectiveKR.getBaseItemLinks()) {
                                                if (!PropertyValidator.isValid((Object)subObjectiveBaseItemLinkWithKr) || !PropertyValidator.isValid((Object)subObjectiveBaseItemLinkWithKr.getItemId()) || subObjectiveBaseItemLinkWithKr.isArchive()) continue;
                                                linkedItemsWithKr.add(subObjectiveBaseItemLinkWithKr.getItemId().toString());
                                                if (!PropertyValidator.isValid((Object)subObjectiveBaseItemLinkWithKr.getLinkedItemById())) continue;
                                                Map linkedItemByIdMap = subObjectiveBaseItemLinkWithKr.getLinkedItemById();
                                                for (Object itemData : linkedItemByIdMap.values()) {
                                                    Map linkedItemById = (Map)itemData;
                                                    linkedItemsIdsMapByKeysWithKr.put(subObjectiveBaseItemLinkWithKr.getItemId().toString(), linkedItemById.get("key").toString());
                                                }
                                            }
                                        }
                                        if (PropertyValidator.isValid(linkedItemsWithKr)) {
                                            copySubObjectiveKR.setLinkedItemsIds(linkedItemsWithKr);
                                        }
                                        if (PropertyValidator.isValid(linkedItemsIdsMapByKeysWithKr)) {
                                            copySubObjectiveKR.setLinkedItemsById(linkedItemsIdsMapByKeysWithKr);
                                        }
                                        if (PropertyValidator.isValid((Object)copySubObjectiveKR.getStatus())) {
                                            Status status = new Status(copySubObjectiveKR.getStatus().getId(), copySubObjectiveKR.getStatus().getTitle(), copySubObjectiveKR.getStatus().getColor(), copySubObjectiveKR.getStatus().getCategory());
                                            copySubObjectiveKR.setStatus(status);
                                        }
                                        copySubObjectiveKR.setBaseItemLinks(null);
                                        copySubObjectiveKR.setItemType(null);
                                        linkedBaseItemList.add(copySubObjectiveKR);
                                    }
                                    krWeightsInSubObjectivesMapById.put(String.valueOf(copySubObjective.getId()), krWeightsSubObjectives);
                                }
                                if (PropertyValidator.isValid(linkedItems)) {
                                    copySubObjective.setLinkedItemsIds(linkedItems);
                                }
                                if (PropertyValidator.isValid(linkedItemsIdsMapByKeys)) {
                                    copySubObjective.setLinkedItemsById(linkedItemsIdsMapByKeys);
                                }
                                if (PropertyValidator.isValid(linkedBaseItemList)) {
                                    copySubObjective.setBaseItemList(linkedBaseItemList);
                                }
                                if (PropertyValidator.isValid((Object)copySubObjective.getStatus())) {
                                    Status status = new Status(copySubObjective.getStatus().getId(), copySubObjective.getStatus().getTitle(), copySubObjective.getStatus().getColor(), copySubObjective.getStatus().getCategory());
                                    copySubObjective.setStatus(status);
                                }
                                copySubObjective.setBaseItemLinks(null);
                                copySubObjective.setItemType(null);
                                listSubObjectiveData.add(copySubObjective);
                                weightsOflinkObjectives.put(String.valueOf(copySubObjective.getId()), baseItemLink.getWeightage());
                            }
                            if (!PropertyValidator.isValid((Object)baseItemLink.getTeamId())) continue;
                            linkedTeamId.add(baseItemLink.getTeamId());
                        }
                        krWeightsInSubObjectivesMapById.put("linkObjectivesWeigts", weightsOflinkObjectives);
                        krWeightsInAllObjectives.put(String.valueOf(baseItemGroup.getId()), krWeightsInSubObjectivesMapById);
                    }
                    BaseItem copyGroupObjective = new BaseItem(baseItemGroup);
                    if (PropertyValidator.isValid(linkedTeamId)) {
                        copyGroupObjective.setLinkedItemsIds(linkedTeamId);
                    }
                    if (PropertyValidator.isValid((Object)copyGroupObjective.getStatus())) {
                        Status status = new Status(copyGroupObjective.getStatus().getId(), copyGroupObjective.getStatus().getTitle(), copyGroupObjective.getStatus().getColor(), copyGroupObjective.getStatus().getCategory());
                        copyGroupObjective.setStatus(status);
                    }
                    if (PropertyValidator.isValid(listSubObjectiveData)) {
                        copyGroupObjective.setBaseItemList(listSubObjectiveData);
                    }
                    copyGroupObjective.setBaseItemLinks(null);
                    copyGroupObjective.setItemType(null);
                    responseList.add(copyGroupObjective);
                }
            }
            responseJson.put("getObjectiveEditModalTemplate", this.getObjectiveEditModalTemplate(sessionId));
            responseJson.put("objectiveData", responseList);
            responseJson.put("krWeightsInAllObjectives", krWeightsInAllObjectives);
        }
        return responseJson;
    }

    public HashMap<String, Object> getObjectivesOfSelectedGroup(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String sessionId = (String)requestBody.get("sessionId");
        String responsibleFieldid = (String)requestBody.get("responsibleFieldId");
        List groupIds = (List)requestBody.get("groupIds");
        ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
        List objectiveGroupList = this.baseItemRepository.findByIdIn(groupIds);
        if (PropertyValidator.isValid((Collection)objectiveGroupList)) {
            HashMap<String, List> objectiveMappedByGroup = new HashMap<String, List>();
            for (BaseItem objectiveGroup : objectiveGroupList) {
                for (Object link2 : objectiveGroup.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link2.getBaseItemId()) || link2.isArchive()) continue;
                    boolean isDefaultGroup = objectiveGroup.getIsDefaultGroup();
                    boolean isSessionMatch = sessionId.equals(link2.getSessionId());
                    if (isDefaultGroup && !isSessionMatch) continue;
                    if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(link2.getBaseItemId())))) {
                        objectiveMappedByGroup.put(link2.getBaseItemId(), new ArrayList());
                    }
                    List objGroups = (List)objectiveMappedByGroup.get(link2.getBaseItemId());
                    objGroups.add(objectiveGroup);
                    objectiveMappedByGroup.put(link2.getBaseItemId(), objGroups);
                    objectiveIds.add(new ObjectId(link2.getBaseItemId()));
                }
            }
            if (PropertyValidator.isValid(objectiveIds)) {
                List objectivesList = this.loadObjectivesByBaseItemId(objectiveIds);
                if (PropertyValidator.isValid((Collection)(objectivesList = this.applyAllObjectiveFilters(requestBody, objectivesList, 1)))) {
                    HashMap keyResultMappedByObjective = new HashMap();
                    ArrayList keyResultsIds = new ArrayList();
                    for (BaseItem objective : objectivesList) {
                        if (PropertyValidator.isValid((Object)objective.getStatus())) {
                            Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                            objective.setStatus(status);
                        }
                        if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(objective.getId())))) continue;
                        List parents = (List)objectiveMappedByGroup.get(objective.getId());
                        for (BaseItem parent : parents) {
                            this.setBaseItemInParent(parent, objective);
                            objective.getBaseItemLinks().forEach(link -> {
                                if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.isArchive() && PropertyValidator.isValid((Object)link.getLinkType()) && !link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) && !link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode()) && !link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())) {
                                    String keyResultId = link.getBaseItemId();
                                    keyResultsIds.add(new ObjectId(keyResultId));
                                    keyResultMappedByObjective.put(link.getBaseItemId(), objective);
                                }
                            });
                        }
                    }
                    if (PropertyValidator.isValid(keyResultsIds)) {
                        Object keyResultsList = this.loadObjectivesByBaseItemId(keyResultsIds);
                        keyResultsList = this.filterListOfObjecttivesAccordingToTimePeriods(requestBody, (List)keyResultsList, 2);
                        keyResultsList.forEach(keyResult -> {
                            if (PropertyValidator.isValid((Object)keyResult.getStatus())) {
                                Status status = new Status(keyResult.getStatus().getId(), keyResult.getStatus().getTitle(), keyResult.getStatus().getColor(), keyResult.getStatus().getCategory());
                                keyResult.setStatus(status);
                            }
                            this.setBaseItemInParent((BaseItem)keyResultMappedByObjective.get(keyResult.getId()), keyResult);
                        });
                    }
                }
            }
        }
        HashSet<String> artIds = new HashSet<String>();
        HashSet<String> linkedSessionIds = new HashSet<String>();
        for (Object grp : objectiveGroupList) {
            if (!PropertyValidator.isValid((Collection)grp.getBaseItemList())) continue;
            for (BaseItem obj : grp.getBaseItemList()) {
                if (!PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) continue;
                for (BaseItemLink link3 : obj.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link3)) continue;
                    if (PropertyValidator.isValid((Object)link3.getLinkType()) && link3.getLinkType().equals(EnumKendis.ART_LINK_OBJECTIVE.getCode()) && !link3.isArchive()) {
                        artIds.add(link3.getSessionId());
                    }
                    if (!PropertyValidator.isValid((Object)link3.getLinkType()) || !link3.getLinkType().equals(EnumKendis.LINKED_SESSION.getCode()) || link3.isArchive()) continue;
                    linkedSessionIds.add(link3.getSessionId());
                }
            }
            if (!PropertyValidator.isValid((Collection)grp.getBaseItemLinks())) continue;
            for (BaseItemLink link4 : grp.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link4.getLinkType()) || !link4.getLinkType().equals(EnumKendis.ART_LINK_OBJECTIVE.getCode()) || link4.isArchive()) continue;
                artIds.add(link4.getSessionId());
            }
        }
        artIds.remove("-1");
        List departments = this.workSpaceRepository.findByIdIn(new ArrayList(artIds));
        for (WorkSpace dpt : departments) {
            artIds.remove(dpt.getId());
        }
        if (PropertyValidator.isValid(artIds)) {
            List batches = this.baseItemRepository.findBatchesByIdIn(new ArrayList(artIds));
            response.put("batches", batches);
        }
        if (PropertyValidator.isValid(linkedSessionIds)) {
            List linkedSessions = this.sessionRepository.findSessionsByIdIn(new ArrayList(linkedSessionIds));
            response.put("sessions", linkedSessions);
        }
        response.put("departments", departments);
        response.put("objectiveGroups", objectiveGroupList);
        return response;
    }

    public HashMap<String, Object> cvGetAll(HashMap<String, Object> params) {
        int rowStatus;
        String releaseTrainId = (String)params.get("releaseTrainId");
        boolean archive = Boolean.TRUE.equals(params.get("archive"));
        Boolean favourites = (Boolean)params.getOrDefault("favourites", false);
        String userId = (String)params.getOrDefault("userId", UserContextUtil.getUserContext().getLoggedInUser().getId());
        String viewMode = (String)params.get("viewMode");
        HashMap<String, Object> response = new HashMap<String, Object>();
        int n = rowStatus = archive ? 1 : 0;
        List allCustomViews = !PropertyValidator.isValid((Object)releaseTrainId) ? (favourites != false ? this.objectiveCustomViewRepository.findAllByFavouriteUserListContainsAndRowStatus(userId, Integer.valueOf(rowStatus)) : this.objectiveCustomViewRepository.findByReleaseTrainIdIsNullAndRowStatus(rowStatus)) : this.fetchCustomViewsByViewMode(releaseTrainId, viewMode, rowStatus);
        allCustomViews = this.getAllowedCustomViewsOnly(allCustomViews);
        allCustomViews.sort(favourites != false ? Comparator.comparing(ObjectiveCustomView::getFavouriteSequence) : Comparator.comparing(BaseItem::getSequence));
        allCustomViews.forEach(view -> {
            if (PropertyValidator.isValid((Object)view.getImageIcon())) {
                List attachments = new ArrayList<Attachment>();
                attachments.add(view.getImageIcon());
                attachments = this.attachmentService.fetchAttachmentData(attachments);
                if (PropertyValidator.isValid(attachments)) {
                    view.setImageIcon((Attachment)attachments.get(0));
                }
            }
            view.setAccessRoles(this.workSpaceAccessRoleRepository.findByCustomView(view));
        });
        response.put("success", true);
        response.put("views", allCustomViews);
        return response;
    }

    private List<ObjectiveCustomView> fetchCustomViewsByViewMode(String releaseTrainId, String viewMode, int rowStatus) {
        if (!PropertyValidator.isValid((Object)viewMode)) {
            return this.objectiveCustomViewRepository.findAllByLinkedCollectionsContainsAndRowStatus(releaseTrainId, Integer.valueOf(rowStatus));
        }
        switch (viewMode) {
            case "owner": {
                return this.objectiveCustomViewRepository.findAllByOwnerCollectionIdAndRowStatus(releaseTrainId, Integer.valueOf(rowStatus));
            }
        }
        return this.objectiveCustomViewRepository.findAllByLinkedCollectionsContainsAndRowStatus(releaseTrainId, Integer.valueOf(rowStatus));
    }

    public HashMap<String, Object> cvGetById(String id) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ObjectiveCustomView customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)customView)) {
            customView.setAccessRoles(this.workSpaceAccessRoleRepository.findByCustomView(customView));
            response.put("success", true);
            response.put("view", customView);
        }
        return response;
    }

    public HashMap<String, Object> cvGetByIdIn(List<String> ids) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        List customViews = this.objectiveCustomViewRepository.findAllByIdIn(ids);
        if (PropertyValidator.isValid((Collection)customViews)) {
            response.put("success", true);
            response.put("views", customViews);
        }
        return response;
    }

    private List<ObjectiveCustomView> getAllowedCustomViewsOnly(List<ObjectiveCustomView> customViews) {
        User user = UserContextUtil.getUserContext().getLoggedInUser();
        ArrayList<ObjectiveCustomView> allowedCustomViews = new ArrayList<ObjectiveCustomView>();
        if (user.getIsAdmin().booleanValue()) {
            allowedCustomViews.addAll(customViews);
        } else {
            ArrayList groups = new ArrayList(user.getGroups());
            List workSpaceAccessRoles = this.workSpaceAccessRoleRepository.findByUserOrGroupIn(user, groups);
            HashMap<String, Boolean> accessRollMap = new HashMap<String, Boolean>();
            for (WorkSpaceAccessRole role : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)role.getCustomView())) continue;
                accessRollMap.put(role.getCustomView().getId(), true);
            }
            for (ObjectiveCustomView cv : customViews) {
                if (accessRollMap.get(cv.getId()) == null) continue;
                allowedCustomViews.add(cv);
            }
        }
        return allowedCustomViews;
    }

    public HashMap<String, Object> cvSave(ObjectiveCustomView customView) throws Exception {
        List existingRoles;
        HashMap<String, Object> response = new HashMap<String, Object>();
        List selectedCollectionIds = customView.getLinkedCollections();
        List<Object> collectionIds = new ArrayList();
        if (customView.getId() == null) {
            customView.setKey(this.customRepository.generateKey("CV"));
            if (PropertyValidator.isValid((Collection)selectedCollectionIds)) {
                collectionIds.addAll(selectedCollectionIds);
            }
        } else {
            ObjectiveCustomView existingView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)customView.getId()));
            if (PropertyValidator.isValid((Object)existingView) && PropertyValidator.isValid((Collection)existingView.getLinkedCollections()) && PropertyValidator.isValid((Collection)selectedCollectionIds)) {
                HashSet existingCollectionIds = new HashSet(existingView.getLinkedCollections());
                collectionIds = selectedCollectionIds.stream().filter(id -> !existingCollectionIds.contains(id)).collect(Collectors.toList());
            } else if (PropertyValidator.isValid((Collection)selectedCollectionIds)) {
                collectionIds.addAll(selectedCollectionIds);
            }
        }
        response.put("success", true);
        ObjectiveCustomView savedCustomView = (ObjectiveCustomView)this.objectiveCustomViewRepository.save((Object)customView);
        if (PropertyValidator.isValid(collectionIds)) {
            this.processLinkedCollections(collectionIds, savedCustomView);
        }
        if (PropertyValidator.isValid((Collection)customView.getAccessRoles())) {
            for (WorkSpaceAccessRole accessRole : customView.getAccessRoles()) {
                if (PropertyValidator.isValid((Object)accessRole.getUser())) {
                    if (accessRole.getUser().isLdap()) {
                        accessRole.getUser().setId(null);
                        User ldapUser = this.userRepository.findByUserCompanies_Company_IdAndUserNameIgnoreCase(UserContextUtil.getUserContext().getCurrentCompany().getId(), accessRole.getUser().getUserName().toLowerCase());
                        if (PropertyValidator.isValid((Object)ldapUser)) {
                            accessRole.setUser(ldapUser);
                        } else {
                            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
                            accessRole.getUser().setUserCompanies(new ArrayList());
                            UserCompany userCompany = new UserCompany();
                            userCompany.setCompany(new Company(cid));
                            userCompany.setIsGuest(accessRole.getUser().getIsGuest());
                            accessRole.getUser().getUserCompanies().add(userCompany);
                            accessRole.getUser().setUserName(accessRole.getUser().getUserName().toLowerCase());
                            accessRole.setUser((User)this.userRepository.save((Object)accessRole.getUser()));
                        }
                    }
                } else if (PropertyValidator.isValid((Object)accessRole.getGroup()) && accessRole.getGroup().isLdap()) {
                    accessRole.getGroup().setId(null);
                    Group ldapGroup = this.groupRepository.findByTitle(accessRole.getGroup().getTitle());
                    if (PropertyValidator.isValid((Object)ldapGroup)) {
                        accessRole.setGroup(ldapGroup);
                    } else {
                        accessRole.setGroup((Group)this.groupRepository.save((Object)accessRole.getGroup()));
                    }
                }
                ObjectiveCustomView tempView = new ObjectiveCustomView();
                tempView.setId(savedCustomView.getId());
                accessRole.setCustomView(tempView);
                WorkSpace objectiveWorkspace = this.workSpaceRepository.findByIsModuleIsTrueAndModuleType("Objectives");
                accessRole.setWorkSpace(objectiveWorkspace);
            }
            existingRoles = this.workSpaceAccessRoleRepository.findByCustomView(savedCustomView);
            if (PropertyValidator.isValid((Collection)existingRoles)) {
                HashSet existingRoleSet = new HashSet(existingRoles);
                HashSet newRoleSet = new HashSet(customView.getAccessRoles());
                HashSet rolesToRemove = new HashSet(existingRoleSet);
                rolesToRemove.removeAll(newRoleSet);
                if (!rolesToRemove.isEmpty()) {
                    this.workSpaceAccessRoleRepository.delete(rolesToRemove);
                }
            }
            this.workSpaceAccessRoleRepository.save((Iterable)customView.getAccessRoles());
        } else {
            existingRoles = this.workSpaceAccessRoleRepository.findByCustomView(savedCustomView);
            if (PropertyValidator.isValid((Collection)existingRoles)) {
                this.workSpaceAccessRoleRepository.delete((Iterable)existingRoles);
            }
        }
        response.put("view", customView);
        return response;
    }

    private void processLinkedCollections(List<String> collectionIds, ObjectiveCustomView savedCustomView) throws Exception {
        List collections = this.workSpaceRepository.findByIdIn(collectionIds);
        List workFlows = this.workFlowRepository.findAllByWorkflowType(EnumKendis.GROUP_OBJECTIVE.getCode());
        Status todoStatus = null;
        if (!workFlows.isEmpty()) {
            List statuses = this.statusRepository.findByWorkFlow((WorkFlow)workFlows.get(0));
            todoStatus = statuses.stream().filter(status -> "ToDo".equals(status.getCategory())).findFirst().orElse(null);
        }
        for (WorkSpace collection : collections) {
            BaseItem group = this.createBaseItem(collection, savedCustomView, todoStatus);
            BaseItem savedGroup = (BaseItem)this.baseItemRepository.save((Object)group);
            BaseItemLink cvLink = this.createBaseItemLink("objective-group", savedGroup.getId());
            cvLink = (BaseItemLink)this.baseItemLinkRepository.save((Object)cvLink);
            ArrayList<BaseItemLink> itemLinks = new ArrayList<BaseItemLink>(savedCustomView.getBaseItemLinks() != null ? savedCustomView.getBaseItemLinks() : Collections.emptyList());
            itemLinks.add(cvLink);
            savedCustomView.setBaseItemLinks(itemLinks);
            this.objectiveCustomViewRepository.save((Object)savedCustomView);
        }
    }

    private BaseItem createBaseItem(WorkSpace collection, ObjectiveCustomView savedCustomView, Status todoStatus) throws Exception {
        BaseItem group = new BaseItem();
        group.setType("Objective-Group");
        group.setHeaderColor(collection.getColor());
        group.setTitle(collection.getTitle());
        group.setLinkedCustomView(savedCustomView.getId());
        group.setStatus(todoStatus);
        List<BaseItemLink> links = Arrays.asList(this.createBaseItemLink("Objective-Group", "0", "-1", EnumKendis.ART_LINK_OBJECTIVE.getCode()), this.createBaseItemLink("Objective-Group", "0", collection.getId(), EnumKendis.ART_LINK_OBJECTIVE.getCode()), this.createBaseItemLink("custom-view", savedCustomView.getId()));
        group.setBaseItemLinks(this.baseItemLinkRepository.save(links));
        return group;
    }

    private BaseItemLink createBaseItemLink(String type, String baseItemId) throws Exception {
        BaseItemLink link = new BaseItemLink();
        link.setType(type);
        link.setBaseItemId(baseItemId);
        return link;
    }

    private BaseItemLink createBaseItemLink(String type, String teamId, String sessionId, String linkType) throws Exception {
        BaseItemLink link = new BaseItemLink();
        link.setType(type);
        link.setTeamId(teamId);
        link.setSessionId(sessionId);
        link.setLinkType(linkType);
        return link;
    }

    public HashMap<String, Object> cvArchieveCustomView(HashMap<String, Object> params) {
        Boolean archive = (Boolean)params.get("archive");
        String viewId = (String)params.get("viewId");
        HashMap<String, Object> response = new HashMap<String, Object>();
        ObjectiveCustomView customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)viewId));
        if (PropertyValidator.isValid((Object)customView)) {
            if (archive.booleanValue()) {
                customView.setRowStatus(1);
            } else {
                customView.setRowStatus(0);
            }
            ArrayList<String> groupIds = new ArrayList<String>();
            if (PropertyValidator.isValid((Collection)customView.getBaseItemLinks())) {
                for (BaseItemLink link2 : customView.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link2) || !link2.getType().equals("objective-group")) continue;
                    groupIds.add(link2.getBaseItemId());
                }
            }
            List objectiveGroupList = this.baseItemRepository.findByIdIn(groupIds);
            for (BaseItem group : objectiveGroupList) {
                group.setArchive(true);
                this.baseItemRepository.save((Object)group);
                group.getBaseItemLinks().forEach(link -> {
                    if (!PropertyValidator.isValid((Object)link.getBaseItemId()) && !link.getType().equals("custom-view")) {
                        link.setArchive(true);
                        this.baseItemLinkRepository.save(link);
                    }
                });
                AuditLog auditLogEntry = new AuditLog();
                auditLogEntry.setEventType("CUSTOM_OBJECTIVE_DELETE");
                auditLogEntry.setEventText("Custom Objective " + group.getTitle() + " deleted");
                auditLogEntry.setSessionId("-1");
                this.auditLogRepository.save((Object)auditLogEntry);
            }
            this.objectiveCustomViewRepository.save((Object)customView);
            response.put("success", true);
            response.put("view", customView);
        } else {
            response.put("success", false);
        }
        return response;
    }

    public HashMap<String, Object> cvLinkGroupsToCustomView(HashMap<String, Object> params) {
        String viewId = (String)params.get("viewId");
        List selectedGropIds = (List)params.get("selectedGropIds");
        HashMap<String, Object> response = new HashMap<String, Object>();
        ObjectiveCustomView customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)viewId));
        if (PropertyValidator.isValid((Object)customView)) {
            if (PropertyValidator.isValid((Collection)selectedGropIds)) {
                HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
                for (Object gId : selectedGropIds) {
                    duplicationCheckMap.put((String)gId, (String)gId);
                }
                boolean alreadyExist = false;
                if (PropertyValidator.isValid((Collection)customView.getBaseItemLinks())) {
                    for (BaseItemLink link : customView.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link) || !link.getType().equals("objective-group") || !duplicationCheckMap.containsKey(link.getBaseItemId())) continue;
                        alreadyExist = true;
                        break;
                    }
                }
                if (alreadyExist) {
                    response.put("success", false);
                    response.put("reason", "One or more group is already linked");
                } else {
                    BaseItemLink link;
                    ArrayList<BaseItemLink> baseItemLinksToSave = new ArrayList<BaseItemLink>();
                    List objectiveGroups = this.baseItemRepository.findByIdIn(selectedGropIds);
                    if (customView.getBaseItemLinks() == null) {
                        customView.setBaseItemLinks(new ArrayList());
                    }
                    for (String gId : selectedGropIds) {
                        link = new BaseItemLink();
                        link.setId(ObjectId.get().toString());
                        link.setType("objective-group");
                        link.setBaseItemId(gId);
                        baseItemLinksToSave.add(link);
                        customView.getBaseItemLinks().add(link);
                    }
                    for (BaseItem objectiveGroup : objectiveGroups) {
                        link = new BaseItemLink();
                        link.setId(ObjectId.get().toString());
                        link.setType("custom-view");
                        link.setBaseItemId(customView.getId());
                        baseItemLinksToSave.add(link);
                        if (objectiveGroup.getBaseItemLinks() == null) {
                            objectiveGroup.setBaseItemLinks(new ArrayList());
                        }
                        objectiveGroup.getBaseItemLinks().add(link);
                    }
                    this.baseItemLinkRepository.save(baseItemLinksToSave);
                    this.baseItemRepository.save((Iterable)objectiveGroups);
                    this.objectiveCustomViewRepository.save((Object)customView);
                    response.put("success", true);
                    response.put("view", customView);
                }
            } else {
                response.put("success", false);
                response.put("reason", "No group to link");
            }
        } else {
            response.put("success", false);
            response.put("reason", "No custom view found");
        }
        return response;
    }

    public HashMap<String, Object> cvMarkViewFavourite(String id, HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String userId = (String)requestBody.getOrDefault("userId", UserContextUtil.getUserContext().getLoggedInUser().getId());
        ObjectiveCustomView view = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)view) && PropertyValidator.isValid((Object)userId)) {
            if (!PropertyValidator.isValid((Collection)view.getFavouriteUserList())) {
                view.setFavouriteUserList(new ArrayList());
            }
            if (view.getFavouriteUserList().contains(userId)) {
                view.getFavouriteUserList().remove(userId);
                view.setFavouriteSequence(null);
            } else {
                view.getFavouriteUserList().add(userId);
                view.setFavouriteSequence(Double.valueOf(System.nanoTime() / 100000L));
            }
            view = (ObjectiveCustomView)this.objectiveCustomViewRepository.save((Object)view);
            response.put("customView", view);
            response.put("success", true);
        } else {
            response.put("reason", "no custom view found or invalid user id");
            response.put("success", false);
        }
        return response;
    }

    public HashMap<String, Object> cvSortCustomView(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String viewId = requestBody.getOrDefault("viewId", null);
        Boolean isFavouriteSort = (Boolean)requestBody.getOrDefault("isFavourite", false);
        Object sequenceObj = requestBody.get("sequence");
        Double sequence = null;
        if (sequenceObj instanceof Long) {
            sequence = ((Long)sequenceObj).doubleValue();
        } else if (sequenceObj instanceof Double) {
            sequence = (Double)sequenceObj;
        } else if (sequenceObj instanceof Integer) {
            sequence = ((Integer)sequenceObj).doubleValue();
        }
        if (PropertyValidator.isValid((Object)viewId) && PropertyValidator.isValid((Object)sequence)) {
            ObjectiveCustomView view = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)viewId));
            if (PropertyValidator.isValid((Object)view)) {
                if (isFavouriteSort.booleanValue()) {
                    view.setFavouriteSequence(sequence);
                } else {
                    view.setSequence(sequence);
                }
                view = (ObjectiveCustomView)this.objectiveCustomViewRepository.save((Object)view);
                response.put("customView", view);
                response.put("success", true);
            } else {
                response.put("success", false);
            }
        } else {
            response.put("success", false);
        }
        return response;
    }

    public Double calculateCompletionOnOldFormulas(HashMap<String, Object> calculationData, String completionCriteria) {
        Double completion = 0.0;
        Double doneItems = (Double)calculationData.get("doneItems");
        Double totalDoneItems = (Double)calculationData.get("totalDoneItems");
        Double doneChildItems = (Double)calculationData.get("doneChildItems");
        Double totalChildItems = (Double)calculationData.get("totalChildItems");
        Double doneStoryPoints = (Double)calculationData.get("doneStoryPoints");
        Double totalStoryPoints = (Double)calculationData.get("totalStoryPoints");
        Double doneTeamItems = (Double)calculationData.get("doneTeamItems");
        Double totalTeamItems = (Double)calculationData.get("totalTeamItems");
        Double doneTeamItemsStoryPoints = (Double)calculationData.get("doneTeamItemsStoryPoints");
        Double totalTeamItemsStoryPoints = (Double)calculationData.get("totalTeamItemsStoryPoints");
        if (completionCriteria.equals("LINKED_ITEM_STATUS")) {
            if (totalDoneItems > 0.0) {
                completion = doneItems / totalDoneItems * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals("CHILDREN_LINKED_ITEM_STATUS")) {
            if (totalChildItems > 0.0) {
                completion = doneChildItems / totalChildItems * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals("CHILDREN_LINKED_ITEM_ESTIMATE")) {
            if (totalStoryPoints > 0.0) {
                completion = doneStoryPoints / totalStoryPoints * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals("TEAM_STORY_STATUS")) {
            if (totalTeamItems > 0.0) {
                completion = doneTeamItems / totalTeamItems * 100.0;
                completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
            }
        } else if (completionCriteria.equals("TEAM_STORY_ESTIMATE") && totalTeamItemsStoryPoints > 0.0) {
            completion = doneTeamItemsStoryPoints / totalTeamItemsStoryPoints * 100.0;
            completion = (double)Math.round((completion + Math.ulp(completion)) * 100.0) / 100.0;
        }
        return completion;
    }

    public List<BaseItem> filteredObjectivesGroupsList(List<BaseItem> objectiveGroupList, String sessionId, String jiraKey, String tfsId, String itemId, List<String> teamsList) {
        ArrayList<BaseItem> filteredGroupList = new ArrayList<BaseItem>();
        for (int i = objectiveGroupList.size() - 1; i >= 0; --i) {
            Boolean foundInGroup = false;
            BaseItem objGroup = objectiveGroupList.get(i);
            List objectives = objGroup.getBaseItemList();
            BaseItemLink teamIdLink = null;
            for (BaseItemLink link : objGroup.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getTeamId())) continue;
                teamIdLink = link;
                break;
            }
            if (!PropertyValidator.isValid((Collection)objectives) || !PropertyValidator.isValid(teamIdLink) || !PropertyValidator.isValid((Object)teamIdLink.getTeamId()) || !teamIdLink.getTeamId().equals("0") && (teamIdLink.getTeamId().equals("0") || !teamsList.contains(teamIdLink.getTeamId()))) continue;
            for (int j = objectives.size() - 1; j >= 0; --j) {
                Boolean foundInObjective = false;
                BaseItem obj = (BaseItem)objectives.get(j);
                if (PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                    for (BaseItemLink objLink : obj.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)objLink.getSessionId()) || !objLink.getSessionId().equals(sessionId) || !PropertyValidator.isValid((Object)objLink.getItemId())) continue;
                        Map linkedItemById = objLink.getLinkedItemById();
                        Iterator iterator = linkedItemById.entrySet().iterator();
                        Boolean foundAsRestored = false;
                        while (iterator.hasNext()) {
                            Map.Entry pair = iterator.next();
                            HashMap linkedItemDataMap = (HashMap)pair.getValue();
                            String jiraKeyFound = (String)linkedItemDataMap.get("jiraKey");
                            String tfsIdFound = (String)linkedItemDataMap.get("tfsId");
                            foundAsRestored = PropertyValidator.isValid((Object)jiraKeyFound) && jiraKeyFound.equals(jiraKey) || PropertyValidator.isValid((Object)tfsIdFound) && tfsIdFound.equals(tfsId);
                        }
                        foundInObjective = objLink.getItemId().equals(itemId) || foundAsRestored != false;
                        if (!foundInObjective.booleanValue()) continue;
                        foundInGroup = true;
                        break;
                    }
                }
                List okrs = obj.getBaseItemList();
                if (!foundInObjective.booleanValue() && PropertyValidator.isValid((Collection)okrs)) {
                    for (int k = okrs.size() - 1; k >= 0; --k) {
                        BaseItem okr = (BaseItem)okrs.get(k);
                        if (PropertyValidator.isValid((Collection)okr.getBaseItemLinks())) {
                            for (BaseItemLink okrLink : okr.getBaseItemLinks()) {
                                if (!PropertyValidator.isValid((Object)okrLink.getSessionId()) || !okrLink.getSessionId().equals(sessionId) || !PropertyValidator.isValid((Object)okrLink.getItemId())) continue;
                                Map linkedItemById = okrLink.getLinkedItemById();
                                Iterator iterator = linkedItemById.entrySet().iterator();
                                Boolean foundAsRestored = false;
                                while (iterator.hasNext()) {
                                    Map.Entry pair = iterator.next();
                                    HashMap linkedItemDataMap = (HashMap)pair.getValue();
                                    String jiraKeyFound = (String)linkedItemDataMap.get("jiraKey");
                                    String tfsIdFound = (String)linkedItemDataMap.get("tfsId");
                                    foundAsRestored = PropertyValidator.isValid((Object)jiraKeyFound) && jiraKeyFound.equals(jiraKey) || PropertyValidator.isValid((Object)tfsIdFound) && tfsIdFound.equals(tfsId);
                                }
                                foundInObjective = okrLink.getItemId().equals(itemId) || foundAsRestored != false;
                                if (!foundInObjective.booleanValue()) continue;
                                foundInGroup = true;
                                break;
                            }
                        }
                        if (!foundInObjective.booleanValue()) continue;
                        foundInGroup = true;
                        break;
                    }
                }
                if (foundInObjective.booleanValue()) continue;
                objectives.remove(j);
            }
            if (!foundInGroup.booleanValue()) continue;
            objGroup.setBaseItemList(objectives);
            filteredGroupList.add(0, objGroup);
            objectiveGroupList.remove(i);
        }
        return filteredGroupList;
    }

    public List<BaseItem> getObjectiveGroupsWithoutItems(Boolean isMockingMode, String sessionId) {
        List<Object> objectiveGroupList = new ArrayList<BaseItem>();
        ArrayList<ObjectId> objectiveIds = new ArrayList<ObjectId>();
        Boolean isOkrEnabled = false;
        ArrayList<BaseItemLink> objectiveAndOkrBaseItemLinks = new ArrayList<BaseItemLink>();
        HashMap<String, BaseItemLink> groupBaseItemIds = new HashMap<String, BaseItemLink>();
        ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessionId);
        if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
        }
        ArrayList<BaseItemLink> baseItemLinks = new ArrayList<BaseItemLink>();
        List all = this.loadBaseItemLinksBySessionIdAndType(Boolean.valueOf(false), sessionId);
        for (Object baseItemLink : all) {
            if (PropertyValidator.isValid((Object)baseItemLink) && PropertyValidator.isValid((Object)baseItemLink.getItemId())) {
                objectiveAndOkrBaseItemLinks.add((BaseItemLink)baseItemLink);
            }
            if (PropertyValidator.isValid((Object)baseItemLink.getType()) && baseItemLink.getType().equals("Objective-Group")) {
                baseItemLinks.add((BaseItemLink)baseItemLink);
            }
            groupBaseItemIds.put(baseItemLink.getId(), (BaseItemLink)baseItemLink);
        }
        if (PropertyValidator.isValid(baseItemLinks)) {
            objectiveGroupList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
            LOGGER.debug("Objective Groups of size " + objectiveGroupList.size() + " Found");
            if (PropertyValidator.isValid(objectiveGroupList)) {
                List objectivesList;
                LOGGER.debug("Going to fetch Objectives With Linked Items With in a Group............");
                HashMap<String, List> objectiveMappedByGroup = new HashMap<String, List>();
                for (BaseItem baseItem : objectiveGroupList) {
                    baseItem.links(groupBaseItemIds);
                    for (Object link : baseItem.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive()) continue;
                        if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(link.getBaseItemId())))) {
                            objectiveMappedByGroup.put(link.getBaseItemId(), new ArrayList());
                        }
                        List objGroups = (List)objectiveMappedByGroup.get(link.getBaseItemId());
                        objGroups.add(baseItem);
                        objectiveMappedByGroup.put(link.getBaseItemId(), objGroups);
                        objectiveIds.add(new ObjectId(link.getBaseItemId()));
                    }
                    Status status = baseItem.getStatus();
                    status = new Status(status.getId(), status.getTitle(), status.getColor(), status.getCategory());
                    baseItem.setStatus(status);
                }
                if (PropertyValidator.isValid(objectiveIds) && PropertyValidator.isValid((Collection)(objectivesList = this.loadObjectivesByBaseItemId(objectiveIds)))) {
                    HashMap<String, BaseItem> hashMap = new HashMap<String, BaseItem>();
                    ArrayList<ObjectId> keyResultsIds = new ArrayList<ObjectId>();
                    for (BaseItem objective : objectivesList) {
                        if (PropertyValidator.isValid((Object)objective.getStatus())) {
                            Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                            objective.setStatus(status);
                        }
                        if (!isMockingMode.booleanValue()) {
                            objective.links(groupBaseItemIds);
                        }
                        if (!PropertyValidator.isValid((Collection)((Collection)objectiveMappedByGroup.get(objective.getId())))) continue;
                        List parents = (List)objectiveMappedByGroup.get(objective.getId());
                        for (BaseItem parent : parents) {
                            this.setBaseItemInParent(parent, objective);
                            if (!isOkrEnabled.booleanValue()) continue;
                            for (int i = objective.getBaseItemLinks().size() - 1; i >= 0; --i) {
                                BaseItemLink link = (BaseItemLink)objective.getBaseItemLinks().get(i);
                                if (link.isArchive()) {
                                    objective.getBaseItemLinks().remove(i);
                                    continue;
                                }
                                if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getLinkType()) || link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode())) continue;
                                keyResultsIds.add(new ObjectId(link.getBaseItemId()));
                                hashMap.put(link.getBaseItemId(), objective);
                            }
                        }
                    }
                    if (isOkrEnabled.booleanValue() && PropertyValidator.isValid(keyResultsIds)) {
                        List keyResultsList = this.loadObjectivesByBaseItemId(keyResultsIds);
                        keyResultsList.forEach(keyResult -> {
                            if (!isMockingMode.booleanValue()) {
                                keyResult.links((Map)groupBaseItemIds);
                            }
                            if (PropertyValidator.isValid((Object)keyResult.getStatus())) {
                                Status status = new Status(keyResult.getStatus().getId(), keyResult.getStatus().getTitle(), keyResult.getStatus().getColor(), keyResult.getStatus().getCategory());
                                keyResult.setStatus(status);
                            }
                            this.setBaseItemInParent((BaseItem)keyResultMappedByObjective.get(keyResult.getId()), keyResult);
                        });
                    }
                }
            }
        }
        return objectiveGroupList;
    }

    public HashMap<String, Object> calculateObjectiveGroupsCompletionForPiBoard(HashMap<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Double> completionById = new HashMap<String, Double>();
        ArrayList<String> okrLinkedObjectivesIdsMap = new ArrayList<String>();
        List okrWeightsList = new ArrayList();
        List groupWeightsList = new ArrayList();
        String sessionId = (String)requestBody.get("sessionId");
        String completionCriteria = (String)requestBody.get("completionCriteria");
        List objectiveGroups = this.getObjectivesList(sessionId);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (BaseItem group : objectiveGroups) {
            groupIds.add(group.getId());
            if (!PropertyValidator.isValid((Collection)group.getBaseItemList())) continue;
            for (BaseItem obj : group.getBaseItemList()) {
                if (!PropertyValidator.isValid((Collection)obj.getBaseItemList())) continue;
                for (BaseItem okr : obj.getBaseItemList()) {
                    if (!PropertyValidator.isValid((Collection)okr.getBaseItemLinks())) continue;
                    for (BaseItemLink link : okr.getBaseItemLinks()) {
                        if (!PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
                        okrLinkedObjectivesIdsMap.add(link.getBaseItemId());
                    }
                }
            }
        }
        List okrProgressCriteriaGroupFields = this.getOkrProgressCriteriaGroupFields();
        HashMap groupBaseItemIds = new HashMap();
        ModuleConfiguration objectiveMenuPermission = this.objectiveMenuPermissionsRepository.findOneBySessionId(sessionId);
        Boolean isOkrEnabled = false;
        if (PropertyValidator.isValid((Object)objectiveMenuPermission)) {
            isOkrEnabled = objectiveMenuPermission.getOkrEnabled();
        }
        HashMap<String, Team> objTeamsMap = new HashMap<String, Team>();
        if (PropertyValidator.isValid((Object)completionCriteria) && (completionCriteria.equals("TEAM_STORY_STATUS") || completionCriteria.equals("TEAM_STORY_ESTIMATE")) || !PropertyValidator.isValid((Object)completionCriteria)) {
            ArrayList<String> teamIds = new ArrayList<String>();
            for (BaseItem group : objectiveGroups) {
                List grpBaseItemLinks = group.getBaseItemLinks();
                if (grpBaseItemLinks.size() <= 0 || !PropertyValidator.isValid((Object)((BaseItemLink)grpBaseItemLinks.get(0)).getTeamId())) continue;
                teamIds.add(((BaseItemLink)grpBaseItemLinks.get(0)).getTeamId());
            }
            List objectiveTeams = new ArrayList();
            objectiveTeams = this.teamRepository.findByIdIn(teamIds);
            for (Team team : objectiveTeams) {
                objTeamsMap.put(team.getId(), team);
            }
        }
        StatsExclusion statsExclusion = this.statsExclusionRepository.findBySessionIdAndViewType(sessionId, "Objectives");
        Map excludedItems = null;
        if (PropertyValidator.isValid((Object)statsExclusion)) {
            excludedItems = statsExclusion.getExcludedItems();
        }
        for (BaseItem group : objectiveGroups) {
            if (!PropertyValidator.isValid((Collection)group.getBaseItemList())) continue;
            if (!objectiveMenuPermission.getUnCommittedEnabled()) {
                List objList = group.getBaseItemList();
                HashMap<String, Boolean> uncommittedObjById = new HashMap<String, Boolean>();
                for (int i = objList.size() - 1; i >= 0; --i) {
                    if (!((BaseItem)objList.get(i)).getType().equals("Objective-Uncommitted")) continue;
                    uncommittedObjById.put(((BaseItem)objList.get(i)).getId(), true);
                    objList.remove(i);
                }
                if (!uncommittedObjById.isEmpty()) {
                    group.setBaseItemList(objList);
                    List links = group.getBaseItemLinks();
                    for (int i = links.size() - 1; i >= 0; --i) {
                        if (!uncommittedObjById.containsKey(((BaseItemLink)links.get(i)).getBaseItemId())) continue;
                        links.remove(i);
                    }
                    group.setBaseItemLinks(links);
                }
            }
            groupWeightsList.clear();
            groupWeightsList = this.getWeightsListOfObjectiveOrGroup(group, Boolean.valueOf(false));
            Double valueOfXForGroup = this.calculateValueOfSingleX(groupWeightsList);
            HashMap calculationCounts = new HashMap();
            Double groupCompletion = 0.0;
            Team objTeam = null;
            if (PropertyValidator.isValid((Object)((BaseItemLink)group.getBaseItemLinks().get(0)).getTeamId())) {
                objTeam = (Team)objTeamsMap.get(((BaseItemLink)group.getBaseItemLinks().get(0)).getTeamId());
            }
            for (BaseItem _obj : group.getBaseItemList()) {
                HashMap calculationData;
                HashMap groupTempMap = new HashMap();
                for (HashMap groupWeightMap : groupWeightsList) {
                    if (!((String)groupWeightMap.get("baseItemId")).equals(_obj.getId())) continue;
                    groupTempMap = groupWeightMap;
                }
                okrWeightsList.clear();
                Boolean isItemLinked = PropertyValidator.isValid((Collection)_obj.getLinkedItems());
                okrWeightsList = this.getWeightsListOfObjectiveOrGroup(_obj, isItemLinked);
                Double completion = 0.0;
                Double objCompletion = 0.0;
                Double objLinkedOkrCompletion = 0.0;
                Double valueOfX = 1.0;
                if (PropertyValidator.isValid((Object)completionCriteria)) {
                    calculationData = this.calculateCompletion(_obj, false, completionCriteria, objTeam, null, null, excludedItems);
                    objCompletion = (Double)calculationData.get("completion");
                    for (Map.Entry set : calculationData.entrySet()) {
                        if (((String)set.getKey()).equals("completion")) continue;
                        Double sum = calculationCounts.getOrDefault(set.getKey(), 0.0) + (Double)set.getValue();
                        calculationCounts.put(set.getKey(), sum);
                    }
                } else {
                    valueOfX = this.calculateValueOfSingleX(okrWeightsList);
                    calculationData = this.calculateCompletion(_obj, false, completionCriteria, objTeam, null, null, excludedItems);
                    objCompletion = (Double)calculationData.get("completion") * (_obj.getLinkedCardWeights() * valueOfX / 100.0);
                }
                if (PropertyValidator.isValid((Collection)_obj.getBaseItemList())) {
                    for (BaseItem okr : _obj.getBaseItemList()) {
                        HashMap calculationData2 = this.calculateCompletion(okr, false, null, null, null, null, excludedItems);
                        Double okrCompletion = this.calculateOkrCompletion(okr, false, (Double)calculationData2.get("completion"), okrWeightsList, excludedItems);
                        HashMap tempMap = new HashMap();
                        for (HashMap okrWeightMap : okrWeightsList) {
                            if (!((String)okrWeightMap.get("baseItemId")).equals(okr.getId())) continue;
                            tempMap = okrWeightMap;
                        }
                        if (!PropertyValidator.isValid(tempMap)) continue;
                        objLinkedOkrCompletion = objLinkedOkrCompletion + okrCompletion * (Double.parseDouble((String)tempMap.get("weightage")) * valueOfX / 100.0);
                    }
                    for (BaseItem okr : _obj.getBaseItemList()) {
                        completion = !PropertyValidator.isValid((Object)completionCriteria) ? Double.valueOf(objCompletion + objLinkedOkrCompletion) : objCompletion;
                        completion = (double)Math.round(completion * 100.0) / 100.0;
                    }
                    completionById.put(_obj.getId(), completion);
                } else {
                    completion = objCompletion;
                    completion = (double)Math.round(completion * 100.0) / 100.0;
                    completionById.put(_obj.getId(), completion);
                }
                if (PropertyValidator.isValid((Object)completionCriteria)) continue;
                groupCompletion = groupCompletion + completion * (Double.parseDouble((String)groupTempMap.get("weightage")) * valueOfXForGroup / 100.0);
            }
            if (PropertyValidator.isValid((Object)completionCriteria)) {
                groupCompletion = this.calculateCompletionOnOldFormulas(calculationCounts, completionCriteria);
            }
            completionById.put(group.getId(), (double)Math.round(groupCompletion * 100.0) / 100.0);
        }
        response.put("completionById", completionById);
        return response;
    }

    public HashMap<String, Object> updateBaseItemLinkSequence(HashMap<String, Object> requestBody) throws Exception {
        BaseItemLink baseItemLink;
        HashMap<String, Object> response = new HashMap<String, Object>();
        String baseItemLinkId = "";
        if (requestBody.containsKey("baseItemLinkId")) {
            baseItemLinkId = (String)requestBody.get("baseItemLinkId");
        }
        Object sequenceObj = requestBody.get("sequence");
        Double sequence = null;
        if (sequenceObj instanceof Long) {
            sequence = ((Long)sequenceObj).doubleValue();
        } else if (sequenceObj instanceof Double) {
            sequence = (Double)sequenceObj;
        } else if (sequenceObj instanceof Integer) {
            sequence = ((Integer)sequenceObj).doubleValue();
        }
        if (PropertyValidator.isValid((Object)baseItemLinkId) && PropertyValidator.isValid((Object)sequence) && PropertyValidator.isValid((Object)(baseItemLink = this.baseItemLinkRepository.findById(baseItemLinkId)))) {
            baseItemLink.setSequence(sequence);
            BaseItemLink saved = (BaseItemLink)this.baseItemLinkRepository.save((Object)baseItemLink);
            response.put("baseItemLink", saved);
            return response;
        }
        return response;
    }

    public Map<String, Object> createDataForOKRsProgress(Map<String, Object> requestStr) throws Exception {
        boolean errorCase;
        LocalDate localDate;
        String dateString;
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String radioTypeSelection = "";
        String interval = "";
        String okrSelection = "";
        Date startDate = null;
        Date endDate = null;
        String criteriaCalculation = "";
        String completionCriteria = "";
        String objCompletionCriteria = "";
        String sessionBoardId = "";
        String sessionId = "";
        Map excludeItemsData = null;
        List groupIds = new ArrayList();
        boolean isPiView = false;
        boolean isOkrEnabled = false;
        boolean unCommittedObjectivesEnabled = true;
        boolean isArtView = false;
        if (PropertyValidator.isValid((Object)requestStr.get("interval"))) {
            interval = (String)requestStr.get("interval");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("radioTypeSelection"))) {
            radioTypeSelection = (String)requestStr.get("radioTypeSelection");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("okrSelection"))) {
            okrSelection = (String)requestStr.get("okrSelection");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("interval"))) {
            interval = (String)requestStr.get("interval");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("criteriaCalculation"))) {
            criteriaCalculation = (String)requestStr.get("criteriaCalculation");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("objCompletionCriteria"))) {
            objCompletionCriteria = (String)requestStr.get("objCompletionCriteria");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("sessionBoardId"))) {
            sessionBoardId = (String)requestStr.get("sessionBoardId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("sessionId"))) {
            sessionId = (String)requestStr.get("sessionId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("groupIds"))) {
            groupIds = (List)requestStr.get("groupIds");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("isPiView"))) {
            isPiView = (Boolean)requestStr.get("isPiView");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("isOkrEnabled"))) {
            isOkrEnabled = (Boolean)requestStr.get("isOkrEnabled");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("isArtView"))) {
            isArtView = (Boolean)requestStr.get("isArtView");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("unCommittedObjectivesEnabled"))) {
            unCommittedObjectivesEnabled = (Boolean)requestStr.get("unCommittedObjectivesEnabled");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("startDate"))) {
            dateString = (String)requestStr.get("startDate");
            localDate = LocalDate.parse(dateString);
            LocalDateTime dateTimeAtEndOfPreviousDay = localDate.atTime(LocalTime.MIN);
            startDate = Date.from(dateTimeAtEndOfPreviousDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (PropertyValidator.isValid((Object)requestStr.get("endDate"))) {
            dateString = (String)requestStr.get("endDate");
            localDate = LocalDate.parse(dateString);
            LocalDateTime dateTimeAtEndOfCurrentDay = localDate.atTime(LocalTime.MAX);
            endDate = Date.from(dateTimeAtEndOfCurrentDay.atZone(ZoneId.systemDefault()).toInstant());
        }
        if (PropertyValidator.isValid((Object)requestStr.get("excludeItemsData"))) {
            excludeItemsData = (Map)requestStr.get("excludeItemsData");
        }
        Date today = new Date();
        if (!PropertyValidator.isValid(startDate) || !PropertyValidator.isValid(endDate) || endDate.before(startDate) || startDate.after(today)) {
            resultMap.put("errorCase", true);
            return resultMap;
        }
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        TimeSeriesSyncStatus baseItemSyncStatus = this.timeSeriesSyncStatusRepository.findByItemTypeAndTenant("baseItem", tenant);
        Date syncDate = null;
        if (null != baseItemSyncStatus) {
            syncDate = baseItemSyncStatus.getCreatedOn();
            if (startDate.before(syncDate) && endDate.after(syncDate)) {
                startDate = syncDate;
            }
        } else {
            syncDate = startDate;
        }
        TimeSeriesUtils timeSeriesUtils = new TimeSeriesUtils(this.mongoTemplate, this.statusRepository);
        List intervalDates = timeSeriesUtils.divideIntervals(startDate, endDate, interval);
        startDate = (Date)intervalDates.get(0);
        endDate = (Date)intervalDates.get(intervalDates.size() - 1);
        Map timeSeriesDataMap = this.timeSeriesRepository.getBacklogItemTimeSeriesWithLevel(interval, okrSelection, startDate, endDate, criteriaCalculation, groupIds, intervalDates, isPiView, isOkrEnabled, excludeItemsData, unCommittedObjectivesEnabled, syncDate, sessionBoardId, sessionId, isArtView);
        Map itemData = (Map)timeSeriesDataMap.get("datedBaseItemsMap");
        if (timeSeriesDataMap.containsKey("errorCase") && (errorCase = ((Boolean)timeSeriesDataMap.get("errorCase")).booleanValue())) {
            resultMap.put("errorCase", errorCase);
            return resultMap;
        }
        Map progressMap = this.timeSeriesRepository.calculateProgressForOKRs(itemData, okrSelection, completionCriteria, criteriaCalculation, objCompletionCriteria, isPiView, isOkrEnabled, excludeItemsData);
        resultMap = this.timeSeriesRepository.getItemsForOKRProgress(progressMap, interval, intervalDates, radioTypeSelection);
        Map itemIds = (Map)timeSeriesDataMap.get("itemKeys");
        Map itemTitles = (Map)timeSeriesDataMap.get("itemTitles");
        resultMap.put("errorCase", false);
        resultMap.put("itemIdsMap", itemIds);
        resultMap.put("itemTitlesMap", itemTitles);
        resultMap.put("progress", progressMap);
        resultMap.put("intervals", interval);
        return resultMap;
    }

    public HashMap<String, Integer> getObjectiveGroupLinkedObjectivesCount(List<String> groupIds) throws Exception {
        HashMap<String, Integer> groupLinkedObjectivesCount = new HashMap<String, Integer>();
        List objectiveGroups = this.baseItemRepository.findByIdIn(groupIds, BaseItemProjectionBaseItemLinks.class);
        for (BaseItemProjectionBaseItemLinks group : objectiveGroups) {
            int count = 0;
            if (PropertyValidator.isValid((Collection)group.getBaseItemLinks())) {
                for (BaseItemLink obj : group.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)obj.getLinkType()) || !obj.getLinkType().equals(EnumKendis.CHILD_GROUP_OBJECTIVE.getCode()) || obj.isArchive()) continue;
                    ++count;
                }
            }
            groupLinkedObjectivesCount.put(group.getId(), count);
        }
        return groupLinkedObjectivesCount;
    }

    public HashMap<String, Integer> getObjectiveGroupLinkedObjectivesCount(List<String> groupIds, HashMap<String, Object> requestBody) throws Exception {
        String methodName = "getObjectiveGroupLinkedObjectivesCount";
        LOGGER.debug("{}: Starting filtered count calculation for {} groups", (Object)"getObjectiveGroupLinkedObjectivesCount", (Object)(groupIds != null ? groupIds.size() : 0));
        if (!PropertyValidator.isValid(groupIds) || groupIds.isEmpty()) {
            LOGGER.warn("{}: No group IDs provided, returning empty result", (Object)"getObjectiveGroupLinkedObjectivesCount");
            return new HashMap<String, Integer>();
        }
        if (requestBody == null) {
            LOGGER.warn("{}: No request body provided, falling back to unfiltered count", (Object)"getObjectiveGroupLinkedObjectivesCount");
            return this.getObjectiveGroupLinkedObjectivesCount(groupIds);
        }
        try {
            HashMap<String, Integer> groupLinkedObjectivesCount = new HashMap<String, Integer>();
            FilterContext filterContext = this.buildFilterContext(requestBody, "getObjectiveGroupLinkedObjectivesCount");
            if (this.shouldUseUnfilteredCount(filterContext, requestBody, "getObjectiveGroupLinkedObjectivesCount")) {
                LOGGER.debug("{}: No filters applied, using optimized unfiltered count", (Object)"getObjectiveGroupLinkedObjectivesCount");
                return this.getObjectiveGroupLinkedObjectivesCount(groupIds);
            }
            ObjectiveGroupMapping groupMapping = this.buildObjectiveGroupMapping(groupIds, "getObjectiveGroupLinkedObjectivesCount");
            if (groupMapping == null) {
                return new HashMap<String, Integer>();
            }
            this.initializeGroupCounts(groupMapping.objectiveGroups, groupLinkedObjectivesCount);
            int totalFilteredCount = this.applyFiltersAndCount(groupMapping, filterContext, requestBody, groupLinkedObjectivesCount, "getObjectiveGroupLinkedObjectivesCount");
            LOGGER.debug("{}: Completed filtered count calculation. Total objectives after filtering: {}", (Object)"getObjectiveGroupLinkedObjectivesCount", (Object)totalFilteredCount);
            return groupLinkedObjectivesCount;
        }
        catch (Exception e) {
            LOGGER.error("{}: Error calculating filtered objective counts. Group IDs: {}, Error: {}", new Object[]{"getObjectiveGroupLinkedObjectivesCount", groupIds, e.getMessage(), e});
            LOGGER.info("{}: Falling back to unfiltered count due to error", (Object)"getObjectiveGroupLinkedObjectivesCount");
            return this.getObjectiveGroupLinkedObjectivesCount(groupIds);
        }
    }

    private FilterContext buildFilterContext(HashMap<String, Object> requestBody, String methodName) {
        try {
            FilterContext ctx = new FilterContext(null);
            ctx.responsibles = (List)requestBody.get("responsibles");
            ctx.statuses = (List)requestBody.get("statuses");
            ctx.collections = (List)requestBody.get("collections");
            ctx.responsibleFieldId = (String)requestBody.get("responsibleFieldId");
            ctx.krResponsibleFieldId = (String)requestBody.get("krResponsibleFieldId");
            ctx.searchQuery = requestBody.containsKey("searchQuery") ? ((String)requestBody.get("searchQuery")).toLowerCase() : null;
            this.logActiveFilters(ctx, methodName);
            return ctx;
        }
        catch (ClassCastException e) {
            LOGGER.warn("{}: Invalid filter parameter types in request body: {}", (Object)methodName, (Object)e.getMessage());
            return new FilterContext(null);
        }
    }

    private void logActiveFilters(FilterContext ctx, String methodName) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder activeFilters = new StringBuilder();
            if (ctx.hasResponsibles()) {
                activeFilters.append("responsibles(").append(ctx.responsibles.size()).append(") ");
            }
            if (ctx.hasStatuses()) {
                activeFilters.append("statuses(").append(ctx.statuses.size()).append(") ");
            }
            if (ctx.hasCollections()) {
                activeFilters.append("collections(").append(ctx.collections.size()).append(") ");
            }
            if (ctx.hasSearchQuery()) {
                activeFilters.append("search('").append(ctx.searchQuery).append("') ");
            }
            if (activeFilters.length() > 0) {
                LOGGER.debug("{}: Active filters: {}", (Object)methodName, (Object)activeFilters.toString().trim());
            } else {
                LOGGER.debug("{}: No standard filters active", (Object)methodName);
            }
        }
    }

    private boolean shouldUseUnfilteredCount(FilterContext ctx, HashMap<String, Object> requestBody, String methodName) {
        if (ctx.hasResponsibles() || ctx.hasStatuses() || ctx.hasCollections() || ctx.hasSearchQuery()) {
            return false;
        }
        try {
            boolean hasTimeFilters;
            List years = (List)requestBody.get("years");
            List uniqueTags = (List)requestBody.get("uniqueTags");
            boolean bl = hasTimeFilters = PropertyValidator.isValid((Collection)years) || PropertyValidator.isValid((Collection)uniqueTags);
            if (hasTimeFilters) {
                LOGGER.debug("{}: Time period filters detected - years: {}, tags: {}", new Object[]{methodName, years != null ? years.size() : 0, uniqueTags != null ? uniqueTags.size() : 0});
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            LOGGER.warn("{}: Invalid time filter parameter types: {}", (Object)methodName, (Object)e.getMessage());
            return false;
        }
    }

    private ObjectiveGroupMapping buildObjectiveGroupMapping(List<String> groupIds, String methodName) {
        try {
            List objectiveGroups = this.baseItemRepository.findByIdIn(groupIds, BaseItemProjectionBaseItemLinks.class);
            if (!PropertyValidator.isValid((Collection)objectiveGroups)) {
                LOGGER.warn("{}: No objective groups found for provided IDs", (Object)methodName);
                return null;
            }
            HashSet<String> allObjectiveIds = new HashSet<String>();
            HashMap<String, String> objectiveToGroupMap = new HashMap<String, String>();
            for (BaseItemProjectionBaseItemLinks group : objectiveGroups) {
                if (!PropertyValidator.isValid((Collection)group.getBaseItemLinks())) continue;
                int objectiveCount = 0;
                for (BaseItemLink link : group.getBaseItemLinks()) {
                    if (!this.isValidObjectiveLink(link)) continue;
                    allObjectiveIds.add(link.getBaseItemId());
                    objectiveToGroupMap.put(link.getBaseItemId(), group.getId());
                    ++objectiveCount;
                }
                LOGGER.debug("{}: Group {} has {} linked objectives", new Object[]{methodName, group.getId(), objectiveCount});
            }
            LOGGER.debug("{}: Built mapping for {} total objectives across {} groups", new Object[]{methodName, allObjectiveIds.size(), objectiveGroups.size()});
            return new ObjectiveGroupMapping(objectiveGroups, allObjectiveIds, objectiveToGroupMap);
        }
        catch (Exception e) {
            LOGGER.error("{}: Error building objective group mapping: {}", new Object[]{methodName, e.getMessage(), e});
            return null;
        }
    }

    private boolean isValidObjectiveLink(BaseItemLink link) {
        return PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getLinkType()) && link.getLinkType().equals(EnumKendis.CHILD_GROUP_OBJECTIVE.getCode()) && !link.isArchive();
    }

    private void initializeGroupCounts(List<BaseItemProjectionBaseItemLinks> objectiveGroups, HashMap<String, Integer> groupLinkedObjectivesCount) {
        for (BaseItemProjectionBaseItemLinks group : objectiveGroups) {
            groupLinkedObjectivesCount.put(group.getId(), 0);
        }
    }

    private int applyFiltersAndCount(ObjectiveGroupMapping groupMapping, FilterContext filterContext, HashMap<String, Object> requestBody, HashMap<String, Integer> groupLinkedObjectivesCount, String methodName) throws Exception {
        List objectives;
        if (groupMapping.allObjectiveIds.isEmpty()) {
            LOGGER.debug("{}: No objectives to filter", (Object)methodName);
            return 0;
        }
        try {
            objectives = this.baseItemRepository.findByIdIn(new ArrayList(groupMapping.allObjectiveIds));
            LOGGER.debug("{}: Fetched {} objectives for filtering", (Object)methodName, (Object)objectives.size());
        }
        catch (Exception e) {
            LOGGER.error("{}: Error fetching objectives for filtering: {}", new Object[]{methodName, e.getMessage(), e});
            throw e;
        }
        try {
            objectives = this.filterListOfObjecttivesAccordingToTimePeriods(requestBody, objectives, 1);
            LOGGER.debug("{}: After time period filtering: {} objectives remain", (Object)methodName, (Object)objectives.size());
        }
        catch (Exception e) {
            LOGGER.error("{}: Error applying time period filters: {}", new Object[]{methodName, e.getMessage(), e});
            throw e;
        }
        int totalMatches = 0;
        for (BaseItem objective : objectives) {
            try {
                if (!this.passesFilter(objective, filterContext)) continue;
                String groupId = (String)groupMapping.objectiveToGroupMap.get(objective.getId());
                if (groupId != null) {
                    groupLinkedObjectivesCount.put(groupId, groupLinkedObjectivesCount.getOrDefault(groupId, 0) + 1);
                    ++totalMatches;
                    continue;
                }
                LOGGER.warn("{}: Objective {} passed filters but has no group mapping", (Object)methodName, (Object)objective.getId());
            }
            catch (Exception e) {
                LOGGER.warn("{}: Error filtering objective {}: {}", new Object[]{methodName, objective.getId(), e.getMessage()});
            }
        }
        return totalMatches;
    }

    public void exportTheme(HashMap<String, Object> requestBody, String exportRequestId) throws Exception {
        HashMap result = new HashMap();
        HashMap completionData = new HashMap();
        this.sendProgressUpdate(exportRequestId, 5, "Starting export process...");
        this.checkCancellation(exportRequestId);
        this.populateObjectiveGroupData(requestBody, exportRequestId, result, completionData);
        this.checkCancellation(exportRequestId);
        this.sendProgressUpdate(exportRequestId, 20, "Preparing export parameters...");
        Map exportParams = this.parseExportParameters(requestBody);
        String exportType = (String)exportParams.get("exportType");
        Object columnSelection = exportParams.get("columnSelection");
        this.checkCancellation(exportRequestId);
        String sessionId = (String)requestBody.get("sessionId");
        String collectionId = (String)requestBody.get("collectionId");
        String viewId = (String)requestBody.get("viewId");
        String exportName = this.getExportName(collectionId, viewId);
        HashMap exportResult = this.exportThing(result, exportType, columnSelection, completionData, exportRequestId, sessionId, exportName);
        this.sendProgressUpdate(exportRequestId, 100, "Export completed successfully!");
        this.sendFinalResult(exportRequestId, exportResult);
    }

    private void checkCancellation(String exportRequestId) throws Exception {
        if (Boolean.TRUE.equals(this.themeExportCancellationFlags.get(exportRequestId))) {
            this.finalizeCancellation(exportRequestId);
        }
    }

    private Map<String, Map<String, Object>> fetchLastComments(List<String> entityIds) throws Exception {
        if (entityIds == null || entityIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List allLastComments = this.conversationRepository.findByEntityTypeAndEntityIdInExcludingEmoji("BaseItem", entityIds, new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
        HashMap<String, Map<String, Object>> lastCommentMap = new HashMap<String, Map<String, Object>>();
        for (Conversation comment : allLastComments) {
            if (lastCommentMap.containsKey(comment.getEntityId())) continue;
            HashMap<String, Object> commentData = new HashMap<String, Object>();
            commentData.put("lastComment", comment.getText());
            commentData.put("lastCommentOn", comment.getCreatedOn());
            lastCommentMap.put(comment.getEntityId(), commentData);
        }
        return lastCommentMap;
    }

    private void populateObjectiveGroupData(HashMap<String, Object> requestBody, String exportRequestId, HashMap<String, Object> result, HashMap<String, Object> completionData) throws Exception {
        HashMap loadObjectivesRequestBody = this.prepareLoadObjectivesRequestBody(requestBody);
        HashMap loadObjectivesList = this.prepareLoadObjectivesList(requestBody);
        HashMap responseJson = this.loadObjectivesListByObjectId(loadObjectivesRequestBody);
        if (responseJson != null && responseJson.containsKey("objectiveGroups")) {
            List groupList = (List)responseJson.get("objectiveGroups");
            List groupIds = groupList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            loadObjectivesList.put("groupIds", groupIds);
            this.checkCancellation(exportRequestId);
            this.sendProgressUpdate(exportRequestId, 10, "Processing objective groups...");
            HashMap groupsResponse = this.getObjectivesOfSelectedGroup(loadObjectivesList);
            List groups = (List)groupsResponse.get("objectiveGroups");
            this.sortGroupsBySequence(groups);
            result.put("objectiveGroups", groups);
            this.checkCancellation(exportRequestId);
            HashMap fetchedCompletionData = this.fetchCompletionData(requestBody, groupIds);
            completionData.putAll(fetchedCompletionData);
        } else {
            result.put("objectiveGroups", new ArrayList());
        }
    }

    private HashMap<String, Object> fetchCompletionData(HashMap<String, Object> requestBody, List<String> groupIds) throws Exception {
        HashMap<String, Object> completionRequestBody = new HashMap<String, Object>();
        completionRequestBody.put("sessionId", requestBody.get("sessionId"));
        completionRequestBody.put("groupIds", groupIds);
        HashMap completionResponse = this.calculateCompletionForSelectGroups(completionRequestBody);
        return (HashMap)completionResponse.get("completionById");
    }

    private void sortGroupsBySequence(List<BaseItem> groups) throws Exception {
        if (PropertyValidator.isValid(groups)) {
            groups.sort((group1, group2) -> {
                Double sequence1 = group1.getSequence() != null ? group1.getSequence() : 0.0;
                Double sequence2 = group2.getSequence() != null ? group2.getSequence() : 0.0;
                return sequence1.compareTo(sequence2);
            });
        }
    }

    private Map<String, Object> parseExportParameters(HashMap<String, Object> requestBody) throws Exception {
        Object typeObject = requestBody.get("type");
        String exportType = null;
        String columnSelection = null;
        if (typeObject instanceof Map) {
            Map typeMap = (Map)typeObject;
            exportType = (String)typeMap.get("type");
            String selectionType = (String)typeMap.get("selectionType");
            columnSelection = "default".equals(selectionType) ? "default" : typeMap.get("selectedColumns");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("exportType", exportType);
        params.put("columnSelection", columnSelection);
        return params;
    }

    private HashMap<String, Object> prepareLoadObjectivesRequestBody(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> loadObjectivesRequestBody = new HashMap<String, Object>(requestBody);
        loadObjectivesRequestBody.remove("type");
        loadObjectivesRequestBody.remove("viewType");
        loadObjectivesRequestBody.remove("columnSelection");
        return loadObjectivesRequestBody;
    }

    private HashMap<String, Object> prepareLoadObjectivesList(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> loadObjectivesList = new HashMap<String, Object>(requestBody);
        loadObjectivesList.remove("type");
        loadObjectivesList.remove("viewType");
        loadObjectivesList.remove("columnSelection");
        loadObjectivesList.remove("requestId");
        loadObjectivesList.remove("viewId");
        loadObjectivesList.remove("isMockingMode");
        return loadObjectivesList;
    }

    private void finalizeCancellation(String requestId) throws Exception {
        this.themeExportCancellationFlags.remove(requestId);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("status", "cancelled");
        data.put("message", "Export operation was cancelled");
        PushResponse pr = new PushResponse();
        pr.setRequestId(requestId);
        pr.setResponseCompleted(Boolean.TRUE);
        pr.setContentType("JSON");
        pr.setData(data);
        this.pushResponseRepository.save((Object)pr);
    }

    public void cancelObjectiveExport(String exportRequestId) throws Exception {
        if (PropertyValidator.isValid((Object)exportRequestId)) {
            this.themeExportCancellationFlags.put(exportRequestId, true);
        }
    }

    private void sendProgressUpdate(String requestId, int progress, String message) throws Exception {
        HashMap<String, Object> progressData = new HashMap<String, Object>();
        progressData.put("progress", progress);
        progressData.put("message", message);
        progressData.put("completed", false);
        PushResponse progressResponse = new PushResponse();
        progressResponse.setRequestId(requestId);
        progressResponse.setResponseCompleted(Boolean.FALSE);
        progressResponse.setCompletion(Float.valueOf(progress));
        progressResponse.setData(progressData);
        progressResponse.setContentType("JSON");
        this.pushResponseRepository.save((Object)progressResponse);
    }

    private void sendFinalResult(String requestId, HashMap<String, Object> exportResult) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        PushResponse finalResponse = new PushResponse();
        finalResponse.setRequestId(requestId);
        finalResponse.setResponseCompleted(Boolean.TRUE);
        finalResponse.setCompletion(Float.valueOf(100.0f));
        String fileReferenceKey = UUID.randomUUID().toString();
        finalResponse.setFileReferenceKey(fileReferenceKey);
        MongoSyncUtils.storeData((String)fileReferenceKey, (String)mapper.writeValueAsString(exportResult), (AppConfig.MongoConfig)this.mongoConfig);
        finalResponse.setContentType("String");
        this.pushResponseRepository.save((Object)finalResponse);
    }

    private void sendErrorResult(String requestId, String errorMessage) throws Exception {
        HashMap<String, Object> errorData = new HashMap<String, Object>();
        errorData.put("error", errorMessage);
        errorData.put("completed", true);
        PushResponse errorResponse = new PushResponse();
        errorResponse.setRequestId(requestId);
        errorResponse.setResponseCompleted(Boolean.TRUE);
        errorResponse.setData(errorData);
        errorResponse.setContentType("JSON");
        this.pushResponseRepository.save((Object)errorResponse);
    }

    private HashMap<String, Object> exportThing(HashMap<String, Object> objectiveGroupsData, String exportType, Object columnSelection, HashMap<String, Object> completionData, String exportRequestId, String sessionId, String exportName) throws Exception {
        HashMap result = new HashMap();
        List selectedColumns = new ArrayList();
        if ("default".equals(columnSelection)) {
            selectedColumns = this.getAllAvailableExportColumns(true);
        } else if (columnSelection instanceof List) {
            List columnList = (List)columnSelection;
            if (columnList.isEmpty()) {
                selectedColumns = new ArrayList();
            } else if (PropertyValidator.isValid((Collection)columnList)) {
                selectedColumns = this.convertStringListToColumnObjects(columnList);
            }
        }
        result = "xls".equals(exportType) || "excel".equals(exportType) ? this.exportToExcel(objectiveGroupsData, selectedColumns, completionData, exportRequestId, sessionId, exportName) : ("csv".equals(exportType) ? this.exportToCSV(objectiveGroupsData, selectedColumns, completionData, exportRequestId, sessionId, exportName) : this.exportToExcel(objectiveGroupsData, selectedColumns, completionData, exportRequestId, sessionId, exportName));
        return result;
    }

    private List<HashMap<String, Object>> getAllAvailableExportColumns() throws Exception {
        return this.getAllAvailableExportColumns(false);
    }

    private List<HashMap<String, Object>> getAllAvailableExportColumns(boolean excludeDescription) throws Exception {
        String[][] columnData;
        ArrayList<HashMap<String, Object>> allColumns = new ArrayList<HashMap<String, Object>>();
        for (String[] column : columnData = new String[][]{{"hLevel", "H-Level"}, {"hType", "H-Type"}, {"itemId", "Item ID"}, {"title", "Title"}, {"description", "Description"}, {"immediateParentId", "Immediate Parent ID"}, {"immediateParentType", "Immediate Parent Type"}, {"objectiveGroupName", "Objective Group Name (L1)"}, {"timePeriod", "Time Period"}, {"status", "Status"}, {"progress", "Progress (%)"}, {"progressCriteria", "Progress Criteria"}, {"association", "Association"}, {"startDate", "Start Date"}, {"endDate", "End Date"}, {"lastUpdated", "Last Updated"}, {"responsible", "Responsible"}, {"objType", "OBJ Type"}, {"krProgressCriteria", "KR Progress Criteria"}, {"linkedItems", "Linked Items"}, {"krStartValue", "KR start value"}, {"krTargetValue", "KR Target Value"}, {"krProgress", "KR progress"}, {"lastComment", "Last Comment"}, {"lastCommentOn", "Last Comment On"}}) {
            if (excludeDescription && "description".equals(column[0])) continue;
            HashMap<String, String> columnObj = new HashMap<String, String>();
            columnObj.put("key", column[0]);
            columnObj.put("title", column[1]);
            allColumns.add(columnObj);
        }
        return allColumns;
    }

    private List<HashMap<String, Object>> convertStringListToColumnObjects(List<String> columnKeys) throws Exception {
        ArrayList<HashMap<String, Object>> columnObjects = new ArrayList<HashMap<String, Object>>();
        List allColumns = this.getAllAvailableExportColumns();
        HashMap<String, String> keyToTitleMap = new HashMap<String, String>();
        for (HashMap column : allColumns) {
            keyToTitleMap.put((String)column.get("key"), (String)column.get("title"));
        }
        for (String key : columnKeys) {
            HashMap<String, String> columnObj = new HashMap<String, String>();
            columnObj.put("key", key);
            columnObj.put("title", keyToTitleMap.getOrDefault(key, key));
            columnObjects.add(columnObj);
        }
        return columnObjects;
    }

    private HashMap<String, Object> exportToExcel(HashMap<String, Object> objectiveGroupsData, List<HashMap<String, Object>> selectedColumns, HashMap<String, Object> completionData, String exportRequestId, String sessionId, String exportName) throws Exception {
        List headers = this.prepareExportHeaders(selectedColumns);
        List items = this.processObjectiveGroupsForExport(objectiveGroupsData, selectedColumns, completionData, exportRequestId, sessionId);
        HashMap requestBody = this.prepareExportRequestBody(headers, items, exportName);
        ResponseEntity exportResponse = this.exportService.exportChartDetail("xlsx", requestBody);
        HashMap exportData = (HashMap)exportResponse.getBody();
        return this.handleExportResponse(exportData, "xlsx");
    }

    private HashMap<String, Object> exportToCSV(HashMap<String, Object> objectiveGroupsData, List<HashMap<String, Object>> selectedColumns, HashMap<String, Object> completionData, String exportRequestId, String sessionId, String exportName) throws Exception {
        List headers = this.prepareExportHeaders(selectedColumns);
        List items = this.processObjectiveGroupsForExport(objectiveGroupsData, selectedColumns, completionData, exportRequestId, sessionId);
        HashMap requestBody = this.prepareExportRequestBody(headers, items, exportName);
        ResponseEntity exportResponse = this.exportService.exportChartDetail("csv", requestBody);
        HashMap exportData = (HashMap)exportResponse.getBody();
        return this.handleExportResponse(exportData, "csv");
    }

    private List<Map<String, String>> prepareExportHeaders(List<HashMap<String, Object>> selectedColumns) throws Exception {
        ArrayList<Map<String, String>> headers = new ArrayList<Map<String, String>>();
        for (HashMap<String, Object> column : selectedColumns) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("header", (String)column.get("title"));
            headerMap.put("value", (String)column.get("key"));
            headers.add(headerMap);
        }
        return headers;
    }

    private List<HashMap<String, Object>> processObjectiveGroupsForExport(HashMap<String, Object> objectiveGroupsData, List<HashMap<String, Object>> selectedColumns, HashMap<String, Object> completionData, String exportRequestId, String sessionId) throws Exception {
        ArrayList<HashMap<String, Object>> items = new ArrayList<HashMap<String, Object>>();
        HashMap lastCommentMap = new HashMap();
        if (selectedColumns.isEmpty()) {
            LOGGER.info("No columns selected for export - creating empty CSV file");
        } else {
            List objectiveGroups = (List)objectiveGroupsData.get("objectiveGroups");
            int[] rowCounter = new int[]{0};
            if (objectiveGroups != null && !objectiveGroups.isEmpty()) {
                int groupsCount = objectiveGroups.size();
                double startProgress = 20.0;
                double endProgress = 90.0;
                double span = endProgress - startProgress;
                int index = 0;
                HashMap itemCache = new HashMap();
                for (BaseItem group : objectiveGroups) {
                    String groupTitle = group.getTitle() != null ? group.getTitle() : "Unknown";
                    String groupId = group.getKey();
                    this.processBaseItemRecursively(group, null, selectedColumns, items, completionData, rowCounter, 1, group, sessionId, null, itemCache, lastCommentMap);
                    int pct = (int)Math.round(startProgress + span * ((double)(++index) / (double)groupsCount));
                    if (pct > 90) {
                        pct = 90;
                    }
                    this.sendProgressUpdate(exportRequestId, pct, "Generating export file...");
                }
            }
        }
        return items;
    }

    private HashMap<String, Object> prepareExportRequestBody(List<Map<String, String>> headers, List<HashMap<String, Object>> items, String exportName) throws Exception {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("headers", headers);
        requestBody.put("items", items);
        requestBody.put("title", exportName);
        return requestBody;
    }

    private String getExportName(String collectionId, String viewId) throws Exception {
        ObjectiveCustomView customView;
        WorkSpace workSpace;
        if (PropertyValidator.isValid((Object)collectionId) && PropertyValidator.isValid((Object)(workSpace = this.workSpaceRepository.findById(collectionId))) && PropertyValidator.isValid((Object)workSpace.getTitle())) {
            return workSpace.getTitle();
        }
        if (PropertyValidator.isValid((Object)viewId) && PropertyValidator.isValid((Object)(customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)viewId)))) && PropertyValidator.isValid((Object)customView.getTitle())) {
            return customView.getTitle();
        }
        return "Legacy Global OKRs";
    }

    private HashMap<String, Object> handleExportResponse(HashMap<String, Object> exportData, String fileExtension) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (exportData != null && exportData.containsKey("srcPath")) {
            result.put("srcPath", exportData.get("srcPath"));
            result.put("name", exportData.get("name"));
        } else {
            String fileName = new Date().getTime() + "." + fileExtension;
            result.put("srcPath", URLEncoder.encode(fileName, "UTF-8"));
            result.put("name", URLEncoder.encode(fileName, "UTF-8"));
        }
        return result;
    }

    private void processBaseItemRecursively(BaseItem item, BaseItem parentGroup, List<HashMap<String, Object>> selectedColumns, List<HashMap<String, Object>> items, HashMap<String, Object> completionData, int[] rowCounter, int depth, BaseItem topGroup, String sessionId, BaseItem preFetchedObjectiveItem, Map<String, BaseItem> itemCache, Map<String, Map<String, Object>> lastComment) throws Exception {
        if (item == null || item.getId() == null) {
            return;
        }
        this.processCurrentItemRow(item, parentGroup, selectedColumns, items, completionData, rowCounter, depth, topGroup, sessionId, lastComment);
        this.processLinkedBacklogItems(item, selectedColumns, items, completionData, rowCounter, depth, topGroup, sessionId, lastComment);
        if (this.shouldStopRecursionForKR(item)) {
            return;
        }
        List childrenToRecurse = this.getChildrenToRecurse(item, depth, preFetchedObjectiveItem);
        if (!childrenToRecurse.isEmpty()) {
            this.fetchAndRecurseOnChildren(childrenToRecurse, item, selectedColumns, items, completionData, rowCounter, depth, topGroup, sessionId, itemCache, lastComment);
        }
    }

    private void processCurrentItemRow(BaseItem item, BaseItem parentGroup, List<HashMap<String, Object>> selectedColumns, List<HashMap<String, Object>> items, HashMap<String, Object> completionData, int[] rowCounter, int depth, BaseItem topGroup, String sessionId, Map<String, Map<String, Object>> lastComment) throws Exception {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("rowId", UUID.randomUUID().toString());
        for (HashMap<String, Object> column : selectedColumns) {
            String columnKey = (String)column.get("key");
            Object value = this.getFieldValue(item, parentGroup, columnKey, completionData, depth, topGroup, sessionId, lastComment);
            row.put(columnKey, value);
        }
        items.add(row);
        rowCounter[0] = rowCounter[0] + 1;
    }

    private void processLinkedBacklogItems(BaseItem item, List<HashMap<String, Object>> selectedColumns, List<HashMap<String, Object>> items, HashMap<String, Object> completionData, int[] rowCounter, int depth, BaseItem topGroup, String sessionId, Map<String, Map<String, Object>> lastComment) throws Exception {
        if (item.getBaseItemLinks() == null || item.getBaseItemLinks().isEmpty()) {
            return;
        }
        ArrayList<BaseItemLink> backlogItemLinks = new ArrayList<BaseItemLink>();
        for (BaseItemLink childLink : item.getBaseItemLinks()) {
            if (!"backLogItem".equals(childLink.getLinkType())) continue;
            backlogItemLinks.add(childLink);
        }
        if (!backlogItemLinks.isEmpty()) {
            this.processBacklogItemsByReleaseTrain(backlogItemLinks, item, selectedColumns, items, completionData, rowCounter, depth + 1, topGroup, sessionId, lastComment);
        }
    }

    private boolean shouldStopRecursionForKR(BaseItem item) throws Exception {
        if (!"KR".equals(item.getType())) {
            return false;
        }
        List fields = this.getFields(item);
        Optional<Fields> progress = fields.stream().filter(f -> "Progress Criteria".equalsIgnoreCase(f.getTitle())).findFirst();
        if (progress.isPresent()) {
            return "Target".equals(item.getFields().get(progress.get().getId()));
        }
        return false;
    }

    private List<BaseItem> getChildrenToRecurse(BaseItem item, int depth, BaseItem preFetchedObjectiveItem) throws Exception {
        ArrayList<BaseItem> childrenToRecurse = new ArrayList<BaseItem>();
        if (depth == 1) {
            if (PropertyValidator.isValid((Collection)item.getBaseItemList())) {
                childrenToRecurse.addAll(item.getBaseItemList());
            }
        } else {
            BaseItem objectiveItem = preFetchedObjectiveItem;
            if (PropertyValidator.isValid((Object)objectiveItem)) {
                String objectiveTitle = objectiveItem.getTitle() != null ? objectiveItem.getTitle() : "Unknown";
                String objectiveId = objectiveItem.getKey();
                List<String> typesToFilter = Arrays.asList("parent_objective", "parent_group_objective", "child_okr");
                ArrayList<String> baseItemIdsToRemove = new ArrayList<String>();
                if (objectiveItem.getBaseItemLinks() != null) {
                    for (BaseItemLink link : objectiveItem.getBaseItemLinks()) {
                        String linkType;
                        boolean isFilteredType;
                        if (link == null || !(isFilteredType = typesToFilter.contains(linkType = link.getLinkType())) || link.getBaseItemId() == null) continue;
                        baseItemIdsToRemove.add(link.getBaseItemId());
                    }
                }
                if (objectiveItem.getBaseItemList() != null) {
                    for (BaseItem baseItem : objectiveItem.getBaseItemList()) {
                        if (baseItem == null || baseItemIdsToRemove.contains(baseItem.getId())) continue;
                        childrenToRecurse.add(baseItem);
                    }
                }
            }
        }
        return childrenToRecurse;
    }

    private void fetchAndRecurseOnChildren(List<BaseItem> childrenToRecurse, BaseItem parentItem, List<HashMap<String, Object>> selectedColumns, List<HashMap<String, Object>> items, HashMap<String, Object> completionData, int[] rowCounter, int depth, BaseItem topGroup, String sessionId, Map<String, BaseItem> itemCache, Map<String, Map<String, Object>> lastCommentMap) throws Exception {
        List childObjectiveIds = childrenToRecurse.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList<String> idsToFetch = new ArrayList<String>();
        HashMap<String, BaseItem> loadedObjectivesMap = new HashMap<String, BaseItem>();
        for (String childId : childObjectiveIds) {
            if (itemCache.containsKey(childId)) {
                loadedObjectivesMap.put(childId, itemCache.get(childId));
                continue;
            }
            idsToFetch.add(childId);
        }
        if (!idsToFetch.isEmpty()) {
            List processedObjectives;
            HashMap<String, Serializable> requestBody = new HashMap<String, Serializable>();
            requestBody.put("objectiveIds", idsToFetch);
            requestBody.put("fetchPIs", Boolean.valueOf(true));
            HashMap response = this.loadObjectivesByBatchIds(requestBody);
            Map fetchedLastCommentMap = (Map)response.get("lastCommentMap");
            if (PropertyValidator.isValid((Object)fetchedLastCommentMap)) {
                lastCommentMap.putAll(fetchedLastCommentMap);
            }
            if (PropertyValidator.isValid((Collection)(processedObjectives = (List)response.get("objectives")))) {
                for (BaseItem processedChild : processedObjectives) {
                    itemCache.put(processedChild.getId(), processedChild);
                    loadedObjectivesMap.put(processedChild.getId(), processedChild);
                }
            }
        }
        for (BaseItem childItem : childrenToRecurse) {
            BaseItem preFetchedChildData = (BaseItem)loadedObjectivesMap.get(childItem.getId());
            this.processBaseItemRecursively(childItem, parentItem, selectedColumns, items, completionData, rowCounter, depth + 1, topGroup, sessionId, preFetchedChildData, itemCache, lastCommentMap);
        }
    }

    private HashMap<String, Object> loadObjectivesByBatchIds(HashMap<String, Object> requestBody) throws Exception {
        List allLinks;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        List objectiveIds = (List)requestBody.get("objectiveIds");
        Optional<String> requestId = Optional.ofNullable((String)requestBody.get("requestId"));
        Boolean isMockingMode = null != requestBody.get("isMockingMode");
        Boolean fetchPIs = null != requestBody.get("fetchPIs");
        if (!PropertyValidator.isValid((Collection)objectiveIds) || objectiveIds.isEmpty()) {
            responseData.put("objectives", new ArrayList());
            return responseData;
        }
        List objectives = this.baseItemRepository.findByIdIn(objectiveIds);
        ArrayList allBaseItemIdsForComment = new ArrayList(objectiveIds);
        Map lastCommentMap = this.fetchLastComments(allBaseItemIdsForComment);
        responseData.put("lastCommentMap", lastCommentMap);
        if (!PropertyValidator.isValid((Collection)objectives) || objectives.isEmpty()) {
            responseData.put("objectives", new ArrayList());
            return responseData;
        }
        Map<String, BaseItem> objectivesById = objectives.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        ArrayList<BaseItemLink> allObjectiveAndOkrBaseItemLinks = new ArrayList<BaseItemLink>();
        HashMap<String, Object> allChildObjectivesByGroupId = new HashMap<String, Object>();
        ArrayList<ObjectId> allChildObjectiveIds = new ArrayList<ObjectId>();
        HashMap linksByObjectiveId = new HashMap();
        for (Object objective : objectives) {
            if (objective == null) continue;
            if (PropertyValidator.isValid((Object)objective.getStatus())) {
                Status status = new Status(objective.getStatus().getId(), objective.getStatus().getTitle(), objective.getStatus().getColor(), objective.getStatus().getCategory());
                objective.setStatus(status);
            }
            ArrayList<BaseItemLink> linksToRemove = new ArrayList<BaseItemLink>();
            ArrayList<BaseItemLink> validLinks = new ArrayList<BaseItemLink>();
            ArrayList<BaseItemLink> objectiveLinks = new ArrayList<BaseItemLink>();
            String objectiveTitle = objective.getTitle() != null ? objective.getTitle() : "Unknown";
            String objectiveId = objective.getKey();
            if (PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) {
                for (BaseItemLink link : objective.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link)) continue;
                    String linkType = link.getLinkType() != null ? link.getLinkType() : "Unknown";
                    String linkId = link.getId() != null ? link.getId() : "Unknown";
                    String baseItemId = link.getBaseItemId() != null ? link.getBaseItemId() : "Unknown";
                    String itemId = link.getItemId() != null ? link.getItemId() : "Unknown";
                    boolean isArchive = link.isArchive();
                    validLinks.add(link);
                    objectiveLinks.add(link);
                    if (PropertyValidator.isValid((Object)link.getItemId())) {
                        allObjectiveAndOkrBaseItemLinks.add(link);
                    } else if ("backLogItem".equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getBaseItemId())) {
                        allObjectiveAndOkrBaseItemLinks.add(link);
                    }
                    if (!(!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getLinkType()) || link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode()) || link.getLinkType().equals(EnumKendis.PARENT_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode()) || EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()))) {
                        allChildObjectivesByGroupId.put(link.getBaseItemId(), objective);
                        allChildObjectiveIds.add(new ObjectId(link.getBaseItemId()));
                    }
                    if (!link.isArchive()) continue;
                    linksToRemove.add(link);
                }
            }
            if (!linksToRemove.isEmpty()) {
                validLinks.removeAll(linksToRemove);
            }
            objective.setBaseItemLinks(validLinks);
            linksByObjectiveId.put(objective.getId(), objectiveLinks);
        }
        this.baseItemRepository.save((Iterable)objectives);
        if (!allChildObjectiveIds.isEmpty()) {
            List allChildObjectives = this.loadObjectivesByBaseItemId(allChildObjectiveIds);
            for (Object childObj : allChildObjectives) {
                BaseItem parentObjective;
                if (childObj == null) continue;
                if (PropertyValidator.isValid((Object)childObj.getStatus())) {
                    Status status = new Status(childObj.getStatus().getId(), childObj.getStatus().getTitle(), childObj.getStatus().getColor(), childObj.getStatus().getCategory());
                    childObj.setStatus(status);
                }
                if ((parentObjective = (BaseItem)allChildObjectivesByGroupId.get(childObj.getId())) != null) {
                    this.setBaseItemInParent(parentObjective, (BaseItem)childObj);
                }
                if (!PropertyValidator.isValid((Collection)childObj.getBaseItemLinks())) continue;
                for (BaseItemLink link : childObj.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link)) continue;
                    if (PropertyValidator.isValid((Object)link.getItemId())) {
                        allObjectiveAndOkrBaseItemLinks.add(link);
                        continue;
                    }
                    if (!"backLogItem".equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
                    allObjectiveAndOkrBaseItemLinks.add(link);
                }
            }
        }
        if (!(allLinks = linksByObjectiveId.values().stream().flatMap(Collection::stream).collect(Collectors.toList())).isEmpty()) {
            this.optimizedSetLinkedGroups(objectives);
        }
        if (!isMockingMode.booleanValue()) {
            if (PropertyValidator.isValid(requestId) && requestId.isPresent()) {
                this.fetchObjectivesWithLinkedItemsInThread(objectives, allObjectiveAndOkrBaseItemLinks, requestId);
            } else {
                this.fetchObjectivesWithLinkedItems(objectives, allObjectiveAndOkrBaseItemLinks);
            }
        } else {
            this.calculationForBatchItems(objectives, requestId);
        }
        if (fetchPIs.booleanValue() && !objectives.isEmpty()) {
            HashSet<String> sessionIds = new HashSet<String>();
            for (BaseItem objective : objectives) {
                if (!PropertyValidator.isValid((Collection)objective.getBaseItemList())) continue;
                for (BaseItem obj : objective.getBaseItemList()) {
                    if (!PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) continue;
                    for (BaseItemLink link : obj.getBaseItemLinks()) {
                        if ((!EnumKendis.OBJECTIVE.getCode().equals(link.getType()) || !EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getSessionId())) && (!EnumKendis.OBJECTIVE.getCode().equals(link.getType()) || !PropertyValidator.isValid((Object)link.getSessionBoardId())) || !PropertyValidator.isValid((Object)link.getSessionId())) continue;
                        sessionIds.add(link.getSessionId());
                    }
                }
            }
            if (PropertyValidator.isValid(sessionIds)) {
                List sessions = this.sessionRepository.findMinimalSessionsByIdIn(new ArrayList(sessionIds));
                Map<String, Session> sessionMapById = sessions.stream().collect(Collectors.toMap(BaseEntity::getId, session -> session));
                responseData.put("sessionMapById", sessionMapById);
            }
        }
        if (isMockingMode.booleanValue()) {
            HashSet<String> allUserEmails = new HashSet<String>();
            for (BaseItem objective : objectives) {
                if (PropertyValidator.isValid((Object)objective.getCreatedBy())) {
                    allUserEmails.add(objective.getCreatedBy());
                }
                if (!PropertyValidator.isValid((Object)objective.getUpdatedBy())) continue;
                allUserEmails.add(objective.getUpdatedBy());
            }
            if (PropertyValidator.isValid(allUserEmails)) {
                List users = this.userRepository.findByUserNameIgnoreCaseIn(new ArrayList(allUserEmails));
                HashMap<String, User> userMap = new HashMap<String, User>();
                if (PropertyValidator.isValid((Collection)users)) {
                    for (User user : users) {
                        if (!PropertyValidator.isValid((Object)user.getUserName()) || !PropertyValidator.isValid((Object)user.getFullName())) continue;
                        userMap.put(user.getUserName(), user);
                    }
                }
                for (BaseItem objective : objectives) {
                    User createdByUser = (User)userMap.get(objective.getCreatedBy());
                    User updatedByUser = (User)userMap.get(objective.getUpdatedBy());
                    if (createdByUser != null) {
                        objective.setCreatedBy(createdByUser.getFullName());
                    }
                    if (updatedByUser == null) continue;
                    objective.setUpdatedBy(updatedByUser.getFullName());
                }
            }
        }
        responseData.put("objectives", objectives);
        return responseData;
    }

    public void optimizedSetLinkedGroups(List<BaseItem> objectives) throws Exception {
        if (objectives == null || objectives.isEmpty()) {
            return;
        }
        List objectiveIds = objectives.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List allLinks = this.findByBaseItemIdIn(objectiveIds);
        if (allLinks.isEmpty()) {
            objectives.forEach(obj -> obj.setSelectedLinkedGroups(Collections.emptyList()));
            return;
        }
        List allGroups = this.baseItemRepository.findGroupsByBaseItemLinksIn(allLinks);
        HashSet objectiveIdSet = new HashSet(objectiveIds);
        HashMap groupsByObjectiveId = new HashMap();
        for (BaseItem group : allGroups) {
            if (group.getBaseItemLinks() == null) continue;
            HashSet<String> relevantObjectiveIdsForThisGroup = new HashSet<String>();
            for (BaseItemLink link : group.getBaseItemLinks()) {
                if (!objectiveIdSet.contains(link.getBaseItemId())) continue;
                relevantObjectiveIdsForThisGroup.add(link.getBaseItemId());
            }
            for (String objectiveId : relevantObjectiveIdsForThisGroup) {
                groupsByObjectiveId.computeIfAbsent(objectiveId, k -> new ArrayList()).add(group);
            }
        }
        for (BaseItem objective : objectives) {
            List selectedLinkedGroups = groupsByObjectiveId.getOrDefault(objective.getId(), Collections.emptyList());
            objective.setSelectedLinkedGroups(selectedLinkedGroups);
        }
    }

    public List<BaseItemLink> findByBaseItemIdIn(List<String> objectiveIds) throws Exception {
        if (objectiveIds == null || objectiveIds.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").in(objectiveIds));
        return this.mongoTemplate.find(query, BaseItemLink.class);
    }

    private void fetchObjectivesWithLinkedItemsInThread(List<BaseItem> objectives, List<BaseItemLink> allObjectiveAndOkrBaseItemLinks, Optional<String> requestId) throws Exception {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private HashMap<String, Object> fetchObjectivesWithLinkedItems(List<BaseItem> objectives, List<BaseItemLink> allObjectiveAndOkrBaseItemLinks) throws Exception {
        HashMap activeBoardItemsMap = new HashMap();
        HashMap<String, Object> objAndKrLinkedItemsMap = new HashMap<String, Object>();
        activeBoardItemsMap = this.fetchLinkedItems(null, allObjectiveAndOkrBaseItemLinks);
        HashMap<String, Item> linkedItemsByItemId = new HashMap<String, Item>();
        HashMap<String, Item> linkedItemsByJiraKeyOrTfsId = new HashMap<String, Item>();
        List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
        if (PropertyValidator.isValid((Collection)linkedItems)) {
            for (Item item : linkedItems) {
                linkedItemsByItemId.put(item.getId(), item);
                if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                    linkedItemsByJiraKeyOrTfsId.put(item.getJiraKey(), item);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                linkedItemsByJiraKeyOrTfsId.put(item.getTfsId(), item);
            }
        }
        for (BaseItem objective : objectives) {
            this.setLinkedItemsMapForOkr(objective, linkedItemsByItemId, linkedItemsByJiraKeyOrTfsId, objAndKrLinkedItemsMap);
        }
        return objAndKrLinkedItemsMap;
    }

    private void calculationForBatchItems(List<BaseItem> okrs, Optional<String> requestId) throws Exception {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void processKrForBatchCalculation(BaseItem kr, List<Fields> okrProgressCriteriaGroupFields, Map<String, String> okrProgressCriteriaById, Map<String, List<String>> okrLinkedItemMapByOkrId, Map<String, Set<String>> itemIdsByRt, List<ObjectId> objectiveIdsToFetch) throws Exception {
        String progressCriteriaFieldToShow = "";
        ArrayList<String> krLinkedItemIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)kr.getFields())) {
            for (Fields groupField : okrProgressCriteriaGroupFields) {
                if (!groupField.getTitle().equals("Progress Criteria")) continue;
                progressCriteriaFieldToShow = (String)kr.getFields().get(groupField.getId());
                okrProgressCriteriaById.put(kr.getId(), progressCriteriaFieldToShow);
                break;
            }
        }
        if (PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) {
            for (BaseItemLink link : kr.getBaseItemLinks()) {
                if (!PropertyValidator.isValid((Object)link) || link.isArchive()) continue;
                if (PropertyValidator.isValid((Object)progressCriteriaFieldToShow) && progressCriteriaFieldToShow.equals("By Items") && "backLogItem".equals(link.getLinkType())) {
                    Set itemIds = itemIdsByRt.computeIfAbsent(link.getReleaseTrainId(), k -> new HashSet());
                    itemIds.add(link.getBaseItemId());
                    krLinkedItemIds.add(link.getBaseItemId());
                }
                if (PropertyValidator.isValid((Object)progressCriteriaFieldToShow) && progressCriteriaFieldToShow.equals("By Objectives") && EnumKendis.PARENT_OKR.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getBaseItemId())) {
                    objectiveIdsToFetch.add(new ObjectId(link.getBaseItemId()));
                }
                if (!EnumKendis.PARENT_OKR.getCode().equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
                objectiveIdsToFetch.add(new ObjectId(link.getBaseItemId()));
            }
        }
        if (PropertyValidator.isValid((Object)progressCriteriaFieldToShow) && progressCriteriaFieldToShow.equals("By Items")) {
            okrLinkedItemMapByOkrId.put(kr.getId(), krLinkedItemIds);
        }
    }

    private List<Fields> getFields(BaseItem item) throws Exception {
        Set fieldIds;
        List fetchedFields;
        List<Object> fields = new ArrayList<Fields>();
        if (item.getFields() != null && !item.getFields().isEmpty() && (fetchedFields = this.fieldsRepository.findAllByIdIn(fieldIds = item.getFields().keySet())) != null && !fetchedFields.isEmpty()) {
            fields = fetchedFields;
        }
        return fields;
    }

    private void processBacklogItemsByReleaseTrain(List<BaseItemLink> backlogItemLinks, BaseItem parentItem, List<HashMap<String, Object>> selectedColumns, List<HashMap<String, Object>> items, HashMap<String, Object> completionData, int[] rowCounter, int depth, BaseItem topParent, String sessionId, Map<String, Map<String, Object>> lastComment) throws Exception {
        String releaseTrainId;
        HashSet<String> allReleaseTrainIds = new HashSet<String>();
        HashSet<String> allBacklogItemIds = new HashSet<String>();
        for (BaseItemLink link : backlogItemLinks) {
            if (PropertyValidator.isValid((Object)link.getReleaseTrainId())) {
                allReleaseTrainIds.add(link.getReleaseTrainId());
            }
            if (!PropertyValidator.isValid((Object)link.getBaseItemId())) continue;
            allBacklogItemIds.add(link.getBaseItemId());
        }
        Map releaseTrainTitleMap = this.getReleaseTrainTitleMap(allReleaseTrainIds);
        Map<Object, Object> backlogItemMap = new HashMap();
        if (allBacklogItemIds != null && !allBacklogItemIds.isEmpty()) {
            ArrayList idList = new ArrayList(allBacklogItemIds);
            backlogItemMap = this.backlogItemRepository.findAllByIdIn(idList).stream().collect(Collectors.toMap(BaseEntity::getId, item -> item, (item1, item2) -> item1));
        }
        HashMap<String, List> backlogItemsByReleaseTrain = new HashMap<String, List>();
        for (BaseItemLink baseItemLink : backlogItemLinks) {
            releaseTrainId = baseItemLink.getReleaseTrainId();
            if (!PropertyValidator.isValid((Object)releaseTrainId)) {
                releaseTrainId = "Unknown";
            }
            backlogItemsByReleaseTrain.computeIfAbsent(releaseTrainId, k -> new ArrayList()).add(baseItemLink);
        }
        for (Map.Entry entry : backlogItemsByReleaseTrain.entrySet()) {
            releaseTrainId = (String)entry.getKey();
            List linksForReleaseTrain = (List)entry.getValue();
            String releaseTrainTitle = "Unknown".equals(releaseTrainId) ? "Unknown" : releaseTrainTitleMap.getOrDefault(releaseTrainId, "Release Train " + releaseTrainId);
            ArrayList<String> backlogItemKeys = new ArrayList<String>();
            for (BaseItemLink link : linksForReleaseTrain) {
                String key;
                BacklogItem backlogItem;
                if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || (backlogItem = (BacklogItem)backlogItemMap.get(link.getBaseItemId())) == null || (key = this.getBacklogItemKey(backlogItem)) == null || key.trim().isEmpty()) continue;
                backlogItemKeys.add(key);
            }
            BaseItem linkedItemsItem = this.createLinkedItemsBaseItem(releaseTrainTitle, releaseTrainId, backlogItemKeys, parentItem);
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("rowId", UUID.randomUUID().toString());
            for (HashMap<String, Object> column : selectedColumns) {
                String columnKey = (String)column.get("key");
                Object value = this.getFieldValue(linkedItemsItem, parentItem, columnKey, completionData, depth, topParent, sessionId, lastComment);
                row.put(columnKey, value);
            }
            items.add(row);
            rowCounter[0] = rowCounter[0] + 1;
        }
    }

    private Map<String, String> getReleaseTrainTitleMap(Set<String> releaseTrainIds) throws Exception {
        if (releaseTrainIds == null || releaseTrainIds.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<String> idList = new ArrayList<String>(releaseTrainIds);
        List releaseTrains = this.workSpaceRepository.findWorkSpaceByIdIn(idList);
        HashMap<String, String> titleMap = new HashMap<String, String>();
        for (WorkSpace releaseTrain : releaseTrains) {
            if (!PropertyValidator.isValid((Object)releaseTrain.getTitle())) continue;
            titleMap.put(releaseTrain.getId(), releaseTrain.getTitle());
        }
        return titleMap;
    }

    private String getBacklogItemKey(BacklogItem backlogItem) throws Exception {
        Object externalKey;
        if (backlogItem.getAlmKey() != null && !backlogItem.getAlmKey().trim().isEmpty()) {
            return backlogItem.getAlmKey();
        }
        if (backlogItem.getKendisKey() != null && !backlogItem.getKendisKey().trim().isEmpty()) {
            return backlogItem.getKendisKey();
        }
        if (backlogItem.getFields() != null && (externalKey = backlogItem.getFields().get("externalKey")) != null && !externalKey.toString().trim().isEmpty()) {
            return externalKey.toString();
        }
        return null;
    }

    private BaseItem createLinkedItemsBaseItem(String releaseTrainTitle, String releaseTrainId, List<String> backlogItemKeys, BaseItem parentItem) throws Exception {
        BaseItem linkedItemsItem = new BaseItem();
        linkedItemsItem.setType("Linked Items");
        linkedItemsItem.setTitle(releaseTrainTitle);
        linkedItemsItem.setKey("");
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("linkedItems", String.join((CharSequence)", ", backlogItemKeys));
        fields.put("releaseTrainId", releaseTrainId);
        fields.put("releaseTrainTitle", releaseTrainTitle);
        if (parentItem != null && parentItem.getId() != null) {
            fields.put("parentId", parentItem.getId());
            fields.put("parentItemId", parentItem.getId());
        }
        linkedItemsItem.setFields(fields);
        return linkedItemsItem;
    }

    private Object getFieldValue(BaseItem item, BaseItem parentGroup, String fieldKey, HashMap<String, Object> completionData, int depth, BaseItem topParent, String sessionId, Map<String, Map<String, Object>> lastCommentMap) throws Exception {
        boolean isGroup = "Objective-Group".equals(item.getType());
        boolean isKR = "KR".equals(item.getType());
        boolean isLinkedItems = "Linked Items".equals(item.getType());
        List fields = this.getFields(item);
        Map<String, Object> commentData = lastCommentMap.get(item.getId());
        switch (fieldKey) {
            case "hLevel": {
                return String.valueOf(depth);
            }
            case "hType": {
                return this.getHTypeValue(isGroup, isKR, isLinkedItems);
            }
            case "itemId": {
                return item.getKey();
            }
            case "title": {
                return this.getTitle(isGroup, sessionId, item);
            }
            case "description": {
                return this.getPlainTextFromRichText(item.getDescription());
            }
            case "immediateParentId": {
                return this.getImmediateParentIdValue(isGroup, parentGroup);
            }
            case "immediateParentType": {
                return this.getImmediateParentType(isGroup, parentGroup);
            }
            case "objectiveGroupName": {
                return this.getObjectiveGroupName(topParent, sessionId);
            }
            case "timePeriod": {
                return this.getTimePeriod(isLinkedItems, fields, item);
            }
            case "status": {
                return this.getStatusValue(item);
            }
            case "progress": {
                return this.getProgressValue(item, completionData);
            }
            case "association": {
                return this.getAssociationValue(isLinkedItems, item);
            }
            case "startDate": {
                return this.getStartEndDate("Start Date", fields, isLinkedItems, item);
            }
            case "endDate": {
                return this.getStartEndDate("End Date", fields, isLinkedItems, item);
            }
            case "lastUpdated": {
                return this.getLastUpdatedValue(isLinkedItems, item);
            }
            case "responsible": {
                return this.getResponsible(isLinkedItems, fields, item);
            }
            case "objType": {
                return this.getObjTypeValue(item.getType());
            }
            case "progressCriteria": {
                return this.getProgressCriteria(item, fields, parentGroup, isLinkedItems);
            }
            case "krProgressCriteria": {
                return this.getKrProgressCriteria(item, fields, isGroup, isKR);
            }
            case "linkedItems": {
                return this.getLinkedItemsValue(isLinkedItems, item);
            }
            case "releaseTrainId": {
                return this.getReleaseTrainField(item, "releaseTrainId", isLinkedItems);
            }
            case "releaseTrainTitle": {
                return this.getReleaseTrainField(item, "releaseTrainTitle", isLinkedItems);
            }
            case "krStartValue": {
                return this.getKrFieldValue(item, fields, "Start", isGroup, isKR);
            }
            case "krTargetValue": {
                return this.getKrFieldValue(item, fields, "Target Value", isGroup, isKR);
            }
            case "krProgress": {
                return this.getKrFieldValue(item, fields, "Progress", isGroup, isKR);
            }
            case "lastComment": {
                return this.lastComment(commentData);
            }
            case "lastCommentOn": {
                return this.lastCommentOn(commentData);
            }
        }
        return "";
    }

    private String lastComment(Map<String, Object> commentData) throws Exception {
        if (PropertyValidator.isValid(commentData) && PropertyValidator.isValid((Object)commentData.get("lastComment"))) {
            return KendisUtils.parseRichText((String)commentData.get("lastComment").toString());
        }
        return "";
    }

    private Object lastCommentOn(Map<String, Object> commentData) throws Exception {
        Object dateObj;
        if (PropertyValidator.isValid(commentData) && PropertyValidator.isValid((Object)commentData.get("lastCommentOn")) && (dateObj = commentData.get("lastCommentOn")) instanceof Date) {
            Date createdOnDate = (Date)dateObj;
            SimpleDateFormat formatter = new SimpleDateFormat("dd MMM 'at' h:mm a");
            return formatter.format(createdOnDate);
        }
        return "";
    }

    private String getHTypeValue(boolean isGroup, boolean isKR, boolean isLinkedItems) throws Exception {
        if (isGroup) {
            return "Objective Group";
        }
        if (isKR) {
            return "Key Result";
        }
        if (isLinkedItems) {
            return "Linked Items";
        }
        return "Objective";
    }

    private String getImmediateParentIdValue(boolean isGroup, BaseItem parentGroup) throws Exception {
        if (isGroup) {
            return "";
        }
        return parentGroup != null ? parentGroup.getKey() : "";
    }

    private String getStatusValue(BaseItem item) throws Exception {
        return item.getStatus() != null ? item.getStatus().getTitle() : "";
    }

    private Object getAssociationValue(boolean isLinkedItems, BaseItem item) throws Exception {
        if (isLinkedItems) {
            return "";
        }
        return this.getAssociationValue(item);
    }

    private Object getLastUpdatedValue(boolean isLinkedItems, BaseItem item) throws Exception {
        if (isLinkedItems) {
            return "";
        }
        return this.formatDateValue((Object)item.getUpdatedOn());
    }

    private String getObjTypeValue(String itemType) throws Exception {
        if (itemType != null && itemType.startsWith("Objective-") && !itemType.startsWith("Objective-Group")) {
            return itemType.replaceFirst("Objective-", "");
        }
        return "";
    }

    private Object getLinkedItemsValue(boolean isLinkedItems, BaseItem item) throws Exception {
        if (isLinkedItems) {
            return this.getLinkedItemsValue(item);
        }
        return "";
    }

    private String getStartEndDate(String fieldName, List<Fields> fields, boolean isLinkedItems, BaseItem item) throws Exception {
        if (isLinkedItems) {
            return "";
        }
        Optional<Fields> startDateField = fields.stream().filter(f -> fieldName.equalsIgnoreCase(f.getTitle())).findFirst();
        if (startDateField.isPresent()) {
            Object startDateValue = item.getFields().get(startDateField.get().getId());
            return this.formatDateValue(startDateValue);
        }
        return "";
    }

    private String getResponsible(boolean isLinkedItems, List<Fields> fields, BaseItem item) throws Exception {
        if (isLinkedItems) {
            return "";
        }
        Optional<Fields> responsibleField = fields.stream().filter(f -> "Responsible".equalsIgnoreCase(f.getTitle())).findFirst();
        if (responsibleField.isPresent()) {
            Object responsibleValue = item.getFields().get(responsibleField.get().getId());
            return this.formatResponsibleField(responsibleValue);
        }
        return "";
    }

    private String getTimePeriod(boolean isLinkedItems, List<Fields> fields, BaseItem item) throws Exception {
        if (isLinkedItems) {
            return "";
        }
        Optional<Fields> timePeriodField = fields.stream().filter(f -> "Time Period".equalsIgnoreCase(f.getTitle())).findFirst();
        if (timePeriodField.isPresent()) {
            Object timePeriodValue = item.getFields().get(timePeriodField.get().getId());
            return this.formatTimePeriodField(timePeriodValue);
        }
        return "";
    }

    private String getTitle(boolean isGroup, String sessionId, BaseItem item) throws Exception {
        ObjectiveCustomView customView;
        if (isGroup && PropertyValidator.isValid((Object)sessionId) && !"-1".equals(sessionId) && PropertyValidator.isValid((Object)item.getLinkedCustomView()) && (customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)item.getLinkedCustomView()))) != null && PropertyValidator.isValid((Object)customView.getTitle())) {
            return customView.getTitle();
        }
        return item.getTitle();
    }

    private String getImmediateParentType(boolean isGroup, BaseItem parentGroup) throws Exception {
        if (isGroup) {
            return "";
        }
        if (parentGroup != null && parentGroup.getItemType() != null) {
            String title = parentGroup.getItemType().getTitle();
            if ("group_objective".equalsIgnoreCase(title)) {
                return "Objective Group";
            }
            return title != null ? title : "Objective Group";
        }
        return "Objective Group";
    }

    private String getObjectiveGroupName(BaseItem topParent, String sessionId) throws Exception {
        if (PropertyValidator.isValid((Object)topParent)) {
            ObjectiveCustomView customView;
            if (PropertyValidator.isValid((Object)sessionId) && !"-1".equals(sessionId) && PropertyValidator.isValid((Object)topParent.getLinkedCustomView()) && (customView = (ObjectiveCustomView)this.objectiveCustomViewRepository.findOne((Serializable)((Object)topParent.getLinkedCustomView()))) != null && PropertyValidator.isValid((Object)customView.getTitle())) {
                return customView.getTitle();
            }
            return topParent.getTitle();
        }
        return "";
    }

    private String formatResponsibleField(Object responsibleValue) throws Exception {
        Map responsibleMap;
        Object fullName;
        if (responsibleValue == null) {
            return "Not assigned";
        }
        if (responsibleValue instanceof Map && (fullName = (responsibleMap = (Map)responsibleValue).get("fullName")) != null && !fullName.toString().trim().isEmpty()) {
            return fullName.toString();
        }
        if (responsibleValue instanceof String) {
            String strValue = responsibleValue.toString().trim();
            return strValue.isEmpty() ? "Not assigned" : strValue;
        }
        return "Not assigned";
    }

    private String formatTimePeriodField(Object timePeriodValue) throws Exception {
        if (timePeriodValue == null) {
            return "";
        }
        if (timePeriodValue instanceof Map) {
            Map timePeriodMap = (Map)timePeriodValue;
            Object title = timePeriodMap.get("title");
            Object selectedYear = timePeriodMap.get("selectedYear");
            if (title != null && selectedYear != null) {
                String periodTitle = title.toString();
                String year = selectedYear.toString();
                if ("Yearly".equals(periodTitle)) {
                    periodTitle = "Year";
                }
                return periodTitle + " " + year;
            }
        }
        if (timePeriodValue instanceof String) {
            return timePeriodValue.toString().trim();
        }
        return "";
    }

    private String getProgressValue(BaseItem item, HashMap<String, Object> completionData) throws Exception {
        if (completionData == null || item == null) {
            return "0";
        }
        if (item.getFields() != null && item.getFields().containsKey("releaseTrainId") && item.getFields().containsKey("parentId")) {
            String releaseTrainId = (String)item.getFields().get("releaseTrainId");
            String parentItemId = (String)item.getFields().get("parentId");
            if (releaseTrainId != null && !releaseTrainId.isEmpty() && parentItemId != null && !parentItemId.isEmpty()) {
                String releaseTrainCompletionKey = "linkedItemsCompletion_" + parentItemId + "_" + releaseTrainId;
                if (completionData.containsKey(releaseTrainCompletionKey)) {
                    Double releaseTrainCompletion = (Double)completionData.get(releaseTrainCompletionKey);
                    return String.format("%.2f", releaseTrainCompletion != null ? releaseTrainCompletion : 0.0);
                }
                String overallCompletionKey = "linkedItemsCompletion_" + parentItemId;
                Double overallCompletion = (Double)completionData.get(overallCompletionKey);
                if (overallCompletion != null) {
                    return String.format("%.2f", overallCompletion);
                }
                return "0";
            }
        }
        if (item.getId() == null) {
            return "0";
        }
        Double completion = (Double)completionData.get(item.getId());
        if (completion == null) {
            return "0";
        }
        return String.format("%.2f", completion);
    }

    private String getPlainTextFromRichText(String html) throws Exception {
        if (html == null || html.isEmpty()) {
            return "";
        }
        String cleaned = Jsoup.parse((String)html).text();
        cleaned = cleaned.replaceAll("<[^>]*>", " ");
        cleaned = cleaned.replaceAll("&nbsp;", " ");
        cleaned = cleaned.replaceAll("&amp;", "&");
        cleaned = cleaned.replaceAll("&lt;", "<");
        cleaned = cleaned.replaceAll("&gt;", ">");
        cleaned = cleaned.replaceAll("&quot;", "\"");
        cleaned = cleaned.replaceAll("&#39;", "'");
        cleaned = cleaned.replaceAll("\\u00A0", " ");
        cleaned = cleaned.replaceAll("\\n+", " ");
        cleaned = cleaned.replaceAll("\\t+", " ");
        cleaned = cleaned.replaceAll("\\r+", " ");
        cleaned = cleaned.replaceAll(" {2,}", " ");
        cleaned = cleaned.trim();
        return cleaned;
    }

    private String getProgressCriteriaTitle(String criteriaValue) throws Exception {
        if (criteriaValue == null || criteriaValue.trim().isEmpty()) {
            return "";
        }
        switch (criteriaValue.toUpperCase()) {
            case "LINKED_ITEM_STATUS": {
                return "By Linked Item Status";
            }
            case "CHILDREN_LINKED_ITEM_STATUS": {
                return "By Children of Linked Items (Stories) Status";
            }
            case "CHILDREN_LINKED_ITEM_ESTIMATE": {
                return "By Children of Linked Items (Stories) Estimate";
            }
        }
        return criteriaValue;
    }

    private String formatDateValue(Object dateValue) throws Exception {
        if (dateValue == null) {
            return "";
        }
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        ZonedDateTime zonedDateTime = null;
        if (dateValue instanceof Date) {
            zonedDateTime = ((Date)dateValue).toInstant().atZone(ZoneId.systemDefault());
        } else if (dateValue instanceof String) {
            zonedDateTime = Instant.parse((String)dateValue).atZone(ZoneId.systemDefault());
        } else {
            if (dateValue instanceof LocalDate) {
                return ((LocalDate)dateValue).format(outputFormatter);
            }
            if (dateValue instanceof LocalDateTime) {
                zonedDateTime = ((LocalDateTime)dateValue).atZone(ZoneId.systemDefault());
            }
        }
        if (zonedDateTime != null) {
            LocalDate localDate = zonedDateTime.toLocalDate();
            return localDate.format(outputFormatter);
        }
        return "";
    }

    private String getLinkedItemsValue(BaseItem objective) throws Exception {
        Object linkedItemsValue;
        if ("Linked Items".equals(objective.getType()) && objective.getFields() != null && (linkedItemsValue = objective.getFields().get("linkedItems")) != null) {
            return linkedItemsValue.toString();
        }
        if (objective.getBaseItemList() != null) {
            return String.valueOf(objective.getBaseItemList().size());
        }
        return "0";
    }

    private String getAssociationValue(BaseItem item) throws Exception {
        if (item.getBaseItemLinks() == null || item.getBaseItemLinks().isEmpty()) {
            return "";
        }
        ArrayList<String> associationNames = new ArrayList<String>();
        HashSet<String> artLinkSessionIds = new HashSet<String>();
        HashSet<String> linkedSessionIds = new HashSet<String>();
        for (Object link : item.getBaseItemLinks()) {
            if (link == null || link.isArchive()) continue;
            if (EnumKendis.ART_LINK_OBJECTIVE.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getSessionId()) && !"-1".equals(link.getSessionId())) {
                artLinkSessionIds.add(link.getSessionId());
            }
            if (!EnumKendis.LINKED_SESSION.getCode().equals(link.getLinkType()) || !PropertyValidator.isValid((Object)link.getSessionId()) || "-1".equals(link.getSessionId())) continue;
            linkedSessionIds.add(link.getSessionId());
        }
        if (!artLinkSessionIds.isEmpty()) {
            List departments = this.workSpaceRepository.findByIdIn(new ArrayList(artLinkSessionIds));
            for (Object dept : departments) {
                if (!PropertyValidator.isValid((Object)dept.getTitle())) continue;
                associationNames.add(dept.getTitle());
                artLinkSessionIds.remove(dept.getId());
            }
            if (!artLinkSessionIds.isEmpty()) {
                List batches = this.baseItemRepository.findBatchesByIdIn(new ArrayList(artLinkSessionIds));
                for (BaseItem batch : batches) {
                    if (!PropertyValidator.isValid((Object)batch.getTitle())) continue;
                    associationNames.add(batch.getTitle());
                }
            }
        }
        if (!linkedSessionIds.isEmpty()) {
            List sessions = this.sessionRepository.findSessionsByIdIn(new ArrayList(linkedSessionIds));
            for (Session session : sessions) {
                if (!PropertyValidator.isValid((Object)session.getTitle())) continue;
                associationNames.add(session.getTitle());
            }
        }
        return String.join((CharSequence)", ", associationNames);
    }

    private String getProgressCriteria(BaseItem item, List<Fields> fields, BaseItem parentGroup, boolean isLinkedItems) throws Exception {
        if (isLinkedItems) {
            if (parentGroup != null) {
                List parentFields;
                Optional<Fields> progressCriteriaField;
                String parentProgressCriteria = parentGroup.getCompletionCriteria();
                if (parentProgressCriteria != null && !parentProgressCriteria.trim().isEmpty()) {
                    return this.getProgressCriteriaTitle(parentProgressCriteria);
                }
                if (parentGroup.getFields() != null && (progressCriteriaField = (parentFields = this.getFields(parentGroup)).stream().filter(f -> "Progress Criteria".equalsIgnoreCase(f.getTitle())).findFirst()).isPresent()) {
                    String criteriaValue = (String)parentGroup.getFields().get(progressCriteriaField.get().getId());
                    return this.getProgressCriteriaTitle(criteriaValue);
                }
            }
            return "";
        }
        return "";
    }

    private String getKrProgressCriteria(BaseItem item, List<Fields> fields, boolean isGroup, boolean isKR) throws Exception {
        if (isGroup) {
            return "";
        }
        if (!isKR) {
            return "";
        }
        Optional<Fields> krProgressDetailField = fields.stream().filter(f -> "Progress Criteria".equalsIgnoreCase(f.getTitle())).findFirst();
        if (krProgressDetailField.isPresent()) {
            return item.getFields().get(krProgressDetailField.get().getId()).toString();
        }
        return "";
    }

    private String getReleaseTrainField(BaseItem item, String fieldName, boolean isLinkedItems) throws Exception {
        if (isLinkedItems && item.getFields() != null) {
            Object value = item.getFields().get(fieldName);
            return value != null ? value.toString() : "";
        }
        return "";
    }

    private String getKrFieldValue(BaseItem item, List<Fields> fields, String fieldTitle, boolean isGroup, boolean isKR) throws Exception {
        if (isGroup) {
            return "";
        }
        if (!isKR) {
            return "";
        }
        Optional<Fields> field = fields.stream().filter(f -> fieldTitle.equalsIgnoreCase(f.getTitle())).findFirst();
        if (field.isPresent()) {
            Object value = item.getFields().get(field.get().getId());
            return value != null ? value.toString() : "";
        }
        return "";
    }

    public Map<String, Object> getLegacyGroups() throws Exception {
        LOGGER.debug("********** ObjectiveServiceImpl - getLegacyGroups **********");
        HashMap<String, Object> response = new HashMap<String, Object>();
        List objectiveGroupList = this.fetchObjectives(Boolean.valueOf(false), "-1", Boolean.valueOf(true), null, null, Boolean.valueOf(true), "-1", null);
        response.put("legacyGroupsCount", objectiveGroupList.size());
        List customViewWorkFlows = this.workFlowRepository.findAllByWorkflowType(EnumKendis.STRATEGIC_THEME.getCode());
        if (PropertyValidator.isValid((Collection)customViewWorkFlows)) {
            LOGGER.debug("strategic themes workflows list found");
            WorkFlow customViewWorkFlow = (WorkFlow)customViewWorkFlows.get(0);
            if (PropertyValidator.isValid((Object)customViewWorkFlow)) {
                LOGGER.debug("strategic themes workflow found");
                response.put("legacyThemeEnabled", customViewWorkFlow.isLegacyThemeEnabled());
            }
        }
        response.put("success", true);
        return response;
    }

    private static /* synthetic */ void lambda$fetchLinkedOkrs$25(List objIds, Map parentIdsByKrMap, BaseItem kr, BaseItemLink link) {
        if (!link.isArchive() && EnumKendis.PARENT_OBJECTIVE.getCode().equals(link.getLinkType()) && PropertyValidator.isValid((Object)link.getBaseItemId())) {
            objIds.add(link.getBaseItemId());
            parentIdsByKrMap.put(kr.getId(), link.getBaseItemId());
        }
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ AppConfig.MongoConfig access$200(ObjectiveServiceImpl x0) {
        return x0.mongoConfig;
    }

    static /* synthetic */ PushResponseRepository access$300(ObjectiveServiceImpl x0) {
        return x0.pushResponseRepository;
    }

    static /* synthetic */ HashMap access$400(ObjectiveServiceImpl x0, BaseItem x1, List x2) {
        return x0.fetchObjectiveWithLinkedItems(x1, x2);
    }

    static /* synthetic */ BacklogItemRepository access$500(ObjectiveServiceImpl x0) {
        return x0.backlogItemRepository;
    }

    static /* synthetic */ RTItemFetchService access$600(ObjectiveServiceImpl x0) {
        return x0.itemFetchService;
    }

    static /* synthetic */ Double access$700(ObjectiveServiceImpl x0, BaseItem x1, Map x2, List x3, Map x4, HashMap x5, Map x6, Map x7, Map x8, Map x9) throws Exception {
        return x0.calculateKrCompletion(x1, x2, x3, x4, x5, x6, x7, x8, x9);
    }

    static /* synthetic */ HashMap access$800(ObjectiveServiceImpl x0, List x1, List x2) throws Exception {
        return x0.fetchObjectivesWithLinkedItems(x1, x2);
    }

    static /* synthetic */ void access$900(ObjectiveServiceImpl x0, BaseItem x1, List x2, Map x3, Map x4, Map x5, List x6) throws Exception {
        x0.processKrForBatchCalculation(x1, x2, x3, x4, x5, x6);
    }
}

