/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viztrend.safe.annotations.SchedLock;
import com.viztrend.safe.enums.EnumEmailConfig;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLinkType;
import com.viztrend.safe.persistence.entity.Notification;
import com.viztrend.safe.persistence.entity.Preferences;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.NotificaitonServiceImpl;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.utils.IntercommUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="Notification")
public class NotificaitonServiceImpl
implements NotificationService {
    @Autowired
    private Environment env;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificaitonServiceImpl.class);

    public void tempSchedule() {
        SystemUtil.isProductionEnv();
    }

    @Scheduled(cron="0 20 11 * * *")
    public void sendAfterSignupNotifications() {
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            return;
        }
        LOGGER.debug("running schedule for intrecomm attrib updates");
        Calendar cal = this.getTimeBeforeAfter(-30);
        Date startDate = cal.getTime();
        List companies = this.getCompanies(startDate, new Date());
        this.sendEmail(companies);
        LOGGER.debug("intrecomm attrib updates completed");
    }

    private List<Company> getCompanies(Date startDate, Date endDate) {
        Query query = new Query();
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"createdOn").gte((Object)startDate).andOperator(new Criteria[]{Criteria.where((String)"createdOn").lte((Object)endDate).andOperator(new Criteria[]{Criteria.where((String)"nextPaymentDate").exists(false)})})});
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Company.class);
    }

    private void sendEmail(List<Company> companies) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        for (Company company : companies) {
            List users = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isAdmin(company.getId(), Boolean.valueOf(true));
            ArrayList tos = new ArrayList();
            for (User user : users) {
                Company currCompany = ((UserCompany)user.getUserCompanies().get(0)).getCompany();
                Long daysLeft = null;
                if (((UserCompany)user.getUserCompanies().get(0)).getCompany().getExpiryDate() != null) {
                    long diff = ((UserCompany)user.getUserCompanies().get(0)).getCompany().getExpiryDate().getTime() - cal.getTime().getTime();
                    daysLeft = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
                }
                Long usersCount = this.userRepository.countByUserCompanies_Company_IdAndUserCompanies_isArchive(currCompany.getId(), Boolean.valueOf(false));
                Long sessionsCountWithoutAlm = this.sessionRepository.countByTenantAndArchiveFalseAndAlmConfigurationsIsNull(currCompany.getTenant());
                Long sessionsCountWithAlm = this.sessionRepository.countByTenantAndArchiveFalseAndAlmConfigurationsNotNull(currCompany.getTenant());
                List almAccounts = this.almAccountRepository.findByTenant(currCompany.getTenant());
                HashMap<String, Object> vars = new HashMap<String, Object>();
                vars.put("remaining_trial_days", daysLeft);
                vars.put("usersCount", usersCount);
                vars.put("sessionsCountWithoutAlm", sessionsCountWithoutAlm);
                vars.put("sessionsCountWithAlm", sessionsCountWithAlm);
                vars.put("utm_campaign", company.getSignupSource());
                if (PropertyValidator.isValid((Collection)almAccounts)) {
                    AlmAccount almAccount = (AlmAccount)almAccounts.get(0);
                    if (almAccount.getCreatedOn() != null) {
                        vars.put("alm_creation_at", almAccount.getCreatedOn().getTime() / 1000L);
                    }
                    vars.put("alm_type", almAccount.getType());
                }
                IntercommUtils.post((String)user.getUserName(), vars);
            }
        }
    }

    private Calendar getTimeBeforeAfter(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, days);
        return cal;
    }

    public void emailOnDependencyCreation(ItemLink link, HashMap<String, Object> requestMap, String targetItemTitle, String targetTeamTitle, String targetSprintTitle, String tKey) {
        ArrayList<String> emails;
        HashMap<String, Object> emailData = new HashMap<String, Object>();
        String sItemTitle = requestMap.get("sItemTitle").toString().length() < 15 ? requestMap.get("sItemTitle").toString() : requestMap.get("sItemTitle").toString().substring(0, 14);
        String tItemTitle = targetItemTitle.length() < 15 ? targetItemTitle : targetItemTitle.substring(0, 14);
        String sourceKey = requestMap.get("sKey") != null ? requestMap.get("sKey").toString() : "";
        String targetKey = tKey != null ? tKey : "";
        String groupingSubject = sourceKey + " " + sItemTitle + " --> " + targetKey + " " + tItemTitle;
        String linkType = requestMap.get("linkType").toString();
        ItemLinkType itemLinkType = this.itemLinkTypeRepository.findByReferenceName(linkType);
        if (PropertyValidator.isValid((Object)itemLinkType) && PropertyValidator.isValid((Object)itemLinkType.getName())) {
            linkType = itemLinkType.getName();
        }
        emailData.put("linkType", linkType);
        emailData.put("sourceItem", requestMap.get("sItemTitle"));
        emailData.put("sourceSprintTitle", requestMap.get("sSprintTitle"));
        emailData.put("sourceTeamTitle", requestMap.get("sTeamTitle"));
        emailData.put("dueDate", link.getDueDate());
        emailData.put("summary", link.getTitle());
        emailData.put("newstatus", link.getWfStatus().getTitle());
        emailData.put("reporter", link.getReporter() != null ? link.getReporter().getFullName() : "");
        emailData.put("board", requestMap.get("boardTitle"));
        emailData.put("sKey", requestMap.get("sKey"));
        emailData.put("targetItem", targetItemTitle);
        emailData.put("targetTeamTitle", targetTeamTitle);
        emailData.put("targetSprintTitle", targetSprintTitle);
        emailData.put("tKey", tKey);
        String boardUrl = this.getBaseUrl(link.getTenant()) + "/session?id=" + link.getSessionBoardId();
        emailData.put("boardUrl", boardUrl);
        HashMap emailRecipientMap = new HashMap();
        ArrayList<Notification> emailNotificationList = new ArrayList<Notification>();
        if (PropertyValidator.isValid((Object)link.getResponsible())) {
            emailData.put("newResponsible", link.getResponsible().getFullName());
        }
        if (PropertyValidator.isValid((Object)link.getReporter()) && PropertyValidator.isValid((Object)link.getResponsible())) {
            if (link.getReporter().getEmail().equalsIgnoreCase(link.getResponsible().getEmail())) {
                emails = new ArrayList();
                emails.add(link.getResponsible().getEmail());
                emailRecipientMap.put(EnumEmailConfig.USER_RESPONSIBLE.getCode(), emails);
                emailData.put("setReporter", true);
            } else {
                ArrayList<String> reporterEmails = new ArrayList<String>();
                ArrayList<String> responsibleEmails = new ArrayList<String>();
                reporterEmails.add(link.getReporter().getEmail());
                emailRecipientMap.put(EnumEmailConfig.USER_REPORTER.getCode(), reporterEmails);
                responsibleEmails.add(link.getResponsible().getEmail());
                emailRecipientMap.put(EnumEmailConfig.USER_RESPONSIBLE.getCode(), responsibleEmails);
                emailData.put("setReporter", true);
            }
        } else if (PropertyValidator.isValid((Object)link.getReporter())) {
            emails = new ArrayList<String>();
            emails.add(link.getReporter().getEmail());
            emailRecipientMap.put(EnumEmailConfig.USER_REPORTER.getCode(), emails);
        } else if (PropertyValidator.isValid((Object)link.getResponsible())) {
            emails = new ArrayList();
            emails.add(link.getResponsible().getEmail());
            emailRecipientMap.put(EnumEmailConfig.USER_RESPONSIBLE.getCode(), emails);
        }
        if (emailRecipientMap.values().stream().mapToInt(List::size).sum() > 0) {
            Notification notification = new Notification(groupingSubject, groupingSubject, Notification.ItemType.ItemLink, "dependency_oncreate_template", emailRecipientMap, emailData);
            emailNotificationList.add(notification);
            this.notificationRepository.save(emailNotificationList);
        }
    }

    public ArrayList<HashMap<String, Object>> dataJsonForEmail(ItemLink link, ItemLink savedLink, HashMap<String, Object> requestMap) {
        ArrayList<HashMap<String, Object>> emailsnusername = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> dataJson = new HashMap<String, Object>();
        String sourceItemTitle = (String)requestMap.get("sItemTitle");
        String sourceTeamTitle = (String)requestMap.get("sTeamTitle");
        String sourceSprintTitle = (String)requestMap.get("sSprintTitle");
        String sKey = (String)requestMap.get("sKey");
        String oldSourceSprintTitle = (String)requestMap.get("oldsSprintTitle");
        String oldSourceTeamTitle = (String)requestMap.get("oldsTeamTitle");
        List targetSprintTitle = (List)requestMap.get("tSprintTitle");
        List targetTeamTitle = (List)requestMap.get("tTeamTitle");
        List targetItemTitle = (List)requestMap.get("tItemTitle");
        List tKey = (List)requestMap.get("tKey");
        List oldTargetSprintTitle = (List)requestMap.get("oldtSprintTitle");
        List oldTargetTeamTitle = (List)requestMap.get("oldtTeamTitle");
        String sItemTitle = "";
        String tItemTitle = "";
        String sourceKey = "";
        String targetKey = "";
        String objectMapper = new String();
        try {
            objectMapper = new ObjectMapper().writeValueAsString((Object)targetItemTitle);
            sItemTitle = requestMap.get("sItemTitle").toString().length() < 15 ? requestMap.get("sItemTitle").toString() : requestMap.get("sItemTitle").toString().substring(0, 14);
            tItemTitle = ((String)targetItemTitle.get(0)).length() < 15 ? (String)targetItemTitle.get(0) : ((String)targetItemTitle.get(0)).substring(0, 14);
            sourceKey = requestMap.get("sKey") != null ? requestMap.get("sKey").toString() : "";
            targetKey = tKey.get(0) != null ? (String)tKey.get(0) : "";
        }
        catch (Exception ex) {
            LOGGER.error(objectMapper);
        }
        String groupingSubject = sourceKey + " " + sItemTitle + " --> " + targetKey + " " + tItemTitle;
        String boardTitle = (String)requestMap.get("boardTitle");
        String summary = (String)requestMap.get("summary");
        String linkType = (String)requestMap.get("linkType") != null ? (String)requestMap.get("linkType") : (String)requestMap.get("type");
        ItemLinkType itemLinkType = this.itemLinkTypeRepository.findByReferenceName(linkType);
        if (PropertyValidator.isValid((Object)itemLinkType) && PropertyValidator.isValid((Object)itemLinkType.getName())) {
            linkType = itemLinkType.getName();
        }
        if (PropertyValidator.isValid((Object)link.getReporter())) {
            String string = (String)requestMap.get(link.getReporter().getFullName());
        }
        String dueDate = requestMap.get("dueDate") != null ? requestMap.get("dueDate").toString() : null;
        HashMap emailRecipientMap = new HashMap();
        int index = 0;
        if (link.getResponsible() != null) {
            String oldStatus;
            ArrayList<String> emails = new ArrayList<String>();
            emails.add(link.getResponsible().getEmail());
            emailRecipientMap.put(EnumEmailConfig.USER_RESPONSIBLE.getCode(), emails);
            dataJson.put("groupingSubject", groupingSubject);
            dataJson.put("sourceItem", sourceItemTitle);
            if (PropertyValidator.isValid((Collection)targetItemTitle) && targetItemTitle.size() > index) {
                dataJson.put("targetItem", targetItemTitle.get(index));
            }
            if (!(oldStatus = savedLink.getWfStatus() != null ? savedLink.getWfStatus().getTitle() : savedLink.getStatus()).equalsIgnoreCase(link.getWfStatus().getTitle())) {
                dataJson.put("earlierstatus", oldStatus);
            }
            dataJson.put("newstatus", link.getWfStatus().getTitle());
            dataJson.put("board", boardTitle);
            if (savedLink.getResponsible() != null && !savedLink.getResponsible().getId().equals(link.getResponsible().getId())) {
                dataJson.put("oldResponsible", savedLink.getResponsible().getFullName());
            }
            dataJson.put("newResponsible", link.getResponsible() != null ? link.getResponsible().getFullName() : null);
            dataJson.put("sourceSprintTitle", sourceSprintTitle);
            if (PropertyValidator.isValid((Object)oldSourceSprintTitle)) {
                dataJson.put("oldSourceSprintTitle", oldSourceSprintTitle);
            }
            if (PropertyValidator.isValid((Object)oldSourceTeamTitle)) {
                dataJson.put("oldSourceTeamTitle", oldSourceTeamTitle);
            }
            if (PropertyValidator.isValid((Collection)oldTargetSprintTitle) && oldTargetSprintTitle.size() > index) {
                dataJson.put("oldTargetSprintTitle", oldTargetSprintTitle.get(index));
            }
            if (PropertyValidator.isValid((Collection)oldTargetTeamTitle) && oldTargetTeamTitle.size() > index) {
                dataJson.put("oldTargetTeamTitle", oldTargetTeamTitle.get(index));
            }
            if (targetSprintTitle.size() > index) {
                dataJson.put("targetSprintTitle", targetSprintTitle.get(index));
            }
            dataJson.put("sourceTeamTitle", sourceTeamTitle);
            if (targetTeamTitle.size() > index) {
                dataJson.put("targetTeamTitle", targetTeamTitle.get(index));
            }
            dataJson.put("dueDate", dueDate);
            dataJson.put("summary", summary);
            dataJson.put("linkType", linkType);
            dataJson.put("reporter", link.getReporter() != null ? link.getReporter().getFullName() : null);
            dataJson.put("sKey", sKey);
            if (tKey.size() > index) {
                dataJson.put("tKey", tKey.get(index));
            }
        }
        if (PropertyValidator.isValid((Collection)savedLink.getWatcherList())) {
            ArrayList<String> emails = new ArrayList<String>();
            if (dataJson.isEmpty()) {
                String oldStatus;
                dataJson.put("groupingSubject", groupingSubject);
                dataJson.put("sourceItem", sourceItemTitle);
                if (targetItemTitle.size() > index) {
                    dataJson.put("targetItem", targetItemTitle.get(index));
                }
                if (!(oldStatus = savedLink.getWfStatus() != null ? savedLink.getWfStatus().getTitle() : savedLink.getStatus()).equalsIgnoreCase(link.getWfStatus().getTitle())) {
                    dataJson.put("earlierstatus", oldStatus);
                }
                if (PropertyValidator.isValid((Object)oldSourceSprintTitle)) {
                    dataJson.put("oldSourceSprintTitle", oldSourceSprintTitle);
                }
                if (PropertyValidator.isValid((Object)oldSourceTeamTitle)) {
                    dataJson.put("oldSourceTeamTitle", oldSourceTeamTitle);
                }
                if (PropertyValidator.isValid((Collection)oldTargetSprintTitle) && oldTargetSprintTitle.size() > index) {
                    dataJson.put("oldTargetSprintTitle", oldTargetSprintTitle.get(index));
                }
                if (PropertyValidator.isValid((Collection)oldTargetTeamTitle) && oldTargetTeamTitle.size() > index) {
                    dataJson.put("oldTargetTeamTitle", oldTargetTeamTitle.get(index));
                }
                dataJson.put("newstatus", link.getWfStatus().getTitle());
                dataJson.put("board", boardTitle);
                dataJson.put("sourceSprintTitle", sourceSprintTitle);
                if (targetSprintTitle.size() > index) {
                    dataJson.put("targetSprintTitle", targetSprintTitle.get(index));
                }
                dataJson.put("sourceTeamTitle", sourceTeamTitle);
                if (targetTeamTitle.size() > index) {
                    dataJson.put("targetTeamTitle", targetTeamTitle.get(index));
                }
                if (!(!PropertyValidator.isValid((Object)savedLink.getResponsible()) || PropertyValidator.isValid((Object)link.getResponsible()) && savedLink.getResponsible().getId().equals(link.getResponsible().getId()))) {
                    dataJson.put("oldResponsible", savedLink.getResponsible().getFullName());
                }
                dataJson.put("newResponsible", link.getResponsible() != null ? link.getResponsible().getFullName() : null);
                dataJson.put("dueDate", dueDate);
                dataJson.put("summary", summary);
                dataJson.put("reporter", link.getReporter() != null ? link.getReporter().getFullName() : null);
                dataJson.put("linkType", linkType);
                dataJson.put("sKey", sKey);
                if (tKey.size() > index) {
                    dataJson.put("tKey", tKey.get(index));
                }
            }
            for (Watcher wT : savedLink.getWatcherList()) {
                ArrayList users = new ArrayList();
                if (wT.getUser() != null) {
                    users.add(wT.getUser());
                } else if (PropertyValidator.isValid((Object)wT.getGroup()) && PropertyValidator.isValid((Collection)wT.getGroup().getUsers())) {
                    users = (ArrayList)this.userRepository.findByIdIn(wT.getGroup().getUsers());
                }
                for (User user : users) {
                    boolean isOldResponsible;
                    boolean bl = isOldResponsible = PropertyValidator.isValid((Object)savedLink.getResponsible()) && savedLink.getResponsible().getEmail().equalsIgnoreCase(user.getEmail());
                    if (PropertyValidator.isValid((Object)link.getResponsible()) && link.getResponsible().getEmail().equalsIgnoreCase(user.getEmail()) || isOldResponsible) continue;
                    emails.add(user.getEmail());
                }
            }
            if (emails.size() > 0) {
                emailRecipientMap.put(EnumEmailConfig.USER_WATCHER.getCode(), emails);
            }
        }
        if (link.getResponsible() == null && savedLink.getResponsible() != null && dataJson.isEmpty()) {
            dataJson.put("groupingSubject", groupingSubject);
            dataJson.put("sourceItem", sourceItemTitle);
            if (targetItemTitle.size() > index) {
                dataJson.put("targetItem", targetItemTitle.get(index));
            }
            dataJson.put("newstatus", link.getWfStatus().getTitle());
            dataJson.put("board", boardTitle);
            dataJson.put("oldResponsible", savedLink.getResponsible().getFullName());
            dataJson.put("newResponsible", link.getResponsible() != null ? link.getResponsible().getFullName() : null);
            dataJson.put("sourceSprintTitle", sourceSprintTitle);
            if (PropertyValidator.isValid((Object)oldSourceSprintTitle)) {
                dataJson.put("oldSourceSprintTitle", oldSourceSprintTitle);
            }
            if (PropertyValidator.isValid((Object)oldSourceTeamTitle)) {
                dataJson.put("oldSourceTeamTitle", oldSourceTeamTitle);
            }
            if (PropertyValidator.isValid((Collection)oldTargetSprintTitle) && oldTargetSprintTitle.size() > index) {
                dataJson.put("oldTargetSprintTitle", oldTargetSprintTitle.get(index));
            }
            if (PropertyValidator.isValid((Collection)oldTargetTeamTitle) && oldTargetTeamTitle.size() > index) {
                dataJson.put("oldTargetTeamTitle", oldTargetTeamTitle.get(index));
            }
            if (targetSprintTitle.size() > index) {
                dataJson.put("targetSprintTitle", targetSprintTitle.get(index));
            }
            dataJson.put("sourceTeamTitle", sourceTeamTitle);
            if (targetTeamTitle.size() > index) {
                dataJson.put("targetTeamTitle", targetTeamTitle.get(index));
            }
            dataJson.put("dueDate", dueDate);
            dataJson.put("summary", summary);
            dataJson.put("linkType", linkType);
            dataJson.put("reporter", link.getReporter() != null ? link.getReporter().getFullName() : null);
            dataJson.put("sKey", sKey);
            if (tKey.size() > index) {
                dataJson.put("tKey", tKey.get(index));
            }
        }
        dataJson.put("emailRecipientMap", emailRecipientMap);
        String boardUrl = this.getBaseUrl(link.getTenant()) + "/session?id=" + link.getSessionBoardId();
        dataJson.put("boardUrl", boardUrl);
        emailsnusername.add(dataJson);
        return emailsnusername;
    }

    public void createMeta(ItemLink link, HashMap<String, Object> requestMap) {
        Item target;
        ArrayList<String> itemIds = new ArrayList<String>();
        ArrayList<String> teamContainerIds = new ArrayList<String>();
        ArrayList teamIds = new ArrayList();
        ArrayList containerIds = new ArrayList();
        ArrayList targetSprintTitle = new ArrayList();
        ArrayList targetTeamTitle = new ArrayList();
        ArrayList<String> targetItemTitle = new ArrayList<String>();
        ArrayList<String> tKey = new ArrayList<String>();
        ArrayList<String> oldTargetSprintTitle = new ArrayList<String>();
        ArrayList<String> oldTargetTeamTitle = new ArrayList<String>();
        Item oldStateItem = (Item)requestMap.get("oldStateItem");
        SessionBoard sessionBoard = this.sessionBoardRepository.findSessionBoardById(link.getSessionBoardId());
        if (PropertyValidator.isValid((Object)link.getSourceUserStoryId())) {
            itemIds.add(link.getSourceUserStoryId());
        } else if (PropertyValidator.isValid((Object)link.getSourceItemId())) {
            itemIds.add(link.getSourceItemId());
        } else {
            itemIds.add(link.getSourceFeatureId());
        }
        if (PropertyValidator.isValid((Object)link.getTargetUserStoryId())) {
            itemIds.add(link.getTargetUserStoryId());
        } else if (PropertyValidator.isValid((Object)link.getTargetItemId())) {
            itemIds.add(link.getTargetItemId());
        } else {
            itemIds.add(link.getTargetFeatureId());
        }
        teamContainerIds.add(link.getSourceTeamContainerId());
        teamContainerIds.add(link.getTargetTeamContainerId());
        List itemList = this.itemRepository.findByIdIn(itemIds);
        HashMap itemMapById = new HashMap();
        itemList.forEach(item -> itemMapById.put(item.getId(), item));
        List teamContainerList = this.teamContainerRepository.findByIdIn(teamContainerIds);
        HashMap teamContainerMapById = new HashMap();
        teamContainerList.forEach(tC -> {
            containerIds.add(tC.getContainer().getId());
            teamIds.add(tC.getTeam().getId());
            teamContainerMapById.put(tC.getId(), tC);
        });
        List containerList = this.containerRepository.findByIdIn(containerIds);
        List teamList = this.teamRepository.findByIdIn(teamIds);
        HashMap ContainerTitleMapById = new HashMap();
        HashMap TeamTitleMapById = new HashMap();
        containerList.forEach(container -> ContainerTitleMapById.put(container.getId(), container.getTitle()));
        teamList.forEach(team -> TeamTitleMapById.put(team.getId(), team.getTitle()));
        Item source = (Item)itemMapById.get(link.getSourceUserStoryId() != null ? link.getSourceUserStoryId() : (link.getSourceItemId() != null ? link.getSourceItemId() : link.getSourceFeatureId()));
        if (PropertyValidator.isValid((Object)source)) {
            TeamContainer sourceTeamContainer = (TeamContainer)teamContainerMapById.get(link.getSourceTeamContainerId());
            requestMap.put("sItemTitle", source.getTitle());
            requestMap.put("sKey", source.getJiraKey() != null ? source.getJiraKey() : source.getTfsId());
            if (PropertyValidator.isValid((Object)sourceTeamContainer)) {
                requestMap.put("sTeamTitle", TeamTitleMapById.get(sourceTeamContainer.getTeam().getId()));
                requestMap.put("sSprintTitle", ContainerTitleMapById.get(sourceTeamContainer.getContainer().getId()));
                if (PropertyValidator.isValid((Object)oldStateItem) && oldStateItem.getId().equals(source.getId())) {
                    if (!oldStateItem.getContainer().getId().equals(sourceTeamContainer.getContainer().getId())) {
                        requestMap.put("oldsSprintTitle", oldStateItem.getContainer().getTitle());
                    }
                    if (!oldStateItem.getTeam().getId().equals(sourceTeamContainer.getTeam().getId())) {
                        requestMap.put("oldsTeamTitle", oldStateItem.getTeam().getTitle());
                    }
                }
            }
        }
        if (PropertyValidator.isValid((Object)(target = (Item)itemMapById.get(link.getTargetUserStoryId() != null ? link.getTargetUserStoryId() : (link.getTargetItemId() != null ? link.getTargetItemId() : link.getTargetFeatureId()))))) {
            TeamContainer targetTeamContainer = (TeamContainer)teamContainerMapById.get(link.getTargetTeamContainerId());
            targetItemTitle.add(target.getTitle());
            tKey.add(target.getJiraKey() != null ? target.getJiraKey() : target.getTfsId());
            if (PropertyValidator.isValid((Object)targetTeamContainer)) {
                targetSprintTitle.add(ContainerTitleMapById.get(targetTeamContainer.getContainer().getId()));
                targetTeamTitle.add(TeamTitleMapById.get(targetTeamContainer.getTeam().getId()));
                if (PropertyValidator.isValid((Object)oldStateItem) && oldStateItem.getId().equals(target.getId())) {
                    if (PropertyValidator.isValid((Object)oldStateItem.getContainer()) && !oldStateItem.getContainer().getId().equals(targetTeamContainer.getContainer().getId())) {
                        oldTargetSprintTitle.add(oldStateItem.getContainer().getTitle());
                    }
                    if (PropertyValidator.isValid((Object)oldStateItem.getTeam()) && !oldStateItem.getTeam().getId().equals(targetTeamContainer.getTeam().getId())) {
                        oldTargetTeamTitle.add(oldStateItem.getTeam().getTitle());
                    }
                }
            }
        }
        requestMap.put("oldtSprintTitle", oldTargetSprintTitle);
        requestMap.put("oldtTeamTitle", oldTargetTeamTitle);
        requestMap.put("tSprintTitle", targetSprintTitle);
        requestMap.put("tItemTitle", targetItemTitle);
        requestMap.put("tTeamTitle", targetTeamTitle);
        requestMap.put("tKey", tKey);
        if (PropertyValidator.isValid((Object)sessionBoard)) {
            requestMap.put("boardTitle", sessionBoard.getSession().getTitle());
        }
        requestMap.put("summary", link.getTitle());
        requestMap.put("linkType", link.getType());
        requestMap.put("dueDate", link.getDueDate());
    }

    public String getEmailSubject(HashMap<String, Object> emailsMap) {
        if (PropertyValidator.isValid((Object)emailsMap.get("oldSourceSprintTitle")) && PropertyValidator.isValid((Object)emailsMap.get("oldSourceTeamTitle"))) {
            return "Creator sprint and creator team of the dependency has changed";
        }
        if (PropertyValidator.isValid((Object)emailsMap.get("oldSourceSprintTitle"))) {
            return "Creator sprint of the dependency has changed";
        }
        if (PropertyValidator.isValid((Object)emailsMap.get("oldSourceTeamTitle"))) {
            return "Creator team of the dependency has changed";
        }
        if (PropertyValidator.isValid((Object)emailsMap.get("oldTargetSprintTitle")) && PropertyValidator.isValid((Object)emailsMap.get("oldTargetTeamTitle"))) {
            return "Receiver sprint and receiver team of the dependency has changed";
        }
        if (PropertyValidator.isValid((Object)emailsMap.get("oldTargetSprintTitle"))) {
            return "Receiver sprint of the dependency has changed";
        }
        if (PropertyValidator.isValid((Object)emailsMap.get("oldTargetTeamTitle"))) {
            return "Receiver team of the dependency has changed";
        }
        return null;
    }

    @SchedLock(name="processNotifications")
    @Scheduled(cron="0 */5 * ? * *")
    public Boolean sendNotification() {
        HashSet sentNotificationIds = new HashSet();
        try {
            Stream.of(emailTypes.values()).forEach(type -> {
                List recipients = this.mongoTemplate.getCollection("notification").distinct("recipientList." + type.name());
                if (PropertyValidator.isValid((Collection)recipients)) {
                    recipients.forEach(recipient -> {
                        User user = this.userRepository.findByUserNameOrEmail(recipient, recipient);
                        List notifications = new ArrayList();
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)("recipientList." + type.name())).is(recipient));
                        notifications = this.mongoTemplate.find(query, Notification.class);
                        notifications.forEach(notification -> sentNotificationIds.add(notification.getId()));
                        if (PropertyValidator.isValid((Object)user)) {
                            if (this.sendEmailToUser(user, type.name(), "Dependency") || this.sendEmailToUser(user, type.name(), "Objective") || type.name() == Notification.ItemType.SOS.name() || type.name() == Notification.ItemType.Risk.name()) {
                                Map<String, List<Notification>> groupNotificattion = notifications.stream().collect(Collectors.groupingBy(Notification::getGroupingSubject));
                                groupNotificattion.forEach((subject, notificationList) -> {
                                    HashMap<String, String> greetingContent = new HashMap<String, String>();
                                    greetingContent.put("firstName", user.getFirstName());
                                    StringBuffer templateHtml = new StringBuffer();
                                    templateHtml.append(LocalMailSender.generateHtml((String)"header"));
                                    templateHtml.append(LocalMailSender.generateHtml((String)"greeting_template", greetingContent));
                                    boolean sendEmail = false;
                                    for (Notification notification : notificationList) {
                                        if (Objects.equals(notification.getType(), Notification.ItemType.Risk) && (notification.getType() != Notification.ItemType.Risk || !this.sendRiskEmailToUser(user, type.name(), Notification.ItemType.Risk.name(), notification.getNotificationActionType()))) continue;
                                        sendEmail = true;
                                        notification.getContent().remove("emailRecipientMap");
                                        templateHtml.append(LocalMailSender.generateHtml((String)notification.getTemplate(), (Map)notification.getContent()));
                                    }
                                    templateHtml.append(LocalMailSender.generateHtml((String)"footer"));
                                    if (sendEmail) {
                                        this.mailSender.sendMail(recipient, subject, templateHtml.toString(), true);
                                    }
                                });
                            }
                        } else {
                            LOGGER.debug("Invalid user for email");
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error while scheduling email :" + StringUtils.getTraceString((Throwable)e));
        }
        finally {
            this.deleteSentNotifications(sentNotificationIds);
        }
        return true;
    }

    public void processSingleNotification(Notification notification) {
        try {
            if (notification == null || notification.getRecipientList() == null) {
                LOGGER.debug("Invalid notification or recipient list is null");
                return;
            }
            notification.getRecipientList().forEach((recipientType, recipients) -> {
                if (PropertyValidator.isValid((Collection)recipients)) {
                    recipients.forEach(recipient -> {
                        User user = this.userRepository.findByUserNameOrEmail(recipient, recipient);
                        if (PropertyValidator.isValid((Object)user)) {
                            if (this.sendEmailToUser(user, recipientType, "Dependency") || this.sendEmailToUser(user, recipientType, "Objective") || recipientType.equals(Notification.ItemType.SOS.name()) || recipientType.equals(Notification.ItemType.Risk.name())) {
                                HashMap<String, String> greetingContent = new HashMap<String, String>();
                                greetingContent.put("firstName", user.getFirstName());
                                StringBuffer templateHtml = new StringBuffer();
                                templateHtml.append(LocalMailSender.generateHtml((String)"header"));
                                templateHtml.append(LocalMailSender.generateHtml((String)"greeting_template", greetingContent));
                                boolean sendEmail = false;
                                if (!Objects.equals(notification.getType(), Notification.ItemType.Risk) || notification.getType() == Notification.ItemType.Risk && this.sendRiskEmailToUser(user, recipientType, Notification.ItemType.Risk.name(), notification.getNotificationActionType())) {
                                    sendEmail = true;
                                    if (notification.getContent() != null) {
                                        notification.getContent().remove("emailRecipientMap");
                                    }
                                    templateHtml.append(LocalMailSender.generateHtml((String)notification.getTemplate(), (Map)notification.getContent()));
                                }
                                templateHtml.append(LocalMailSender.generateHtml((String)"footer"));
                                if (sendEmail) {
                                    String subject = notification.getEmailSubject() != null ? notification.getEmailSubject() : notification.getGroupingSubject();
                                    this.mailSender.sendMail(recipient, subject, templateHtml.toString(), true);
                                }
                            }
                        } else {
                            LOGGER.debug("Invalid user for email: " + recipient);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error while processing single notification: " + StringUtils.getTraceString((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean sendDailyNotificationDigest() {
        HashSet recipients = new HashSet();
        HashSet sentNotificationIds = new HashSet();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isDailyDigest").is((Object)true));
        try {
            List notifications = this.mongoTemplate.find(query, Notification.class);
            notifications.forEach(notification -> {
                notification.getEmails().forEach(email -> recipients.add(email));
                sentNotificationIds.add(notification.getId());
            });
            recipients.forEach(recipient -> {
                User user = this.userRepository.findByUserName(recipient);
                List recipientNotifications = notifications.stream().filter(notification -> notification.getEmails().contains(recipient)).collect(Collectors.toList());
                this.sendEmailDigest(user, recipientNotifications);
            });
        }
        catch (Exception ex) {
            LOGGER.error("Error While Sending Daily Digest" + StringUtils.getTraceString((Throwable)ex));
        }
        finally {
            this.deleteSentNotifications(sentNotificationIds);
        }
        return false;
    }

    public void deleteSentNotifications(Set ids) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)ids));
        this.mongoTemplate.remove(query, Notification.class);
    }

    public boolean sendEmailToUser(User user, String eventType, String emailCategory) {
        if (emailCategory == "Dependency" && PropertyValidator.isValid((Object)user)) {
            User updatedUser = this.userRepository.findById(user.getId());
            if (PropertyValidator.isValid((Object)updatedUser.getUserPreferences())) {
                if (updatedUser.getUserPreferences().isEnableForDependency()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean sendRiskEmailToUser(User user, String eventType, String emailCategory, Notification.NotificationActionType actionType) {
        if (emailCategory == "Risk" && PropertyValidator.isValid((Object)user)) {
            User updatedUser = this.userRepository.findById(user.getId());
            if (PropertyValidator.isValid((Object)updatedUser.getUserPreferences())) {
                if (PropertyValidator.isValid((Object)updatedUser.getUserPreferences().getEmailConfig()) && PropertyValidator.isValid(((Map)updatedUser.getUserPreferences().getEmailConfig().get(emailCategory)).get(eventType)) && ((Notification.EmailInterval)((Preferences)((Map)updatedUser.getUserPreferences().getEmailConfig().get(emailCategory)).get(eventType)).getActionTypes().get(actionType)).equals((Object)Notification.EmailInterval.Immediately)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public void notifyUsers(Map<String, Set<User>> recipientMap, Notification.ItemType notificationType, Notification.NotificationActionType actionType, HashMap<String, Object> content, String template) {
        try {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void emailOnObjectiveCreation(HashMap<String, Object> requestMap, String title, String key, List<String> recepients, String actionType) {
        HashMap emailData = new HashMap();
        String targetKey = key != null ? key : "";
        String groupingSubject = "";
        groupingSubject = actionType.equals("Conversation") ? "Objective Conversation Update" : (actionType.equals("Item Linking") ? targetKey + " " + title + " new linked items" : targetKey + " " + title + " " + actionType);
        HashMap<String, List<String>> emailRecipientMap = new HashMap<String, List<String>>();
        ArrayList<Notification> emailNotificationList = new ArrayList<Notification>();
        if (PropertyValidator.isValid(recepients)) {
            emailRecipientMap.put(EnumEmailConfig.USER_REPORTER.getCode(), recepients);
        }
        if (emailRecipientMap.values().stream().mapToInt(List::size).sum() > 0) {
            Notification notification = new Notification(groupingSubject, groupingSubject, Notification.ItemType.Objective, "objective_oncreate_template", emailRecipientMap, requestMap);
            emailNotificationList.add(notification);
            this.notificationRepository.save(emailNotificationList);
        }
    }

    public void emailOnConversationTag(HashMap<String, Object> requestMap, String title, String key, List<String> recepients) {
        HashMap emailData = new HashMap();
        String groupingSubject = "Objective conversation tagging";
        HashMap<String, List<String>> emailRecipientMap = new HashMap<String, List<String>>();
        ArrayList<Notification> emailNotificationList = new ArrayList<Notification>();
        if (PropertyValidator.isValid(recepients)) {
            emailRecipientMap.put(EnumEmailConfig.USER_REPORTER.getCode(), recepients);
        }
        if (emailRecipientMap.values().stream().mapToInt(List::size).sum() > 0) {
            Notification notification = new Notification(groupingSubject, groupingSubject, Notification.ItemType.Objective, "conversation_tag_template", emailRecipientMap, requestMap);
            emailNotificationList.add(notification);
            this.notificationRepository.save(emailNotificationList);
        }
    }

    public void emailOnObjectiveDeletion(HashMap<String, Object> requestMap, List<String> recepients) {
        String groupingSubject = "Obj/KR Deletion";
        HashMap<String, List<String>> emailRecipientMap = new HashMap<String, List<String>>();
        ArrayList<Notification> emailNotificationList = new ArrayList<Notification>();
        if (PropertyValidator.isValid(recepients)) {
            emailRecipientMap.put(EnumEmailConfig.USER_REPORTER.getCode(), recepients);
        }
        if (emailRecipientMap.values().stream().mapToInt(List::size).sum() > 0) {
            Notification notification = new Notification(groupingSubject, groupingSubject, Notification.ItemType.Objective, "objective_delete_template", emailRecipientMap, requestMap);
            emailNotificationList.add(notification);
            this.notificationRepository.save(emailNotificationList);
        }
    }

    public void sendCheckInEmail(HashMap<String, Object> requestMap, Set<String> recipients) {
    }

    private Notification.EmailInterval checkUserPreference(String recipientType, Notification.ItemType notificationType, Notification.NotificationActionType actionType, User user) {
        if (PropertyValidator.isValid((Object)user.getUserPreferences()) && PropertyValidator.isValid((Object)user.getUserPreferences().getEmailConfig()) && PropertyValidator.isValid(user.getUserPreferences().getEmailConfig().get(notificationType.name()))) {
            return (Notification.EmailInterval)((Preferences)((Map)user.getUserPreferences().getEmailConfig().get(notificationType.name())).get(recipientType)).getActionTypes().get(actionType);
        }
        return null;
    }

    private void sendImmediateMail(User user, HashMap<String, Object> content, String template) {
        StringBuffer templateHtml = new StringBuffer();
        this.setEmailHeader(user.getFirstName(), templateHtml);
        templateHtml.append(LocalMailSender.generateHtml((String)template, content));
        templateHtml.append(LocalMailSender.generateHtml((String)"footer"));
        this.mailSender.sendMail(user.getEmail(), "subject", templateHtml.toString(), true);
    }

    private void sendEmailDigest(User user, List<Notification> notifications) {
        StringBuffer templateHtml = new StringBuffer();
        this.setEmailHeader(user.getFirstName(), templateHtml);
        notifications.forEach(notification -> templateHtml.append(LocalMailSender.generateHtml((String)notification.getTemplate(), (Map)notification.getContent())));
        templateHtml.append(LocalMailSender.generateHtml((String)"footer"));
        this.mailSender.sendMail(user.getEmail(), "subject", templateHtml.toString(), true);
    }

    public void setEmailHeader(String firstName, StringBuffer templateHtml) {
        HashMap<String, String> greetingContent = new HashMap<String, String>();
        greetingContent.put("firstName", firstName);
        templateHtml.append(LocalMailSender.generateHtml((String)"header"));
        templateHtml.append(LocalMailSender.generateHtml((String)"greeting_template", greetingContent));
    }

    private String getHttpScheme() {
        if (this.env.getProperty("redirect.from.http.server.port") != null) {
            return "https";
        }
        return "http";
    }

    public String getBaseUrl(String tenant) {
        String cid = this.companyRepository.findByTenant(tenant).getId();
        Company comp = (Company)this.companyRepository.findOne((Serializable)((Object)cid));
        String baseUrl = this.getHttpScheme() + "://" + comp.getUrlPrefix() + "." + this.env.getProperty("server.domain");
        if (this.env.getProperty("isLocalDeployment").equals("true")) {
            baseUrl = UserContextUtil.getUserContext().getCurrentCompany().getUrl();
        }
        return baseUrl;
    }

    public void startNotificationThread(ItemLink link, ItemLink savedLink, String template, Boolean isOldResponsible, String comment) {
        try {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    static /* synthetic */ NotificationRepository access$000(NotificaitonServiceImpl x0) {
        return x0.notificationRepository;
    }

    static /* synthetic */ Notification.EmailInterval access$100(NotificaitonServiceImpl x0, String x1, Notification.ItemType x2, Notification.NotificationActionType x3, User x4) {
        return x0.checkUserPreference(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$200(NotificaitonServiceImpl x0, User x1, HashMap x2, String x3) {
        x0.sendImmediateMail(x1, x2, x3);
    }
}

