/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.internal.LinkedTreeMap;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.dto.MilestoneCalculationResultDTO;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.service.MilestoneCalculationService;
import com.viztrend.safe.service.MilestoneCalculationServiceImpl;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="MilestoneCalculationService")
public class MilestoneCalculationServiceImpl
implements MilestoneCalculationService {
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private RTItemFetchService rtItemFetchService;
    @Autowired
    private StatusRepository statusRepository;
    private static final double PERCENT_MULTIPLIER = 100.0;
    private static final double ROUNDING_OFFSET_MULTIPLIER = 100.0;

    public Map<String, Object> calculateMilestoneCompletion(HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List milestoneIds = new ArrayList();
        if (params.containsKey("milestoneIds")) {
            milestoneIds = (List)params.get("milestoneIds");
        }
        if (PropertyValidator.isValid(milestoneIds)) {
            List milestones = this.backlogItemRepository.findByIdIn(milestoneIds);
            if (PropertyValidator.isValid((Collection)milestones)) {
                for (BacklogItem milestone : milestones) {
                    Set artIds = milestone.getItemRelations().stream().filter(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId())).map(BaseItemLink::getReleaseTrainId).collect(Collectors.toSet());
                    ArrayList<MilestoneCalculationResultDTO> milestoneCalculationResultDTOList = new ArrayList<MilestoneCalculationResultDTO>();
                    for (String artId : artIds) {
                        MilestoneCalculationResultDTO milestoneCalculationResultDTO = this.calculateCompletionByArt(milestone, artId);
                        milestoneCalculationResultDTOList.add(milestoneCalculationResultDTO);
                    }
                    if (!milestoneCalculationResultDTOList.isEmpty()) {
                        result.put(milestone.getId(), milestoneCalculationResultDTOList);
                        continue;
                    }
                    MilestoneCalculationResultDTO milestoneCalculationResultDTO = new MilestoneCalculationResultDTO();
                    result.put(milestone.getId(), Collections.singleton(milestoneCalculationResultDTO));
                }
                result.put("success", true);
            } else {
                result.put("error", "Invalid Milestone Ids");
            }
        }
        return result;
    }

    private MilestoneCalculationResultDTO calculateCompletionByArt(BacklogItem milestone, String releaseTrainId) throws Exception {
        ArrayList linkedItemIds = new ArrayList(milestone.getItemRelations().stream().filter(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId()) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && baseItemLink.getReleaseTrainId().equals(releaseTrainId)).map(BaseItemLink::getBaseItemId).collect(Collectors.toList()));
        return this.calculateCompletion(linkedItemIds, releaseTrainId);
    }

    public MilestoneCalculationResultDTO calculateCompletion(List<String> linkedItemIds, String releaseTrainId) throws Exception {
        MilestoneCalculationResultDTO milestoneCalculationResultDTO = new MilestoneCalculationResultDTO();
        if (PropertyValidator.isValid(linkedItemIds)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            HashMap<String, Object> rule = new HashMap<String, Object>();
            rule.put("key", "itemIds");
            rule.put("type", "array");
            rule.put("almType", "");
            rule.put("value", linkedItemIds);
            LinkedTreeMap filter = new LinkedTreeMap();
            ArrayList<HashMap<String, Object>> rules = new ArrayList<HashMap<String, Object>>();
            rules.add(rule);
            filter.put((Object)"condition", (Object)"AND");
            filter.put((Object)"rules", rules);
            params.put("filter", filter);
            params.put("loadStatuses", true);
            params.put("rollupStoryPointsArray", true);
            params.put("sortBy", "sequence");
            params.put("sortOrder", "1");
            Map result = this.rtItemFetchService.getBacklogItemsWithLevel(releaseTrainId, params);
            Map resultMap = (Map)result.get("result");
            int itemsDone = 0;
            BasicDBList dbItems = (BasicDBList)resultMap.get("items");
            ArrayList<StoryPointStatusInformation> storyPointStatusInformationList = new ArrayList<StoryPointStatusInformation>();
            ArrayList<String> childrenStatusesInformation = new ArrayList<String>();
            for (int i = 0; i < dbItems.size(); ++i) {
                String statusId;
                Status status;
                DBObject statusObject;
                int j;
                DBObject dbObject = (DBObject)dbItems.get(i);
                if (dbObject.containsField("childStoryPointsByStatus")) {
                    BasicDBList childStoryPointsByStatusList = (BasicDBList)dbObject.get("childStoryPointsByStatus");
                    for (j = 0; j < childStoryPointsByStatusList.size(); ++j) {
                        DBObject childStoryPointInformation = (DBObject)childStoryPointsByStatusList.get(j);
                        if (!childStoryPointInformation.containsField("status") || !childStoryPointInformation.containsField("storyPoints")) continue;
                        Object statusId2 = null;
                        if (childStoryPointInformation.get("status") == null) {
                            statusId2 = this.getMiscStatus();
                        } else if (childStoryPointInformation.get("status") != null) {
                            statusId2 = childStoryPointInformation.get("status").toString();
                        }
                        Double storyPoints = (Double)childStoryPointInformation.get("storyPoints");
                        StoryPointStatusInformation storyPointStatusInformation = new StoryPointStatusInformation(this, (String)statusId2, storyPoints);
                        storyPointStatusInformationList.add(storyPointStatusInformation);
                    }
                }
                if (dbObject.containsField("status") && (statusObject = (DBObject)dbObject.get("status")).containsField("id") && PropertyValidator.isValid((Object)(status = (Status)this.statusRepository.findOne((Serializable)((Object)(statusId = statusObject.get("id").toString())))))) {
                    if (PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                        status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                    }
                    if (status.getCategory().equalsIgnoreCase("Done")) {
                        ++itemsDone;
                    }
                }
                if (!dbObject.containsField("childrenStatuses")) continue;
                BasicDBList childrenStatusesList = (BasicDBList)dbObject.get("childrenStatuses");
                for (j = 0; j < childrenStatusesList.size(); ++j) {
                    if (childrenStatusesList.get(j) == null) {
                        childrenStatusesInformation.add(this.getMiscStatus());
                        continue;
                    }
                    childrenStatusesInformation.add(childrenStatusesList.get(j).toString());
                }
            }
            int doneStatuses = 0;
            double totalStoryPoints = 0.0;
            double doneStoryPoints = 0.0;
            for (StoryPointStatusInformation info : storyPointStatusInformationList) {
                String statusId = info.getStatusId();
                Status status = (Status)this.statusRepository.findOne((Serializable)((Object)statusId));
                double storyPoints = info.getStoryPoints();
                if (PropertyValidator.isValid((Object)status)) {
                    if (PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                        status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                    }
                    if (status.getCategory().equalsIgnoreCase("Done")) {
                        ++doneStatuses;
                        doneStoryPoints += storyPoints;
                    }
                }
                totalStoryPoints += storyPoints;
            }
            int totalDoneChildren = 0;
            int totalChildCount = 0;
            for (String statusId : childrenStatusesInformation) {
                Status status = (Status)this.statusRepository.findOne((Serializable)((Object)statusId));
                if (!PropertyValidator.isValid((Object)status)) continue;
                if (PropertyValidator.isValid((Object)status.getCategoryMappingByCollectionId()) && PropertyValidator.isValid(status.getCategoryMappingByCollectionId().get(releaseTrainId))) {
                    status.setCategory((String)status.getCategoryMappingByCollectionId().get(releaseTrainId));
                }
                if (status.getCategory().equalsIgnoreCase("Done")) {
                    ++totalDoneChildren;
                }
                ++totalChildCount;
            }
            double completionByRollupStatus = this.calculateCompletion((double)doneStatuses, (double)storyPointStatusInformationList.size());
            double completionByRollupEstimates = this.calculateCompletion(doneStoryPoints, totalStoryPoints);
            double completionByDoneChildren = this.calculateCompletion((double)totalDoneChildren, (double)totalChildCount);
            double completionByLinkedItems = this.calculateCompletion((double)itemsDone, (double)dbItems.size());
            milestoneCalculationResultDTO.setCalculationByRollupStatus(Double.valueOf(completionByRollupStatus));
            milestoneCalculationResultDTO.setCalculationByRollupEstimate(Double.valueOf(completionByRollupEstimates));
            milestoneCalculationResultDTO.setCalculationByDoneChildren(Double.valueOf(completionByDoneChildren));
            milestoneCalculationResultDTO.setCalculationByLinkedItems(Double.valueOf(completionByLinkedItems));
        }
        return milestoneCalculationResultDTO;
    }

    private String getMiscStatus() {
        List miscStatusList = this.statusRepository.findByCategory("Misc");
        if (!miscStatusList.isEmpty()) {
            return ((Status)miscStatusList.get(0)).getId();
        }
        List inProgressStatusList = this.statusRepository.findByCategory("InProgress");
        return ((Status)inProgressStatusList.get(0)).getId();
    }

    private double calculateCompletion(double numerator, double denominator) {
        double ratio = denominator > 0.0 ? numerator / denominator : 0.0;
        return this.roundToTwoDecimals(ratio * 100.0);
    }

    private double roundToTwoDecimals(double value) {
        return (double)Math.round((value + Math.ulp(value)) * 100.0) / 100.0;
    }
}

