/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.ThirdPartyAppConfig;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.service.LearnWorldsService;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class LearnWorldsServiceImpl
implements LearnWorldsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LearnWorldsServiceImpl.class);
    private final RestTemplate restTemplate;
    private final MongoTemplate mongoTemplate;
    private final Environment env;

    public LearnWorldsServiceImpl(RestTemplate restTemplate, MongoTemplate mongoTemplate, Environment env) {
        this.restTemplate = restTemplate;
        this.env = env;
        this.mongoTemplate = mongoTemplate;
    }

    public ResponseEntity<Object> loginUser() throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || !(authentication.getPrincipal() instanceof SecureUser)) {
            return new ResponseEntity((Object)"User not authenticated", HttpStatus.UNAUTHORIZED);
        }
        SecureUser secureUser = (SecureUser)authentication.getPrincipal();
        String email = null;
        String fullName = null;
        email = secureUser.getUsername();
        fullName = secureUser.getLoggedInUser().getFullName();
        if (email == null || email.isEmpty()) {
            return new ResponseEntity((Object)"Missing authenticated user email", HttpStatus.BAD_REQUEST);
        }
        String learnWorldsClientId = null;
        String learnWorldsAppToken = null;
        String learnWorldsBaseUrl = null;
        Map learnWorldsConfig = this.getLearnWorldsConfig();
        if (PropertyValidator.isValid((Object)learnWorldsConfig)) {
            learnWorldsBaseUrl = (String)learnWorldsConfig.get("baseUrl");
            learnWorldsClientId = (String)learnWorldsConfig.get("clientId");
            learnWorldsAppToken = this.env.getProperty("app.env").equals("prod") ? EncDecUtility.decrypt((String)((String)learnWorldsConfig.get("appToken"))) : (String)learnWorldsConfig.get("appToken");
        }
        if (learnWorldsClientId == null || learnWorldsAppToken == null || learnWorldsBaseUrl == null) {
            LOGGER.debug("Configurations are missing for learn worlds");
            return new ResponseEntity((Object)"LearnWorlds Admin API credentials are not configured", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        String adminApiUrl = learnWorldsBaseUrl + "/admin/api/sso";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Lw-Client", learnWorldsClientId);
        headers.set("Authorization", "Bearer " + learnWorldsAppToken);
        String redirectUrl = learnWorldsBaseUrl;
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("email", email);
        payload.put("username", fullName);
        payload.put("avatar", null);
        payload.put("redirectUrl", redirectUrl);
        HttpEntity req = new HttpEntity(payload, (MultiValueMap)headers);
        ResponseEntity res = this.restTemplate.postForEntity(adminApiUrl, (Object)req, Map.class, new Object[0]);
        if (!res.getStatusCode().is2xxSuccessful() || res.getBody() == null) {
            return new ResponseEntity((Object)("LearnWorlds SSO API error: " + res.getStatusCode().toString()), HttpStatus.BAD_GATEWAY);
        }
        Object urlObj = ((Map)res.getBody()).get("url");
        if (urlObj == null) {
            urlObj = ((Map)res.getBody()).get("login_url");
        }
        if (urlObj == null) {
            urlObj = ((Map)res.getBody()).get("redirectUrl");
        }
        if (urlObj == null) {
            return new ResponseEntity((Object)"LearnWorlds SSO API did not return a login URL", HttpStatus.BAD_GATEWAY);
        }
        HashMap<String, String> urlMap = new HashMap<String, String>();
        urlMap.put("baseUrl", learnWorldsBaseUrl);
        urlMap.put("loginUrl", (String)urlObj);
        return new ResponseEntity(urlMap, HttpStatus.OK);
    }

    private Map<String, Object> getLearnWorldsConfig() {
        BasicDBObject filter = new BasicDBObject();
        DBCollection collection = this.mongoTemplate.getCollection("thirdPartyAppConfig");
        DBCursor querys = collection.find((DBObject)filter);
        if (querys.hasNext()) {
            DBObject obj = querys.next();
            ThirdPartyAppConfig thirdPartyAppConfig = (ThirdPartyAppConfig)this.mongoTemplate.getConverter().read(ThirdPartyAppConfig.class, (Object)obj);
            if (PropertyValidator.isValid((Object)thirdPartyAppConfig)) {
                return thirdPartyAppConfig.getLearnWorldsConfig();
            }
        }
        return null;
    }

    public ResponseEntity<Object> getBaseUrl() throws Exception {
        String learnWorldsBaseUrl = null;
        Map learnWorldsConfig = this.getLearnWorldsConfig();
        if (PropertyValidator.isValid((Object)learnWorldsConfig)) {
            learnWorldsBaseUrl = (String)learnWorldsConfig.get("baseUrl");
        }
        if (learnWorldsBaseUrl == null) {
            return new ResponseEntity((Object)"LearnWorlds base URL is not configured", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)learnWorldsBaseUrl, HttpStatus.OK);
    }
}

