/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.sun.jndi.ldap.LdapCtxFactory;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.service.LDAPService;
import com.viztrend.safe.service.MultipleAttributesMapper;
import com.viztrend.safe.utils.BlindSSLSocketFactory;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Component;

@Component
public class LDAPServiceImpl
implements LDAPService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPServiceImpl.class);
    @Autowired
    private ConfigRepository configRepository;

    public LdapContextSource contextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        Config appConfigSetting = (Config)this.configRepository.findAll().get(0);
        if (appConfigSetting.getLdapConfig().isSsl()) {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.ldap.factory.socket", BlindSSLSocketFactory.class.getName());
            env.put("com.sun.jndi.ldap.connect.timeout", 4000);
            Properties props = System.getProperties();
            props.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
            contextSource.setBaseEnvironmentProperties(env);
        }
        contextSource.setUrl(appConfigSetting.getLdapConfig().getBaseUrl());
        contextSource.setBase(appConfigSetting.getLdapConfig().getBaseDn());
        if (appConfigSetting.getLdapConfig().getLdapType().equals(Config.ACTIVE_DIR)) {
            contextSource.setUserDn(appConfigSetting.getLdapConfig().getUserDn());
        } else {
            contextSource.setUserDn("uid=" + appConfigSetting.getLdapConfig().getUserDn() + "," + appConfigSetting.getLdapConfig().getAddUserDn() + "," + appConfigSetting.getLdapConfig().getBaseDn());
        }
        try {
            contextSource.setPassword(appConfigSetting.getLdapConfig().getDecryptedPasswordIfEncrypt());
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    public LdapContextSource contextSource(Config.LDAPConfig ldapConfig) {
        LdapContextSource contextSource = new LdapContextSource();
        if (ldapConfig.isSsl()) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.ldap.factory.socket", BlindSSLSocketFactory.class.getName());
            Properties props = System.getProperties();
            props.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
            contextSource.setBaseEnvironmentProperties(env);
        }
        contextSource.setUrl(ldapConfig.getBaseUrl());
        contextSource.setBase(ldapConfig.getBaseDn());
        if (ldapConfig.getLdapType().equals(Config.ACTIVE_DIR)) {
            contextSource.setUserDn(ldapConfig.getUserDn());
        } else {
            contextSource.setUserDn("uid=" + ldapConfig.getUserDn() + "," + ldapConfig.getAddUserDn() + "," + ldapConfig.getBaseDn());
        }
        try {
            contextSource.setPassword(ldapConfig.getDecryptedPasswordIfEncrypt());
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        contextSource.afterPropertiesSet();
        return contextSource;
    }

    @Bean
    public LdapTemplate ldapTemplate(ContextSource contextSource) {
        return new LdapTemplate(contextSource);
    }

    public List<String> serach() {
        return this.ldapTemplate((ContextSource)this.contextSource()).search("CN=Users", "", attrs -> (String)attrs.get("CN").get());
    }

    public LdapUser findUser(String uid) throws Exception {
        boolean isSSL;
        String additionalUserDN;
        String searchStr = null;
        Config appConfigSetting = (Config)this.configRepository.findAll().get(0);
        searchStr = "(sAMAccountName=" + uid + ")";
        if (appConfigSetting.getLdapConfig().getLdapType().equals(Config.OPEN_LDAP)) {
            searchStr = "(uid=" + uid + ")";
        }
        String userDn = appConfigSetting.getLdapConfig().getUserDn();
        String password = appConfigSetting.getLdapConfig().getDecryptedPasswordIfEncrypt();
        String baseDN = appConfigSetting.getLdapConfig().getBaseDn();
        String baseUrl = appConfigSetting.getLdapConfig().getBaseUrl();
        List users = this.searchLdap(userDn, password, baseUrl, baseDN, additionalUserDN = appConfigSetting.getLdapConfig().getAddUserDn(), searchStr, isSSL = appConfigSetting.getLdapConfig().isSsl());
        if (PropertyValidator.isValid((Collection)users)) {
            return (LdapUser)users.get(0);
        }
        return null;
    }

    public List<LdapUser> search(String searchStr) throws Exception {
        Config appConfigSetting = (Config)this.configRepository.findAll().get(0);
        searchStr = "(sAMAccountName=*" + searchStr + "*)";
        if (appConfigSetting.getLdapConfig().getLdapType().equals(Config.OPEN_LDAP)) {
            searchStr = "(uid=*" + searchStr + "*)";
        }
        String userDn = appConfigSetting.getLdapConfig().getUserDn();
        String password = appConfigSetting.getLdapConfig().getDecryptedPasswordIfEncrypt();
        String baseDN = appConfigSetting.getLdapConfig().getBaseDn();
        String baseUrl = appConfigSetting.getLdapConfig().getBaseUrl();
        String additionalUserDN = appConfigSetting.getLdapConfig().getAddUserDn();
        boolean isSSL = appConfigSetting.getLdapConfig().isSsl();
        List users = this.searchLdap(userDn, password, baseUrl, baseDN, additionalUserDN, searchStr, isSSL);
        return users;
    }

    public List<LdapUser> listGroups() {
        ContainerCriteria groupQuery = LdapQueryBuilder.query().base("CN=Users").where("objectClass").is("group");
        List groups = this.ldapTemplate((ContextSource)this.contextSource()).search((LdapQuery)groupQuery, (AttributesMapper)new MultipleAttributesMapper("group"));
        return groups;
    }

    public List<LdapUser> listUsers(String groupDn) {
        ContainerCriteria userQuery = LdapQueryBuilder.query().base("CN=Users").where("objectClass").is("user").and("memberof").is(groupDn);
        List users = this.ldapTemplate((ContextSource)this.contextSource()).search((LdapQuery)userQuery, (AttributesMapper)new MultipleAttributesMapper("user"));
        return users;
    }

    public boolean authenticateAndAuthorize(String userName, String pass) {
        if (!PropertyValidator.isValid((Object)pass)) {
            return false;
        }
        Config appConfigSetting = (Config)this.configRepository.findAll().get(0);
        try {
            LdapUser user;
            List baseDNList;
            String userDn = userName;
            String configUserDn = appConfigSetting.getLdapConfig().getUserDn();
            if (configUserDn.split("@").length > 1) {
                userDn = configUserDn.split("@")[1];
                userDn = userName + "@" + userDn;
            }
            if (PropertyValidator.isValid((Collection)(baseDNList = this.authenticate(userDn, pass, appConfigSetting.getLdapConfig()))) && (user = this.findUser(userName)) != null) {
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return false;
        }
        return false;
    }

    public List<String> authenticate(String userName, String pass, Config.LDAPConfig ldapConfig) throws Exception {
        List baseDnList = null;
        AndFilter filter = new AndFilter();
        if (ldapConfig.getLdapType().equals(Config.ACTIVE_DIR)) {
            filter.and((Filter)new EqualsFilter("sAMAccountName", userName.split("@")[0]));
        } else {
            filter.and((Filter)new EqualsFilter("uid", userName));
        }
        if (userName == null && pass == null) {
            userName = ldapConfig.getUserDn();
            pass = ldapConfig.getDecryptedPasswordIfEncrypt();
        }
        String baseUrl = ldapConfig.getBaseUrl();
        baseDnList = this.verifyLdapAuthentication(userName, pass, baseUrl, ldapConfig.isSsl());
        return baseDnList;
    }

    private DirContext getLdapContext(String userDn, String pass, String baseUrl, boolean isSSL) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String principalName = userDn;
        env.put("java.naming.security.principal", principalName);
        env.put("java.naming.security.credentials", pass);
        if (isSSL) {
            Properties props = System.getProperties();
            props.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
            env.put("java.naming.ldap.factory.socket", BlindSSLSocketFactory.class.getName());
            LOGGER.debug("com.sun.jndi.ldap.object.disableEndpointIdentification  :" + System.getProperty("com.sun.jndi.ldap.object.disableEndpointIdentification"));
        }
        DirContext context = LdapCtxFactory.getLdapCtxInstance(baseUrl + '/', env);
        return context;
    }

    private List<String> verifyLdapAuthentication(String userDn, String pass, String baseUrl, boolean isSSL) throws Exception {
        DirContext context = this.getLdapContext(userDn, pass, baseUrl, isSSL);
        ArrayList<String> contextList = new ArrayList<String>();
        NamingEnumeration<?> nameEnum = context.getAttributes("").get("namingcontexts").getAll();
        while (nameEnum.hasMoreElements()) {
            contextList.add((String)nameEnum.next());
        }
        if (contextList.size() > 0) {
            return contextList;
        }
        return null;
    }

    public List<LdapUser> searchLdap(String userDn, String pass, String baseUrl, String baseDN, String addionalDN, String searchStr, boolean isSSL) throws Exception {
        DirContext context = this.getLdapContext(userDn, pass, baseUrl, isSSL);
        SearchControls searchCtrls = new SearchControls();
        searchCtrls.setSearchScope(2);
        String filter = searchStr;
        if (PropertyValidator.isValid((Object)addionalDN)) {
            baseDN = addionalDN + "," + baseDN;
        }
        NamingEnumeration<SearchResult> values = context.search(baseDN, filter, searchCtrls);
        ArrayList<LdapUser> ldapUsers = new ArrayList<LdapUser>();
        while (values.hasMoreElements()) {
            LdapUser ldapUser = new LdapUser();
            SearchResult result = values.next();
            Attributes attribs = result.getAttributes();
            MultipleAttributesMapper mapper = new MultipleAttributesMapper("user");
            ldapUser = mapper.mapFromAttributes(attribs);
            ldapUsers.add(ldapUser);
        }
        return ldapUsers;
    }

    public static void main(String[] args) throws Exception {
        Properties props1 = System.getProperties();
        props1.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
        Hashtable<String, String> props = new Hashtable<String, String>();
        String principalName = "lu1@loxvo.com";
        props.put("java.naming.security.principal", principalName);
        props.put("java.naming.security.credentials", "Loxvo12#");
        props.put("java.naming.ldap.factory.socket", BlindSSLSocketFactory.class.getName());
        try {
            DirContext context = LdapCtxFactory.getLdapCtxInstance("LDAPS://172.31.38.211:636/", props);
            String baseDN = String.valueOf(context.getAttributes("").get("namingcontexts").get(0));
            NamingEnumeration<?> nameEnum = context.getAttributes("").get("namingcontexts").getAll();
            while (nameEnum.hasMoreElements()) {
                System.out.println(nameEnum.next());
            }
            SearchControls searchCtrls = new SearchControls();
            searchCtrls.setSearchScope(1);
            String filter = "(sAMAccountName=*kendis*)";
            NamingEnumeration<SearchResult> values = context.search("cn=Users," + baseDN, filter, searchCtrls);
            while (values.hasMoreElements()) {
                SearchResult result = values.next();
                Attributes attribs = result.getAttributes();
                if (null == attribs) continue;
                NamingEnumeration<? extends Attribute> ae = attribs.getAll();
                while (ae.hasMoreElements()) {
                    Attribute atr = ae.next();
                    String attributeID = atr.getID();
                    NamingEnumeration<?> vals = atr.getAll();
                    while (vals.hasMoreElements()) {
                        System.out.println(attributeID + ": " + vals.nextElement());
                    }
                }
            }
            context.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static SearchControls getSimpleSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setTimeLimit(30000);
        return searchControls;
    }

    public static void main2(String[] args) throws Exception {
        Properties props = System.getProperties();
        props.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
        LdapContextSource contextSource = new LdapContextSource();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.ldap.factory.socket", BlindSSLSocketFactory.class.getName());
        contextSource.setBaseEnvironmentProperties(env);
        contextSource.setUrl("ldaps://172.31.38.211:636");
        contextSource.setBase("DC=LOXVO,DC=COM");
        contextSource.setUserDn("Administrator@LOXVO.COM");
        contextSource.setPassword("xxxxxx");
        contextSource.afterPropertiesSet();
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        ldapTemplate.afterPropertiesSet();
        AndFilter filter = new AndFilter();
        filter.and((Filter)new EqualsFilter("sAMAccountName", "Administrator"));
        Boolean authenticate = ldapTemplate.authenticate("DC=COM", filter.encode(), "Loxvo12#");
    }
}

