/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.Invitation;
import com.viztrend.safe.service.InvitationService;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.Date;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class InvitationServiceImpl
implements InvitationService {
    private final MongoTemplate mongoTemplate;

    @Autowired
    public InvitationServiceImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public Invitation findInvitationById(String token) throws Exception {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(token)));
        DBCursor dbCursorDomain = this.mongoTemplate.getCollection("invitation").find(query.getQueryObject());
        Invitation invitation = null;
        if (dbCursorDomain.hasNext()) {
            invitation = new Invitation();
            DBObject invitationObject = dbCursorDomain.next();
            ObjectId id = (ObjectId)invitationObject.get("_id");
            String inviteJson = (String)invitationObject.get("inviteJson");
            String createdBy = (String)invitationObject.get("createdBy");
            Date createdOn = (Date)invitationObject.get("createdOn");
            Boolean archive = (Boolean)invitationObject.get("archive");
            String tenant = (String)invitationObject.get("tenant");
            Integer rowStatus = (Integer)invitationObject.get("rowStatus");
            if (PropertyValidator.isValid((Object)id)) {
                invitation.setId(id.toString());
            }
            if (PropertyValidator.isValid((Object)inviteJson)) {
                invitation.setInviteJson(inviteJson);
            }
            if (PropertyValidator.isValid((Object)createdBy)) {
                invitation.setCreatedBy(createdBy);
            }
            if (PropertyValidator.isValid((Object)createdOn)) {
                invitation.setCreatedOn(createdOn);
            }
            if (PropertyValidator.isValid((Object)archive)) {
                invitation.setArchive(archive.booleanValue());
            }
            if (PropertyValidator.isValid((Object)tenant)) {
                invitation.setTenant(tenant);
            }
            if (PropertyValidator.isValid((Object)rowStatus)) {
                invitation.setRowStatus(rowStatus.intValue());
            }
        }
        return invitation;
    }
}

