/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.gson.Gson;
import com.mongodb.BasicDBObject;
import com.mongodb.WriteResult;
import com.viztrend.safe.enums.EnumShareBoard;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.CanvasBoard;
import com.viztrend.safe.persistence.entity.CanvasBoardPreferences;
import com.viztrend.safe.persistence.entity.CanvasFolder;
import com.viztrend.safe.persistence.entity.CanvasNote;
import com.viztrend.safe.persistence.entity.CollaborationType;
import com.viztrend.safe.persistence.entity.Collaborator;
import com.viztrend.safe.persistence.entity.Notification;
import com.viztrend.safe.persistence.entity.PublicLinks;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.CanvasBoardPreferencesRepository;
import com.viztrend.safe.persistence.repository.CanvasBoardRepository;
import com.viztrend.safe.persistence.repository.CanvasFolderRepository;
import com.viztrend.safe.persistence.repository.CanvasNoteRepository;
import com.viztrend.safe.persistence.repository.CollaborationTypeRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.GraphRepositoryImpl;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.ObjectiveCustomViewRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.service.CanvasBoardLegacyMigrationService;
import com.viztrend.safe.service.CollaborationTypeServiceImpl;
import com.viztrend.safe.service.GraphAuditLogService;
import com.viztrend.safe.service.GraphService;
import com.viztrend.safe.service.GraphServiceImpl;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.S3Utils;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.Attachment;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class GraphServiceImpl
implements GraphService {
    @Autowired
    GraphRepositoryImpl graphRepository;
    @Autowired
    CanvasBoardRepository canvasBoardRepository;
    @Autowired
    CanvasBoardPreferencesRepository canvasBoardPreferencesRepository;
    @Autowired
    CanvasFolderRepository canvasFolderRepository;
    @Autowired
    CanvasNoteRepository canvasNoteRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    ServerCacheRepository serverCacheRepository;
    @Autowired
    private GraphAuditLogService graphAuditLogService;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private CompanyRepository companyRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphServiceImpl.class);
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private ObjectiveCustomViewRepository objectiveCustomViewRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private CollaborationTypeRepository collaborationTypeRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private CollaborationTypeServiceImpl collaborationTypeService;
    @Autowired
    private ReleaseTrainServiceImpl releaseTrainServiceImpl;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private CanvasBoardLegacyMigrationService legacyMigrationService;

    private String loadTemplateFromResource(String templateFileName) throws Exception {
        ClassPathResource resource = new ClassPathResource("templates/collab-board-templates/" + templateFileName);
        InputStream inputStream = resource.getInputStream();
        byte[] bytes = new byte[inputStream.available()];
        inputStream.read(bytes);
        inputStream.close();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public List<CanvasBoard> findTemplatesByCreatedFromBoard(String createdFromBoard) throws Exception {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template").and("createdFromBoard").is((Object)createdFromBoard));
            return this.mongoTemplate.find(query, CanvasBoard.class);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching templates by createdFromBoard: {}", (Object)createdFromBoard, (Object)StringUtils.getTraceString((Throwable)e));
            return new ArrayList<CanvasBoard>();
        }
    }

    public List<Map> findAllBoards() {
        return this.graphRepository.findAllBoards();
    }

    public CanvasBoard findBoardById(String id, String tenant) {
        CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)board)) {
            return board;
        }
        return null;
    }

    public CanvasFolder findFolderById(String id) {
        return (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)id));
    }

    public Boolean findStarredBoardById(String bid, String uid) {
        CanvasBoardPreferences board = this.canvasBoardPreferencesRepository.findByUserIdAndBoardId(uid, bid);
        Boolean starred = false;
        if (PropertyValidator.isValid((Object)board)) {
            if (board.getStarred().equals(true)) {
                starred = true;
            } else if (board.getStarred().equals(false)) {
                starred = false;
            }
        }
        return starred;
    }

    public List<CanvasBoard> findBoardByUserId(String userId) {
        User user = this.userRepository.findById(userId);
        Collaborator collaborators = new Collaborator();
        collaborators.setUser(user);
        ArrayList<User> collaboratorsList = new ArrayList<User>();
        collaboratorsList.add(user);
        List board = this.canvasBoardRepository.findByCollaboratorsUserIn(collaboratorsList);
        return board;
    }

    public List<User> getCompanyUsers() {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        if (PropertyValidator.isValid((Object)cid)) {
            List users = this.userRepository.findByUserCompanies_Company_IdAndUserCompanies_isArchive(cid, Boolean.valueOf(false));
            return users;
        }
        return null;
    }

    public List<CanvasBoard> findSharedBoardByUserId(String userId) {
        try {
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            User user = this.userRepository.findById(userId);
            ArrayList<User> collaboratorsList = new ArrayList<User>();
            collaboratorsList.add(user);
            List boardList = this.canvasBoardRepository.findByCollaboratorsUserIn(collaboratorsList);
            ArrayList<CanvasBoard> sharedBoardList = new ArrayList<CanvasBoard>();
            ArrayList<CanvasBoard> sharedBoards = new ArrayList<CanvasBoard>();
            if (PropertyValidator.isValid((Collection)boardList)) {
                for (CanvasBoard board : boardList) {
                    if (board.getCreatedBy().equals(loggedInUser.getUserName())) continue;
                    sharedBoardList.add(board);
                }
            }
            if (PropertyValidator.isValid(sharedBoardList)) {
                for (CanvasBoard board : sharedBoardList) {
                    if (PropertyValidator.isValid((Object)board.getType())) continue;
                    sharedBoards.add(board);
                }
            }
            return sharedBoards;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public List<CanvasFolder> findFolderByUserId(String userId) {
        User user = this.userRepository.findById(userId);
        Collaborator collaborators = new Collaborator();
        collaborators.setUser(user);
        ArrayList<User> collaboratorsList = new ArrayList<User>();
        collaboratorsList.add(user);
        CanvasFolder savedFolder = null;
        List folders = this.canvasFolderRepository.findByCollaboratorsUserIn(collaboratorsList);
        ArrayList foldersToBeSaved = new ArrayList();
        if (!PropertyValidator.isValid((Collection)folders)) {
            CanvasFolder newCanvasFolder = new CanvasFolder();
            newCanvasFolder.setTitle("My Documents");
            newCanvasFolder.setTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList1 = new ArrayList<Collaborator>();
            collaboratorsList1.add(collaborator);
            newCanvasFolder.setCollaborators(collaboratorsList1);
            savedFolder = (CanvasFolder)this.canvasFolderRepository.save((Object)newCanvasFolder);
            folders.add(savedFolder);
            return folders;
        }
        return folders;
    }

    public ArrayList<CanvasBoard> findBoardPreferencesByUserId(String userId) {
        List boardPreferencesList = this.canvasBoardPreferencesRepository.findByUserId(userId);
        ArrayList boards = new ArrayList();
        ArrayList<CanvasBoard> updatedBoards = new ArrayList<CanvasBoard>();
        boards = (ArrayList)this.findBoardByUserId(userId);
        HashMap<String, CanvasBoard> map = new HashMap<String, CanvasBoard>();
        if (PropertyValidator.isValid((Collection)boards)) {
            for (CanvasBoard board : boards) {
                if (board.getRowStatus() == -1) continue;
                map.put(board.getId(), board);
            }
        }
        if (PropertyValidator.isValid((Collection)boardPreferencesList)) {
            for (CanvasBoardPreferences boardPref : boardPreferencesList) {
                if (!PropertyValidator.isValid(map.get(boardPref.getBoardId()))) continue;
                CanvasBoard updatedBoard = new CanvasBoard();
                updatedBoard = (CanvasBoard)map.get(boardPref.getBoardId());
                if (!boardPref.getStarred().equals(true)) continue;
                updatedBoard.setFavorite(boardPref.getStarred());
                updatedBoards.add(updatedBoard);
            }
        }
        return updatedBoards;
    }

    public List<Map> findNodesByBoradId(String boardId, String tenant) throws Exception {
        return this.graphRepository.findNodesByBoradId(boardId, tenant);
    }

    public List<Map> findLinksByBoradId(String boardId, String tenant) {
        return this.graphRepository.findLinksByBoardId(boardId, tenant);
    }

    public Long incrementBoardVersion(String boardId, String tenant) {
        try {
            WriteResult result = this.customRepository.incrementValue(boardId, "version", (Number)1, CanvasBoard.class);
            CanvasBoard board = this.canvasBoardRepository.findVersionById(boardId);
            if (PropertyValidator.isValid((Object)board)) {
                return board.getVersion();
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public ResponseEntity<Object> saveBoard(Map board) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List<CanvasBoard> boardsList = new ArrayList<CanvasBoard>();
            ArrayList allboards = new ArrayList();
            CanvasBoard canvasBoard = new CanvasBoard();
            canvasBoard.setTitle(board.get("title").toString());
            canvasBoard.setDescription(board.get("description").toString());
            canvasBoard.setContext((Map)board.get("context"));
            canvasBoard.setTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            if (PropertyValidator.isValid(board.get("folderId"))) {
                canvasBoard.setFolderId((String)board.get("folderId"));
            }
            if (PropertyValidator.isValid(board.get("id"))) {
                canvasBoard.setId((String)board.get("id"));
            }
            canvasBoard.setFavorite(Boolean.valueOf(false));
            canvasBoard.setLocked(Boolean.valueOf(false));
            canvasBoard.setArchived(Boolean.valueOf(false));
            canvasBoard.setIsSystem(Boolean.valueOf(false));
            canvasBoard.setType("");
            if (PropertyValidator.isValid(board.get("backgroundColor"))) {
                canvasBoard.setBackgroundColor(board.get("backgroundColor").toString());
            }
            if (PropertyValidator.isValid(board.get("backgroundPattern"))) {
                canvasBoard.setBackgroundPattern(board.get("backgroundPattern").toString());
            }
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
            collaboratorsList.add(collaborator);
            canvasBoard.setCollaborators(collaboratorsList);
            this.setupBoardAssociations(canvasBoard, board);
            CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
            CanvasNote note = new CanvasNote();
            note.setBoardId(savedBoard.getId());
            note.setDescription("");
            CanvasNote savednote = (CanvasNote)this.canvasNoteRepository.save((Object)note);
            if (PropertyValidator.isValid(board.get("folderId"))) {
                CanvasFolder parentFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)((String)board.get("folderId"))));
                if (!PropertyValidator.isValid((Collection)parentFolder.getCanvasBoard())) {
                    boardsList.add(savedBoard);
                } else {
                    boardsList = parentFolder.getCanvasBoard();
                    boardsList.add(savedBoard);
                }
                allboards.addAll(boardsList);
                parentFolder.setCanvasBoard(allboards);
                this.canvasFolderRepository.save((Object)parentFolder);
                responseJson.put("parentFolder", parentFolder);
            }
            responseJson.put("board", savedBoard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public ResponseEntity<Object> saveBoardUsingTemplate(Map board) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            CanvasFolder parentFolder;
            HashMap<String, Object> params;
            List<CanvasBoard> boardsList = new ArrayList<CanvasBoard>();
            ArrayList allboards = new ArrayList();
            CanvasBoard template = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)((String)board.get("templateId"))));
            List nodes = this.graphRepository.findNodesByBoradId(template.getId(), null);
            List links = this.graphRepository.findLinksByBoardId(template.getId(), null);
            CanvasBoard canvasBoard = new CanvasBoard();
            canvasBoard.setTitle(board.get("title").toString());
            canvasBoard.setDescription(board.get("description").toString());
            canvasBoard.setContext((Map)board.get("context"));
            canvasBoard.setTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            canvasBoard.setFolderId((String)board.get("folderId"));
            canvasBoard.setFavorite(Boolean.valueOf(false));
            canvasBoard.setLocked(Boolean.valueOf(false));
            canvasBoard.setArchived(Boolean.valueOf(false));
            canvasBoard.setIsSystem(Boolean.valueOf(false));
            canvasBoard.setType("");
            canvasBoard.setBackgroundColor("#ffffff");
            canvasBoard.setBackgroundPattern("dotted");
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
            collaboratorsList.add(collaborator);
            canvasBoard.setCollaborators(collaboratorsList);
            CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
            if (PropertyValidator.isValid((Collection)nodes)) {
                for (int i = 0; i < nodes.size(); ++i) {
                    ((Map)nodes.get(i)).put("boardId", savedBoard.getId());
                }
                params = new HashMap<String, Object>();
                params.put("boardId", template.getId());
                params.put("items", nodes);
                this.saveNode(params);
            }
            if (PropertyValidator.isValid((Collection)links)) {
                for (int i = 0; i < links.size(); ++i) {
                    ((Map)links.get(i)).put("boardId", savedBoard.getId());
                }
                params = new HashMap();
                params.put("boardId", template.getId());
                params.put("items", links);
                this.saveLink(params);
            }
            if (!PropertyValidator.isValid((Collection)(parentFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)((String)board.get("folderId"))))).getCanvasBoard())) {
                boardsList.add(savedBoard);
            } else {
                boardsList = parentFolder.getCanvasBoard();
                boardsList.add(savedBoard);
            }
            allboards.addAll(boardsList);
            parentFolder.setCanvasBoard(allboards);
            this.canvasFolderRepository.save((Object)parentFolder);
            responseJson.put("parentFolder", parentFolder);
            responseJson.put("board", savedBoard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public ResponseEntity<Object> createBoardUsingCollaborationLink(Map board) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            ArrayList boardsList = new ArrayList();
            ArrayList allboards = new ArrayList();
            CanvasBoard canvasBoard = new CanvasBoard();
            if (PropertyValidator.isValid(board.get("title"))) {
                canvasBoard.setTitle(board.get("title").toString());
            }
            if (PropertyValidator.isValid(board.get("description"))) {
                canvasBoard.setDescription(board.get("description").toString());
            }
            if (PropertyValidator.isValid(board.get("context"))) {
                canvasBoard.setContext((Map)board.get("context"));
            }
            canvasBoard.setTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            canvasBoard.setFavorite(Boolean.valueOf(false));
            canvasBoard.setLocked(Boolean.valueOf(false));
            canvasBoard.setArchived(Boolean.valueOf(false));
            canvasBoard.setIsSystem(Boolean.valueOf(false));
            canvasBoard.setType("");
            if (PropertyValidator.isValid(board.get("backgroundColor"))) {
                canvasBoard.setBackgroundColor(board.get("backgroundColor").toString());
            }
            if (PropertyValidator.isValid(board.get("backgroundPattern"))) {
                canvasBoard.setBackgroundPattern(board.get("backgroundPattern").toString());
            }
            this.setupBoardAssociations(canvasBoard, board);
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
            collaboratorsList.add(collaborator);
            canvasBoard.setCollaborators(collaboratorsList);
            CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
            Gson gson = new Gson();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            String templateId = (String)board.get("templateId");
            if (!PropertyValidator.isValid((Object)templateId)) {
                String nodes = this.loadTemplateFromResource("planning-retro-template.json");
                if (!PropertyValidator.isValid((Object)nodes)) {
                    LOGGER.error("Failed to load planning retro template from resource file");
                    responseJson.put("error", "Failed to load default template");
                    return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                List requestMap = (List)gson.fromJson(nodes, T.getType());
                if (PropertyValidator.isValid((Collection)requestMap)) {
                    for (int i = 0; i < requestMap.size(); ++i) {
                        Map node = (Map)requestMap.get(i);
                        node.put("boardId", savedBoard.getId());
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("boardId", savedBoard.getId());
                    params.put("items", requestMap);
                    this.saveNode(params);
                }
                responseJson.put("nodes", nodes);
            } else {
                CanvasBoard template = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)((String)board.get("templateId"))));
                List nodes = this.graphRepository.findNodesByBoradId(template.getId(), null);
                List links = this.graphRepository.findLinksByBoardId(template.getId(), null);
                if (PropertyValidator.isValid((Collection)nodes)) {
                    for (int i = 0; i < nodes.size(); ++i) {
                        Map node = (Map)nodes.get(i);
                        node.put("boardId", savedBoard.getId());
                        node.remove("tenant");
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("boardId", savedBoard.getId());
                    params.put("items", nodes);
                    this.saveNode(params);
                }
                if (PropertyValidator.isValid((Collection)links)) {
                    for (int i = 0; i < links.size(); ++i) {
                        ((Map)links.get(i)).put("boardId", savedBoard.getId());
                        ((Map)links.get(i)).remove("tenant");
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("boardId", savedBoard.getId());
                    params.put("items", links);
                    this.saveLink(params);
                }
                responseJson.put("nodes", nodes);
            }
            responseJson.put("board", savedBoard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public List<CanvasBoard> findCollabBoardsById(String id, Map payload) {
        List<Object> boards = new ArrayList<CanvasBoard>();
        try {
            List migratedBoardIds;
            List filters;
            long totalCount = 0L;
            String subContext = (String)payload.get("subContext");
            Map context = (Map)payload.get("context");
            Integer page = (Integer)payload.get("page");
            Integer pageSize = (Integer)payload.get("pageSize");
            String defaultTypeOrigin = (String)payload.get("defaultTypeOrigin");
            String collabType = (String)payload.get("collabType");
            if (page == null || page < 0) {
                page = 0;
            }
            if (pageSize == null || pageSize < 1) {
                pageSize = 10;
            }
            HashMap<String, List> filterMap = new HashMap<String, List>();
            String searchQuery = null;
            if (PropertyValidator.isValid(payload.get("idContext")) && "sessionBoard".equals(payload.get("idContext").toString())) {
                Session session = this.sessionRepository.findByActiveSessionBoard(id);
                id = session.getId();
                if (context != null && context.containsKey("session")) {
                    context.put("session", id);
                }
            }
            if (PropertyValidator.isValid((Collection)(filters = (List)payload.get("filter")))) {
                for (Map filter : filters) {
                    for (Map.Entry entry : filter.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if ("search".equals(key) && value instanceof String) {
                            searchQuery = (String)value;
                            continue;
                        }
                        if (!(value instanceof List)) continue;
                        filterMap.put(key, (List)value);
                    }
                }
            }
            int skip = page * pageSize;
            Map.Entry entry = context.entrySet().iterator().next();
            String contextKey = (String)entry.getKey();
            String contextValue = String.valueOf(entry.getValue());
            String flag = (String)payload.get("flag");
            if ("session".equals(flag)) {
                if (this.legacyMigrationService.hasLegacySessionBoards(contextValue)) {
                    LOGGER.info("Found legacy session boards for sessionId: {}. Starting migration...", (Object)contextValue);
                    migratedBoardIds = this.legacyMigrationService.migrateLegacySessionBoards(contextValue);
                    LOGGER.info("Successfully migrated {} legacy session boards", (Object)migratedBoardIds.size());
                }
            } else if ("solution".equals(flag) && this.legacyMigrationService.hasLegacySolutionBoards(contextValue)) {
                LOGGER.info("Found legacy solution boards for solutionBoardId: {}. Starting migration...", (Object)contextValue);
                migratedBoardIds = this.legacyMigrationService.migrateLegacySolutionBoards(contextValue);
                LOGGER.info("Successfully migrated {} legacy solution boards", (Object)migratedBoardIds.size());
            }
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            if ("session".equals(flag)) {
                if (PropertyValidator.isValid((Object)defaultTypeOrigin)) {
                    this.addDefaultSessionBoardCriteria(id, collabType, contextKey, criteriaList, defaultTypeOrigin, contextValue);
                } else {
                    criteriaList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(collabType)), Criteria.where((String)"sessions").in(new Object[]{id})}));
                }
            } else if ("solution".equals(flag)) {
                if (PropertyValidator.isValid((Object)defaultTypeOrigin)) {
                    this.addDefaultSolutionBoardCriteria(id, collabType, contextKey, criteriaList, defaultTypeOrigin);
                } else {
                    criteriaList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(collabType)), Criteria.where((String)"solutionBoards").in(new Object[]{id})}));
                }
            } else if ("workspace".equals(flag)) {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (!PropertyValidator.isValid((Object)workSpace)) {
                    LOGGER.error("Workspace is null for workspace key: {}", (Object)id);
                    return new ArrayList<CanvasBoard>();
                }
                if (PropertyValidator.isValid((Object)defaultTypeOrigin)) {
                    this.addDefaultCollectionsCriteria(id, collabType, contextKey, criteriaList, workSpace, contextValue, defaultTypeOrigin);
                } else {
                    criteriaList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(collabType)), Criteria.where((String)"workSpaces").in(new Object[]{workSpace})}));
                }
            }
            if (PropertyValidator.isValid((Object)searchQuery) && !searchQuery.trim().isEmpty()) {
                Criteria searchCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(searchQuery.trim(), "i"), Criteria.where((String)"description").regex(searchQuery.trim(), "i")});
                criteriaList.add(searchCriteria);
            }
            this.addFilterCriteriaToList(filterMap, criteriaList);
            String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
            criteriaList.add(Criteria.where((String)"tenant").is((Object)tenant));
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            Map sortParams = (Map)payload.get("sort");
            String sortField = "createdOn";
            boolean ascending = false;
            if (PropertyValidator.isValid((Object)sortParams)) {
                String field = (String)sortParams.get("field");
                Boolean isAscending = (Boolean)sortParams.get("ascending");
                if (PropertyValidator.isValid((Object)field)) {
                    sortField = field;
                }
                if (isAscending != null) {
                    ascending = isAscending;
                }
            }
            totalCount = this.mongoTemplate.count(query, CanvasBoard.class);
            boards = this.findContextBasedCollabBoards(page.intValue(), pageSize.intValue(), query, sortField, ascending);
            if (boards != null && !boards.isEmpty()) {
                this.filterArchivedCollectionsFromBoards(boards);
            }
            if (boards != null) {
                List teamsMeta = this.fetchTeamsForBoards(boards);
                HashMap<String, Object> paginationInfo = new HashMap<String, Object>();
                paginationInfo.put("totalItems", totalCount);
                paginationInfo.put("currentPage", page);
                paginationInfo.put("pageSize", pageSize);
                paginationInfo.put("totalPages", (int)Math.ceil((double)totalCount / (double)pageSize.intValue()));
                paginationInfo.put("teamsMeta", teamsMeta);
                payload.put("paginationInfo", paginationInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching boards related to particular context for id: {}, error: {}", new Object[]{id, e.getMessage(), e});
        }
        return boards;
    }

    private void addDefaultSessionBoardCriteria(String id, String collabType, String contextKey, List<Criteria> criteriaList, String defaultTypeOrigin, String contextValue) throws Exception {
        if ("sessionTeam".equals(defaultTypeOrigin)) {
            Query teamTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"sessionTeam"), Criteria.where((String)("teams." + id)).is((Object)collabType)}));
            List teamTypes = this.mongoTemplate.find(teamTypeQuery, CollaborationType.class);
            List teamTypeIds = teamTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteriaList.add(new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)("piTeamArea." + id)).is((Object)collabType), Criteria.where((String)"collaborationType").in(teamTypeIds)}), Criteria.where((String)"type").ne((Object)"template")}));
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
        } else if ("general".equals(collabType)) {
            HashMap<String, String> contextPayload = new HashMap<String, String>();
            contextPayload.put("context", contextKey);
            List types = this.collaborationTypeService.getTypesRelatedToContext(id, contextPayload);
            List linkedTypeIds = types.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Query generalTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"session"), Criteria.where((String)"title").is((Object)"general")}));
            List generalTypes = this.mongoTemplate.find(generalTypeQuery, CollaborationType.class);
            List generalTypeIds = generalTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Query excludedTypeQuery = new Query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"sessionInspect"), Criteria.where((String)"defaultOrigin").is((Object)"sessionTeam")}));
            Query nonGeneralQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").exists(true), Criteria.where((String)"sessions").in(new Object[]{id})}));
            List excludedTypes = this.mongoTemplate.find(excludedTypeQuery, CollaborationType.class);
            List nonGeneralTypes = this.mongoTemplate.find(nonGeneralQuery, CollaborationType.class);
            List excludedTypeIds = excludedTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            linkedTypeIds.addAll(excludedTypeIds);
            criteriaList.add(new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"piInspectAndAdapt").exists(false), Criteria.where((String)"piInspectAndAdapt").size(0)}), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"piTeamArea").exists(false), Criteria.where((String)"piTeamArea").size(0), Criteria.where((String)"piTeamArea").is(Collections.emptyMap())}), Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)"sessions").in(new Object[]{id})}), new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"piInspectAndAdapt").exists(true), Criteria.where((String)"piInspectAndAdapt").not().size(0), Criteria.where((String)"piInspectAndAdapt").ne((Object)id)}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"piTeamArea").exists(true), Criteria.where((String)"piTeamArea").not().size(0), Criteria.where((String)"piTeamArea").nin(new Object[]{Collections.emptyMap()}), new Criteria().norOperator(new Criteria[]{Criteria.where((String)("piTeamArea." + id)).exists(true)})})}), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)"session").in(new Object[]{id})})}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").nin(linkedTypeIds), Criteria.where((String)"collaborationType").exists(true), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"piInspectAndAdapt").exists(false), Criteria.where((String)"piInspectAndAdapt").size(0)}), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"piTeamArea").exists(false), Criteria.where((String)"piTeamArea").size(0), Criteria.where((String)"piTeamArea").is(Collections.emptyMap())}), new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)("context." + contextKey)).is((Object)contextValue), Criteria.where((String)"sessions").exists(false)}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").nin(generalTypeIds), Criteria.where((String)"sessions").in(new Object[]{id})})})}), Criteria.where((String)"collaborationType").in((Collection)nonGeneralTypes.stream().map(BaseEntity::getId).collect(Collectors.toList()))}));
        } else if ("inspect".equals(collabType)) {
            Query collabTypeQuery = new Query((CriteriaDefinition)Criteria.where((String)"defaultOrigin").is((Object)"sessionInspect"));
            List inspectTypes = this.mongoTemplate.find(collabTypeQuery, CollaborationType.class);
            List inspectTypeIds = inspectTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteriaList.add(new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(inspectTypeIds), Criteria.where((String)("context." + contextKey)).is((Object)contextValue)}), Criteria.where((String)"piInspectAndAdapt").in(new Object[]{id})}));
        }
    }

    private void addDefaultSolutionBoardCriteria(String id, String collabType, String contextKey, List<Criteria> criteriaList, String defaultTypeOrigin) throws Exception {
        if ("solutionPiBoard".equals(defaultTypeOrigin)) {
            Query piBoardTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"solutionPiBoard"), Criteria.where((String)"sessions").in(new Object[]{collabType})}));
            List piBoardTypes = this.mongoTemplate.find(piBoardTypeQuery, CollaborationType.class);
            List piBoardTypeIds = piBoardTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteriaList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sessions").in(new Object[]{collabType}), Criteria.where((String)"collaborationType").in(piBoardTypeIds)}));
        } else if ("general".equals(collabType) && "solution".equals(defaultTypeOrigin)) {
            Query generalTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"solution"), Criteria.where((String)"title").is((Object)"general")}));
            List generalTypes = this.mongoTemplate.find(generalTypeQuery, CollaborationType.class);
            List generalTypeIds = generalTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Query nonGeneralQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").exists(true), Criteria.where((String)"defaultOrigin").is((Object)"solutionPiBoard"), Criteria.where((String)"solutionBoards").in(new Object[]{id})}));
            List nonGeneralTypes = this.mongoTemplate.find(nonGeneralQuery, CollaborationType.class);
            HashMap<String, String> contextPayload = new HashMap<String, String>();
            contextPayload.put("context", contextKey);
            List types = this.collaborationTypeService.getTypesRelatedToContext(id, contextPayload);
            List linkedTypeIds = types.stream().filter(type -> type.getDefaultOrigin() == null).map(BaseEntity::getId).collect(Collectors.toList());
            ArrayList excludedTypeIds = new ArrayList();
            excludedTypeIds.addAll(nonGeneralTypes.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            excludedTypeIds.addAll(linkedTypeIds);
            criteriaList.add(new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)"solutionBoards").in(new Object[]{id})}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").nin(excludedTypeIds), Criteria.where((String)"solutionBoards").in(new Object[]{id})})}));
        }
    }

    private void addDefaultCollectionsCriteria(String id, String collabType, String contextKey, List<Criteria> criteriaList, WorkSpace workSpace, String contextValue, String defaultTypeOrigin) throws Exception {
        if ("general".equals(collabType)) {
            Query generalTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"workspace"), Criteria.where((String)"title").is((Object)"general")}));
            List generalTypes = this.mongoTemplate.find(generalTypeQuery, CollaborationType.class);
            List generalTypeIds = generalTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Query excludedTypeQuery = new Query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"workspaceSolutionBoard"), Criteria.where((String)"defaultOrigin").is((Object)"workspacePiBoard")}));
            List excludedTypes = this.mongoTemplate.find(excludedTypeQuery, CollaborationType.class);
            List excludedTypeIds = excludedTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            HashMap<String, String> contextPayload = new HashMap<String, String>();
            contextPayload.put("context", contextKey);
            List types = this.collaborationTypeService.getTypesRelatedToContext(id, contextPayload);
            List linkedTypeIds = types.stream().map(BaseEntity::getId).collect(Collectors.toList());
            excludedTypeIds.addAll(linkedTypeIds);
            criteriaList.add(new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)"workSpaces").in(new Object[]{workSpace})}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").exists(false), Criteria.where((String)"workSpaces").in(new Object[]{workSpace})}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"workSpaces").exists(false)}), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sessions").exists(true), Criteria.where((String)"solutionBoards").exists(true), Criteria.where((String)"piInspectAndAdapt").exists(true), Criteria.where((String)"piTeamArea").exists(true)}), Criteria.where((String)("context." + contextKey)).is((Object)contextValue)}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"collaborationType").nin(excludedTypeIds), Criteria.where((String)"collaborationType").exists(true), Criteria.where((String)"workSpaces").in(new Object[]{workSpace})})}));
        } else if ("workspacePiBoard".equals(defaultTypeOrigin)) {
            String sessionId = collabType;
            Query generalTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"workspacePiBoard"), Criteria.where((String)"sessions").in(new Object[]{sessionId}), Criteria.where((String)"workSpaces").in(new Object[]{workSpace.getId()})}));
            List generalTypes = this.mongoTemplate.find(generalTypeQuery, CollaborationType.class);
            List generalTypeIds = generalTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteriaList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)"sessions").in(new Object[]{sessionId})}));
        } else if ("workspaceSolutionBoard".equals(defaultTypeOrigin)) {
            String solutionId = collabType;
            Query generalTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"workspaceSolutionBoard"), Criteria.where((String)"solutionBoards").in(new Object[]{solutionId}), Criteria.where((String)"workSpaces").in(new Object[]{workSpace.getId()})}));
            List generalTypes = this.mongoTemplate.find(generalTypeQuery, CollaborationType.class);
            List generalTypeIds = generalTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            criteriaList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"collaborationType").in(generalTypeIds), Criteria.where((String)"solutionBoards").in(new Object[]{solutionId})}));
        }
    }

    public List<CanvasBoard> findContextBasedCollabBoards(int page, int pageSize, Query query, String sortField, boolean ascending) {
        try {
            int skip = page * pageSize;
            query.skip(skip);
            query.limit(pageSize);
            Sort.Direction direction = ascending ? Sort.Direction.ASC : Sort.Direction.DESC;
            query.with(new Sort(direction, new String[]{sortField}));
            return this.mongoTemplate.find(query, CanvasBoard.class);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching context-based collaboration boards: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    private List<Team> fetchTeamsForBoards(List<CanvasBoard> boards) throws Exception {
        List<Object> teams = new ArrayList<Team>();
        if (boards == null || boards.isEmpty()) {
            return teams;
        }
        HashSet teamIds = new HashSet();
        for (CanvasBoard board : boards) {
            if (!PropertyValidator.isValid((Object)board.getPiTeamArea())) continue;
            board.getPiTeamArea().values().forEach(teamIds::addAll);
        }
        if (!teamIds.isEmpty()) {
            String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
            Query teamsQuery = new Query();
            teamsQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(teamIds).and("tenant").is((Object)tenant));
            teams = this.mongoTemplate.find(teamsQuery, Team.class);
        }
        return teams;
    }

    private void filterArchivedCollectionsFromBoards(List<CanvasBoard> boards) {
        try {
            HashSet<String> collectionIdsToCheck = new HashSet<String>();
            for (CanvasBoard board : boards) {
                if (board.getWorkSpaces() == null || board.getWorkSpaces().isEmpty()) continue;
                for (WorkSpace workspace2 : board.getWorkSpaces()) {
                    collectionIdsToCheck.add(workspace2.getId());
                }
            }
            if (collectionIdsToCheck.isEmpty()) {
                return;
            }
            Query collectionsQuery = new Query();
            collectionsQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(collectionIdsToCheck));
            List attachedCollections = this.mongoTemplate.find(collectionsQuery, WorkSpace.class);
            Set activeCollectionIds = attachedCollections.stream().filter(workspace -> workspace.getRowStatus() == 0).map(BaseEntity::getId).collect(Collectors.toSet());
            for (CanvasBoard board : boards) {
                if (board.getWorkSpaces() == null || board.getWorkSpaces().isEmpty()) continue;
                List originalWorkSpaces = board.getWorkSpaces();
                List filteredWorkSpaces = originalWorkSpaces.stream().filter(workspace -> activeCollectionIds.contains(workspace.getId())).collect(Collectors.toList());
                board.setWorkSpaces(filteredWorkSpaces);
                if (filteredWorkSpaces.size() >= originalWorkSpaces.size()) continue;
                this.canvasBoardRepository.save((Object)board);
                LOGGER.debug("Updated board {} - removed {} archived collections", (Object)board.getId(), (Object)(originalWorkSpaces.size() - filteredWorkSpaces.size()));
            }
            LOGGER.debug("Filtered archived collections from {} boards", (Object)boards.size());
        }
        catch (Exception e) {
            LOGGER.error("Error filtering archived collections from boards: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void addFilterCriteriaToList(Map<String, List<String>> filterMap, List<Criteria> criteriaList) {
        List<String> teamIds;
        List<String> solutionIds;
        List<String> sessionIds;
        List<String> workspaceIds;
        if (filterMap.containsKey("workspace") && (workspaceIds = filterMap.get("workspace")) != null && !workspaceIds.isEmpty()) {
            List workspaceObjectIds = workspaceIds.stream().filter(PropertyValidator::isValid).collect(Collectors.toList());
            LOGGER.info("Filtering by workspace IDs: {}", workspaceObjectIds);
            Criteria workspaceCriteria = Criteria.where((String)"workSpaces").in(workspaceObjectIds);
            criteriaList.add(workspaceCriteria);
        }
        if (filterMap.containsKey("session") && (sessionIds = filterMap.get("session")) != null && !sessionIds.isEmpty()) {
            List sessionObjectIds = sessionIds.stream().filter(PropertyValidator::isValid).collect(Collectors.toList());
            LOGGER.info("Filtering by session IDs: {}", sessionObjectIds);
            Criteria sessionCriteria = Criteria.where((String)"sessions").in(sessionObjectIds);
            criteriaList.add(sessionCriteria);
        }
        if (filterMap.containsKey("solution") && (solutionIds = filterMap.get("solution")) != null && !solutionIds.isEmpty()) {
            List solutionObjectIds = solutionIds.stream().filter(PropertyValidator::isValid).collect(Collectors.toList());
            LOGGER.info("Filtering by solution IDs: {}", solutionObjectIds);
            Criteria solutionCriteria = Criteria.where((String)"solutionBoards").in(solutionObjectIds);
            criteriaList.add(solutionCriteria);
        }
        if (filterMap.containsKey("team") && (teamIds = filterMap.get("team")) != null && !teamIds.isEmpty()) {
            Criteria teamCriteria = Criteria.where((String)"associatedTeams").in(teamIds);
            criteriaList.add(teamCriteria);
        }
    }

    public ResponseEntity<Object> applyTemplate(Map template) throws Exception {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)((String)template.get("boardId"))));
        Gson gson = new Gson();
        2 T = new /* Unavailable Anonymous Inner Class!! */;
        String templateId = (String)template.get("templateId");
        if (PropertyValidator.isValid((Object)templateId)) {
            int i;
            CanvasBoard templateBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)templateId));
            List nodes = this.graphRepository.findNodesByBoradId(templateBoard.getId(), null);
            List links = this.graphRepository.findLinksByBoardId(templateBoard.getId(), null);
            if (PropertyValidator.isValid((Collection)nodes)) {
                for (i = 0; i < nodes.size(); ++i) {
                    Map node = (Map)nodes.get(i);
                    node.put("boardId", board.getId());
                }
            }
            if (PropertyValidator.isValid((Collection)links)) {
                for (i = 0; i < links.size(); ++i) {
                    ((Map)links.get(i)).put("boardId", board.getId());
                }
            }
            responseJson.put("nodes", nodes);
            responseJson.put("links", links);
        } else {
            String nodes = "";
            if (template.get("templateTitle").equals("Planning Retro Template")) {
                nodes = this.loadTemplateFromResource("planning-retro-template.json");
            }
            List requestMap = (List)gson.fromJson(nodes, T.getType());
            for (int i = 0; i < requestMap.size(); ++i) {
                Map node = (Map)requestMap.get(i);
                node.put("boardId", board.getId());
            }
            responseJson.put("nodes", nodes);
            responseJson.put("links", null);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public CanvasFolder saveFolder(Map folder) {
        try {
            WorkSpace workSpace;
            List<CanvasFolder> foldersList = new ArrayList<CanvasFolder>();
            ArrayList allFolders = new ArrayList();
            CanvasFolder canvasFolder = new CanvasFolder();
            canvasFolder.setTitle(folder.get("title").toString());
            canvasFolder.setTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            canvasFolder.setParentFolder((String)folder.get("id"));
            if (PropertyValidator.isValid(folder.get("folderAccessType"))) {
                if (folder.get("folderAccessType").equals(CanvasFolder.AccessType.PrivateAccess.toString())) {
                    canvasFolder.setAccessType(CanvasFolder.AccessType.PrivateAccess);
                } else if (folder.get("folderAccessType").equals(CanvasFolder.AccessType.Restricted.toString())) {
                    canvasFolder.setAccessType(CanvasFolder.AccessType.Restricted);
                }
            }
            ArrayList<WorkSpace> savedWorkSpace = new ArrayList<WorkSpace>();
            if (PropertyValidator.isValid(folder.get("selectedWorkspace")) && PropertyValidator.isValid((Object)(workSpace = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)folder.get("selectedWorkspace").toString()))))) {
                savedWorkSpace.add(workSpace);
            }
            canvasFolder.setWorkSpaces(savedWorkSpace);
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
            collaboratorsList.add(collaborator);
            canvasFolder.setCollaborators(collaboratorsList);
            CanvasFolder savedFolder = (CanvasFolder)this.canvasFolderRepository.save((Object)canvasFolder);
            CanvasFolder parentFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)((String)folder.get("id"))));
            if (!PropertyValidator.isValid((Collection)parentFolder.getCanvasFolder())) {
                foldersList.add(savedFolder);
            } else {
                foldersList = parentFolder.getCanvasFolder();
                foldersList.add(savedFolder);
            }
            allFolders.addAll(foldersList);
            parentFolder.setCanvasFolder(allFolders);
            this.canvasFolderRepository.save((Object)parentFolder);
            return savedFolder;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public CanvasBoard addBoardPermission(Map permission) {
        ArrayList emails = new ArrayList();
        emails.addAll((List)permission.get("emails"));
        CanvasBoard savedBoard = new CanvasBoard();
        for (String email : emails) {
            Collaborator collaborator;
            List collaboratorList;
            CanvasBoard canvasBoard;
            User user = this.userRepository.findByEmail(email);
            if (PropertyValidator.isValid((Object)user)) {
                canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)permission.get("boardId").toString()));
                collaboratorList = canvasBoard.getCollaborators();
                for (Collaborator collaborator2 : collaboratorList) {
                    if (collaborator2.isExternal() || !collaborator2.getUser().getId().equals(user.getId())) continue;
                    return savedBoard;
                }
                collaborator = new Collaborator();
                collaborator.setUser(user);
                collaborator.setAccess(permission.get("right").toString());
                collaborator.setExternal(false);
                collaboratorList.add(collaborator);
                canvasBoard.setCollaborators(collaboratorList);
                savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
                HashMap<String, String> emailsnusername = new HashMap<String, String>();
                emailsnusername.put("body", savedBoard.getTitle());
                Notification emailNotification = new Notification("A collab board has been shared with you", Notification.ItemType.Item, "share_board_template", (String)emails.get(0), emailsnusername);
                this.notificationRepository.save((Object)emailNotification);
                continue;
            }
            if (PropertyValidator.isValid((Object)user)) continue;
            canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)permission.get("boardId").toString()));
            collaboratorList = canvasBoard.getCollaborators();
            collaborator = new Collaborator();
            User externalUser = new User();
            String accessToken = UUID.randomUUID().toString();
            ServerCache serverCache = new ServerCache();
            serverCache.setKey(accessToken);
            serverCache.setValue(permission.get("boardId").toString());
            serverCache.setTime(new Date());
            this.serverCacheRepository.save((Object)serverCache);
            collaborator.setToken(accessToken);
            collaborator.setExternal(true);
            collaborator.setAccess(permission.get("right").toString());
            externalUser.setEmail(email);
            collaborator.setExternalUser(externalUser);
            collaboratorList.add(collaborator);
            canvasBoard.setCollaborators(collaboratorList);
            savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
        }
        return savedBoard;
    }

    public String saveAnonymousUser(Map user) {
        String token = (String)user.get("token");
        CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)user.get("boardId").toString()));
        List collaboratorList = board.getCollaborators();
        for (Collaborator collaborator : collaboratorList) {
            if (!collaborator.isExternal() || !collaborator.getToken().equals(token)) continue;
            User ext = collaborator.getExternalUser();
            ext.setFullName((String)user.get("userName"));
            collaborator.setExternalUser(ext);
            collaborator.setCompanyId(UserContextUtil.getUserContext().getCurrentCompany().getId());
        }
        board.setCollaborators(collaboratorList);
        this.canvasBoardRepository.save((Object)board);
        return "1";
    }

    public String removeExternalCollaborator(String boardId, String accessToken) {
        CanvasBoard canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
        Collaborator removingCollaborator = new Collaborator();
        for (Collaborator collaborator : canvasBoard.getCollaborators()) {
            if (!collaborator.isExternal() || !collaborator.getToken().equals(accessToken)) continue;
            removingCollaborator = collaborator;
        }
        canvasBoard.getCollaborators().remove(removingCollaborator);
        this.canvasBoardRepository.save((Object)canvasBoard);
        return accessToken;
    }

    public String removeCollaborator(String boardId, String userId) {
        CanvasBoard canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
        Collaborator removingCollaborator = new Collaborator();
        for (Collaborator collaborator : canvasBoard.getCollaborators()) {
            if (!collaborator.getUser().getId().equalsIgnoreCase(userId)) continue;
            removingCollaborator = collaborator;
        }
        canvasBoard.getCollaborators().remove(removingCollaborator);
        this.canvasBoardRepository.save((Object)canvasBoard);
        return canvasBoard.getId();
    }

    public List<Map> saveNode(HashMap<String, Object> params) {
        List nodeList = (List)params.get("items");
        String tenant = (String)params.get("tenant");
        if (tenant == null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            String id = UUID.randomUUID().toString();
            ((Map)nodeList.get(i)).put("_id", id);
            ((Map)nodeList.get(i)).put("tenant", tenant);
            if (!((Map)nodeList.get(i)).containsKey("__gohashid")) continue;
            ((Map)nodeList.get(i)).remove("__gohashid");
        }
        nodeList.forEach(node -> {
            ArrayList reactions;
            if (node.get("category").equals("NOTE") && PropertyValidator.isValid((Collection)(reactions = (ArrayList)node.get("reactions")))) {
                ArrayList _reactions = new ArrayList();
                reactions.forEach(reaction -> {
                    ArrayList users = (ArrayList)reaction.get("users");
                    if (PropertyValidator.isValid((Collection)users)) {
                        _reactions.add(reaction);
                        users.forEach(user -> {
                            String userid = (String)user.get("id");
                            user.clear();
                            user.put("$ref", "user");
                            user.put("$id", new ObjectId(userid));
                        });
                    }
                });
            }
        });
        params.put("items", nodeList);
        return this.graphRepository.saveNode(params);
    }

    public List<Map> restoreItem(HashMap<String, Object> params) {
        ArrayList reactions;
        Map item = (Map)params.get("item");
        Map log = (Map)params.get("log");
        HashMap<String, String> newParam = new HashMap<String, String>();
        newParam.put("logId", (String)log.get("_id"));
        newParam.put("itemId", (String)item.get("_id"));
        String tenant = (String)params.get("tenant");
        if (tenant == null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        String id = UUID.randomUUID().toString();
        item.put("_id", id);
        item.put("tenant", tenant);
        if (item.containsKey("__gohashid")) {
            item.remove("__gohashid");
        }
        if (item.get("category").equals("NOTE") && PropertyValidator.isValid((Collection)(reactions = (ArrayList)item.get("reactions")))) {
            ArrayList _reactions = new ArrayList();
            reactions.forEach(reaction -> {
                ArrayList users = (ArrayList)reaction.get("users");
                if (PropertyValidator.isValid((Collection)users)) {
                    _reactions.add(reaction);
                    users.forEach(user -> {
                        String userid = (String)user.get("id");
                        user.clear();
                        user.put("$ref", "user");
                        user.put("$id", new ObjectId(userid));
                    });
                }
            });
        }
        ArrayList<Map> items = new ArrayList<Map>();
        items.add(item);
        params.put("items", items);
        params.put("ignoreLog", true);
        this.graphAuditLogService.removeItemFromAuditLog(newParam);
        if (item.get("category").equals("Arrow")) {
            return this.graphRepository.saveLink(params);
        }
        return this.graphRepository.saveNode(params);
    }

    public List<Map> saveLink(HashMap<String, Object> params) {
        List linksList = (List)params.get("items");
        String tenant = (String)params.get("tenant");
        if (tenant == null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        for (int i = 0; i < linksList.size(); ++i) {
            String id = UUID.randomUUID().toString();
            ((Map)linksList.get(i)).put("_id", id);
            ((Map)linksList.get(i)).put("tenant", tenant);
            if (!((Map)linksList.get(i)).containsKey("__gohashid")) continue;
            ((Map)linksList.get(i)).remove("__gohashid");
        }
        params.put("items", linksList);
        return this.graphRepository.saveLink(params);
    }

    public CanvasBoard saveTemplate(Map template) {
        block19: {
            try {
                String boardImage;
                if (!PropertyValidator.isValid((Object)template.get("type").equals("template"))) break block19;
                CanvasBoard canvasBoard = new CanvasBoard();
                Object piTeamAreaObj = template.get("piTeamArea");
                List sessions = (List)template.get("piSessions");
                List solutionBoards = (List)template.get("solutionBoards");
                canvasBoard.setId(ObjectId.get().toString());
                canvasBoard.setTitle(template.get("title").toString());
                if (template.containsKey("description")) {
                    canvasBoard.setDescription((String)template.get("description"));
                }
                canvasBoard.setCreatedFromBoard((String)template.get("createdFromBoard"));
                canvasBoard.setTenant(UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                canvasBoard.setFavorite(Boolean.valueOf(false));
                canvasBoard.setLocked(Boolean.valueOf(false));
                canvasBoard.setArchived(Boolean.valueOf(false));
                canvasBoard.setType("template");
                canvasBoard.setFolderId("template");
                canvasBoard.setIsSystem(Boolean.valueOf(false));
                canvasBoard.setBackgroundColor("#ffffff");
                canvasBoard.setBackgroundPattern("dotted");
                canvasBoard.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                canvasBoard.setCreatedOn(new Date());
                Collaborator collaborator = new Collaborator();
                collaborator.setAccess("3");
                collaborator.setAdmin(Boolean.valueOf(true));
                collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
                ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
                collaboratorsList.add(collaborator);
                canvasBoard.setCollaborators(collaboratorsList);
                String defaultOrigin = (String)template.get("defaultOrigin");
                Map context = (Map)template.get("context");
                String typeId = (String)template.get("typeId");
                String collaborationType = (String)template.get("collaborationType");
                String collaborationTypeId = (String)template.get("collaborationType");
                if (PropertyValidator.isValid((Object)collaborationTypeId)) {
                    CollaborationType collabType = new CollaborationType();
                    collabType.setId(collaborationTypeId);
                    canvasBoard.setCollaborationType(collabType);
                } else if (PropertyValidator.isValid(piTeamAreaObj)) {
                    if (piTeamAreaObj instanceof Map) {
                        Map piTeamAreaMap = (Map)piTeamAreaObj;
                        canvasBoard.setPiTeamArea(piTeamAreaMap);
                    }
                } else if (PropertyValidator.isValid((Collection)sessions)) {
                    List sessionList = this.sessionRepository.findSessionByIdIn(sessions);
                    canvasBoard.setSession(sessionList);
                } else if (PropertyValidator.isValid((Collection)solutionBoards)) {
                    List solutionList = this.solutionBoardRepository.findByIdIn(solutionBoards);
                    canvasBoard.setSolutionBoard(solutionList);
                }
                if (template.containsKey("existingTemplateId")) {
                    String existingTemplateId = (String)template.get("existingTemplateId");
                    this.canvasBoardRepository.delete((Serializable)((Object)existingTemplateId));
                }
                if (PropertyValidator.isValid((Object)(boardImage = (String)template.get("image")))) {
                    String thumbnailFileName = "thumbnail_" + canvasBoard.getId() + ".png";
                    try {
                        String gridFsFileId = this.attachmentService.uploadImageFromBase64(boardImage, thumbnailFileName);
                        canvasBoard.setThumbnailPath(gridFsFileId);
                        LOGGER.info("Successfully uploaded thumbnail image for template: {} to MongoDB GridFS with ID: {}", (Object)canvasBoard.getId(), (Object)gridFsFileId);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error uploading thumbnail image to MongoDB GridFS for template {}: {}", new Object[]{canvasBoard.getId(), e.getMessage(), StringUtils.getTraceString((Throwable)e)});
                        canvasBoard.setThumbnailPath(null);
                    }
                }
                CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
                List nodes = new ArrayList();
                List links = new ArrayList();
                nodes = (List)template.get("nodes");
                links = (List)template.get("links");
                if (PropertyValidator.isValid(nodes)) {
                    for (int i = 0; i < nodes.size(); ++i) {
                        ((Map)nodes.get(i)).put("boardId", savedBoard.getId());
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("boardId", savedBoard.getId());
                    params.put("items", nodes);
                    this.saveNode(params);
                }
                if (PropertyValidator.isValid(links)) {
                    for (int i = 0; i < links.size(); ++i) {
                        ((Map)links.get(i)).put("boardId", savedBoard.getId());
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("boardId", savedBoard.getId());
                    params.put("items", links);
                    this.saveLink(params);
                }
                return savedBoard;
            }
            catch (Exception e) {
                LOGGER.error("Error saving template: {}", (Object)StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }

    public ResponseEntity<Object> updateTemplate(Map template) {
        try {
            HashMap responseJson = new HashMap();
            CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)((String)template.get("boardId"))));
            Map currentNodes = (Map)template.get("currentNodes");
            Map currentLinks = (Map)template.get("currentLinks");
            this.deleteNodesAndLinksOnTemplateSave(board, currentNodes, currentLinks);
            List nodes = new ArrayList();
            List links = new ArrayList();
            nodes = (List)template.get("nodes");
            links = (List)template.get("links");
            if (PropertyValidator.isValid(nodes)) {
                for (int i = 0; i < nodes.size(); ++i) {
                    ((Map)nodes.get(i)).put("boardId", template.get("boardId"));
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", board.getId());
                params.put("items", nodes);
                this.saveNode(params);
            }
            if (PropertyValidator.isValid(links)) {
                for (int i = 0; i < links.size(); ++i) {
                    ((Map)links.get(i)).put("boardId", template.get("boardId"));
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", board.getId());
                params.put("items", links);
                this.saveLink(params);
            }
            responseJson.put("nodes", nodes);
            responseJson.put("links", links);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private void deleteNodesAndLinksOnTemplateSave(CanvasBoard board, Map currentNodes, Map currentLinks) {
        int i;
        List existingNodes = this.graphRepository.findNodesByBoradId(board.getId(), null);
        List existingLinks = this.graphRepository.findLinksByBoardId(board.getId(), null);
        if (PropertyValidator.isValid((Collection)existingNodes)) {
            ArrayList<Map> filterNodes = new ArrayList<Map>();
            for (i = 0; i < existingNodes.size(); ++i) {
                Map node = (Map)existingNodes.get(i);
                if (PropertyValidator.isValid(currentNodes.get(node.get("_id")))) continue;
                filterNodes.add(node);
            }
            if (PropertyValidator.isValid(filterNodes)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", board.getId());
                params.put("items", filterNodes);
                this.graphRepository.removeNode(params);
            }
        }
        if (PropertyValidator.isValid((Collection)existingLinks)) {
            ArrayList<Map> filterLinks = new ArrayList<Map>();
            for (i = 0; i < existingLinks.size(); ++i) {
                Map link = (Map)existingLinks.get(i);
                if (PropertyValidator.isValid(currentLinks.get(link.get("_id")))) continue;
                filterLinks.add(link);
            }
            if (PropertyValidator.isValid(filterLinks)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", board.getId());
                params.put("items", filterLinks);
                this.graphRepository.removeLink(params);
            }
        }
    }

    public List<CanvasBoard> findTemplatesByUserId(String userId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"collaborators.user.$id").is((Object)new ObjectId(userId)).and("type").is((Object)"template"));
            List boards = this.mongoTemplate.find(query, CanvasBoard.class);
            ArrayList<CanvasBoard> templates = new ArrayList<CanvasBoard>();
            templates.addAll(boards);
            return templates;
        }
        catch (Exception e) {
            LOGGER.error("Error fetching Templates related to particular user for id: {}, error: {}", new Object[]{userId, e.getMessage(), e});
            return null;
        }
    }

    public List<CanvasBoard> findTemplatesCollaborationType(String collabType) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(collabType)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        List boards = this.mongoTemplate.find(query, CanvasBoard.class);
        ArrayList<CanvasBoard> templates = new ArrayList<CanvasBoard>();
        templates.addAll(boards);
        return templates;
    }

    public Map<String, Object> findAllTemplatesRelatedToContext(String collabType, Map<String, Object> payload) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String association = (String)payload.get("association");
        String contextId = (String)payload.get("contextId");
        String context = (String)payload.get("context");
        Map templateCount = new HashMap();
        templateCount = "session".equals(context) ? this.getTemplateCountsForSessionContext(contextId) : ("solution".equals(context) ? this.getTemplateCountsForSolutionContext(contextId) : this.getTemplateCountsForWorkspaceContext(contextId));
        Query query = new Query();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        List boards = new ArrayList();
        if (PropertyValidator.isValid((Object)association)) {
            if ("team".equals(association)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)("piTeamArea." + contextId)).is((Object)collabType));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
                boards = this.mongoTemplate.find(query, CanvasBoard.class);
            } else if ("piBoard".equals(association)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions.$id").is((Object)new ObjectId(collabType)));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
                boards = this.mongoTemplate.find(query, CanvasBoard.class);
            } else if ("solutionBoard".equals(association)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoards.$id").is((Object)new ObjectId(collabType)));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
                boards = this.mongoTemplate.find(query, CanvasBoard.class);
            }
        } else {
            SessionBoard sessionBoard;
            String id = "";
            id = PropertyValidator.isValid((Object)context) && "session".equals(context) ? (!PropertyValidator.isValid((Object)(sessionBoard = this.sessionBoardRepository.findBoardById(contextId))) ? this.sessionRepository.findById(contextId).getId() : this.sessionRepository.findByActiveSessionBoard(sessionBoard.getId()).getId()) : (PropertyValidator.isValid((Object)context) && "solution".equals(context) ? this.solutionBoardRepository.findById(contextId).getId() : this.workSpaceRepository.findByKey(contextId).getId());
            Criteria orRelatedCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sessions.$id").is((Object)new ObjectId(id)), Criteria.where((String)"solutionBoards.$id").is((Object)new ObjectId(id)), Criteria.where((String)"workSpaces.$id").is((Object)new ObjectId(id))});
            Criteria orCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(collabType))});
            Criteria finalCriteria = null;
            finalCriteria = PropertyValidator.isValid((Object)collabType) ? new Criteria().andOperator(new Criteria[]{Criteria.where((String)"type").is((Object)"template"), orCriteria}) : new Criteria().andOperator(new Criteria[]{Criteria.where((String)"type").is((Object)"template"), orRelatedCriteria});
            query = new Query((CriteriaDefinition)finalCriteria);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            boards = this.mongoTemplate.find(query, CanvasBoard.class);
        }
        ArrayList templates = new ArrayList();
        templates.addAll(boards);
        result.put("templates", templates);
        result.put("templatesCount", templateCount);
        return result;
    }

    public List<CanvasBoard> getSystemTemplates() {
        ArrayList<CanvasBoard> systemTemplates = new ArrayList<CanvasBoard>();
        CanvasBoard canvasBoard = new CanvasBoard();
        canvasBoard.setTitle("Planning Retro Template");
        canvasBoard.setFavorite(Boolean.valueOf(false));
        canvasBoard.setLocked(Boolean.valueOf(false));
        canvasBoard.setArchived(Boolean.valueOf(false));
        canvasBoard.setIsSystem(Boolean.valueOf(true));
        canvasBoard.setType("template");
        canvasBoard.setFolderId("template");
        canvasBoard.setBackgroundColor("#ffffff");
        canvasBoard.setBackgroundPattern("dotted");
        systemTemplates.add(canvasBoard);
        return systemTemplates;
    }

    public List<CanvasBoard> findSystemTemplatesByUserId(String userId) {
        try {
            User user = this.userRepository.findById(userId);
            Collaborator collaborators = new Collaborator();
            collaborators.setUser(user);
            ArrayList<User> collaboratorsList = new ArrayList<User>();
            collaboratorsList.add(user);
            List boards = this.customRepository.getSystemTemplates(Boolean.valueOf(true));
            ArrayList<CanvasBoard> customTemplates = new ArrayList<CanvasBoard>();
            for (CanvasBoard board : boards) {
                if (!PropertyValidator.isValid((Object)board.getType()) || !PropertyValidator.isValid((Object)board.getIsSystem()) || !board.getType().equals("template") || !board.getIsSystem().equals(true)) continue;
                customTemplates.add(board);
            }
            if (!PropertyValidator.isValid(customTemplates)) {
                CanvasBoard canvasBoard = new CanvasBoard();
                canvasBoard.setTitle("Kanban Framework");
                canvasBoard.setFavorite(Boolean.valueOf(false));
                canvasBoard.setLocked(Boolean.valueOf(false));
                canvasBoard.setArchived(Boolean.valueOf(false));
                canvasBoard.setIsSystem(Boolean.valueOf(true));
                canvasBoard.setType("template");
                canvasBoard.setFolderId("template");
                canvasBoard.setBackgroundColor("#ffffff");
                canvasBoard.setBackgroundPattern("dotted");
                Collaborator collaborator = new Collaborator();
                collaborator.setAccess("3");
                collaborator.setAdmin(Boolean.valueOf(true));
                collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
                ArrayList<Collaborator> collaboratorsList1 = new ArrayList<Collaborator>();
                collaboratorsList1.add(collaborator);
                canvasBoard.setCollaborators(collaboratorsList1);
                CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)canvasBoard);
                customTemplates.add(savedBoard);
                Gson gson = new Gson();
                3 T = new /* Unavailable Anonymous Inner Class!! */;
                String nodes = "[{\"_id\":\"94cf9d10-e636-4a1d-ae96-b583c2b7b42f\",\"_class\":\"java.util.LinkedHashMap\",\"loc\":\"-442.8189875 -293.29999999999995\",\"underline\":false,\"link\":\"\",\"type\":\"ratio\",\"italic\":false,\"linkTo\":\"\",\"isEditable\":true,\"sizeRatio\":[0.0,0.0],\"angle\":0.0,\"lock\":false,\"text\":\"WhatWentWell\",\"notAllowedItems\":[],\"key\":-1,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\",\"textSize\":24,\"showHeader\":true,\"textBg\":\"#64DD17\",\"bold\":false,\"fill\":\"#CCFF90\",\"textColor\":\"#ffffff\",\"lockBy\":\"\",\"size\":\"436 727\",\"textAlignment\":\"center\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"category\":\"FRAME\",\"isGroup\":true,\"group\":\"none\"},{\"_id\":\"0cd7f5ef-cefe-4212-8492-a8e30aad5e85\",\"_class\":\"java.util.LinkedHashMap\",\"loc\":\"51.14683749999983 -293.29999999999995\",\"underline\":false,\"link\":\"\",\"type\":\"ratio\",\"italic\":false,\"linkTo\":\"\",\"isEditable\":true,\"sizeRatio\":[0.0,0.0],\"angle\":0.0,\"lock\":false,\"text\":\"WhatDidn\u2019tGoWell\",\"notAllowedItems\":[],\"key\":-2,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\",\"textSize\":24,\"showHeader\":true,\"textBg\":\"#FF1744\",\"bold\":false,\"fill\":\"#FF80AB\",\"textColor\":\"#ffffff\",\"lockBy\":\"\",\"size\":\"436 727\",\"textAlignment\":\"center\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"category\":\"FRAME\",\"isGroup\":true,\"group\":\"none\"},{\"_id\":\"ee299351-1843-468f-a5bf-c6609d2f1bb9\",\"_class\":\"java.util.LinkedHashMap\",\"loc\":\"551.1901937499999 -293.29999999999995\",\"underline\":false,\"link\":\"\",\"type\":\"ratio\",\"italic\":false,\"linkTo\":\"\",\"isEditable\":true,\"sizeRatio\":[0.0,0.0],\"angle\":0.0,\"lock\":false,\"text\":\"WhatToImproveNext?\",\"notAllowedItems\":[],\"key\":-3,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\",\"textSize\":24,\"showHeader\":true,\"textBg\":\"#699bf7\",\"bold\":false,\"fill\":\"#82B1FF\",\"textColor\":\"#ffffff\",\"lockBy\":\"\",\"size\":\"436 727\",\"textAlignment\":\"center\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"category\":\"FRAME\",\"isGroup\":true,\"group\":\"none\"},{\"_id\":\"359dce6f-9981-4f39-8622-7be280f79358\",\"_class\":\"java.util.LinkedHashMap\",\"loc\":\"1046.3715250000002 -293.29999999999995\",\"underline\":false,\"link\":\"\",\"type\":\"ratio\",\"italic\":false,\"linkTo\":\"\",\"isEditable\":true,\"sizeRatio\":[0.0,0.0],\"angle\":0.0,\"lock\":false,\"text\":\"AThankYouTo...\",\"notAllowedItems\":[],\"key\":-4,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\",\"textSize\":24,\"showHeader\":true,\"textBg\":\"#D500F9\",\"bold\":false,\"fill\":\"#B388FF\",\"textColor\":\"#ffffff\",\"lockBy\":\"\",\"size\":\"436 727\",\"textAlignment\":\"center\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"category\":\"FRAME\",\"isGroup\":true,\"group\":\"none\"},{\"_id\":\"fe6ecc03-829c-4b47-87b2-2848124745b2\",\"_class\":\"java.util.LinkedHashMap\",\"category\":\"NOTE\",\"linkable\":true,\"angle\":0,\"size\":\"200 200\",\"lock\":false,\"border\":\"black\",\"fill\":\"#FCFAA2\",\"text\":\"\",\"textPosition\":0,\"textSize\":\"Auto\",\"autoFont\":92,\"textColor\":\"#000\",\"showText\":false,\"isEditable\":true,\"reactions\":[],\"lockBy\":\"\",\"link\":\"\",\"linkTo\":\"\",\"bold\":false,\"italic\":false,\"underline\":false,\"scale\":0.528745218750001,\"emoji\":4,\"key\":-5,\"loc\":\"-426.6426937500003 -230.94618750000012\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\",\"group\":-1},{\"_id\":\"59aff733-038a-4896-8607-6e4dcfe3730f\",\"_class\":\"java.util.LinkedHashMap\",\"category\":\"NOTE\",\"linkable\":true,\"angle\":0,\"size\":\"200 200\",\"lock\":false,\"border\":\"black\",\"fill\":\"#FCFAA2\",\"text\":\"\",\"textPosition\":0,\"textSize\":\"Auto\",\"autoFont\":92,\"textColor\":\"#000\",\"showText\":false,\"isEditable\":true,\"lockBy\":\"\",\"link\":\"\",\"linkTo\":\"\",\"bold\":false,\"italic\":false,\"underline\":false,\"scale\":0.528745218750001,\"emoji\":4,\"loc\":\"74.03417499999983 -234.5927062500001\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"group\":-2,\"key\":-6,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\"},{\"_id\":\"5d8b0a27-ce99-4e30-8c33-450748f04c00\",\"_class\":\"java.util.LinkedHashMap\",\"category\":\"NOTE\",\"linkable\":true,\"angle\":0,\"size\":\"200 200\",\"lock\":false,\"border\":\"black\",\"fill\":\"#FCFAA2\",\"text\":\"\",\"textPosition\":0,\"textSize\":\"Auto\",\"autoFont\":92,\"textColor\":\"#000\",\"showText\":false,\"isEditable\":true,\"lockBy\":\"\",\"link\":\"\",\"linkTo\":\"\",\"bold\":false,\"italic\":false,\"underline\":false,\"scale\":0.528745218750001,\"emoji\":4,\"loc\":\"564.9869937500005 -238.2392250000001\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"group\":-3,\"key\":-7,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\"},{\"_id\":\"96ba5316-dd66-4c6b-a342-249b8423bbad\",\"_class\":\"java.util.LinkedHashMap\",\"category\":\"NOTE\",\"linkable\":true,\"angle\":0,\"size\":\"200 200\",\"lock\":false,\"border\":\"black\",\"fill\":\"#FCFAA2\",\"text\":\"\",\"textPosition\":0,\"textSize\":\"Auto\",\"autoFont\":92,\"textColor\":\"#000\",\"showText\":false,\"isEditable\":true,\"lockBy\":\"\",\"link\":\"\",\"linkTo\":\"\",\"bold\":false,\"italic\":false,\"underline\":false,\"scale\":0.528745218750001,\"emoji\":4,\"loc\":\"1059.698037500001 -241.99745000000013\",\"boardId\":\"6253c87b1778d05040ceb7a6\",\"group\":-4,\"key\":-8,\"tenant\":\"ca07c250-1737-4987-996d-c13d814b4cee\"}]";
                List requestMap = (List)gson.fromJson(nodes, T.getType());
                for (int i = 0; i < requestMap.size(); ++i) {
                    Map node = (Map)requestMap.get(i);
                    node.put("boardId", savedBoard.getId());
                    node.remove("tenant");
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", savedBoard.getId());
                params.put("items", requestMap);
                this.saveNode(params);
            }
            return customTemplates;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public Map findTemplateById(String id) {
        try {
            return this.graphRepository.findTemplateById(id);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public void saveAllNodes(HashMap<String, Object> params) {
        this.graphRepository.saveAllNodes(params);
    }

    public void saveAllLinks(HashMap<String, Object> params) {
        this.graphRepository.saveAllLinks(params);
    }

    public CanvasBoard updateBoard(Map board) {
        try {
            Boolean setupAssociations = (Boolean)board.get("setupAssociations");
            CanvasBoard canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)board.get("id").toString()));
            canvasBoard.setTitle(board.get("title").toString());
            if (PropertyValidator.isValid(board.get("description"))) {
                canvasBoard.setDescription(board.get("description").toString());
            }
            if (PropertyValidator.isValid(board.get("backgroundColor"))) {
                canvasBoard.setBackgroundColor(board.get("backgroundColor").toString());
            }
            if (PropertyValidator.isValid(board.get("backgroundPattern"))) {
                canvasBoard.setBackgroundPattern(board.get("backgroundPattern").toString());
            }
            CanvasBoard boardToBeMoved = new CanvasBoard();
            if (PropertyValidator.isValid(board.get("selectedFolderId"))) {
                canvasBoard.setFolderId(board.get("selectedFolderId").toString());
                CanvasFolder targetFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)board.get("selectedFolderId").toString()));
                CanvasFolder currentFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)board.get("currentFolderId").toString()));
                if (PropertyValidator.isValid((Collection)currentFolder.getCanvasBoard())) {
                    for (CanvasBoard board1 : currentFolder.getCanvasBoard()) {
                        if (!board1.getId().equals(board.get("id").toString())) continue;
                        boardToBeMoved = board1;
                    }
                }
                currentFolder.getCanvasBoard().remove(boardToBeMoved);
                if (!PropertyValidator.isValid((Collection)targetFolder.getCanvasBoard())) {
                    ArrayList boards = new ArrayList();
                    targetFolder.setCanvasBoard(boards);
                }
                targetFolder.getCanvasBoard().add(boardToBeMoved);
                this.canvasFolderRepository.save((Object)targetFolder);
                this.canvasFolderRepository.save((Object)currentFolder);
            }
            if (!PropertyValidator.isValid((Object)setupAssociations)) {
                this.setupBoardAssociations(canvasBoard, board);
            }
            if (PropertyValidator.isValid((Object)canvasBoard.getCreatedOn())) {
                canvasBoard.setCreatedOn(canvasBoard.getCreatedOn());
            }
            if (PropertyValidator.isValid((Object)canvasBoard.getCreatedBy())) {
                canvasBoard.setCreatedBy(canvasBoard.getCreatedBy());
            }
            this.canvasBoardRepository.save((Object)canvasBoard);
            return canvasBoard;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private void setupBoardAssociations(CanvasBoard canvasBoard, Map board) throws Exception {
        Object sessionIdObj = board.get("sessionId");
        List<String> sessionIds = new ArrayList();
        if (sessionIdObj instanceof List) {
            sessionIds = (List)sessionIdObj;
        } else if (sessionIdObj instanceof String) {
            sessionIds.add((String)sessionIdObj);
        }
        if (!sessionIds.isEmpty()) {
            List fetchedSessions = this.sessionRepository.findByIdIn(sessionIds);
            canvasBoard.setSession(fetchedSessions);
        } else {
            canvasBoard.setSession(Collections.emptyList());
        }
        Object solutionIdObj = board.get("solutionId");
        List<String> solutionIds = new ArrayList();
        if (solutionIdObj instanceof List) {
            solutionIds = (List)solutionIdObj;
        } else if (solutionIdObj instanceof String) {
            solutionIds.add((String)solutionIdObj);
        }
        if (!solutionIds.isEmpty()) {
            List fetchedSolutionBoards = this.solutionBoardRepository.findByIdIn(solutionIds);
            canvasBoard.setSolutionBoard(fetchedSolutionBoards);
        } else {
            canvasBoard.setSolutionBoard(Collections.emptyList());
        }
        Object workSpaceIdObj = board.get("workSpaceId");
        List<String> workSpaceIds = new ArrayList();
        if (workSpaceIdObj instanceof List) {
            workSpaceIds = (List)workSpaceIdObj;
        } else if (workSpaceIdObj instanceof String) {
            workSpaceIds.add((String)workSpaceIdObj);
        }
        if (!workSpaceIds.isEmpty()) {
            List fetchedWorkSpaces = this.workSpaceRepository.findByIdIn(workSpaceIds);
            canvasBoard.setWorkSpaces(fetchedWorkSpaces);
        } else {
            canvasBoard.setWorkSpaces(Collections.emptyList());
        }
        if (PropertyValidator.isValid(board.get("piInspectAndAdapt"))) {
            Object piInspectAndAdaptObj = board.get("piInspectAndAdapt");
            List<String> piInspectAndAdaptList = new ArrayList();
            if (piInspectAndAdaptObj instanceof List) {
                piInspectAndAdaptList = (List)piInspectAndAdaptObj;
            } else if (piInspectAndAdaptObj instanceof String) {
                piInspectAndAdaptList.add((String)piInspectAndAdaptObj);
            }
            canvasBoard.setPiInspectAndAdapt(piInspectAndAdaptList);
        } else {
            canvasBoard.setPiInspectAndAdapt(Collections.emptyList());
        }
        if (PropertyValidator.isValid(board.get("piTeamArea"))) {
            Object piTeamAreaObj = board.get("piTeamArea");
            if (piTeamAreaObj instanceof Map) {
                Map piTeamAreaMap = (Map)piTeamAreaObj;
                canvasBoard.setPiTeamArea(piTeamAreaMap);
            }
        } else {
            canvasBoard.setPiTeamArea(new HashMap());
        }
        Map context = (Map)board.get("context");
        Object collaborationType = board.get("type");
        Object defaultOrigin = board.get("defaultOrigin");
        if (PropertyValidator.isValid(collaborationType)) {
            String typeId = collaborationType.toString();
            this.setupCollaborationType(defaultOrigin, context, typeId, canvasBoard, collaborationType);
        }
    }

    private void setupCollaborationType(Object defaultOrigin, Map<String, String> context, String typeId, CanvasBoard canvasBoard, Object collaborationType) throws Exception {
        boolean typeSet = false;
        if (!typeSet) {
            typeSet = this.setUpSessionAssociationType(defaultOrigin, context, typeId, canvasBoard, collaborationType);
        }
        if (!typeSet) {
            typeSet = this.setUpSolutionAssociationType(defaultOrigin, context, typeId, canvasBoard, collaborationType);
        }
        if (!typeSet) {
            typeSet = this.setUpWorkspaceAssociationType(defaultOrigin, context, typeId, canvasBoard, collaborationType);
        }
        if (!typeSet) {
            this.setUpCustomAssociationType(canvasBoard, collaborationType);
        }
    }

    private boolean setUpSessionAssociationType(Object defaultOrigin, Map<String, String> context, String typeId, CanvasBoard canvasBoard, Object collaborationType) throws Exception {
        if (PropertyValidator.isValid((Object)defaultOrigin) && "sessionTeam".equals(defaultOrigin.toString())) {
            canvasBoard.setCollaborationType(null);
            return true;
        }
        if (PropertyValidator.isValid((Object)defaultOrigin) && "session".equals(defaultOrigin.toString())) {
            String titleRegex = DBUtils.toCaseInsensitiveRegex((String)collaborationType.toString());
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex(titleRegex, "i").and("defaultOrigin").is((Object)defaultOrigin.toString()));
            CollaborationType collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)collabType)) {
                collabType = new CollaborationType();
                collabType.setTitle(collaborationType.toString());
                collabType.setDefaultOrigin(defaultOrigin.toString());
                collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        if ("inspect".equals(typeId)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").is((Object)"Inspect and Adapt").and("defaultOrigin").is((Object)"sessionInspect"));
            CollaborationType collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)collabType)) {
                collabType = new CollaborationType();
                collabType.setTitle("Inspect and Adapt");
                collabType.setDefaultOrigin("sessionInspect");
                collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        return false;
    }

    private boolean setUpSolutionAssociationType(Object defaultOrigin, Map<String, String> context, String typeId, CanvasBoard canvasBoard, Object collaborationType) {
        if (PropertyValidator.isValid((Object)defaultOrigin) && "solution".equals(defaultOrigin.toString())) {
            String titleRegex = DBUtils.toCaseInsensitiveRegex((String)collaborationType.toString());
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex(titleRegex, "i").and("defaultOrigin").is((Object)defaultOrigin.toString()));
            CollaborationType collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)collabType)) {
                collabType = new CollaborationType();
                collabType.setTitle(collaborationType.toString());
                collabType.setDefaultOrigin(defaultOrigin.toString());
                collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        if (PropertyValidator.isValid((Object)defaultOrigin) && "solutionPiBoard".equals(defaultOrigin.toString())) {
            String solutionId = context.get("solution");
            String sessionId = typeId;
            Session session = this.sessionRepository.findById(sessionId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"defaultOrigin").is((Object)defaultOrigin.toString()).and("session").in(new Object[]{sessionId}));
            CollaborationType collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)collabType)) {
                collabType = new CollaborationType();
                collabType.setTitle(session.getTitle());
                collabType.setDefaultOrigin(defaultOrigin.toString());
                collabType.setSessions(Arrays.asList(session));
                List solutionBoards = this.solutionBoardRepository.findByIdIn(Arrays.asList(solutionId));
                collabType.setSolutionBoards(solutionBoards);
                collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        return false;
    }

    private boolean setUpWorkspaceAssociationType(Object defaultOrigin, Map<String, String> context, String typeId, CanvasBoard canvasBoard, Object collaborationType) {
        if (PropertyValidator.isValid((Object)defaultOrigin) && "workspace".equals(defaultOrigin.toString())) {
            String workspaceKey = context.get("workspace");
            CollaborationType collabType = null;
            if ("general".equals(collaborationType)) {
                String titleRegex = DBUtils.toCaseInsensitiveRegex((String)collaborationType.toString());
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex(titleRegex, "i").and("defaultOrigin").is((Object)"workspace"));
                collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
                if (!PropertyValidator.isValid((Object)collabType)) {
                    collabType = new CollaborationType();
                    collabType.setTitle("general");
                    collabType.setDefaultOrigin("workspace");
                    collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
                }
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        if (PropertyValidator.isValid((Object)defaultOrigin) && "workspacePiBoard".equals(defaultOrigin.toString())) {
            String collectionKey = context.get("workspace");
            String sessionId = typeId;
            Session session = this.sessionRepository.findById(sessionId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"defaultOrigin").is((Object)defaultOrigin.toString()).and("sessions").in(new Object[]{sessionId}));
            CollaborationType collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)collabType)) {
                collabType = new CollaborationType();
                collabType.setTitle(session.getTitle());
                collabType.setDefaultOrigin(defaultOrigin.toString());
                collabType.setSessions(Arrays.asList(session));
                WorkSpace workSpace = this.workSpaceRepository.findByKey(collectionKey);
                collabType.setWorkSpaces(Arrays.asList(workSpace));
                collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        if (PropertyValidator.isValid((Object)defaultOrigin) && "workspaceSolutionBoard".equals(defaultOrigin.toString())) {
            String collectionKey = context.get("workspace");
            String solutionId = typeId;
            SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"defaultOrigin").is((Object)defaultOrigin.toString()).and("solutionBoards").in(new Object[]{solutionId}));
            CollaborationType collabType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)collabType)) {
                collabType = new CollaborationType();
                collabType.setTitle(solutionBoard.getTitle());
                collabType.setDefaultOrigin(defaultOrigin.toString());
                collabType.setSolutionBoards(Arrays.asList(solutionBoard));
                WorkSpace workSpace = this.workSpaceRepository.findByKey(collectionKey);
                collabType.setWorkSpaces(Arrays.asList(workSpace));
                collabType = (CollaborationType)this.collaborationTypeRepository.save((Object)collabType);
            }
            canvasBoard.setCollaborationType(collabType);
            return true;
        }
        return false;
    }

    private void setUpCustomAssociationType(CanvasBoard canvasBoard, Object collaborationType) {
        Optional collaborationTypeOptional = this.collaborationTypeRepository.findById((String)collaborationType);
        CollaborationType collabType = (CollaborationType)collaborationTypeOptional.get();
        canvasBoard.setCollaborationType(collabType);
    }

    public String addThumbnailPath(String bitmap, String boardId) {
        CanvasBoard canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
        canvasBoard.setThumbnailPath("thumbnail_" + canvasBoard.getId() + ".png");
        Attachment attachmentVO = new Attachment();
        try {
            byte[] bytes = Base64.getDecoder().decode(new String(bitmap.substring(bitmap.indexOf(",") + 1)).getBytes("UTF-8"));
            attachmentVO.setAttachmentData(bytes);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        attachmentVO.setFilepath(canvasBoard.getThumbnailPath());
        S3Utils.uploadFile((Attachment)attachmentVO);
        this.canvasBoardRepository.save((Object)canvasBoard);
        return canvasBoard.getId();
    }

    public String uploadImageToS3(String data) {
        String path = "graphNode" + UUID.randomUUID().toString() + ".png";
        Attachment attachmentVO = new Attachment();
        try {
            byte[] bytes = Base64.getDecoder().decode(new String(data.substring(data.indexOf(",") + 1)).getBytes("UTF-8"));
            attachmentVO.setAttachmentData(bytes);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        attachmentVO.setFilepath(path);
        S3Utils.uploadFile((Attachment)attachmentVO);
        return path;
    }

    public CanvasFolder updateFolder(Map folder) {
        CanvasFolder canvasFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)folder.get("id").toString()));
        canvasFolder.setTitle(folder.get("title").toString());
        this.canvasFolderRepository.save((Object)canvasFolder);
        return canvasFolder;
    }

    public String updateBoardUrl(String id, String url) {
        CanvasBoard canvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)id));
        canvasBoard.setUrl(url);
        this.canvasBoardRepository.save((Object)canvasBoard);
        return canvasBoard.getId();
    }

    public List updateNode(HashMap<String, Object> params) {
        ArrayList updatedNode = new ArrayList();
        ObjectMapper oMapper = new ObjectMapper();
        List items = (List)params.get("items");
        items.forEach(node -> {
            ArrayList reactions;
            if (PropertyValidator.isValid(node.get("reactions")) && PropertyValidator.isValid((Collection)(reactions = (ArrayList)node.get("reactions")))) {
                ArrayList _reactions = new ArrayList();
                reactions.forEach(reaction -> {
                    ArrayList users = (ArrayList)reaction.get("users");
                    if (PropertyValidator.isValid((Collection)users)) {
                        _reactions.add(reaction);
                        users.forEach(user -> {
                            String userid = (String)user.get("id");
                            user.clear();
                            user.put("$ref", "user");
                            user.put("$id", new ObjectId(userid));
                        });
                    }
                    reaction.put("users", users);
                });
            }
            updatedNode.add(node);
        });
        params.put("items", items);
        return this.graphRepository.updateNode(params);
    }

    public String updateExistingNodes(HashMap<String, Object> params) {
        ArrayList updatedNode = new ArrayList();
        ObjectMapper oMapper = new ObjectMapper();
        List items = (List)params.get("items");
        items.forEach(node -> {
            ArrayList reactions;
            if (PropertyValidator.isValid(node.get("reactions")) && PropertyValidator.isValid((Collection)(reactions = (ArrayList)node.get("reactions")))) {
                ArrayList _reactions = new ArrayList();
                reactions.forEach(reaction -> {
                    ArrayList users = (ArrayList)reaction.get("users");
                    if (PropertyValidator.isValid((Collection)users)) {
                        _reactions.add(reaction);
                        users.forEach(user -> {
                            String userid = (String)user.get("id");
                            user.clear();
                            user.put("$ref", "user");
                            user.put("$id", new ObjectId(userid));
                        });
                    }
                    reaction.put("users", users);
                });
            }
            updatedNode.add(node);
        });
        params.put("items", items);
        this.graphRepository.updateNode(params);
        return "success";
    }

    public List updateLink(HashMap<String, Object> params) {
        return this.graphRepository.updateLink(params);
    }

    public String updateExistingLinks(HashMap<String, Object> params) {
        this.graphRepository.updateLink(params);
        return "success";
    }

    public int removeBoard(String id, String parentFolderId) {
        CanvasFolder parentCanvasFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)parentFolderId));
        CanvasBoard removingBoard = new CanvasBoard();
        if (PropertyValidator.isValid((Collection)parentCanvasFolder.getCanvasBoard())) {
            for (CanvasBoard board : parentCanvasFolder.getCanvasBoard()) {
                if (!board.getId().equals(id)) continue;
                removingBoard = board;
            }
        }
        parentCanvasFolder.getCanvasBoard().remove(removingBoard);
        this.canvasFolderRepository.save((Object)parentCanvasFolder);
        CanvasBoard boardToBeDeleted = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)id));
        boardToBeDeleted.setRowStatus(-1);
        this.canvasBoardRepository.save((Object)boardToBeDeleted);
        return 1;
    }

    public int deleteSessionCollaborationBoard(String id) {
        CanvasBoard boardToBeDeleted = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)boardToBeDeleted)) {
            boardToBeDeleted.setRowStatus(-1);
        }
        this.canvasBoardRepository.save((Object)boardToBeDeleted);
        return 1;
    }

    public int removeFolder(String id, String parentFolderId) {
        CanvasFolder parentCanvasFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)parentFolderId));
        CanvasFolder canvasFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)id));
        CanvasFolder removingFolder = new CanvasFolder();
        if (PropertyValidator.isValid((Collection)parentCanvasFolder.getCanvasFolder())) {
            for (CanvasFolder folder : parentCanvasFolder.getCanvasFolder()) {
                if (!folder.getId().equals(id)) continue;
                removingFolder = folder;
            }
        }
        parentCanvasFolder.getCanvasFolder().remove(removingFolder);
        canvasFolder.setRowStatus(-1);
        this.canvasFolderRepository.save((Object)canvasFolder);
        try {
            return 1;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return 0;
        }
    }

    public int removeNode(HashMap<String, Object> params) {
        int result = this.graphRepository.removeNode(params);
        return result;
    }

    public int removeLink(HashMap<String, Object> params) {
        int result = this.graphRepository.removeLink(params);
        return result;
    }

    public CanvasBoard markBoardFavorite(Map data) {
        CanvasBoard board2;
        String uid = data.get("uid").toString();
        String boardId = data.get("boardId").toString();
        Boolean starred = (Boolean)data.get("starred");
        CanvasBoardPreferences savedBoardPreference = null;
        CanvasBoardPreferences board = this.canvasBoardPreferencesRepository.findByUserIdAndBoardId(uid, boardId);
        if (!PropertyValidator.isValid((Object)board)) {
            CanvasBoardPreferences newBoard = new CanvasBoardPreferences();
            newBoard.setBoardId(boardId);
            newBoard.setUserId(uid);
            newBoard.setStarred(starred);
            savedBoardPreference = (CanvasBoardPreferences)this.canvasBoardPreferencesRepository.save((Object)newBoard);
        }
        if (PropertyValidator.isValid((Object)board)) {
            board.setStarred(starred);
            savedBoardPreference = (CanvasBoardPreferences)this.canvasBoardPreferencesRepository.save((Object)board);
        }
        if (PropertyValidator.isValid((Object)(board2 = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId))))) {
            board2.setFavorite(starred);
        }
        return board2;
    }

    public CanvasBoard lockUnlockBoard(String boardId) {
        CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
        if (board != null) {
            board.setLocked(Boolean.valueOf(board.getLocked() == false));
        }
        CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)board);
        return savedBoard;
    }

    public CanvasBoard archiveUnarchiveBoard(String boardId) {
        CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
        if (board != null) {
            board.setArchived(Boolean.valueOf(board.getArchived() == false));
        }
        CanvasBoard savedBoard = (CanvasBoard)this.canvasBoardRepository.save((Object)board);
        return savedBoard;
    }

    public CanvasBoard duplicateBoard(Map board) {
        try {
            String boardIdToBeCopied = (String)board.get("boardIdToBeCopied");
            String folderId = (String)board.get("folderId");
            CanvasBoard existingCanvasBoard = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardIdToBeCopied));
            CanvasFolder canvasFolder = null;
            if (PropertyValidator.isValid((Object)folderId)) {
                canvasFolder = (CanvasFolder)this.canvasFolderRepository.findOne((Serializable)((Object)folderId));
            }
            String title = board.get("title").toString();
            String sessionId = (String)board.get("sessionId");
            String solutionBoardId = (String)board.get("solutionBoardId");
            String workSpaceId = (String)board.get("workSpaceId");
            CanvasBoard newCopiedBoard = null;
            List<CanvasBoard> boardsList = new ArrayList<CanvasBoard>();
            ArrayList allboards = new ArrayList();
            if (PropertyValidator.isValid((Object)existingCanvasBoard)) {
                boolean alreadyExists;
                newCopiedBoard = new CanvasBoard();
                newCopiedBoard.setTitle(title);
                if (PropertyValidator.isValid((Object)folderId)) {
                    newCopiedBoard.setFolderId(folderId);
                }
                Query query = new Query();
                if (PropertyValidator.isValid((Object)sessionId)) {
                    Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
                    if (PropertyValidator.isValid((Object)session)) {
                        ArrayList<Session> sessions = new ArrayList<Session>(existingCanvasBoard.getSession());
                        alreadyExists = sessions.stream().anyMatch(s -> s.getId().equals(session.getId()));
                        if (!alreadyExists) {
                            sessions.add(session);
                        }
                        newCopiedBoard.setSession(sessions);
                        newCopiedBoard.setWorkSpaces(existingCanvasBoard.getWorkSpaces());
                        newCopiedBoard.setSolutionBoard(existingCanvasBoard.getSolutionBoard());
                    }
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").is((Object)"general").and("defaultOrigin").is((Object)"session"));
                } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
                    SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionBoardId);
                    if (PropertyValidator.isValid((Object)solutionBoard)) {
                        ArrayList<SolutionBoard> solutionBoards = new ArrayList<SolutionBoard>(existingCanvasBoard.getSolutionBoard());
                        alreadyExists = solutionBoards.stream().anyMatch(sb -> sb.getId().equals(solutionBoard.getId()));
                        if (!alreadyExists) {
                            solutionBoards.add(solutionBoard);
                        }
                        newCopiedBoard.setSolutionBoard(solutionBoards);
                        newCopiedBoard.setSession(existingCanvasBoard.getSession());
                        newCopiedBoard.setWorkSpaces(existingCanvasBoard.getWorkSpaces());
                    }
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").is((Object)"general").and("defaultOrigin").is((Object)"solution"));
                } else if (PropertyValidator.isValid((Object)workSpaceId)) {
                    WorkSpace workSpace = this.workSpaceRepository.findById(workSpaceId);
                    if (PropertyValidator.isValid((Object)workSpace)) {
                        ArrayList<WorkSpace> workSpaces = new ArrayList<WorkSpace>(existingCanvasBoard.getWorkSpaces());
                        alreadyExists = workSpaces.stream().anyMatch(ws -> ws.getId().equals(workSpace.getId()));
                        if (!alreadyExists) {
                            workSpaces.add(workSpace);
                        }
                        newCopiedBoard.setSession(existingCanvasBoard.getSession());
                        newCopiedBoard.setSolutionBoard(existingCanvasBoard.getSolutionBoard());
                        newCopiedBoard.setWorkSpaces(workSpaces);
                    }
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").is((Object)"general").and("defaultOrigin").is((Object)"workspace"));
                }
                CollaborationType collaborationType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
                newCopiedBoard.setCollaborationType(collaborationType);
                newCopiedBoard.setFavorite(existingCanvasBoard.getFavorite());
                newCopiedBoard.setArchived(existingCanvasBoard.getArchived());
                newCopiedBoard.setLocked(existingCanvasBoard.getLocked());
                newCopiedBoard.setBackgroundColor(existingCanvasBoard.getBackgroundColor());
                newCopiedBoard.setBackgroundPattern(existingCanvasBoard.getBackgroundPattern());
                newCopiedBoard.setPiInspectAndAdapt(existingCanvasBoard.getPiInspectAndAdapt());
                newCopiedBoard.setPiTeamArea(existingCanvasBoard.getPiTeamArea());
                newCopiedBoard.setDescription(existingCanvasBoard.getDescription());
                newCopiedBoard.setContext(existingCanvasBoard.getContext());
            }
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
            collaboratorsList.add(collaborator);
            newCopiedBoard.setCollaborators(collaboratorsList);
            this.canvasBoardRepository.save((Object)newCopiedBoard);
            List nodes = this.graphRepository.findNodesByBoradId(existingCanvasBoard.getId(), null);
            List links = this.graphRepository.findLinksByBoardId(existingCanvasBoard.getId(), null);
            if (PropertyValidator.isValid((Collection)nodes)) {
                for (int i = 0; i < nodes.size(); ++i) {
                    ((Map)nodes.get(i)).put("boardId", newCopiedBoard.getId());
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", newCopiedBoard.getId());
                params.put("items", nodes);
                this.saveNode(params);
            }
            if (PropertyValidator.isValid((Collection)links)) {
                for (int i = 0; i < links.size(); ++i) {
                    ((Map)links.get(i)).put("boardId", newCopiedBoard.getId());
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", newCopiedBoard.getId());
                params.put("items", links);
                this.saveLink(params);
            }
            if (PropertyValidator.isValid((Object)canvasFolder)) {
                if (!PropertyValidator.isValid((Collection)canvasFolder.getCanvasBoard())) {
                    boardsList.add(newCopiedBoard);
                } else {
                    boardsList = canvasFolder.getCanvasBoard();
                    boardsList.add(newCopiedBoard);
                }
                allboards.addAll(boardsList);
                canvasFolder.setCanvasBoard(allboards);
                this.canvasFolderRepository.save((Object)canvasFolder);
            } else {
                boardsList.add(newCopiedBoard);
            }
            return newCopiedBoard;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public CanvasBoard duplicateTemplate(Map template) {
        try {
            CanvasBoard existingTemplate = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)template.get("boardIdToBeCopied").toString()));
            String title = template.get("title").toString();
            CanvasBoard newCopiedTemplate = null;
            if (PropertyValidator.isValid((Object)existingTemplate)) {
                newCopiedTemplate = new CanvasBoard();
                newCopiedTemplate.setTitle(title);
                newCopiedTemplate.setType("template");
                newCopiedTemplate.setIsSystem(Boolean.valueOf(false));
                newCopiedTemplate.setFolderId("template");
                newCopiedTemplate.setFavorite(existingTemplate.getFavorite());
                newCopiedTemplate.setArchived(existingTemplate.getArchived());
                newCopiedTemplate.setLocked(existingTemplate.getLocked());
                newCopiedTemplate.setBackgroundColor(existingTemplate.getBackgroundColor());
                newCopiedTemplate.setBackgroundPattern(existingTemplate.getBackgroundPattern());
            }
            Collaborator collaborator = new Collaborator();
            collaborator.setAccess("3");
            collaborator.setAdmin(Boolean.valueOf(true));
            collaborator.setUser(UserContextUtil.getUserContext().getLoggedInUser());
            ArrayList<Collaborator> collaboratorsList = new ArrayList<Collaborator>();
            collaboratorsList.add(collaborator);
            newCopiedTemplate.setCollaborators(collaboratorsList);
            this.canvasBoardRepository.save((Object)newCopiedTemplate);
            List nodes = this.graphRepository.findNodesByBoradId(existingTemplate.getId(), null);
            List links = this.graphRepository.findLinksByBoardId(existingTemplate.getId(), null);
            if (PropertyValidator.isValid((Collection)nodes)) {
                for (int i = 0; i < nodes.size(); ++i) {
                    ((Map)nodes.get(i)).put("boardId", newCopiedTemplate.getId());
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", newCopiedTemplate.getId());
                params.put("items", nodes);
                this.saveNode(params);
            }
            if (PropertyValidator.isValid((Collection)links)) {
                for (int i = 0; i < links.size(); ++i) {
                    ((Map)links.get(i)).put("boardId", newCopiedTemplate.getId());
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("boardId", newCopiedTemplate.getId());
                params.put("items", links);
                this.saveLink(params);
            }
            return newCopiedTemplate;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public User getLoggedInUser() {
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            User user = UserContextUtil.getUserContext().getLoggedInUser();
            return user;
        }
        return null;
    }

    public List<WorkSpaceAccessRole> getLoggedInUserAccessRoles() {
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            User user = UserContextUtil.getUserContext().getLoggedInUser();
            List workSpaceAccessRoles = this.workSpaceAccessRoleRepository.findByUser(user);
            return workSpaceAccessRoles;
        }
        return null;
    }

    public int removeTemplate(String id) {
        HashMap<String, Object> params;
        List nodes = this.graphRepository.findNodesByBoradId(id, null);
        List links = this.graphRepository.findLinksByBoardId(id, null);
        if (PropertyValidator.isValid((Collection)nodes)) {
            params = new HashMap<String, Object>();
            params.put("boardId", id);
            params.put("items", nodes);
            this.graphRepository.removeNode(params);
        }
        if (PropertyValidator.isValid((Collection)links)) {
            params = new HashMap();
            params.put("boardId", id);
            params.put("items", links);
            this.graphRepository.removeLink(params);
        }
        this.canvasBoardRepository.delete((Serializable)((Object)id));
        return 1;
    }

    public CanvasNote saveNote(Map data) {
        String boardId = data.get("id").toString();
        CanvasNote savedNote = null;
        CanvasNote note = this.canvasNoteRepository.findByBoardId(boardId);
        if (PropertyValidator.isValid((Object)note)) {
            note.setDescription((String)data.get("description"));
            savedNote = (CanvasNote)this.canvasNoteRepository.save((Object)note);
        } else {
            CanvasNote canvasNote = new CanvasNote();
            canvasNote.setBoardId(boardId);
            canvasNote.setDescription((String)data.get("description"));
            savedNote = (CanvasNote)this.canvasNoteRepository.save((Object)canvasNote);
        }
        return savedNote;
    }

    public CanvasNote getNote(String boardId) {
        CanvasNote note = this.canvasNoteRepository.findByBoardId(boardId);
        return note;
    }

    public List<PublicLinks> generateShareBoardToken(String boardId, int code, String value, String params) {
        CanvasBoard board = (CanvasBoard)this.canvasBoardRepository.findOne((Serializable)((Object)boardId));
        String token = UUID.randomUUID().toString();
        if (PropertyValidator.isValid((Object)board)) {
            if (!PropertyValidator.isValid((Collection)board.getPublicLinks())) {
                ArrayList<PublicLinks> list = new ArrayList<PublicLinks>();
                PublicLinks publicLink = new PublicLinks(token, EnumShareBoard.getEnumByCode((int)code).getCode());
                list.add(publicLink);
                board.setPublicLinks(list);
                this.createServerCache(token, params);
            } else if (value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                PublicLinks publicLink = new PublicLinks(token, EnumShareBoard.getEnumByCode((int)code).getCode());
                board.getPublicLinks().add(publicLink);
                this.createServerCache(token, params);
            } else {
                PublicLinks linkToRemove = null;
                for (PublicLinks publicLink : board.getPublicLinks()) {
                    if (publicLink.getAccessLevel() != EnumShareBoard.getEnumByCode((int)code).getCode()) continue;
                    linkToRemove = publicLink;
                    break;
                }
                if (PropertyValidator.isValid(linkToRemove)) {
                    ServerCache serverCache = this.serverCacheRepository.findByKey(linkToRemove.getToken());
                    if (PropertyValidator.isValid((Object)serverCache)) {
                        this.serverCacheRepository.deleteByKey(linkToRemove.getToken());
                    }
                    board.getPublicLinks().remove(linkToRemove);
                }
            }
            this.canvasBoardRepository.save((Object)board);
            return board.getPublicLinks();
        }
        return null;
    }

    void createServerCache(String token, String params) {
        ServerCache serverCache = new ServerCache();
        serverCache.setKey(token);
        serverCache.setValue(params);
        serverCache.setTime(new Date());
        this.serverCacheRepository.save((Object)serverCache);
    }

    public Map<String, Integer> getBoardCountByContext(String id, Map payload) {
        HashMap<String, Integer> boardCounts = new HashMap<String, Integer>();
        String context = (String)payload.get("context");
        try {
            boolean isSessionBoard = "sessionBoard".equals(context);
            boolean isSession = "session".equals(context);
            if (isSession || isSessionBoard) {
                List teams;
                Session session;
                if (isSessionBoard && PropertyValidator.isValid((Object)(session = this.sessionRepository.findByActiveSessionBoard(id)))) {
                    id = session.getId();
                }
                if ((teams = this.getTeamsForSession(id)) != null && !teams.isEmpty()) {
                    for (Team team : teams) {
                        int count = this.countCollaborationBoardsForTeam(id, team.getId());
                        boardCounts.put(team.getId(), count);
                    }
                }
                int generalCount = this.countCollaborationBoardsForGeneral(id);
                boardCounts.put("general", generalCount);
                int inspectCount = this.countCollaborationBoardsForInspect(id);
                boardCounts.put("inspect", inspectCount);
                Map customTypeCounts = this.countCollaborationBoardsForCustomTypes(id);
                boardCounts.putAll(customTypeCounts);
            } else if ("solution".equals(context)) {
                List sessions = this.getSessionsForSolutionBoard(id);
                if (sessions != null && !sessions.isEmpty()) {
                    for (Session session : sessions) {
                        int count = this.countCollaborationBoardsForSession(session.getId(), id);
                        boardCounts.put(session.getId(), count);
                    }
                }
                int generalCount = this.countCollaborationBoardsForGeneralInSolution(id);
                boardCounts.put("general", generalCount);
                Map customTypeCounts = this.countCollaborationBoardsForCustomTypesInSolution(id);
                boardCounts.putAll(customTypeCounts);
            } else if ("workspace".equals(context)) {
                int count;
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)id));
                WorkSpace workSpace = (WorkSpace)this.mongoTemplate.findOne(query, WorkSpace.class);
                Map response = this.releaseTrainServiceImpl.getReleaseSolutionBoardsAndPiBoards(workSpace.getId());
                List programBoards = (List)response.get("sessions");
                List solutionBoards = (List)response.get("solutionBoards");
                if (programBoards != null && !programBoards.isEmpty()) {
                    for (Session session : programBoards) {
                        count = this.countCollaborationBoardsForWorkspacePiBoard(session.getId(), workSpace);
                        boardCounts.put(session.getId(), count);
                    }
                }
                if (solutionBoards != null && !solutionBoards.isEmpty()) {
                    for (SolutionBoard solutionBoard : solutionBoards) {
                        count = this.countCollaborationBoardsForWorkspaceSolutionBoard(solutionBoard.getId(), workSpace);
                        boardCounts.put(solutionBoard.getId(), count);
                    }
                }
                int generalCount = this.countCollaborationBoardsForGeneralInWorkspace(workSpace);
                boardCounts.put("general", generalCount);
                Map customTypeCounts = this.countCollaborationBoardsForCustomTypesInWorkspace(workSpace);
                boardCounts.putAll(customTypeCounts);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting board counts for context: {} and id: {}", new Object[]{context, id, e});
        }
        return boardCounts;
    }

    private List<Team> getTeamsForSession(String sessionId) {
        try {
            Query sessionBoardQuery = new Query((CriteriaDefinition)Criteria.where((String)"session.$id").is((Object)new ObjectId(sessionId)));
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(sessionBoardQuery, SessionBoard.class);
            if (sessionBoard != null && sessionBoard.getTeams() != null) {
                return sessionBoard.getTeams();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching teams for session: {}", (Object)sessionId, (Object)e);
        }
        return new ArrayList<Team>();
    }

    private int countCollaborationBoardsForTeam(String sessionId, String teamId) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            this.addDefaultSessionBoardCriteria(sessionId, teamId, "session", criteriaList, "sessionTeam", sessionId);
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for team: {} in session: {}", new Object[]{teamId, sessionId, e});
            return 0;
        }
    }

    private List<Session> getSessionsForSolutionBoard(String solutionId) {
        try {
            SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionId);
            if (solutionBoard != null && solutionBoard.getPiSessions() != null && !solutionBoard.getPiSessions().isEmpty()) {
                List sessionObjectIds = solutionBoard.getPiSessions().stream().map(sessionId -> new ObjectId(sessionId)).collect(Collectors.toList());
                Query sessionQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(sessionObjectIds));
                return this.mongoTemplate.find(sessionQuery, Session.class);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching sessions for solution board: {}", (Object)solutionId, (Object)e);
        }
        return new ArrayList<Session>();
    }

    private int countCollaborationBoardsForSession(String sessionId, String solutionId) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            Query solutionPiBoardTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"solutionPiBoard"), Criteria.where((String)"sessions").is((Object)sessionId), Criteria.where((String)"solutionBoards").is((Object)solutionId)}));
            List solutionPiBoardTypes = this.mongoTemplate.find(solutionPiBoardTypeQuery, CollaborationType.class);
            List solutionPiBoardTypeIds = solutionPiBoardTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            ArrayList<Criteria> sessionCriteria = new ArrayList<Criteria>();
            sessionCriteria.add(Criteria.where((String)"sessions.$id").is((Object)new ObjectId(sessionId)));
            if (!solutionPiBoardTypeIds.isEmpty()) {
                sessionCriteria.add(Criteria.where((String)"collaborationType").in(solutionPiBoardTypeIds));
            }
            criteriaList.add(new Criteria().orOperator(sessionCriteria.toArray(new Criteria[0])));
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for session: {} and solution: {}", new Object[]{sessionId, solutionId, e});
            return 0;
        }
    }

    private int countCollaborationBoardsForWorkspacePiBoard(String sessionId, WorkSpace workSpace) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            Query workspacePiBoardTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"defaultOrigin").is((Object)"workspacePiBoard"), Criteria.where((String)"sessions").in(new Object[]{sessionId}), Criteria.where((String)"workSpaces").in(new Object[]{workSpace.getId()})}));
            List workspacePiBoardTypes = this.mongoTemplate.find(workspacePiBoardTypeQuery, CollaborationType.class);
            List workspacePiBoardTypeIds = workspacePiBoardTypes.stream().map(BaseEntity::getId).collect(Collectors.toList());
            ArrayList<Criteria> sessionCriteria = new ArrayList<Criteria>();
            sessionCriteria.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"sessions.$id").is((Object)new ObjectId(sessionId)), Criteria.where((String)"workSpaces.$id").is((Object)new ObjectId(workSpace.getId()))}));
            if (!workspacePiBoardTypeIds.isEmpty()) {
                sessionCriteria.add(Criteria.where((String)"collaborationType").in(workspacePiBoardTypeIds));
            }
            criteriaList.add(new Criteria().orOperator(sessionCriteria.toArray(new Criteria[0])));
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for workspace PI board: {} in workspace: {}", new Object[]{sessionId, workSpace.getId(), e});
            return 0;
        }
    }

    private int countCollaborationBoardsForWorkspaceSolutionBoard(String solutionBoardId, WorkSpace workSpace) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            this.addDefaultCollectionsCriteria(workSpace.getId(), solutionBoardId, "workspace", criteriaList, workSpace, workSpace.getId(), "workspaceSolutionBoard");
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for workspace solution board: {} in workspace: {}", new Object[]{solutionBoardId, workSpace.getId(), e});
            return 0;
        }
    }

    private int countCollaborationBoardsForGeneral(String sessionId) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            this.addDefaultSessionBoardCriteria(sessionId, "general", "session", criteriaList, "session", sessionId);
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for general type in session: {}", (Object)sessionId, (Object)e);
            return 0;
        }
    }

    private int countCollaborationBoardsForInspect(String sessionId) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            this.addDefaultSessionBoardCriteria(sessionId, "inspect", "session", criteriaList, "sessionInspect", sessionId);
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for inspect type in session: {}", (Object)sessionId, (Object)e);
            return 0;
        }
    }

    private Map<String, Integer> countCollaborationBoardsForCustomTypes(String sessionId) {
        HashMap<String, Integer> customTypeCounts = new HashMap<String, Integer>();
        try {
            Query customTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"sessions").in(new Object[]{sessionId}), Criteria.where((String)"defaultOrigin").is(null), Criteria.where((String)"rowStatus").is((Object)0)}));
            List customTypes = this.mongoTemplate.find(customTypeQuery, CollaborationType.class);
            for (CollaborationType customType : customTypes) {
                try {
                    ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
                    criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
                    criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
                    criteriaList.add(Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(customType.getId())));
                    criteriaList.add(Criteria.where((String)"sessions").in(new Object[]{sessionId}));
                    Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
                    Query query = new Query((CriteriaDefinition)combined);
                    int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
                    customTypeCounts.put(customType.getId(), count);
                }
                catch (Exception e) {
                    LOGGER.error("Error counting collaboration boards for custom type: {} in session: {}", new Object[]{customType.getId(), sessionId, e});
                    customTypeCounts.put(customType.getId(), 0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching custom types for session: {}", (Object)sessionId, (Object)e);
        }
        return customTypeCounts;
    }

    private int countCollaborationBoardsForGeneralInSolution(String solutionBoardId) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            this.addDefaultSolutionBoardCriteria(solutionBoardId, "general", "solution", criteriaList, "solution");
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for general type in solution: {}", (Object)solutionBoardId, (Object)e);
            return 0;
        }
    }

    private Map<String, Integer> countCollaborationBoardsForCustomTypesInSolution(String solutionBoardId) {
        HashMap<String, Integer> customTypeCounts = new HashMap<String, Integer>();
        try {
            Query customTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"solutionBoards").in(new Object[]{solutionBoardId}), Criteria.where((String)"defaultOrigin").is(null), Criteria.where((String)"rowStatus").is((Object)0)}));
            List customTypes = this.mongoTemplate.find(customTypeQuery, CollaborationType.class);
            for (CollaborationType customType : customTypes) {
                try {
                    ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
                    criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
                    criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
                    criteriaList.add(Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(customType.getId())));
                    criteriaList.add(Criteria.where((String)"solutionBoards").in(new Object[]{solutionBoardId}));
                    Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
                    Query query = new Query((CriteriaDefinition)combined);
                    int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
                    customTypeCounts.put(customType.getId(), count);
                }
                catch (Exception e) {
                    LOGGER.error("Error counting collaboration boards for custom type: {} in solution: {}", new Object[]{customType.getId(), solutionBoardId, e});
                    customTypeCounts.put(customType.getId(), 0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching custom types for solution: {}", (Object)solutionBoardId, (Object)e);
        }
        return customTypeCounts;
    }

    private int countCollaborationBoardsForGeneralInWorkspace(WorkSpace workSpace) {
        try {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
            criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
            this.addDefaultCollectionsCriteria(workSpace.getKey(), "general", "workspace", criteriaList, workSpace, workSpace.getId(), "workspace");
            Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)combined);
            int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
            return count;
        }
        catch (Exception e) {
            LOGGER.error("Error counting collaboration boards for general type in workspace: {}", (Object)workSpace.getId(), (Object)e);
            return 0;
        }
    }

    private Map<String, Integer> countCollaborationBoardsForCustomTypesInWorkspace(WorkSpace workSpace) {
        HashMap<String, Integer> customTypeCounts = new HashMap<String, Integer>();
        try {
            Query customTypeQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"workSpaces").in(new Object[]{workSpace.getId()}), Criteria.where((String)"defaultOrigin").is(null), Criteria.where((String)"rowStatus").is((Object)0)}));
            List customTypes = this.mongoTemplate.find(customTypeQuery, CollaborationType.class);
            for (CollaborationType customType : customTypes) {
                try {
                    ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
                    criteriaList.add(Criteria.where((String)"rowStatus").ne((Object)-1));
                    criteriaList.add(Criteria.where((String)"archived").ne((Object)true));
                    criteriaList.add(Criteria.where((String)"collaborationType.$id").is((Object)new ObjectId(customType.getId())));
                    criteriaList.add(Criteria.where((String)"workSpaces").in(new Object[]{workSpace.getId()}));
                    Criteria combined = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
                    Query query = new Query((CriteriaDefinition)combined);
                    int count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
                    customTypeCounts.put(customType.getId(), count);
                }
                catch (Exception e) {
                    LOGGER.error("Error counting collaboration boards for custom type: {} in workspace: {}", new Object[]{customType.getId(), workSpace.getId(), e});
                    customTypeCounts.put(customType.getId(), 0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching custom types for workspace: {}", (Object)workSpace.getId(), (Object)e);
        }
        return customTypeCounts;
    }

    public Map<String, Object> getAllTemplatesForContext(String contextId, String context) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList allTemplates = new ArrayList();
        Map templateCount = new HashMap();
        templateCount = "session".equals(context) ? this.getTemplateCountsForSessionContext(contextId) : ("solution".equals(context) ? this.getTemplateCountsForSolutionContext(contextId) : this.getTemplateCountsForWorkspaceContext(contextId));
        allTemplates.addAll(this.getSystemTemplates());
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("context", context);
        List collaborationTypes = this.collaborationTypeService.getAllTypes(contextId, payload);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
        if ("session".equals(context)) {
            this.getTemplatesRelatedToSessionContext(contextId, query, allTemplates);
        } else if ("solution".equals(context)) {
            this.getTemplatesRelatedToSolutionContext(contextId, query, allTemplates);
        } else if ("workspace".equals(context)) {
            this.getTemplatesRelatedToWorkspaceContext(contextId, query, allTemplates);
        }
        if (!collaborationTypes.isEmpty()) {
            List collaborationTypeIds = collaborationTypes.stream().map(collabType -> new ObjectId(collabType.getId())).collect(Collectors.toList());
            Query collabTypeQuery = new Query();
            collabTypeQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
            collabTypeQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"collaborationType.$id").in(collaborationTypeIds));
            List collabTypeTemplates = this.mongoTemplate.find(collabTypeQuery, CanvasBoard.class);
            allTemplates.addAll(collabTypeTemplates);
        }
        response.put("success", true);
        response.put("templates", new ArrayList(allTemplates));
        response.put("templateCount", templateCount);
        return response;
    }

    private void getTemplatesRelatedToSessionContext(String contextId, Query query, List<CanvasBoard> allTemplates) throws Exception {
        Session session = this.sessionRepository.findById(contextId);
        SessionBoard sessionBoard = this.sessionBoardRepository.findOneBySessionId(session.getId());
        List<Object> teamIds = new ArrayList();
        if (sessionBoard != null && sessionBoard.getTeams() != null) {
            teamIds = sessionBoard.getTeams().stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        if (!teamIds.isEmpty()) {
            List<Criteria> teamConditions = teamIds.stream().map(teamId -> Criteria.where((String)("piTeamArea." + contextId)).is(teamId)).collect(Collectors.toList());
            Criteria teamCriteria = new Criteria().orOperator(teamConditions.toArray(new Criteria[0]));
            query.addCriteria((CriteriaDefinition)teamCriteria);
            List directTemplates = this.mongoTemplate.find(query, CanvasBoard.class);
            allTemplates.addAll(directTemplates);
        }
    }

    public Map<String, Integer> getTemplateCountsForSessionContext(String contextId) throws Exception {
        HashMap<String, Integer> allCounts = new HashMap<String, Integer>();
        SessionBoard sessionBoard = null;
        Session session = this.sessionRepository.findById(contextId);
        if (PropertyValidator.isValid((Object)session)) {
            sessionBoard = this.sessionBoardRepository.findOneBySessionId(session.getId());
        } else {
            sessionBoard = this.sessionBoardRepository.findById(contextId);
            contextId = sessionBoard.getSession().getId();
        }
        List<Object> teamIds = new ArrayList();
        if (sessionBoard != null && sessionBoard.getTeams() != null) {
            teamIds = sessionBoard.getTeams().stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("context", "session");
        List collaborationTypes = this.collaborationTypeService.getAllTypes(contextId, payload);
        if (!teamIds.isEmpty()) {
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)("piTeamArea." + contextId)).in(teamIds)), Aggregation.unwind((String)("piTeamArea." + contextId)), Aggregation.group((String[])new String[]{"piTeamArea." + contextId}).count().as("count"), Aggregation.project((String[])new String[]{"count"}).and("_id").as("teamId")});
            List teamCountResults = this.mongoTemplate.aggregate(aggregation, "canvasBoard", Map.class).getMappedResults();
            for (Map teamResult : teamCountResults) {
                String teamId = (String)teamResult.get("teamId");
                Integer count = (Integer)teamResult.get("count");
                if (!PropertyValidator.isValid((Object)teamId)) continue;
                allCounts.put(teamId, count);
            }
        }
        Map typeCounts = this.countTemplatesForCollaborationTypes(collaborationTypes, "Session");
        allCounts.putAll(typeCounts);
        int allTemplatesCount = this.getAllTemplatesCountForContext(contextId, "session");
        allCounts.put("allTemplates", allTemplatesCount);
        return allCounts;
    }

    public Map<String, Integer> getTemplateCountsForSolutionContext(String contextId) throws Exception {
        HashMap<String, Integer> allCounts = new HashMap<String, Integer>();
        Map typeCounts = new HashMap();
        HashMap<String, Integer> sessionCounts = new HashMap<String, Integer>();
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(contextId);
        if (solutionBoard != null) {
            List sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions());
            List sessionObjectIds = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("context", "solution");
            List collaborationTypes = this.collaborationTypeService.getAllTypes(contextId, payload);
            if (!sessions.isEmpty()) {
                for (Session session2 : sessions) {
                    if (!PropertyValidator.isValid((Object)session2.getId())) continue;
                    int count = this.countTemplatesForSolutionSession(session2.getId(), contextId);
                    sessionCounts.put(session2.getId(), count);
                }
            }
            typeCounts = this.countTemplatesForCollaborationTypes(collaborationTypes, "Solution");
        }
        allCounts.putAll(typeCounts);
        allCounts.putAll(sessionCounts);
        int allTemplatesCount = this.getAllTemplatesCountForContext(contextId, "solution");
        allCounts.put("allTemplates", allTemplatesCount);
        return allCounts;
    }

    private void getTemplatesRelatedToSolutionContext(String contextId, Query query, List<CanvasBoard> allTemplates) throws Exception {
        List sessions;
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(contextId);
        if (solutionBoard != null && !(sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions())).isEmpty()) {
            List sessionObjectIds = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions.$id").in(sessionObjectIds));
            List directTemplates = this.mongoTemplate.find(query, CanvasBoard.class);
            allTemplates.addAll(directTemplates);
        }
    }

    public Map<String, Integer> getTemplateCountsForWorkspaceContext(String contextId) throws Exception {
        HashMap<String, Integer> allCounts = new HashMap<String, Integer>();
        Map typeCounts = new HashMap();
        HashMap<String, Integer> sessionCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> solutionBoardCounts = new HashMap<String, Integer>();
        WorkSpace workSpace = this.workSpaceRepository.findByKey(contextId);
        if (workSpace != null) {
            List solutionBoards;
            Map workspaceData = this.releaseTrainServiceImpl.getReleaseSolutionBoardsAndPiBoards(contextId);
            List<Object> sessionObjectIds = new ArrayList();
            List<Object> solutionBoardObjectIds = new ArrayList();
            List sessions = (List)workspaceData.get("sessions");
            if (sessions != null) {
                sessionObjectIds = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            }
            if ((solutionBoards = (List)workspaceData.get("solutionBoards")) != null) {
                solutionBoardObjectIds = solutionBoards.stream().map(solutionBoard -> new ObjectId(solutionBoard.getId())).collect(Collectors.toList());
            }
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("context", "workspace");
            List collaborationTypes = this.collaborationTypeService.getAllTypes(contextId, payload);
            if (!sessionObjectIds.isEmpty() || !solutionBoardObjectIds.isEmpty()) {
                int count;
                if (!sessions.isEmpty()) {
                    for (Session session2 : sessions) {
                        if (!PropertyValidator.isValid((Object)session2.getId())) continue;
                        count = this.countTemplatesForWorkspaceSession(session2.getId());
                        sessionCounts.put(session2.getId(), count);
                    }
                }
                if (!solutionBoards.isEmpty()) {
                    for (SolutionBoard solutionBoard2 : solutionBoards) {
                        if (!PropertyValidator.isValid((Object)solutionBoard2.getId())) continue;
                        count = this.countTemplatesForWorkspaceSolutionBoard(solutionBoard2.getId());
                        solutionBoardCounts.put(solutionBoard2.getId(), count);
                    }
                }
            }
            typeCounts = this.countTemplatesForCollaborationTypes(collaborationTypes, "Workspace");
        }
        allCounts.putAll(typeCounts);
        allCounts.putAll(sessionCounts);
        allCounts.putAll(solutionBoardCounts);
        int allTemplatesCount = this.getAllTemplatesCountForContext(contextId, "workspace");
        allCounts.put("allTemplates", allTemplatesCount);
        return allCounts;
    }

    public int getAllTemplatesCountForContext(String contextId, String context) throws Exception {
        int totalCount = 0;
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("context", context);
        List collaborationTypes = this.collaborationTypeService.getAllTypes(contextId, payload);
        if ("session".equals(context)) {
            totalCount += this.getTemplatesCountForSessionContext(contextId);
        } else if ("solution".equals(context)) {
            totalCount += this.getTemplatesCountForSolutionContext(contextId);
        } else if ("workspace".equals(context)) {
            totalCount += this.getTemplatesCountForWorkspaceContext(contextId);
        }
        if (!collaborationTypes.isEmpty()) {
            List collaborationTypeIds = collaborationTypes.stream().map(collabType -> new ObjectId(collabType.getId())).collect(Collectors.toList());
            Query collabTypeQuery = new Query();
            collabTypeQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
            collabTypeQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"collaborationType.$id").in(collaborationTypeIds));
            long collabTypeCount = this.mongoTemplate.count(collabTypeQuery, CanvasBoard.class);
            totalCount += (int)collabTypeCount;
        }
        return totalCount;
    }

    private int getTemplatesCountForSessionContext(String contextId) throws Exception {
        int count = 0;
        Session session = this.sessionRepository.findById(contextId);
        SessionBoard sessionBoard = this.sessionBoardRepository.findOneBySessionId(session.getId());
        List<Object> teamIds = new ArrayList();
        if (sessionBoard != null && sessionBoard.getTeams() != null) {
            teamIds = sessionBoard.getTeams().stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        if (!teamIds.isEmpty()) {
            List<Criteria> teamConditions = teamIds.stream().map(teamId -> Criteria.where((String)("piTeamArea." + contextId)).is(teamId)).collect(Collectors.toList());
            Criteria teamCriteria = new Criteria().orOperator(teamConditions.toArray(new Criteria[0]));
            Query query = new Query((CriteriaDefinition)teamCriteria);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
            count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
        }
        return count;
    }

    private int getTemplatesCountForSolutionContext(String contextId) throws Exception {
        List sessions;
        int count = 0;
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(contextId);
        if (solutionBoard != null && !(sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions())).isEmpty()) {
            List sessionObjectIds = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions.$id").in(sessionObjectIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
            count = (int)this.mongoTemplate.count(query, CanvasBoard.class);
        }
        return count;
    }

    private Map<String, Integer> countTemplatesForCollaborationTypes(List<CollaborationType> collaborationTypes, String context) throws Exception {
        HashMap<String, Integer> typeCounts = new HashMap<String, Integer>();
        if (collaborationTypes == null || collaborationTypes.isEmpty()) {
            return typeCounts;
        }
        List collabTypeIds = collaborationTypes.stream().filter(ct -> PropertyValidator.isValid((Object)ct.getId())).map(ct -> new ObjectId(ct.getId())).collect(Collectors.toList());
        if (collabTypeIds.isEmpty()) {
            return typeCounts;
        }
        MatchOperation matchStage = Aggregation.match((Criteria)Criteria.where((String)"type").is((Object)"template").and("collaborationType.$id").in(collabTypeIds));
        GroupOperation groupStage = Aggregation.group((String[])new String[]{"collaborationType"}).count().as("count");
        AggregationOperation projectStage = context1 -> {
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"collaborationTypeId", (Object)"$_id.$id");
            fields.put((Object)"count", (Object)1);
            return new BasicDBObject("$project", (Object)fields);
        };
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchStage, groupStage, projectStage});
        List results = this.mongoTemplate.aggregate(aggregation, "canvasBoard", Document.class).getMappedResults();
        for (Document doc : results) {
            ObjectId idObj = doc.getObjectId((Object)"collaborationTypeId");
            if (idObj == null) continue;
            String id = idObj.toHexString();
            int count = doc.getInteger((Object)"count", 0);
            typeCounts.put(id, count);
        }
        return typeCounts;
    }

    private int countTemplatesForWorkspaceSession(String sessionId) throws Exception {
        Query query = new Query();
        long count = 0L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions.$id").is((Object)new ObjectId(sessionId)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
        count = this.mongoTemplate.count(query, CanvasBoard.class);
        return (int)count;
    }

    private int countTemplatesForWorkspaceSolutionBoard(String solutionBoardId) throws Exception {
        Query query = new Query();
        long count = 0L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoards.$id").is((Object)new ObjectId(solutionBoardId)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
        count = this.mongoTemplate.count(query, CanvasBoard.class);
        return (int)count;
    }

    private int countTemplatesForSolutionSession(String sessionId, String solutionBoardId) throws Exception {
        Query query = new Query();
        long count = 0L;
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions.$id").is((Object)new ObjectId(sessionId)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
        count = this.mongoTemplate.count(query, CanvasBoard.class);
        return (int)count;
    }

    private int getTemplatesCountForWorkspaceContext(String contextId) throws Exception {
        int count = 0;
        WorkSpace workSpace = this.workSpaceRepository.findByKey(contextId);
        if (workSpace != null) {
            List solutionBoards;
            Map workspaceData = this.releaseTrainServiceImpl.getReleaseSolutionBoardsAndPiBoards(contextId);
            List<Object> sessionObjectIds = new ArrayList();
            List<Object> solutionBoardObjectIds = new ArrayList();
            List sessions = (List)workspaceData.get("sessions");
            if (sessions != null) {
                sessionObjectIds = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            }
            if ((solutionBoards = (List)workspaceData.get("solutionBoards")) != null) {
                solutionBoardObjectIds = solutionBoards.stream().map(solutionBoard -> new ObjectId(solutionBoard.getId())).collect(Collectors.toList());
            }
            if (!sessionObjectIds.isEmpty()) {
                Query sessionQuery = new Query();
                sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"sessions.$id").in(sessionObjectIds));
                sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
                count += (int)this.mongoTemplate.count(sessionQuery, CanvasBoard.class);
            }
            if (!solutionBoardObjectIds.isEmpty()) {
                Query solutionQuery = new Query();
                solutionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoards.$id").in(solutionBoardObjectIds));
                solutionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"template"));
                count += (int)this.mongoTemplate.count(solutionQuery, CanvasBoard.class);
            }
        }
        return count;
    }

    private void getTemplatesRelatedToWorkspaceContext(String contextId, Query query, List<CanvasBoard> allTemplates) throws Exception {
        WorkSpace workSpace = this.workSpaceRepository.findByKey(contextId);
        if (workSpace != null) {
            List solutionBoards;
            Map workspaceData = null;
            workspaceData = this.releaseTrainServiceImpl.getReleaseSolutionBoardsAndPiBoards(contextId);
            List<Object> sessionObjectIds = new ArrayList();
            List<Object> solutionBoardObjectIds = new ArrayList();
            List sessions = (List)workspaceData.get("sessions");
            if (sessions != null) {
                sessionObjectIds = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            }
            if ((solutionBoards = (List)workspaceData.get("solutionBoards")) != null) {
                solutionBoardObjectIds = solutionBoards.stream().map(solutionBoard -> new ObjectId(solutionBoard.getId())).collect(Collectors.toList());
            }
            if (!sessionObjectIds.isEmpty() || !solutionBoardObjectIds.isEmpty()) {
                Criteria orCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sessions.$id").in(sessionObjectIds), Criteria.where((String)"solutionBoards.$id").in(solutionBoardObjectIds)});
                query.addCriteria((CriteriaDefinition)orCriteria);
                List directTemplates = this.mongoTemplate.find(query, CanvasBoard.class);
                allTemplates.addAll(directTemplates);
            }
        }
    }
}

