/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.google.common.collect.Sets;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumWorkSpaceType;
import com.viztrend.safe.persistence.entity.ActionPoint;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BacklogItemLog;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.Notification;
import com.viztrend.safe.persistence.entity.Scrum;
import com.viztrend.safe.persistence.entity.ScrumOfScrums;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.ActionPointRepository;
import com.viztrend.safe.persistence.repository.BacklogItemLogRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.BoardRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WatcherRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.ObjectiveServiceVO;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.bson.types.ObjectId;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="ExternalEntitiesService")
public class ExternalEntitiesServiceImpl
implements ExternalEntitiesService {
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private WatcherRepository watcherRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private FieldTemplateRepository fieldTemplateRepository;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private BacklogItemLogRepository backlogItemLogRepository;
    @Autowired
    private BoardRepository boardRepository;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalEntitiesServiceImpl.class);
    private CustomRepositoryImpl customRepositoryImpl;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private ActionPointRepository actionPointRepository;

    public Conversation saveConversation(Conversation inputConversation) {
        try {
            HashSet recepientEmails = new HashSet();
            if (!PropertyValidator.isValid((Object)inputConversation.getId())) {
                Conversation savedConversation = (Conversation)this.conversationRepository.save((Object)inputConversation);
                User user = this.userRepository.findBasicUserInfoById(savedConversation.getUser().getId());
                savedConversation.setUser(user);
                return savedConversation;
            }
            Conversation conversation = (Conversation)this.conversationRepository.findOne((Serializable)((Object)inputConversation.getId()));
            conversation.setText(inputConversation.getText());
            Conversation savedConversation = (Conversation)this.conversationRepository.save((Object)conversation);
            return savedConversation;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public Conversation saveEmojiConversation(Conversation inputConversation) throws Exception {
        try {
            Conversation savedEmojiConversation = this.conversationRepository.findByUserAndTextAndConversationTypeAndEntityTypeAndEntityId(inputConversation.getUser(), inputConversation.getText(), inputConversation.getConversationType(), inputConversation.getEntityType(), inputConversation.getEntityId());
            if (PropertyValidator.isValid((Object)savedEmojiConversation)) {
                this.conversationRepository.delete((Serializable)((Object)savedEmojiConversation.getId()));
                savedEmojiConversation = null;
            } else {
                savedEmojiConversation = (Conversation)this.conversationRepository.save((Object)inputConversation);
            }
            return savedEmojiConversation;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            throw e;
        }
    }

    public List<Conversation> fetchConversation(HashMap<String, Object> requestBody) {
        try {
            if (requestBody.get("entityId") instanceof String) {
                String entityId = (String)requestBody.get("entityId");
                String conversationType = (String)requestBody.get("conversationType");
                if (PropertyValidator.isValid((Object)conversationType) && conversationType.equalsIgnoreCase("Emoji")) {
                    List savedConversation = this.conversationRepository.findByEntityTypeAndEntityIdAndConversationType((String)requestBody.get("entityType"), entityId, conversationType);
                    return savedConversation;
                }
                List savedConversation = this.conversationRepository.findByEntityTypeAndEntityIdAndConversationType((String)requestBody.get("entityType"), entityId, null);
                return savedConversation;
            }
            List savedConversation = this.conversationRepository.findByEntityTypeAndEntityIdIn((String)requestBody.get("entityType"), (List)requestBody.get("entityId"));
            return savedConversation;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public Long fetchConversationCount(HashMap<String, Object> requestBody) {
        try {
            if (requestBody.get("entityId") instanceof String) {
                String entityId = (String)requestBody.get("entityId");
                String conversationType = (String)requestBody.get("conversationType");
                if (PropertyValidator.isValid((Object)conversationType) && conversationType.equalsIgnoreCase("Emoji")) {
                    Long savedConversationCount = this.conversationRepository.countByEntityTypeAndEntityIdAndConversationType((String)requestBody.get("entityType"), entityId, conversationType);
                    return savedConversationCount;
                }
                Long savedConversationCount = this.conversationRepository.countByEntityTypeAndEntityIdAndConversationType((String)requestBody.get("entityType"), entityId, null);
                return savedConversationCount;
            }
            Long savedConversationCount = this.conversationRepository.countByEntityTypeAndEntityIdIn((String)requestBody.get("entityType"), (List)requestBody.get("entityId"));
            return savedConversationCount;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public void deleteConversation(String conversationId) {
        try {
            this.conversationRepository.delete((Serializable)((Object)conversationId));
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
        }
    }

    public ActionPoint saveActionPoint(ActionPoint inputActionPoint) throws Exception {
        if (!PropertyValidator.isValid((Object)inputActionPoint.getId())) {
            ActionPoint savedConversation = (ActionPoint)this.actionPointRepository.save((Object)inputActionPoint);
            return savedConversation;
        }
        ActionPoint actionPoint = (ActionPoint)this.actionPointRepository.findOne((Serializable)((Object)inputActionPoint.getId()));
        if (PropertyValidator.isValid((Object)inputActionPoint.getTitle())) {
            actionPoint.setTitle(inputActionPoint.getTitle());
        }
        if (PropertyValidator.isValid((Object)inputActionPoint.getValue())) {
            actionPoint.setValue(inputActionPoint.getValue());
        }
        if (PropertyValidator.isValid((Object)inputActionPoint.getSequence())) {
            actionPoint.setSequence(inputActionPoint.getSequence());
        }
        actionPoint = (ActionPoint)this.actionPointRepository.save((Object)actionPoint);
        return actionPoint;
    }

    public List<ActionPoint> fetchActionPoints(HashMap<String, Object> requestBody) throws Exception {
        if (requestBody.get("entityId") instanceof String) {
            List savedActionPoints = this.actionPointRepository.findByEntityTypeAndEntityId((String)requestBody.get("entityType"), (String)requestBody.get("entityId"));
            return savedActionPoints;
        }
        List savedActionPoints = this.actionPointRepository.findByEntityTypeAndEntityIdIn((String)requestBody.get("entityType"), (List)requestBody.get("entityId"));
        return savedActionPoints;
    }

    public void deleteActionPoint(String actionPointId) throws Exception {
        this.actionPointRepository.delete((Serializable)((Object)actionPointId));
    }

    public HashMap<String, Object> fetchCheckIn(String checkInId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        BaseItem baseItem = this.baseItemRepository.findById(checkInId);
        if (PropertyValidator.isValid((Object)baseItem)) {
            response.put("checkIn", baseItem);
            String relationId = null;
            Iterator iterator = baseItem.getRelationMap().entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                relationId = (String)entry.getKey();
            }
            if (PropertyValidator.isValid(relationId)) {
                WorkSpace ws = (WorkSpace)this.workSpaceRepository.findOne(relationId);
                BaseItem batch = new BaseItem();
                Session session = new Session();
                if (!PropertyValidator.isValid((Object)ws) && !PropertyValidator.isValid((Object)(batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)relationId))))) {
                    session = (Session)this.sessionRepository.findOne((Serializable)((Object)relationId));
                }
                if (PropertyValidator.isValid((Object)ws) || PropertyValidator.isValid((Object)batch) || PropertyValidator.isValid((Object)session)) {
                    ItemType checkInItemType = this.itemTypeRepository.findByTitle(EnumKendis.CHECK_IN.getCode());
                    ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(checkInItemType);
                    response.put("scheme", itemTypeScheme);
                }
            }
            User user = this.userRepository.findByUserName(baseItem.getCreatedBy());
            HashMap<String, User> usersByUsername = new HashMap<String, User>();
            if (PropertyValidator.isValid((Object)user)) {
                usersByUsername.put(user.getUserName(), user);
            }
            if (PropertyValidator.isValid(usersByUsername)) {
                response.put("usersByUsername", usersByUsername);
            }
        } else {
            response.put("error", "Invalid check in Id");
        }
        return response;
    }

    public List<Watcher> fetchWatchers(HashMap<String, String> requestBody) {
        try {
            List savedWatchers = this.watcherRepository.findByEntityTypeAndEntityId(requestBody.get("entityType"), requestBody.get("entityId"));
            return savedWatchers;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public List<Watcher> getWatchersByTitleSearch(String title) {
        try {
            ArrayList<Watcher> watchers = new ArrayList<Watcher>();
            List users = this.userRepository.findByUserCompanies_Company_IdAndFullNameContainingIgnoreCase(UserContextUtil.getUserContext().getCurrentCompany().getId(), title);
            for (User user : users) {
                if (!this.isLoggedInCompanyUser(user).booleanValue()) continue;
                Watcher watcher = new Watcher();
                watcher.setUser(user);
                watchers.add(watcher);
            }
            List groups = this.groupRepository.findByTitleContainingIgnoreCase(title);
            for (Group group : groups) {
                Watcher watcher = new Watcher();
                watcher.setGroup(group);
                watchers.add(watcher);
            }
            return watchers;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public Watcher saveWatcher(Watcher inputWatcher) {
        try {
            Watcher savedWatcher = (Watcher)this.watcherRepository.save((Object)inputWatcher);
            return savedWatcher;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public List<Watcher> saveWatchers(List<String> inputWatchers, String entityId, String entityType) {
        try {
            List usersForWatchers = this.userRepository.findByEmailIn(inputWatchers);
            List savedWatchers = this.watcherRepository.findByEntityTypeAndEntityIdAndUserIn(entityType, entityId, usersForWatchers);
            ArrayList<Watcher> watchers = new ArrayList<Watcher>();
            for (User watcher : usersForWatchers) {
                Boolean watcherExists = savedWatchers.stream().filter(o -> o.getUser().getEmail().equals(watcher.getEmail())).findFirst().isPresent();
                if (watcherExists.booleanValue()) continue;
                Watcher newWatcher = new Watcher();
                newWatcher.setEntityId(entityId);
                newWatcher.setEntityType(entityType);
                newWatcher.setUser(watcher);
                watchers.add(newWatcher);
            }
            List newWatchers = this.watcherRepository.save(watchers);
            return newWatchers;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public void deleteWatcher(String watcherId) {
        try {
            Watcher watcher = (Watcher)this.watcherRepository.findOne((Serializable)((Object)watcherId));
            watcher.setArchive(true);
            this.watcherRepository.save((Object)watcher);
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
        }
    }

    private Boolean isLoggedInCompanyUser(User user) {
        try {
            String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
            for (UserCompany userCompany : user.getUserCompanies()) {
                if (!userCompany.getCompany().getId().equals(loggedinCompanyId) || !userCompany.getIsActive().booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error(e.getStackTrace().toString());
            return null;
        }
    }

    public List<String> fetchHistory(HashMap<String, String> requestBody) {
        Boolean forEmail = false;
        String entityId = requestBody.get("entityId");
        String entityType = requestBody.get("entityType");
        String zoneOffset = requestBody.get("zoneOffset");
        Boolean isMockingMode = null != requestBody.get("isMockingMode");
        List itemList = this.itemLogRepository.findByItemIdAndItemTypeOrderByCreatedOnAsc(entityId, entityType);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"detail.entityId").is((Object)entityId).andOperator(new Criteria[]{Criteria.where((String)"detail.entityType").is((Object)entityType)}));
        List conversationLog = this.mongoTemplate.find(query, ItemLog.class);
        query = new Query();
        List okrItemLogList = new ArrayList();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)entityId));
        BaseItem baseItem = (BaseItem)this.mongoTemplate.findOne(query, BaseItem.class);
        ArrayList<String> baseItemLinkIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)baseItem)) {
            List objBaseItemLinkList = baseItem.getBaseItemLinks();
            ArrayList linkedItemIds = new ArrayList();
            ArrayList baseItemIDs = new ArrayList();
            objBaseItemLinkList.forEach(link -> {
                if (PropertyValidator.isValid((Object)link.getLinkedItemById())) {
                    linkedItemIds.add(link.getId());
                } else if (PropertyValidator.isValid((Object)link.getBaseItemId()) && PropertyValidator.isValid((Object)link.getLinkType()) && !link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) && !link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode()) && !link.getLinkType().equals(EnumKendis.PARENT_OBJECTIVE.getCode()) && !link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())) {
                    baseItemIDs.add(link.getBaseItemId());
                    baseItemLinkIds.add(link.getId());
                }
            });
            Query query3 = new Query();
            query3.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(baseItemIDs));
            List orkChildBaseItem = this.mongoTemplate.find(query3, BaseItem.class);
            ArrayList okrChildIDs = new ArrayList();
            if (orkChildBaseItem.size() > 0) {
                ((BaseItem)orkChildBaseItem.get(0)).getBaseItemLinks().forEach(okrChild -> {
                    if (!(!PropertyValidator.isValid((Object)okrChild.getBaseItemId()) || !PropertyValidator.isValid((Object)okrChild.getLinkType()) || okrChild.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || okrChild.getLinkType().equals(EnumKendis.CHILD_OKR.getCode()) || okrChild.getLinkType().equals(EnumKendis.PARENT_OBJECTIVE.getCode()) || okrChild.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) || okrChild.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode()))) {
                        okrChildIDs.add(okrChild.getId());
                    }
                });
            }
            ArrayList okrItemIDs = new ArrayList();
            okrItemIDs.addAll(linkedItemIds);
            okrItemIDs.addAll(okrChildIDs);
            Query query4 = new Query();
            query4.addCriteria((CriteriaDefinition)Criteria.where((String)"itemId").in(okrItemIDs));
            okrItemLogList = this.mongoTemplate.find(query4, ItemLog.class);
        }
        Query linkingQuery = new Query();
        linkingQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"baseItemId").is((Object)entityId));
        linkingQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne(null));
        List baseItemLinkList = this.mongoTemplate.find(linkingQuery, BaseItemLink.class);
        for (BaseItemLink _link : baseItemLinkList) {
            if (!PropertyValidator.isValid((Object)_link.getBaseItemId()) || !PropertyValidator.isValid((Object)_link.getLinkType()) || _link.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) || _link.getLinkType().equals(EnumKendis.PARENT_OBJECTIVE.getCode())) continue;
            baseItemLinkIds.add(_link.getId());
        }
        Query linkingLogQuery = new Query();
        linkingLogQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"itemId").in(baseItemLinkIds));
        List linkingLog = this.mongoTemplate.find(linkingLogQuery, ItemLog.class);
        ArrayList newItemList = new ArrayList();
        newItemList.addAll(itemList);
        newItemList.addAll(conversationLog);
        newItemList.addAll(okrItemLogList);
        newItemList.addAll(linkingLog);
        Collections.sort(newItemList, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<String> historyList = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        int descriptionCount = 0;
        BaseItem savedBaseItem = null;
        FieldTemplate savedBaseItemTemplate = new FieldTemplate();
        HashMap<String, Fields> fieldsIdMap = new HashMap<String, Fields>();
        for (ItemLog item : newItemList) {
            Map map;
            boolean anyActivity = false;
            String historyString = "";
            String jsonChanges = item.getChanges();
            if (jsonChanges == null) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(item.getCreatedOn());
            cal.add(12, Integer.parseInt(zoneOffset));
            SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy hh:mm a");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strDate = dateFormat.format(cal.getTime());
            if (item.getItemType().equals("BaseItemLink")) {
                Map objectAndGroupName;
                Map map2;
                String _linkedItemID = item.getItemId();
                Query baseItemLinkQuery = new Query();
                baseItemLinkQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(_linkedItemID)));
                ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
                booleanList.add(false);
                booleanList.add(true);
                baseItemLinkQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(booleanList));
                BaseItemLink linkItem = (BaseItemLink)this.mongoTemplate.findOne(baseItemLinkQuery, BaseItemLink.class);
                if (PropertyValidator.isValid((Object)linkItem)) {
                    if (PropertyValidator.isValid((Object)linkItem.getItemId())) {
                        Item linkedItemDetail = this.itemRepository.findById(linkItem.getItemId());
                        if (PropertyValidator.isValid((Object)linkedItemDetail)) {
                            String itemKey;
                            if (item.getEventType().equals("DELETED")) {
                                itemKey = "";
                                if (PropertyValidator.isValid((Object)linkedItemDetail.getJiraKey())) {
                                    itemKey = linkedItemDetail.getJiraKey();
                                }
                                if (PropertyValidator.isValid((Object)linkedItemDetail.getKendisKey())) {
                                    itemKey = linkedItemDetail.getKendisKey();
                                }
                                historyString = historyString + "<div class='nm-dt'><span class='txtgr'>" + itemKey + "</span>  <strong>" + linkedItemDetail.getTitle() + "</strong> Unlinked by <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
                            } else if (!jsonChanges.equals("{}")) {
                                itemKey = "";
                                if (PropertyValidator.isValid((Object)linkedItemDetail.getJiraKey())) {
                                    itemKey = linkedItemDetail.getJiraKey();
                                }
                                if (PropertyValidator.isValid((Object)linkedItemDetail.getKendisKey())) {
                                    itemKey = linkedItemDetail.getKendisKey();
                                }
                                if (PropertyValidator.isValid((Object)linkedItemDetail.getTfsId())) {
                                    itemKey = linkedItemDetail.getTfsId();
                                }
                                historyString = historyString + "<div class='nm-dt'><span class='txtgr'>" + itemKey + "</span> <strong>" + linkedItemDetail.getTitle() + "</strong> Linked by <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
                            }
                        }
                    } else if (PropertyValidator.isValid((Object)linkItem.getBaseItemId())) {
                        try {
                            map2 = (Map)mapper.readValue(jsonChanges, Map.class);
                            if (map2.size() == 1 && PropertyValidator.isValid(map2.get("archive"))) {
                                map2 = (HashMap)item.getDetail();
                            }
                            objectAndGroupName = this.extractGroupNameAndObjectiveNameFromJsonChanges(mapper, map2);
                            String linkAction = " Linked with ";
                            if (item.getEventType().equals("DELETED")) {
                                linkAction = " Unlinked from ";
                            }
                            if (PropertyValidator.isValid(objectAndGroupName.get("group")) && PropertyValidator.isValid(objectAndGroupName.get("objective")) && PropertyValidator.isValid(objectAndGroupName.get("groupKey"))) {
                                historyString = historyString + "<div class='nm-dt'><span class='txtgr'>" + (String)objectAndGroupName.get("objectiveKey") + "</span> <strong>" + ((String)objectAndGroupName.get("objective")).toString() + "</strong>" + linkAction + "<span class='txtgr mr-5'>" + (String)objectAndGroupName.get("groupKey") + "</span><strong>" + ((String)objectAndGroupName.get("group")).toString() + "</strong> By <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
                            } else if (PropertyValidator.isValid(objectAndGroupName.get("group")) && PropertyValidator.isValid(objectAndGroupName.get("objective"))) {
                                historyString = historyString + "<div class='nm-dt'><span class='txtgr'>" + (String)objectAndGroupName.get("objectiveKey") + "</span> <strong>" + ((String)objectAndGroupName.get("objective")).toString() + "</strong>" + linkAction + "<strong>" + ((String)objectAndGroupName.get("group")).toString() + "</strong> By <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(e.toString());
                        }
                    }
                } else if (!PropertyValidator.isValid((Object)linkItem) && (item.getEventType().equals("CREATED") || item.getEventType().equals("DELETED"))) {
                    try {
                        map2 = (Map)mapper.readValue(jsonChanges, Map.class);
                        objectAndGroupName = this.extractGroupNameAndObjectiveNameFromJsonChanges(mapper, map2);
                        if (PropertyValidator.isValid(objectAndGroupName.get("group")) && PropertyValidator.isValid(objectAndGroupName.get("objective"))) {
                            historyString = historyString + "<div class='nm-dt'><span class='key'>" + (String)objectAndGroupName.get("objectiveKey") + "</span> <strong>" + (String)objectAndGroupName.get("objective") + "</strong> Linked with <strong>" + (String)objectAndGroupName.get("group") + "</strong> By <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
                        }
                    }
                    catch (Exception map3) {
                        // empty catch block
                    }
                }
                if (!historyString.equals("")) {
                    historyList.add(historyString);
                }
                if (!forEmail.booleanValue()) continue;
                break;
            }
            if (item.getItemType().equals("Watcher")) {
                try {
                    map = (Map)mapper.readValue(jsonChanges, Map.class);
                    for (Map.Entry pair : map.entrySet()) {
                        if (!pair.getKey().equals("archive")) continue;
                        LinkedHashMap userDetail = (LinkedHashMap)item.getDetail();
                        if (pair.getValue().equals(false)) {
                            historyString = historyString + "<div class='nm-dt'><span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "<span> added `" + userDetail.get("title") + "` as a watcher.</span></div>";
                            continue;
                        }
                        historyString = historyString + "<div class='nm-dt'><span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "<span> deleted `" + userDetail.get("title") + "` as a watcher.</span></div>";
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.toString());
                }
                if (!historyString.equals("")) {
                    historyList.add(historyString);
                }
                if (!forEmail.booleanValue()) continue;
                break;
            }
            String eventType = item.getEventType().substring(0, 1).toUpperCase() + item.getEventType().substring(1).toLowerCase();
            if (!forEmail.booleanValue()) {
                historyString = historyString + "<div class='nm-dt'> " + eventType + " by <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
            }
            try {
                map = (Map)mapper.readValue(jsonChanges, Map.class);
                for (Map.Entry pair : map.entrySet()) {
                    if (pair.getKey().equals("id") || item.getItemType().equals("Conversation") && !pair.getKey().equals("text")) continue;
                    if (!pair.getKey().equals("fields")) {
                        Object value;
                        String itemType;
                        LinkedHashMap detail = (LinkedHashMap)item.getDetail();
                        if (PropertyValidator.isValid((Object)detail) && PropertyValidator.isValid(detail.get("type")) && (PropertyValidator.isValid((Object)(itemType = (String)detail.get("type"))) && (itemType.equals("Milestone") || itemType.equals("Phases") || itemType.contains("Objective") || itemType.equals("KR") || itemType.equals("batch_group") || itemType.equals("Batch")) && pair.getKey().equals("starred") || pair.getKey().equals("type") && (PropertyValidator.isValid((Object)itemType) && (itemType.equals("Milestone") || itemType.equals("Phases") || itemType.equals("Impediment") || itemType.equals("Action Point") || itemType.equals("KR")) || itemType.equals("batch_group") || itemType.equals("Batch")) || pair.getKey().equals("bvPlan") && PropertyValidator.isValid((Object)itemType) && !itemType.contains("Objective") || pair.getKey().equals("bvActual") && PropertyValidator.isValid((Object)itemType) && !itemType.contains("Objective") || pair.getKey().equals("isDefaultGroup") || (itemType.contains("Objective") || itemType.equals("KR")) && (pair.getKey().equals("bvPlan") || pair.getKey().equals("bvActual")) && isMockingMode.booleanValue())) continue;
                        if (pair.getKey() != "archive") {
                            historyString = historyString + " <div class='line prow '> ";
                        }
                        if (forEmail.booleanValue()) {
                            historyString = historyString + "&#8226;    ";
                        }
                        if (!(pair.getKey().equals("linkedItemsIds") || pair.getKey().equals("user") || pair.getKey().equals("entityType") || pair.getKey().equals("entityId") || pair.getKey().equals("starred") || pair.getKey() == "archive" || pair.getKey() == "sessionId")) {
                            historyString = historyString + StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)pair.getKey().toString()), (char)' '));
                        }
                        if (pair.getKey().equals("linkedCardWeights")) {
                            historyString = historyString + " changed to " + pair.getValue().toString();
                        }
                        if (pair.getKey().equals("status") || pair.getKey().equals("responsible") || pair.getKey().equals("probability") || pair.getKey().equals("impact")) {
                            historyString = historyString + this.getLastHistory(pair, itemList, item);
                        } else if (pair.getKey().equals("linkedItemsIds")) {
                            historyString = historyString + "<span class='a'>Linked Items count updated to " + ((List)pair.getValue()).size() + "</span>";
                        } else if (pair.getValue() instanceof String) {
                            value = (String)pair.getValue();
                            if (pair.getKey().equals("raisedDate") || pair.getKey().equals("resolutionDate")) {
                                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
                                Object parsedDate = null;
                                try {
                                    parsedDate = formatter.parse((String)value);
                                }
                                catch (ParseException parseException) {
                                    // empty catch block
                                }
                                formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
                                value = formatter.format((Date)parsedDate);
                            }
                            if (!(pair.getKey().equals("User") || pair.getKey().equals("entityId") || pair.getKey().equals("entityType"))) {
                                if (pair.getKey().equals("description")) {
                                    historyString = historyString + "<span class='b' id=\"description-download-" + descriptionCount + "\"> changed to \"" + (String)value + "\"</span>";
                                    if (PropertyValidator.isValid((Object)value)) {
                                        historyString = historyString + "<a href=\"javascript:void(0)\" onclick=\"downloadDescription(event)\"  data-description-id=\"" + descriptionCount + "\">Download Description</a>";
                                    }
                                    ++descriptionCount;
                                }
                                if (pair.getKey().equals("type")) {
                                    if (((String)value).contains("Objective-Committed")) {
                                        historyString = historyString + "<span class='b'> changed to Committed Objective</span>";
                                    } else if (((String)value).contains("Objective-Uncommitted")) {
                                        historyString = historyString + "<span class='b'> changed to Uncommitted Objective</span>";
                                    }
                                } else if (pair.getKey() != "archive" && pair.getKey() != "sessionId" && pair.getKey() != "description") {
                                    historyString = historyString + "<span class='b'> changed to \"" + (String)value + "\"</span>";
                                }
                            }
                        } else if (pair.getValue() instanceof Boolean) {
                            if (pair.getKey() == "starred") {
                                value = (Boolean)pair.getValue();
                                historyString = ((Boolean)value).booleanValue() ? historyString + "<span class='b'> Marked as starred</span>" : historyString + "<span class='b'> Marked as unstarred</span>";
                            }
                        } else if (pair.getValue() instanceof Double && (pair.getKey().equals("bvPlan") || pair.getKey().equals("bvActual"))) {
                            historyString = historyString + " changed to " + pair.getValue().toString();
                        }
                        if (pair.getKey() != "archive") {
                            historyString = historyString + " </div> ";
                        }
                        anyActivity = true;
                        continue;
                    }
                    HashMap fieldsMap = (HashMap)pair.getValue();
                    Iterator fieldsIterator = fieldsMap.entrySet().iterator();
                    if (fieldsMap.isEmpty()) continue;
                    while (fieldsIterator.hasNext()) {
                        Map.Entry fieldPair = fieldsIterator.next();
                        if (item.getItemType().equals("BaseItem")) {
                            Object field2;
                            if (!PropertyValidator.isValid(savedBaseItem) && PropertyValidator.isValid((Object)(savedBaseItem = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)item.getItemId()))))) {
                                ItemTypeScheme itemTypeScheme;
                                savedBaseItemTemplate = savedBaseItem.getFieldsTemplate();
                                if (PropertyValidator.isValid((Object)savedBaseItemTemplate)) {
                                    if (PropertyValidator.isValid((Collection)savedBaseItemTemplate.getConfiguredFields())) {
                                        for (Object field2 : savedBaseItemTemplate.getConfiguredFields()) {
                                            if (PropertyValidator.isValid((Object)field2.getIsGroup()) && field2.getIsGroup().booleanValue()) {
                                                for (Object _field : field2.getGroupFields()) {
                                                    fieldsIdMap.put(_field.getId(), (Fields)_field);
                                                }
                                                continue;
                                            }
                                            fieldsIdMap.put(field2.getId(), (Fields)field2);
                                        }
                                    }
                                } else if (PropertyValidator.isValid((Object)savedBaseItem.getItemType()) && PropertyValidator.isValid((Object)(itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(savedBaseItem.getItemType())).getFieldsTemplate()) && PropertyValidator.isValid((Collection)itemTypeScheme.getFieldsTemplate().getConfiguredFields())) {
                                    for (Fields field3 : itemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
                                        if (PropertyValidator.isValid((Object)field3.getIsGroup()) && field3.getIsGroup().booleanValue()) {
                                            Object _field;
                                            _field = field3.getGroupFields().iterator();
                                            while (_field.hasNext()) {
                                                Fields _field2 = (Fields)_field.next();
                                                fieldsIdMap.put(_field2.getId(), _field2);
                                            }
                                            continue;
                                        }
                                        fieldsIdMap.put(field3.getId(), field3);
                                    }
                                }
                            }
                            String fieldKey = (String)fieldPair.getKey();
                            field2 = (Fields)fieldsIdMap.get(fieldKey);
                            String value = "";
                            if (PropertyValidator.isValid((Object)field2) && field2.getTitle().equals("Shape")) continue;
                            Object fieldValue = fieldPair.getValue();
                            if (PropertyValidator.isValid((Object)field2)) {
                                LinkedHashMap valueMap;
                                historyString = historyString + " <div class='line prow '> ";
                                historyString = historyString + StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)field2.getTitle()), (char)' '));
                                if (field2.getType().equals("datepicker")) {
                                    LinkedHashMap date;
                                    if (fieldValue instanceof String) {
                                        Calendar calField = Calendar.getInstance();
                                        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                                        Date resolutionDate = inputFormat.parse((String)fieldValue);
                                        calField.setTime(resolutionDate);
                                        calField.add(12, Integer.parseInt(zoneOffset));
                                        SimpleDateFormat dateFormatField = new SimpleDateFormat("d MMM yyyy ");
                                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                                        value = dateFormatField.format(calField.getTime());
                                    } else if (fieldValue instanceof Map && PropertyValidator.isValid((date = (LinkedHashMap)fieldValue).get("right"))) {
                                        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                                        String resolutionDateString = (String)date.get("right");
                                        Date resolutionDate = inputFormat.parse(resolutionDateString);
                                        Calendar calField = Calendar.getInstance();
                                        calField.setTime(resolutionDate);
                                        calField.add(12, Integer.parseInt(zoneOffset));
                                        SimpleDateFormat dateFormatField = new SimpleDateFormat("d MMM yyyy ");
                                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                                        value = dateFormatField.format(calField.getTime());
                                    }
                                } else if (field2.getType().equals("userpicker")) {
                                    if (fieldValue instanceof Map) {
                                        LinkedHashMap user = (LinkedHashMap)fieldValue;
                                        if (!PropertyValidator.isValid(user.get("right"))) {
                                            Map userObject = new HashMap();
                                            userObject = (Map)this.getFieldValueFromBaseItem(savedBaseItem, field2.getTitle());
                                            if (!PropertyValidator.isValid(userObject)) {
                                                value = "Unassigned";
                                            } else if (PropertyValidator.isValid(userObject) && !userObject.isEmpty()) {
                                                value = (String)userObject.get("fullName");
                                            } else {
                                                user = (LinkedHashMap)fieldValue;
                                                value = (String)user.get("fullName");
                                            }
                                        } else if (!(user = (LinkedHashMap)user.get("right")).isEmpty()) {
                                            value = (String)user.get("fullName");
                                        }
                                    } else if (fieldValue instanceof ArrayList) {
                                        ArrayList users = (ArrayList)fieldValue;
                                        if (users.size() == 0) {
                                            value = value + "Unassigned";
                                        } else {
                                            for (int i = 0; i < users.size(); ++i) {
                                                LinkedHashMap user = (LinkedHashMap)users.get(i);
                                                if (!PropertyValidator.isValid((Object)user) || user.isEmpty()) continue;
                                                value = value + (String)user.get("fullName");
                                                if (i == users.size() - 1) continue;
                                                value = value + ", ";
                                            }
                                        }
                                    }
                                } else if (field2.getType().equals("severity")) {
                                    if (fieldValue instanceof Map) {
                                        LinkedHashMap severity = (LinkedHashMap)fieldValue;
                                        if (!PropertyValidator.isValid(severity.get("right"))) {
                                            Map severityObject = new HashMap();
                                            severityObject = (Map)this.getFieldValueFromBaseItem(savedBaseItem, field2.getTitle());
                                            if (PropertyValidator.isValid(severityObject)) {
                                                if (!severityObject.isEmpty()) {
                                                    value = (String)severityObject.get("title");
                                                }
                                            } else {
                                                severity = (LinkedHashMap)fieldValue;
                                                value = (String)severity.get("title");
                                            }
                                        } else if (!(severity = (LinkedHashMap)severity.get("right")).isEmpty()) {
                                            value = (String)severity.get("title");
                                        }
                                    }
                                } else if (field2.getType().equals("singleselect")) {
                                    if (fieldValue instanceof Map) {
                                        LinkedHashMap singleSelectValue = (LinkedHashMap)fieldValue;
                                        if (!PropertyValidator.isValid(singleSelectValue.get("right"))) {
                                            Map singleSelectValueObject = new HashMap();
                                            singleSelectValueObject = (Map)this.getFieldValueFromBaseItem(savedBaseItem, field2.getTitle());
                                            if (!singleSelectValueObject.isEmpty()) {
                                                value = (String)singleSelectValueObject.get("title");
                                            }
                                        } else if (singleSelectValue.get("right") instanceof String) {
                                            value = (String)singleSelectValue.get("right");
                                        } else if (PropertyValidator.isValid((Object)(singleSelectValue = (LinkedHashMap)singleSelectValue.get("right"))) && !singleSelectValue.isEmpty()) {
                                            value = (String)singleSelectValue.get("title");
                                        }
                                    } else {
                                        value = (String)fieldValue;
                                    }
                                } else if (field2.getType().equals("numberfield")) {
                                    if (fieldValue.getClass().getSimpleName().equals("Integer") || fieldValue.getClass().getSimpleName().equals("Double")) {
                                        value = fieldValue.toString();
                                    } else if (fieldValue instanceof Map) {
                                        valueMap = (LinkedHashMap)fieldValue;
                                        if (PropertyValidator.isValid(valueMap.get("right"))) {
                                            value = valueMap.get("right").toString();
                                        }
                                    } else {
                                        value = (String)fieldValue;
                                    }
                                } else if (field2.getType().equals("textfield") || field2.getType().equals("simpleEditor")) {
                                    if (!(fieldValue instanceof Map)) {
                                        value = (String)fieldValue;
                                    }
                                } else if (field2.getType().equals("time-period") && fieldValue instanceof Map && PropertyValidator.isValid((valueMap = (LinkedHashMap)fieldValue).get("title")) && PropertyValidator.isValid(valueMap.get("selectedYear"))) {
                                    String year;
                                    String title = String.valueOf(valueMap.get("title"));
                                    if (valueMap.get("selectedYear") instanceof Double) {
                                        Double val = (Double)valueMap.get("selectedYear");
                                        year = String.valueOf(val.intValue());
                                    } else {
                                        year = String.valueOf(valueMap.get("selectedYear"));
                                    }
                                    if (title.equals("Yearly")) {
                                        title = "Year";
                                    }
                                    value = title + " - " + year;
                                }
                                historyString = historyString + "<span class='b'> changed to \"" + value + "\"</span>";
                            }
                        }
                        historyString = historyString + " </div> ";
                        anyActivity = true;
                    }
                }
            }
            catch (IOException | ParseException exception) {
                // empty catch block
            }
            if (anyActivity && !historyString.equals("")) {
                historyList.add(historyString);
            }
            if (!forEmail.booleanValue()) continue;
            break;
        }
        Collections.reverse(historyList);
        return historyList;
    }

    private String getLastHistory(Map.Entry mapPair, List<ItemLog> itemList, ItemLog item) {
        String history = " changed ";
        String type = (String)mapPair.getKey();
        ObjectMapper mapper = new ObjectMapper();
        boolean startCheck = false;
        boolean breakLoop = false;
        for (ItemLog itemLog : itemList) {
            String jsonChanges;
            if (breakLoop) break;
            if (itemLog.getId().equals(item.getId())) {
                startCheck = true;
                continue;
            }
            if (!startCheck || (jsonChanges = itemLog.getChanges()) == null) continue;
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                for (Map.Entry pair : map.entrySet()) {
                    if (!pair.getKey().equals(type)) continue;
                    Map map2 = (Map)pair.getValue();
                    if (type.equals("status")) {
                        history = history + "from \"" + this.getObjectTitle(type, map2) + "\"";
                    }
                    breakLoop = true;
                }
            }
            catch (IOException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        Map map2 = (Map)mapPair.getValue();
        if (!(type.equals("responsible") || type.equals("probability") || type.equals("impact"))) {
            history = history + " to \"" + this.getObjectTitle(type, map2) + "\"";
        }
        return history;
    }

    private String getObjectTitle(String type, Map<Object, Object> map) {
        User responsible;
        String id;
        Status status;
        if (type.equals("status") && (status = (Status)this.statusRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return status.getTitle();
        }
        if (type.equals("responsible") && (responsible = (User)this.userRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return responsible.getFullName();
        }
        if (type.equals("probability") || type.equals("impact")) {
            String title = (String)map.get("title");
            return title;
        }
        return null;
    }

    public BaseItem filterExternalItems(BaseItem savedImpediment, BaseItem impediment) {
        HashMap externalItemIds = new HashMap();
        List savedImpedimentContainers = savedImpediment.getBaseItemLinks();
        List impedimentContainers = impediment.getBaseItemLinks();
        List<Object> impedimentSessionIds = new ArrayList();
        for (BaseItemLink impdtContainer : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)impdtContainer.getSessionId())) continue;
            impedimentSessionIds.add(impdtContainer.getSessionId());
        }
        impedimentSessionIds = impedimentSessionIds.stream().distinct().collect(Collectors.toList());
        List sessions = this.sessionRepository.findByIdIn(impedimentSessionIds);
        ArrayList<String> savedLinkedItemsIds = new ArrayList<String>();
        HashMap savedLinkedItemsById = new HashMap();
        ArrayList<Item> savedLinkedItems = new ArrayList<Item>();
        ArrayList<String> linkedItemsIds = new ArrayList<String>();
        HashMap linkedItemsById = new HashMap();
        ArrayList<Item> linkedItems = new ArrayList<Item>();
        for (BaseItemLink itemLink : savedImpedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            savedLinkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                savedLinkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            savedLinkedItems.add(itemLink.getLinkedItem());
        }
        for (BaseItemLink itemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
            linkedItemsIds.add(itemLink.getItemId());
            if (PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) {
                linkedItemsById.putAll(itemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) continue;
            linkedItems.add(itemLink.getLinkedItem());
        }
        HashMap activeBoardItemsMap = this.setActiveBoardItems(savedImpediment, sessions, externalItemIds, new HashMap(), null, null);
        List itemsList = (List)activeBoardItemsMap.get("linkedItems");
        if (PropertyValidator.isValid((Collection)itemsList)) {
            this.setFeatureStoryPoints(savedLinkedItems);
            HashMap filteredKeys = savedLinkedItemsById;
            if (PropertyValidator.isValid(filteredKeys)) {
                externalItemIds.putAll(filteredKeys);
            }
            if (PropertyValidator.isValid(linkedItemsById)) {
                externalItemIds.putAll(linkedItemsById);
            }
            for (BaseItemLink itemLink : savedImpedimentContainers) {
                if (!PropertyValidator.isValid((Object)itemLink.getItemId())) continue;
                HashMap newLinkedItemById = new HashMap();
                newLinkedItemById.put(itemLink.getItemId(), externalItemIds.get(itemLink.getItemId()));
                itemLink.setLinkedItemById(newLinkedItemById);
            }
            savedImpedimentContainers = this.baseItemLinkRepository.save((Iterable)savedImpedimentContainers);
            savedImpediment.setBaseItemLinks(savedImpedimentContainers);
            savedImpediment = (BaseItem)this.baseItemRepository.save((Object)savedImpediment);
            for (BaseItemLink itemLink : savedImpediment.getBaseItemLinks()) {
                itemLink.adjustLinkedItemIds();
            }
        }
        return savedImpediment;
    }

    private void getActiveSessionBoardAndLinkedItemsData(List<ObjectiveServiceVO> objectiveServiceVOList, Map<String, List<Session>> sessionsMap) {
        objectiveServiceVOList.forEach(objVo -> {
            List sessions = (List)sessionsMap.get(objVo.getSessionId());
            if (PropertyValidator.isValid((Collection)sessions)) {
                sessions.forEach(session -> objVo.getActiveSessionBoardIds().add(new ObjectId(session.getActiveSessionBoard())));
            }
            if (PropertyValidator.isValid((Collection)objVo.getObjectiveAndOkrBaseItemLinks())) {
                List impedimentContainers = objVo.getObjectiveAndOkrBaseItemLinks();
                for (BaseItemLink itemLink : impedimentContainers) {
                    if (!PropertyValidator.isValid((Object)itemLink.getItemId()) || itemLink.isArchive()) continue;
                    objVo.getLinkedItemsIds().add(itemLink.getItemId());
                    if (!PropertyValidator.isValid((Object)itemLink.getLinkedItemById())) continue;
                    objVo.getLinkedItemsById().putAll(itemLink.getLinkedItemById());
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doesItemBelongToSession(Item item, Set<String> activeSessionBoardIds, Set<String> objectIds, Set<String> duplicateOfIds, Set<String> originItemIds) {
        Set itemSessionBoardIds = PropertyValidator.isValid((Collection)item.getSessionBoards()) ? item.getSessionBoards().stream().map(BaseEntity::getId).collect(Collectors.toSet()) : null;
        if (!PropertyValidator.isValid(itemSessionBoardIds)) return false;
        if (!itemSessionBoardIds.stream().anyMatch(activeSessionBoardIds::contains)) return false;
        boolean bl = true;
        boolean containsAnySessionBoardId = bl;
        boolean exists = false;
        if (!containsAnySessionBoardId) return exists;
        if (PropertyValidator.isValid(objectIds) && objectIds.contains(item.getId())) {
            exists = true;
        }
        if (PropertyValidator.isValid(duplicateOfIds) && duplicateOfIds.contains(item.getId())) {
            exists = true;
        }
        if (!PropertyValidator.isValid(originItemIds)) return exists;
        if (!originItemIds.contains(item.getId())) return exists;
        return true;
    }

    private Map<String, List<Item>> groupItemListBySessionId(List<Item> itemList, List<ObjectiveServiceVO> objectiveServiceVOList, boolean forMissingItems) {
        if (!PropertyValidator.isValid(itemList)) {
            return null;
        }
        HashMap<String, List<Item>> groupedItemsBySessionId = new HashMap<String, List<Item>>();
        objectiveServiceVOList.forEach(objVo -> {
            if (PropertyValidator.isValid((Collection)objVo.getActiveSessionBoardIds()) && PropertyValidator.isValid((Collection)objVo.getLinkedItemsIds())) {
                HashSet duplicateOfIds;
                HashSet originItemIds;
                Set activeSessionBoardIds = objVo.getActiveSessionBoardIds().stream().map(ObjectId::toString).collect(Collectors.toSet());
                HashSet objectIds = new HashSet(objVo.getLinkedItemsIds());
                if (!forMissingItems) {
                    duplicateOfIds = originItemIds = objectIds;
                } else {
                    originItemIds = null;
                    duplicateOfIds = null;
                }
                groupedItemsBySessionId.put(objVo.getSessionId(), new LinkedList());
                itemList.forEach(item -> {
                    if (this.doesItemBelongToSession(item, activeSessionBoardIds, objectIds, duplicateOfIds, originItemIds)) {
                        ((List)groupedItemsBySessionId.get(objVo.getSessionId())).add(item);
                    }
                });
            }
        });
        return groupedItemsBySessionId;
    }

    private Map<String, List<Item>> getLinkedItemsForAllSessions(List<ObjectiveServiceVO> objectiveServiceVOList, boolean forMissingItems) {
        LinkedList objectIds = new LinkedList();
        LinkedList linkedItemsIds = new LinkedList();
        ArrayList activeSessionBoardsIds = new ArrayList();
        String tenant = objectiveServiceVOList.get(0).getTenant();
        objectiveServiceVOList.forEach(objVo -> {
            if (PropertyValidator.isValid((Collection)objVo.getLinkedItemsIds()) && PropertyValidator.isValid((Collection)objVo.getActiveSessionBoardIds())) {
                objectIds.addAll(KendisUtils.getListAsObjectIds((Collection)objVo.getLinkedItemsIds()));
                if (forMissingItems) {
                    linkedItemsIds.addAll(objVo.getKeys());
                } else {
                    linkedItemsIds.addAll(objVo.getLinkedItemsIds());
                }
                activeSessionBoardsIds.addAll(objVo.getActiveSessionBoardIds());
            }
        });
        BasicDBObject matchCriteria = forMissingItems ? this.getMatchCriteriaForMissedItems(objectIds, linkedItemsIds, activeSessionBoardsIds, tenant) : this.getMatchCriteriaForAllItems(objectIds, linkedItemsIds, null, activeSessionBoardsIds, tenant);
        List itemList = this.getLinkedItemsFromQuery(matchCriteria);
        return this.groupItemListBySessionId(itemList, objectiveServiceVOList, forMissingItems);
    }

    private void getKeysFromLinkedItemIdsForAllSessions(List<ObjectiveServiceVO> objectiveServiceVOList) {
        objectiveServiceVOList.forEach(objVo -> {
            Set ids = objVo.getLinkedItemsById().keySet();
            for (String id : ids) {
                Map obj;
                String localId;
                if (!PropertyValidator.isValid(objVo.getLinkedItemsById().get(id)) || PropertyValidator.isValid((Object)(localId = (String)(obj = (Map)objVo.getLinkedItemsById().get(id)).get("localId")))) continue;
                String key = (String)obj.get("key");
                objVo.getIdByKey().put(key + "_" + obj.get("session_id"), id);
                objVo.getKeys().add(key);
            }
        });
    }

    private void setSessionBoardAndTcMapFromAllItems(Map<String, List<Item>> itemListBySessionId, Map<String, SessionBoard> sessionIdAgainstSessionBoard, Map<String, TeamContainer> tcIdAgainstTC) {
        if (!PropertyValidator.isValid(itemListBySessionId)) {
            return;
        }
        List allItemList = itemListBySessionId.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map sessionBoardMap = this.getUniqueSessionBoardData(allItemList);
        Map teamContainerMap = this.getUniqueTeamContainerData(allItemList);
        if (PropertyValidator.isValid((Object)sessionBoardMap)) {
            sessionIdAgainstSessionBoard.putAll(sessionBoardMap);
        }
        if (PropertyValidator.isValid((Object)teamContainerMap)) {
            tcIdAgainstTC.putAll(teamContainerMap);
        }
    }

    public void setActiveBoardItemsForAllSessions(Map<String, List<Session>> sessionsMap, List<ObjectiveServiceVO> objectiveServiceVOList, HashMap<String, Boolean> addFieldInItem) {
        this.getActiveSessionBoardAndLinkedItemsData(objectiveServiceVOList, sessionsMap);
        Map itemListBySessionId = this.getLinkedItemsForAllSessions(objectiveServiceVOList, false);
        HashMap sessionIdAgainstSessionBoard = new HashMap();
        HashMap tcIdAgainstTeamContainer = new HashMap();
        this.setSessionBoardAndTcMapFromAllItems(itemListBySessionId, sessionIdAgainstSessionBoard, tcIdAgainstTeamContainer);
        objectiveServiceVOList.forEach(objVo -> {
            List itemList;
            List list = itemList = PropertyValidator.isValid((Object)itemListBySessionId) ? (List)itemListBySessionId.get(objVo.getSessionId()) : null;
            if (PropertyValidator.isValid(itemList)) {
                List itemIds = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                objVo.setLinkedItemsIds(itemIds);
                objVo.setLinkedItems(itemList);
                for (Item item : itemList) {
                    List itemSessionBoard = item.getSessionBoards();
                    List itemTeamContainers = item.getTeamContainers();
                    if (PropertyValidator.isValid((Object)sessionIdAgainstSessionBoard) && !sessionIdAgainstSessionBoard.isEmpty()) {
                        ArrayList sessionBoards = new ArrayList();
                        for (SessionBoard sb : itemSessionBoard) {
                            sessionBoards.add(sessionIdAgainstSessionBoard.get(sb.getId()));
                        }
                        item.setSessionBoards(sessionBoards);
                    }
                    if (PropertyValidator.isValid((Object)tcIdAgainstTeamContainer) && !tcIdAgainstTeamContainer.isEmpty()) {
                        ArrayList teamContainers = new ArrayList();
                        for (TeamContainer tc : itemTeamContainers) {
                            teamContainers.add(tcIdAgainstTeamContainer.get(tc.getId()));
                        }
                        item.setTeamContainers(teamContainers);
                    }
                    if (!itemIds.contains(item.getId())) {
                        itemIds.add(item.getId());
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        String externalLink = this.getItemLink(item);
                        item.setExternalReferenceURL(externalLink);
                    }
                    if (objVo.getExternalIds() != null) {
                        objVo.getExternalIds().put(item.getId(), this.toSimpleObject(item));
                    }
                    if (objVo.getLinkedItemsById() == null) continue;
                    objVo.getLinkedItemsById().remove(item.getId());
                    if (PropertyValidator.isValid((Object)item.getOriginItemId())) {
                        objVo.getLinkedItemsById().remove(item.getOriginItemId());
                    }
                    if (PropertyValidator.isValid((Object)item.getDuplicateOfId())) {
                        objVo.getLinkedItemsById().remove(item.getDuplicateOfId());
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        objVo.getExternalItemsMap().put(item.getJiraKey(), item);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    objVo.getExternalItemsMap().put(item.getTfsId(), item);
                }
            } else {
                objVo.getLinkedItemsIds().clear();
            }
        });
        this.getKeysFromLinkedItemIdsForAllSessions(objectiveServiceVOList);
        Map missedItemListBySessionId = this.getLinkedItemsForAllSessions(objectiveServiceVOList, true);
        HashMap sessionIdAgainstSessionBoardForMissing = new HashMap();
        HashMap tcIdAgainstTeamContainerForMissing = new HashMap();
        this.setSessionBoardAndTcMapFromAllItems(missedItemListBySessionId, sessionIdAgainstSessionBoard, tcIdAgainstTeamContainer);
        if (PropertyValidator.isValid((Object)missedItemListBySessionId)) {
            objectiveServiceVOList.forEach(objVo -> {
                if (objVo.getLinkedItemsIds() != null && objVo.getLinkedItemsById() != null) {
                    Set ids;
                    List itemList = (List)missedItemListBySessionId.get(objVo.getSessionId());
                    if (PropertyValidator.isValid((Collection)itemList)) {
                        for (Item item : itemList) {
                            List itemSessionBoard = item.getSessionBoards();
                            List itemTeamContainers = item.getTeamContainers();
                            if (PropertyValidator.isValid((Object)sessionIdAgainstSessionBoardForMissing) && !sessionIdAgainstSessionBoardForMissing.isEmpty()) {
                                ArrayList sessionBoards = new ArrayList();
                                for (SessionBoard sb : itemSessionBoard) {
                                    sessionBoards.add(sessionIdAgainstSessionBoardForMissing.get(sb.getId()));
                                }
                                item.setSessionBoards(sessionBoards);
                            }
                            if (PropertyValidator.isValid((Object)tcIdAgainstTeamContainerForMissing) && !tcIdAgainstTeamContainerForMissing.isEmpty()) {
                                ArrayList teamContainers = new ArrayList();
                                for (TeamContainer tc : itemTeamContainers) {
                                    teamContainers.add(tcIdAgainstTeamContainerForMissing.get(tc.getId()));
                                }
                                item.setTeamContainers(teamContainers);
                            }
                            String externalLink = this.getItemLink(item);
                            item.setExternalReferenceURL(externalLink);
                            if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
                            String sId = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
                            if (PropertyValidator.isValid((Object)item.getJiraId())) {
                                if (objVo.getIdByKey().containsKey(item.getJiraKey() + "_" + sId)) {
                                    objVo.getLinkedItemsById().remove(objVo.getIdByKey().get(item.getJiraKey() + "_" + sId));
                                }
                            } else if (PropertyValidator.isValid((Object)item.getTfsId()) && objVo.getIdByKey().containsKey(item.getTfsId() + "_" + sId)) {
                                objVo.getLinkedItemsById().remove(objVo.getIdByKey().get(item.getTfsId() + "_" + sId));
                            }
                            if (objVo.getExternalIds().containsKey(item.getId())) continue;
                            objVo.getLinkedItems().add(item);
                            objVo.getLinkedItemsIds().add(item.getId());
                        }
                    }
                    if (PropertyValidator.isValid(ids = objVo.getLinkedItemsById().keySet())) {
                        objVo.getLinkedItemsIds().addAll(ids);
                    }
                }
            });
        }
        Boolean setFeatureStoryPoints = true;
        if (PropertyValidator.isValid(addFieldInItem) && PropertyValidator.isValid((Object)addFieldInItem.get("featureStoryPoints"))) {
            setFeatureStoryPoints = addFieldInItem.get("featureStoryPoints");
        }
        if (setFeatureStoryPoints.booleanValue()) {
            this.setFeatureStoryPointsForAllItemsInSessions(objectiveServiceVOList);
        }
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, Object> setActiveBoardItems(BaseItem impediment, List<Session> sessions, Map<String, Object> externalIds, Map<String, Item> externalItemsMap, List<BaseItemLink> baseItemLinksOfObjAndKr, HashMap<String, Boolean> addFieldInItem) {
        void var16_19;
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Boolean> boardIdMap = new HashMap<String, Boolean>();
        ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid(sessions)) {
            for (Session s : sessions) {
                activeSessionBoardIds.add(new ObjectId(s.getActiveSessionBoard()));
                boardIdMap.put(s.getActiveSessionBoard(), true);
            }
        }
        List<Object> impedimentContainers = new ArrayList();
        if (PropertyValidator.isValid((Object)impediment) && PropertyValidator.isValid((Collection)impediment.getBaseItemLinks())) {
            impedimentContainers = impediment.getBaseItemLinks();
        } else if (PropertyValidator.isValid(baseItemLinksOfObjAndKr)) {
            impedimentContainers = baseItemLinksOfObjAndKr;
        }
        List<Object> linkedItemsIds = new ArrayList<String>();
        ArrayList<String> itemsKeys = new ArrayList<String>();
        Map<Object, Object> linkedItemsById = new HashMap();
        List<Item> linkedItems = new ArrayList<Item>();
        for (BaseItemLink baseItemLink : impedimentContainers) {
            if (!PropertyValidator.isValid((Object)baseItemLink.getItemId()) || baseItemLink.isArchive()) continue;
            linkedItemsIds.add(baseItemLink.getItemId());
            if (PropertyValidator.isValid((Object)baseItemLink.getLinkedItemById())) {
                Map link = (Map)baseItemLink.getLinkedItemById().get(baseItemLink.getItemId());
                if (PropertyValidator.isValid((Object)link) && boardIdMap.containsKey(link.get("sessionBoard_id")) && PropertyValidator.isValid(link.get("key"))) {
                    itemsKeys.add((String)link.get("key"));
                }
                linkedItemsById.putAll(baseItemLink.getLinkedItemById());
            }
            if (!PropertyValidator.isValid(linkedItems)) continue;
            linkedItems.add(baseItemLink.getLinkedItem());
        }
        List objectIds = KendisUtils.getListAsObjectIds(linkedItemsIds);
        if (externalIds == null) {
            externalIds = new HashMap<String, Object>();
        }
        Object var16_17 = null;
        if (PropertyValidator.isValid(sessions)) {
            String string = sessions.get(0).getTenant();
        }
        if (PropertyValidator.isValid(activeSessionBoardIds) && PropertyValidator.isValid(linkedItemsIds)) {
            BasicDBObject matchCriteria = this.getMatchCriteriaForAllItems(objectIds, linkedItemsIds, itemsKeys, activeSessionBoardIds, (String)var16_19);
            List itemList = this.getLinkedItemsFromQuery(matchCriteria);
            if (PropertyValidator.isValid((Collection)itemList)) {
                List itemIds = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
                Map sessionIdAgainstSessionBoard = this.getUniqueSessionBoardData(itemList);
                Map tcIdAgainstTeamContainer = this.getUniqueTeamContainerData(itemList);
                linkedItemsIds = itemIds;
                linkedItems = itemList;
                linkedItemsById = linkedItemsById.entrySet().stream().filter(entry -> itemIds.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                for (Item item : itemList) {
                    List itemSessionBoard = item.getSessionBoards();
                    List itemTeamContainers = item.getTeamContainers();
                    if (PropertyValidator.isValid((Object)sessionIdAgainstSessionBoard)) {
                        ArrayList sessionBoards = new ArrayList();
                        for (SessionBoard sb : itemSessionBoard) {
                            sessionBoards.add(sessionIdAgainstSessionBoard.get(sb.getId()));
                        }
                        item.setSessionBoards(sessionBoards);
                    }
                    if (PropertyValidator.isValid((Object)tcIdAgainstTeamContainer)) {
                        ArrayList teamContainers = new ArrayList();
                        for (TeamContainer tc : itemTeamContainers) {
                            teamContainers.add(tcIdAgainstTeamContainer.get(tc.getId()));
                        }
                        item.setTeamContainers(teamContainers);
                    }
                    if (!itemIds.contains(item.getId())) {
                        itemIds.add(item.getId());
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        String externalLink = this.getItemLink(item);
                        item.setExternalReferenceURL(externalLink);
                    }
                    if (externalIds != null) {
                        externalIds.put(item.getId(), this.toSimpleObject(item));
                    }
                    if (externalItemsMap == null || linkedItemsById == null) continue;
                    linkedItemsById.remove(item.getId());
                    if (PropertyValidator.isValid((Object)item.getOriginItemId())) {
                        linkedItemsById.remove(item.getOriginItemId());
                    }
                    if (PropertyValidator.isValid((Object)item.getDuplicateOfId())) {
                        linkedItemsById.remove(item.getDuplicateOfId());
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        externalItemsMap.put(item.getJiraKey(), item);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    externalItemsMap.put(item.getTfsId(), item);
                }
            } else {
                linkedItemsIds = new ArrayList();
                linkedItemsById = new HashMap();
            }
        }
        if (externalItemsMap != null && linkedItemsById != null) {
            Set ids = linkedItemsById.keySet();
            ArrayList<String> keys = new ArrayList<String>();
            HashMap<String, String> idByKey = new HashMap<String, String>();
            for (String id : ids) {
                String localId;
                Map obj = (Map)linkedItemsById.get(id);
                if (!PropertyValidator.isValid(linkedItemsById.get(id)) || PropertyValidator.isValid((Object)(localId = (String)obj.get("localId")))) continue;
                String key = (String)obj.get("key");
                idByKey.put(key + "_" + (String)obj.get("session_id"), id);
                keys.add(key);
            }
            BasicDBObject matchCriteriaForMissedItems = this.getMatchCriteriaForMissedItems(objectIds, keys, activeSessionBoardIds, (String)var16_19);
            List itemList = this.getLinkedItemsFromQuery(matchCriteriaForMissedItems);
            if (PropertyValidator.isValid((Collection)itemList)) {
                Map sessionIdAgainstSessionBoard = this.getUniqueSessionBoardData(itemList);
                Map tcIdAgainstTeamContainer = this.getUniqueTeamContainerData(itemList);
                for (Item item : itemList) {
                    List itemSessionBoard = item.getSessionBoards();
                    List itemTeamContainers = item.getTeamContainers();
                    if (PropertyValidator.isValid((Object)sessionIdAgainstSessionBoard)) {
                        ArrayList sessionBoards = new ArrayList();
                        for (SessionBoard sb : itemSessionBoard) {
                            sessionBoards.add(sessionIdAgainstSessionBoard.get(sb.getId()));
                        }
                        item.setSessionBoards(sessionBoards);
                    }
                    if (PropertyValidator.isValid((Object)tcIdAgainstTeamContainer)) {
                        ArrayList teamContainers = new ArrayList();
                        for (TeamContainer tc : itemTeamContainers) {
                            teamContainers.add(tcIdAgainstTeamContainer.get(tc.getId()));
                        }
                        item.setTeamContainers(teamContainers);
                    }
                    String externalLink = this.getItemLink(item);
                    item.setExternalReferenceURL(externalLink);
                    if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
                    String sId = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        if (idByKey.containsKey(item.getJiraKey() + "_" + sId)) {
                            linkedItemsById.remove(idByKey.get(item.getJiraKey() + "_" + sId));
                        }
                    } else if (PropertyValidator.isValid((Object)item.getTfsId()) && idByKey.containsKey(item.getTfsId() + "_" + sId)) {
                        linkedItemsById.remove(idByKey.get(item.getTfsId() + "_" + sId));
                    }
                    if (externalIds.containsKey(item.getId())) continue;
                    linkedItems.add(item);
                    linkedItemsIds.add(item.getId());
                }
            }
            if (PropertyValidator.isValid(ids = linkedItemsById.keySet())) {
                linkedItemsIds.addAll(ids);
            }
        }
        Boolean setFeatureStoryPoints = true;
        if (PropertyValidator.isValid(addFieldInItem) && PropertyValidator.isValid((Object)addFieldInItem.get("featureStoryPoints"))) {
            setFeatureStoryPoints = addFieldInItem.get("featureStoryPoints");
        }
        if (setFeatureStoryPoints.booleanValue()) {
            this.setFeatureStoryPoints(linkedItems);
        }
        response.put("linkedItems", linkedItems);
        response.put("linkedItemsIds", linkedItemsIds);
        response.put("linkedItemsById", linkedItemsById);
        return response;
    }

    private BasicDBObject getMatchCriteriaForMissedItems(List<ObjectId> objectIds, List<String> keys, ArrayList<ObjectId> activeSessionBoardIds, String tenant) {
        return new BasicDBObject("$match", (Object)new BasicDBObject("$and", Arrays.asList(new BasicDBObject("$or", Arrays.asList(new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", keys)), new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", keys)))), new BasicDBObject("sessionBoards.$id", (Object)new BasicDBObject("$in", activeSessionBoardIds)), new BasicDBObject("_id", (Object)new BasicDBObject("$nin", objectIds)), new BasicDBObject("archive", (Object)new BasicDBObject("$ne", (Object)true)), new BasicDBObject("tenant", (Object)tenant))));
    }

    private BasicDBObject getMatchCriteriaForAllItems(List<ObjectId> objectIds, List<String> linkedItemsIds, List<String> keys, ArrayList<ObjectId> activeSessionBoardIds, String tenant) {
        List<DBObject> list = null;
        list = keys == null ? Arrays.asList(new BasicDBObject("_id", (Object)new BasicDBObject("$in", objectIds)), new BasicDBObject("originItemId", (Object)new BasicDBObject("$in", linkedItemsIds)), new BasicDBObject("duplicateOfId", (Object)new BasicDBObject("$in", linkedItemsIds))) : Arrays.asList(new BasicDBObject("_id", (Object)new BasicDBObject("$in", objectIds)), new BasicDBObject("originItemId", (Object)new BasicDBObject("$in", linkedItemsIds)), new BasicDBObject("duplicateOfId", (Object)new BasicDBObject("$in", linkedItemsIds)), new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", keys)), new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", keys)));
        return new BasicDBObject("$match", (Object)new BasicDBObject("$and", Arrays.asList(new BasicDBObject("$or", list), new BasicDBObject("sessionBoards.$id", (Object)new BasicDBObject("$in", activeSessionBoardIds)), new BasicDBObject("archive", (Object)new BasicDBObject("$ne", (Object)true)), new BasicDBObject("tenant", (Object)tenant))));
    }

    private BasicDBObject getMatchCriteriaForFetchChildItemsGroupedByParentId(List<String> parentIds, String tenant) {
        ArrayList<ObjectId> parentObjectIds = new ArrayList<ObjectId>();
        for (String parentId : parentIds) {
            parentObjectIds.add(new ObjectId(parentId));
        }
        return new BasicDBObject("$match", (Object)new BasicDBObject().append("parent.$id", (Object)new BasicDBObject("$in", parentObjectIds)).append("archive", (Object)new BasicDBObject("$ne", (Object)true)).append("tenant", (Object)tenant));
    }

    private List<Item> getLinkedItemsFromQuery(BasicDBObject matchCriteria) {
        if (!PropertyValidator.isValid((Object)matchCriteria)) {
            return null;
        }
        try {
            BasicDBObject statusLookupStage = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
            BasicDBObject issueTypeLookupStage = DBUtils.createLookup((String)"issueType", (String)"issueType.$id", (String)"_id", (String)"issueType");
            BasicDBObject issueTypeUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject().append("path", (Object)"$issueType").append("preserveNullAndEmptyArrays", (Object)true));
            BasicDBObject statusUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject().append("path", (Object)"$status").append("preserveNullAndEmptyArrays", (Object)true));
            BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("title", (Object)1).append("type", (Object)1).append("storyPoints", (Object)1).append("tfsId", (Object)1).append("kendisKey", (Object)1).append("tfsURL", (Object)1).append("status._id", (Object)1).append("status.title", (Object)1).append("status.color", (Object)1).append("status.category", (Object)1).append("teamContainers.$id", (Object)1).append("jiraId", (Object)1).append("jiraKey", (Object)1).append("jiraURL", (Object)1).append("issueType", (Object)1).append("jiraIssueTypeId", (Object)1).append("tfsItemType", (Object)1).append("tfsItemTypeIcon", (Object)1).append("parentId", (Object)"$parent.$id").append("sessionBoards.$id", (Object)1).append("originItemId", (Object)1).append("duplicateOfId", (Object)1).append("externalReferenceURL", (Object)1));
            List<DBObject> pipeLine = Arrays.asList(matchCriteria, statusLookupStage, issueTypeLookupStage, issueTypeUnWind, statusUnWind, projectionStage);
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
            AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
            Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);
            ArrayList<Item> itemList = new ArrayList<Item>();
            while (dbCursor.hasNext()) {
                ObjectId id;
                IssueType itemIssueType;
                DBObject obj = (DBObject)dbCursor.next();
                Status itemStatus = null;
                Item item = new Item();
                ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                Map statusMap = (Map)obj.get("status");
                List sessionBoardIds = (List)obj.get("sessionBoards");
                List teamContainerIds = (List)obj.get("teamContainers");
                ObjectId parentId = (ObjectId)obj.get("parentId");
                BasicDBObject issueType = (BasicDBObject)obj.get("issueType");
                Item parentItem = PropertyValidator.isValid((Object)parentId) ? new Item(parentId.toString()) : null;
                IssueType issueType2 = itemIssueType = PropertyValidator.isValid((Object)issueType) ? new IssueType(issueType) : null;
                if (PropertyValidator.isValid((Object)statusMap)) {
                    Object statusId;
                    if (statusMap.get("_id") instanceof String) {
                        statusId = (String)statusMap.get("_id");
                    } else {
                        ObjectId id2 = (ObjectId)statusMap.get("_id");
                        statusId = id2.toString();
                    }
                    itemStatus = new Status((String)statusId, (String)statusMap.get("title"), (String)statusMap.get("color"), (String)statusMap.get("category"));
                }
                if (PropertyValidator.isValid((Collection)sessionBoardIds)) {
                    for (BasicDBObject sessionBoardObj : sessionBoardIds) {
                        id = (ObjectId)sessionBoardObj.get("$id");
                        sessionBoards.add(new SessionBoard(id.toString()));
                    }
                }
                if (PropertyValidator.isValid((Collection)teamContainerIds)) {
                    for (BasicDBObject teamContainerObj : teamContainerIds) {
                        id = (ObjectId)teamContainerObj.get("$id");
                        teamContainers.add(new TeamContainer(id.toString()));
                    }
                }
                ObjectId itemId = (ObjectId)obj.get("_id");
                item.setId(itemId.toString());
                item.setTitle((String)obj.get("title"));
                item.setType((String)obj.get("type"));
                item.setStoryPoints((Double)obj.get("storyPoints"));
                item.setTfsId((String)obj.get("tfsId"));
                item.setKendisKey((String)obj.get("kendisKey"));
                item.setTfsURL((String)obj.get("tfsURL"));
                item.setJiraId((String)obj.get("jiraId"));
                item.setJiraKey((String)obj.get("jiraKey"));
                item.setJiraURL((String)obj.get("jiraURL"));
                item.setIssueType(itemIssueType);
                item.setJiraIssueTypeId((String)obj.get("jiraIssueTypeId"));
                item.setTfsItemType((String)obj.get("tfsItemType"));
                item.setTfsItemTypeIcon((String)obj.get("tfsItemTypeIcon"));
                item.setOriginItemId((String)obj.get("originItemId"));
                item.setDuplicateOfId((String)obj.get("duplicateOfId"));
                item.setExternalReferenceURL((String)obj.get("externalReferenceURL"));
                item.setParent(parentItem);
                item.setStatus(itemStatus);
                item.setSessionBoards(sessionBoards);
                item.setTeamContainers(teamContainers);
                itemList.add(item);
            }
            return itemList;
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private Map<String, SessionBoard> getUniqueSessionBoardData(List<Item> items) {
        if (!PropertyValidator.isValid(items)) {
            return null;
        }
        HashSet sessionIds = new HashSet();
        HashMap<String, SessionBoard> sessionBoardMap = new HashMap<String, SessionBoard>();
        try {
            for (Item item : items) {
                if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
                item.getSessionBoards().forEach(sessionBoard -> sessionIds.add(new ObjectId(sessionBoard.getId())));
            }
            BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", (Object)sessionIds.toArray())));
            BasicDBObject lookupStage = DBUtils.createLookup((String)"session", (String)"session.$id", (String)"_id", (String)"session");
            BasicDBObject unWind = new BasicDBObject("$unwind", (Object)"$session");
            BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("session._id", (Object)1).append("session.title", (Object)1).append("session.parentItem", (Object)1).append("session.childItem", (Object)1));
            List<DBObject> pipeLine = Arrays.asList(matchStage, lookupStage, unWind, projectStage);
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
            AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
            Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                ObjectId id = (ObjectId)object.get("_id");
                SessionBoard sessionBoard2 = new SessionBoard(id.toString());
                BasicDBObject basicSessionObj = (BasicDBObject)object.get("session");
                Session session = new Session(basicSessionObj.get("_id").toString(), (String)basicSessionObj.get("title"), (String)basicSessionObj.get("parentItem"), (String)basicSessionObj.get("childItem"));
                sessionBoard2.setSession(session);
                sessionBoardMap.put(id.toString(), sessionBoard2);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return sessionBoardMap;
    }

    private Map<String, TeamContainer> getUniqueTeamContainerData(List<Item> items) {
        if (!PropertyValidator.isValid(items)) {
            return null;
        }
        HashSet teamContainerIds = new HashSet();
        HashMap<String, TeamContainer> teamContainerMap = new HashMap<String, TeamContainer>();
        try {
            for (Item item : items) {
                if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
                item.getTeamContainers().forEach(teamContainer -> teamContainerIds.add(new ObjectId(teamContainer.getId())));
            }
            BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", (Object)teamContainerIds.toArray())));
            BasicDBObject teamLookup = DBUtils.createLookup((String)"team", (String)"team.$id", (String)"_id", (String)"team");
            BasicDBObject containerLookup = DBUtils.createLookup((String)"container", (String)"container.$id", (String)"_id", (String)"container");
            BasicDBObject teamUnWind = new BasicDBObject("$unwind", (Object)"$team");
            BasicDBObject containerUnWind = new BasicDBObject("$unwind", (Object)"$container");
            BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("team._id", (Object)1).append("container._id", (Object)1));
            List<DBObject> pipeLine = Arrays.asList(matchStage, teamLookup, containerLookup, teamUnWind, containerUnWind, projectStage);
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TeamContainer.class));
            AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
            Cursor dbCursor = collection.aggregate(pipeLine, aggregationOptions);
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                ObjectId id = (ObjectId)object.get("_id");
                TeamContainer teamContainer2 = new TeamContainer(id.toString());
                BasicDBObject basicTeamObj = (BasicDBObject)object.get("team");
                BasicDBObject basicContainerObj = (BasicDBObject)object.get("container");
                teamContainer2.setTeam(new Team(basicTeamObj.get("_id").toString()));
                teamContainer2.setContainer(new Container(basicContainerObj.get("_id").toString()));
                teamContainerMap.put(teamContainer2.getId(), teamContainer2);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return teamContainerMap;
    }

    public String getItemLink(Item item) {
        String externalLink = "";
        if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            return null;
        }
        SessionBoard sessionBoard = (SessionBoard)item.getSessionBoards().get(0);
        Session session = sessionBoard.getSession();
        String referenceBaseUrl = null;
        if (session.getAlmEnabled().booleanValue()) {
            if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                referenceBaseUrl = PropertyValidator.isValid((Object)((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL()) ? ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL() + "/browse" : ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getUrl() + "/browse";
            } else if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                referenceBaseUrl = item.getTfsURL();
            }
        } else {
            referenceBaseUrl = session.getJiraBaseURL() != null ? session.getJiraBaseURL() : "";
        }
        if (item.getJiraKey() != null && item.getJiraId() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        } else if (item.getJiraKey() != null && item.getExternalReferenceURL() != null) {
            externalLink = item.getExternalReferenceURL();
        } else if (item.getJiraKey() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        }
        return externalLink;
    }

    public HashMap<String, ? super Object> toSimpleObject(Item item) {
        HashMap<String, String> rowData = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)item.getJiraId())) {
            rowData.put("jiraId", item.getJiraId());
            rowData.put("jiraKey", item.getJiraKey());
            rowData.put("key", item.getJiraKey());
        }
        if (PropertyValidator.isValid((Object)item.getTfsId())) {
            rowData.put("tfsId", item.getTfsId());
            rowData.put("key", item.getTfsId());
            rowData.put("tfsURL", item.getTfsURL());
        }
        if (!PropertyValidator.isValid((Object)item.getTfsId()) && !PropertyValidator.isValid((Object)item.getJiraId())) {
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                rowData.put("key", item.getJiraKey());
            } else if (PropertyValidator.isValid((Object)item.getKendisKey())) {
                rowData.put("key", item.getKendisKey());
            } else {
                rowData.put("key", "");
            }
            rowData.put("localId", item.getId());
        } else if (PropertyValidator.isValid((Object)item.getExternalReferenceURL())) {
            rowData.put("externalReferenceURL", this.getItemLink(item));
        } else {
            rowData.put("externalReferenceURL", item.getExternalReferenceURL());
        }
        if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession())) {
            rowData.put("sessionBoard_id", ((SessionBoard)item.getSessionBoards().get(0)).getId());
            rowData.put("session_id", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
            rowData.put("session_title", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTitle());
        }
        return rowData;
    }

    private void setFeatureStoryPointsForAllItemsInSessions(List<ObjectiveServiceVO> objectiveServiceVOs) {
        LinkedList parentIds = new LinkedList();
        objectiveServiceVOs.forEach(objectiveServiceVO -> objectiveServiceVO.getLinkedItems().forEach(item -> parentIds.add(item.getId())));
        Map childItemsAgainstParentId = this.customRepositoryImpl.findAndMapItemsByParent(parentIds, objectiveServiceVOs.get(0).getTenant());
        objectiveServiceVOs.forEach(objectiveServiceVO -> objectiveServiceVO.getLinkedItems().forEach(item -> {
            if (PropertyValidator.isValid((Object)item) && item.getType().equals("Feature")) {
                Double storyPoints = 0.0;
                List childList = (List)childItemsAgainstParentId.get(item.getId());
                if (PropertyValidator.isValid((Collection)childList)) {
                    for (Item childItem : childList) {
                        if (!PropertyValidator.isValid((Object)childItem)) continue;
                        storyPoints = storyPoints + childItem.getStoryPoints();
                    }
                }
                item.setStoryPoints(storyPoints);
            }
        }));
    }

    public void setFeatureStoryPoints(List<Item> items) throws RuntimeException {
        for (Item item : items) {
            if (!PropertyValidator.isValid((Object)item) || !item.getType().equals("Feature")) continue;
            Double storyPoints = 0.0;
            List childList = this.itemRepository.findByParentId(item.getId());
            for (Item childItem : childList) {
                if (!PropertyValidator.isValid((Object)childItem)) continue;
                storyPoints = storyPoints + childItem.getStoryPoints();
            }
            item.setStoryPoints(storyPoints);
        }
    }

    public List<Session> fetchWorkspaceSessions() {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        List<Object> piBoards = new ArrayList<Session>();
        HashSet workSpaces = new HashSet();
        List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            LOGGER.debug("Workspaces  fetched :: " + workSpaces.size());
            for (WorkSpace workSpace : workSpaces) {
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(user);
                workSpaceAccessRoles.add(accessRole);
            }
        } else {
            workSpaceAccessRoles = this.customRepository.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            piBoards = this.sessionRepository.findByWorkSpaceIn(new ArrayList(workSpaces));
        }
        return piBoards;
    }

    public void sendEmailNotitication(@RequestBody HashMap<String, Object> requestBody) {
        ArrayList<Notification> emailNotificationList = new ArrayList<Notification>();
        HashMap emailContent = new HashMap();
        HashMap recipientList = new HashMap();
        String subject = "";
        String groupingSubject = "";
        String template = "";
        try {
            if (PropertyValidator.isValid(requestBody)) {
                String emailType = (String)requestBody.get("emailType");
                if (emailType.equals("mark-complete")) {
                    emailContent = (HashMap)requestBody.get("emailContent");
                    recipientList.put(Notification.ItemType.SOS.name(), (List)requestBody.get("emailList"));
                    subject = (Date)emailContent.get("sos_Date") + " Scrum of Scrums Session Marked As Complete";
                    template = "sos_mark_complete";
                    groupingSubject = subject;
                } else if (emailType.equals("delete-imp")) {
                    emailContent = (HashMap)requestBody.get("emailContent");
                    subject = (String)emailContent.get("IMPID") + "has been Deleted from Scrum of Scrums Session";
                    template = "sos_delete_imp";
                    groupingSubject = "Impediment has been Deleted from Scrum of Scrums Session";
                    recipientList = (HashMap)requestBody.get("recipientList");
                } else if (emailType.equals("mention-user") && (String)requestBody.get("Item-type") != null) {
                    String itemType = (String)requestBody.get("Item-type");
                    subject = itemType.equals("Highlight") ? "You have been Tagged in a " + (String)requestBody.get("Item-type") : "You have been Tagged in an " + (String)requestBody.get("Item-type");
                    emailContent.put("key", (String)requestBody.get("Item-type"));
                    recipientList.put(Notification.ItemType.SOS.name(), (List)requestBody.get("emailList"));
                    emailContent.put("Item_detail", (String)requestBody.get("Item-detail"));
                    groupingSubject = subject;
                    template = "sos_tag_user";
                } else if (emailType.equals("no_work_done")) {
                    groupingSubject = subject = "Reminder for updating Scrum of Scrums ";
                    template = "sos_reminder_email";
                    recipientList.put(Notification.ItemType.SOS.name(), (List)requestBody.get("emailList"));
                    emailContent.put("Impediment", requestBody.get("Impediment") != null);
                    emailContent.put("ActionPoint", requestBody.get("ActionPoint") != null);
                    emailContent.put("Highlights", requestBody.get("Highlights") != null);
                    emailContent.put("startDate", (String)requestBody.get("sos-date"));
                }
                Notification emailNotification = new Notification();
                emailNotification.setGroupingSubject(groupingSubject);
                emailNotification.setEmailSubject(subject);
                emailNotification.setRecipientList(recipientList);
                emailNotification.setType(Notification.ItemType.SOS);
                emailNotification.setTemplate(template);
                emailNotification.setContent((Map)emailContent);
                emailNotificationList.add(emailNotification);
                if (PropertyValidator.isValid((Object)emailNotification)) {
                    this.notificationRepository.save(emailNotificationList);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.toString());
        }
    }

    public Object getFieldValueFromBaseItem(BaseItem baseItem, String fieldLabel) {
        block8: {
            try {
                Object fieldValue;
                List templateFields = new ArrayList();
                Map fieldsValue = new HashMap();
                String fieldId = "";
                if (!PropertyValidator.isValid((Object)baseItem)) break block8;
                FieldTemplate template = new FieldTemplate();
                if (PropertyValidator.isValid((Object)baseItem.getItemType())) {
                    ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(baseItem.getItemType());
                    template = itemTypeScheme.getFieldsTemplate();
                } else {
                    template = baseItem.getFieldsTemplate();
                }
                if (!PropertyValidator.isValid((Object)template)) break block8;
                templateFields = template.getConfiguredFields();
                for (Fields field : templateFields) {
                    if (PropertyValidator.isValid((Object)field.getIsGroup()) && field.getIsGroup().booleanValue()) {
                        for (Fields _field : field.getGroupFields()) {
                            if (!_field.getTitle().equals(fieldLabel)) continue;
                            fieldId = _field.getId();
                        }
                        continue;
                    }
                    if (!field.getTitle().equals(fieldLabel)) continue;
                    fieldId = field.getId();
                }
                fieldsValue = baseItem.getFields();
                if (fieldsValue.get(fieldId) instanceof ArrayList) {
                    fieldValue = (ArrayList)fieldsValue.get(fieldId);
                    return fieldValue;
                }
                fieldValue = (Map)fieldsValue.get(fieldId);
                return fieldValue;
            }
            catch (Exception ex) {
                LOGGER.error(ex.toString());
            }
        }
        return null;
    }

    public void sendEmailToWatchersAndResponsible(BaseItem baseItem, String saveType) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        HashMap<String, Object> emailRequestBody = new HashMap<String, Object>();
        HashMap<String, Object> emailContent = new HashMap<String, Object>();
        HashMap recipientList = new HashMap();
        ArrayList<String> emailList = new ArrayList<String>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        try {
            requestBody.put("entityType", "BaseItem");
            requestBody.put("entityId", baseItem.getId());
            List savedWatchers = this.externalEntitiesService.fetchWatchers(requestBody);
            Map responsible = (Map)this.getFieldValueFromBaseItem(baseItem, "Responsible");
            for (Watcher watcher : savedWatchers) {
                emailList.add(watcher.getUser().getEmail());
            }
            if (PropertyValidator.isValid((Object)responsible) && responsible.get("email") != null) {
                emailList.add((String)responsible.get("email"));
            }
            recipientList.put(Notification.ItemType.SOS.name(), emailList);
            if (PropertyValidator.isValid(emailList) && emailList.size() > 0) {
                emailRequestBody.put("recipientList", recipientList);
                emailRequestBody.put("emailType", saveType);
                emailContent.put("IMPID", baseItem.getKey());
                emailContent.put("IMPtitle", baseItem.getTitle());
                emailContent.put("dateTime", new Date());
                emailContent.put("deletedBy", user.getFirstName());
                emailRequestBody.put("emailContent", emailContent);
                this.sendEmailNotitication(emailRequestBody);
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.toString());
        }
    }

    private static HashMap<String, Object> timeZoneList(TimeZone tz) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        long hours = TimeUnit.MILLISECONDS.toHours(tz.getRawOffset());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(tz.getRawOffset()) - TimeUnit.HOURS.toMinutes(hours);
        minutes = Math.abs(minutes);
        String result = "";
        if (hours > 0L) {
            result = String.format("(GMT+%d:%02d ) %s", hours, minutes, tz.getID());
            response.put("timeZoneLabel", result);
            response.put("timeZoneGMT", hours);
        } else {
            result = String.format("(GMT%d:%02d ) %s", hours, minutes, tz.getID());
            response.put("timeZoneLabel", result);
            response.put("timeZoneGMT", hours);
        }
        response.put("timeZoneOffset", TimeUnit.MILLISECONDS.toMinutes(tz.getRawOffset()));
        response.put("timeZoneId", tz.getID());
        return response;
    }

    public void sendSOSReminderEmail(ScrumOfScrums sos) {
        try {
            HashMap<String, Object> emailMeta = new HashMap<String, Object>();
            ArrayList<String> emailList = new ArrayList<String>();
            for (Scrum scrum : sos.getScrums()) {
                if (PropertyValidator.isValid((Object)scrum.getScrumMaster())) {
                    emailList.add(scrum.getScrumMaster().getEmail());
                }
                if (!PropertyValidator.isValid((Object)scrum.getProductOwner())) continue;
                emailList.add(scrum.getProductOwner().getEmail());
            }
            Long milli = sos.getReminderMillis() + TimeUnit.MINUTES.toMillis(sos.getReminderMinutes());
            Calendar cal = Calendar.getInstance();
            LocalDateTime dt = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
            ZonedDateTime zone1 = dt.atZone(cal.getTimeZone().toZoneId());
            ZonedDateTime zone2 = dt.atZone(ZoneId.of(sos.getTimeZoneName()));
            long diff = Duration.between(zone2, zone1).toMillis();
            cal.setTime(new Date(milli + diff));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd yyyy hh:mm a");
            String nextSosDate = dateFormat.format(cal.getTime());
            emailMeta.put("sos-date", nextSosDate + " (" + sos.getTimeZoneName() + ")");
            emailMeta.put("emailList", emailList);
            emailMeta.put("emailType", "no_work_done");
            for (String reminder : sos.getRemainderList()) {
                emailMeta.put(reminder, true);
            }
            if (emailList.size() > 0) {
                this.sendEmailNotitication(emailMeta);
            }
        }
        catch (Exception ex) {
            LOGGER.debug(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void sendScrumSpecificReminderEmail(ScrumOfScrums sos, Scrum scrum) {
        try {
            HashMap<String, Object> emailMeta = new HashMap<String, Object>();
            List<Object> emailList = new ArrayList<String>();
            if (PropertyValidator.isValid((Object)scrum.getScrumMaster())) {
                emailList.add(scrum.getScrumMaster().getEmail());
            }
            if (PropertyValidator.isValid((Object)scrum.getProductOwner())) {
                emailList.add(scrum.getProductOwner().getEmail());
            }
            if (PropertyValidator.isValid((Collection)scrum.getOtherParticipants())) {
                for (User user : scrum.getOtherParticipants()) {
                    emailList.add(user.getEmail());
                }
            }
            emailList = emailList.stream().distinct().collect(Collectors.toList());
            Long milli = sos.getReminderMillis() + TimeUnit.MINUTES.toMillis(sos.getReminderMinutes());
            Calendar cal = Calendar.getInstance();
            LocalDateTime dt = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId());
            ZonedDateTime zone1 = dt.atZone(cal.getTimeZone().toZoneId());
            ZonedDateTime zone2 = dt.atZone(ZoneId.of(sos.getTimeZoneName()));
            long diff = Duration.between(zone2, zone1).toMillis();
            cal.setTime(new Date(milli + diff));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd yyyy hh:mm a");
            String nextSosDate = dateFormat.format(cal.getTime());
            emailMeta.put("sos-date", nextSosDate + " (" + sos.getTimeZoneName() + ")");
            emailMeta.put("emailList", emailList);
            emailMeta.put("emailType", "no_work_done");
            for (String reminder : scrum.getRemainderList()) {
                emailMeta.put(reminder, true);
            }
            if (emailList.size() > 0) {
                HashMap<String, Object> emailContent = new HashMap<String, Object>();
                HashMap<String, List> recipientList = new HashMap<String, List>();
                String template = "sos_reminder_email";
                recipientList.put(Notification.ItemType.SOS.name(), (List)emailMeta.get("emailList"));
                emailContent.put("Impediment", emailMeta.get("Impediment") != null);
                emailContent.put("ActionPoint", emailMeta.get("ActionPoint") != null);
                emailContent.put("Highlights", emailMeta.get("Highlights") != null);
                emailContent.put("startDate", (String)emailMeta.get("sos-date"));
                Notification emailNotification = new Notification();
                emailNotification.setEmailSubject("Reminder for updating Scrum of Scrums ");
                emailNotification.setRecipientList(recipientList);
                emailNotification.setType(Notification.ItemType.SOS);
                emailNotification.setTemplate(template);
                emailNotification.setContent(emailContent);
                this.notificationService.processSingleNotification(emailNotification);
            }
        }
        catch (Exception e) {
            LOGGER.debug(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    public List<HashMap<String, Object>> getTimeZoneList() {
        ArrayList<HashMap<String, Object>> timeZoneList = new ArrayList<HashMap<String, Object>>();
        try {
            Set<String> ids = ZoneId.getAvailableZoneIds();
            for (String id : ids) {
                timeZoneList.add(ExternalEntitiesServiceImpl.timeZoneList((TimeZone)TimeZone.getTimeZone(id)));
            }
        }
        catch (Exception ex) {
            LOGGER.debug(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return timeZoneList;
    }

    public HashMap<String, Object> getItemTypeScheme(ItemTypeScheme itemTypeScheme) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        ArrayList<String> itemTypeStr = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)itemTypeScheme)) {
            responseJson.put("scheme", itemTypeScheme);
            List statuses = this.statusRepository.findByWorkFlow(itemTypeScheme.getWorkflow());
            responseJson.put("statuses", statuses);
            if (itemTypeScheme.getItemType().getTitle().equals(EnumKendis.MILESTONE.getCode()) || itemTypeScheme.getItemType().getTitle().equals(EnumKendis.PHASES.getCode())) {
                itemTypeStr.add(EnumKendis.MILESTONE.getCode());
                itemTypeStr.add(EnumKendis.PHASES.getCode());
                List itemTypeList = this.itemTypeRepository.findByTitleIn(itemTypeStr);
                if (PropertyValidator.isValid((Collection)itemTypeList)) {
                    responseJson.put("itemTypeList", itemTypeList);
                }
            } else {
                itemTypeStr.add(EnumKendis.EPIC.getCode());
                List itemTypeList = this.itemTypeRepository.findByTitleIn(itemTypeStr);
                if (PropertyValidator.isValid((Collection)itemTypeList)) {
                    responseJson.put("itemTypeList", itemTypeList);
                }
            }
        }
        return responseJson;
    }

    public List<BaseItem> getSubItemsList(String itemId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").is((Object)new ObjectId(itemId)));
        List subItems = this.mongoTemplate.find(query, BaseItem.class);
        return subItems;
    }

    public HashMap<String, Boolean> validateBaseItem(BaseItem baseItem) {
        ItemTypeScheme itemTypeScheme;
        HashMap<String, Boolean> invalidFieldValues = new HashMap<String, Boolean>();
        FieldTemplate itemFieldTemplate = new FieldTemplate();
        Map fields = baseItem.getFields();
        if (PropertyValidator.isValid((Object)baseItem.getFieldsTemplate())) {
            itemFieldTemplate = (FieldTemplate)this.fieldTemplateRepository.findOne((Serializable)((Object)baseItem.getFieldsTemplate().getId()));
        } else if (PropertyValidator.isValid((Object)baseItem.getItemType()) && PropertyValidator.isValid((Object)(itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(baseItem.getItemType())))) {
            itemFieldTemplate = itemTypeScheme.getFieldsTemplate();
        }
        if (PropertyValidator.isValid((Object)itemFieldTemplate) && PropertyValidator.isValid((Collection)itemFieldTemplate.getConfiguredFields())) {
            for (Fields field : itemFieldTemplate.getConfiguredFields()) {
                if (!Boolean.TRUE.equals(field.getIsRequired())) continue;
                boolean invalidValue = false;
                if (field.getTitle().equals("Title")) {
                    invalidValue = !PropertyValidator.isValid((Object)baseItem.getTitle());
                } else if (field.getTitle().equals("Description")) {
                    invalidValue = !PropertyValidator.isValid((Object)baseItem.getDescription());
                } else if (field.getTitle().equals("BV Plan")) {
                    invalidValue = !PropertyValidator.isValid((Object)baseItem.getBvPlan());
                } else if (field.getTitle().equals("BV Actual")) {
                    invalidValue = !PropertyValidator.isValid((Object)baseItem.getBvActual());
                } else if (field.getTitle().equals("Status")) {
                    invalidValue = !PropertyValidator.isValid((Object)baseItem.getStatus()) && !PropertyValidator.isValid((Object)baseItem.getStatus().getId());
                } else {
                    Object fieldValue = fields.get(field.getId());
                    boolean bl = invalidValue = !PropertyValidator.isValid(fieldValue);
                }
                if (!invalidValue) continue;
                invalidFieldValues.put(field.getTitle(), invalidValue);
            }
        }
        return invalidFieldValues;
    }

    public Map extractGroupNameAndObjectiveNameFromJsonChanges(ObjectMapper mapper, Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            List _groupList;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            String linkedGroupName = null;
            String linkedGroupKey = null;
            String linkedObjectiveName = null;
            String linkedObjectiveKey = null;
            ArrayList<BaseItemLink> linkedGroupBaseItemLinks = new ArrayList<BaseItemLink>();
            String linkedObjectiveId = null;
            while (iterator.hasNext()) {
                Map.Entry<String, String> pair = iterator.next();
                if (pair.getKey().equals("id")) {
                    BaseItemLink newBaseItemLink = new BaseItemLink();
                    newBaseItemLink.setId(pair.getValue().toString());
                    linkedGroupBaseItemLinks.add(newBaseItemLink);
                    continue;
                }
                if (!pair.getKey().equals("baseItemId")) continue;
                linkedObjectiveId = pair.getValue().toString();
            }
            if (linkedGroupBaseItemLinks.size() > 0 && (_groupList = this.baseItemRepository.findByBaseItemLinksIn(linkedGroupBaseItemLinks)).size() > 0 && !((BaseItem)_groupList.get(0)).isArchive()) {
                linkedGroupName = ((BaseItem)_groupList.get(0)).getTitle();
                linkedGroupKey = ((BaseItem)_groupList.get(0)).getKey();
            }
            if (PropertyValidator.isValid(linkedObjectiveId)) {
                Query findBaseItem = new Query();
                findBaseItem.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is(linkedObjectiveId));
                findBaseItem.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne(null));
                BaseItem _baseItem = (BaseItem)this.mongoTemplate.findOne(findBaseItem, BaseItem.class);
                if (PropertyValidator.isValid((Object)_baseItem)) {
                    linkedObjectiveName = _baseItem.getTitle();
                    linkedObjectiveKey = _baseItem.getKey();
                }
            }
            result.put("group", linkedGroupName);
            result.put("groupKey", linkedGroupKey);
            result.put("objective", linkedObjectiveName);
            result.put("objectiveKey", linkedObjectiveKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Map<String, List<Item>> fetchChildItemsGroupedByParentId(List<String> parentIds, String tenant) {
        BasicDBObject matchCriteria = this.getMatchCriteriaForFetchChildItemsGroupedByParentId(parentIds, tenant);
        List childItems = this.getLinkedItemsFromQuery(matchCriteria);
        HashMap<String, List<Item>> parentChildMap = new HashMap<String, List<Item>>();
        Map sessionIdAgainstSessionBoard = null;
        Map tcIdAgainstTeamContainer = null;
        if (!PropertyValidator.isValid((Collection)childItems)) {
            return parentChildMap;
        }
        sessionIdAgainstSessionBoard = this.getUniqueSessionBoardData(childItems);
        tcIdAgainstTeamContainer = this.getUniqueTeamContainerData(childItems);
        for (Item item : childItems) {
            if (PropertyValidator.isValid((Object)sessionIdAgainstSessionBoard)) {
                ArrayList sessionBoards = new ArrayList();
                for (SessionBoard sb : item.getSessionBoards()) {
                    sessionBoards.add(sessionIdAgainstSessionBoard.get(sb.getId()));
                }
                item.setSessionBoards(sessionBoards);
            }
            if (PropertyValidator.isValid((Object)tcIdAgainstTeamContainer)) {
                ArrayList teamContainers = new ArrayList();
                for (TeamContainer tc : item.getTeamContainers()) {
                    teamContainers.add(tcIdAgainstTeamContainer.get(tc.getId()));
                }
                item.setTeamContainers(teamContainers);
            }
            String parentId = item.getParent().getId();
            item.setParent(null);
            List children = parentChildMap.getOrDefault(parentId, new ArrayList());
            children.add(item);
            parentChildMap.put(parentId, children);
        }
        return parentChildMap;
    }

    private String formatDate(Object dateInput) {
        if (dateInput instanceof Date) {
            return dateInput.toString();
        }
        try {
            return Date.from(Instant.parse((String)dateInput)).toString();
        }
        catch (Exception e) {
            return dateInput.toString();
        }
    }

    public List<String> fetchBacklogItemHistory(HashMap<String, String> requestBody) {
        String entityId = requestBody.get("entityId");
        String entityType = requestBody.get("entityType");
        String zoneOffset = requestBody.get("zoneOffset");
        Boolean isMockingMode = null != requestBody.get("isMockingMode");
        List itemList = this.backlogItemLogRepository.findByItemIdAndItemTypeOrderByCreatedOnAsc(entityId, entityType);
        ArrayList<String> historyList = new ArrayList<String>();
        List statusIds = itemList.stream().flatMap(log -> Stream.of(log.getChangeTo(), log.getChangeFrom())).filter(Objects::nonNull).map(change -> (Map)change.get("status")).filter(Objects::nonNull).map(statusMap -> statusMap.get("id").toString()).collect(Collectors.toList());
        Map<String, Status> statusesMap = this.statusRepository.findStatusByIdIn(statusIds).stream().collect(Collectors.toMap(BaseEntity::getId, status -> status));
        Set allBacklogItemIds = itemList.stream().flatMap(log -> {
            Stream<Object> fromItemIds = Stream.empty();
            Stream<Object> toItemIds = Stream.empty();
            Map changesFrom = log.getChangeFrom();
            Map changesTo = log.getChangeTo();
            if (changesFrom != null && changesFrom.containsKey("itemRelations") && PropertyValidator.isValid(changesFrom.get("itemRelations"))) {
                fromItemIds = ((List)changesFrom.get("itemRelations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                    baseItemLink.setArchive(((Boolean)map.get("archive")).booleanValue());
                    return baseItemLink;
                }).map(BaseItemLink::getBaseItemId);
            }
            if (changesTo != null && changesTo.containsKey("itemRelations") && PropertyValidator.isValid(changesTo.get("itemRelations"))) {
                toItemIds = ((List)changesTo.get("itemRelations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                    baseItemLink.setArchive(((Boolean)map.get("archive")).booleanValue());
                    return baseItemLink;
                }).map(BaseItemLink::getBaseItemId);
            }
            return Stream.concat(fromItemIds, toItemIds);
        }).collect(Collectors.toSet());
        Map<String, BacklogItem> backlogItemsMap = this.backlogItemRepository.findByIdIn(new ArrayList(allBacklogItemIds)).stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        for (BacklogItemLog backlogItemLog : itemList) {
            StringBuilder historyString = new StringBuilder();
            if (backlogItemLog.getEventType().equals(BacklogItemLog.EventType.CREATED.toString())) {
                List batchIds;
                List batches;
                String batchesInformation;
                List sessionBoardIds;
                List sessionBoards;
                String sessionInformation;
                Map artMap;
                Set artIds;
                List workSpaces;
                String workSpaceInformation;
                List timelines;
                String timelineInformation;
                List timelineRelationIds;
                String statusId;
                Status status2;
                Map statusMap2;
                historyString.append("<div>");
                historyString.append("<div>Created by " + backlogItemLog.getActivityBy() + " on " + backlogItemLog.getCreatedOn() + "</div>");
                historyString.append("<div> <ul>");
                Map changesTo = backlogItemLog.getChangeTo();
                if (changesTo.containsKey("title")) {
                    historyString.append("<li>Title changed to \"" + changesTo.get("title") + "\"</li>");
                }
                if (changesTo.containsKey("description") && PropertyValidator.isValid(changesTo.get("description"))) {
                    historyString.append("<li>Description changed to '" + changesTo.get("description") + "'</li>");
                }
                if (changesTo.containsKey("status") && (statusMap2 = (Map)changesTo.get("status")).containsKey("id") && PropertyValidator.isValid((Object)(status2 = statusesMap.get(statusId = statusMap2.get("id").toString())))) {
                    historyString.append("<li>Status changed to \"" + status2.getTitle() + "\"</li>");
                }
                if (changesTo.containsKey("fields")) {
                    List users;
                    String toUsers;
                    Map fieldsMap = (Map)changesTo.get("fields");
                    if (fieldsMap.containsKey("itemType")) {
                        historyString.append("<li>Type changed to \"" + fieldsMap.get("itemType") + "\"</li>");
                    }
                    if (fieldsMap.containsKey("StartDate")) {
                        if (fieldsMap.getOrDefault("itemType", "").equals("Milestone")) {
                            historyString.append("<li>Milestone Date changed to \"" + this.formatDate(fieldsMap.get("StartDate")) + "\"</li>");
                        } else if (PropertyValidator.isValid(fieldsMap.get("StartDate"))) {
                            historyString.append("<li>Start Date changed to \"" + this.formatDate(fieldsMap.get("StartDate")) + "\"</li>");
                        }
                    }
                    if (fieldsMap.containsKey("EndDate") && PropertyValidator.isValid(fieldsMap.get("EndDate"))) {
                        historyString.append("<li>End Date changed to \"" + this.formatDate(fieldsMap.get("EndDate")) + "\"</li>");
                    }
                    if (fieldsMap.containsKey("responsibles") && PropertyValidator.isValid(fieldsMap.get("responsibles")) && PropertyValidator.isValid((Object)(toUsers = (users = ((List)fieldsMap.get("responsibles")).stream().map(map -> {
                        User user = new User();
                        user.setId((String)map.get("id"));
                        user.setFullName((String)map.get("fullName"));
                        return user;
                    }).collect(Collectors.toList())).stream().map(user -> user.getFullName()).collect(Collectors.joining(", "))))) {
                        historyString.append("<li>Responsible(s) Changed to " + toUsers + " </li>");
                    }
                }
                if (changesTo.containsKey("relations") && PropertyValidator.isValid(changesTo.get("relations")) && PropertyValidator.isValid(timelineRelationIds = ((List)changesTo.get("relations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                    baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                    baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                    return baseItemLink;
                }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.TIMELINE_RELATION.getCode())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList())) && !timelineRelationIds.isEmpty() && PropertyValidator.isValid((Object)(timelineInformation = (timelines = this.boardRepository.findBoardByIdIn(timelineRelationIds)).stream().map(timeline -> timeline.getKey() + " " + timeline.getName()).collect(Collectors.joining(", "))))) {
                    historyString.append("<li>Timeline Relation(s) Changed to ");
                    historyString.append(timelineInformation);
                    historyString.append("</li>");
                }
                if (changesTo.containsKey("artRelationMap") && PropertyValidator.isValid(changesTo.get("artRelationMap")) && PropertyValidator.isValid((Object)(workSpaceInformation = (workSpaces = this.workSpaceRepository.findWorkSpaceByIdIn(new ArrayList(artIds = (artMap = (Map)changesTo.get("artRelationMap")).keySet()))).stream().map(workSpace -> workSpace.getKey() + " " + workSpace.getTitle()).collect(Collectors.joining(", "))))) {
                    historyString.append("<li>ART Relation(s) Changed to ");
                    historyString.append(workSpaceInformation);
                    historyString.append("</li>");
                }
                if (changesTo.containsKey("boardRelations") && PropertyValidator.isValid(changesTo.get("boardRelations")) && PropertyValidator.isValid((Object)(sessionInformation = (sessionBoards = this.sessionRepository.findSessionByIdIn(sessionBoardIds = ((List)changesTo.get("boardRelations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setSessionBoardId((String)map.get("sessionBoardId"));
                    baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                    baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                    baseItemLink.setSessionId((String)map.get("sessionId"));
                    return baseItemLink;
                }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.ART_BOARD_LINK.getCode())).map(baseItemLink -> baseItemLink.getSessionId()).collect(Collectors.toList()))).stream().map(session -> session.getTitle()).collect(Collectors.joining(", "))))) {
                    historyString.append("<li>Program Board Relation(s) Changed to ");
                    historyString.append(sessionInformation);
                    historyString.append("</li>");
                }
                if (changesTo.containsKey("batchRelations") && PropertyValidator.isValid(changesTo.get("batchRelations")) && PropertyValidator.isValid((Object)(batchesInformation = (batches = this.baseItemRepository.findByIdIn(batchIds = ((List)changesTo.get("batchRelations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                    baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                    return baseItemLink;
                }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumBaseItemTypes.BATCH.getName())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList()))).stream().map(batch -> batch.getKey() + " " + batch.getTitle()).collect(Collectors.joining(","))))) {
                    historyString.append("<li>Batch Relation(s) Changed to ");
                    historyString.append(batchesInformation);
                    historyString.append("</li>");
                }
                historyString.append("</ul></div>");
                historyString.append("</div>");
            } else if (backlogItemLog.getEventType().equals(BacklogItemLog.EventType.UPDATED.toString())) {
                List batchIds;
                List batches;
                String batchesInformation;
                List sessionBoardIds;
                List sessionBoards;
                String sessionInformation;
                Map newArtRelationMap;
                Set newArtRelationIds;
                List newWorkSpaces;
                String newWorkSpaceInformation;
                historyString.append("<div>Updated by " + backlogItemLog.getActivityBy() + " on " + backlogItemLog.getCreatedOn() + "</div>");
                historyString.append("<div> <ul>");
                Map changesFrom = backlogItemLog.getChangeFrom();
                Map changesTo = backlogItemLog.getChangeTo();
                if (changesFrom.containsKey("title") && changesTo.containsKey("title")) {
                    String titleTo;
                    String titleFrom = changesFrom.get("title").toString();
                    if (!titleFrom.equals(titleTo = changesTo.get("title").toString())) {
                        historyString.append("<li>Title changed " + titleFrom + " ---> " + titleTo + "</li>");
                    }
                } else if (changesTo.containsKey("title")) {
                    historyString.append("<li>Title changed None ---> " + changesTo.get("title") + "</li>");
                }
                if (changesFrom.containsKey("description") && changesTo.containsKey("description")) {
                    String descriptionTo;
                    String descriptionFrom = changesFrom.get("description").toString();
                    if (!descriptionFrom.equals(descriptionTo = changesTo.get("description").toString())) {
                        historyString.append("<li>Description changed " + changesFrom.get("description") + " ---> " + changesTo.get("description") + "</li>");
                    }
                } else if (changesTo.containsKey("description") && PropertyValidator.isValid(changesTo.get("description"))) {
                    historyString.append("<li>Description changed None ---> " + changesTo.get("description") + "</li>");
                }
                if (changesFrom.containsKey("status") && changesTo.containsKey("status")) {
                    Map statusMapFrom = (Map)changesFrom.get("status");
                    Map statusMapTo = (Map)changesTo.get("status");
                    if (statusMapFrom.containsKey("id") && statusMapTo.containsKey("id")) {
                        String fromStatusId = statusMapFrom.get("id").toString();
                        String toStatusId = statusMapTo.get("id").toString();
                        Status statusFrom = statusesMap.get(fromStatusId);
                        Status statusTo = statusesMap.get(toStatusId);
                        if (PropertyValidator.isValid((Object)statusFrom) && PropertyValidator.isValid((Object)statusTo) && !statusFrom.equals((Object)statusTo)) {
                            historyString.append("<li>Status changed  " + statusFrom.getTitle() + " ---> " + statusTo.getTitle() + "</li>");
                        }
                    }
                }
                if (changesFrom.containsKey("fields") && changesTo.containsKey("fields")) {
                    List toResponsibles;
                    String toUsers;
                    List toTags;
                    String to;
                    String toItemType;
                    Map fieldsMapFrom = (Map)changesFrom.get("fields");
                    Map fieldsMapTo = (Map)changesTo.get("fields");
                    String fromItemType = fieldsMapFrom.getOrDefault("itemType", "").toString();
                    if (!fromItemType.equals(toItemType = fieldsMapTo.getOrDefault("itemType", "").toString())) {
                        historyString.append("<li>Type changed " + fieldsMapFrom.get("itemType") + " ---> " + fieldsMapTo.get("itemType") + "</li>");
                    }
                    if (fieldsMapFrom.containsKey("StartDate") && fieldsMapTo.containsKey("StartDate")) {
                        String toStartDate;
                        String fromStartDate = fieldsMapFrom.get("StartDate").toString();
                        if (!fromStartDate.equals(toStartDate = fieldsMapTo.get("StartDate").toString())) {
                            if (fromItemType.equals("Milestone") && toItemType.equals("Milestone")) {
                                historyString.append("<li>Milestone Date changed " + this.formatDate((Object)fromStartDate) + " ---> " + this.formatDate((Object)toStartDate) + "</li>");
                            } else {
                                historyString.append("<li>Start Date changed " + this.formatDate((Object)fromStartDate) + " ---> " + this.formatDate((Object)toStartDate) + "</li>");
                            }
                        }
                    } else if (fieldsMapTo.containsKey("StartDate")) {
                        historyString.append("<li>Start Date changed None ---> " + this.formatDate(fieldsMapTo.get("StartDate")) + "</li>");
                    }
                    if (fieldsMapFrom.containsKey("EndDate") && fieldsMapTo.containsKey("EndDate")) {
                        String toEndDate;
                        String fromEndDate = fieldsMapFrom.get("EndDate").toString();
                        if (!fromEndDate.equals(toEndDate = fieldsMapTo.get("EndDate").toString())) {
                            historyString.append("<li>End Date changed " + this.formatDate((Object)fromEndDate) + " ---> " + this.formatDate((Object)toEndDate) + "</li>");
                        }
                    } else if (fieldsMapTo.containsKey("EndDate")) {
                        historyString.append("<li>End Date changed  None ---> " + this.formatDate(fieldsMapTo.get("EndDate")) + "</li>");
                    }
                    if (fieldsMapFrom.containsKey("historyTags") && fieldsMapTo.containsKey("historyTags")) {
                        List fromTags = ((List)fieldsMapFrom.get("historyTags")).stream().map(tag -> this.formatDate(tag)).collect(Collectors.toList());
                        List toTags2 = ((List)fieldsMapTo.get("historyTags")).stream().map(tag -> this.formatDate(tag)).collect(Collectors.toList());
                        String from = fromTags.stream().collect(Collectors.joining(", "));
                        String to2 = toTags2.stream().collect(Collectors.joining(" ,"));
                        if (PropertyValidator.isValid((Object)from) && PropertyValidator.isValid((Object)to2)) {
                            if (!from.equals(to2)) {
                                historyString.append("<li>History Tags Changed from " + from + " ---> " + to2 + "</li>");
                            }
                        } else if (PropertyValidator.isValid((Object)from)) {
                            historyString.append("<li>History Tags Changed from " + from + " ---> None</li>");
                        } else if (PropertyValidator.isValid((Object)to2)) {
                            historyString.append("<li>History Tags Changed from None ---> " + to2 + "</li>");
                        }
                    } else if (fieldsMapTo.containsKey("historyTags") && PropertyValidator.isValid((Object)(to = (toTags = ((List)fieldsMapTo.get("historyTags")).stream().map(tag -> this.formatDate(tag)).collect(Collectors.toList())).stream().collect(Collectors.joining(" ,"))))) {
                        historyString.append("<li>History Tags Changed from None ---> " + to + "</li>");
                    }
                    if (fieldsMapFrom.containsKey("responsibles") && fieldsMapTo.containsKey("responsibles")) {
                        List fromResponsibles = ((List)fieldsMapFrom.get("responsibles")).stream().map(map -> {
                            User user = new User();
                            user.setId((String)map.get("id"));
                            user.setFullName((String)map.get("fullName"));
                            return user;
                        }).collect(Collectors.toList());
                        List toResponsibles2 = ((List)fieldsMapTo.get("responsibles")).stream().map(map -> {
                            User user = new User();
                            user.setId((String)map.get("id"));
                            user.setFullName((String)map.get("fullName"));
                            return user;
                        }).collect(Collectors.toList());
                        String fromUsers = fromResponsibles.stream().map(user -> user.getFullName()).collect(Collectors.joining(", "));
                        String toUsers2 = toResponsibles2.stream().map(user -> user.getFullName()).collect(Collectors.joining(", "));
                        if (PropertyValidator.isValid((Object)fromUsers) && PropertyValidator.isValid((Object)toUsers2)) {
                            if (!fromUsers.equals(toUsers2)) {
                                historyString.append("<li>Responsible(s) Changed from " + fromUsers + " ---> " + toUsers2 + "</li>");
                            }
                        } else if (PropertyValidator.isValid((Object)fromUsers)) {
                            historyString.append("<li>Responsible(s) Changed from " + fromUsers + " ---> None</li>");
                        } else if (PropertyValidator.isValid((Object)toUsers2)) {
                            historyString.append("<li>Responsible(s) Changed from None ---> " + toUsers2 + "</li>");
                        }
                    } else if (fieldsMapTo.containsKey("responsibles") && PropertyValidator.isValid((Object)(toUsers = (toResponsibles = ((List)fieldsMapTo.get("responsibles")).stream().map(map -> {
                        User user = new User();
                        user.setId((String)map.get("id"));
                        user.setFullName((String)map.get("fullName"));
                        return user;
                    }).collect(Collectors.toList())).stream().map(user -> user.getFullName()).collect(Collectors.joining(", "))))) {
                        historyString.append("<li>Responsible(s) Changed from None ---> " + toUsers + "</li>");
                    }
                }
                if (PropertyValidator.isValid(changesFrom.get("relations")) && PropertyValidator.isValid(changesTo.get("relations"))) {
                    List oldTimelineRelationIds = ((List)changesFrom.get("relations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                        baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.TIMELINE_RELATION.getCode())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList());
                    List newTimelineRelationIds = ((List)changesTo.get("relations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                        baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.TIMELINE_RELATION.getCode())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList());
                    List oldTimelines = this.boardRepository.findBoardByIdIn(oldTimelineRelationIds);
                    List newTimelines = this.boardRepository.findBoardByIdIn(newTimelineRelationIds);
                    String oldTimelineInformation = oldTimelines.stream().map(timeline -> timeline.getKey() + " " + timeline.getName()).collect(Collectors.joining(", "));
                    String newTimelineInformation = newTimelines.stream().map(timeline -> timeline.getKey() + " " + timeline.getName()).collect(Collectors.joining(", "));
                    if (PropertyValidator.isValid((Object)oldTimelineInformation) && PropertyValidator.isValid((Object)newTimelineInformation)) {
                        if (!oldTimelineInformation.equals(newTimelineInformation)) {
                            historyString.append("<li>Timeline Relation(s) changes from ");
                            historyString.append(oldTimelineInformation);
                            historyString.append(" ---> " + newTimelineInformation);
                            historyString.append("</li>");
                        }
                    } else if (PropertyValidator.isValid((Object)oldTimelineInformation)) {
                        historyString.append("<li>Timeline Relation(s) changes from ");
                        historyString.append(oldTimelineInformation);
                        historyString.append(" ---> None");
                        historyString.append("</li>");
                    } else if (PropertyValidator.isValid((Object)newTimelineInformation)) {
                        historyString.append("<li>Timeline Relation(s) changes from None");
                        historyString.append(" ---> " + newTimelineInformation);
                        historyString.append("</li>");
                    }
                } else if (PropertyValidator.isValid(changesTo.get("relations"))) {
                    List newTimelines;
                    String newTimelineInformation;
                    List newTimelineRelationIds = ((List)changesTo.get("relations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                        baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.TIMELINE_RELATION.getCode())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList());
                    if (PropertyValidator.isValid(newTimelineRelationIds) && PropertyValidator.isValid((Object)(newTimelineInformation = (newTimelines = this.boardRepository.findBoardByIdIn(newTimelineRelationIds)).stream().map(timeline -> timeline.getKey() + " " + timeline.getName()).collect(Collectors.joining(", "))))) {
                        historyString.append("<li>Timeline Relation(s) changed from None ---> ");
                        historyString.append(newTimelineInformation);
                        historyString.append("</li>");
                    }
                    historyString.append("</ul></div>");
                    historyString.append("</div>");
                }
                if (PropertyValidator.isValid(changesFrom.get("artRelationMap")) && PropertyValidator.isValid(changesTo.get("artRelationMap"))) {
                    Map oldArtRelationMap = (Map)changesFrom.get("artRelationMap");
                    Map newArtRelationMap2 = (Map)changesTo.get("artRelationMap");
                    Set oldArtRelationIds = oldArtRelationMap.keySet();
                    Set newArtRelationIds2 = newArtRelationMap2.keySet();
                    List oldWorkSpaces = this.workSpaceRepository.findWorkSpaceByIdIn(new ArrayList(oldArtRelationIds));
                    List newWorkSpaces2 = this.workSpaceRepository.findWorkSpaceByIdIn(new ArrayList(newArtRelationIds2));
                    String oldWorkSpaceInformation = oldWorkSpaces.stream().map(workSpace -> workSpace.getKey() + " " + workSpace.getTitle()).collect(Collectors.joining(", "));
                    String newWorkSpaceInformation2 = newWorkSpaces2.stream().map(workSpace -> workSpace.getKey() + " " + workSpace.getTitle()).collect(Collectors.joining(", "));
                    if (PropertyValidator.isValid((Object)oldWorkSpaceInformation) && PropertyValidator.isValid((Object)newWorkSpaceInformation2)) {
                        if (!oldWorkSpaceInformation.equals(newWorkSpaceInformation2)) {
                            historyString.append("<li>Art Relation(s) changes from ");
                            historyString.append(oldWorkSpaceInformation);
                            historyString.append(" ---> " + newWorkSpaceInformation2);
                            historyString.append("</li>");
                        }
                    } else if (PropertyValidator.isValid((Object)oldWorkSpaceInformation)) {
                        historyString.append("<li>Art Relation(s) changes from ");
                        historyString.append(oldWorkSpaceInformation);
                        historyString.append(" ---> None");
                        historyString.append("</li>");
                    } else if (PropertyValidator.isValid((Object)newWorkSpaceInformation2)) {
                        historyString.append("<li>Art Relation(s) changes from ");
                        historyString.append("None ---> " + newWorkSpaceInformation2);
                        historyString.append("</li>");
                    }
                } else if (PropertyValidator.isValid(changesTo.get("artRelationMap")) && PropertyValidator.isValid((Object)(newWorkSpaceInformation = (newWorkSpaces = this.workSpaceRepository.findWorkSpaceByIdIn(new ArrayList(newArtRelationIds = (newArtRelationMap = (Map)changesTo.get("artRelationMap")).keySet()))).stream().map(workSpace -> workSpace.getKey() + " " + workSpace.getTitle()).collect(Collectors.joining(", "))))) {
                    historyString.append("<li>Art Relation(s) changes from ");
                    historyString.append("None ---> " + newWorkSpaceInformation);
                    historyString.append("</li>");
                }
                if (PropertyValidator.isValid(changesFrom.get("boardRelations")) && PropertyValidator.isValid(changesTo.get("boardRelations"))) {
                    List oldSessionBoardIds = ((List)changesFrom.get("boardRelations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setSessionBoardId((String)map.get("sessionBoardId"));
                        baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        baseItemLink.setSessionId((String)map.get("sessionId"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.ART_BOARD_LINK.getCode())).map(baseItemLink -> baseItemLink.getSessionId()).collect(Collectors.toList());
                    List newSessionBoardIds = ((List)changesTo.get("boardRelations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setSessionBoardId((String)map.get("sessionBoardId"));
                        baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        baseItemLink.setSessionId((String)map.get("sessionId"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.ART_BOARD_LINK.getCode())).map(baseItemLink -> baseItemLink.getSessionId()).collect(Collectors.toList());
                    List oldSessionBoards = this.sessionRepository.findSessionByIdIn(oldSessionBoardIds);
                    List newSessionBoards = this.sessionRepository.findSessionByIdIn(newSessionBoardIds);
                    String oldSessionInformation = oldSessionBoards.stream().map(session -> session.getTitle()).collect(Collectors.joining(", "));
                    String newSessionInformation = newSessionBoards.stream().map(session -> session.getTitle()).collect(Collectors.joining(", "));
                    if (PropertyValidator.isValid((Object)oldSessionInformation) && PropertyValidator.isValid((Object)newSessionInformation)) {
                        if (!oldSessionInformation.equals(newSessionInformation)) {
                            historyString.append("<li>Program Board Relation(s) Changes  ");
                            historyString.append(oldSessionInformation + " ---> " + newSessionInformation);
                            historyString.append("</li>");
                        }
                    } else if (PropertyValidator.isValid((Object)oldSessionInformation)) {
                        historyString.append("<li>Program Board Relation(s) Changes  ");
                        historyString.append(oldSessionInformation + " ---> None");
                        historyString.append("</li>");
                    } else if (PropertyValidator.isValid((Object)newSessionInformation)) {
                        historyString.append("<li>Program Board Relation(s) Changes  ");
                        historyString.append("None ---> " + newSessionInformation);
                        historyString.append("</li>");
                    }
                } else if (PropertyValidator.isValid(changesTo.get("boardRelations")) && PropertyValidator.isValid((Object)(sessionInformation = (sessionBoards = this.sessionRepository.findSessionByIdIn(sessionBoardIds = ((List)changesTo.get("boardRelations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setSessionBoardId((String)map.get("sessionBoardId"));
                    baseItemLink.setReleaseTrainId((String)map.get("releaseTrainId"));
                    baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                    baseItemLink.setSessionId((String)map.get("sessionId"));
                    return baseItemLink;
                }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.ART_BOARD_LINK.getCode())).map(baseItemLink -> baseItemLink.getSessionId()).collect(Collectors.toList()))).stream().map(session -> session.getTitle()).collect(Collectors.joining(", "))))) {
                    historyString.append("<li>Program Board Relation(s) Changes from None ---> ");
                    historyString.append(sessionInformation);
                    historyString.append("</li>");
                }
                if (PropertyValidator.isValid(changesFrom.get("batchRelations")) && PropertyValidator.isValid(changesTo.get("batchRelations"))) {
                    List oldBatchIds = ((List)changesFrom.get("batchRelations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumBaseItemTypes.BATCH.getName())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList());
                    List newBatchIds = ((List)changesTo.get("batchRelations")).stream().map(map -> {
                        BaseItemLink baseItemLink = new BaseItemLink();
                        baseItemLink.setLinkType((String)map.get("linkType"));
                        baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                        baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                        return baseItemLink;
                    }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumBaseItemTypes.BATCH.getName())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList());
                    List oldBatches = this.baseItemRepository.findByIdIn(oldBatchIds);
                    List newBatches = this.baseItemRepository.findByIdIn(newBatchIds);
                    String oldBatchesInformation = oldBatches.stream().map(batch -> batch.getKey() + " " + batch.getTitle()).collect(Collectors.joining(","));
                    String newBatchesInformation = newBatches.stream().map(batch -> batch.getKey() + " " + batch.getTitle()).collect(Collectors.joining(","));
                    if (PropertyValidator.isValid((Object)oldBatchesInformation) && PropertyValidator.isValid((Object)newBatchesInformation)) {
                        if (!oldBatchesInformation.equals(newBatchesInformation)) {
                            historyString.append("<li>Batch Relation(s) Changes ");
                            historyString.append(oldBatchesInformation + " ---> " + newBatchesInformation);
                            historyString.append("</li>");
                        }
                    } else if (PropertyValidator.isValid((Object)oldBatchesInformation)) {
                        historyString.append("<li>Batch Relation(s) Changes ");
                        historyString.append(oldBatchesInformation + " ---> None");
                        historyString.append("</li>");
                    } else if (PropertyValidator.isValid((Object)newBatchesInformation)) {
                        historyString.append("<li>Batch Relation(s) Changes ");
                        historyString.append("None ---> " + newBatchesInformation);
                        historyString.append("</li>");
                    }
                } else if (changesTo.containsKey("batchRelations") && PropertyValidator.isValid(changesTo.get("batchRelations")) && PropertyValidator.isValid((Object)(batchesInformation = (batches = this.baseItemRepository.findByIdIn(batchIds = ((List)changesTo.get("batchRelations")).stream().map(map -> {
                    BaseItemLink baseItemLink = new BaseItemLink();
                    baseItemLink.setLinkType((String)map.get("linkType"));
                    baseItemLink.setBaseItemId((String)map.get("baseItemId"));
                    baseItemLink.setIsSystemLink((Boolean)map.get("isSystemLink"));
                    return baseItemLink;
                }).filter(baseItemLink -> baseItemLink.getLinkType().equals(EnumBaseItemTypes.BATCH.getName())).map(baseItemLink -> baseItemLink.getBaseItemId()).collect(Collectors.toList()))).stream().map(batch -> batch.getKey() + " " + batch.getTitle()).collect(Collectors.joining(","))))) {
                    historyString.append("<li>Batch Relation(s) Changes None ---> ");
                    historyString.append(batchesInformation);
                    historyString.append("</li>");
                }
                if (PropertyValidator.isValid(changesFrom.get("itemRelations")) && PropertyValidator.isValid(changesTo.get("itemRelations"))) {
                    List oldItemIds = ((List)changesFrom.get("itemRelations")).stream().map(map -> (String)map.get("baseItemId")).filter(allBacklogItemIds::contains).collect(Collectors.toList());
                    List newItemIds = ((List)changesTo.get("itemRelations")).stream().map(map -> (String)map.get("baseItemId")).filter(allBacklogItemIds::contains).collect(Collectors.toList());
                    String oldItemsInformation = oldItemIds.stream().map(backlogItemsMap::get).filter(Objects::nonNull).map(BaseItem::getTitle).collect(Collectors.joining(", "));
                    String newItemsInformation = newItemIds.stream().map(backlogItemsMap::get).filter(Objects::nonNull).map(BaseItem::getTitle).collect(Collectors.joining(", "));
                    if (PropertyValidator.isValid((Object)oldItemsInformation) && PropertyValidator.isValid((Object)newItemsInformation)) {
                        if (!oldItemsInformation.equals(newItemsInformation)) {
                            historyString.append("<li>Item Relation(s) Changes ");
                            historyString.append(oldItemsInformation + " ---> " + newItemsInformation);
                            historyString.append("</li>");
                        }
                    } else if (PropertyValidator.isValid((Object)oldItemsInformation)) {
                        historyString.append("<li>Item Relation(s) Changes ");
                        historyString.append(oldItemsInformation + " ---> None");
                        historyString.append("</li>");
                    } else if (PropertyValidator.isValid((Object)newItemsInformation)) {
                        historyString.append("<li>Item Relation(s) Changes ");
                        historyString.append("None ---> " + newItemsInformation);
                        historyString.append("</li>");
                    }
                } else if (changesTo.containsKey("itemRelations") && PropertyValidator.isValid(changesTo.get("itemRelations"))) {
                    List backlogItemIds = ((List)changesFrom.get("itemRelations")).stream().map(map -> (String)map.get("baseItemId")).filter(allBacklogItemIds::contains).collect(Collectors.toList());
                    String itemInformation = backlogItemIds.stream().map(backlogItemsMap::get).filter(Objects::nonNull).map(BaseItem::getTitle).collect(Collectors.joining(", "));
                    if (PropertyValidator.isValid((Object)itemInformation)) {
                        historyString.append("<li>Item Relation(s) Changes None ---> ");
                        historyString.append(itemInformation);
                        historyString.append("</li>");
                    }
                }
            }
            historyList.add(historyString.toString());
        }
        Collections.reverse(historyList);
        return historyList;
    }

    public void fetchChildItemsGroupedByParentIdForSessions(List<ObjectiveServiceVO> objectiveServiceVOs, String tenant) {
        if (!PropertyValidator.isValid(objectiveServiceVOs)) {
            return;
        }
        LinkedList parentIds = new LinkedList();
        objectiveServiceVOs.forEach(objectiveServiceVO -> parentIds.addAll(objectiveServiceVO.getParentIds()));
        Map parentChildMap = this.fetchChildItemsGroupedByParentId(parentIds, tenant);
        if (PropertyValidator.isValid((Object)parentChildMap)) {
            objectiveServiceVOs.forEach(objectiveServiceVO -> {
                objectiveServiceVO.setParentChildItemsMap(new HashMap());
                objectiveServiceVO.getParentIds().forEach(parentId -> {
                    List cfr_ignored_0 = (List)objectiveServiceVO.getParentChildItemsMap().put(parentId, parentChildMap.get(parentId));
                });
            });
        }
    }

    public ItemType fetchCheckInTemplate() {
        ItemType checkInItemType = this.itemTypeRepository.findByTitle(EnumKendis.CHECK_IN.getCode());
        if (!PropertyValidator.isValid((Object)checkInItemType)) {
            checkInItemType = new ItemType();
            checkInItemType.setTitle(EnumKendis.CHECK_IN.getCode());
            checkInItemType.setNested(false);
            checkInItemType = (ItemType)this.itemTypeRepository.save((Object)checkInItemType);
            FieldTemplate checkInFT = new FieldTemplate();
            List<Object> fields = new ArrayList<Fields>();
            fields.add(new Fields("1", "", "textarea", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null));
            fields.add(new Fields("2", "Responsible", "userpicker", null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, 4, null));
            fields = this.fieldsRepository.save(fields);
            checkInFT.setConfiguredFields(fields);
            checkInFT.setType(EnumKendis.CHECK_IN.getCode());
            checkInFT = (FieldTemplate)this.fieldTemplateRepository.save((Object)checkInFT);
            ItemTypeScheme objectiveGroupItemTypeScheme = new ItemTypeScheme();
            objectiveGroupItemTypeScheme.setItemType(checkInItemType);
            objectiveGroupItemTypeScheme.setFieldsTemplate(checkInFT);
            objectiveGroupItemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)objectiveGroupItemTypeScheme);
        }
        return checkInItemType;
    }

    public HashMap<String, Object> saveCheckIn(HashMap<String, Object> params) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Map checkInMap = new HashMap();
        String contextId = null;
        if (params.containsKey("contextId")) {
            contextId = (String)params.get("contextId");
        }
        if (params.containsKey("checkIn")) {
            checkInMap = (Map)params.get("checkIn");
        }
        HashSet mentionedEmails = new HashSet();
        if (params.containsKey("mentionedUsers")) {
            mentionedEmails.addAll((List)params.get("mentionedUsers"));
        }
        List mentionedObjectiveIds = new ArrayList();
        if (params.containsKey("mentionedObjectives")) {
            mentionedObjectiveIds = (List)params.get("mentionedObjectives");
        }
        String checkInBaseUrl = null;
        if (params.containsKey("checkInBaseUrl")) {
            checkInBaseUrl = (String)params.get("checkInBaseUrl");
        }
        User user = null;
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            user = UserContextUtil.getUserContext().getLoggedInUser();
        }
        String userFullName = user.getFullName();
        String checkInId = null;
        BaseItem baseItem = null;
        if (checkInMap.containsKey("id")) {
            checkInId = (String)checkInMap.get("id");
        }
        String checkInTitle = checkInMap.getOrDefault("title", "").toString();
        String checkInDescription = checkInMap.getOrDefault("description", "").toString();
        if (PropertyValidator.isValid((Object)checkInId)) {
            String title;
            baseItem = this.baseItemRepository.findById(checkInId);
            if (checkInMap.containsKey("title") && (title = checkInMap.get("title").toString().trim()).length() > 0) {
                baseItem.setTitle(title);
            }
            if (checkInMap.containsKey("description")) {
                String description = (String)checkInMap.get("description");
                baseItem.setDescription(description);
            }
            BaseItem savedItem = (BaseItem)this.baseItemRepository.save((Object)baseItem);
            response.put("checkIn", savedItem);
            User basicUserInfo = this.userRepository.findBasicUserInfoByUserName(savedItem.getCreatedBy());
            HashMap<String, User> usersByUsername = new HashMap<String, User>();
            if (PropertyValidator.isValid((Object)basicUserInfo)) {
                usersByUsername.put(basicUserInfo.getUserName(), basicUserInfo);
            }
            response.put("usersByUsername", usersByUsername);
            String updatedCheckInUrl = "";
            if (PropertyValidator.isValid((Object)checkInBaseUrl)) {
                updatedCheckInUrl = checkInBaseUrl.contains("/checkin/") ? checkInBaseUrl : (checkInBaseUrl.endsWith("/") ? checkInBaseUrl + "checkin/" + baseItem.getId() : checkInBaseUrl + "/checkin/" + baseItem.getId());
            }
            String finalCheckInUrl = updatedCheckInUrl;
            if (PropertyValidator.isValid(mentionedEmails) && PropertyValidator.isValid(mentionedObjectiveIds)) {
                List finalMentionedObjectiveIds = mentionedObjectiveIds;
                new Thread(() -> {
                    List objectives = this.baseItemRepository.findByIdIn(finalMentionedObjectiveIds);
                    for (BaseItem objective : objectives) {
                        HashMap<String, String> requestBody = new HashMap<String, String>();
                        requestBody.put("entityId", objective.getId());
                        requestBody.put("entityType", "BaseItem");
                        List watchers = this.fetchWatchers(requestBody);
                        mentionedEmails.addAll(watchers.stream().filter(watcher -> PropertyValidator.isValid((Object)watcher.getUser()) && PropertyValidator.isValid((Object)watcher.getUser().getEmail())).map(watcher -> watcher.getUser().getEmail()).collect(Collectors.toSet()));
                    }
                    HashMap<String, Object> requestParams = new HashMap<String, Object>();
                    requestParams.put("flag", false);
                    requestParams.put("checkInUrl", finalCheckInUrl);
                    requestParams.put("checkInTitle", checkInTitle);
                    requestParams.put("checkInDescription", checkInDescription);
                    requestParams.put("creator", userFullName);
                    requestParams.put("time", new SimpleDateFormat("HH:mm:ss a").format(Calendar.getInstance().getTime()));
                    this.notificationService.sendCheckInEmail(requestParams, mentionedEmails);
                }).start();
            } else if (PropertyValidator.isValid(mentionedObjectiveIds)) {
                List finalMentionedObjectiveIds = mentionedObjectiveIds;
                new Thread(() -> {
                    List objectives = this.baseItemRepository.findByIdIn(finalMentionedObjectiveIds);
                    for (BaseItem objective : objectives) {
                        HashMap<String, String> requestBody = new HashMap<String, String>();
                        requestBody.put("entityId", objective.getId());
                        requestBody.put("entityType", "BaseItem");
                        List watchers = this.fetchWatchers(requestBody);
                        mentionedEmails.addAll(watchers.stream().filter(watcher -> PropertyValidator.isValid((Object)watcher.getUser()) && PropertyValidator.isValid((Object)watcher.getUser().getEmail())).map(watcher -> watcher.getUser().getEmail()).collect(Collectors.toSet()));
                    }
                    HashMap<String, Object> requestParams = new HashMap<String, Object>();
                    requestParams.put("flag", false);
                    requestParams.put("checkInUrl", finalCheckInUrl);
                    requestParams.put("checkInTitle", checkInTitle);
                    requestParams.put("checkInDescription", checkInDescription);
                    requestParams.put("creator", userFullName);
                    requestParams.put("time", new SimpleDateFormat("HH:mm:ss a").format(Calendar.getInstance().getTime()));
                    this.notificationService.sendCheckInEmail(requestParams, mentionedEmails);
                }).start();
            } else if (PropertyValidator.isValid(mentionedEmails)) {
                new Thread(() -> {
                    HashMap<String, Object> requestParams = new HashMap<String, Object>();
                    requestParams.put("flag", false);
                    requestParams.put("checkInUrl", finalCheckInUrl);
                    requestParams.put("checkInTitle", checkInTitle);
                    requestParams.put("checkInDescription", checkInDescription);
                    requestParams.put("creator", userFullName);
                    requestParams.put("time", new SimpleDateFormat("HH:mm:ss a").format(Calendar.getInstance().getTime()));
                    this.notificationService.sendCheckInEmail(requestParams, mentionedEmails);
                }).start();
            }
        } else {
            String title;
            baseItem = new BaseItem();
            WorkSpace ws = this.workSpaceRepository.findByIsModuleIsTrueAndModuleType(EnumWorkSpaceType.OBJECTIVES.getValue());
            if (!contextId.equals("-1")) {
                ws = this.workSpaceRepository.findByIdOrKey(contextId, contextId);
            }
            HashMap<String, BaseItemLink> relationMap = new HashMap<String, BaseItemLink>();
            BaseItemLink relation = new BaseItemLink();
            if (PropertyValidator.isValid((Object)ws)) {
                relation.setId(ws.getModuleType() + "_" + ws.getId());
                relation.setLinkType(ws.getModuleType());
                relationMap.put(ws.getId(), relation);
            } else {
                BaseItem batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)contextId));
                if (PropertyValidator.isValid((Object)batch)) {
                    relation.setId("Batch_" + batch.getId());
                    relation.setLinkType("Batch");
                    relationMap.put(batch.getId(), relation);
                } else {
                    Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)contextId));
                    relation.setId("Session_" + session.getId());
                    relation.setLinkType("Session");
                    relationMap.put(session.getId(), relation);
                }
            }
            baseItem.setRelationMap(relationMap);
            ItemType itemType = this.fetchCheckInTemplate();
            baseItem.setItemType(itemType);
            if (checkInMap.containsKey("title") && (title = checkInMap.get("title").toString().trim()).length() > 0) {
                baseItem.setTitle(title);
            }
            if (checkInMap.containsKey("description")) {
                String description = (String)checkInMap.get("description");
                baseItem.setDescription(description);
            }
            BaseItem savedItem = (BaseItem)this.baseItemRepository.save((Object)baseItem);
            response.put("checkIn", savedItem);
            User basicUserInfo = this.userRepository.findBasicUserInfoByUserName(savedItem.getCreatedBy());
            HashMap<String, User> usersByUsername = new HashMap<String, User>();
            usersByUsername.put(basicUserInfo.getUserName(), basicUserInfo);
            response.put("usersByUsername", usersByUsername);
            String updatedCheckInUrl = "";
            if (PropertyValidator.isValid((Object)checkInBaseUrl)) {
                updatedCheckInUrl = checkInBaseUrl.contains("/checkin/") ? checkInBaseUrl : (checkInBaseUrl.endsWith("/") ? checkInBaseUrl + "checkin/" + baseItem.getId() : checkInBaseUrl + "/checkin/" + baseItem.getId());
            }
            String finalCheckInUrl = updatedCheckInUrl;
            if (PropertyValidator.isValid(mentionedEmails) && PropertyValidator.isValid(mentionedObjectiveIds)) {
                List finalMentionedObjectiveIds = mentionedObjectiveIds;
                new Thread(() -> {
                    List objectives = this.baseItemRepository.findByIdIn(finalMentionedObjectiveIds);
                    for (BaseItem objective : objectives) {
                        HashMap<String, String> requestBody = new HashMap<String, String>();
                        requestBody.put("entityId", objective.getId());
                        requestBody.put("entityType", "BaseItem");
                        List watchers = this.fetchWatchers(requestBody);
                        mentionedEmails.addAll(watchers.stream().filter(watcher -> PropertyValidator.isValid((Object)watcher.getUser()) && PropertyValidator.isValid((Object)watcher.getUser().getEmail())).map(watcher -> watcher.getUser().getEmail()).collect(Collectors.toSet()));
                    }
                    HashMap<String, Object> requestParams = new HashMap<String, Object>();
                    requestParams.put("flag", true);
                    requestParams.put("checkInUrl", finalCheckInUrl);
                    requestParams.put("checkInTitle", checkInTitle);
                    requestParams.put("checkInDescription", checkInDescription);
                    requestParams.put("creator", userFullName);
                    requestParams.put("time", new SimpleDateFormat("HH:mm:ss a").format(Calendar.getInstance().getTime()));
                    this.notificationService.sendCheckInEmail(requestParams, mentionedEmails);
                }).start();
            } else if (PropertyValidator.isValid(mentionedObjectiveIds)) {
                List finalMentionedObjectiveIds = mentionedObjectiveIds;
                new Thread(() -> {
                    List objectives = this.baseItemRepository.findByIdIn(finalMentionedObjectiveIds);
                    for (BaseItem objective : objectives) {
                        HashMap<String, String> requestBody = new HashMap<String, String>();
                        requestBody.put("entityId", objective.getId());
                        requestBody.put("entityType", "BaseItem");
                        List watchers = this.fetchWatchers(requestBody);
                        mentionedEmails.addAll(watchers.stream().filter(watcher -> PropertyValidator.isValid((Object)watcher.getUser()) && PropertyValidator.isValid((Object)watcher.getUser().getEmail())).map(watcher -> watcher.getUser().getEmail()).collect(Collectors.toSet()));
                    }
                    HashMap<String, Object> requestParams = new HashMap<String, Object>();
                    requestParams.put("flag", true);
                    requestParams.put("checkInUrl", finalCheckInUrl);
                    requestParams.put("checkInTitle", checkInTitle);
                    requestParams.put("checkInDescription", checkInDescription);
                    requestParams.put("creator", userFullName);
                    requestParams.put("time", new SimpleDateFormat("HH:mm:ss a").format(Calendar.getInstance().getTime()));
                    this.notificationService.sendCheckInEmail(requestParams, mentionedEmails);
                }).start();
            } else if (PropertyValidator.isValid(mentionedEmails)) {
                new Thread(() -> {
                    HashMap<String, Object> requestParams = new HashMap<String, Object>();
                    requestParams.put("flag", true);
                    requestParams.put("checkInUrl", finalCheckInUrl);
                    requestParams.put("checkInTitle", checkInTitle);
                    requestParams.put("checkInDescription", checkInDescription);
                    requestParams.put("creator", userFullName);
                    requestParams.put("time", new SimpleDateFormat("HH:mm:ss a").format(Calendar.getInstance().getTime()));
                    this.notificationService.sendCheckInEmail(requestParams, mentionedEmails);
                }).start();
            }
        }
        return response;
    }

    public HashMap<String, Object> fetchCheckIns(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String relationId = (String)requestBody.get("relationId");
        Integer pageIndex = (Integer)requestBody.get("pageIndex");
        Integer pageSize = (Integer)requestBody.get("pageSize");
        String searchQuery = (String)requestBody.get("searchQuery");
        if (PropertyValidator.isValid((Object)relationId)) {
            WorkSpace ws = (WorkSpace)this.workSpaceRepository.findOne((Serializable)((Object)relationId));
            BaseItem batch = new BaseItem();
            Session session = new Session();
            if (!PropertyValidator.isValid((Object)ws) && !PropertyValidator.isValid((Object)(batch = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)relationId))))) {
                session = (Session)this.sessionRepository.findOne((Serializable)((Object)relationId));
            }
            if (PropertyValidator.isValid((Object)ws) || PropertyValidator.isValid((Object)batch) || PropertyValidator.isValid((Object)session)) {
                ItemType checkInItemType = this.itemTypeRepository.findByTitle(EnumKendis.CHECK_IN.getCode());
                ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(checkInItemType);
                response.put("scheme", itemTypeScheme);
                PageRequest pageable = new PageRequest(pageIndex.intValue(), pageSize.intValue());
                Query query = new Query();
                Query countQuery = new Query();
                query.with((Pageable)pageable);
                query.with(new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
                Criteria relationCriteria = new Criteria();
                Criteria itemTypeCriteria = new Criteria();
                relationCriteria = PropertyValidator.isValid((Object)ws) ? Criteria.where((String)("relationMap." + relationId + "._id")).is((Object)(ws.getModuleType() + "_" + ws.getId())) : (PropertyValidator.isValid((Object)batch) ? Criteria.where((String)("relationMap." + relationId + "._id")).is((Object)("Batch_" + batch.getId())) : Criteria.where((String)("relationMap." + relationId + "._id")).is((Object)("Session_" + session.getId())));
                itemTypeCriteria = Criteria.where((String)"itemType").is((Object)checkInItemType);
                if (PropertyValidator.isValid((Object)searchQuery)) {
                    searchQuery = this.escapeRegex(searchQuery);
                    Criteria searchCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"title").regex(searchQuery, "i"), Criteria.where((String)"description").regex(searchQuery, "i"), Criteria.where((String)"createdBy").regex(searchQuery, "i")});
                    query.addCriteria((CriteriaDefinition)searchCriteria);
                    countQuery.addCriteria((CriteriaDefinition)searchCriteria);
                }
                query.addCriteria((CriteriaDefinition)relationCriteria);
                countQuery.addCriteria((CriteriaDefinition)relationCriteria);
                query.addCriteria((CriteriaDefinition)itemTypeCriteria);
                countQuery.addCriteria((CriteriaDefinition)itemTypeCriteria);
                countQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                List checkIns = this.mongoTemplate.find(query, BaseItem.class);
                long checkInsCount = this.mongoTemplate.count(countQuery, BaseItem.class);
                response.put("checkIns", checkIns);
                response.put("checkInsCount", checkInsCount);
                ArrayList<String> userIds = new ArrayList<String>();
                if (PropertyValidator.isValid((Collection)checkIns)) {
                    for (BaseItem checkIn : checkIns) {
                        userIds.add(checkIn.getCreatedBy());
                    }
                    List users = this.userRepository.findUsersByUserNameIgnoreCaseIn(userIds);
                    HashMap<String, User> usersByUsername = new HashMap<String, User>();
                    for (User user : users) {
                        usersByUsername.put(user.getUserName(), user);
                    }
                    if (PropertyValidator.isValid(usersByUsername)) {
                        response.put("usersByUsername", usersByUsername);
                    }
                }
            }
        }
        return response;
    }

    public HashMap<String, Object> deleteCheckIn(String id) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        BaseItem item = (BaseItem)this.baseItemRepository.findOne((Serializable)((Object)id));
        if (PropertyValidator.isValid((Object)item)) {
            item.setArchive(true);
            this.baseItemRepository.save((Object)item);
        }
        return response;
    }

    public String escapeRegex(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append("\\");
            sb.append(c);
        }
        return sb.toString();
    }

    public HashMap<String, Object> fetchCheckInsSettings(Map<String, Object> requestBody) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        return response;
    }
}

