/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.entity.dto.ExportPageRequest;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.service.ExportPageService;
import com.viztrend.safe.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Date;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class ExportPageServiceImpl
implements ExportPageService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private AppInitConfigRepository appInitConfigRepository;
    @Value(value="${temp.file.location}")
    private String tempFileLocation;
    private ObjectMapper objectMapper = new ObjectMapper();

    public String decodeUrlEncodedString(String encodedString) throws Exception {
        return URLDecoder.decode(encodedString, StandardCharsets.UTF_8.toString());
    }

    public ExportPageRequest convertToExportPageRequest(String jsonString) throws Exception {
        return (ExportPageRequest)this.objectMapper.readValue(jsonString, ExportPageRequest.class);
    }

    public byte[] downloadPdf(String url) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_PDF));
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, requestEntity, InputStream.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            try {
                Path tempFilePath = Files.createTempFile(Paths.get(this.tempFileLocation, new String[0]), "temp-pdf-" + new Date().getTime(), ".pdf", new FileAttribute[0]);
                try (InputStream inputStream = (InputStream)response.getBody();
                     OutputStream outputStream = Files.newOutputStream(tempFilePath, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                byte[] byteArray = Files.readAllBytes(tempFilePath);
                Files.deleteIfExists(tempFilePath);
                return byteArray;
            }
            catch (IOException e) {
                throw new ResourceAccessException(StringUtils.getTraceString((Throwable)e));
            }
        }
        throw new ResourceAccessException("Could not download the file! Got response code from export server: " + response.getStatusCode() + " and body: " + response.getBody());
    }

    public byte[] sendExportRequest(ExportPageRequest request) throws Exception {
        AppInitConfig appInitConfig = (AppInitConfig)this.appInitConfigRepository.findAll().get(0);
        if (appInitConfig == null || appInitConfig.getExportServerUrl() == null) {
            throw new IllegalArgumentException("Export server url is not defined in app init config. Cannot proceed.");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)request, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(appInitConfig.getExportServerUrl(), (Object)entity, byte[].class, new Object[0]);
        return (byte[])responseEntity.getBody();
    }
}

