/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WatcherRepository;
import com.viztrend.safe.service.APIServiceImpl;
import com.viztrend.safe.service.DependencyAPIService;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="DependencyAPIService")
@Transactional
public class DependencyAPIServiceImpl
implements DependencyAPIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyAPIServiceImpl.class);
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private WatcherRepository watcherRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private APIServiceImpl apiServiceImpl;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ContainerRepository containerRepository;

    private List<DBObject> getListOfSessionDependencies(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoardId").is((Object)id));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("itemLink").find(query.getQueryObject());
        List dependencyList = dbCursorPrefix.toArray();
        return dependencyList;
    }

    private List<DBObject> getListOfDependenciesTeamContainer(Set<ObjectId> teamContainerIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(teamContainerIds));
        query.fields().include("_id");
        query.fields().include("team");
        query.fields().include("container");
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject(), query.getFieldsObject());
        List teamContainerList = dbCursorPrefix.toArray();
        return teamContainerList;
    }

    public HashMap<String, Object> getSessionDependencies(String sessionId, String fields, String expand) throws Exception {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        List dependencies = this.getListOfSessionDependencies(sessionId);
        HashMap fieldsMap = this.apiServiceImpl.getfieldsMap(fields, expand);
        HashMap allExtraAdditionalDataMap = new HashMap();
        this.dependencyDataMapping(dependencies, fieldsMap, allExtraAdditionalDataMap);
        HashSet<LinkedHashMap> dependenciesList = new HashSet<LinkedHashMap>();
        for (DBObject dependecy : dependencies) {
            LinkedHashMap dependencyData = this.getDataBySelectedFieldsForDependency(dependecy, fieldsMap, allExtraAdditionalDataMap);
            if (!PropertyValidator.isValid((Object)dependencyData)) continue;
            dependenciesList.add(dependencyData);
        }
        responseJson.put("data", dependenciesList);
        return responseJson;
    }

    private void dependencyDataMapping(List<DBObject> dependencies, HashMap<String, String> fieldsMap, Map<String, Object> allExtraAdditionalDataMap) {
        try {
            HashSet<ObjectId> teamContainerIds = new HashSet<ObjectId>();
            ArrayList<String> itemIds = new ArrayList<String>();
            ArrayList<String> wfStatusDependency = new ArrayList<String>();
            ArrayList<String> reporterDependency = new ArrayList<String>();
            ArrayList<String> watcherListDependency = new ArrayList<String>();
            ArrayList<String> conversationsDependency = new ArrayList<String>();
            for (DBObject dependecy : dependencies) {
                List conversationsList;
                List watcherList;
                DBRef responsibleRef;
                DBRef reporterRef;
                DBRef wfStatusRef;
                if (PropertyValidator.isValid((Object)dependecy.get("sourceTeamContainerId"))) {
                    teamContainerIds.add(new ObjectId(String.valueOf(dependecy.get("sourceTeamContainerId"))));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("targetTeamContainerId"))) {
                    teamContainerIds.add(new ObjectId(String.valueOf(dependecy.get("targetTeamContainerId"))));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("sourceFeatureId"))) {
                    itemIds.add(String.valueOf(dependecy.get("sourceFeatureId")));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("targetFeatureId"))) {
                    itemIds.add(String.valueOf(dependecy.get("targetFeatureId")));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("sourceUserStoryId"))) {
                    itemIds.add(String.valueOf(dependecy.get("sourceUserStoryId")));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("targetUserStoryId"))) {
                    itemIds.add(String.valueOf(dependecy.get("targetUserStoryId")));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("sourceItemId"))) {
                    itemIds.add(String.valueOf(dependecy.get("sourceItemId")));
                }
                if (PropertyValidator.isValid((Object)dependecy.get("targetItemId"))) {
                    itemIds.add(String.valueOf(dependecy.get("targetItemId")));
                }
                if (PropertyValidator.isValid((Object)(wfStatusRef = (DBRef)dependecy.get("wfStatus")))) {
                    wfStatusDependency.add(String.valueOf(wfStatusRef.getId()));
                }
                if (PropertyValidator.isValid((Object)(reporterRef = (DBRef)dependecy.get("reporter")))) {
                    reporterDependency.add(String.valueOf(reporterRef.getId()));
                }
                if (PropertyValidator.isValid((Object)(responsibleRef = (DBRef)dependecy.get("responsible")))) {
                    reporterDependency.add(String.valueOf(responsibleRef.getId()));
                }
                if (PropertyValidator.isValid((Collection)(watcherList = (List)dependecy.get("watcherList")))) {
                    for (int i = 0; i < watcherList.size(); ++i) {
                        DBRef watcherRef = (DBRef)watcherList.get(i);
                        if (!PropertyValidator.isValid((Object)watcherRef)) continue;
                        watcherListDependency.add(String.valueOf(watcherRef.getId()));
                    }
                }
                if (!PropertyValidator.isValid((Collection)(conversationsList = (List)dependecy.get("conversations")))) continue;
                for (int i = 0; i < conversationsList.size(); ++i) {
                    DBRef conversationsRef = (DBRef)conversationsList.get(i);
                    if (!PropertyValidator.isValid((Object)conversationsRef)) continue;
                    conversationsDependency.add(String.valueOf(conversationsRef.getId()));
                }
            }
            this.buildHashMapData(allExtraAdditionalDataMap, teamContainerIds, itemIds, wfStatusDependency, reporterDependency, watcherListDependency, conversationsDependency, fieldsMap);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build hashmap Data By fields by api key -> ", (Throwable)e);
        }
    }

    private void buildHashMapData(Map<String, Object> allExtraAdditionalDataMap, Set<ObjectId> teamContainerIds, List<String> itemIds, List<String> wfStatusDependency, List<String> reporterDependency, List<String> watcherListDependency, List<String> conversationsDependency, HashMap<String, String> fieldsMap) {
        try {
            if (PropertyValidator.isValid(teamContainerIds)) {
                List allTeamContainer = this.getListOfDependenciesTeamContainer(teamContainerIds);
                ArrayList<String> teamIds = new ArrayList<String>();
                ArrayList<String> containerIds = new ArrayList<String>();
                for (DBObject teamContainer : allTeamContainer) {
                    DBRef containerRef;
                    allExtraAdditionalDataMap.put(String.valueOf(teamContainer.get("_id")), teamContainer);
                    DBRef teamRef = (DBRef)teamContainer.get("team");
                    if (PropertyValidator.isValid((Object)teamRef)) {
                        teamIds.add(String.valueOf(teamRef.getId()));
                    }
                    if (!PropertyValidator.isValid((Object)(containerRef = (DBRef)teamContainer.get("container")))) continue;
                    containerIds.add(String.valueOf(containerRef.getId()));
                }
                List allTeams = this.teamRepository.findTeamByIdIn(teamIds);
                List allSprints = this.containerRepository.findContainerByIdIn(containerIds);
                for (Team team : allTeams) {
                    allExtraAdditionalDataMap.put(String.valueOf(team.getId()), team);
                }
                for (Container container : allSprints) {
                    allExtraAdditionalDataMap.put(String.valueOf(container.getId()), container);
                }
            }
            if (PropertyValidator.isValid(itemIds)) {
                List allItems = this.itemRepository.findByIdIn(itemIds);
                for (Item item : allItems) {
                    allExtraAdditionalDataMap.put(String.valueOf(item.getId()), item);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("status"))) {
                List allStatuses = this.statusRepository.findByIdIn(wfStatusDependency);
                for (Status status : allStatuses) {
                    allExtraAdditionalDataMap.put(String.valueOf(status.getId()), status);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("watcherList"))) {
                List allWatcher = this.watcherRepository.findByIdIn(watcherListDependency);
                for (Watcher watcher : allWatcher) {
                    allExtraAdditionalDataMap.put(String.valueOf(watcher.getId()), watcher);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("responsible")) || PropertyValidator.isValid((Object)fieldsMap.get("reporter"))) {
                List allResponsible = this.userRepository.findByIdIn(reporterDependency);
                for (User user : allResponsible) {
                    allExtraAdditionalDataMap.put(String.valueOf(user.getId()), user);
                }
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("conversation"))) {
                List allConversation = this.conversationRepository.findAllByIdIn(conversationsDependency);
                for (Conversation conversation : allConversation) {
                    if (!PropertyValidator.isValid((Object)conversation.getRisk())) continue;
                    allExtraAdditionalDataMap.put(String.valueOf(conversation.getRisk().getId()), conversation);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build hashmap Data By fields by api key -> ", (Throwable)e);
        }
    }

    private LinkedHashMap<String, Object> getDataBySelectedFieldsForDependency(DBObject dependecy, HashMap<String, String> fieldsMap, Map<String, Object> allExtraAdditionalDataMap) throws Exception {
        User reporter;
        DBRef reporterRef;
        User responsible;
        DBRef responsibleRef;
        Status status;
        DBRef wfStatusRef;
        HashMap<String, String> depTargetTeam;
        Team team;
        DBRef teamRef;
        Container container;
        DBRef containerRef;
        DBObject teamContainer;
        LinkedHashMap<String, Object> dependencyData = new LinkedHashMap<String, Object>();
        if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("type"))) {
            dependencyData.put("type", dependecy.get("type"));
        }
        if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("status"))) {
            dependencyData.put("status", dependecy.get("status"));
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("sourcesprint")) || PropertyValidator.isValid((Object)fieldsMap.get("sourceteam"))) && PropertyValidator.isValid((Object)dependecy.get("sourceTeamContainerId")) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(dependecy.get("sourceTeamContainerId")))) {
            teamContainer = (DBObject)allExtraAdditionalDataMap.get(dependecy.get("sourceTeamContainerId"));
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("sourcesprint"))) && PropertyValidator.isValid((Object)(containerRef = (DBRef)teamContainer.get("container"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(containerRef.getId().toString())) && PropertyValidator.isValid((Object)(container = (Container)allExtraAdditionalDataMap.get(containerRef.getId().toString())))) {
                HashMap<String, String> depSourceSprint = new HashMap<String, String>();
                depSourceSprint.put("id", container.getId());
                depSourceSprint.put("title", container.getTitle());
                depSourceSprint.put("label", container.getLabel());
                dependencyData.put("sourcesprint", depSourceSprint);
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("sourceteam"))) && PropertyValidator.isValid((Object)(teamRef = (DBRef)teamContainer.get("team"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(teamRef.getId().toString())) && PropertyValidator.isValid((Object)(team = (Team)allExtraAdditionalDataMap.get(teamRef.getId().toString())))) {
                depTargetTeam = new HashMap<String, String>();
                depTargetTeam.put("id", team.getId());
                depTargetTeam.put("title", team.getTitle());
                depTargetTeam.put("label", team.getLabel());
                dependencyData.put("sourceteam", depTargetTeam);
            }
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("targetsprint")) || PropertyValidator.isValid((Object)fieldsMap.get("targetteam"))) && PropertyValidator.isValid((Object)dependecy.get("targetTeamContainerId")) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(dependecy.get("targetTeamContainerId")))) {
            teamContainer = (DBObject)allExtraAdditionalDataMap.get(dependecy.get("targetTeamContainerId"));
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("targetsprint"))) && PropertyValidator.isValid((Object)(containerRef = (DBRef)teamContainer.get("container"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(containerRef.getId().toString())) && PropertyValidator.isValid((Object)(container = (Container)allExtraAdditionalDataMap.get(containerRef.getId().toString())))) {
                HashMap<String, String> depTargetSprint = new HashMap<String, String>();
                depTargetSprint.put("id", container.getId());
                depTargetSprint.put("title", container.getTitle());
                depTargetSprint.put("label", container.getLabel());
                dependencyData.put("targetsprint", depTargetSprint);
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("targetteam"))) && PropertyValidator.isValid((Object)(teamRef = (DBRef)teamContainer.get("team"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(teamRef.getId().toString())) && PropertyValidator.isValid((Object)(team = (Team)allExtraAdditionalDataMap.get(teamRef.getId().toString())))) {
                depTargetTeam = new HashMap();
                depTargetTeam.put("id", team.getId());
                depTargetTeam.put("title", team.getTitle());
                depTargetTeam.put("label", team.getLabel());
                dependencyData.put("targetteam", depTargetTeam);
            }
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("wsStatus"))) && PropertyValidator.isValid((Object)(wfStatusRef = (DBRef)dependecy.get("wfStatus"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(wfStatusRef.getId().toString())) && PropertyValidator.isValid((Object)(status = (Status)allExtraAdditionalDataMap.get(wfStatusRef.getId().toString())))) {
            HashMap<String, String> depStatus = new HashMap<String, String>();
            depStatus.put("id", status.getId());
            depStatus.put("status", status.getTitle());
            dependencyData.put("wsStatus", depStatus);
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("responsible"))) && PropertyValidator.isValid((Object)(responsibleRef = (DBRef)dependecy.get("responsible"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(responsibleRef.getId().toString())) && PropertyValidator.isValid((Object)(responsible = (User)allExtraAdditionalDataMap.get(responsibleRef.getId().toString())))) {
            HashMap<String, String> responsibleData = new HashMap<String, String>();
            responsibleData.put("responsible", responsible.getFirstName());
            responsibleData.put("id", responsible.getId());
            dependencyData.put("responsible", responsibleData);
        }
        if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("reporter"))) && PropertyValidator.isValid((Object)(reporterRef = (DBRef)dependecy.get("reporter"))) && PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(reporterRef.getId().toString())) && PropertyValidator.isValid((Object)(reporter = (User)allExtraAdditionalDataMap.get(reporterRef.getId().toString())))) {
            HashMap<String, String> reporterData = new HashMap<String, String>();
            reporterData.put("reporter", reporter.getFirstName());
            reporterData.put("id", reporter.getId());
            dependencyData.put("reporter", reporterData);
        }
        if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("watcherList"))) {
            HashSet linkWatcherList = new HashSet();
            List watcherList = (List)dependecy.get("watcherList");
            if (PropertyValidator.isValid((Collection)watcherList)) {
                for (DBRef watcherRef : watcherList) {
                    Watcher watcher;
                    if (!PropertyValidator.isValid((Object)watcherRef) || !PropertyValidator.isValid((Object)allExtraAdditionalDataMap.get(watcherRef.getId().toString())) || !PropertyValidator.isValid((Object)(watcher = (Watcher)allExtraAdditionalDataMap.get(watcherRef.getId().toString())))) continue;
                    HashMap<String, String> watcherData = new HashMap<String, String>();
                    watcherData.put("Watcher", watcher.getUser().getFullName());
                    watcherData.put("id", watcher.getUser().getId());
                    linkWatcherList.add(watcherData);
                }
            }
            dependencyData.put("watcherList", linkWatcherList);
        }
        return dependencyData;
    }
}

