/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.enums.EnumShareBoard;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmHierarchyLevelMapping;
import com.viztrend.safe.persistence.entity.BacklogHierarchy;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BoardSprintCriteria;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Dashboard;
import com.viztrend.safe.persistence.entity.DashboardAccessRole;
import com.viztrend.safe.persistence.entity.GraphCriteria;
import com.viztrend.safe.persistence.entity.GraphGroup;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.HierarchyLevel;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.JiraProjectIssueTypes;
import com.viztrend.safe.persistence.entity.PublicLinks;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.TimeSeriesDTO;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.Widget;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.DashboardAccessRoleRepository;
import com.viztrend.safe.persistence.repository.DashboardRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.TimeSeriesRepository;
import com.viztrend.safe.persistence.repository.WidgetRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.DashboardService;
import com.viztrend.safe.service.DashboardServiceImpl;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="DashboardService")
public class DashboardServiceImpl
implements DashboardService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardServiceImpl.class);
    SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy");
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    TimeSeriesRepository timeSeriesRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private DashboardAccessRoleRepository dashboardAccessRoleRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;

    public Map<String, Object> saveDashboard(Dashboard dashboard) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            dashboard.setUpdatedOn(new Date());
            dashboard.setUpdatedBy(user.getUserName());
            result.put("dashboard", this.dashboardRepository.save((Object)dashboard));
        }
        catch (Exception e) {
            LOGGER.error("Error processing saveDashboard()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getDashboardRole(String dashboardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Query queryForDashboard;
            Dashboard dashboard;
            List dars;
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            Query query = new Query();
            List groupIds = user.getGroups().stream().filter(s -> ObjectId.isValid((String)s)).map(ObjectId::new).collect(Collectors.toList());
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"group.$id").in(groupIds), Criteria.where((String)"dashboardId").is((Object)dashboardId)});
            query.addCriteria((CriteriaDefinition)criteria);
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("dashboardAccessRole").find(query.getQueryObject());
            List accessRoles = dbCursorPrefix.toArray();
            HashMap<String, ArrayList<DBObject>> accessRolesMapByDashboardId = new HashMap<String, ArrayList<DBObject>>();
            if (PropertyValidator.isValid((Collection)accessRoles)) {
                for (DBObject dashboardAccessRole : accessRoles) {
                    dars = (ArrayList<DBObject>)accessRolesMapByDashboardId.get(dashboardId);
                    if (dars == null) {
                        dars = new ArrayList<DBObject>();
                        accessRolesMapByDashboardId.put(dashboardId, (ArrayList<DBObject>)dars);
                    }
                    dars.add(dashboardAccessRole);
                }
            }
            if (PropertyValidator.isValid((Object)(dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(dashboardId))), Dashboard.class)))) {
                dars = (List)accessRolesMapByDashboardId.get(dashboardId);
                if (PropertyValidator.isValid((Object)dashboard.getOwner()) && dashboard.getOwner().getId().equals(user.getId())) {
                    dashboard.setMyRole("Owner");
                    dashboard.setSharedWithMe(Boolean.valueOf(false));
                } else {
                    dashboard.setSharedWithMe(Boolean.valueOf(true));
                    String role = "Viewer";
                    if (PropertyValidator.isValid(dars)) {
                        for (DBObject dashboardAccessRole : dars) {
                            String _role = (String)dashboardAccessRole.get("role");
                            if (!_role.equals("Editor")) continue;
                            role = "Editor";
                        }
                    }
                    dashboard.setMyRole(role);
                }
            }
            result.put("myRole", dashboard.getMyRole());
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDashboardRole()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getAllDashboards(String property, List<String> values) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query();
            List groupIds = user.getGroups().stream().filter(s -> ObjectId.isValid((String)s)).map(ObjectId::new).collect(Collectors.toList());
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("dashboardAccessRole").find(query.getQueryObject());
            List accessRoles = dbCursorPrefix.toArray();
            ArrayList<String> dashboardIds = new ArrayList<String>();
            HashMap myAccessRolesMapByDashboardId = new HashMap();
            HashMap<String, ArrayList<DBObject>> otherAccessRolesMapByDashboardId = new HashMap<String, ArrayList<DBObject>>();
            if (PropertyValidator.isValid((Collection)accessRoles)) {
                for (DBObject dashboardAccessRole : accessRoles) {
                    ArrayList<DBObject> dars;
                    List<DBObject> dars2;
                    String dashboardId = (String)dashboardAccessRole.get("dashboardId");
                    boolean isMy = false;
                    if (dashboardAccessRole.containsKey("user")) {
                        DBRef usr = (DBRef)dashboardAccessRole.get("user");
                        String userId = String.valueOf(usr.getId());
                        if (userId.equals(user.getId())) {
                            isMy = true;
                            dars2 = (ArrayList<DBObject>)myAccessRolesMapByDashboardId.get(dashboardId);
                            if (dars2 == null) {
                                dars2 = new ArrayList<DBObject>();
                                myAccessRolesMapByDashboardId.put(dashboardId, dars2);
                            }
                            dars2.add(dashboardAccessRole);
                        }
                    } else if (dashboardAccessRole.containsKey("group")) {
                        DBRef grp = (DBRef)dashboardAccessRole.get("group");
                        ObjectId grpId = (ObjectId)grp.getId();
                        if (PropertyValidator.isValid(groupIds) && groupIds.contains(grpId)) {
                            isMy = true;
                            dars2 = (List)myAccessRolesMapByDashboardId.get(dashboardId);
                            if (dars2 == null) {
                                dars2 = new ArrayList();
                                myAccessRolesMapByDashboardId.put(dashboardId, dars2);
                            }
                            dars2.add(dashboardAccessRole);
                        }
                    }
                    if (isMy) {
                        dashboardIds.add(dashboardId);
                    }
                    if ((dars = (ArrayList<DBObject>)otherAccessRolesMapByDashboardId.get(dashboardId)) == null) {
                        dars = new ArrayList<DBObject>();
                        otherAccessRolesMapByDashboardId.put(dashboardId, dars);
                    }
                    dars.add(dashboardAccessRole);
                }
            }
            List dashboards = null;
            Query match = new Query();
            match.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            match.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
            if (PropertyValidator.isValid((Object)property) && PropertyValidator.isValid(values)) {
                match.addCriteria((CriteriaDefinition)Criteria.where((String)property).in(values));
            }
            if (!user.getIsAdmin().booleanValue()) {
                Criteria or = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"id").in((Collection)KendisUtils.getListAsObjectIds(dashboardIds)), Criteria.where((String)"owner.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"sharedWithAll").is((Object)true)});
                match.addCriteria((CriteriaDefinition)or);
            }
            if (PropertyValidator.isValid((Collection)(dashboards = this.mongoTemplate.find(match, Dashboard.class)))) {
                for (Dashboard dashboard : dashboards) {
                    List myDars = (List)myAccessRolesMapByDashboardId.get(dashboard.getId());
                    List otherDars = (List)otherAccessRolesMapByDashboardId.get(dashboard.getId());
                    if (PropertyValidator.isValid((Collection)otherDars)) {
                        dashboard.setShared(Boolean.valueOf(true));
                    } else {
                        dashboard.setShared(Boolean.valueOf(false));
                    }
                    if (PropertyValidator.isValid((Object)dashboard.getOwner()) && dashboard.getOwner().getId().equals(user.getId())) {
                        dashboard.setMyRole("Owner");
                        dashboard.setSharedWithMe(Boolean.valueOf(false));
                    } else {
                        dashboard.setSharedWithMe(Boolean.valueOf(true));
                        String role = "Viewer";
                        if (PropertyValidator.isValid((Collection)myDars)) {
                            for (DBObject dashboardAccessRole : myDars) {
                                String _role = (String)dashboardAccessRole.get("role");
                                if (!_role.equals("Editor")) continue;
                                role = "Editor";
                            }
                        }
                        dashboard.setMyRole(role);
                    }
                    if (!user.getIsAdmin().booleanValue()) continue;
                    if (PropertyValidator.isValid((Object)dashboard.getOwner())) {
                        if (dashboard.getOwner().getId().equals(user.getId())) continue;
                        dashboard.setMyRole("Editor");
                        continue;
                    }
                    dashboard.setMyRole("Editor");
                }
            }
            result.put("dashboards", dashboards);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAllDashboards()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Widget getWidget(String widgetId) {
        try {
            if (PropertyValidator.isValid((Object)widgetId)) {
                Widget savedWidget = new Widget();
                Query queryForWidget = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(widgetId)));
                savedWidget = (Widget)this.mongoTemplate.findOne(queryForWidget, Widget.class);
                if (savedWidget.getCategory().equals("Completion by Teams")) {
                    this.loadWidgetData(savedWidget.getGraphCriteria().getFileReferenceKey(), savedWidget);
                }
                return savedWidget;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getWidget()" + StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    public Map<String, Object> getDashboard(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)id));
            if (PropertyValidator.isValid((Object)dashboard)) {
                result.put("dashboard", dashboard);
            } else {
                result.put("error", "Couldn't Find Dashboard with Id: " + id);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDashboard()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> markFavoriteDashboard(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            String dashboardId = (String)params.get("dashboardId");
            Boolean favorite = (Boolean)params.get("favorite");
            Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
            if (PropertyValidator.isValid((Object)dashboard)) {
                if (favorite.booleanValue()) {
                    if (dashboard.getFavoriteMapByUserId() == null) {
                        dashboard.setFavoriteMapByUserId(new HashMap());
                    }
                    dashboard.getFavoriteMapByUserId().put(user.getId(), user.getId());
                } else if (dashboard.getFavoriteMapByUserId() != null && dashboard.getFavoriteMapByUserId().containsKey(user.getId())) {
                    dashboard.getFavoriteMapByUserId().remove(user.getId());
                }
                dashboard = (Dashboard)this.dashboardRepository.save((Object)dashboard);
                result.put("dashboard", dashboard);
                result.put("success", true);
            } else {
                result.put("success", false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing markFavoriteDashboard()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> searchUsersOrGroups(String searchText) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            Query groupQuery = new Query();
            groupQuery.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            groupQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            String options = "i";
            Criteria searchCriteria = Criteria.where((String)"title").regex(searchText, options);
            groupQuery.addCriteria((CriteriaDefinition)searchCriteria);
            List groups = this.mongoTemplate.find(groupQuery, Group.class);
            Query query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
            options = "i";
            Criteria criteria1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userName").regex(searchText, options), Criteria.where((String)"fullName").regex(searchText, options), Criteria.where((String)"email").regex(searchText, options)});
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)criteria1);
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies.company.id").is((Object)cid));
            List users1 = this.mongoTemplate.find(query, User.class);
            query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies").is(null));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            options = "i";
            criteria1 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userName").regex(searchText, options), Criteria.where((String)"fullName").regex(searchText, options), Criteria.where((String)"email").regex(searchText, options)});
            query.addCriteria((CriteriaDefinition)criteria1);
            List users2 = this.mongoTemplate.find(query, User.class);
            if (PropertyValidator.isValid((Collection)users2)) {
                users1.addAll(users2);
            }
            result.put("groups", groups);
            result.put("users", users1);
        }
        catch (Exception e) {
            LOGGER.error("Error processing searchUsersOrGroups()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getDashboardAccessRoles(String dashboardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List accessRoles = this.dashboardAccessRoleRepository.findByDashboardId(dashboardId);
            result.put("accessRoles", accessRoles);
            result.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDashboardAccessRoles()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getUserDashboardAccessRole(String dashboardKey) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User currentUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            Query dashboardQuery = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            dashboardQuery.fields().include("_id").include("owner").include("sharedWithAll");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(dashboardQuery, Dashboard.class);
            if (PropertyValidator.isValid((Object)dashboard)) {
                if (currentUser.getId().equals(dashboard.getOwner().getId())) {
                    result.put("userRole", "Owner");
                } else if (currentUser.getIsAdmin().booleanValue()) {
                    result.put("userRole", "Editor");
                } else {
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(currentUser.getId())), Criteria.where((String)"group").in((Collection)currentUser.getGroups())}), Criteria.where((String)"dashboardId").is((Object)dashboard.getId())}));
                    query.fields().include("role");
                    List dashboardAccessRole = this.mongoTemplate.find(query, DashboardAccessRole.class);
                    Boolean isEditor = false;
                    if (PropertyValidator.isValid((Collection)dashboardAccessRole)) {
                        for (DashboardAccessRole accessRole : dashboardAccessRole) {
                            if (!accessRole.getRole().equals("Editor")) continue;
                            isEditor = true;
                        }
                        if (isEditor.booleanValue()) {
                            result.put("userRole", "Editor");
                        } else {
                            result.put("userRole", "Viewer");
                        }
                    } else if (dashboard.getSharedWithAll().booleanValue()) {
                        result.put("userRole", "Viewer");
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getUserDashboardAccessRole()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> createDashboardAccessRole(DashboardAccessRole accessRole) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DashboardAccessRole newAccessRole = new DashboardAccessRole();
            newAccessRole.setDashboardId(accessRole.getDashboardId());
            newAccessRole.setUser(accessRole.getUser());
            newAccessRole.setGroup(accessRole.getGroup());
            newAccessRole.setRole(accessRole.getRole());
            newAccessRole = (DashboardAccessRole)this.dashboardAccessRoleRepository.save((Object)newAccessRole);
            newAccessRole = (DashboardAccessRole)this.dashboardAccessRoleRepository.findOne((Serializable)((Object)newAccessRole.getId()));
            result.put("accessRole", newAccessRole);
            result.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDashboardAccessRole()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> updateDashboardAccessRole(DashboardAccessRole accessRole) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            DashboardAccessRole savedAccessRole = (DashboardAccessRole)this.dashboardAccessRoleRepository.findOne((Serializable)((Object)accessRole.getId()));
            if (PropertyValidator.isValid((Object)savedAccessRole)) {
                savedAccessRole.setRole(accessRole.getRole());
                this.dashboardAccessRoleRepository.save((Object)savedAccessRole);
                result.put("success", true);
            } else {
                result.put("success", false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateDashboardAccessRole()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> deleteDashboardAccessRole(String accessRoleId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.dashboardAccessRoleRepository.delete((Serializable)((Object)accessRoleId));
            result.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error("Error processing deleteDashboardAccessRole()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    private List<DBObject> getSessionDBObjectList(List<ObjectId> workSpaces) {
        try {
            Query query = new Query();
            query.fields().include("_id");
            query.fields().include("title");
            query.fields().include("activeSessionBoard");
            query.fields().include("tenant");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"workSpace.$id").in(workSpaces));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"disabledForDashboardListing").is((Object)false));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject(), query.getFieldsObject());
            List rawSessions = dbCursorPrefix.toArray();
            return rawSessions;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSessionDBObjectList()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private List<DBObject> getSessionDBObject(String SessionId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(SessionId)));
            query.fields().include("_id");
            query.fields().include("itemWorkFlow");
            query.fields().include("subItemWorkFlow");
            query.fields().include("tenant");
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("session").find(query.getQueryObject(), query.getFieldsObject());
            List rawSessions = dbCursorPrefix.toArray();
            return rawSessions;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSessionDBObject()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private List<DBObject> getSessionBoardDBObject(String SessionId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(SessionId)));
            query.fields().include("_id");
            query.fields().include("tenant");
            query.fields().include("teamSequence");
            query.fields().include("containers");
            query.fields().include("teams");
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("sessionBoard").find(query.getQueryObject(), query.getFieldsObject());
            List rawSessions = dbCursorPrefix.toArray();
            return rawSessions;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSessionBoardDBObject()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private List<DBObject> getStatusDBObjectList(List<ObjectId> workFlowIds) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"workFlow.$id").in(workFlowIds));
            query.fields().include("_id");
            query.fields().include("title");
            query.fields().include("color");
            query.fields().include("category");
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(query.getQueryObject(), query.getFieldsObject());
            List rawStatus = dbCursorPrefix.toArray();
            return rawStatus;
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private List<DBObject> getTeamsOrSprintsDBObjectList(List<ObjectId> teamOrSprintIds, String collectionName) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(teamOrSprintIds));
            query.fields().include("_id");
            query.fields().include("title");
            query.fields().include("label");
            query.fields().include("color");
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection(collectionName).find(query.getQueryObject(), query.getFieldsObject());
            List rawStatus = dbCursorPrefix.toArray();
            return rawStatus;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamsOrSprintsDBObjectList()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private List<DBObject> getSprintsDBObjectList(List<ObjectId> teamOrSprintIds, String collectionName) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(teamOrSprintIds));
            query.fields().include("_id");
            query.fields().include("title");
            query.fields().include("label");
            query.fields().include("color");
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection(collectionName).find(query.getQueryObject(), query.getFieldsObject());
            List rawStatus = dbCursorPrefix.toArray();
            return rawStatus;
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    public Map<String, Object> updateDashboard(String id, Dashboard dashboard) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Dashboard savedDashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)id));
            if (PropertyValidator.isValid((Object)savedDashboard)) {
                savedDashboard.setName(dashboard.getName());
                savedDashboard.setDescription(dashboard.getDescription());
                savedDashboard.setSolutionBoardIds(dashboard.getSolutionBoardIds());
                savedDashboard.setWorkSpaceKeys(dashboard.getWorkSpaceKeys());
                result.put("dashboard", this.dashboardRepository.save((Object)savedDashboard));
            } else {
                result.put("error", "Couldn't find Dashboard with id: " + id);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateDashboard()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> deleteDashboard(String dashboardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
            if (PropertyValidator.isValid((Object)dashboard)) {
                if (PropertyValidator.isValid((Collection)dashboard.getWidgets())) {
                    this.widgetRepository.delete((Iterable)dashboard.getWidgets());
                }
                this.dashboardRepository.delete((Object)dashboard);
                result.put("success", true);
            } else {
                result.put("success", false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing deleteDashboard()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> createDashboardPublicLink(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String dashboardId = (String)params.get("dashboardId");
            String password = (String)params.get("password");
            int code = Integer.parseInt(params.get("code").toString());
            Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
            if (PropertyValidator.isValid((Object)dashboard)) {
                HashMap<String, String> jsonParams = new HashMap<String, String>();
                jsonParams.put("tenant", UserContextUtil.getUserContext().getCurrentCompany().getTenant());
                jsonParams.put("dashboardId", dashboardId);
                jsonParams.put("password", password);
                Gson gson = new Gson();
                String jsonParamsStr = gson.toJson(jsonParams);
                String token = UUID.randomUUID().toString();
                PublicLinks publicLink = new PublicLinks(token, EnumShareBoard.getEnumByCode((int)code).getCode());
                ServerCache serverCache = new ServerCache();
                serverCache.setKey(token);
                serverCache.setValue(jsonParamsStr);
                serverCache.setTime(new Date());
                this.serverCacheRepository.save((Object)serverCache);
                dashboard.setPublicLink(publicLink);
                dashboard = (Dashboard)this.dashboardRepository.save((Object)dashboard);
                result.put("success", true);
                result.put("dashboard", dashboard);
            } else {
                result.put("success", false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDashboardPublicLink()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> removeDashboardPublicLink(String dashboardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
            if (PropertyValidator.isValid((Object)dashboard) && PropertyValidator.isValid((Object)dashboard.getPublicLink())) {
                this.serverCacheRepository.deleteByKey(dashboard.getPublicLink().getToken());
                dashboard.setPublicLink(null);
                this.dashboardRepository.save((Object)dashboard);
                result.put("success", true);
                result.put("dashboard", dashboard);
            } else {
                result.put("success", false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing removeDashboardPublicLink()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> saveWidgetGridPosition(String dashboardId, List<Widget> widgets) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            ArrayList<String> widgetIds = new ArrayList<String>();
            HashMap<String, Widget> inputWidgetMap = new HashMap<String, Widget>();
            if (PropertyValidator.isValid(widgets)) {
                for (Widget widget : widgets) {
                    widgetIds.add(widget.getId());
                    inputWidgetMap.put(widget.getId(), widget);
                }
                List savedWidgets = this.widgetRepository.findByIdIn(widgetIds);
                if (PropertyValidator.isValid((Collection)savedWidgets)) {
                    for (Widget savedWidget : savedWidgets) {
                        Widget inputWidget = (Widget)inputWidgetMap.get(savedWidget.getId());
                        if (!PropertyValidator.isValid((Object)inputWidget)) continue;
                        savedWidget.setPosX(inputWidget.getPosX());
                        savedWidget.setPosY(inputWidget.getPosY());
                        savedWidget.setColumns(inputWidget.getColumns());
                        savedWidget.setRows(inputWidget.getRows());
                    }
                    savedWidgets = this.widgetRepository.save((Iterable)savedWidgets);
                    result.put("widgets", savedWidgets);
                    result.put("success", true);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing saveWidgetGridPosition()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public void loadWidgetData(String key, Widget widget) {
        try {
            String jsonData = MongoSyncUtils.retrieveData((String)key, (AppConfig.MongoConfig)this.mongoConfig);
            ObjectMapper objectMapper = new ObjectMapper();
            if (jsonData != null) {
                Map retrievedData = (Map)objectMapper.readValue(jsonData, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                widget.getGraphCriteria().setCommittedStoriesBeforeSprint((Map)retrievedData.getOrDefault("committedStoriesBeforeSprint", new HashMap()));
                widget.getGraphCriteria().setScopeChangeAddedItems((Map)retrievedData.getOrDefault("scopeChangeAddedItems", new HashMap()));
                widget.getGraphCriteria().setScopeChangeRemovedItems((Map)retrievedData.getOrDefault("scopeChangeRemovedItems", new HashMap()));
                widget.getGraphCriteria().setDeliveredCommittedStoriesBeforeSprint((Map)retrievedData.getOrDefault("deliveredCommittedStoriesBeforeSprint", new HashMap()));
                widget.getGraphCriteria().setDeliveredScopeChange((Map)retrievedData.getOrDefault("deliveredScopeChange", new HashMap()));
            } else {
                System.out.println("No data found for key: " + key);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String saveSimplifiedSprintData(Widget widget) throws Exception {
        try {
            HashMap<String, Map> dataToStore = new HashMap<String, Map>();
            dataToStore.put("committedStoriesBeforeSprint", widget.getGraphCriteria().getCommittedStoriesBeforeSprint());
            dataToStore.put("scopeChangeAddedItems", widget.getGraphCriteria().getScopeChangeAddedItems());
            dataToStore.put("scopeChangeRemovedItems", widget.getGraphCriteria().getScopeChangeRemovedItems());
            dataToStore.put("deliveredCommittedStoriesBeforeSprint", widget.getGraphCriteria().getDeliveredCommittedStoriesBeforeSprint());
            dataToStore.put("deliveredScopeChange", widget.getGraphCriteria().getDeliveredScopeChange());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String jsonData = objectMapper.writeValueAsString(dataToStore);
            String fileReferenceKey = UUID.randomUUID().toString();
            MongoSyncUtils.storeData((String)fileReferenceKey, (String)jsonData, (AppConfig.MongoConfig)this.mongoConfig);
            return fileReferenceKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> saveWidget(String dashboardId, Widget widget) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardId));
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(query, Dashboard.class);
            if (PropertyValidator.isValid((Object)dashboard)) {
                Widget savedWidget = null;
                if (PropertyValidator.isValid((Object)widget.getId())) {
                    savedWidget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widget.getId()));
                    if (!PropertyValidator.isValid((Object)savedWidget)) {
                        savedWidget = new Widget();
                    }
                    if (widget.getName() != null) {
                        savedWidget.setName(widget.getName());
                    }
                    if (widget.getDescription() != null) {
                        savedWidget.setDescription(widget.getDescription());
                    }
                    if (widget.getSize() != null) {
                        savedWidget.setSize(widget.getSize());
                    }
                    if (widget.getType() != null) {
                        savedWidget.setType(widget.getType());
                    }
                    if (widget.getCategory() != null) {
                        savedWidget.setCategory(widget.getCategory());
                    }
                    if (widget.getState() != null) {
                        savedWidget.setState(widget.getState());
                    }
                    if (widget.getCriteria() != null) {
                        savedWidget.setCriteria(widget.getCriteria());
                    }
                    if (widget.getCollectionsGraphCriteria() != null) {
                        savedWidget.setCollectionsGraphCriteria(widget.getCollectionsGraphCriteria());
                    }
                    if (widget.getGraphCriteria() != null) {
                        GraphCriteria graphCriteria = savedWidget.getGraphCriteria();
                        if (widget.getGraphCriteria().getGraphType() != null) {
                            savedWidget.getGraphCriteria().setGraphType(widget.getGraphCriteria().getGraphType());
                        }
                        if (widget.getGraphCriteria().getCategories() != null) {
                            savedWidget.getGraphCriteria().setCategories(widget.getGraphCriteria().getCategories());
                        }
                        if (widget.getGraphCriteria().getBoardId() != null) {
                            savedWidget.getGraphCriteria().setBoardId(widget.getGraphCriteria().getBoardId());
                        }
                        if (widget.getGraphCriteria().getSessionBoardId() != null) {
                            savedWidget.getGraphCriteria().setSessionBoardId(widget.getGraphCriteria().getSessionBoardId());
                        }
                        if (widget.getGraphCriteria().getSelectedItems() != null) {
                            savedWidget.getGraphCriteria().setSelectedItems(widget.getGraphCriteria().getSelectedItems());
                        }
                        if (widget.getGraphCriteria().getStartDate() != null) {
                            savedWidget.getGraphCriteria().setStartDate(widget.getGraphCriteria().getStartDate());
                        }
                        if (widget.getGraphCriteria().getEndDate() != null) {
                            savedWidget.getGraphCriteria().setEndDate(widget.getGraphCriteria().getEndDate());
                        }
                        if (widget.getGraphCriteria().getSelectedBoardTenant() != null) {
                            savedWidget.getGraphCriteria().setSelectedBoardTenant(widget.getGraphCriteria().getSelectedBoardTenant());
                        }
                        if (widget.getGraphCriteria().getGraphType() != null) {
                            savedWidget.getGraphCriteria().setGraphType(widget.getGraphCriteria().getGraphType());
                        }
                        if (widget.getGraphCriteria().getOptionalSprints() != null) {
                            savedWidget.getGraphCriteria().setOptionalSprints(widget.getGraphCriteria().getOptionalSprints());
                        }
                        if (widget.getGraphCriteria().getOptionalTeams() != null) {
                            savedWidget.getGraphCriteria().setOptionalTeams(widget.getGraphCriteria().getOptionalTeams());
                        }
                        if (widget.getGraphCriteria().getIntervals() != null) {
                            savedWidget.getGraphCriteria().setIntervals(widget.getGraphCriteria().getIntervals());
                        }
                        if (widget.getGraphCriteria().getRadioButtonSelection() != null) {
                            savedWidget.getGraphCriteria().setRadioButtonSelection(widget.getGraphCriteria().getRadioButtonSelection());
                        }
                        if (widget.getGraphCriteria().getSelectedIssueType() != null) {
                            savedWidget.getGraphCriteria().setSelectedIssueType(widget.getGraphCriteria().getSelectedIssueType());
                        }
                        if (widget.getGraphCriteria().getGroupBy() != null) {
                            savedWidget.getGraphCriteria().setGroupBy(widget.getGraphCriteria().getGroupBy());
                        }
                        if (widget.getAllGroupBys() != null) {
                            savedWidget.setAllGroupBys(widget.getAllGroupBys());
                        }
                        if (widget.getGraphCriteria().getBoardTitle() != null) {
                            savedWidget.getGraphCriteria().setBoardTitle(widget.getGraphCriteria().getBoardTitle());
                        }
                        if (widget.getGraphCriteria().getToStatusTitle() != null) {
                            savedWidget.getGraphCriteria().setToStatusTitle(widget.getGraphCriteria().getToStatusTitle());
                        }
                        if (widget.getGraphCriteria().getFromStatusTitle() != null) {
                            savedWidget.getGraphCriteria().setFromStatusTitle(widget.getGraphCriteria().getFromStatusTitle());
                        }
                        if (widget.getGraphCriteria().getItemDaysMap() != null) {
                            savedWidget.getGraphCriteria().setItemDaysMap(widget.getGraphCriteria().getItemDaysMap());
                        }
                        if (widget.getGraphCriteria().getItemsGroupMap() != null) {
                            savedWidget.getGraphCriteria().setItemsGroupMap(widget.getGraphCriteria().getItemsGroupMap());
                        }
                        if (widget.getGraphCriteria().getSelectedIssueType() != null) {
                            savedWidget.getGraphCriteria().setSelectedIssueType(widget.getGraphCriteria().getSelectedIssueType());
                        }
                        if (widget.getGraphCriteria().getActiveTimeStatuses() != null) {
                            savedWidget.getGraphCriteria().setActiveTimeStatuses(widget.getGraphCriteria().getActiveTimeStatuses());
                        }
                        if (widget.getGraphCriteria().isToggleCreationDate() != savedWidget.getGraphCriteria().isToggleCreationDate()) {
                            savedWidget.getGraphCriteria().setToggleCreationDate(widget.getGraphCriteria().isToggleCreationDate());
                        }
                        if (widget.getGraphCriteria().getItemStatusMap() != null) {
                            savedWidget.getGraphCriteria().setItemStatusMap(widget.getGraphCriteria().getItemStatusMap());
                        }
                        if (widget.getGraphCriteria().getIssueTypeTitle() != null) {
                            savedWidget.getGraphCriteria().setIssueTypeTitle(widget.getGraphCriteria().getIssueTypeTitle());
                        }
                        if (widget.getGraphCriteria().getActiveItems() != null) {
                            savedWidget.getGraphCriteria().setActiveItems(widget.getGraphCriteria().getActiveItems());
                        }
                        if (widget.getGraphCriteria().getWaitingItems() != null) {
                            savedWidget.getGraphCriteria().setWaitingItems(widget.getGraphCriteria().getWaitingItems());
                        }
                        if (widget.getGraphCriteria().getIssueTypeMap() != null) {
                            savedWidget.getGraphCriteria().setIssueTypeMap(widget.getGraphCriteria().getIssueTypeMap());
                        }
                        if (widget.getGraphCriteria().getToggleAdvanceCriteria() != null) {
                            savedWidget.getGraphCriteria().setToggleAdvanceCriteria(widget.getGraphCriteria().getToggleAdvanceCriteria());
                        }
                        if (widget.getGraphCriteria().getToggleAdvanceCalculation() != null) {
                            savedWidget.getGraphCriteria().setToggleAdvanceCalculation(widget.getGraphCriteria().getToggleAdvanceCalculation());
                        }
                        if (widget.getGraphCriteria().getToggleAvgCycleTime() != null) {
                            savedWidget.getGraphCriteria().setToggleAvgCycleTime(widget.getGraphCriteria().getToggleAvgCycleTime());
                        }
                        if (widget.getGraphCriteria().getToggleAvgLeadTime() != null) {
                            savedWidget.getGraphCriteria().setToggleAvgLeadTime(widget.getGraphCriteria().getToggleAvgLeadTime());
                        }
                        if (widget.getGraphCriteria().getToggleAvgArrivalTime() != null) {
                            savedWidget.getGraphCriteria().setToggleAvgArrivalTime(widget.getGraphCriteria().getToggleAvgArrivalTime());
                        }
                        if (widget.getGraphCriteria().getToggleAvgWIPTime() != null) {
                            savedWidget.getGraphCriteria().setToggleAvgWIPTime(widget.getGraphCriteria().getToggleAvgWIPTime());
                        }
                        if (widget.getGraphCriteria().getToggleAvgThroughputTime() != null) {
                            savedWidget.getGraphCriteria().setToggleAvgThroughputTime(widget.getGraphCriteria().getToggleAvgThroughputTime());
                        }
                        if (widget.getGraphCriteria().getAvgCycleTime() != null) {
                            savedWidget.getGraphCriteria().setAvgCycleTime(widget.getGraphCriteria().getAvgCycleTime());
                        }
                        if (widget.getGraphCriteria().getAvgLeadTime() != null) {
                            savedWidget.getGraphCriteria().setAvgLeadTime(widget.getGraphCriteria().getAvgLeadTime());
                        }
                        if (widget.getGraphCriteria().getAvgArrivalTime() != null) {
                            savedWidget.getGraphCriteria().setAvgArrivalTime(widget.getGraphCriteria().getAvgArrivalTime());
                        }
                        if (widget.getGraphCriteria().getAvgWIPTime() != null) {
                            savedWidget.getGraphCriteria().setAvgWIPTime(widget.getGraphCriteria().getAvgWIPTime());
                        }
                        if (widget.getGraphCriteria().getAvgThroughputTime() != null) {
                            savedWidget.getGraphCriteria().setAvgThroughputTime(widget.getGraphCriteria().getAvgThroughputTime());
                        }
                        if (widget.getGraphCriteria().getSelectedActiveStatus() != null) {
                            savedWidget.getGraphCriteria().setSelectedActiveStatus(widget.getGraphCriteria().getSelectedActiveStatus());
                        }
                        if (widget.getGraphCriteria().getSelectedInProgressStatus() != null) {
                            savedWidget.getGraphCriteria().setSelectedInProgressStatus(widget.getGraphCriteria().getSelectedInProgressStatus());
                        }
                        if (widget.getGraphCriteria().getSelectedCompletedStatus() != null) {
                            savedWidget.getGraphCriteria().setSelectedCompletedStatus(widget.getGraphCriteria().getSelectedCompletedStatus());
                        }
                        if (widget.getGraphCriteria().getAdvanceCriteria() != null) {
                            savedWidget.getGraphCriteria().setAdvanceCriteria(widget.getGraphCriteria().getAdvanceCriteria());
                        }
                        if (widget.getGraphCriteria().getSelectedAdvanceCriteria() != null) {
                            savedWidget.getGraphCriteria().setSelectedAdvanceCriteria(widget.getGraphCriteria().getSelectedAdvanceCriteria());
                        }
                        if (widget.getGraphCriteria().getyAxis() != null) {
                            savedWidget.getGraphCriteria().setyAxis(widget.getGraphCriteria().getyAxis());
                        }
                        if (widget.getGraphCriteria().getActiveStatuses() != null) {
                            savedWidget.getGraphCriteria().setActiveStatuses(widget.getGraphCriteria().getActiveStatuses());
                        }
                        if (widget.getGraphCriteria().getIssueType() != null) {
                            savedWidget.getGraphCriteria().setIssueType(widget.getGraphCriteria().getIssueType());
                        }
                        if (widget.getGraphCriteria().getGroupByTitle() != null) {
                            savedWidget.getGraphCriteria().setGroupByTitle(widget.getGraphCriteria().getGroupByTitle());
                        }
                        if (widget.getGraphCriteria().getItemTeamsMap() != null) {
                            savedWidget.getGraphCriteria().setItemTeamsMap(widget.getGraphCriteria().getItemTeamsMap());
                        }
                        if (widget.getGraphCriteria().getItemSprintsMap() != null) {
                            savedWidget.getGraphCriteria().setItemSprintsMap(widget.getGraphCriteria().getItemSprintsMap());
                        }
                        if (widget.getGraphCriteria().getItemGroupbyMap() != null) {
                            savedWidget.getGraphCriteria().setItemGroupbyMap(widget.getGraphCriteria().getItemGroupbyMap());
                        }
                        if (widget.getGraphCriteria().getChartType() != null) {
                            savedWidget.getGraphCriteria().setChartType(widget.getGraphCriteria().getChartType());
                        }
                        if (widget.getGraphCriteria().getChartTypeName() != null) {
                            savedWidget.getGraphCriteria().setChartTypeName(widget.getGraphCriteria().getChartTypeName());
                        }
                        if (widget.getGraphCriteria().getRelevantDates() != null) {
                            savedWidget.getGraphCriteria().setRelevantDates(widget.getGraphCriteria().getRelevantDates());
                        }
                        if (widget.getGraphCriteria().getTotalItemsList() != null) {
                            savedWidget.getGraphCriteria().setTotalItemsList(widget.getGraphCriteria().getTotalItemsList());
                        }
                        if (widget.getGraphCriteria().getActiveItemsList() != null) {
                            savedWidget.getGraphCriteria().setActiveItemsList(widget.getGraphCriteria().getActiveItemsList());
                        }
                        if (widget.getGraphCriteria().getBoardItemsFilter() != null) {
                            savedWidget.getGraphCriteria().setBoardItemsFilter(widget.getGraphCriteria().getBoardItemsFilter());
                        }
                        if (widget.getGraphCriteria().getItemIdsMap() != null) {
                            savedWidget.getGraphCriteria().setItemIdsMap(widget.getGraphCriteria().getItemIdsMap());
                        }
                        if (widget.getGraphCriteria().getGraphTypeTitle() != null) {
                            savedWidget.getGraphCriteria().setGraphTypeTitle(widget.getGraphCriteria().getGraphTypeTitle());
                        }
                        if (widget.getGraphCriteria().getGroupIdColorMap() != null) {
                            savedWidget.getGraphCriteria().setGroupIdColorMap(widget.getGraphCriteria().getGroupIdColorMap());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getItemTags())) {
                            savedWidget.getGraphCriteria().setItemTags(widget.getGraphCriteria().getItemTags());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getItemTagsMetaMap())) {
                            savedWidget.getGraphCriteria().setItemTagsMetaMap(widget.getGraphCriteria().getItemTagsMetaMap());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getFilterId())) {
                            savedWidget.getGraphCriteria().setFilterId(widget.getGraphCriteria().getFilterId());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getHierarchyLevel())) {
                            savedWidget.getGraphCriteria().setHierarchyLevel(widget.getGraphCriteria().getHierarchyLevel());
                        }
                        if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getGroups())) {
                            savedWidget.getGraphCriteria().setGroups(widget.getGraphCriteria().getGroups());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getCommittedDeliveredTracking())) {
                            savedWidget.getGraphCriteria().setCommittedDeliveredTracking(widget.getGraphCriteria().getCommittedDeliveredTracking());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getCommittedDelivered())) {
                            savedWidget.getGraphCriteria().setCommittedDelivered(widget.getGraphCriteria().getCommittedDelivered());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getCommittedAndScopeChangeTotal())) {
                            savedWidget.getGraphCriteria().setCommittedAndScopeChangeTotal(widget.getGraphCriteria().getCommittedAndScopeChangeTotal());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getScopeChangeDeliveredTracking())) {
                            savedWidget.getGraphCriteria().setScopeChangeDeliveredTracking(widget.getGraphCriteria().getScopeChangeDeliveredTracking());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getScopeChngeDelivered())) {
                            savedWidget.getGraphCriteria().setScopeChngeDelivered(widget.getGraphCriteria().getScopeChngeDelivered());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getCommittedTeamsData())) {
                            savedWidget.getGraphCriteria().setCommittedTeamsData(widget.getGraphCriteria().getCommittedTeamsData());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getScopeChangeAdded())) {
                            savedWidget.getGraphCriteria().setScopeChangeAdded(widget.getGraphCriteria().getScopeChangeAdded());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getScopeChangeRemoved())) {
                            savedWidget.getGraphCriteria().setScopeChangeRemoved(widget.getGraphCriteria().getScopeChangeRemoved());
                        }
                        if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getAllTeams())) {
                            savedWidget.getGraphCriteria().setAllTeams(widget.getGraphCriteria().getAllTeams());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getTeamAndColorList())) {
                            savedWidget.getGraphCriteria().setTeamAndColorList(widget.getGraphCriteria().getTeamAndColorList());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getTeamAndLabelList())) {
                            savedWidget.getGraphCriteria().setTeamAndLabelList(widget.getGraphCriteria().getTeamAndLabelList());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getTeamTarget())) {
                            savedWidget.getGraphCriteria().setTeamTarget(widget.getGraphCriteria().getTeamTarget());
                        }
                        if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedBoardSprint())) {
                            savedWidget.getGraphCriteria().setSelectedBoardSprint(widget.getGraphCriteria().getSelectedBoardSprint());
                        }
                        if (PropertyValidator.isValid((Object)widget.getCategory()) && widget.getCategory().equals("Completion by Teams")) {
                            savedWidget.getGraphCriteria().setFileReferenceKey(this.saveSimplifiedSprintData(widget));
                        }
                    }
                    if (widget.getCollectionsGraphCriteria() != null) {
                        this.setCollectionsGraphCriteriaFields(widget, savedWidget);
                    }
                    if (widget.getGraphAdditionalCriteria() == null) {
                        savedWidget.setGraphAdditionalCriteria(null);
                        savedWidget.setSelectedAdditionalFilterCriteria(null);
                        savedWidget.setSelectedAdditionalGraphOption(null);
                    } else if (widget.getGraphAdditionalCriteria() != null) {
                        savedWidget.setGraphAdditionalCriteria(widget.getGraphAdditionalCriteria());
                        savedWidget.setSelectedAdditionalFilterCriteria(widget.getSelectedAdditionalFilterCriteria());
                        savedWidget.setSelectedAdditionalGraphOption(widget.getSelectedAdditionalGraphOption());
                    }
                    if (widget.getGraphCriteria() != null && PropertyValidator.isValid((Object)widget.getGraphCriteria().getSaveFilter())) {
                        if (widget.getGraphCriteria().getSaveFilter().equals(true)) {
                            savedWidget = (Widget)this.widgetRepository.save((Object)savedWidget);
                        }
                    } else if (widget.getCollectionsGraphCriteria() != null && PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getSaveFilter())) {
                        if (widget.getCollectionsGraphCriteria().getSaveFilter().equals(true)) {
                            savedWidget = (Widget)this.widgetRepository.save((Object)savedWidget);
                        }
                    } else {
                        savedWidget = (Widget)this.widgetRepository.save((Object)savedWidget);
                    }
                } else {
                    savedWidget = (Widget)this.widgetRepository.save((Object)widget);
                    if (!PropertyValidator.isValid((Collection)dashboard.getWidgets())) {
                        dashboard.setWidgets(new ArrayList());
                    }
                    dashboard.getWidgets().add(savedWidget);
                    result.put("dashboard", this.dashboardRepository.save((Object)dashboard));
                }
                if (PropertyValidator.isValid((Object)savedWidget.getCategory()) && savedWidget.getCategory().equals("Completion by Teams") && savedWidget.getGraphCriteria().getFileReferenceKey() != null) {
                    this.loadWidgetData(savedWidget.getGraphCriteria().getFileReferenceKey(), savedWidget);
                }
                result.put("widget", savedWidget);
            } else {
                result.put("error", "Couldn't Find Dashboard with Id: " + dashboardId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing saveWidget()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    private void setCollectionsGraphCriteriaFields(Widget widget, Widget savedWidget) throws Exception {
        if (widget.getCollectionsGraphCriteria().getGraphType() != null) {
            savedWidget.getCollectionsGraphCriteria().setGraphType(widget.getCollectionsGraphCriteria().getGraphType());
        }
        if (widget.getCollectionsGraphCriteria().getCategories() != null) {
            savedWidget.getCollectionsGraphCriteria().setCategories(widget.getCollectionsGraphCriteria().getCategories());
        }
        if (widget.getCollectionsGraphCriteria().getBoardId() != null) {
            savedWidget.getCollectionsGraphCriteria().setBoardId(widget.getCollectionsGraphCriteria().getBoardId());
        }
        if (widget.getCollectionsGraphCriteria().getSessionBoardId() != null) {
            savedWidget.getCollectionsGraphCriteria().setSessionBoardId(widget.getCollectionsGraphCriteria().getSessionBoardId());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedItems() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedItems(widget.getCollectionsGraphCriteria().getSelectedItems());
        }
        if (widget.getCollectionsGraphCriteria().getStartDate() != null) {
            savedWidget.getCollectionsGraphCriteria().setStartDate(widget.getCollectionsGraphCriteria().getStartDate());
        }
        if (widget.getCollectionsGraphCriteria().getEndDate() != null) {
            savedWidget.getCollectionsGraphCriteria().setEndDate(widget.getCollectionsGraphCriteria().getEndDate());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedBoardTenant() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedBoardTenant(widget.getCollectionsGraphCriteria().getSelectedBoardTenant());
        }
        if (widget.getCollectionsGraphCriteria().getGraphType() != null) {
            savedWidget.getCollectionsGraphCriteria().setGraphType(widget.getCollectionsGraphCriteria().getGraphType());
        }
        if (widget.getCollectionsGraphCriteria().getOptionalSprints() != null) {
            savedWidget.getCollectionsGraphCriteria().setOptionalSprints(widget.getCollectionsGraphCriteria().getOptionalSprints());
        }
        if (widget.getCollectionsGraphCriteria().getOptionalTeams() != null) {
            savedWidget.getCollectionsGraphCriteria().setOptionalTeams(widget.getCollectionsGraphCriteria().getOptionalTeams());
        }
        if (widget.getCollectionsGraphCriteria().getIntervals() != null) {
            savedWidget.getCollectionsGraphCriteria().setIntervals(widget.getCollectionsGraphCriteria().getIntervals());
        }
        if (widget.getCollectionsGraphCriteria().getRadioButtonSelection() != null) {
            savedWidget.getCollectionsGraphCriteria().setRadioButtonSelection(widget.getCollectionsGraphCriteria().getRadioButtonSelection());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedIssueType() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedIssueType(widget.getCollectionsGraphCriteria().getSelectedIssueType());
        }
        if (widget.getCollectionsGraphCriteria().getGroupBy() != null) {
            savedWidget.getCollectionsGraphCriteria().setGroupBy(widget.getCollectionsGraphCriteria().getGroupBy());
        }
        if (widget.getAllGroupBys() != null) {
            savedWidget.setAllGroupBys(widget.getAllGroupBys());
        }
        if (widget.getCollectionsGraphCriteria().getBoardTitle() != null) {
            savedWidget.getCollectionsGraphCriteria().setBoardTitle(widget.getCollectionsGraphCriteria().getBoardTitle());
        }
        if (widget.getCollectionsGraphCriteria().getToStatusTitle() != null) {
            savedWidget.getCollectionsGraphCriteria().setToStatusTitle(widget.getCollectionsGraphCriteria().getToStatusTitle());
        }
        if (widget.getCollectionsGraphCriteria().getFromStatusTitle() != null) {
            savedWidget.getCollectionsGraphCriteria().setFromStatusTitle(widget.getCollectionsGraphCriteria().getFromStatusTitle());
        }
        if (widget.getCollectionsGraphCriteria().getItemDaysMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemDaysMap(widget.getCollectionsGraphCriteria().getItemDaysMap());
        }
        if (widget.getCollectionsGraphCriteria().getItemsGroupMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemsGroupMap(widget.getCollectionsGraphCriteria().getItemsGroupMap());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedIssueType() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedIssueType(widget.getCollectionsGraphCriteria().getSelectedIssueType());
        }
        if (widget.getCollectionsGraphCriteria().getActiveTimeStatuses() != null) {
            savedWidget.getCollectionsGraphCriteria().setActiveTimeStatuses(widget.getCollectionsGraphCriteria().getActiveTimeStatuses());
        }
        if (widget.getCollectionsGraphCriteria().isToggleCreationDate() != savedWidget.getCollectionsGraphCriteria().isToggleCreationDate()) {
            savedWidget.getCollectionsGraphCriteria().setToggleCreationDate(widget.getCollectionsGraphCriteria().isToggleCreationDate());
        }
        if (widget.getCollectionsGraphCriteria().getItemStatusMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemStatusMap(widget.getCollectionsGraphCriteria().getItemStatusMap());
        }
        if (widget.getCollectionsGraphCriteria().getIssueTypeTitle() != null) {
            savedWidget.getCollectionsGraphCriteria().setIssueTypeTitle(widget.getCollectionsGraphCriteria().getIssueTypeTitle());
        }
        if (widget.getCollectionsGraphCriteria().getActiveItems() != null) {
            savedWidget.getCollectionsGraphCriteria().setActiveItems(widget.getCollectionsGraphCriteria().getActiveItems());
        }
        if (widget.getCollectionsGraphCriteria().getWaitingItems() != null) {
            savedWidget.getCollectionsGraphCriteria().setWaitingItems(widget.getCollectionsGraphCriteria().getWaitingItems());
        }
        if (widget.getCollectionsGraphCriteria().getIssueTypeMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setIssueTypeMap(widget.getCollectionsGraphCriteria().getIssueTypeMap());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAdvanceCriteria() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAdvanceCriteria(widget.getCollectionsGraphCriteria().getToggleAdvanceCriteria());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAdvanceCalculation() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAdvanceCalculation(widget.getCollectionsGraphCriteria().getToggleAdvanceCalculation());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAvgCycleTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAvgCycleTime(widget.getCollectionsGraphCriteria().getToggleAvgCycleTime());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAvgLeadTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAvgLeadTime(widget.getCollectionsGraphCriteria().getToggleAvgLeadTime());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAvgArrivalTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAvgArrivalTime(widget.getCollectionsGraphCriteria().getToggleAvgArrivalTime());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAvgWIPTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAvgWIPTime(widget.getCollectionsGraphCriteria().getToggleAvgWIPTime());
        }
        if (widget.getCollectionsGraphCriteria().getToggleAvgThroughputTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setToggleAvgThroughputTime(widget.getCollectionsGraphCriteria().getToggleAvgThroughputTime());
        }
        if (widget.getCollectionsGraphCriteria().getAvgCycleTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setAvgCycleTime(widget.getCollectionsGraphCriteria().getAvgCycleTime());
        }
        if (widget.getCollectionsGraphCriteria().getAvgLeadTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setAvgLeadTime(widget.getCollectionsGraphCriteria().getAvgLeadTime());
        }
        if (widget.getCollectionsGraphCriteria().getAvgArrivalTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setAvgArrivalTime(widget.getCollectionsGraphCriteria().getAvgArrivalTime());
        }
        if (widget.getCollectionsGraphCriteria().getAvgWIPTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setAvgWIPTime(widget.getCollectionsGraphCriteria().getAvgWIPTime());
        }
        if (widget.getCollectionsGraphCriteria().getAvgThroughputTime() != null) {
            savedWidget.getCollectionsGraphCriteria().setAvgThroughputTime(widget.getCollectionsGraphCriteria().getAvgThroughputTime());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedActiveStatus() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedActiveStatus(widget.getCollectionsGraphCriteria().getSelectedActiveStatus());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedInProgressStatus() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedInProgressStatus(widget.getCollectionsGraphCriteria().getSelectedInProgressStatus());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedCompletedStatus() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedCompletedStatus(widget.getCollectionsGraphCriteria().getSelectedCompletedStatus());
        }
        if (widget.getCollectionsGraphCriteria().getAdvanceCriteria() != null) {
            savedWidget.getCollectionsGraphCriteria().setAdvanceCriteria(widget.getCollectionsGraphCriteria().getAdvanceCriteria());
        }
        if (widget.getCollectionsGraphCriteria().getSelectedAdvanceCriteria() != null) {
            savedWidget.getCollectionsGraphCriteria().setSelectedAdvanceCriteria(widget.getCollectionsGraphCriteria().getSelectedAdvanceCriteria());
        }
        if (widget.getCollectionsGraphCriteria().getyAxis() != null) {
            savedWidget.getCollectionsGraphCriteria().setyAxis(widget.getCollectionsGraphCriteria().getyAxis());
        }
        if (widget.getCollectionsGraphCriteria().getActiveStatuses() != null) {
            savedWidget.getCollectionsGraphCriteria().setActiveStatuses(widget.getCollectionsGraphCriteria().getActiveStatuses());
        }
        if (widget.getCollectionsGraphCriteria().getIssueType() != null) {
            savedWidget.getCollectionsGraphCriteria().setIssueType(widget.getCollectionsGraphCriteria().getIssueType());
        }
        if (widget.getCollectionsGraphCriteria().getGroupByTitle() != null) {
            savedWidget.getCollectionsGraphCriteria().setGroupByTitle(widget.getCollectionsGraphCriteria().getGroupByTitle());
        }
        if (widget.getCollectionsGraphCriteria().getItemTeamsMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemTeamsMap(widget.getCollectionsGraphCriteria().getItemTeamsMap());
        }
        if (widget.getCollectionsGraphCriteria().getItemSprintsMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemSprintsMap(widget.getCollectionsGraphCriteria().getItemSprintsMap());
        }
        if (widget.getCollectionsGraphCriteria().getItemGroupbyMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemGroupbyMap(widget.getCollectionsGraphCriteria().getItemGroupbyMap());
        }
        if (widget.getCollectionsGraphCriteria().getChartType() != null) {
            savedWidget.getCollectionsGraphCriteria().setChartType(widget.getCollectionsGraphCriteria().getChartType());
        }
        if (widget.getCollectionsGraphCriteria().getRelevantDates() != null) {
            savedWidget.getCollectionsGraphCriteria().setRelevantDates(widget.getCollectionsGraphCriteria().getRelevantDates());
        }
        if (widget.getCollectionsGraphCriteria().getTotalItemsList() != null) {
            savedWidget.getCollectionsGraphCriteria().setTotalItemsList(widget.getCollectionsGraphCriteria().getTotalItemsList());
        }
        if (widget.getCollectionsGraphCriteria().getActiveItemsList() != null) {
            savedWidget.getCollectionsGraphCriteria().setActiveItemsList(widget.getCollectionsGraphCriteria().getActiveItemsList());
        }
        if (widget.getCollectionsGraphCriteria().getBoardItemsFilter() != null) {
            savedWidget.getCollectionsGraphCriteria().setBoardItemsFilter(widget.getCollectionsGraphCriteria().getBoardItemsFilter());
        }
        if (widget.getCollectionsGraphCriteria().getItemIdsMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemIdsMap(widget.getCollectionsGraphCriteria().getItemIdsMap());
        }
        if (widget.getCollectionsGraphCriteria().getGraphTypeTitle() != null) {
            savedWidget.getCollectionsGraphCriteria().setGraphTypeTitle(widget.getCollectionsGraphCriteria().getGraphTypeTitle());
        }
        if (widget.getCollectionsGraphCriteria().getGroupIdColorMap() != null) {
            savedWidget.getCollectionsGraphCriteria().setGroupIdColorMap(widget.getCollectionsGraphCriteria().getGroupIdColorMap());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getItemTags())) {
            savedWidget.getCollectionsGraphCriteria().setItemTags(widget.getCollectionsGraphCriteria().getItemTags());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getItemTagsMetaMap())) {
            savedWidget.getCollectionsGraphCriteria().setItemTagsMetaMap(widget.getCollectionsGraphCriteria().getItemTagsMetaMap());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getCollectionName())) {
            savedWidget.getCollectionsGraphCriteria().setCollectionName(widget.getCollectionsGraphCriteria().getCollectionName());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getBacklogFilterName())) {
            savedWidget.getCollectionsGraphCriteria().setBacklogFilterName(widget.getCollectionsGraphCriteria().getBacklogFilterName());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getReleaseTrainId())) {
            savedWidget.getCollectionsGraphCriteria().setReleaseTrainId(widget.getCollectionsGraphCriteria().getReleaseTrainId());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getType())) {
            savedWidget.getCollectionsGraphCriteria().setType(widget.getCollectionsGraphCriteria().getType());
        }
        if (widget.getCollectionsGraphCriteria().getHierarchyLevelId() != null) {
            savedWidget.getCollectionsGraphCriteria().setHierarchyLevelId(widget.getCollectionsGraphCriteria().getHierarchyLevelId());
        }
        if (widget.getCollectionsGraphCriteria().getItemType() != null) {
            savedWidget.getCollectionsGraphCriteria().setItemType(widget.getCollectionsGraphCriteria().getItemType());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getFilterId())) {
            savedWidget.getCollectionsGraphCriteria().setFilterId(widget.getCollectionsGraphCriteria().getFilterId());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getHierarchyLevel())) {
            savedWidget.getCollectionsGraphCriteria().setHierarchyLevel(widget.getCollectionsGraphCriteria().getHierarchyLevel());
        }
        if (PropertyValidator.isValid((Collection)widget.getCollectionsGraphCriteria().getGroups())) {
            savedWidget.getCollectionsGraphCriteria().setGroups(widget.getCollectionsGraphCriteria().getGroups());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getCommittedDeliveredTracking())) {
            savedWidget.getCollectionsGraphCriteria().setCommittedDeliveredTracking(widget.getCollectionsGraphCriteria().getCommittedDeliveredTracking());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getCommittedDelivered())) {
            savedWidget.getCollectionsGraphCriteria().setCommittedDelivered(widget.getCollectionsGraphCriteria().getCommittedDelivered());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getCommittedAndScopeChangeTotal())) {
            savedWidget.getCollectionsGraphCriteria().setCommittedAndScopeChangeTotal(widget.getCollectionsGraphCriteria().getCommittedAndScopeChangeTotal());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getScopeChangeDeliveredTracking())) {
            savedWidget.getCollectionsGraphCriteria().setScopeChangeDeliveredTracking(widget.getCollectionsGraphCriteria().getScopeChangeDeliveredTracking());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getScopeChngeDelivered())) {
            savedWidget.getCollectionsGraphCriteria().setScopeChngeDelivered(widget.getCollectionsGraphCriteria().getScopeChngeDelivered());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getCommittedTeamsData())) {
            savedWidget.getCollectionsGraphCriteria().setCommittedTeamsData(widget.getCollectionsGraphCriteria().getCommittedTeamsData());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getScopeChangeAdded())) {
            savedWidget.getCollectionsGraphCriteria().setScopeChangeAdded(widget.getCollectionsGraphCriteria().getScopeChangeAdded());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getScopeChangeRemoved())) {
            savedWidget.getCollectionsGraphCriteria().setScopeChangeRemoved(widget.getCollectionsGraphCriteria().getScopeChangeRemoved());
        }
        if (PropertyValidator.isValid((Collection)widget.getCollectionsGraphCriteria().getAllTeams())) {
            savedWidget.getCollectionsGraphCriteria().setAllTeams(widget.getCollectionsGraphCriteria().getAllTeams());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getTeamAndColorList())) {
            savedWidget.getCollectionsGraphCriteria().setTeamAndColorList(widget.getCollectionsGraphCriteria().getTeamAndColorList());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getTeamAndLabelList())) {
            savedWidget.getCollectionsGraphCriteria().setTeamAndLabelList(widget.getCollectionsGraphCriteria().getTeamAndLabelList());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getTeamTarget())) {
            savedWidget.getCollectionsGraphCriteria().setTeamTarget(widget.getCollectionsGraphCriteria().getTeamTarget());
        }
        if (PropertyValidator.isValid((Object)widget.getCollectionsGraphCriteria().getSelectedBoardSprint())) {
            savedWidget.getCollectionsGraphCriteria().setSelectedBoardSprint(widget.getCollectionsGraphCriteria().getSelectedBoardSprint());
        }
        if (PropertyValidator.isValid((Object)widget.getCategory()) && widget.getCategory().equals("Completion by Teams")) {
            savedWidget.getCollectionsGraphCriteria().setFileReferenceKey(this.saveSimplifiedSprintData(widget));
        }
    }

    public Map<String, Object> updateWidgetSequence(String widgetId, Double sequence) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
            if (PropertyValidator.isValid((Object)widget) && PropertyValidator.isValid((Object)sequence)) {
                widget.setSequence(sequence);
                result.put("widget", this.widgetRepository.save((Object)widget));
            } else {
                result.put("error", "Couldn't Update Widget Sequence");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateWidgetSequence()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> deleteWidget(String dashboardId, Widget widget) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
            if (PropertyValidator.isValid((Object)dashboard) && PropertyValidator.isValid((Object)widget) && PropertyValidator.isValid((Object)widget.getId())) {
                Widget savedWidget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widget.getId()));
                if (PropertyValidator.isValid((Collection)dashboard.getWidgets())) {
                    ArrayList<Widget> updatedWidgets = new ArrayList<Widget>();
                    for (Widget dashboardWidget : dashboard.getWidgets()) {
                        if (dashboardWidget.getId().equals(savedWidget.getId())) {
                            this.widgetRepository.delete((Object)savedWidget);
                            result.put("success", "Widget Deletion Successful");
                            continue;
                        }
                        updatedWidgets.add(dashboardWidget);
                    }
                    if (updatedWidgets.size() != dashboard.getWidgets().size()) {
                        dashboard.setWidgets(updatedWidgets);
                        result.put("dashboard", this.dashboardRepository.save((Object)dashboard));
                    } else {
                        result.put("error", "Unable to Delete Widget " + widget.getName() + " with Dashboard Id: " + dashboardId);
                    }
                }
            } else {
                result.put("error", "Invalid Dashboard/Widget");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing deleteWidget()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> deleteWidgetById(String dashboardId, String widgetId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardId));
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(query, Dashboard.class);
            if (PropertyValidator.isValid((Object)dashboard) && PropertyValidator.isValid((Object)widgetId)) {
                Widget savedWidget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
                if (PropertyValidator.isValid((Collection)dashboard.getWidgets())) {
                    ArrayList<Widget> updatedWidgets = new ArrayList<Widget>();
                    for (Widget dashboardWidget : dashboard.getWidgets()) {
                        if (dashboardWidget.getId().equals(savedWidget.getId())) {
                            this.widgetRepository.delete((Object)savedWidget);
                            result.put("success", "Widget Deletion Successful");
                            continue;
                        }
                        updatedWidgets.add(dashboardWidget);
                    }
                    if (updatedWidgets.size() != dashboard.getWidgets().size()) {
                        dashboard.setWidgets(updatedWidgets);
                        result.put("dashboard", this.dashboardRepository.save((Object)dashboard));
                    } else {
                        result.put("error", "Unable to Delete Widget with id " + widgetId + " with Dashboard Key: " + dashboardId);
                    }
                }
            } else {
                result.put("error", "Invalid Dashboard/Widget");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemsUsingBasicDBObject()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public List<DBObject> getAllAccessableBoards() {
        List<Object> sessions = new ArrayList<DBObject>();
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            ArrayList<ObjectId> workSpacesIds = new ArrayList<ObjectId>();
            HashSet workSpaces = new HashSet();
            List<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList();
            if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
                workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
                for (WorkSpace workSpace : workSpaces) {
                    WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                    accessRole.setWorkSpace(workSpace);
                    accessRole.setUser(user);
                    workSpaceAccessRoles.add(accessRole);
                }
            } else {
                workSpaceAccessRoles = this.customRepositoryImpl.findWorkspaceAccessRoles(user);
                for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                    if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                    workSpaces.add(workSpaceAccessRole.getWorkSpace());
                }
            }
            for (WorkSpace rawWorkSpace : workSpaces) {
                workSpacesIds.add(new ObjectId(String.valueOf(String.valueOf(rawWorkSpace.getId()))));
            }
            if (PropertyValidator.isValid((Collection)workSpaces)) {
                sessions = this.getSessionDBObjectList(workSpacesIds);
                sessions.forEach(Session2 -> Session2.put("_id", (Object)String.valueOf(Session2.get("_id"))));
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sessions;
    }

    private StateScheme getDefaultStateScheme() {
        try {
            StateScheme defaultStateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
            return defaultStateScheme;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDefaultStateScheme()" + StringUtils.getTraceString((Throwable)e));
            return new StateScheme();
        }
    }

    public void fillBoardStatuses(SessionBoard sessionBoard) {
        try {
            sessionBoard.getSession().setStateScheme(this.getDefaultStateScheme());
            sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
            if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNullAndSessionIdAndItemType(sessionBoard.getSession().getId(), "Feature"));
                sessionBoard.getSession().getSubItemWorkFlow().setStatuses(this.statusRepository.findByJiraProjKeyNotNullAndSessionIdAndItemType(sessionBoard.getSession().getId(), "UserStory"));
                sessionBoard.getSession().getItemWorkFlow().getStatuses().addAll(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()), (String)sessionBoard.getSession().getItemWorkFlow().getStatusSequence()));
                sessionBoard.getSession().getSubItemWorkFlow().getStatuses().addAll(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
            } else if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                List tfsProjects = this.tfsProjectRepository.findProjectBySessionId(sessionBoard.getSession().getId());
                ArrayList<String> tfsIds = new ArrayList<String>();
                for (TFSProject tfsProject : tfsProjects) {
                    tfsIds.add(tfsProject.getTfsId());
                }
                List tfsStatuses = new ArrayList();
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"tfsProjectId").in(tfsIds).and("tenant").is((Object)sessionBoard.getSession().getTenant()));
                query.fields().include("_id").include("category").include("title");
                tfsStatuses = this.mongoTemplate.find(query, Status.class);
                tfsStatuses.addAll(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()), (String)sessionBoard.getSession().getItemWorkFlow().getStatusSequence()));
                tfsStatuses.addAll(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
                sessionBoard.getSession().getSubItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
                sessionBoard.getSession().getItemWorkFlow().setStatuses(tfsStatuses);
            } else {
                sessionBoard.getSession().getItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()), (String)sessionBoard.getSession().getItemWorkFlow().getStatusSequence()));
                sessionBoard.getSession().getSubItemWorkFlow().setStatuses(KendisUtils.sortStatuses((List)this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()), (String)sessionBoard.getSession().getSubItemWorkFlow().getStatusSequence()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fillBoardStatuses()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public List<Status> getAllAccessableBoardStatus(String sessionId) {
        List<Object> statusList = new ArrayList<Status>();
        try {
            SessionBoard sessionBoard = this.getSessionBoardBySessionId(sessionId);
            this.fillBoardStatuses(sessionBoard);
            if (sessionBoard.getSession().getItemWorkFlow().getStatuses() != null) {
                statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            }
            if (sessionBoard.getSession().getSubItemWorkFlow().getStatuses() != null) {
                statusList.addAll(sessionBoard.getSession().getSubItemWorkFlow().getStatuses());
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return statusList;
    }

    public Map<String, Object> getAdvanceCriteriaForCFD(String sessionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            SessionBoard sessionBoard = this.getSessionBoardBySessionId(sessionId);
            List containers = sessionBoard.getContainers();
            List teams = sessionBoard.getTeams();
            result.put("teams", teams);
            result.put("sprints", containers);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> createDataForAreaChart(Map<String, Object> requestStr) throws Exception {
        Date startDate = new Date();
        Date endDate = new Date();
        String tenant = "";
        HashMap<String, Object> objectData = new HashMap<String, Object>();
        try {
            TimeSeriesDTO.Interval interval = TimeSeriesDTO.Interval.fromValue((String)"Day");
            List queryData = (List)requestStr.get("statusIds");
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            Optional<ArrayList> optionalTeamId = Optional.ofNullable((ArrayList)requestStr.get("teams"));
            Optional<ArrayList> optionalSprintId = Optional.ofNullable((ArrayList)requestStr.get("sprints"));
            if (PropertyValidator.isValid((Object)requestStr.get("startDate")) && PropertyValidator.isValid((Object)"endDate")) {
                startDate = this.dateFormat.parse((String)requestStr.get("startDate"));
                endDate = this.dateFormat.parse((String)requestStr.get("endDate"));
            }
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            Map itemData = this.timeSeriesRepository.getItemsForTheGivingDurition(startDate, endDate, sessionBoardIds, tenant, interval, queryData, optionalTeamId, optionalSprintId);
            List intervals = this.createIntervalsBetweenDatesForType(startDate, endDate, interval);
            objectData.put("itemData", itemData);
            objectData.put("intervals", intervals);
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForAreaChart()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public Map<String, Object> createDataForCFD(Map<String, Object> requestStr) throws Exception {
        String tenant = "";
        HashMap<String, Object> objectData = new HashMap();
        String sessionBoardIds = "";
        Date startDate = new Date();
        Date endDate = new Date();
        List selectedStatusIds = new ArrayList();
        String xAxis = "";
        String advanceCriteria = "";
        List selectedAdvanceCriteria = new ArrayList();
        String selectedActiveStatus = "";
        List selectedWaitingStatus = new ArrayList();
        List selectedCompletedStatus = new ArrayList();
        Boolean toggleAvgLeadTime = false;
        Boolean toggleAvgCycleTime = false;
        Boolean toggleAvgWIPTime = false;
        Boolean toggleAvgArrivalTime = false;
        Boolean toggleAvgThroughputTime = false;
        Boolean toggleAdvanceCriteria = false;
        Boolean toggleAdvanceCalculation = false;
        SessionBoard sessionBoard = new SessionBoard();
        Map issueTypeMap = new HashMap();
        String radioButtonSelection = "";
        String boardItemsFilter = "";
        String dashboardKey = "";
        List selectedIssueType = new ArrayList();
        Map itemTags = new HashMap();
        try {
            String[] activeids;
            if (PropertyValidator.isValid((Collection)((List)requestStr.get("issueType")))) {
                selectedIssueType = (List)requestStr.get("issueType");
            }
            if (PropertyValidator.isValid((Object)((String)requestStr.get("boardItemsFilter")))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAvgLeadTime")))) {
                toggleAvgLeadTime = (Boolean)requestStr.get("toggleAvgLeadTime");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAvgCycleTime")))) {
                toggleAvgCycleTime = (Boolean)requestStr.get("toggleAvgCycleTime");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAvgWIPTime")))) {
                toggleAvgWIPTime = (Boolean)requestStr.get("toggleAvgWIPTime");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAvgArrivalTime")))) {
                toggleAvgArrivalTime = (Boolean)requestStr.get("toggleAvgArrivalTime");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAvgThroughputTime")))) {
                toggleAvgThroughputTime = (Boolean)requestStr.get("toggleAvgThroughputTime");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAdvanceCriteria")))) {
                toggleAdvanceCriteria = (Boolean)requestStr.get("toggleAdvanceCriteria");
            }
            if (PropertyValidator.isValid((Object)((Boolean)requestStr.get("toggleAdvanceCalculation")))) {
                toggleAdvanceCalculation = (Boolean)requestStr.get("toggleAdvanceCalculation");
            }
            if (PropertyValidator.isValid((Object)((String)requestStr.get("radioButtonSelection")))) {
                radioButtonSelection = (String)requestStr.get("radioButtonSelection");
            }
            if (PropertyValidator.isValid((Object)((String)requestStr.get("sessionBoardId")))) {
                sessionBoardIds = (String)requestStr.get("sessionBoardId");
                Query sessionBoardQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
                sessionBoard = (SessionBoard)this.mongoTemplate.findOne(sessionBoardQuery, SessionBoard.class);
                this.fillBoardStatuses(sessionBoard);
            }
            if (PropertyValidator.isValid((Object)((String)requestStr.get("selectedActiveStatus")))) {
                selectedActiveStatus = (String)requestStr.get("selectedActiveStatus");
            }
            if (PropertyValidator.isValid((Collection)((List)requestStr.get("selectedWaitingStatus")))) {
                selectedWaitingStatus = (List)requestStr.get("selectedWaitingStatus");
            }
            if (PropertyValidator.isValid((Collection)((List)requestStr.get("selectedCompletedStatus")))) {
                selectedCompletedStatus = (List)requestStr.get("selectedCompletedStatus");
            }
            if (PropertyValidator.isValid((Collection)((List)requestStr.get("selectedStatusIds")))) {
                selectedStatusIds = (List)requestStr.get("selectedStatusIds");
            }
            if (PropertyValidator.isValid((Collection)((List)requestStr.get("selectedAdvanceCriteria")))) {
                selectedAdvanceCriteria = (List)requestStr.get("selectedAdvanceCriteria");
            }
            if (PropertyValidator.isValid((Object)((String)requestStr.get("advanceCriteria")))) {
                advanceCriteria = (String)requestStr.get("advanceCriteria");
            }
            if (PropertyValidator.isValid((Object)((String)requestStr.get("xAxis")))) {
                xAxis = (String)requestStr.get("xAxis");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("startDate")) && PropertyValidator.isValid((Object)requestStr.get("endDate"))) {
                Map result = this.getStartEndDateofPI(sessionBoardIds);
                startDate = (Date)result.get("startDate");
                endDate = (Date)result.get("endDate");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("issueTypeMap"))) {
                issueTypeMap = (Map)requestStr.get("issueTypeMap");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            ArrayList<String> individualActiveStatusIds = new ArrayList<String>();
            for (String id : activeids = selectedActiveStatus.split(",")) {
                individualActiveStatusIds.add(id);
            }
            ArrayList<String> individualWaitingStatusIds = new ArrayList<String>();
            for (String str : selectedWaitingStatus) {
                String[] ids;
                for (String id : ids = str.split(",")) {
                    individualWaitingStatusIds.add(id);
                }
            }
            ArrayList<String> individualCompletedStatusIds = new ArrayList<String>();
            for (Object str : selectedCompletedStatus) {
                String[] ids;
                for (String id : ids = ((String)str).split(",")) {
                    individualCompletedStatusIds.add(id);
                }
            }
            ArrayList<String> individualSelectedStatusIds = new ArrayList<String>();
            for (String str : selectedStatusIds) {
                String[] ids;
                for (String id : ids = str.split(",")) {
                    individualSelectedStatusIds.add(id);
                }
            }
            Dashboard dashboard = new Dashboard();
            if (requestStr.containsKey("dashboardId")) {
                Query queryforDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is(requestStr.get("dashboardId")));
                queryforDashboard.fields().include("_id");
                queryforDashboard.fields().include("globalColorsMap");
                dashboard = (Dashboard)this.mongoTemplate.findOne(queryforDashboard, Dashboard.class);
            }
            objectData = this.timeSeriesRepository.getCFDItems(tenant, individualSelectedStatusIds, individualActiveStatusIds, individualWaitingStatusIds, individualCompletedStatusIds, xAxis, startDate, endDate, sessionBoard, advanceCriteria, selectedAdvanceCriteria, toggleAvgArrivalTime, toggleAvgCycleTime, toggleAvgLeadTime, toggleAvgThroughputTime, toggleAdvanceCalculation, toggleAdvanceCriteria, toggleAvgWIPTime, selectedIssueType, issueTypeMap, radioButtonSelection, boardItemsFilter, dashboard, itemTags);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in createDataForCFD()" + StringUtils.getTraceString((Throwable)e));
            throw e;
        }
        return objectData;
    }

    public Map<String, Object> createDataForTimeFlowChart(Map<String, Object> requestStr) throws Exception {
        String tenant = "";
        String interval = null;
        Map<String, Object> responseObject = new HashMap<String, Object>();
        Map itemTags = new HashMap();
        try {
            List selectedIssueType = (List)requestStr.get("issueType");
            String radioTypeSelection = (String)requestStr.get("radioTypeSelection");
            if (requestStr.get("interval") != null) {
                interval = (String)requestStr.get("interval");
            }
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            String boardItemsFilter = "";
            if (PropertyValidator.isValid((Object)requestStr.get("boardItemsFilter"))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
            query.fields().include("session");
            query.fields().include("teams");
            query.fields().include("creationDate");
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            this.fillBoardStatuses(sessionBoard);
            HashMap itemData = new HashMap();
            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            statusList.addAll(sessionBoard.getSession().getSubItemWorkFlow().getStatuses());
            if (radioTypeSelection == null) {
                String startStatusId = (String)requestStr.get("startStatus");
                String endStatusId = (String)requestStr.get("endStatus");
                ArrayList<String> startStatusIdList = new ArrayList<String>(Arrays.asList(startStatusId.split(",")));
                ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                responseObject = this.timeSeriesRepository.getItemsBasedOnStartEndStatus(sessionBoardIds, tenant, startStatusIdList, endStatusIdList, interval, statusList, selectedIssueType, boardItemsFilter, radioTypeSelection, itemTags);
            } else if (radioTypeSelection.equals("status") || radioTypeSelection.equals("statusCategory")) {
                String startStatusId = (String)requestStr.get("startStatus");
                String endStatusId = (String)requestStr.get("endStatus");
                ArrayList<String> startStatusIdList = new ArrayList<String>(Arrays.asList(startStatusId.split(",")));
                ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                responseObject = this.timeSeriesRepository.getItemsBasedOnStartEndStatus(sessionBoardIds, tenant, startStatusIdList, endStatusIdList, interval, statusList, selectedIssueType, boardItemsFilter, radioTypeSelection, itemTags);
            } else if (radioTypeSelection.equals("creationDate")) {
                String endStatusId = (String)requestStr.get("endStatus");
                ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                responseObject = this.timeSeriesRepository.getItemsBasedOnCreationDate(sessionBoardIds, tenant, interval, statusList, selectedIssueType, boardItemsFilter, endStatusIdList, itemTags);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForTimeFlowChart()" + StringUtils.getTraceString((Throwable)e));
        }
        return responseObject;
    }

    public Map<String, Object> createDataForFlowTimeLineGraph(Map<String, Object> requestStr) throws Exception {
        HashMap<String, Object> objectData = new HashMap<String, Object>();
        try {
            String tenant = "";
            List selectedIssueType = (List)requestStr.get("issueType");
            String radioTypeSelection = (String)requestStr.get("radioTypeSelection");
            String interval = null;
            String groupBy = null;
            Map itemTags = new HashMap();
            if (requestStr.get("interval") != null) {
                interval = (String)requestStr.get("interval");
            }
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            if (requestStr.get("groupBy") != null) {
                groupBy = (String)requestStr.get("groupBy");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
            query.fields().include("session");
            query.fields().include("teams");
            query.fields().include("creationDate");
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            this.fillBoardStatuses(sessionBoard);
            String dashboardKey = (String)requestStr.get("dashboardId");
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            queryForDashboard.fields().include("_id");
            queryForDashboard.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            Map itemData = new HashMap();
            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            String boardItemsFilter = "";
            if (PropertyValidator.isValid((Object)requestStr.get("boardItemsFilter"))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (radioTypeSelection.equals("status") || radioTypeSelection.equals("statusCategory")) {
                String startStatusId = (String)requestStr.get("startStatus");
                String endStatusId = (String)requestStr.get("endStatus");
                ArrayList<String> startStatusIdList = new ArrayList<String>(Arrays.asList(startStatusId.split(",")));
                ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                itemData = this.timeSeriesRepository.getItemsForFlowLine(sessionBoard, sessionBoardIds, tenant, startStatusIdList, endStatusIdList, interval, statusList, selectedIssueType, groupBy, radioTypeSelection, boardItemsFilter, dashboard, itemTags);
            }
            objectData = itemData;
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForFlowTimeLineGraph()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public Map<String, Object> boardTeamsAndSprintList(String sessionId, Map<String, Object> requestStr) throws Exception {
        HashMap<String, Object> teamAndSprintMap = new HashMap<String, Object>();
        try {
            List sessionBoardList = this.getSessionBoardDBObject(sessionId);
            if (PropertyValidator.isValid((Collection)sessionBoardList)) {
                DBObject sessionBoard = (DBObject)sessionBoardList.get(0);
                if (requestStr.containsKey("teams") && PropertyValidator.isValid((Object)sessionBoard.get("teams"))) {
                    List teams = (List)sessionBoard.get("teams");
                    ArrayList<ObjectId> teamsIds = new ArrayList<ObjectId>();
                    for (DBRef team2 : teams) {
                        teamsIds.add(new ObjectId(String.valueOf(team2.getId())));
                    }
                    List teamsList = this.getTeamsOrSprintsDBObjectList(teamsIds, "team");
                    teamsList.forEach(team -> team.put("_id", (Object)String.valueOf(team.get("_id"))));
                    teamAndSprintMap.put("teams", teamsList);
                    teamAndSprintMap.put("teamSequence", sessionBoard.get("teamSequence"));
                }
                if (requestStr.containsKey("sprints") && PropertyValidator.isValid((Object)sessionBoard.get("containers"))) {
                    List sprints = (List)sessionBoard.get("containers");
                    ArrayList<String> sprintIds = new ArrayList<String>();
                    for (DBRef sprint : sprints) {
                        sprintIds.add(String.valueOf(sprint.getId()));
                    }
                    List sprintsList = this.containerRepository.findContainerByIdIn(sprintIds);
                    teamAndSprintMap.put("sprints", sprintsList);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing boardTeamsAndSprintList()" + StringUtils.getTraceString((Throwable)e));
        }
        return teamAndSprintMap;
    }

    private List<DBObject> getTeamCapacity(String sessionBoardIds, String tenant) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoardId").is((Object)sessionBoardIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("teamSprintVelocity").find(query.getQueryObject());
            return dbCursorPrefix.toArray();
        }
        catch (Exception e) {
            LOGGER.error("Error processing getTeamCapacity()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private List<DBObject> getAuditLogData(Set<ObjectId> auditLogIds, Set<String> linkedBaseLineAuditLogIds) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"_id").in(auditLogIds), Criteria.where((String)"linkedBaseLineAuditLogId").in(linkedBaseLineAuditLogIds)}));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("auditLog").find(query.getQueryObject());
            return dbCursorPrefix.toArray();
        }
        catch (Exception e) {
            LOGGER.error("Error processing getAuditLogData()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private HashMap<String, Object> spillOverAndCommittedLoadCalculations(List<DBObject> boardCapacity) throws Exception {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            HashSet<ObjectId> lastBaseLinerAuditLogIds = new HashSet<ObjectId>();
            HashSet<String> lastBaseLinerAuditLogIdsStr = new HashSet<String>();
            HashMap auditLogIdForSpillData = new HashMap();
            HashMap<String, DBObject> capacityMap = new HashMap<String, DBObject>();
            for (DBObject capacity : boardCapacity) {
                if (capacity.get("lastBaseLineAuditLogId") != null) {
                    lastBaseLinerAuditLogIdsStr.add(String.valueOf(capacity.get("lastBaseLineAuditLogId")));
                    lastBaseLinerAuditLogIds.add(new ObjectId(String.valueOf(capacity.get("lastBaseLineAuditLogId"))));
                    capacityMap.put(String.valueOf(capacity.get("lastBaseLineAuditLogId")), capacity);
                }
                if (capacity.get("lastSpillOverAuditLogId") == null) continue;
                HashMap<String, String> auditLogSprintAndTeamId = new HashMap<String, String>();
                auditLogSprintAndTeamId.put("sprintId", String.valueOf(capacity.get("sprintId")));
                auditLogSprintAndTeamId.put("teamId", String.valueOf(capacity.get("teamId")));
                auditLogIdForSpillData.put(String.valueOf(capacity.get("lastBaseLineAuditLogId")), auditLogSprintAndTeamId);
            }
            List auditLogs = this.getAuditLogData(lastBaseLinerAuditLogIds, lastBaseLinerAuditLogIdsStr);
            response.put("auditLogs", auditLogs);
            response.put("auditLogIdForSpillData", auditLogIdForSpillData);
        }
        catch (Exception e) {
            LOGGER.error("Error processing spillOverAndCommittedLoadCalculations()" + StringUtils.getTraceString((Throwable)e));
        }
        return response;
    }

    private List<DBObject> getPiReportItems(String sessionBoardId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.fields().include("_id");
            query.fields().include("originItemId");
            query.fields().include("parent");
            query.fields().include("title");
            query.fields().include("subItemEstimate");
            query.fields().include("status");
            query.fields().include("jiraKey");
            query.fields().include("jiraId");
            query.fields().include("tfsId");
            query.fields().include("tfsURL");
            query.fields().include("itemLinks");
            query.fields().include("sessionBoards");
            query.fields().include("teamContainers");
            query.fields().include("issueType");
            query.fields().include("storyPoints");
            query.fields().include("duplicateOfId");
            query.fields().include("type");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject(), query.getFieldsObject());
            List rawItems = dbCursorPrefix.toArray();
            return rawItems;
        }
        catch (Exception e) {
            LOGGER.error("Error processing getPiReportItems()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<DBObject>();
        }
    }

    private void filterSpillOverAndCommittedLoad(Map<String, Object> boardItemsById, Map<String, Object> response, Map<String, String> issueTyepIdMap, Map<String, String> selectedStatusMap) throws Exception {
        try {
            List auditLogs = (List)response.get("auditLogs");
            HashSet<String> committedLoad = new HashSet<String>();
            HashSet<String> scopeChangesAfterStartOfSprint = new HashSet<String>();
            for (DBObject auditLogData : auditLogs) {
                Map reqbody = new HashMap();
                Gson gson = new Gson();
                2 T = new /* Unavailable Anonymous Inner Class!! */;
                reqbody = (Map)gson.fromJson((String)auditLogData.get("auditData"), T.getType());
                if (!PropertyValidator.isValid(reqbody) || !PropertyValidator.isValid(reqbody.keySet())) continue;
                for (String key : reqbody.keySet()) {
                    Map singleBaseLineItem = (Map)reqbody.get(key);
                    if (!PropertyValidator.isValid(singleBaseLineItem.get("jiraIssueTypeId")) || !issueTyepIdMap.containsKey(singleBaseLineItem.get("jiraIssueTypeId"))) continue;
                    if (!auditLogData.get("eventType").equals("ITEM_ADD")) {
                        committedLoad.add(String.valueOf(singleBaseLineItem.get("id")));
                    } else {
                        scopeChangesAfterStartOfSprint.add(String.valueOf(singleBaseLineItem.get("id")));
                    }
                    if (!boardItemsById.containsKey(singleBaseLineItem.get("id"))) continue;
                    Map map = (Map)boardItemsById.get(singleBaseLineItem.get("id"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing filterSpillOverAndCommittedLoad()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public List<?> getItemCompletionbyTeams(Map<?, ?> request) throws Exception {
        try {
            Map selectedBoard = (Map)request.get("selectedBoard");
            String tenant = (String)request.get("tenant");
            List boardCapacity = this.getTeamCapacity(String.valueOf(selectedBoard.get("activeSessionBoard")), tenant);
            HashMap response = this.spillOverAndCommittedLoadCalculations(boardCapacity);
            List boardItems = this.getPiReportItems(String.valueOf(selectedBoard.get("activeSessionBoard")));
            HashMap<String, DBObject> boardItemsById = new HashMap<String, DBObject>();
            List selectedIssueType = (List)request.get("selectedIssueType");
            List selectedActiveStatus = (List)request.get("selectedActiveStatus");
            Map<String, String> issueTyepIdMap = selectedIssueType.stream().collect(Collectors.toMap(issueId -> issueId, issueIdVal -> issueIdVal));
            Map<String, String> selectedStatusMap = selectedActiveStatus.stream().collect(Collectors.toMap(statusId -> statusId, statusVal -> statusVal));
            for (DBObject item : boardItems) {
                boardItemsById.put(String.valueOf(item.get("_id")), item);
            }
            this.filterSpillOverAndCommittedLoad(boardItemsById, (Map)response, issueTyepIdMap, selectedStatusMap);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getItemCompletionbyTeams()" + StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    private List<String> createIntervalsBetweenDatesForType(Date startDate, Date endDate, TimeSeriesDTO.Interval interval) {
        try {
            ArrayList<String> dateIntervals = new ArrayList<String>();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(interval.getPattern());
            LocalDate localStartDate = KendisUtils.convertToLocalDate((String)startDate.toString());
            LocalDate localEndDate = KendisUtils.convertToLocalDate((String)endDate.toString());
            if (PropertyValidator.isValid((Object)localStartDate) && PropertyValidator.isValid((Object)localEndDate)) {
                LocalDate currentDate = localStartDate;
                while (!currentDate.isAfter(localEndDate)) {
                    dateIntervals.add(formatter.format(currentDate));
                    switch (3.$SwitchMap$com$viztrend$safe$persistence$entity$TimeSeriesDTO$Interval[interval.ordinal()]) {
                        case 1: {
                            currentDate = currentDate.plusDays(1L);
                            break;
                        }
                        case 2: {
                            currentDate = currentDate.plusMonths(1L);
                            break;
                        }
                        case 3: {
                            currentDate = currentDate.plusYears(1L);
                        }
                    }
                }
            }
            return dateIntervals;
        }
        catch (Exception e) {
            LOGGER.error("Error processing createIntervalsBetweenDatesForType()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<String>();
        }
    }

    public List<BacklogItem> getBackLogItemsofStatusIdPaginated(List<ObjectId> statusIdsList, int page, int size, String releaseTrainId) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"status.$id").in(statusIdsList).and("tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0));
            query.skip(page * size).limit(size);
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error processing getBackLogItemsofStatusIdPaginated()" + StringUtils.getTraceString((Throwable)e));
            return new ArrayList<BacklogItem>();
        }
    }

    public SessionBoard getSessionBoardBySessionId(String sessionId) {
        SessionBoard sessionBoard = new SessionBoard();
        try {
            String sessionBoardId;
            BasicDBObject workflowFields;
            BasicDBObject workflowFilter;
            BasicDBObject sessionFilter = new BasicDBObject();
            sessionFilter.put((Object)"_id", (Object)new ObjectId(sessionId));
            DBCollection sessionCollection = this.mongoTemplate.getCollection("session");
            BasicDBObject sessionFields = new BasicDBObject();
            sessionFields.put((Object)"title", (Object)1);
            sessionFields.put((Object)"itemWorkFlow", (Object)1);
            sessionFields.put((Object)"subItemWorkFlow", (Object)1);
            sessionFields.put((Object)"activeSessionBoard", (Object)1);
            sessionFields.put((Object)"stateScheme", (Object)1);
            sessionFields.put((Object)"stateScheme", (Object)1);
            sessionFields.put((Object)"almConfigurations", (Object)1);
            sessionFields.put((Object)"tfsAlmConfigurations", (Object)1);
            DBObject sessionDbObject = sessionCollection.findOne((DBObject)sessionFilter, (DBObject)sessionFields);
            if (sessionDbObject == null) {
                return null;
            }
            Session session = new Session();
            session.setId(sessionId);
            session.setTitle((String)sessionDbObject.get("title"));
            session.setActiveSessionBoard((String)sessionDbObject.get("activeSessionBoard"));
            DBRef itemWorkFlowRef = (DBRef)sessionDbObject.get("itemWorkFlow");
            DBRef subItemWorkFlowRef = (DBRef)sessionDbObject.get("subItemWorkFlow");
            DBRef stateSchemeRef = (DBRef)sessionDbObject.get("stateScheme");
            List almConfigurationsList = (List)sessionDbObject.get("almConfigurations");
            DBRef tfsalmConfigurations = (DBRef)sessionDbObject.get("tfsAlmConfigurations");
            if (PropertyValidator.isValid((Collection)almConfigurationsList)) {
                List almConfigurations = almConfigurationsList.stream().map(item -> new AlmConfigurations()).collect(Collectors.toList());
                session.setAlmConfigurations(almConfigurations);
            }
            if (PropertyValidator.isValid((Object)tfsalmConfigurations)) {
                TFSAlmConfigurations tfsalmConfiguration = new TFSAlmConfigurations();
                session.setTfsAlmConfigurations(tfsalmConfiguration);
            }
            DBCollection workFlowCollection = this.mongoTemplate.getCollection("workFlow");
            if (itemWorkFlowRef != null) {
                workflowFilter = new BasicDBObject();
                workflowFilter.put((Object)"_id", itemWorkFlowRef.getId());
                workflowFields = new BasicDBObject();
                workflowFields.put((Object)"statusSequence", (Object)1);
                DBObject itemWorkFlowDBObject = workFlowCollection.findOne((DBObject)workflowFilter, (DBObject)workflowFields);
                if (itemWorkFlowDBObject != null) {
                    WorkFlow ItemworkFlow = new WorkFlow();
                    ItemworkFlow.setStatusSequence((String)itemWorkFlowDBObject.get("statusSequence"));
                    ItemworkFlow.setId(itemWorkFlowRef.getId().toString());
                    session.setItemWorkFlow(ItemworkFlow);
                }
            }
            if (subItemWorkFlowRef != null) {
                workflowFilter = new BasicDBObject();
                workflowFilter.put((Object)"_id", subItemWorkFlowRef.getId());
                workflowFields = new BasicDBObject();
                workflowFields.put((Object)"statusSequence", (Object)1);
                DBObject subItemWorkFlowDBObject = workFlowCollection.findOne((DBObject)workflowFilter, (DBObject)workflowFields);
                if (subItemWorkFlowDBObject != null) {
                    WorkFlow subItemworkFlow = new WorkFlow();
                    subItemworkFlow.setId(subItemWorkFlowRef.getId().toString());
                    subItemworkFlow.setStatusSequence((String)subItemWorkFlowDBObject.get("statusSequence"));
                    session.setSubItemWorkFlow(subItemworkFlow);
                }
            }
            DBCollection stateSchemeFlowCollection = this.mongoTemplate.getCollection("stateScheme");
            if (stateSchemeRef != null) {
                BasicDBObject stateSchemeFilter = new BasicDBObject();
                stateSchemeFilter.put((Object)"_id", stateSchemeRef.getId());
                BasicDBObject stateSchemeFields = new BasicDBObject();
                stateSchemeFields.put((Object)"title", (Object)1);
                stateSchemeFields.put((Object)"isDefault", (Object)1);
                DBObject stateSchemeDbObject = stateSchemeFlowCollection.findOne((DBObject)stateSchemeFilter, (DBObject)stateSchemeFields);
                if (stateSchemeDbObject != null) {
                    StateScheme stateScheme = new StateScheme();
                    stateScheme.setTitle((String)stateSchemeDbObject.get("title"));
                    stateScheme.setDefault(((Boolean)stateSchemeDbObject.get("isDefault")).booleanValue());
                    session.setStateScheme(stateScheme);
                }
            }
            if ((sessionBoardId = session.getActiveSessionBoard()) == null) {
                return null;
            }
            BasicDBObject filter = new BasicDBObject();
            filter.put((Object)"_id", (Object)new ObjectId(sessionBoardId));
            DBCollection collection = this.mongoTemplate.getCollection("sessionBoard");
            DBCursor querys = collection.find((DBObject)filter);
            sessionBoard = (SessionBoard)this.mongoTemplate.findById((Object)new ObjectId(sessionBoardId), SessionBoard.class);
            if (sessionBoard == null) {
                return null;
            }
            while (querys.hasNext()) {
                DBObject dbObject = querys.next();
                sessionBoard = new SessionBoard();
                sessionBoard.setId(dbObject.get("_id").toString());
                sessionBoard.setTenant((String)dbObject.get("tenant"));
                sessionBoard.setSession(session);
                List dbRefTeams = (List)dbObject.get("teams");
                if (dbRefTeams == null || dbRefTeams.isEmpty()) continue;
                ArrayList<Team> teams = new ArrayList<Team>();
                for (DBRef dbRefTeam : dbRefTeams) {
                    Team team = (Team)this.mongoTemplate.findById(dbRefTeam.getId(), Team.class);
                    teams.add(team);
                }
                sessionBoard.setTeams(teams);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getSessionBoardBySessionId()" + StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoard;
    }

    public List<BacklogItem> getBackLogItemsofTeamIdsPaginated(List<String> teamIdsList, int page, int size, String releaseTrainId) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"teamContainerRelations").elemMatch(Criteria.where((String)"teamId").in(teamIdsList)).and("tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0));
            query.skip(page * size).limit(size);
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in getBackLogItemsofTeamIdsPaginated()" + StringUtils.getTraceString((Throwable)e));
            return Collections.emptyList();
        }
    }

    public List<BacklogItem> getBackLogItemsofTeamStatusCategoryPaginated(String teamId, int page, int size, String releaseTrainId, List<ObjectId> statusIds) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"teamContainerRelations").elemMatch(Criteria.where((String)"teamId").in(new Object[]{teamId})).and("tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0).and("status.$id").in(statusIds));
            query.skip(page * size).limit(size);
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in getBackLogItemsofTeamStatusCategoryPaginated()" + StringUtils.getTraceString((Throwable)e));
            return Collections.emptyList();
        }
    }

    public List<BacklogItem> getBackLogItemsofStatusId(String statusId, String releaseTrainId) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"status.$id").is((Object)new ObjectId(statusId)).and("tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0));
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in getBackLogItemsofStatusId()" + StringUtils.getTraceString((Throwable)e));
            return Collections.emptyList();
        }
    }

    public List<BacklogItem> getBackLogItemsofTeamId(String teamId, String releaseTrainId) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"teamContainerRelations").elemMatch(Criteria.where((String)"teamId").in(new Object[]{teamId})).and("tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0));
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in getBackLogItemsofTeamId()" + StringUtils.getTraceString((Throwable)e));
            return Collections.emptyList();
        }
    }

    public List<BacklogItem> getAllBackLogItems(String releaseTrainId) {
        try {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0));
            return this.mongoTemplate.find(query, BacklogItem.class);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in getAllBackLogItems()" + StringUtils.getTraceString((Throwable)e));
            return Collections.emptyList();
        }
    }

    public Map<String, Object> groupByItems(String groupBy, String parentGroup, List<String> items, String releaseTrainId) {
        HashMap result = new HashMap();
        try {
            ArrayList itemsFinalList = new ArrayList();
            if (groupBy.equals("statusCategory") && parentGroup.equals("teams")) {
                List listOfTeams = this.teamRepository.findByIdIn(items);
                String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                for (String item : items) {
                    Object backlogItem2;
                    Query query = new Query((CriteriaDefinition)Criteria.where((String)"teamContainerRelations").elemMatch(Criteria.where((String)"teamId").in(new Object[]{item})).and("tenant").is((Object)tenant).and("artRelationMap." + releaseTrainId + ".backlogLevel").is((Object)0));
                    List backlogItemList = this.mongoTemplate.find(query, BacklogItem.class);
                    Team selectedTeam = (Team)this.teamRepository.findOne((Serializable)((Object)item));
                    HashMap statusItemMap = new HashMap();
                    HashMap categoryStatusMap = new HashMap();
                    for (Object backlogItem2 : backlogItemList) {
                        HashSet<String> itemIdSet;
                        String itemId = backlogItem2.getId();
                        Status statusObject = backlogItem2.getStatus();
                        if (statusObject == null || statusObject.getCategory().isEmpty()) continue;
                        String statusCategory = statusObject.getCategory();
                        if (statusItemMap.containsKey(statusCategory)) {
                            ((Set)statusItemMap.get(statusCategory)).add(itemId);
                        } else {
                            itemIdSet = new HashSet<String>();
                            itemIdSet.add(itemId);
                            statusItemMap.put(statusCategory, itemIdSet);
                        }
                        if (categoryStatusMap.containsKey(statusCategory)) {
                            ((Set)categoryStatusMap.get(statusCategory)).add(statusObject.getId());
                            continue;
                        }
                        itemIdSet = new HashSet();
                        itemIdSet.add(statusObject.getId());
                        categoryStatusMap.put(statusCategory, itemIdSet);
                    }
                    ArrayList<String> statusIds = new ArrayList<String>();
                    backlogItem2 = statusItemMap.keySet().iterator();
                    while (backlogItem2.hasNext()) {
                        String statusCategory = (String)backlogItem2.next();
                        statusIds.add(statusCategory);
                    }
                    ArrayList itemsList = new ArrayList();
                    HashMap<String, Object> itemMap = new HashMap<String, Object>();
                    Iterator iterator = statusIds.iterator();
                    while (iterator.hasNext()) {
                        String status;
                        String statusCategory = status = (String)iterator.next();
                        Set itemIds = statusItemMap.getOrDefault(statusCategory, new HashSet());
                        Set statusIdsList = categoryStatusMap.getOrDefault(statusCategory, new HashSet());
                        HashMap<String, Object> itemInfo = new HashMap<String, Object>();
                        itemInfo.put("title", statusCategory);
                        itemInfo.put("count", itemIds.size());
                        itemInfo.put("statusIdsList", statusIdsList);
                        itemsList.add(itemInfo);
                    }
                    itemMap.put("statusList", itemsList);
                    itemMap.put("title", selectedTeam.getTitle());
                    itemMap.put("id", selectedTeam.getId());
                    itemsFinalList.add(itemMap);
                }
            }
            HashMap<String, Object> finalMap = new HashMap<String, Object>();
            finalMap.put("itemsList", itemsFinalList);
            return finalMap;
        }
        catch (Exception e) {
            LOGGER.error("Error occured in groupByItems()" + StringUtils.getTraceString((Throwable)e));
            return Collections.emptyMap();
        }
    }

    public Map<String, Object> getDashboardWidgets(String dashboardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Dashboard db = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
            Date updatedOn = db.getUpdatedOn();
            result.put("widgets", db.getWidgets());
            if (db.getUpdatedOn() != null) {
                result.put("dashboardDate", db.getUpdatedOn());
            } else {
                result.put("dashboardDate", db.getCreatedOn());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDashboardWidgets()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getDashboardWidgetsMap(String dashboardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardId));
            query.fields().include("widgets");
            query.fields().include("createdOn");
            query.fields().include("updatedOn");
            query.fields().include("name");
            query.fields().include("description");
            query.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(query, Dashboard.class);
            ArrayList<Widget> widgetMap = new ArrayList<Widget>();
            HashMap<String, Map> allGroupBys = new HashMap<String, Map>();
            if (dashboard != null) {
                if (dashboard.getUpdatedOn() != null) {
                    result.put("dashboardDate", dashboard.getUpdatedOn());
                } else {
                    result.put("dashboardDate", dashboard.getCreatedOn());
                }
                if (dashboard.getWidgets() != null) {
                    for (Widget currentWidget : dashboard.getWidgets()) {
                        Query queryForWidgetMockup = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(currentWidget.getId())));
                        queryForWidgetMockup.fields().include("name");
                        queryForWidgetMockup.fields().include("columns");
                        queryForWidgetMockup.fields().include("rows");
                        queryForWidgetMockup.fields().include("posX");
                        queryForWidgetMockup.fields().include("posY");
                        queryForWidgetMockup.fields().include("allGroupBys");
                        queryForWidgetMockup.fields().include("state");
                        queryForWidgetMockup.fields().include("type");
                        queryForWidgetMockup.fields().include("graphCriteria.graphTypeOptionTitle");
                        queryForWidgetMockup.fields().include("graphCriteria.optionTypeTitle");
                        queryForWidgetMockup.fields().include("graphCriteria.graphTypeTitle");
                        Widget dbWidget = (Widget)this.mongoTemplate.findOne(queryForWidgetMockup, Widget.class);
                        allGroupBys.put(currentWidget.getId(), dbWidget.getAllGroupBys());
                        widgetMap.add(dbWidget);
                    }
                }
            }
            query.fields().include("workSpaceKeys");
            query.fields().include("solutionBoardIds");
            query.fields().include("sharedWithAll");
            Dashboard dashboard2 = (Dashboard)this.mongoTemplate.findOne(query, Dashboard.class);
            result.put("dashboard", dashboard2);
            result.put("widgetMap", widgetMap);
            result.put("allgroupsMap", allGroupBys);
            result.put("dashboardName", dashboard.getName());
            result.put("dashboardDescription", dashboard.getDescription());
            result.put("dashboardId", dashboard.getId());
            result.put("globalColorsMap", dashboard.getGlobalColorsMap());
        }
        catch (Exception e) {
            LOGGER.error("Error processing getDashboardWidgetsMap()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public List<Widget> updateBacklogItemsStatusWidgetCriteria(List<Widget> widgets) {
        ArrayList<Widget> updatedWidgets = new ArrayList<Widget>();
        try {
            List backlogItemList = new ArrayList();
            for (Widget widget : widgets) {
                GraphCriteria graphCriteria = widget.getGraphCriteria();
                Iterator iterator = graphCriteria.getItemList().iterator();
                while (iterator.hasNext()) {
                    GraphGroup graphGroup = (GraphGroup)iterator.next();
                    if (widget.getType().equals("status")) {
                        backlogItemList = this.getBackLogItemsofStatusId(graphGroup.getId(), widget.getReleaseTrainId());
                    } else if (widget.getType().equals("teams")) {
                        backlogItemList = this.getBackLogItemsofTeamId(graphGroup.getId(), widget.getReleaseTrainId());
                    }
                    if (backlogItemList.size() > 0) {
                        graphGroup.setCount(backlogItemList.size());
                        continue;
                    }
                    iterator.remove();
                }
                updatedWidgets.add(widget);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateBacklogItemsStatusWidgetCriteria()" + StringUtils.getTraceString((Throwable)e));
        }
        return updatedWidgets;
    }

    public Widget updateSingleBacklogItemsStatusWidgetCriteria(String widgetId, String dashboardKey) {
        Widget widget = new Widget();
        try {
            List backlogItemList = new ArrayList();
            widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(query, Dashboard.class);
            if (PropertyValidator.isValid((Object)widget) && !widget.getType().equals("cfd")) {
                if (widget.getType().equals("teams") && widget.getSelectedAdditionalGraphOption().equals("colBreakDown") && widget.getSelectedAdditionalFilterCriteria().equals("statusCategory")) {
                    Map map = this.groupByItems("statusCategory", "teams", widget.getGraphCriteria().getSelectedItems(), widget.getReleaseTrainId());
                    ArrayList graphAdditionalCriteriaList = new ArrayList();
                    List itemList = (List)map.get("itemsList");
                    for (int i = 0; i < itemList.size(); ++i) {
                        HashMap graphAdditionalCriteria = new HashMap();
                        graphAdditionalCriteria.put("title", ((Map)itemList.get(i)).get("title"));
                        graphAdditionalCriteria.put("id", ((Map)itemList.get(i)).get("id"));
                        graphAdditionalCriteria.put("itemList", ((Map)itemList.get(i)).get("statusList"));
                        graphAdditionalCriteriaList.add(graphAdditionalCriteria);
                    }
                    widget.setGraphAdditionalCriteria(graphAdditionalCriteriaList);
                } else {
                    GraphCriteria graphCriteria = widget.getGraphCriteria();
                    Iterator iterator = graphCriteria.getItemList().iterator();
                    while (iterator.hasNext()) {
                        GraphGroup graphGroup = (GraphGroup)iterator.next();
                        if (widget.getType().equals("status")) {
                            backlogItemList = this.getBackLogItemsofStatusId(graphGroup.getId(), widget.getReleaseTrainId());
                        } else if (widget.getType().equals("teams") && widget.getGraphAdditionalCriteria() == null) {
                            backlogItemList = this.getBackLogItemsofTeamId(graphGroup.getId(), widget.getReleaseTrainId());
                        }
                        if (!backlogItemList.isEmpty()) {
                            graphGroup.setCount(backlogItemList.size());
                            continue;
                        }
                        iterator.remove();
                    }
                }
            }
            if (dashboard.getWidgets().contains(widget)) {
                this.widgetRepository.save((Object)widget);
                this.updateDashboardWidget(dashboard, widget);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateSingleBacklogItemsStatusWidgetCriteria()" + StringUtils.getTraceString((Throwable)e));
        }
        return widget;
    }

    public Map<String, Object> updateSingleCSItemsWidgetCriteria(String widgetId, String dashboardId) {
        Map<String, Object> objectData = new HashMap<String, Object>();
        try {
            Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
            try {
                if (PropertyValidator.isValid((Object)widget) && widget.getGraphCriteria().getOptionTypeTitle().equals("Completion by Teams")) {
                    HashMap<String, Object> completedStories = new HashMap<String, Object>();
                    String sessionBoardId = null;
                    List issueType = null;
                    BoardSprintCriteria selectedBoardSprint = null;
                    List selectedStatusIds = null;
                    if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSessionBoardId())) {
                        sessionBoardId = widget.getGraphCriteria().getSessionBoardId();
                    }
                    if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedIssueType())) {
                        issueType = widget.getGraphCriteria().getSelectedIssueType();
                    }
                    if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedBoardSprint())) {
                        selectedBoardSprint = widget.getGraphCriteria().getSelectedBoardSprint();
                    }
                    if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems())) {
                        selectedStatusIds = widget.getGraphCriteria().getSelectedItems();
                    }
                    if (sessionBoardId != null) {
                        completedStories.put("sessionBoardId", sessionBoardId);
                    }
                    if (issueType != null) {
                        completedStories.put("issueType", issueType);
                    }
                    if (selectedBoardSprint != null) {
                        completedStories.put("selectedBoardSprint", selectedBoardSprint);
                    }
                    if (selectedStatusIds != null) {
                        completedStories.put("selectedStatusIds", selectedStatusIds);
                    }
                    objectData = this.createDataForCompletedStories(completedStories);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateSingleCFDItemsWidgetCriteria()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public Map<String, Object> updateSingleCFDItemsWidgetCriteria(String widgetId, String dashboardId) {
        Map<String, Object> objectData = new HashMap<String, Object>();
        try {
            Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardId));
            queryForDashboard.fields().include("_id");
            queryForDashboard.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            if (PropertyValidator.isValid((Object)widget.getGraphCriteria()) && !PropertyValidator.isValid((Object)widget.getGraphCriteria().getItemTagsMetaMap()) && PropertyValidator.isValid((Object)widget.getGraphCriteria().getItemTags()) && !widget.getGraphCriteria().getItemTags().isEmpty()) {
                widget.getGraphCriteria().setItemTags(new HashMap());
            }
            try {
                if (PropertyValidator.isValid((Object)widget)) {
                    if (widget.getGraphCriteria().getOptionTypeTitle().equals("By Status Category")) {
                        TimeSeriesDTO.Interval interval = TimeSeriesDTO.Interval.fromValue((String)"Day");
                        Object teamsObj = widget.getGraphCriteria().getOptionalTeams();
                        Object sprintsObj = widget.getGraphCriteria().getOptionalSprints();
                        Optional<Object> optionalTeams = Optional.empty();
                        Optional<Object> optionalSprints = Optional.empty();
                        if (teamsObj instanceof ArrayList) {
                            optionalTeams = Optional.of((ArrayList)teamsObj);
                        }
                        if (sprintsObj instanceof ArrayList) {
                            optionalSprints = Optional.of((ArrayList)sprintsObj);
                        }
                        Map itemData = this.timeSeriesRepository.getItemsForTheGivingDurition(widget.getGraphCriteria().getStartDate(), widget.getGraphCriteria().getEndDate(), widget.getGraphCriteria().getSessionBoardId(), widget.getGraphCriteria().getSelectedBoardTenant(), interval, widget.getGraphCriteria().getSelectedItems(), optionalTeams, optionalSprints);
                        List intervals = this.createIntervalsBetweenDatesForType(widget.getGraphCriteria().getStartDate(), widget.getGraphCriteria().getEndDate(), interval);
                        objectData.put("itemData", itemData);
                        objectData.put("intervals", intervals);
                    } else {
                        if (widget.getGraphCriteria().getOptionTypeTitle().equals("Time in Status") || widget.getGraphCriteria().getOptionTypeTitle().equals("Lead Time Graph")) {
                            String tenant = "";
                            String interval = "5";
                            HashMap itemData = new HashMap();
                            if (widget.getGraphCriteria().getIntervals() != null) {
                                interval = widget.getGraphCriteria().getIntervals();
                            }
                            String sessionBoardIds = widget.getGraphCriteria().getSessionBoardId();
                            if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedBoardTenant())) {
                                tenant = widget.getGraphCriteria().getSelectedBoardTenant();
                            }
                            List selectedIssueType = new ArrayList();
                            if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedIssueType())) {
                                selectedIssueType = widget.getGraphCriteria().getSelectedIssueType();
                            }
                            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
                            query.fields().include("session");
                            query.fields().include("teams");
                            query.fields().include("creationDate");
                            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
                            this.fillBoardStatuses(sessionBoard);
                            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
                            String boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                            if (widget.getGraphCriteria().getRadioButtonSelection().equals("status") || widget.getGraphCriteria().getRadioButtonSelection().equals("statusCategory")) {
                                if (!widget.getGraphCriteria().getSelectedItems().isEmpty()) {
                                    List<String> startStatusIdList = Arrays.asList(((String)widget.getGraphCriteria().getSelectedItems().get(0)).split(","));
                                    List<String> endStatusIdList = Arrays.asList(((String)widget.getGraphCriteria().getSelectedItems().get(1)).split(","));
                                    objectData = this.timeSeriesRepository.getItemsBasedOnStartEndStatus(sessionBoardIds, tenant, startStatusIdList, endStatusIdList, interval, statusList, selectedIssueType, boardItemsFilter, widget.getGraphCriteria().getRadioButtonSelection(), widget.getGraphCriteria().getItemTags());
                                }
                            } else if (widget.getGraphCriteria().getRadioButtonSelection().equals("creationDate") && PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems())) {
                                List<String> endStatusIdList = Arrays.asList(((String)widget.getGraphCriteria().getSelectedItems().get(0)).split(","));
                                objectData = this.timeSeriesRepository.getItemsBasedOnCreationDate(sessionBoardIds, tenant, interval, statusList, selectedIssueType, boardItemsFilter, endStatusIdList, widget.getGraphCriteria().getItemTags());
                            }
                            return objectData;
                        }
                        if (widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Time Graph") || widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Efficiency Graph") || widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Velocity Graph") || widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Load Graph") || widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Distribution Graph")) {
                            String tenant = "";
                            List selectedIssueType = widget.getGraphCriteria().getSelectedIssueType();
                            String radioTypeSelection = widget.getGraphCriteria().getRadioButtonSelection();
                            String interval = null;
                            String groupBy = null;
                            Date startDate = new Date();
                            Date endDate = new Date();
                            if (widget.getGraphCriteria().getIntervals() != null) {
                                interval = widget.getGraphCriteria().getIntervals();
                            }
                            String sessionBoardIds = widget.getGraphCriteria().getSessionBoardId();
                            if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedBoardTenant())) {
                                tenant = widget.getGraphCriteria().getSelectedBoardTenant();
                            }
                            if (widget.getGraphCriteria().getGroupBy() != null) {
                                groupBy = widget.getGraphCriteria().getGroupBy();
                            }
                            String boardItemsFilter = "";
                            if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getBoardItemsFilter())) {
                                boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                            }
                            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
                            query.fields().include("session");
                            query.fields().include("teams");
                            query.fields().include("creationDate");
                            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
                            this.fillBoardStatuses(sessionBoard);
                            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Time Graph")) {
                                Map itemData = new HashMap();
                                if ((radioTypeSelection.equals("status") || radioTypeSelection.equals("statusCategory")) && PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems()) && widget.getGraphCriteria().getSelectedItems().size() > 1) {
                                    String startStatusId = (String)widget.getGraphCriteria().getSelectedItems().get(0);
                                    String endStatusId = (String)widget.getGraphCriteria().getSelectedItems().get(1);
                                    ArrayList<String> startStatusIdList = new ArrayList<String>(Arrays.asList(startStatusId.split(",")));
                                    ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                                    itemData = this.timeSeriesRepository.getItemsForFlowLine(sessionBoard, sessionBoardIds, tenant, startStatusIdList, endStatusIdList, interval, statusList, selectedIssueType, groupBy, radioTypeSelection, boardItemsFilter, dashboard, widget.getGraphCriteria().getItemTags());
                                }
                                objectData = itemData;
                                return objectData;
                            }
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Efficiency Graph")) {
                                Map itemData = new HashMap();
                                boolean creationDateEnabled = widget.getGraphCriteria().isToggleCreationDate();
                                boardItemsFilter = "";
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getBoardItemsFilter())) {
                                    boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                                }
                                if (!creationDateEnabled && PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems()) && widget.getGraphCriteria().getSelectedItems().size() > 1) {
                                    String startStatusId = (String)widget.getGraphCriteria().getSelectedItems().get(0);
                                    String endStatusId = (String)widget.getGraphCriteria().getSelectedItems().get(1);
                                    String activeStatusId = widget.getGraphCriteria().getActiveTimeStatuses();
                                    ArrayList<String> startStatusIdList = new ArrayList<String>(Arrays.asList(startStatusId.split(",")));
                                    ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                                    ArrayList<String> activeStatusIdList = new ArrayList<String>(Arrays.asList(activeStatusId.split(",")));
                                    itemData = this.timeSeriesRepository.getItemsForFlowEfficiency(sessionBoard, sessionBoardIds, tenant, startStatusIdList, endStatusIdList, activeStatusIdList, statusList, interval, selectedIssueType, groupBy, creationDateEnabled, boardItemsFilter, dashboard, widget.getGraphCriteria().getItemTags());
                                } else if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems())) {
                                    String activeStatusId = widget.getGraphCriteria().getActiveTimeStatuses();
                                    ArrayList startStatusIdList = new ArrayList();
                                    String endStatusId = (String)widget.getGraphCriteria().getSelectedItems().get(0);
                                    ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                                    ArrayList<String> activeStatusIdList = new ArrayList<String>(Arrays.asList(activeStatusId.split(",")));
                                    itemData = this.timeSeriesRepository.getItemsForFlowEfficiency(sessionBoard, sessionBoardIds, tenant, startStatusIdList, endStatusIdList, activeStatusIdList, statusList, interval, selectedIssueType, groupBy, creationDateEnabled, boardItemsFilter, dashboard, widget.getGraphCriteria().getItemTags());
                                }
                                objectData = itemData;
                                return objectData;
                            }
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Velocity Graph")) {
                                if (sessionBoardIds != null) {
                                    Map result = this.getStartEndDateofPI(sessionBoardIds);
                                    startDate = (Date)result.get("startDate");
                                    endDate = (Date)result.get("endDate");
                                }
                                Map itemData = new HashMap();
                                List activeStatusId = new ArrayList();
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems())) {
                                    activeStatusId = widget.getGraphCriteria().getSelectedItems();
                                }
                                ArrayList<String> activeStatusIdList = new ArrayList<String>();
                                for (String str : activeStatusId) {
                                    String[] ids;
                                    for (String id : ids = str.split(",")) {
                                        activeStatusIdList.add(id);
                                    }
                                }
                                boardItemsFilter = "";
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getBoardItemsFilter())) {
                                    boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                                }
                                itemData = this.timeSeriesRepository.getItemsForFlowVelocity(sessionBoard, sessionBoardIds, tenant, activeStatusIdList, statusList, interval, selectedIssueType, groupBy, boardItemsFilter, startDate, endDate, dashboard, widget.getGraphCriteria().getItemTags(), widget.getGraphCriteria().getRadioButtonSelection());
                                objectData = itemData;
                                return objectData;
                            }
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Load Graph")) {
                                boardItemsFilter = "";
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getBoardItemsFilter())) {
                                    boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getStartDate()) && PropertyValidator.isValid((Object)widget.getGraphCriteria().getEndDate()) && PropertyValidator.isValid((Object)interval) && interval.equals("days")) {
                                    startDate = widget.getGraphCriteria().getStartDate();
                                    endDate = widget.getGraphCriteria().getEndDate();
                                }
                                Map itemData = new HashMap();
                                ArrayList<String> individualActiveIds = new ArrayList<String>();
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getActiveStatuses())) {
                                    for (Object activeStatusIds : widget.getGraphCriteria().getActiveStatuses()) {
                                        String[] idsArray;
                                        for (String id : idsArray = ((String)activeStatusIds).split(",")) {
                                            individualActiveIds.add(id);
                                        }
                                    }
                                }
                                ArrayList<String> individualWaitingIds = new ArrayList<String>();
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedInProgressStatus())) {
                                    for (String waitingStatusIds : widget.getGraphCriteria().getSelectedInProgressStatus()) {
                                        String[] idsArray;
                                        for (String id : idsArray = waitingStatusIds.split(",")) {
                                            individualWaitingIds.add(id);
                                        }
                                    }
                                }
                                String waitingStatusIds = (String)widget.getGraphCriteria().getSelectedInProgressStatus().get(0);
                                itemData = this.timeSeriesRepository.getFlowLoad(sessionBoard, sessionBoardIds, tenant, individualActiveIds, individualWaitingIds, statusList, interval, selectedIssueType, groupBy, startDate, endDate, boardItemsFilter, dashboard, widget.getGraphCriteria().getItemTags(), radioTypeSelection);
                                objectData = itemData;
                                return objectData;
                            }
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Flow Distribution Graph")) {
                                String yAxis = null;
                                boardItemsFilter = "";
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getBoardItemsFilter())) {
                                    boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                                }
                                Map issueTypeMap = new HashMap();
                                if (widget.getGraphCriteria().getyAxis() != null) {
                                    yAxis = widget.getGraphCriteria().getyAxis();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getStartDate()) && PropertyValidator.isValid((Object)widget.getGraphCriteria().getEndDate()) && PropertyValidator.isValid((Object)interval) && interval.equals("days")) {
                                    startDate = widget.getGraphCriteria().getStartDate();
                                    endDate = widget.getGraphCriteria().getEndDate();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getIssueTypeMap())) {
                                    issueTypeMap = widget.getGraphCriteria().getIssueTypeMap();
                                }
                                Map itemData = new HashMap();
                                String activeStatusIds = (String)widget.getGraphCriteria().getSelectedItems().get(0);
                                String[] idsArray = activeStatusIds.split(",");
                                ArrayList<String> individualActiveIds = new ArrayList<String>();
                                for (String id : idsArray) {
                                    individualActiveIds.add(id);
                                }
                                itemData = this.timeSeriesRepository.getFlowDistribution(sessionBoard, sessionBoardIds, tenant, individualActiveIds, statusList, interval, selectedIssueType, groupBy, startDate, endDate, yAxis, issueTypeMap, boardItemsFilter, dashboard, widget.getGraphCriteria().getItemTags(), radioTypeSelection);
                                objectData = itemData;
                                return objectData;
                            }
                        } else {
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Cumulative Flow Diagram")) {
                                String[] activeids;
                                String sessionBoardIds = "";
                                Date startDate = new Date();
                                Date endDate = new Date();
                                List selectedStatusIds = new ArrayList();
                                String xAxis = "";
                                String advanceCriteria = "";
                                List selectedAdvanceCriteria = new ArrayList();
                                List selectedIssueType = new ArrayList();
                                String selectedActiveStatus = "";
                                List selectedWaitingStatus = new ArrayList();
                                List selectedCompletedStatus = new ArrayList();
                                Boolean toggleAvgLeadTime = false;
                                Boolean toggleAvgCycleTime = false;
                                Boolean toggleAvgWIPTime = false;
                                Boolean toggleAvgArrivalTime = false;
                                Boolean toggleAvgThroughputTime = false;
                                Boolean toggleAdvanceCriteria = false;
                                Boolean toggleAdvanceCalculation = false;
                                SessionBoard sessionBoard = new SessionBoard();
                                Map issueTypeMap = new HashMap();
                                String tenant = "";
                                String radioButtonSelection = "";
                                String boardItemsFilter = "";
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getBoardItemsFilter())) {
                                    boardItemsFilter = widget.getGraphCriteria().getBoardItemsFilter();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAvgLeadTime())) {
                                    toggleAvgLeadTime = widget.getGraphCriteria().getToggleAvgLeadTime();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAvgCycleTime())) {
                                    toggleAvgCycleTime = widget.getGraphCriteria().getToggleAvgCycleTime();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAvgWIPTime())) {
                                    toggleAvgWIPTime = widget.getGraphCriteria().getToggleAvgWIPTime();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAvgLeadTime())) {
                                    toggleAvgArrivalTime = widget.getGraphCriteria().getToggleAvgLeadTime();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAvgThroughputTime())) {
                                    toggleAvgThroughputTime = widget.getGraphCriteria().getToggleAvgThroughputTime();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAdvanceCriteria())) {
                                    toggleAdvanceCriteria = widget.getGraphCriteria().getToggleAdvanceCriteria();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getToggleAdvanceCalculation())) {
                                    toggleAdvanceCalculation = widget.getGraphCriteria().getToggleAdvanceCalculation();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSessionBoardId())) {
                                    sessionBoardIds = widget.getGraphCriteria().getSessionBoardId();
                                    Query sessionBoardQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
                                    sessionBoard = (SessionBoard)this.mongoTemplate.findOne(sessionBoardQuery, SessionBoard.class);
                                    this.fillBoardStatuses(sessionBoard);
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedIssueType())) {
                                    selectedIssueType = widget.getGraphCriteria().getSelectedIssueType();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedActiveStatus())) {
                                    selectedActiveStatus = widget.getGraphCriteria().getSelectedActiveStatus();
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedInProgressStatus())) {
                                    selectedWaitingStatus = widget.getGraphCriteria().getSelectedInProgressStatus();
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedCompletedStatus())) {
                                    selectedCompletedStatus = widget.getGraphCriteria().getSelectedCompletedStatus();
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems())) {
                                    selectedStatusIds = widget.getGraphCriteria().getSelectedItems();
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedAdvanceCriteria())) {
                                    selectedAdvanceCriteria = widget.getGraphCriteria().getSelectedAdvanceCriteria();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getAdvanceCriteria())) {
                                    advanceCriteria = widget.getGraphCriteria().getAdvanceCriteria();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getIntervals())) {
                                    xAxis = widget.getGraphCriteria().getIntervals();
                                }
                                if (sessionBoardIds != null) {
                                    Map result = this.getStartEndDateofPI(sessionBoardIds);
                                    startDate = (Date)result.get("startDate");
                                    endDate = (Date)result.get("endDate");
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedBoardTenant())) {
                                    tenant = widget.getGraphCriteria().getSelectedBoardTenant();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getIssueTypeMap())) {
                                    issueTypeMap = widget.getGraphCriteria().getIssueTypeMap();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getRadioButtonSelection())) {
                                    radioButtonSelection = widget.getGraphCriteria().getRadioButtonSelection();
                                }
                                ArrayList<String> individualActiveStatusIds = new ArrayList<String>();
                                for (String id : activeids = selectedActiveStatus.split(",")) {
                                    individualActiveStatusIds.add(id);
                                }
                                ArrayList<String> individualWaitingStatusIds = new ArrayList<String>();
                                for (String str : selectedWaitingStatus) {
                                    String[] ids;
                                    for (String id : ids = str.split(",")) {
                                        individualWaitingStatusIds.add(id);
                                    }
                                }
                                ArrayList<String> individualCompletedStatusIds = new ArrayList<String>();
                                for (String str : selectedCompletedStatus) {
                                    String[] ids;
                                    for (String id : ids = str.split(",")) {
                                        individualCompletedStatusIds.add(id);
                                    }
                                }
                                ArrayList<String> individualSelectedStatusIds = new ArrayList<String>();
                                for (String str : selectedStatusIds) {
                                    String[] ids;
                                    for (String id : ids = str.split(",")) {
                                        individualSelectedStatusIds.add(id);
                                    }
                                }
                                objectData = this.timeSeriesRepository.getCFDItems(tenant, individualSelectedStatusIds, individualActiveStatusIds, individualWaitingStatusIds, individualCompletedStatusIds, xAxis, startDate, endDate, sessionBoard, advanceCriteria, selectedAdvanceCriteria, toggleAvgArrivalTime, toggleAvgCycleTime, toggleAvgLeadTime, toggleAvgThroughputTime, toggleAdvanceCalculation, toggleAdvanceCriteria, toggleAvgWIPTime, selectedIssueType, issueTypeMap, radioButtonSelection, boardItemsFilter, dashboard, widget.getGraphCriteria().getItemTags());
                                return objectData;
                            }
                            if (widget.getGraphCriteria().getOptionTypeTitle().equals("Completion by Teams")) {
                                HashMap<String, Object> completedStories = new HashMap<String, Object>();
                                String sessionBoardId = null;
                                List issueType = null;
                                BoardSprintCriteria selectedBoardSprint = null;
                                List selectedStatusIds = null;
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSessionBoardId())) {
                                    sessionBoardId = widget.getGraphCriteria().getSessionBoardId();
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedIssueType())) {
                                    issueType = widget.getGraphCriteria().getSelectedIssueType();
                                }
                                if (PropertyValidator.isValid((Object)widget.getGraphCriteria().getSelectedBoardSprint())) {
                                    selectedBoardSprint = widget.getGraphCriteria().getSelectedBoardSprint();
                                }
                                if (PropertyValidator.isValid((Collection)widget.getGraphCriteria().getSelectedItems())) {
                                    selectedStatusIds = widget.getGraphCriteria().getSelectedItems();
                                }
                                if (sessionBoardId != null) {
                                    completedStories.put("sessionBoardId", sessionBoardId);
                                }
                                if (issueType != null) {
                                    completedStories.put("issueType", issueType);
                                }
                                if (selectedBoardSprint != null) {
                                    completedStories.put("selectedBoardSprint", selectedBoardSprint);
                                }
                                if (selectedStatusIds != null) {
                                    completedStories.put("selectedStatusIds", selectedStatusIds);
                                }
                                objectData = this.createDataForCompletedStories(completedStories);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateSingleCFDItemsWidgetCriteria()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public void updateDashboardWidget(Dashboard dashboard, Widget widget) {
        try {
            for (int i = 0; i < dashboard.getWidgets().size(); ++i) {
                if (!((Widget)dashboard.getWidgets().get(i)).getId().equals(widget.getId())) continue;
                dashboard.getWidgets().set(i, widget);
                break;
            }
            this.dashboardRepository.save((Object)dashboard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, Object> updateDashboardWidgets(String dashboardId, List<Widget> widgets) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)dashboardId) && PropertyValidator.isValid(widgets)) {
                Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
                dashboard.setWidgets(widgets);
                for (Widget widget : widgets) {
                    if (!PropertyValidator.isValid((Object)widget.getId())) continue;
                    this.widgetRepository.save((Object)widget);
                }
                result.put("dashboard", this.dashboardRepository.save((Object)dashboard));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing updateDashboardWidgets()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> getStartEndDateofPI(String boardId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            BasicDBList basicDBList;
            List sessionBoard = this.getSessionBoardDBObject(boardId);
            if (sessionBoard.size() > 0 && (basicDBList = (BasicDBList)((DBObject)sessionBoard.get(0)).get("containers")).size() > 0) {
                List formattedIds = basicDBList.stream().map(id -> {
                    if (id instanceof DBRef) {
                        return ((DBRef)id).getId();
                    }
                    return DBUtils.isHexString((String)id.toString()) ? new ObjectId(id.toString()) : id;
                }).collect(Collectors.toList());
                Query queryForAllContainers = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(formattedIds));
                queryForAllContainers.with(new Sort(Sort.Direction.ASC, new String[]{"startDate"}));
                queryForAllContainers.fields().include("startDate");
                queryForAllContainers.fields().include("endDate");
                List allContainers = this.mongoTemplate.find(queryForAllContainers, Container.class);
                Date earliestDate = null;
                Date furthestDate = null;
                for (Container container : allContainers) {
                    Date startDate = container.getStartDate();
                    Date endDate = container.getEndDate();
                    if (startDate != null && (earliestDate == null || startDate.before(earliestDate))) {
                        earliestDate = startDate;
                    }
                    if (endDate == null || furthestDate != null && !endDate.after(furthestDate)) continue;
                    furthestDate = endDate;
                }
                result.put("startDate", earliestDate);
                result.put("endDate", furthestDate);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing getStartEndDateofPI()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    private void fetchJiraIssueTypes(String almAccountId, List<String> projectKeys, HashMap<String, Object> responseJson) {
        try {
            if (PropertyValidator.isValid(projectKeys)) {
                List jiraProjectIssueTypes = this.jiraProjectIssueTypesRepository.findByAlmAccountIdAndJiraProjectKeyIn(almAccountId, projectKeys);
                for (JiraProjectIssueTypes jpType : jiraProjectIssueTypes) {
                    if (!PropertyValidator.isValid((Object)jpType.getIssueTypesReference())) continue;
                    jpType.setIssueTypes(MongoSyncUtils.retrieveData((String)jpType.getIssueTypesReference(), (AppConfig.MongoConfig)this.mongoConfig));
                }
                responseJson.put("jiraProjectIssueTypes", jiraProjectIssueTypes);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchJiraIssueTypes()" + StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, Object> fetchALMTFSMeta(SessionBoard sessionBoard) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            LOGGER.debug("1. fetch board meta");
            Gson gson = new Gson();
            ArrayList<String> projectKeys = null;
            String almId = null;
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                HashMap meta = KendisUtils.getTfsMeta((SessionBoard)sessionBoard, (TFSProjectRepository)this.tfsProjectRepository, (WorkFlowItemTypeRepository)this.workFlowItemTypeRepository, (WorkFlowRepository)this.workFlowRepository, (StatusRepository)this.statusRepository, (TFSservice)this.tfSservice);
                responseJson.putAll(meta);
                List tfsProjects = (List)meta.get("tfsProject");
                if (PropertyValidator.isValid((Collection)tfsProjects)) {
                    for (TFSProject project : tfsProjects) {
                        responseJson.put("tfsProjectItemTypes_" + project.getId(), gson.toJson((Object)project.getItemTypes()));
                        project.setItemTypes(null);
                    }
                }
            } else if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                almId = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount().getId();
                projectKeys = new ArrayList<String>();
                responseJson.put("jiraLinksTypes", this.almSyncService.retrieveJiraIssueLinkTypesList(((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getAlmAccount(), false));
                List tMapping = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getTeamMappings();
                List bMapping = ((AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0)).getFeatureMappings();
                if (PropertyValidator.isValid((Collection)tMapping)) {
                    for (BacklogMapping tm : tMapping) {
                        if (!PropertyValidator.isValid((Collection)tm.getProjectKeys())) continue;
                        projectKeys.addAll(tm.getProjectKeys());
                    }
                }
                if (PropertyValidator.isValid((Collection)bMapping)) {
                    for (BacklogMapping bm : bMapping) {
                        projectKeys.add(bm.getProjectKey());
                    }
                }
                AlmAccount almAccount = AlmUtils.getALMAcount((String)almId, (AlmAccountRepository)this.almAccountRepository);
                responseJson.put("jiraFields", this.almSyncService.retrieveJiraFieldsJSON(almAccount, false));
                this.fetchJiraIssueTypes(almId, projectKeys, responseJson);
            }
            List allIssueTypes = this.issueTypeRepository.findAllByOrderBySequenceAsc();
            responseJson.put("allIssueTypes", allIssueTypes);
            responseJson.put("sessionBoardId", sessionBoard.getId());
            responseJson.put("sessionBoard", sessionBoard);
        }
        catch (Exception e) {
            LOGGER.error("Error occured in fetchALMTFSMeta()" + StringUtils.getTraceString((Throwable)e));
        }
        return responseJson;
    }

    public List<Map<String, Object>> fetchItemDetails(Map<String, Map<String, Object>> requestMap) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            DecimalFormat df = new DecimalFormat("#.#");
            boolean flag = false;
            HashSet<ObjectId> itemIds = new HashSet<ObjectId>();
            for (Map.Entry<String, Map<String, Object>> entry : requestMap.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                String[] parts = key.split("[_\\:]");
                String keyType = parts[0];
                if (keyType.equals("itemId")) {
                    itemIds.add(new ObjectId(parts[1]));
                    continue;
                }
                itemIds.add(new ObjectId(parts[1]));
            }
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
            Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"id").in(itemIds));
            itemQuery.fields().include("teamContainers").include("tfsItemTypeIcon").include("tfsItemType").include("tfsId").include("jiraIssueTypeId").include("jiraProjectKey").include("jiraId").include("jiraKey").include("title").include("jiraFieldByKey.issuetype").include("jiraFieldByKey.assignee").include("fields.issuetype").include("tfsFieldByKey").include("tfsURL").include("jiraURL").include("jiraIssueType");
            itemQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            List items = this.mongoTemplate.find(itemQuery, Item.class);
            HashSet<String> containerIds = new HashSet<String>();
            HashSet<String> teamIds = new HashSet<String>();
            for (Item item : items) {
                if (!PropertyValidator.isValid((Object)item) || item.getTeamContainers() == null) continue;
                for (TeamContainer teamContainer : item.getTeamContainers()) {
                    if (!PropertyValidator.isValid((Object)teamContainer)) continue;
                    teamIds.add(teamContainer.getTeam().getId());
                    containerIds.add(teamContainer.getContainer().getId());
                }
            }
            Query containerQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)containerIds.stream().map(id -> DBUtils.isHexString((String)id) ? new ObjectId(id) : id).collect(Collectors.toList())));
            List containers = this.mongoTemplate.find(containerQuery, Container.class);
            Map<String, Container> containersById = containers.stream().collect(Collectors.toMap(BaseEntity::getId, container -> container));
            Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)teamIds.stream().map(ObjectId::new).collect(Collectors.toList())));
            List teams = this.mongoTemplate.find(teamQuery, Team.class);
            Map<String, Team> teamsById = teams.stream().collect(Collectors.toMap(BaseEntity::getId, team -> team));
            HashSet<String> itemIdsSet = new HashSet<String>();
            for (Map.Entry<String, Map<String, Object>> entry : requestMap.entrySet()) {
                String key = entry.getKey();
                String[] stringParts = key.split("[_\\:]");
                if (stringParts.length > 0 && itemIdsSet.contains(stringParts[1]) || key == null) continue;
                Map<String, Object> valueMap = entry.getValue();
                Object value = valueMap.get("days");
                String startDate = "";
                String endDate = "";
                if (valueMap.containsKey("startDate") && valueMap.containsKey("endDate")) {
                    startDate = (String)valueMap.get("startDate");
                    endDate = (String)valueMap.get("endDate");
                }
                Double days = null;
                String status = null;
                if (value instanceof Integer) {
                    days = ((Integer)value).doubleValue();
                    days = Double.parseDouble(df.format(days));
                } else if (value instanceof Double) {
                    days = (Double)value;
                    days = Double.parseDouble(df.format(days));
                } else if (value instanceof String) {
                    status = (String)value;
                    flag = true;
                }
                List groupBys = (List)valueMap.get("groupby");
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                String[] parts = key.split("[_\\:]");
                String keyType = parts[0];
                Item item = items.stream().filter(i -> i.getId().equals(parts[1])).findFirst().orElse(null);
                if (!PropertyValidator.isValid((Object)item)) continue;
                itemMap.put("itemId", item.getId());
                if (item.isArchive()) {
                    itemMap.put("itemRemoved", true);
                } else {
                    itemMap.put("itemRemoved", false);
                }
                if (PropertyValidator.isValid((Object)item.getFields()) && PropertyValidator.isValid(item.getFields().get("issuetype"))) {
                    itemMap.put("fields", item.getFields());
                }
                if (item.getTfsId() != null) {
                    itemMap.put("id", item.getTfsId());
                    itemMap.put("tfsItemTypeIcon", item.getTfsItemTypeIcon());
                    itemMap.put("tfsItemType", item.getTfsItemType());
                    itemMap.put("key", item.getTfsId());
                    itemMap.put("itemURL", item.getTfsURL());
                    if (PropertyValidator.isValid((Object)item.getTfsFieldByKey()) && PropertyValidator.isValid(item.getTfsFieldByKey().get("AssignedTo"))) {
                        HashMap assigneeMap = new HashMap();
                        assigneeMap.put("displayName", item.getTfsFieldByKey().get("AssignedTo"));
                        itemMap.put("assignee", assigneeMap);
                    }
                }
                if (item.getJiraId() != null) {
                    itemMap.put("id", item.getJiraId());
                    itemMap.put("jiraIssueTypeId", item.getJiraIssueTypeId());
                    itemMap.put("jiraProjectKey", item.getJiraProjectKey());
                    itemMap.put("key", item.getJiraKey());
                    if (item.getJiraURL() != null) {
                        itemMap.put("itemURL", item.getJiraURL());
                    } else {
                        URL url = new URL(item.getJiraIssueType().getIconUrl());
                        String baseUrl = url.getProtocol() + "://" + url.getHost();
                        if (url.getPort() != -1) {
                            baseUrl = baseUrl + ":" + url.getPort();
                        }
                        String modifiedUrl = baseUrl + "/browse/" + item.getJiraKey();
                        itemMap.put("itemURL", modifiedUrl);
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                        itemMap.put("jiraFieldByKeyIssueType", item.getJiraFieldByKey().get("issuetype"));
                        itemMap.put("assignee", item.getJiraFieldByKey().get("assignee"));
                    }
                }
                itemMap.put("title", item.getTitle());
                itemMap.put("days", flag ? status : days);
                itemMap.put("groupBy", groupBys);
                if (!startDate.isEmpty() && !endDate.isEmpty()) {
                    itemMap.put("startDate", startDate);
                    itemMap.put("endDate", endDate);
                }
                HashMap<String, String> teamMap = new HashMap<String, String>();
                HashMap<String, String> sprintMap = new HashMap<String, String>();
                if (item.getTeamContainers() != null) {
                    for (TeamContainer teamContainer : item.getTeamContainers()) {
                        Container selectedSprint;
                        if (!PropertyValidator.isValid((Object)teamContainer)) continue;
                        Team selectedTeam = teamsById.get(teamContainer.getTeam().getId());
                        if (selectedTeam != null) {
                            teamMap.put(selectedTeam.getLabel(), selectedTeam.getTitle() + "-color:" + selectedTeam.getColor());
                        }
                        if ((selectedSprint = containersById.get(teamContainer.getContainer().getId())) == null) continue;
                        sprintMap.put(selectedSprint.getLabel(), selectedSprint.getTitle());
                    }
                    itemMap.put("teams", teamMap);
                    itemMap.put("sprints", sprintMap);
                    itemIdsSet.add(item.getId());
                }
                resultList.add(itemMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchItemDetails()" + StringUtils.getTraceString((Throwable)e));
        }
        return resultList;
    }

    public List<Map<String, Object>> fetchCFDItemDetails(Map<String, Object> requestMap) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            String almUrl = null;
            List itemIds = (List)requestMap.get("itemIds");
            String sessionBoardId = null;
            if (PropertyValidator.isValid((Object)requestMap.get("sessionBoardId"))) {
                sessionBoardId = requestMap.get("sessionBoardId").toString();
            }
            if (sessionBoardId != null) {
                TFSAlmConfigurations tfsAlmConfigurations;
                Iterator firstAlmConfiguration;
                SessionBoard sessionBoard = this.sessionBoardRepository.findSessionBoardById(sessionBoardId);
                Object object = firstAlmConfiguration = sessionBoard.getSession().getAlmConfigurations() != null && !sessionBoard.getSession().getAlmConfigurations().isEmpty() ? (AlmConfigurations)sessionBoard.getSession().getAlmConfigurations().get(0) : null;
                if (firstAlmConfiguration != null && PropertyValidator.isValid((Object)firstAlmConfiguration.getAlmAccount())) {
                    almUrl = firstAlmConfiguration.getAlmAccount().getUrl();
                }
                if (almUrl == null && (tfsAlmConfigurations = sessionBoard.getSession().getTfsAlmConfigurations()) != null && PropertyValidator.isValid((Object)tfsAlmConfigurations.getAlmAccount())) {
                    almUrl = tfsAlmConfigurations.getAlmAccount().getUrl();
                }
            }
            ArrayList<ObjectId> itemIdsList = new ArrayList<ObjectId>();
            for (String itemId : itemIds) {
                itemIdsList.add(new ObjectId(itemId));
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsList).and("archive").in(new Object[]{true, false}));
            List allItems = this.mongoTemplate.find(query, Item.class);
            for (Item item : allItems) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                if (!PropertyValidator.isValid((Object)item)) continue;
                itemMap.put("itemId", item.getId());
                if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getTitle())) {
                    itemMap.put("status", item.getStatus().getTitle());
                }
                if (PropertyValidator.isValid((Object)item.getStatus()) && PropertyValidator.isValid((Object)item.getStatus().getCategory())) {
                    itemMap.put("category", item.getStatus().getCategory());
                }
                if (PropertyValidator.isValid((Object)item.getUpdatedOn()) && PropertyValidator.isValid((Object)item.getUpdatedOn())) {
                    itemMap.put("date", item.getUpdatedOn());
                }
                if (PropertyValidator.isValid((Object)item.getStoryPoints()) && PropertyValidator.isValid((Object)item.getStoryPoints())) {
                    itemMap.put("totalEstimate", item.getStoryPoints());
                }
                if (PropertyValidator.isValid((Object)almUrl) && PropertyValidator.isValid((Object)almUrl)) {
                    itemMap.put("almUrl", almUrl);
                }
                if (PropertyValidator.isValid((Object)item.getParent())) {
                    Item parent = item.getParent();
                    if (PropertyValidator.isValid((Object)parent.getTfsId())) {
                        if (PropertyValidator.isValid((Object)parent.getTfsURL())) {
                            itemMap.put("parentItemUrl", parent.getTfsURL());
                        }
                        if (PropertyValidator.isValid((Object)parent.getTfsId())) {
                            itemMap.put("parentKey", parent.getTfsId());
                        }
                        if (PropertyValidator.isValid((Object)parent.getTfsItemTypeIcon())) {
                            itemMap.put("parentIcon", parent.getTfsItemTypeIcon());
                        }
                    } else if (PropertyValidator.isValid((Object)parent.getJiraKey())) {
                        Map issueTypeMap;
                        Object issueType;
                        if (PropertyValidator.isValid((Object)parent.getJiraKey())) {
                            itemMap.put("parentKey", parent.getJiraKey());
                        }
                        if (PropertyValidator.isValid((Object)parent.getJiraKey())) {
                            String modifiedUrl = almUrl + "/browse/" + parent.getJiraKey();
                            itemMap.put("parentItemUrl", modifiedUrl);
                        }
                        if (PropertyValidator.isValid((Object)parent.getJiraFieldByKey()) && PropertyValidator.isValid(issueType = parent.getJiraFieldByKey().get("issuetype")) && issueType instanceof Map && PropertyValidator.isValid((issueTypeMap = (Map)issueType).get("iconUrl"))) {
                            String iconUrl = (String)issueTypeMap.get("iconUrl");
                            itemMap.put("parentIcon", iconUrl);
                        }
                    }
                }
                if (PropertyValidator.isValid((Object)item.getJiraFieldByKey()) && PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                    itemMap.put("jiraFieldByKey", item.getJiraFieldByKey());
                }
                if (item.isArchive()) {
                    itemMap.put("itemRemoved", true);
                } else {
                    itemMap.put("itemRemoved", false);
                }
                if (PropertyValidator.isValid((Object)item.getFields()) && PropertyValidator.isValid(item.getFields().get("issuetype"))) {
                    itemMap.put("fields", item.getFields());
                }
                if (item.getTfsId() != null) {
                    itemMap.put("id", item.getTfsId());
                    if (item.getTfsItemTypeIcon() != null) {
                        itemMap.put("tfsItemTypeIcon", item.getTfsItemTypeIcon());
                    }
                    if (item.getTfsItemType() != null) {
                        itemMap.put("tfsItemType", item.getTfsItemType());
                    }
                    if (item.getTfsId() != null) {
                        itemMap.put("key", item.getTfsId());
                    }
                    if (item.getTfsURL() != null) {
                        itemMap.put("itemURL", item.getTfsURL());
                    }
                    if (PropertyValidator.isValid((Object)item.getTfsFieldByKey()) && PropertyValidator.isValid(item.getTfsFieldByKey().get("AssignedTo"))) {
                        HashMap assigneeMap = new HashMap();
                        assigneeMap.put("displayName", item.getTfsFieldByKey().get("AssignedTo"));
                        itemMap.put("assignee", assigneeMap);
                    }
                }
                if (item.getJiraId() != null) {
                    itemMap.put("id", item.getJiraId());
                    if (item.getJiraIssueTypeId() != null) {
                        itemMap.put("jiraIssueTypeId", item.getJiraIssueTypeId());
                    }
                    if (item.getJiraProjectKey() != null) {
                        itemMap.put("jiraProjectKey", item.getJiraProjectKey());
                    }
                    if (item.getJiraKey() != null) {
                        itemMap.put("key", item.getJiraKey());
                    }
                    if (item.getJiraURL() != null) {
                        itemMap.put("itemURL", item.getJiraURL());
                    } else {
                        URL url = new URL(item.getJiraIssueType().getIconUrl());
                        String baseUrl = url.getProtocol() + "://" + url.getHost();
                        if (url.getPort() != -1) {
                            baseUrl = baseUrl + ":" + url.getPort();
                        }
                        String modifiedUrl = baseUrl + "/browse/" + item.getJiraKey();
                        itemMap.put("itemURL", modifiedUrl);
                    }
                    if (PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                        if (PropertyValidator.isValid(item.getJiraFieldByKey().get("issuetype"))) {
                            itemMap.put("jiraFieldByKeyIssueType", item.getJiraFieldByKey().get("issuetype"));
                        }
                        if (PropertyValidator.isValid(item.getJiraFieldByKey().get("assignee"))) {
                            itemMap.put("assignee", item.getJiraFieldByKey().get("assignee"));
                        }
                    }
                }
                itemMap.put("title", item.getTitle());
                HashMap<String, String> teamMap = new HashMap<String, String>();
                HashMap<String, String> sprintMap = new HashMap<String, String>();
                if (item.getTeamContainers() != null) {
                    for (TeamContainer teamContainer : item.getTeamContainers()) {
                        if (!PropertyValidator.isValid((Object)teamContainer)) continue;
                        Query queryForTeam = new Query();
                        queryForTeam.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(teamContainer.getTeam().getId())));
                        queryForTeam.fields().include("title");
                        queryForTeam.fields().include("label");
                        queryForTeam.fields().include("color");
                        queryForTeam.fields().include("id");
                        Team selectedTeam = (Team)this.mongoTemplate.findOne(queryForTeam, Team.class);
                        if (!PropertyValidator.isValid((Object)selectedTeam)) continue;
                        teamMap.put(selectedTeam.getLabel(), selectedTeam.getTitle() + "-color:" + selectedTeam.getColor());
                        Query queryForSprint = new Query();
                        queryForSprint.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(DBUtils.isHexString((String)teamContainer.getContainer().getId()) ? new ObjectId(teamContainer.getContainer().getId()) : teamContainer.getContainer().getId()));
                        queryForSprint.fields().include("title");
                        queryForSprint.fields().include("label");
                        queryForSprint.fields().include("id");
                        Container selectedSprint = (Container)this.mongoTemplate.findOne(queryForSprint, Container.class);
                        if (!PropertyValidator.isValid(sprintMap)) continue;
                        sprintMap.put(selectedSprint.getLabel(), selectedSprint.getTitle());
                    }
                }
                itemMap.put("teams", teamMap);
                itemMap.put("sprints", sprintMap);
                result.add(itemMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchCFDItemDetails()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public List<Map<String, Object>> fetchAllItemDetails(Map<String, Object> requestMap) throws Exception {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List itemIds = (List)requestMap.get("itemIds");
        ArrayList<ObjectId> itemIdsList = new ArrayList<ObjectId>();
        for (String itemId : itemIds) {
            itemIdsList.add(new ObjectId(itemId));
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().tenant;
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsList).and("archive").in(new Object[]{true, false}).and("tenant").is((Object)tenant));
        query.fields().include("id");
        query.fields().include("title");
        query.fields().include("type");
        query.fields().include("teamContainers.team");
        query.fields().include("teamContainers.container");
        query.fields().include("tfsItemType");
        query.fields().include("jiraFieldByKey");
        List allItems = this.mongoTemplate.find(query, Item.class);
        for (Item item : allItems) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            if (!PropertyValidator.isValid((Object)item)) continue;
            itemMap.put("itemId", item.getId());
            itemMap.put("title", item.getTitle());
            itemMap.put("cardType", item.getType());
            HashMap<String, String> teamMap = new HashMap<String, String>();
            HashMap<String, String> sprintMap = new HashMap<String, String>();
            if (item.getTeamContainers() != null) {
                for (TeamContainer teamContainer : item.getTeamContainers()) {
                    if (!PropertyValidator.isValid((Object)teamContainer)) continue;
                    Query queryForTeam = new Query();
                    queryForTeam.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(teamContainer.getTeam().getId())));
                    queryForTeam.fields().include("title");
                    queryForTeam.fields().include("label");
                    queryForTeam.fields().include("color");
                    queryForTeam.fields().include("id");
                    Team selectedTeam = (Team)this.mongoTemplate.findOne(queryForTeam, Team.class);
                    if (!PropertyValidator.isValid((Object)selectedTeam)) continue;
                    teamMap.put(selectedTeam.getLabel(), selectedTeam.getTitle() + "-color:" + selectedTeam.getColor());
                    Query queryForSprint = new Query();
                    queryForSprint.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(DBUtils.isHexString((String)teamContainer.getContainer().getId()) ? new ObjectId(teamContainer.getContainer().getId()) : teamContainer.getContainer().getId()));
                    queryForSprint.fields().include("title");
                    queryForSprint.fields().include("label");
                    queryForSprint.fields().include("id");
                    Container selectedSprint = (Container)this.mongoTemplate.findOne(queryForSprint, Container.class);
                    if (!PropertyValidator.isValid(sprintMap)) continue;
                    sprintMap.put(selectedSprint.getLabel(), selectedSprint.getTitle());
                }
            }
            if (PropertyValidator.isValid((Object)item.getTfsItemType())) {
                itemMap.put("tfsItemType", item.getTfsItemType());
            }
            if (PropertyValidator.isValid((Object)item.getJiraFieldByKey()) && PropertyValidator.isValid(item.getJiraFieldByKey().get("issuetype"))) {
                itemMap.put("jiraFieldByKeyIssueType", item.getJiraFieldByKey().get("issuetype"));
            }
            itemMap.put("teams", teamMap);
            itemMap.put("sprints", sprintMap);
            result.add(itemMap);
        }
        return result;
    }

    public Map<String, Object> createDataForFlowEfficiencyChart(Map<String, Object> requestStr) throws Exception {
        Map<String, Object> objectData = new HashMap<String, Object>();
        try {
            String tenant = "";
            List selectedIssueType = (List)requestStr.get("issueType");
            String interval = null;
            String groupBy = null;
            String boardItemsFilter = "";
            Map itemTags = new LinkedHashMap();
            if (requestStr.get("interval") != null) {
                interval = (String)requestStr.get("interval");
            }
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            if (requestStr.get("groupBy") != null) {
                groupBy = (String)requestStr.get("groupBy");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("boardItemsFilter"))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            boolean creationDateEnabled = (Boolean)requestStr.get("toggleCreationDate");
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
            query.fields().include("session");
            query.fields().include("teams");
            query.fields().include("creationDate");
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            this.fillBoardStatuses(sessionBoard);
            String dashboardKey = (String)requestStr.get("dashboardId");
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            queryForDashboard.fields().include("_id");
            queryForDashboard.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            Map itemData = new HashMap();
            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            if (!creationDateEnabled) {
                String startStatusId = (String)requestStr.get("startStatus");
                String endStatusId = (String)requestStr.get("endStatus");
                String activeStatusId = (String)requestStr.get("selectedActiveStatus");
                ArrayList<String> startStatusIdList = new ArrayList<String>(Arrays.asList(startStatusId.split(",")));
                ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                ArrayList<String> activeStatusIdList = new ArrayList<String>(Arrays.asList(activeStatusId.split(",")));
                itemData = this.timeSeriesRepository.getItemsForFlowEfficiency(sessionBoard, sessionBoardIds, tenant, startStatusIdList, endStatusIdList, activeStatusIdList, statusList, interval, selectedIssueType, groupBy, creationDateEnabled, boardItemsFilter, dashboard, itemTags);
            } else {
                String activeStatusId = (String)requestStr.get("selectedActiveStatus");
                ArrayList startStatusIdList = new ArrayList();
                String endStatusId = (String)requestStr.get("endStatus");
                ArrayList<String> endStatusIdList = new ArrayList<String>(Arrays.asList(endStatusId.split(",")));
                ArrayList<String> activeStatusIdList = new ArrayList<String>(Arrays.asList(activeStatusId.split(",")));
                itemData = this.timeSeriesRepository.getItemsForFlowEfficiency(sessionBoard, sessionBoardIds, tenant, startStatusIdList, endStatusIdList, activeStatusIdList, statusList, interval, selectedIssueType, groupBy, creationDateEnabled, boardItemsFilter, dashboard, itemTags);
            }
            objectData = itemData;
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForFlowEfficiencyChart()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public Map<String, Object> createDataForFlowVelocityChart(Map<String, Object> requestStr) throws Exception {
        Map<String, Object> objectData = new HashMap<String, Object>();
        try {
            String tenant = "";
            List selectedIssueType = (List)requestStr.get("issueType");
            String radioTypeSelection = (String)requestStr.get("radioTypeSelection");
            String interval = null;
            String groupBy = null;
            String boardItemsFilter = "";
            Date startDate = new Date();
            Date endDate = new Date();
            Map itemTags = new HashMap();
            if (requestStr.get("interval") != null) {
                interval = (String)requestStr.get("interval");
            }
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            if (requestStr.get("groupBy") != null) {
                groupBy = (String)requestStr.get("groupBy");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("boardItemsFilter"))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
            query.fields().include("session");
            query.fields().include("teams");
            query.fields().include("creationDate");
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            this.fillBoardStatuses(sessionBoard);
            String dashboardKey = (String)requestStr.get("dashboardId");
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            queryForDashboard.fields().include("_id");
            queryForDashboard.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            Map itemData = new HashMap();
            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            List activeStatusId = new ArrayList();
            if (PropertyValidator.isValid((Collection)((List)requestStr.get("selectedActiveStatus")))) {
                activeStatusId = (List)requestStr.get("selectedActiveStatus");
            }
            ArrayList<String> activeStatusIdList = new ArrayList<String>();
            for (String str : activeStatusId) {
                String[] ids;
                for (String id : ids = str.split(",")) {
                    activeStatusIdList.add(id);
                }
            }
            if (PropertyValidator.isValid((Object)requestStr.get("startDate")) && PropertyValidator.isValid((Object)requestStr.get("endDate"))) {
                Map result = this.getStartEndDateofPI(sessionBoardIds);
                startDate = (Date)result.get("startDate");
                endDate = (Date)result.get("endDate");
            }
            itemData = this.timeSeriesRepository.getItemsForFlowVelocity(sessionBoard, sessionBoardIds, tenant, activeStatusIdList, statusList, interval, selectedIssueType, groupBy, boardItemsFilter, startDate, endDate, dashboard, itemTags, radioTypeSelection);
            objectData = itemData;
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForFlowVelocityChart()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public Map<String, Object> createDataForFlowLoadChart(Map<String, Object> requestStr) throws Exception {
        Map<String, Object> objectData = new HashMap<String, Object>();
        try {
            String tenant = "";
            List selectedIssueType = (List)requestStr.get("issueType");
            Date startDate = new Date();
            Date endDate = new Date();
            String interval = null;
            String groupBy = null;
            String boardItemsFilter = "";
            String radioTypeSelection = "";
            if (requestStr.get("interval") != null) {
                interval = (String)requestStr.get("interval");
            }
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            if (requestStr.get("groupBy") != null) {
                groupBy = (String)requestStr.get("groupBy");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("startDate")) && PropertyValidator.isValid((Object)"endDate") && PropertyValidator.isValid((Object)interval) && interval.equals("days")) {
                startDate = this.dateFormat.parse((String)requestStr.get("startDate"));
                endDate = this.dateFormat.parse((String)requestStr.get("endDate"));
            }
            if (PropertyValidator.isValid((Object)requestStr.get("boardItemsFilter"))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("radioTypeSelection"))) {
                radioTypeSelection = (String)requestStr.get("radioTypeSelection");
            }
            Map itemTags = new HashMap();
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
            query.fields().include("session");
            query.fields().include("teams");
            query.fields().include("creationDate");
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            this.fillBoardStatuses(sessionBoard);
            String dashboardKey = (String)requestStr.get("dashboardId");
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            queryForDashboard.fields().include("_id");
            queryForDashboard.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            Map itemData = new HashMap();
            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            List activeStatusIds = (List)requestStr.get("startStatus");
            ArrayList individualActiveIds = new ArrayList();
            for (String s : activeStatusIds) {
                String[] splitIds = s.split(",");
                Collections.addAll(individualActiveIds, splitIds);
            }
            List waitingStatusIds = (List)requestStr.get("endStatus");
            ArrayList individualWaitingIds = new ArrayList();
            for (String s : waitingStatusIds) {
                String[] splitIds = s.split(",");
                Collections.addAll(individualWaitingIds, splitIds);
            }
            itemData = this.timeSeriesRepository.getFlowLoad(sessionBoard, sessionBoardIds, tenant, individualActiveIds, individualWaitingIds, statusList, interval, selectedIssueType, groupBy, startDate, endDate, boardItemsFilter, dashboard, itemTags, radioTypeSelection);
            objectData = itemData;
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForFlowLoadChart()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    public Map<String, Object> createDataForFlowDistributionChart(Map<String, Object> requestStr) throws Exception {
        Map<String, Object> objectData = new HashMap<String, Object>();
        try {
            String tenant = "";
            List selectedIssueType = (List)requestStr.get("issueType");
            Date startDate = new Date();
            Date endDate = new Date();
            String interval = null;
            String groupBy = null;
            String yAxis = null;
            String boardItemsFilter = "";
            String radioTypeSelection = "";
            Map issueTypeMap = new HashMap();
            if (requestStr.get("interval") != null) {
                interval = (String)requestStr.get("interval");
            }
            if (requestStr.get("yAxis") != null) {
                yAxis = (String)requestStr.get("yAxis");
            }
            String sessionBoardIds = (String)requestStr.get("sessionBoardId");
            if (PropertyValidator.isValid((Object)requestStr.get("tenant"))) {
                tenant = (String)requestStr.get("tenant");
            }
            if (requestStr.get("groupBy") != null) {
                groupBy = (String)requestStr.get("groupBy");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("startDate")) && PropertyValidator.isValid((Object)"endDate") && PropertyValidator.isValid((Object)interval) && interval.equals("days")) {
                startDate = this.dateFormat.parse((String)requestStr.get("startDate"));
                endDate = this.dateFormat.parse((String)requestStr.get("endDate"));
            }
            if (PropertyValidator.isValid((Object)requestStr.get("issueTypeMap"))) {
                issueTypeMap = (Map)requestStr.get("issueTypeMap");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("boardItemsFilter"))) {
                boardItemsFilter = (String)requestStr.get("boardItemsFilter");
            }
            if (PropertyValidator.isValid((Object)requestStr.get("radioTypeSelection"))) {
                radioTypeSelection = (String)requestStr.get("radioTypeSelection");
            }
            Map itemTags = new HashMap();
            if (PropertyValidator.isValid((Object)requestStr.get("itemtags"))) {
                itemTags = (Map)requestStr.get("itemtags");
            }
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardIds)));
            query.fields().include("session");
            query.fields().include("teams");
            query.fields().include("creationDate");
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            this.fillBoardStatuses(sessionBoard);
            String dashboardKey = (String)requestStr.get("dashboardId");
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            queryForDashboard.fields().include("_id");
            queryForDashboard.fields().include("globalColorsMap");
            Dashboard dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            Map itemData = new HashMap();
            List statusList = sessionBoard.getSession().getItemWorkFlow().getStatuses();
            List activeStatusIds = (List)requestStr.get("distributionStatus");
            ArrayList<String> individualActiveIds = new ArrayList<String>();
            for (String str : activeStatusIds) {
                String[] ids;
                for (String id : ids = str.split(",")) {
                    individualActiveIds.add(id);
                }
            }
            itemData = this.timeSeriesRepository.getFlowDistribution(sessionBoard, sessionBoardIds, tenant, individualActiveIds, statusList, interval, selectedIssueType, groupBy, startDate, endDate, yAxis, issueTypeMap, boardItemsFilter, dashboard, itemTags, radioTypeSelection);
            objectData = itemData;
        }
        catch (Exception e) {
            LOGGER.error("Error processing createDataForFlowDistributionChart()" + StringUtils.getTraceString((Throwable)e));
        }
        return objectData;
    }

    private long adjustTimeWithTimezone(long dateMillis, String time, String timeZone) throws ParseException {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        dateTimeFormatter.setTimeZone(TimeZone.getTimeZone(timeZone));
        Date date = new Date(dateMillis);
        String dateOnly = dateFormatter.format(date);
        Date newDateTime = dateTimeFormatter.parse(dateOnly + " " + time);
        return newDateTime.getTime();
    }

    public Map<String, Object> createDataForCompletedStories(Map<String, Object> requestStr) throws Exception {
        String teamName;
        Object selectedBoardSprint = requestStr.get("selectedBoardSprint");
        BoardSprintCriteria sprintMap = null;
        if (selectedBoardSprint instanceof BoardSprintCriteria) {
            sprintMap = (BoardSprintCriteria)selectedBoardSprint;
        } else if (selectedBoardSprint instanceof Map) {
            Map sprintMapData = (Map)selectedBoardSprint;
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            sprintMap = (BoardSprintCriteria)objectMapper.convertValue((Object)sprintMapData, BoardSprintCriteria.class);
        }
        List selectedIssueType = (List)requestStr.get("issueType");
        HashMap<String, Object> completedStories = new HashMap<String, Object>();
        HashMap tempCompletedStories = new HashMap();
        Object sessionBoardMap = requestStr.get("selectedBoard");
        String id = sprintMap.getId();
        Object sessionBoardId = null;
        SessionBoard sessionBoardProp = null;
        Boolean showCriteria = false;
        HashMap teamAndColorList = new HashMap();
        HashMap teamAndLabelList = new HashMap();
        HashMap teamIdAndNameList = new HashMap();
        List teamSprintVelocity = null;
        if (requestStr.get("sessionBoardId") != null) {
            sessionBoardId = requestStr.get("sessionBoardId");
        }
        if (requestStr.get("showCriteria") != null) {
            showCriteria = (Boolean)requestStr.get("showCriteria");
        }
        String processedId = id instanceof String && ObjectId.isValid((String)id) ? new ObjectId(id) : id;
        if (sessionBoardId != null) {
            sessionBoardProp = this.sessionBoardRepository.findById(sessionBoardId.toString());
            String sprintId = processedId != null ? processedId.toString() : null;
            teamSprintVelocity = this.teamSprintVelocityRepository.findBySessionBoardIdAndSprintId(sessionBoardId.toString(), sprintId);
        }
        String startDateObj = sprintMap.getStartDate().toString();
        long startDateMillis = Long.parseLong(startDateObj);
        String endDateObj = sprintMap.getEndDate().toString();
        long endDateMillis = Long.parseLong(endDateObj);
        Date startDate = new Date(startDateMillis);
        Date endDate = new Date(endDateMillis);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        endDate = calendar.getTime();
        List selectedStatusIds = new ArrayList();
        if (PropertyValidator.isValid((Collection)((List)requestStr.get("selectedStatusIds")))) {
            selectedStatusIds = (List)requestStr.get("selectedStatusIds");
        }
        ArrayList<String> individualSelectedStatusIds = new ArrayList<String>();
        for (String str : selectedStatusIds) {
            String[] ids;
            for (String idd : ids = str.split(",")) {
                individualSelectedStatusIds.add(idd);
            }
        }
        HashMap committedStoriesBeforeSprint = new HashMap();
        HashMap committedStoriesBeforeSprintStoryPoints = new HashMap();
        HashMap scopeChangeAddedItems = new HashMap();
        HashMap scopeChangeAddedItemsStoryPoints = new HashMap();
        HashMap beforeSprintAndScopeChangeAddedCombined = new HashMap();
        HashMap scopeChangeRemovedItems = new HashMap();
        HashMap scopeChangeRemovedItemsStoryPoints = new HashMap();
        HashMap deliveredCommittedStoriesBeforeSprint = new HashMap();
        HashMap deliveredCommittedStoriesBeforeSprintStoryPoints = new HashMap();
        HashMap updatedScopeChangeAddedItems = new HashMap();
        HashMap deliveredScopeChange = new HashMap();
        HashMap deliveredScopeChangeStoryPoints = new HashMap();
        HashMap scopeChangeTeamItems = new HashMap();
        HashMap scopeChangeTeamItemsStoryPoints = new HashMap();
        HashMap committedDeliveredTracking = new HashMap();
        HashMap committedDelivered = new HashMap();
        HashMap committedAndScopeChangeTotal = new HashMap();
        HashMap scopeChangeDeliveredTracking = new HashMap();
        HashMap scopeChngeDelivered = new HashMap();
        HashMap committedTeamsData = new HashMap();
        HashMap scopeChangeAdded = new HashMap();
        HashMap scopeChangeRemoved = new HashMap();
        HashSet allTeams = new HashSet();
        HashMap scopeChangeDelivered = new HashMap();
        HashMap teamDetails = new HashMap();
        List teams = sessionBoardProp.getTeams();
        HashMap teamDateMap = new HashMap();
        if (teams.size() > 0) {
            for (Team team : teams) {
                if (team == null || team.getTitle() == null || startDate == null || endDate == null || team.isArchive()) continue;
                HashMap<String, Object> dateMap = new HashMap<String, Object>();
                dateMap.put("startDate", startDate);
                dateMap.put("endDate", endDate);
                dateMap.put("teamId", team.getId());
                teamDateMap.put(team.getTitle(), dateMap);
            }
        }
        if (teamSprintVelocity.size() > 0) {
            Object teamId;
            Map dateMap;
            for (Map.Entry entry : teamDateMap.entrySet()) {
                teamName = (String)entry.getKey();
                dateMap = (Map)entry.getValue();
                Date currentStartDate = (Date)dateMap.get("startDate");
                Date currentEndDate = (Date)dateMap.get("endDate");
                teamId = dateMap.get("teamId");
                for (TeamSprintVelocity sprintVelocity : teamSprintVelocity) {
                    String sprintVelocityTeamId = sprintVelocity.getTeamId();
                    if (!teamId.equals(sprintVelocityTeamId)) continue;
                    Date lastBaseLineDate = sprintVelocity.getLastBaseLineDate();
                    Date lastSpillOverDate = sprintVelocity.getLastSpillOverDate();
                    if (lastBaseLineDate == null || lastBaseLineDate.after(currentEndDate)) break;
                    if (lastBaseLineDate != null) {
                        currentStartDate = lastBaseLineDate;
                    }
                    if (lastSpillOverDate == null) break;
                    currentEndDate = lastSpillOverDate;
                    break;
                }
                dateMap.put("startDate", currentStartDate);
                dateMap.put("endDate", currentEndDate);
            }
            for (Map.Entry entry : teamDateMap.entrySet()) {
                teamName = (String)entry.getKey();
                dateMap = (Map)entry.getValue();
                Date startDateVelocity = (Date)dateMap.get("startDate");
                Date endDateVelocity = (Date)dateMap.get("endDate");
                teamId = new ObjectId((String)dateMap.get("teamId"));
                if (showCriteria.booleanValue()) {
                    this.completedStoriesStoryPointsCalculation(tempCompletedStories, teamIdAndNameList, teamName, teamId, sessionBoardId, (Object)processedId, startDateVelocity, selectedIssueType, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprint, committedStoriesBeforeSprintStoryPoints, endDateVelocity, scopeChangeAddedItems, scopeChangeAddedItemsStoryPoints, beforeSprintAndScopeChangeAddedCombined, scopeChangeRemovedItems, scopeChangeRemovedItemsStoryPoints, individualSelectedStatusIds, deliveredCommittedStoriesBeforeSprint, deliveredCommittedStoriesBeforeSprintStoryPoints, updatedScopeChangeAddedItems, deliveredScopeChange, deliveredScopeChangeStoryPoints, completedStories, allTeams, scopeChangeTeamItems, scopeChangeTeamItemsStoryPoints, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
                    continue;
                }
                this.completedStoriesItemCalculation(teamIdAndNameList, teamName, teamId, sessionBoardId, (Object)processedId, startDateVelocity, selectedIssueType, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprint, endDateVelocity, scopeChangeAddedItems, beforeSprintAndScopeChangeAddedCombined, scopeChangeRemovedItems, individualSelectedStatusIds, deliveredCommittedStoriesBeforeSprint, updatedScopeChangeAddedItems, deliveredScopeChange, completedStories, allTeams, scopeChangeTeamItems, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            }
            if (showCriteria.booleanValue()) {
                this.itemStoryPointsTrackingComputationCompletedStories(scopeChangeAddedItems, scopeChangeRemovedItems, deliveredScopeChange, deliveredCommittedStoriesBeforeSprint, committedStoriesBeforeSprint, tempCompletedStories, teamIdAndNameList, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprintStoryPoints, scopeChangeAddedItemsStoryPoints, scopeChangeRemovedItemsStoryPoints, deliveredCommittedStoriesBeforeSprintStoryPoints, deliveredScopeChangeStoryPoints, completedStories, allTeams, scopeChangeTeamItems, scopeChangeTeamItemsStoryPoints, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            } else {
                this.itemTrackingComputationCompletedStories(completedStories, allTeams, teamAndColorList, teamAndLabelList, teamIdAndNameList, scopeChangeAddedItems, scopeChangeRemovedItems, scopeChangeTeamItems, deliveredScopeChange, scopeChangeDelivered, committedStoriesBeforeSprint, deliveredCommittedStoriesBeforeSprint, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            }
        } else if (sessionBoardProp.getTzEnabled().booleanValue()) {
            Map dateMap;
            String timeZone = null;
            if (sessionBoardProp.getTzSite() != null) {
                timeZone = sessionBoardProp.getTzSite().getTimeZone();
            }
            if (timeZone == null || timeZone.isEmpty()) {
                timeZone = TimeZone.getDefault().getID();
            }
            String string = sessionBoardProp.getTzStartTime();
            String tzEndTime = sessionBoardProp.getTzEndTime();
            long adjustedStartDateMillis = this.adjustTimeWithTimezone(startDateMillis, string, timeZone);
            long adjustedEndDateMillis = this.adjustTimeWithTimezone(endDateMillis, tzEndTime, timeZone);
            for (Map.Entry entry : teamDateMap.entrySet()) {
                String teamName2 = (String)entry.getKey();
                dateMap = (Map)entry.getValue();
                Date currentStartDate = (Date)dateMap.get("startDate");
                Date currentEndDate = (Date)dateMap.get("endDate");
                if (currentStartDate == null || currentEndDate == null) continue;
                dateMap.put("startDate", new Date(adjustedStartDateMillis));
                dateMap.put("endDate", new Date(adjustedEndDateMillis));
            }
            for (Map.Entry entry : teamDateMap.entrySet()) {
                String teamName2 = (String)entry.getKey();
                dateMap = (Map)entry.getValue();
                Date startDateVelocity = (Date)dateMap.get("startDate");
                ObjectId teamId = new ObjectId((String)dateMap.get("teamId"));
                Date endDateVelocity = (Date)dateMap.get("endDate");
                if (showCriteria.booleanValue()) {
                    this.completedStoriesStoryPointsCalculation(tempCompletedStories, teamIdAndNameList, teamName2, (Object)teamId, sessionBoardId, (Object)processedId, startDateVelocity, selectedIssueType, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprint, committedStoriesBeforeSprintStoryPoints, endDateVelocity, scopeChangeAddedItems, scopeChangeAddedItemsStoryPoints, beforeSprintAndScopeChangeAddedCombined, scopeChangeRemovedItems, scopeChangeRemovedItemsStoryPoints, individualSelectedStatusIds, deliveredCommittedStoriesBeforeSprint, deliveredCommittedStoriesBeforeSprintStoryPoints, updatedScopeChangeAddedItems, deliveredScopeChange, deliveredScopeChangeStoryPoints, completedStories, allTeams, scopeChangeTeamItems, scopeChangeTeamItemsStoryPoints, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
                    continue;
                }
                this.completedStoriesItemCalculation(teamIdAndNameList, teamName2, (Object)teamId, sessionBoardId, (Object)processedId, startDateVelocity, selectedIssueType, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprint, endDateVelocity, scopeChangeAddedItems, beforeSprintAndScopeChangeAddedCombined, scopeChangeRemovedItems, individualSelectedStatusIds, deliveredCommittedStoriesBeforeSprint, updatedScopeChangeAddedItems, deliveredScopeChange, completedStories, allTeams, scopeChangeTeamItems, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            }
            if (showCriteria.booleanValue()) {
                this.itemStoryPointsTrackingComputationCompletedStories(scopeChangeAddedItems, scopeChangeRemovedItems, deliveredScopeChange, deliveredCommittedStoriesBeforeSprint, committedStoriesBeforeSprint, tempCompletedStories, teamIdAndNameList, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprintStoryPoints, scopeChangeAddedItemsStoryPoints, scopeChangeRemovedItemsStoryPoints, deliveredCommittedStoriesBeforeSprintStoryPoints, deliveredScopeChangeStoryPoints, completedStories, allTeams, scopeChangeTeamItems, scopeChangeTeamItemsStoryPoints, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            } else {
                this.itemTrackingComputationCompletedStories(completedStories, allTeams, teamAndColorList, teamAndLabelList, teamIdAndNameList, scopeChangeAddedItems, scopeChangeRemovedItems, scopeChangeTeamItems, deliveredScopeChange, scopeChangeDelivered, committedStoriesBeforeSprint, deliveredCommittedStoriesBeforeSprint, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            }
        } else {
            for (Map.Entry entry : teamDateMap.entrySet()) {
                teamName = (String)entry.getKey();
                Map dateMap = (Map)entry.getValue();
                Date startDateVelocity = (Date)dateMap.get("startDate");
                Date endDateVelocity = (Date)dateMap.get("endDate");
                ObjectId teamId = new ObjectId((String)dateMap.get("teamId"));
                if (showCriteria.booleanValue()) {
                    this.completedStoriesStoryPointsCalculation(tempCompletedStories, teamIdAndNameList, teamName, (Object)teamId, sessionBoardId, (Object)processedId, startDateVelocity, selectedIssueType, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprint, committedStoriesBeforeSprintStoryPoints, endDateVelocity, scopeChangeAddedItems, scopeChangeAddedItemsStoryPoints, beforeSprintAndScopeChangeAddedCombined, scopeChangeRemovedItems, scopeChangeRemovedItemsStoryPoints, individualSelectedStatusIds, deliveredCommittedStoriesBeforeSprint, deliveredCommittedStoriesBeforeSprintStoryPoints, updatedScopeChangeAddedItems, deliveredScopeChange, deliveredScopeChangeStoryPoints, completedStories, allTeams, scopeChangeTeamItems, scopeChangeTeamItemsStoryPoints, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
                    continue;
                }
                this.completedStoriesItemCalculation(teamIdAndNameList, teamName, (Object)teamId, sessionBoardId, (Object)processedId, startDateVelocity, selectedIssueType, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprint, endDateVelocity, scopeChangeAddedItems, beforeSprintAndScopeChangeAddedCombined, scopeChangeRemovedItems, individualSelectedStatusIds, deliveredCommittedStoriesBeforeSprint, updatedScopeChangeAddedItems, deliveredScopeChange, completedStories, allTeams, scopeChangeTeamItems, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            }
            if (showCriteria.booleanValue()) {
                this.itemStoryPointsTrackingComputationCompletedStories(scopeChangeAddedItems, scopeChangeRemovedItems, deliveredScopeChange, deliveredCommittedStoriesBeforeSprint, committedStoriesBeforeSprint, tempCompletedStories, teamIdAndNameList, teamAndLabelList, teamAndColorList, committedStoriesBeforeSprintStoryPoints, scopeChangeAddedItemsStoryPoints, scopeChangeRemovedItemsStoryPoints, deliveredCommittedStoriesBeforeSprintStoryPoints, deliveredScopeChangeStoryPoints, completedStories, allTeams, scopeChangeTeamItems, scopeChangeTeamItemsStoryPoints, scopeChangeDelivered, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            } else {
                this.itemTrackingComputationCompletedStories(completedStories, allTeams, teamAndColorList, teamAndLabelList, teamIdAndNameList, scopeChangeAddedItems, scopeChangeRemovedItems, scopeChangeTeamItems, deliveredScopeChange, scopeChangeDelivered, committedStoriesBeforeSprint, deliveredCommittedStoriesBeforeSprint, committedAndScopeChangeTotal, committedTeamsData, scopeChangeAdded, scopeChangeRemoved, scopeChangeDeliveredTracking, committedDeliveredTracking, committedDelivered, scopeChngeDelivered);
            }
        }
        return completedStories;
    }

    private void itemTrackingComputationCompletedStories(Map<String, Object> completedStories, Set<String> allTeams, Map<String, String> teamAndColorList, Map<String, String> teamAndLabelList, Map<String, String> teamIdAndNameList, Map<String, List<String>> scopeChangeAddedItems, Map<String, List<String>> scopeChangeRemovedItems, Map<String, List> scopeChangeTeamItems, Map<String, List<String>> deliveredScopeChange, Map<String, String> scopeChangeDelivered, Map<String, List<String>> committedStoriesBeforeSprint, Map<String, List<String>> deliveredCommittedStoriesBeforeSprint, Map<String, String> committedAndScopeChangeTotal, Map<String, Double> committedTeamsData, Map<String, Double> scopeChangeAdded, Map<String, Double> scopeChangeRemoved, Map<String, Double> scopeChangeDeliveredTracking, Map<String, Double> committedDeliveredTracking, Map<String, String> committedDelivered, Map<String, String> scopeChngeDelivered) {
        Map nestedMap;
        Object nestedMapObject;
        String outerKey;
        for (Map.Entry<String, Object> entry : completedStories.entrySet()) {
            outerKey = entry.getKey();
            nestedMapObject = entry.getValue();
            if (!(nestedMapObject instanceof Map)) continue;
            nestedMap = (Map)nestedMapObject;
            allTeams.addAll(nestedMap.keySet());
        }
        for (String string : allTeams) {
            Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(string)));
            teamQuery.fields().include("title").include("color").include("label");
            Team teamEntity = (Team)this.mongoTemplate.findOne(teamQuery, Team.class, "team");
            if (teamEntity != null) {
                String title = teamEntity.getTitle();
                String color = teamEntity.getColor();
                Iterator label = teamEntity.getLabel();
                teamAndColorList.putIfAbsent(title, color);
                teamAndLabelList.putIfAbsent(title, (String)((Object)label));
                teamIdAndNameList.putIfAbsent(string, title);
                continue;
            }
            System.out.println("No team found for teamId: " + string);
        }
        for (Map.Entry entry : completedStories.entrySet()) {
            outerKey = (String)entry.getKey();
            nestedMapObject = entry.getValue();
            if (!(nestedMapObject instanceof Map)) continue;
            nestedMap = (Map)nestedMapObject;
            HashMap<String, List> newNestedMap = new HashMap<String, List>();
            for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                String teamId = (String)nestedEntry.getKey();
                List storyList = (List)nestedEntry.getValue();
                if (teamIdAndNameList.containsKey(teamId)) {
                    String teamName = teamIdAndNameList.get(teamId);
                    newNestedMap.put(teamName, storyList);
                    continue;
                }
                newNestedMap.put(teamId, storyList);
            }
            completedStories.put(outerKey, newNestedMap);
        }
        scopeChangeAddedItems = null;
        scopeChangeAddedItems = (Map)completedStories.get("scopeChangeAddedItems");
        scopeChangeRemovedItems = null;
        scopeChangeRemovedItems = (Map)completedStories.get("scopeChangeRemovedItems");
        deliveredScopeChange = null;
        deliveredScopeChange = (Map)completedStories.get("deliveredScopeChange");
        committedStoriesBeforeSprint = null;
        committedStoriesBeforeSprint = (Map)completedStories.get("committedStoriesBeforeSprint");
        deliveredCommittedStoriesBeforeSprint = null;
        deliveredCommittedStoriesBeforeSprint = (Map)completedStories.get("deliveredCommittedStoriesBeforeSprint");
        HashSet<String> updatedTeams = new HashSet<String>();
        for (String teamId : allTeams) {
            if (teamIdAndNameList.containsKey(teamId)) {
                String teamName = teamIdAndNameList.get(teamId);
                updatedTeams.add(teamName);
                continue;
            }
            updatedTeams.add(teamId);
        }
        allTeams.clear();
        allTeams.addAll(updatedTeams);
        for (String team : allTeams) {
            List addedItems = scopeChangeAddedItems.getOrDefault(team, new ArrayList());
            List removedItems = scopeChangeRemovedItems.getOrDefault(team, new ArrayList());
            ArrayList<String> filteredItems = new ArrayList<String>();
            for (String item : addedItems) {
                if (removedItems.contains(item)) continue;
                filteredItems.add(item);
            }
            scopeChangeTeamItems.put(team, filteredItems);
        }
        for (String team : allTeams) {
            List committedScopeChangeStories = scopeChangeTeamItems.getOrDefault(team, new ArrayList());
            List deliveredScopeChangeStories = deliveredScopeChange.getOrDefault(team, new ArrayList());
            int totalScopeChangeCommitted = committedScopeChangeStories.size();
            int totalScopeChangeDelivered = deliveredScopeChangeStories.size();
            String delivered = totalScopeChangeDelivered + "/" + totalScopeChangeCommitted;
            scopeChangeDelivered.put(team, delivered);
        }
        for (String team : allTeams) {
            List committedStories = committedStoriesBeforeSprint.getOrDefault(team, new ArrayList());
            List deliveredStories = deliveredCommittedStoriesBeforeSprint.getOrDefault(team, new ArrayList());
            List committedScopeChangeStories = scopeChangeTeamItems.getOrDefault(team, new ArrayList());
            List committedScopeChangeAddedStories = scopeChangeAddedItems.getOrDefault(team, new ArrayList());
            List deliveredScopeChangeStories = deliveredScopeChange.getOrDefault(team, new ArrayList());
            List removedScopeChangeItems = scopeChangeRemovedItems.getOrDefault(team, new ArrayList());
            int totalScopeChangeCommitted = committedScopeChangeStories.size();
            int totalAddedScopeChangeCommittedItems = committedScopeChangeAddedStories.size();
            int totalScopeChangeDelivered = deliveredScopeChangeStories.size();
            int totalRemovalScopeChange = removedScopeChangeItems.size();
            int totalCommitted = committedStories.size();
            int totalDelivered = deliveredStories.size();
            String deliveredWithChange = totalDelivered + totalScopeChangeDelivered + "/" + (totalScopeChangeCommitted + totalCommitted);
            String delivered = totalDelivered + "/" + totalCommitted;
            String scopeChgDelivered = totalScopeChangeDelivered + "/" + totalScopeChangeCommitted;
            double percentage = totalCommitted > 0 ? (double)totalDelivered / (double)totalCommitted * 100.0 : 0.0;
            double totalItemCompleted = (double)totalDelivered + (double)totalScopeChangeDelivered;
            double totalItemsCommittedAndScopeChange = (double)totalAddedScopeChangeCommittedItems + (double)totalCommitted - (double)totalRemovalScopeChange;
            double percentageWithChange = totalItemsCommittedAndScopeChange > 0.0 ? totalItemCompleted / totalItemsCommittedAndScopeChange * 100.0 : 0.0;
            committedAndScopeChangeTotal.put(team, deliveredWithChange);
            if (committedStoriesBeforeSprint.containsKey(team)) {
                committedTeamsData.put(team, Double.valueOf(((List)committedStoriesBeforeSprint.get(team)).size()));
            } else {
                committedTeamsData.put(team, 0.0);
            }
            if (scopeChangeAddedItems.containsKey(team)) {
                scopeChangeAdded.put(team, Double.valueOf(((List)scopeChangeAddedItems.get(team)).size()));
            } else {
                scopeChangeAdded.put(team, 0.0);
            }
            if (scopeChangeRemovedItems.containsKey(team)) {
                scopeChangeRemoved.put(team, Double.valueOf(((List)scopeChangeRemovedItems.get(team)).size()));
            } else {
                scopeChangeRemoved.put(team, 0.0);
            }
            scopeChangeDeliveredTracking.put(team, percentageWithChange);
            committedDeliveredTracking.put(team, percentage);
            committedDelivered.put(team, delivered);
            scopeChngeDelivered.put(team, scopeChgDelivered);
        }
        completedStories.put("committedDeliveredTracking", committedDeliveredTracking);
        completedStories.put("committedDelivered", committedDelivered);
        completedStories.put("committedAndScopeChangeTotal", committedAndScopeChangeTotal);
        completedStories.put("scopeChangeDeliveredTracking", scopeChangeDeliveredTracking);
        completedStories.put("scopeChngeDelivered", scopeChngeDelivered);
        completedStories.put("scopeChangeRemoved", scopeChangeRemoved);
        completedStories.put("scopeChangeAdded", scopeChangeAdded);
        completedStories.put("committedTeamsData", committedTeamsData);
        completedStories.put("teams", allTeams);
        completedStories.put("teamAndColorList", teamAndColorList);
        completedStories.put("teamAndLabelList", teamAndLabelList);
    }

    private Item findItemById(List<Item> items, String itemId) {
        for (Item item : items) {
            if (!item.getId().toString().equals(itemId)) continue;
            return item;
        }
        return null;
    }

    private void completedStoriesItemCalculation(Map<String, String> teamIdAndNameList, String teamNameSprint, Object teamIdSprint, Object sessionBoardId, Object processedId, Date startDate, List<String> selectedIssueType, Map<String, String> teamAndLabelList, Map<String, String> teamAndColorList, Map<String, List<String>> committedStoriesBeforeSprint, Date endDate, Map<String, List<String>> scopeChangeAddedItems, Map<String, List<String>> beforeSprintAndScopeChangeAddedCombined, Map<String, List<String>> scopeChangeRemovedItems, List<String> individualSelectedStatusIds, Map<String, List<String>> deliveredCommittedStoriesBeforeSprint, Map<String, List<String>> updatedScopeChangeAddedItems, Map<String, List<String>> deliveredScopeChange, Map<String, Object> completedStories, Set<String> allTeams, Map<String, List> scopeChangeTeamItems, Map<String, String> scopeChangeDelivered, Map<String, String> committedAndScopeChangeTotal, Map<String, Double> committedTeamsData, Map<String, Double> scopeChangeAdded, Map<String, Double> scopeChangeRemoved, Map<String, Double> scopeChangeDeliveredTracking, Map<String, Double> committedDeliveredTracking, Map<String, String> committedDelivered, Map<String, String> scopeChngeDelivered) {
        String team;
        long startTime = System.nanoTime();
        BasicDBObject query = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("changes.teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers.container._id", processedId).append("teamContainers.team._id", teamIdSprint).append("eventTime", (Object)new BasicDBObject("$lte", (Object)startDate));
        DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursor = collection.find((DBObject)query);
        HashSet<String> itemIdsCommit = new HashSet<String>();
        while (cursor.hasNext()) {
            BasicDBObject document = (BasicDBObject)cursor.next();
            String itemId = document.getString("itemId");
            itemIdsCommit.add(itemId);
        }
        Query itemQueryForCommit = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsCommit).and("archive").in(new Object[]{true, false}));
        itemQueryForCommit.fields().include("type").include("jiraIssueTypeId").include("tfsItemType");
        List itemsForCommit = this.mongoTemplate.find(itemQueryForCommit, Item.class, "item");
        HashMap<String, Item> itemMap = new HashMap<String, Item>();
        for (Item item2 : itemsForCommit) {
            itemMap.put(item2.getId().toString(), item2);
        }
        cursor = collection.find((DBObject)query);
        while (cursor.hasNext()) {
            String teamId;
            BasicDBObject container;
            BasicDBObject team2;
            BasicDBObject document = (BasicDBObject)cursor.next();
            String itemId = document.getString("itemId");
            Item item2 = (Item)itemMap.get(itemId);
            if (item2 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item2, selectedIssueType)) || !item2.getType().equals("UserStory")) continue;
            BasicDBList teamContainers = (BasicDBList)document.get("teamContainers");
            BasicDBObject lastTeamContainer = null;
            if (teamContainers == null || teamContainers.isEmpty() || (team2 = (BasicDBObject)(container = (lastTeamContainer = (BasicDBObject)teamContainers.get(teamContainers.size() - 1))).get("team")) == null) continue;
            String teamTitle = teamId = team2.getString("_id");
            committedStoriesBeforeSprint.computeIfAbsent(teamTitle, k -> new ArrayList());
            if (committedStoriesBeforeSprint.get(teamTitle).contains(itemId)) continue;
            committedStoriesBeforeSprint.get(teamTitle).add(itemId);
        }
        HashMap committedTempMap = new HashMap();
        for (Map.Entry entry : committedStoriesBeforeSprint.entrySet()) {
            committedTempMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        long endTime = System.nanoTime();
        double elapsedTime = (double)(endTime - startTime) / 1.0E9;
        LOGGER.debug("Committed Items in -->" + elapsedTime);
        long startTime2 = System.nanoTime();
        ArrayList<BasicDBObject> aggregationPipelineComitRemove = new ArrayList<BasicDBObject>();
        BasicDBObject matchStageComitRemove = new BasicDBObject("$match", (Object)new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("eventTime", (Object)new BasicDBObject("$lte", (Object)startDate)).append("$or", Arrays.asList(new BasicDBObject("changes.teamContainers", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("changes.archive", (Object)true))));
        aggregationPipelineComitRemove.add(matchStageComitRemove);
        BasicDBObject groupStageComitRemove = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("firstDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipelineComitRemove.add(groupStageComitRemove);
        DBCollection collection3CommitRemoval = this.mongoTemplate.getCollection("itemTimeSeries");
        AggregationOutput outputFirstDoc = collection3CommitRemoval.aggregate(aggregationPipelineComitRemove);
        HashMap<String, BasicDBObject> firstDocumentsMapComitRemove = new HashMap<String, BasicDBObject>();
        for (DBObject result : outputFirstDoc.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject firstDoc = (BasicDBObject)result.get("firstDocument");
            firstDocumentsMapComitRemove.put(itemId, firstDoc);
        }
        ArrayList<BasicDBObject> aggregationPipelineCommitRemoval2 = new ArrayList<BasicDBObject>();
        aggregationPipelineCommitRemoval2.add(matchStageComitRemove);
        BasicDBObject sortStageComitRemove = new BasicDBObject("$sort", (Object)new BasicDBObject("eventTime", (Object)-1));
        aggregationPipelineCommitRemoval2.add(sortStageComitRemove);
        BasicDBObject groupStage2CommitRemove = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("latestDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipelineCommitRemoval2.add(groupStage2CommitRemove);
        AggregationOutput output2CommitRemove = collection3CommitRemoval.aggregate(aggregationPipelineCommitRemoval2);
        HashMap<String, BasicDBObject> latestDocumentsMapComitRemove = new HashMap<String, BasicDBObject>();
        for (DBObject result : output2CommitRemove.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject latestDoc = (BasicDBObject)result.get("latestDocument");
            latestDocumentsMapComitRemove.put(itemId, latestDoc);
        }
        Set allItemIdsFromFirstDocumentComitRemove = firstDocumentsMapComitRemove.keySet();
        Query itemQueryDeliveredRemove = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(allItemIdsFromFirstDocumentComitRemove).and("archive").in(new Object[]{true, false}));
        itemQueryDeliveredRemove.fields().include("type").include("jiraIssueTypeId").include("tfsItemType");
        List itemsDeliveredRemoved = this.mongoTemplate.find(itemQueryDeliveredRemove, Item.class, "item");
        HashMap<String, Item> itemMapComitRemove = new HashMap<String, Item>();
        for (Item item3 : itemsDeliveredRemoved) {
            itemMapComitRemove.put(item3.getId().toString(), item3);
        }
        for (Map.Entry entry : committedTempMap.entrySet()) {
            String teamId = (String)entry.getKey();
            List itemIds2 = (List)entry.getValue();
            if (!teamId.equals(teamIdSprint.toString())) continue;
            for (String itemId : itemIds2) {
                List<String> items;
                Item item5 = (Item)itemMapComitRemove.get(itemId);
                if (item5 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item5, selectedIssueType)) || !item5.getType().equals("UserStory")) continue;
                BasicDBObject firstDocument = (BasicDBObject)firstDocumentsMapComitRemove.get(itemId);
                BasicDBObject latestDocument = (BasicDBObject)latestDocumentsMapComitRemove.get(itemId);
                if (firstDocument == null || latestDocument == null) continue;
                String firstTeamId = this.extractTeamId(firstDocument);
                String firstContainerId = this.extractContainerIdFromTeamContainer(firstDocument);
                String latestTeamId = this.extractTeamId(latestDocument);
                String latestContainerId = this.extractContainerIdFromTeamContainer(latestDocument);
                Boolean latestArchive = this.extractArchiveStatus(latestDocument);
                if (Objects.equals(latestContainerId, processedId.toString()) && !latestArchive.booleanValue()) continue;
                if (!Objects.equals(firstContainerId, latestContainerId) || latestArchive.booleanValue()) {
                    if (!Objects.equals(firstTeamId, latestTeamId) || latestArchive.booleanValue()) {
                        committedStoriesBeforeSprint.computeIfAbsent(teamId, k -> new ArrayList());
                        items = committedStoriesBeforeSprint.get(teamId);
                        if (!items.contains(itemId)) continue;
                        items.remove(itemId);
                        continue;
                    }
                    committedStoriesBeforeSprint.computeIfAbsent(teamId, k -> new ArrayList());
                    items = committedStoriesBeforeSprint.get(teamId);
                    if (!items.contains(itemId)) continue;
                    items.remove(itemId);
                    continue;
                }
                if (Objects.equals(firstTeamId, latestTeamId) && !latestArchive.booleanValue()) continue;
                committedStoriesBeforeSprint.computeIfAbsent(teamId, k -> new ArrayList());
                items = committedStoriesBeforeSprint.get(teamId);
                if (!items.contains(itemId)) continue;
                items.remove(itemId);
            }
        }
        long endTime2 = System.nanoTime();
        double elapsedTime2 = (double)(endTime2 - startTime2) / 1.0E9;
        LOGGER.debug("Committed Items removed in --> " + elapsedTime2 + " seconds");
        long startTime3 = System.nanoTime();
        BasicDBObject query2 = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers.container._id", processedId).append("teamContainers.team._id", teamIdSprint).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate));
        DBCollection collection2 = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursor2 = collection2.find((DBObject)query2);
        ArrayList<String> itemIdsForScopeAdded = new ArrayList<String>();
        while (cursor2.hasNext()) {
            DBObject document = cursor2.next();
            String itemId = (String)document.get("itemId");
            itemIdsForScopeAdded.add(itemId);
        }
        Query itemQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsForScopeAdded).and("archive").in(new Object[]{true, false}));
        itemQuery.fields().include("type").include("jiraIssueTypeId").include("tfsItemType");
        List itemsForScopeAdded = this.mongoTemplate.find(itemQuery, Item.class, "item");
        for (DBObject document : cursor2) {
            String teamId;
            BasicDBObject container;
            BasicDBObject basicDBObject;
            String itemId = (String)document.get("itemId");
            Item item6 = this.findItemById(itemsForScopeAdded, itemId);
            if (item6 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item6, selectedIssueType)) || !item6.getType().equals("UserStory")) continue;
            BasicDBList teamContainers = (BasicDBList)document.get("teamContainers");
            BasicDBObject lastTeamContainer = null;
            if (teamContainers == null || teamContainers.isEmpty() || (basicDBObject = (BasicDBObject)(container = (lastTeamContainer = (BasicDBObject)teamContainers.get(teamContainers.size() - 1))).get("team")) == null) continue;
            String teamTitle = teamId = basicDBObject.getString("_id");
            scopeChangeAddedItems.computeIfAbsent(teamTitle, k -> new ArrayList());
            if (scopeChangeAddedItems.get(teamTitle).contains(itemId)) continue;
            scopeChangeAddedItems.get(teamTitle).add(itemId);
        }
        long endTime3 = System.nanoTime();
        double elapsedTime3 = (double)(endTime3 - startTime3) / 1.0E9;
        LOGGER.debug("Scope Added Items in --> " + elapsedTime3 + " seconds");
        long startTime4 = System.nanoTime();
        for (Map.Entry<String, List<String>> entry : committedStoriesBeforeSprint.entrySet()) {
            team = entry.getKey();
            List<String> committedItems = entry.getValue();
            if (!scopeChangeAddedItems.containsKey(team)) continue;
            scopeChangeAddedItems.get(team).removeAll(committedItems);
        }
        for (Map.Entry<String, List<String>> entry : committedStoriesBeforeSprint.entrySet()) {
            team = entry.getKey();
            beforeSprintAndScopeChangeAddedCombined.putIfAbsent(team, new ArrayList());
            for (String item7 : entry.getValue()) {
                if (beforeSprintAndScopeChangeAddedCombined.get(team).contains(item7)) continue;
                beforeSprintAndScopeChangeAddedCombined.get(team).add(item7);
            }
        }
        for (Map.Entry entry : scopeChangeAddedItems.entrySet()) {
            team = (String)entry.getKey();
            beforeSprintAndScopeChangeAddedCombined.putIfAbsent(team, new ArrayList());
            for (String item4 : (List)entry.getValue()) {
                if (beforeSprintAndScopeChangeAddedCombined.get(team).contains(item4)) continue;
                beforeSprintAndScopeChangeAddedCombined.get(team).add(item4);
            }
        }
        long endTime4 = System.nanoTime();
        double elapsedTime4 = (double)(endTime4 - startTime4) / 1.0E9;
        LOGGER.debug("Process After Scope Added Items in --> " + elapsedTime4 + " seconds");
        long startTime5 = System.nanoTime();
        ArrayList itemIdsList = new ArrayList();
        beforeSprintAndScopeChangeAddedCombined.values().forEach(itemIds -> itemIdsList.addAll(itemIds));
        ArrayList<BasicDBObject> aggregationPipeline = new ArrayList<BasicDBObject>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("itemId", (Object)new BasicDBObject("$in", itemIdsList)).append("teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers.container._id", processedId).append("teamContainers.team._id", teamIdSprint).append("eventTime", (Object)new BasicDBObject("$lte", (Object)endDate)));
        aggregationPipeline.add(matchStage);
        BasicDBObject groupStage = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("firstDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipeline.add(groupStage);
        DBCollection collection3 = this.mongoTemplate.getCollection("itemTimeSeries");
        AggregationOutput output = collection3.aggregate(aggregationPipeline);
        HashMap<String, BasicDBObject> firstDocumentsMap = new HashMap<String, BasicDBObject>();
        for (DBObject result : output.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject firstDoc = (BasicDBObject)result.get("firstDocument");
            firstDocumentsMap.put(itemId, firstDoc);
        }
        BasicDBObject matchStage2 = new BasicDBObject("$match", (Object)new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("itemId", (Object)new BasicDBObject("$in", itemIdsList)).append("$or", Arrays.asList(new BasicDBObject("changes.teamContainers", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("changes.archive", (Object)true))).append("eventTime", (Object)new BasicDBObject("$lte", (Object)endDate)));
        ArrayList<BasicDBObject> aggregationPipeline2 = new ArrayList<BasicDBObject>();
        aggregationPipeline2.add(matchStage2);
        BasicDBObject sortStage = new BasicDBObject("$sort", (Object)new BasicDBObject("eventTime", (Object)-1));
        aggregationPipeline2.add(sortStage);
        BasicDBObject groupStage2 = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("latestDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipeline2.add(groupStage2);
        AggregationOutput output2 = collection3.aggregate(aggregationPipeline2);
        HashMap<String, BasicDBObject> latestDocumentsMap = new HashMap<String, BasicDBObject>();
        for (DBObject result : output2.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject latestDoc = (BasicDBObject)result.get("latestDocument");
            latestDocumentsMap.put(itemId, latestDoc);
        }
        Set allItemIdsFromFirstDocument = firstDocumentsMap.keySet();
        Query itemQueryDelivered = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(allItemIdsFromFirstDocument).and("archive").in(new Object[]{true, false}));
        itemQueryDelivered.fields().include("type").include("jiraIssueTypeId").include("tfsItemType");
        List itemsDelivered = this.mongoTemplate.find(itemQueryDelivered, Item.class, "item");
        HashMap<String, Item> itemMapDelivery = new HashMap<String, Item>();
        for (Item item5 : itemsDelivered) {
            itemMapDelivery.put(item5.getId().toString(), item5);
        }
        for (Map.Entry entry : beforeSprintAndScopeChangeAddedCombined.entrySet()) {
            String teamId = (String)entry.getKey();
            List itemIds3 = (List)entry.getValue();
            if (!teamId.equals(teamIdSprint.toString())) continue;
            for (String itemId : itemIds3) {
                List<String> items;
                Item item9 = (Item)itemMapDelivery.get(itemId);
                if (item9 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item9, selectedIssueType)) || !item9.getType().equals("UserStory")) continue;
                BasicDBObject firstDocument = (BasicDBObject)firstDocumentsMap.get(itemId);
                BasicDBObject latestDocument = (BasicDBObject)latestDocumentsMap.get(itemId);
                if (firstDocument == null || latestDocument == null) continue;
                String firstTeamId = this.extractTeamId(firstDocument);
                String firstContainerId = this.extractContainerIdFromTeamContainer(firstDocument);
                String latestTeamId = this.extractTeamId(latestDocument);
                String latestContainerId = this.extractContainerIdFromTeamContainer(latestDocument);
                Boolean latestArchive = this.extractArchiveStatus(latestDocument);
                if (!Objects.equals(firstContainerId, latestContainerId) || latestArchive.booleanValue()) {
                    if (!Objects.equals(firstTeamId, latestTeamId) || latestArchive.booleanValue()) {
                        scopeChangeRemovedItems.computeIfAbsent(teamId, k -> new ArrayList());
                        items = scopeChangeRemovedItems.get(teamId);
                        if (items.contains(itemId)) continue;
                        items.add(itemId);
                        continue;
                    }
                    scopeChangeRemovedItems.computeIfAbsent(teamId, k -> new ArrayList());
                    items = scopeChangeRemovedItems.get(teamId);
                    if (items.contains(itemId)) continue;
                    items.add(itemId);
                    continue;
                }
                if (Objects.equals(firstTeamId, latestTeamId) && !latestArchive.booleanValue()) continue;
                scopeChangeRemovedItems.computeIfAbsent(teamId, k -> new ArrayList());
                items = scopeChangeRemovedItems.get(teamId);
                if (items.contains(itemId)) continue;
                items.add(itemId);
            }
        }
        long endTime5 = System.nanoTime();
        double elapsedTime5 = (double)(endTime5 - startTime5) / 1.0E9;
        LOGGER.debug("Scope Changed Removed Items in --> " + elapsedTime5 + " seconds");
        long startTime6 = System.nanoTime();
        HashMap updatesCommittedStoriesBeforeSprint = new HashMap();
        for (Map.Entry<String, List<String>> entry : committedStoriesBeforeSprint.entrySet()) {
            List updatedItems;
            String team4 = entry.getKey();
            List<String> committedItems = entry.getValue();
            if (!scopeChangeRemovedItems.isEmpty()) {
                if (scopeChangeRemovedItems.containsKey(team4)) {
                    List<String> removedItems = scopeChangeRemovedItems.get(team4);
                    List updatedItems2 = committedItems.stream().filter(item -> !removedItems.contains(item)).collect(Collectors.toList());
                    if (updatedItems2.isEmpty()) continue;
                    updatesCommittedStoriesBeforeSprint.put(team4, updatedItems2);
                    continue;
                }
                updatedItems = committedItems.stream().collect(Collectors.toList());
                if (updatedItems.isEmpty()) continue;
                updatesCommittedStoriesBeforeSprint.put(team4, updatedItems);
                continue;
            }
            updatedItems = committedItems.stream().collect(Collectors.toList());
            if (updatedItems.isEmpty()) continue;
            updatesCommittedStoriesBeforeSprint.put(team4, updatedItems);
        }
        long endTime6 = System.nanoTime();
        double elapsedTime6 = (double)(endTime6 - startTime6) / 1.0E9;
        LOGGER.debug("Process After Scope Remove in --> " + elapsedTime6 + " seconds");
        long startTime7 = System.nanoTime();
        BasicDBObject query4 = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("eventTime", (Object)new BasicDBObject("$lte", (Object)endDate)).append("changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds));
        DBCollection collectionCommitDelivered = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursorCommitDelivered = collectionCommitDelivered.find((DBObject)query4);
        HashSet<String> allItemIdsCommitDelivered = new HashSet<String>();
        while (cursorCommitDelivered.hasNext()) {
            BasicDBObject document = (BasicDBObject)cursorCommitDelivered.next();
            allItemIdsCommitDelivered.add(document.getString("itemId"));
        }
        for (Map.Entry entry : updatesCommittedStoriesBeforeSprint.entrySet()) {
            String teamTitle = (String)entry.getKey();
            List itemIds4 = (List)entry.getValue();
            for (String itemId : itemIds4) {
                if (!allItemIdsCommitDelivered.contains(itemId)) continue;
                deliveredCommittedStoriesBeforeSprint.computeIfAbsent(teamTitle, k -> new ArrayList());
                List<String> itemList = deliveredCommittedStoriesBeforeSprint.get(teamTitle);
                if (itemList.contains(itemId)) continue;
                itemList.add(itemId);
            }
        }
        long endTime7 = System.nanoTime();
        double elapsedTime7 = (double)(endTime7 - startTime7) / 1.0E9;
        LOGGER.debug("Delivered Committed Items in in --> " + elapsedTime7 + " seconds");
        long startTime8 = System.nanoTime();
        for (String team5 : scopeChangeAddedItems.keySet()) {
            ArrayList addedItems = new ArrayList(scopeChangeAddedItems.get(team5));
            if (scopeChangeRemovedItems.containsKey(team5)) {
                List<String> removedItems = scopeChangeRemovedItems.get(team5);
                addedItems.removeAll(removedItems);
            }
            if (addedItems.isEmpty()) continue;
            updatedScopeChangeAddedItems.put(team5, addedItems);
        }
        BasicDBObject query5 = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)).append("changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds));
        DBCollection collection5 = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursor5 = collection5.find((DBObject)query5);
        HashSet<String> allItemIds = new HashSet<String>();
        while (cursor5.hasNext()) {
            BasicDBObject document = (BasicDBObject)cursor5.next();
            allItemIds.add(document.getString("itemId"));
        }
        for (Map.Entry entry : updatedScopeChangeAddedItems.entrySet()) {
            String teamTitle = (String)entry.getKey();
            List itemIds5 = (List)entry.getValue();
            for (String itemId : itemIds5) {
                if (!allItemIds.contains(itemId)) continue;
                deliveredScopeChange.computeIfAbsent(teamTitle, k -> new ArrayList());
                List<String> itemList = deliveredScopeChange.get(teamTitle);
                if (itemList.contains(itemId)) continue;
                itemList.add(itemId);
            }
        }
        long endTime8 = System.nanoTime();
        double elapsedTime8 = (double)(endTime8 - startTime8) / 1.0E9;
        LOGGER.debug("Delivered Scope change Items in --> " + elapsedTime8 + " seconds");
        completedStories.put("scopeChangeAddedItems", scopeChangeAddedItems);
        completedStories.put("scopeChangeRemovedItems", scopeChangeRemovedItems);
        completedStories.put("deliveredScopeChange", deliveredScopeChange);
        completedStories.put("committedStoriesBeforeSprint", committedStoriesBeforeSprint);
        completedStories.put("deliveredCommittedStoriesBeforeSprint", deliveredCommittedStoriesBeforeSprint);
    }

    private void completedStoriesStoryPointsCalculation(Map<String, Object> tempCompletedStories, Map<String, String> teamIdAndNameList, String teamNameSprint, Object teamIdSprint, Object sessionBoardId, Object processedId, Date startDate, List<String> selectedIssueType, Map<String, String> teamAndLabelList, Map<String, String> teamAndColorList, Map<String, List<String>> committedStoriesBeforeSprint, Map<String, Map<String, Double>> committedStoriesBeforeSprintStoryPoints, Date endDate, Map<String, List<String>> scopeChangeAddedItems, Map<String, Map<String, Double>> scopeChangeAddedItemsStoryPoints, Map<String, List<String>> beforeSprintAndScopeChangeAddedCombined, Map<String, List<String>> scopeChangeRemovedItems, Map<String, Map<String, Double>> scopeChangeRemovedItemsStoryPoints, List<String> individualSelectedStatusIds, Map<String, List<String>> deliveredCommittedStoriesBeforeSprint, Map<String, Map<String, Double>> deliveredCommittedStoriesBeforeSprintStoryPoints, Map<String, List<String>> updatedScopeChangeAddedItems, Map<String, List<String>> deliveredScopeChange, Map<String, Map<String, Double>> deliveredScopeChangeStoryPoints, Map<String, Object> completedStories, Set<String> allTeams, Map<String, List> scopeChangeTeamItems, Map<String, Map<String, Double>> scopeChangeTeamItemsStoryPoints, Map<String, String> scopeChangeDelivered, Map<String, String> committedAndScopeChangeTotal, Map<String, Double> committedTeamsData, Map<String, Double> scopeChangeAdded, Map<String, Double> scopeChangeRemoved, Map<String, Double> scopeChangeDeliveredTracking, Map<String, Double> committedDeliveredTracking, Map<String, String> committedDelivered, Map<String, String> scopeChngeDelivered) {
        Object committedItems;
        String team;
        long startTime1 = System.nanoTime();
        BasicDBObject query = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("changes.teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers.container._id", processedId).append("teamContainers.team._id", teamIdSprint).append("eventTime", (Object)new BasicDBObject("$lte", (Object)startDate));
        DBCollection collection = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursor = collection.find((DBObject)query);
        ArrayList<String> itemIdsCommit = new ArrayList<String>();
        while (cursor.hasNext()) {
            DBObject document = cursor.next();
            String itemId = (String)document.get("itemId");
            itemIdsCommit.add(itemId);
        }
        Query itemQueryForCommit = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsCommit).and("archive").in(new Object[]{true, false}));
        itemQueryForCommit.fields().include("type").include("jiraIssueTypeId").include("tfsItemType").include("storyPoints");
        List itemsCommit = this.mongoTemplate.find(itemQueryForCommit, Item.class, "item");
        for (DBObject document : cursor) {
            BasicDBObject container;
            BasicDBObject team2;
            String itemId = (String)document.get("itemId");
            Item item2 = this.findItemById(itemsCommit, itemId);
            if (item2 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item2, selectedIssueType)) || !item2.getType().equals("UserStory")) continue;
            BasicDBList teamContainers = (BasicDBList)document.get("teamContainers");
            BasicDBObject lastTeamContainer = null;
            if (teamContainers == null || teamContainers.isEmpty() || (team2 = (BasicDBObject)(container = (lastTeamContainer = (BasicDBObject)teamContainers.get(teamContainers.size() - 1))).get("team")) == null) continue;
            String teamId = team2.getString("_id");
            Double storyPoint = item2.getStoryPoints();
            String teamTitle = teamId;
            committedStoriesBeforeSprint.computeIfAbsent(teamTitle, k -> new ArrayList());
            committedStoriesBeforeSprintStoryPoints.computeIfAbsent(teamTitle, k -> new HashMap());
            if (committedStoriesBeforeSprint.get(teamTitle).contains(itemId)) continue;
            committedStoriesBeforeSprint.get(teamTitle).add(itemId);
            committedStoriesBeforeSprintStoryPoints.get(teamTitle).put(itemId, storyPoint);
        }
        long endTime1 = System.nanoTime();
        double elapsedTime1 = (double)(endTime1 - startTime1) / 1.0E9;
        LOGGER.debug("Committed Items in --> " + elapsedTime1 + " seconds");
        long startTime2 = System.nanoTime();
        HashMap committedTempMap = new HashMap();
        for (Map.Entry<String, List<String>> entry : committedStoriesBeforeSprint.entrySet()) {
            committedTempMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        ArrayList<BasicDBObject> aggregationPipelineComitRemove = new ArrayList<BasicDBObject>();
        BasicDBObject matchStageComitRemove = new BasicDBObject("$match", (Object)new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("eventTime", (Object)new BasicDBObject("$lte", (Object)startDate)).append("$or", Arrays.asList(new BasicDBObject("changes.teamContainers", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("changes.archive", (Object)true))));
        aggregationPipelineComitRemove.add(matchStageComitRemove);
        BasicDBObject groupStageComitRemove = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("firstDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipelineComitRemove.add(groupStageComitRemove);
        DBCollection collection3CommitRemoval = this.mongoTemplate.getCollection("itemTimeSeries");
        AggregationOutput outputFirstDoc = collection3CommitRemoval.aggregate(aggregationPipelineComitRemove);
        HashMap<String, BasicDBObject> firstDocumentsMapComitRemove = new HashMap<String, BasicDBObject>();
        for (DBObject result : outputFirstDoc.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject firstDoc = (BasicDBObject)result.get("firstDocument");
            firstDocumentsMapComitRemove.put(itemId, firstDoc);
        }
        ArrayList<BasicDBObject> aggregationPipelineCommitRemoval2 = new ArrayList<BasicDBObject>();
        aggregationPipelineCommitRemoval2.add(matchStageComitRemove);
        BasicDBObject sortStageComitRemove = new BasicDBObject("$sort", (Object)new BasicDBObject("eventTime", (Object)-1));
        aggregationPipelineCommitRemoval2.add(sortStageComitRemove);
        BasicDBObject groupStage2CommitRemove = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("latestDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipelineCommitRemoval2.add(groupStage2CommitRemove);
        AggregationOutput output2CommitRemove = collection3CommitRemoval.aggregate(aggregationPipelineCommitRemoval2);
        HashMap<String, BasicDBObject> latestDocumentsMapComitRemove = new HashMap<String, BasicDBObject>();
        for (DBObject result : output2CommitRemove.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject latestDoc = (BasicDBObject)result.get("latestDocument");
            latestDocumentsMapComitRemove.put(itemId, latestDoc);
        }
        Set allItemIdsFromFirstDocumentComitRemove = firstDocumentsMapComitRemove.keySet();
        Query itemQueryDeliveredRemove = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(allItemIdsFromFirstDocumentComitRemove).and("archive").in(new Object[]{true, false}));
        itemQueryDeliveredRemove.fields().include("type").include("jiraIssueTypeId").include("tfsItemType");
        List itemsDeliveredRemoved = this.mongoTemplate.find(itemQueryDeliveredRemove, Item.class, "item");
        HashMap<String, Item> itemMapComitRemove = new HashMap<String, Item>();
        for (Item item2 : itemsDeliveredRemoved) {
            itemMapComitRemove.put(item2.getId().toString(), item2);
        }
        for (Map.Entry entry : committedTempMap.entrySet()) {
            String teamId = (String)entry.getKey();
            List itemIds2 = (List)entry.getValue();
            if (!teamId.equals(teamIdSprint.toString())) continue;
            for (String itemId : itemIds2) {
                Map<String, Double> storypointsMap;
                List<String> items;
                Item item4 = (Item)itemMapComitRemove.get(itemId);
                if (item4 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item4, selectedIssueType)) || !item4.getType().equals("UserStory")) continue;
                BasicDBObject firstDocument = (BasicDBObject)firstDocumentsMapComitRemove.get(itemId);
                BasicDBObject latestDocument = (BasicDBObject)latestDocumentsMapComitRemove.get(itemId);
                if (firstDocument == null || latestDocument == null) continue;
                String firstTeamId = this.extractTeamId(firstDocument);
                String firstContainerId = this.extractContainerIdFromTeamContainer(firstDocument);
                String latestTeamId = this.extractTeamId(latestDocument);
                String latestContainerId = this.extractContainerIdFromTeamContainer(latestDocument);
                Boolean latestArchive = this.extractArchiveStatus(latestDocument);
                if (Objects.equals(latestContainerId, processedId.toString()) && !latestArchive.booleanValue()) continue;
                if (!Objects.equals(firstContainerId, latestContainerId) || latestArchive.booleanValue()) {
                    if (!Objects.equals(firstTeamId, latestTeamId) || latestArchive.booleanValue()) {
                        committedStoriesBeforeSprint.computeIfAbsent(teamId, k -> new ArrayList());
                        items = committedStoriesBeforeSprint.get(teamId);
                        storypointsMap = committedStoriesBeforeSprintStoryPoints.get(teamId);
                        if (!items.contains(itemId)) continue;
                        items.remove(itemId);
                        storypointsMap.remove(itemId);
                        continue;
                    }
                    committedStoriesBeforeSprint.computeIfAbsent(teamId, k -> new ArrayList());
                    items = committedStoriesBeforeSprint.get(teamId);
                    storypointsMap = committedStoriesBeforeSprintStoryPoints.get(teamId);
                    if (!items.contains(itemId)) continue;
                    items.remove(itemId);
                    storypointsMap.remove(itemId);
                    continue;
                }
                if (Objects.equals(firstTeamId, latestTeamId) && !latestArchive.booleanValue()) continue;
                committedStoriesBeforeSprint.computeIfAbsent(teamId, k -> new ArrayList());
                items = committedStoriesBeforeSprint.get(teamId);
                storypointsMap = committedStoriesBeforeSprintStoryPoints.get(teamId);
                if (!items.contains(itemId)) continue;
                items.remove(itemId);
                storypointsMap.remove(itemId);
            }
        }
        long endTime2 = System.nanoTime();
        double elapsedTime2 = (double)(endTime2 - startTime2) / 1.0E9;
        LOGGER.debug("committed removed Items in --> " + elapsedTime2 + " seconds");
        long startTime3 = System.nanoTime();
        BasicDBObject query2 = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers.container._id", processedId).append("teamContainers.team._id", teamIdSprint).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate));
        DBCollection collection2 = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursor2 = collection2.find((DBObject)query2);
        ArrayList<String> itemIdsForScopeAdded = new ArrayList<String>();
        while (cursor2.hasNext()) {
            DBObject document = cursor2.next();
            String itemId = (String)document.get("itemId");
            itemIdsForScopeAdded.add(itemId);
        }
        Query itemQueryScopeAdded = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(itemIdsForScopeAdded).and("archive").in(new Object[]{true, false}));
        itemQueryScopeAdded.fields().include("type").include("jiraIssueTypeId").include("tfsItemType").include("storyPoints");
        List itemsForScopeAdded = this.mongoTemplate.find(itemQueryScopeAdded, Item.class, "item");
        for (DBObject document : cursor2) {
            String teamId;
            Iterator<Map.Entry<String, Object>> container;
            BasicDBObject basicDBObject;
            String itemId = (String)document.get("itemId");
            Item item5 = this.findItemById(itemsForScopeAdded, itemId);
            if (item5 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item5, selectedIssueType)) || !item5.getType().equals("UserStory")) continue;
            BasicDBList teamContainers = (BasicDBList)document.get("teamContainers");
            BasicDBObject lastTeamContainer = null;
            if (teamContainers == null || teamContainers.isEmpty() || (basicDBObject = (BasicDBObject)(container = (lastTeamContainer = (BasicDBObject)teamContainers.get(teamContainers.size() - 1))).get("team")) == null) continue;
            String teamTitle = teamId = basicDBObject.getString("_id");
            Double storyPoint = item5.getStoryPoints();
            scopeChangeAddedItems.computeIfAbsent(teamTitle, k -> new ArrayList());
            scopeChangeAddedItemsStoryPoints.computeIfAbsent(teamTitle, k -> new HashMap());
            if (scopeChangeAddedItems.get(teamTitle).contains(itemId)) continue;
            scopeChangeAddedItems.get(teamTitle).add(itemId);
            scopeChangeAddedItemsStoryPoints.computeIfAbsent(teamTitle, k -> new HashMap()).put(itemId, storyPoint);
        }
        long endTime3 = System.nanoTime();
        double elapsedTime3 = (double)(endTime3 - startTime3) / 1.0E9;
        LOGGER.debug("Scope Change Added Items in --> " + elapsedTime3 + " seconds");
        long startTime4 = System.nanoTime();
        for (Map.Entry<String, List<String>> entry : committedStoriesBeforeSprint.entrySet()) {
            team = entry.getKey();
            committedItems = entry.getValue();
            if (!scopeChangeAddedItems.containsKey(team)) continue;
            scopeChangeAddedItems.get(team).removeAll((Collection<?>)committedItems);
        }
        for (Map.Entry<String, Object> entry : committedStoriesBeforeSprintStoryPoints.entrySet()) {
            team = entry.getKey();
            committedItems = (Map)entry.getValue();
            if (!scopeChangeAddedItemsStoryPoints.containsKey(team)) continue;
            for (String itemId : committedItems.keySet()) {
                scopeChangeAddedItemsStoryPoints.get(team).remove(itemId);
            }
            if (!scopeChangeAddedItemsStoryPoints.get(team).isEmpty()) continue;
            scopeChangeAddedItemsStoryPoints.remove(team);
        }
        for (Map.Entry<String, Object> entry : committedStoriesBeforeSprint.entrySet()) {
            team = entry.getKey();
            beforeSprintAndScopeChangeAddedCombined.putIfAbsent(team, new ArrayList());
            for (String item6 : (List)entry.getValue()) {
                if (beforeSprintAndScopeChangeAddedCombined.get(team).contains(item6)) continue;
                beforeSprintAndScopeChangeAddedCombined.get(team).add(item6);
            }
        }
        for (Map.Entry<String, Object> entry : scopeChangeAddedItems.entrySet()) {
            team = entry.getKey();
            beforeSprintAndScopeChangeAddedCombined.putIfAbsent(team, new ArrayList());
            for (String item3 : (List)entry.getValue()) {
                if (beforeSprintAndScopeChangeAddedCombined.get(team).contains(item3)) continue;
                beforeSprintAndScopeChangeAddedCombined.get(team).add(item3);
            }
        }
        long endTime4 = System.nanoTime();
        double elapsedTime4 = (double)(endTime4 - startTime4) / 1.0E9;
        LOGGER.debug("Process After scope added Items in --> " + elapsedTime4 + " seconds");
        long startTime5 = System.nanoTime();
        ArrayList itemIdsList = new ArrayList();
        beforeSprintAndScopeChangeAddedCombined.values().forEach(itemIds -> itemIdsList.addAll(itemIds));
        ArrayList<BasicDBObject> aggregationPipeline = new ArrayList<BasicDBObject>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("itemId", (Object)new BasicDBObject("$in", itemIdsList)).append("teamContainers", (Object)new BasicDBObject("$exists", (Object)true)).append("teamContainers.container._id", processedId).append("teamContainers.team._id", teamIdSprint).append("eventTime", (Object)new BasicDBObject("$lte", (Object)endDate)));
        aggregationPipeline.add(matchStage);
        BasicDBObject groupStage = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("firstDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipeline.add(groupStage);
        DBCollection collection3 = this.mongoTemplate.getCollection("itemTimeSeries");
        AggregationOutput output = collection3.aggregate(aggregationPipeline);
        HashMap<String, BasicDBObject> firstDocumentsMap = new HashMap<String, BasicDBObject>();
        for (DBObject result : output.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject firstDoc = (BasicDBObject)result.get("firstDocument");
            firstDocumentsMap.put(itemId, firstDoc);
        }
        BasicDBObject matchStage2 = new BasicDBObject("$match", (Object)new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("itemId", (Object)new BasicDBObject("$in", itemIdsList)).append("$or", Arrays.asList(new BasicDBObject("changes.teamContainers", (Object)new BasicDBObject("$exists", (Object)true)), new BasicDBObject("changes.archive", (Object)true))).append("eventTime", (Object)new BasicDBObject("$lte", (Object)endDate)));
        ArrayList<BasicDBObject> aggregationPipeline2 = new ArrayList<BasicDBObject>();
        aggregationPipeline2.add(matchStage2);
        BasicDBObject sortStage = new BasicDBObject("$sort", (Object)new BasicDBObject("eventTime", (Object)-1));
        aggregationPipeline2.add(sortStage);
        BasicDBObject groupStage2 = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("latestDocument", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        aggregationPipeline2.add(groupStage2);
        AggregationOutput output2 = collection3.aggregate(aggregationPipeline2);
        HashMap<String, BasicDBObject> latestDocumentsMap = new HashMap<String, BasicDBObject>();
        for (DBObject result : output2.results()) {
            String itemId = (String)result.get("_id");
            BasicDBObject latestDoc = (BasicDBObject)result.get("latestDocument");
            latestDocumentsMap.put(itemId, latestDoc);
        }
        Set allItemIdsFromFirstDocument = firstDocumentsMap.keySet();
        Query itemQueryDelivered = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(allItemIdsFromFirstDocument).and("archive").in(new Object[]{true, false}));
        itemQueryDelivered.fields().include("type").include("jiraIssueTypeId").include("tfsItemType").include("storyPoints");
        List itemsDelivered = this.mongoTemplate.find(itemQueryDelivered, Item.class, "item");
        HashMap<String, Item> itemMap = new HashMap<String, Item>();
        for (Item item4 : itemsDelivered) {
            itemMap.put(item4.getId().toString(), item4);
        }
        for (Map.Entry entry : beforeSprintAndScopeChangeAddedCombined.entrySet()) {
            String teamId = (String)entry.getKey();
            List itemIds3 = (List)entry.getValue();
            if (!teamId.equals(teamIdSprint.toString())) continue;
            for (String itemId : itemIds3) {
                List<String> items;
                Item item8 = (Item)itemMap.get(itemId);
                if (item8 == null || selectedIssueType != null && !selectedIssueType.isEmpty() && (selectedIssueType.isEmpty() || !this.isValidIssueTypes(item8, selectedIssueType)) || !item8.getType().equals("UserStory")) continue;
                BasicDBObject firstDocument = (BasicDBObject)firstDocumentsMap.get(itemId);
                BasicDBObject latestDocument = (BasicDBObject)latestDocumentsMap.get(itemId);
                if (firstDocument == null || latestDocument == null) continue;
                String firstTeamId = this.extractTeamId(firstDocument);
                String firstContainerId = this.extractContainerIdFromTeamContainer(firstDocument);
                Double storyPoint = item8.getStoryPoints();
                String latestTeamId = this.extractTeamId(latestDocument);
                String latestContainerId = this.extractContainerIdFromTeamContainer(latestDocument);
                Boolean latestArchive = this.extractArchiveStatus(latestDocument);
                if (!Objects.equals(firstContainerId, latestContainerId) || latestArchive.booleanValue()) {
                    if (!Objects.equals(firstTeamId, latestTeamId) || latestArchive.booleanValue()) {
                        scopeChangeRemovedItems.computeIfAbsent(teamId, k -> new ArrayList());
                        items = scopeChangeRemovedItems.get(teamId);
                        scopeChangeRemovedItemsStoryPoints.computeIfAbsent(teamId, k -> new HashMap());
                        if (items.contains(itemId)) continue;
                        items.add(itemId);
                        scopeChangeRemovedItemsStoryPoints.computeIfAbsent(teamId, k -> new HashMap()).put(itemId, storyPoint);
                        continue;
                    }
                    scopeChangeRemovedItems.computeIfAbsent(teamId, k -> new ArrayList());
                    items = scopeChangeRemovedItems.get(teamId);
                    scopeChangeRemovedItemsStoryPoints.computeIfAbsent(teamId, k -> new HashMap());
                    if (items.contains(itemId)) continue;
                    items.add(itemId);
                    scopeChangeRemovedItemsStoryPoints.computeIfAbsent(teamId, k -> new HashMap()).put(itemId, storyPoint);
                    continue;
                }
                if (Objects.equals(firstTeamId, latestTeamId) && !latestArchive.booleanValue()) continue;
                scopeChangeRemovedItems.computeIfAbsent(teamId, k -> new ArrayList());
                items = scopeChangeRemovedItems.get(teamId);
                scopeChangeRemovedItemsStoryPoints.computeIfAbsent(teamId, k -> new HashMap());
                if (items.contains(itemId)) continue;
                items.add(itemId);
                scopeChangeRemovedItemsStoryPoints.computeIfAbsent(teamId, k -> new HashMap()).put(itemId, storyPoint);
            }
        }
        long endTime5 = System.nanoTime();
        double elapsedTime5 = (double)(endTime5 - startTime5) / 1.0E9;
        LOGGER.debug("scope change removed Items in --> " + elapsedTime5 + " seconds");
        long startTime6 = System.nanoTime();
        HashMap updatesCommittedStoriesBeforeSprint = new HashMap();
        for (Map.Entry<String, List<String>> entry : committedStoriesBeforeSprint.entrySet()) {
            List updatedItems;
            String team4 = entry.getKey();
            List<String> committedItems2 = entry.getValue();
            if (!scopeChangeRemovedItems.isEmpty()) {
                if (scopeChangeRemovedItems.containsKey(team4)) {
                    List<String> removedItems = scopeChangeRemovedItems.get(team4);
                    List updatedItems2 = committedItems2.stream().filter(item -> !removedItems.contains(item)).collect(Collectors.toList());
                    if (updatedItems2.isEmpty()) continue;
                    updatesCommittedStoriesBeforeSprint.put(team4, updatedItems2);
                    continue;
                }
                updatedItems = committedItems2.stream().collect(Collectors.toList());
                if (updatedItems.isEmpty()) continue;
                updatesCommittedStoriesBeforeSprint.put(team4, updatedItems);
                continue;
            }
            updatedItems = committedItems2.stream().collect(Collectors.toList());
            if (updatedItems.isEmpty()) continue;
            updatesCommittedStoriesBeforeSprint.put(team4, updatedItems);
        }
        long endTime6 = System.nanoTime();
        double elapsedTime6 = (double)(endTime6 - startTime6) / 1.0E9;
        LOGGER.debug("Process After scope removed Items in --> " + elapsedTime6 + " seconds");
        long startTime7 = System.nanoTime();
        BasicDBObject query4 = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("eventTime", (Object)new BasicDBObject("$lte", (Object)endDate)).append("changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds));
        DBCollection collectionCommitDelivered = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursorCommitDelivered = collectionCommitDelivered.find((DBObject)query4);
        HashSet<String> allItemIdsCommitDelivered = new HashSet<String>();
        while (cursorCommitDelivered.hasNext()) {
            BasicDBObject document = (BasicDBObject)cursorCommitDelivered.next();
            allItemIdsCommitDelivered.add(document.getString("itemId"));
        }
        Query itemQueryyCommitDelivered = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(allItemIdsCommitDelivered).and("archive").in(new Object[]{true, false}));
        itemQueryyCommitDelivered.fields().include("storyPoints");
        List itemsCommitDelivered = this.mongoTemplate.find(itemQueryyCommitDelivered, Item.class, "item");
        HashMap<String, Item> itemMapForCommitDelivered = new HashMap<String, Item>();
        for (Item item5 : itemsCommitDelivered) {
            itemMapForCommitDelivered.put(item5.getId().toString(), item5);
        }
        for (Map.Entry entry : updatesCommittedStoriesBeforeSprint.entrySet()) {
            String teamTitle = (String)entry.getKey();
            List itemIds4 = (List)entry.getValue();
            for (String itemId : itemIds4) {
                Item item10;
                if (!allItemIdsCommitDelivered.contains(itemId) || (item10 = (Item)itemMapForCommitDelivered.get(itemId)) == null) continue;
                Double storyPoint = item10.getStoryPoints();
                deliveredCommittedStoriesBeforeSprint.computeIfAbsent(teamTitle, k -> new ArrayList());
                deliveredCommittedStoriesBeforeSprintStoryPoints.computeIfAbsent(teamTitle, k -> new HashMap());
                List<String> itemList = deliveredCommittedStoriesBeforeSprint.get(teamTitle);
                if (itemList.contains(itemId)) continue;
                itemList.add(itemId);
                deliveredCommittedStoriesBeforeSprintStoryPoints.get(teamTitle).put(itemId, storyPoint);
            }
        }
        long endTime7 = System.nanoTime();
        double elapsedTime7 = (double)(endTime7 - startTime7) / 1.0E9;
        LOGGER.debug("delivered Committed Items in --> " + elapsedTime7 + " seconds");
        long startTime8 = System.nanoTime();
        for (String team5 : scopeChangeAddedItems.keySet()) {
            ArrayList addedItems = new ArrayList(scopeChangeAddedItems.get(team5));
            if (scopeChangeRemovedItems.containsKey(team5)) {
                List<String> removedItems = scopeChangeRemovedItems.get(team5);
                addedItems.removeAll(removedItems);
            }
            if (addedItems.isEmpty()) continue;
            updatedScopeChangeAddedItems.put(team5, addedItems);
        }
        BasicDBObject query5 = new BasicDBObject().append("meta.sessionBoardId", sessionBoardId).append("eventTime", (Object)new BasicDBObject("$gte", (Object)startDate).append("$lte", (Object)endDate)).append("changes.status.id", (Object)new BasicDBObject("$in", individualSelectedStatusIds));
        DBCollection collection5 = this.mongoTemplate.getCollection("itemTimeSeries");
        DBCursor cursor5 = collection5.find((DBObject)query5);
        HashSet<String> allItemIds = new HashSet<String>();
        while (cursor5.hasNext()) {
            BasicDBObject document = (BasicDBObject)cursor5.next();
            allItemIds.add(document.getString("itemId"));
        }
        Query itemQueryy = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(allItemIds).and("archive").in(new Object[]{true, false}));
        itemQueryy.fields().include("storyPoints");
        List items = this.mongoTemplate.find(itemQueryy, Item.class, "item");
        HashMap<String, Item> itemMapForScopeDelivered = new HashMap<String, Item>();
        for (Item item6 : items) {
            itemMapForScopeDelivered.put(item6.getId().toString(), item6);
        }
        for (Map.Entry entry : updatedScopeChangeAddedItems.entrySet()) {
            String teamTitle = (String)entry.getKey();
            List itemIds5 = (List)entry.getValue();
            for (String itemId : itemIds5) {
                Item item12;
                if (!allItemIds.contains(itemId) || (item12 = (Item)itemMapForScopeDelivered.get(itemId)) == null) continue;
                Double storyPoint = item12.getStoryPoints();
                deliveredScopeChange.computeIfAbsent(teamTitle, k -> new ArrayList());
                deliveredScopeChangeStoryPoints.computeIfAbsent(teamTitle, k -> new HashMap());
                List<String> itemList = deliveredScopeChange.get(teamTitle);
                if (itemList.contains(itemId)) continue;
                itemList.add(itemId);
                deliveredScopeChangeStoryPoints.get(teamTitle).put(itemId, storyPoint);
            }
        }
        long endTime8 = System.nanoTime();
        double elapsedTime8 = (double)(endTime8 - startTime8) / 1.0E9;
        LOGGER.debug("delivered scope change Items in --> " + elapsedTime8 + " seconds");
        completedStories.put("scopeChangeAddedItems", scopeChangeAddedItems);
        completedStories.put("scopeChangeRemovedItems", scopeChangeRemovedItems);
        completedStories.put("deliveredScopeChange", deliveredScopeChange);
        completedStories.put("committedStoriesBeforeSprint", committedStoriesBeforeSprint);
        completedStories.put("deliveredCommittedStoriesBeforeSprint", deliveredCommittedStoriesBeforeSprint);
    }

    private void itemStoryPointsTrackingComputationCompletedStories(Map<String, List<String>> committedStoriesBeforeSprint, Map<String, List<String>> deliveredCommittedStoriesBeforeSprint, Map<String, List<String>> scopeChangeRemovedItems, Map<String, List<String>> scopeChangeAddedItems, Map<String, List<String>> deliveredScopeChange, Map<String, Object> tempCompletedStories, Map<String, String> teamIdAndNameList, Map<String, String> teamAndLabelList, Map<String, String> teamAndColorList, Map<String, Map<String, Double>> committedStoriesBeforeSprintStoryPoints, Map<String, Map<String, Double>> scopeChangeAddedItemsStoryPoints, Map<String, Map<String, Double>> scopeChangeRemovedItemsStoryPoints, Map<String, Map<String, Double>> deliveredCommittedStoriesBeforeSprintStoryPoints, Map<String, Map<String, Double>> deliveredScopeChangeStoryPoints, Map<String, Object> completedStories, Set<String> allTeams, Map<String, List> scopeChangeTeamItems, Map<String, Map<String, Double>> scopeChangeTeamItemsStoryPoints, Map<String, String> scopeChangeDelivered, Map<String, String> committedAndScopeChangeTotal, Map<String, Double> committedTeamsData, Map<String, Double> scopeChangeAdded, Map<String, Double> scopeChangeRemoved, Map<String, Double> scopeChangeDeliveredTracking, Map<String, Double> committedDeliveredTracking, Map<String, String> committedDelivered, Map<String, String> scopeChngeDelivered) {
        String teamName;
        Object teamId;
        HashMap<String, Object> newNestedMap;
        Map nestedMap;
        Object nestedMapObject;
        String outerKey;
        tempCompletedStories.put("scopeChangeAddedItemsStoryPoints", scopeChangeAddedItemsStoryPoints);
        tempCompletedStories.put("scopeChangeRemovedItemsStoryPoints", scopeChangeRemovedItemsStoryPoints);
        tempCompletedStories.put("deliveredScopeChangeStoryPoints", deliveredScopeChangeStoryPoints);
        tempCompletedStories.put("committedStoriesBeforeSprintStoryPoints", committedStoriesBeforeSprintStoryPoints);
        tempCompletedStories.put("deliveredCommittedStoriesBeforeSprintStoryPoints", deliveredCommittedStoriesBeforeSprintStoryPoints);
        for (Map.Entry<String, Object> entry : completedStories.entrySet()) {
            outerKey = entry.getKey();
            nestedMapObject = entry.getValue();
            if (!(nestedMapObject instanceof Map)) continue;
            nestedMap = (Map)nestedMapObject;
            allTeams.addAll(nestedMap.keySet());
        }
        for (String string : allTeams) {
            Query teamQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(string)));
            teamQuery.fields().include("title").include("color").include("label");
            Team teamEntity = (Team)this.mongoTemplate.findOne(teamQuery, Team.class, "team");
            if (teamEntity != null) {
                String title = teamEntity.getTitle();
                String color = teamEntity.getColor();
                String label = teamEntity.getLabel();
                teamAndColorList.putIfAbsent(title, color);
                teamAndLabelList.putIfAbsent(title, label);
                teamIdAndNameList.putIfAbsent(string, title);
                continue;
            }
            System.out.println("No team found for teamId: " + string);
        }
        for (Map.Entry entry : completedStories.entrySet()) {
            outerKey = (String)entry.getKey();
            nestedMapObject = entry.getValue();
            if (!(nestedMapObject instanceof Map)) continue;
            nestedMap = (Map)nestedMapObject;
            newNestedMap = new HashMap<String, Object>();
            for (Map.Entry entry2 : nestedMap.entrySet()) {
                teamId = (String)entry2.getKey();
                List storyList = (List)entry2.getValue();
                if (teamIdAndNameList.containsKey(teamId)) {
                    teamName = teamIdAndNameList.get(teamId);
                    newNestedMap.put(teamName, storyList);
                    continue;
                }
                newNestedMap.put((String)teamId, storyList);
            }
            completedStories.put(outerKey, newNestedMap);
        }
        for (Map.Entry entry : tempCompletedStories.entrySet()) {
            outerKey = (String)entry.getKey();
            nestedMapObject = entry.getValue();
            if (!(nestedMapObject instanceof Map)) continue;
            nestedMap = (Map)nestedMapObject;
            newNestedMap = new HashMap();
            for (Map.Entry entry3 : nestedMap.entrySet()) {
                teamId = (String)entry3.getKey();
                Map itemStoryPoints = (Map)entry3.getValue();
                if (teamIdAndNameList.containsKey(teamId)) {
                    teamName = teamIdAndNameList.get(teamId);
                    newNestedMap.put(teamName, itemStoryPoints);
                    continue;
                }
                newNestedMap.put((String)teamId, itemStoryPoints);
            }
            tempCompletedStories.put(outerKey, newNestedMap);
        }
        scopeChangeAddedItems = null;
        scopeChangeAddedItems = (Map)completedStories.get("scopeChangeAddedItems");
        scopeChangeRemovedItems = null;
        scopeChangeRemovedItems = (Map)completedStories.get("scopeChangeRemovedItems");
        deliveredScopeChange = null;
        deliveredScopeChange = (Map)completedStories.get("deliveredScopeChange");
        committedStoriesBeforeSprint = null;
        committedStoriesBeforeSprint = (Map)completedStories.get("committedStoriesBeforeSprint");
        deliveredCommittedStoriesBeforeSprint = null;
        deliveredCommittedStoriesBeforeSprint = (Map)completedStories.get("deliveredCommittedStoriesBeforeSprint");
        scopeChangeAddedItemsStoryPoints = null;
        scopeChangeAddedItemsStoryPoints = (Map)tempCompletedStories.get("scopeChangeAddedItemsStoryPoints");
        scopeChangeRemovedItemsStoryPoints = null;
        scopeChangeRemovedItemsStoryPoints = (Map)tempCompletedStories.get("scopeChangeRemovedItemsStoryPoints");
        deliveredScopeChangeStoryPoints = null;
        deliveredScopeChangeStoryPoints = (Map)tempCompletedStories.get("deliveredScopeChangeStoryPoints");
        committedStoriesBeforeSprintStoryPoints = null;
        committedStoriesBeforeSprintStoryPoints = (Map)tempCompletedStories.get("committedStoriesBeforeSprintStoryPoints");
        deliveredCommittedStoriesBeforeSprintStoryPoints = null;
        deliveredCommittedStoriesBeforeSprintStoryPoints = (Map)tempCompletedStories.get("deliveredCommittedStoriesBeforeSprintStoryPoints");
        HashSet<String> updatedTeams = new HashSet<String>();
        for (String teamId3 : allTeams) {
            if (teamIdAndNameList.containsKey(teamId3)) {
                String teamName2 = teamIdAndNameList.get(teamId3);
                updatedTeams.add(teamName2);
                continue;
            }
            updatedTeams.add(teamId3);
        }
        allTeams.clear();
        allTeams.addAll(updatedTeams);
        for (String team : allTeams) {
            Map addedItemsStoryPoints = scopeChangeAddedItemsStoryPoints.getOrDefault(team, new HashMap());
            List addedItems = scopeChangeAddedItems.getOrDefault(team, new ArrayList());
            List removedItems = scopeChangeRemovedItems.getOrDefault(team, new ArrayList());
            HashMap filteredStoryPoints = new HashMap();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String item : addedItems) {
                if (removedItems.contains(item)) continue;
                arrayList.add(item);
                filteredStoryPoints.put(item, addedItemsStoryPoints.get(item));
            }
            scopeChangeTeamItems.put(team, arrayList);
            scopeChangeTeamItemsStoryPoints.put(team, filteredStoryPoints);
        }
        for (String team : allTeams) {
            Map committedScopeChangeStories = scopeChangeTeamItemsStoryPoints.getOrDefault(team, new HashMap());
            Map deliveredScopeChangeStories = deliveredScopeChangeStoryPoints.getOrDefault(team, new HashMap());
            double totalScopeChangeCommitted = committedScopeChangeStories.values().stream().mapToDouble(Double::doubleValue).sum();
            double d = deliveredScopeChangeStories.values().stream().mapToDouble(Double::doubleValue).sum();
            String delivered = d + "/" + totalScopeChangeCommitted;
            scopeChangeDelivered.put(team, delivered);
        }
        for (String team : allTeams) {
            double totalStoryPoints;
            Map storyPointsMap;
            Map committedStories = committedStoriesBeforeSprintStoryPoints.getOrDefault(team, new HashMap());
            Map deliveredStories = deliveredCommittedStoriesBeforeSprintStoryPoints.getOrDefault(team, new HashMap());
            Map committedScopeChangeStories = scopeChangeTeamItemsStoryPoints.getOrDefault(team, new HashMap());
            Map committedScopeChangeAddedStories = scopeChangeAddedItemsStoryPoints.getOrDefault(team, new HashMap());
            Map map = deliveredScopeChangeStoryPoints.getOrDefault(team, new HashMap());
            Map removedScopeChangeItems = scopeChangeRemovedItemsStoryPoints.getOrDefault(team, new HashMap());
            double totalScopeChangeCommitted = committedScopeChangeStories.values().stream().mapToDouble(Double::doubleValue).sum();
            double totalAddedScopeChangeCommittedItems = committedScopeChangeAddedStories.values().stream().mapToDouble(Double::doubleValue).sum();
            double totalScopeChangeDelivered = map.values().stream().mapToDouble(Double::doubleValue).sum();
            double totalScopeChangeRemovedDelivered = removedScopeChangeItems.values().stream().mapToDouble(Double::doubleValue).sum();
            double totalCommitted = committedStories.values().stream().mapToDouble(Double::doubleValue).sum();
            double totalDelivered = deliveredStories.values().stream().mapToDouble(Double::doubleValue).sum();
            String deliveredWithChange = totalDelivered + totalScopeChangeDelivered + "/" + (totalScopeChangeCommitted + totalCommitted);
            String delivered = totalDelivered + "/" + totalCommitted;
            String scopeChgDelivered = totalScopeChangeDelivered + "/" + totalScopeChangeCommitted;
            double percentage = totalCommitted > 0.0 ? totalDelivered / totalCommitted * 100.0 : 0.0;
            double totalItemCompleted = totalDelivered + totalScopeChangeDelivered;
            double totalItemsCommittedAndScopeChange = totalAddedScopeChangeCommittedItems + totalCommitted - totalScopeChangeRemovedDelivered;
            double percentageWithChange = totalItemCompleted > 0.0 ? totalItemCompleted / totalItemsCommittedAndScopeChange * 100.0 : 0.0;
            committedAndScopeChangeTotal.put(team, deliveredWithChange);
            if (committedStoriesBeforeSprintStoryPoints.containsKey(team)) {
                storyPointsMap = (Map)committedStoriesBeforeSprintStoryPoints.get(team);
                totalStoryPoints = storyPointsMap.values().stream().mapToDouble(Double::doubleValue).sum();
                committedTeamsData.put(team, totalStoryPoints);
            } else {
                committedTeamsData.put(team, 0.0);
            }
            if (scopeChangeAddedItemsStoryPoints.containsKey(team)) {
                storyPointsMap = (Map)scopeChangeAddedItemsStoryPoints.get(team);
                totalStoryPoints = storyPointsMap.values().stream().mapToDouble(Double::doubleValue).sum();
                scopeChangeAdded.put(team, totalStoryPoints);
            } else {
                scopeChangeAdded.put(team, 0.0);
            }
            if (scopeChangeRemovedItemsStoryPoints.containsKey(team)) {
                storyPointsMap = (Map)scopeChangeRemovedItemsStoryPoints.get(team);
                totalStoryPoints = storyPointsMap.values().stream().mapToDouble(Double::doubleValue).sum();
                scopeChangeRemoved.put(team, totalStoryPoints);
            } else {
                scopeChangeRemoved.put(team, 0.0);
            }
            scopeChangeDeliveredTracking.put(team, percentageWithChange);
            committedDeliveredTracking.put(team, percentage);
            committedDelivered.put(team, delivered);
            scopeChngeDelivered.put(team, scopeChgDelivered);
        }
        completedStories.put("committedDeliveredTracking", committedDeliveredTracking);
        completedStories.put("teamAndColorList", teamAndColorList);
        completedStories.put("teamAndLabelList", teamAndLabelList);
        completedStories.put("committedDelivered", committedDelivered);
        completedStories.put("committedAndScopeChangeTotal", committedAndScopeChangeTotal);
        completedStories.put("scopeChangeDeliveredTracking", scopeChangeDeliveredTracking);
        completedStories.put("scopeChngeDelivered", scopeChngeDelivered);
        completedStories.put("scopeChangeRemoved", scopeChangeRemoved);
        completedStories.put("scopeChangeAdded", scopeChangeAdded);
        completedStories.put("committedTeamsData", committedTeamsData);
        completedStories.put("teams", allTeams);
    }

    private Date convertStringToDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        try {
            Date parsedDate = formatter.parse(dateString);
            return parsedDate;
        }
        catch (ParseException e) {
            System.out.println("Error parsing date: " + e.getMessage());
            return null;
        }
    }

    private String extractEventTime(BasicDBObject document) {
        if (document.containsKey("eventTime")) {
            return document.getString("eventTime");
        }
        return null;
    }

    private Boolean extractArchiveStatus(BasicDBObject document) {
        BasicDBObject changes;
        if (document.containsField("changes") && (changes = (BasicDBObject)document.get("changes")).containsField("archive")) {
            return changes.getBoolean("archive");
        }
        return false;
    }

    private String extractTeamId(BasicDBObject document) {
        BasicDBObject container;
        BasicDBObject team;
        BasicDBList teamContainers = (BasicDBList)document.get("teamContainers");
        if (teamContainers != null && !teamContainers.isEmpty() && (team = (BasicDBObject)(container = (BasicDBObject)teamContainers.get(0)).get("team")) != null) {
            return team.getString("_id");
        }
        return null;
    }

    private String extractContainerIdFromTeamContainer(BasicDBObject document) {
        BasicDBObject lastContainer;
        BasicDBObject container;
        BasicDBList teamContainers;
        if (document.get("teamContainers") instanceof BasicDBList && (teamContainers = (BasicDBList)document.get("teamContainers")) != null && !teamContainers.isEmpty() && (container = (BasicDBObject)(lastContainer = (BasicDBObject)teamContainers.get(teamContainers.size() - 1)).get("container")) != null) {
            Object idValue = container.get("_id");
            if (idValue instanceof ObjectId) {
                return ((ObjectId)idValue).toHexString();
            }
            if (idValue instanceof String) {
                return (String)idValue;
            }
        }
        return null;
    }

    private String extractContainerId(BasicDBObject document) {
        BasicDBList teamContainers = (BasicDBList)document.get("teamContainers");
        if (teamContainers != null && !teamContainers.isEmpty()) {
            BasicDBObject container = (BasicDBObject)teamContainers.get(0);
            return container.getString("_id");
        }
        return null;
    }

    private boolean isValidIssueTypes(Item item, List<String> selectedIssueType) {
        if (item != null) {
            if (item.getJiraIssueTypeId() != null && selectedIssueType.contains(item.getJiraIssueTypeId())) {
                return true;
            }
            if (item.getTfsItemType() != null && selectedIssueType.contains(item.getTfsItemType())) {
                return true;
            }
            return selectedIssueType.contains("Kendis Only") && item.getJiraIssueTypeId() == null && item.getTfsItemType() == null;
        }
        return false;
    }

    public List<Map<String, String>> fetchGroupBySubOptions(Map<String, String> requestMap) {
        block25: {
            try {
                String groupBy = requestMap.get("groupBy");
                String boardId = requestMap.get("boardId");
                if ("teams".equals(groupBy)) {
                    Query teamsQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(boardId)));
                    teamsQuery.fields().include("teams");
                    SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(teamsQuery, SessionBoard.class);
                    if (sessionBoard != null) {
                        List teams = sessionBoard.getTeams();
                        ArrayList<Map<String, String>> teamOptions = new ArrayList<Map<String, String>>();
                        for (Team team : teams) {
                            HashMap<String, String> teamOption = new HashMap<String, String>();
                            teamOption.put("id", team.getId());
                            teamOption.put("title", team.getTitle());
                            teamOptions.add(teamOption);
                        }
                        return teamOptions;
                    }
                    break block25;
                }
                if ("cardType".equals(groupBy)) {
                    List<IssueType> cardTypes = new ArrayList();
                    cardTypes = this.mongoTemplate.findAll(IssueType.class);
                    IssueType feature = new IssueType();
                    feature.setId("feature");
                    feature.setTitle("Feature");
                    cardTypes.add(feature);
                    ArrayList<Map<String, String>> cardTypeOptions = new ArrayList<Map<String, String>>();
                    for (IssueType cardType : cardTypes) {
                        HashMap<String, String> cardTypeOption = new HashMap<String, String>();
                        cardTypeOption.put("id", cardType.getId());
                        cardTypeOption.put("title", cardType.getTitle());
                        cardTypeOptions.add(cardTypeOption);
                    }
                    return cardTypeOptions;
                }
                if ("plannedUnplanned".equals(groupBy)) {
                    ArrayList<Map<String, String>> plannedUnplannedOptions = new ArrayList<Map<String, String>>();
                    HashMap<String, String> plannedOption = new HashMap<String, String>();
                    plannedOption.put("id", "planned");
                    plannedOption.put("title", "Planned");
                    plannedUnplannedOptions.add(plannedOption);
                    HashMap<String, String> unplannedOption = new HashMap<String, String>();
                    unplannedOption.put("id", "unplanned");
                    unplannedOption.put("title", "Unplanned");
                    plannedUnplannedOptions.add(unplannedOption);
                    return plannedUnplannedOptions;
                }
                if ("jiraProject".equals(groupBy)) {
                    ArrayList<Map<String, String>> jiraProjectMap = new ArrayList<Map<String, String>>();
                    Query sessionQuery = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(boardId)));
                    sessionQuery.fields().include("almConfigurations");
                    BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new ObjectId(boardId)));
                    BasicDBObject almConfigurationsLookup = DBUtils.createLookup((String)"almConfigurations", (String)"almConfigurations.$id", (String)"_id", (String)"almConfigurationDetails");
                    BasicDBObject almConfigurationsUnwind = DBUtils.createUnWindWithPath((String)"$almConfigurationDetails", (boolean)true);
                    BasicDBObject featureMappingsUnwind = DBUtils.createUnWindWithPath((String)"$almConfigurationDetails.featureMappings", (boolean)true);
                    BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject("projectKey", (Object)"$almConfigurationDetails.featureMappings.projectKey"));
                    BasicDBObject groupStage = new BasicDBObject("$group", (Object)new BasicDBObject("_id", null).append("projectKeys", (Object)new BasicDBObject("$addToSet", (Object)"$projectKey")));
                    List<DBObject> pipeline = Arrays.asList(matchStage, almConfigurationsLookup, almConfigurationsUnwind, featureMappingsUnwind, projectionStage, groupStage);
                    DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
                    AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
                    try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
                        if (dbCursor.hasNext()) {
                            DBObject result = (DBObject)dbCursor.next();
                            List projectKeys = (List)result.get("projectKeys");
                            for (String projectKey : projectKeys) {
                                HashMap<String, String> projectKeyMap = new HashMap<String, String>();
                                projectKeyMap.put("id", projectKey);
                                projectKeyMap.put("title", projectKey);
                                jiraProjectMap.add(projectKeyMap);
                            }
                        }
                    }
                    return jiraProjectMap;
                }
                if ("tfsProject".equals(groupBy)) {
                    ArrayList<Map<String, String>> tfsProjectMap = new ArrayList<Map<String, String>>();
                    Query tfsProjectQuery = new Query((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)boardId));
                    tfsProjectQuery.fields().include("tfsId");
                    tfsProjectQuery.fields().include("name");
                    List tfsProjects = this.mongoTemplate.find(tfsProjectQuery, TFSProject.class);
                    for (TFSProject tfsProject : tfsProjects) {
                        HashMap<String, String> projectKeyMap = new HashMap<String, String>();
                        projectKeyMap.put("id", tfsProject.getTfsId());
                        projectKeyMap.put("title", tfsProject.getName());
                        tfsProjectMap.add(projectKeyMap);
                    }
                    return tfsProjectMap;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing fetchGroupBySubOptions()" + StringUtils.getTraceString((Throwable)e));
            }
        }
        return new ArrayList<Map<String, String>>();
    }

    public Map<String, Object> searchItems(Map<String, Object> requestStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String sessionBoardId = null;
            List issueTypeList = null;
            String searchText = null;
            if (requestStr.containsKey("sessionBoardId")) {
                sessionBoardId = (String)requestStr.get("sessionBoardId");
            }
            if (requestStr.containsKey("issueTypes")) {
                issueTypeList = (List)requestStr.get("issueTypes");
            }
            if (requestStr.containsKey("searchText")) {
                searchText = (String)requestStr.get("searchText");
            }
            BasicDBObject filter = new BasicDBObject("sessionBoards.$id", (Object)new ObjectId(sessionBoardId));
            filter.put((Object)"archive", (Object)false);
            BasicDBObject fields = new BasicDBObject();
            fields.put((Object)"_id", (Object)1);
            fields.put((Object)"jiraKey", (Object)1);
            fields.put((Object)"jiraId", (Object)1);
            fields.put((Object)"title", (Object)1);
            fields.put((Object)"tfsId", (Object)1);
            fields.put((Object)"jiraIssueTypeId", (Object)1);
            fields.put((Object)"tfsItemType", (Object)1);
            DBCollection collection = this.mongoTemplate.getCollection("item");
            DBCursor dbCursor = collection.find((DBObject)filter, (DBObject)fields);
            HashSet<Item> itemList = new HashSet<Item>();
            HashMap itemTeamContainerMap = new HashMap();
            while (dbCursor.hasNext()) {
                DBObject dbObject = dbCursor.next();
                Item item = new Item();
                item.setId(dbObject.get("_id").toString());
                item.setJiraIssueTypeId((String)dbObject.get("jiraIssueTypeId"));
                item.setTfsItemType((String)dbObject.get("tfsItemType"));
                item.setJiraKey((String)dbObject.get("jiraKey"));
                item.setJiraId((String)dbObject.get("jiraId"));
                item.setTfsId((String)dbObject.get("tfsId"));
                item.setTitle((String)dbObject.get("title"));
                itemList.add(item);
            }
            ArrayList<Item> finalItemsList = new ArrayList<Item>();
            for (Item item : itemList) {
                if (!(PropertyValidator.isValid((Object)item.getTitle()) && item.getTitle().toLowerCase().contains(searchText.toLowerCase()) || PropertyValidator.isValid((Object)item.getJiraKey()) && item.getJiraKey().toLowerCase().contains(searchText.toLowerCase()) || PropertyValidator.isValid((Object)item.getTfsId()) && item.getTfsId().toLowerCase().contains(searchText.toLowerCase())) && (!PropertyValidator.isValid((Object)item.getJiraId()) || !item.getJiraId().toLowerCase().contains(searchText.toLowerCase()))) continue;
                if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                    if (!PropertyValidator.isValid((Object)item.getJiraIssueTypeId()) || !issueTypeList.contains(item.getJiraIssueTypeId())) continue;
                    finalItemsList.add(item);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)item.getTfsId()) || !PropertyValidator.isValid((Object)item.getTfsItemType()) || !issueTypeList.contains(item.getTfsItemType())) continue;
                finalItemsList.add(item);
            }
            result.put("itemsList", finalItemsList);
        }
        catch (Exception e) {
            LOGGER.error("Error processing searchItems()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> fetchGroupTitles(Map<String, Object> requestStr) throws Exception {
        Dashboard dashboard = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List itemIds = new ArrayList();
            Map globalColorsMap = new HashMap();
            itemIds = (List)requestStr.get("ids");
            String groupType = (String)requestStr.get("type");
            List colors = (List)requestStr.get("colors");
            String dashboardKey = (String)requestStr.get("dashboardKey");
            Query queryForDashboard = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            queryForDashboard.fields().include("globalColorsMap");
            dashboard = (Dashboard)this.mongoTemplate.findOne(queryForDashboard, Dashboard.class);
            globalColorsMap = dashboard.getGlobalColorsMap();
            if (globalColorsMap == null) {
                globalColorsMap = new HashMap();
                dashboard.setGlobalColorsMap(globalColorsMap);
            }
            switch (groupType) {
                case "Batches": {
                    ArrayList<ObjectId> batchIds = new ArrayList<ObjectId>();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (!globalColorsMap.containsKey(itemIds.get(i))) {
                            globalColorsMap.put(itemIds.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        batchIds.add(new ObjectId((String)itemIds.get(i)));
                    }
                    Query queryForBatches = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(batchIds));
                    queryForBatches.fields().include("title");
                    queryForBatches.fields().include("type");
                    queryForBatches.fields().include("key");
                    List batches = this.mongoTemplate.find(queryForBatches, BaseItem.class);
                    HashMap<String, String> itemTitleMap = new HashMap<String, String>();
                    for (int i = 0; i < batches.size(); ++i) {
                        itemTitleMap.put(((BaseItem)batches.get(i)).getId(), ((BaseItem)batches.get(i)).getKey() + ":" + ((BaseItem)batches.get(i)).getTitle());
                    }
                    int deletedCounter = 1;
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (itemTitleMap.containsKey(itemIds.get(i))) continue;
                        itemTitleMap.put((String)itemIds.get(i), "Deleted Batch # " + deletedCounter);
                        ++deletedCounter;
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                case "kendisStatus": {
                    HashMap itemTitleMap = new HashMap();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (!globalColorsMap.containsKey(itemIds.get(i))) {
                            globalColorsMap.put(itemIds.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        itemTitleMap.put(itemIds.get(i), itemIds.get(i));
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                case "Session": {
                    ArrayList<ObjectId> sessionIds = new ArrayList<ObjectId>();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (!globalColorsMap.containsKey(itemIds.get(i))) {
                            globalColorsMap.put(itemIds.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        sessionIds.add(new ObjectId((String)itemIds.get(i)));
                    }
                    Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(sessionIds));
                    query.fields().include("session");
                    query.fields().include("title");
                    List sessionBoards = this.mongoTemplate.find(query, Session.class);
                    HashMap<String, String> itemTitleMap = new HashMap<String, String>();
                    for (int i = 0; i < sessionBoards.size(); ++i) {
                        itemTitleMap.put(((Session)sessionBoards.get(i)).getId(), ((Session)sessionBoards.get(i)).getTitle());
                    }
                    int deletedCounter = 1;
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (itemTitleMap.containsKey(itemIds.get(i))) continue;
                        itemTitleMap.put((String)itemIds.get(i), "Deleted PiBoard # " + deletedCounter);
                        ++deletedCounter;
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                case "Teams": {
                    ArrayList<ObjectId> teamIds = new ArrayList<ObjectId>();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        teamIds.add(new ObjectId((String)itemIds.get(i)));
                    }
                    Query queryForTeams = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(teamIds));
                    queryForTeams.fields().include("title");
                    queryForTeams.fields().include("label");
                    queryForTeams.fields().include("color");
                    List teams = this.mongoTemplate.find(queryForTeams, Team.class);
                    HashMap<String, String> itemTitleMap = new HashMap<String, String>();
                    for (int i = 0; i < teams.size(); ++i) {
                        itemTitleMap.put(((Team)teams.get(i)).getId(), ((Team)teams.get(i)).getTitle());
                    }
                    int deletedCounter = 1;
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (itemTitleMap.containsKey(itemIds.get(i))) continue;
                        itemTitleMap.put((String)itemIds.get(i), "Deleted Team # " + deletedCounter);
                        ++deletedCounter;
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                case "Containers": {
                    ArrayList sprintIds = new ArrayList();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (!globalColorsMap.containsKey(itemIds.get(i))) {
                            globalColorsMap.put(itemIds.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        sprintIds.add(itemIds.get(i));
                    }
                    Query queryForSprints = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(sprintIds));
                    queryForSprints.fields().include("title");
                    queryForSprints.fields().include("label");
                    List teams = this.mongoTemplate.find(queryForSprints, Container.class);
                    HashMap<String, String> itemTitleMap = new HashMap<String, String>();
                    for (int i = 0; i < teams.size(); ++i) {
                        List board = this.sessionBoardRepository.findByContainersId(((Container)teams.get(i)).getId());
                        itemTitleMap.put(((Container)teams.get(i)).getId(), ((Container)teams.get(i)).getTitle() + " (" + ((SessionBoard)board.get(0)).getSession().getTitle() + ")");
                    }
                    int deletedCounter = 1;
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (itemTitleMap.containsKey(itemIds.get(i))) continue;
                        itemTitleMap.put((String)itemIds.get(i), "Deleted Iteration # " + deletedCounter);
                        ++deletedCounter;
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                case "SolutionBoards": {
                    ArrayList<ObjectId> solutionBoardIds = new ArrayList<ObjectId>();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (!globalColorsMap.containsKey(itemIds.get(i))) {
                            globalColorsMap.put(itemIds.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        solutionBoardIds.add(new ObjectId((String)itemIds.get(i)));
                    }
                    Query queryForSolutionBoard = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(solutionBoardIds));
                    queryForSolutionBoard.fields().include("title");
                    List teams = this.mongoTemplate.find(queryForSolutionBoard, SolutionBoard.class);
                    HashMap<String, String> itemTitleMap = new HashMap<String, String>();
                    for (int i = 0; i < teams.size(); ++i) {
                        itemTitleMap.put(((SolutionBoard)teams.get(i)).getId(), ((SolutionBoard)teams.get(i)).getTitle());
                    }
                    int deletedCounter = 1;
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (itemTitleMap.containsKey(itemIds.get(i))) continue;
                        itemTitleMap.put((String)itemIds.get(i), "Deleted Solution Board # " + deletedCounter);
                        ++deletedCounter;
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                case "Parent": {
                    HashMap<String, String> itemTitleMap = new HashMap<String, String>();
                    ArrayList<ObjectId> parentIds = new ArrayList<ObjectId>();
                    for (int i = 0; i < itemIds.size(); ++i) {
                        if (((String)itemIds.get(i)).equals("null")) continue;
                        if (!globalColorsMap.containsKey(itemIds.get(i))) {
                            globalColorsMap.put(itemIds.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        parentIds.add(new ObjectId((String)itemIds.get(i)));
                    }
                    Query queryForParents = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(parentIds));
                    queryForParents.fields().include("title");
                    queryForParents.fields().include("label");
                    queryForParents.fields().include("color");
                    List parents = this.mongoTemplate.find(queryForParents, BacklogItem.class);
                    for (int i = 0; i < parents.size(); ++i) {
                        itemTitleMap.put(((BacklogItem)parents.get(i)).getId(), ((BacklogItem)parents.get(i)).getTitle());
                    }
                    if (parents.size() < itemIds.size()) {
                        itemTitleMap.put("null", "No Parent");
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
                default: {
                    HashMap itemTitleMap = new HashMap();
                    ArrayList areaPaths = new ArrayList(itemIds);
                    for (int i = 0; i < areaPaths.size(); ++i) {
                        if (!globalColorsMap.containsKey(areaPaths.get(i))) {
                            globalColorsMap.put(areaPaths.get(i), colors.get((globalColorsMap.size() + i) % colors.size()));
                        }
                        itemTitleMap.put(areaPaths.get(i), areaPaths.get(i));
                    }
                    result.put("groupTitleMap", itemTitleMap);
                    break;
                }
            }
            Update updateQuery = new Update();
            updateQuery.set("globalColorsMap", globalColorsMap);
            Query updateDashboardQuery = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)dashboardKey));
            this.mongoTemplate.updateFirst(updateDashboardQuery, updateQuery, Dashboard.class);
            result.put("globalColorsMap", globalColorsMap);
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchGroupTitles()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public Map<String, Object> fetchStatusTitles(Map<String, Object> requestStr) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String tenant = (String)requestStr.get("tenant");
            List statusIds = (List)requestStr.get("statusIds");
            List sprintIds = (List)requestStr.get("sprintIds");
            List teamIds = (List)requestStr.get("teamIds");
            List batchIds = (List)requestStr.get("batchIds");
            List sessionIds = (List)requestStr.get("sessionIds");
            List parentIds = (List)requestStr.get("parentIds");
            List solutionBoardIds = (List)requestStr.get("solutionIds");
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)statusIds));
            query.fields().include("_id").include("title").include("category");
            List statusList = this.mongoTemplate.find(query, Status.class);
            HashMap<String, String> statusMap = new HashMap<String, String>();
            HashMap<String, String> categoryMap = new HashMap<String, String>();
            for (Status status : statusList) {
                statusMap.put(status.getId(), status.getTitle());
                categoryMap.put(status.getId(), status.getCategory());
            }
            Query containerQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)sprintIds), Criteria.where((String)"tenant").is((Object)tenant)}));
            List sprints = this.mongoTemplate.find(containerQuery, Container.class);
            List board = this.sessionBoardRepository.findByContainersIdIn(sprints.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            HashMap<String, Object> boardMap = new HashMap<String, Object>();
            for (Object sb : board) {
                for (Container container : sb.getContainers()) {
                    boardMap.put(container.getId(), sb);
                }
            }
            HashMap sprintMap = new HashMap();
            for (Container sprint : sprints) {
                HashMap<String, String> sprintDetails = new HashMap<String, String>();
                sprintDetails.put("label", sprint.getLabel());
                sprintDetails.put("title", sprint.getTitle());
                SessionBoard sbForSprint = (SessionBoard)boardMap.get(sprint.getId());
                if (sbForSprint != null && sbForSprint.getSession() != null) {
                    sprintDetails.put("boardTitle", sbForSprint.getSession().getTitle());
                } else {
                    sprintDetails.put("boardTitle", "");
                }
                sprintMap.put(sprint.getId(), sprintDetails);
            }
            Query teamQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)teamIds), Criteria.where((String)"tenant").is((Object)tenant)}));
            teamQuery.fields().include("_id").include("title").include("label");
            List teamsList = this.mongoTemplate.find(teamQuery, Team.class);
            HashMap teamsMap = new HashMap();
            for (Team team : teamsList) {
                HashMap<String, String> teamDetails = new HashMap<String, String>();
                teamDetails.put("label", team.getLabel());
                teamDetails.put("title", team.getTitle());
                teamsMap.put(team.getId(), teamDetails);
            }
            Query batchQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)batchIds), Criteria.where((String)"tenant").is((Object)tenant)}));
            batchQuery.fields().include("_id").include("title").include("key");
            List batchesList = this.mongoTemplate.find(batchQuery, BaseItem.class);
            HashMap<String, String> batchesMap = new HashMap<String, String>();
            for (BaseItem batch : batchesList) {
                batchesMap.put(batch.getId(), batch.getKey() + ":" + batch.getTitle());
            }
            Query parentQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)parentIds), Criteria.where((String)"tenant").is((Object)tenant)}));
            List backlogItems = this.mongoTemplate.find(parentQuery, BacklogItem.class);
            HashMap parentMap = new HashMap();
            for (BacklogItem backlogItem : backlogItems) {
                HashMap<String, String> parentDetails = new HashMap<String, String>();
                Object key = null;
                String url = null;
                if (backlogItem.getAlmKey() != null && !backlogItem.getAlmKey().isEmpty()) {
                    key = backlogItem.getAlmKey();
                    url = backlogItem.getUrl();
                } else if (backlogItem.getKendisKey() != null && !backlogItem.getKendisKey().isEmpty()) {
                    key = backlogItem.getKendisKey();
                    url = null;
                } else if (backlogItem.getFields() != null && backlogItem.getFields().get("externalKey") != null) {
                    key = (String)backlogItem.getFields().get("externalKey");
                    url = (String)backlogItem.getFields().get("externalLink");
                }
                parentDetails.put("key", (String)(key != null ? key : "--"));
                parentDetails.put("url", url != null ? url : "");
                parentDetails.put("title", backlogItem.getTitle());
                parentMap.put(backlogItem.getId(), parentDetails);
            }
            Query sessionQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)sessionIds), Criteria.where((String)"tenant").is((Object)tenant), Criteria.where((String)"rowStatus").is((Object)0)}));
            sessionQuery.fields().include("_id").include("title").include("prefix");
            List sessionsList = this.mongoTemplate.find(sessionQuery, Session.class);
            HashMap sessionMap = new HashMap();
            for (Session session : sessionsList) {
                HashMap<String, String> sessionDetails = new HashMap<String, String>();
                sessionDetails.put("prefix", session.getPrefix());
                sessionDetails.put("title", session.getTitle());
                sessionMap.put(session.getId(), sessionDetails);
            }
            Query solutionQuery = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").in((Collection)solutionBoardIds), Criteria.where((String)"tenant").is((Object)tenant), Criteria.where((String)"rowStatus").is((Object)0)}));
            solutionQuery.fields().include("_id").include("title");
            List solutionBoards = this.mongoTemplate.find(solutionQuery, SolutionBoard.class);
            HashMap<String, String> solutionMap = new HashMap<String, String>();
            for (SolutionBoard solutionBoard : solutionBoards) {
                solutionMap.put(solutionBoard.getId(), solutionBoard.getTitle());
            }
            result.put("statusMap", statusMap);
            result.put("categoryMap", categoryMap);
            result.put("teamMap", teamsMap);
            result.put("sprintMap", sprintMap);
            result.put("sessionMap", sessionMap);
            result.put("batchMap", batchesMap);
            result.put("parentMap", parentMap);
            result.put("solutionBoardMap", solutionMap);
        }
        catch (Exception e) {
            LOGGER.error("Error processing fetchStatusTitles()" + StringUtils.getTraceString((Throwable)e));
        }
        return result;
    }

    public List<HashMap> retrieveGroupingForAlms(HashMap<String, Object> requestStr) throws Exception {
        ArrayList<HashMap> almFields = new ArrayList<HashMap>();
        try {
            Double hierarchyLevel = (Double)requestStr.get("hierarchyLevel");
            List linkedAlmAccounts = (List)requestStr.get("linkedAlmAccounts");
            String linkedAlmHierarchyId = (String)requestStr.get("linkedAlmHierarchyId");
            String releaseTrainId = (String)requestStr.get("releaseTrainId");
            Query queryForBacklogHierarchy = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(linkedAlmHierarchyId)));
            queryForBacklogHierarchy.fields().include("hierarchyLevels");
            queryForBacklogHierarchy.fields().include("linkedAlmAccounts");
            queryForBacklogHierarchy.fields().include("_id");
            BacklogHierarchy backlogHierarchy = (BacklogHierarchy)this.mongoTemplate.findOne(queryForBacklogHierarchy, BacklogHierarchy.class);
            int hierarchyLevelInt = hierarchyLevel.intValue();
            if (PropertyValidator.isValid((Object)hierarchyLevelInt) && PropertyValidator.isValid((Collection)backlogHierarchy.getHierarchyLevels())) {
                HierarchyLevel hierarchyLevelFromList = (HierarchyLevel)backlogHierarchy.getHierarchyLevels().get(hierarchyLevelInt);
                for (AlmHierarchyLevelMapping almHierarchyLevelMapping : hierarchyLevelFromList.getAlmHierarchyLevelMappings()) {
                    if (!linkedAlmAccounts.contains(almHierarchyLevelMapping.getAlmAccountId())) continue;
                    if (PropertyValidator.isValid((Collection)almHierarchyLevelMapping.getTfsFields())) {
                        almFields.addAll(almHierarchyLevelMapping.getTfsFields());
                        continue;
                    }
                    if (!PropertyValidator.isValid((Collection)almHierarchyLevelMapping.getJiraFields())) continue;
                    almFields.addAll(almHierarchyLevelMapping.getJiraFields());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing retrieveGroupingForAlms()" + StringUtils.getTraceString((Throwable)e));
        }
        return almFields;
    }

    public void updatePermissionForAll(Map map) throws Exception {
        String dashBoardId = (String)map.get("id");
        Boolean flag = (Boolean)map.get("flag");
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)dashBoardId));
        Update update = new Update();
        update.set("sharedWithAll", (Object)flag);
        this.mongoTemplate.updateFirst(query, update, Dashboard.class);
    }
}

