/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.alm.tfs.TFSBacklogMappingLinks;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TFSFilterRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.service.CreateBoardService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.IntercommUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="CreateBoardService")
@Transactional
public class CreateBoardServiceImpl
implements CreateBoardService {
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private TFSFilterRepository tfsFilterRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateBoardServiceImpl.class);

    public HashMap<String, Object> createTfsBoard(HashMap<String, Object> params) throws Exception {
        WorkFlow wf;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String sessionTitle = (String)params.get("title");
        String sessionId = (String)params.get("sessionId");
        String prefix = (String)params.get("prefix");
        String color = (String)params.get("color");
        String parentItem = (String)params.get("parentItem");
        String childItem = (String)params.get("childItem");
        String parentItems = (String)params.get("parentItems");
        String childItems = (String)params.get("childItems");
        String teamLabel = (String)params.get("teamLabel");
        String teamsLabel = (String)params.get("teamsLabel");
        String sprintLabel = (String)params.get("sprintLabel");
        String sprintsLabel = (String)params.get("sprintsLabel");
        String parentItemColor = (String)params.get("parentItemColor");
        String childItemColor = (String)params.get("childItemColor");
        String parentItemTextColor = (String)params.get("parentItemTextColor");
        String childItemTextColor = (String)params.get("childItemTextColor");
        String almAccountId = (String)params.get("almAccountId");
        String tfsProjectId = (String)params.get("tfsProjectId");
        String workSpaceId = (String)params.get("workSpaceId");
        Boolean usePlanningAgenda = (Boolean)params.get("usePlanningAgenda");
        Session session = new Session();
        WorkSpace ws = new WorkSpace();
        ws.setId(workSpaceId);
        session.setWorkSpace(ws);
        session.setId(sessionId);
        session.setTitle(sessionTitle);
        session.setPrefix(prefix);
        session.setPrefixColor(color);
        session.setParentItem(parentItem);
        session.setChildItem(childItem);
        session.setParentItems(parentItems);
        session.setChildItems(childItems);
        session.setHidePiJourney(Boolean.valueOf(usePlanningAgenda == false));
        session.setParentItemColor(parentItemColor);
        session.setParentItemTextColor(parentItemTextColor);
        session.setChildItemColor(childItemColor);
        session.setChildItemTextColor(childItemTextColor);
        session.setTeamLabel(teamLabel);
        session.setTeamsLabel(teamsLabel);
        session.setSprintLabel(sprintLabel);
        session.setSprintsLabel(sprintsLabel);
        session.setStateScheme(this.getDefaultStateScheme());
        session.setLoadOldObjectivesView(Boolean.valueOf(false));
        session.setAutoFillStartEndDate(true);
        SessionBoard sessionBoard = new SessionBoard();
        sessionBoard.setId(ObjectId.get().toString());
        session.setActiveSessionBoard(sessionBoard.getId());
        State draftState = this.stateRepository.findByTitle("Draft");
        sessionBoard.setState(draftState);
        sessionBoard.setCreationDate(new Date());
        sessionBoard.setCreatedOn(new Date());
        session.setDisabledForDashboardListing(false);
        session.setHideMilestonesBar(Boolean.FALSE);
        session.setLoadNewStructureMilestones(Boolean.valueOf(true));
        ArrayList<Team> teamsToAdd = new ArrayList<Team>();
        AlmAccount almAccount = null;
        TFSAlmConfigurations almConfiguration = null;
        TFSProject tfsProject = null;
        if (PropertyValidator.isValid((Object)tfsProjectId)) {
            tfsProject = this.tfsProjectRepository.findById(tfsProjectId);
        }
        boolean resyncRequired = false;
        if (PropertyValidator.isValid((Object)almAccountId) && PropertyValidator.isValid((Object)(almAccount = this.almAccountRepository.findById(almAccountId))) && almAccount.getType().equals("tfs")) {
            almConfiguration = new TFSAlmConfigurations();
            almConfiguration.setId(ObjectId.get().toString());
            almConfiguration.setAlmAccount(almAccount);
            session.setTfsAlmConfigurations(almConfiguration);
            session.setAlmEnabled(Boolean.valueOf(true));
            if (params.containsKey("wiql") || params.containsKey("tfsFilter") || params.containsKey("wiqlParams")) {
                TFSFilter newTfsFilter = new TFSFilter();
                newTfsFilter.setId(ObjectId.get().toString());
                newTfsFilter.setSessionId(session.getId());
                newTfsFilter.setFilterFetchedBy(UserContextUtil.getUserContext().getLoggedInUser());
                newTfsFilter.setSystem(Boolean.TRUE);
                if (params.containsKey("wiqlParams")) {
                    String workItemType = (String)params.get("workItemType");
                    Object iterationPath = params.get("iterationPath");
                    Object iterationPathId = params.get("iterationPathId");
                    Object areaPath = params.get("areaPath");
                    Object areaPathId = params.get("areaPathId");
                    Object _state = params.get("state");
                    String iterationPathOp = (String)params.get("iterationPathOp");
                    String areaPathOp = (String)params.get("areaPathOp");
                    String stateOp = (String)params.get("stateOp");
                    String wiql = AlmUtils.createWIQLQuery(params);
                    newTfsFilter.setMoreInfo(new HashMap());
                    newTfsFilter.getMoreInfo().put("iterationPathOp", iterationPathOp);
                    newTfsFilter.getMoreInfo().put("areaPathOp", areaPathOp);
                    newTfsFilter.getMoreInfo().put("stateOp", stateOp);
                    newTfsFilter.getMoreInfo().put("itemType", workItemType);
                    newTfsFilter.getMoreInfo().put("areaPath", areaPath);
                    newTfsFilter.getMoreInfo().put("iterationPath", iterationPath);
                    newTfsFilter.getMoreInfo().put("iterationPathId", iterationPathId);
                    newTfsFilter.getMoreInfo().put("areaPathId", areaPathId);
                    newTfsFilter.getMoreInfo().put("state", _state);
                    newTfsFilter.setTfsId(ObjectId.get().toString());
                    newTfsFilter.setIsWiql(Boolean.TRUE);
                    newTfsFilter.setQueryJSON(wiql);
                    newTfsFilter.setName("Features by Iteration Path");
                } else if (params.containsKey("wiql")) {
                    String wiql = (String)params.get("wiql");
                    newTfsFilter.setTfsId(ObjectId.get().toString());
                    newTfsFilter.setIsWiql(Boolean.TRUE);
                    newTfsFilter.setQueryJSON(wiql);
                    newTfsFilter.setName("Features by Iteration Path");
                } else {
                    Map tfsFilterMap = (Map)params.get("tfsFilter");
                    newTfsFilter.setTfsId((String)tfsFilterMap.get("id"));
                    newTfsFilter.setIsWiql(Boolean.FALSE);
                    newTfsFilter.setHtmlUrl((String)tfsFilterMap.get("htmlUrl"));
                    newTfsFilter.setQueryJSON((String)tfsFilterMap.get("wiql"));
                    newTfsFilter.setName((String)tfsFilterMap.get("name"));
                }
                TFSBacklogMappingLinks backlogMapping = new TFSBacklogMappingLinks();
                String tfsProjectName = tfsProject.getName();
                String _tfsProjectId = tfsProject.getTfsId();
                newTfsFilter.setTfsProject(tfsProjectName);
                newTfsFilter.setTfsProjectId(_tfsProjectId);
                backlogMapping.setTfsProjectId(_tfsProjectId);
                backlogMapping.setProject(tfsProjectName);
                backlogMapping.setLinkTypes(Arrays.asList("System.LinkTypes.Hierarchy-Forward"));
                backlogMapping.setLinkTypesName(Arrays.asList("Child"));
                newTfsFilter.setBacklogMappingLinks(Arrays.asList(backlogMapping));
                this.tfsFilterRepository.save((Object)newTfsFilter);
                if (almConfiguration.getFeatureFilters() == null) {
                    almConfiguration.setFeatureFilters(new ArrayList());
                }
                resyncRequired = true;
                almConfiguration.getFeatureFilters().add(newTfsFilter);
            }
        }
        if (resyncRequired) {
            session.setResyncRequired(Boolean.TRUE);
        }
        List teamsData = (List)params.get("teams");
        ArrayList<TFSTeamMapping> teamMappings = new ArrayList<TFSTeamMapping>();
        HashMap<String, TFSTeamMapping> teamMappingsMapByKendisTeamId = new HashMap<String, TFSTeamMapping>();
        String tmMappingItemType = (String)params.get("tmMappingItemType");
        if (PropertyValidator.isValid((Collection)teamsData)) {
            String[] teamsSequence = new String[teamsData.size()];
            for (int i = 0; i < teamsData.size(); ++i) {
                Map teamData = (Map)teamsData.get(i);
                String _id = (String)teamData.get("id");
                Map _tfsTeam = (Map)teamData.get("tfsTeam");
                String _backlogIteration = (String)teamData.get("backlogIteration");
                List _selectedAreaPaths = (List)teamData.get("selectedAreaPaths");
                String _selectedAreaPath = (String)teamData.get("selectedAreaPath");
                Boolean _includeSubAreaPaths = (Boolean)teamData.get("includeSubAreaPaths");
                Team team = new Team();
                team.setId(_id);
                teamsToAdd.add(team);
                teamsSequence[i] = _id;
                if (!PropertyValidator.isValid((Object)_tfsTeam) || !PropertyValidator.isValid((Object)_backlogIteration) || !PropertyValidator.isValid((Collection)_selectedAreaPaths) || !PropertyValidator.isValid((Object)almAccount) || !almAccount.getType().equals("tfs")) continue;
                TFSTeamMapping teamMapping = new TFSTeamMapping();
                teamMapping.setItemTypeName(tmMappingItemType);
                teamMapping.setIncludeSubAreaPaths(_includeSubAreaPaths);
                teamMapping.setKendisTeamId(_id);
                teamMapping.setTfsTeamId((String)_tfsTeam.get("id"));
                teamMapping.setTfsTeamName((String)_tfsTeam.get("name"));
                teamMapping.setTfsProject(tfsProject.getId());
                teamMapping.setTfsProjectName(tfsProject.getName());
                teamMapping.setTfsProjectTfsId(tfsProject.getTfsId());
                teamMapping.setTfsAreaPath(_selectedAreaPath);
                teamMapping.setTfsAreaPathsForTeam(_selectedAreaPaths);
                teamMapping.setTfsBacklogIteration(_backlogIteration);
                teamMappings.add(teamMapping);
                teamMappingsMapByKendisTeamId.put(teamMapping.getKendisTeamId(), teamMapping);
            }
            sessionBoard.setTeamSequence(teamsSequence);
        }
        if (PropertyValidator.isValid(teamsToAdd)) {
            sessionBoard.setTeams(teamsToAdd);
        }
        if (PropertyValidator.isValid((Object)almConfiguration) && PropertyValidator.isValid(teamMappings)) {
            almConfiguration.setTeamMappings(teamMappings);
        }
        List containersData = (List)params.get("containers");
        HashMap<String, Object> tfsSprintDataByNewSprintId = new HashMap<String, Object>();
        ArrayList<Container> newContainers = new ArrayList<Container>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Double sequenceOffset = System.nanoTime();
        if (PropertyValidator.isValid((Collection)containersData)) {
            for (Object containerData : containersData) {
                Container newSprint = null;
                String newContainerId = ObjectId.get().toString();
                newSprint = new Container();
                newSprint.setId(newContainerId);
                tfsSprintDataByNewSprintId.put(newContainerId, containerData);
                newSprint.setTitle((String)containerData.get("title"));
                newSprint.setLabel((String)containerData.get("label"));
                String startDateStr = (String)containerData.get("startDate");
                String endDateStr = (String)containerData.get("endDate");
                try {
                    if (PropertyValidator.isValid((Object)startDateStr)) {
                        Date startDate = df.parse(startDateStr);
                        newSprint.setStartDate(startDate);
                    } else {
                        newSprint.setStartDate(null);
                    }
                    if (PropertyValidator.isValid((Object)endDateStr)) {
                        Date endDate = df.parse(endDateStr);
                        newSprint.setEndDate(endDate);
                    } else {
                        newSprint.setEndDate(null);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                newSprint.setSequence(sequenceOffset);
                newSprint.setStartedOn(null);
                newSprint.setEndedOn(null);
                newSprint.setCreatedOn(new Date());
                newSprint.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                newSprint.setOriginItemId(null);
                newSprint.setDuplicateOfId(null);
                newSprint.setDuplicateToId(null);
                newContainers.add(newSprint);
                sequenceOffset = sequenceOffset + 1000.0;
            }
        }
        if (PropertyValidator.isValid(newContainers)) {
            sessionBoard.setContainers(newContainers);
        }
        if (PropertyValidator.isValid((Object)almConfiguration)) {
            almConfiguration = (TFSAlmConfigurations)this.tfsAlmConfigurationsRepository.save((Object)almConfiguration);
        }
        ArrayList<ItemSyncMapper> mappers = new ArrayList<ItemSyncMapper>();
        if (PropertyValidator.isValid((Collection)sessionBoard.getTeams()) && PropertyValidator.isValid((Collection)sessionBoard.getTeams())) {
            for (Team team : sessionBoard.getTeams()) {
                TFSTeamMapping tfsTeamMapping = (TFSTeamMapping)teamMappingsMapByKendisTeamId.get(team.getId());
                for (Container sprint : newContainers) {
                    Map sprintMap;
                    if (!PropertyValidator.isValid((Object)tfsTeamMapping)) continue;
                    ItemSyncMapper itemSyncMapper = new ItemSyncMapper();
                    itemSyncMapper.setTeam(team);
                    itemSyncMapper.setContainer(sprint);
                    itemSyncMapper.setId(ObjectId.get().toString());
                    itemSyncMapper.setSessionBoard(sessionBoard);
                    mappers.add(itemSyncMapper);
                    itemSyncMapper.setTfsSprint(null);
                    itemSyncMapper.setTfsProjectId(tfsTeamMapping.getTfsProjectTfsId());
                    if (!tfsTeamMapping.getTfsProjectTfsId().equals(tfsProject.getTfsId()) || !PropertyValidator.isValid((Object)(sprintMap = (Map)tfsSprintDataByNewSprintId.get(sprint.getId())))) continue;
                    String tfsId = (String)sprintMap.get("tfsSprintId");
                    String path = (String)sprintMap.get("path");
                    String title = (String)sprintMap.get("tfsSprintName");
                    if (!PropertyValidator.isValid((Object)path)) continue;
                    Sprint tfsSprint = new Sprint();
                    tfsSprint.setIterationPath(path);
                    tfsSprint.setTitle(title);
                    tfsSprint.setTfsId(tfsId);
                    itemSyncMapper.setTfsSprint(tfsSprint);
                }
            }
        }
        if (PropertyValidator.isValid((Object)almAccount) && almAccount.getType() != null && almAccount.getType().equals("tfs") && params.containsKey("selectedLinkTypes")) {
            List selectedLinkTypes = (List)params.get("selectedLinkTypes");
            session.setJiraLinkTypes(selectedLinkTypes);
            session.setJiraDependencyEnabled(Boolean.TRUE);
        }
        if (PropertyValidator.isValid((Object)tfsProject) && params.containsKey("selectedFields")) {
            List selectedFields = (List)params.get("selectedFields");
            tfsProject.setSelectedFields(selectedFields);
            this.tfsProjectRepository.save((Object)tfsProject);
        }
        String itemWorkflow = (String)params.get("itemWorkflow");
        String subItemWorkflow = (String)params.get("subItemWorkflow");
        String dependencyWorkflow = (String)params.get("dependencyWorkflow");
        if (PropertyValidator.isValid((Object)itemWorkflow)) {
            wf = new WorkFlow();
            wf.setId(itemWorkflow);
            session.setItemWorkFlow(wf);
        }
        if (PropertyValidator.isValid((Object)subItemWorkflow)) {
            wf = new WorkFlow();
            wf.setId(subItemWorkflow);
            session.setSubItemWorkFlow(wf);
        }
        if (PropertyValidator.isValid((Object)dependencyWorkflow)) {
            wf = new WorkFlow();
            wf.setId(dependencyWorkflow);
            session.setDependencyWorkFlow(wf);
        }
        if (PropertyValidator.isValid(newContainers)) {
            this.containerRepository.save(newContainers);
        }
        if (PropertyValidator.isValid(mappers)) {
            this.itemSyncMapperRepository.save(mappers);
        }
        sessionBoard.setSession(session);
        sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        session = (Session)this.sessionRepository.save((Object)session);
        this.userService.setOnboardingMeta("Create_Board", true);
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("board_created", 1);
        IntercommUtils.post((String)UserContextUtil.getUserContext().getLoggedInUser().getUserName(), vars);
        responseJson.put("session", session);
        responseJson.put("sessionBoard", sessionBoard);
        return responseJson;
    }

    private StateScheme getDefaultStateScheme() {
        StateScheme defaultStateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
        return defaultStateScheme;
    }
}

