/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.persistence.entity.ConfigAndMapping;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ConfigAndMappingRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.ConfigAndMappingService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.TfsProjectWorkflowService;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component(value="ConfigAndMappingService")
public class ConfigAndMappingServiceImpl
implements ConfigAndMappingService {
    @Autowired
    private ConfigAndMappingRepository configAndMappingRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private TfsProjectWorkflowService tfsProjectWorkflowService;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;

    public HashMap<String, Object> loadConfigs() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List configs = this.configAndMappingRepository.findAll();
        result.put("configs", configs);
        result.put("success", true);
        return result;
    }

    public HashMap<String, Object> configMetaGeneral() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List almAccounts = this.almAccountRepository.findAll();
        result.put("almAccounts", almAccounts);
        result.put("success", true);
        return result;
    }

    public HashMap<String, Object> saveConfig(ConfigAndMapping config) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        if (PropertyValidator.isValid((Object)config.getId())) {
            ConfigAndMapping savedConfig = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)config.getId()));
            savedConfig.setTitle(config.getTitle());
            savedConfig.setTfsProjectId(config.getTfsProjectId());
            savedConfig.setTfsProjectTfsId(config.getTfsProjectTfsId());
            savedConfig.setTfsProjectName(config.getTfsProjectName());
            savedConfig.setRiskItemType(config.getRiskItemType());
            savedConfig.setRiskItemTypeName(config.getRiskItemTypeName());
            savedConfig.setRiskLinkType(config.getRiskLinkType());
            savedConfig.setRiskFieldsMappings(config.getRiskFieldsMappings());
            savedConfig.setRiskCsutomFieldsMappings(config.getRiskCsutomFieldsMappings());
            savedConfig = (ConfigAndMapping)this.configAndMappingRepository.save((Object)savedConfig);
            result.put("config", savedConfig);
        } else {
            ConfigAndMapping newConfig = new ConfigAndMapping();
            newConfig.setTitle(config.getTitle());
            newConfig.setAlmAccount(config.getAlmAccount());
            newConfig = (ConfigAndMapping)this.configAndMappingRepository.save((Object)newConfig);
            result.put("config", newConfig);
        }
        return result;
    }

    public HashMap<String, Object> configMetaTfsProjects(String configId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List projects = this.tfsProjectRepository.findByLinkedConfigIdsIn(configId);
        result.put("tfsProjects", projects);
        return result;
    }

    public HashMap<String, Object> linkTfsProject(HashMap<String, Object> request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String almId = (String)request.get("almId");
        String projectId = (String)request.get("tfsProjectId");
        String configId = (String)request.get("configId");
        TFSProject tfsProject = this.tfsProjectRepository.findByAlmIdAndTfsId(almId, projectId);
        if (PropertyValidator.isValid((Object)tfsProject)) {
            if (PropertyValidator.isValid((Collection)tfsProject.getLinkedConfigIds()) && tfsProject.getLinkedConfigIds().contains(configId)) {
                result.put("success", false);
                result.put("reason", "AlreadyExist");
            } else {
                if ((tfsProject = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)tfsProject.getId()))).getLinkedConfigIds() == null) {
                    tfsProject.setLinkedConfigIds(new ArrayList());
                }
                tfsProject.getLinkedConfigIds().add(configId);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)tfsProject.getId()));
                Update update = new Update();
                update.set("linkedConfigIds", (Object)tfsProject.getLinkedConfigIds());
                this.mongoTemplate.updateMulti(query, update, TFSProject.class);
                WorkFlow workFlow = this.workFlowRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
                List statuses = this.statusRepository.findByTfsProjectIdAndAlmId(tfsProject.getTfsId(), almId);
                workFlow.setStatuses(statuses);
                tfsProject.setWorkFlow(workFlow);
                result.put("project", tfsProject);
                result.put("success", true);
                result.put("action", "projectLinked");
            }
            return result;
        }
        try {
            TFSProject tfsProjectNew = this.tfSservice.linkTFSProjectsWithAlm(projectId, almId, null);
            WorkFlow worlflow = this.tfsProjectWorkflowService.createWorkflowForProject(tfsProjectNew, almId);
            tfsProjectNew.setWorkFlow(worlflow);
            ArrayList<String> configIds = new ArrayList<String>();
            configIds.add(configId);
            tfsProjectNew.setLinkedConfigIds(configIds);
            this.tfsProjectRepository.save((Object)tfsProjectNew);
            result.put("success", true);
            result.put("project", tfsProjectNew);
            return result;
        }
        catch (ViztrendJiraException e2) {
            result.put("success", false);
            result.put("viztrend", true);
            result.put("error", (Object)e2);
            return result;
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("viztrend", false);
            result.put("error", e);
            return result;
        }
    }

    public HashMap<String, Object> getTfsProjectDetails(String projectId, String almId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TFSProject project = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)projectId));
        result.put("success", true);
        result.put("tfsProject", project);
        return result;
    }

    public HashMap<String, Object> configMetaRiskMapping(String configId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConfigAndMapping config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)configId));
        if (PropertyValidator.isValid((Object)config) && PropertyValidator.isValid((Object)config.getAlmAccount())) {
            List projects = this.tfsProjectRepository.findByLinkedConfigIdsIn(configId);
            result.put("tfsProjects", projects);
            Object tfsLinkTypesStr = this.tfsUtils.getRelationShipTypes(config.getAlmAccount());
            result.put("tfsLinkTypes", tfsLinkTypesStr);
            if (PropertyValidator.isValid((Object)config.getTfsProjectId())) {
                TFSProject project = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)config.getTfsProjectId()));
                result.put("selectedTfsProject", project);
            }
        }
        return result;
    }

    public HashMap<String, Object> configRiskRegisterMeta(String riskRegisterId) throws Exception {
        ConfigAndMapping config;
        HashMap<String, Object> result = new HashMap<String, Object>();
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)riskRegister.getConfigId()) && PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId())))) && PropertyValidator.isValid((Collection)config.getRiskFieldsMappings())) {
            TFSProject project = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)config.getTfsProjectId()));
            WorkFlow workFlow = this.workFlowRepository.findByTfsProjectIdAndAlmId(project.getTfsId(), config.getAlmAccount().getId());
            List statuses = this.statusRepository.findByTfsProjectIdAndAlmIdAndItemType(project.getTfsId(), config.getAlmAccount().getId(), config.getRiskItemTypeName());
            workFlow.setStatuses(statuses);
            project.setWorkFlow(workFlow);
            List itemTypes = this.workFlowItemTypeRepository.findByTfsProjectIdAndAlmId(project.getTfsId(), config.getAlmAccount().getId());
            project.setItemTypes(itemTypes);
            result.put("config", config);
            result.put("tfsProject", project);
        }
        return result;
    }
}

