/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.enums.EnumCollaborationType;
import com.viztrend.safe.enums.EnumCollaborationTypeContext;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.CollaborationType;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.CollaborationTypeRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.CollaborationTypeService;
import com.viztrend.safe.service.CollaborationTypeServiceImpl;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.utils.AttachmentUtils;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class CollaborationTypeServiceImpl
implements CollaborationTypeService {
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private CollaborationTypeRepository collaborationTypeRepository;
    @Autowired
    private ReleaseTrainServiceImpl releaseTrainService;
    @Autowired
    private MongoTemplate mongoTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentUtils.class);

    public List<CollaborationType> linkType(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        List typesIds = (List)payload.get("types");
        List types = this.collaborationTypeRepository.findByIdIn(typesIds);
        switch (1.$SwitchMap$com$viztrend$safe$enums$EnumCollaborationTypeContext[EnumCollaborationTypeContext.getEnumByCode((String)context).ordinal()]) {
            case 1: {
                Session session = this.sessionRepository.findById(id);
                if (session == null) break;
                for (CollaborationType type : types) {
                    ArrayList<Session> existingSessions = type.getSessions();
                    if (existingSessions != null && existingSessions.stream().anyMatch(s -> s.getId().equals(session.getId()))) continue;
                    if (existingSessions == null) {
                        existingSessions = new ArrayList<Session>();
                    }
                    existingSessions.add(session);
                    type.setSessions(existingSessions);
                }
                break;
            }
            case 2: {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findByIdIn(id);
                if (solutionBoard == null) break;
                for (CollaborationType type : types) {
                    ArrayList<SolutionBoard> existingBoards = type.getSolutionBoards();
                    if (existingBoards != null && existingBoards.stream().anyMatch(sb -> sb.getId().equals(solutionBoard.getId()))) continue;
                    if (existingBoards == null) {
                        existingBoards = new ArrayList<SolutionBoard>();
                    }
                    existingBoards.add(solutionBoard);
                    type.setSolutionBoards(existingBoards);
                }
                break;
            }
            case 3: {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (workSpace == null) break;
                for (CollaborationType type : types) {
                    ArrayList<WorkSpace> existingWorkspaces = type.getWorkSpaces();
                    if (existingWorkspaces != null && existingWorkspaces.stream().anyMatch(ws -> ws.getId().equals(workSpace.getId()))) continue;
                    if (existingWorkspaces == null) {
                        existingWorkspaces = new ArrayList<WorkSpace>();
                    }
                    existingWorkspaces.add(workSpace);
                    type.setWorkSpaces(existingWorkspaces);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        return this.collaborationTypeRepository.save((Iterable)types);
    }

    public List<CollaborationType> unlinkType(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        List typesIds = (List)payload.get("types");
        List types = this.collaborationTypeRepository.findByIdIn(typesIds);
        switch (1.$SwitchMap$com$viztrend$safe$enums$EnumCollaborationTypeContext[EnumCollaborationTypeContext.getEnumByCode((String)context).ordinal()]) {
            case 1: {
                Session session = this.sessionRepository.findById(id);
                if (session == null) break;
                for (CollaborationType type : types) {
                    List existingSessions = type.getSessions();
                    if (existingSessions == null) continue;
                    existingSessions.removeIf(s -> s.getId().equals(session.getId()));
                    type.setSessions(existingSessions);
                }
                break;
            }
            case 2: {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findById(id);
                if (solutionBoard == null) break;
                for (CollaborationType type : types) {
                    List existingBoards = type.getSolutionBoards();
                    if (existingBoards == null) continue;
                    existingBoards.removeIf(sb -> sb.getId().equals(solutionBoard.getId()));
                    type.setSolutionBoards(existingBoards);
                }
                break;
            }
            case 3: {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (workSpace == null) break;
                for (CollaborationType type : types) {
                    List existingWorkspaces = type.getWorkSpaces();
                    if (existingWorkspaces == null) continue;
                    existingWorkspaces.removeIf(ws -> ws.getId().equals(workSpace.getId()));
                    type.setWorkSpaces(existingWorkspaces);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        return this.collaborationTypeRepository.save((Iterable)types);
    }

    public List<CollaborationType> getTypesRelatedToContext(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        String origin = (String)payload.get("origin");
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(Criteria.where((String)"tenant").is((Object)tenant));
        switch (1.$SwitchMap$com$viztrend$safe$enums$EnumCollaborationTypeContext[EnumCollaborationTypeContext.getEnumByCode((String)context).ordinal()]) {
            case 1: {
                if ("sessionBoard".equals(origin)) {
                    Session session = this.sessionRepository.findByActiveSessionBoard(id);
                    if (!PropertyValidator.isValid((Object)session)) break;
                    criteriaList.add(Criteria.where((String)"sessions").in(new Object[]{session.getId()}));
                    break;
                }
                criteriaList.add(Criteria.where((String)"sessions").in(new Object[]{id}));
                break;
            }
            case 2: {
                criteriaList.add(Criteria.where((String)"solutionBoards").in(new Object[]{id}));
                break;
            }
            case 3: {
                WorkSpace matchedWorkspace = this.workSpaceRepository.findByKey(id);
                criteriaList.add(Criteria.where((String)"workSpaces").in(new Object[]{matchedWorkspace.getId()}));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        Criteria finalCriteria = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
        Query query = new Query((CriteriaDefinition)finalCriteria);
        List types = this.mongoTemplate.find(query, CollaborationType.class);
        return types;
    }

    public List<CollaborationType> getAllTypes(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        String origin = (String)payload.get("origin");
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        switch (1.$SwitchMap$com$viztrend$safe$enums$EnumCollaborationTypeContext[EnumCollaborationTypeContext.getEnumByCode((String)context).ordinal()]) {
            case 1: {
                return this.handleSessionContext(id, origin, tenantCriteria);
            }
            case 2: {
                return this.handleSolutionContext(id, tenantCriteria);
            }
            case 3: {
                return this.handleWorkspaceContext(id, tenantCriteria);
            }
        }
        return new ArrayList<CollaborationType>();
    }

    public void createAllTypes(String id, Map payload) throws Exception {
        String context = (String)payload.get("context");
        String origin = (String)payload.get("origin");
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Criteria tenantCriteria = Criteria.where((String)"tenant").is((Object)tenant);
        switch (1.$SwitchMap$com$viztrend$safe$enums$EnumCollaborationTypeContext[EnumCollaborationTypeContext.getEnumByCode((String)context).ordinal()]) {
            case 1: {
                this.createSessionContextTypes(id, origin, tenantCriteria);
                break;
            }
            case 2: {
                this.createSolutionContextTypes(id, tenantCriteria);
                break;
            }
            case 3: {
                this.createWorkspaceContextTypes(id, tenantCriteria);
            }
        }
    }

    private void createSessionContextTypes(String id, String origin, Criteria tenantCriteria) throws Exception {
        this.createTypeIfNotExists(EnumCollaborationType.GENERAL.getTitle(), "session");
        this.createTypeIfNotExists(EnumCollaborationType.INSPECT_AND_ADAPT.getTitle(), "sessionInspect");
    }

    private List<CollaborationType> handleSessionContext(String id, String origin, Criteria tenantCriteria) throws Exception {
        ArrayList<CollaborationType> allTypes = new ArrayList<CollaborationType>();
        if (PropertyValidator.isValid((Object)origin) && "sessionBoard".equals(origin)) {
            Session session = this.sessionRepository.findByActiveSessionBoard(id);
            id = session.getId();
        }
        SessionBoard sessionBoard = null;
        Session session = this.sessionRepository.findById(id);
        sessionBoard = !PropertyValidator.isValid((Object)session) ? this.sessionBoardRepository.findById(id) : this.sessionBoardRepository.findById(session.getActiveSessionBoard());
        List teams = null;
        if (PropertyValidator.isValid((Object)sessionBoard)) {
            teams = sessionBoard.getTeams();
            Criteria noDefaultOriginCriteria = Criteria.where((String)"sessions").in(new Object[]{id}).and("defaultOrigin").exists(false);
            Criteria sessionCriteria = Criteria.where((String)"defaultOrigin").in(new Object[]{"session", "sessionInspect"});
            Criteria sessionTeamCriteria = Criteria.where((String)"defaultOrigin").is((Object)"sessionTeam").and("teams." + id).in((Collection)teams.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            Criteria finalCriteria = new Criteria().andOperator(new Criteria[]{tenantCriteria, new Criteria().orOperator(new Criteria[]{sessionCriteria, noDefaultOriginCriteria})});
            List types = this.mongoTemplate.find(new Query((CriteriaDefinition)finalCriteria), CollaborationType.class);
            allTypes.addAll(types);
        }
        return allTypes;
    }

    private void addIfMissing(String title, String origin, List<CollaborationType> types) throws Exception {
        if (types.stream().noneMatch(t -> title.equalsIgnoreCase(t.getTitle()) && t.getDefaultOrigin() != null)) {
            CollaborationType collabType = new CollaborationType();
            collabType.setTitle(title);
            collabType.setDefaultOrigin(origin);
            this.collaborationTypeRepository.save((Object)collabType);
        }
    }

    private List<CollaborationType> handleSolutionContext(String id, Criteria tenantCriteria) throws Exception {
        ArrayList<CollaborationType> allTypes = new ArrayList<CollaborationType>();
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(id);
        ArrayList sessionBoards = solutionBoard.getPiSessions();
        List sessions = this.sessionRepository.findSessionsByIdIn((List)sessionBoards);
        Criteria noDefaultOriginCriteria = Criteria.where((String)"solutionBoards").in(new Object[]{id}).and("defaultOrigin").exists(false);
        Criteria solutionCriteria = Criteria.where((String)"defaultOrigin").is((Object)"solution");
        Criteria finalCriteria = new Criteria().andOperator(new Criteria[]{tenantCriteria, new Criteria().orOperator(new Criteria[]{solutionCriteria, noDefaultOriginCriteria})});
        List types = this.mongoTemplate.find(new Query((CriteriaDefinition)finalCriteria), CollaborationType.class);
        allTypes.addAll(types);
        return allTypes;
    }

    private void createSolutionContextTypes(String id, Criteria tenantCriteria) throws Exception {
        this.createTypeIfNotExists(EnumCollaborationType.GENERAL.getTitle(), "solution");
    }

    private List<CollaborationType> handleWorkspaceContext(String id, Criteria tenantCriteria) throws Exception {
        ArrayList<CollaborationType> allTypes = new ArrayList<CollaborationType>();
        WorkSpace workspace = this.workSpaceRepository.findByKey(id);
        Map result = null;
        result = this.releaseTrainService.getReleaseSolutionBoardsAndPiBoards(workspace.getId());
        List solutionBoards = (List)result.get("solutionBoards");
        List sessions = (List)result.get("sessions");
        if (solutionBoards == null) {
            solutionBoards = Collections.emptyList();
        }
        if (sessions == null) {
            sessions = Collections.emptyList();
        }
        Criteria noDefaultOriginCriteria = Criteria.where((String)"workSpaces").in(new Object[]{workspace.getId()}).and("defaultOrigin").exists(false);
        Criteria workspaceCriteria = Criteria.where((String)"defaultOrigin").is((Object)"workspace");
        Criteria finalCriteria = new Criteria().andOperator(new Criteria[]{tenantCriteria, new Criteria().orOperator(new Criteria[]{workspaceCriteria, noDefaultOriginCriteria})});
        List types = this.mongoTemplate.find(new Query((CriteriaDefinition)finalCriteria), CollaborationType.class);
        allTypes.addAll(types);
        return allTypes;
    }

    private void createWorkspaceContextTypes(String id, Criteria tenantCriteria) throws Exception {
        this.createTypeIfNotExists(EnumCollaborationType.GENERAL.getTitle(), "workspace");
    }

    public CollaborationType createType(Map payload) throws Exception {
        String context = (String)payload.get("context");
        String origin = (String)payload.get("origin");
        String title = (String)payload.get("title");
        String id = (String)payload.get("id");
        CollaborationType type = new CollaborationType();
        type.setTitle(title);
        switch (1.$SwitchMap$com$viztrend$safe$enums$EnumCollaborationTypeContext[EnumCollaborationTypeContext.getEnumByCode((String)context).ordinal()]) {
            case 1: {
                Session session = "sessionBoard".equals(origin) ? this.sessionRepository.findByActiveSessionBoard(id) : this.sessionRepository.findById(id);
                if (!PropertyValidator.isValid((Object)session)) break;
                type.setSessions(Collections.singletonList(session));
                break;
            }
            case 2: {
                SolutionBoard solutionBoard = this.solutionBoardRepository.findById(id);
                if (!PropertyValidator.isValid((Object)solutionBoard)) break;
                type.setSolutionBoards(Collections.singletonList(solutionBoard));
                break;
            }
            case 3: {
                WorkSpace workSpace = this.workSpaceRepository.findByKey(id);
                if (!PropertyValidator.isValid((Object)workSpace)) break;
                type.setWorkSpaces(Collections.singletonList(workSpace));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid context: " + context);
            }
        }
        return (CollaborationType)this.collaborationTypeRepository.save((Object)type);
    }

    public CollaborationType deleteTypeById(String id) throws Exception {
        Optional collaborationTypeOptional;
        if (PropertyValidator.isValid((Object)id) && (collaborationTypeOptional = this.collaborationTypeRepository.findById(id)).isPresent()) {
            CollaborationType collaborationType = (CollaborationType)collaborationTypeOptional.get();
            collaborationType.setRowStatus(1);
            return (CollaborationType)this.collaborationTypeRepository.save((Object)collaborationType);
        }
        return null;
    }

    public List<CollaborationType> getAllTypes() throws Exception {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        return this.mongoTemplate.find(query, CollaborationType.class, "collaborationType");
    }

    private void createTypeIfNotExists(String title, String origin) throws Exception {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        String currentUserEmail = UserContextUtil.getUserContext().getLoggedInUser().getEmail();
        String titleRegex = DBUtils.toCaseInsensitiveRegex((String)title);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant).and("title").regex(titleRegex, "i").and("defaultOrigin").is((Object)origin));
        Update update = new Update().setOnInsert("tenant", (Object)tenant).setOnInsert("title", (Object)title).setOnInsert("defaultOrigin", (Object)origin).setOnInsert("createdBy", (Object)currentUserEmail).setOnInsert("createdOn", (Object)new Date()).setOnInsert("archive", (Object)false).setOnInsert("rowStatus", (Object)0).setOnInsert("_class", (Object)CollaborationType.class.getName());
        this.mongoTemplate.upsert(query, update, CollaborationType.class);
    }
}

