/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatus;
import com.viztrend.safe.persistence.entity.TimeSeriesSyncStatusRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.service.ChangeLogSyncService;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class ChangeLogSyncServiceImpl
implements ChangeLogSyncService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeLogSyncServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private TimeSeriesSyncStatusRepository timeSeriesSyncStatusRepository;
    @Autowired
    private ObjectiveService objectiveService;
    @Autowired
    private BaseItemRepository baseItemRepository;

    public void updateItemAndChild(List<String> itemIds) throws Exception {
        try {
            LOGGER.debug("Updating item and child");
            List objectIds = itemIds.stream().map(ObjectId::new).collect(Collectors.toList());
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(objectIds));
            Update update = new Update();
            update.set("changeRevision", (Object)new Date());
            LOGGER.debug("Query for updating baseItems: {} and update parameters are: {}", (Object)query, (Object)update);
            WriteResult wr = this.mongoTemplate.updateMulti(query, update, "item");
            LOGGER.debug(wr.getN() + " parent items updated in method updateItemAndChild()");
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in(objectIds));
            wr = this.mongoTemplate.updateMulti(query, update, "item");
            LOGGER.debug(wr.getN() + " child items updated in method updateItemAndChild()");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public boolean reSyncOKRItems(Map<String, Object> requestStr) throws Exception {
        LOGGER.debug("reSyncOKRItems called");
        String baseItemType = "";
        boolean isResyncDone = false;
        List itemTypes = new ArrayList();
        List baseItemIds = new ArrayList();
        ArrayList<String> objectiveIds = new ArrayList<String>();
        String sessionBoardId = "";
        String activeSessionBoard = "";
        boolean globalOKRs = false;
        if (PropertyValidator.isValid((Object)requestStr.get("itemTypes"))) {
            itemTypes = (List)requestStr.get("itemTypes");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("baseItemIds"))) {
            baseItemIds = (List)requestStr.get("baseItemIds");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("baseItemType"))) {
            baseItemType = (String)requestStr.get("baseItemType");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("globalOKRs"))) {
            globalOKRs = (Boolean)requestStr.get("globalOKRs");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("sessionBoardId"))) {
            sessionBoardId = (String)requestStr.get("sessionBoardId");
        }
        if (PropertyValidator.isValid((Object)requestStr.get("activeSessionBoard"))) {
            activeSessionBoard = (String)requestStr.get("activeSessionBoard");
        }
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        List timeSeriesSyncStatuses = this.timeSeriesSyncStatusRepository.findByTenant(tenant);
        ArrayList<String> syncedItemsTypes = new ArrayList<String>();
        HashSet<String> syncedSessionBoardIds = new HashSet<String>();
        for (TimeSeriesSyncStatus status : timeSeriesSyncStatuses) {
            syncedItemsTypes.add(status.getItemType());
            if (!PropertyValidator.isValid((Object)status.getSessionBoardId())) continue;
            syncedSessionBoardIds.add(status.getSessionBoardId());
        }
        if (globalOKRs) {
            WriteResult wr;
            Update update;
            Query query;
            TimeSeriesSyncStatus timeSeriesSyncStatus;
            LOGGER.debug("global OKRs manual sync case");
            if (!syncedItemsTypes.contains("baseItem")) {
                LOGGER.debug("baseItems manual sync case");
                timeSeriesSyncStatus = new TimeSeriesSyncStatus("baseItem", true);
                this.timeSeriesSyncStatusRepository.save((Object)timeSeriesSyncStatus);
                query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                update = new Update();
                update.set("changeRevision", (Object)new Date());
                LOGGER.debug("Query for updating baseItems: {} and update parameters are: {}", (Object)query, (Object)update);
                wr = this.mongoTemplate.updateMulti(query, update, "baseItem");
                LOGGER.debug(wr.getN() + " baseItems updated in method reSyncOKRItems()");
                isResyncDone = true;
            }
            if (!syncedItemsTypes.contains("backlogItem")) {
                LOGGER.debug("backlogItems manual sync case");
                timeSeriesSyncStatus = new TimeSeriesSyncStatus("backlogItem", true);
                this.timeSeriesSyncStatusRepository.save((Object)timeSeriesSyncStatus);
                query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                update = new Update();
                update.set("changeRevision", (Object)new Date());
                LOGGER.debug("Query for updating backlogItems: {} and update parameters are: {}", (Object)query, (Object)update);
                wr = this.mongoTemplate.updateMulti(query, update, "backlogItem");
                LOGGER.debug(wr.getN() + " backlogItems updated in method reSyncOKRItems()");
                isResyncDone = true;
            }
            if (!PropertyValidator.isValid(objectiveIds)) {
                ArrayList<BaseItemLink> baseItemLinks = new ArrayList<BaseItemLink>();
                List all = this.objectiveService.loadBaseItemLinksBySessionIdAndType(Boolean.valueOf(false), "-1");
                for (BaseItemLink baseItemLink : all) {
                    if (!PropertyValidator.isValid((Object)baseItemLink.getType()) || !baseItemLink.getType().equals("Objective-Group")) continue;
                    baseItemLinks.add(baseItemLink);
                }
                List objectiveGroupList = this.baseItemRepository.findByBaseItemLinksInOrderBySequenceAsc(baseItemLinks);
                if (PropertyValidator.isValid((Collection)objectiveGroupList)) {
                    for (BaseItem objectiveGroup : objectiveGroupList) {
                        for (BaseItemLink link : objectiveGroup.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !"-1".equals(link.getSessionId())) continue;
                            objectiveIds.add(link.getBaseItemId());
                        }
                    }
                }
            }
            if (this.updateItems(baseItemType, baseItemIds, objectiveIds, tenant)) {
                isResyncDone = true;
            }
        } else {
            Iterator iterator = itemTypes.iterator();
            while (iterator.hasNext()) {
                String itemType;
                switch (itemType = (String)iterator.next()) {
                    case "baseItem": {
                        if (syncedItemsTypes.contains("baseItem")) break;
                        LOGGER.debug("baseItems manual sync case");
                        TimeSeriesSyncStatus timeSeriesSyncStatus = new TimeSeriesSyncStatus(itemType, true);
                        this.timeSeriesSyncStatusRepository.save((Object)timeSeriesSyncStatus);
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                        Update update = new Update();
                        update.set("changeRevision", (Object)new Date());
                        LOGGER.debug("Query for updating baseItems: {} and update parameters are: {}", (Object)query, (Object)update);
                        WriteResult wr = this.mongoTemplate.updateMulti(query, update, "baseItem");
                        LOGGER.debug(wr.getN() + " baseItems updated in method reSyncOKRItems()");
                        isResyncDone = true;
                        break;
                    }
                    case "item": {
                        LOGGER.debug("items manual sync case");
                        if (!PropertyValidator.isValid((Object)sessionBoardId) || syncedSessionBoardIds.contains(sessionBoardId) || !activeSessionBoard.equalsIgnoreCase(sessionBoardId)) break;
                        TimeSeriesSyncStatus timeSeriesSyncStatus = new TimeSeriesSyncStatus("item", true);
                        timeSeriesSyncStatus.setSessionBoardId(sessionBoardId);
                        this.timeSeriesSyncStatusRepository.save((Object)timeSeriesSyncStatus);
                        if (!this.updateItems(baseItemType, baseItemIds, objectiveIds, tenant)) break;
                        isResyncDone = true;
                    }
                }
            }
        }
        return isResyncDone;
    }

    public void updateBaseItem(String baseItemId) throws Exception {
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        ObjectId objectId = new ObjectId(baseItemId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant).and("_id").in(new Object[]{objectId}));
        Update update = new Update();
        update.set("changeRevision", (Object)new Date());
        LOGGER.debug("Query for updating baseItems: {} and update parameters are: {}", (Object)query, (Object)update);
        this.mongoTemplate.updateMulti(query, update, "baseItem");
    }

    public void updateBaseItems(List<String> baseItemIds) throws Exception {
        String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
        List objectIds = baseItemIds.stream().map(ObjectId::new).distinct().collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant).and("_id").in(objectIds));
        Update update = new Update();
        update.set("changeRevision", (Object)new Date());
        LOGGER.debug("Query for updating baseItems: {} and update parameters are: {}", (Object)query, (Object)update);
        WriteResult wr = this.mongoTemplate.updateMulti(query, update, "baseItem");
        LOGGER.debug(wr.getN() + " baseItems updated in method updateBaseItems()");
    }

    public void fetchObjectiveLinkedItems(List<String> allObjectiveIds, List<String> objectiveIds, Set<String> itemIds, Set<String> jiraKeys, Set<String> tfsIds) throws Exception {
        List objObjectIds = objectiveIds.stream().map(ObjectId::new).distinct().collect(Collectors.toList());
        List objectives = this.objectiveService.loadObjectivesByBaseItemId(objObjectIds);
        if (!objectives.isEmpty()) {
            for (BaseItem objective : objectives) {
                for (BaseItemLink link : objective.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link.getLinkedItemById()) || link.isArchive()) continue;
                    for (Map.Entry entry : link.getLinkedItemById().entrySet()) {
                        itemIds.add((String)entry.getKey());
                        Map linkedItem = (Map)entry.getValue();
                        if (linkedItem.containsKey("jiraKey")) {
                            jiraKeys.add((String)linkedItem.get("jiraKey"));
                        }
                        if (!linkedItem.containsKey("tfsId")) continue;
                        tfsIds.add((String)linkedItem.get("tfsId"));
                    }
                }
            }
            ArrayList keyResultIds = new ArrayList();
            for (BaseItem baseItem : objectives) {
                keyResultIds.addAll(baseItem.getBaseItemLinks().stream().filter(l -> EnumKendis.CHILD_OBJECTIVE.getCode().equalsIgnoreCase(l.getLinkType())).map(BaseItemLink::getBaseItemId).distinct().collect(Collectors.toList()));
            }
            if (!keyResultIds.isEmpty()) {
                this.fetchKeyResultLinkedItems(allObjectiveIds, keyResultIds, itemIds, jiraKeys, tfsIds);
            }
        }
    }

    public void fetchKeyResultLinkedItems(List<String> objectiveIds, List<String> keyResultIds, Set<String> itemIds, Set<String> jiraKeys, Set<String> tfsIds) throws Exception {
        ArrayList<String> KRLinkedObjectiveIds = new ArrayList<String>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(keyResultIds));
        query.fields().include("id");
        query.fields().include("title");
        query.fields().include("baseItemLinks");
        List keyResults = this.mongoTemplate.find(query, BaseItem.class);
        for (BaseItem item : keyResults) {
            List links = item.getBaseItemLinks();
            for (BaseItemLink link : links) {
                Map linkedItemByIdsMap;
                if (EnumKendis.SESSION_LINK_OBJECTIVE.getCode().equalsIgnoreCase(link.getLinkType()) && PropertyValidator.isValid((Object)(linkedItemByIdsMap = link.getLinkedItemById()))) {
                    itemIds.addAll(linkedItemByIdsMap.keySet());
                    for (Map.Entry entry : linkedItemByIdsMap.entrySet()) {
                        Map linkedItem = (Map)entry.getValue();
                        if (linkedItem.containsKey("jiraKey")) {
                            jiraKeys.add((String)linkedItem.get("jiraKey"));
                        }
                        if (!linkedItem.containsKey("tfsId")) continue;
                        tfsIds.add((String)linkedItem.get("tfsId"));
                    }
                }
                if (!EnumKendis.PARENT_OKR.getCode().equalsIgnoreCase(link.getLinkType()) || objectiveIds.contains(link.getBaseItemId())) continue;
                KRLinkedObjectiveIds.add(link.getBaseItemId());
            }
        }
        if (!KRLinkedObjectiveIds.isEmpty()) {
            this.fetchObjectiveLinkedItems(objectiveIds, KRLinkedObjectiveIds, itemIds, jiraKeys, tfsIds);
        }
    }

    private boolean updateItems(String baseItemType, List<String> baseItemIds, List<String> objectiveIds, String tenant) throws Exception {
        boolean isResyncDone = false;
        HashSet itemIds = new HashSet();
        HashSet jiraKeys = new HashSet();
        HashSet tfsId = new HashSet();
        if ("objectiveGroup".equalsIgnoreCase(baseItemType)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(baseItemIds));
            query.fields().include("id");
            query.fields().include("title");
            query.fields().include("baseItemLinks");
            List objectiveGroups = this.mongoTemplate.find(query, BaseItem.class);
            for (BaseItem objectiveGroup : objectiveGroups) {
                for (BaseItemLink link : objectiveGroup.getBaseItemLinks()) {
                    if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive()) continue;
                    objectiveIds.add(link.getBaseItemId());
                }
            }
        } else if ("objective".equalsIgnoreCase(baseItemType)) {
            objectiveIds = baseItemIds;
        }
        this.fetchObjectiveLinkedItems(objectiveIds, objectiveIds, itemIds, jiraKeys, tfsId);
        if (!(itemIds.isEmpty() && jiraKeys.isEmpty() && tfsId.isEmpty())) {
            BasicDBObject itemQuery = new BasicDBObject("$and", Arrays.asList(new BasicDBObject("tenant", (Object)tenant), new BasicDBObject("$or", Arrays.asList(new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", tfsId)), new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", jiraKeys))))));
            List objectIds = itemIds.stream().map(ObjectId::new).collect(Collectors.toList());
            DBCollection itemCollection = this.mongoTemplate.getCollection("item");
            DBCursor dbCursor = itemCollection.find((DBObject)itemQuery);
            while (dbCursor.hasNext()) {
                DBObject dbObject = (DBObject)dbCursor.next();
                ObjectId itemId = (ObjectId)dbObject.get("_id");
                objectIds.add(itemId);
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant).and("_id").in(objectIds));
            Update update = new Update();
            update.set("changeRevision", (Object)new Date());
            LOGGER.debug("Query for updating items: {} and update parameters are: {}", (Object)query, (Object)update);
            WriteResult wr = this.mongoTemplate.updateMulti(query, update, "item");
            if (wr.getN() > 0) {
                isResyncDone = true;
            }
            LOGGER.debug(wr.getN() + " parent items updated in method updateItems()");
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$ref").is((Object)"item").and("parent.$id").in(objectIds));
            wr = this.mongoTemplate.updateMulti(query, update, "item");
            if (wr.getN() > 0) {
                isResyncDone = true;
            }
            LOGGER.debug(wr.getN() + " child items updated in method updateItems()");
        }
        return isResyncDone;
    }
}

