/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.enums.EnumCollaborationType;
import com.viztrend.safe.persistence.entity.CollaborationType;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CollaborationTypeRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class CanvasBoardLegacyMigrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanvasBoardLegacyMigrationService.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private CollaborationTypeRepository collaborationTypeRepository;

    public List<String> migrateLegacySessionBoards(String sessionId) {
        ArrayList<String> migratedBoardIds = new ArrayList<String>();
        try {
            LOGGER.debug("Checking for legacy session boards for sessionId: {}", (Object)sessionId);
            SecureUser secureUser = UserContextUtil.getUserContext();
            String tenant = secureUser.getCurrentCompany().getTenant();
            BasicDBObject queryDoc = new BasicDBObject("session.$id", (Object)new ObjectId(sessionId));
            queryDoc.put("tenant", (Object)tenant);
            ArrayList<DBObject> legacyDocs = new ArrayList<DBObject>();
            DBCursor cursor = this.mongoTemplate.getDb().getCollection("canvasBoard").find((DBObject)queryDoc);
            while (cursor.hasNext()) {
                legacyDocs.add(cursor.next());
            }
            cursor.close();
            LOGGER.debug("Found {} legacy session boards to migrate", (Object)legacyDocs.size());
            for (DBObject doc : legacyDocs) {
                String boardId = this.migrateLegacySessionDocument(doc);
                if (boardId == null) continue;
                migratedBoardIds.add(boardId);
            }
            LOGGER.debug("Successfully migrated {} legacy session boards", (Object)migratedBoardIds.size());
        }
        catch (Exception e) {
            LOGGER.error("Error migrating legacy session boards for sessionId {}: {}", new Object[]{sessionId, e.getMessage(), e});
        }
        return migratedBoardIds;
    }

    public List<String> migrateLegacySolutionBoards(String solutionBoardId) {
        ArrayList<String> migratedBoardIds = new ArrayList<String>();
        try {
            LOGGER.debug("Checking for legacy solution boards for solutionBoardId: {}", (Object)solutionBoardId);
            SecureUser secureUser = UserContextUtil.getUserContext();
            String tenant = secureUser.getCurrentCompany().getTenant();
            BasicDBObject queryDoc = new BasicDBObject("solutionBoard.$id", (Object)new ObjectId(solutionBoardId));
            queryDoc.put("tenant", (Object)tenant);
            ArrayList<DBObject> legacyDocs = new ArrayList<DBObject>();
            DBCursor cursor = this.mongoTemplate.getDb().getCollection("canvasBoard").find((DBObject)queryDoc);
            while (cursor.hasNext()) {
                legacyDocs.add(cursor.next());
            }
            cursor.close();
            LOGGER.debug("Found {} legacy solution boards to migrate", (Object)legacyDocs.size());
            for (DBObject doc : legacyDocs) {
                String boardId = this.migrateLegacySolutionDocument(doc);
                if (boardId == null) continue;
                migratedBoardIds.add(boardId);
            }
            LOGGER.debug("Successfully migrated {} legacy solution boards", (Object)migratedBoardIds.size());
        }
        catch (Exception e) {
            LOGGER.error("Error migrating legacy solution boards for solutionBoardId {}: {}", (Object)solutionBoardId, (Object)StringUtils.getTraceString((Throwable)e));
        }
        return migratedBoardIds;
    }

    private String migrateLegacySessionDocument(DBObject doc) throws Exception {
        String boardId = doc.get("_id").toString();
        Object sessionData = doc.get("session");
        if (sessionData != null) {
            ArrayList<Object> sessions = new ArrayList<Object>();
            sessions.add(sessionData);
            CollaborationType generalType = this.getOrCreateGeneralType("session");
            Update update = new Update().set("sessions", sessions).set("collaborationType", (Object)generalType).unset("session").unset("workSpaces");
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)boardId));
            this.mongoTemplate.updateFirst(query, update, "canvasBoard");
            LOGGER.debug("Migrated legacy session board: {}", (Object)boardId);
            return boardId;
        }
        return null;
    }

    private String migrateLegacySolutionDocument(DBObject doc) throws Exception {
        String boardId = doc.get("_id").toString();
        Object solutionBoardData = doc.get("solutionBoard");
        if (solutionBoardData != null) {
            ArrayList<Object> solutionBoards = new ArrayList<Object>();
            solutionBoards.add(solutionBoardData);
            CollaborationType generalType = this.getOrCreateGeneralType("solution");
            Update update = new Update().set("solutionBoards", solutionBoards).set("collaborationType", (Object)generalType).unset("solutionBoard").unset("workSpaces");
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)boardId));
            this.mongoTemplate.updateFirst(query, update, "canvasBoard");
            LOGGER.debug("Migrated legacy solution board: {}", (Object)boardId);
            return boardId;
        }
        return null;
    }

    private CollaborationType getOrCreateGeneralType(String defaultOrigin) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").is((Object)EnumCollaborationType.GENERAL.getTitle()).and("defaultOrigin").is((Object)defaultOrigin));
            CollaborationType generalType = (CollaborationType)this.mongoTemplate.findOne(query, CollaborationType.class);
            if (!PropertyValidator.isValid((Object)generalType)) {
                generalType = new CollaborationType();
                generalType.setTitle(EnumCollaborationType.GENERAL.getTitle());
                generalType.setDefaultOrigin(defaultOrigin);
                generalType.setRowStatus(0);
                generalType = (CollaborationType)this.collaborationTypeRepository.save((Object)generalType);
                LOGGER.debug("Created new 'General' collaboration type for defaultOrigin '{}' with ID: {}", (Object)defaultOrigin, (Object)generalType.getId());
            }
            return generalType;
        }
        catch (Exception e) {
            LOGGER.error("Error getting or creating General collaboration type for defaultOrigin '{}': {}", new Object[]{defaultOrigin, e.getMessage(), e});
            CollaborationType fallbackType = new CollaborationType();
            fallbackType.setId("general");
            fallbackType.setTitle("General");
            fallbackType.setDefaultOrigin(defaultOrigin);
            return fallbackType;
        }
    }

    public boolean hasLegacySessionBoards(String sessionId) {
        try {
            BasicDBObject queryDoc = new BasicDBObject("session.$id", (Object)new ObjectId(sessionId));
            long count = this.mongoTemplate.getDb().getCollection("canvasBoard").count((DBObject)queryDoc);
            return count > 0L;
        }
        catch (Exception e) {
            LOGGER.error("Error checking for legacy session boards: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public boolean hasLegacySolutionBoards(String solutionBoardId) {
        try {
            BasicDBObject queryDoc = new BasicDBObject("solutionBoard.$id", (Object)new ObjectId(solutionBoardId));
            long count = this.mongoTemplate.getDb().getCollection("canvasBoard").count((DBObject)queryDoc);
            return count > 0L;
        }
        catch (Exception e) {
            LOGGER.error("Error checking for legacy solution boards: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

