/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.repository.FieldTemplateRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.BatchInfrastructureService;
import com.viztrend.safe.service.BatchService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BatchInfrastructureServiceImpl
implements BatchInfrastructureService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchInfrastructureServiceImpl.class);
    private final ItemTypeRepository itemTypeRepository;
    private final WorkFlowRepository workFlowRepository;
    private final FieldTemplateRepository fieldTemplateRepository;
    private final ItemTypeSchemeRepository itemTypeSchemeRepository;
    private final FieldsRepository fieldsRepository;
    private final StatusRepository statusRepository;
    private final BatchService batchService;
    private final MongoTemplate mongoTemplate;

    @Autowired
    public BatchInfrastructureServiceImpl(ItemTypeRepository itemTypeRepository, WorkFlowRepository workFlowRepository, FieldTemplateRepository fieldTemplateRepository, ItemTypeSchemeRepository itemTypeSchemeRepository, FieldsRepository fieldsRepository, StatusRepository statusRepository, BatchService batchService, MongoTemplate mongoTemplate) {
        this.itemTypeRepository = itemTypeRepository;
        this.workFlowRepository = workFlowRepository;
        this.fieldTemplateRepository = fieldTemplateRepository;
        this.itemTypeSchemeRepository = itemTypeSchemeRepository;
        this.fieldsRepository = fieldsRepository;
        this.statusRepository = statusRepository;
        this.batchService = batchService;
        this.mongoTemplate = mongoTemplate;
    }

    public Boolean isBatchInfrastructureExists() {
        LOGGER.debug("Checking if batch infrastructure exists");
        ItemType batchItemType = this.itemTypeRepository.findByTitle(EnumBaseItemTypes.BATCH.getName());
        ItemType batchGroupItemType = this.itemTypeRepository.findByTitle(EnumBaseItemTypes.BATCH_GROUP.getName());
        if (!PropertyValidator.isValid((Object)batchItemType) || !PropertyValidator.isValid((Object)batchGroupItemType)) {
            LOGGER.debug("Batch infrastructure missing: ItemTypes not found");
            return false;
        }
        FieldTemplate batchFieldTemplate = this.fieldTemplateRepository.findByType(EnumBaseItemTypes.BATCH.getName());
        FieldTemplate batchGroupFieldTemplate = this.fieldTemplateRepository.findByType(EnumBaseItemTypes.BATCH_GROUP.getName());
        if (!PropertyValidator.isValid((Object)batchFieldTemplate) || !PropertyValidator.isValid((Object)batchGroupFieldTemplate)) {
            LOGGER.debug("Batch infrastructure missing: FieldTemplates not found");
            return false;
        }
        List batchWorkflows = this.workFlowRepository.findAllByWorkflowType(EnumBaseItemTypes.BATCH.getName());
        List batchGroupWorkflows = this.workFlowRepository.findAllByWorkflowType(EnumBaseItemTypes.BATCH_GROUP.getName());
        if (batchWorkflows.isEmpty()) {
            LOGGER.debug("Batch infrastructure missing: WorkFlow not found for type {}", (Object)EnumBaseItemTypes.BATCH.getName());
            return false;
        }
        if (batchGroupWorkflows.isEmpty()) {
            LOGGER.debug("Batch infrastructure missing: WorkFlow not found for type {}", (Object)EnumBaseItemTypes.BATCH_GROUP.getName());
            return false;
        }
        ItemTypeScheme batchItemTypeScheme = this.itemTypeSchemeRepository.findByItemType(batchItemType);
        ItemTypeScheme batchGroupItemTypeScheme = this.itemTypeSchemeRepository.findByItemType(batchGroupItemType);
        if (!PropertyValidator.isValid((Object)batchItemTypeScheme) || !PropertyValidator.isValid((Object)batchGroupItemTypeScheme)) {
            LOGGER.debug("Batch infrastructure missing: ItemTypeSchemes not found");
            return false;
        }
        LOGGER.debug("Batch infrastructure exists and is complete");
        return true;
    }

    @Transactional
    public Map<String, Object> initializeBatchInfrastructure() throws KendisException {
        LOGGER.info("Starting batch infrastructure initialization (upsert mode - will create or update)");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> processedComponents = new ArrayList<String>();
        try {
            LOGGER.info("Upserting ItemTypes for batch and batch_group");
            ItemType batchGroupItemType = this.upsertItemType(EnumBaseItemTypes.BATCH_GROUP.getName());
            ItemType batchItemType = this.upsertItemType(EnumBaseItemTypes.BATCH.getName());
            processedComponents.add("ItemTypes");
            LOGGER.info("Upserting WorkFlows for batch and batch_group");
            WorkFlow batchGroupWorkflow = this.upsertWorkflow(EnumBaseItemTypes.BATCH_GROUP.getName());
            WorkFlow batchWorkflow = this.upsertWorkflow(EnumBaseItemTypes.BATCH.getName());
            processedComponents.add("WorkFlows");
            LOGGER.info("Upserting FieldTemplates for batch and batch_group");
            FieldTemplate batchGroupFieldTemplate = this.upsertFieldTemplate("batch_group", batchGroupItemType);
            FieldTemplate batchFieldTemplate = this.upsertFieldTemplate("Batch", batchItemType);
            processedComponents.add("FieldTemplates");
            LOGGER.info("Upserting ItemTypeSchemes for batch and batch_group");
            ItemTypeScheme batchGroupItemTypeScheme = this.upsertItemTypeScheme(batchGroupItemType, batchGroupWorkflow, batchGroupFieldTemplate);
            ItemTypeScheme batchItemTypeScheme = this.upsertItemTypeScheme(batchItemType, batchWorkflow, batchFieldTemplate);
            processedComponents.add("ItemTypeSchemes");
            result.put("success", true);
            result.put("processedComponents", processedComponents);
            result.put("batchGroupItemType", batchGroupItemType.getId());
            result.put("batchItemType", batchItemType.getId());
            result.put("batchGroupWorkflow", batchGroupWorkflow.getId());
            result.put("batchWorkflow", batchWorkflow.getId());
            result.put("batchGroupFieldTemplate", batchGroupFieldTemplate.getId());
            result.put("batchFieldTemplate", batchFieldTemplate.getId());
            result.put("batchGroupItemTypeScheme", batchGroupItemTypeScheme.getId());
            result.put("batchItemTypeScheme", batchItemTypeScheme.getId());
            LOGGER.info("Successfully initialized batch infrastructure with components: {}", processedComponents);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error initializing batch infrastructure: {}", (Object)StringUtils.getTraceString((Throwable)e));
            throw new KendisException("INFRASTRUCTURE_CREATION_FAILED", "Failed to create batch infrastructure: " + e.getMessage());
        }
    }

    public Map<String, Object> getBatchModalTemplateData() throws KendisException {
        LOGGER.debug("Fetching batch modal template data");
        if (!this.isBatchInfrastructureExists().booleanValue()) {
            throw new KendisException("INFRASTRUCTURE_NOT_EXISTS", "Batch infrastructure does not exist");
        }
        try {
            ArrayList<String> whereInClause = new ArrayList<String>();
            whereInClause.add(EnumBaseItemTypes.BATCH_GROUP.getName());
            whereInClause.add(EnumBaseItemTypes.BATCH.getName());
            List itemTypes = this.itemTypeRepository.findByTitleIn(whereInClause);
            ItemType batchGroupItemType = null;
            ItemType batchItemType = null;
            for (ItemType it : itemTypes) {
                if (it.getTitle().equals(EnumBaseItemTypes.BATCH_GROUP.getName())) {
                    batchGroupItemType = it;
                    continue;
                }
                if (!it.getTitle().equals(EnumBaseItemTypes.BATCH.getName())) continue;
                batchItemType = it;
            }
            List batchGroupWorkFlowList = this.workFlowRepository.findAllByWorkflowType(EnumBaseItemTypes.BATCH_GROUP.getName());
            List batchGroupStatuses = this.statusRepository.findByWorkFlow((WorkFlow)batchGroupWorkFlowList.get(0));
            List batchWorkFlowList = this.workFlowRepository.findAllByWorkflowType(EnumBaseItemTypes.BATCH.getName());
            List batchStatuses = this.statusRepository.findByWorkFlow((WorkFlow)batchWorkFlowList.get(0));
            ArrayList<ItemType> itemTypeList = new ArrayList<ItemType>();
            itemTypeList.add(batchGroupItemType);
            itemTypeList.add(batchItemType);
            List itemTypeSchemeList = this.itemTypeSchemeRepository.findByItemTypeIn(itemTypeList);
            ItemTypeScheme batchGroupItemTypeScheme = null;
            ItemTypeScheme batchItemTypeScheme = null;
            for (ItemTypeScheme itemTypeScheme : itemTypeSchemeList) {
                if (itemTypeScheme.getItemType().equals((Object)batchGroupItemType)) {
                    batchGroupItemTypeScheme = itemTypeScheme;
                    continue;
                }
                if (!itemTypeScheme.getItemType().equals((Object)batchItemType)) continue;
                batchItemTypeScheme = itemTypeScheme;
            }
            HashMap<String, Object> jsonResponse = new HashMap<String, Object>();
            HashMap batchGroupResponse = new HashMap();
            HashMap batchResponse = new HashMap();
            batchGroupResponse.put("statuses", batchGroupStatuses);
            batchGroupResponse.put("scheme", batchGroupItemTypeScheme);
            batchResponse.put("statuses", batchStatuses);
            batchResponse.put("scheme", batchItemTypeScheme);
            jsonResponse.put("batchGroupTemplate", batchGroupResponse);
            jsonResponse.put("batchTemplate", batchResponse);
            LOGGER.info("Successfully fetched batch modal template data");
            return jsonResponse;
        }
        catch (Exception e) {
            LOGGER.error("Error fetching batch modal template data: {}", (Object)StringUtils.getTraceString((Throwable)e));
            throw new KendisException("TEMPLATE_FETCH_FAILED", "Failed to fetch batch modal template data: " + e.getMessage());
        }
    }

    private ItemType upsertItemType(String title) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"title").is((Object)title));
        Update update = new Update();
        update.set("title", (Object)title);
        update.set("isNested", (Object)false);
        this.mongoTemplate.upsert(query, update, ItemType.class);
        ItemType itemType = this.itemTypeRepository.findByTitle(title);
        if (PropertyValidator.isValid((Object)itemType) && PropertyValidator.isValid((Object)itemType.getId())) {
            LOGGER.debug("ItemType upserted successfully: {} with ID: {}", (Object)title, (Object)itemType.getId());
        } else {
            LOGGER.warn("ItemType upsert completed but entity not found: {}", (Object)title);
            itemType = new ItemType();
            itemType.setTitle(title);
            itemType.setNested(false);
            itemType = (ItemType)this.itemTypeRepository.save((Object)itemType);
            LOGGER.info("Created ItemType manually: {} with ID: {}", (Object)title, (Object)itemType.getId());
        }
        return itemType;
    }

    private WorkFlow upsertWorkflow(String workflowType) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"workflowType").is((Object)workflowType));
        WorkFlow existingWorkflow = (WorkFlow)this.mongoTemplate.findOne(query, WorkFlow.class);
        if (existingWorkflow != null && PropertyValidator.isValid((Object)existingWorkflow.getId())) {
            LOGGER.debug("WorkFlow found, using existing: {} with ID: {}", (Object)workflowType, (Object)existingWorkflow.getId());
            if (existingWorkflow.getWorkflowType() == null || !existingWorkflow.getWorkflowType().equals(workflowType)) {
                Update update = new Update();
                update.set("workflowType", (Object)workflowType);
                this.mongoTemplate.updateFirst(query, update, WorkFlow.class);
                existingWorkflow.setWorkflowType(workflowType);
                LOGGER.debug("Updated WorkFlow workflowType: {} with ID: {}", (Object)workflowType, (Object)existingWorkflow.getId());
            }
            return existingWorkflow;
        }
        LOGGER.debug("WorkFlow not found, creating: {}", (Object)workflowType);
        WorkFlow workflow = workflowType.equals(EnumBaseItemTypes.BATCH_GROUP.getName()) ? this.batchService.createDefaultBatchGroupWorkflow() : this.batchService.createDefaultBatchWorkflow();
        workflow.setWorkflowType(workflowType);
        workflow = (WorkFlow)this.workFlowRepository.save((Object)workflow);
        LOGGER.info("Created WorkFlow: {} with ID: {}", (Object)workflowType, (Object)workflow.getId());
        return workflow;
    }

    private FieldTemplate upsertFieldTemplate(String type, ItemType itemType) throws Exception {
        List fields = type.equals(EnumBaseItemTypes.BATCH_GROUP.getName()) ? this.fieldsRepository.save((Iterable)this.batchService.fetchFieldsForBatchGroup()) : this.fieldsRepository.save((Iterable)this.batchService.fetchFieldsForBatch());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        Update update = new Update();
        update.set("type", (Object)type);
        update.set("configuredFields", (Object)fields);
        this.mongoTemplate.upsert(query, update, FieldTemplate.class);
        FieldTemplate fieldTemplate = this.fieldTemplateRepository.findByType(type);
        if (PropertyValidator.isValid((Object)fieldTemplate) && PropertyValidator.isValid((Object)fieldTemplate.getId())) {
            LOGGER.debug("FieldTemplate upserted successfully: {} with ID: {}", (Object)type, (Object)fieldTemplate.getId());
        } else {
            LOGGER.warn("FieldTemplate upsert completed but entity not found: {}", (Object)type);
            fieldTemplate = new FieldTemplate();
            fieldTemplate.setType(type);
            fieldTemplate.setConfiguredFields(fields);
            fieldTemplate = (FieldTemplate)this.fieldTemplateRepository.save((Object)fieldTemplate);
            LOGGER.info("Created FieldTemplate manually: {} with ID: {}", (Object)type, (Object)fieldTemplate.getId());
        }
        return fieldTemplate;
    }

    private ItemTypeScheme upsertItemTypeScheme(ItemType itemType, WorkFlow workflow, FieldTemplate fieldTemplate) throws Exception {
        Query query;
        ItemTypeScheme existingScheme = this.itemTypeSchemeRepository.findByItemType(itemType);
        if (existingScheme != null && PropertyValidator.isValid((Object)existingScheme.getId())) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)existingScheme.getId()));
            LOGGER.debug("ItemTypeScheme exists, will update by ID: {}", (Object)existingScheme.getId());
        } else {
            query = new Query((CriteriaDefinition)Criteria.where((String)"itemType").is((Object)itemType));
            LOGGER.debug("ItemTypeScheme not found, will create new for itemType: {}", (Object)itemType.getTitle());
        }
        Update update = new Update();
        update.set("itemType", (Object)itemType);
        update.set("workflow", (Object)workflow);
        update.set("fieldsTemplate", (Object)fieldTemplate);
        this.mongoTemplate.upsert(query, update, ItemTypeScheme.class);
        ItemTypeScheme itemTypeScheme = this.itemTypeSchemeRepository.findByItemType(itemType);
        if (PropertyValidator.isValid((Object)itemTypeScheme) && PropertyValidator.isValid((Object)itemTypeScheme.getId())) {
            LOGGER.debug("ItemTypeScheme upserted successfully for: {} with ID: {}", (Object)itemType.getTitle(), (Object)itemTypeScheme.getId());
        } else {
            LOGGER.warn("ItemTypeScheme upsert completed but entity not found for: {}", (Object)itemType.getTitle());
            itemTypeScheme = new ItemTypeScheme();
            itemTypeScheme.setItemType(itemType);
            itemTypeScheme.setWorkflow(workflow);
            itemTypeScheme.setFieldsTemplate(fieldTemplate);
            itemTypeScheme = (ItemTypeScheme)this.itemTypeSchemeRepository.save((Object)itemTypeScheme);
            LOGGER.info("Created ItemTypeScheme manually for: {} with ID: {}", (Object)itemType.getTitle(), (Object)itemTypeScheme.getId());
        }
        return itemTypeScheme;
    }
}

