/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.dto.MilestoneCalculationResultDTO;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.service.BatchesCalculationService;
import com.viztrend.safe.service.MilestoneCalculationServiceImpl;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="BatchCalculationService")
public class BatchCalculationServiceImpl
implements BatchesCalculationService {
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private MilestoneCalculationServiceImpl milestoneCalculationService;

    public Map<String, Object> calculateBatchCompletion(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String batchId = null;
        if (requestBody.containsKey("batchId")) {
            batchId = (String)requestBody.get("batchId");
        }
        if (PropertyValidator.isValid(batchId)) {
            BaseItem batch = this.baseItemRepository.findById(batchId);
            if (PropertyValidator.isValid((Object)batch)) {
                Set collectionIds = batch.getBaseItemLinks().stream().filter(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId()) && PropertyValidator.isValid((Object)baseItemLink.getLinkType()) && baseItemLink.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())).map(BaseItemLink::getReleaseTrainId).collect(Collectors.toSet());
                ArrayList<MilestoneCalculationResultDTO> milestoneCalculationResultDTOList = new ArrayList<MilestoneCalculationResultDTO>();
                for (String collectionId : collectionIds) {
                    MilestoneCalculationResultDTO milestoneCalculationResultDTO = this.calculateCompletionByArt(batch, collectionId);
                    milestoneCalculationResultDTOList.add(milestoneCalculationResultDTO);
                }
                if (!milestoneCalculationResultDTOList.isEmpty()) {
                    result.put(batch.getId(), milestoneCalculationResultDTOList);
                } else {
                    MilestoneCalculationResultDTO milestoneCalculationResultDTO = new MilestoneCalculationResultDTO();
                    result.put(batch.getId(), Collections.singleton(milestoneCalculationResultDTO));
                }
                result.put("batchId", batch.getId());
                result.put("success", true);
            } else {
                result.put("error", "Invalid Batch Id");
            }
        }
        return result;
    }

    public Map<String, Object> calculateBatchCompletionInBulk(Map<String, Object> requestBody) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List batchIds = new ArrayList();
        if (requestBody.containsKey("batchIds")) {
            batchIds = (List)requestBody.get("batchIds");
        }
        if (PropertyValidator.isValid(batchIds)) {
            List batches = this.baseItemRepository.findByIdIn(batchIds);
            if (PropertyValidator.isValid((Collection)batches)) {
                for (BaseItem batch : batches) {
                    Set collectionIds = batch.getBaseItemLinks().stream().filter(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId()) && PropertyValidator.isValid((Object)baseItemLink.getLinkType()) && baseItemLink.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())).map(BaseItemLink::getReleaseTrainId).collect(Collectors.toSet());
                    ArrayList<MilestoneCalculationResultDTO> milestoneCalculationResultDTOList = new ArrayList<MilestoneCalculationResultDTO>();
                    for (String collectionId : collectionIds) {
                        MilestoneCalculationResultDTO milestoneCalculationResultDTO = this.calculateCompletionByArt(batch, collectionId);
                        milestoneCalculationResultDTOList.add(milestoneCalculationResultDTO);
                    }
                    if (!milestoneCalculationResultDTOList.isEmpty()) {
                        result.put(batch.getId(), milestoneCalculationResultDTOList);
                        continue;
                    }
                    MilestoneCalculationResultDTO milestoneCalculationResultDTO = new MilestoneCalculationResultDTO();
                    result.put(batch.getId(), Collections.singleton(milestoneCalculationResultDTO));
                }
                result.put("success", true);
            } else {
                result.put("error", "Invalid Batch Id");
            }
        }
        return result;
    }

    private MilestoneCalculationResultDTO calculateCompletionByArt(BaseItem batch, String releaseTrainId) throws Exception {
        ArrayList linkedItemIds = batch.getBaseItemLinks().stream().filter(baseItemLink -> PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId()) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && baseItemLink.getReleaseTrainId().equals(releaseTrainId)).map(BaseItemLink::getBaseItemId).collect(Collectors.toCollection(ArrayList::new));
        return this.milestoneCalculationService.calculateCompletion((List)linkedItemIds, releaseTrainId);
    }
}

