/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssueFields;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.alm.jira.bo.JiraStatus;
import com.viztrend.safe.alm.jira.bo.JiraStatusCategory;
import com.viztrend.safe.alm.jira.bo.TFSIssue;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.EpicFeature;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.JiraAlmAccountMeta;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.JiraAlmAccountMetaRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.AzureDevOpsExtensionService;
import com.viztrend.safe.service.AzureDevOpsExtensionServiceImpl;
import com.viztrend.safe.service.PIService;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.service.SolutionService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.S3Utils;
import com.viztrend.safe.utils.StringUtils;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AzureDevOpsExtensionServiceImpl
implements AzureDevOpsExtensionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureDevOpsExtensionServiceImpl.class);
    private static final String LINK_TYPE_KENDIS = "kendis";
    private static final String LINK_TYPE_ALM = "alm";
    private static final String DEPENDENCY_TYPE_OVERDUE = "Overdue Dependency";
    private static final String DEPENDENCY_TYPE_ALIGNED = "Aligned Dependency";
    private static final String DEPENDENCY_TYPE_REVERSE = "Reverse Dependency";
    private static final String CLOSED_STATE = "Closed";
    private static final Set<String> FORWARD_TYPES = new HashSet<String>(Arrays.asList("successor", "depends on", "is blocking", "produces For", "associated with"));
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private JiraUtils jiraUtils;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private PiJourneyService piJourneyService;
    @Autowired
    private PIService piService;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private SolutionService solutionService;
    @Autowired
    private JiraAlmAccountMetaRepository jiraAlmAccountMetaRepository;

    private <T> List<T> executeAggregationWithDiskUse(Aggregation aggregation, String collectionName, Class<T> outputType) {
        LOGGER.debug("Attempting aggregation with Spring Data MongoDB for collection: {}", (Object)collectionName);
        return this.mongoTemplate.aggregate(aggregation, collectionName, outputType).getMappedResults();
    }

    private List<DBObject> buildItemAggregationPipeline(BasicDBObject matchCriteria) {
        ArrayList<DBObject> pipe = new ArrayList<DBObject>();
        pipe.add((DBObject)new BasicDBObject("$match", (Object)matchCriteria));
        pipe.add((DBObject)new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'status','localField':'status.$id','foreignField':'_id','as':'status'}")));
        pipe.add((DBObject)BasicDBObject.parse((String)"{'$unwind':{'path':'$status','preserveNullAndEmptyArrays':true}}"));
        pipe.add((DBObject)new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'solutionBoard','localField':'solutionBoard.$id','foreignField':'_id','as':'solutionBoard'}")));
        pipe.add((DBObject)BasicDBObject.parse((String)"{'$unwind':{'path':'$solutionBoard','preserveNullAndEmptyArrays':true}}"));
        pipe.add((DBObject)new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'sessionBoard','localField':'sessionBoards.$id','foreignField':'_id','as':'sessionBoards'}")));
        pipe.add((DBObject)new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'teamContainer','localField':'teamContainers.$id','foreignField':'_id','as':'teamContainers'}")));
        pipe.add((DBObject)new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'itemLink','localField':'itemLinks.$id','foreignField':'_id','as':'itemLinks'}")));
        pipe.add((DBObject)new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'itemJiraDependency','localField':'jiraDependencies.$id','foreignField':'_id','as':'jiraDependencies'}")));
        BasicDBObject project = new BasicDBObject();
        project.append("_id", (Object)1);
        project.append("tfsId", (Object)1);
        project.append("jiraKey", (Object)1);
        project.append("title", (Object)1);
        project.append("endDate", (Object)1);
        project.append("tfsItemTypeIcon", (Object)1);
        project.append("jiraFieldByKey", (Object)1);
        project.append("tfsURL", (Object)1);
        project.append("jiraURL", (Object)1);
        project.append("status", (Object)1);
        project.append("sessionBoards", (Object)1);
        project.append("solutionBoard", (Object)1);
        project.append("teamContainers", (Object)1);
        project.append("itemLinks", (Object)1);
        project.append("jiraDependencies", (Object)1);
        project.append("fields", (Object)1);
        pipe.add((DBObject)new BasicDBObject("$project", (Object)project));
        return pipe;
    }

    private List<Item> executeItemAggregation(List<DBObject> pipe, Set<String> teamContainerIds, Set<String> sessionBoardIds) {
        DBCollection collection = this.mongoTemplate.getCollection("item");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor cursor = collection.aggregate(pipe, ao);
        ArrayList<Item> items = new ArrayList<Item>();
        while (cursor.hasNext()) {
            Object fieldsObj;
            Object jdeps;
            Object links;
            Object tcs;
            Object sba;
            Iterator pis;
            Object solutionObj;
            Object statusObj;
            Object jiraFieldByKey;
            Object jiraURL;
            Object tfsURL;
            Object tfsItemTypeIcon;
            Object endDate;
            Object title;
            Object jiraKey;
            Object tfsId;
            DBObject dbObject = (DBObject)cursor.next();
            Item item = new Item();
            Object idObj = dbObject.get("_id");
            if (idObj != null) {
                item.setId(String.valueOf(idObj));
            }
            if ((tfsId = dbObject.get("tfsId")) != null) {
                item.setTfsId(String.valueOf(tfsId));
            }
            if ((jiraKey = dbObject.get("jiraKey")) != null) {
                item.setJiraKey(String.valueOf(jiraKey));
            }
            if ((title = dbObject.get("title")) != null) {
                item.setTitle(String.valueOf(title));
            }
            if ((endDate = dbObject.get("endDate")) instanceof Date) {
                item.setEndDate((Date)endDate);
            }
            if ((tfsItemTypeIcon = dbObject.get("tfsItemTypeIcon")) != null) {
                item.setTfsItemTypeIcon(String.valueOf(tfsItemTypeIcon));
            }
            if ((tfsURL = dbObject.get("tfsURL")) != null) {
                item.setTfsURL(String.valueOf(tfsURL));
            }
            if ((jiraURL = dbObject.get("jiraURL")) != null) {
                item.setJiraURL(String.valueOf(jiraURL));
            }
            if ((jiraFieldByKey = dbObject.get("jiraFieldByKey")) != null && jiraFieldByKey instanceof Map) {
                Map jiraFields = (Map)jiraFieldByKey;
                item.setJiraFieldByKey(jiraFields);
            }
            if ((statusObj = dbObject.get("status")) instanceof DBObject) {
                Object scategory;
                Object stitle;
                DBObject s = (DBObject)statusObj;
                Status status = new Status();
                Object sid = s.get("_id");
                if (sid != null) {
                    status.setId(String.valueOf(sid));
                }
                if ((stitle = s.get("title")) != null) {
                    status.setTitle(String.valueOf(stitle));
                }
                if ((scategory = s.get("category")) != null) {
                    status.setCategory(String.valueOf(scategory));
                }
                item.setStatus(status);
            }
            if ((solutionObj = dbObject.get("solutionBoard")) instanceof DBObject) {
                Object stitle;
                DBObject sb = (DBObject)solutionObj;
                SolutionBoard solutionBoard = new SolutionBoard();
                Object sbid = sb.get("_id");
                if (sbid != null) {
                    solutionBoard.setId(String.valueOf(sbid));
                }
                if ((pis = sb.get("piSessions")) instanceof BasicDBList) {
                    BasicDBList dbl = (BasicDBList)pis;
                    ArrayList<String> piSessions = new ArrayList<String>();
                    for (Object v : dbl) {
                        if (v == null) continue;
                        piSessions.add(String.valueOf(v));
                    }
                    solutionBoard.setPiSessions(piSessions);
                }
                if ((stitle = sb.get("title")) != null) {
                    solutionBoard.setTitle(String.valueOf(stitle));
                }
                item.setSolutionBoard(solutionBoard);
            }
            if ((sba = dbObject.get("sessionBoards")) instanceof List) {
                List arr = (List)sba;
                ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                pis = arr.iterator();
                while (pis.hasNext()) {
                    Object o = pis.next();
                    if (o instanceof DBObject) {
                        DBObject sbObj = (DBObject)o;
                        Object sbid = sbObj.get("_id");
                        if (sbid != null) {
                            sessionBoardIds.add(String.valueOf(sbid));
                        }
                        SessionBoard sb = new SessionBoard(sbid != null ? String.valueOf(sbid) : null);
                        Object sbSession = sbObj.get("session");
                        if (sbSession instanceof DBObject) {
                            Object sessTitle;
                            DBObject sess = (DBObject)sbSession;
                            Session session = new Session();
                            Object sessId = sess.get("_id");
                            if (sessId != null) {
                                session.setId(String.valueOf(sessId));
                            }
                            if ((sessTitle = sess.get("title")) != null) {
                                session.setTitle(String.valueOf(sessTitle));
                            }
                            sb.setSession(session);
                        }
                        sessionBoards.add(sb);
                        continue;
                    }
                    if (o == null) continue;
                    sessionBoards.add(new SessionBoard(String.valueOf(o)));
                }
                item.setSessionBoards(sessionBoards);
            }
            if ((tcs = dbObject.get("teamContainers")) instanceof List) {
                List arr = (List)tcs;
                ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
                for (Object o : arr) {
                    if (o instanceof DBObject) {
                        DBObject tcObj = (DBObject)o;
                        Object tcid = tcObj.get("_id");
                        if (tcid == null) continue;
                        teamContainerIds.add(String.valueOf(tcid));
                        teamContainers.add(new TeamContainer(String.valueOf(tcid)));
                        continue;
                    }
                    if (o == null) continue;
                    teamContainers.add(new TeamContainer(String.valueOf(o)));
                }
                item.setTeamContainers(teamContainers);
            }
            if ((links = dbObject.get("itemLinks")) instanceof List) {
                Object o;
                List arr = (List)links;
                ArrayList<ItemLink> itemLinks = new ArrayList<ItemLink>();
                o = arr.iterator();
                while (o.hasNext()) {
                    Object o2 = o.next();
                    if (o2 instanceof DBObject) {
                        DBObject linkObj = (DBObject)o2;
                        Object lid = linkObj.get("_id");
                        if (lid == null) continue;
                        itemLinks.add(new ItemLink(String.valueOf(lid)));
                        continue;
                    }
                    if (o2 == null) continue;
                    itemLinks.add(new ItemLink(String.valueOf(o2)));
                }
                item.setItemLinks(itemLinks);
            }
            if ((jdeps = dbObject.get("jiraDependencies")) instanceof List) {
                List arr = (List)jdeps;
                ArrayList<ItemJiraDependency> deps = new ArrayList<ItemJiraDependency>();
                for (Object o : arr) {
                    if (o instanceof DBObject) {
                        Object targetItemId;
                        Object sourceItemId;
                        DBObject depObj = (DBObject)o;
                        Object did = depObj.get("_id");
                        ItemJiraDependency dependency = new ItemJiraDependency();
                        if (did != null) {
                            dependency.setId(String.valueOf(did));
                        }
                        if ((sourceItemId = depObj.get("sourceItemId")) != null) {
                            dependency.setSourceItemId(String.valueOf(sourceItemId));
                        }
                        if ((targetItemId = depObj.get("targetItemId")) != null) {
                            dependency.setTargetItemId(String.valueOf(targetItemId));
                        }
                        deps.add(dependency);
                        continue;
                    }
                    if (o == null) continue;
                    deps.add(new ItemJiraDependency(String.valueOf(o)));
                }
                item.setJiraDependencies(deps);
            }
            if ((fieldsObj = dbObject.get("fields")) instanceof Map) {
                Map fieldsMap = (Map)fieldsObj;
                item.setFields(fieldsMap);
            }
            items.add(item);
        }
        cursor.close();
        return items;
    }

    public Map<String, Object> fetchDependencies(String companyPrefix, Map<String, Object> workItemData) throws Exception {
        Map dependencyMap;
        Map itemWithDependencies;
        Set uniqueSessionIds;
        Object itemLinkedSessionBoards;
        ArrayList<SolutionBoard> solutionBoards;
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Starting fetchDependencies for company: {}, workItem: {}, url :{}", new Object[]{companyPrefix, workItemData.get("id"), workItemData.get("url")});
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, List> activeSessionBoardWithItems = new HashMap<String, List>();
        HashSet<String> solutionBoardsLinkedSessions = new HashSet<String>();
        HashSet sessionIds = new HashSet();
        HashSet<String> featureIds = new HashSet<String>();
        HashMap<String, Item> itemsWithIdMap = new HashMap<String, Item>();
        List sessions = new ArrayList();
        List<Object> activeSolutionLinkedBoardIds = new ArrayList();
        List epicFeatures = new ArrayList();
        HashMap<String, String> epicKeyWithSessionIdMap = new HashMap<String, String>();
        HashMap<String, String> solutionIdFeatureItemMap = new HashMap<String, String>();
        HashSet<String> featureLinkedSolutionBoardIds = new HashSet<String>();
        Set<Object> sessionBoardIds = new HashSet();
        HashMap<String, Set> solutionBoardWithPiBoard = new HashMap<String, Set>();
        HashMap solutionBoardWithPiBoardMap = new HashMap();
        HashMap<String, Iterator<Map.Entry<String, Object>>> solutionBoardWithDependenciesMap = new HashMap<String, Iterator<Map.Entry<String, Object>>>();
        HashMap<String, Session> sessionMap = new HashMap<String, Session>();
        Map itemLinkMap = new HashMap();
        Map itemJiraDependencyMap = new HashMap();
        Map teamContainerMap = new HashMap();
        HashMap sessionBoardMap = new HashMap();
        HashSet<String> itemLinkIds = new HashSet<String>();
        HashSet<String> itemJiraDependencyIds = new HashSet<String>();
        HashSet<String> teamContainerIds = new HashSet<String>();
        HashSet activeSessionBoardIds = new HashSet();
        LOGGER.debug("Step 1: Validating company and extracting TFS ID");
        long step1Start = System.currentTimeMillis();
        Company company = this.fetchAndValidateCompany(companyPrefix);
        String tenant = company.getTenant();
        String tfsId = this.extractTfsId(workItemData);
        String tfsUrl = this.extractTfsUrl(workItemData);
        long step1End = System.currentTimeMillis();
        LOGGER.debug("Step 1 completed in {} ms", (Object)(step1End - step1Start));
        if (!PropertyValidator.isValid((Object)tfsId)) {
            LOGGER.debug("No TFS Id found");
            response.put("noItemFound", true);
            return response;
        }
        LOGGER.debug("Step 2: Fetching items for work item");
        long step2Start = System.currentTimeMillis();
        List items = this.fetchItemsForWorkItem(tfsId, tenant, teamContainerIds, tfsUrl, sessionBoardIds);
        long step2End = System.currentTimeMillis();
        LOGGER.debug("Step 2 completed in {} ms, found {} items", (Object)(step2End - step2Start), (Object)items.size());
        if (items.isEmpty()) {
            LOGGER.debug("No items found for TFS ID: {} in tenant: {}", (Object)tfsId, (Object)tenant);
            response.put("noItemFound", true);
            return response;
        }
        for (Item item2 : items) {
            itemsWithIdMap.put(item2.getId(), item2);
            featureIds.add(item2.getId());
        }
        LOGGER.debug("Step 3: Collecting session board IDs");
        long step3Start = System.currentTimeMillis();
        sessionBoardIds = this.collectSessionBoardIds(items);
        long step3End = System.currentTimeMillis();
        LOGGER.debug("Step 3 completed in {} ms, collected {} session board IDs", (Object)(step3End - step3Start), (Object)sessionBoardIds.size());
        LOGGER.debug("Step 4: Fetching active session boards");
        long step4Start = System.currentTimeMillis();
        List sessionBoards = new ArrayList();
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, true);
        long step4End = System.currentTimeMillis();
        LOGGER.debug("Step 4 completed in {} ms, found {} active session boards", (Object)(step4End - step4Start), (Object)sessionBoards.size());
        sessionBoards.stream().map(SessionBoard::getSession).filter(PropertyValidator::isValid).forEach(session -> {
            if (PropertyValidator.isValid((Object)session.getId())) {
                sessionIds.add(session.getId());
            }
        });
        Criteria epicCriteria = Criteria.where((String)"featureId").in(featureIds).and("tenant").is((Object)tenant);
        Query epicQuery = Query.query((CriteriaDefinition)epicCriteria);
        epicQuery.fields().include("_id").include("featureId").include("solutionBoardId").include("sessionId").include("epicKey").include("featureKey");
        List featureEpics = this.mongoTemplate.find(epicQuery, EpicFeature.class);
        if (PropertyValidator.isValid((Collection)featureEpics)) {
            for (EpicFeature epicFeature : featureEpics) {
                if (!PropertyValidator.isValid((Object)epicFeature.getSolutionBoardId()) || !sessionIds.contains(epicFeature.getSessionId())) continue;
                featureLinkedSolutionBoardIds.add(epicFeature.getSolutionBoardId());
                solutionIdFeatureItemMap.put(epicFeature.getSolutionBoardId(), epicFeature.getFeatureId());
            }
        }
        if (PropertyValidator.isValid(featureLinkedSolutionBoardIds)) {
            Criteria solutionCriteria = Criteria.where((String)"_id").in(featureLinkedSolutionBoardIds).and("tenant").is((Object)tenant);
            Query solutionQuery = Query.query((CriteriaDefinition)solutionCriteria);
            solutionQuery.fields().include("_id").include("title").include("piSessions");
            solutionBoards = this.mongoTemplate.find(solutionQuery, SolutionBoard.class);
            if (PropertyValidator.isValid((Collection)solutionBoards)) {
                String featureId;
                HashMap<String, List> featureToSolutionBoardsMap = new HashMap<String, List>();
                for (SolutionBoard solutionBoard2 : solutionBoards) {
                    if (!solutionIdFeatureItemMap.containsKey(solutionBoard2.getId()) || !PropertyValidator.isValid((Object)(featureId = (String)solutionIdFeatureItemMap.get(solutionBoard2.getId())))) continue;
                    featureToSolutionBoardsMap.computeIfAbsent(featureId, k -> new ArrayList()).add(solutionBoard2);
                }
                for (Map.Entry entry : featureToSolutionBoardsMap.entrySet()) {
                    featureId = (String)entry.getKey();
                    List featureSolutionBoards = (List)entry.getValue();
                    Item featureItem = (Item)itemsWithIdMap.get(featureId);
                    if (!PropertyValidator.isValid((Object)featureItem) || !PropertyValidator.isValid((Collection)featureSolutionBoards)) continue;
                    featureItem.setSolutionBoard((SolutionBoard)featureSolutionBoards.get(0));
                    if (featureItem.getFields() == null) {
                        featureItem.setFields(new HashMap());
                    }
                    featureItem.getFields().put("allSolutionBoards", featureSolutionBoards);
                }
            }
        }
        for (Item item3 : items) {
            Object additionalSolutionBoards;
            SolutionBoard solutionBoard3;
            Object sessionBoard222;
            if (PropertyValidator.isValid((Collection)item3.getSessionBoards())) {
                for (Object sessionBoard222 : item3.getSessionBoards()) {
                    if (!PropertyValidator.isValid((Object)sessionBoard222.getId())) continue;
                    activeSessionBoardWithItems.computeIfAbsent(sessionBoard222.getId(), k -> new ArrayList()).add(item3);
                }
            }
            if (PropertyValidator.isValid((Object)item3.getSolutionBoard()) && PropertyValidator.isValid((Collection)(solutionBoard3 = item3.getSolutionBoard()).getPiSessions())) {
                sessionBoard222 = solutionBoard3.getPiSessions().iterator();
                while (sessionBoard222.hasNext()) {
                    String piSession = (String)sessionBoard222.next();
                    if (!PropertyValidator.isValid((Object)piSession)) continue;
                    solutionBoardsLinkedSessions.add(piSession);
                }
            }
            if (!PropertyValidator.isValid((Object)item3.getFields()) || !item3.getFields().containsKey("allSolutionBoards") || !PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item3.getFields().get("allSolutionBoards")))) continue;
            sessionBoard222 = additionalSolutionBoards.iterator();
            while (sessionBoard222.hasNext()) {
                SolutionBoard solutionBoard4 = (SolutionBoard)sessionBoard222.next();
                if (!PropertyValidator.isValid((Collection)solutionBoard4.getPiSessions())) continue;
                for (Object piSession : solutionBoard4.getPiSessions()) {
                    if (!PropertyValidator.isValid((Object)piSession)) continue;
                    solutionBoardsLinkedSessions.add((String)piSession);
                }
            }
        }
        if (!solutionBoardsLinkedSessions.isEmpty()) {
            Criteria sessionEpicCriteria = Criteria.where((String)"sessionId").in(solutionBoardsLinkedSessions).and("tenant").is((Object)tenant);
            Query sessionEpicQuery = Query.query((CriteriaDefinition)sessionEpicCriteria);
            sessionEpicQuery.fields().include("_id").include("epicKey").include("sessionId").include("featureId").include("solutionBoardId").include("featureKey");
            epicFeatures = this.mongoTemplate.find(sessionEpicQuery, EpicFeature.class);
            for (EpicFeature epicFeature : epicFeatures) {
                if (!PropertyValidator.isValid((Object)epicFeature.getEpicKey()) || !PropertyValidator.isValid((Object)epicFeature.getSessionId())) continue;
                String compositeKey = epicFeature.getEpicKey() + "::" + epicFeature.getSessionId();
                epicKeyWithSessionIdMap.put(compositeKey, epicFeature.getSessionId());
            }
            List invalidSessionIdStrings = solutionBoardsLinkedSessions.stream().filter(idStr -> !ObjectId.isValid((String)idStr)).collect(Collectors.toList());
            if (!invalidSessionIdStrings.isEmpty()) {
                LOGGER.debug("Skipping {} invalid ObjectId(s) for solutionBoardLinkedSessionIds: {}", (Object)invalidSessionIdStrings.size(), invalidSessionIdStrings);
            }
            List solutionBoardLinkedSessionIds = solutionBoardsLinkedSessions.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(sessionId -> new ObjectId(sessionId)).collect(Collectors.toList());
            Criteria sessionCriteria = Criteria.where((String)"_id").in(solutionBoardLinkedSessionIds).and("tenant").is((Object)tenant);
            Query query = Query.query((CriteriaDefinition)sessionCriteria);
            query.fields().include("_id").include("activeSessionBoard").include("title").include("rowStatus");
            sessions = this.mongoTemplate.find(query, Session.class);
            activeSolutionLinkedBoardIds = sessions.stream().map(Session::getActiveSessionBoard).distinct().collect(Collectors.toList());
            sessionBoardIds.addAll(activeSolutionLinkedBoardIds);
        }
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, true);
        sessionBoards.stream().map(SessionBoard::getSession).filter(PropertyValidator::isValid).forEach(session -> {
            if (PropertyValidator.isValid((Object)session.getId())) {
                sessionIds.add(session.getId());
                sessionMap.put(session.getId(), (Session)session);
            }
        });
        sessionBoards.stream().forEach(sessionBoard -> {
            activeSessionBoardIds.add(sessionBoard.getId());
            sessionBoardMap.put(sessionBoard.getId(), sessionBoard);
        });
        Aggregation solutionAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"piSessions").in(sessionIds).and("tenant").is((Object)tenant).and("archive").is((Object)false)), Aggregation.project((String[])new String[0]).and("_id").as("_id").and("title").as("title").and("piSessions").as("piSessions")});
        List tempSolutionBoards = this.executeAggregationWithDiskUse(solutionAggregation, "solutionBoard", SolutionBoard.class);
        solutionBoards = new ArrayList<SolutionBoard>();
        if (PropertyValidator.isValid((Collection)tempSolutionBoards)) {
            for (Object item4 : items) {
                List list;
                SolutionBoard solutionBoard3;
                if (PropertyValidator.isValid((Object)item4.getSolutionBoard()) && tempSolutionBoards.contains(solutionBoard3 = item4.getSolutionBoard())) {
                    solutionBoards.add(solutionBoard3);
                }
                if (PropertyValidator.isValid((Object)item4.getFields()) && item4.getFields().containsKey("allSolutionBoards") && PropertyValidator.isValid((Collection)(list = (List)item4.getFields().get("allSolutionBoards")))) {
                    for (SolutionBoard solutionBoard5 : list) {
                        if (!tempSolutionBoards.contains(solutionBoard5)) continue;
                        solutionBoards.add(solutionBoard5);
                    }
                }
                if (!PropertyValidator.isValid((Collection)item4.getSessionBoards())) continue;
                for (SessionBoard sessionBoard2 : item4.getSessionBoards()) {
                    SessionBoard fetchedSessionBoard = (SessionBoard)sessionBoardMap.get(sessionBoard2.getId());
                    if (!PropertyValidator.isValid((Object)fetchedSessionBoard) || !PropertyValidator.isValid((Object)fetchedSessionBoard.getSession()) || !PropertyValidator.isValid((Object)fetchedSessionBoard.getSession().getId())) continue;
                    String sessionId2 = fetchedSessionBoard.getSession().getId();
                    for (SolutionBoard solutionBoard6 : tempSolutionBoards) {
                        if (!PropertyValidator.isValid((Collection)solutionBoard6.getPiSessions()) || !solutionBoard6.getPiSessions().contains(sessionId2) || solutionBoards.contains(solutionBoard6)) continue;
                        solutionBoards.add(solutionBoard6);
                    }
                }
            }
        }
        HashMap allSolutionBoardsWithPiSessions = new HashMap();
        if (PropertyValidator.isValid(solutionBoards)) {
            for (SolutionBoard solutionBoard4 : solutionBoards) {
                ArrayList piSessions = solutionBoard4.getPiSessions();
                HashSet<String> piSessionsSet = new HashSet<String>();
                for (Object piSession : piSessions) {
                    piSessionsSet.add((String)piSession);
                    for (SessionBoard sessionBoard4 : sessionBoards) {
                        if (!PropertyValidator.isValid((Object)sessionBoard4.getSession()) || !sessionBoard4.getSession().getId().equalsIgnoreCase((String)piSession)) continue;
                        solutionBoardWithPiBoard.computeIfAbsent(solutionBoard4.getId(), k -> new HashSet()).add(sessionBoard4.getId());
                    }
                }
                allSolutionBoardsWithPiSessions.put(solutionBoard4.getId(), piSessionsSet);
            }
            LOGGER.debug("Found sessionBoards of size :{}", (Object)sessionBoards.size());
        }
        if (sessionBoards.isEmpty()) {
            LOGGER.debug("No active session boards found for TFS ID: {}", (Object)tfsId);
            response.put("noProgramBoards", true);
            return response;
        }
        HashMap<String, SessionBoard> sessionBoardWithIdMap = new HashMap<String, SessionBoard>();
        for (SessionBoard sessionBoard3 : sessionBoards) {
            if (!PropertyValidator.isValid((Object)sessionBoard3.getId())) continue;
            sessionBoardWithIdMap.put(sessionBoard3.getId(), sessionBoard3);
        }
        for (Item item5 : items) {
            List additionalSolutionBoards;
            Object itemLinkedSessionBoardIds;
            String solutionBoardId;
            if (PropertyValidator.isValid((Object)item5.getSolutionBoard()) && solutionBoardWithPiBoard.containsKey(solutionBoardId = item5.getSolutionBoard().getId()) && PropertyValidator.isValid((Collection)(itemLinkedSessionBoardIds = (Set)solutionBoardWithPiBoard.get(solutionBoardId)))) {
                Object piSession;
                piSession = itemLinkedSessionBoardIds.iterator();
                while (piSession.hasNext()) {
                    String epicSessionId;
                    SessionBoard sessionBoard3;
                    String sessionBoardId = (String)piSession.next();
                    if (!sessionBoardWithIdMap.containsKey(sessionBoardId) || !PropertyValidator.isValid((Object)(sessionBoard3 = (SessionBoard)sessionBoardWithIdMap.get(sessionBoardId))) || !PropertyValidator.isValid((Object)sessionBoard3.getSession())) continue;
                    String sessionId3 = sessionBoard3.getSession().getId();
                    String epicKey = item5.getTfsId();
                    String compositeKey = epicKey + "::" + (String)sessionId3;
                    if (!epicKeyWithSessionIdMap.containsKey(compositeKey) || !(epicSessionId = (String)epicKeyWithSessionIdMap.get(compositeKey)).equalsIgnoreCase(sessionId3)) continue;
                    LOGGER.debug("Found epic session id :{}", (Object)epicSessionId);
                    if (!PropertyValidator.isValid((Collection)item5.getSessionBoards())) {
                        ArrayList<SessionBoard> itemLinkedSessionBoards2 = new ArrayList<SessionBoard>();
                        itemLinkedSessionBoards2.add(sessionBoard3);
                        item5.setSessionBoards(itemLinkedSessionBoards2);
                        continue;
                    }
                    item5.getSessionBoards().add(sessionBoard3);
                    sessionMap.put(sessionBoard3.getSession().getId(), sessionBoard3.getSession());
                }
            }
            if (!PropertyValidator.isValid((Object)item5.getFields()) || !item5.getFields().containsKey("allSolutionBoards") || !PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item5.getFields().get("allSolutionBoards")))) continue;
            itemLinkedSessionBoardIds = additionalSolutionBoards.iterator();
            while (itemLinkedSessionBoardIds.hasNext()) {
                Set itemLinkedSessionBoardIds2;
                SolutionBoard solutionBoard7 = (SolutionBoard)itemLinkedSessionBoardIds.next();
                String solutionBoardId2 = solutionBoard7.getId();
                if (!solutionBoardWithPiBoard.containsKey(solutionBoardId2) || !PropertyValidator.isValid((Collection)(itemLinkedSessionBoardIds2 = (Set)solutionBoardWithPiBoard.get(solutionBoardId2)))) continue;
                for (String sessionBoardId : itemLinkedSessionBoardIds2) {
                    String epicSessionId;
                    SessionBoard sessionBoard5;
                    if (!sessionBoardWithIdMap.containsKey(sessionBoardId) || !PropertyValidator.isValid((Object)(sessionBoard5 = (SessionBoard)sessionBoardWithIdMap.get(sessionBoardId))) || !PropertyValidator.isValid((Object)sessionBoard5.getSession())) continue;
                    String sessionId4 = sessionBoard5.getSession().getId();
                    String epicKey = item5.getTfsId();
                    String compositeKey = (String)epicKey + "::" + sessionId4;
                    if (!epicKeyWithSessionIdMap.containsKey(compositeKey) || !(epicSessionId = (String)epicKeyWithSessionIdMap.get(compositeKey)).equalsIgnoreCase(sessionId4)) continue;
                    LOGGER.debug("Found epic session id :{}", (Object)epicSessionId);
                    if (!PropertyValidator.isValid((Collection)item5.getSessionBoards())) {
                        itemLinkedSessionBoards = new ArrayList();
                        itemLinkedSessionBoards.add(sessionBoard5);
                        item5.setSessionBoards((List)itemLinkedSessionBoards);
                        continue;
                    }
                    item5.getSessionBoards().add(sessionBoard5);
                }
            }
        }
        sessionBoards.stream().forEach(sessionBoard -> {
            activeSessionBoardIds.add(sessionBoard.getId());
            sessionBoardMap.put(sessionBoard.getId(), sessionBoard);
        });
        HashMap<Object, Date> hashMap = new HashMap<Object, Date>();
        LOGGER.debug("Step 6: Filtering active items and building item maps");
        long step6Start = System.currentTimeMillis();
        List activeItems = this.filterActiveItems(items, activeSessionBoardIds);
        List itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceTFSItemTfsId(tfsId);
        Map boardWithItemMap = this.buildBoardWithItemMap(activeItems, hashMap, sessionBoardMap);
        if (PropertyValidator.isValid(solutionBoards) && PropertyValidator.isValid(uniqueSessionIds = solutionBoards.stream().filter(solutionBoard -> PropertyValidator.isValid((Collection)solutionBoard.getPiSessions())).flatMap(solutionBoard -> solutionBoard.getPiSessions().stream()).collect(Collectors.toSet()))) {
            Criteria sessionCriteria = Criteria.where((String)"_id").in(uniqueSessionIds).and("tenant").is((Object)tenant);
            Query sessionQuery = Query.query((CriteriaDefinition)sessionCriteria);
            sessionQuery.fields().include("_id").include("activeSessionBoard").include("title").include("rowStatus");
            sessions = this.mongoTemplate.find(sessionQuery, Session.class);
            activeSolutionLinkedBoardIds = sessions.stream().map(Session::getActiveSessionBoard).distinct().collect(Collectors.toList());
            sessionBoardIds.addAll(activeSolutionLinkedBoardIds);
        }
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, false);
        sessionBoards.forEach(sessionBoard -> sessionBoardMap.put(sessionBoard.getId(), sessionBoard));
        LOGGER.debug("Step 5: Building link types map for active session boards");
        long step5Start = System.currentTimeMillis();
        Map boardWithLinkTypesMap = this.buildBoardLinkTypesMap(sessionBoards, sessionBoardMap);
        long step5End = System.currentTimeMillis();
        LOGGER.debug("Step 5 completed in {} ms", (Object)(step5End - step5Start));
        for (ItemJiraDependency itemJiraDependency : itemJiraDependencies) {
            Iterator<Object> boardItems;
            if (!PropertyValidator.isValid((Object)itemJiraDependency.getSessionBoardId()) || !activeSessionBoardWithItems.containsKey(itemJiraDependency.getSessionBoardId()) || !PropertyValidator.isValid((Collection)((Object)(boardItems = (List)activeSessionBoardWithItems.get(itemJiraDependency.getSessionBoardId()))))) continue;
            itemLinkedSessionBoards = boardItems.iterator();
            while (itemLinkedSessionBoards.hasNext()) {
                Item boardItem = (Item)itemLinkedSessionBoards.next();
                if (!boardItem.getTfsURL().equalsIgnoreCase(itemJiraDependency.getSourceTFSItem().getUrl())) continue;
                if (!PropertyValidator.isValid((Collection)boardItem.getJiraDependencies())) {
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId())) {
                        if (!boardItem.getId().equalsIgnoreCase(itemJiraDependency.getSourceItemId())) continue;
                        ArrayList<ItemJiraDependency> itemJiraDependencyList = new ArrayList<ItemJiraDependency>();
                        itemJiraDependencyList.add(itemJiraDependency);
                        boardItem.setJiraDependencies(itemJiraDependencyList);
                        itemJiraDependencyIds.add(itemJiraDependency.getId());
                        continue;
                    }
                    ArrayList<ItemJiraDependency> itemJiraDependencyList = new ArrayList<ItemJiraDependency>();
                    itemJiraDependencyList.add(itemJiraDependency);
                    boardItem.setJiraDependencies(itemJiraDependencyList);
                    itemJiraDependencyIds.add(itemJiraDependency.getId());
                    continue;
                }
                boolean exists = false;
                for (ItemJiraDependency existingDep : boardItem.getJiraDependencies()) {
                    if (!existingDep.getId().equalsIgnoreCase(itemJiraDependency.getId())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId())) {
                    if (!boardItem.getId().equalsIgnoreCase(itemJiraDependency.getSourceItemId())) continue;
                    boardItem.getJiraDependencies().add(itemJiraDependency);
                    itemJiraDependencyIds.add(itemJiraDependency.getId());
                    continue;
                }
                boardItem.getJiraDependencies().add(itemJiraDependency);
                itemJiraDependencyIds.add(itemJiraDependency.getId());
            }
        }
        itemJiraDependencies = this.itemJiraDependencyRepository.findByTargetTFSItemTfsId(tfsId);
        for (ItemJiraDependency itemJiraDependency : itemJiraDependencies) {
            if (!PropertyValidator.isValid((Object)itemJiraDependency.getSessionBoardId()) || !tfsUrl.equalsIgnoreCase(itemJiraDependency.getTargetTFSItem().getUrl())) continue;
            for (Item item6 : activeItems) {
                boolean exists = false;
                for (Object existingDep : item6.getJiraDependencies()) {
                    if (!existingDep.getId().equalsIgnoreCase(itemJiraDependency.getId())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId())) {
                    if (!item6.getId().equalsIgnoreCase(itemJiraDependency.getTargetItemId())) continue;
                    item6.getJiraDependencies().add(itemJiraDependency);
                    itemJiraDependency.setDirection("reverse");
                    itemJiraDependencyIds.add(itemJiraDependency.getId());
                    continue;
                }
                itemJiraDependency.setDirection("reverse");
                item6.getJiraDependencies().add(itemJiraDependency);
                itemJiraDependencyIds.add(itemJiraDependency.getId());
            }
        }
        for (Item activeItem : activeItems) {
            if (PropertyValidator.isValid((Collection)activeItem.getItemLinks())) {
                for (ItemLink itemLink : activeItem.getItemLinks()) {
                    if (!PropertyValidator.isValid((Object)itemLink.getId())) continue;
                    itemLinkIds.add(itemLink.getId());
                }
            }
            if (PropertyValidator.isValid((Collection)activeItem.getJiraDependencies())) {
                for (ItemJiraDependency jiraDependency : activeItem.getJiraDependencies()) {
                    if (!PropertyValidator.isValid((Object)jiraDependency.getId())) continue;
                    itemJiraDependencyIds.add(jiraDependency.getId());
                }
            }
            if (!PropertyValidator.isValid((Collection)activeItem.getTeamContainers())) continue;
            for (TeamContainer teamContainer : activeItem.getTeamContainers()) {
                if (!PropertyValidator.isValid((Object)teamContainer.getId())) continue;
                teamContainerIds.add(teamContainer.getId());
            }
        }
        HashSet<String> userIds = new HashSet<String>();
        if (!itemLinkIds.isEmpty()) {
            itemLinkMap = this.fetchItemLinksWithNestedObjects(itemLinkIds, tenant, userIds);
        }
        if (!itemJiraDependencyIds.isEmpty()) {
            itemJiraDependencyMap = this.fetchItemJiraDependenciesWithNestedObjects(itemJiraDependencyIds, tenant, userIds);
        }
        HashSet<String> conversationIds = new HashSet<String>();
        for (ItemLink link : itemLinkMap.values()) {
            if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
            for (Conversation c : link.getConversations()) {
                if (!PropertyValidator.isValid((Object)c) || !PropertyValidator.isValid((Object)c.getId())) continue;
                conversationIds.add(c.getId());
            }
        }
        for (Object dep : itemJiraDependencyMap.values()) {
            if (!PropertyValidator.isValid((Collection)dep.getConversations())) continue;
            for (Conversation c : dep.getConversations()) {
                if (!PropertyValidator.isValid((Object)c) || !PropertyValidator.isValid((Object)c.getId())) continue;
                conversationIds.add(c.getId());
            }
        }
        Map conversationMap = new HashMap();
        if (!conversationIds.isEmpty()) {
            Conversation full;
            conversationMap = this.fetchConversationsByIds(conversationIds);
            for (ItemLink link : itemLinkMap.values()) {
                if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
                ArrayList<Conversation> updated = new ArrayList<Conversation>();
                for (Conversation c : link.getConversations()) {
                    Conversation conversation = full = PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getId()) ? (Conversation)conversationMap.get(c.getId()) : null;
                    if (PropertyValidator.isValid(full)) {
                        if (PropertyValidator.isValid((Object)full.getUser()) && PropertyValidator.isValid((Object)full.getUser().getId())) {
                            userIds.add(full.getUser().getId());
                        }
                        updated.add(full);
                        continue;
                    }
                    if (PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getUser()) && PropertyValidator.isValid((Object)c.getUser().getId())) {
                        userIds.add(c.getUser().getId());
                    }
                    updated.add(c);
                }
                link.setConversations(updated);
            }
            for (ItemJiraDependency dep : itemJiraDependencyMap.values()) {
                if (!PropertyValidator.isValid((Collection)dep.getConversations())) continue;
                ArrayList<Conversation> updated = new ArrayList<Conversation>();
                for (Conversation c : dep.getConversations()) {
                    Conversation conversation = full = PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getId()) ? (Conversation)conversationMap.get(c.getId()) : null;
                    if (PropertyValidator.isValid((Object)full)) {
                        if (PropertyValidator.isValid((Object)full.getUser()) && PropertyValidator.isValid((Object)full.getUser().getId())) {
                            userIds.add(full.getUser().getId());
                        }
                        updated.add(full);
                        continue;
                    }
                    if (PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getUser()) && PropertyValidator.isValid((Object)c.getUser().getId())) {
                        userIds.add(c.getUser().getId());
                    }
                    updated.add(c);
                }
                dep.setConversations(updated);
            }
        }
        long step6End = System.currentTimeMillis();
        LOGGER.debug("Step 6 completed in {} ms, filtered {} active items", (Object)(step6End - step6Start), (Object)activeItems.size());
        HashMap<TfsItemKey, Map> missingItems = new HashMap<TfsItemKey, Map>();
        LOGGER.debug("Step 7: Building dependencies for each board/item");
        long step7Start = System.currentTimeMillis();
        Set<Object> dependentItemIds = new HashSet();
        HashSet<String> containerIds = new HashSet<String>();
        HashMap almDependenciesMap = new HashMap();
        Map boardWithDependenciesMap = this.buildBoardWithDependenciesMap(boardWithItemMap, hashMap, dependentItemIds, containerIds, missingItems, tenant, itemLinkMap, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, teamContainerIds, boardWithLinkTypesMap, sessionBoardIds, almDependenciesMap, conversationMap);
        long step7End = System.currentTimeMillis();
        LOGGER.debug("Step 7 completed in {} ms, found {} dependent items, {} container IDs", new Object[]{step7End - step7Start, dependentItemIds.size(), containerIds.size()});
        HashMap<String, Item> dependentItemsMap = new HashMap<String, Item>();
        HashMap<TfsItemKey, Object> dependentItemWithTfsId = new HashMap<TfsItemKey, Object>();
        dependentItemIds = dependentItemIds.stream().filter(PropertyValidator::isValid).collect(Collectors.toSet());
        List<Object> dependencyItems = new ArrayList();
        if (PropertyValidator.isValid(solutionBoards)) {
            LOGGER.debug("Finding dependent items by solution boards with item Ids: {}", dependentItemIds);
            List invalidDependentItemIdStrings = dependentItemIds.stream().filter(idStr -> !ObjectId.isValid((String)idStr)).collect(Collectors.toList());
            if (!invalidDependentItemIdStrings.isEmpty()) {
                LOGGER.debug("Skipping {} invalid ObjectId(s) for dependentItemIds (solution boards branch): {}", (Object)invalidDependentItemIdStrings.size(), invalidDependentItemIdStrings);
            }
            List list = dependentItemIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(id -> new ObjectId(id)).collect(Collectors.toList());
            BasicDBObject dependencyWhere = new BasicDBObject();
            dependencyWhere.append("_id", (Object)new BasicDBObject("$in", list));
            dependencyWhere.append("tenant", (Object)tenant);
            List dependencyPipe = this.buildItemAggregationPipeline(dependencyWhere);
            dependencyItems = this.executeItemAggregation(dependencyPipe, teamContainerIds, sessionBoardIds);
        } else {
            LOGGER.debug("Fetching dependent items without solution boards for {} item IDs", (Object)dependentItemIds.size());
            LOGGER.debug("Active session board IDs: {}", activeSessionBoardIds);
            List invalidDependentItemIdStringsFallback = dependentItemIds.stream().filter(idStr -> !ObjectId.isValid((String)idStr)).collect(Collectors.toList());
            if (!invalidDependentItemIdStringsFallback.isEmpty()) {
                LOGGER.debug("Skipping {} invalid ObjectId(s) for dependentItemIds (fallback branch): {}", (Object)invalidDependentItemIdStringsFallback.size(), invalidDependentItemIdStringsFallback);
            }
            List list = dependentItemIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(id -> new ObjectId(id)).collect(Collectors.toList());
            BasicDBObject fallbackWhere = new BasicDBObject();
            fallbackWhere.append("_id", (Object)new BasicDBObject("$in", list));
            fallbackWhere.append("tenant", (Object)tenant);
            List fallbackPipe = this.buildItemAggregationPipeline(fallbackWhere);
            List allDependentItems = this.executeItemAggregation(fallbackPipe, teamContainerIds, sessionBoardIds);
            LOGGER.debug("Fetched {} dependent items from database", (Object)allDependentItems.size());
            dependencyItems = allDependentItems.stream().filter(item -> {
                LOGGER.debug("Processing item: {} with sessionBoards: {}", (Object)item.getId(), item.getSessionBoards() != null ? Integer.valueOf(item.getSessionBoards().size()) : "null");
                if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                    LOGGER.debug("Item {} has solution board, excluding", (Object)item.getId());
                    return false;
                }
                if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && !item.getSessionBoards().isEmpty()) {
                    boolean hasActiveSessionBoard = item.getSessionBoards().stream().anyMatch(sessionBoard -> {
                        if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getId())) {
                            boolean isActive = activeSessionBoardIds.contains(sessionBoard.getId());
                            LOGGER.debug("Session board {} for item {} is active: {}", new Object[]{sessionBoard.getId(), item.getId(), isActive});
                            return isActive;
                        }
                        return false;
                    });
                    if (hasActiveSessionBoard) {
                        LOGGER.debug("Item {} has active session board, including", (Object)item.getId());
                        return true;
                    }
                    LOGGER.debug("Item {} has no active session boards, excluding", (Object)item.getId());
                    return false;
                }
                LOGGER.debug("Item {} has no session boards, excluding", (Object)item.getId());
                return false;
            }).collect(Collectors.toList());
            LOGGER.debug("Filtered to {} dependent items without solution boards and with active session boards", (Object)dependencyItems.size());
        }
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, false);
        sessionBoards.stream().forEach(sessionBoard -> {
            activeSessionBoardIds.add(sessionBoard.getId());
            sessionBoardMap.put(sessionBoard.getId(), sessionBoard);
        });
        if (!epicKeyWithSessionIdMap.isEmpty()) {
            Set epicKeys = epicKeyWithSessionIdMap.keySet().stream().map(key -> key.split("::")[0]).collect(Collectors.toSet());
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.append("tfsId", (Object)new BasicDBObject("$in", (Object)epicKeys));
            basicDBObject.append("tenant", (Object)tenant);
            List epicItemsPipe = this.buildItemAggregationPipeline(basicDBObject);
            List epicItems = this.executeItemAggregation(epicItemsPipe, teamContainerIds, sessionBoardIds);
            if (PropertyValidator.isValid((Collection)epicItems)) {
                for (Object epicItem : epicItems) {
                    SessionBoard sessionBoard6;
                    dependentItemsMap.put(epicItem.getTfsId(), (Item)epicItem);
                    if (!PropertyValidator.isValid((Collection)epicItem.getSessionBoards()) || !PropertyValidator.isValid((Object)(sessionBoard6 = (SessionBoard)sessionBoardMap.get(((SessionBoard)epicItem.getSessionBoards().get(0)).getId()))) || !PropertyValidator.isValid((Object)sessionBoard6.getSession())) continue;
                    TfsItemKey tfsItemKey = new TfsItemKey(epicItem.getTfsId(), sessionBoard6.getSession().getId());
                    dependentItemWithTfsId.put(tfsItemKey, epicItem);
                }
            }
        }
        LOGGER.debug("Dependent items found: {}", (Object)dependencyItems.size());
        if (PropertyValidator.isValid(dependencyItems)) {
            for (Item item2 : dependencyItems) {
                List additionalSolutionBoards;
                SolutionBoard solutionBoard8;
                SessionBoard sessionBoard7;
                dependentItemsMap.put(item2.getId(), item2);
                if (PropertyValidator.isValid((Collection)item2.getSessionBoards()) && PropertyValidator.isValid((Object)(sessionBoard7 = (SessionBoard)sessionBoardMap.get(((SessionBoard)item2.getSessionBoards().get(0)).getId()))) && PropertyValidator.isValid((Object)sessionBoard7.getSession())) {
                    TfsItemKey tfsItemKey = new TfsItemKey(item2.getTfsId(), sessionBoard7.getSession().getId());
                    dependentItemWithTfsId.put(tfsItemKey, item2);
                }
                if (PropertyValidator.isValid((Object)item2.getSolutionBoard()) && PropertyValidator.isValid((Collection)(solutionBoard8 = item2.getSolutionBoard()).getPiSessions())) {
                    for (String piSession : solutionBoard8.getPiSessions()) {
                        if (!PropertyValidator.isValid((Object)piSession)) continue;
                        solutionBoardsLinkedSessions.add(piSession);
                    }
                }
                if (!PropertyValidator.isValid((Object)item2.getFields()) || !item2.getFields().containsKey("allSolutionBoards") || !PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item2.getFields().get("allSolutionBoards")))) continue;
                for (SolutionBoard solutionBoard9 : additionalSolutionBoards) {
                    if (!PropertyValidator.isValid((Collection)solutionBoard9.getPiSessions())) continue;
                    for (String piSession : solutionBoard9.getPiSessions()) {
                        if (!PropertyValidator.isValid((Object)piSession)) continue;
                        solutionBoardsLinkedSessions.add(piSession);
                    }
                }
            }
        }
        long epicSolutionStart = System.currentTimeMillis();
        LOGGER.debug("Building epic features and linked solution boards for epic items");
        HashMap<String, Set> epicLinkedSolutionBoardsMap = new HashMap<String, Set>();
        HashMap<Object, Container> epicLinkedContainersMap = new HashMap<Object, Container>();
        HashMap<String, List> epicKeyToContainerIds = new HashMap<String, List>();
        if (PropertyValidator.isValid(solutionBoardsLinkedSessions)) {
            Criteria additionalEpicCriteria = Criteria.where((String)"sessionId").in(solutionBoardsLinkedSessions).and("tenant").is((Object)tenant);
            Query additionalEpicQuery = Query.query((CriteriaDefinition)additionalEpicCriteria);
            additionalEpicQuery.fields().include("_id").include("epicKey").include("sessionId").include("featureId").include("solutionBoardId").include("featureKey");
            epicFeatures.addAll(this.mongoTemplate.find(additionalEpicQuery, EpicFeature.class));
            HashMap featureWithEpicMap = new HashMap();
            for (EpicFeature epicFeature : epicFeatures) {
                if (PropertyValidator.isValid((Object)epicFeature.getEpicKey()) && PropertyValidator.isValid((Object)epicFeature.getSessionId())) {
                    String compositeKey = epicFeature.getEpicKey() + "::" + epicFeature.getSessionId();
                    epicKeyWithSessionIdMap.put(compositeKey, epicFeature.getSessionId());
                }
                if (PropertyValidator.isValid((Object)epicFeature.getFeatureId())) {
                    featureWithEpicMap.put(epicFeature.getFeatureId(), epicFeature.getEpicKey());
                }
                if (!PropertyValidator.isValid((Object)epicFeature.getSolutionBoardId())) continue;
                epicLinkedSolutionBoardsMap.computeIfAbsent(epicFeature.getEpicKey(), k -> new HashSet()).add(epicFeature.getSolutionBoardId());
            }
            if (!featureWithEpicMap.isEmpty()) {
                List featureWithEpicObjIds = featureWithEpicMap.keySet().stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
                BasicDBObject featureItemsWhere = new BasicDBObject();
                featureItemsWhere.append("_id", (Object)new BasicDBObject("$in", featureWithEpicObjIds));
                featureItemsWhere.append("tenant", (Object)tenant);
                List featureItemsPipe = this.buildItemAggregationPipeline(featureItemsWhere);
                List featureItems = this.executeItemAggregation(featureItemsPipe, teamContainerIds, sessionBoardIds);
                teamContainerMap = this.fetchTeamContainersWithNestedObjects(teamContainerIds, tenant);
                Iterator iterator = featureItems.iterator();
                while (iterator.hasNext()) {
                    Item featureItem = (Item)iterator.next();
                    String epicKey = (String)featureWithEpicMap.get(featureItem.getId());
                    if (!PropertyValidator.isValid((Object)epicKey) || !PropertyValidator.isValid((Collection)featureItem.getTeamContainers())) continue;
                    for (TeamContainer teamContainer : featureItem.getTeamContainers()) {
                        TeamContainer fetchedTeamContainer = (TeamContainer)teamContainerMap.get(teamContainer.getId());
                        if (!PropertyValidator.isValid((Object)fetchedTeamContainer) || !PropertyValidator.isValid((Object)fetchedTeamContainer.getContainer()) || !PropertyValidator.isValid((Object)fetchedTeamContainer.getContainer().getId())) continue;
                        String string = fetchedTeamContainer.getContainer().getId();
                        epicKeyToContainerIds.computeIfAbsent(epicKey, k -> new ArrayList()).add(string);
                        containerIds.add(string);
                    }
                }
            }
            List solutionBoardLinkedSessionIdObjs = solutionBoardsLinkedSessions.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
            Criteria additionalSessionCriteria = Criteria.where((String)"_id").in(solutionBoardLinkedSessionIdObjs).and("tenant").is((Object)tenant);
            Query additionalSessionQuery = Query.query((CriteriaDefinition)additionalSessionCriteria);
            additionalSessionQuery.fields().include("_id").include("activeSessionBoard").include("title").include("rowStatus");
            sessions.addAll(this.mongoTemplate.find(additionalSessionQuery, Session.class));
            activeSolutionLinkedBoardIds.addAll(sessions.stream().map(Session::getActiveSessionBoard).distinct().collect(Collectors.toList()));
        }
        long epicSolutionEnd = System.currentTimeMillis();
        LOGGER.debug("Built epic features and linked solution boards in {} ms", (Object)(epicSolutionEnd - epicSolutionStart));
        for (Session session2 : sessions) {
            if (!PropertyValidator.isValid((Object)session2.getId())) continue;
            sessionMap.put(session2.getId(), session2);
        }
        Criteria containerCriteria = Criteria.where((String)"_id").in(containerIds).and("tenant").is((Object)tenant);
        Query containerQuery = Query.query((CriteriaDefinition)containerCriteria);
        containerQuery.fields().include("_id").include("label").include("sequence").include("endDate");
        List containers = this.mongoTemplate.find(containerQuery, Container.class);
        HashMap<String, Container> containerMap = new HashMap<String, Container>();
        if (PropertyValidator.isValid((Collection)containers)) {
            for (Container container : containers) {
                containerMap.put(container.getId(), container);
            }
        }
        if (PropertyValidator.isValid(epicKeyToContainerIds)) {
            for (Map.Entry entry : epicKeyToContainerIds.entrySet()) {
                String epicKey = (String)entry.getKey();
                List ids = (List)entry.getValue();
                if (!PropertyValidator.isValid((Collection)ids)) continue;
                Container best = ids.stream().map(containerMap::get).filter(Objects::nonNull).max(Comparator.comparing(Container::getSequence, Comparator.nullsLast(Comparator.naturalOrder()))).orElse(null);
                if (!PropertyValidator.isValid((Object)best)) continue;
                hashMap.put(epicKey, best.getEndDate());
                epicLinkedContainersMap.put(epicKey, best);
            }
        }
        if (!teamContainerIds.isEmpty()) {
            teamContainerMap = this.fetchTeamContainersWithNestedObjects(teamContainerIds, tenant);
        }
        long dependenciesEnrichStart = System.currentTimeMillis();
        for (Object piBoardWithDependencies : boardWithDependenciesMap.values()) {
            Map piBoardWithDependenciesMap = (Map)piBoardWithDependencies;
            if (!PropertyValidator.isValid(piBoardWithDependenciesMap.get("dependencies"))) continue;
            Map itemWithDependencies2 = (Map)piBoardWithDependenciesMap.get("dependencies");
            String boardSessionId = piBoardWithDependenciesMap.get("boardSessionId").toString();
            Iterator iterator = itemWithDependencies2.entrySet().iterator();
            while (iterator.hasNext()) {
                TfsItemKey tfsItemKey;
                String dependencyId;
                String sourceSessionId;
                Map.Entry itemEntry = iterator.next();
                String itemId = (String)itemEntry.getKey();
                Map dependencyMap2 = (Map)itemEntry.getValue();
                Item item7 = (Item)dependentItemsMap.get(itemId);
                if (!PropertyValidator.isValid((Object)item7) && PropertyValidator.isValid(dependencyMap2.get("targetItemId"))) {
                    String targetItemId = (String)dependencyMap2.get("targetItemId");
                    item7 = (Item)dependentItemsMap.get(targetItemId);
                }
                if (PropertyValidator.isValid(dependencyMap2.get("sourceSessionId")) && PropertyValidator.isValid((Object)(sourceSessionId = (String)dependencyMap2.get("sourceSessionId"))) && !sourceSessionId.equalsIgnoreCase(boardSessionId)) {
                    LOGGER.debug("Dependency id :{} does not belong to session id: {}, removing it.", (Object)boardSessionId, (Object)dependencyMap2.get("dependencyId").toString());
                    iterator.remove();
                    continue;
                }
                if (PropertyValidator.isValid((Object)item7)) {
                    boolean reverseLink;
                    if (PropertyValidator.isValid((Collection)item7.getSessionBoards()) && !item7.getSessionBoards().isEmpty() && dependencyMap2.containsKey("isSolutionOnly")) {
                        String sessionBoardId = ((SessionBoard)item7.getSessionBoards().get(0)).getId();
                        SessionBoard sessionBoardObj = (SessionBoard)sessionBoardMap.get(sessionBoardId);
                        if (PropertyValidator.isValid((Object)sessionBoardObj) && PropertyValidator.isValid((Object)sessionBoardObj.getSession()) && boardSessionId.equalsIgnoreCase(sessionBoardObj.getSession().getId())) {
                            dependencyMap2.remove("isSolutionOnly");
                        }
                    } else {
                        SessionBoard fetchedSessionBoard;
                        if (!PropertyValidator.isValid((Collection)item7.getSessionBoards()) && !dependencyMap2.containsKey("isSolutionOnly") && LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap2.get("linkOrigin").toString())) {
                            dependencyMap2.put("isArchive", true);
                            dependencyMap2.put("dependencyType", "");
                            dependencyId = dependencyMap2.get("dependencyId").toString();
                            tfsItemKey = new TfsItemKey(dependencyId, tfsId);
                            missingItems.put(tfsItemKey, dependencyMap2);
                            continue;
                        }
                        if (LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap2.get("linkOrigin").toString()) && PropertyValidator.isValid((Collection)item7.getSessionBoards()) && PropertyValidator.isValid((Object)(fetchedSessionBoard = (SessionBoard)sessionBoardMap.get(((SessionBoard)item7.getSessionBoards().get(0)).getId()))) && PropertyValidator.isValid((Object)fetchedSessionBoard.getSession()) && !boardSessionId.equalsIgnoreCase(fetchedSessionBoard.getSession().getId())) {
                            String dependencyId2 = dependencyMap2.get("dependencyId").toString();
                            TfsItemKey tfsItemKey2 = new TfsItemKey(dependencyId2, tfsId);
                            dependencyMap2.put("isArchive", true);
                            dependencyMap2.put("dependencyType", "");
                            missingItems.put(tfsItemKey2, dependencyMap2);
                            continue;
                        }
                    }
                    if (dependencyMap2.containsKey("reverseLink") && LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap2.get("linkOrigin").toString()) && (reverseLink = ((Boolean)dependencyMap2.get("reverseLink")).booleanValue())) {
                        LOGGER.debug("Found reverse link for item with ID: {}", (Object)itemId);
                        String dependencyId2 = (String)dependencyMap2.get("dependencyId");
                        if (!PropertyValidator.isValid((Collection)item7.getItemLinks())) {
                            LOGGER.debug("Dependency ID :{} is not valid for item with ID: {}", (Object)dependencyId2, (Object)itemId);
                            iterator.remove();
                            continue;
                        }
                        ItemLink itemLink = item7.getItemLinks().stream().filter(l -> dependencyId2.equals(l.getId())).findFirst().orElse(null);
                        if (itemLink == null) {
                            iterator.remove();
                            LOGGER.debug("ItemLink with ID :{} not found, removing it from dependencies list", (Object)dependencyId2);
                            continue;
                        }
                    }
                    this.enrichDependencyMap(item7, dependencyMap2, hashMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
                    continue;
                }
                LOGGER.debug("Item with ID :{} not found, removing it from dependencies list. When looking in pi boards", (Object)itemId);
                if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap2.get("linkType").toString())) {
                    iterator.remove();
                    continue;
                }
                if (!LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap2.get("linkType").toString())) continue;
                dependencyId = dependencyMap2.get("dependencyId").toString();
                tfsItemKey = new TfsItemKey(dependencyId, tfsId);
                dependencyMap2.put("isArchive", true);
                dependencyMap2.put("dependencyType", "");
                missingItems.put(tfsItemKey, dependencyMap2);
            }
        }
        long dependenciesEnrichEnd = System.currentTimeMillis();
        LOGGER.debug("Dependencies enriched in {} ms", (Object)(dependenciesEnrichEnd - dependenciesEnrichStart));
        if (!missingItems.isEmpty()) {
            LOGGER.debug("Missing Items size :{}", (Object)missingItems.size());
            this.fetchTfsMissingItems(missingItems);
        }
        if (PropertyValidator.isValid(solutionBoards)) {
            long solutionBoardsStart = System.currentTimeMillis();
            for (Map.Entry entry : solutionBoardWithPiBoard.entrySet()) {
                String solutionBoardId = (String)entry.getKey();
                Set piBoards = (Set)entry.getValue();
                Iterator<Map.Entry<String, Object>> piBoardWithDependencies = new HashMap();
                HashMap acrossBoardDependencies = new HashMap();
                if (!PropertyValidator.isValid((Collection)piBoards)) continue;
                for (String piBoard : piBoards) {
                    Map piBoardMap = this.findBoardDataBySessionBoardId(boardWithDependenciesMap, piBoard, solutionBoardId);
                    if (!PropertyValidator.isValid((Object)piBoardMap)) continue;
                    HashMap copiedMap = new HashMap();
                    for (Map.Entry piBoardEntry : piBoardMap.entrySet()) {
                        String key2 = (String)piBoardEntry.getKey();
                        Object v = piBoardEntry.getValue();
                        if (v instanceof Map) {
                            HashMap hashMap2 = new HashMap((Map)v);
                            copiedMap.put(key2, hashMap2);
                            continue;
                        }
                        copiedMap.put(key2, v);
                    }
                    piBoardWithDependencies.put(piBoard, copiedMap);
                    itemWithDependencies = (Map)copiedMap.get("dependencies");
                    String boardSessionId = (String)copiedMap.get("boardSessionId");
                    Iterator iterator = itemWithDependencies.entrySet().iterator();
                    block56: while (iterator.hasNext()) {
                        Set solutionLinkedSessionIds;
                        Session targetSession;
                        String targetSessionId;
                        String sourceSessionId;
                        SessionBoard sessionBoard4;
                        HashMap<String, Object> copy;
                        Map.Entry epicEntry;
                        Object epicLinkedSessionId;
                        Map missingItemMap;
                        TfsItemKey missingItemKey;
                        String targetItemId;
                        Set epicLinkedSolutionBoards;
                        Map.Entry entry2 = iterator.next();
                        String string = (String)entry2.getKey();
                        dependencyMap = (Map)entry2.getValue();
                        Session epicLinkedSession = null;
                        Item item8 = (Item)dependentItemsMap.get(string);
                        String sourceKey = (String)dependencyMap.get("sourceKey");
                        if (PropertyValidator.isValid(epicLinkedSolutionBoardsMap) && epicLinkedSolutionBoardsMap.containsKey(sourceKey) && PropertyValidator.isValid((Collection)(epicLinkedSolutionBoards = (Set)epicLinkedSolutionBoardsMap.get(sourceKey))) && !epicLinkedSolutionBoards.contains(solutionBoardId)) {
                            LOGGER.debug("Removing sourceKey :{} epic from dependencies as it is not linked to solution board with ID :{}", (Object)sourceKey, (Object)solutionBoardId);
                            iterator.remove();
                            continue;
                        }
                        if (!PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid(dependencyMap.get("targetItemId"))) {
                            targetItemId = (String)dependencyMap.get("targetItemId");
                            item8 = (Item)dependentItemsMap.get(targetItemId);
                        }
                        if (PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid(dependencyMap.get("targetItemId")) && PropertyValidator.isValid(dependencyMap.get("targetContainerId")) && !PropertyValidator.isValid((Collection)item8.getTeamContainers()) && LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap.get("linkOrigin").toString())) {
                            targetItemId = (String)dependencyMap.get("targetItemId");
                            if (almDependenciesMap.containsKey(targetItemId)) {
                                itemWithDependencies.put(targetItemId, almDependenciesMap.get(targetItemId));
                                continue;
                            }
                            String targetKey = (String)dependencyMap.get("targetKey");
                            if (PropertyValidator.isValid((Object)targetKey) && PropertyValidator.isValid((Object)(missingItemKey = (TfsItemKey)missingItems.keySet().stream().filter(i -> i.getTfsKey().equalsIgnoreCase(targetKey)).findFirst().orElse(null)))) {
                                iterator.remove();
                                missingItemMap = (Map)missingItems.get(missingItemKey);
                                itemWithDependencies.put(targetKey, new HashMap(missingItemMap));
                                continue;
                            }
                        }
                        String targetKey = null;
                        if (PropertyValidator.isValid(dependencyMap.get("targetKey"))) {
                            targetKey = (String)dependencyMap.get("targetKey");
                            epicLinkedSessionId = null;
                            missingItemKey = epicKeyWithSessionIdMap.entrySet().iterator();
                            while (missingItemKey.hasNext()) {
                                epicEntry = missingItemKey.next();
                                if (!((String)epicEntry.getKey()).startsWith(targetKey + "::")) continue;
                                epicLinkedSessionId = (String)epicEntry.getValue();
                                break;
                            }
                            if (PropertyValidator.isValid(epicLinkedSessionId)) {
                                epicLinkedSession = (Session)sessionMap.get(epicLinkedSessionId);
                            }
                        } else if (PropertyValidator.isValid((Object)item8)) {
                            targetKey = item8.getTfsId();
                            epicLinkedSessionId = null;
                            missingItemKey = epicKeyWithSessionIdMap.entrySet().iterator();
                            while (missingItemKey.hasNext()) {
                                epicEntry = missingItemKey.next();
                                if (!((String)epicEntry.getKey()).startsWith(targetKey + "::")) continue;
                                epicLinkedSessionId = (String)epicEntry.getValue();
                                break;
                            }
                            if (PropertyValidator.isValid(epicLinkedSessionId)) {
                                epicLinkedSession = (Session)sessionMap.get(epicLinkedSessionId);
                            }
                        }
                        if (PropertyValidator.isValid(epicLinkedSession)) {
                            dependencyMap.put("targetBoardTitle", epicLinkedSession.getTitle());
                        }
                        if (dependencyMap.containsKey("isArchive") && !dependencyMap.containsKey("isSolutionOnly")) {
                            for (Map.Entry epicEntry2 : epicKeyWithSessionIdMap.entrySet()) {
                                if (!((String)epicEntry2.getKey()).startsWith(targetKey)) continue;
                                continue block56;
                            }
                            if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap.get("linkType").toString())) {
                                LOGGER.debug("Item is not linked to solution board with ID :{}, removing it from dependencies list", (Object)solutionBoardId);
                                iterator.remove();
                                continue;
                            }
                            if (!LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap.get("linkOrigin").toString()) || dependencyMap.containsKey("isSolutionOnly")) continue;
                            String piBoardId = null;
                            if (PropertyValidator.isValid(dependencyMap.get("sessionBoardId"))) {
                                piBoardId = dependencyMap.get("sessionBoardId").toString();
                            }
                            if (!PropertyValidator.isValid((Object)item8)) {
                                Set solutionLinkedpiBoards = (Set)allSolutionBoardsWithPiSessions.get(solutionBoardId);
                                for (String solutionLinkedpiBoard : solutionLinkedpiBoards) {
                                    TfsItemKey tfsItemKey = new TfsItemKey(targetKey, solutionLinkedpiBoard);
                                    if (!dependentItemWithTfsId.containsKey(tfsItemKey)) continue;
                                    item8 = (Item)dependentItemWithTfsId.get(tfsItemKey);
                                }
                            }
                            if (PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid((Collection)item8.getSessionBoards()) && !item8.getSessionBoards().isEmpty()) {
                                Set piSessions;
                                String sessionBoardId = ((SessionBoard)item8.getSessionBoards().get(0)).getId();
                                SessionBoard sessionBoardObj = (SessionBoard)sessionBoardMap.get(sessionBoardId);
                                if (PropertyValidator.isValid((Object)sessionBoardObj) && PropertyValidator.isValid((Object)piBoardId) && piBoardId.equalsIgnoreCase(sessionBoardObj.getId())) {
                                    this.enrichDependencyMap(item8, new HashMap(dependencyMap), hashMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
                                    continue;
                                }
                                if (sessionBoardIds.contains(sessionBoardObj.getId()) && PropertyValidator.isValid((Collection)(piSessions = (Set)allSolutionBoardsWithPiSessions.get(solutionBoardId))) && piSessions.contains(sessionBoardObj.getSession().getId()) && sessionBoardObj.getSession().getActiveSessionBoard().equalsIgnoreCase(((SessionBoard)item8.getSessionBoards().get(0)).getId())) {
                                    HashMap acrossBoardDependency = new HashMap(dependencyMap);
                                    acrossBoardDependency.remove("isArchive");
                                    this.enrichAcrossBoardDependency(sessionBoardObj.getSession(), acrossBoardDependency, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                    entry2.setValue(acrossBoardDependency);
                                    continue;
                                }
                            }
                            String dependencyId = dependencyMap.get("dependencyId").toString();
                            TfsItemKey missingTfsItemKey = new TfsItemKey(dependencyId, tfsId);
                            missingItems.put(missingTfsItemKey, dependencyMap);
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid((Collection)item8.getSessionBoards()) && !item8.getSessionBoards().isEmpty() && PropertyValidator.isValid(dependencyMap.get("sessionBoardId"))) {
                            SessionBoard fetchedSessionBoard;
                            SessionBoard sessionBoard8 = (SessionBoard)item8.getSessionBoards().get(0);
                            String sourceSessionBoardId = dependencyMap.get("sessionBoardId").toString();
                            if (!sourceSessionBoardId.equalsIgnoreCase(sessionBoard8.getId()) && PropertyValidator.isValid((Object)(fetchedSessionBoard = (SessionBoard)sessionBoardMap.get(sessionBoard8.getId()))) && PropertyValidator.isValid((Object)fetchedSessionBoard.getSession()) && !sourceSessionBoardId.equalsIgnoreCase(fetchedSessionBoard.getSession().getActiveSessionBoard())) {
                                Set solutionLinkedpiBoards = (Set)solutionBoardWithPiBoard.get(solutionBoardId);
                                if (PropertyValidator.isValid((Collection)solutionLinkedpiBoards) && solutionLinkedpiBoards.contains(fetchedSessionBoard.getId())) {
                                    this.enrichAcrossBoardDependency(fetchedSessionBoard.getSession(), dependencyMap, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                    dependencyMap.put("isSolutionOnly", true);
                                    continue;
                                }
                                if (PropertyValidator.isValid(dependencyMap.get("sourceSessionId")) && PropertyValidator.isValid(dependencyMap.get("targetSessionId"))) {
                                    Set piSessions = (Set)allSolutionBoardsWithPiSessions.get(solutionBoardId);
                                    String sourceSessionId2 = (String)dependencyMap.get("sourceSessionId");
                                    String targetSessionId2 = (String)dependencyMap.get("targetSessionId");
                                    if (PropertyValidator.isValid((Collection)piSessions) && piSessions.contains(sourceSessionId2) && piSessions.contains(targetSessionId2) && PropertyValidator.isValid((Object)sourceSessionId2) && PropertyValidator.isValid((Object)targetSessionId2) && !sourceSessionId2.equalsIgnoreCase(targetSessionId2)) {
                                        Session targetSession2 = (Session)sessionMap.get(targetSessionId2);
                                        this.enrichAcrossBoardDependency(targetSession2, dependencyMap, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                        dependencyMap.put("isSolutionOnly", true);
                                        continue;
                                    }
                                }
                                if (dependencyMap.containsKey("isSolutionOnly")) {
                                    HashMap<String, Object> copy2 = new HashMap<String, Object>(dependencyMap);
                                    copy2.put("isArchive", true);
                                    copy2.put("dependencyType", "");
                                    entry2.setValue(copy2);
                                    continue;
                                }
                                LOGGER.debug("Removing dependency Id: {} as it does not belong to solutionBoard :{}", dependencyMap.get("dependencyId"), (Object)solutionBoardId);
                                iterator.remove();
                                continue;
                            }
                        }
                        if (PropertyValidator.isValid((Object)item8) && this.isItemInSolutionBoard(item8, solutionBoardId, epicLinkedSolutionBoardsMap)) {
                            String targetSessionId3;
                            if (PropertyValidator.isValid(dependencyMap.get("targetSessionId")) && PropertyValidator.isValid((Object)(targetSessionId3 = (String)dependencyMap.get("targetSessionId"))) && targetSessionId3.equalsIgnoreCase(boardSessionId)) continue;
                            if (PropertyValidator.isValid((Collection)item8.getSessionBoards()) && !item8.getSessionBoards().isEmpty() || epicLinkedSession != null) {
                                if (PropertyValidator.isValid((Object)epicLinkedSession)) {
                                    if (!epicLinkedSession.getActiveSessionBoard().equalsIgnoreCase(piBoard)) {
                                        if (this.isItemInSolutionBoard(item8, solutionBoardId, null)) {
                                            this.enrichAcrossBoardDependency(epicLinkedSession, dependencyMap, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                            continue;
                                        }
                                        copy = new HashMap<String, Object>(dependencyMap);
                                        copy.put("isArchive", true);
                                        copy.put("dependencyType", "");
                                        entry2.setValue(copy);
                                        continue;
                                    }
                                } else if (PropertyValidator.isValid((Collection)item8.getSessionBoards())) {
                                    sessionBoard4 = (SessionBoard)item8.getSessionBoards().get(0);
                                    sessionMap.put(sessionBoard4.getSession().getId(), sessionBoard4.getSession());
                                    if (!sessionBoard4.getId().equalsIgnoreCase(piBoard)) {
                                        this.enrichAcrossBoardDependency(sessionBoard4.getSession(), dependencyMap, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                        continue;
                                    }
                                }
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("sourceSessionId")) || !PropertyValidator.isValid(dependencyMap.get("targetSessionId"))) continue;
                            sourceSessionId = (String)dependencyMap.get("sourceSessionId");
                            targetSessionId = (String)dependencyMap.get("targetSessionId");
                            if (!PropertyValidator.isValid((Object)sourceSessionId) || !PropertyValidator.isValid((Object)targetSessionId) || sourceSessionId.equalsIgnoreCase(targetSessionId)) continue;
                            targetSession = (Session)sessionMap.get(targetSessionId);
                            this.enrichAcrossBoardDependency(targetSession, dependencyMap, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                            continue;
                        }
                        if (PropertyValidator.isValid(dependencyMap.get("sourceSessionId")) && PropertyValidator.isValid(dependencyMap.get("targetSessionId"))) {
                            sourceSessionId = (String)dependencyMap.get("sourceSessionId");
                            targetSessionId = (String)dependencyMap.get("targetSessionId");
                            if (PropertyValidator.isValid((Object)sourceSessionId) && PropertyValidator.isValid((Object)targetSessionId) && !sourceSessionId.equalsIgnoreCase(targetSessionId)) {
                                if (PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid((Object)item8.getSolutionBoard()) && !this.isItemInSolutionBoard(item8, solutionBoardId, null)) {
                                    HashMap<String, Object> copy3 = new HashMap<String, Object>(dependencyMap);
                                    copy3.put("isArchive", true);
                                    copy3.put("dependencyType", "");
                                    entry2.setValue(copy3);
                                    continue;
                                }
                                targetSession = (Session)sessionMap.get(targetSessionId);
                                this.enrichAcrossBoardDependency(targetSession, dependencyMap, item8, hashMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, string, entry2, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                continue;
                            }
                        }
                        LOGGER.debug("Item with ID :{} not found, removing it from dependencies list. When looking in solution boards", (Object)string);
                        if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap.get("linkType").toString())) {
                            if (PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid((Collection)item8.getSessionBoards())) {
                                sessionBoard4 = (SessionBoard)item8.getSessionBoards().get(0);
                                solutionLinkedSessionIds = (Set)solutionBoardWithPiBoard.get(solutionBoardId);
                                if (PropertyValidator.isValid((Collection)solutionLinkedSessionIds) && solutionLinkedSessionIds.contains(sessionBoard4.getId())) continue;
                            }
                            LOGGER.debug("Item is not linked to solution board with ID :{}, removing it from dependencies list", (Object)solutionBoardId);
                            iterator.remove();
                        } else if (LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap.get("linkType").toString()) && !dependencyMap.containsKey("isSolutionOnly")) {
                            if (PropertyValidator.isValid((Object)item8) && PropertyValidator.isValid((Collection)item8.getSessionBoards())) {
                                sessionBoard4 = (SessionBoard)item8.getSessionBoards().get(0);
                                solutionLinkedSessionIds = (Set)solutionBoardWithPiBoard.get(solutionBoardId);
                                if (PropertyValidator.isValid((Collection)solutionLinkedSessionIds) && solutionLinkedSessionIds.contains(sessionBoard4.getId())) continue;
                            }
                            if (item8 == null) {
                                LOGGER.debug("Item is null with id: {}, checking from missing items list", (Object)string);
                                if (PropertyValidator.isValid((Object)targetKey)) {
                                    String missingTargetKey = dependencyMap.get("targetKey").toString();
                                    missingItemKey = missingItems.keySet().stream().filter(i -> i.getTfsKey().equalsIgnoreCase(missingTargetKey)).findFirst().orElse(null);
                                    if (PropertyValidator.isValid((Object)missingItemKey)) {
                                        missingItemMap = (Map)missingItems.get(missingItemKey);
                                        if (!PropertyValidator.isValid((Object)missingItemMap)) continue;
                                        LOGGER.debug("Item is null with id: {}, adding from missing items list", (Object)string);
                                        entry2.setValue(missingItemMap);
                                        missingItemMap.put("isArchive", true);
                                        missingItemMap.put("dependencyType", "");
                                        itemWithDependencies.put(targetKey, new HashMap(missingItemMap));
                                        continue;
                                    }
                                }
                            }
                        }
                        if (!PropertyValidator.isValid((Object)item8) || !PropertyValidator.isValid((Object)item8.getSolutionBoard()) || this.isItemInSolutionBoard(item8, solutionBoardId, null)) continue;
                        copy = new HashMap(dependencyMap);
                        copy.put("isArchive", true);
                        copy.put("dependencyType", "");
                        entry2.setValue(copy);
                    }
                }
                SolutionBoard solutionBoard10 = solutionBoards.stream().filter(s -> s.getId().equals(solutionBoardId)).findFirst().get();
                piBoardWithDependencies.put("boardTitle", solutionBoard10.getTitle());
                piBoardWithDependencies.put("acrossBoardDependencies", acrossBoardDependencies);
                solutionBoardWithDependenciesMap.put(solutionBoardId, piBoardWithDependencies);
            }
            long solutionBoardsEnd = System.currentTimeMillis();
            LOGGER.debug("Processed solution boards in {} ms", (Object)(solutionBoardsEnd - solutionBoardsStart));
        }
        long solutionBoardWithDependenciesStart = System.currentTimeMillis();
        for (Object v : solutionBoardWithDependenciesMap.values()) {
            Map solutionBoardDependenciesMap = (Map)v;
            Map acrossBoardDependencies = (Map)solutionBoardDependenciesMap.get("acrossBoardDependencies");
            if (PropertyValidator.isValid((Object)acrossBoardDependencies)) {
                for (Map.Entry entry : solutionBoardDependenciesMap.entrySet()) {
                    Map piBoardWithDependenciesMap;
                    if (!((String)entry.getKey()).matches("^[a-fA-F0-9]{24}$") || !PropertyValidator.isValid((piBoardWithDependenciesMap = (Map)entry.getValue()).get("dependencies"))) continue;
                    Map itemWithDependencies3 = (Map)piBoardWithDependenciesMap.get("dependencies");
                    Iterator iterator = itemWithDependencies3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry itemEntry = iterator.next();
                        String itemId = (String)itemEntry.getKey();
                        Map dependencyMap3 = (Map)itemEntry.getValue();
                        Object targetKey = null;
                        if (PropertyValidator.isValid(dependencyMap3.get("targetKey"))) {
                            targetKey = (String)dependencyMap3.get("targetKey");
                        }
                        if (!acrossBoardDependencies.containsKey(itemId) && !acrossBoardDependencies.containsKey(targetKey)) continue;
                        iterator.remove();
                        LOGGER.debug("Found item id :{} in acrossBoardDependencies list, removing it against pi board", (Object)itemId);
                    }
                }
            }
            for (Map.Entry solutionBoardEntry : solutionBoardWithDependenciesMap.entrySet()) {
                Map solutionBoardEntryVal = (Map)solutionBoardEntry.getValue();
                for (Map.Entry entry : solutionBoardEntryVal.entrySet()) {
                    if (!((String)entry.getKey()).matches("^[a-fA-F0-9]{24}$")) continue;
                    Map piBoardWithDependenciesMap = (Map)entry.getValue();
                    itemWithDependencies = (Map)piBoardWithDependenciesMap.get("dependencies");
                    HashMap<String, Map> consolidatedDependencies = new HashMap<String, Map>();
                    for (Map.Entry entry3 : itemWithDependencies.entrySet()) {
                        String string = (String)entry3.getKey();
                        dependencyMap = (Map)entry3.getValue();
                        String targetKey = (String)dependencyMap.get("targetKey");
                        if (PropertyValidator.isValid((Object)targetKey)) {
                            String oldOrigin;
                            String newOrigin;
                            boolean isArchiveExisting;
                            boolean isArchiveNew;
                            Set epicLinkedSolutionBoards;
                            if (PropertyValidator.isValid(epicLinkedSolutionBoardsMap) && epicLinkedSolutionBoardsMap.containsKey(targetKey) && PropertyValidator.isValid((Collection)(epicLinkedSolutionBoards = (Set)epicLinkedSolutionBoardsMap.get(targetKey))) && !epicLinkedSolutionBoards.contains(solutionBoardEntry.getKey())) {
                                dependencyMap.put("isArchive", true);
                                dependencyMap.put("dependencyType", "");
                            }
                            if (!consolidatedDependencies.containsKey(targetKey)) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                continue;
                            }
                            Map existingDependency = (Map)consolidatedDependencies.get(targetKey);
                            String existingSessionBoardId = (String)existingDependency.get("sessionBoardId");
                            String newSessionBoardId = (String)dependencyMap.get("sessionBoardId");
                            if (PropertyValidator.isValid((Object)newSessionBoardId) && PropertyValidator.isValid((Object)existingSessionBoardId) && newSessionBoardId.equalsIgnoreCase(existingSessionBoardId)) {
                                isArchiveNew = dependencyMap.getOrDefault("isArchive", false);
                                isArchiveExisting = existingDependency.getOrDefault("isArchive", false);
                                if (isArchiveNew && !isArchiveExisting) {
                                    consolidatedDependencies.put(targetKey, existingDependency);
                                    LOGGER.debug("Keeping new dependency for targetKey: {} as it is an archive", (Object)targetKey);
                                    continue;
                                }
                                if (isArchiveExisting && !isArchiveNew) {
                                    consolidatedDependencies.put(targetKey, dependencyMap);
                                    LOGGER.debug("Keeping existing dependency for targetKey: {} as it is an archive", (Object)targetKey);
                                    continue;
                                }
                                if (isArchiveNew || isArchiveExisting) continue;
                                newOrigin = (String)dependencyMap.get("linkOrigin");
                                oldOrigin = (String)existingDependency.get("linkOrigin");
                                if (LINK_TYPE_KENDIS.equalsIgnoreCase(oldOrigin) && LINK_TYPE_ALM.equalsIgnoreCase(newOrigin)) {
                                    consolidatedDependencies.put(targetKey, existingDependency);
                                    continue;
                                }
                                if (!LINK_TYPE_ALM.equalsIgnoreCase(oldOrigin) || !LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) continue;
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                continue;
                            }
                            if (((String)entry.getKey()).equalsIgnoreCase(existingSessionBoardId)) {
                                consolidatedDependencies.put(targetKey, existingDependency);
                                continue;
                            }
                            if (((String)entry.getKey()).equalsIgnoreCase(newSessionBoardId)) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                LOGGER.debug("Keeping new dependency for targetKey: {} as it belongs to the same solution board", (Object)targetKey);
                                continue;
                            }
                            isArchiveNew = dependencyMap.getOrDefault("isArchive", false);
                            isArchiveExisting = existingDependency.getOrDefault("isArchive", false);
                            newOrigin = (String)dependencyMap.get("linkOrigin");
                            oldOrigin = (String)existingDependency.get("linkOrigin");
                            if (LINK_TYPE_KENDIS.equalsIgnoreCase(oldOrigin) && LINK_TYPE_ALM.equalsIgnoreCase(newOrigin)) {
                                consolidatedDependencies.put(targetKey, existingDependency);
                                continue;
                            }
                            if (LINK_TYPE_ALM.equalsIgnoreCase(oldOrigin) && LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                continue;
                            }
                            if (isArchiveNew && !isArchiveExisting) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                LOGGER.debug("Keeping new dependency for targetKey: {} as it is an archive", (Object)targetKey);
                                continue;
                            }
                            if (!isArchiveExisting || isArchiveNew) continue;
                            consolidatedDependencies.put(targetKey, existingDependency);
                            LOGGER.debug("Keeping existing dependency for targetKey: {} as it is an archive", (Object)targetKey);
                            continue;
                        }
                        String targetItemId = (String)dependencyMap.get("targetItemId");
                        if (PropertyValidator.isValid((Object)targetItemId)) {
                            if (!consolidatedDependencies.containsKey(targetItemId)) {
                                consolidatedDependencies.put(targetItemId, dependencyMap);
                                continue;
                            }
                            LOGGER.debug("Removing duplicate dependency for targetItemId: {}", (Object)targetItemId);
                            continue;
                        }
                        consolidatedDependencies.put(string, dependencyMap);
                    }
                    piBoardWithDependenciesMap.put("dependencies", consolidatedDependencies);
                }
            }
        }
        long solutionBoardWithDependenciesEnd = System.currentTimeMillis();
        LOGGER.debug("Consolidated dependencies for solution boards in {} ms", (Object)(solutionBoardWithDependenciesEnd - solutionBoardWithDependenciesStart));
        for (Object piBoardWithDependencies : boardWithDependenciesMap.values()) {
            Map piBoardWithDependenciesMap = (Map)piBoardWithDependencies;
            if (!PropertyValidator.isValid(piBoardWithDependenciesMap.get("dependencies"))) continue;
            Map itemWithDependencies4 = (Map)piBoardWithDependenciesMap.get("dependencies");
            HashMap<String, Map> consolidatedDependencies = new HashMap<String, Map>();
            block68: for (Map.Entry dependencyEntry : itemWithDependencies4.entrySet()) {
                String dependencyKey = (String)dependencyEntry.getKey();
                Map dependencyMap4 = (Map)dependencyEntry.getValue();
                String targetKey = (String)dependencyMap4.get("targetKey");
                String sourceKey = (String)dependencyMap4.get("sourceKey");
                if (PropertyValidator.isValid((Object)targetKey)) {
                    for (Map.Entry entry : epicKeyWithSessionIdMap.entrySet()) {
                        if (!PropertyValidator.isValid((Object)sourceKey) || !((String)entry.getKey()).startsWith(sourceKey)) continue;
                        continue block68;
                    }
                    if (!consolidatedDependencies.containsKey(targetKey)) {
                        consolidatedDependencies.put(targetKey, dependencyMap4);
                        continue;
                    }
                    LOGGER.debug("Removing duplicate dependency for targetKey: {}", (Object)targetKey);
                    Map map = (Map)consolidatedDependencies.get(targetKey);
                    String string = (String)map.get("sessionBoardId");
                    String newSessionBoardId = (String)dependencyMap4.get("sessionBoardId");
                    if (PropertyValidator.isValid((Object)newSessionBoardId) && PropertyValidator.isValid((Object)string) && newSessionBoardId.equalsIgnoreCase(string)) {
                        boolean isSolutionNew;
                        boolean isSolutionExisting;
                        boolean isArchiveNew = dependencyMap4.getOrDefault("isArchive", false);
                        boolean isArchiveExisting = map.getOrDefault("isArchive", false);
                        if (isArchiveNew && !isArchiveExisting) {
                            isSolutionExisting = map.getOrDefault("isSolutionOnly", false);
                            isSolutionNew = dependencyMap4.getOrDefault("isSolutionOnly", false);
                            if (!isSolutionNew && isSolutionExisting) {
                                consolidatedDependencies.put(targetKey, dependencyMap4);
                            } else {
                                LOGGER.debug("Keeping existing dependency for targetKey: {} as it is solution only", (Object)targetKey);
                            }
                            LOGGER.debug("Keeping new dependency for targetKey: {} as it is an archive", (Object)targetKey);
                            continue;
                        }
                        if (!isArchiveExisting || isArchiveNew) continue;
                        isSolutionExisting = map.getOrDefault("isSolutionOnly", false);
                        isSolutionNew = dependencyMap4.getOrDefault("isSolutionOnly", false);
                        if (!isSolutionNew && isSolutionExisting) {
                            consolidatedDependencies.put(targetKey, dependencyMap4);
                        } else {
                            LOGGER.debug("Keeping existing dependency for targetKey: {} as it is solution only", (Object)targetKey);
                        }
                        LOGGER.debug("Keeping existing dependency for targetKey: {} as it is an archive", (Object)targetKey);
                        continue;
                    }
                    boolean isSolutionExisting = map.getOrDefault("isSolutionOnly", false);
                    boolean isSolutionNew = dependencyMap4.getOrDefault("isSolutionOnly", false);
                    if (!isSolutionNew && isSolutionExisting) {
                        consolidatedDependencies.put(targetKey, dependencyMap4);
                        continue;
                    }
                    LOGGER.debug("Keeping existing dependency for targetKey: {} as it is solution only", (Object)targetKey);
                    continue;
                }
                String string = (String)dependencyMap4.get("targetItemId");
                if (PropertyValidator.isValid((Object)string)) {
                    if (!consolidatedDependencies.containsKey(string)) {
                        consolidatedDependencies.put(string, dependencyMap4);
                        continue;
                    }
                    LOGGER.debug("Removing duplicate dependency for targetItemId: {}", (Object)string);
                    continue;
                }
                consolidatedDependencies.put(dependencyKey, dependencyMap4);
            }
            piBoardWithDependenciesMap.put("dependencies", consolidatedDependencies);
        }
        solutionBoardWithPiBoardMap.put("solutionBoardWithDependenciesMap", solutionBoardWithDependenciesMap);
        LOGGER.debug("Merging dependencies for the same PI board");
        long mergeStart = System.currentTimeMillis();
        LOGGER.debug("Consolidated dependencies for PI boards and solution boards in time {} ms", (Object)(mergeStart - solutionBoardWithDependenciesEnd));
        Map mergedBoardWithDependenciesMap = this.mergeDependenciesForSamePiBoard(boardWithDependenciesMap);
        long mergeEnd = System.currentTimeMillis();
        LOGGER.debug("Merging completed in {} ms", (Object)(mergeEnd - mergeStart));
        LOGGER.debug("Sorting board with dependencies by creation date");
        long sortStart = System.currentTimeMillis();
        Map sortedBoardWithDependenciesMap = this.sortBoardWithDependenciesByCreationDate(mergedBoardWithDependenciesMap);
        long sortEnd = System.currentTimeMillis();
        LOGGER.debug("Sorting completed in {} ms", (Object)(sortEnd - sortStart));
        if (PropertyValidator.isValid(solutionBoards)) {
            response.put("solutionBoardWithPiBoardMap", solutionBoardWithPiBoardMap);
        }
        response.put("boardWithDependenciesMap", sortedBoardWithDependenciesMap);
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.debug("Successfully completed fetchDependencies for TFS ID: {} in {} ms", (Object)tfsId, (Object)totalTime);
        return response;
    }

    private String extractTfsUrl(Map<String, Object> workItemData) throws Exception {
        if (PropertyValidator.isValid(workItemData) && workItemData.containsKey("url")) {
            String tfsUrl = String.valueOf(workItemData.get("url"));
            LOGGER.debug("Extracted TFS URL: {}", (Object)tfsUrl);
            return tfsUrl;
        }
        return null;
    }

    private List<Item> fetchItemsForWorkItem(String tfsId, String tenant, Set<String> teamContainerIds, String tfsUrl, Set<String> sessionBoardIds) throws Exception {
        List pipe;
        List items;
        LOGGER.debug("Fetching items for TFS ID: {} in tenant: {}", (Object)tfsId, (Object)tenant);
        BasicDBObject where = new BasicDBObject();
        where.append("tfsId", (Object)tfsId);
        if (PropertyValidator.isValid((Object)tenant)) {
            where.append("tenant", (Object)tenant);
        }
        if (PropertyValidator.isValid((Collection)(items = this.executeItemAggregation(pipe = this.buildItemAggregationPipeline(where), teamContainerIds, sessionBoardIds))) && PropertyValidator.isValid((Object)tfsUrl)) {
            items = items.stream().filter(i -> tfsUrl.equalsIgnoreCase(i.getTfsURL())).collect(Collectors.toList());
        }
        LOGGER.debug("Found {} items for TFS ID: {} with eager loaded relationships", (Object)items.size(), (Object)tfsId);
        return items;
    }

    private Set<String> collectSessionBoardIds(List<Item> items) throws Exception {
        HashSet<String> sessionBoardIds = new HashSet<String>();
        for (Item item : items) {
            if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
            for (SessionBoard sessionBoard : item.getSessionBoards()) {
                if (!PropertyValidator.isValid((Object)sessionBoard.getId())) continue;
                sessionBoardIds.add(sessionBoard.getId());
            }
        }
        LOGGER.debug("Collected {} session board IDs", (Object)sessionBoardIds.size());
        return sessionBoardIds;
    }

    private List<SessionBoard> fetchActiveSessionBoards(Set<String> sessionBoardIds, String tenant, boolean shouldFilter) throws Exception {
        if (sessionBoardIds.isEmpty()) {
            LOGGER.debug("No session board IDs to fetch");
            return Collections.emptyList();
        }
        LOGGER.debug("Fetching {} session boards with eager loading", (Object)sessionBoardIds.size());
        ArrayList<BasicDBObject> sessionBoardPipe = new ArrayList<BasicDBObject>();
        List sessionBoardObjectIds = sessionBoardIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
        BasicDBObject sessionBoardWhere = new BasicDBObject();
        sessionBoardWhere.append("_id", (Object)new BasicDBObject("$in", sessionBoardObjectIds));
        sessionBoardWhere.append("tenant", (Object)tenant);
        sessionBoardPipe.add(new BasicDBObject("$match", (Object)sessionBoardWhere));
        sessionBoardPipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'session','localField':'session.$id','foreignField':'_id','as':'session'}")));
        sessionBoardPipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$session','preserveNullAndEmptyArrays':true}}"));
        sessionBoardPipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'tFSAlmConfigurations','localField':'session.tfsAlmConfigurations.$id','foreignField':'_id','as':'session_tfsAlmConfigurations'}")));
        sessionBoardPipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$session_tfsAlmConfigurations','preserveNullAndEmptyArrays':true}}"));
        sessionBoardPipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'almAccount','localField':'session_tfsAlmConfigurations.almAccount.$id','foreignField':'_id','as':'session_tfsAlmConfigurations_almAccount'}")));
        sessionBoardPipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$session_tfsAlmConfigurations_almAccount','preserveNullAndEmptyArrays':true}}"));
        sessionBoardPipe.add(BasicDBObject.parse((String)"{'$addFields':{'session_tfsAlmConfigurations.almAccount':'$session_tfsAlmConfigurations_almAccount'}}"));
        sessionBoardPipe.add(BasicDBObject.parse((String)"{'$addFields':{'session.tfsAlmConfigurations':'$session_tfsAlmConfigurations'}}"));
        sessionBoardPipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'almConfigurations','localField':'session.almConfigurations.$id','foreignField':'_id','as':'session_almConfigurations'}")));
        sessionBoardPipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'state','localField':'state.$id','foreignField':'_id','as':'state'}")));
        sessionBoardPipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$state','preserveNullAndEmptyArrays':true}}"));
        BasicDBObject sessionBoardProject = new BasicDBObject();
        sessionBoardProject.append("_id", (Object)1);
        sessionBoardProject.append("session", (Object)1);
        sessionBoardProject.append("session_almConfigurations", (Object)1);
        sessionBoardProject.append("state", (Object)1);
        sessionBoardProject.append("creationDate", (Object)1);
        sessionBoardProject.append("createdOn", (Object)1);
        sessionBoardPipe.add(new BasicDBObject("$project", (Object)sessionBoardProject));
        List sessionBoards = this.executeSessionBoardAggregation(sessionBoardPipe);
        if (shouldFilter) {
            List<SessionBoard> activeSessionBoards = sessionBoards.stream().filter(sessionBoard -> {
                if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                    Session session = sessionBoard.getSession();
                    return PropertyValidator.isValid((Object)session.getRowStatus()) && session.getRowStatus() == 0 && PropertyValidator.isValid((Object)session.getActiveSessionBoard()) && sessionBoard.getId().equals(session.getActiveSessionBoard()) && PropertyValidator.isValid((Object)sessionBoard.getState()) && !CLOSED_STATE.equalsIgnoreCase(sessionBoard.getState().getDoneNarrative());
                }
                return false;
            }).collect(Collectors.toList());
            LOGGER.debug("Found {} active session boards with eager loaded relationships", (Object)activeSessionBoards.size());
            return activeSessionBoards;
        }
        return sessionBoards;
    }

    private List<SessionBoard> executeSessionBoardAggregation(List<DBObject> pipe) {
        DBCollection collection = this.mongoTemplate.getCollection("sessionBoard");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor cursor = collection.aggregate(pipe, ao);
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        while (cursor.hasNext()) {
            Object almConfigsObj;
            Object stateObj;
            Object sessionObj;
            Object createdOnObj;
            Object creationDateObj;
            DBObject dbObject = (DBObject)cursor.next();
            SessionBoard sessionBoard = new SessionBoard();
            Object idObj = dbObject.get("_id");
            if (idObj != null) {
                sessionBoard.setId(String.valueOf(idObj));
            }
            if ((creationDateObj = dbObject.get("creationDate")) instanceof Date) {
                sessionBoard.setCreationDate((Date)creationDateObj);
            }
            if ((createdOnObj = dbObject.get("createdOn")) instanceof Date) {
                sessionBoard.setCreatedOn((Date)createdOnObj);
            }
            if ((sessionObj = dbObject.get("session")) instanceof DBObject) {
                Object tfsAlmConfigurationsObj;
                Object activeSessionBoard;
                Object rowStatus;
                Object sessionTitle;
                DBObject sessionDbObj = (DBObject)sessionObj;
                Session session = new Session();
                Object sessionId = sessionDbObj.get("_id");
                if (sessionId != null) {
                    session.setId(String.valueOf(sessionId));
                }
                if ((sessionTitle = sessionDbObj.get("title")) != null) {
                    session.setTitle(String.valueOf(sessionTitle));
                }
                if ((rowStatus = sessionDbObj.get("rowStatus")) instanceof Integer) {
                    session.setRowStatus(((Integer)rowStatus).intValue());
                }
                if ((activeSessionBoard = sessionDbObj.get("activeSessionBoard")) != null) {
                    session.setActiveSessionBoard(String.valueOf(activeSessionBoard));
                }
                if ((tfsAlmConfigurationsObj = sessionDbObj.get("tfsAlmConfigurations")) instanceof DBObject) {
                    DBObject tfsAlmConfigDbObj = (DBObject)tfsAlmConfigurationsObj;
                    TFSAlmConfigurations tfsAlmConfigurations = new TFSAlmConfigurations();
                    Object almAccountObj = tfsAlmConfigDbObj.get("almAccount");
                    if (almAccountObj instanceof DBObject) {
                        DBObject almAccountDbObj = (DBObject)almAccountObj;
                        AlmAccount almAccount = new AlmAccount();
                        Object almAccountId = almAccountDbObj.get("_id");
                        if (almAccountId != null) {
                            almAccount.setId(String.valueOf(almAccountId));
                        }
                        tfsAlmConfigurations.setAlmAccount(almAccount);
                    }
                    session.setTfsAlmConfigurations(tfsAlmConfigurations);
                }
                sessionBoard.setSession(session);
            }
            if ((stateObj = dbObject.get("state")) instanceof DBObject) {
                Object doneNarrative;
                Object stateTitle;
                DBObject stateDbObj = (DBObject)stateObj;
                State state = new State();
                Object stateId = stateDbObj.get("_id");
                if (stateId != null) {
                    state.setId(String.valueOf(stateId));
                }
                if ((stateTitle = stateDbObj.get("title")) != null) {
                    state.setTitle(String.valueOf(stateTitle));
                }
                if ((doneNarrative = stateDbObj.get("doneNarrative")) != null) {
                    state.setDoneNarrative(String.valueOf(doneNarrative));
                }
                sessionBoard.setState(state);
            }
            if (sessionBoard.getSession() != null && (almConfigsObj = dbObject.get("session_almConfigurations")) instanceof List) {
                List almConfigsList = (List)almConfigsObj;
                ArrayList<AlmConfigurations> mappedConfigs = new ArrayList<AlmConfigurations>();
                for (Object cfgObj : almConfigsList) {
                    DBObject almAccountDbObj;
                    Object aaId;
                    Object almAccountInCfg;
                    Object cfgType;
                    Object cfgName;
                    if (!(cfgObj instanceof DBObject)) continue;
                    DBObject cfgDbObj = (DBObject)cfgObj;
                    AlmConfigurations almConfig = new AlmConfigurations();
                    Object cfgId = cfgDbObj.get("_id");
                    if (cfgId != null) {
                        almConfig.setId(String.valueOf(cfgId));
                    }
                    if ((cfgName = cfgDbObj.get("name")) != null) {
                        almConfig.setName(String.valueOf(cfgName));
                    }
                    if ((cfgType = cfgDbObj.get("type")) != null) {
                        almConfig.setType(String.valueOf(cfgType));
                    }
                    if ((almAccountInCfg = cfgDbObj.get("almAccount")) instanceof DBRef) {
                        DBRef ref = (DBRef)almAccountInCfg;
                        if (ref.getId() != null) {
                            AlmAccount almAccount = new AlmAccount();
                            almAccount.setId(String.valueOf(ref.getId()));
                            almConfig.setAlmAccount(almAccount);
                        }
                    } else if (almAccountInCfg instanceof DBObject && (aaId = (almAccountDbObj = (DBObject)almAccountInCfg).get("_id")) != null) {
                        AlmAccount almAccount = new AlmAccount();
                        almAccount.setId(String.valueOf(aaId));
                        almConfig.setAlmAccount(almAccount);
                    }
                    mappedConfigs.add(almConfig);
                }
                if (!mappedConfigs.isEmpty()) {
                    sessionBoard.getSession().setAlmConfigurations(mappedConfigs);
                }
            }
            sessionBoards.add(sessionBoard);
        }
        cursor.close();
        return sessionBoards;
    }

    private List<Item> filterActiveItems(List<Item> items, Set<String> activeSessionBoardIds) throws Exception {
        List<Item> activeItems = items.stream().filter(item -> item.getSessionBoards() != null && item.getSessionBoards().stream().anyMatch(board -> activeSessionBoardIds.contains(board.getId()))).collect(Collectors.toList());
        LOGGER.debug("Filtered to {} active items", (Object)activeItems.size());
        return activeItems;
    }

    private Map<BoardKey, Map<String, Object>> buildBoardWithItemMap(List<Item> activeItems, Map<String, Date> itemWithDatesMap, Map<String, SessionBoard> sessionBoardMap) throws Exception {
        HashMap<BoardKey, Map<String, Object>> boardWithItemMap = new HashMap<BoardKey, Map<String, Object>>();
        for (Item item : activeItems) {
            if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                Iterator iterator = item.getSessionBoards().iterator();
                while (iterator.hasNext()) {
                    SessionBoard cached;
                    SessionBoard sbLite;
                    SessionBoard sessionBoard = sbLite = (SessionBoard)iterator.next();
                    if (PropertyValidator.isValid((Object)sbLite.getId()) && sessionBoardMap != null && PropertyValidator.isValid((Object)(cached = sessionBoardMap.get(sbLite.getId())))) {
                        sessionBoard = cached;
                    }
                    String solutionBoardId = item.getSolutionBoard() != null ? item.getSolutionBoard().getId() : null;
                    BoardKey boardKey = new BoardKey(solutionBoardId, sessionBoard.getId(), sessionBoard);
                    Map itemMap = this.buildItemMap(item);
                    itemMap.put("boardSessionId", sessionBoard.getSession().getId());
                    if (!boardWithItemMap.containsKey(boardKey)) {
                        boardWithItemMap.put(boardKey, itemMap);
                        continue;
                    }
                    Map existingItemMap = (Map)boardWithItemMap.get(boardKey);
                    Item existingItem = (Item)existingItemMap.get("item");
                    if (!PropertyValidator.isValid((Collection)item.getTeamContainers()) || PropertyValidator.isValid((Collection)existingItem.getTeamContainers())) continue;
                    boardWithItemMap.put(boardKey, itemMap);
                }
            }
            if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
            for (TeamContainer teamContainer : item.getTeamContainers()) {
                if (!PropertyValidator.isValid((Object)teamContainer.getContainer())) continue;
                Container container = teamContainer.getContainer();
                itemWithDatesMap.put(item.getId(), container.getEndDate());
            }
        }
        LOGGER.debug("Built board with item map for {} boards", (Object)boardWithItemMap.size());
        for (BoardKey key : boardWithItemMap.keySet()) {
            LOGGER.debug("Composite key: {} -> SolutionBoard: {}, SessionBoard: {}", new Object[]{key.toString(), key.getSolutionBoardId(), key.getSessionBoardId()});
        }
        return boardWithItemMap;
    }

    private Map<BoardKey, Map<String, Object>> buildJiraBoardWithItemMap(List<Item> activeItems, Map<String, Date> itemWithDatesMap, Map<String, SessionBoard> sessionBoardMap) throws Exception {
        HashMap<BoardKey, Map<String, Object>> boardWithItemMap = new HashMap<BoardKey, Map<String, Object>>();
        for (Item item : activeItems) {
            if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                Iterator iterator = item.getSessionBoards().iterator();
                while (iterator.hasNext()) {
                    SessionBoard cached;
                    SessionBoard sbLite;
                    SessionBoard sessionBoard = sbLite = (SessionBoard)iterator.next();
                    if (PropertyValidator.isValid((Object)sbLite.getId()) && sessionBoardMap != null && PropertyValidator.isValid((Object)(cached = sessionBoardMap.get(sbLite.getId())))) {
                        sessionBoard = cached;
                    }
                    String solutionBoardId = item.getSolutionBoard() != null ? item.getSolutionBoard().getId() : null;
                    BoardKey boardKey = new BoardKey(solutionBoardId, sessionBoard.getId(), sessionBoard);
                    Map itemMap = this.buildJiraItemMap(item);
                    itemMap.put("boardSessionId", sessionBoard.getSession().getId());
                    if (!boardWithItemMap.containsKey(boardKey)) {
                        boardWithItemMap.put(boardKey, itemMap);
                        continue;
                    }
                    Map existingItemMap = (Map)boardWithItemMap.get(boardKey);
                    Item existingItem = (Item)existingItemMap.get("item");
                    if (!PropertyValidator.isValid((Collection)item.getTeamContainers()) || PropertyValidator.isValid((Collection)existingItem.getTeamContainers())) continue;
                    boardWithItemMap.put(boardKey, itemMap);
                }
            }
            if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
            for (TeamContainer teamContainer : item.getTeamContainers()) {
                if (!PropertyValidator.isValid((Object)teamContainer.getContainer())) continue;
                Container container = teamContainer.getContainer();
                itemWithDatesMap.put(item.getId(), container.getEndDate());
            }
        }
        LOGGER.debug("Built board with item map for {} boards", (Object)boardWithItemMap.size());
        for (BoardKey key : boardWithItemMap.keySet()) {
            LOGGER.debug("Composite key: {} -> SolutionBoard: {}, SessionBoard: {}", new Object[]{key.toString(), key.getSolutionBoardId(), key.getSessionBoardId()});
        }
        return boardWithItemMap;
    }

    private Map<String, Object> buildItemMap(Item item) throws Exception {
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        itemMap.put("key", item.getTfsId());
        itemMap.put("sourceSummary", item.getTitle());
        itemMap.put("targetDate", item.getEndDate());
        itemMap.put("sourceIcon", item.getTfsItemTypeIcon());
        itemMap.put("sourceTfsUrl", item.getTfsURL());
        if (PropertyValidator.isValid((Object)item.getStatus())) {
            itemMap.put("sourceStatus", item.getStatus().getTitle());
            itemMap.put("sourceStatusCategory", item.getStatus().getCategory());
        }
        itemMap.put("item", item);
        return itemMap;
    }

    private Map<String, Object> buildJiraItemMap(Item item) throws Exception {
        Map issueType;
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        itemMap.put("key", item.getJiraKey());
        itemMap.put("sourceSummary", item.getTitle());
        itemMap.put("targetDate", item.getEndDate());
        if (PropertyValidator.isValid((Object)item.getJiraFieldByKey()) && PropertyValidator.isValid(item.getJiraFieldByKey().get("issuetype")) && PropertyValidator.isValid((issueType = (Map)item.getJiraFieldByKey().get("issuetype")).get("iconUrl"))) {
            itemMap.put("sourceIcon", issueType.get("iconUrl"));
        }
        if (PropertyValidator.isValid((Object)item.getJiraURL())) {
            itemMap.put("sourceTfsUrl", item.getJiraURL());
        } else if (PropertyValidator.isValid((Object)item.getJiraFieldByKey()) && PropertyValidator.isValid(item.getJiraFieldByKey().get("issuetype")) && PropertyValidator.isValid((issueType = (Map)item.getJiraFieldByKey().get("issuetype")).get("self"))) {
            String issueTypeUrl = (String)issueType.get("self");
            int index = issueTypeUrl.indexOf("/rest");
            String jiraURL = index >= 0 ? issueTypeUrl.substring(0, index) : issueTypeUrl;
            jiraURL = jiraURL + "/browse/" + item.getJiraKey();
            itemMap.put("sourceTfsUrl", jiraURL);
        }
        if (PropertyValidator.isValid((Object)item.getStatus())) {
            itemMap.put("sourceStatus", item.getStatus().getTitle());
            itemMap.put("sourceStatusCategory", item.getStatus().getCategory());
        }
        itemMap.put("item", item);
        return itemMap;
    }

    private Map<String, Object> findBoardDataBySessionBoardId(Map<String, Object> boardWithDependenciesMap, String sessionBoardId, String solutionBoardId) {
        String compositeKey = solutionBoardId + "::" + sessionBoardId;
        LOGGER.debug("Looking for board data with composite key: {}", (Object)compositeKey);
        Map boardData = (Map)boardWithDependenciesMap.get(compositeKey);
        if (boardData != null) {
            LOGGER.debug("Found board data with exact composite key match");
            return boardData;
        }
        LOGGER.debug("Exact match not found, searching for session board ID: {}", (Object)sessionBoardId);
        for (Map.Entry<String, Object> entry : boardWithDependenciesMap.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("::" + sessionBoardId)) continue;
            LOGGER.debug("Found board data with fallback match using key: {}", (Object)key);
            return (Map)entry.getValue();
        }
        LOGGER.debug("No board data found for session board ID: {} and solution board ID: {}", (Object)sessionBoardId, (Object)solutionBoardId);
        return null;
    }

    private Map<String, Object> buildBoardWithDependenciesMap(Map<BoardKey, Map<String, Object>> boardWithItemMap, Map<String, Date> itemWithDatesMap, Set<String> dependentItemIds, Set<String> containerIds, Map<TfsItemKey, Object> missingItems, String tenant, Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, Set<String> teamContainerIds, Map<String, Object> boardWithLinkTypesMap, Set<String> sessionBoardIds, Map<String, Object> almDependenciesMap, Map<String, Conversation> conversationMap) throws Exception {
        LOGGER.debug("Building board with dependencies map for {} board keys", (Object)boardWithItemMap.size());
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> boardWithDependenciesMap = new HashMap<String, Object>();
        for (Map.Entry<BoardKey, Map<String, Object>> entry : boardWithItemMap.entrySet()) {
            BoardKey boardKey = entry.getKey();
            SessionBoard sessionBoard = boardKey.getSessionBoard();
            Map<String, Object> itemMap = entry.getValue();
            Item item = (Item)itemMap.get("item");
            LOGGER.debug("Processing board key: {} for item: {}", (Object)boardKey.toString(), (Object)item.getTfsId());
            Map dependenciesMap = this.buildDependenciesForItem(item, sessionBoard, itemWithDatesMap, dependentItemIds, containerIds, missingItems, tenant, itemLinkMap, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, teamContainerIds, boardWithLinkTypesMap, sessionBoardIds, almDependenciesMap, conversationMap);
            itemMap.put("dependencies", dependenciesMap);
            itemMap.remove("item");
            itemMap.put("boardTitle", sessionBoard.getSession().getTitle());
            itemMap.put("boardCreationDate", sessionBoard.getCreationDate());
            itemMap.put("boardCreatedOn", sessionBoard.getCreatedOn());
            boardWithDependenciesMap.put(boardKey.toString(), itemMap);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Built board with dependencies map for {} boards in {} ms", (Object)boardWithDependenciesMap.size(), (Object)(endTime - startTime));
        return boardWithDependenciesMap;
    }

    private Map<String, Object> buildDependenciesForItem(Item item, SessionBoard sessionBoard, Map<String, Date> itemWithDatesMap, Set<String> dependencyItems, Set<String> containerIds, Map<TfsItemKey, Object> missingItems, String tenant, Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, Set<String> teamContainerIds, Map<String, Object> boardWithLinkTypesMap, Set<String> sessionBoardIds, Map<String, Object> almDependenciesMap, Map<String, Conversation> conversationMap) throws Exception {
        LOGGER.debug("Building dependencies for item: {} on session board: {}", (Object)item.getTfsId(), (Object)sessionBoard.getId());
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> itemDependenciesMap = new HashMap<String, Object>();
        HashSet linkedTfsKeys = new HashSet();
        this.processKendisDependencies(item, itemDependenciesMap, dependencyItems, sessionBoard, linkedTfsKeys, containerIds, itemLinkMap, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, tenant, teamContainerIds, boardWithLinkTypesMap, conversationMap);
        this.processAlmDependencies(item, sessionBoard, itemDependenciesMap, dependencyItems, linkedTfsKeys, missingItems, tenant, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, teamContainerIds, containerIds, boardWithLinkTypesMap, sessionBoardIds, almDependenciesMap, conversationMap);
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Built dependencies for item: {} in {} ms, found {} dependencies", new Object[]{item.getTfsId(), endTime - startTime, itemDependenciesMap.size()});
        return itemDependenciesMap;
    }

    private void processKendisDependencies(Item item, Map<String, Object> itemDependenciesMap, Set<String> dependencyItems, SessionBoard sessionBoard, Set<String> linkedTfsKeys, Set<String> containerIds, Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, String tenant, Set<String> teamContainerIds, Map<String, Object> boardWithLinkTypesMap, Map<String, Conversation> conversationMap) throws Exception {
        List targetItemLinks;
        LOGGER.debug("Processing Kendis dependencies for item: {}", (Object)item.getTfsId());
        long startTime = System.currentTimeMillis();
        HashSet<String> fetchedDependencies = new HashSet<String>();
        if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
            for (ItemLink itemLinkRef : item.getItemLinks()) {
                Object tfsLinkType;
                Map attribute;
                ItemLink itemLink = itemLinkMap.get(itemLinkRef.getId());
                if (itemLink == null) {
                    LOGGER.debug("ItemLink not found in map for ID: {}", (Object)itemLinkRef.getId());
                    continue;
                }
                if (!PropertyValidator.isValid((Object)itemLink.getType())) continue;
                HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
                if (PropertyValidator.isValid((Object)itemLink.getResponsible())) {
                    User responsible = itemLink.getResponsible();
                    LOGGER.debug("Found responsible user: {} against itemLink :{} ", (Object)responsible.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("responsibleUserId", responsible.getId());
                    dependencyMap.put("responsibleUserName", responsible.getUserName());
                    dependencyMap.put("responsibleFullName", responsible.getFullName());
                    dependencyMap.put("responsibleImage", responsible.getPicturePath());
                }
                if (PropertyValidator.isValid((Object)itemLink.getReporter())) {
                    User reporter = itemLink.getReporter();
                    LOGGER.debug("Found reporter user: {} against itemLink :{} ", (Object)reporter.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("reporterUserId", reporter.getId());
                    dependencyMap.put("reporterUserName", reporter.getUserName());
                    dependencyMap.put("reporterFullName", reporter.getFullName());
                    dependencyMap.put("reporterImage", reporter.getPicturePath());
                }
                dependencyMap.put("customId", itemLink.getCustomId());
                this.addCommentsToDependency(dependencyMap, itemLink.getConversations(), conversationMap);
                dependencyMap.put("type", itemLink.getType());
                dependencyMap.put("targetKey", itemLink.getTargetTfsId());
                linkedTfsKeys.add(itemLink.getTargetTfsId());
                fetchedDependencies.add(itemLink.getId());
                dependencyMap.put("sourceTeamContainerId", itemLink.getSourceTeamContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceTeamContainerId())) {
                    teamContainerIds.add(itemLink.getSourceTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) {
                    teamContainerIds.add(itemLink.getTargetTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                dependencyMap.put("targetTeamContainerId", itemLink.getTargetTeamContainerId());
                dependencyMap.put("sourceContainerId", itemLink.getSourceContainerId());
                dependencyMap.put("targetContainerId", itemLink.getTargetContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getSourceContainerId());
                    containerIds.add(itemLink.getTargetContainerId());
                }
                dependencyMap.put("sessionBoardId", itemLink.getSessionBoardId());
                dependencyMap.put("sourceSessionId", itemLink.getSourceSessionId());
                dependencyMap.put("targetSessionId", itemLink.getTargetSessionId());
                dependencyMap.put("sourceKey", item.getTfsId());
                dependencyMap.put("description", itemLink.getDescription());
                dependencyMap.put("sourceBoardTitle", sessionBoard.getSession().getTitle());
                if (PropertyValidator.isValid((Object)itemLink.getWfStatus())) {
                    dependencyMap.put("dependencyStatus", itemLink.getWfStatus().getTitle());
                    dependencyMap.put("dependencyStatusCategory", itemLink.getWfStatus().getCategory());
                }
                dependencyMap.put("richDescription", itemLink.getRichDescription());
                dependencyMap.put("dueDate", itemLink.getDueDate());
                dependencyMap.put("dependencyId", itemLink.getId());
                dependencyMap.put("solutionId", itemLink.getSolutionId());
                dependencyMap.put("raisedOn", itemLink.getRaisedOn());
                dependencyMap.put("linkOrigin", LINK_TYPE_KENDIS);
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    dependencyMap.put("targetItemId", itemLink.getTargetUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    dependencyMap.put("targetItemId", itemLink.getTargetFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    dependencyMap.put("targetItemId", itemLink.getTargetItemId());
                } else {
                    LOGGER.debug("No target item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    dependencyMap.put("sourceItemId", itemLink.getSourceUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    dependencyMap.put("sourceItemId", itemLink.getSourceFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceItemId())) {
                    dependencyMap.put("sourceItemId", itemLink.getSourceItemId());
                } else {
                    LOGGER.debug("No source item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (!PropertyValidator.isValid(dependencyMap.get("targetItemId"))) {
                    LOGGER.debug("No target item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                dependencyItems.add(dependencyMap.get("targetItemId").toString());
                dependencyItems.add(item.getId());
                itemDependenciesMap.put(dependencyMap.get("targetItemId").toString(), dependencyMap);
                if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                    dependencyMap.put("isSolutionOnly", true);
                }
                if (PropertyValidator.isValid((Object)(attribute = (Map)boardWithLinkTypesMap.get(tfsLinkType = itemLink.getType())))) {
                    Map attributes;
                    String name = (String)attribute.get("name");
                    Map map = attributes = attribute.get("attributes") != null ? (Map)attribute.get("attributes") : null;
                    if (PropertyValidator.isValid((Object)attributes)) {
                        Boolean isForward = (Boolean)attributes.get("isForward");
                        if (PropertyValidator.isValid((Object)isForward) && isForward.booleanValue()) {
                            dependencyMap.put("arrowDirection", "reverse");
                        } else {
                            dependencyMap.put("arrowDirection", "forward");
                        }
                    }
                    if (PropertyValidator.isValid((Object)name)) {
                        dependencyMap.put("type", name);
                    }
                }
                if (!PropertyValidator.isValid(dependencyMap.get("type"))) {
                    dependencyMap.put("type", "");
                }
                if (!PropertyValidator.isValid(dependencyMap.get("arrowDirection"))) {
                    String type = dependencyMap.get("type").toString();
                    if ("Successor".equalsIgnoreCase(type) || "Depends on".equalsIgnoreCase(type) || "Is Blocking".equalsIgnoreCase(type) || "Produces For".equalsIgnoreCase(type) || "Associated By".equalsIgnoreCase(type)) {
                        dependencyMap.put("arrowDirection", "reverse");
                    } else {
                        dependencyMap.put("arrowDirection", "forward");
                    }
                }
                if ("Depends On".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Dependent on".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated With".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated By".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Is Blocking".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Blocked By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                    dependencyMap.put("linkType", LINK_TYPE_KENDIS);
                    continue;
                }
                dependencyMap.put("linkType", LINK_TYPE_ALM);
            }
        }
        if (PropertyValidator.isValid((Collection)(targetItemLinks = this.fetchTargetItemLinksWithAggregation(item.getId(), tenant)))) {
            HashSet<String> conversationIds = new HashSet<String>();
            for (Object link : targetItemLinks) {
                if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
                for (Conversation c : link.getConversations()) {
                    if (!PropertyValidator.isValid((Object)c) || !PropertyValidator.isValid((Object)c.getId())) continue;
                    conversationIds.add(c.getId());
                }
            }
            if (!conversationIds.isEmpty()) {
                conversationMap.putAll(this.fetchConversationsByIds(conversationIds));
                HashSet<String> userIds = new HashSet<String>();
                for (ItemLink link : targetItemLinks) {
                    if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
                    ArrayList<Conversation> updated = new ArrayList<Conversation>();
                    for (Conversation c : link.getConversations()) {
                        Conversation full;
                        Conversation conversation = full = PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getId()) ? conversationMap.get(c.getId()) : null;
                        if (PropertyValidator.isValid(full)) {
                            if (PropertyValidator.isValid((Object)full.getUser()) && PropertyValidator.isValid((Object)full.getUser().getId())) {
                                userIds.add(full.getUser().getId());
                            }
                            updated.add(full);
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getUser()) && PropertyValidator.isValid((Object)c.getUser().getId())) {
                            userIds.add(c.getUser().getId());
                        }
                        updated.add(c);
                    }
                    link.setConversations(updated);
                }
            }
            for (ItemLink itemLink : targetItemLinks) {
                if (!PropertyValidator.isValid((Object)itemLink.getType()) || fetchedDependencies.contains(itemLink.getId()) && linkedTfsKeys.contains(itemLink.getSourceTfsId()) || PropertyValidator.isValid((Object)itemLink.getTargetFeatureId()) && !itemLink.getTargetFeatureId().equals(item.getId()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && !itemLink.getTargetUserStoryId().equals(item.getId()) || PropertyValidator.isValid((Object)itemLink.getTargetItemId()) && !itemLink.getTargetItemId().equals(item.getId()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && !itemLink.getTargetUserStoryId().equals(item.getId()) || PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && !itemLink.getTargetUserStoryId().equals(item.getId()) || !PropertyValidator.isValid((Object)item.getSolutionBoard()) && PropertyValidator.isValid((Object)itemLink.getSessionBoardId()) && !sessionBoard.getId().equalsIgnoreCase(itemLink.getSessionBoardId()) && !sessionBoard.getSession().getId().equalsIgnoreCase(itemLink.getTargetSessionId())) continue;
                HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
                this.addCommentsToDependency(dependencyMap, itemLink.getConversations(), conversationMap);
                if (PropertyValidator.isValid((Object)itemLink.getResponsible())) {
                    User responsible = itemLink.getResponsible();
                    LOGGER.debug("Found responsible user: {} against itemLink :{} ", (Object)responsible.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("responsibleUserId", responsible.getId());
                    dependencyMap.put("responsibleUserName", responsible.getUserName());
                    dependencyMap.put("responsibleFullName", responsible.getFullName());
                    dependencyMap.put("responsibleImage", responsible.getPicturePath());
                }
                if (PropertyValidator.isValid((Object)itemLink.getReporter())) {
                    User reporter = itemLink.getReporter();
                    LOGGER.debug("Found reporter user: {} against itemLink :{} ", (Object)reporter.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("reporterUserId", reporter.getId());
                    dependencyMap.put("reporterUserName", reporter.getUserName());
                    dependencyMap.put("reporterFullName", reporter.getFullName());
                    dependencyMap.put("reporterImage", reporter.getPicturePath());
                }
                dependencyMap.put("customId", itemLink.getCustomId());
                dependencyMap.put("reverseLink", true);
                dependencyMap.put("type", itemLink.getType());
                dependencyMap.put("linkOrigin", LINK_TYPE_KENDIS);
                dependencyMap.put("sourceBoardTitle", sessionBoard.getSession().getTitle());
                dependencyMap.put("targetKey", itemLink.getSourceTfsId());
                dependencyMap.put("sourceTeamContainerId", itemLink.getTargetTeamContainerId());
                dependencyMap.put("targetTeamContainerId", itemLink.getSourceTeamContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceTeamContainerId())) {
                    teamContainerIds.add(itemLink.getSourceTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) {
                    teamContainerIds.add(itemLink.getTargetTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                linkedTfsKeys.add(itemLink.getSourceTfsId());
                if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                    dependencyMap.put("isSolutionOnly", true);
                }
                dependencyMap.put("targetContainerId", itemLink.getSourceContainerId());
                dependencyMap.put("sourceContainerId", itemLink.getTargetContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getSourceContainerId());
                    containerIds.add(itemLink.getTargetContainerId());
                }
                dependencyMap.put("sessionBoardId", itemLink.getSessionBoardId());
                dependencyMap.put("targetSessionId", itemLink.getSourceSessionId());
                dependencyMap.put("sourceSessionId", itemLink.getTargetSessionId());
                dependencyMap.put("sourceKey", item.getTfsId());
                dependencyMap.put("description", itemLink.getDescription());
                dependencyMap.put("raisedOn", itemLink.getRaisedOn());
                if (PropertyValidator.isValid((Object)itemLink.getWfStatus())) {
                    dependencyMap.put("dependencyStatus", itemLink.getWfStatus().getTitle());
                    dependencyMap.put("dependencyStatusCategory", itemLink.getWfStatus().getCategory());
                }
                dependencyMap.put("richDescription", itemLink.getRichDescription());
                dependencyMap.put("dueDate", itemLink.getDueDate());
                dependencyMap.put("dependencyId", itemLink.getId());
                dependencyMap.put("solutionId", itemLink.getSolutionId());
                String tfsLinkType = itemLink.getType();
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    dependencyMap.put("sourceItemId", itemLink.getTargetUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    dependencyMap.put("sourceItemId", itemLink.getTargetFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    dependencyMap.put("sourceItemId", itemLink.getTargetItemId());
                } else {
                    LOGGER.debug("No source item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    dependencyMap.put("targetItemId", itemLink.getSourceUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    dependencyMap.put("targetItemId", itemLink.getSourceFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceItemId())) {
                    dependencyMap.put("targetItemId", itemLink.getSourceItemId());
                } else {
                    LOGGER.debug("No source item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (!PropertyValidator.isValid(dependencyMap.get("targetItemId"))) {
                    LOGGER.debug("No target item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                dependencyItems.add(dependencyMap.get("targetItemId").toString());
                dependencyItems.add(item.getId());
                itemDependenciesMap.put(dependencyMap.get("targetItemId").toString(), dependencyMap);
                if (tfsLinkType.endsWith("-Forward")) {
                    tfsLinkType = tfsLinkType.substring(0, tfsLinkType.length() - "-Forward".length()) + "-Reverse";
                } else if (tfsLinkType.endsWith("-Reverse")) {
                    tfsLinkType = tfsLinkType.substring(0, tfsLinkType.length() - "-Reverse".length()) + "-Forward";
                }
                Map attribute = (Map)boardWithLinkTypesMap.get(tfsLinkType);
                if (PropertyValidator.isValid((Object)attribute)) {
                    Map attributes;
                    String name = (String)attribute.get("name");
                    Map map = attributes = attribute.get("attributes") != null ? (Map)attribute.get("attributes") : null;
                    if (PropertyValidator.isValid((Object)attributes)) {
                        Boolean isForward = (Boolean)attributes.get("isForward");
                        if (PropertyValidator.isValid((Object)isForward) && isForward.booleanValue()) {
                            dependencyMap.put("arrowDirection", "reverse");
                        } else if ("Consumes From".equalsIgnoreCase(name) || "Predecessor".equalsIgnoreCase(name)) {
                            dependencyMap.put("arrowDirection", "forward");
                        } else {
                            dependencyMap.put("arrowDirection", "reverse");
                        }
                    }
                    if (PropertyValidator.isValid((Object)name)) {
                        dependencyMap.put("type", name);
                    }
                }
                if (attribute == null) {
                    String jiraLinkType = itemLink.getType();
                    String[] split = jiraLinkType.split("-");
                    String linkTypeId = null;
                    if (split.length > 1) {
                        linkTypeId = split[0];
                    }
                    if (PropertyValidator.isValid(linkTypeId)) {
                        attribute = (Map)boardWithLinkTypesMap.get(linkTypeId);
                    }
                    if (attribute != null) {
                        String id = (String)attribute.get("id");
                        if (null != linkTypeId && null != id && id.equalsIgnoreCase(linkTypeId)) {
                            if (split.length > 1) {
                                String direction = split[1];
                                if (direction.equalsIgnoreCase("OUT")) {
                                    String inward = (String)attribute.get("inward");
                                    dependencyMap.put("type", inward);
                                    dependencyMap.put("arrowDirection", "forward");
                                } else {
                                    String outward = (String)attribute.get("outward");
                                    dependencyMap.put("type", outward);
                                    dependencyMap.put("arrowDirection", "reverse");
                                }
                            } else {
                                dependencyMap.put("type", attribute.get("inward"));
                            }
                        }
                    } else {
                        dependencyMap.put("skipTypeCheck", true);
                        dependencyMap.put("shouldReverse", true);
                        this.reverseKendisDependencyType(dependencyMap);
                    }
                }
                if (!PropertyValidator.isValid(dependencyMap.get("type"))) {
                    dependencyMap.put("type", "");
                }
                if (!PropertyValidator.isValid(dependencyMap.get("skipTypeCheck"))) {
                    if ("Associated By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                        dependencyMap.put("type", "Associated with");
                    } else if ("Blocked By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                        dependencyMap.put("type", "is Blocking");
                    } else if ("Depends on".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                        dependencyMap.put("type", "Dependent on");
                    }
                }
                if ("Depends On".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Dependent on".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated With".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated By".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Is Blocking".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Blocked By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                    dependencyMap.put("linkType", LINK_TYPE_KENDIS);
                    continue;
                }
                dependencyMap.put("linkType", LINK_TYPE_ALM);
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Processed Kendis dependencies for item: {} in {} ms, found {} dependencies", new Object[]{item.getTfsId(), endTime - startTime, fetchedDependencies.size()});
    }

    private void reverseKendisDependencyType(Map<String, Object> dependencyMap) {
        if ("Associated By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
            dependencyMap.put("type", "Associated with");
        } else if ("Blocked By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
            dependencyMap.put("type", "is Blocking");
        } else if ("Depends on".equalsIgnoreCase(dependencyMap.get("type").toString())) {
            dependencyMap.put("type", "Dependent on");
        } else if ("Associated with".equalsIgnoreCase(dependencyMap.get("type").toString())) {
            dependencyMap.put("type", "Associated By");
        } else if ("is Blocking".equalsIgnoreCase(dependencyMap.get("type").toString())) {
            dependencyMap.put("type", "Blocked By");
        } else if ("Dependent on".equalsIgnoreCase(dependencyMap.get("type").toString())) {
            dependencyMap.put("type", "Depends on");
        }
    }

    private void addCommentsToDependency(Map<String, Object> dependencyMap, List<Conversation> conversations, Map<String, Conversation> conversationMap) throws Exception {
        if (PropertyValidator.isValid(conversations)) {
            List commentsList = conversations.stream().map(conversationRef -> {
                Conversation comment = conversationRef;
                if (PropertyValidator.isValid((Object)comment) && PropertyValidator.isValid((Object)comment.getId())) {
                    comment = conversationMap.getOrDefault(comment.getId(), comment);
                }
                HashMap<String, Object> commentMap = new HashMap<String, Object>();
                if (PropertyValidator.isValid((Object)comment)) {
                    if (PropertyValidator.isValid((Object)comment.getText())) {
                        String input = comment.getText();
                        String cleaned = input.replaceAll("~~\\[~|~\\]", "");
                        cleaned = cleaned.replaceAll("\\[-|\\-\\]", "");
                        cleaned = cleaned.replaceAll("&nbsp;", "");
                        cleaned = cleaned.replaceAll("\\b[\\w.%+-]+@[\\w.-]+\\.[A-Za-z]{2,6}\\b", "");
                        cleaned = cleaned.replaceAll("\\s+", " ").trim();
                        commentMap.put("comment", cleaned);
                    }
                    if (PropertyValidator.isValid((Object)comment.getUser())) {
                        User user = comment.getUser();
                        if (PropertyValidator.isValid((Object)user.getFullName())) {
                            commentMap.put("createdBy", user.getFullName());
                        }
                        if (PropertyValidator.isValid((Object)user.getId())) {
                            commentMap.put("userId", user.getId());
                        }
                        if (PropertyValidator.isValid((Object)user.getUserName())) {
                            commentMap.put("userEmail", user.getUserName());
                        }
                        if (PropertyValidator.isValid((Object)user.getPicturePath())) {
                            commentMap.put("userImage", user.getPicturePath());
                        }
                    }
                    commentMap.put("createdAt", comment.getCreatedOn());
                    commentMap.put("id", comment.getId());
                }
                return commentMap;
            }).collect(Collectors.toList());
            dependencyMap.put("comments", commentsList);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void processAlmDependencies(Item item, SessionBoard sessionBoard, Map<String, Object> itemDependenciesMap, Set<String> dependencyItems, Set<String> linkedTfsKeys, Map<TfsItemKey, Object> missingItemsMap, String tenant, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, Set<String> teamContainerIds, Set<String> containerIds, Map<String, Object> boardWithLinkTypesMap, Set<String> sessionBoardIds, Map<String, Object> almDependenciesMap, Map<String, Conversation> conversationMap) throws Exception {
        LOGGER.debug("Processing ALM dependencies for item: {}", (Object)item.getTfsId());
        long startTime = System.currentTimeMillis();
        if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
            LOGGER.debug("No Jira dependencies found for item: {}", (Object)item.getTfsId());
            return;
        }
        HashMap<String, Map> missingItemIdsDependencies = new HashMap<String, Map>();
        HashMap<String, Map> missingTFSURLsDependencies = new HashMap<String, Map>();
        block0: for (ItemJiraDependency jiraDependencyRef : item.getJiraDependencies()) {
            ItemJiraDependency jiraDependency = itemJiraDependencyMap.get(jiraDependencyRef.getId());
            if (jiraDependency == null) {
                LOGGER.debug("ItemJiraDependency not found in map for ID: {}", (Object)jiraDependencyRef.getId());
                continue;
            }
            if (PropertyValidator.isValid((Object)jiraDependencyRef.getDirection())) {
                jiraDependency.setDirection(jiraDependencyRef.getDirection());
            }
            if (!PropertyValidator.isValid((Object)jiraDependency) || !PropertyValidator.isValid((Object)jiraDependency.getTargetTFSItem())) continue;
            if (PropertyValidator.isValid((Object)jiraDependency.getTargetTFSItem()) && jiraDependency.getTargetTFSItem().getUrl().equalsIgnoreCase(item.getTfsURL())) {
                TFSIssue source = jiraDependency.getSourceTFSItem();
                TFSIssue target = jiraDependency.getTargetTFSItem();
                String linkType = jiraDependency.getTfsLinkType();
                if (linkType.endsWith("-Forward")) {
                    linkType = linkType.substring(0, linkType.length() - "-Forward".length()) + "-Reverse";
                } else if (linkType.endsWith("-Reverse")) {
                    linkType = linkType.substring(0, linkType.length() - "-Reverse".length()) + "-Forward";
                }
                jiraDependency.setTfsLinkType(linkType);
                jiraDependency.setTargetTFSItem(source);
                jiraDependency.setSourceTFSItem(target);
                jiraDependency.setTargetItemId(jiraDependency.getSourceItemId());
                jiraDependency.setSourceItemId(item.getId());
                if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && !item.getSessionBoards().isEmpty()) {
                    String sessionBoardId = ((SessionBoard)item.getSessionBoards().get(0)).getId();
                    jiraDependency.setSessionBoardId(sessionBoardId);
                }
            }
            if (PropertyValidator.isValid((Object)jiraDependency.getTargetTFSItem()) && linkedTfsKeys.contains(jiraDependency.getTargetTFSItem().getTfsId())) {
                for (Object dependency : itemDependenciesMap.values()) {
                    Map dependencyMap = (Map)dependency;
                    if (!jiraDependency.getTargetTFSItem().getTfsId().equals(dependencyMap.get("targetKey")) && !jiraDependency.getTargetTFSItem().getTfsId().equals(dependencyMap.get("sourceKey")) || !PropertyValidator.isValid(dependencyMap.get("type")) || (!dependencyMap.get("type").toString().equalsIgnoreCase("Predecessor") && !dependencyMap.get("type").toString().equalsIgnoreCase("Successor") || !"System.LinkTypes.Dependency-Forward".equalsIgnoreCase(jiraDependency.getTfsLinkType()) && !"System.LinkTypes.Dependency-Reverse".equalsIgnoreCase(jiraDependency.getTfsLinkType())) && (!"System.LinkTypes.Related".equalsIgnoreCase(jiraDependency.getTfsLinkType()) || !dependencyMap.get("type").toString().equalsIgnoreCase("Related"))) continue;
                    LOGGER.debug("Skipping ALM dependency as it already exists in itemDependenciesMap for item: {} and dependency : {}", (Object)item.getId(), (Object)jiraDependency.getId());
                    continue block0;
                }
            }
            Map dependencyMap = this.buildAlmDependencyMap(jiraDependency, item, sessionBoard, linkedTfsKeys, teamContainerIds, containerIds, boardWithLinkTypesMap);
            this.addCommentsToDependency(dependencyMap, jiraDependency.getConversations(), conversationMap);
            if (PropertyValidator.isValid((Object)jiraDependency.getTargetItemId())) {
                if (itemDependenciesMap.containsKey(jiraDependency.getTargetItemId())) {
                    boolean shouldAdd = false;
                    if (PropertyValidator.isValid((Object)jiraDependency.getSessionBoardId()) && sessionBoard.getId().equalsIgnoreCase(jiraDependency.getSessionBoardId())) {
                        shouldAdd = true;
                    }
                    if (!shouldAdd) {
                        for (Object dependency : itemDependenciesMap.values()) {
                            boolean isDepDep;
                            Map fetchedDependencyMap = (Map)dependency;
                            String fetchedType = String.valueOf(fetchedDependencyMap.get("type"));
                            String depType = String.valueOf(dependencyMap.get("type"));
                            boolean isFetchedRelated = "Related".equalsIgnoreCase(fetchedType);
                            boolean isFetchedDep = !isFetchedRelated;
                            boolean isDepRelated = "Related".equalsIgnoreCase(depType);
                            boolean bl = isDepDep = !isDepRelated;
                            if ((!isFetchedRelated || !isDepDep) && (!isDepRelated || !isFetchedDep)) continue;
                            shouldAdd = true;
                            break;
                        }
                    }
                    if (shouldAdd) {
                        if (PropertyValidator.isValid((Object)jiraDependency.getTargetItemId())) {
                            dependencyItems.add(jiraDependency.getTargetItemId());
                        }
                        itemDependenciesMap.put(jiraDependency.getTargetTFSItem().getTfsId(), dependencyMap);
                    } else {
                        almDependenciesMap.put(jiraDependency.getTargetItemId(), dependencyMap);
                    }
                } else {
                    itemDependenciesMap.put(jiraDependency.getTargetItemId(), dependencyMap);
                }
                dependencyItems.add(jiraDependency.getSourceItemId());
                dependencyItems.add(jiraDependency.getTargetItemId());
                continue;
            }
            if (!PropertyValidator.isValid((Object)jiraDependency.getTargetTFSItem())) continue;
            LOGGER.debug("Missing item Id against tfsId: {}", (Object)jiraDependency.getTargetTFSItem().getTfsId());
            missingItemIdsDependencies.put(jiraDependency.getTargetTFSItem().getTfsId(), dependencyMap);
            missingTFSURLsDependencies.put(jiraDependency.getTargetTFSItem().getUrl(), dependencyMap);
            String dependencyId = dependencyMap.get("dependencyId").toString();
            TfsItemKey tfsItemKey = new TfsItemKey(dependencyId, jiraDependency.getTargetTFSItem().getTfsId());
            itemDependenciesMap.put(jiraDependency.getTargetTFSItem().getTfsId(), dependencyMap);
            missingItemsMap.put(tfsItemKey, dependencyMap);
        }
        if (!missingItemIdsDependencies.isEmpty()) {
            Set missingTfsUrls = missingTFSURLsDependencies.keySet();
            Set missingTfsKeys = missingItemIdsDependencies.keySet();
            BasicDBObject where = new BasicDBObject();
            where.append("tfsId", (Object)new BasicDBObject("$in", missingTfsKeys));
            where.append("tenant", (Object)tenant);
            List pipe = this.buildItemAggregationPipeline(where);
            List allDependentItems = this.executeItemAggregation(pipe, teamContainerIds, sessionBoardIds);
            if (PropertyValidator.isValid((Collection)allDependentItems)) {
                List missingItems = allDependentItems.stream().filter(i -> PropertyValidator.isValid((Collection)i.getSessionBoards()) && !i.getSessionBoards().isEmpty() && missingTfsUrls.contains(i.getTfsURL())).collect(Collectors.toList());
                LOGGER.debug("Found : {} items whose item ids were missing but dependency was present", (Object)missingItems.size());
                HashSet<String> foundTfsKeys = new HashSet<String>();
                for (Item missingItem : missingItems) {
                    Map missingItemMap = (Map)missingItemIdsDependencies.get(missingItem.getTfsId());
                    if (PropertyValidator.isValid((Object)missingItemMap)) {
                        if (itemDependenciesMap.containsKey(missingItem.getId())) {
                            boolean isDepDep;
                            Map fetchedDependencyMap = (Map)itemDependenciesMap.get(missingItem.getId());
                            String fetchedType = String.valueOf(fetchedDependencyMap.get("type"));
                            String depType = String.valueOf(missingItemMap.get("type"));
                            boolean isFetchedRelated = "Related".equalsIgnoreCase(fetchedType);
                            boolean isFetchedDep = !isFetchedRelated;
                            boolean isDepRelated = "Related".equalsIgnoreCase(depType);
                            boolean bl = isDepDep = !isDepRelated;
                            if ((isFetchedRelated && isDepDep || isDepRelated && isFetchedDep) && PropertyValidator.isValid((Object)missingItem.getId())) {
                                dependencyItems.add(missingItem.getId());
                            }
                        } else {
                            itemDependenciesMap.put(missingItem.getId(), missingItemMap);
                        }
                        dependencyItems.add(missingItem.getId());
                    }
                    foundTfsKeys.add(missingItem.getTfsId());
                }
                for (String missingTfsKey : missingTfsKeys) {
                    if (foundTfsKeys.contains(missingTfsKey)) continue;
                    itemDependenciesMap.put(missingTfsKey, missingItemIdsDependencies.get(missingTfsKey));
                }
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Processed ALM dependencies for item: {} in {} ms", (Object)item.getTfsId(), (Object)(endTime - startTime));
    }

    private Map<String, Object> buildAlmDependencyMap(ItemJiraDependency jiraDependency, Item item, SessionBoard sessionBoard, Set<String> linkedTfsKeys, Set<String> teamContainerIds, Set<String> containerIds, Map<String, Object> boardWithLinkTypesMap) throws Exception {
        String tfsLinkType;
        Map attribute;
        AlmAccount almAccount;
        TFSAlmConfigurations tfsAlmConfigurations;
        Session session;
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
        TFSIssue targetTfsItem = jiraDependency.getTargetTFSItem();
        if (PropertyValidator.isValid((Object)jiraDependency.getResponsible())) {
            User responsible = jiraDependency.getResponsible();
            LOGGER.debug("Found responsible user: {} against jiraDependency :{} ", (Object)responsible.getUserName(), (Object)jiraDependency.getId());
            dependencyMap.put("responsibleUserId", responsible.getId());
            dependencyMap.put("responsibleUserName", responsible.getUserName());
            dependencyMap.put("responsibleFullName", responsible.getFullName());
            dependencyMap.put("responsibleImage", responsible.getPicturePath());
        }
        if (PropertyValidator.isValid((Object)jiraDependency.getReporter())) {
            User reporter = jiraDependency.getReporter();
            LOGGER.debug("Found reporter user: {} against itemLink :{} ", (Object)reporter.getUserName(), (Object)jiraDependency.getId());
            dependencyMap.put("reporterUserId", reporter.getId());
            dependencyMap.put("reporterUserName", reporter.getUserName());
            dependencyMap.put("reporterFullName", reporter.getFullName());
            dependencyMap.put("reporterImage", reporter.getPicturePath());
        }
        if (PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Object)(session = sessionBoard.getSession()).getTfsAlmConfigurations()) && PropertyValidator.isValid((Object)(tfsAlmConfigurations = session.getTfsAlmConfigurations()).getAlmAccount()) && PropertyValidator.isValid((Object)(almAccount = tfsAlmConfigurations.getAlmAccount()).getId())) {
            dependencyMap.put("almAccount", almAccount);
        }
        dependencyMap.put("targetKey", targetTfsItem.getTfsId());
        dependencyMap.put("sourceKey", item.getTfsId());
        dependencyMap.put("linkType", LINK_TYPE_ALM);
        dependencyMap.put("linkOrigin", LINK_TYPE_ALM);
        dependencyMap.put("sourceItemId", jiraDependency.getSourceItemId());
        dependencyMap.put("targetItemId", jiraDependency.getTargetItemId());
        dependencyMap.put("sessionBoardId", jiraDependency.getSessionBoardId());
        dependencyMap.put("sourceBoardTitle", sessionBoard.getSession().getTitle());
        dependencyMap.put("description", jiraDependency.getDescription());
        dependencyMap.put("solutionId", jiraDependency.getSolutionId());
        dependencyMap.put("raisedOn", jiraDependency.getRaisedOn());
        if (PropertyValidator.isValid((Object)jiraDependency.getWfStatus())) {
            dependencyMap.put("dependencyStatus", jiraDependency.getWfStatus().getTitle());
            dependencyMap.put("dependencyStatusCategory", jiraDependency.getWfStatus().getCategory());
        }
        dependencyMap.put("richDescription", jiraDependency.getRichDescription());
        dependencyMap.put("dueDate", jiraDependency.getDueDate());
        dependencyMap.put("dependencyId", jiraDependency.getId());
        dependencyMap.put("linkType", LINK_TYPE_ALM);
        if ("reverse".equalsIgnoreCase(jiraDependency.getDirection())) {
            dependencyMap.put("reverseLink", true);
        }
        if (PropertyValidator.isValid((Object)(attribute = (Map)boardWithLinkTypesMap.get(tfsLinkType = jiraDependency.getTfsLinkType())))) {
            Map attributes;
            String name = (String)attribute.get("name");
            Map map = attributes = attribute.get("attributes") != null ? (Map)attribute.get("attributes") : null;
            if (PropertyValidator.isValid((Object)attributes)) {
                Boolean isForward = (Boolean)attributes.get("isForward");
                if (PropertyValidator.isValid((Object)isForward) && isForward.booleanValue()) {
                    dependencyMap.put("arrowDirection", "reverse");
                } else {
                    dependencyMap.put("arrowDirection", "forward");
                }
            }
            if (PropertyValidator.isValid((Object)name)) {
                dependencyMap.put("type", name);
            }
        }
        if (!PropertyValidator.isValid(dependencyMap.get("type"))) {
            dependencyMap.put("type", "");
            dependencyMap.put("arrowDirection", "forward");
        }
        if (PropertyValidator.isValid((Object)item.getSolutionBoard()) && !PropertyValidator.isValid((Object)jiraDependency.getSessionBoardId())) {
            dependencyMap.put("isSolutionOnly", true);
        } else if (PropertyValidator.isValid((Object)item.getSolutionBoard()) && PropertyValidator.isValid((Object)jiraDependency.getSolutionId())) {
            dependencyMap.put("isSolutionOnly", true);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Built alm dependency map for dependency: {} in {} ms", (Object)jiraDependency.getId(), (Object)(endTime - startTime));
        return dependencyMap;
    }

    private void enrichDependencyMap(Item dependentItem, Map<String, Object> dependencyMap, Map<String, Date> itemWithDatesMap, List<Item> items, Map<String, Container> containerMap, Map<String, Container> epicLinkedContainersMap, String tenant, Map<String, TeamContainer> teamContainerMap) throws Exception {
        Container targetContainer;
        Item item;
        String sourceItemId;
        String linkType = (String)dependencyMap.get("linkType");
        dependencyMap.put("targetDate", dependentItem.getEndDate());
        dependencyMap.put("targetSummary", dependentItem.getTitle());
        dependencyMap.put("targetKey", dependentItem.getTfsId());
        dependencyMap.put("targetIcon", dependentItem.getTfsItemTypeIcon());
        dependencyMap.put("targetTfsUrl", dependentItem.getTfsURL());
        if (PropertyValidator.isValid((Object)dependentItem.getJiraKey())) {
            Map issueType;
            dependencyMap.put("targetKey", dependentItem.getJiraKey());
            if (PropertyValidator.isValid((Object)dependentItem.getJiraURL())) {
                dependencyMap.put("targetTfsUrl", dependentItem.getJiraURL());
            } else if (PropertyValidator.isValid((Object)dependentItem.getJiraFieldByKey()) && PropertyValidator.isValid(dependentItem.getJiraFieldByKey().get("issuetype"))) {
                issueType = (Map)dependentItem.getJiraFieldByKey().get("issuetype");
                if (PropertyValidator.isValid(issueType.get("self"))) {
                    String issueTypeUrl = (String)issueType.get("self");
                    int index = issueTypeUrl.indexOf("/rest");
                    String jiraURL = index >= 0 ? issueTypeUrl.substring(0, index) : issueTypeUrl;
                    jiraURL = jiraURL + "/browse/" + dependentItem.getJiraKey();
                    dependencyMap.put("targetTfsUrl", jiraURL);
                }
                if (PropertyValidator.isValid(issueType.get("iconUrl"))) {
                    dependencyMap.put("targetIcon", issueType.get("iconUrl"));
                }
            }
            if (!PropertyValidator.isValid((Object)dependencyMap.get("targetIcon")) && PropertyValidator.isValid((Object)dependentItem.getJiraFieldByKey()) && PropertyValidator.isValid(dependentItem.getJiraFieldByKey().get("issuetype")) && PropertyValidator.isValid((issueType = (Map)dependentItem.getJiraFieldByKey().get("issuetype")).get("iconUrl"))) {
                dependencyMap.put("targetIcon", issueType.get("iconUrl"));
            }
        }
        if (PropertyValidator.isValid((Object)dependentItem.getStatus())) {
            dependencyMap.put("targetStatus", dependentItem.getStatus().getTitle());
            dependencyMap.put("targetStatusCategory", dependentItem.getStatus().getCategory());
        }
        if (LINK_TYPE_KENDIS.equalsIgnoreCase(linkType)) {
            this.enrichKendisDependency(dependentItem, dependencyMap, itemWithDatesMap, containerMap, teamContainerMap);
        } else if (LINK_TYPE_ALM.equalsIgnoreCase(linkType)) {
            this.enrichAlmDependency(dependentItem, dependencyMap, itemWithDatesMap, containerMap, teamContainerMap);
        }
        dependencyMap.remove("almAccount");
        if (PropertyValidator.isValid((Object)dependencyMap.get("sourceItemId")) && PropertyValidator.isValid((Object)dependencyMap.get("sourceTeamContainerId"))) {
            String teamContainerId;
            sourceItemId = (String)dependencyMap.get("sourceItemId");
            if (PropertyValidator.isValid((Object)sourceItemId) && PropertyValidator.isValid((Object)(item = (Item)items.stream().filter(i -> sourceItemId.equals(i.getId())).findFirst().orElse(null))) && PropertyValidator.isValid((Object)(teamContainerId = (String)dependencyMap.get("sourceTeamContainerId")))) {
                TeamContainer teamContainer = teamContainerMap.get(teamContainerId);
                if (PropertyValidator.isValid((Object)teamContainer)) {
                    if (PropertyValidator.isValid((Object)teamContainer.getTeam())) {
                        dependencyMap.put("sourceTeam", teamContainer.getTeam().getLabel());
                        dependencyMap.put("sourceTeamColor", teamContainer.getTeam().getColor());
                    }
                    if (PropertyValidator.isValid((Object)teamContainer.getContainer())) {
                        dependencyMap.put("sourceContainerSequence", teamContainer.getContainer().getSequence());
                        dependencyMap.put("sourceContainerId", teamContainer.getContainer().getId());
                        dependencyMap.put("sourceIteration", teamContainer.getContainer().getLabel());
                        dependencyMap.put("sourceEndDate", teamContainer.getContainer().getEndDate());
                    }
                } else {
                    LOGGER.debug("Could not find teamContainer for item: {}", (Object)item.getId());
                }
            }
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceContainerId")) && containerMap.containsKey(dependencyMap.get("sourceContainerId").toString())) {
            Container container = containerMap.get(dependencyMap.get("sourceContainerId").toString());
            if (PropertyValidator.isValid((Object)container)) {
                dependencyMap.put("sourceIteration", container.getLabel());
                dependencyMap.put("sourceContainerSequence", container.getSequence());
                dependencyMap.put("sourceEndDate", container.getEndDate());
            }
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceKey")) && epicLinkedContainersMap.containsKey(dependencyMap.get("sourceKey").toString())) {
            Container sourceContainer = epicLinkedContainersMap.get(dependencyMap.get("sourceKey").toString());
            if (PropertyValidator.isValid((Object)sourceContainer)) {
                dependencyMap.put("sourceIteration", sourceContainer.getLabel());
                dependencyMap.put("sourceContainerSequence", sourceContainer.getSequence());
                dependencyMap.put("sourceEndDate", sourceContainer.getEndDate());
            }
        } else {
            LOGGER.debug("Source item ID or team container ID not found in dependency map for dependent item: {}", (Object)dependentItem.getId());
            if (PropertyValidator.isValid((Object)dependencyMap.get("sourceItemId"))) {
                Container container;
                sourceItemId = (String)dependencyMap.get("sourceItemId");
                item = items.stream().filter(i -> sourceItemId.equals(i.getId())).findFirst().orElse(null);
                if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getTeamContainers()) && !item.getTeamContainers().isEmpty()) {
                    List fetchedTeamContainers = item.getTeamContainers().stream().filter(Objects::nonNull).map(tc -> (TeamContainer)teamContainerMap.get(tc.getId())).filter(Objects::nonNull).collect(Collectors.toList());
                    Optional<TeamContainer> optionalTeamContainer = fetchedTeamContainers.stream().filter(Objects::nonNull).max(Comparator.comparing(tc -> tc.getContainer() != null ? tc.getContainer().getSequence() : null, Comparator.nullsLast(Comparator.naturalOrder())));
                    if (optionalTeamContainer.isPresent()) {
                        TeamContainer fetchedTeamContainer = optionalTeamContainer.get();
                        if (PropertyValidator.isValid((Object)fetchedTeamContainer)) {
                            if (PropertyValidator.isValid((Object)fetchedTeamContainer.getTeam())) {
                                dependencyMap.put("sourceTeam", fetchedTeamContainer.getTeam().getLabel());
                                dependencyMap.put("sourceTeamColor", fetchedTeamContainer.getTeam().getColor());
                            }
                            if (PropertyValidator.isValid((Object)fetchedTeamContainer.getContainer())) {
                                dependencyMap.put("sourceContainerSequence", fetchedTeamContainer.getContainer().getSequence());
                                dependencyMap.put("sourceContainerId", fetchedTeamContainer.getContainer().getId());
                                dependencyMap.put("sourceIteration", fetchedTeamContainer.getContainer().getLabel());
                                dependencyMap.put("sourceEndDate", fetchedTeamContainer.getContainer().getEndDate());
                            }
                        }
                    } else {
                        LOGGER.debug("Could not find team container for dependent item: {}", (Object)dependentItem.getId());
                    }
                } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceContainerId")) && PropertyValidator.isValid((Object)(container = containerMap.get(dependencyMap.get("sourceContainerId").toString())))) {
                    dependencyMap.put("sourceIteration", container.getLabel());
                    dependencyMap.put("sourceContainerSequence", container.getSequence());
                    dependencyMap.put("sourceEndDate", container.getEndDate());
                }
            }
        }
        if (PropertyValidator.isValid((Object)dependencyMap.get("targetKey")) && !PropertyValidator.isValid((Object)dependencyMap.get("targetContainerSequence")) && PropertyValidator.isValid((Object)(targetContainer = epicLinkedContainersMap.get(dependencyMap.get("targetKey").toString())))) {
            dependencyMap.put("targetIteration", targetContainer.getLabel());
            dependencyMap.put("targetContainerSequence", targetContainer.getSequence());
            dependencyMap.put("targetEndDate", targetContainer.getEndDate());
        }
        this.determineDependencyType(dependentItem, dependencyMap, itemWithDatesMap, containerMap, tenant);
    }

    private String getJiraUrl(Item item) {
        String jiraURL = null;
        Map issueType = (Map)item.getJiraFieldByKey().get("issuetype");
        if (PropertyValidator.isValid(issueType.get("self"))) {
            String issueTypeUrl = (String)issueType.get("self");
            int index = issueTypeUrl.indexOf("/rest");
            jiraURL = index >= 0 ? issueTypeUrl.substring(0, index) : issueTypeUrl;
            jiraURL = jiraURL + "/browse/" + item.getJiraKey();
        }
        return jiraURL;
    }

    private void enrichKendisDependency(Item dependentItem, Map<String, Object> dependencyMap, Map<String, Date> itemWithDatesMap, Map<String, Container> containerMap, Map<String, TeamContainer> teamContainerMap) throws Exception {
        Container container;
        String teamContainerId = (String)dependencyMap.get("targetTeamContainerId");
        if (PropertyValidator.isValid((Object)teamContainerId)) {
            TeamContainer teamContainer = teamContainerMap.get(teamContainerId);
            if (PropertyValidator.isValid((Object)teamContainer)) {
                if (PropertyValidator.isValid((Object)teamContainer.getTeam())) {
                    dependencyMap.put("targetTeam", teamContainer.getTeam().getLabel());
                    dependencyMap.put("targetTeamColor", teamContainer.getTeam().getColor());
                }
                if (PropertyValidator.isValid((Object)teamContainer.getContainer())) {
                    dependencyMap.put("targetIteration", teamContainer.getContainer().getLabel());
                    dependencyMap.put("targetContainerSequence", teamContainer.getContainer().getSequence());
                    dependencyMap.put("targetContainerId", teamContainer.getContainer().getId());
                    dependencyMap.put("targetEndDate", teamContainer.getContainer().getEndDate());
                    itemWithDatesMap.put(dependentItem.getId(), teamContainer.getContainer().getEndDate());
                }
            }
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("targetContainerId")) && PropertyValidator.isValid((Object)(container = containerMap.get(dependencyMap.get("targetContainerId").toString())))) {
            dependencyMap.put("targetIteration", container.getLabel());
            dependencyMap.put("targetContainerSequence", container.getSequence());
            dependencyMap.put("targetEndDate", container.getEndDate());
        }
    }

    private void enrichAlmDependency(Item dependentItem, Map<String, Object> dependencyMap, Map<String, Date> itemWithDatesMap, Map<String, Container> containerMap, Map<String, TeamContainer> teamContainerMap) throws Exception {
        if (PropertyValidator.isValid((Object)dependentItem) && PropertyValidator.isValid((Collection)dependentItem.getTeamContainers())) {
            String teamContainerId = (String)dependencyMap.get("targetTeamContainerId");
            if (PropertyValidator.isValid((Object)teamContainerId)) {
                TeamContainer teamContainer;
                TeamContainer teamContainer2 = teamContainer = PropertyValidator.isValid(teamContainerMap) ? teamContainerMap.get(teamContainerId) : null;
                if (!PropertyValidator.isValid((Object)teamContainer) && PropertyValidator.isValid((Collection)dependentItem.getTeamContainers())) {
                    teamContainer = dependentItem.getTeamContainers().stream().filter(tc -> teamContainerId.equals(tc.getId())).findFirst().orElse(null);
                }
                if (PropertyValidator.isValid((Object)teamContainer)) {
                    if (PropertyValidator.isValid((Object)teamContainer.getTeam())) {
                        dependencyMap.put("targetTeam", teamContainer.getTeam().getLabel());
                        dependencyMap.put("targetTeamColor", teamContainer.getTeam().getColor());
                    }
                    if (PropertyValidator.isValid((Object)teamContainer.getContainer())) {
                        dependencyMap.put("targetIteration", teamContainer.getContainer().getLabel());
                        dependencyMap.put("targetContainerId", teamContainer.getContainer().getId());
                        dependencyMap.put("targetContainerSequence", teamContainer.getContainer().getSequence());
                        dependencyMap.put("targetEndDate", teamContainer.getContainer().getEndDate());
                        itemWithDatesMap.put(dependentItem.getId(), teamContainer.getContainer().getEndDate());
                    }
                }
            } else {
                List<TeamContainer> source = new ArrayList();
                if (PropertyValidator.isValid(teamContainerMap)) {
                    for (TeamContainer tcRef : dependentItem.getTeamContainers()) {
                        TeamContainer full;
                        if (!PropertyValidator.isValid((Object)tcRef) || !PropertyValidator.isValid((Object)tcRef.getId()) || !PropertyValidator.isValid((Object)(full = teamContainerMap.get(tcRef.getId())))) continue;
                        source.add(full);
                    }
                }
                if (!PropertyValidator.isValid(source)) {
                    source = dependentItem.getTeamContainers();
                }
                Optional<Container> optionalContainer = source.stream().map(TeamContainer::getContainer).filter(Objects::nonNull).max(Comparator.comparing(Container::getSequence, Comparator.nullsLast(Comparator.naturalOrder())));
                Optional<Team> optionalTeam = source.stream().filter(Objects::nonNull).max(Comparator.comparing(tc -> tc != null && tc.getContainer() != null ? tc.getContainer().getSequence() : null, Comparator.nullsLast(Comparator.naturalOrder()))).map(TeamContainer::getTeam);
                if (optionalTeam.isPresent()) {
                    Team team = optionalTeam.get();
                    dependencyMap.put("targetTeam", team.getLabel());
                    dependencyMap.put("targetTeamColor", team.getColor());
                }
                if (optionalContainer.isPresent()) {
                    Container container = optionalContainer.get();
                    itemWithDatesMap.put(dependentItem.getId(), container.getEndDate());
                    dependencyMap.put("targetIteration", container.getLabel());
                    dependencyMap.put("targetContainerSequence", container.getSequence());
                    dependencyMap.put("targetEndDate", container.getEndDate());
                }
            }
        } else if (PropertyValidator.isValid((Object)dependentItem) && PropertyValidator.isValid((Object)dependencyMap.get("targetContainerId")) && containerMap.containsKey(dependencyMap.get("targetContainerId").toString())) {
            Container container = containerMap.get(dependencyMap.get("targetContainerId").toString());
            dependencyMap.put("targetIteration", container.getLabel());
            dependencyMap.put("targetContainerSequence", container.getSequence());
            dependencyMap.put("targetEndDate", container.getEndDate());
        } else if (PropertyValidator.isValid((Object)dependentItem)) {
            LOGGER.debug("Could not find teamContainer for dependent item: {}", (Object)dependentItem.getId());
        }
    }

    private Container refreshContainerFromDatabase(String containerId, String tenant) {
        try {
            if (PropertyValidator.isValid((Object)containerId)) {
                Criteria containerCriteria = Criteria.where((String)"_id").is((Object)containerId).and("tenant").is((Object)tenant);
                Query containerQuery = Query.query((CriteriaDefinition)containerCriteria);
                containerQuery.fields().include("_id").include("label").include("sequence").include("endDate");
                return (Container)this.mongoTemplate.findOne(containerQuery, Container.class);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error refreshing container from database - ID: {}", (Object)containerId, (Object)e);
            return null;
        }
    }

    private Map<String, String> getSafeStatusInfo(Item item) {
        HashMap<String, String> statusInfo = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)item.getStatus()) && item.getStatus().getTitle() != null) {
            statusInfo.put("title", item.getStatus().getTitle());
            statusInfo.put("category", item.getStatus().getCategory());
        } else {
            LOGGER.debug("Status is not loaded for item: {}", (Object)item.getId());
            statusInfo.put("title", "Unknown");
            statusInfo.put("category", "Unknown");
        }
        return statusInfo;
    }

    private Map<String, Object> getSafeTeamContainerInfo(Item item, Map<String, TeamContainer> teamContainerMap) {
        if (!PropertyValidator.isValid((Collection)item.getTeamContainers()) || item.getTeamContainers().isEmpty()) {
            return null;
        }
        TeamContainer firstTeamContainer = (TeamContainer)item.getTeamContainers().get(0);
        if (firstTeamContainer.getTeam() == null || firstTeamContainer.getContainer() == null) {
            if (!PropertyValidator.isValid(teamContainerMap)) {
                LOGGER.debug("TeamContainers are not fully loaded and teamContainerMap is unavailable for item: {}", (Object)item.getId());
                return null;
            }
            ArrayList<TeamContainer> resolved = new ArrayList<TeamContainer>();
            for (TeamContainer tcRef : item.getTeamContainers()) {
                TeamContainer full;
                if (!PropertyValidator.isValid((Object)tcRef) || !PropertyValidator.isValid((Object)tcRef.getId()) || !PropertyValidator.isValid((Object)(full = teamContainerMap.get(tcRef.getId()))) || !PropertyValidator.isValid((Object)full.getTeam()) || !PropertyValidator.isValid((Object)full.getContainer())) continue;
                resolved.add(full);
            }
            if (!PropertyValidator.isValid(resolved)) {
                LOGGER.debug("Could not resolve TeamContainers from map for item: {}", (Object)item.getId());
                return null;
            }
            TeamContainer best = resolved.stream().filter(Objects::nonNull).max(Comparator.comparing(tc -> tc != null && tc.getContainer() != null ? tc.getContainer().getSequence() : null, Comparator.nullsLast(Comparator.naturalOrder()))).orElse(null);
            if (!PropertyValidator.isValid((Object)best)) {
                return null;
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            if (PropertyValidator.isValid((Object)best.getTeam())) {
                info.put("teamLabel", best.getTeam().getLabel());
                info.put("teamColor", best.getTeam().getColor());
            }
            if (PropertyValidator.isValid((Object)best.getContainer())) {
                info.put("containerLabel", best.getContainer().getLabel());
                info.put("containerSequence", best.getContainer().getSequence());
                info.put("containerEndDate", best.getContainer().getEndDate());
            }
            return info;
        }
        List fetchedTeamContainers = item.getTeamContainers().stream().filter(Objects::nonNull).map(tc -> (TeamContainer)teamContainerMap.get(tc.getId())).filter(Objects::nonNull).collect(Collectors.toList());
        Optional<Team> optionalTeam = fetchedTeamContainers.stream().filter(Objects::nonNull).max(Comparator.comparing(tc -> tc.getContainer() != null ? tc.getContainer().getSequence() : null, Comparator.nullsLast(Comparator.naturalOrder()))).map(TeamContainer::getTeam);
        Optional<Container> optionalContainer = fetchedTeamContainers.stream().filter(Objects::nonNull).max(Comparator.comparing(tc -> tc.getContainer() != null ? tc.getContainer().getSequence() : null, Comparator.nullsLast(Comparator.naturalOrder()))).map(TeamContainer::getContainer);
        HashMap<String, Object> teamContainerInfo = new HashMap<String, Object>();
        if (optionalTeam.isPresent()) {
            Team team = optionalTeam.get();
            teamContainerInfo.put("teamLabel", team.getLabel());
            teamContainerInfo.put("teamColor", team.getColor());
        }
        if (optionalContainer.isPresent()) {
            Container container = optionalContainer.get();
            teamContainerInfo.put("containerLabel", container.getLabel());
            teamContainerInfo.put("containerSequence", container.getSequence());
            teamContainerInfo.put("containerEndDate", container.getEndDate());
        }
        return teamContainerInfo;
    }

    private int compareContainerSequences(Double sequence1, Double sequence2) {
        if (sequence1 == null && sequence2 == null) {
            return 0;
        }
        if (sequence1 == null) {
            return -1;
        }
        if (sequence2 == null) {
            return 1;
        }
        try {
            BigDecimal seq1 = new BigDecimal(sequence1.toString());
            BigDecimal seq2 = new BigDecimal(sequence2.toString());
            return seq1.compareTo(seq2);
        }
        catch (Exception e) {
            LOGGER.error("Error comparing sequences: {} and {}", new Object[]{sequence1, sequence2, e});
            return Double.compare(sequence1, sequence2);
        }
    }

    private void determineDependencyType(Item dependentItem, Map<String, Object> dependencyMap, Map<String, Date> itemWithDatesMap, Map<String, Container> containerMap, String tenant) throws Exception {
        if (PropertyValidator.isValid((Object)dependencyMap.get("dependencyType"))) {
            return;
        }
        if (PropertyValidator.isValid((Object)dependencyMap.get("isArchive"))) {
            dependencyMap.put("dependencyType", "");
            return;
        }
        Date sourceItemDate = null;
        if (PropertyValidator.isValid((Object)dependencyMap.get("sourceEndDate"))) {
            sourceItemDate = (Date)dependencyMap.get("sourceEndDate");
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceKey")) && PropertyValidator.isValid((Object)itemWithDatesMap.get(dependencyMap.get("sourceKey").toString()))) {
            sourceItemDate = itemWithDatesMap.get(dependencyMap.get("sourceKey").toString());
        } else {
            String sourceItemId = (String)dependencyMap.get("sourceItemId");
            sourceItemDate = itemWithDatesMap.get(sourceItemId);
        }
        Date dependencyDate = null;
        if (PropertyValidator.isValid((Object)dependencyMap.get("targetEndDate"))) {
            dependencyDate = (Date)dependencyMap.get("targetEndDate");
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("targetKey")) && PropertyValidator.isValid((Object)itemWithDatesMap.get(dependencyMap.get("targetKey").toString()))) {
            dependencyDate = itemWithDatesMap.get(dependencyMap.get("targetKey").toString());
        } else if (PropertyValidator.isValid((Object)dependentItem.getTfsId()) && PropertyValidator.isValid(itemWithDatesMap) && PropertyValidator.isValid((Object)itemWithDatesMap.get(dependentItem.getTfsId()))) {
            dependencyDate = itemWithDatesMap.get(dependentItem.getTfsId());
        }
        String type = (String)dependencyMap.get("type");
        if (!PropertyValidator.isValid((Object)dependencyMap.get("arrowDirection"))) {
            LOGGER.debug("Arrow direction not found for dependency Id: {}", dependencyMap.get("dependencyId"));
            if (FORWARD_TYPES.contains(type.toLowerCase())) {
                dependencyMap.put("arrowDirection", "reverse");
            } else {
                dependencyMap.put("arrowDirection", "forward");
            }
        }
        boolean condition = "forward".equalsIgnoreCase(dependencyMap.get("arrowDirection").toString());
        if (PropertyValidator.isValid((Object)dependencyMap.get("shouldReverse"))) {
            dependencyMap.put("arrowDirection", "forward");
        }
        Date today = new Date();
        today.setTime(today.getTime() - today.getTime() % 86400000L);
        if (PropertyValidator.isValid((Object)sourceItemDate)) {
            sourceItemDate.setTime(sourceItemDate.getTime() - sourceItemDate.getTime() % 86400000L);
        }
        if (PropertyValidator.isValid((Object)dependencyDate)) {
            dependencyDate.setTime(dependencyDate.getTime() - dependencyDate.getTime() % 86400000L);
        }
        if (PropertyValidator.isValid((Object)dependencyMap.get("dependencyStatusCategory")) && "Done".equalsIgnoreCase(dependencyMap.get("dependencyStatusCategory").toString())) {
            dependencyMap.put("dependencyType", "");
            return;
        }
        if (PropertyValidator.isValid((Object)sourceItemDate) && PropertyValidator.isValid((Object)dependencyDate)) {
            if (sourceItemDate.equals(dependencyDate)) {
                if (sourceItemDate.before(today)) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
                }
            } else if (sourceItemDate.before(today)) {
                if (dependencyDate.after(today)) {
                    if (!condition) {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                    } else {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                    }
                } else if (sourceItemDate.before(dependencyDate)) {
                    if (!condition) {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                    } else {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                    }
                } else if (!condition) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                }
            } else if (dependencyDate.before(today)) {
                if (!condition) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                }
            } else if (dependencyDate.after(today)) {
                if (sourceItemDate.after(dependencyDate)) {
                    if (!condition) {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                    } else {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
                    }
                } else if (!condition) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                }
            } else if (dependencyDate.after(sourceItemDate)) {
                if (sourceItemDate.before(today)) {
                    if (condition) {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                    } else {
                        dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                    }
                } else if (condition) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                }
            } else if (condition) {
                dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
            } else {
                dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
            }
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceContainerSequence")) && PropertyValidator.isValid((Object)dependencyMap.get("targetContainerSequence"))) {
            int comparison;
            Container refreshedTargetContainer;
            Container refreshedSourceContainer;
            String sourceContainerId = (String)dependencyMap.get("sourceContainerId");
            String targetContainerId = (String)dependencyMap.get("targetContainerId");
            Double sourceContainerSequence = null;
            Double targetContainerSequence = null;
            if (PropertyValidator.isValid((Object)sourceContainerId) && (refreshedSourceContainer = this.refreshContainerFromDatabase(sourceContainerId, tenant)) != null) {
                sourceContainerSequence = refreshedSourceContainer.getSequence();
            }
            if (PropertyValidator.isValid((Object)targetContainerId) && (refreshedTargetContainer = this.refreshContainerFromDatabase(targetContainerId, tenant)) != null) {
                targetContainerSequence = refreshedTargetContainer.getSequence();
            }
            if (sourceContainerSequence == null) {
                sourceContainerSequence = (Double)dependencyMap.get("sourceContainerSequence");
            }
            if (targetContainerSequence == null) {
                targetContainerSequence = (Double)dependencyMap.get("targetContainerSequence");
            }
            if ((comparison = this.compareContainerSequences(targetContainerSequence, sourceContainerSequence)) < 0) {
                if (!condition) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
                }
            } else if (comparison > 0) {
                if (!condition) {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
                } else {
                    dependencyMap.put("dependencyType", DEPENDENCY_TYPE_REVERSE);
                }
            } else {
                dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
            }
        } else {
            dependencyMap.put("dependencyType", "");
        }
        if (PropertyValidator.isValid((Object)type) && ("Related".equalsIgnoreCase(type) || "Relates to".equalsIgnoreCase(type))) {
            dependencyMap.put("arrowDirection", "");
            dependencyMap.put("dependencyType", DEPENDENCY_TYPE_ALIGNED);
        }
        if (PropertyValidator.isValid((Object)dependencyMap.get("dueDate")) && PropertyValidator.isValid((Object)dependencyMap.get("dependencyType")) && !DEPENDENCY_TYPE_REVERSE.equalsIgnoreCase(dependencyMap.get("dependencyType").toString()) && today.after((Date)dependencyMap.get("dueDate"))) {
            dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
        }
    }

    private void fetchTfsMissingItems(Map<TfsItemKey, Object> dependencyItems) throws Exception {
        LOGGER.debug("Fetching {} missing items from TFS", (Object)dependencyItems.size());
        long startTime = System.currentTimeMillis();
        HashMap dependencyItemsMap = new HashMap();
        HashSet<String> almAccountIds = new HashSet<String>();
        try {
            HashMap<AlmAccount, Map> almGroupedItems = new HashMap<AlmAccount, Map>();
            for (Map.Entry<TfsItemKey, Object> entry : dependencyItems.entrySet()) {
                Map dependencyMap = (Map)entry.getValue();
                AlmAccount almAccount = (AlmAccount)dependencyMap.get("almAccount");
                if (!PropertyValidator.isValid((Object)almAccount)) continue;
                almAccountIds.add(almAccount.getId());
                Map almItemMap = almGroupedItems.getOrDefault(almAccount, new HashMap());
                String tfsKey = (String)dependencyMap.get("targetKey");
                if (PropertyValidator.isValid((Object)tfsKey)) {
                    LOGGER.debug("Adding item key: {} for almAccount: {}", (Object)tfsKey, (Object)almAccount.getName());
                    dependencyItemsMap.put(tfsKey, dependencyItemsMap);
                    almItemMap.put(tfsKey, dependencyMap);
                    almGroupedItems.put(almAccount, almItemMap);
                }
                dependencyMap.remove("almAccount");
            }
            if (PropertyValidator.isValid(almGroupedItems) && !almGroupedItems.isEmpty()) {
                List almAccounts = this.almAccountRepository.findByIdIn(new ArrayList(almAccountIds));
                HashMap<String, AlmAccount> almAccountsMap = new HashMap<String, AlmAccount>();
                if (PropertyValidator.isValid((Collection)almAccounts)) {
                    for (AlmAccount almAccount : almAccounts) {
                        if (!PropertyValidator.isValid((Object)almAccount)) continue;
                        almAccountsMap.put(almAccount.getId(), almAccount);
                    }
                }
                LOGGER.debug("Found {} ALM accounts with missing items", (Object)almGroupedItems.size());
                for (Map.Entry entry : almGroupedItems.entrySet()) {
                    AlmAccount almAccount = (AlmAccount)entry.getKey();
                    Map dependentItemsMap = (Map)entry.getValue();
                    AlmAccount fetchedAlmAccount = (AlmAccount)almAccountsMap.get(almAccount.getId());
                    if (!PropertyValidator.isValid((Object)fetchedAlmAccount) || !PropertyValidator.isValid((Object)dependentItemsMap)) continue;
                    Set itemKeys = dependentItemsMap.keySet();
                    String itemKeysJoined = String.join((CharSequence)",", itemKeys);
                    String tfsResponse = this.tfsUtils.getItems("1", itemKeysJoined, fetchedAlmAccount);
                    LOGGER.debug("Received response for almAccount: {} with items: {}", (Object)fetchedAlmAccount.getName(), (Object)itemKeysJoined);
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode root = mapper.readTree(tfsResponse);
                    JsonNode valueArray = root.get("value");
                    if (valueArray == null || !valueArray.isArray()) continue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        JsonNode item = valueArray.get(i);
                        String tfsKey = item.get("fields").get("System.Id").asText();
                        LOGGER.debug("Processing TFS item with key: {}", (Object)tfsKey);
                        String title = item.get("fields").get("System.Title").asText();
                        String state = item.get("fields").get("System.State").asText();
                        for (Object dependency : dependencyItems.values()) {
                            Map dependencyMap;
                            String targetKey;
                            if (!PropertyValidator.isValid((Object)dependency) || !PropertyValidator.isValid((Object)(targetKey = (String)(dependencyMap = (Map)dependency).get("targetKey"))) || !targetKey.equals(tfsKey)) continue;
                            dependencyMap.put("targetStatus", state);
                            dependencyMap.put("targetSummary", title);
                            dependencyMap.put("isArchive", true);
                            dependencyMap.put("dependencyType", "");
                            if ("Done".equalsIgnoreCase(state)) {
                                dependencyMap.put("targetStatusCategory", "Done");
                            } else {
                                dependencyMap.put("targetStatusCategory", "todo");
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("dueDate"))) continue;
                            Date today = new Date();
                            today.setTime(today.getTime() - today.getTime() % 86400000L);
                            if (PropertyValidator.isValid(dependencyMap.get("dependencyType")) && !DEPENDENCY_TYPE_REVERSE.equalsIgnoreCase(dependencyMap.get("dependencyType").toString()) && today.after((Date)dependencyMap.get("dueDate"))) {
                                dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                                continue;
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("dependencyStatusCategory")) || !"Done".equalsIgnoreCase(dependencyMap.get("dependencyStatusCategory").toString())) continue;
                            dependencyMap.put("dependencyType", "");
                        }
                    }
                }
            } else {
                LOGGER.debug("No ALM accounts with missing items found");
            }
        }
        catch (Exception ex) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)ex));
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Fetched missing items from TFS in {} ms", (Object)(endTime - startTime));
    }

    public Map<String, Object> fetchImages(Map<String, Object> requestBody) throws Exception {
        LOGGER.debug("Fetching images for Azure DevOps Extension");
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, Object> imageData : requestBody.entrySet()) {
                Map imageMap = (Map)imageData.getValue();
                String picturePath = (String)imageMap.get("picturePath");
                String imageUrl = S3Utils.getSecureUrl(null, (String)picturePath, (boolean)true);
                response.put(imageData.getKey(), imageUrl);
            }
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            response.put("error", "Error fetching images");
        }
        return response;
    }

    private boolean isItemInSolutionBoard(Item item, String solutionBoardId, Map<String, Set<String>> epicLinkedSolutionBoardsMap) {
        Set<String> linkedSolutionBoards;
        List additionalSolutionBoards;
        if (PropertyValidator.isValid((Object)item.getSolutionBoard()) && solutionBoardId.equalsIgnoreCase(item.getSolutionBoard().getId())) {
            return true;
        }
        if (PropertyValidator.isValid((Object)item.getFields()) && item.getFields().containsKey("allSolutionBoards") && PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item.getFields().get("allSolutionBoards")))) {
            for (SolutionBoard solutionBoard : additionalSolutionBoards) {
                if (!solutionBoardId.equalsIgnoreCase(solutionBoard.getId())) continue;
                return true;
            }
        }
        return PropertyValidator.isValid(epicLinkedSolutionBoardsMap) && epicLinkedSolutionBoardsMap.containsKey(item.getTfsId()) && PropertyValidator.isValid(linkedSolutionBoards = epicLinkedSolutionBoardsMap.get(item.getTfsId())) && linkedSolutionBoards.contains(solutionBoardId);
    }

    private Map<String, Object> mergeDependenciesForSamePiBoard(Map<String, Object> boardWithDependenciesMap) {
        LOGGER.debug("Merging dependencies for the same PI board for {} boards", (Object)(boardWithDependenciesMap != null ? boardWithDependenciesMap.size() : 0));
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> mergedMap = new HashMap<String, Object>();
        HashMap<String, List> piBoardGroups = new HashMap<String, List>();
        for (Map.Entry<String, Object> entry : boardWithDependenciesMap.entrySet()) {
            String compositeKey = entry.getKey();
            Map boardData = (Map)entry.getValue();
            String[] keyParts = compositeKey.split("::");
            if (keyParts.length == 2) {
                String sessionBoardId = keyParts[1];
                piBoardGroups.computeIfAbsent(sessionBoardId, k -> new ArrayList()).add(boardData);
                continue;
            }
            mergedMap.put(compositeKey, boardData);
        }
        for (Map.Entry<String, Object> entry : piBoardGroups.entrySet()) {
            String sessionBoardId = entry.getKey();
            List boardGroup = (List)entry.getValue();
            if (boardGroup.size() == 1) {
                Map boardData = (Map)boardGroup.get(0);
                String compositeKey = this.findCompositeKeyForBoardData(boardWithDependenciesMap, boardData);
                if (compositeKey == null) continue;
                mergedMap.put(compositeKey, boardData);
                continue;
            }
            Map mergedBoardData = this.mergeBoardDependencies(boardGroup);
            String firstCompositeKey = this.findCompositeKeyForBoardData(boardWithDependenciesMap, (Map)boardGroup.get(0));
            if (firstCompositeKey == null) continue;
            mergedMap.put(firstCompositeKey, mergedBoardData);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Merged dependencies for {} PI boards into {} entries in {} ms", new Object[]{piBoardGroups.size(), mergedMap.size(), endTime - startTime});
        return mergedMap;
    }

    private String findCompositeKeyForBoardData(Map<String, Object> boardWithDependenciesMap, Map<String, Object> boardData) {
        for (Map.Entry<String, Object> entry : boardWithDependenciesMap.entrySet()) {
            if (!entry.getValue().equals(boardData)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Map<String, Object> mergeBoardDependencies(List<Map<String, Object>> boardGroup) {
        HashMap<String, Object> mergedBoardData = new HashMap<String, Object>();
        HashMap<String, Map> mergedDependencies = new HashMap<String, Map>();
        Map<String, Object> firstBoard = boardGroup.get(0);
        mergedBoardData.put("boardTitle", firstBoard.get("boardTitle"));
        mergedBoardData.put("boardSessionId", firstBoard.get("boardSessionId"));
        mergedBoardData.put("key", firstBoard.get("key"));
        mergedBoardData.put("sourceSummary", firstBoard.get("sourceSummary"));
        mergedBoardData.put("targetDate", firstBoard.get("targetDate"));
        mergedBoardData.put("sourceIcon", firstBoard.get("sourceIcon"));
        mergedBoardData.put("sourceTfsUrl", firstBoard.get("sourceTfsUrl"));
        mergedBoardData.put("sourceStatus", firstBoard.get("sourceStatus"));
        mergedBoardData.put("sourceStatusCategory", firstBoard.get("sourceStatusCategory"));
        for (Map<String, Object> boardData : boardGroup) {
            Map dependencies = (Map)boardData.get("dependencies");
            if (!PropertyValidator.isValid((Object)dependencies)) continue;
            for (Map.Entry dependencyEntry : dependencies.entrySet()) {
                String dependencyKey = (String)dependencyEntry.getKey();
                Map dependencyMap = (Map)dependencyEntry.getValue();
                if (!mergedDependencies.containsKey(dependencyKey)) {
                    mergedDependencies.put(dependencyKey, dependencyMap);
                    continue;
                }
                Map existingDependency = (Map)mergedDependencies.get(dependencyKey);
                boolean shouldReplace = this.shouldReplaceDependency(existingDependency, dependencyMap);
                if (!shouldReplace) continue;
                mergedDependencies.put(dependencyKey, dependencyMap);
                LOGGER.debug("Replaced dependency {} with higher priority version", (Object)dependencyKey);
            }
        }
        mergedBoardData.put("dependencies", mergedDependencies);
        return mergedBoardData;
    }

    private boolean shouldReplaceDependency(Map<String, Object> existingDependency, Map<String, Object> newDependency) {
        boolean existingIsArchive = Boolean.TRUE.equals(existingDependency.get("isArchive"));
        boolean existingIsSolutionOnly = Boolean.TRUE.equals(existingDependency.get("isSolutionOnly"));
        boolean newIsArchive = Boolean.TRUE.equals(newDependency.get("isArchive"));
        boolean newIsSolutionOnly = Boolean.TRUE.equals(newDependency.get("isSolutionOnly"));
        if (newIsArchive && !existingIsArchive) {
            return true;
        }
        if (!newIsArchive && existingIsArchive) {
            return false;
        }
        if (!newIsSolutionOnly && existingIsSolutionOnly) {
            return true;
        }
        if (newIsSolutionOnly && !existingIsSolutionOnly) {
            return false;
        }
        return false;
    }

    private void enrichAcrossBoardDependency(Session session, Map<String, Object> dependencyMap, Item item, Map<String, Date> itemWithDatesMap, List<Item> items, Map<String, Container> containerMap, Map<String, Object> piBoardMap, Map<String, Object> acrossBoardDependencies, Iterator<Map.Entry<String, Object>> iterator, String itemId, Map.Entry<String, Object> itemEntry, Map<String, Container> epicLinkedContainersMap, Map<String, Session> sessionMap, String tenant, Map<String, TeamContainer> teamContainerMap) throws Exception {
        LOGGER.debug("Found across board dependency with Id: {}", dependencyMap.get("dependencyId"));
        dependencyMap.put("sourceKey", piBoardMap.get("key"));
        this.enrichDependencyMap(item, dependencyMap, itemWithDatesMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
        dependencyMap.put("sourceBoardTitle", piBoardMap.get("boardTitle"));
        if (PropertyValidator.isValid((Object)session)) {
            dependencyMap.put("targetBoardTitle", session.getTitle());
            dependencyMap.put("boardSessionId", session.getId());
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("targetSessionId"))) {
            String targetSessionId = dependencyMap.get("targetSessionId").toString();
            Criteria targetSessionCriteria = Criteria.where((String)"_id").is((Object)targetSessionId).and("tenant").is((Object)tenant);
            Query targetSessionQuery = Query.query((CriteriaDefinition)targetSessionCriteria);
            targetSessionQuery.fields().include("_id").include("title").include("activeSessionBoard").include("rowStatus");
            Session targetSession = (Session)this.mongoTemplate.findOne(targetSessionQuery, Session.class);
            if (PropertyValidator.isValid((Object)targetSession)) {
                dependencyMap.put("targetBoardTitle", targetSession.getTitle());
                sessionMap.put(targetSessionId, targetSession);
            }
            dependencyMap.put("boardSessionId", targetSession.getId());
        }
        dependencyMap.put("targetKey", item.getTfsId());
        dependencyMap.put("sourceStatus", piBoardMap.get("sourceStatus"));
        dependencyMap.put("sourceStatusCategory", piBoardMap.get("sourceStatusCategory"));
        Map statusInfo = this.getSafeStatusInfo(item);
        dependencyMap.put("targetStatus", statusInfo.get("title"));
        dependencyMap.put("targetStatusCategory", statusInfo.get("category"));
        dependencyMap.put("sourceTargetDate", piBoardMap.get("targetDate"));
        dependencyMap.put("targetTargetDate", item.getEndDate());
        dependencyMap.put("sourceSummary", piBoardMap.get("sourceSummary"));
        dependencyMap.put("targetSummary", item.getTitle());
        dependencyMap.put("sourceIcon", piBoardMap.get("sourceIcon"));
        dependencyMap.put("sourceTfsUrl", piBoardMap.get("sourceTfsUrl"));
        dependencyMap.put("targetTfsUrl", item.getTfsURL());
        Map teamContainerInfo = this.getSafeTeamContainerInfo(item, teamContainerMap);
        if (teamContainerInfo != null) {
            if (teamContainerInfo.containsKey("teamLabel")) {
                dependencyMap.put("targetTeam", teamContainerInfo.get("teamLabel"));
                dependencyMap.put("targetTeamColor", teamContainerInfo.get("teamColor"));
            }
            if (teamContainerInfo.containsKey("containerLabel")) {
                dependencyMap.put("targetIteration", teamContainerInfo.get("containerLabel"));
            }
        }
        if (PropertyValidator.isValid((Object)item.getJiraKey())) {
            Map issueType;
            dependencyMap.put("targetKey", item.getJiraKey());
            if (PropertyValidator.isValid((Object)item.getJiraURL())) {
                dependencyMap.put("targetTfsUrl", item.getJiraURL());
            } else if (PropertyValidator.isValid((Object)item.getJiraFieldByKey()) && PropertyValidator.isValid(item.getJiraFieldByKey().get("issuetype")) && PropertyValidator.isValid((issueType = (Map)item.getJiraFieldByKey().get("issuetype")).get("self"))) {
                String issueTypeUrl = (String)issueType.get("self");
                int index = issueTypeUrl.indexOf("/rest");
                String jiraURL = index >= 0 ? issueTypeUrl.substring(0, index) : issueTypeUrl;
                jiraURL = jiraURL + "/browse/" + item.getJiraKey();
                dependencyMap.put("targetTfsUrl", jiraURL);
            }
        }
        this.populateInAcrossBoardDependencyMap(dependencyMap, acrossBoardDependencies, item, itemEntry);
        iterator.remove();
    }

    private Map<String, Object> sortBoardWithDependenciesByCreationDate(Map<String, Object> boardWithDependenciesMap) {
        LOGGER.debug("Sorting board with dependencies by creation date for {} boards", (Object)(boardWithDependenciesMap != null ? boardWithDependenciesMap.size() : 0));
        long startTime = System.currentTimeMillis();
        if (boardWithDependenciesMap == null || boardWithDependenciesMap.isEmpty()) {
            LOGGER.debug("No boards to sort");
            return boardWithDependenciesMap;
        }
        ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(boardWithDependenciesMap.entrySet());
        entries.sort((entry1, entry2) -> {
            Map boardData1 = (Map)entry1.getValue();
            Map boardData2 = (Map)entry2.getValue();
            Date creationDate1 = this.getCreationDateFromBoardData(boardData1);
            Date creationDate2 = this.getCreationDateFromBoardData(boardData2);
            if (creationDate1 == null && creationDate2 == null) {
                return 0;
            }
            if (creationDate1 == null) {
                return 1;
            }
            if (creationDate2 == null) {
                return -1;
            }
            return creationDate2.compareTo(creationDate1);
        });
        LinkedHashMap<String, Object> sortedMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : entries) {
            sortedMap.put((String)entry.getKey(), entry.getValue());
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Sorted {} boards by creation date in descending order in {} ms", (Object)sortedMap.size(), (Object)(endTime - startTime));
        return sortedMap;
    }

    private Date getCreationDateFromBoardData(Map<String, Object> boardData) {
        if (boardData == null) {
            return null;
        }
        Object boardCreationDateObj = boardData.get("boardCreationDate");
        if (boardCreationDateObj instanceof Date) {
            return (Date)boardCreationDateObj;
        }
        Object boardCreatedOnObj = boardData.get("boardCreatedOn");
        if (boardCreatedOnObj instanceof Date) {
            return (Date)boardCreatedOnObj;
        }
        return null;
    }

    private Map<String, ItemLink> fetchItemLinksWithNestedObjects(Set<String> itemLinkIds, String tenant, Set<String> userIds) throws Exception {
        if (itemLinkIds.isEmpty()) {
            return new HashMap<String, ItemLink>();
        }
        LOGGER.debug("Fetching {} ItemLinks with nested objects", (Object)itemLinkIds.size());
        List objectIds = itemLinkIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
        ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
        BasicDBObject where = new BasicDBObject();
        where.append("_id", (Object)new BasicDBObject("$in", objectIds));
        if (PropertyValidator.isValid((Object)tenant)) {
            where.append("tenant", (Object)tenant);
        }
        pipe.add(new BasicDBObject("$match", (Object)where));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'status','localField':'wfStatus.$id','foreignField':'_id','as':'wfStatus'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$wfStatus','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'responsible.$id','foreignField':'_id','as':'responsible'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$responsible','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'reporter.$id','foreignField':'_id','as':'reporter'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$reporter','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'conversation','localField':'conversations.$id','foreignField':'_id','as':'conversations'}")));
        Map itemLinkMap = this.executeItemLinkAggregation(pipe, userIds);
        LOGGER.debug("Fetched {} ItemLinks with nested objects", (Object)itemLinkMap.size());
        return itemLinkMap;
    }

    private Map<String, ItemLink> executeItemLinkAggregation(List<DBObject> pipe, Set<String> userIds) {
        DBCollection collection = this.mongoTemplate.getCollection("itemLink");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor cursor = collection.aggregate(pipe, ao);
        HashMap<String, ItemLink> itemLinkMap = new HashMap<String, ItemLink>();
        while (cursor.hasNext()) {
            Object conversationsObj;
            Object reporterObj;
            Object responsibleObj;
            Object wfStatusObj;
            Object targetItemId;
            Object sourceItemId;
            Object targetFeatureId;
            Object sourceFeatureId;
            Object targetUserStoryId;
            Object sourceUserStoryId;
            Object targetSessionId;
            Object sourceSessionId;
            Object sessionBoardId;
            Object targetContainerId;
            Object sourceContainerId;
            Object targetTeamContainerId;
            Object sourceTeamContainerId;
            Object targetTfsId;
            Object sourceTfsId;
            Object solutionId;
            Object raisedOn;
            Object dueDate;
            Object richDescription;
            Object description;
            Object type;
            DBObject dbObject = (DBObject)cursor.next();
            ItemLink itemLink = new ItemLink();
            Object idObj = dbObject.get("_id");
            if (idObj != null) {
                itemLink.setId(String.valueOf(idObj));
            }
            if ((type = dbObject.get("type")) != null) {
                itemLink.setType(String.valueOf(type));
            }
            if ((description = dbObject.get("description")) != null) {
                itemLink.setDescription(String.valueOf(description));
            }
            if ((richDescription = dbObject.get("richDescription")) != null) {
                itemLink.setRichDescription(String.valueOf(richDescription));
            }
            if ((dueDate = dbObject.get("dueDate")) instanceof Date) {
                itemLink.setDueDate((Date)dueDate);
            }
            if ((raisedOn = dbObject.get("raisedOn")) instanceof Date) {
                itemLink.setRaisedOn((Date)raisedOn);
            }
            if ((solutionId = dbObject.get("solutionId")) != null) {
                itemLink.setSolutionId(String.valueOf(solutionId));
            }
            if ((sourceTfsId = dbObject.get("sourceTfsId")) != null) {
                itemLink.setSourceTfsId(String.valueOf(sourceTfsId));
            }
            if ((targetTfsId = dbObject.get("targetTfsId")) != null) {
                itemLink.setTargetTfsId(String.valueOf(targetTfsId));
            }
            if ((sourceTeamContainerId = dbObject.get("sourceTeamContainerId")) != null) {
                itemLink.setSourceTeamContainerId(String.valueOf(sourceTeamContainerId));
            }
            if ((targetTeamContainerId = dbObject.get("targetTeamContainerId")) != null) {
                itemLink.setTargetTeamContainerId(String.valueOf(targetTeamContainerId));
            }
            if ((sourceContainerId = dbObject.get("sourceContainerId")) != null) {
                itemLink.setSourceContainerId(String.valueOf(sourceContainerId));
            }
            if ((targetContainerId = dbObject.get("targetContainerId")) != null) {
                itemLink.setTargetContainerId(String.valueOf(targetContainerId));
            }
            if ((sessionBoardId = dbObject.get("sessionBoardId")) != null) {
                itemLink.setSessionBoardId(String.valueOf(sessionBoardId));
            }
            if ((sourceSessionId = dbObject.get("sourceSessionId")) != null) {
                itemLink.setSourceSessionId(String.valueOf(sourceSessionId));
            }
            if ((targetSessionId = dbObject.get("targetSessionId")) != null) {
                itemLink.setTargetSessionId(String.valueOf(targetSessionId));
            }
            if ((sourceUserStoryId = dbObject.get("sourceUserStoryId")) != null) {
                itemLink.setSourceUserStoryId(String.valueOf(sourceUserStoryId));
            }
            if ((targetUserStoryId = dbObject.get("targetUserStoryId")) != null) {
                itemLink.setTargetUserStoryId(String.valueOf(targetUserStoryId));
            }
            if ((sourceFeatureId = dbObject.get("sourceFeatureId")) != null) {
                itemLink.setSourceFeatureId(String.valueOf(sourceFeatureId));
            }
            if ((targetFeatureId = dbObject.get("targetFeatureId")) != null) {
                itemLink.setTargetFeatureId(String.valueOf(targetFeatureId));
            }
            if ((sourceItemId = dbObject.get("sourceItemId")) != null) {
                itemLink.setSourceItemId(String.valueOf(sourceItemId));
            }
            if ((targetItemId = dbObject.get("targetItemId")) != null) {
                itemLink.setTargetItemId(String.valueOf(targetItemId));
            }
            if ((wfStatusObj = dbObject.get("wfStatus")) instanceof DBObject) {
                Object wfStatusCategory;
                Object wfStatusTitle;
                DBObject wfStatusDbObj = (DBObject)wfStatusObj;
                Status wfStatus = new Status();
                Object wfStatusId = wfStatusDbObj.get("_id");
                if (wfStatusId != null) {
                    wfStatus.setId(String.valueOf(wfStatusId));
                }
                if ((wfStatusTitle = wfStatusDbObj.get("title")) != null) {
                    wfStatus.setTitle(String.valueOf(wfStatusTitle));
                }
                if ((wfStatusCategory = wfStatusDbObj.get("category")) != null) {
                    wfStatus.setCategory(String.valueOf(wfStatusCategory));
                }
                itemLink.setWfStatus(wfStatus);
            }
            if ((responsibleObj = dbObject.get("responsible")) instanceof DBObject) {
                Object picturePath;
                Object userCompanies;
                Object userType;
                Object fullName;
                Object userName;
                DBObject responsibleDbObj = (DBObject)responsibleObj;
                User responsible = new User();
                Object responsibleId = responsibleDbObj.get("_id");
                if (responsibleId != null) {
                    responsible.setId(String.valueOf(responsibleId));
                }
                if ((userName = responsibleDbObj.get("userName")) != null) {
                    responsible.setUserName(String.valueOf(userName));
                }
                if ((fullName = responsibleDbObj.get("fullName")) != null) {
                    responsible.setFullName(String.valueOf(fullName));
                }
                if ((userType = responsibleDbObj.get("userType")) != null) {
                    responsible.setUserType(User.UserType.valueOf((String)String.valueOf(responsibleDbObj.get("userType"))));
                }
                if ((userCompanies = responsibleDbObj.get("userCompanies")) != null) {
                    responsible.setUserCompanies((List)userCompanies);
                }
                if ((picturePath = responsibleDbObj.get("picturePath")) != null) {
                    responsible.setPicturePath(String.valueOf(picturePath));
                }
                itemLink.setResponsible(responsible);
            }
            if ((reporterObj = dbObject.get("reporter")) instanceof DBObject) {
                Object reporterPicturePath;
                Object reporterFullName;
                Object reporterUserName;
                DBObject reporterDbObj = (DBObject)reporterObj;
                User reporter = new User();
                Object reporterId = reporterDbObj.get("_id");
                if (reporterId != null) {
                    reporter.setId(String.valueOf(reporterId));
                }
                if ((reporterUserName = reporterDbObj.get("userName")) != null) {
                    reporter.setUserName(String.valueOf(reporterUserName));
                }
                if ((reporterFullName = reporterDbObj.get("fullName")) != null) {
                    reporter.setFullName(String.valueOf(reporterFullName));
                }
                if ((reporterPicturePath = reporterDbObj.get("picturePath")) != null) {
                    reporter.setPicturePath(String.valueOf(reporterPicturePath));
                }
                itemLink.setReporter(reporter);
            }
            if ((conversationsObj = dbObject.get("conversations")) instanceof List) {
                List conversationsList = (List)conversationsObj;
                ArrayList<Conversation> conversations = new ArrayList<Conversation>();
                for (Object convObj : conversationsList) {
                    Object userObj;
                    Object createdOn;
                    Object text;
                    if (!(convObj instanceof DBObject)) continue;
                    DBObject convDbObj = (DBObject)convObj;
                    Conversation conversation = new Conversation();
                    Object convId = convDbObj.get("_id");
                    if (convId != null) {
                        conversation.setId(String.valueOf(convId));
                    }
                    if ((text = convDbObj.get("text")) != null) {
                        conversation.setText(String.valueOf(text));
                    }
                    if ((createdOn = convDbObj.get("createdOn")) instanceof Date) {
                        conversation.setCreatedOn((Date)createdOn);
                    }
                    if ((userObj = convDbObj.get("user")) instanceof DBObject) {
                        DBObject userDbObj = (DBObject)userObj;
                        User user = new User();
                        Object userId = userDbObj.get("$id");
                        if (userId == null) {
                            userId = userDbObj.get("_id");
                        }
                        if (userId != null) {
                            String userIdStr = String.valueOf(userId);
                            user.setId(userIdStr);
                            userIds.add(userIdStr);
                        }
                        conversation.setUser(user);
                    }
                    conversations.add(conversation);
                }
                itemLink.setConversations(conversations);
            }
            itemLinkMap.put(itemLink.getId(), itemLink);
        }
        cursor.close();
        return itemLinkMap;
    }

    private Map<String, ItemJiraDependency> fetchItemJiraDependenciesWithNestedObjects(Set<String> itemJiraDependencyIds, String tenant, Set<String> userIds) throws Exception {
        if (itemJiraDependencyIds.isEmpty()) {
            return new HashMap<String, ItemJiraDependency>();
        }
        LOGGER.debug("Fetching {} ItemJiraDependencies with nested objects", (Object)itemJiraDependencyIds.size());
        List objectIds = itemJiraDependencyIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
        ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
        BasicDBObject where = new BasicDBObject();
        where.append("_id", (Object)new BasicDBObject("$in", objectIds));
        if (PropertyValidator.isValid((Object)tenant)) {
            where.append("tenant", (Object)tenant);
        }
        pipe.add(new BasicDBObject("$match", (Object)where));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'status','localField':'wfStatus.$id','foreignField':'_id','as':'wfStatus'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$wfStatus','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'responsible.$id','foreignField':'_id','as':'responsible'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$responsible','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'reporter.$id','foreignField':'_id','as':'reporter'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$reporter','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'conversation','localField':'conversations.$id','foreignField':'_id','as':'conversations'}")));
        Map itemJiraDependencyMap = this.executeItemJiraDependencyAggregation(pipe, userIds);
        LOGGER.debug("Fetched {} ItemJiraDependencies with nested objects", (Object)itemJiraDependencyMap.size());
        return itemJiraDependencyMap;
    }

    private Map<String, ItemJiraDependency> executeItemJiraDependencyAggregation(List<DBObject> pipe, Set<String> userIds) {
        DBCollection collection = this.mongoTemplate.getCollection("itemJiraDependency");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor cursor = collection.aggregate(pipe, ao);
        HashMap<String, ItemJiraDependency> itemJiraDependencyMap = new HashMap<String, ItemJiraDependency>();
        while (cursor.hasNext()) {
            Object conversationsObj;
            Object reporterObj;
            Object responsibleObj;
            Object wfStatusObj;
            Object targetJiraIssueObj;
            Object sourceTFSItemObj;
            Object targetTFSItemObj;
            Object linkType;
            Object tfsLinkType;
            Object sessionBoardId;
            Object targetItemId;
            Object sourceItemId;
            Object direction;
            Object solutionId;
            Object raisedOn;
            Object dueDate;
            Object richDescription;
            Object description;
            DBObject dbObject = (DBObject)cursor.next();
            ItemJiraDependency itemJiraDependency = new ItemJiraDependency();
            Object idObj = dbObject.get("_id");
            if (idObj != null) {
                itemJiraDependency.setId(String.valueOf(idObj));
            }
            if ((description = dbObject.get("description")) != null) {
                itemJiraDependency.setDescription(String.valueOf(description));
            }
            if ((richDescription = dbObject.get("richDescription")) != null) {
                itemJiraDependency.setRichDescription(String.valueOf(richDescription));
            }
            if ((dueDate = dbObject.get("dueDate")) instanceof Date) {
                itemJiraDependency.setDueDate((Date)dueDate);
            }
            if ((raisedOn = dbObject.get("raisedOn")) instanceof Date) {
                itemJiraDependency.setRaisedOn((Date)raisedOn);
            }
            if ((solutionId = dbObject.get("solutionId")) != null) {
                itemJiraDependency.setSolutionId(String.valueOf(solutionId));
            }
            if ((direction = dbObject.get("direction")) != null) {
                itemJiraDependency.setDirection(String.valueOf(direction));
            }
            if ((sourceItemId = dbObject.get("sourceItemId")) != null) {
                itemJiraDependency.setSourceItemId(String.valueOf(sourceItemId));
            }
            if ((targetItemId = dbObject.get("targetItemId")) != null) {
                itemJiraDependency.setTargetItemId(String.valueOf(targetItemId));
            }
            if ((sessionBoardId = dbObject.get("sessionBoardId")) != null) {
                itemJiraDependency.setSessionBoardId(String.valueOf(sessionBoardId));
            }
            if ((tfsLinkType = dbObject.get("tfsLinkType")) != null) {
                itemJiraDependency.setTfsLinkType(String.valueOf(tfsLinkType));
            }
            if ((linkType = dbObject.get("linkType")) != null) {
                BasicDBObject linkTypeObj = (BasicDBObject)linkType;
                JiraIssueLinkType jiraIssueLinkType = new JiraIssueLinkType();
                jiraIssueLinkType.setName(linkTypeObj.getString("name"));
                jiraIssueLinkType.setInward(linkTypeObj.getString("inward"));
                jiraIssueLinkType.setOutward(linkTypeObj.getString("outward"));
                jiraIssueLinkType.setJiraId(linkTypeObj.getString("jiraId"));
                itemJiraDependency.setLinkType(jiraIssueLinkType);
            }
            if ((targetTFSItemObj = dbObject.get("targetTFSItem")) instanceof DBObject) {
                Object apiURL;
                Object url;
                Object tfsState;
                Object tfsTitle;
                DBObject targetTFSItemDbObj = (DBObject)targetTFSItemObj;
                TFSIssue targetTFSItem = new TFSIssue();
                Object tfsId = targetTFSItemDbObj.get("tfsId");
                if (tfsId != null) {
                    targetTFSItem.setTfsId(String.valueOf(tfsId));
                }
                if ((tfsTitle = targetTFSItemDbObj.get("title")) != null) {
                    targetTFSItem.setTitle(String.valueOf(tfsTitle));
                }
                if ((tfsState = targetTFSItemDbObj.get("state")) != null) {
                    targetTFSItem.setStatus(String.valueOf(tfsState));
                }
                if ((url = targetTFSItemDbObj.get("url")) != null) {
                    targetTFSItem.setUrl(String.valueOf(url));
                }
                if ((apiURL = targetTFSItemDbObj.get("apiURL")) != null) {
                    targetTFSItem.setApiURL(String.valueOf(apiURL));
                }
                itemJiraDependency.setTargetTFSItem(targetTFSItem);
            }
            if ((sourceTFSItemObj = dbObject.get("sourceTFSItem")) instanceof DBObject) {
                Object apiURL;
                Object url;
                Object tfsState;
                Object tfsTitle;
                DBObject sourceTFSItemDbObj = (DBObject)sourceTFSItemObj;
                TFSIssue sourceTFSItem = new TFSIssue();
                Object tfsId = sourceTFSItemDbObj.get("tfsId");
                if (tfsId != null) {
                    sourceTFSItem.setTfsId(String.valueOf(tfsId));
                }
                if ((tfsTitle = sourceTFSItemDbObj.get("title")) != null) {
                    sourceTFSItem.setTitle(String.valueOf(tfsTitle));
                }
                if ((tfsState = sourceTFSItemDbObj.get("state")) != null) {
                    sourceTFSItem.setStatus(String.valueOf(tfsState));
                }
                if ((url = sourceTFSItemDbObj.get("url")) != null) {
                    sourceTFSItem.setUrl(String.valueOf(url));
                }
                if ((apiURL = sourceTFSItemDbObj.get("apiURL")) != null) {
                    sourceTFSItem.setApiURL(String.valueOf(apiURL));
                }
                itemJiraDependency.setSourceTFSItem(sourceTFSItem);
            }
            if ((targetJiraIssueObj = dbObject.get("targetJiraIssue")) instanceof DBObject) {
                Object fields;
                Object self;
                Object key;
                DBObject targetJiraIssueDbObj = (DBObject)targetJiraIssueObj;
                JiraIssue targetJiraIssue = new JiraIssue();
                Object jiraId = targetJiraIssueDbObj.get("jiraId");
                if (jiraId != null) {
                    targetJiraIssue.setJiraId(String.valueOf(jiraId));
                }
                if ((key = targetJiraIssueDbObj.get("key")) != null) {
                    targetJiraIssue.setKey(String.valueOf(key));
                }
                if ((self = targetJiraIssueDbObj.get("self")) != null) {
                    targetJiraIssue.setSelf(String.valueOf(self));
                }
                if ((fields = targetJiraIssueDbObj.get("fields")) != null) {
                    BasicDBObject statusObj;
                    BasicDBObject fieldsObj = (BasicDBObject)fields;
                    JiraIssueFields jiraIssueFields = new JiraIssueFields();
                    jiraIssueFields.setSummary(fieldsObj.getString("summary"));
                    BasicDBObject issueTypeObj = (BasicDBObject)fieldsObj.get("issuetype");
                    if (issueTypeObj != null) {
                        JiraIssueType jiraIssueType = new JiraIssueType();
                        jiraIssueType.setSelf(issueTypeObj.getString("self"));
                        jiraIssueType.setIconUrl(issueTypeObj.getString("iconUrl"));
                        jiraIssueType.setName(issueTypeObj.getString("name"));
                        jiraIssueType.setDescription(issueTypeObj.getString("description"));
                        jiraIssueFields.setIssuetype(jiraIssueType);
                    }
                    if ((statusObj = (BasicDBObject)fieldsObj.get("status")) != null) {
                        JiraStatus jiraStatus = new JiraStatus();
                        jiraStatus.setName(statusObj.getString("name"));
                        BasicDBObject statusCategoryObj = (BasicDBObject)fieldsObj.get("statusCategory");
                        if (statusCategoryObj != null) {
                            JiraStatusCategory statusCategory = new JiraStatusCategory();
                            statusCategory.setKey(statusCategoryObj.getString("key"));
                            jiraStatus.setStatusCategory(statusCategory);
                        }
                        jiraIssueFields.setStatus(jiraStatus);
                    }
                    targetJiraIssue.setFields(jiraIssueFields);
                }
                itemJiraDependency.setTargetJiraIssue(targetJiraIssue);
            }
            if ((wfStatusObj = dbObject.get("wfStatus")) instanceof DBObject) {
                Object wfStatusCategory;
                Object wfStatusTitle;
                DBObject wfStatusDbObj = (DBObject)wfStatusObj;
                Status wfStatus = new Status();
                Object wfStatusId = wfStatusDbObj.get("_id");
                if (wfStatusId != null) {
                    wfStatus.setId(String.valueOf(wfStatusId));
                }
                if ((wfStatusTitle = wfStatusDbObj.get("title")) != null) {
                    wfStatus.setTitle(String.valueOf(wfStatusTitle));
                }
                if ((wfStatusCategory = wfStatusDbObj.get("category")) != null) {
                    wfStatus.setCategory(String.valueOf(wfStatusCategory));
                }
                itemJiraDependency.setWfStatus(wfStatus);
            }
            if ((responsibleObj = dbObject.get("responsible")) instanceof DBObject) {
                Object picturePath;
                Object fullName;
                Object userName;
                DBObject responsibleDbObj = (DBObject)responsibleObj;
                User responsible = new User();
                Object responsibleId = responsibleDbObj.get("_id");
                if (responsibleId != null) {
                    responsible.setId(String.valueOf(responsibleId));
                }
                if ((userName = responsibleDbObj.get("userName")) != null) {
                    responsible.setUserName(String.valueOf(userName));
                }
                if ((fullName = responsibleDbObj.get("fullName")) != null) {
                    responsible.setFullName(String.valueOf(fullName));
                }
                if ((picturePath = responsibleDbObj.get("picturePath")) != null) {
                    responsible.setPicturePath(String.valueOf(picturePath));
                }
                itemJiraDependency.setResponsible(responsible);
            }
            if ((reporterObj = dbObject.get("reporter")) instanceof DBObject) {
                Object reporterPicturePath;
                Object reporterFullName;
                Object reporterUserName;
                DBObject reporterDbObj = (DBObject)reporterObj;
                User reporter = new User();
                Object reporterId = reporterDbObj.get("_id");
                if (reporterId != null) {
                    reporter.setId(String.valueOf(reporterId));
                }
                if ((reporterUserName = reporterDbObj.get("userName")) != null) {
                    reporter.setUserName(String.valueOf(reporterUserName));
                }
                if ((reporterFullName = reporterDbObj.get("fullName")) != null) {
                    reporter.setFullName(String.valueOf(reporterFullName));
                }
                if ((reporterPicturePath = reporterDbObj.get("picturePath")) != null) {
                    reporter.setPicturePath(String.valueOf(reporterPicturePath));
                }
                itemJiraDependency.setReporter(reporter);
            }
            if ((conversationsObj = dbObject.get("conversations")) instanceof List) {
                List conversationsList = (List)conversationsObj;
                ArrayList<Conversation> conversations = new ArrayList<Conversation>();
                for (Object convObj : conversationsList) {
                    Object userObj;
                    Object createdOn;
                    Object text;
                    if (!(convObj instanceof DBObject)) continue;
                    DBObject convDbObj = (DBObject)convObj;
                    Conversation conversation = new Conversation();
                    Object convId = convDbObj.get("_id");
                    if (convId != null) {
                        conversation.setId(String.valueOf(convId));
                    }
                    if ((text = convDbObj.get("text")) != null) {
                        conversation.setText(String.valueOf(text));
                    }
                    if ((createdOn = convDbObj.get("createdOn")) instanceof Date) {
                        conversation.setCreatedOn((Date)createdOn);
                    }
                    if ((userObj = convDbObj.get("user")) instanceof DBObject) {
                        DBObject userDbObj = (DBObject)userObj;
                        User user = new User();
                        Object userId = userDbObj.get("$id");
                        if (userId == null) {
                            userId = userDbObj.get("_id");
                        }
                        if (userId != null) {
                            String userIdStr = String.valueOf(userId);
                            user.setId(userIdStr);
                            userIds.add(userIdStr);
                        }
                        conversation.setUser(user);
                    }
                    conversations.add(conversation);
                }
                itemJiraDependency.setConversations(conversations);
            }
            itemJiraDependencyMap.put(itemJiraDependency.getId(), itemJiraDependency);
        }
        cursor.close();
        return itemJiraDependencyMap;
    }

    private Map<String, User> fetchUsersByIds(Set<String> userIds, String tenant) throws Exception {
        if (userIds.isEmpty()) {
            return new HashMap<String, User>();
        }
        LOGGER.debug("Fetching {} users by IDs", (Object)userIds.size());
        List objectIds = userIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
        Criteria userCriteria = Criteria.where((String)"_id").in(objectIds).and("tenant").is((Object)tenant);
        Query userQuery = Query.query((CriteriaDefinition)userCriteria);
        userQuery.fields().include("_id").include("userName").include("fullName").include("picturePath");
        List users = this.mongoTemplate.find(userQuery, User.class);
        HashMap<String, User> userMap = new HashMap<String, User>();
        for (User user : users) {
            userMap.put(user.getId(), user);
        }
        LOGGER.debug("Fetched {} users", (Object)userMap.size());
        return userMap;
    }

    private Map<String, Conversation> fetchConversationsByIds(Set<String> conversationIds) throws Exception {
        LOGGER.debug("Fetching {} conversations by IDs", (Object)(conversationIds != null ? conversationIds.size() : 0));
        if (!PropertyValidator.isValid(conversationIds)) {
            return new HashMap<String, Conversation>();
        }
        List objectIds = conversationIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
        if (objectIds.isEmpty()) {
            return new HashMap<String, Conversation>();
        }
        ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
        BasicDBObject where = new BasicDBObject();
        where.append("_id", (Object)new BasicDBObject("$in", objectIds));
        pipe.add(new BasicDBObject("$match", (Object)where));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'user.$id','foreignField':'_id','as':'user'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$user','preserveNullAndEmptyArrays':true}}"));
        Map conversationMap = this.executeConversationAggregation(pipe);
        LOGGER.debug("Fetched {} conversations with user details", (Object)conversationMap.size());
        return conversationMap;
    }

    private Map<String, Conversation> executeConversationAggregation(List<DBObject> pipe) {
        DBCollection collection = this.mongoTemplate.getCollection("conversation");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        try (Cursor cursor = collection.aggregate(pipe, ao);){
            HashMap<String, Conversation> conversationMap = new HashMap<String, Conversation>();
            while (cursor.hasNext()) {
                Object userObj;
                Object createdOn;
                Object text;
                DBObject dbObject = (DBObject)cursor.next();
                Conversation conversation = new Conversation();
                Object idObj = dbObject.get("_id");
                if (idObj != null) {
                    conversation.setId(String.valueOf(idObj));
                }
                if ((text = dbObject.get("text")) != null) {
                    conversation.setText(String.valueOf(text));
                }
                if ((createdOn = dbObject.get("createdOn")) instanceof Date) {
                    conversation.setCreatedOn((Date)createdOn);
                }
                if ((userObj = dbObject.get("user")) instanceof DBObject) {
                    Object picturePath;
                    Object fullName;
                    Object userName;
                    DBObject userDbObj = (DBObject)userObj;
                    User user = new User();
                    Object userId = userDbObj.get("_id");
                    if (userId != null) {
                        user.setId(String.valueOf(userId));
                    }
                    if ((userName = userDbObj.get("userName")) != null) {
                        user.setUserName(String.valueOf(userName));
                    }
                    if ((fullName = userDbObj.get("fullName")) != null) {
                        user.setFullName(String.valueOf(fullName));
                    }
                    if ((picturePath = userDbObj.get("picturePath")) != null) {
                        user.setPicturePath(String.valueOf(picturePath));
                    }
                    conversation.setUser(user);
                }
                conversationMap.put(conversation.getId(), conversation);
            }
            cursor.close();
            HashMap<String, Conversation> hashMap = conversationMap;
            return hashMap;
        }
    }

    private void populateUserDetailsInConversations(Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, User> userMap) {
        User fullUser;
        LOGGER.debug("Populating user details in conversations for {} ItemLinks and {} ItemJiraDependencies", (Object)itemLinkMap.size(), (Object)itemJiraDependencyMap.size());
        for (ItemLink itemLink : itemLinkMap.values()) {
            if (!PropertyValidator.isValid((Collection)itemLink.getConversations())) continue;
            for (Conversation conversation : itemLink.getConversations()) {
                if (!PropertyValidator.isValid((Object)conversation.getUser()) || !PropertyValidator.isValid((Object)conversation.getUser().getId()) || !PropertyValidator.isValid((Object)(fullUser = userMap.get(conversation.getUser().getId())))) continue;
                conversation.getUser().setUserName(fullUser.getUserName());
                conversation.getUser().setFullName(fullUser.getFullName());
                conversation.getUser().setPicturePath(fullUser.getPicturePath());
            }
        }
        for (ItemJiraDependency itemJiraDependency : itemJiraDependencyMap.values()) {
            if (!PropertyValidator.isValid((Collection)itemJiraDependency.getConversations())) continue;
            for (Conversation conversation : itemJiraDependency.getConversations()) {
                if (!PropertyValidator.isValid((Object)conversation.getUser()) || !PropertyValidator.isValid((Object)conversation.getUser().getId()) || !PropertyValidator.isValid((Object)(fullUser = userMap.get(conversation.getUser().getId())))) continue;
                conversation.getUser().setUserName(fullUser.getUserName());
                conversation.getUser().setFullName(fullUser.getFullName());
                conversation.getUser().setPicturePath(fullUser.getPicturePath());
            }
        }
        LOGGER.debug("Completed populating user details in conversations");
    }

    private List<ItemLink> fetchTargetItemLinksWithAggregation(String itemId, String tenant) throws Exception {
        if (!PropertyValidator.isValid((Object)itemId)) {
            return new ArrayList<ItemLink>();
        }
        LOGGER.debug("Fetching target ItemLinks for item: {} using aggregation", (Object)itemId);
        ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
        BasicDBObject where = new BasicDBObject();
        where.append("$or", Arrays.asList(new BasicDBObject("targetFeatureId", (Object)itemId), new BasicDBObject("targetUserStoryId", (Object)itemId), new BasicDBObject("targetItemId", (Object)itemId)));
        if (PropertyValidator.isValid((Object)tenant)) {
            where.append("tenant", (Object)tenant);
        }
        pipe.add(new BasicDBObject("$match", (Object)where));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'status','localField':'wfStatus.$id','foreignField':'_id','as':'wfStatus'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$wfStatus','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'responsible.$id','foreignField':'_id','as':'responsible'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$responsible','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'user','localField':'reporter.$id','foreignField':'_id','as':'reporter'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$reporter','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'conversation','localField':'conversations.$id','foreignField':'_id','as':'conversations'}")));
        Map itemLinkMap = this.executeItemLinkAggregation(pipe, new HashSet());
        ArrayList<ItemLink> targetItemLinks = new ArrayList<ItemLink>(itemLinkMap.values());
        LOGGER.debug("Fetched {} target ItemLinks with nested objects for item: {}", (Object)targetItemLinks.size(), (Object)itemId);
        return targetItemLinks;
    }

    private Map<String, TeamContainer> fetchTeamContainersWithNestedObjects(Set<String> teamContainerIds, String tenant) throws Exception {
        if (teamContainerIds.isEmpty()) {
            return new HashMap<String, TeamContainer>();
        }
        LOGGER.debug("Fetching {} TeamContainers with nested objects", (Object)teamContainerIds.size());
        List objectIds = teamContainerIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
        ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
        BasicDBObject where = new BasicDBObject();
        where.append("_id", (Object)new BasicDBObject("$in", objectIds));
        if (PropertyValidator.isValid((Object)tenant)) {
            where.append("tenant", (Object)tenant);
        }
        pipe.add(new BasicDBObject("$match", (Object)where));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'team','localField':'team.$id','foreignField':'_id','as':'team'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$team','preserveNullAndEmptyArrays':true}}"));
        pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'container','localField':'container.$id','foreignField':'_id','as':'container'}")));
        pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$container','preserveNullAndEmptyArrays':true}}"));
        Map teamContainerMap = this.executeTeamContainerAggregation(pipe);
        LOGGER.debug("Fetched {} TeamContainers with nested objects", (Object)teamContainerMap.size());
        return teamContainerMap;
    }

    private Map<String, TeamContainer> executeTeamContainerAggregation(List<DBObject> pipe) {
        DBCollection collection = this.mongoTemplate.getCollection("teamContainer");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor cursor = collection.aggregate(pipe, ao);
        HashMap<String, TeamContainer> teamContainerMap = new HashMap<String, TeamContainer>();
        while (cursor.hasNext()) {
            Object containerObj;
            Object teamObj;
            DBObject dbObject = (DBObject)cursor.next();
            TeamContainer teamContainer = new TeamContainer();
            Object idObj = dbObject.get("_id");
            if (idObj != null) {
                teamContainer.setId(String.valueOf(idObj));
            }
            if ((teamObj = dbObject.get("team")) instanceof DBObject) {
                Object teamColor;
                Object teamLabel;
                DBObject teamDbObj = (DBObject)teamObj;
                Team team = new Team();
                Object teamId = teamDbObj.get("_id");
                if (teamId != null) {
                    team.setId(String.valueOf(teamId));
                }
                if ((teamLabel = teamDbObj.get("label")) != null) {
                    team.setLabel(String.valueOf(teamLabel));
                }
                if ((teamColor = teamDbObj.get("color")) != null) {
                    team.setColor(String.valueOf(teamColor));
                }
                teamContainer.setTeam(team);
            }
            if ((containerObj = dbObject.get("container")) instanceof DBObject) {
                Object containerSequence;
                Object containerLabel;
                DBObject containerDbObj = (DBObject)containerObj;
                Container container = new Container();
                Object containerId = containerDbObj.get("_id");
                if (containerId != null) {
                    container.setId(String.valueOf(containerId));
                }
                if ((containerLabel = containerDbObj.get("label")) != null) {
                    container.setLabel(String.valueOf(containerLabel));
                }
                if ((containerSequence = containerDbObj.get("sequence")) instanceof Double) {
                    container.setSequence((Double)containerSequence);
                } else if (containerSequence instanceof Integer) {
                    container.setSequence(Double.valueOf(((Integer)containerSequence).doubleValue()));
                }
                Object containerEndDate = containerDbObj.get("endDate");
                if (containerEndDate instanceof Date) {
                    container.setEndDate((Date)containerEndDate);
                }
                teamContainer.setContainer(container);
            }
            teamContainerMap.put(teamContainer.getId(), teamContainer);
        }
        cursor.close();
        return teamContainerMap;
    }

    private Map<String, Object> buildBoardLinkTypesMap(List<SessionBoard> sessionBoards, Map<String, SessionBoard> sessionBoardMap) throws Exception {
        HashMap<String, Object> boardWithLinkTypesMap = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        for (SessionBoard sessionBoard : sessionBoards) {
            String boardId = sessionBoard.getId();
            SessionBoard board = sessionBoardMap.get(boardId);
            if (PropertyValidator.isValid((Object)board)) {
                this.extractLinkTypes(board, mapper, boardWithLinkTypesMap);
                continue;
            }
            LOGGER.debug("Invalid session board: {}", (Object)boardId);
        }
        LOGGER.debug("Built link types map for {} session boards", (Object)boardWithLinkTypesMap.size());
        return boardWithLinkTypesMap;
    }

    private Map<String, Object> buildJiraBoardLinkTypesMap(List<SessionBoard> sessionBoards, Map<String, SessionBoard> sessionBoardMap) throws Exception {
        HashMap<String, Object> boardWithLinkTypesMap = new HashMap<String, Object>();
        ObjectMapper mapper = new ObjectMapper();
        for (SessionBoard sessionBoard : sessionBoards) {
            String boardId = sessionBoard.getId();
            SessionBoard board = sessionBoardMap.get(boardId);
            if (PropertyValidator.isValid((Object)board)) {
                this.extractJiraLinkTypes(board, mapper, boardWithLinkTypesMap);
                continue;
            }
            LOGGER.debug("Invalid session board: {}", (Object)boardId);
        }
        LOGGER.debug("Built link types map for {} session boards", (Object)boardWithLinkTypesMap.size());
        return boardWithLinkTypesMap;
    }

    private void extractLinkTypes(SessionBoard sessionBoard, ObjectMapper mapper, Map<String, Object> boardWithLinkTypesMap) throws Exception {
        if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount())) {
            AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
            this.processAlmAccountMeta(almAccount, boardWithLinkTypesMap, mapper);
        } else if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
            for (AlmConfigurations almConfigurations : sessionBoard.getSession().getAlmConfigurations()) {
                if (!PropertyValidator.isValid((Object)almConfigurations.getAlmAccount())) continue;
                AlmAccount almAccount = almConfigurations.getAlmAccount();
                this.processAlmAccountMeta(almAccount, boardWithLinkTypesMap, mapper);
            }
        }
    }

    private void processAlmAccountMeta(AlmAccount almAccount, Map<String, Object> boardWithLinkTypesMap, ObjectMapper mapper) throws Exception {
        block2: {
            JsonNode root;
            block3: {
                JiraAlmAccountMeta accountMeta;
                if (!PropertyValidator.isValid((Object)almAccount) || !PropertyValidator.isValid((Object)almAccount.getId()) || !PropertyValidator.isValid((Object)(accountMeta = this.jiraAlmAccountMetaRepository.findByAlmAccountId(almAccount.getId())))) break block2;
                String linkTypes = accountMeta.getIssueLinkTypes();
                root = mapper.readTree(linkTypes);
                if (!root.has("issueLinkTypes") || !root.get("issueLinkTypes").isArray()) break block3;
                for (JsonNode node : root.get("issueLinkTypes")) {
                    String id;
                    Map attrMap = (Map)mapper.convertValue((Object)node, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    if (!PropertyValidator.isValid((Object)attrMap) || !PropertyValidator.isValid((Object)(id = (String)attrMap.get("id")))) continue;
                    boardWithLinkTypesMap.put(id, attrMap);
                }
                break block2;
            }
            if (!root.has("value") || !root.get("value").isArray()) break block2;
            for (JsonNode node : root.get("value")) {
                String referenceName;
                Map attrMap = (Map)mapper.convertValue((Object)node, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (!PropertyValidator.isValid((Object)attrMap) || !PropertyValidator.isValid((Object)(referenceName = (String)attrMap.get("referenceName")))) continue;
                boardWithLinkTypesMap.put(referenceName, attrMap);
            }
        }
    }

    private void extractJiraLinkTypes(SessionBoard sessionBoard, ObjectMapper mapper, Map<String, Object> boardWithLinkTypesMap) throws Exception {
        if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
            for (AlmConfigurations almConfigurations : sessionBoard.getSession().getAlmConfigurations()) {
                if (!PropertyValidator.isValid((Object)almConfigurations.getAlmAccount())) continue;
                AlmAccount almAccount = almConfigurations.getAlmAccount();
                this.processAlmAccountMeta(almAccount, boardWithLinkTypesMap, mapper);
            }
        } else if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
            AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
            this.processAlmAccountMeta(almAccount, boardWithLinkTypesMap, mapper);
        }
    }

    public Map<String, Object> searchUsers(Map<String, Object> requestBody) throws Exception {
        Map response = this.piJourneyService.searchUsers(requestBody);
        List users = (List)response.get("users");
        if (PropertyValidator.isValid((Collection)users) && !users.isEmpty()) {
            for (User user : users) {
                if (!PropertyValidator.isValid((Object)user.getPicturePath())) continue;
                String imageUrl = S3Utils.getSecureUrl(null, (String)user.getPicturePath(), (boolean)true);
                user.setPicturePath(imageUrl);
            }
        }
        return response;
    }

    public ResponseEntity<Object> editADODependency(Map<String, Object> requestBody) throws Exception {
        Instant instant;
        String dependencyId = (String)requestBody.get("dependencyId");
        String itemId = (String)requestBody.get("itemId");
        String linkOrigin = (String)requestBody.get("linkOrigin");
        String summary = (String)requestBody.get("summary");
        String description = (String)requestBody.get("description");
        String wfStatusId = (String)requestBody.get("wfStatusId");
        String raisedOnStr = (String)requestBody.get("raisedOn");
        String dueDateStr = (String)requestBody.get("dueDate");
        String sessionBoardId = (String)requestBody.get("sessionBoardId");
        Date raisedOn = null;
        Date dueDate = null;
        boolean solutionBoard = false;
        if (PropertyValidator.isValid((Object)raisedOnStr)) {
            instant = Instant.parse(raisedOnStr);
            raisedOn = Date.from(instant);
        }
        if (PropertyValidator.isValid((Object)dueDateStr)) {
            instant = Instant.parse(dueDateStr);
            dueDate = Date.from(instant);
        }
        if (PropertyValidator.isValid((Object)requestBody.get("solutionBoard"))) {
            solutionBoard = (Boolean)requestBody.get("solutionBoard");
        }
        User responsibleUser = null;
        User reporterUser = null;
        if (PropertyValidator.isValid((Object)requestBody.get("responsibleUserId"))) {
            String responsibleUserId = (String)requestBody.get("responsibleUserId");
            responsibleUser = this.userRepository.findById(responsibleUserId);
        }
        if (PropertyValidator.isValid((Object)requestBody.get("reporterUserId"))) {
            String reporterUserId = (String)requestBody.get("reporterUserId");
            reporterUser = this.userRepository.findById(reporterUserId);
        }
        Item item = new Item();
        if (PropertyValidator.isValid((Object)itemId)) {
            item.setId(itemId);
        }
        if (PropertyValidator.isValid((Object)dependencyId) && PropertyValidator.isValid((Object)itemId) && PropertyValidator.isValid((Object)linkOrigin)) {
            ItemJiraDependency itemJiraDependency;
            List itemJiraDependencies;
            if (LINK_TYPE_KENDIS.equalsIgnoreCase(linkOrigin)) {
                ItemLink itemLink;
                Item fetchedItem = this.itemRepository.findById(itemId);
                Status wfStatus = this.statusRepository.findById(wfStatusId);
                List itemLinks = fetchedItem.getItemLinks();
                if (PropertyValidator.isValid((Object)fetchedItem) && PropertyValidator.isValid((Collection)fetchedItem.getItemLinks()) && PropertyValidator.isValid((Object)(itemLink = (ItemLink)itemLinks.stream().filter(link -> dependencyId.equals(link.getId())).findFirst().orElse(null)))) {
                    itemLinks.remove(itemLink);
                    itemLinks.add(0, itemLink);
                    itemLink.setDescription(summary);
                    itemLink.setRichDescription(description);
                    if (PropertyValidator.isValid((Object)wfStatus)) {
                        itemLink.setWfStatus(wfStatus);
                    }
                    if (PropertyValidator.isValid((Object)responsibleUser)) {
                        itemLink.setResponsible(responsibleUser);
                    }
                    if (PropertyValidator.isValid((Object)reporterUser)) {
                        itemLink.setReporter(reporterUser);
                    }
                    itemLink.setDueDate(dueDate);
                    itemLink.setRaisedOn(raisedOn);
                    HashMap<String, Object> updateMap = new HashMap<String, Object>();
                    ObjectMapper mapper = new ObjectMapper();
                    item.setItemLinks(itemLinks);
                    String itemJson = mapper.writeValueAsString((Object)item);
                    updateMap.put("item", itemJson);
                    updateMap.put("metaMap", "{}");
                    updateMap.put("syncId", "3443444");
                    updateMap.put("linkIds", Collections.singletonList(dependencyId));
                    String requestBodyJson = mapper.writeValueAsString(updateMap);
                    if (solutionBoard) {
                        LOGGER.debug("Dependency is solution board's.");
                        return new ResponseEntity((Object)this.solutionService.updateItemLink(sessionBoardId, itemId, new ArrayList(itemLinks), "{}"), HttpStatus.OK);
                    }
                    return new ResponseEntity((Object)this.piService.saveLinks(requestBodyJson), HttpStatus.OK);
                }
            } else if (LINK_TYPE_ALM.equalsIgnoreCase(linkOrigin) && PropertyValidator.isValid((Collection)(itemJiraDependencies = this.itemJiraDependencyRepository.findByIdIn(Collections.singletonList(dependencyId)))) && !itemJiraDependencies.isEmpty() && PropertyValidator.isValid((Object)(itemJiraDependency = (ItemJiraDependency)itemJiraDependencies.get(0)))) {
                itemJiraDependency.setDescription(summary);
                itemJiraDependency.setRichDescription(description);
                Status wfStatus = this.statusRepository.findById(wfStatusId);
                if (PropertyValidator.isValid((Object)wfStatus)) {
                    itemJiraDependency.setWfStatus(wfStatus);
                }
                if (PropertyValidator.isValid((Object)responsibleUser)) {
                    itemJiraDependency.setResponsible(responsibleUser);
                }
                if (PropertyValidator.isValid((Object)reporterUser)) {
                    itemJiraDependency.setReporter(reporterUser);
                }
                itemJiraDependency.setDueDate(dueDate);
                itemJiraDependency.setRaisedOn(raisedOn);
                return this.piService.saveTfsLink(itemJiraDependency);
            }
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    public List<Status> fetchStatusList(String sessionId) throws Exception {
        if (PropertyValidator.isValid((Object)sessionId)) {
            Session session = this.sessionRepository.findById(sessionId);
            if (PropertyValidator.isValid((Object)session) && PropertyValidator.isValid((Object)session.getDependencyWorkFlow())) {
                WorkFlow dependencyWorkFlow = session.getDependencyWorkFlow();
                return this.statusRepository.findByWorkFlow(dependencyWorkFlow);
            }
        } else {
            LOGGER.debug("Invalid session id: {}", (Object)sessionId);
        }
        return null;
    }

    public Map<String, Object> fetchComments(String dependencyId, String linkOrigin) throws Exception {
        List conversations = new ArrayList();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)dependencyId)) {
            if (LINK_TYPE_KENDIS.equalsIgnoreCase(linkOrigin)) {
                ItemLink itemLink = this.itemLinkRepository.findById(dependencyId);
                if (PropertyValidator.isValid((Object)itemLink)) {
                    conversations = itemLink.getConversations();
                }
            } else {
                ItemJiraDependency itemJiraDependency = this.itemJiraDependencyRepository.findById(dependencyId);
                if (PropertyValidator.isValid((Object)itemJiraDependency)) {
                    conversations = itemJiraDependency.getConversations();
                }
            }
            response.put("comments", conversations);
        }
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("apiUser") && null != UserContextDTO.getFromLocalThread() && null != UserContextDTO.getFromLocalThread().get("apiKeyUsername")) {
            String userName = (String)UserContextDTO.getFromLocalThread().get("apiKeyUsername");
            User user = this.userRepository.findByUserName(userName);
            response.put("user", user);
        }
        return response;
    }

    public ResponseEntity<Object> saveComments(String dependencyId, List<Conversation> comments) throws Exception {
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("apiUser") && null != UserContextDTO.getFromLocalThread() && null != UserContextDTO.getFromLocalThread().get("apiKeyUsername")) {
            String userName = (String)UserContextDTO.getFromLocalThread().get("apiKeyUsername");
            User user = this.userRepository.findByUserName(userName);
            if (PropertyValidator.isValid((Object)user)) {
                for (Conversation comment : comments) {
                    if (PropertyValidator.isValid((Object)comment.getId())) continue;
                    comment.setUser(user);
                    comment.setMine(true);
                    comment.setLast(true);
                    if (comments.size() != 1) continue;
                    comment.setFirst(true);
                }
            }
            return this.piService.saveConversationByItemLink(dependencyId, comments);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    private Map<String, Object> buildJiraBoardWithDependenciesMap(Map<BoardKey, Map<String, Object>> boardWithItemMap, Map<String, Date> itemWithDatesMap, Set<String> dependentItemIds, Set<String> containerIds, Map<JiraItemKey, Object> missingItems, String tenant, Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, Set<String> teamContainerIds, Map<String, Object> boardWithLinkTypesMap, Map<String, Object> almDependenciesMap, Set<String> sessionBoardIds, Map<String, Conversation> conversationMap) throws Exception {
        LOGGER.debug("Building board with dependencies map for {} board keys", (Object)boardWithItemMap.size());
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> boardWithDependenciesMap = new HashMap<String, Object>();
        for (Map.Entry<BoardKey, Map<String, Object>> entry : boardWithItemMap.entrySet()) {
            BoardKey boardKey = entry.getKey();
            SessionBoard sessionBoard = boardKey.getSessionBoard();
            Map<String, Object> itemMap = entry.getValue();
            Item item = (Item)itemMap.get("item");
            LOGGER.debug("Processing board key: {} for item: {}", (Object)boardKey.toString(), (Object)item.getTfsId());
            Map dependenciesMap = this.buildDependenciesForJiraItem(item, sessionBoard, itemWithDatesMap, dependentItemIds, containerIds, missingItems, tenant, itemLinkMap, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, teamContainerIds, boardWithLinkTypesMap, almDependenciesMap, sessionBoardIds, conversationMap);
            itemMap.put("dependencies", dependenciesMap);
            itemMap.remove("item");
            itemMap.put("boardTitle", sessionBoard.getSession().getTitle());
            itemMap.put("boardCreationDate", sessionBoard.getCreationDate());
            itemMap.put("boardCreatedOn", sessionBoard.getCreatedOn());
            boardWithDependenciesMap.put(boardKey.toString(), itemMap);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Built board with dependencies map for {} boards in {} ms", (Object)boardWithDependenciesMap.size(), (Object)(endTime - startTime));
        return boardWithDependenciesMap;
    }

    public Map<String, Object> fetchJiraDependencies(String companyPrefix, Map<String, Object> workItemData) throws Exception {
        Map dependencyMap;
        Map itemWithDependencies;
        List dependentItemIdsObj;
        ArrayList<SolutionBoard> solutionBoards;
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Starting fetchDependencies for company: {}, workItem: {}, jiraURL: {}", new Object[]{companyPrefix, workItemData.get("id"), workItemData.get("url")});
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, List> activeSessionBoardWithItems = new HashMap<String, List>();
        HashSet<String> solutionBoardsLinkedSessions = new HashSet<String>();
        HashSet sessionIds = new HashSet();
        HashSet<String> featureIds = new HashSet<String>();
        HashMap<String, Item> itemsWithIdMap = new HashMap<String, Item>();
        List sessions = new ArrayList();
        List<Object> activeSolutionLinkedBoardIds = new ArrayList();
        List epicFeatures = new ArrayList();
        HashMap<String, String> epicKeyWithSessionIdMap = new HashMap<String, String>();
        HashMap<String, String> solutionIdFeatureItemMap = new HashMap<String, String>();
        HashSet<String> featureLinkedSolutionBoardIds = new HashSet<String>();
        Set<Object> sessionBoardIds = new HashSet();
        HashMap<String, Set> solutionBoardWithPiBoard = new HashMap<String, Set>();
        HashMap solutionBoardWithPiBoardMap = new HashMap();
        HashMap<String, Iterator<Map.Entry<String, Object>>> solutionBoardWithDependenciesMap = new HashMap<String, Iterator<Map.Entry<String, Object>>>();
        HashMap<String, Session> sessionMap = new HashMap<String, Session>();
        Map itemLinkMap = new HashMap();
        Map itemJiraDependencyMap = new HashMap();
        Map teamContainerMap = new HashMap();
        HashMap<String, SessionBoard> sessionBoardMap = new HashMap<String, SessionBoard>();
        HashSet<String> itemLinkIds = new HashSet<String>();
        HashSet<String> itemJiraDependencyIds = new HashSet<String>();
        HashSet<String> teamContainerIds = new HashSet<String>();
        HashMap<String, Container> containerMap = new HashMap<String, Container>();
        HashSet<String> conversationIds = new HashSet<String>();
        LOGGER.debug("Step 1: Validating company and extracting Jira Key");
        long step1Start = System.currentTimeMillis();
        Company company = this.fetchAndValidateCompany(companyPrefix);
        String tenant = company.getTenant();
        String jiraKey = this.extractTfsId(workItemData);
        String jiraURLString = this.extractTfsUrl(workItemData);
        int index = jiraURLString.indexOf("/images");
        String jiraURL = index >= 0 ? jiraURLString.substring(0, index) : jiraURLString;
        long step1End = System.currentTimeMillis();
        LOGGER.debug("Step 1 completed in {} ms", (Object)(step1End - step1Start));
        if (!PropertyValidator.isValid((Object)jiraKey)) {
            LOGGER.warn("No Jira Key found");
            response.put("noItemFound", true);
            return response;
        }
        LOGGER.debug("Step 2: Fetching items for work item");
        long step2Start = System.currentTimeMillis();
        List items = this.fetchJiraItemsForWorkItem(jiraKey, tenant, teamContainerIds, sessionBoardIds, jiraURL);
        long step2End = System.currentTimeMillis();
        LOGGER.debug("Step 2 completed in {} ms, found {} items", (Object)(step2End - step2Start), (Object)items.size());
        if (items.isEmpty()) {
            LOGGER.warn("No items found for jiraKey ID: {} in tenant: {}", (Object)jiraKey, (Object)tenant);
            response.put("noItemFound", true);
            return response;
        }
        for (Item item2 : items) {
            itemsWithIdMap.put(item2.getId(), item2);
            featureIds.add(item2.getId());
        }
        LOGGER.debug("Step 3: Collecting session board IDs");
        long step3Start = System.currentTimeMillis();
        sessionBoardIds = this.collectSessionBoardIds(items);
        long step3End = System.currentTimeMillis();
        LOGGER.debug("Step 3 completed in {} ms, collected {} session board IDs", (Object)(step3End - step3Start), (Object)sessionBoardIds.size());
        LOGGER.debug("Step 4: Fetching active session boards");
        long step4Start = System.currentTimeMillis();
        List sessionBoards = new ArrayList();
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, true);
        long step4End = System.currentTimeMillis();
        LOGGER.debug("Step 4 completed in {} ms, found {} active session boards", (Object)(step4End - step4Start), (Object)sessionBoards.size());
        sessionBoards.stream().map(SessionBoard::getSession).filter(PropertyValidator::isValid).forEach(session -> {
            if (PropertyValidator.isValid((Object)session.getId())) {
                sessionIds.add(session.getId());
            }
        });
        Criteria epicCriteria = Criteria.where((String)"featureId").in(featureIds).and("tenant").is((Object)tenant);
        Query epicQuery = Query.query((CriteriaDefinition)epicCriteria);
        epicQuery.fields().include("_id").include("featureId").include("solutionBoardId").include("sessionId").include("epicKey").include("featureKey");
        List featureEpics = this.mongoTemplate.find(epicQuery, EpicFeature.class);
        if (PropertyValidator.isValid((Collection)featureEpics)) {
            for (EpicFeature epicFeature : featureEpics) {
                if (!PropertyValidator.isValid((Object)epicFeature.getSolutionBoardId()) || !sessionIds.contains(epicFeature.getSessionId())) continue;
                featureLinkedSolutionBoardIds.add(epicFeature.getSolutionBoardId());
                solutionIdFeatureItemMap.put(epicFeature.getSolutionBoardId(), epicFeature.getFeatureId());
            }
        }
        if (PropertyValidator.isValid(featureLinkedSolutionBoardIds)) {
            Criteria solutionCriteria = Criteria.where((String)"_id").in(featureLinkedSolutionBoardIds).and("tenant").is((Object)tenant);
            Query solutionQuery = Query.query((CriteriaDefinition)solutionCriteria);
            solutionQuery.fields().include("_id").include("title").include("piSessions");
            solutionBoards = this.mongoTemplate.find(solutionQuery, SolutionBoard.class);
            if (PropertyValidator.isValid((Collection)solutionBoards)) {
                String featureId;
                HashMap<String, List> featureToSolutionBoardsMap = new HashMap<String, List>();
                for (SolutionBoard solutionBoard : solutionBoards) {
                    if (!solutionIdFeatureItemMap.containsKey(solutionBoard.getId()) || !PropertyValidator.isValid((Object)(featureId = (String)solutionIdFeatureItemMap.get(solutionBoard.getId())))) continue;
                    featureToSolutionBoardsMap.computeIfAbsent(featureId, k -> new ArrayList()).add(solutionBoard);
                }
                for (Map.Entry entry : featureToSolutionBoardsMap.entrySet()) {
                    featureId = (String)entry.getKey();
                    List featureSolutionBoards = (List)entry.getValue();
                    Item featureItem = (Item)itemsWithIdMap.get(featureId);
                    if (!PropertyValidator.isValid((Object)featureItem) || !PropertyValidator.isValid((Collection)featureSolutionBoards)) continue;
                    featureItem.setSolutionBoard((SolutionBoard)featureSolutionBoards.get(0));
                    if (featureItem.getFields() == null) {
                        featureItem.setFields(new HashMap());
                    }
                    featureItem.getFields().put("allSolutionBoards", featureSolutionBoards);
                }
            }
        }
        for (Item item3 : items) {
            Object additionalSolutionBoards;
            SolutionBoard solutionBoard;
            Object sessionBoard222;
            if (PropertyValidator.isValid((Collection)item3.getSessionBoards())) {
                for (Object sessionBoard222 : item3.getSessionBoards()) {
                    if (!PropertyValidator.isValid((Object)sessionBoard222.getId())) continue;
                    activeSessionBoardWithItems.computeIfAbsent(sessionBoard222.getId(), k -> new ArrayList()).add(item3);
                }
            }
            if (PropertyValidator.isValid((Object)item3.getSolutionBoard()) && PropertyValidator.isValid((Collection)(solutionBoard = item3.getSolutionBoard()).getPiSessions())) {
                sessionBoard222 = solutionBoard.getPiSessions().iterator();
                while (sessionBoard222.hasNext()) {
                    String piSession = (String)sessionBoard222.next();
                    if (!PropertyValidator.isValid((Object)piSession)) continue;
                    solutionBoardsLinkedSessions.add(piSession);
                }
            }
            if (!PropertyValidator.isValid((Object)item3.getFields()) || !item3.getFields().containsKey("allSolutionBoards") || !PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item3.getFields().get("allSolutionBoards")))) continue;
            sessionBoard222 = additionalSolutionBoards.iterator();
            while (sessionBoard222.hasNext()) {
                SolutionBoard solutionBoard2 = (SolutionBoard)sessionBoard222.next();
                if (!PropertyValidator.isValid((Collection)solutionBoard2.getPiSessions())) continue;
                for (Object piSession : solutionBoard2.getPiSessions()) {
                    if (!PropertyValidator.isValid((Object)piSession)) continue;
                    solutionBoardsLinkedSessions.add((String)piSession);
                }
            }
        }
        if (!solutionBoardsLinkedSessions.isEmpty()) {
            Criteria sessionEpicCriteria = Criteria.where((String)"sessionId").in(solutionBoardsLinkedSessions).and("tenant").is((Object)tenant);
            Query sessionEpicQuery = Query.query((CriteriaDefinition)sessionEpicCriteria);
            sessionEpicQuery.fields().include("_id").include("epicKey").include("sessionId").include("featureId").include("solutionBoardId").include("featureKey");
            epicFeatures = this.mongoTemplate.find(sessionEpicQuery, EpicFeature.class);
            for (EpicFeature epicFeature : epicFeatures) {
                if (!PropertyValidator.isValid((Object)epicFeature.getEpicKey()) || !PropertyValidator.isValid((Object)epicFeature.getSessionId())) continue;
                String compositeKey = epicFeature.getEpicKey() + "::" + epicFeature.getSessionId();
                epicKeyWithSessionIdMap.put(compositeKey, epicFeature.getSessionId());
            }
            List solutionBoardLinkedSessionIds = solutionBoardsLinkedSessions.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(sessionId -> new ObjectId(sessionId)).collect(Collectors.toList());
            Criteria sessionCriteria = Criteria.where((String)"_id").in(solutionBoardLinkedSessionIds).and("tenant").is((Object)tenant);
            Query sessionQuery = Query.query((CriteriaDefinition)sessionCriteria);
            sessionQuery.fields().include("_id").include("activeSessionBoard").include("title").include("rowStatus");
            sessions = this.mongoTemplate.find(sessionQuery, Session.class);
            activeSolutionLinkedBoardIds = sessions.stream().map(Session::getActiveSessionBoard).distinct().collect(Collectors.toList());
            sessionBoardIds.addAll(activeSolutionLinkedBoardIds);
        }
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, true);
        sessionBoards.stream().map(SessionBoard::getSession).filter(PropertyValidator::isValid).forEach(session -> {
            if (PropertyValidator.isValid((Object)session.getId())) {
                sessionIds.add(session.getId());
                sessionMap.put(session.getId(), (Session)session);
            }
        });
        sessionBoards.stream().forEach(sessionBoard -> sessionBoardMap.put(sessionBoard.getId(), (SessionBoard)sessionBoard));
        Aggregation solutionAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"piSessions").in(sessionIds).and("tenant").is((Object)tenant).and("archive").is((Object)false)), Aggregation.project((String[])new String[0]).and("_id").as("_id").and("title").as("title").and("piSessions").as("piSessions")});
        List tempSolutionBoards = this.executeAggregationWithDiskUse(solutionAggregation, "solutionBoard", SolutionBoard.class);
        solutionBoards = new ArrayList<SolutionBoard>();
        if (PropertyValidator.isValid((Collection)tempSolutionBoards)) {
            for (Object item4 : items) {
                List list;
                SolutionBoard solutionBoard;
                if (PropertyValidator.isValid((Object)item4.getSolutionBoard()) && tempSolutionBoards.contains(solutionBoard = item4.getSolutionBoard())) {
                    solutionBoards.add(solutionBoard);
                }
                if (PropertyValidator.isValid((Object)item4.getFields()) && item4.getFields().containsKey("allSolutionBoards") && PropertyValidator.isValid((Collection)(list = (List)item4.getFields().get("allSolutionBoards")))) {
                    for (SolutionBoard solutionBoard3 : list) {
                        if (!tempSolutionBoards.contains(solutionBoard3)) continue;
                        solutionBoards.add(solutionBoard3);
                    }
                }
                if (!PropertyValidator.isValid((Collection)item4.getSessionBoards())) continue;
                for (SessionBoard sessionBoard2 : item4.getSessionBoards()) {
                    SessionBoard fetchedSessionBoard = (SessionBoard)sessionBoardMap.get(sessionBoard2.getId());
                    if (!PropertyValidator.isValid((Object)fetchedSessionBoard) || !PropertyValidator.isValid((Object)fetchedSessionBoard.getSession()) || !PropertyValidator.isValid((Object)fetchedSessionBoard.getSession().getId())) continue;
                    String sessionId2 = fetchedSessionBoard.getSession().getId();
                    for (SolutionBoard solutionBoard4 : tempSolutionBoards) {
                        if (!PropertyValidator.isValid((Collection)solutionBoard4.getPiSessions()) || !solutionBoard4.getPiSessions().contains(sessionId2) || solutionBoards.contains(solutionBoard4)) continue;
                        solutionBoards.add(solutionBoard4);
                        item4.setSolutionBoard(solutionBoard4);
                    }
                }
            }
        }
        HashMap allSolutionBoardsWithPiSessions = new HashMap();
        if (PropertyValidator.isValid(solutionBoards)) {
            for (SolutionBoard solutionBoard : solutionBoards) {
                ArrayList piSessions = solutionBoard.getPiSessions();
                for (String piSession : piSessions) {
                    for (SessionBoard sessionBoard4 : sessionBoards) {
                        if (!PropertyValidator.isValid((Object)sessionBoard4.getSession()) || !sessionBoard4.getSession().getId().equalsIgnoreCase(piSession)) continue;
                        solutionBoardWithPiBoard.computeIfAbsent(solutionBoard.getId(), k -> new HashSet()).add(sessionBoard4.getId());
                    }
                }
                allSolutionBoardsWithPiSessions.put(solutionBoard.getId(), new HashSet(piSessions));
            }
            LOGGER.debug("Found sessionBoards of size :{}", (Object)sessionBoards.size());
        }
        if (sessionBoards.isEmpty()) {
            LOGGER.warn("No active session boards found for TFS ID: {}", (Object)jiraKey);
            response.put("noProgramBoards", true);
            return response;
        }
        HashMap<String, SessionBoard> sessionBoardWithIdMap = new HashMap<String, SessionBoard>();
        for (SessionBoard sessionBoard3 : sessionBoards) {
            if (!PropertyValidator.isValid((Object)sessionBoard3.getId())) continue;
            sessionBoardWithIdMap.put(sessionBoard3.getId(), sessionBoard3);
        }
        for (Item item5 : items) {
            List additionalSolutionBoards;
            Object itemLinkedSessionBoardIds;
            String solutionBoardId;
            if (PropertyValidator.isValid((Object)item5.getSolutionBoard()) && solutionBoardWithPiBoard.containsKey(solutionBoardId = item5.getSolutionBoard().getId()) && PropertyValidator.isValid((Collection)(itemLinkedSessionBoardIds = (Set)solutionBoardWithPiBoard.get(solutionBoardId)))) {
                Iterator iterator = itemLinkedSessionBoardIds.iterator();
                while (iterator.hasNext()) {
                    String epicSessionId;
                    SessionBoard sessionBoard5;
                    String sessionBoardId = (String)iterator.next();
                    if (!sessionBoardWithIdMap.containsKey(sessionBoardId) || !PropertyValidator.isValid((Object)(sessionBoard5 = (SessionBoard)sessionBoardWithIdMap.get(sessionBoardId))) || !PropertyValidator.isValid((Object)sessionBoard5.getSession())) continue;
                    String sessionId3 = sessionBoard5.getSession().getId();
                    String epicKey = item5.getJiraKey();
                    String compositeKey = epicKey + "::" + (String)sessionId3;
                    if (!epicKeyWithSessionIdMap.containsKey(compositeKey) || !(epicSessionId = (String)epicKeyWithSessionIdMap.get(compositeKey)).equalsIgnoreCase(sessionId3)) continue;
                    LOGGER.debug("Found epic session id :{}", (Object)epicSessionId);
                    if (!PropertyValidator.isValid((Collection)item5.getSessionBoards())) {
                        ArrayList<SessionBoard> itemLinkedSessionBoards = new ArrayList<SessionBoard>();
                        itemLinkedSessionBoards.add(sessionBoard5);
                        item5.setSessionBoards(itemLinkedSessionBoards);
                        continue;
                    }
                    item5.getSessionBoards().add(sessionBoard5);
                    sessionMap.put(sessionBoard5.getSession().getId(), sessionBoard5.getSession());
                }
            }
            if (!PropertyValidator.isValid((Object)item5.getFields()) || !item5.getFields().containsKey("allSolutionBoards") || !PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item5.getFields().get("allSolutionBoards")))) continue;
            itemLinkedSessionBoardIds = additionalSolutionBoards.iterator();
            while (itemLinkedSessionBoardIds.hasNext()) {
                Set itemLinkedSessionBoardIds2;
                SolutionBoard solutionBoard = (SolutionBoard)itemLinkedSessionBoardIds.next();
                String solutionBoardId2 = solutionBoard.getId();
                if (!solutionBoardWithPiBoard.containsKey(solutionBoardId2) || !PropertyValidator.isValid((Collection)(itemLinkedSessionBoardIds2 = (Set)solutionBoardWithPiBoard.get(solutionBoardId2)))) continue;
                for (String sessionBoardId : itemLinkedSessionBoardIds2) {
                    String epicSessionId;
                    SessionBoard sessionBoard6;
                    if (!sessionBoardWithIdMap.containsKey(sessionBoardId) || !PropertyValidator.isValid((Object)(sessionBoard6 = (SessionBoard)sessionBoardWithIdMap.get(sessionBoardId))) || !PropertyValidator.isValid((Object)sessionBoard6.getSession())) continue;
                    String sessionId4 = sessionBoard6.getSession().getId();
                    String epicKey = item5.getJiraKey();
                    String compositeKey = epicKey + "::" + (String)sessionId4;
                    if (!epicKeyWithSessionIdMap.containsKey(compositeKey) || !(epicSessionId = (String)epicKeyWithSessionIdMap.get(compositeKey)).equalsIgnoreCase(sessionId4)) continue;
                    LOGGER.debug("Found epic session id :{}", (Object)epicSessionId);
                    if (!PropertyValidator.isValid((Collection)item5.getSessionBoards())) {
                        ArrayList<SessionBoard> itemLinkedSessionBoards = new ArrayList<SessionBoard>();
                        itemLinkedSessionBoards.add(sessionBoard6);
                        item5.setSessionBoards(itemLinkedSessionBoards);
                        continue;
                    }
                    item5.getSessionBoards().add(sessionBoard6);
                }
            }
        }
        HashSet hashSet = new HashSet();
        sessionBoards.stream().forEach(sessionBoard -> {
            activeSessionBoardIds.add(sessionBoard.getId());
            sessionBoardMap.put(sessionBoard.getId(), (SessionBoard)sessionBoard);
        });
        LOGGER.debug("Step 5: Building link types map for active session boards");
        long step5Start = System.currentTimeMillis();
        Map boardWithLinkTypesMap = this.buildJiraBoardLinkTypesMap(sessionBoards, sessionBoardMap);
        long step5End = System.currentTimeMillis();
        LOGGER.debug("Step 5 completed in {} ms", (Object)(step5End - step5Start));
        HashMap<Object, Date> itemWithDatesMap = new HashMap<Object, Date>();
        LOGGER.debug("Step 6: Filtering active items and building item maps");
        long step6Start = System.currentTimeMillis();
        List activeItems = this.filterActiveItems(items, hashSet);
        for (Item activeItem : activeItems) {
            if (PropertyValidator.isValid((Collection)activeItem.getItemLinks())) {
                for (ItemLink itemLink : activeItem.getItemLinks()) {
                    if (!PropertyValidator.isValid((Object)itemLink.getId())) continue;
                    itemLinkIds.add(itemLink.getId());
                }
            }
            if (PropertyValidator.isValid((Collection)activeItem.getJiraDependencies())) {
                for (ItemJiraDependency jiraDependency : activeItem.getJiraDependencies()) {
                    if (!PropertyValidator.isValid((Object)jiraDependency.getId())) continue;
                    itemJiraDependencyIds.add(jiraDependency.getId());
                }
            }
            if (!PropertyValidator.isValid((Collection)activeItem.getTeamContainers())) continue;
            for (TeamContainer teamContainer : activeItem.getTeamContainers()) {
                if (!PropertyValidator.isValid((Object)teamContainer.getId())) continue;
                teamContainerIds.add(teamContainer.getId());
            }
        }
        HashSet<String> userIds = new HashSet<String>();
        if (!itemLinkIds.isEmpty()) {
            itemLinkMap = this.fetchItemLinksWithNestedObjects(itemLinkIds, tenant, userIds);
        }
        List itemJiraDependencies = this.itemJiraDependencyRepository.findByTargetJiraIssueKey(jiraKey);
        for (ItemJiraDependency itemJiraDependency : itemJiraDependencies) {
            Iterator boardItems;
            if (!PropertyValidator.isValid((Object)itemJiraDependency.getSessionBoardId()) || !activeSessionBoardWithItems.containsKey(itemJiraDependency.getSessionBoardId()) || !PropertyValidator.isValid((Collection)((Object)(boardItems = (List)activeSessionBoardWithItems.get(itemJiraDependency.getSessionBoardId()))))) continue;
            Iterator iterator = boardItems.iterator();
            while (iterator.hasNext()) {
                Item boardItem = (Item)iterator.next();
                if (!PropertyValidator.isValid((Object)itemJiraDependency.getTargetJiraIssue()) || !PropertyValidator.isValid((Object)itemJiraDependency.getTargetJiraIssue().getFields()) || !PropertyValidator.isValid((Object)itemJiraDependency.getTargetJiraIssue().getFields().getIssuetype()) || !PropertyValidator.isValid((Object)boardItem.getJiraFieldByKey()) || !PropertyValidator.isValid(boardItem.getJiraFieldByKey().get("issuetype"))) continue;
                Map issueType = (Map)boardItem.getJiraFieldByKey().get("issuetype");
                if ((!PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId()) || !boardItem.getId().equalsIgnoreCase(itemJiraDependency.getTargetItemId())) && (!PropertyValidator.isValid(issueType.get("self")) || !issueType.get("self").toString().equalsIgnoreCase(itemJiraDependency.getTargetJiraIssue().getFields().getIssuetype().getSelf()))) continue;
                if (!PropertyValidator.isValid((Collection)boardItem.getJiraDependencies())) {
                    ArrayList<ItemJiraDependency> itemJiraDependencyList = new ArrayList<ItemJiraDependency>();
                    itemJiraDependencyList.add(itemJiraDependency);
                    boardItem.setJiraDependencies(itemJiraDependencyList);
                    itemJiraDependencyIds.add(itemJiraDependency.getId());
                    continue;
                }
                boolean exists = boardItem.getJiraDependencies().stream().anyMatch(existingDep -> existingDep.getId().equalsIgnoreCase(itemJiraDependency.getId()));
                if (exists) continue;
                boardItem.getJiraDependencies().add(itemJiraDependency);
                itemJiraDependencyIds.add(itemJiraDependency.getId());
                if (!PropertyValidator.isValid((Collection)itemJiraDependency.getConversations())) continue;
                for (Conversation conversation : itemJiraDependency.getConversations()) {
                    conversationIds.add(conversation.getId());
                }
            }
        }
        if (!itemJiraDependencyIds.isEmpty()) {
            itemJiraDependencyMap = this.fetchItemJiraDependenciesWithNestedObjects(itemJiraDependencyIds, tenant, userIds);
        }
        for (ItemLink link : itemLinkMap.values()) {
            if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
            for (Conversation c : link.getConversations()) {
                if (!PropertyValidator.isValid((Object)c) || !PropertyValidator.isValid((Object)c.getId())) continue;
                conversationIds.add(c.getId());
            }
        }
        for (Object dep : itemJiraDependencyMap.values()) {
            if (!PropertyValidator.isValid((Collection)dep.getConversations())) continue;
            for (Conversation c : dep.getConversations()) {
                if (!PropertyValidator.isValid((Object)c) || !PropertyValidator.isValid((Object)c.getId())) continue;
                conversationIds.add(c.getId());
            }
        }
        Map conversationMap = new HashMap();
        if (!conversationIds.isEmpty()) {
            Conversation full;
            ArrayList<Conversation> updated;
            conversationMap = this.fetchConversationsByIds(conversationIds);
            for (ItemLink link : itemLinkMap.values()) {
                if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
                updated = new ArrayList<Conversation>();
                for (Conversation c : link.getConversations()) {
                    Conversation conversation = full = PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getId()) ? (Conversation)conversationMap.get(c.getId()) : null;
                    if (PropertyValidator.isValid(full)) {
                        if (PropertyValidator.isValid((Object)full.getUser()) && PropertyValidator.isValid((Object)full.getUser().getId())) {
                            userIds.add(full.getUser().getId());
                        }
                        updated.add(full);
                        continue;
                    }
                    if (PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getUser()) && PropertyValidator.isValid((Object)c.getUser().getId())) {
                        userIds.add(c.getUser().getId());
                    }
                    updated.add(c);
                }
                link.setConversations(updated);
            }
            for (ItemJiraDependency dep : itemJiraDependencyMap.values()) {
                if (!PropertyValidator.isValid((Collection)dep.getConversations())) continue;
                updated = new ArrayList();
                for (Conversation c : dep.getConversations()) {
                    Conversation conversation = full = PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getId()) ? (Conversation)conversationMap.get(c.getId()) : null;
                    if (PropertyValidator.isValid((Object)full)) {
                        if (PropertyValidator.isValid((Object)full.getUser()) && PropertyValidator.isValid((Object)full.getUser().getId())) {
                            userIds.add(full.getUser().getId());
                        }
                        updated.add(full);
                        continue;
                    }
                    if (PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getUser()) && PropertyValidator.isValid((Object)c.getUser().getId())) {
                        userIds.add(c.getUser().getId());
                    }
                    updated.add(c);
                }
                dep.setConversations(updated);
            }
        }
        Map boardWithItemMap = this.buildJiraBoardWithItemMap(activeItems, itemWithDatesMap, sessionBoardMap);
        long step6End = System.currentTimeMillis();
        LOGGER.debug("Step 6 completed in {} ms, filtered {} active items", (Object)(step6End - step6Start), (Object)activeItems.size());
        HashMap<JiraItemKey, Map> missingItems = new HashMap<JiraItemKey, Map>();
        LOGGER.debug("Step 7: Building dependencies for each board/item");
        long step7Start = System.currentTimeMillis();
        Set<Object> dependentItemIds = new HashSet();
        HashSet<String> containerIds = new HashSet<String>();
        HashMap almDependenciesMap = new HashMap();
        Map boardWithDependenciesMap = this.buildJiraBoardWithDependenciesMap(boardWithItemMap, itemWithDatesMap, dependentItemIds, containerIds, missingItems, tenant, itemLinkMap, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, teamContainerIds, boardWithLinkTypesMap, almDependenciesMap, sessionBoardIds, conversationMap);
        long step7End = System.currentTimeMillis();
        LOGGER.debug("Step 7 completed in {} ms, found {} dependent items, {} container IDs", new Object[]{step7End - step7Start, dependentItemIds.size(), containerIds.size()});
        HashMap<TfsItemKey, Object> dependentItemWithJiraKey = new HashMap<TfsItemKey, Object>();
        HashMap<String, Item> dependentItemsMap = new HashMap<String, Item>();
        dependentItemIds = dependentItemIds.stream().filter(PropertyValidator::isValid).collect(Collectors.toSet());
        List<Object> dependencyItems = new ArrayList();
        if (PropertyValidator.isValid(solutionBoards)) {
            List dependentSessionBoards;
            Object dependentSessionBoardObjs;
            LOGGER.debug("Finding dependent items by solution boards with item Ids: {}", dependentItemIds);
            dependentItemIdsObj = dependentItemIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(id -> new ObjectId(id)).collect(Collectors.toList());
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.append("_id", (Object)new BasicDBObject("$in", dependentItemIdsObj));
            basicDBObject.append("tenant", (Object)tenant);
            List dependencyPipe = this.buildItemAggregationPipeline(basicDBObject);
            dependencyItems = this.executeItemAggregation(dependencyPipe, teamContainerIds, sessionBoardIds);
            if (PropertyValidator.isValid(dependencyItems) && PropertyValidator.isValid((Collection)(dependentSessionBoardObjs = this.fetchActiveSessionBoards(new HashSet(dependentSessionBoards = dependencyItems.stream().filter(item -> PropertyValidator.isValid((Collection)item.getSessionBoards())).map(i -> ((SessionBoard)i.getSessionBoards().get(0)).getId()).distinct().collect(Collectors.toList())), tenant, false)))) {
                Iterator iterator = dependentSessionBoardObjs.iterator();
                while (iterator.hasNext()) {
                    SessionBoard dependentSessionBoardObj = (SessionBoard)iterator.next();
                    if (!PropertyValidator.isValid((Object)dependentSessionBoardObj.getSession()) || !PropertyValidator.isValid((Object)dependentSessionBoardObj.getSession().getId())) continue;
                    sessionBoardMap.put(dependentSessionBoardObj.getId(), dependentSessionBoardObj);
                }
            }
        } else {
            LOGGER.debug("Fetching dependent items without solution boards for {} item IDs", (Object)dependentItemIds.size());
            LOGGER.debug("Active session board IDs: {}", hashSet);
            dependentItemIdsObj = dependentItemIds.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(id -> new ObjectId(id)).collect(Collectors.toList());
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.append("_id", (Object)new BasicDBObject("$in", dependentItemIdsObj));
            basicDBObject.append("tenant", (Object)tenant);
            List fallbackPipe = this.buildItemAggregationPipeline(basicDBObject);
            List allDependentItems = this.executeItemAggregation(fallbackPipe, teamContainerIds, sessionBoardIds);
            LOGGER.debug("Fetched {} dependent items from database", (Object)allDependentItems.size());
            dependencyItems = allDependentItems.stream().filter(item -> {
                LOGGER.debug("Processing item: {} with sessionBoards: {}", (Object)item.getId(), item.getSessionBoards() != null ? Integer.valueOf(item.getSessionBoards().size()) : "null");
                if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                    LOGGER.debug("Item {} has solution board, excluding", (Object)item.getId());
                    return false;
                }
                if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && !item.getSessionBoards().isEmpty()) {
                    boolean hasActiveSessionBoard = item.getSessionBoards().stream().anyMatch(sessionBoard -> {
                        if (PropertyValidator.isValid((Object)sessionBoard) && PropertyValidator.isValid((Object)sessionBoard.getId())) {
                            boolean isActive = activeSessionBoardIds.contains(sessionBoard.getId());
                            LOGGER.debug("Session board {} for item {} is active: {}", new Object[]{sessionBoard.getId(), item.getId(), isActive});
                            return isActive;
                        }
                        return false;
                    });
                    if (hasActiveSessionBoard) {
                        LOGGER.debug("Item {} has active session board, including", (Object)item.getId());
                        return true;
                    }
                    LOGGER.debug("Item {} has no active session boards, excluding", (Object)item.getId());
                    return false;
                }
                LOGGER.debug("Item {} has no session boards, excluding", (Object)item.getId());
                return false;
            }).collect(Collectors.toList());
            LOGGER.debug("Filtered to {} dependent items without solution boards and with active session boards", (Object)dependencyItems.size());
        }
        sessionBoards = this.fetchActiveSessionBoards(sessionBoardIds, tenant, false);
        sessionBoards.stream().map(SessionBoard::getSession).filter(PropertyValidator::isValid).forEach(session -> {
            if (PropertyValidator.isValid((Object)session.getId())) {
                sessionIds.add(session.getId());
                sessionMap.put(session.getId(), (Session)session);
            }
        });
        sessionBoards.stream().forEach(sessionBoard -> sessionBoardMap.put(sessionBoard.getId(), (SessionBoard)sessionBoard));
        if (!epicKeyWithSessionIdMap.isEmpty()) {
            Iterator epicKeys = epicKeyWithSessionIdMap.keySet().stream().map(key -> key.split("::")[0]).collect(Collectors.toSet());
            BasicDBObject basicDBObject = new BasicDBObject();
            basicDBObject.append("jiraKey", (Object)new BasicDBObject("$in", epicKeys));
            basicDBObject.append("tenant", (Object)tenant);
            List epicItemsPipe = this.buildItemAggregationPipeline(basicDBObject);
            List epicItems = this.executeItemAggregation(epicItemsPipe, teamContainerIds, sessionBoardIds);
            if (PropertyValidator.isValid((Collection)epicItems)) {
                for (Object epicItem : epicItems) {
                    SessionBoard sessionBoard7;
                    dependentItemsMap.put(epicItem.getJiraKey(), (Item)epicItem);
                    if (!PropertyValidator.isValid((Collection)epicItem.getSessionBoards()) || !PropertyValidator.isValid((Object)(sessionBoard7 = (SessionBoard)sessionBoardMap.get(((SessionBoard)epicItem.getSessionBoards().get(0)).getId()))) || !PropertyValidator.isValid((Object)sessionBoard7.getSession())) continue;
                    TfsItemKey tfsItemKey = new TfsItemKey(epicItem.getJiraKey(), sessionBoard7.getSession().getId());
                    dependentItemWithJiraKey.put(tfsItemKey, epicItem);
                }
            }
        }
        LOGGER.debug("Dependent items found: {}", (Object)dependencyItems.size());
        if (PropertyValidator.isValid(dependencyItems)) {
            for (Item item2 : dependencyItems) {
                List additionalSolutionBoards;
                SolutionBoard solutionBoard;
                SessionBoard sessionBoard8;
                dependentItemsMap.put(item2.getId(), item2);
                if (PropertyValidator.isValid((Collection)item2.getSessionBoards()) && PropertyValidator.isValid((Object)(sessionBoard8 = (SessionBoard)sessionBoardMap.get(((SessionBoard)item2.getSessionBoards().get(0)).getId()))) && PropertyValidator.isValid((Object)sessionBoard8.getSession())) {
                    TfsItemKey tfsItemKey = new TfsItemKey(item2.getJiraKey(), sessionBoard8.getSession().getId());
                    dependentItemWithJiraKey.put(tfsItemKey, item2);
                }
                if (PropertyValidator.isValid((Object)item2.getSolutionBoard()) && PropertyValidator.isValid((Collection)(solutionBoard = item2.getSolutionBoard()).getPiSessions())) {
                    for (String piSession : solutionBoard.getPiSessions()) {
                        if (!PropertyValidator.isValid((Object)piSession)) continue;
                        solutionBoardsLinkedSessions.add(piSession);
                    }
                }
                if (!PropertyValidator.isValid((Object)item2.getFields()) || !item2.getFields().containsKey("allSolutionBoards") || !PropertyValidator.isValid((Collection)(additionalSolutionBoards = (List)item2.getFields().get("allSolutionBoards")))) continue;
                for (SolutionBoard solutionBoard5 : additionalSolutionBoards) {
                    if (!PropertyValidator.isValid((Collection)solutionBoard5.getPiSessions())) continue;
                    for (String piSession : solutionBoard5.getPiSessions()) {
                        if (!PropertyValidator.isValid((Object)piSession)) continue;
                        solutionBoardsLinkedSessions.add(piSession);
                    }
                }
            }
        }
        if (!teamContainerIds.isEmpty()) {
            teamContainerMap = this.fetchTeamContainersWithNestedObjects(teamContainerIds, tenant);
        }
        for (TeamContainer teamContainer : teamContainerMap.values()) {
            Container container = teamContainer.getContainer();
            containerMap.put(container.getId(), container);
        }
        long epicSolutionStart = System.currentTimeMillis();
        LOGGER.debug("Building epic features and linked solution boards for epic items");
        HashMap<String, Set> epicLinkedSolutionBoardsMap = new HashMap<String, Set>();
        HashMap<Object, Container> epicLinkedContainersMap = new HashMap<Object, Container>();
        HashMap<String, List> epicKeyToContainerIds = new HashMap<String, List>();
        if (PropertyValidator.isValid(solutionBoardsLinkedSessions)) {
            Criteria additionalEpicCriteria = Criteria.where((String)"sessionId").in(solutionBoardsLinkedSessions).and("tenant").is((Object)tenant);
            Query additionalEpicQuery = Query.query((CriteriaDefinition)additionalEpicCriteria);
            additionalEpicQuery.fields().include("_id").include("epicKey").include("sessionId").include("featureId").include("solutionBoardId").include("featureKey");
            epicFeatures.addAll(this.mongoTemplate.find(additionalEpicQuery, EpicFeature.class));
            HashMap featureWithEpicMap = new HashMap();
            for (EpicFeature epicFeature : epicFeatures) {
                if (PropertyValidator.isValid((Object)epicFeature.getEpicKey()) && PropertyValidator.isValid((Object)epicFeature.getSessionId())) {
                    String compositeKey = epicFeature.getEpicKey() + "::" + epicFeature.getSessionId();
                    epicKeyWithSessionIdMap.put(compositeKey, epicFeature.getSessionId());
                }
                if (PropertyValidator.isValid((Object)epicFeature.getFeatureId())) {
                    featureWithEpicMap.put(epicFeature.getFeatureId(), epicFeature.getEpicKey());
                }
                if (!PropertyValidator.isValid((Object)epicFeature.getSolutionBoardId())) continue;
                epicLinkedSolutionBoardsMap.computeIfAbsent(epicFeature.getEpicKey(), k -> new HashSet()).add(epicFeature.getSolutionBoardId());
            }
            if (!featureWithEpicMap.isEmpty()) {
                List featureWithEpicObjIds = featureWithEpicMap.keySet().stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
                BasicDBObject featureItemsWhere = new BasicDBObject();
                featureItemsWhere.append("_id", (Object)new BasicDBObject("$in", featureWithEpicObjIds));
                featureItemsWhere.append("tenant", (Object)tenant);
                List featureItemsPipe = this.buildItemAggregationPipeline(featureItemsWhere);
                List list = this.executeItemAggregation(featureItemsPipe, teamContainerIds, sessionBoardIds);
                teamContainerMap = this.fetchTeamContainersWithNestedObjects(teamContainerIds, tenant);
                for (Item featureItem : list) {
                    String epicKey = (String)featureWithEpicMap.get(featureItem.getId());
                    if (!PropertyValidator.isValid((Object)epicKey) || !PropertyValidator.isValid((Collection)featureItem.getTeamContainers())) continue;
                    for (TeamContainer teamContainer : featureItem.getTeamContainers()) {
                        TeamContainer teamContainer2 = (TeamContainer)teamContainerMap.get(teamContainer.getId());
                        if (!PropertyValidator.isValid((Object)teamContainer2) || !PropertyValidator.isValid((Object)teamContainer2.getContainer()) || !PropertyValidator.isValid((Object)teamContainer2.getContainer().getId())) continue;
                        String containerId = teamContainer2.getContainer().getId();
                        epicKeyToContainerIds.computeIfAbsent(epicKey, k -> new ArrayList()).add(containerId);
                        containerIds.add(containerId);
                    }
                }
            }
            List solutionBoardLinkedSessionIdObjs = solutionBoardsLinkedSessions.stream().filter(PropertyValidator::isValid).filter(ObjectId::isValid).map(ObjectId::new).collect(Collectors.toList());
            Criteria additionalSessionCriteria = Criteria.where((String)"_id").in(solutionBoardLinkedSessionIdObjs).and("tenant").is((Object)tenant);
            Iterator<Object> additionalSessionQuery = Query.query((CriteriaDefinition)additionalSessionCriteria);
            additionalSessionQuery.fields().include("_id").include("activeSessionBoard").include("title").include("rowStatus");
            sessions.addAll(this.mongoTemplate.find(additionalSessionQuery, Session.class));
            activeSolutionLinkedBoardIds.addAll(sessions.stream().map(Session::getActiveSessionBoard).distinct().collect(Collectors.toList()));
        }
        long epicSolutionEnd = System.currentTimeMillis();
        LOGGER.debug("Built epic features and linked solution boards in {} ms", (Object)(epicSolutionEnd - epicSolutionStart));
        for (Session session2 : sessions) {
            if (!PropertyValidator.isValid((Object)session2.getId())) continue;
            sessionMap.put(session2.getId(), session2);
        }
        Criteria containerCriteria = Criteria.where((String)"_id").in(containerIds).and("tenant").is((Object)tenant);
        Query containerQuery = Query.query((CriteriaDefinition)containerCriteria);
        containerQuery.fields().include("_id").include("label").include("sequence").include("endDate");
        List containers = this.mongoTemplate.find(containerQuery, Container.class);
        if (PropertyValidator.isValid((Collection)containers)) {
            for (Container container : containers) {
                containerMap.put(container.getId(), container);
            }
        }
        if (PropertyValidator.isValid(epicKeyToContainerIds)) {
            for (Map.Entry entry : epicKeyToContainerIds.entrySet()) {
                String epicKey = (String)entry.getKey();
                List ids = (List)entry.getValue();
                if (!PropertyValidator.isValid((Collection)ids)) continue;
                Container best = ids.stream().map(containerMap::get).filter(Objects::nonNull).max(Comparator.comparing(Container::getSequence, Comparator.nullsLast(Comparator.naturalOrder()))).orElse(null);
                if (!PropertyValidator.isValid((Object)best)) continue;
                itemWithDatesMap.put(epicKey, best.getEndDate());
                epicLinkedContainersMap.put(epicKey, best);
            }
        }
        long dependenciesEnrichStart = System.currentTimeMillis();
        for (Object piBoardWithDependencies : boardWithDependenciesMap.values()) {
            Map piBoardWithDependenciesMap = (Map)piBoardWithDependencies;
            if (!PropertyValidator.isValid(piBoardWithDependenciesMap.get("dependencies"))) continue;
            Map itemWithDependencies2 = (Map)piBoardWithDependenciesMap.get("dependencies");
            String boardSessionId = piBoardWithDependenciesMap.get("boardSessionId").toString();
            Iterator iterator = itemWithDependencies2.entrySet().iterator();
            while (iterator.hasNext()) {
                JiraItemKey jiraItemKey;
                String dependencyId;
                String sourceSessionId;
                String targetItemId;
                Item item6;
                String sessionBoardId;
                Map.Entry itemEntry = iterator.next();
                String itemId = (String)itemEntry.getKey();
                Map dependencyMap2 = (Map)itemEntry.getValue();
                if (dependencyMap2.containsKey("isSolutionOnly") && PropertyValidator.isValid(dependencyMap2.get("targetItemId")) && PropertyValidator.isValid(dependencyMap2.get("sessionBoardId"))) {
                    Map fetchedDependencyMap;
                    String fetchedSessionBoardId;
                    String targetItemId2 = (String)dependencyMap2.get("targetItemId");
                    sessionBoardId = (String)dependencyMap2.get("sessionBoardId");
                    if (PropertyValidator.isValid((Object)targetItemId2) && PropertyValidator.isValid((Object)sessionBoardId) && almDependenciesMap.containsKey(targetItemId2) && PropertyValidator.isValid((Object)(fetchedSessionBoardId = (String)(fetchedDependencyMap = (Map)almDependenciesMap.get(targetItemId2)).get("sessionBoardId"))) && fetchedSessionBoardId.equalsIgnoreCase(sessionBoardId) && PropertyValidator.isValid(fetchedDependencyMap.get("targetKey"))) {
                        itemWithDependencies2.put(fetchedDependencyMap.get("targetKey").toString(), fetchedDependencyMap);
                        dependencyMap2 = fetchedDependencyMap;
                    }
                }
                if (!PropertyValidator.isValid((Object)(item6 = (Item)dependentItemsMap.get(itemId))) && PropertyValidator.isValid(dependencyMap2.get("targetItemId"))) {
                    targetItemId = (String)dependencyMap2.get("targetItemId");
                    item6 = (Item)dependentItemsMap.get(targetItemId);
                }
                if (PropertyValidator.isValid(dependencyMap2.get("sourceSessionId")) && PropertyValidator.isValid((Object)(sourceSessionId = (String)dependencyMap2.get("sourceSessionId"))) && !sourceSessionId.equalsIgnoreCase(boardSessionId)) {
                    LOGGER.debug("Dependency id :{} does not belong to session id: {}, removing it.", (Object)boardSessionId, (Object)dependencyMap2.get("dependencyId").toString());
                    iterator.remove();
                    continue;
                }
                if (PropertyValidator.isValid((Object)item6)) {
                    boolean reverseLink;
                    SessionBoard sessionBoardObj;
                    Map newMap;
                    if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap2.get("linkOrigin").toString()) && PropertyValidator.isValid(dependencyMap2.get("targetTeamContainerId")) && !PropertyValidator.isValid((Collection)item6.getTeamContainers()) && PropertyValidator.isValid((Object)"targetItemId") && (targetItemId = dependencyMap2.get("targetItemId").toString()).equalsIgnoreCase(item6.getId()) && !PropertyValidator.isValid((Collection)item6.getTeamContainers()) && almDependenciesMap.containsKey(targetItemId) && (newMap = (Map)almDependenciesMap.get(targetItemId)) != null) {
                        itemEntry.setValue(newMap);
                        dependencyMap2 = newMap;
                    }
                    if (PropertyValidator.isValid((Collection)item6.getSessionBoards()) && !item6.getSessionBoards().isEmpty() && dependencyMap2.containsKey("isSolutionOnly")) {
                        sessionBoardId = ((SessionBoard)item6.getSessionBoards().get(0)).getId();
                        sessionBoardObj = (SessionBoard)sessionBoardMap.get(sessionBoardId);
                        if (PropertyValidator.isValid((Object)sessionBoardObj) && PropertyValidator.isValid((Object)sessionBoardObj.getSession()) && boardSessionId.equalsIgnoreCase(sessionBoardObj.getSession().getId())) {
                            dependencyMap2.remove("isSolutionOnly");
                        }
                    } else if (!PropertyValidator.isValid((Collection)item6.getSessionBoards()) && !dependencyMap2.containsKey("isSolutionOnly") && LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap2.get("linkOrigin").toString())) {
                        dependencyMap2.put("isArchive", true);
                        dependencyMap2.put("dependencyType", "");
                        dependencyId = dependencyMap2.get("dependencyId").toString();
                        jiraItemKey = new JiraItemKey(dependencyId, jiraKey);
                        missingItems.put(jiraItemKey, dependencyMap2);
                    } else if (PropertyValidator.isValid((Collection)item6.getSessionBoards()) && !(sessionBoardObj = (SessionBoard)sessionBoardMap.get(sessionBoardId = ((SessionBoard)item6.getSessionBoards().get(0)).getId())).getSession().getId().equalsIgnoreCase(boardSessionId)) {
                        dependencyMap2.put("isArchive", true);
                        dependencyMap2.put("dependencyType", "");
                        String dependencyId2 = dependencyMap2.get("dependencyId").toString();
                        JiraItemKey jiraItemKey2 = new JiraItemKey(dependencyId2, jiraKey);
                        missingItems.put(jiraItemKey2, dependencyMap2);
                    }
                    if (dependencyMap2.containsKey("reverseLink") && (reverseLink = ((Boolean)dependencyMap2.get("reverseLink")).booleanValue())) {
                        LOGGER.debug("Found reverse link for item with ID: {}", (Object)itemId);
                        String dependencyId3 = (String)dependencyMap2.get("dependencyId");
                        if (!PropertyValidator.isValid((Collection)item6.getItemLinks())) {
                            LOGGER.debug("Dependency ID :{} is not valid for item with ID: {}", (Object)dependencyId3, (Object)itemId);
                            iterator.remove();
                            continue;
                        }
                        ItemLink itemLink = item6.getItemLinks().stream().filter(l -> dependencyId3.equals(l.getId())).findFirst().orElse(null);
                        if (itemLink == null) {
                            iterator.remove();
                            LOGGER.debug("ItemLink with ID :{} not found, removing it from dependencies list", (Object)dependencyId3);
                            continue;
                        }
                    }
                    if (PropertyValidator.isValid(piBoardWithDependenciesMap.get("sourceStatus"))) {
                        dependencyMap2.put("sourceStatus", piBoardWithDependenciesMap.get("sourceStatus"));
                        dependencyMap2.put("sourceStatusCategory", piBoardWithDependenciesMap.get("sourceStatusCategory"));
                    }
                    dependencyMap2.put("targetDate", piBoardWithDependenciesMap.get("targetDate"));
                    dependencyMap2.put("sourceIcon", piBoardWithDependenciesMap.get("sourceIcon"));
                    dependencyMap2.put("sourceTfsUrl", piBoardWithDependenciesMap.get("sourceTfsUrl"));
                    this.enrichJiraDependencyMap(item6, dependencyMap2, itemWithDatesMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
                    continue;
                }
                LOGGER.debug("Item with ID :{} not found, removing it from dependencies list. When looking in pi boards", (Object)itemId);
                if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap2.get("linkType").toString())) {
                    iterator.remove();
                    continue;
                }
                if (!LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap2.get("linkOrigin").toString())) continue;
                dependencyId = dependencyMap2.get("dependencyId").toString();
                jiraItemKey = new JiraItemKey(dependencyId, jiraKey);
                dependencyMap2.put("isArchive", true);
                dependencyMap2.put("dependencyType", "");
                missingItems.put(jiraItemKey, dependencyMap2);
                this.enrichJiraDependencyMap(item6, dependencyMap2, itemWithDatesMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
            }
        }
        long dependenciesEnrichEnd = System.currentTimeMillis();
        LOGGER.debug("Dependencies enriched in {} ms", (Object)(dependenciesEnrichEnd - dependenciesEnrichStart));
        if (!missingItems.isEmpty()) {
            LOGGER.debug("Missing Items size :{}", (Object)missingItems.size());
            this.fetchJiraMissingItems(missingItems);
        }
        if (PropertyValidator.isValid(solutionBoards)) {
            long solutionBoardsStart = System.currentTimeMillis();
            for (Map.Entry entry : solutionBoardWithPiBoard.entrySet()) {
                String solutionBoardId = (String)entry.getKey();
                Set piBoards = (Set)entry.getValue();
                Iterator<Map.Entry<String, Object>> piBoardWithDependencies = new HashMap();
                HashMap acrossBoardDependencies = new HashMap();
                if (!PropertyValidator.isValid((Collection)piBoards)) continue;
                for (String piBoard : piBoards) {
                    Map piBoardMap = this.findBoardDataBySessionBoardId(boardWithDependenciesMap, piBoard, solutionBoardId);
                    if (!PropertyValidator.isValid((Object)piBoardMap)) continue;
                    HashMap copiedMap = new HashMap();
                    for (Map.Entry piBoardEntry : piBoardMap.entrySet()) {
                        String key2 = (String)piBoardEntry.getKey();
                        Object value = piBoardEntry.getValue();
                        if (value instanceof Map) {
                            HashMap innerMap = new HashMap((Map)value);
                            copiedMap.put(key2, innerMap);
                            continue;
                        }
                        copiedMap.put(key2, value);
                    }
                    piBoardWithDependencies.put(piBoard, copiedMap);
                    itemWithDependencies = (Map)copiedMap.get("dependencies");
                    String boardSessionId = (String)copiedMap.get("boardSessionId");
                    Iterator iterator = itemWithDependencies.entrySet().iterator();
                    block55: while (iterator.hasNext()) {
                        Set solutionLinkedSessionIds;
                        Session targetSession;
                        String targetSessionId;
                        String sourceSessionId;
                        Object epicLinkedSessionId;
                        Set epicLinkedSolutionBoards;
                        Map.Entry itemEntry = iterator.next();
                        String itemId = (String)itemEntry.getKey();
                        dependencyMap = (Map)itemEntry.getValue();
                        Session epicLinkedSession = null;
                        Item item7 = (Item)dependentItemsMap.get(itemId);
                        String sourceKey = (String)dependencyMap.get("sourceKey");
                        if (PropertyValidator.isValid(epicLinkedSolutionBoardsMap) && epicLinkedSolutionBoardsMap.containsKey(sourceKey) && PropertyValidator.isValid((Collection)(epicLinkedSolutionBoards = (Set)epicLinkedSolutionBoardsMap.get(sourceKey))) && !epicLinkedSolutionBoards.contains(solutionBoardId)) {
                            LOGGER.debug("Removing sourceKey :{} epic from dependencies as it is not linked to solution board with ID :{}", (Object)sourceKey, (Object)solutionBoardId);
                            iterator.remove();
                            continue;
                        }
                        if (!PropertyValidator.isValid((Object)item7) && PropertyValidator.isValid(dependencyMap.get("targetItemId"))) {
                            String targetItemId = (String)dependencyMap.get("targetItemId");
                            item7 = (Item)dependentItemsMap.get(targetItemId);
                        }
                        String targetKey = null;
                        if (PropertyValidator.isValid(dependencyMap.get("targetKey"))) {
                            targetKey = (String)dependencyMap.get("targetKey");
                            epicLinkedSessionId = null;
                            for (Map.Entry epicEntry : epicKeyWithSessionIdMap.entrySet()) {
                                if (!((String)epicEntry.getKey()).startsWith(targetKey + "::")) continue;
                                epicLinkedSessionId = (String)epicEntry.getValue();
                                break;
                            }
                            if (PropertyValidator.isValid(epicLinkedSessionId)) {
                                epicLinkedSession = (Session)sessionMap.get(epicLinkedSessionId);
                            }
                        } else if (PropertyValidator.isValid((Object)item7)) {
                            targetKey = item7.getJiraKey();
                            epicLinkedSessionId = null;
                            for (Map.Entry epicEntry : epicKeyWithSessionIdMap.entrySet()) {
                                if (!((String)epicEntry.getKey()).startsWith(targetKey + "::")) continue;
                                epicLinkedSessionId = (String)epicEntry.getValue();
                                break;
                            }
                            if (PropertyValidator.isValid(epicLinkedSessionId)) {
                                epicLinkedSession = (Session)sessionMap.get(epicLinkedSessionId);
                            }
                        }
                        if (PropertyValidator.isValid(epicLinkedSession)) {
                            dependencyMap.put("targetBoardTitle", epicLinkedSession.getTitle());
                        }
                        if (dependencyMap.containsKey("isArchive") && !dependencyMap.containsKey("isSolutionOnly")) {
                            for (Map.Entry epicEntry : epicKeyWithSessionIdMap.entrySet()) {
                                if (!((String)epicEntry.getKey()).startsWith(targetKey)) continue;
                                continue block55;
                            }
                            if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap.get("linkType").toString())) {
                                LOGGER.debug("Item is not linked to solution board with ID :{}, removing it from dependencies list", (Object)solutionBoardId);
                                iterator.remove();
                                continue;
                            }
                            if (!LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap.get("linkType").toString()) || dependencyMap.containsKey("isSolutionOnly")) continue;
                            String piBoardId = dependencyMap.get("sessionBoardId").toString();
                            if (!PropertyValidator.isValid((Object)item7)) {
                                Map.Entry epicEntry;
                                Set solutionLinkedpiBoards = (Set)allSolutionBoardsWithPiSessions.get(solutionBoardId);
                                epicEntry = solutionLinkedpiBoards.iterator();
                                while (epicEntry.hasNext()) {
                                    String solutionLinkedpiBoard = (String)epicEntry.next();
                                    TfsItemKey tfsItemKey = new TfsItemKey(targetKey, solutionLinkedpiBoard);
                                    if (!dependentItemWithJiraKey.containsKey(tfsItemKey)) continue;
                                    item7 = (Item)dependentItemWithJiraKey.get(tfsItemKey);
                                }
                            }
                            if (PropertyValidator.isValid((Object)item7) && PropertyValidator.isValid((Collection)item7.getSessionBoards()) && !item7.getSessionBoards().isEmpty()) {
                                Set piSessions;
                                String sessionBoardId = ((SessionBoard)item7.getSessionBoards().get(0)).getId();
                                SessionBoard sessionBoardObj = (SessionBoard)sessionBoardMap.get(sessionBoardId);
                                if (PropertyValidator.isValid((Object)sessionBoardObj) && PropertyValidator.isValid((Object)piBoardId) && piBoardId.equalsIgnoreCase(sessionBoardObj.getId())) {
                                    dependencyMap.remove("isArchive");
                                    this.enrichJiraDependencyMap(item7, new HashMap(dependencyMap), itemWithDatesMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
                                    continue;
                                }
                                if (sessionBoardIds.contains(sessionBoardObj.getId()) && PropertyValidator.isValid((Collection)(piSessions = (Set)allSolutionBoardsWithPiSessions.get(solutionBoardId))) && piSessions.contains(sessionBoardObj.getSession().getId()) && sessionBoardObj.getSession().getActiveSessionBoard().equalsIgnoreCase(((SessionBoard)item7.getSessionBoards().get(0)).getId()) && !boardSessionId.equalsIgnoreCase(sessionBoardObj.getSession().getId())) {
                                    HashMap acrossBoardDependency = new HashMap(dependencyMap);
                                    acrossBoardDependency.remove("isArchive");
                                    this.enrichJiraAcrossBoardDependency(sessionBoardObj.getSession(), acrossBoardDependency, item7, itemWithDatesMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, itemId, itemEntry, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                    itemEntry.setValue(acrossBoardDependency);
                                    continue;
                                }
                            }
                            String dependencyId = dependencyMap.get("dependencyId").toString();
                            JiraItemKey jiraItemKey = new JiraItemKey(dependencyId, jiraKey);
                            dependencyMap.put("isArchive", true);
                            dependencyMap.put("dependencyType", "");
                            missingItems.put(jiraItemKey, dependencyMap);
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)item7)) {
                            String targetSessionId2;
                            if (PropertyValidator.isValid(dependencyMap.get("targetSessionId")) && PropertyValidator.isValid((Object)(targetSessionId2 = (String)dependencyMap.get("targetSessionId"))) && targetSessionId2.equalsIgnoreCase(boardSessionId)) continue;
                            if (PropertyValidator.isValid((Collection)item7.getSessionBoards()) && !item7.getSessionBoards().isEmpty() || epicLinkedSession != null) {
                                String sessionBoardId;
                                SessionBoard sessionBoard10;
                                if (PropertyValidator.isValid((Object)epicLinkedSession)) {
                                    if (!epicLinkedSession.getActiveSessionBoard().equalsIgnoreCase(piBoard)) {
                                        this.enrichJiraAcrossBoardDependency(epicLinkedSession, dependencyMap, item7, itemWithDatesMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, itemId, itemEntry, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                        continue;
                                    }
                                } else if (PropertyValidator.isValid((Collection)item7.getSessionBoards()) && PropertyValidator.isValid((Object)(sessionBoard10 = (SessionBoard)sessionBoardMap.get(sessionBoardId = ((SessionBoard)item7.getSessionBoards().get(0)).getId())))) {
                                    sessionMap.put(sessionBoard10.getSession().getId(), sessionBoard10.getSession());
                                    if (!sessionBoard10.getId().equalsIgnoreCase(piBoard)) {
                                        this.enrichJiraAcrossBoardDependency(sessionBoard10.getSession(), dependencyMap, item7, itemWithDatesMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, itemId, itemEntry, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                        continue;
                                    }
                                }
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("sourceSessionId")) || !PropertyValidator.isValid(dependencyMap.get("targetSessionId"))) continue;
                            sourceSessionId = (String)dependencyMap.get("sourceSessionId");
                            targetSessionId = (String)dependencyMap.get("targetSessionId");
                            if (!PropertyValidator.isValid((Object)sourceSessionId) || !PropertyValidator.isValid((Object)targetSessionId) || sourceSessionId.equalsIgnoreCase(targetSessionId)) continue;
                            targetSession = (Session)sessionMap.get(targetSessionId);
                            this.enrichJiraAcrossBoardDependency(targetSession, dependencyMap, item7, itemWithDatesMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, itemId, itemEntry, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)item7) && PropertyValidator.isValid(dependencyMap.get("sourceSessionId")) && PropertyValidator.isValid(dependencyMap.get("targetSessionId"))) {
                            sourceSessionId = (String)dependencyMap.get("sourceSessionId");
                            targetSessionId = (String)dependencyMap.get("targetSessionId");
                            if (PropertyValidator.isValid((Object)sourceSessionId) && PropertyValidator.isValid((Object)targetSessionId) && !sourceSessionId.equalsIgnoreCase(targetSessionId)) {
                                targetSession = (Session)sessionMap.get(targetSessionId);
                                this.enrichJiraAcrossBoardDependency(targetSession, dependencyMap, item7, itemWithDatesMap, items, containerMap, piBoardMap, acrossBoardDependencies, iterator, itemId, itemEntry, epicLinkedContainersMap, sessionMap, tenant, teamContainerMap);
                                continue;
                            }
                        }
                        LOGGER.debug("Item with ID :{} not found, removing it from dependencies list. When looking in solution boards", (Object)itemId);
                        if (LINK_TYPE_KENDIS.equalsIgnoreCase(dependencyMap.get("linkType").toString())) {
                            if (PropertyValidator.isValid((Object)item7) && PropertyValidator.isValid((Collection)item7.getSessionBoards())) {
                                SessionBoard sessionBoard9 = (SessionBoard)item7.getSessionBoards().get(0);
                                solutionLinkedSessionIds = (Set)solutionBoardWithPiBoard.get(solutionBoardId);
                                if (PropertyValidator.isValid((Collection)solutionLinkedSessionIds) && solutionLinkedSessionIds.contains(sessionBoard9.getId())) continue;
                            }
                            LOGGER.debug("Item is not linked to solution board with ID :{}, removing it from dependencies list", (Object)solutionBoardId);
                            iterator.remove();
                            continue;
                        }
                        if (!LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap.get("linkType").toString()) || dependencyMap.containsKey("isSolutionOnly")) continue;
                        if (PropertyValidator.isValid((Object)item7) && PropertyValidator.isValid((Collection)item7.getSessionBoards())) {
                            SessionBoard sessionBoard3 = (SessionBoard)item7.getSessionBoards().get(0);
                            solutionLinkedSessionIds = (Set)solutionBoardWithPiBoard.get(solutionBoardId);
                            if (PropertyValidator.isValid((Collection)solutionLinkedSessionIds) && solutionLinkedSessionIds.contains(sessionBoard3.getId())) continue;
                        }
                        if (!LINK_TYPE_ALM.equalsIgnoreCase(dependencyMap.get("linkOrigin").toString())) continue;
                        String dependencyId = dependencyMap.get("dependencyId").toString();
                        JiraItemKey jiraItemKey = new JiraItemKey(dependencyId, jiraKey);
                        dependencyMap.put("isArchive", true);
                        dependencyMap.put("dependencyType", "");
                        missingItems.put(jiraItemKey, dependencyMap);
                    }
                }
                SolutionBoard solutionBoard = solutionBoards.stream().filter(s -> s.getId().equals(solutionBoardId)).findFirst().get();
                piBoardWithDependencies.put("boardTitle", solutionBoard.getTitle());
                piBoardWithDependencies.put("acrossBoardDependencies", acrossBoardDependencies);
                solutionBoardWithDependenciesMap.put(solutionBoardId, piBoardWithDependencies);
            }
            long solutionBoardsEnd = System.currentTimeMillis();
            LOGGER.debug("Processed solution boards in {} ms", (Object)(solutionBoardsEnd - solutionBoardsStart));
        }
        long solutionBoardWithDependenciesStart = System.currentTimeMillis();
        for (Object v : solutionBoardWithDependenciesMap.values()) {
            Map solutionBoardDependenciesMap = (Map)v;
            Map acrossBoardDependencies = (Map)solutionBoardDependenciesMap.get("acrossBoardDependencies");
            if (PropertyValidator.isValid((Object)acrossBoardDependencies)) {
                for (Map.Entry entry : solutionBoardDependenciesMap.entrySet()) {
                    Map piBoardWithDependenciesMap;
                    if (!((String)entry.getKey()).matches("^[a-fA-F0-9]{24}$") || !PropertyValidator.isValid((piBoardWithDependenciesMap = (Map)entry.getValue()).get("dependencies"))) continue;
                    Map itemWithDependencies3 = (Map)piBoardWithDependenciesMap.get("dependencies");
                    Iterator iterator = itemWithDependencies3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry itemEntry = iterator.next();
                        String itemId = (String)itemEntry.getKey();
                        Map dependencyMap3 = (Map)itemEntry.getValue();
                        Object targetKey = null;
                        if (PropertyValidator.isValid(dependencyMap3.get("targetKey"))) {
                            targetKey = (String)dependencyMap3.get("targetKey");
                        }
                        if (!acrossBoardDependencies.containsKey(itemId) && !acrossBoardDependencies.containsKey(targetKey)) continue;
                        iterator.remove();
                        LOGGER.debug("Found item id :{} in acrossBoardDependencies list, removing it against pi board", (Object)itemId);
                    }
                }
            }
            for (Map.Entry solutionBoardEntry : solutionBoardWithDependenciesMap.entrySet()) {
                Map solutionBoardEntryVal = (Map)solutionBoardEntry.getValue();
                for (Map.Entry entry : solutionBoardEntryVal.entrySet()) {
                    if (!((String)entry.getKey()).matches("^[a-fA-F0-9]{24}$")) continue;
                    Map piBoardWithDependenciesMap = (Map)entry.getValue();
                    itemWithDependencies = (Map)piBoardWithDependenciesMap.get("dependencies");
                    HashMap<String, Map> consolidatedDependencies = new HashMap<String, Map>();
                    for (Map.Entry dependencyEntry : itemWithDependencies.entrySet()) {
                        String dependencyKey = (String)dependencyEntry.getKey();
                        dependencyMap = (Map)dependencyEntry.getValue();
                        String targetKey = (String)dependencyMap.get("targetKey");
                        if (PropertyValidator.isValid((Object)targetKey)) {
                            String oldOrigin;
                            String newOrigin;
                            boolean isArchiveExisting;
                            boolean isArchiveNew;
                            boolean isDepDep;
                            Set epicLinkedSolutionBoards;
                            if (PropertyValidator.isValid(epicLinkedSolutionBoardsMap) && epicLinkedSolutionBoardsMap.containsKey(targetKey) && PropertyValidator.isValid((Collection)(epicLinkedSolutionBoards = (Set)epicLinkedSolutionBoardsMap.get(targetKey))) && !epicLinkedSolutionBoards.contains(solutionBoardEntry.getKey())) {
                                dependencyMap.put("isArchive", true);
                            }
                            if (!consolidatedDependencies.containsKey(targetKey)) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                continue;
                            }
                            Map existingDependency = (Map)consolidatedDependencies.get(targetKey);
                            String existingSessionBoardId = (String)existingDependency.get("sessionBoardId");
                            String newSessionBoardId = (String)dependencyMap.get("sessionBoardId");
                            String fetchedType = String.valueOf(existingDependency.get("type"));
                            String depType = String.valueOf(dependencyMap.get("type"));
                            boolean isFetchedRelated = "Relates to".equalsIgnoreCase(fetchedType);
                            boolean isFetchedDep = !isFetchedRelated;
                            boolean isDepRelated = "Relates to".equalsIgnoreCase(depType);
                            boolean bl = isDepDep = !isDepRelated;
                            if (isFetchedRelated && isDepDep || isDepRelated && isFetchedDep) {
                                consolidatedDependencies.put(targetKey + "R", dependencyMap);
                                continue;
                            }
                            if (PropertyValidator.isValid((Object)newSessionBoardId) && PropertyValidator.isValid((Object)existingSessionBoardId) && newSessionBoardId.equalsIgnoreCase(existingSessionBoardId)) {
                                isArchiveNew = dependencyMap.getOrDefault("isArchive", false);
                                isArchiveExisting = existingDependency.getOrDefault("isArchive", false);
                                if (isArchiveNew && !isArchiveExisting) {
                                    consolidatedDependencies.put(targetKey, existingDependency);
                                    LOGGER.debug("Keeping new dependency for targetKey: {} as it is an archive", (Object)targetKey);
                                    continue;
                                }
                                if (isArchiveExisting && !isArchiveNew) {
                                    consolidatedDependencies.put(targetKey, dependencyMap);
                                    LOGGER.debug("Keeping existing dependency for targetKey: {} as it is an archive", (Object)targetKey);
                                    continue;
                                }
                                if (isArchiveNew || isArchiveExisting) continue;
                                newOrigin = (String)dependencyMap.get("linkOrigin");
                                oldOrigin = (String)existingDependency.get("linkOrigin");
                                if (LINK_TYPE_KENDIS.equalsIgnoreCase(oldOrigin) && LINK_TYPE_ALM.equalsIgnoreCase(newOrigin)) {
                                    consolidatedDependencies.put(targetKey, existingDependency);
                                    continue;
                                }
                                if (!LINK_TYPE_ALM.equalsIgnoreCase(oldOrigin) || !LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) continue;
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                continue;
                            }
                            if (((String)entry.getKey()).equalsIgnoreCase(existingSessionBoardId)) {
                                consolidatedDependencies.put(targetKey, existingDependency);
                                continue;
                            }
                            if (((String)entry.getKey()).equalsIgnoreCase(newSessionBoardId)) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                LOGGER.debug("Keeping new dependency for targetKey: {} as it belongs to the same solution board", (Object)targetKey);
                                continue;
                            }
                            isArchiveNew = dependencyMap.getOrDefault("isArchive", false);
                            isArchiveExisting = existingDependency.getOrDefault("isArchive", false);
                            newOrigin = (String)dependencyMap.get("linkOrigin");
                            oldOrigin = (String)existingDependency.get("linkOrigin");
                            if (LINK_TYPE_KENDIS.equalsIgnoreCase(oldOrigin) && LINK_TYPE_ALM.equalsIgnoreCase(newOrigin)) {
                                consolidatedDependencies.put(targetKey, existingDependency);
                                continue;
                            }
                            if (LINK_TYPE_ALM.equalsIgnoreCase(oldOrigin) && LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                continue;
                            }
                            if (isArchiveNew && !isArchiveExisting) {
                                consolidatedDependencies.put(targetKey, dependencyMap);
                                LOGGER.debug("Keeping new dependency for targetKey: {} as it is an archive", (Object)targetKey);
                                continue;
                            }
                            if (!isArchiveExisting || isArchiveNew) continue;
                            consolidatedDependencies.put(targetKey, existingDependency);
                            LOGGER.debug("Keeping existing dependency for targetKey: {} as it is an archive", (Object)targetKey);
                            continue;
                        }
                        String targetItemId = (String)dependencyMap.get("targetItemId");
                        if (PropertyValidator.isValid((Object)targetItemId)) {
                            if (!consolidatedDependencies.containsKey(targetItemId)) {
                                consolidatedDependencies.put(targetItemId, dependencyMap);
                                continue;
                            }
                            LOGGER.debug("Removing duplicate dependency for targetItemId: {}", (Object)targetItemId);
                            continue;
                        }
                        consolidatedDependencies.put(dependencyKey, dependencyMap);
                    }
                    piBoardWithDependenciesMap.put("dependencies", consolidatedDependencies);
                }
            }
        }
        long solutionBoardWithDependenciesEnd = System.currentTimeMillis();
        LOGGER.debug("Consolidated dependencies for solution boards in {} ms", (Object)(solutionBoardWithDependenciesEnd - solutionBoardWithDependenciesStart));
        for (Object piBoardWithDependencies : boardWithDependenciesMap.values()) {
            Map piBoardWithDependenciesMap = (Map)piBoardWithDependencies;
            if (!PropertyValidator.isValid(piBoardWithDependenciesMap.get("dependencies"))) continue;
            Map itemWithDependencies4 = (Map)piBoardWithDependenciesMap.get("dependencies");
            HashMap<String, Map> consolidatedDependencies = new HashMap<String, Map>();
            for (Map.Entry dependencyEntry : itemWithDependencies4.entrySet()) {
                String dependencyKey = (String)dependencyEntry.getKey();
                Map dependencyMap4 = (Map)dependencyEntry.getValue();
                String targetKey = (String)dependencyMap4.get("targetKey");
                String sourceKey = (String)dependencyMap4.get("sourceKey");
                if (PropertyValidator.isValid((Object)targetKey)) {
                    boolean isSolutionNew;
                    boolean isSolutionExisting;
                    boolean isDepDep;
                    if (!consolidatedDependencies.containsKey(targetKey)) {
                        consolidatedDependencies.put(targetKey, dependencyMap4);
                        continue;
                    }
                    LOGGER.debug("Removing duplicate dependency for targetKey: {}", (Object)targetKey);
                    Map existingDependency = (Map)consolidatedDependencies.get(targetKey);
                    String fetchedType = String.valueOf(existingDependency.get("type"));
                    String depType = String.valueOf(dependencyMap4.get("type"));
                    boolean isFetchedRelated = "Relates to".equalsIgnoreCase(fetchedType);
                    boolean isFetchedDep = !isFetchedRelated;
                    boolean isDepRelated = "Relates to".equalsIgnoreCase(depType);
                    boolean bl = isDepDep = !isDepRelated;
                    if (isFetchedRelated && isDepDep || isDepRelated && isFetchedDep) {
                        consolidatedDependencies.put(targetKey + "R", dependencyMap4);
                        continue;
                    }
                    String existingSessionBoardId = (String)existingDependency.get("sessionBoardId");
                    String newSessionBoardId = (String)dependencyMap4.get("sessionBoardId");
                    if (PropertyValidator.isValid((Object)newSessionBoardId) && PropertyValidator.isValid((Object)existingSessionBoardId) && newSessionBoardId.equalsIgnoreCase(existingSessionBoardId)) {
                        isSolutionExisting = existingDependency.getOrDefault("isSolutionOnly", false);
                        isSolutionNew = dependencyMap4.getOrDefault("isSolutionOnly", false);
                        if (!isSolutionNew && isSolutionExisting) {
                            consolidatedDependencies.put(targetKey, dependencyMap4);
                            continue;
                        }
                        boolean isArchiveNew = dependencyMap4.getOrDefault("isArchive", false);
                        boolean isArchiveExisting = existingDependency.getOrDefault("isArchive", false);
                        if (isArchiveNew && !isArchiveExisting) {
                            consolidatedDependencies.put(targetKey, existingDependency);
                            LOGGER.debug("Keeping new dependency for targetKey: {} as it is an archive", (Object)targetKey);
                            continue;
                        }
                        if (isArchiveExisting && !isArchiveNew) {
                            consolidatedDependencies.put(targetKey, dependencyMap4);
                            LOGGER.debug("Keeping existing dependency for targetKey: {} as it is an archive", (Object)targetKey);
                            continue;
                        }
                        String newOrigin = (String)dependencyMap4.get("linkOrigin");
                        String oldOrigin = (String)existingDependency.get("linkOrigin");
                        if (LINK_TYPE_KENDIS.equalsIgnoreCase(oldOrigin) && LINK_TYPE_ALM.equalsIgnoreCase(newOrigin)) {
                            consolidatedDependencies.put(targetKey, existingDependency);
                            continue;
                        }
                        if (!LINK_TYPE_ALM.equalsIgnoreCase(oldOrigin) || !LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) continue;
                        consolidatedDependencies.put(targetKey, dependencyMap4);
                        continue;
                    }
                    isSolutionExisting = existingDependency.getOrDefault("isSolutionOnly", false);
                    isSolutionNew = dependencyMap4.getOrDefault("isSolutionOnly", false);
                    if (!isSolutionNew && isSolutionExisting) {
                        consolidatedDependencies.put(targetKey, dependencyMap4);
                        continue;
                    }
                    LOGGER.debug("Keeping existing dependency for targetKey: {} as it is solution only", (Object)targetKey);
                    continue;
                }
                String targetItemId = (String)dependencyMap4.get("targetItemId");
                if (PropertyValidator.isValid((Object)targetItemId)) {
                    if (!consolidatedDependencies.containsKey(targetItemId)) {
                        consolidatedDependencies.put(targetItemId, dependencyMap4);
                        continue;
                    }
                    LOGGER.debug("Removing duplicate dependency for targetItemId: {}", (Object)targetItemId);
                    continue;
                }
                consolidatedDependencies.put(dependencyKey, dependencyMap4);
            }
            piBoardWithDependenciesMap.put("dependencies", consolidatedDependencies);
        }
        solutionBoardWithPiBoardMap.put("solutionBoardWithDependenciesMap", solutionBoardWithDependenciesMap);
        LOGGER.debug("Merging dependencies for the same PI board");
        long mergeStart = System.currentTimeMillis();
        LOGGER.debug("Consolidated dependencies for PI boards and solution boards in time {} ms", (Object)(mergeStart - solutionBoardWithDependenciesEnd));
        Map mergedBoardWithDependenciesMap = this.mergeDependenciesForSamePiBoard(boardWithDependenciesMap);
        long mergeEnd = System.currentTimeMillis();
        LOGGER.debug("Merging completed in {} ms", (Object)(mergeEnd - mergeStart));
        LOGGER.debug("Sorting board with dependencies by creation date");
        long sortStart = System.currentTimeMillis();
        Map sortedBoardWithDependenciesMap = this.sortBoardWithDependenciesByCreationDate(mergedBoardWithDependenciesMap);
        long sortEnd = System.currentTimeMillis();
        LOGGER.debug("Sorting completed in {} ms", (Object)(sortEnd - sortStart));
        if (PropertyValidator.isValid(solutionBoards)) {
            response.put("solutionBoardWithPiBoardMap", solutionBoardWithPiBoardMap);
        }
        response.put("boardWithDependenciesMap", sortedBoardWithDependenciesMap);
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.debug("Successfully completed fetchDependencies for Jira Key: {} in {} ms", (Object)jiraKey, (Object)totalTime);
        return response;
    }

    private Company fetchAndValidateCompany(String companyPrefix) throws Exception {
        LOGGER.debug("Fetching company for prefix: {}", (Object)companyPrefix);
        Company company = this.companyRepository.findByUrlPrefix(companyPrefix);
        if (!PropertyValidator.isValid((Object)company)) {
            String errorMsg = "Company not found for prefix: " + companyPrefix;
            LOGGER.error(errorMsg);
            throw new Exception(errorMsg);
        }
        LOGGER.debug("Found company: {} for prefix: {}", (Object)company.getId(), (Object)companyPrefix);
        return company;
    }

    private String extractTfsId(Map<String, Object> workItemData) throws Exception {
        if (PropertyValidator.isValid(workItemData) && workItemData.containsKey("id")) {
            String jiraKey = String.valueOf(workItemData.get("id"));
            LOGGER.debug("Extracted TFS ID: {}", (Object)jiraKey);
            return jiraKey;
        }
        return null;
    }

    private List<Item> fetchJiraItemsForWorkItem(String jiraKey, String tenant, Set<String> teamContainerIds, Set<String> sessionBoardIds, String jiraURL) throws Exception {
        LOGGER.debug("Fetching items for TFS ID: {} in tenant: {}", (Object)jiraKey, (Object)tenant);
        BasicDBObject where = new BasicDBObject();
        where.append("jiraKey", (Object)jiraKey);
        if (PropertyValidator.isValid((Object)tenant)) {
            where.append("tenant", (Object)tenant);
        }
        List pipe = this.buildItemAggregationPipeline(where);
        List items = this.executeItemAggregation(pipe, teamContainerIds, sessionBoardIds);
        ArrayList<Item> filteredItems = new ArrayList();
        if (PropertyValidator.isValid((Collection)items) && PropertyValidator.isValid((Object)jiraURL)) {
            for (Item item : items) {
                String self;
                Map issueType;
                Map jiraFieldByKey = item.getJiraFieldByKey();
                if (!PropertyValidator.isValid((Object)jiraFieldByKey) || !jiraFieldByKey.containsKey("issuetype") || !PropertyValidator.isValid((Object)(issueType = (Map)jiraFieldByKey.get("issuetype"))) || !(self = (String)issueType.get("self")).startsWith(jiraURL)) continue;
                filteredItems.add(item);
            }
        } else {
            filteredItems = items;
        }
        LOGGER.debug("Found {} items for JiraKey: {} with eager loaded relationships", (Object)items.size(), (Object)jiraKey);
        return filteredItems;
    }

    private Map<String, Object> buildDependenciesForJiraItem(Item item, SessionBoard sessionBoard, Map<String, Date> itemWithDatesMap, Set<String> dependencyItems, Set<String> containerIds, Map<JiraItemKey, Object> missingItems, String tenant, Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, Set<String> teamContainerIds, Map<String, Object> boardWithLinkTypesMap, Map<String, Object> almDependenciesMap, Set<String> sessionBoardIds, Map<String, Conversation> conversationMap) throws Exception {
        LOGGER.debug("Building dependencies for item: {} on session board: {}", (Object)item.getJiraKey(), (Object)sessionBoard.getId());
        long startTime = System.currentTimeMillis();
        ConcurrentHashMap<String, Object> itemDependenciesMap = new ConcurrentHashMap<String, Object>();
        HashSet linkedJiraKeys = new HashSet();
        this.processJiraKendisDependencies(item, itemDependenciesMap, dependencyItems, sessionBoard, linkedJiraKeys, containerIds, itemLinkMap, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, tenant, teamContainerIds, boardWithLinkTypesMap, conversationMap);
        this.processJiraAlmDependencies(item, sessionBoard, itemDependenciesMap, dependencyItems, linkedJiraKeys, missingItems, tenant, itemJiraDependencyMap, teamContainerMap, sessionBoardMap, teamContainerIds, containerIds, boardWithLinkTypesMap, almDependenciesMap, sessionBoardIds, conversationMap);
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Built dependencies for item: {} in {} ms, found {} dependencies", new Object[]{item.getJiraKey(), endTime - startTime, itemDependenciesMap.size()});
        return itemDependenciesMap;
    }

    private void processJiraKendisDependencies(Item item, Map<String, Object> itemDependenciesMap, Set<String> dependencyItems, SessionBoard sessionBoard, Set<String> linkedJiraKeys, Set<String> containerIds, Map<String, ItemLink> itemLinkMap, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, String tenant, Set<String> teamContainerIds, Map<String, Object> boardWithLinkTypesMap, Map<String, Conversation> conversationMap) throws Exception {
        List targetItemLinks;
        String name;
        LOGGER.debug("Processing Kendis dependencies for item: {}", (Object)item.getJiraKey());
        long startTime = System.currentTimeMillis();
        HashSet<String> fetchedDependencies = new HashSet<String>();
        if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
            for (ItemLink itemLinkRef : item.getItemLinks()) {
                Object jiraLinkType;
                String linkTypeId;
                Object attribute;
                ItemLink itemLink = itemLinkMap.get(itemLinkRef.getId());
                if (itemLink == null) {
                    LOGGER.warn("ItemLink not found in map for ID: {}", (Object)itemLinkRef.getId());
                    continue;
                }
                if (!PropertyValidator.isValid((Object)itemLink.getType())) continue;
                HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
                if (PropertyValidator.isValid((Object)itemLink.getResponsible())) {
                    User responsible = itemLink.getResponsible();
                    LOGGER.debug("Found responsible user: {} against itemLink :{} ", (Object)responsible.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("responsibleUserId", responsible.getId());
                    dependencyMap.put("responsibleUserName", responsible.getUserName());
                    dependencyMap.put("responsibleFullName", responsible.getFullName());
                    dependencyMap.put("responsibleImage", responsible.getPicturePath());
                }
                if (PropertyValidator.isValid((Object)itemLink.getReporter())) {
                    User reporter = itemLink.getReporter();
                    LOGGER.debug("Found reporter user: {} against itemLink :{} ", (Object)reporter.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("reporterUserId", reporter.getId());
                    dependencyMap.put("reporterUserName", reporter.getUserName());
                    dependencyMap.put("reporterFullName", reporter.getFullName());
                    dependencyMap.put("reporterImage", reporter.getPicturePath());
                }
                dependencyMap.put("customId", itemLink.getCustomId());
                this.addCommentsToDependency(dependencyMap, itemLink.getConversations(), conversationMap);
                dependencyMap.put("type", itemLink.getType());
                dependencyMap.put("targetKey", itemLink.getTargetJiraId());
                linkedJiraKeys.add(itemLink.getTargetJiraId());
                fetchedDependencies.add(itemLink.getId());
                dependencyMap.put("sourceTeamContainerId", itemLink.getSourceTeamContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceTeamContainerId())) {
                    teamContainerIds.add(itemLink.getSourceTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) {
                    teamContainerIds.add(itemLink.getTargetTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getSourceContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                dependencyMap.put("targetTeamContainerId", itemLink.getTargetTeamContainerId());
                dependencyMap.put("sourceContainerId", itemLink.getSourceContainerId());
                dependencyMap.put("targetContainerId", itemLink.getTargetContainerId());
                dependencyMap.put("sessionBoardId", itemLink.getSessionBoardId());
                dependencyMap.put("sourceSessionId", itemLink.getSourceSessionId());
                dependencyMap.put("targetSessionId", itemLink.getTargetSessionId());
                dependencyMap.put("sourceKey", item.getJiraKey());
                dependencyMap.put("description", itemLink.getDescription());
                dependencyMap.put("sourceBoardTitle", sessionBoard.getSession().getTitle());
                if (PropertyValidator.isValid((Object)itemLink.getWfStatus())) {
                    dependencyMap.put("dependencyStatus", itemLink.getWfStatus().getTitle());
                    dependencyMap.put("dependencyStatusCategory", itemLink.getWfStatus().getCategory());
                }
                dependencyMap.put("richDescription", itemLink.getRichDescription());
                dependencyMap.put("dueDate", itemLink.getDueDate());
                dependencyMap.put("dependencyId", itemLink.getId());
                dependencyMap.put("solutionId", itemLink.getSolutionId());
                dependencyMap.put("raisedOn", itemLink.getRaisedOn());
                dependencyMap.put("linkOrigin", LINK_TYPE_KENDIS);
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    dependencyMap.put("targetItemId", itemLink.getTargetUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    dependencyMap.put("targetItemId", itemLink.getTargetFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    dependencyMap.put("targetItemId", itemLink.getTargetItemId());
                } else {
                    LOGGER.debug("No target item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    dependencyMap.put("sourceItemId", itemLink.getSourceUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    dependencyMap.put("sourceItemId", itemLink.getSourceFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceItemId())) {
                    dependencyMap.put("sourceItemId", itemLink.getSourceItemId());
                } else {
                    LOGGER.debug("No source item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (!PropertyValidator.isValid(dependencyMap.get("targetItemId"))) {
                    LOGGER.debug("No target item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                dependencyItems.add(dependencyMap.get("targetItemId").toString());
                dependencyItems.add(item.getId());
                itemDependenciesMap.put(dependencyMap.get("targetItemId").toString(), dependencyMap);
                if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                    dependencyMap.put("isSolutionOnly", true);
                }
                if ((attribute = (Map)boardWithLinkTypesMap.get(linkTypeId = ((String)(jiraLinkType = itemLink.getType())).split("-")[0])) != null) {
                    String id = (String)attribute.get("id");
                    if (linkTypeId.equalsIgnoreCase(id)) {
                        if (((String)jiraLinkType).split("-").length > 1) {
                            String direction = ((String)jiraLinkType).split("-")[1];
                            if (direction.equalsIgnoreCase("IN")) {
                                String inward = (String)attribute.get("inward");
                                dependencyMap.put("type", inward);
                                dependencyMap.put("arrowDirection", "forward");
                            } else {
                                String outward = (String)attribute.get("outward");
                                dependencyMap.put("type", outward);
                                dependencyMap.put("arrowDirection", "reverse");
                            }
                        } else {
                            dependencyMap.put("type", (String)attribute.get("inward"));
                        }
                    } else if (id == null && PropertyValidator.isValid(attribute.get("referenceName")) && linkTypeId.equalsIgnoreCase(attribute.get("referenceName").toString())) {
                        name = (String)attribute.get("name");
                        dependencyMap.put("type", name);
                    }
                } else if (((String)jiraLinkType).equalsIgnoreCase(linkTypeId) && PropertyValidator.isValid((Object)itemLink.getLineDirection()) && "Forward".equalsIgnoreCase(itemLink.getLineDirection())) {
                    dependencyMap.put("type", jiraLinkType);
                    dependencyMap.put("shouldReverse", true);
                }
                if ("Depends On".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Dependent on".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated With".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated By".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Is Blocking".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Blocked By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                    dependencyMap.put("linkType", LINK_TYPE_KENDIS);
                    continue;
                }
                dependencyMap.put("linkType", LINK_TYPE_ALM);
            }
        }
        if (PropertyValidator.isValid((Collection)(targetItemLinks = this.fetchTargetItemLinksWithAggregation(item.getId(), tenant)))) {
            HashSet<String> conversationIds = new HashSet<String>();
            for (Object link : targetItemLinks) {
                if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
                for (Conversation c : link.getConversations()) {
                    if (!PropertyValidator.isValid((Object)c) || !PropertyValidator.isValid((Object)c.getId())) continue;
                    conversationIds.add(c.getId());
                }
            }
            if (!conversationIds.isEmpty()) {
                conversationMap.putAll(this.fetchConversationsByIds(conversationIds));
                HashSet<String> userIds = new HashSet<String>();
                for (ItemLink link : targetItemLinks) {
                    if (!PropertyValidator.isValid((Collection)link.getConversations())) continue;
                    ArrayList<Conversation> updated = new ArrayList<Conversation>();
                    for (Conversation c : link.getConversations()) {
                        Conversation full;
                        Conversation conversation = full = PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getId()) ? conversationMap.get(c.getId()) : null;
                        if (PropertyValidator.isValid(full)) {
                            if (PropertyValidator.isValid((Object)full.getUser()) && PropertyValidator.isValid((Object)full.getUser().getId())) {
                                userIds.add(full.getUser().getId());
                            }
                            updated.add(full);
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)c) && PropertyValidator.isValid((Object)c.getUser()) && PropertyValidator.isValid((Object)c.getUser().getId())) {
                            userIds.add(c.getUser().getId());
                        }
                        updated.add(c);
                    }
                    link.setConversations(updated);
                }
            }
            for (ItemLink itemLink : targetItemLinks) {
                if (!PropertyValidator.isValid((Object)itemLink.getType()) || fetchedDependencies.contains(itemLink.getId()) && linkedJiraKeys.contains(itemLink.getSourceJiraId()) || PropertyValidator.isValid((Object)itemLink.getTargetFeatureId()) && !itemLink.getTargetFeatureId().equals(item.getId()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && !itemLink.getTargetUserStoryId().equals(item.getId()) || PropertyValidator.isValid((Object)itemLink.getTargetItemId()) && !itemLink.getTargetItemId().equals(item.getId()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && !itemLink.getTargetUserStoryId().equals(item.getId()) || PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId()) && !itemLink.getTargetUserStoryId().equals(item.getId()) || !PropertyValidator.isValid((Object)item.getSolutionBoard()) && PropertyValidator.isValid((Object)itemLink.getSessionBoardId()) && !sessionBoard.getId().equalsIgnoreCase(itemLink.getSessionBoardId()) && !sessionBoard.getSession().getId().equalsIgnoreCase(itemLink.getTargetSessionId()) || PropertyValidator.isValid((Object)itemLink.getSessionBoardId()) && itemLink.getSessionBoardId().equalsIgnoreCase(sessionBoard.getSession().getActiveSessionBoard()) && !PropertyValidator.isValid((Collection)item.getTeamContainers()) || PropertyValidator.isValid((Object)itemLink.getSourceItemId()) && itemDependenciesMap.get(itemLink.getSourceItemId()) != null) continue;
                HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
                this.addCommentsToDependency(dependencyMap, itemLink.getConversations(), conversationMap);
                if (PropertyValidator.isValid((Object)itemLink.getResponsible())) {
                    User responsible = itemLink.getResponsible();
                    LOGGER.debug("Found responsible user: {} against itemLink :{} ", (Object)responsible.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("responsibleUserId", responsible.getId());
                    dependencyMap.put("responsibleUserName", responsible.getUserName());
                    dependencyMap.put("responsibleFullName", responsible.getFullName());
                    dependencyMap.put("responsibleImage", responsible.getPicturePath());
                }
                if (PropertyValidator.isValid((Object)itemLink.getReporter())) {
                    User reporter = itemLink.getReporter();
                    LOGGER.debug("Found reporter user: {} against itemLink :{} ", (Object)reporter.getUserName(), (Object)itemLink.getId());
                    dependencyMap.put("reporterUserId", reporter.getId());
                    dependencyMap.put("reporterUserName", reporter.getUserName());
                    dependencyMap.put("reporterFullName", reporter.getFullName());
                    dependencyMap.put("reporterImage", reporter.getPicturePath());
                }
                dependencyMap.put("customId", itemLink.getCustomId());
                dependencyMap.put("reverseLink", true);
                dependencyMap.put("reverseDirection", true);
                dependencyMap.put("type", itemLink.getType());
                dependencyMap.put("linkOrigin", LINK_TYPE_KENDIS);
                dependencyMap.put("sourceBoardTitle", sessionBoard.getSession().getTitle());
                dependencyMap.put("targetKey", itemLink.getTargetJiraId());
                dependencyMap.put("sourceTeamContainerId", itemLink.getTargetTeamContainerId());
                dependencyMap.put("targetTeamContainerId", itemLink.getSourceTeamContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceTeamContainerId())) {
                    teamContainerIds.add(itemLink.getTargetTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) {
                    teamContainerIds.add(itemLink.getSourceTeamContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetContainerId())) {
                    containerIds.add(itemLink.getTargetContainerId());
                }
                linkedJiraKeys.add(itemLink.getSourceJiraId());
                if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                    dependencyMap.put("isSolutionOnly", true);
                }
                dependencyMap.put("targetContainerId", itemLink.getSourceContainerId());
                dependencyMap.put("sourceContainerId", itemLink.getTargetContainerId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId())) {
                    containerIds.add(itemLink.getSourceContainerId());
                    containerIds.add(itemLink.getTargetContainerId());
                }
                dependencyMap.put("sessionBoardId", itemLink.getSessionBoardId());
                dependencyMap.put("targetSessionId", itemLink.getSourceSessionId());
                dependencyMap.put("sourceSessionId", itemLink.getTargetSessionId());
                dependencyMap.put("sourceKey", item.getJiraKey());
                dependencyMap.put("description", itemLink.getDescription());
                dependencyMap.put("raisedOn", itemLink.getRaisedOn());
                if (PropertyValidator.isValid((Object)itemLink.getWfStatus())) {
                    dependencyMap.put("dependencyStatus", itemLink.getWfStatus().getTitle());
                    dependencyMap.put("dependencyStatusCategory", itemLink.getWfStatus().getCategory());
                }
                dependencyMap.put("richDescription", itemLink.getRichDescription());
                dependencyMap.put("dueDate", itemLink.getDueDate());
                dependencyMap.put("dependencyId", itemLink.getId());
                dependencyMap.put("solutionId", itemLink.getSolutionId());
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    dependencyMap.put("sourceItemId", itemLink.getTargetUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    dependencyMap.put("sourceItemId", itemLink.getTargetFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetItemId())) {
                    dependencyMap.put("sourceItemId", itemLink.getTargetItemId());
                } else {
                    LOGGER.debug("No source item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    dependencyMap.put("targetItemId", itemLink.getSourceUserStoryId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    dependencyMap.put("targetItemId", itemLink.getSourceFeatureId());
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceItemId())) {
                    dependencyMap.put("targetItemId", itemLink.getSourceItemId());
                } else {
                    LOGGER.debug("No source item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                if (!PropertyValidator.isValid(dependencyMap.get("targetItemId"))) {
                    LOGGER.debug("No target item found for itemLink: {}", (Object)itemLink.getId());
                    continue;
                }
                dependencyItems.add(dependencyMap.get("targetItemId").toString());
                dependencyItems.add(item.getId());
                itemDependenciesMap.put(dependencyMap.get("targetItemId").toString(), dependencyMap);
                String jiraLinkType = itemLink.getType();
                String linkTypeId = jiraLinkType.split("-")[0];
                Map attribute = (Map)boardWithLinkTypesMap.get(linkTypeId);
                if (attribute != null) {
                    String id = (String)attribute.get("id");
                    if (linkTypeId.equalsIgnoreCase(id)) {
                        if (jiraLinkType.split("-").length > 1) {
                            String direction = jiraLinkType.split("-")[1];
                            if (direction.equalsIgnoreCase("OUT")) {
                                String inward = (String)attribute.get("inward");
                                dependencyMap.put("type", inward);
                                dependencyMap.put("arrowDirection", "forward");
                            } else {
                                String outward = (String)attribute.get("outward");
                                dependencyMap.put("type", outward);
                                dependencyMap.put("arrowDirection", "reverse");
                            }
                        } else {
                            dependencyMap.put("type", attribute.get("inward"));
                        }
                    } else if (id == null && PropertyValidator.isValid(attribute.get("referenceName")) && linkTypeId.equalsIgnoreCase(attribute.get("referenceName").toString())) {
                        String name2 = (String)attribute.get("name");
                        dependencyMap.put("type", name2);
                    }
                }
                if (attribute == null) {
                    if (jiraLinkType.endsWith("-Forward")) {
                        jiraLinkType = jiraLinkType.substring(0, jiraLinkType.length() - "-Forward".length()) + "-Reverse";
                    } else if (jiraLinkType.endsWith("-Reverse")) {
                        jiraLinkType = jiraLinkType.substring(0, jiraLinkType.length() - "-Reverse".length()) + "-Forward";
                    }
                    attribute = (Map)boardWithLinkTypesMap.get(jiraLinkType);
                    if (PropertyValidator.isValid((Object)attribute)) {
                        Map attributes;
                        name = (String)attribute.get("name");
                        Map map = attributes = attribute.get("attributes") != null ? (Map)attribute.get("attributes") : null;
                        if (PropertyValidator.isValid((Object)attributes)) {
                            Boolean isForward = (Boolean)attributes.get("isForward");
                            if (PropertyValidator.isValid((Object)isForward) && isForward.booleanValue()) {
                                dependencyMap.put("arrowDirection", "reverse");
                            } else if ("Consumes From".equalsIgnoreCase(name) || "Predecessor".equalsIgnoreCase(name)) {
                                dependencyMap.put("arrowDirection", "forward");
                            } else {
                                dependencyMap.put("arrowDirection", "reverse");
                            }
                        }
                        if (PropertyValidator.isValid((Object)name)) {
                            dependencyMap.put("type", name);
                        }
                    } else {
                        this.reverseKendisDependencyType(dependencyMap);
                    }
                }
                if ("Depends On".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Dependent on".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated With".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Associated By".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Is Blocking".equalsIgnoreCase(dependencyMap.get("type").toString()) || "Blocked By".equalsIgnoreCase(dependencyMap.get("type").toString())) {
                    dependencyMap.put("linkType", LINK_TYPE_KENDIS);
                    continue;
                }
                dependencyMap.put("linkType", LINK_TYPE_ALM);
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Processed Kendis dependencies for item: {} in {} ms, found {} dependencies", new Object[]{item.getJiraKey(), endTime - startTime, fetchedDependencies.size()});
    }

    private void processJiraAlmDependencies(Item item, SessionBoard sessionBoard, Map<String, Object> itemDependenciesMap, Set<String> dependencyItems, Set<String> linkedJiraKeys, Map<JiraItemKey, Object> missingItemsMap, String tenant, Map<String, ItemJiraDependency> itemJiraDependencyMap, Map<String, TeamContainer> teamContainerMap, Map<String, SessionBoard> sessionBoardMap, Set<String> teamContainerIds, Set<String> containerIds, Map<String, Object> boardWithLinkTypesMap, Map<String, Object> almDependenciesMap, Set<String> sessionBoardIds, Map<String, Conversation> conversationMap) throws Exception {
        LOGGER.debug("Processing ALM dependencies for item: {}", (Object)item.getJiraKey());
        long startTime = System.currentTimeMillis();
        if (!PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
            LOGGER.debug("No Jira dependencies found for item: {}", (Object)item.getJiraKey());
            return;
        }
        HashMap<String, Map> missingItemIdsDependencies = new HashMap<String, Map>();
        block0: for (ItemJiraDependency jiraDependencyRef : item.getJiraDependencies()) {
            ItemJiraDependency jiraDependency = itemJiraDependencyMap.get(jiraDependencyRef.getId());
            if (jiraDependency == null) {
                LOGGER.warn("ItemJiraDependency not found in map for ID: {}", (Object)jiraDependencyRef.getId());
                continue;
            }
            if (!PropertyValidator.isValid((Object)jiraDependency) || !PropertyValidator.isValid((Object)jiraDependency.getTargetJiraIssue())) continue;
            if (linkedJiraKeys.contains(jiraDependency.getTargetJiraIssue().getKey())) {
                for (Object dependency : itemDependenciesMap.values()) {
                    Map dependencyMap = (Map)dependency;
                    if (!jiraDependency.getTargetJiraIssue().getKey().equals(dependencyMap.get("targetKey")) && !jiraDependency.getTargetJiraIssue().getKey().equals(dependencyMap.get("sourceKey")) || !PropertyValidator.isValid(dependencyMap.get("type")) || !dependencyMap.get("type").toString().equalsIgnoreCase("Predecessor") && !dependencyMap.get("type").toString().equalsIgnoreCase("Successor") || !"Relates to".equalsIgnoreCase(jiraDependency.getLinkType().getInward()) && (!"Relates to".equalsIgnoreCase(jiraDependency.getLinkType().getOutward()) || !dependencyMap.get("type").toString().equalsIgnoreCase("Relates to"))) continue;
                    LOGGER.debug("Skipping ALM dependency as it already exists in itemDependenciesMap for item: {} and dependency : {}", (Object)item.getId(), (Object)jiraDependency.getId());
                    continue block0;
                }
            }
            Map dependencyMap = this.buildJiraAlmDependencyMap(jiraDependency, item, sessionBoard, linkedJiraKeys, teamContainerIds, containerIds, boardWithLinkTypesMap);
            this.addCommentsToDependency(dependencyMap, jiraDependency.getConversations(), conversationMap);
            if (PropertyValidator.isValid((Object)jiraDependency.getTargetItemId())) {
                if (itemDependenciesMap.containsKey(jiraDependency.getTargetItemId())) {
                    Map fetchedDependencyMap;
                    boolean shouldAdd = false;
                    if (PropertyValidator.isValid((Object)jiraDependency.getSessionBoardId()) && sessionBoard.getId().equalsIgnoreCase(jiraDependency.getSessionBoardId())) {
                        Map existingDependencyMap = (Map)itemDependenciesMap.get(jiraDependency.getTargetItemId());
                        if (existingDependencyMap.containsKey("sessionBoardId") && PropertyValidator.isValid(existingDependencyMap.get("sessionBoardId"))) {
                            if (!sessionBoard.getId().equalsIgnoreCase(existingDependencyMap.get("sessionBoardId").toString())) {
                                shouldAdd = true;
                            }
                        } else {
                            shouldAdd = true;
                        }
                    }
                    if (!shouldAdd && PropertyValidator.isValid((Object)(fetchedDependencyMap = (Map)itemDependenciesMap.get(jiraDependency.getTargetItemId())))) {
                        boolean isDepDep;
                        String fetchedType = String.valueOf(fetchedDependencyMap.get("type"));
                        String depType = String.valueOf(dependencyMap.get("type"));
                        boolean isFetchedRelated = "Relates to".equalsIgnoreCase(fetchedType);
                        boolean isFetchedDep = !isFetchedRelated;
                        boolean isDepRelated = "Relates to".equalsIgnoreCase(depType);
                        boolean bl = isDepDep = !isDepRelated;
                        if (isFetchedRelated && isDepDep || isDepRelated && isFetchedDep) {
                            shouldAdd = true;
                        } else {
                            almDependenciesMap.put(jiraDependency.getTargetItemId(), dependencyMap);
                        }
                    }
                    if (shouldAdd) {
                        if (PropertyValidator.isValid((Object)jiraDependency.getTargetItemId())) {
                            dependencyItems.add(jiraDependency.getTargetItemId());
                        }
                        if (PropertyValidator.isValid((Object)jiraDependency.getTargetJiraIssue())) {
                            itemDependenciesMap.put(jiraDependency.getTargetJiraIssue().getKey(), dependencyMap);
                        } else if (!itemDependenciesMap.containsKey(jiraDependency.getTargetItemId())) {
                            itemDependenciesMap.put(jiraDependency.getTargetItemId(), dependencyMap);
                            almDependenciesMap.put(jiraDependency.getTargetItemId(), dependencyMap);
                        }
                    }
                } else {
                    itemDependenciesMap.put(jiraDependency.getTargetItemId(), dependencyMap);
                }
                dependencyItems.add(jiraDependency.getSourceItemId());
                dependencyItems.add(jiraDependency.getTargetItemId());
                continue;
            }
            if (!PropertyValidator.isValid((Object)jiraDependency.getTargetJiraIssue())) continue;
            LOGGER.debug("Missing item Id against jiraKey: {}", (Object)jiraDependency.getTargetJiraIssue().getKey());
            missingItemIdsDependencies.put(jiraDependency.getTargetJiraIssue().getKey(), dependencyMap);
            String dependencyId = dependencyMap.get("dependencyId").toString();
            JiraItemKey jiraItemKey = new JiraItemKey(dependencyId, jiraDependency.getTargetJiraIssue().getKey());
            missingItemsMap.put(jiraItemKey, dependencyMap);
            itemDependenciesMap.put(jiraDependency.getTargetJiraIssue().getKey(), dependencyMap);
        }
        if (!missingItemIdsDependencies.isEmpty()) {
            Set missingTfsKeys = missingItemIdsDependencies.keySet();
            BasicDBObject where = new BasicDBObject();
            where.append("jiraKey", (Object)new BasicDBObject("$in", missingTfsKeys));
            where.append("tenant", (Object)tenant);
            List pipe = this.buildItemAggregationPipeline(where);
            List allDependentItems = this.executeItemAggregation(pipe, teamContainerIds, sessionBoardIds);
            if (PropertyValidator.isValid((Collection)allDependentItems)) {
                List missingItems = allDependentItems.stream().filter(i -> PropertyValidator.isValid((Collection)i.getSessionBoards()) && !i.getSessionBoards().isEmpty()).collect(Collectors.toList());
                LOGGER.debug("Found : {} items whose item ids were missing but dependency was present", (Object)missingItems.size());
                HashSet<String> foundTfsKeys = new HashSet<String>();
                for (Item missingItem : missingItems) {
                    Map missingItemMap = (Map)missingItemIdsDependencies.get(missingItem.getJiraKey());
                    if (PropertyValidator.isValid((Object)missingItemMap)) {
                        itemDependenciesMap.put(missingItem.getId(), missingItemMap);
                        dependencyItems.add(missingItem.getId());
                    }
                    foundTfsKeys.add(missingItem.getJiraKey());
                }
                for (String missingTfsKey : missingTfsKeys) {
                    if (foundTfsKeys.contains(missingTfsKey)) continue;
                    itemDependenciesMap.put(missingTfsKey, missingItemIdsDependencies.get(missingTfsKey));
                }
            }
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Processed ALM dependencies for item: {} in {} ms", (Object)item.getJiraKey(), (Object)(endTime - startTime));
    }

    private Map<String, Object> buildJiraAlmDependencyMap(ItemJiraDependency jiraDependency, Item item, SessionBoard sessionBoard, Set<String> linkedTfsKeys, Set<String> teamContainerIds, Set<String> containerIds, Map<String, Object> boardWithLinkTypesMap) throws Exception {
        Session session;
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> dependencyMap = new HashMap<String, Object>();
        JiraIssue targetJiraItem = jiraDependency.getTargetJiraIssue();
        if (item.getJiraKey().equalsIgnoreCase(targetJiraItem.getKey())) {
            dependencyMap.put("reverseAlm", true);
            String sourceItemId = jiraDependency.getSourceItemId();
            String targetItemId = jiraDependency.getTargetItemId();
            targetJiraItem = null;
            jiraDependency.setTargetItemId(sourceItemId);
            jiraDependency.setSourceItemId(targetItemId);
            jiraDependency.setTargetJiraIssue(null);
        }
        if (PropertyValidator.isValid((Object)jiraDependency.getResponsible())) {
            User responsible = jiraDependency.getResponsible();
            LOGGER.debug("Found responsible user: {} against jiraDependency :{} ", (Object)responsible.getUserName(), (Object)jiraDependency.getId());
            dependencyMap.put("responsibleUserId", responsible.getId());
            dependencyMap.put("responsibleUserName", responsible.getUserName());
            dependencyMap.put("responsibleFullName", responsible.getFullName());
            dependencyMap.put("responsibleImage", responsible.getPicturePath());
        }
        if (PropertyValidator.isValid((Object)jiraDependency.getReporter())) {
            User reporter = jiraDependency.getReporter();
            LOGGER.debug("Found reporter user: {} against itemLink :{} ", (Object)reporter.getUserName(), (Object)jiraDependency.getId());
            dependencyMap.put("reporterUserId", reporter.getId());
            dependencyMap.put("reporterUserName", reporter.getUserName());
            dependencyMap.put("reporterFullName", reporter.getFullName());
            dependencyMap.put("reporterImage", reporter.getPicturePath());
        }
        if (PropertyValidator.isValid((Object)sessionBoard.getSession()) && PropertyValidator.isValid((Collection)(session = sessionBoard.getSession()).getAlmConfigurations())) {
            List almConfigurations = session.getAlmConfigurations();
            for (AlmConfigurations almConfiguration : almConfigurations) {
                AlmAccount almAccount;
                if (!PropertyValidator.isValid((Object)almConfiguration.getAlmAccount()) || !PropertyValidator.isValid((Object)(almAccount = almConfiguration.getAlmAccount()).getId())) continue;
                dependencyMap.put("almAccount", almAccount);
            }
        }
        if (PropertyValidator.isValid((Object)targetJiraItem)) {
            dependencyMap.put("targetKey", targetJiraItem.getKey());
            if (PropertyValidator.isValid((Object)targetJiraItem.getFields())) {
                JiraIssueFields jiraIssueFields = targetJiraItem.getFields();
                dependencyMap.put("targetSummary", jiraIssueFields.getSummary());
                if (PropertyValidator.isValid((Object)jiraIssueFields.getIssuetype())) {
                    dependencyMap.put("targetIcon", jiraIssueFields.getIssuetype().getIconUrl());
                }
                if (PropertyValidator.isValid((Object)jiraIssueFields.getStatus())) {
                    JiraStatus jiraStatus = jiraIssueFields.getStatus();
                    dependencyMap.put("targetStatus", jiraStatus.getName());
                    if (PropertyValidator.isValid((Object)jiraStatus.getStatusCategory())) {
                        dependencyMap.put("targetStatusCategory", jiraStatus.getStatusCategory().getKey());
                    }
                }
            }
        }
        dependencyMap.put("sourceKey", item.getJiraKey());
        dependencyMap.put("linkType", LINK_TYPE_ALM);
        dependencyMap.put("linkOrigin", LINK_TYPE_ALM);
        dependencyMap.put("sourceItemId", jiraDependency.getSourceItemId());
        dependencyMap.put("targetItemId", jiraDependency.getTargetItemId());
        dependencyMap.put("sessionBoardId", jiraDependency.getSessionBoardId());
        dependencyMap.put("sourceBoardTitle", sessionBoard.getSession().getTitle());
        dependencyMap.put("description", jiraDependency.getDescription());
        dependencyMap.put("solutionId", jiraDependency.getSolutionId());
        dependencyMap.put("raisedOn", jiraDependency.getRaisedOn());
        if (PropertyValidator.isValid((Object)jiraDependency.getWfStatus())) {
            dependencyMap.put("dependencyStatus", jiraDependency.getWfStatus().getTitle());
            dependencyMap.put("dependencyStatusCategory", jiraDependency.getWfStatus().getCategory());
        }
        dependencyMap.put("richDescription", jiraDependency.getRichDescription());
        dependencyMap.put("dueDate", jiraDependency.getDueDate());
        dependencyMap.put("dependencyId", jiraDependency.getId());
        String jiraLinkType = jiraDependency.getLinkType().getName();
        String direction = jiraDependency.getDirection();
        if (dependencyMap.containsKey("reverseAlm")) {
            if ("IN".equalsIgnoreCase(direction)) {
                direction = "OUT";
            } else if ("OUT".equalsIgnoreCase(direction)) {
                direction = "IN";
            }
        }
        if ("OUT".equalsIgnoreCase(direction)) {
            dependencyMap.put("type", jiraDependency.getLinkType().getOutward());
            dependencyMap.put("arrowDirection", "reverse");
        } else {
            dependencyMap.put("type", jiraDependency.getLinkType().getInward());
            dependencyMap.put("arrowDirection", "forward");
        }
        if (PropertyValidator.isValid((Object)item.getSolutionBoard()) && !PropertyValidator.isValid((Object)jiraDependency.getSessionBoardId())) {
            dependencyMap.put("isSolutionOnly", true);
        } else if (PropertyValidator.isValid((Object)item.getSolutionBoard()) && PropertyValidator.isValid((Object)jiraDependency.getSolutionId())) {
            dependencyMap.put("isSolutionOnly", true);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Built alm dependency map for dependency: {} in {} ms", (Object)jiraDependency.getId(), (Object)(endTime - startTime));
        return dependencyMap;
    }

    private void fetchJiraMissingItems(Map<JiraItemKey, Object> dependencyItems) throws Exception {
        LOGGER.debug("Going to fetch missing items from Jira");
        HashSet<String> almAccountIds = new HashSet<String>();
        try {
            HashMap<AlmAccount, Map> almGroupedItems = new HashMap<AlmAccount, Map>();
            for (Map.Entry<JiraItemKey, Object> entry : dependencyItems.entrySet()) {
                Map dependencyMap = (Map)entry.getValue();
                AlmAccount almAccount = (AlmAccount)dependencyMap.get("almAccount");
                if (!PropertyValidator.isValid((Object)almAccount)) continue;
                Map almItemMap = almGroupedItems.getOrDefault(almAccount, new HashMap());
                String jiraKey = (String)dependencyMap.get("targetKey");
                if (PropertyValidator.isValid((Object)jiraKey)) {
                    LOGGER.debug("Adding item key: {} for almAccount: {}", (Object)jiraKey, (Object)almAccount.getName());
                    almItemMap.put(jiraKey, dependencyMap);
                    almGroupedItems.put(almAccount, almItemMap);
                    almAccountIds.add(almAccount.getId());
                }
                dependencyMap.remove("almAccount");
            }
            if (PropertyValidator.isValid(almGroupedItems) && !almGroupedItems.isEmpty()) {
                LOGGER.debug("Found {} ALM accounts with missing items", (Object)almGroupedItems.size());
                List almAccounts = this.almAccountRepository.findByIdIn(new ArrayList(almAccountIds));
                HashMap<String, AlmAccount> almAccountMap = new HashMap<String, AlmAccount>();
                if (PropertyValidator.isValid((Collection)almAccounts)) {
                    for (AlmAccount almAccount : almAccounts) {
                        almAccountMap.put(almAccount.getId(), almAccount);
                    }
                }
                for (Map.Entry entry : almGroupedItems.entrySet()) {
                    AlmAccount almAccount = (AlmAccount)entry.getKey();
                    Map dependentItemsMap = (Map)entry.getValue();
                    AlmAccount fetchedAlmAccount = (AlmAccount)almAccountMap.get(almAccount.getId());
                    if (!PropertyValidator.isValid((Object)fetchedAlmAccount) || !PropertyValidator.isValid((Object)dependentItemsMap)) continue;
                    Set itemKeys = dependentItemsMap.keySet();
                    String itemKeysJoined = String.join((CharSequence)",", itemKeys);
                    String jiraResponse = this.jiraUtils.getIssuesByKeys(itemKeysJoined, fetchedAlmAccount);
                    LOGGER.debug("Received response for almAccount: {} with items: {}", (Object)fetchedAlmAccount.getName(), (Object)itemKeysJoined);
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode root = mapper.readTree(jiraResponse);
                    JsonNode issuesArray = root.get("issues");
                    if (issuesArray == null || !issuesArray.isArray()) continue;
                    for (int i = 0; i < issuesArray.size(); ++i) {
                        JsonNode issue = issuesArray.get(i);
                        String jiraKey = issue.get("key").asText();
                        LOGGER.debug("Processing Jira issue with key: {}", (Object)jiraKey);
                        String title = issue.get("fields").get("summary").asText();
                        String status = issue.get("fields").get("status").get("name").asText();
                        String statusCategory = issue.get("fields").get("status").get("statusCategory").get("key").asText();
                        String iconUrl = issue.get("fields").get("issuetype").get("iconUrl").asText();
                        for (Object dependency : dependencyItems.values()) {
                            Map dependencyMap;
                            String targetKey;
                            if (!PropertyValidator.isValid((Object)dependency) || !PropertyValidator.isValid((Object)(targetKey = (String)(dependencyMap = (Map)dependency).get("targetKey"))) || !targetKey.equals(jiraKey)) continue;
                            if (!PropertyValidator.isValid(dependencyMap.get("targetStatus"))) {
                                dependencyMap.put("targetStatus", status);
                            }
                            if (!PropertyValidator.isValid((Object)"targetStatusCategory")) {
                                dependencyMap.put("targetStatusCategory", statusCategory);
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("targetSummary"))) {
                                dependencyMap.put("targetSummary", title);
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("targetIcon"))) {
                                dependencyMap.put("targetIcon", iconUrl);
                            }
                            dependencyMap.put("isArchive", true);
                            dependencyMap.put("dependencyType", "");
                            if (!PropertyValidator.isValid((Object)"targetStatusCategory")) {
                                if ("Done".equalsIgnoreCase(status)) {
                                    dependencyMap.put("targetStatusCategory", "Done");
                                } else {
                                    dependencyMap.put("targetStatusCategory", "todo");
                                    dependencyMap.put("targetStatusColor", "todo");
                                }
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("dueDate"))) continue;
                            Date today = new Date();
                            today.setTime(today.getTime() - today.getTime() % 86400000L);
                            if (PropertyValidator.isValid(dependencyMap.get("dependencyType")) && !DEPENDENCY_TYPE_REVERSE.equalsIgnoreCase(dependencyMap.get("dependencyType").toString()) && today.after((Date)dependencyMap.get("dueDate"))) {
                                dependencyMap.put("dependencyType", DEPENDENCY_TYPE_OVERDUE);
                                continue;
                            }
                            if (!PropertyValidator.isValid(dependencyMap.get("dependencyStatusCategory")) || !"Done".equalsIgnoreCase(dependencyMap.get("dependencyStatusCategory").toString())) continue;
                            dependencyMap.put("dependencyType", "");
                            return;
                        }
                    }
                }
            } else {
                LOGGER.debug("No ALM accounts with missing items found");
            }
        }
        catch (Exception ex) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void enrichJiraDependencyMap(Item dependentItem, Map<String, Object> dependencyMap, Map<String, Date> itemWithDatesMap, List<Item> items, Map<String, Container> containerMap, Map<String, Container> epicLinkedContainersMap, String tenant, Map<String, TeamContainer> teamContainerMap) throws Exception {
        Container targetContainer;
        Item item;
        String sourceItemId;
        String linkType = (String)dependencyMap.get("linkType");
        if (PropertyValidator.isValid((Object)dependentItem)) {
            Map issueType;
            dependencyMap.put("targetDate", dependentItem.getEndDate());
            dependencyMap.put("targetSummary", dependentItem.getTitle());
            dependencyMap.put("targetKey", dependentItem.getJiraKey());
            if (PropertyValidator.isValid((Object)dependentItem.getStatus())) {
                dependencyMap.put("targetStatus", dependentItem.getStatus().getTitle());
                dependencyMap.put("targetStatusCategory", dependentItem.getStatus().getCategory());
            }
            if (PropertyValidator.isValid((Object)dependentItem.getJiraFieldByKey()) && PropertyValidator.isValid(dependentItem.getJiraFieldByKey().get("issuetype"))) {
                issueType = (Map)dependentItem.getJiraFieldByKey().get("issuetype");
                if (PropertyValidator.isValid(issueType.get("iconUrl"))) {
                    dependencyMap.put("targetIcon", issueType.get("iconUrl"));
                }
            } else if (PropertyValidator.isValid((Object)dependentItem.getTfsItemTypeIcon())) {
                dependencyMap.put("targetIcon", dependentItem.getTfsItemTypeIcon());
            }
            if (PropertyValidator.isValid((Object)dependentItem.getJiraURL())) {
                dependencyMap.put("targetTfsUrl", dependentItem.getJiraURL());
            } else if (PropertyValidator.isValid((Object)dependentItem.getJiraFieldByKey()) && PropertyValidator.isValid(dependentItem.getJiraFieldByKey().get("issuetype"))) {
                issueType = (Map)dependentItem.getJiraFieldByKey().get("issuetype");
                if (PropertyValidator.isValid(issueType.get("self"))) {
                    String issueTypeUrl = (String)issueType.get("self");
                    int index = issueTypeUrl.indexOf("/rest");
                    String jiraURL = index >= 0 ? issueTypeUrl.substring(0, index) : issueTypeUrl;
                    jiraURL = jiraURL + "/browse/" + dependentItem.getJiraKey();
                    dependencyMap.put("targetTfsUrl", jiraURL);
                }
            } else if (PropertyValidator.isValid((Object)dependentItem.getTfsURL())) {
                dependencyMap.put("targetTfsUrl", dependentItem.getTfsURL());
            }
            if (!PropertyValidator.isValid((Object)dependencyMap.get("targetKey")) && PropertyValidator.isValid((Object)dependentItem.getTfsId())) {
                dependencyMap.put("targetKey", dependentItem.getTfsId());
            }
            dependencyMap.remove("almAccount");
        }
        if (LINK_TYPE_KENDIS.equalsIgnoreCase(linkType)) {
            this.enrichKendisDependency(dependentItem, dependencyMap, itemWithDatesMap, containerMap, teamContainerMap);
        } else if (LINK_TYPE_ALM.equalsIgnoreCase(linkType)) {
            this.enrichAlmDependency(dependentItem, dependencyMap, itemWithDatesMap, containerMap, teamContainerMap);
        }
        if (PropertyValidator.isValid((Object)dependencyMap.get("sourceItemId")) && PropertyValidator.isValid((Object)dependencyMap.get("sourceTeamContainerId"))) {
            String teamContainerId;
            sourceItemId = (String)dependencyMap.get("sourceItemId");
            if (PropertyValidator.isValid((Object)sourceItemId) && PropertyValidator.isValid((Object)(item = (Item)items.stream().filter(i -> sourceItemId.equals(i.getId())).findFirst().orElse(null))) && PropertyValidator.isValid((Object)(teamContainerId = (String)dependencyMap.get("sourceTeamContainerId")))) {
                TeamContainer teamContainer = teamContainerMap.get(teamContainerId);
                if (PropertyValidator.isValid((Object)teamContainer)) {
                    if (PropertyValidator.isValid((Object)teamContainer.getTeam())) {
                        dependencyMap.put("sourceTeam", teamContainer.getTeam().getLabel());
                        dependencyMap.put("sourceTeamColor", teamContainer.getTeam().getColor());
                    }
                    if (PropertyValidator.isValid((Object)teamContainer.getContainer())) {
                        dependencyMap.put("sourceContainerSequence", teamContainer.getContainer().getSequence());
                        dependencyMap.put("sourceContainerId", teamContainer.getContainer().getId());
                        dependencyMap.put("sourceIteration", teamContainer.getContainer().getLabel());
                        dependencyMap.put("sourceEndDate", teamContainer.getContainer().getEndDate());
                    }
                } else {
                    LOGGER.debug("Could not find teamContainer for item: {}", (Object)item.getId());
                }
            }
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceContainerId")) && containerMap.containsKey(dependencyMap.get("sourceContainerId").toString())) {
            Container container = containerMap.get(dependencyMap.get("sourceContainerId").toString());
            if (PropertyValidator.isValid((Object)container)) {
                dependencyMap.put("sourceIteration", container.getLabel());
                dependencyMap.put("sourceContainerSequence", container.getSequence());
                dependencyMap.put("sourceEndDate", container.getEndDate());
            }
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceKey")) && epicLinkedContainersMap.containsKey(dependencyMap.get("sourceKey").toString())) {
            Container sourceContainer = epicLinkedContainersMap.get(dependencyMap.get("sourceKey").toString());
            if (PropertyValidator.isValid((Object)sourceContainer)) {
                dependencyMap.put("sourceIteration", sourceContainer.getLabel());
                dependencyMap.put("sourceContainerSequence", sourceContainer.getSequence());
                dependencyMap.put("sourceEndDate", sourceContainer.getEndDate());
            }
        } else {
            if (PropertyValidator.isValid((Object)dependentItem)) {
                LOGGER.debug("Source item ID or team container ID not found in dependency map for dependent item: {}", (Object)dependentItem.getId());
            }
            if (PropertyValidator.isValid((Object)dependencyMap.get("sourceItemId"))) {
                Container container;
                sourceItemId = (String)dependencyMap.get("sourceItemId");
                item = items.stream().filter(i -> sourceItemId.equals(i.getId())).findFirst().orElse(null);
                if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getTeamContainers()) && !item.getTeamContainers().isEmpty()) {
                    List fetchedTeamContainers = item.getTeamContainers().stream().filter(Objects::nonNull).map(tc -> (TeamContainer)teamContainerMap.get(tc.getId())).filter(Objects::nonNull).collect(Collectors.toList());
                    Optional<TeamContainer> optionalTeamContainer = fetchedTeamContainers.stream().filter(Objects::nonNull).max(Comparator.comparing(tc -> tc.getContainer() != null ? tc.getContainer().getSequence() : null, Comparator.nullsLast(Comparator.naturalOrder())));
                    if (optionalTeamContainer.isPresent()) {
                        TeamContainer fetchedTeamContainer = optionalTeamContainer.get();
                        if (PropertyValidator.isValid((Object)fetchedTeamContainer)) {
                            if (PropertyValidator.isValid((Object)fetchedTeamContainer.getTeam())) {
                                dependencyMap.put("sourceTeam", fetchedTeamContainer.getTeam().getLabel());
                                dependencyMap.put("sourceTeamColor", fetchedTeamContainer.getTeam().getColor());
                            }
                            if (PropertyValidator.isValid((Object)fetchedTeamContainer.getContainer())) {
                                dependencyMap.put("sourceContainerSequence", fetchedTeamContainer.getContainer().getSequence());
                                dependencyMap.put("sourceContainerId", fetchedTeamContainer.getContainer().getId());
                                dependencyMap.put("sourceIteration", fetchedTeamContainer.getContainer().getLabel());
                                dependencyMap.put("sourceEndDate", fetchedTeamContainer.getContainer().getEndDate());
                            }
                        }
                    } else {
                        LOGGER.debug("Could not find team container for dependent item: {}", (Object)dependentItem.getId());
                    }
                } else if (PropertyValidator.isValid((Object)dependencyMap.get("sourceContainerId")) && PropertyValidator.isValid((Object)(container = containerMap.get(dependencyMap.get("sourceContainerId").toString())))) {
                    dependencyMap.put("sourceIteration", container.getLabel());
                    dependencyMap.put("sourceContainerSequence", container.getSequence());
                    dependencyMap.put("sourceEndDate", container.getEndDate());
                }
            }
        }
        if (PropertyValidator.isValid((Object)dependencyMap.get("targetKey")) && !PropertyValidator.isValid((Object)dependencyMap.get("targetContainerSequence")) && PropertyValidator.isValid((Object)(targetContainer = epicLinkedContainersMap.get(dependencyMap.get("targetKey").toString())))) {
            dependencyMap.put("targetIteration", targetContainer.getLabel());
            dependencyMap.put("targetContainerSequence", targetContainer.getSequence());
            dependencyMap.put("targetEndDate", targetContainer.getEndDate());
        }
        if (PropertyValidator.isValid((Object)dependentItem)) {
            this.determineDependencyType(dependentItem, dependencyMap, itemWithDatesMap, containerMap, tenant);
        }
    }

    private void enrichJiraAcrossBoardDependency(Session session, Map<String, Object> dependencyMap, Item item, Map<String, Date> itemWithDatesMap, List<Item> items, Map<String, Container> containerMap, Map<String, Object> piBoardMap, Map<String, Object> acrossBoardDependencies, Iterator<Map.Entry<String, Object>> iterator, String itemId, Map.Entry<String, Object> itemEntry, Map<String, Container> epicLinkedContainersMap, Map<String, Session> sessionMap, String tenant, Map<String, TeamContainer> teamContainerMap) throws Exception {
        Map issueType;
        LOGGER.debug("Found across board dependency with Id: {}", dependencyMap.get("dependencyId"));
        dependencyMap.put("sourceKey", piBoardMap.get("key"));
        this.enrichJiraDependencyMap(item, dependencyMap, itemWithDatesMap, items, containerMap, epicLinkedContainersMap, tenant, teamContainerMap);
        dependencyMap.put("sourceBoardTitle", piBoardMap.get("boardTitle"));
        if (PropertyValidator.isValid((Object)session)) {
            dependencyMap.put("targetBoardTitle", session.getTitle());
            dependencyMap.put("boardSessionId", session.getId());
        } else if (PropertyValidator.isValid((Object)dependencyMap.get("targetSessionId"))) {
            String targetSessionId = dependencyMap.get("targetSessionId").toString();
            Criteria targetSessionCriteria = Criteria.where((String)"_id").is((Object)targetSessionId).and("tenant").is((Object)tenant);
            Query targetSessionQuery = Query.query((CriteriaDefinition)targetSessionCriteria);
            targetSessionQuery.fields().include("_id").include("title").include("activeSessionBoard").include("rowStatus");
            Session targetSession = (Session)this.mongoTemplate.findOne(targetSessionQuery, Session.class);
            if (PropertyValidator.isValid((Object)targetSession)) {
                dependencyMap.put("targetBoardTitle", targetSession.getTitle());
                dependencyMap.put("boardSessionId", targetSession.getId());
                sessionMap.put(targetSessionId, targetSession);
            }
        }
        dependencyMap.put("targetKey", item.getJiraKey());
        dependencyMap.put("sourceStatus", piBoardMap.get("sourceStatus"));
        dependencyMap.put("sourceStatusCategory", piBoardMap.get("sourceStatusCategory"));
        Map statusInfo = this.getSafeStatusInfo(item);
        dependencyMap.put("targetStatus", statusInfo.get("title"));
        dependencyMap.put("targetStatusCategory", statusInfo.get("category"));
        dependencyMap.put("sourceTargetDate", piBoardMap.get("targetDate"));
        dependencyMap.put("targetTargetDate", item.getEndDate());
        dependencyMap.put("sourceSummary", piBoardMap.get("sourceSummary"));
        dependencyMap.put("targetSummary", item.getTitle());
        dependencyMap.put("sourceIcon", piBoardMap.get("sourceIcon"));
        dependencyMap.put("sourceTfsUrl", piBoardMap.get("sourceTfsUrl"));
        if (PropertyValidator.isValid((Object)item.getJiraURL())) {
            dependencyMap.put("targetTfsUrl", item.getJiraURL());
        } else if (PropertyValidator.isValid((Object)item.getJiraFieldByKey()) && PropertyValidator.isValid(item.getJiraFieldByKey().get("issuetype")) && PropertyValidator.isValid((issueType = (Map)item.getJiraFieldByKey().get("issuetype")).get("self"))) {
            String issueTypeUrl = (String)issueType.get("self");
            int index = issueTypeUrl.indexOf("/rest");
            String jiraURL = index >= 0 ? issueTypeUrl.substring(0, index) : issueTypeUrl;
            jiraURL = jiraURL + "/browse/" + item.getJiraKey();
            dependencyMap.put("targetTfsUrl", jiraURL);
        }
        Map teamContainerInfo = this.getSafeTeamContainerInfo(item, teamContainerMap);
        if (teamContainerInfo != null) {
            if (teamContainerInfo.containsKey("teamLabel")) {
                dependencyMap.put("targetTeam", teamContainerInfo.get("teamLabel"));
                dependencyMap.put("targetTeamColor", teamContainerInfo.get("teamColor"));
            }
            if (teamContainerInfo.containsKey("containerLabel")) {
                dependencyMap.put("targetIteration", teamContainerInfo.get("containerLabel"));
            }
        }
        this.populateInAcrossBoardDependencyMap(dependencyMap, acrossBoardDependencies, item, itemEntry);
        iterator.remove();
    }

    private void populateInAcrossBoardDependencyMap(Map<String, Object> dependencyMap, Map<String, Object> acrossBoardDependencies, Item item, Map.Entry<String, Object> itemEntry) {
        if (PropertyValidator.isValid((Object)item.getJiraKey())) {
            if (!acrossBoardDependencies.containsKey(item.getJiraKey())) {
                acrossBoardDependencies.put(item.getJiraKey(), itemEntry);
            } else {
                String newOrigin = (String)dependencyMap.get("linkOrigin");
                if (PropertyValidator.isValid((Object)newOrigin) && LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) {
                    acrossBoardDependencies.put(item.getJiraKey(), itemEntry);
                }
            }
        } else if (PropertyValidator.isValid((Object)item.getTfsId())) {
            if (!acrossBoardDependencies.containsKey(item.getTfsId())) {
                acrossBoardDependencies.put(item.getTfsId(), itemEntry);
            } else {
                String newOrigin = (String)dependencyMap.get("linkOrigin");
                if (PropertyValidator.isValid((Object)newOrigin) && LINK_TYPE_KENDIS.equalsIgnoreCase(newOrigin)) {
                    acrossBoardDependencies.put(item.getTfsId(), itemEntry);
                }
            }
            dependencyMap.put("targetKey", item.getTfsId());
            dependencyMap.put("targetTfsUrl", item.getTfsURL());
            dependencyMap.put("targetIcon", item.getTfsItemTypeIcon());
        }
    }
}

