/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.gridfs.GridFSFile;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.AttachmentRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.AttachmentService;
import com.viztrend.safe.utils.AttachmentUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.Attachment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.gridfs.GridFsOperations;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Component(value="AttachmentService")
@Transactional
public class AttachmentServiceImpl
implements AttachmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    private AttachmentUtils attachmentUtils;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    AttachmentRepository attachmentRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private GridFsOperations gridFsOperations;

    public List<Attachment> saveAttachmentasImage(List<Map<String, Object>> imageList) {
        ArrayList<Attachment> savedAttachments = new ArrayList<Attachment>();
        for (Map<String, Object> image : imageList) {
            Attachment newImage = new Attachment();
            newImage.setFilename((String)image.get("fileName"));
            newImage.setFileType((String)image.get("fileType"));
            if (PropertyValidator.isValid((Object)image.get("sequence"))) {
                newImage.setSequence(this.getSequenceFromObject(image.get("sequence")));
            }
            String dataURL = (String)image.get("dataURL");
            String base64Image = dataURL.split(",")[1];
            byte[] imageBytes = Base64.getDecoder().decode(base64Image);
            if (this.isImageType(newImage.getFileType())) {
                newImage.setIsImage(Boolean.valueOf(true));
                newImage.setImage(Boolean.valueOf(true));
            }
            newImage.setContentType((String)image.get("contentType"));
            newImage.setMimeType((String)image.get("fileType"));
            newImage.setReferenceKey(UUID.randomUUID().toString());
            newImage.setAttachmentData(imageBytes);
            Attachment savedImage = (Attachment)this.attachmentRepository.save((Object)newImage);
            savedAttachments.add(savedImage);
        }
        return savedAttachments;
    }

    private Double getSequenceFromObject(Object image) {
        if (image == null) {
            return null;
        }
        try {
            if (image instanceof Double) {
                return (Double)image;
            }
            if (image instanceof Integer) {
                return ((Integer)image).doubleValue();
            }
            String sequence = image.toString();
            return Double.parseDouble(sequence);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    private boolean isImageType(String fileType) {
        return fileType.contains("image");
    }

    public Attachment uploadAttachmentForItem(MultipartFile file) throws Exception {
        Attachment persistedAttachment;
        try {
            persistedAttachment = this.persistAttachmentObjects(file);
            this.writeAttachmentData(persistedAttachment);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving the attachment data in the database", (Throwable)e);
            throw e;
        }
        return persistedAttachment;
    }

    public boolean saveAttachmentSequences(List<Map<String, Object>> sequencesForAttachments, String workSpaceId) {
        if (!PropertyValidator.isValid(sequencesForAttachments)) {
            return false;
        }
        Map attachmentIdMap = this.createSeqByAttachmentIdMap(sequencesForAttachments);
        LinkedList attachmentIds = new LinkedList(attachmentIdMap.keySet());
        List attachments = this.attachmentRepository.findByIdIn(attachmentIds);
        if (!PropertyValidator.isValid((Collection)attachments)) {
            return false;
        }
        attachments.forEach(attachment -> attachment.setSequence((Double)attachmentIdMap.get(attachment.getId())));
        List savedAttachments = this.attachmentRepository.save((Iterable)attachments);
        Map<String, Attachment> attachmentMap = savedAttachments.stream().collect(Collectors.toMap(BaseEntity::getId, attachment -> attachment));
        WorkSpace workSpace = this.workSpaceRepository.findById(workSpaceId);
        workSpace.getAttachments().stream().filter(attachment -> attachmentMap.containsKey(attachment.getId())).forEach(attachment -> attachment.setSequence(((Attachment)attachmentMap.get(attachment.getId())).getSequence()));
        this.workSpaceRepository.save((Object)workSpace);
        return true;
    }

    private Map<String, Double> createSeqByAttachmentIdMap(List<Map<String, Object>> sequenceForAttachments) {
        HashMap<String, Double> seqByAttachmentId = new HashMap<String, Double>();
        if (!PropertyValidator.isValid(sequenceForAttachments)) {
            return seqByAttachmentId;
        }
        sequenceForAttachments.forEach(map -> {
            if (PropertyValidator.isValid(map.get("id"))) {
                seqByAttachmentId.put(map.get("id").toString(), this.getSequenceFromObject(map.get("sequence")));
            }
        });
        return seqByAttachmentId;
    }

    private Attachment persistAttachmentObjects(MultipartFile image) throws Exception {
        Attachment savedImage;
        try {
            Attachment newImage = new Attachment();
            newImage.setFilename(image.getOriginalFilename());
            newImage.setFileType(image.getContentType());
            if (this.isImageType(newImage.getFileType())) {
                newImage.setIsImage(Boolean.valueOf(true));
                newImage.setImage(Boolean.valueOf(true));
            }
            newImage.setReferenceKey(UUID.randomUUID().toString());
            newImage.setAttachmentData(image.getBytes());
            newImage.setMimeType(image.getContentType());
            savedImage = (Attachment)this.attachmentRepository.save((Object)newImage);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving the attachment data in the database", (Throwable)e);
            throw e;
        }
        return savedImage;
    }

    public boolean addAttachmentstoWorkspace(List<Attachment> savedAttachments, String id) {
        WorkSpace currentWorkspace = null;
        if (savedAttachments.size() > 0) {
            currentWorkspace = this.workSpaceRepository.findByIdOrKey(id, id);
            if (currentWorkspace.getAttachments() != null && currentWorkspace.getAttachments().size() > 0) {
                for (int i = 0; i < savedAttachments.size(); ++i) {
                    currentWorkspace.getAttachments().add(savedAttachments.get(i));
                }
            } else {
                currentWorkspace.setAttachments(savedAttachments);
            }
            currentWorkspace = (WorkSpace)this.workSpaceRepository.save((Object)currentWorkspace);
            return true;
        }
        return false;
    }

    public String writeAttachmentData(Attachment toWrite) {
        boolean isWritten = false;
        String attachmentId = null;
        isWritten = AttachmentUtils.storeData((Attachment)toWrite, (AppConfig.MongoConfig)this.mongoConfig);
        if (isWritten) {
            attachmentId = toWrite.getId();
        }
        return attachmentId;
    }

    public List<Attachment> fetchAttachmentData(List<Attachment> attachments) {
        boolean isFetched = false;
        ArrayList<Attachment> attachmentWithData = new ArrayList<Attachment>();
        for (int i = 0; i < attachments.size(); ++i) {
            byte[] imageBytes = AttachmentUtils.retrieveData((String)attachments.get(i).getReferenceKey(), (AppConfig.MongoConfig)this.mongoConfig);
            attachments.get(i).setAttachmentData(imageBytes);
            attachmentWithData.add(attachments.get(i));
        }
        return attachmentWithData;
    }

    public List<Attachment> getAttachments(String id) {
        List retrievedAttachments = null;
        try {
            WorkSpace currentWorkspace = this.workSpaceRepository.findByIdOrKey(id, id);
            return currentWorkspace.getAttachments() != null ? currentWorkspace.getAttachments() : retrievedAttachments;
        }
        catch (Exception e) {
            LOGGER.error("Error while getting Attachment:" + StringUtils.getTraceString((Throwable)e));
            return retrievedAttachments;
        }
    }

    public long removeAttachmentasImage(Map<String, Object> image) {
        long deleteCount = 0L;
        String attachmentId = (String)image.get("id");
        String referenceKey = (String)image.get("referenceKey");
        if (attachmentId != null) {
            deleteCount = this.attachmentRepository.deleteById(attachmentId);
        } else if (referenceKey != null) {
            deleteCount = this.attachmentRepository.deleteByReferenceKey(referenceKey);
        }
        return deleteCount;
    }

    public void removeAttachmentfromWorkspace(String workspaceId, String attachmentId, String refKey) {
        long deleteCount = 0L;
        this.customRepository.deleteAttachmentFromWorkspace(workspaceId, attachmentId);
    }

    public boolean removeAttachmentData(String referenceKey) {
        try {
            return AttachmentUtils.removeData((String)referenceKey, (AppConfig.MongoConfig)this.mongoConfig);
        }
        catch (Exception ex) {
            LOGGER.error("Error while deleting attachment: " + StringUtils.getTraceString((Throwable)ex));
            return false;
        }
    }

    public boolean removeAttachment(String id) {
        this.attachmentRepository.delete((Serializable)((Object)id));
        return false;
    }

    public Attachment saveAttachment(Attachment attachment) {
        return null;
    }

    public List<Attachment> getAttachments(List<String> ids) {
        return null;
    }

    public String uploadImage(MultipartFile file) throws Exception {
        GridFSFile gridFSFile = this.mongoConfig.gridFsTemplate().store(file.getInputStream(), file.getOriginalFilename(), file.getContentType());
        return gridFSFile.getId().toString();
    }

    public String uploadImageFromBase64(String base64Data, String filename) throws Exception {
        return AttachmentUtils.uploadImageFromBase64((String)base64Data, (String)filename, (AppConfig.MongoConfig)this.mongoConfig);
    }
}

