/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.service;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.ItemTypeScheme;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserApiKey;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.BaseItemLinkRepository;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemTypeSchemeRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.UserApiKeyRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.APIService;
import com.viztrend.safe.service.APIServiceImpl;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.ObjectiveServiceImpl;
import com.viztrend.safe.service.PlanServiceImpl;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="APIService")
@Transactional
public class APIServiceImpl
implements APIService {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIServiceImpl.class);
    private static final DecimalFormat dfSharp = new DecimalFormat("#.##");
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private BaseItemLinkRepository baseItemLinkRepository;
    @Autowired
    private BaseItemRepository baseItemRepository;
    @Autowired
    private ObjectiveService objectiveService;
    @Autowired
    private ObjectiveServiceImpl objectiveServiceImpl;
    @Autowired
    private ItemTypeSchemeRepository itemTypeSchemeRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private MongoConverter mongoConverter;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private UserApiKeyRepository userApiKeyRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private PlanServiceImpl planServiceImpl;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private StatusRepository statusRepository;

    public boolean isWorking() {
        return true;
    }

    public UserApiKey createUserAPIKey(User user, String apiKey, String apiKeyLabel, Date expiresAt, int expiryDateSpan) {
        if (!PropertyValidator.isValid((Object)user) || !this.isValidExpireDate(expiresAt)) {
            return null;
        }
        UserApiKey userApiKey = new UserApiKey();
        userApiKey.setUserId(user.getId());
        userApiKey.setApiKey(this.hashApiKey(apiKey));
        userApiKey.setUserType(user.getUserType());
        userApiKey.setUserCompanies(user.getUserCompanies());
        userApiKey.setDailyLimit(10);
        userApiKey.setLabel(apiKeyLabel);
        userApiKey.setExpiresAt(expiresAt);
        userApiKey.setExpiryDateSpan(expiryDateSpan);
        return userApiKey;
    }

    public boolean isValidExpireDate(Date expiresAt) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of("UTC")));
        calendar.add(1, 1);
        return !expiresAt.after(calendar.getTime());
    }

    public String generateAPIKey() {
        byte[] apiKeyBytes = new byte[32];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(apiKeyBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(apiKeyBytes);
    }

    public String hashApiKey(String apiKey) {
        if (!PropertyValidator.isValid((Object)apiKey)) {
            return "";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(apiKey.getBytes(StandardCharsets.UTF_8));
            return this.bytesToHex(hashBytes);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while hashing api key -> ", (Throwable)e);
            return "";
        }
    }

    public Date calculateNextExpiresAt(int expiryDateSpan) {
        Calendar newExpiresCal = Calendar.getInstance();
        newExpiresCal.add(5, expiryDateSpan);
        return KendisUtils.convertInstantToDayEndDate((Instant)newExpiresCal.toInstant());
    }

    public Map<String, Object> getUserInfo(String apiKey) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        try {
            User user;
            String apiKeyHash = this.hashApiKey(apiKey);
            UserApiKey userApiKey = this.userApiKeyRepository.findByApiKey(apiKeyHash);
            if (PropertyValidator.isValid((Object)userApiKey) && PropertyValidator.isValid((Object)(user = this.userRepository.findById(userApiKey.getUserId())))) {
                userInfo.put("id", user.getId());
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return userInfo;
    }

    public UserApiKey getUserFromRequest(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.toLowerCase().startsWith("basic")) {
            User user;
            String apiKey = authorization.substring("Basic".length()).trim();
            byte[] credDecoded = Base64.getDecoder().decode(apiKey);
            String credentials = new String(credDecoded, StandardCharsets.UTF_8);
            String[] splitCredentials = credentials.split(":");
            String apiKeyHash = this.hashApiKey(splitCredentials[1]);
            UserApiKey userApiKey = this.userApiKeyRepository.findByApiKey(apiKeyHash);
            if (userApiKey != null && PropertyValidator.isValid((Object)(user = this.userRepository.findById(userApiKey.getUserId()))) && splitCredentials[0].equalsIgnoreCase(user.getUserName())) {
                return userApiKey;
            }
        }
        return null;
    }

    public void resetAllDailyLimits(UserApiKey userApiKey) {
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private List<DBObject> getBaseItemLinks(String sessionId, String type, int startIndex, int endIndex) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createdOn"}));
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"sessionId").is((Object)sessionId), Criteria.where((String)"type").is((Object)type)});
        query.addCriteria((CriteriaDefinition)criteria);
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("baseItemLink").find(query.getQueryObject()).skip(startIndex).limit(endIndex);
        List rawItems = dbCursorPrefix.toArray();
        return rawItems;
    }

    public HashMap<String, String> getfieldsMap(String fields, String expand) {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        try {
            String newString;
            if (!PropertyValidator.isValid((Object)fields)) {
                fieldsMap.put("all", "all");
            } else {
                String[] fieldsArray;
                for (String filed : fieldsArray = fields.split(",")) {
                    newString = filed.replace(" ", "");
                    fieldsMap.put(newString, filed);
                }
            }
            if (PropertyValidator.isValid((Object)expand)) {
                String[] expandArray;
                for (String filed : expandArray = expand.split(",")) {
                    newString = filed.replace(" ", "");
                    fieldsMap.put(newString, filed);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching objectives by active session board id by api key -> ", (Throwable)e);
        }
        return fieldsMap;
    }

    public HashMap<String, Object> getIndividualObjectiveByObjectiveKey(String objectiveKey, String fields, String expand) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap fieldsMap = this.getfieldsMap(fields, expand);
            String[] objectivesKeyArray = objectiveKey.split(",");
            if (PropertyValidator.isValid((String[])objectivesKeyArray)) {
                List objectivesList = this.baseItemRepository.findByKeyIn(objectivesKeyArray);
                if (PropertyValidator.isValid((Collection)objectivesList)) {
                    ArrayList<BaseItemLink> baseItemLinksOfItemIds = new ArrayList<BaseItemLink>();
                    ArrayList<String> baseItemLinksOfOKRBaseItems = new ArrayList<String>();
                    ArrayList<ItemType> itemType = new ArrayList<ItemType>();
                    HashMap<String, ItemType> checkDuplicateItemType = new HashMap<String, ItemType>();
                    ArrayList<String> backLogItemsLinkObjective = new ArrayList<String>();
                    ArrayList<String> globallinkBaseItems = new ArrayList<String>();
                    ArrayList<BaseItem> globalBaseItems = new ArrayList<BaseItem>();
                    HashMap<String, BaseItem> checkglobalBaseItems = new HashMap<String, BaseItem>();
                    for (BaseItem objectives : objectivesList) {
                        Status status = new Status(objectives.getStatus().getId(), objectives.getStatus().getTitle(), objectives.getStatus().getColor(), objectives.getStatus().getCategory());
                        objectives.setStatus(status);
                        if (PropertyValidator.isValid((Object)objectives.getItemType()) && !PropertyValidator.isValid(checkDuplicateItemType.get(objectives.getItemType().getId().toString()))) {
                            checkDuplicateItemType.put(objectives.getItemType().getId().toString(), objectives.getItemType());
                            itemType.add(objectives.getItemType());
                        }
                        for (BaseItemLink bil : objectives.getBaseItemLinks()) {
                            if (!bil.isArchive() && PropertyValidator.isValid((Object)bil.getItemId())) {
                                baseItemLinksOfItemIds.add(bil);
                            }
                            if (!bil.isArchive() && PropertyValidator.isValid((Object)bil.getSessionId()) && bil.getSessionId().equals("-1") && PropertyValidator.isValid((Object)bil.getBaseItemId())) {
                                globallinkBaseItems.add(bil.getBaseItemId());
                                if (!PropertyValidator.isValid(checkglobalBaseItems.get(objectives.getId()))) {
                                    globalBaseItems.add(objectives);
                                    checkglobalBaseItems.put(objectives.getId(), objectives);
                                }
                            } else if (!bil.isArchive() && PropertyValidator.isValid((Object)bil.getLinkType()) && bil.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) && PropertyValidator.isValid((Object)bil.getBaseItemId())) {
                                baseItemLinksOfOKRBaseItems.add(bil.getBaseItemId());
                            }
                            if (bil.isArchive() || !PropertyValidator.isValid((Object)bil.getLinkType()) || !bil.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode()) || !PropertyValidator.isValid((Object)bil.getBaseItemId()) || !PropertyValidator.isValid((Object)bil.getReleaseTrainId())) continue;
                            backLogItemsLinkObjective.add(bil.getBaseItemId());
                        }
                    }
                    HashMap listOfKRsMapById = new HashMap();
                    if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("KR"))) {
                        this.getKrDataForObjectives(listOfKRsMapById, baseItemLinksOfOKRBaseItems, itemType, checkDuplicateItemType, baseItemLinksOfItemIds);
                    }
                    HashMap globalKrObjectivesById = new HashMap();
                    HashMap globalObjectivesCOmpleationById = new HashMap();
                    if (PropertyValidator.isValid(globallinkBaseItems)) {
                        List globallinkBaseItemsList = this.baseItemRepository.findByIdIn(globallinkBaseItems);
                        HashMap<String, BaseItem> globallinkBaseItemsMapById = new HashMap<String, BaseItem>();
                        for (BaseItem item : globallinkBaseItemsList) {
                            globallinkBaseItemsMapById.put(item.getId(), item);
                        }
                        this.setObjectiveWithLinkKr(globalBaseItems, globallinkBaseItemsMapById, itemType, globalKrObjectivesById);
                        globalObjectivesCOmpleationById = this.globalObjectiveDataPrep(backLogItemsLinkObjective, globalBaseItems);
                    }
                    HashMap linkFields = this.getObjectiveFields(itemType);
                    this.fetchIndividualObjectiveWithLinkedItems(objectivesList, baseItemLinksOfItemIds);
                    ArrayList<LinkedHashMap> responseData = new ArrayList<LinkedHashMap>();
                    for (BaseItem objectives : objectivesList) {
                        LinkedHashMap subObjectiveData = this.getDataBySelectedFields(objectives, linkFields, fieldsMap);
                        if (PropertyValidator.isValid(globalObjectivesCOmpleationById.get(objectives.getId()))) {
                            this.globalSetObjectivesCalculation(objectives, (HashMap)subObjectiveData, fieldsMap, globalObjectivesCOmpleationById);
                            if (!PropertyValidator.isValid((Object)subObjectiveData)) continue;
                            if (PropertyValidator.isValid((Collection)objectives.getBaseItemLinks()) && (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("KR")))) {
                                this.globalKeyResultCalculation(objectives, (HashMap)subObjectiveData, globalKrObjectivesById, linkFields, fieldsMap, globalObjectivesCOmpleationById);
                            }
                            responseData.add(subObjectiveData);
                            continue;
                        }
                        this.piSetObjectivesCalculation(objectives, (HashMap)subObjectiveData, fieldsMap);
                        if (!PropertyValidator.isValid((Object)subObjectiveData)) continue;
                        if (PropertyValidator.isValid((Collection)objectives.getBaseItemLinks()) && (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("KR")))) {
                            this.keyResultCalculation(objectives, (HashMap)subObjectiveData, listOfKRsMapById, linkFields, fieldsMap);
                        }
                        responseData.add(subObjectiveData);
                    }
                    responseJson.put("data", responseData);
                } else {
                    responseJson.put("data", new ArrayList());
                }
            } else {
                responseJson.put("data", new ArrayList());
            }
            return responseJson;
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while fetching objectice by objectives key function by api key -> ", (Throwable)e);
            return responseJson;
        }
    }

    private HashMap<String, BaseItem> getKrDataForObjectives(HashMap<String, BaseItem> listOfKRsMapById, List<String> baseItemLinksOfOKRBaseItems, List<ItemType> itemType, HashMap<String, ItemType> checkDuplicateItemType, List<BaseItemLink> baseItemLinksOfItemIds) {
        HashMap<String, BaseItem> responseJson = new HashMap<String, BaseItem>();
        try {
            List listOfKRs = this.baseItemRepository.findByIdIn(baseItemLinksOfOKRBaseItems);
            for (BaseItem KRs : listOfKRs) {
                listOfKRsMapById.put(KRs.getId(), KRs);
                if (PropertyValidator.isValid((Object)KRs.getItemType()) && !PropertyValidator.isValid((Object)checkDuplicateItemType.get(KRs.getItemType().getId().toString()))) {
                    checkDuplicateItemType.put(KRs.getItemType().getId().toString(), KRs.getItemType());
                    itemType.add(KRs.getItemType());
                }
                if (!PropertyValidator.isValid((Collection)KRs.getBaseItemLinks())) continue;
                for (BaseItemLink bil : KRs.getBaseItemLinks()) {
                    if (bil.isArchive() || !PropertyValidator.isValid((Object)bil.getItemId())) continue;
                    baseItemLinksOfItemIds.add(bil);
                }
            }
            this.fetchIndividualObjectiveWithLinkedItems(listOfKRs, baseItemLinksOfItemIds);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching get Kr Data For Objectives api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    private HashMap<String, BaseItem> setGroupObjectiveWithLinksubObjectiveAndLinkKr(List<BaseItem> listOfSelectedObjGroup, List<BaseItem> globalBaseItems, List<ItemType> itemType) {
        HashMap<String, BaseItem> responseJson = new HashMap<String, BaseItem>();
        try {
            HashMap<String, BaseItem> globallinkBaseItemsMapById = new HashMap<String, BaseItem>();
            if (PropertyValidator.isValid(globalBaseItems)) {
                for (BaseItem item : globalBaseItems) {
                    globallinkBaseItemsMapById.put(item.getId(), item);
                }
                if (PropertyValidator.isValid(listOfSelectedObjGroup)) {
                    for (BaseItem objectiveGroup : listOfSelectedObjGroup) {
                        ArrayList linkBaseItems = new ArrayList();
                        for (BaseItemLink link : objectiveGroup.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid(globallinkBaseItemsMapById.get(link.getBaseItemId()))) continue;
                            linkBaseItems.add(globallinkBaseItemsMapById.get(link.getBaseItemId()));
                        }
                        this.setObjectiveWithLinkKr(linkBaseItems, globallinkBaseItemsMapById, itemType, responseJson);
                        this.setBaseItemInParent(objectiveGroup, linkBaseItems);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while set Objective With Link Kr by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    public void setBaseItemInParent(BaseItem parent, List<BaseItem> keyResult) {
        List baseItemList = parent.getBaseItemList();
        if (PropertyValidator.isValid((Collection)baseItemList) && baseItemList.size() > 0) {
            baseItemList.addAll(keyResult);
        } else {
            ArrayList<BaseItem> keyResults = new ArrayList<BaseItem>();
            keyResults.addAll(keyResult);
            parent.setBaseItemList(keyResults);
        }
    }

    private void setObjectiveWithLinkKr(List<BaseItem> globalBaseItems, HashMap<String, BaseItem> globallinkBaseItemsMapById, List<ItemType> itemType, HashMap<String, BaseItem> responseJson) {
        try {
            HashMap<String, ItemType> checkDuplicateItemType = new HashMap<String, ItemType>();
            if (PropertyValidator.isValid(globallinkBaseItemsMapById) && PropertyValidator.isValid(globalBaseItems)) {
                for (BaseItem obj : globalBaseItems) {
                    if (!PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) continue;
                    for (BaseItemLink link : obj.getBaseItemLinks()) {
                        BaseItem kr;
                        if (!PropertyValidator.isValid((Object)link.getBaseItemId()) || !PropertyValidator.isValid((Object)(kr = globallinkBaseItemsMapById.get(link.getBaseItemId()))) || !PropertyValidator.isValid((Object)link) || !PropertyValidator.isValid((Object)link.getBaseItemId()) || link.isArchive() || !PropertyValidator.isValid((Object)link.getLinkType()) || link.getLinkType().equals(EnumKendis.PARENT_GROUP_OBJECTIVE.getCode()) || link.getLinkType().equals(EnumKendis.CHILD_OKR.getCode())) continue;
                        this.objectiveServiceImpl.setBaseItemInParent(obj, kr);
                        responseJson.put(kr.getId(), kr);
                        if (!PropertyValidator.isValid((Object)kr.getItemType()) || PropertyValidator.isValid(checkDuplicateItemType.get(kr.getItemType().getId().toString()))) continue;
                        checkDuplicateItemType.put(kr.getItemType().getId().toString(), kr.getItemType());
                        itemType.add(kr.getItemType());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while set Objective With Link Kr by api key -> ", (Throwable)e);
        }
    }

    private HashMap<String, Double> globalObjectiveDataPrep(List<String> backLogItemsLinkObjective, List<BaseItem> globalBaseItems) {
        HashMap<String, Double> responseJson = new HashMap<String, Double>();
        try {
            List okrProgressCriteriaGroupFields = this.objectiveServiceImpl.getOkrProgressCriteriaGroupFields();
            HashMap okrLinkedItemMapByOkrId = new HashMap();
            HashMap<String, String> okrProgressCriteriaById = new HashMap<String, String>();
            HashMap<String, Double> completionById = new HashMap<String, Double>();
            HashMap backlogItemsByIdMapForRt = new HashMap();
            List backlogItemsList = this.backlogItemRepository.findAllByIdIn(backLogItemsLinkObjective);
            HashMap<String, BacklogItem> backlogItemMapById = new HashMap<String, BacklogItem>();
            for (BacklogItem item : backlogItemsList) {
                backlogItemMapById.put(item.getId(), item);
            }
            if (PropertyValidator.isValid(globalBaseItems)) {
                for (BaseItem obj : globalBaseItems) {
                    ArrayList<String> objLinkedItemIds = new ArrayList<String>();
                    if (PropertyValidator.isValid((Collection)obj.getBaseItemLinks())) {
                        for (BaseItemLink link : obj.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType()) || !PropertyValidator.isValid(backlogItemMapById.get(link.getBaseItemId()))) continue;
                            Map itemsMap = new HashMap();
                            if (PropertyValidator.isValid(backlogItemsByIdMapForRt.get(link.getReleaseTrainId()))) {
                                itemsMap = (Map)backlogItemsByIdMapForRt.get(link.getReleaseTrainId());
                            }
                            itemsMap.put(link.getBaseItemId(), backlogItemMapById.get(link.getBaseItemId()));
                            objLinkedItemIds.add(link.getBaseItemId());
                            backlogItemsByIdMapForRt.put(link.getReleaseTrainId(), itemsMap);
                        }
                        okrLinkedItemMapByOkrId.put(obj.getId(), objLinkedItemIds);
                    }
                    if (!PropertyValidator.isValid((Collection)obj.getBaseItemList())) continue;
                    for (BaseItem kr : obj.getBaseItemList()) {
                        String progressCriteriaFieldToShow = "";
                        ArrayList<String> krLinkedItemIds = new ArrayList<String>();
                        if (PropertyValidator.isValid((Object)kr.getFields())) {
                            for (Fields groupField : okrProgressCriteriaGroupFields) {
                                if (!groupField.getTitle().equals("Progress Criteria")) continue;
                                progressCriteriaFieldToShow = (String)kr.getFields().get(groupField.getId());
                                okrProgressCriteriaById.put(kr.getId(), progressCriteriaFieldToShow);
                                break;
                            }
                        }
                        if (!PropertyValidator.isValid((Object)progressCriteriaFieldToShow) || !progressCriteriaFieldToShow.equals("By Items") || !PropertyValidator.isValid((Collection)kr.getBaseItemLinks())) continue;
                        for (BaseItemLink link : kr.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid((Object)link) || link.isArchive() || !"backLogItem".equals(link.getLinkType())) continue;
                            if (PropertyValidator.isValid((Object)link) && !link.isArchive() && "backLogItem".equals(link.getLinkType()) && PropertyValidator.isValid(backlogItemMapById.get(link.getBaseItemId()))) {
                                Map itemsMap = new HashMap();
                                if (PropertyValidator.isValid(backlogItemsByIdMapForRt.get(link.getReleaseTrainId()))) {
                                    itemsMap = (Map)backlogItemsByIdMapForRt.get(link.getReleaseTrainId());
                                }
                                itemsMap.put(link.getBaseItemId(), backlogItemMapById.get(link.getBaseItemId()));
                                objLinkedItemIds.add(link.getBaseItemId());
                                backlogItemsByIdMapForRt.put(link.getReleaseTrainId(), itemsMap);
                            }
                            krLinkedItemIds.add(link.getBaseItemId());
                        }
                        okrLinkedItemMapByOkrId.put(kr.getId(), krLinkedItemIds);
                    }
                }
            }
            HashMap childItemsById = new HashMap();
            if (PropertyValidator.isValid(globalBaseItems)) {
                for (BaseItem obj : globalBaseItems) {
                    HashMap<String, Boolean> objectiveEncountered = new HashMap<String, Boolean>();
                    objectiveEncountered.put(obj.getId(), true);
                    Double objCompletion = this.objectiveServiceImpl.calculateOkrCompletion(obj, backlogItemsByIdMapForRt, okrProgressCriteriaGroupFields, okrProgressCriteriaById, completionById, childItemsById, new HashMap(), objectiveEncountered, okrLinkedItemMapByOkrId);
                    completionById.put(obj.getId(), objCompletion);
                }
            }
            responseJson = completionById;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching global objective data prep by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    private void globalKeyResultCalculation(BaseItem objectives, HashMap<String, Object> subObjectiveData, HashMap<String, BaseItem> listOfKRsMapById, HashMap<String, Fields> linkFields, HashMap<String, String> fieldsMap, HashMap<String, Double> globalObjectivesCOmpleationById) {
        ArrayList<LinkedHashMap> listOfKrs = new ArrayList<LinkedHashMap>();
        for (BaseItemLink bil : objectives.getBaseItemLinks()) {
            BaseItem linkKR;
            LinkedHashMap krResponseJson;
            if (bil.isArchive() || !PropertyValidator.isValid((Object)bil.getLinkType()) || !bil.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) || !PropertyValidator.isValid((Object)bil.getBaseItemId()) || !PropertyValidator.isValid((Object)listOfKRsMapById.get(bil.getBaseItemId())) || !PropertyValidator.isValid((Object)(krResponseJson = this.getDataBySelectedFields(linkKR = listOfKRsMapById.get(bil.getBaseItemId()), linkFields, fieldsMap))) || !PropertyValidator.isValid((Object)linkKR)) continue;
            krResponseJson.put("weightage", bil.getWeightage());
            krResponseJson.put("completionCriteria", linkKR.getCompletionCriteria());
            if (PropertyValidator.isValid((Object)globalObjectivesCOmpleationById.get(linkKR.getId()))) {
                krResponseJson.put("completion", globalObjectivesCOmpleationById.get(linkKR.getId()));
            }
            listOfKrs.add(krResponseJson);
        }
        subObjectiveData.put("linkKrs", listOfKrs);
    }

    private void keyResultCalculation(BaseItem objectives, HashMap<String, Object> subObjectiveData, HashMap<String, BaseItem> listOfKRsMapById, HashMap<String, Fields> linkFields, HashMap<String, String> fieldsMap) {
        double totalWeights = objectives.getLinkedCardWeights();
        subObjectiveData.put("linkedCardWeights", objectives.getLinkedCardWeights());
        ArrayList<HashMap> listOfKrs = new ArrayList<HashMap>();
        for (BaseItemLink bil : objectives.getBaseItemLinks()) {
            BaseItem linkKR;
            HashMap krResponseJson;
            if (bil.isArchive() || !PropertyValidator.isValid((Object)bil.getLinkType()) || !bil.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) || !PropertyValidator.isValid((Object)bil.getBaseItemId()) || !PropertyValidator.isValid((Object)listOfKRsMapById.get(bil.getBaseItemId())) || !PropertyValidator.isValid((Object)(krResponseJson = this.objectiveKrsCalculation(linkKR = listOfKRsMapById.get(bil.getBaseItemId()), linkFields, fieldsMap))) || !PropertyValidator.isValid((Object)linkKR)) continue;
            krResponseJson.put("weightage", bil.getWeightage());
            krResponseJson.put("completionCriteria", linkKR.getCompletionCriteria());
            totalWeights += bil.getWeightage().doubleValue();
            listOfKrs.add(krResponseJson);
        }
        subObjectiveData.put("linkKrs", listOfKrs);
        this.objectiveAndKrsForSubObjectives(subObjectiveData, totalWeights);
    }

    private void objectiveAndKrsForSubObjectives(HashMap<String, Object> subObjectiveData, double totalWeights) {
        try {
            Double sumOfTotalProgress = 0.0;
            ArrayList listOfKrs = (ArrayList)subObjectiveData.get("linkKrs");
            for (Object singleKr : listOfKrs) {
                double krsCompletion;
                double krWeightage;
                HashMap krData = (HashMap)singleKr;
                if (krData.get("Progress Criteria").equals("Target")) {
                    if (!PropertyValidator.isValid(krData.get("weightage")) || !PropertyValidator.isValid(krData.get("krsCompletion"))) continue;
                    krWeightage = (Double)krData.get("weightage");
                    krsCompletion = (Double)krData.get("krsCompletion");
                    sumOfTotalProgress = sumOfTotalProgress + krWeightage / totalWeights * krsCompletion;
                    continue;
                }
                if (!krData.get("Progress Criteria").equals("By Items")) continue;
                krWeightage = (Double)krData.get("weightage");
                krsCompletion = this.getCompletionCriteriaOfObjectives(krData);
                if (!PropertyValidator.isValid((Object)krsCompletion) || !PropertyValidator.isValid((Object)krWeightage)) continue;
                sumOfTotalProgress = sumOfTotalProgress + krWeightage / totalWeights * krsCompletion;
            }
            if (PropertyValidator.isValid((Object)subObjectiveData.get("linkedCardWeights"))) {
                HashMap objCompletion = (HashMap)subObjectiveData.get("completion");
                double linkedCardWeights = (Double)subObjectiveData.get("linkedCardWeights");
                objCompletion.put("ByLinkedItemStatus", Double.valueOf(dfSharp.format(sumOfTotalProgress + linkedCardWeights / totalWeights * (Double)objCompletion.get("ByLinkedItemStatus"))));
                objCompletion.put("ByChildrenOfLinkeditemsStatus", Double.valueOf(dfSharp.format(sumOfTotalProgress + linkedCardWeights / totalWeights * (Double)objCompletion.get("ByChildrenOfLinkeditemsStatus"))));
                objCompletion.put("ByTeamStoriesStatus", Double.valueOf(dfSharp.format(sumOfTotalProgress + linkedCardWeights / totalWeights * (Double)objCompletion.get("ByTeamStoriesStatus"))));
                objCompletion.put("ByChildrenOfLinkedItemsEstimate", Double.valueOf(dfSharp.format(sumOfTotalProgress + linkedCardWeights / totalWeights * (Double)objCompletion.get("ByChildrenOfLinkedItemsEstimate"))));
                objCompletion.put("ByTeamStoriesEstimate", Double.valueOf(dfSharp.format(sumOfTotalProgress + linkedCardWeights / totalWeights * (Double)objCompletion.get("ByTeamStoriesEstimate"))));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching objective and Kr Calculation for Sub Objectives by api key -> ", (Throwable)e);
        }
    }

    private HashMap<String, Object> objectiveKrsCalculation(BaseItem linkKR, HashMap<String, Fields> linkFields, HashMap<String, String> fieldsMap) {
        LinkedHashMap responseJson = new LinkedHashMap();
        try {
            responseJson = this.getDataBySelectedFields(linkKR, linkFields, fieldsMap);
            this.piSetObjectivesCalculation(linkKR, (HashMap)responseJson, fieldsMap);
            if (responseJson.get("Progress Criteria").equals("Target") && PropertyValidator.isValid((Object)linkKR.getFields()) && PropertyValidator.isValid(linkKR.getFields().keySet())) {
                String progressCriteria = "";
                int targetValue = -1;
                int progress = -1;
                for (String fieldId : linkKR.getFields().keySet()) {
                    Map linkBaseItemFields = linkKR.getFields();
                    Fields linkedField = linkFields.get(fieldId);
                    if (linkedField.getTitle().equals("Progress Criteria")) {
                        progressCriteria = (String)linkBaseItemFields.get(fieldId);
                    }
                    if (linkedField.getTitle().equals("Target Value")) {
                        targetValue = (Integer)linkBaseItemFields.get(fieldId);
                    }
                    if (!linkedField.getTitle().equals("Progress")) continue;
                    progress = (Integer)linkBaseItemFields.get(fieldId);
                }
                if (progressCriteria.equals("Target") && targetValue > -1 && progress > -1) {
                    responseJson.put("krsCompletion", (double)(progress * 100) / (double)targetValue);
                    responseJson.remove("completion");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching objective Kr Calculation by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    public Map<String, Object> getAllglobalObjectives(String boardId, boolean isPiBoard, String fields, String expand, int startAt, int pageLimit) {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        try {
            HashMap fieldsMap = this.getfieldsMap(fields, expand);
            List listOfBoardBaseItemLink = new ArrayList();
            List listOfAllBoardBaseItemLink = this.baseItemLinkRepository.findBySessionIdAndType(boardId, "Objective");
            listOfBoardBaseItemLink = this.getBaseItemLinks(boardId, "Objective", startAt, pageLimit);
            this.processSubObjectives(boardId, responseJson, listOfBoardBaseItemLink, listOfAllBoardBaseItemLink, fieldsMap, isPiBoard, startAt, pageLimit);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching objective Kr Calculation by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    private void processSubObjectives(String boardId, Map<String, Object> responseJson, List<DBObject> listOfBoardBaseItemLink, List<BaseItemLink> listOfAllBoardBaseItemLink, HashMap<String, String> fieldsMap, boolean isPiObjectives, int startAt, int pageLimit) {
        try {
            HashMap<String, BaseItemLink> baseItemLinkMapByIds = new HashMap<String, BaseItemLink>();
            ArrayList<BaseItemLink> listOfBaseItemLinkIds = new ArrayList<BaseItemLink>();
            for (DBObject baseItemLink : listOfBoardBaseItemLink) {
                BaseItemLink typeCastBaseItemLink = (BaseItemLink)this.mongoConverter.read(BaseItemLink.class, (Object)baseItemLink);
                if (PropertyValidator.isValid(baseItemLinkMapByIds.get(typeCastBaseItemLink.getId()))) continue;
                baseItemLinkMapByIds.put(typeCastBaseItemLink.getId().toString(), typeCastBaseItemLink);
                listOfBaseItemLinkIds.add(typeCastBaseItemLink);
            }
            List listOfObjectiveBaseItemOfBoard = this.baseItemRepository.findByBaseItemLinksIn(listOfBaseItemLinkIds);
            ArrayList<String> listOfSelectedObjGroup = new ArrayList<String>();
            HashMap<String, String> checkDuplicateSelectedObjGroup = new HashMap<String, String>();
            HashMap<String, Object> objectiveBaseItemsMapByIds = new HashMap<String, Object>();
            ArrayList<ItemType> itemType = new ArrayList<ItemType>();
            HashMap<String, ItemType> checkDuplicateItemType = new HashMap<String, ItemType>();
            ArrayList<String> baseItemLinksOfOKRBaseItems = new ArrayList<String>();
            ArrayList<String> backLogItemsLinkObjective = new ArrayList<String>();
            ArrayList<String> globallinkBaseItems = new ArrayList<String>();
            if (PropertyValidator.isValid((Collection)listOfObjectiveBaseItemOfBoard) && pageLimit > 0) {
                for (Object objective : listOfObjectiveBaseItemOfBoard) {
                    if (PropertyValidator.isValid((Collection)objective.getBaseItemLinks())) {
                        for (BaseItemLink baseItemLink : objective.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid(checkDuplicateSelectedObjGroup.get(baseItemLink.getBaseItemId())) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && PropertyValidator.isValid((Object)baseItemLink.getLinkType()) && baseItemLink.getLinkType().equals("parent_group_objective")) {
                                listOfSelectedObjGroup.add(baseItemLink.getBaseItemId());
                                checkDuplicateSelectedObjGroup.put(baseItemLink.getBaseItemId(), baseItemLink.getBaseItemId());
                            }
                            if (!PropertyValidator.isValid(baseItemLinkMapByIds.get(baseItemLink.getId()))) {
                                baseItemLinkMapByIds.put(baseItemLink.getId().toString(), baseItemLink);
                                listOfBaseItemLinkIds.add(baseItemLink);
                            }
                            if (!isPiObjectives && !baseItemLink.isArchive() && PropertyValidator.isValid((Object)baseItemLink.getSessionId()) && baseItemLink.getSessionId().equals(boardId) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId())) {
                                globallinkBaseItems.add(baseItemLink.getBaseItemId());
                            } else if (!baseItemLink.isArchive() && PropertyValidator.isValid((Object)baseItemLink.getLinkType()) && baseItemLink.getLinkType().equals(EnumKendis.CHILD_OBJECTIVE.getCode()) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId())) {
                                baseItemLinksOfOKRBaseItems.add(baseItemLink.getBaseItemId());
                            }
                            if (isPiObjectives || baseItemLink.isArchive() || !PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !baseItemLink.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode()) || !PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) || !PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId())) continue;
                            backLogItemsLinkObjective.add(baseItemLink.getBaseItemId());
                        }
                    }
                    if (PropertyValidator.isValid((Object)objective.getItemType()) && !PropertyValidator.isValid(checkDuplicateItemType.get(objective.getItemType().getId().toString()))) {
                        checkDuplicateItemType.put(objective.getItemType().getId().toString(), objective.getItemType());
                        itemType.add(objective.getItemType());
                    }
                    objectiveBaseItemsMapByIds.put(objective.getId(), objective);
                }
                List listOfAllGroupObjectiveBaseItemOfBoard = this.baseItemRepository.findByIdIn(listOfSelectedObjGroup);
                if (PropertyValidator.isValid((Collection)listOfAllGroupObjectiveBaseItemOfBoard)) {
                    for (BaseItem objGroup : listOfAllGroupObjectiveBaseItemOfBoard) {
                        ArrayList linkBaseItemList = new ArrayList();
                        if (PropertyValidator.isValid((Object)objGroup) && PropertyValidator.isValid((Collection)objGroup.getBaseItemLinks())) {
                            for (BaseItemLink baseItemLink : objGroup.getBaseItemLinks()) {
                                if (PropertyValidator.isValid(objectiveBaseItemsMapByIds.get(baseItemLink.getBaseItemId())) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && PropertyValidator.isValid((Object)baseItemLink.getLinkType()) && baseItemLink.getLinkType().equals("child_group_objective")) {
                                    linkBaseItemList.add(objectiveBaseItemsMapByIds.get(baseItemLink.getBaseItemId()));
                                }
                                if (PropertyValidator.isValid(baseItemLinkMapByIds.get(baseItemLink.getId()))) continue;
                                baseItemLinkMapByIds.put(baseItemLink.getId().toString(), baseItemLink);
                                listOfBaseItemLinkIds.add(baseItemLink);
                            }
                        }
                        if (PropertyValidator.isValid((Object)objGroup.getItemType()) && !PropertyValidator.isValid(checkDuplicateItemType.get(objGroup.getItemType().getId().toString()))) {
                            checkDuplicateItemType.put(objGroup.getItemType().getId().toString(), objGroup.getItemType());
                            itemType.add(objGroup.getItemType());
                        }
                        objGroup.setBaseItemList(linkBaseItemList);
                    }
                }
                HashMap listOfKRsMapById = new HashMap();
                if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("KR"))) {
                    this.getKrDataForObjectives(listOfKRsMapById, baseItemLinksOfOKRBaseItems, itemType, checkDuplicateItemType, listOfBaseItemLinkIds);
                }
                HashMap globalKrObjectivesById = new HashMap();
                HashMap globalObjectivesCOmpleationById = new HashMap();
                if (PropertyValidator.isValid(globallinkBaseItems)) {
                    List globallinkBaseItemsList = this.baseItemRepository.findByIdIn(globallinkBaseItems);
                    HashMap<String, BaseItem> globallinkBaseItemsMapById = new HashMap<String, BaseItem>();
                    for (BaseItem item : globallinkBaseItemsList) {
                        globallinkBaseItemsMapById.put(item.getId(), item);
                    }
                    this.setObjectiveWithLinkKr(listOfObjectiveBaseItemOfBoard, globallinkBaseItemsMapById, itemType, globalKrObjectivesById);
                    globalObjectivesCOmpleationById = this.globalObjectiveDataPrep(backLogItemsLinkObjective, listOfObjectiveBaseItemOfBoard);
                }
                HashMap linkFields = this.getObjectiveFields(itemType);
                this.objectiveService.fetchObjGroupsWithLinkedItems(listOfAllGroupObjectiveBaseItemOfBoard, listOfBaseItemLinkIds);
                ArrayList<LinkedHashMap> listOfSubObjectiveData = new ArrayList<LinkedHashMap>();
                HashMap<String, BaseItem> checkDuplicateBaseItem = new HashMap<String, BaseItem>();
                for (BaseItem baseItemGroup : listOfAllGroupObjectiveBaseItemOfBoard) {
                    if (!PropertyValidator.isValid((Collection)baseItemGroup.getBaseItemList())) continue;
                    ArrayList baseItemObjList = (ArrayList)baseItemGroup.getBaseItemList();
                    for (BaseItem baseItemObj : baseItemObjList) {
                        if (PropertyValidator.isValid(checkDuplicateBaseItem.get(baseItemObj.getId()))) continue;
                        checkDuplicateBaseItem.put(baseItemObj.getId(), baseItemObj);
                        LinkedHashMap subObjectiveData = this.getDataBySelectedFields(baseItemObj, linkFields, fieldsMap);
                        if (PropertyValidator.isValid(globalObjectivesCOmpleationById.get(baseItemObj.getId()))) {
                            this.globalSetObjectivesCalculation(baseItemObj, (HashMap)subObjectiveData, fieldsMap, globalObjectivesCOmpleationById);
                            if (PropertyValidator.isValid((Object)subObjectiveData) && PropertyValidator.isValid((Collection)baseItemObj.getBaseItemLinks()) && (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("KR")))) {
                                this.globalKeyResultCalculation(baseItemObj, (HashMap)subObjectiveData, globalKrObjectivesById, linkFields, fieldsMap, globalObjectivesCOmpleationById);
                            }
                        } else {
                            this.piSetObjectivesCalculation(baseItemObj, (HashMap)subObjectiveData, fieldsMap);
                            if (PropertyValidator.isValid((Object)subObjectiveData) && PropertyValidator.isValid((Collection)baseItemObj.getBaseItemLinks()) && (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("KR")))) {
                                this.keyResultCalculation(baseItemObj, (HashMap)subObjectiveData, listOfKRsMapById, linkFields, fieldsMap);
                            }
                        }
                        if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("groupName"))) {
                            subObjectiveData.put("TeamGroupName", baseItemGroup.getTitle());
                        }
                        listOfSubObjectiveData.add(subObjectiveData);
                    }
                }
                responseJson.put("startAt", startAt);
                responseJson.put("pageLimit", pageLimit);
                responseJson.put("total", listOfAllBoardBaseItemLink.size());
                responseJson.put("data", listOfSubObjectiveData);
            } else {
                responseJson.put("startAt", startAt);
                responseJson.put("pageLimit", pageLimit);
                responseJson.put("total", listOfAllBoardBaseItemLink.size());
                responseJson.put("data", new ArrayList());
            }
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while processing Sub Objectives by api key -> ", (Throwable)e);
        }
    }

    public Map<String, Object> getObjectivesByActiveSessionBoardId(String activeSessionId, String fields, String expand, int startAt, int pageLimit) {
        LinkedHashMap<String, Object> responseJson = new LinkedHashMap<String, Object>();
        try {
            SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)activeSessionId));
            if (PropertyValidator.isValid((Object)activeSessionBoard)) {
                HashMap fieldsMap = this.getfieldsMap(fields, expand);
                if (activeSessionBoard.getSession().getLoadOldObjectivesView().equals(false)) {
                    List listOfBoardBaseItemLink = new ArrayList();
                    List listOfAllBoardBaseItemLink = this.baseItemLinkRepository.findBySessionIdAndType(activeSessionBoard.getSession().getId(), "Objective");
                    listOfBoardBaseItemLink = this.getBaseItemLinks(activeSessionBoard.getSession().getId(), "Objective", startAt, pageLimit);
                    this.processSubObjectives(activeSessionBoard.getSession().getId(), responseJson, listOfBoardBaseItemLink, listOfAllBoardBaseItemLink, fieldsMap, true, startAt, pageLimit);
                } else {
                    this.getOldObjectivesByActiveSessionBoardId(activeSessionBoard, fieldsMap, responseJson, false);
                }
            } else {
                responseJson.put("errorMessages", "Board does not exist or you do not have permission to see it.");
            }
            return responseJson;
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while fetching objectives by active session board id by api key -> ", (Throwable)e);
            return responseJson;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processGroupObjectiveData(String boardId, HashMap<String, Object> responseJson, List<BaseItemLink> listOfBoardBaseItemLink, HashMap<String, String> groupNameMap, HashMap<String, String> fieldsMap, boolean isPiBoard) {
        try {
            HashMap<String, BaseItemLink> groupBaseItemLinkMapByIds = new HashMap<String, BaseItemLink>();
            HashMap<String, BaseItemLink> baseItemLinkMapByIds = new HashMap<String, BaseItemLink>();
            ArrayList<BaseItemLink> listOfBaseItemLinkIds = new ArrayList<BaseItemLink>();
            for (BaseItemLink baseItemLink : listOfBoardBaseItemLink) {
                if (PropertyValidator.isValid((Object)baseItemLink.getTeamId())) {
                    groupBaseItemLinkMapByIds.put(baseItemLink.getId().toString(), baseItemLink);
                }
                baseItemLinkMapByIds.put(baseItemLink.getId().toString(), baseItemLink);
                listOfBaseItemLinkIds.add(baseItemLink);
            }
            List listOfAllBaseItemOfBoard = this.baseItemRepository.findByBaseItemLinksIn(listOfBaseItemLinkIds);
            ArrayList<BaseItem> listOfSelectedObjGroup = new ArrayList<BaseItem>();
            HashMap<String, BaseItem> baseItemsMapByIds = new HashMap<String, BaseItem>();
            ArrayList<ItemType> itemType = new ArrayList<ItemType>();
            HashMap<String, ItemType> checkDuplicateItemType = new HashMap<String, ItemType>();
            ArrayList<BaseItem> listOfKRs = new ArrayList<BaseItem>();
            if (PropertyValidator.isValid((Collection)listOfAllBaseItemOfBoard)) {
                for (BaseItem objGroup : listOfAllBaseItemOfBoard) {
                    if (PropertyValidator.isValid((Collection)objGroup.getBaseItemLinks())) {
                        for (BaseItemLink baseItemLink : objGroup.getBaseItemLinks()) {
                            if (!PropertyValidator.isValid(groupBaseItemLinkMapByIds.get(baseItemLink.getId())) || !PropertyValidator.isValid((Object)groupNameMap.get(objGroup.getTitle())) && !PropertyValidator.isValid(groupNameMap)) continue;
                            listOfSelectedObjGroup.add(objGroup);
                            break;
                        }
                    }
                    if (PropertyValidator.isValid((Object)objGroup.getItemType()) && !PropertyValidator.isValid(checkDuplicateItemType.get(objGroup.getItemType().getId().toString()))) {
                        checkDuplicateItemType.put(objGroup.getItemType().getId().toString(), objGroup.getItemType());
                        itemType.add(objGroup.getItemType());
                    }
                    if (PropertyValidator.isValid((Object)objGroup.getType()) && objGroup.getType().equals(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) {
                        listOfKRs.add(objGroup);
                    }
                    baseItemsMapByIds.put(objGroup.getId().toString(), objGroup);
                }
            }
            ArrayList<String> backLogItemsLinkObjective = new ArrayList<String>();
            HashMap<String, Double> groupObjectiveWeightages = new HashMap<String, Double>();
            if (PropertyValidator.isValid(listOfSelectedObjGroup)) {
                for (BaseItem baseItem : listOfSelectedObjGroup) {
                    double totalWeights = 0.0;
                    ArrayList linkBaseItemList = new ArrayList();
                    if (PropertyValidator.isValid((Object)baseItem) && PropertyValidator.isValid((Collection)baseItem.getBaseItemLinks())) {
                        for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                            if (PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) && PropertyValidator.isValid((Object)baseItemLink.getBaseItemId())) {
                                linkBaseItemList.add(baseItemsMapByIds.get(baseItemLink.getBaseItemId()));
                                totalWeights += baseItemLink.getWeightage().doubleValue();
                                groupObjectiveWeightages.put(baseItemLink.getBaseItemId(), baseItemLink.getWeightage());
                            }
                            if (baseItemLink.isArchive() || !PropertyValidator.isValid((Object)baseItemLink.getLinkType()) || !baseItemLink.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode()) || !PropertyValidator.isValid((Object)baseItemLink.getBaseItemId()) || !PropertyValidator.isValid((Object)baseItemLink.getReleaseTrainId())) continue;
                            backLogItemsLinkObjective.add(baseItemLink.getBaseItemId());
                        }
                    }
                    groupObjectiveWeightages.put(baseItem.getId(), totalWeights);
                    if (!isPiBoard) continue;
                    baseItem.setBaseItemList(linkBaseItemList);
                }
                HashMap<String, BaseItem> listOfKRsMapById = new HashMap<String, BaseItem>();
                if (PropertyValidator.isValid(listOfKRs) && (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("KR")))) {
                    for (BaseItem KRs : listOfKRs) {
                        listOfKRsMapById.put(KRs.getId(), KRs);
                        if (!PropertyValidator.isValid((Collection)KRs.getBaseItemLinks())) continue;
                        for (BaseItemLink bil : KRs.getBaseItemLinks()) {
                            if (bil.isArchive() || !PropertyValidator.isValid((Object)bil.getItemId())) continue;
                            listOfBaseItemLinkIds.add(bil);
                        }
                    }
                    this.fetchIndividualObjectiveWithLinkedItems(listOfKRs, listOfBaseItemLinkIds);
                }
                HashMap hashMap = new HashMap();
                HashMap globalObjectivesCOmpleationById = new HashMap();
                if (!isPiBoard && PropertyValidator.isValid((Collection)listOfAllBaseItemOfBoard)) {
                    HashMap hashMap2 = this.setGroupObjectiveWithLinksubObjectiveAndLinkKr(listOfSelectedObjGroup, listOfAllBaseItemOfBoard, itemType);
                    globalObjectivesCOmpleationById = this.objectiveServiceImpl.calculateOkrAndGroupCompletion(listOfSelectedObjGroup, boardId, new HashMap());
                } else {
                    this.objectiveService.fetchObjGroupsWithLinkedItems(listOfSelectedObjGroup, listOfBaseItemLinkIds);
                }
                HashMap linkFields = this.getObjectiveFields(itemType);
                ArrayList groupObjectiveDataList = new ArrayList();
                for (BaseItem baseItemGroup : listOfSelectedObjGroup) {
                    HashMap<String, Object> groupObjectiveData = new HashMap<String, Object>();
                    ArrayList<LinkedHashMap> listOfCommitedSubObjectiveData = new ArrayList<LinkedHashMap>();
                    ArrayList<LinkedHashMap> listOfUncommittedSubObjectiveData = new ArrayList<LinkedHashMap>();
                    HashMap calDataForObjective = this.getGroupObjectivesCompletionFields();
                    ArrayList listOfItemsLinkedWithObjectives = new ArrayList();
                    if (PropertyValidator.isValid((Collection)baseItemGroup.getBaseItemList())) {
                        ArrayList baseItemObjList = (ArrayList)baseItemGroup.getBaseItemList();
                        for (BaseItem baseItemObj : baseItemObjList) {
                            LinkedHashMap subObjectiveData = this.getDataBySelectedFields(baseItemObj, linkFields, fieldsMap);
                            if (PropertyValidator.isValid(globalObjectivesCOmpleationById.get(baseItemObj.getId()))) {
                                void var19_27;
                                if (!PropertyValidator.isValid(var19_27.get(baseItemObj.getId())) && PropertyValidator.isValid((Object)subObjectiveData)) {
                                    this.globalSetObjectivesCalculation(baseItemObj, (HashMap)subObjectiveData, fieldsMap, globalObjectivesCOmpleationById);
                                    if (PropertyValidator.isValid((Collection)baseItemObj.getBaseItemLinks()) && (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("KR")))) {
                                        this.globalKeyResultCalculation(baseItemObj, (HashMap)subObjectiveData, (HashMap)var19_27, linkFields, fieldsMap, globalObjectivesCOmpleationById);
                                    }
                                }
                            } else {
                                this.piSetObjectivesCalculation(baseItemObj, (HashMap)subObjectiveData, fieldsMap);
                                if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("completion")) || PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) {
                                    HashMap checkDuplicateLinkItems = new HashMap();
                                    this.objectiveLinkItemsCount(baseItemObj, null, listOfItemsLinkedWithObjectives, calDataForObjective, checkDuplicateLinkItems);
                                }
                                if (PropertyValidator.isValid((Collection)baseItemObj.getBaseItemLinks()) && (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("KR")))) {
                                    this.keyResultCalculation(baseItemObj, (HashMap)subObjectiveData, listOfKRsMapById, linkFields, fieldsMap);
                                    subObjectiveData.put("completionCriteria", baseItemObj.getCompletionCriteria());
                                    subObjectiveData.put("weightage", groupObjectiveWeightages.get(baseItemObj.getId()));
                                }
                            }
                            if (baseItemObj.getType().equals("Objective-Committed")) {
                                listOfCommitedSubObjectiveData.add(subObjectiveData);
                                continue;
                            }
                            if (!baseItemObj.getType().equals("Objective-Uncommitted")) continue;
                            listOfUncommittedSubObjectiveData.add(subObjectiveData);
                        }
                    }
                    if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("GroupType"))) {
                        groupObjectiveData.put("GroupType", baseItemGroup.getType());
                    }
                    if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("groupName"))) {
                        groupObjectiveData.put("TeamGroupName", baseItemGroup.getTitle());
                    }
                    if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("type"))) {
                        groupObjectiveData.put("type", baseItemGroup.getType());
                    }
                    if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("committedObjectives"))) {
                        groupObjectiveData.put("CommitedObjCount", listOfCommitedSubObjectiveData.size());
                        groupObjectiveData.put("CommittedObjectives", listOfCommitedSubObjectiveData);
                    }
                    if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("uncommitedObjectives"))) {
                        groupObjectiveData.put("UncommitedObjCount", listOfUncommittedSubObjectiveData.size());
                        groupObjectiveData.put("UncommitedObjectives", listOfUncommittedSubObjectiveData);
                    }
                    if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("completion")) || PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) {
                        if (PropertyValidator.isValid(globalObjectivesCOmpleationById.get(baseItemGroup.getId()))) {
                            this.globalSetObjectivesCalculation(baseItemGroup, groupObjectiveData, fieldsMap, globalObjectivesCOmpleationById);
                        } else {
                            this.groupObjectiveCalculationByLinkOfAllItems(groupObjectiveData, calDataForObjective);
                        }
                    }
                    groupObjectiveDataList.add(groupObjectiveData);
                }
                if (PropertyValidator.isValid(groupObjectiveDataList)) {
                    responseJson.put("data", groupObjectiveDataList);
                } else {
                    responseJson.put("errorMessages", "Objective group does not exist or you do not have permission to see it.");
                    responseJson.put("error", new HashMap());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while process group objective data by api key -> ", (Throwable)e);
        }
    }

    public HashMap<String, Object> getAllglobalAndOtherGroupObjectiveByGroupName(String groupName, String boardId, String fields, String expand, boolean isPiBoard) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            HashMap fieldsMap = this.getfieldsMap(fields, expand);
            SessionBoard activeSessionBoard = null;
            boolean isPiBoardOldObjectives = false;
            if (isPiBoard) {
                activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
                boardId = activeSessionBoard.getSession().getId();
                if (!PropertyValidator.isValid((Object)activeSessionBoard.getSession().getLoadOldObjectivesView()) || !activeSessionBoard.getSession().getLoadOldObjectivesView().equals(false)) {
                    isPiBoardOldObjectives = true;
                }
            }
            if (!isPiBoardOldObjectives) {
                List listOfBoardBaseItemLink = this.baseItemLinkRepository.findBySessionId(boardId);
                if (PropertyValidator.isValid((Collection)listOfBoardBaseItemLink)) {
                    HashMap<String, String> groupNameMap = new HashMap<String, String>();
                    if (PropertyValidator.isValid((Object)groupName)) {
                        String[] teamNameArray;
                        for (String filed : teamNameArray = groupName.split(",")) {
                            groupNameMap.put(filed, filed);
                        }
                    }
                    this.processGroupObjectiveData(boardId, responseJson, listOfBoardBaseItemLink, groupNameMap, fieldsMap, isPiBoard);
                } else {
                    responseJson.put("errorMessages", "no data found against your given parameter.");
                }
            } else {
                this.getOldObjectivesByActiveSessionBoardId(activeSessionBoard, fieldsMap, responseJson, true);
            }
            return responseJson;
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while fetching group Objective By group name and active session board id by api key -> ", (Throwable)e);
            return responseJson;
        }
    }

    public HashMap<String, Object> getGroupObjectiveByGroupNameAndActiveSessionBoardId(String groupName, String activeSessionId, String fields, String expand) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)activeSessionId));
            HashMap fieldsMap = this.getfieldsMap(fields, expand);
            if (activeSessionBoard.getSession().getLoadOldObjectivesView().equals(false)) {
                List listOfBoardBaseItemLink = this.baseItemLinkRepository.findBySessionId(activeSessionBoard.getSession().getId());
                if (PropertyValidator.isValid((Object)activeSessionBoard) && PropertyValidator.isValid((Object)groupName)) {
                    String[] teamNameArray = groupName.split(",");
                    HashMap<String, String> groupNameMap = new HashMap<String, String>();
                    for (String filed : teamNameArray) {
                        groupNameMap.put(filed, filed);
                    }
                    this.processGroupObjectiveData(activeSessionId, responseJson, listOfBoardBaseItemLink, groupNameMap, fieldsMap, true);
                } else {
                    responseJson.put("errorMessages", "please send board id in the url and group key as a parameter.");
                }
            } else {
                this.getOldObjectivesByActiveSessionBoardId(activeSessionBoard, fieldsMap, responseJson, true);
            }
            return responseJson;
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while fetching group Objective By group name and active session board id by api key -> ", (Throwable)e);
            return responseJson;
        }
    }

    private HashMap<String, Object> getGroupObjectivesCompletionFields() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            responseJson.put("linkedDoneItems", 0);
            responseJson.put("linkedTotalItems", 0);
            responseJson.put("linkedDoneStories", 0);
            responseJson.put("linkedTotalStories", 0);
            responseJson.put("linkedDoneStoryPoints", 0);
            responseJson.put("linkedTotalStoryPoints", 0);
            responseJson.put("teamLinkedDoneStories", 0);
            responseJson.put("teamLinkedTotalStories", 0);
            responseJson.put("teamLinkedDoneStoryPoints", 0);
            responseJson.put("teamLinkedTotalStoryPoints", 0);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching group objective completion fields by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    private void groupObjectiveCalculationByLinkOfAllItems(HashMap<String, Object> groupObjectiveData, HashMap<String, Object> calDataForObjective) {
        try {
            HashMap<String, Double> responseJson = new HashMap<String, Double>();
            responseJson.put("ByLinkedItemStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("linkedDoneItems")).intValue(), ((Integer)calDataForObjective.get("linkedTotalItems")).intValue()))));
            responseJson.put("ByChildrenOfLinkeditemsStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("linkedDoneStories")).intValue(), ((Integer)calDataForObjective.get("linkedTotalStories")).intValue()))));
            responseJson.put("ByTeamStoriesStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("teamLinkedDoneStories")).intValue(), ((Integer)calDataForObjective.get("teamLinkedTotalStories")).intValue()))));
            responseJson.put("ByChildrenOfLinkedItemsEstimate", Double.valueOf(dfSharp.format(this.calculateProgress(Double.valueOf(String.valueOf(calDataForObjective.get("linkedDoneStoryPoints"))), Double.valueOf(String.valueOf(calDataForObjective.get("linkedTotalStoryPoints")))))));
            responseJson.put("ByTeamStoriesEstimate", Double.valueOf(dfSharp.format(this.calculateProgress(Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedDoneStoryPoints"))), Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedTotalStoryPoints")))))));
            groupObjectiveData.put("completion", responseJson);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching group objective calculation by link of all items by api key -> ", (Throwable)e);
        }
    }

    private void objectiveAndKrsForGroupObjectives(HashMap<String, Object> objectiveData, double totalWeights) {
        try {
            ArrayList listOfCommitedAndUncommitedSubObjectiveData = (ArrayList)objectiveData.get("CommittedObjectives");
            listOfCommitedAndUncommitedSubObjectiveData.addAll((ArrayList)objectiveData.get("UncommitedObjectives"));
            Double sumOfTotalProgress = 0.0;
            for (Object subObjective : listOfCommitedAndUncommitedSubObjectiveData) {
                HashMap subObjectiveData = (HashMap)subObjective;
                double completion = this.getCompletionCriteriaOfObjectives(subObjectiveData);
                double weightage = (Double)subObjectiveData.get("weightage");
                if (!PropertyValidator.isValid((Object)completion) || !PropertyValidator.isValid((Object)weightage)) continue;
                sumOfTotalProgress = sumOfTotalProgress + weightage / totalWeights * completion;
            }
            if (PropertyValidator.isValid((Object)objectiveData.get("completion"))) {
                HashMap responseJson = (HashMap)objectiveData.get("completion");
                responseJson.put("okrBasedCompletion", Double.valueOf(dfSharp.format(sumOfTotalProgress)));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching objective and Kr Calculation for Sub Objectives by api key -> ", (Throwable)e);
        }
    }

    private double getCompletionCriteriaOfObjectives(HashMap<String, Object> subObjectiveData) {
        double completion = 0.0;
        try {
            HashMap subObjCompletion = (HashMap)subObjectiveData.get("completion");
            if (subObjectiveData.get("completionCriteria").equals("LINKED_ITEM_STATUS")) {
                completion = (Double)subObjCompletion.get("ByLinkedItemStatus");
            } else if (subObjectiveData.get("completionCriteria").equals("CHILDREN_LINKED_ITEM_STATUS")) {
                completion = (Double)subObjCompletion.get("ByChildrenOfLinkeditemsStatus");
            } else if (subObjectiveData.get("completionCriteria").equals("CHILDREN_LINKED_ITEM_ESTIMATE")) {
                completion = (Double)subObjCompletion.get("ByChildrenOfLinkedItemsEstimate");
            } else if (subObjectiveData.get("completionCriteria").equals("TEAM_STORY_STATUS")) {
                completion = (Double)subObjCompletion.get("ByTeamStoriesStatus");
            } else if (subObjectiveData.get("completionCriteria").equals("TEAM_STORY_ESTIMATE")) {
                completion = (Double)subObjCompletion.get("ByTeamStoriesEstimate");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching Completion Criteria Of Objectives by api key -> ", (Throwable)e);
        }
        return completion;
    }

    private HashMap<String, Fields> getObjectiveFields(List<ItemType> itemType) {
        HashMap<String, Fields> response = new HashMap<String, Fields>();
        try {
            List itemTypeSchemes = this.itemTypeSchemeRepository.findByItemTypeIn(itemType);
            HashMap<String, ItemTypeScheme> checkDuplicateConfiguredGroupFields = new HashMap<String, ItemTypeScheme>();
            for (ItemTypeScheme itemTypeScheme : itemTypeSchemes) {
                if (PropertyValidator.isValid(checkDuplicateConfiguredGroupFields.get(itemTypeScheme.getId()))) continue;
                checkDuplicateConfiguredGroupFields.put(itemTypeScheme.getId(), itemTypeScheme);
                if (!PropertyValidator.isValid((Object)itemTypeScheme.getFieldsTemplate()) || !PropertyValidator.isValid((Collection)itemTypeScheme.getFieldsTemplate().getConfiguredFields())) continue;
                for (Fields configuredGroupField : itemTypeScheme.getFieldsTemplate().getConfiguredFields()) {
                    if (!PropertyValidator.isValid((Collection)configuredGroupField.getGroupFields())) continue;
                    for (Fields field : configuredGroupField.getGroupFields()) {
                        response.put(field.getId().toString(), field);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice fields by api key -> ", (Throwable)e);
        }
        return response;
    }

    private LinkedHashMap<String, Object> getDataBySelectedFields(BaseItem baseItemObj, HashMap<String, Fields> linkFields, HashMap<String, String> fieldsMap) {
        LinkedHashMap<String, Object> subObjectiveData = new LinkedHashMap<String, Object>();
        try {
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("key"))) {
                subObjectiveData.put("key", baseItemObj.getKey());
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("type"))) {
                subObjectiveData.put("type", baseItemObj.getType());
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("title"))) {
                subObjectiveData.put("title", baseItemObj.getTitle());
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("bvPlan"))) {
                subObjectiveData.put("bvPlan", baseItemObj.getBvPlan());
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("bvActual"))) {
                subObjectiveData.put("bvActual", baseItemObj.getBvActual());
            }
            if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("status"))) && PropertyValidator.isValid((Object)baseItemObj.getStatus()) && PropertyValidator.isValid((Object)baseItemObj.getStatus().getTitle())) {
                subObjectiveData.put("status", baseItemObj.getStatus().getTitle());
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("description"))) {
                subObjectiveData.put("description", baseItemObj.getDescription());
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("conversation"))) {
                subObjectiveData.put("conversation", this.getObjectiveConversation(baseItemObj));
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("watchers"))) {
                subObjectiveData.put("watchers", this.getObjectiveWatchers(baseItemObj));
            }
            if (PropertyValidator.isValid((Object)baseItemObj.getFields()) && PropertyValidator.isValid(baseItemObj.getFields().keySet()) && PropertyValidator.isValid(linkFields)) {
                for (String fieldId : baseItemObj.getFields().keySet()) {
                    Map linkBaseItemFields = baseItemObj.getFields();
                    if (!PropertyValidator.isValid((Object)linkFields.get(fieldId))) continue;
                    Fields linkedField = linkFields.get(fieldId);
                    String fieldTitle = linkedField.getTitle().replace(" ", "");
                    if (!PropertyValidator.isValid((Object)fieldsMap.get("all")) && !PropertyValidator.isValid((Object)fieldsMap.get(linkedField.getTitle())) && (!PropertyValidator.isValid((Object)fieldsMap.get("startDate")) || !fieldTitle.equalsIgnoreCase("startDate")) && (!PropertyValidator.isValid((Object)fieldsMap.get("endDate")) || !fieldTitle.equalsIgnoreCase("endDate"))) continue;
                    if ((PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get(linkedField.getTitle()))) && linkedField.getTitle().equals("Responsible")) {
                        HashMap responsible = (HashMap)linkBaseItemFields.get(fieldId);
                        subObjectiveData.put(linkedField.getTitle(), responsible.get("fullName"));
                        continue;
                    }
                    subObjectiveData.put(linkedField.getTitle(), linkBaseItemFields.get(fieldId));
                }
            }
            return subObjectiveData;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice Data By fields by api key -> ", (Throwable)e);
            return subObjectiveData;
        }
    }

    private void piSetObjectivesCalculation(BaseItem baseItemObj, HashMap<String, Object> subObjectiveData, HashMap<String, String> fieldsMap) {
        try {
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("completion")) || PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) {
                ArrayList listOfItemsLinkedWithObjectives = new ArrayList();
                HashMap objectiveCalculationResponseJson = this.objectiveCalculation(baseItemObj, null, listOfItemsLinkedWithObjectives);
                if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("completion"))) {
                    subObjectiveData.put("completion", objectiveCalculationResponseJson);
                }
                if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) {
                    subObjectiveData.put("linkedItems", listOfItemsLinkedWithObjectives);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while pi Set Objectives Calculation by api key -> ", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void globalSetObjectivesCalculation(BaseItem baseItemObj, HashMap<String, Object> subObjectiveData, HashMap<String, String> fieldsMap, HashMap<String, Double> globalObjectivesCOmpleationById) {
        try {
            if (!PropertyValidator.isValid((Object)fieldsMap.get("all")) && !PropertyValidator.isValid((Object)fieldsMap.get("completion")) && !PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) return;
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("completion"))) {
                subObjectiveData.put("completion", globalObjectivesCOmpleationById.get(baseItemObj.getId()));
            }
            if (!PropertyValidator.isValid((Object)fieldsMap.get("all")) && !PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) return;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while pi Set Objectives Calculation by api key -> ", (Throwable)e);
        }
    }

    private ArrayList<Object> getObjectiveConversation(BaseItem baseItemObj) {
        ArrayList<Object> subObjectiveConversationData = new ArrayList<Object>();
        try {
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("entityId", baseItemObj.getId());
            requestBody.put("entityType", "BaseItem");
            List savedConversation = this.externalEntitiesService.fetchConversation(requestBody);
            savedConversation.forEach(conv -> {
                HashMap<String, String> conversationData = new HashMap<String, String>();
                conversationData.put(conv.getUser().getFullName(), conv.getText());
                subObjectiveConversationData.add(conversationData);
            });
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice Conversation by api key -> ", (Throwable)e);
        }
        return subObjectiveConversationData;
    }

    private ArrayList<Object> getObjectiveWatchers(BaseItem baseItemObj) {
        ArrayList<Object> subObjectiveWatchersData = new ArrayList<Object>();
        try {
            HashMap<String, String> requestBody = new HashMap<String, String>();
            requestBody.put("entityId", baseItemObj.getId());
            requestBody.put("entityType", "BaseItem");
            List savedWatchers = this.externalEntitiesService.fetchWatchers(requestBody);
            savedWatchers.forEach(conv -> subObjectiveWatchersData.add(conv.getUser().getFullName()));
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice Conversation by api key -> ", (Throwable)e);
        }
        return subObjectiveWatchersData;
    }

    private void objectiveLinkItemsCount(BaseItem baseItemObj, String teamId, ArrayList<String> listOfItemsLinkedWithObjectives, HashMap<String, Object> calDataForObjective, HashMap<String, Object> checkDuplicateLinkItems) {
        try {
            if (PropertyValidator.isValid((Collection)baseItemObj.getLinkedItems())) {
                for (Item linkFeature : baseItemObj.getLinkedItems()) {
                    if (PropertyValidator.isValid((Collection)linkFeature.getSubItems())) {
                        for (Item linkStory : linkFeature.getSubItems()) {
                            Team linkStoryTeam = null;
                            if (PropertyValidator.isValid((Collection)linkStory.getTeamContainers()) && PropertyValidator.isValid((Object)teamId)) {
                                for (int index = 0; index < linkStory.getTeamContainers().size(); ++index) {
                                    TeamContainer teamConatiner = (TeamContainer)linkStory.getTeamContainers().get(index);
                                    if (!PropertyValidator.isValid((Object)teamConatiner)) continue;
                                    linkStoryTeam = teamConatiner.getTeam();
                                }
                            }
                            if (linkStory.getStatus().getCategory().equals("Done")) {
                                calDataForObjective.put("linkedDoneStories", (Integer)calDataForObjective.get("linkedDoneStories") + 1);
                                calDataForObjective.put("linkedDoneItems", (Integer)calDataForObjective.get("linkedDoneItems") + 1);
                                calDataForObjective.put("linkedDoneStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("linkedDoneStoryPoints"))) + Double.valueOf(String.valueOf(linkStory.getStoryPoints())));
                                if (PropertyValidator.isValid((Object)linkStoryTeam) && PropertyValidator.isValid((Object)teamId) && linkStoryTeam.getId().equals(teamId)) {
                                    calDataForObjective.put("teamLinkedDoneStories", (Integer)calDataForObjective.get("teamLinkedDoneStories") + 1);
                                    calDataForObjective.put("teamLinkedDoneStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedDoneStoryPoints"))) + Double.valueOf(String.valueOf(linkStory.getStoryPoints())));
                                }
                            }
                            calDataForObjective.put("linkedTotalStories", (Integer)calDataForObjective.get("linkedTotalStories") + 1);
                            calDataForObjective.put("linkedTotalItems", (Integer)calDataForObjective.get("linkedTotalItems") + 1);
                            calDataForObjective.put("linkedTotalStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("linkedTotalStoryPoints"))) + Double.valueOf(String.valueOf(linkStory.getStoryPoints())));
                            if (PropertyValidator.isValid((Object)linkStoryTeam) && PropertyValidator.isValid((Object)teamId) && linkStoryTeam.getId().equals(teamId)) {
                                calDataForObjective.put("teamLinkedTotalStories", (Integer)calDataForObjective.get("teamLinkedTotalStories") + 1);
                                calDataForObjective.put("teamLinkedTotalStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedTotalStoryPoints"))) + Double.valueOf(String.valueOf(linkStory.getStoryPoints())));
                            }
                            if (PropertyValidator.isValid((Object)linkStory.getJiraKey()) && !PropertyValidator.isValid((Object)checkDuplicateLinkItems.get(linkStory.getJiraKey()))) {
                                checkDuplicateLinkItems.put(linkStory.getJiraKey(), linkStory.getJiraKey());
                                listOfItemsLinkedWithObjectives.add(linkStory.getJiraKey());
                            }
                            if (!PropertyValidator.isValid((Object)linkStory.getTfsId()) || PropertyValidator.isValid((Object)checkDuplicateLinkItems.get(linkStory.getTfsId()))) continue;
                            checkDuplicateLinkItems.put(linkStory.getTfsId(), linkStory.getTfsId());
                            listOfItemsLinkedWithObjectives.add(linkStory.getTfsId());
                        }
                    }
                    if (linkFeature.getStatus().getCategory().equals("Done")) {
                        calDataForObjective.put("linkedDoneItems", (Integer)calDataForObjective.get("linkedDoneItems") + 1);
                    }
                    if (PropertyValidator.isValid((Object)linkFeature.getJiraKey()) && !PropertyValidator.isValid((Object)checkDuplicateLinkItems.get(linkFeature.getJiraKey()))) {
                        checkDuplicateLinkItems.put(linkFeature.getJiraKey(), linkFeature.getJiraKey());
                        listOfItemsLinkedWithObjectives.add(linkFeature.getJiraKey());
                    }
                    if (PropertyValidator.isValid((Object)linkFeature.getTfsId()) && !PropertyValidator.isValid((Object)checkDuplicateLinkItems.get(linkFeature.getTfsId()))) {
                        checkDuplicateLinkItems.put(linkFeature.getTfsId(), linkFeature.getTfsId());
                        listOfItemsLinkedWithObjectives.add(linkFeature.getTfsId());
                    }
                    calDataForObjective.put("linkedTotalItems", (Integer)calDataForObjective.get("linkedTotalItems") + 1);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while build objectice link item count by api key -> ", (Throwable)e);
        }
    }

    private HashMap<String, Object> objectiveCalculation(BaseItem baseItemObj, String teamId, ArrayList<String> listOfItemsLinkedWithObjectives) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("ByLinkedItemStatus", 0);
        responseJson.put("ByChildrenOfLinkeditemsStatus", 0);
        responseJson.put("ByChildrenOfLinkedItemsEstimate", 0);
        responseJson.put("ByTeamStoriesStatus", 0);
        responseJson.put("ByTeamStoriesEstimate", 0);
        try {
            HashMap<String, Integer> calDataForObjective = new HashMap<String, Integer>();
            HashMap checkDuplicateLinkItems = new HashMap();
            calDataForObjective.put("linkedDoneItems", 0);
            calDataForObjective.put("linkedTotalItems", 0);
            calDataForObjective.put("linkedDoneStories", 0);
            calDataForObjective.put("linkedTotalStories", 0);
            calDataForObjective.put("linkedDoneStoryPoints", 0);
            calDataForObjective.put("linkedTotalStoryPoints", 0);
            calDataForObjective.put("teamLinkedDoneStories", 0);
            calDataForObjective.put("teamLinkedTotalStories", 0);
            calDataForObjective.put("teamLinkedDoneStoryPoints", 0);
            calDataForObjective.put("teamLinkedTotalStoryPoints", 0);
            this.objectiveLinkItemsCount(baseItemObj, teamId, listOfItemsLinkedWithObjectives, calDataForObjective, checkDuplicateLinkItems);
            responseJson.put("ByLinkedItemStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("linkedDoneItems")).intValue(), ((Integer)calDataForObjective.get("linkedTotalItems")).intValue()))));
            responseJson.put("ByChildrenOfLinkeditemsStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("linkedDoneStories")).intValue(), ((Integer)calDataForObjective.get("linkedTotalStories")).intValue()))));
            responseJson.put("ByTeamStoriesStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("teamLinkedDoneStories")).intValue(), ((Integer)calDataForObjective.get("teamLinkedTotalStories")).intValue()))));
            responseJson.put("ByChildrenOfLinkedItemsEstimate", Double.valueOf(dfSharp.format(this.calculateProgress(Double.valueOf(String.valueOf(calDataForObjective.get("linkedDoneStoryPoints"))), Double.valueOf(String.valueOf(calDataForObjective.get("linkedTotalStoryPoints")))))));
            responseJson.put("ByTeamStoriesEstimate", Double.valueOf(dfSharp.format(this.calculateProgress(Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedDoneStoryPoints"))), Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedTotalStoryPoints")))))));
            return responseJson;
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching objective Calculation by api key -> ", (Throwable)e);
            return responseJson;
        }
    }

    private double calculateProgress(int numerator, int deNumerator) {
        try {
            if (deNumerator > 0) {
                return (double)numerator / (double)deNumerator * 100.0;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while calculating  objectice linked items by api key  -> ", (Throwable)e);
        }
        return 0.0;
    }

    private double calculateProgress(Double numerator, Double deNumerator) {
        try {
            if (deNumerator > 0.0) {
                return numerator / deNumerator * 100.0;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while calculating  objectice linked Story Points  by api key -> ", (Throwable)e);
        }
        return 0.0;
    }

    private HashMap<String, Object> fetchIndividualObjectiveWithLinkedItems(List<BaseItem> objectivesList, List<BaseItemLink> objectiveAndOkrBaseItemLinks) {
        HashMap<String, Object> objAndKrLinkedItemsMap = new HashMap<String, Object>();
        try {
            HashMap activeBoardItemsMap = new HashMap();
            activeBoardItemsMap = this.objectiveServiceImpl.fetchLinkedItems(null, objectiveAndOkrBaseItemLinks);
            HashMap<String, Item> linkedItemsByItemId = new HashMap<String, Item>();
            HashMap<String, Item> linkedItemsByJiraKeyOrTfsId = new HashMap<String, Item>();
            List linkedItems = (List)activeBoardItemsMap.get("linkedItems");
            for (Item item : linkedItems) {
                linkedItemsByItemId.put(item.getId(), item);
                if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                    linkedItemsByJiraKeyOrTfsId.put(item.getJiraKey(), item);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                linkedItemsByJiraKeyOrTfsId.put(item.getTfsId(), item);
            }
            for (BaseItem objectives : objectivesList) {
                this.objectiveServiceImpl.setLinkedItemsMapForOkr(objectives, linkedItemsByItemId, linkedItemsByJiraKeyOrTfsId, objAndKrLinkedItemsMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching Individual Objective With Linked Items by api key -> ", (Throwable)e);
        }
        return objAndKrLinkedItemsMap;
    }

    public void getOldObjectivesByActiveSessionBoardId(SessionBoard activeSessionBoard, HashMap<String, String> fieldsMap, Map<String, Object> responseJson, boolean groupObjective) {
        block12: {
            try {
                if (!PropertyValidator.isValid((Object)activeSessionBoard)) break block12;
                List activeSessionTeams = activeSessionBoard.getTeams();
                HashMap objectiveTeams = new HashMap();
                activeSessionTeams.forEach(team -> {
                    HashMap<String, String> teamDetails = new HashMap<String, String>();
                    teamDetails.put("id", team.getId());
                    teamDetails.put("title", team.getTitle());
                    teamDetails.put("label", team.getLabel());
                    teamDetails.put("color", team.getColor());
                    objectiveTeams.put(team.getId(), teamDetails);
                });
                ArrayList listObjectiveData = new ArrayList();
                ArrayList objectivesLinkItems = new ArrayList();
                if (PropertyValidator.isValid((Object)activeSessionBoard.getObjectivesMap())) {
                    for (String key : activeSessionBoard.getObjectivesMap().keySet()) {
                        Objective objectivesMap = (Objective)activeSessionBoard.getObjectivesMap().get(key);
                        if (!PropertyValidator.isValid((Collection)objectivesMap.getValues())) continue;
                        ArrayList arrayList = new ArrayList();
                        objectivesMap.getValues().forEach(value -> {
                            HashMap<String, Object> objectiveValue = new HashMap<String, Object>();
                            if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("title"))) {
                                objectiveValue.put("title", value.getTitle());
                            }
                            if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("type"))) {
                                objectiveValue.put("type", value.getType());
                            }
                            if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("bvPlan"))) {
                                objectiveValue.put("bvPlan", value.getPlanValue());
                            }
                            if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("bvActual"))) {
                                objectiveValue.put("bvActual", value.getActualValue());
                            }
                            if (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("groupName"))) {
                                HashMap teams = (HashMap)objectiveTeams.get(objectivesMap.getTeamId());
                                objectiveValue.put("TeamGroupName", teams.get("title"));
                            }
                            if (PropertyValidator.isValid((Collection)value.getItemIds()) && (PropertyValidator.isValid(fieldsMap.get("all")) || PropertyValidator.isValid(fieldsMap.get("completion")) || PropertyValidator.isValid(fieldsMap.get("linkedItems")))) {
                                objectivesLinkItems.addAll(value.getItemIds());
                                objectiveValue.put("linkedItems", value.getItemIds());
                                objectiveValue.put("teamId", objectivesMap.getTeamId());
                            }
                            listOfSubObjectiveData.add(objectiveValue);
                        });
                        if (groupObjective) {
                            HashMap groupObjectiveData = new HashMap();
                            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("title"))) {
                                HashMap team2 = (HashMap)objectiveTeams.get(objectivesMap.getTeamId());
                                groupObjectiveData.put("title", team2.get("title"));
                            }
                            groupObjectiveData.put("subObjectives", arrayList);
                            listObjectiveData.add(groupObjectiveData);
                            continue;
                        }
                        listObjectiveData.addAll(arrayList);
                    }
                    List allObjectivesLinkItems = this.itemRepository.findByIdInOrParentIn(objectivesLinkItems, objectivesLinkItems);
                    HashMap<String, Item> allObjectivesLinkItemsMapById = new HashMap<String, Item>();
                    for (Item item : allObjectivesLinkItems) {
                        allObjectivesLinkItemsMapById.put(item.getId(), item);
                    }
                    for (Object e : listObjectiveData) {
                        HashMap objectiveData;
                        if (groupObjective) {
                            objectiveData = (HashMap)e;
                            List groupObjectiveData = (List)objectiveData.get("subObjectives");
                            for (Object subObj : groupObjectiveData) {
                                this.oldObjectiveCalculation((HashMap)subObj, allObjectivesLinkItemsMapById, fieldsMap);
                            }
                            continue;
                        }
                        objectiveData = (HashMap)e;
                        this.oldObjectiveCalculation(objectiveData, allObjectivesLinkItemsMapById, fieldsMap);
                    }
                }
                if (PropertyValidator.isValid(listObjectiveData)) {
                    responseJson.put("data", listObjectiveData);
                } else {
                    responseJson.put("errorMessages", "Session objective does not exist or you do not have permission to see it.");
                }
            }
            catch (Exception e) {
                responseJson.put("error", "There are some issue in fetching data.");
                LOGGER.error("Error occurred while fetching old Objective With Linked Items by api key -> ", (Throwable)e);
            }
        }
    }

    private HashMap<String, Object> oldObjectiveCalculation(HashMap<String, Object> subObjectiveData, HashMap<String, Item> allObjectivesLinkItemsMapById, HashMap<String, String> fieldsMap) {
        try {
            List objectivesLinkItems = (List)subObjectiveData.get("linkedItems");
            String teamId = (String)subObjectiveData.get("teamId");
            HashMap<String, Number> responseJson = new HashMap<String, Number>();
            responseJson.put("ByLinkedItemStatus", 0);
            responseJson.put("ByChildrenOfLinkeditemsStatus", 0);
            responseJson.put("ByChildrenOfLinkedItemsEstimate", 0);
            responseJson.put("ByTeamStoriesStatus", 0);
            responseJson.put("ByTeamStoriesEstimate", 0);
            HashMap<String, Number> calDataForObjective = new HashMap<String, Number>();
            HashMap<String, String> checkDuplicateLinkItems = new HashMap<String, String>();
            ArrayList<String> listOfItemsLinkedWithObjectives = new ArrayList<String>();
            calDataForObjective.put("linkedDoneItems", 0);
            calDataForObjective.put("linkedTotalItems", 0);
            calDataForObjective.put("linkedDoneStories", 0);
            calDataForObjective.put("linkedTotalStories", 0);
            calDataForObjective.put("linkedDoneStoryPoints", 0);
            calDataForObjective.put("linkedTotalStoryPoints", 0);
            calDataForObjective.put("teamLinkedDoneStories", 0);
            calDataForObjective.put("teamLinkedTotalStories", 0);
            calDataForObjective.put("teamLinkedDoneStoryPoints", 0);
            calDataForObjective.put("teamLinkedTotalStoryPoints", 0);
            for (Object obj : objectivesLinkItems) {
                Item item = allObjectivesLinkItemsMapById.get(obj);
                if (PropertyValidator.isValid((Object)item) && item.getType().equals(Item.USER_STORY)) {
                    Team linkStoryTeam = null;
                    if (PropertyValidator.isValid((Collection)item.getTeamContainers()) && PropertyValidator.isValid((Object)teamId)) {
                        for (int index = 0; index < item.getTeamContainers().size(); ++index) {
                            TeamContainer teamConatiner = (TeamContainer)item.getTeamContainers().get(index);
                            if (!PropertyValidator.isValid((Object)teamConatiner)) continue;
                            linkStoryTeam = teamConatiner.getTeam();
                        }
                    }
                    if (item.getStatus().getCategory().equals("Done")) {
                        calDataForObjective.put("linkedDoneStories", (Integer)calDataForObjective.get("linkedDoneStories") + 1);
                        calDataForObjective.put("linkedDoneStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("linkedDoneStoryPoints"))) + Double.valueOf(String.valueOf(item.getStoryPoints())));
                        if (PropertyValidator.isValid((Object)linkStoryTeam) && PropertyValidator.isValid((Object)teamId) && linkStoryTeam.getId().equals(teamId)) {
                            calDataForObjective.put("teamLinkedDoneStories", (Integer)calDataForObjective.get("teamLinkedDoneStories") + 1);
                            calDataForObjective.put("teamLinkedDoneStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedDoneStoryPoints"))) + Double.valueOf(String.valueOf(item.getStoryPoints())));
                        }
                    }
                    calDataForObjective.put("linkedTotalStories", (Integer)calDataForObjective.get("linkedTotalStories") + 1);
                    calDataForObjective.put("linkedTotalStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("linkedTotalStoryPoints"))) + Double.valueOf(String.valueOf(item.getStoryPoints())));
                    if (PropertyValidator.isValid((Object)linkStoryTeam) && PropertyValidator.isValid((Object)teamId) && linkStoryTeam.getId().equals(teamId)) {
                        calDataForObjective.put("teamLinkedTotalStories", (Integer)calDataForObjective.get("teamLinkedTotalStories") + 1);
                        calDataForObjective.put("teamLinkedTotalStoryPoints", Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedTotalStoryPoints"))) + Double.valueOf(String.valueOf(item.getStoryPoints())));
                    }
                }
                if (item.getStatus().getCategory().equals("Done")) {
                    calDataForObjective.put("linkedDoneItems", (Integer)calDataForObjective.get("linkedDoneItems") + 1);
                }
                if (PropertyValidator.isValid((Object)item.getJiraKey()) && !PropertyValidator.isValid(checkDuplicateLinkItems.get(item.getJiraKey()))) {
                    checkDuplicateLinkItems.put(item.getJiraKey(), item.getJiraKey());
                    listOfItemsLinkedWithObjectives.add(item.getJiraKey());
                }
                if (PropertyValidator.isValid((Object)item.getTfsId()) && !PropertyValidator.isValid(checkDuplicateLinkItems.get(item.getTfsId()))) {
                    checkDuplicateLinkItems.put(item.getTfsId(), item.getTfsId());
                    listOfItemsLinkedWithObjectives.add(item.getTfsId());
                }
                calDataForObjective.put("linkedTotalItems", (Integer)calDataForObjective.get("linkedTotalItems") + 1);
            }
            responseJson.put("ByLinkedItemStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("linkedDoneItems")).intValue(), ((Integer)calDataForObjective.get("linkedTotalItems")).intValue()))));
            responseJson.put("ByChildrenOfLinkeditemsStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("linkedDoneStories")).intValue(), ((Integer)calDataForObjective.get("linkedTotalStories")).intValue()))));
            responseJson.put("ByTeamStoriesStatus", Double.valueOf(dfSharp.format(this.calculateProgress(((Integer)calDataForObjective.get("teamLinkedDoneStories")).intValue(), ((Integer)calDataForObjective.get("teamLinkedTotalStories")).intValue()))));
            responseJson.put("ByChildrenOfLinkedItemsEstimate", Double.valueOf(dfSharp.format(this.calculateProgress(Double.valueOf(String.valueOf(calDataForObjective.get("linkedDoneStoryPoints"))), Double.valueOf(String.valueOf(calDataForObjective.get("linkedTotalStoryPoints")))))));
            responseJson.put("ByTeamStoriesEstimate", Double.valueOf(dfSharp.format(this.calculateProgress(Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedDoneStoryPoints"))), Double.valueOf(String.valueOf(calDataForObjective.get("teamLinkedTotalStoryPoints")))))));
            subObjectiveData.remove("teamId");
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("completion"))) {
                subObjectiveData.put("completion", responseJson);
            }
            if (PropertyValidator.isValid((Object)fieldsMap.get("all")) || PropertyValidator.isValid((Object)fieldsMap.get("linkedItems"))) {
                subObjectiveData.put("linkedItems", listOfItemsLinkedWithObjectives);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while Calculation old Objective With Linked Items by api key -> ", (Throwable)e);
        }
        return null;
    }

    private HashMap<String, Object> getSessionBoard(List<SessionBoard> sessionBoards, HashMap<String, String> fieldsMap) {
        HashMap<String, Object> allSessionsMap = new HashMap<String, Object>();
        try {
            for (SessionBoard sessionBoard : sessionBoards) {
                Session session;
                if (PropertyValidator.isValid((Object)fieldsMap.get("active"))) {
                    allSessionsMap.put(sessionBoard.getId(), sessionBoard);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)fieldsMap.get("all")) && !PropertyValidator.isValid((Object)fieldsMap.get(sessionBoard.getState().getTitle())) || !PropertyValidator.isValid((Object)(session = sessionBoard.getSession()))) continue;
                this.putSessionBoardData(allSessionsMap, session, sessionBoard);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while featching Session board meta by api key -> ", (Throwable)e);
        }
        return allSessionsMap;
    }

    private void putSessionBoardData(HashMap<String, Object> allSessionsMap, Session session, SessionBoard sessionBoard) {
        try {
            if (!PropertyValidator.isValid((Object)allSessionsMap.get(session.getId()))) {
                HashMap<String, Object> allSessionBoardByState = new HashMap<String, Object>();
                allSessionBoardByState.put("id", session.getId());
                allSessionBoardByState.put("title", session.getTitle());
                allSessionBoardByState.put("states", new ArrayList());
                allSessionsMap.put(session.getId(), allSessionBoardByState);
            }
            HashMap<String, String> sessionBoardData = new HashMap<String, String>();
            sessionBoardData.put("id", sessionBoard.getId());
            sessionBoardData.put("title", sessionBoard.getState().getTitle());
            HashMap sessionBoardMap = (HashMap)allSessionsMap.get(session.getId());
            ArrayList sessionBoardMapById = (ArrayList)sessionBoardMap.get("states");
            sessionBoardMapById.add(sessionBoardData);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while featching Session board data meta by api key -> ", (Throwable)e);
        }
    }

    public List<Object> loadObjectiveJson(UserApiKey userApi, Map<String, String[]> params) throws Exception {
        if (!PropertyValidator.isValid((String[])params.get("boardId")) || params.get("boardId").length <= 0) {
            throw new KendisException("404", "Invalid Session Board Id passed");
        }
        Set wSpaces = this.getUserCollectstions(userApi);
        List sessions = this.sessionRepository.findLiteSessionsByIdInAndWorkSpaceIn(params.get("boardId"), (Collection)wSpaces);
        if (PropertyValidator.isValid((Collection)sessions)) {
            Map teams = null;
            Map sprints = null;
            if (PropertyValidator.isValid((String[])params.get("additionalColumns")) && PropertyValidator.isValid((Object)params.get("additionalColumns")[0])) {
                Map meta = this.getBoardMetaInMap(sessions, params.get("additionalColumns")[0]);
                teams = (Map)meta.get("teams");
                sprints = (Map)meta.get("sprints");
            }
            return this.objectiveService.fetchObjectivesForApi(sessions, teams, sprints, params);
        }
        throw new KendisException("404", "No Session Board found");
    }

    private Map getBoardMetaInMap(List<Session> sessions, String cols) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        HashMap<String, Team> teams = null;
        HashMap<String, Container> sprints = null;
        List<String> columns = Arrays.asList(cols.split(","));
        ArrayList<String> boardIds = new ArrayList<String>();
        boolean boolT = "teams".equals(cols) || columns.contains("team") || columns.contains("1");
        boolean boolC = "sprints".equals(cols) || columns.contains("sprint") || columns.contains("1");
        boolean boolS = "statuses".equals(cols);
        ArrayList<String> statusesP = new ArrayList<String>();
        ArrayList<String> statusesC = new ArrayList<String>();
        ArrayList<String> jiraS = null;
        ArrayList<String> tfsS = null;
        for (Session session : sessions) {
            if (boolS) {
                if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                    if (jiraS == null) {
                        jiraS = new ArrayList<String>();
                    }
                    jiraS.add(session.getId());
                } else if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                    if (tfsS == null) {
                        tfsS = new ArrayList<String>();
                    }
                    tfsS.add(session.getId());
                }
                statusesP.add(session.getItemWorkFlow().getId());
                statusesC.add(session.getSubItemWorkFlow().getId());
            }
            if (session.getActiveSessionBoard() == null) continue;
            boardIds.add(session.getActiveSessionBoard());
        }
        if (boolT || boolC) {
            List boards = this.sessionBoardRepository.findSessionBoardsByIdIn(boardIds);
            ArrayList<String> teamIds = new ArrayList<String>();
            ArrayList<String> sprintIds = new ArrayList<String>();
            for (SessionBoard board : boards) {
                if (boolT) {
                    for (Team tm : board.getTeams()) {
                        teamIds.add(tm.getId());
                    }
                }
                if (!boolC) continue;
                for (Container sp : board.getContainers()) {
                    sprintIds.add(sp.getId());
                }
            }
            if (boolT) {
                teams = new HashMap<String, Team>();
                List _teams = this.teamRepository.findTeamsByIdIn(teamIds);
                if ("teams".equals(cols)) {
                    meta.put(cols, _teams);
                    return meta;
                }
                for (Team team : _teams) {
                    teams.put(team.getId(), team);
                }
            }
            if (boolC) {
                sprints = new HashMap<String, Container>();
                List containers = this.containerRepository.findContainerByIdIn(sprintIds);
                if ("sprints".equals(cols)) {
                    meta.put(cols, containers);
                    return meta;
                }
                for (Container sprint : containers) {
                    sprints.put(sprint.getId(), sprint);
                }
            }
        }
        if (boolS) {
            List list = new ArrayList();
            List tStatuses = null;
            list = this.statusRepository.findStatsuesByWorkFlowIdIn(statusesP);
            if (tfsS != null) {
                tStatuses = this.statusRepository.findStatusesBySessionIdIn(tfsS);
            }
            if (PropertyValidator.isValid(jiraS)) {
                list.addAll(this.statusRepository.findStatsuesByJiraProjKeyNotNullAndSessionIdInAndItemType(jiraS, Item.Type.Feature.name()));
            }
            if (tStatuses != null) {
                list.addAll(tStatuses);
            }
            meta.put("parentStatuses", list);
            list = new ArrayList();
            list = this.statusRepository.findStatsuesByWorkFlowIdIn(statusesC);
            if (PropertyValidator.isValid(jiraS)) {
                list.addAll(this.statusRepository.findStatsuesByJiraProjKeyNotNullAndSessionIdInAndItemType(jiraS, Item.Type.UserStory.name()));
            }
            if (tStatuses != null) {
                list.addAll(tStatuses);
            }
            meta.put("childrenStatuses", list);
        }
        meta.put("teams", teams);
        meta.put("sprints", sprints);
        return meta;
    }

    private void mapDbProperties(String key, String name, Map<String, String> columns, Map<String, String> subColumns, Map<String, Boolean> apiFields, Set<String> dbnames) {
        if ((apiFields == null || Boolean.TRUE.equals(apiFields.get(name))) && dbnames != null) {
            if (name.equals("jiraId")) {
                dbnames.add("jiraKey");
            } else if (name.equals("teamsAndSprints")) {
                dbnames.add("teamContainers");
            } else if (key.equals("parentId") || key.equals("parentTitle")) {
                dbnames.add("parent");
                dbnames.add("jiraFieldByKey.parent");
                dbnames.add("tfsFieldByKey.ParentId");
                dbnames.add("tfsFieldByKey.ParentTitle");
            }
            dbnames.add(key);
        }
        columns.put(key, name);
        if (subColumns != null) {
            subColumns.put(key, name);
        }
    }

    public List getBoardTeamSprintJson(UserApiKey userApi, Map<String, Object> params) throws Exception {
        if (!PropertyValidator.isValid((Object)params.get("boardId"))) {
            throw new KendisException("404", "Invalid Session Board Id passed");
        }
        ArrayList<String> boardIds = new ArrayList<String>();
        boardIds.add((String)params.get("boardId"));
        Set wSpaces = this.getUserCollectstions(userApi);
        List sessions = this.sessionRepository.findSessionsByWorkSpaceInAndIdIn((Collection)wSpaces, boardIds);
        if (PropertyValidator.isValid((Collection)sessions)) {
            Session session = (Session)sessions.get(0);
            boardIds = new ArrayList();
            boardIds.add(session.getActiveSessionBoard());
            ArrayList<HashMap> result = new ArrayList<HashMap>();
            String type = (String)params.get("type");
            Map meta = this.getBoardMetaInMap(sessions, type);
            if ("teams".equals(type)) {
                List teams = null;
                teams = (List)meta.get(type);
                for (Team team : teams) {
                    result.add(team.toSimpleObject());
                }
            }
            if ("sprints".equals(type)) {
                List sprints = null;
                sprints = (List)meta.get(type);
                for (Container sprint : sprints) {
                    result.add(sprint.toSimpleObject());
                }
            }
            return result;
        }
        throw new KendisException("404", "No Session Board found");
    }

    public Map getBoardStatusesJson(UserApiKey userApi, Map<String, Object> params) throws Exception {
        if (!PropertyValidator.isValid((Object)params.get("boardId"))) {
            throw new KendisException("404", "Invalid Session Board Id passed");
        }
        ArrayList<String> boardIds = new ArrayList<String>();
        boardIds.add((String)params.get("boardId"));
        Set wSpaces = this.getUserCollectstions(userApi);
        List sessions = this.sessionRepository.findSessionsByWorkSpaceInAndIdIn((Collection)wSpaces, boardIds);
        if (PropertyValidator.isValid((Collection)sessions)) {
            Session session = (Session)sessions.get(0);
            boardIds = new ArrayList();
            boardIds.add(session.getActiveSessionBoard());
            HashMap result = new HashMap();
            String type = (String)params.get("type");
            Map meta = this.getBoardMetaInMap(sessions, type);
            return meta;
        }
        throw new KendisException("404", "No Session Board found");
    }

    public HashMap<String, Object> getItemsJson(UserApiKey userApi, Map<String, Object> params) throws Exception {
        if (!PropertyValidator.isValid((Object)params.get("boardId"))) {
            throw new KendisException("404", "Invalid Session Board Id passed");
        }
        ArrayList<String> boardIds = new ArrayList<String>();
        boardIds.add((String)params.get("boardId"));
        Set wSpaces = this.getUserCollectstions(userApi);
        List sessions = this.sessionRepository.findSessionsByIdInAndWorkSpaceIn(boardIds, (Collection)wSpaces);
        if (PropertyValidator.isValid((Collection)sessions)) {
            Session session = (Session)sessions.get(0);
            ArrayList<ObjectId> bids = new ArrayList<ObjectId>();
            bids.add(new ObjectId(session.getActiveSessionBoard()));
            HashMap iMap = new HashMap();
            ArrayList items = new ArrayList();
            HashSet<String> dbnames = null;
            HashMap<String, Boolean> apiFields = null;
            if (!PropertyValidator.isValid((Object)params.get("fields"))) {
                ArrayList<String> fields = new ArrayList<String>();
                fields.add(KendisUtils.camelCase((String)"kendis ID"));
                fields.add(KendisUtils.camelCase((String)"External Key"));
                fields.add(KendisUtils.camelCase((String)"External Url"));
                fields.add(KendisUtils.camelCase((String)"Summary"));
                fields.add(KendisUtils.camelCase((String)"Item Type"));
                fields.add(KendisUtils.camelCase((String)"Status"));
                fields.add(KendisUtils.camelCase((String)"Teams and Sprints"));
                fields.add(KendisUtils.camelCase((String)"jira ID"));
                fields.add(KendisUtils.camelCase((String)"azure ID"));
                fields.add(KendisUtils.camelCase((String)"Parent Id"));
                fields.add(KendisUtils.camelCase((String)"Parent Description"));
                fields.add(KendisUtils.camelCase((String)"Iteration Path"));
                fields.add(KendisUtils.camelCase((String)"Card Type"));
                params.put("fields", fields);
            }
            if (params.get("fields") != null) {
                dbnames = new HashSet<String>();
                dbnames.add("id");
                apiFields = new HashMap<String, Boolean>();
                List projection = (List)params.get("fields");
                for (String col : projection) {
                    apiFields.put(col, true);
                }
            }
            HashMap columns = new HashMap();
            HashMap subColumns = new HashMap();
            this.mapDbProperties("id", KendisUtils.camelCase((String)"kendis ID"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("jiraId", KendisUtils.camelCase((String)"jira ID"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("tfsId", KendisUtils.camelCase((String)"azure ID"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("jiraKey", KendisUtils.camelCase((String)"External Key"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("kendisKey", KendisUtils.camelCase((String)"External Key"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("externalReferenceURL", KendisUtils.camelCase((String)"External Url"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("title", KendisUtils.camelCase((String)"Summary"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("status", KendisUtils.camelCase((String)"Status"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("tfsFieldMap", KendisUtils.camelCase((String)"Azure Fields"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("duaDate", KendisUtils.camelCase((String)"Due Date"), columns, null, apiFields, dbnames);
            this.mapDbProperties("startDate", KendisUtils.camelCase((String)"Start Date"), columns, null, apiFields, dbnames);
            this.mapDbProperties("endDate", KendisUtils.camelCase((String)"End Date"), columns, null, apiFields, dbnames);
            this.mapDbProperties("storyPoints", KendisUtils.camelCase((String)"Estimates"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("issueType", KendisUtils.camelCase((String)"Card Type"), columns, null, apiFields, dbnames);
            this.mapDbProperties("tfsItemType", KendisUtils.camelCase((String)"Item Type"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("tfsAreaPath", KendisUtils.camelCase((String)"Area Path"), columns, null, apiFields, dbnames);
            this.mapDbProperties("tfsIterationPath", KendisUtils.camelCase((String)"Iteration Path"), columns, null, apiFields, dbnames);
            this.mapDbProperties("createdBy", KendisUtils.camelCase((String)"Created By"), columns, null, apiFields, dbnames);
            this.mapDbProperties("updatedBy", KendisUtils.camelCase((String)"Updated By"), columns, null, apiFields, dbnames);
            this.mapDbProperties("createdOn", KendisUtils.camelCase((String)"Created On"), columns, null, apiFields, dbnames);
            this.mapDbProperties("updatedOn", KendisUtils.camelCase((String)"Updated On"), columns, null, apiFields, dbnames);
            this.mapDbProperties("parentId", KendisUtils.camelCase((String)"Parent Id"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("parentTitle", KendisUtils.camelCase((String)"Parent Description"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("teamsAndSprints", KendisUtils.camelCase((String)"Teams and Sprints"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("score", KendisUtils.camelCase((String)"WSJF"), columns, null, apiFields, dbnames);
            this.mapDbProperties("param3", KendisUtils.camelCase((String)"Job Size"), columns, null, apiFields, dbnames);
            this.mapDbProperties("param1", KendisUtils.camelCase((String)"User Business Value"), columns, null, apiFields, dbnames);
            this.mapDbProperties("param2", KendisUtils.camelCase((String)"Time Criticality"), columns, null, apiFields, dbnames);
            this.mapDbProperties("param3", KendisUtils.camelCase((String)"Risk Reduction over Opportunity Enablement"), columns, null, apiFields, dbnames);
            this.mapDbProperties("subItems", KendisUtils.camelCase((String)"children"), columns, subColumns, apiFields, dbnames);
            this.mapDbProperties("lebal" + Item.Type.Feature.name(), session.getParentItem(), columns, null, null, null);
            this.mapDbProperties("lebal" + Item.Type.UserStory.name(), session.getChildItem(), columns, null, null, null);
            HashMap meta = new HashMap();
            Map teams = (Map)meta.get("teams");
            Map sprints = (Map)meta.get("sprints");
            ArrayList<String> configFields = new ArrayList<String>();
            if (session.getAlmConfigurations() != null) {
                String almAccountId = ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getId();
                configFields.add(JiraField.FIXED.issuetype.name());
                configFields.add(JiraField.FIXED.reporter.name());
                configFields.add(JiraField.FIXED.assignee.name());
                configFields.add(JiraField.FIXED.project.name());
                if (PropertyValidator.isValid((Object)session.getJiraFlaggedField())) {
                    configFields.add(session.getJiraFlaggedField().getKey());
                }
                if (PropertyValidator.isValid((Collection)session.getAdditionalFieldsValuesFeature())) {
                    for (Object field : session.getAdditionalFieldsValuesFeature()) {
                        configFields.add(field.getKey());
                    }
                }
                if (PropertyValidator.isValid((Collection)session.getAdditionalFieldsValuesUserStory())) {
                    for (Object field : session.getAdditionalFieldsValuesUserStory()) {
                        configFields.add(field.getKey());
                    }
                }
                List fields = this.jiraFieldRepository.findByJiraIdInAndAlmAccountId(configFields, almAccountId);
                for (JiraField field : fields) {
                    this.mapDbProperties("jiraFieldByKey." + field.getJiraId(), KendisUtils.camelCase((String)field.getName()), columns, null, apiFields, dbnames);
                }
                this.mapDbProperties("jiraFieldByKey.issuetype", KendisUtils.camelCase((String)"Item Type"), columns, subColumns, apiFields, dbnames);
            }
            Query qParent = new Query();
            Query qChild = null;
            if (dbnames != null) {
                params.put("fields", dbnames);
                qParent.fields().include("id");
                qParent.fields().include("type");
                HashMap cols = new HashMap();
                for (String name : dbnames) {
                    if (columns.containsKey(name)) {
                        cols.put(name, columns.get(name));
                    }
                    qParent.fields().include(name);
                }
                columns = cols;
            }
            boolean fetchChildren = columns.containsKey("subItems");
            if (!PropertyValidator.isValid((Object)params.get("types")) && !PropertyValidator.isValid((Object)params.get("itemIds"))) {
                params.put("types", new /* Unavailable Anonymous Inner Class!! */);
            }
            List result = this.findItemsJson(userApi.getTenant(), Item.Type.Feature.name(), qParent, bids, params);
            this.convertListSimpleMap(columns, items, result, teams, sprints, fetchChildren ? iMap : null);
            qParent.skip(0);
            qParent.limit(0);
            List count = this.customRepositoryImpl.findItemsByAggregation(userApi.getTenant(), bids, null, Boolean.valueOf(true), qParent);
            if (fetchChildren) {
                qChild = new Query();
                qChild.fields().include("type");
                qChild.fields().include("id");
                qChild.fields().include("jiraId");
                qChild.fields().include("tfsId");
                qChild.fields().include("jiraKey");
                qChild.fields().include("kendisKey");
                qChild.fields().include("externalReferenceURL");
                qChild.fields().include("title");
                qChild.fields().include("status");
                qChild.fields().include("storyPoints");
                qChild.fields().include("teamContainers");
                qChild.fields().include("parent");
                qChild.fields().include("tfsItemType");
                qChild.fields().include("jiraFieldByKey.issuetype");
                params.put("types", new /* Unavailable Anonymous Inner Class!! */);
                params.put("parentIds", iMap.keySet());
                params.remove("itemIds");
                result = this.findItemsJson(userApi.getTenant(), Item.Type.UserStory.name(), qChild, bids, params);
                this.convertListSimpleMap(subColumns, items, result, teams, sprints, iMap);
            }
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            responseJson.put("data", items);
            if (PropertyValidator.isValid((Collection)count)) {
                responseJson.put("total", ((DBObject)count.get(0)).get("total"));
            } else {
                responseJson.put("total", count);
            }
            return responseJson;
        }
        throw new KendisException("404", "No Session Board found");
    }

    private void convertListSimpleMap(Map<String, String> columns, List<Map> items, List<DBObject> result, Map<String, Team> teams, Map<String, Container> sprints, Map<String, Integer> iMap) {
        if (PropertyValidator.isValid(result)) {
            String jiraDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            String tfsDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SS'Z'";
            String points = "storyPoints";
            String pointsTitle = columns.get(points);
            String subTitle = columns.get("subItems");
            String subStTitle = columns.get("completionByStatus");
            String subEstTitle = columns.get("completionByEstimate");
            Item item = new Item();
            HashMap allStats = new HashMap();
            for (DBObject dbo : result) {
                List tcs;
                Map row = dbo.toMap();
                Map jiraFields = dbo.containsField("jiraFieldByKey") ? (Map)dbo.get("jiraFieldByKey") : null;
                Map tfsFields = dbo.containsField("tfsFieldByKey") ? (Map)dbo.get("tfsFieldByKey") : null;
                String id = (String)row.get("id");
                String type = (String)row.get("type");
                if (jiraFields != null) {
                    item.simplifyCustomValues(jiraFields, null, null, jiraDateFormat);
                    if (PropertyValidator.isValid((Object)item.getJiraFieldTextByKey())) {
                        row.put("jiraFieldByKey", item.getJiraFieldTextByKey());
                    }
                    this.putParentInApi(row, (Map)jiraFields.get("parent"), false);
                    jiraFields = (Map)row.get("jiraFieldByKey");
                }
                if (tfsFields != null) {
                    item.simplifyCustomValues(tfsFields, null, null, tfsDateFormat);
                    if (PropertyValidator.isValid((Object)item.getJiraFieldTextByKey())) {
                        row.put("tfsFieldByKey", item.getJiraFieldTextByKey());
                    }
                    this.putParentInApi(row, tfsFields, false);
                }
                if (dbo.containsField("parent")) {
                    this.putParentInApi(row, (Map)dbo.get("parent"), true);
                }
                if (!Item.Type.Feature.name().equals(type)) {
                    if (dbo.containsField(points)) {
                        row.put(points, dbo.get(points));
                    } else {
                        row.put(points, 0.0);
                    }
                }
                if (dbo.containsField("teamContainers") && PropertyValidator.isValid((Collection)(tcs = (List)dbo.get("teamContainers")))) {
                    ArrayList<3> tm = new ArrayList<3>();
                    for (Map tc : tcs) {
                        if (!PropertyValidator.isValid((Object)tc)) continue;
                        tm.add(new /* Unavailable Anonymous Inner Class!! */);
                    }
                    row.put("teamsAndSprints", tm);
                }
                this.putItemKey(row);
                if (row.containsKey("issueType") && !PropertyValidator.isValid(row.get("issueType"))) {
                    row.put("issueType", columns.get("lebal" + type));
                }
                if (Item.Type.Feature.name().equals(type) || iMap == null) {
                    items.add(row);
                    if (iMap != null) {
                        iMap.put(id, items.size() - 1);
                    }
                } else {
                    String pid = (String)row.get("parentId");
                    if (PropertyValidator.isValid((Object)pid) && iMap != null && iMap.containsKey(pid)) {
                        int index = iMap.get(pid);
                        Map stats = (Map)allStats.get(pid);
                        if (stats == null) {
                            allStats.put(pid, new HashMap());
                            stats = (Map)allStats.get(pid);
                        }
                        this.putParentInApi(row, items.get(index), true);
                        this.putChildStats(dbo, row, stats);
                        if (subTitle != null) {
                            items.get(index).put(subTitle, stats.get("subItems"));
                        }
                    }
                }
                this.transform(row, row, columns);
                if (jiraFields != null) {
                    this.transform(jiraFields, row, columns);
                }
                if (!dbo.containsField("scoreParams")) continue;
                this.transform((Map)dbo.get("scoreParams"), row, columns);
            }
        }
    }

    private void transform(Map from, Map to, Map columns) {
        ArrayList keys = new ArrayList(from.keySet());
        for (String key : keys) {
            Object val = from.remove(key);
            if (columns.containsKey(key)) {
                to.put(columns.get(key), val);
                continue;
            }
            if (columns.containsKey("jiraFieldByKey." + key)) {
                to.put(columns.get("jiraFieldByKey." + key), val);
                continue;
            }
            if (!columns.containsKey("tfsFieldByKey." + key)) continue;
            to.put(columns.get("tfsFieldByKey." + key), val);
        }
    }

    private void putChildStats(DBObject dbo, Map<String, Object> child, Map<String, Object> stats) {
        ArrayList<Map<String, Object>> subItems = (ArrayList<Map<String, Object>>)stats.get("subItems");
        String points = "storyPoints";
        String subStTitle = "completionByStatus";
        String subEstTitle = "completionByEstimate";
        if (subItems == null) {
            subItems = new ArrayList<Map<String, Object>>();
            stats.put("subItems", subItems);
        }
        subItems.add(child);
    }

    private void putParentInApi(Map item, Map parent, boolean isKendis) {
        if (parent != null) {
            if (isKendis) {
                if (parent.get("id") == null) {
                    item.put("parentId", parent.get("kendisId"));
                    item.put("parentTitle", parent.get("summary"));
                } else {
                    item.put("parentId", parent.get("id"));
                    item.put("parentTitle", parent.get("title"));
                }
            } else {
                Map fields = (Map)parent.get("fields");
                if (fields == null) {
                    if (parent.get("ParentId") != null) {
                        item.put("parentId", parent.get("ParentId"));
                        item.put("parentTitle", parent.get("ParentTitle"));
                    }
                } else {
                    item.put("parentId", parent.get("key"));
                    item.put("parentTitle", fields.get("summary"));
                }
            }
        }
    }

    private void putItemKey(Map<String, Object> item) {
        String key = (String)item.get("tfsId");
        if (key == null && (key = (String)item.get("jiraId")) != null) {
            item.put("jiraId", item.get("jiraKey"));
        }
    }

    public List<DBObject> findItemsJson(String tenant, String type, Query query, List<ObjectId> sessionBoardIds, Map<String, Object> params) {
        if (PropertyValidator.isValid((Object)params.get("types"))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in((Collection)((List)params.get("types"))));
        }
        if (PropertyValidator.isValid((Object)params.get("parentIds"))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in((Collection)KendisUtils.getListAsObjectIds((Collection)((Collection)params.get("parentIds")))));
        }
        if (PropertyValidator.isValid((Object)params.get("itemIds"))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)KendisUtils.getListAsObjectIds((Collection)((Collection)params.get("itemIds")))));
        }
        if (Item.Type.Feature.name().equals(type)) {
            Integer count;
            query.skip(0);
            query.limit(50);
            if (params.get("pageStart") != null) {
                query.skip(new Integer(String.valueOf(params.get("pageStart"))).intValue());
            }
            if (params.get("pageSize") != null && (count = new Integer(String.valueOf(params.get("pageSize")))) > -1 && count < 101) {
                query.limit(new Integer(String.valueOf(params.get("pageSize"))).intValue());
            }
        }
        return this.customRepositoryImpl.findItemsByAggregation(tenant, sessionBoardIds, null, null, query);
    }

    public Set<WorkSpace> getUserCollectstions(UserApiKey userApi) {
        Set<Object> wSpaces = new HashSet<WorkSpace>();
        Company company = this.companyRepository.findByTenant(userApi.getTenant());
        if (PropertyValidator.isValid((Object)company)) {
            User user = this.userRepository.findById(userApi.getUserId());
            ArrayList ucomp = new ArrayList();
            for (int i = 0; i < user.getUserCompanies().size(); ++i) {
                if (!company.getId().equals(((UserCompany)user.getUserCompanies().get(i)).getCompany().getId())) continue;
                user.setIsAdmin(((UserCompany)user.getUserCompanies().get(i)).getIsAdmin());
                user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(i)).getIsAdmin());
                if (company.isGuestEnabled()) {
                    user.setIsGuest(((UserCompany)user.getUserCompanies().get(i)).getIsGuest());
                }
                user.setIsAdmin(((UserCompany)user.getUserCompanies().get(i)).getIsAdmin());
                user.setIsSuperAdmin(((UserCompany)user.getUserCompanies().get(i)).getIsAdmin());
                user.setIsGuest(((UserCompany)user.getUserCompanies().get(i)).getIsGuest());
                ucomp.add(user.getUserCompanies().get(i));
            }
            wSpaces = this.planServiceImpl.getUserWorkSpaces(user, null);
        }
        return wSpaces;
    }

    public HashMap<String, Object> getBoardMeta(UserApiKey userApi, String boardCollectionIds) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            ArrayList list = new ArrayList();
            Set<WorkSpace> wSpaces = new HashSet();
            if (PropertyValidator.isValid((Object)boardCollectionIds)) {
                String[] ids;
                for (String id : ids = boardCollectionIds.split(",")) {
                    wSpaces.add(new WorkSpace(id));
                }
            } else {
                wSpaces = this.getUserCollectstions(userApi);
            }
            List sessions = this.sessionRepository.findLiteSessionsByWorkSpaceIn(wSpaces);
            HashMap<String, Integer> mapping = new HashMap<String, Integer>();
            ArrayList<String> boardIds = new ArrayList<String>();
            for (Session session : sessions) {
                HashMap<String, String> obj = new HashMap<String, String>();
                obj.put("id", session.getId());
                obj.put("title", session.getTitle());
                list.add(obj);
                boardIds.add(session.getActiveSessionBoard());
                mapping.put(session.getActiveSessionBoard(), list.size() - 1);
            }
            List boards = this.sessionBoardRepository.findBoardsByIdIn(boardIds);
            for (SessionBoard board : boards) {
                Integer index = (Integer)mapping.get(board.getId());
                if (index == null || index >= list.size()) continue;
                HashMap<String, String> obj = new HashMap<String, String>();
                obj.put("id", board.getState().getId());
                obj.put("title", board.getState().getTitle());
                ((Map)list.get(index)).put("state", obj);
            }
            if (PropertyValidator.isValid(list)) {
                responseJson.put("data", list);
            } else {
                responseJson.put("data", new ArrayList());
            }
            return responseJson;
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while featcging board meta by api key -> ", (Throwable)e);
            return responseJson;
        }
    }

    public HashMap<String, Object> getWorkSpaces(UserApiKey userApi) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("data", "");
        try {
            Set allWorkSpaces = this.getUserCollectstions(userApi);
            ArrayList workSpaceList = new ArrayList();
            for (WorkSpace workSpace : allWorkSpaces) {
                HashMap<String, String> workSpaceData = new HashMap<String, String>();
                workSpaceData.put("id", workSpace.getId());
                workSpaceData.put("title", workSpace.getTitle());
                workSpaceList.add(workSpaceData);
            }
            if (PropertyValidator.isValid(workSpaceList)) {
                responseJson.put("data", workSpaceList);
            } else {
                responseJson.put("errorMessages", "Session does not exist or you do not have permission to see it.");
                responseJson.put("error", new HashMap());
            }
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while featching work spaces meta by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    public HashMap<String, Object> getObjectivesMeta(String id, boolean isBatchesDataCalled) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("data", new HashMap());
        try {
            List listOfAllBaseItemOfBoard = new ArrayList();
            if (isBatchesDataCalled) {
                listOfAllBaseItemOfBoard = this.baseItemRepository.findByType(EnumBaseItemTypes.BATCH_GROUP.getName());
            } else {
                List listOfBoardBaseItemLink = this.baseItemLinkRepository.findBySessionId(id);
                ArrayList<BaseItemLink> listOfBaseItemLinkIds = new ArrayList<BaseItemLink>();
                for (Object baseItemLink : listOfBoardBaseItemLink) {
                    listOfBaseItemLinkIds.add((BaseItemLink)baseItemLink);
                }
                listOfAllBaseItemOfBoard = this.baseItemRepository.findByBaseItemLinksIn(listOfBaseItemLinkIds);
            }
            if (PropertyValidator.isValid(listOfAllBaseItemOfBoard)) {
                HashSet<Object> groupObjectivesTitle = new HashSet<Object>();
                HashSet<String> subObjectivesTitle = new HashSet<String>();
                HashSet<String> krObjectivesTitle = new HashSet<String>();
                if (PropertyValidator.isValid(listOfAllBaseItemOfBoard)) {
                    for (BaseItem objective : listOfAllBaseItemOfBoard) {
                        if (objective.getType().equals(EnumBaseItemTypes.OBJECTIVE_GROUP.getName())) {
                            if (PropertyValidator.isValid((Object)objective.getKey())) {
                                groupObjectivesTitle.add(objective.getKey());
                                continue;
                            }
                            if (!PropertyValidator.isValid((Object)objective.getTitle())) continue;
                            groupObjectivesTitle.add(objective.getTitle());
                            continue;
                        }
                        if (objective.getType().equals("Objective-Committed")) {
                            if (PropertyValidator.isValid((Object)objective.getKey())) {
                                subObjectivesTitle.add(objective.getKey());
                                continue;
                            }
                            if (!PropertyValidator.isValid((Object)objective.getTitle())) continue;
                            subObjectivesTitle.add(objective.getTitle());
                            continue;
                        }
                        if (objective.getType().equals(EnumKendis.OBJECTIVE_KEY_RESULT.getCode())) {
                            if (PropertyValidator.isValid((Object)objective.getKey())) {
                                krObjectivesTitle.add(objective.getKey());
                                continue;
                            }
                            if (!PropertyValidator.isValid((Object)objective.getTitle())) continue;
                            krObjectivesTitle.add(objective.getTitle());
                            continue;
                        }
                        if (!objective.getType().equals(EnumBaseItemTypes.BATCH_GROUP.getName())) continue;
                        HashMap<String, String> batchData = new HashMap<String, String>();
                        batchData.put(objective.getTitle(), objective.getId());
                        groupObjectivesTitle.add(batchData);
                        isBatchesDataCalled = true;
                    }
                    LinkedHashMap<String, HashSet<Object>> responseJsonData = new LinkedHashMap<String, HashSet<Object>>();
                    if (PropertyValidator.isValid(groupObjectivesTitle)) {
                        if (isBatchesDataCalled) {
                            responseJsonData.put("batcheTitles", groupObjectivesTitle);
                        } else {
                            responseJsonData.put("groupObjectivesTitles", groupObjectivesTitle);
                        }
                    }
                    if (PropertyValidator.isValid(subObjectivesTitle)) {
                        responseJsonData.put("subObjectiveKeys", subObjectivesTitle);
                    }
                    if (PropertyValidator.isValid(subObjectivesTitle)) {
                        responseJsonData.put("krKeys", krObjectivesTitle);
                    }
                    responseJson.put("data", responseJsonData);
                } else {
                    responseJson.put("errorMessages", "Objectives does not exist or you do not have permission to see it.");
                    responseJson.put("error", new HashMap());
                }
            } else {
                responseJson.put("errorMessages", "Objectives does not exist or you do not have permission to see it.");
                responseJson.put("error", new HashMap());
            }
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issue in fetching data.");
            LOGGER.error("Error occurred while featching work spaces meta by api key -> ", (Throwable)e);
        }
        return responseJson;
    }

    public static String getFieldName(Object object, Object value) {
        Class<?> clazz = object.getClass();
        try {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(object);
                    if (fieldValue == null || !fieldValue.equals(value)) continue;
                    return field.getName();
                }
                catch (IllegalAccessException e) {
                    LOGGER.error("Error occurred while fetching field Name -> ", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching field Name -> ", (Throwable)e);
        }
        return null;
    }
}

