/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.repository.StatsServiceDAO;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class StatsServiceDAOImpl
implements StatsServiceDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsServiceDAOImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;

    public List<SessionBoard> findSessionBoardsByIdIn(List<ObjectId> sessionBoardIds, String tenant) throws Exception {
        if (!PropertyValidator.isValid(sessionBoardIds)) {
            return new LinkedList<SessionBoard>();
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("_id", (Object)new BasicDBObject("$in", sessionBoardIds)).append("archive", (Object)false).append("tenant", (Object)tenant));
        BasicDBObject lookupSession = new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)KendisUtils.dbName(Session.class)).append("localField", (Object)"session.$id").append("foreignField", (Object)"_id").append("as", (Object)"session_joined"));
        BasicDBObject projectSession = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("archive", (Object)1).append("tenant", (Object)1).append("session", (Object)new BasicDBObject("$let", (Object)new BasicDBObject().append("vars", (Object)new BasicDBObject("sessionObj", (Object)new BasicDBObject("$arrayElemAt", Arrays.asList("$session_joined", 0)))).append("in", (Object)new BasicDBObject().append("_id", (Object)"$$sessionObj._id").append("loadOldObjectivesView", (Object)"$$sessionObj.loadOldObjectivesView")))).append("state", (Object)1).append("teams", (Object)1).append("objectivesMap", (Object)1));
        BasicDBObject lookupState = new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)KendisUtils.dbName(State.class)).append("localField", (Object)"state.$id").append("foreignField", (Object)"_id").append("as", (Object)"state_joined"));
        BasicDBObject projectState = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("archive", (Object)1).append("tenant", (Object)1).append("session", (Object)1).append("state", (Object)new BasicDBObject("$let", (Object)new BasicDBObject().append("vars", (Object)new BasicDBObject("stateObj", (Object)new BasicDBObject("$arrayElemAt", Arrays.asList("$state_joined", 0)))).append("in", (Object)new BasicDBObject().append("_id", (Object)"$$stateObj._id").append("title", (Object)"$$stateObj.title")))).append("teams", (Object)1).append("objectivesMap", (Object)1));
        BasicDBObject lookupTeams = new BasicDBObject("$lookup", (Object)new BasicDBObject().append("from", (Object)KendisUtils.dbName(Team.class)).append("localField", (Object)"teams.$id").append("foreignField", (Object)"_id").append("as", (Object)"teams_joined"));
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("session", (Object)"$session").append("state", (Object)"$state").append("teams", (Object)new BasicDBObject("$map", (Object)new BasicDBObject().append("input", (Object)"$teams_joined").append("as", (Object)"t").append("in", (Object)new BasicDBObject().append("_id", (Object)"$$t._id").append("title", (Object)"$$t.title").append("label", (Object)"$$t.label").append("color", (Object)"$$t.color")))).append("objectivesMap", (Object)new BasicDBObject("$cond", (Object)new BasicDBObject().append("if", (Object)new BasicDBObject("$eq", Arrays.asList("$session.loadOldObjectivesView", true))).append("then", (Object)"$objectivesMap").append("else", (Object)"$$REMOVE"))));
        List<DBObject> pipeline = Arrays.asList(matchStage, lookupSession, projectSession, lookupState, projectState, lookupTeams, projectStage);
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        LinkedList<SessionBoard> sessionBoards = new LinkedList<SessionBoard>();
        try (Cursor cursor = collection.aggregate(pipeline, options);){
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                SessionBoard sb = (SessionBoard)this.mongoTemplate.getConverter().read(SessionBoard.class, (Object)dbObject);
                sessionBoards.add(sb);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoards;
    }

    private void handleTeamsRef(BasicDBObject sessionBoardObj, List<ObjectId> teamIds, SessionBoard sessionBoard) {
        if (!PropertyValidator.isValid((Object)sessionBoardObj.get("teams"))) {
            return;
        }
        List teamRef = (List)sessionBoardObj.get("teams");
        LinkedList teams = new LinkedList();
        teamRef.forEach(teamRefObj -> {
            teamIds.add(new ObjectId(teamRefObj.getId().toString()));
            teams.add(new Team(teamRefObj.getId().toString()));
        });
        sessionBoard.setTeams(teams);
    }

    private void handleSessionRef(BasicDBObject sessionBoardObj, List<ObjectId> sessionIds, SessionBoard sessionBoard) {
        if (!PropertyValidator.isValid((Object)sessionBoardObj.get("session"))) {
            return;
        }
        DBRef sessionRef = (DBRef)sessionBoardObj.get("session");
        sessionIds.add(new ObjectId(sessionRef.getId().toString()));
        sessionBoard.setSession(new Session(sessionRef.getId().toString()));
    }

    private void handleStateRef(BasicDBObject sessionBoardObj, List<ObjectId> stateIds, SessionBoard sessionBoard) {
        if (!PropertyValidator.isValid((Object)sessionBoardObj.get("state"))) {
            return;
        }
        DBRef stateRef = (DBRef)sessionBoardObj.get("state");
        stateIds.add(new ObjectId(stateRef.getId().toString()));
        sessionBoard.setState(new State(stateRef.getId().toString()));
    }

    private void findSessionsById(Map<String, Session> sessionMap, List<ObjectId> sessionIds) {
        DBCollection sessionCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        BasicDBObject sessionMatch = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", sessionIds)));
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("loadOldObjectivesView", (Object)1));
        List<DBObject> pipeline = Arrays.asList(sessionMatch, projection);
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor sessionCursor = sessionCollection.aggregate(pipeline, aggregationOptions);){
            while (sessionCursor.hasNext()) {
                BasicDBObject sessionDBObject = (BasicDBObject)sessionCursor.next();
                Session session = new Session(DBUtils.getIdFromDBObject((BasicDBObject)sessionDBObject, (String[])new String[0]));
                session.setLoadOldObjectivesView(Boolean.valueOf(sessionDBObject.getBoolean("loadOldObjectivesView", true)));
                sessionMap.put(session.getId(), session);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private void findTeamsById(Map<String, Team> teamMap, List<ObjectId> teamIds) {
        DBCollection teamCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(Team.class));
        BasicDBObject teamMatch = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", teamIds)));
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("title", (Object)1).append("label", (Object)1).append("color", (Object)1));
        List<DBObject> pipeline = Arrays.asList(teamMatch, projection);
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor teamCursor = teamCollection.aggregate(pipeline, aggregationOptions);){
            while (teamCursor.hasNext()) {
                BasicDBObject teamDBObject = (BasicDBObject)teamCursor.next();
                Team team = new Team(teamDBObject);
                teamMap.put(team.getId(), team);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }

    private void findStatesById(Map<String, State> stateMap, List<ObjectId> stateIds) {
        DBCollection stateCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(State.class));
        BasicDBObject stateMatch = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", stateIds)));
        BasicDBObject projection = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("title", (Object)1));
        List<DBObject> pipeline = Arrays.asList(stateMatch, projection);
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor stateCursor = stateCollection.aggregate(pipeline, aggregationOptions);){
            while (stateCursor.hasNext()) {
                BasicDBObject stateDBObject = (BasicDBObject)stateCursor.next();
                String id = DBUtils.getIdFromDBObject((BasicDBObject)stateDBObject, (String[])new String[0]);
                State state = new State(id);
                state.setTitle(stateDBObject.getString("title"));
                stateMap.put(state.getId(), state);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw e;
        }
    }
}

