/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.Questionnaire;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

public interface SessionRepository
extends MongoRepository<Session, String> {
    public List<Session> findByAlmConfigurationsIn(List<AlmConfigurations> var1);

    @Query(fields="{ 'title' : 1, 'prefix' : 1, 'prefixColor' : 1, 'id' : 1,'activeSessionBoard' : 1}")
    public List<Session> findSessionsByAlmConfigurationsIn(List<AlmConfigurations> var1);

    @Query(fields="{ 'title' : 1, 'prefix' : 1, 'prefixColor' : 1, 'id' : 1,'activeSessionBoard' : 1,'workSpace' : 1}")
    public List<Session> findSessionsByAlmConfigurationsInAndRowStatus(List<AlmConfigurations> var1, Integer var2);

    @Query(fields="{ 'title' : 1, 'prefix' : 1, 'prefixColor' : 1, 'id' : 1,'activeSessionBoard' : 1,'workSpace' : 1}")
    public List<Session> findSessionsByTfsAlmConfigurationsInAndRowStatus(List<TFSAlmConfigurations> var1, Integer var2);

    public List<Session> findByTfsAlmConfigurationsIn(List<TFSAlmConfigurations> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'startSprintWebhookEnabled' : 1, 'endSprintWebhookEnabled' : 1, 'startDateAction' : 1}")
    public List<Session> findByAlmConfigurationsInOrderByCreatedOn(List<AlmConfigurations> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1}")
    public List<Session> findTitleByRowStatus(Integer var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'startSprintWebhookEnabled' : 1, 'endSprintWebhookEnabled' : 1, 'startDateAction' : 1, 'bucketEnabled' : 1, 'buckets' : 1}")
    public List<Session> findByAlmConfigurationsInAndArchiveOrderByCreatedOn(List<AlmConfigurations> var1, boolean var2);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'startSprintWebhookEnabled' : 1, 'endSprintWebhookEnabled' : 1, 'startDateAction' : 1, 'bucketEnabled' : 1, 'buckets' : 1}")
    public List<Session> findByTfsAlmConfigurationsInAndArchiveOrderByCreatedOn(List<TFSAlmConfigurations> var1, boolean var2);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' :'1', 'startSprintWebhookEnabled' : 1, 'endSprintWebhookEnabled' : 1, 'startDateAction' : 1}")
    public Session findByAlmConfigurations(AlmConfigurations var1);

    public List<Session> findByWorkSpaceIn(List<WorkSpace> var1);

    @Query(fields="{ 'title' : 1, 'id' : 1, 'almEnabled' :  1}")
    public List<Session> findByWorkSpaceInOrderByTitleAsc(List<WorkSpace> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'rowStatus' : 1, 'loadOldObjectivesView' :  1, 'workSpace' : 1, 'sequence' : 1}")
    public List<Session> findByWorkSpaceInAndRowStatusOrRowStatusIsNull(List<WorkSpace> var1, int var2);

    public List<Session> findByWorkSpace(WorkSpace var1);

    @Query(fields="{ 'title' : 1, 'prefix' : 1, 'prefixColor' : 1, 'id' :1, 'workSpace' : 1, 'activeSessionBoard' : 1, 'almConfigurations':1, 'tfsAlmConfigurations' : 1, 'sequence' : 1 }")
    public List<Session> findPiBoardsByWorkSpaceAndRowStatus(WorkSpace var1, Integer var2);

    public List<Session> findBySubItemWorkFlow(WorkFlow var1);

    public List<Session> findByItemWorkFlow(WorkFlow var1);

    public List<Session> findByDependencyWorkFlow(WorkFlow var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' :1, 'workSpace' : 1 }")
    public List<Session> findSessionByIdIn(List<String> var1);

    public Long countByTenantAndArchiveFalseAndAlmConfigurationsIsNull(String var1);

    public Long countByTenantAndArchiveFalseAndAlmConfigurationsNotNull(String var1);

    public Long countByTenantAndArchiveFalseAndTfsAlmConfigurationsNotNull(String var1);

    public Long countByTenantAndArchiveFalseAndAlmConfigurationsIsNullAndTfsAlmConfigurationsIsNull(String var1);

    public Long countByRiskRegisterId(String var1);

    public Long countByRiskRegisterIdAndArchiveFalse(String var1);

    public Long countByItemWorkFlowId(String var1);

    public Long countByArchiveFalseAndDependencyWorkFlowId(String var1);

    public Long countByArchiveFalseAndItemWorkFlowId(String var1);

    public List<Session> findByIdIn(List<String> var1);

    @Query(value="{ '_id' : { $in : ?0 } }", fields="{ 'activeSessionBoard' : 1 }")
    public List<Session> findByIdsIn(List<String> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'prefix' : 1, 'prefixColor' : 1, 'tfsAlmConfigurations' :  1}")
    public List<Session> findSessionsByIdIn(List<String> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'loadNewStructureMilestones' : 1}")
    public List<Session> findByWorkSpaceId(String var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'loadNewStructureMilestones' : 1, 'rowStatus' : 1}")
    public List<Session> findByWorkSpaceIdAndRowStatus(String var1, Integer var2);

    public List<Session> findByRiskRegisterId(String var1);

    public Session findByIdAndRiskRegisterId(String var1, String var2);

    public List<Session> findByRiskRegisterIdIn(List<String> var1);

    public List<Session> findByIdIn(ArrayList<ObjectId> var1);

    public Session findByConfidenceVoteSurveyId(String var1);

    public Session findById(String var1);

    @Query(fields="{ 'id' : 1, 'title' : 1, 'confidenceVoteSurvey' : 1}")
    public Session findByConfidenceVoteSurveyIdIn(List<Questionnaire> var1);

    public Session findByActiveSessionBoard(String var1);

    public List<Session> findSessionByWorkSpaceIn(String[] var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'prefix' : 1, 'prefixColor' : 1}")
    public List<Session> findMinimalSessionsByIdIn(List<String> var1);

    @Query(fields="{ 'id' : 1 ,'activeSessionBoard' : 1}")
    public List<Session> findSessionIdsByIdIn(ArrayList<ObjectId> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'loadOldObjectivesView' :  1, 'workSpace' : 1, 'rowStatus' : 1, 'sequence' :  1, 'prefix' :  1, 'prefixColor' :  1}")
    public List<Session> findSessionsByWorkSpaceIn(List<WorkSpace> var1);

    @Query(fields="{'id' : 1, 'title' : 1}")
    public List<Session> findByKendisOnlyLayout(FieldsLayout var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'loadOldObjectivesView' :  1, 'sequence' :  1}")
    public List<Session> findLiteSessionsByWorkSpaceIn(Collection<WorkSpace> var1);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'childItems' : 1, 'loadOldObjectivesView' :  1, 'sequence' :  1}")
    public List<Session> findLiteSessionsByIdInAndWorkSpaceIn(String[] var1, Collection<WorkSpace> var2);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'parentItem' : 1, 'parentItems' : 1, 'childItems' : 1, 'childItem' : 1, 'almConfigurations' :  1, 'additionalFieldsValuesFeature' :  1, 'additionalFieldsValuesUserStory' : 1, 'additionalFieldsEnabled' : 1, 'scoreCard' : 1, 'wsjfAlmEnabled' : 1, 'wsjfAlmFieldKey' : 1, 'fieldsValuesForColors' : 1, 'jiraFlaggedField' : 1, 'jiraSharedSprintField' : 1}")
    public List<Session> findSessionsByIdInAndWorkSpaceIn(List<String> var1, Collection<WorkSpace> var2);

    @Query(fields="{ 'title' : 1, 'activeSessionBoard' : 1, 'id' : 1, 'almConfigurations' :  1, 'tfsAlmConfigurations' : 1, 'tfsAlmConfigurations' : 1, 'itemWorkFlow' : 1, 'subItemWorkFlow' : 1}")
    public List<Session> findSessionsByWorkSpaceInAndIdIn(Collection<WorkSpace> var1, List<String> var2);
}

