/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.State;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

public interface SessionBoardRepository
extends MongoRepository<SessionBoard, String> {
    public List<SessionBoard> findAllByOrderByCreatedOnAsc();

    public List<SessionBoard> findByParentBoardIsNullOrderByCreatedOnAsc();

    public List<SessionBoard> findByParentBoardIsNullOrderByCreationDateAsc();

    @Query(fields="{ 'title' : 1, 'state' : 1, 'parentBoard' : 1, 'createdOn' : 1, 'createdBy' : 1}")
    public List<SessionBoard> findByParentBoardIsNotNullOrderByCreatedOnAsc();

    @Query(fields="{ 'title' : 1, session : 1, 'state' : 1, 'parentBoard' : 1, 'createdOn' : 1, 'createdBy' : 1, 'stateChangeDate' : 1}")
    public List<SessionBoard> findByIdOrParentBoardOrderByCreatedOnAsc(String var1, String var2);

    @Query(fields="{'session' : 1, 'state' : 1, 'parentBoard': 1, 'teams': 1, 'containers': 1, 'createdOn': 1, 'createdBy': 1, 'updatedOn': 1, 'creationDate' : 1,'tenant' : 1 }")
    public List<SessionBoard> findBySessionInAndParentBoardIsNullOrderByCreatedOnDesc(List<Session> var1);

    public List<SessionBoard> findBySessionInAndParentBoardIsNotNullOrderByCreatedOnDesc(List<Session> var1);

    @Query(fields="{ 'state' : 1, 'parentBoard' : 1, 'createdOn' : 1, 'createdBy' : 1,'updatedOn': 1, 'creationDate' : 1 }")
    public List<SessionBoard> findBySessionInAndParentBoardIsNotNull(List<Session> var1, Sort var2);

    public List<SessionBoard> findByIdIn(List<String> var1);

    @Query(fields="{ 'state' : 1}")
    public List<SessionBoard> findBoardsByIdIn(List<String> var1);

    public List<SessionBoard> findByContainersId(String var1);

    @Query(fields="{ 'session': 1, 'containers': 1 }")
    public List<SessionBoard> findByContainersIdIn(List<String> var1);

    @Query(fields="{ 'session':1,'title': 1,'color': 1,'prefix': 1,'teams': 1, 'containers': 1}")
    public List<SessionBoard> findEssentialsByIdIn(List<String> var1);

    @Query(fields="{ 'state' : 1, session : 1, 'createdOn' : 1, 'createdBy' : 1,'updatedOn': 1, 'creationDate' : 1, 'tenant' : 1, 'containers':1, 'teamSequence':1, 'teams':1 }")
    public List<SessionBoard> findByContainersIn(Collection<Container> var1);

    public List<SessionBoard> findByTeamsId(String var1);

    public List<SessionBoard> findBySessionId(String var1);

    public SessionBoard findById(String var1);

    @Query(fields="{ 'title' : 1, 'tenant' : 1}")
    public SessionBoard findBoardById(String var1);

    public List<SessionBoard> findBySessionIdOrderByCreatedOnAsc(String var1);

    public List<SessionBoard> findBySessionIdOrderByCreatedOnDesc(String var1);

    public List<SessionBoard> findBySessionIdIn(List<String> var1);

    public List<SessionBoard> findBySessionIn(List<Session> var1);

    public SessionBoard findOneBySessionAndState(Session var1, State var2);

    @Query(fields="{'id': 1, 'teams':1, 'session':1}")
    public SessionBoard findOneBySessionId(String var1);

    @Query(fields="{'session':1 }")
    public SessionBoard findSessionBoardById(String var1);

    @Query(fields="{'session':1 , 'teamSequence':1, 'containers':1, 'teams':1 }")
    public List<SessionBoard> findSessionBoardByIdIn(List<String> var1);

    public List<SessionBoard> findBycreatedBy(String var1);

    @Query(fields="{'title' : 1,'id': 1, 'containers':1, 'teams':1,}")
    public List<SessionBoard> findSessionBoardsByIdIn(Collection<String> var1);

    @Query(fields="{'id': 1, 'session':1}")
    public List<SessionBoard> findBoardsBySessionIn(List<Session> var1);

    @Query(fields="{'id': 1, 'teams':1, 'containers':1}")
    public List<SessionBoard> findBoardsForTeamsBySessionIn(List<Session> var1);
}

