/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.repository.BaseItemRepository;
import com.viztrend.safe.persistence.repository.ObjectiveServiceDAO;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.ObjectiveServiceVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ObjectiveServiceDAOImpl
implements ObjectiveServiceDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveServiceDAOImpl.class);
    private final MongoTemplate mongoTemplate;
    private final BaseItemRepository baseItemRepository;
    private final SessionRepository sessionRepository;

    @Autowired
    public ObjectiveServiceDAOImpl(MongoTemplate mongoTemplate, BaseItemRepository baseItemRepository, SessionRepository sessionRepository) {
        this.baseItemRepository = baseItemRepository;
        this.mongoTemplate = mongoTemplate;
        this.sessionRepository = sessionRepository;
    }

    public void loadBaseItemLinksBySessionIdInAndType(List<String> sessionIds, Map<String, List<BaseItemLink>> objectiveAndOkrBaseItemLinks, Map<String, List<BaseItemLink>> baseItemLinks, Map<String, Map<String, BaseItemLink>> groupBaseItemIds) {
        if (sessionIds == null || sessionIds.isEmpty()) {
            return;
        }
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BaseItemLink.class));
        BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject().append("archive", (Object)false).append("linkType", (Object)new BasicDBObject("$in", Arrays.asList(ObjectiveServiceDAO.defaultLinkTypeCodes))).append("sessionId", (Object)new BasicDBObject("$in", sessionIds)));
        BasicDBObject group = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)"$sessionId").append("links", (Object)new BasicDBObject("$push", (Object)"$$ROOT")));
        List<DBObject> pipeline = Arrays.asList(match, group);
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor cursor = collection.aggregate(pipeline, options);){
            while (cursor.hasNext()) {
                BasicDBObject sessionDoc = (BasicDBObject)cursor.next();
                String sId = sessionDoc.getString("_id");
                if (sId == null) continue;
                LinkedList objLinks = new LinkedList();
                LinkedList grpLinks = new LinkedList();
                HashMap idMap = new HashMap();
                objectiveAndOkrBaseItemLinks.put(sId, objLinks);
                baseItemLinks.put(sId, grpLinks);
                groupBaseItemIds.put(sId, idMap);
                List links = (List)sessionDoc.get("links");
                if (links == null || links.isEmpty()) continue;
                for (BasicDBObject linkDoc : links) {
                    BaseItemLink link = new BaseItemLink();
                    Object rawId = linkDoc.get("_id");
                    link.setId(rawId != null ? rawId.toString() : null);
                    link.setSessionId(sId);
                    link.setType(linkDoc.getString("type"));
                    link.setLinkType(linkDoc.getString("linkType"));
                    Object rawItemId = linkDoc.get("itemId");
                    link.setItemId(rawItemId != null ? rawItemId.toString() : null);
                    Object rawBaseId = linkDoc.get("baseItemId");
                    link.setBaseItemId(rawBaseId != null ? rawBaseId.toString() : null);
                    Object rawTeamId = linkDoc.get("teamId");
                    link.setTeamId(rawTeamId != null ? rawTeamId.toString() : null);
                    if (PropertyValidator.isValid((Object)link) && PropertyValidator.isValid((Object)link.getItemId())) {
                        objectiveAndOkrBaseItemLinks.get(sId).add(link);
                    }
                    if (PropertyValidator.isValid((Object)link.getType()) && "Objective-Group".equals(link.getType())) {
                        baseItemLinks.get(sId).add(link);
                    }
                    if (link.getId() == null) continue;
                    groupBaseItemIds.get(sId).put(link.getId(), link);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public Map<String, List<BaseItem>> findObjectiveGroupListForSessionByBaseItemLinks(Map<String, List<BaseItemLink>> baseItemLinksAgainstSessionId) {
        HashMap<String, List<BaseItem>> result = new HashMap<String, List<BaseItem>>(baseItemLinksAgainstSessionId.size());
        HashSet<ObjectId> linkObjectIds = new HashSet<ObjectId>();
        boolean hasLinks = false;
        for (List<BaseItemLink> list : baseItemLinksAgainstSessionId.values()) {
            if (list == null) continue;
            for (BaseItemLink link : list) {
                if (link.getId() == null) continue;
                hasLinks = true;
                try {
                    linkObjectIds.add(new ObjectId(link.getId()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (!hasLinks) {
            return result;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"baseItemLinks.$id").in(linkObjectIds));
        query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
        List groups = this.mongoTemplate.find(query, BaseItem.class);
        HashMap<String, BaseItem> linkIdToGroupMap = new HashMap<String, BaseItem>();
        for (BaseItem baseItem : groups) {
            if (baseItem.getBaseItemLinks() == null) continue;
            for (BaseItemLink linkInGroup : baseItem.getBaseItemLinks()) {
                if (linkInGroup.getId() == null) continue;
                linkIdToGroupMap.put(linkInGroup.getId(), baseItem);
            }
        }
        for (Map.Entry entry : baseItemLinksAgainstSessionId.entrySet()) {
            String sessionId = (String)entry.getKey();
            List sessionLinks = (List)entry.getValue();
            if (sessionLinks == null || sessionLinks.isEmpty()) {
                result.put(sessionId, new ArrayList());
                continue;
            }
            LinkedHashSet<BaseItem> uniqueSessionGroups = new LinkedHashSet<BaseItem>();
            for (BaseItemLink link : sessionLinks) {
                BaseItem group;
                if (link.getId() == null || (group = (BaseItem)linkIdToGroupMap.get(link.getId())) == null) continue;
                uniqueSessionGroups.add(group);
            }
            result.put(sessionId, new ArrayList(uniqueSessionGroups));
        }
        return result;
    }

    public Map<String, List<BaseItem>> loadBaseItemsForAllSessions(List<ObjectiveServiceVO> objectiveServiceVO, boolean isOkrData) {
        HashMap<String, List<BaseItem>> baseItemsForSession = new HashMap<String, List<BaseItem>>();
        try {
            HashSet uniqueIds = new HashSet();
            for (ObjectiveServiceVO vo : objectiveServiceVO) {
                List ids = isOkrData ? vo.getKeyResultsIds() : vo.getObjectiveIds();
                if (ids == null) continue;
                uniqueIds.addAll(ids);
            }
            if (uniqueIds.isEmpty()) {
                return baseItemsForSession;
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(uniqueIds));
            query.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            List baseItems = this.mongoTemplate.find(query, BaseItem.class);
            HashMap<String, BaseItem> lookupMap = new HashMap<String, BaseItem>(baseItems.size());
            for (BaseItem item : baseItems) {
                lookupMap.put(item.getId(), item);
            }
            for (ObjectiveServiceVO vo : objectiveServiceVO) {
                List idsToFetch = isOkrData ? vo.getKeyResultsIds() : vo.getObjectiveIds();
                if (idsToFetch == null || idsToFetch.isEmpty()) continue;
                LinkedList<BaseItem> sessionList = new LinkedList<BaseItem>();
                for (ObjectId id : idsToFetch) {
                    BaseItem item = (BaseItem)lookupMap.get(id.toString());
                    if (item == null) continue;
                    sessionList.add(item);
                }
                if (sessionList.isEmpty()) continue;
                baseItemsForSession.put(vo.getSessionId(), sessionList);
            }
        }
        catch (Exception exception) {
            LOGGER.error(StringUtils.getTraceString((Throwable)exception));
            throw exception;
        }
        return baseItemsForSession;
    }

    public Map<String, List<Session>> findSessionsByBaseItemLinksOfAllSessions(List<ObjectiveServiceVO> objectiveServiceVOList) {
        HashMap<String, List<Session>> sessionMap = new HashMap<String, List<Session>>(objectiveServiceVOList.size());
        HashSet<String> sessionIdsToFetch = new HashSet<String>();
        for (ObjectiveServiceVO vo : objectiveServiceVOList) {
            List links = vo.getObjectiveAndOkrBaseItemLinks();
            if (links == null) continue;
            for (BaseItemLink link : links) {
                if (link.getSessionId() == null) continue;
                sessionIdsToFetch.add(link.getSessionId());
            }
        }
        if (sessionIdsToFetch.isEmpty()) {
            return sessionMap;
        }
        List sessions = this.sessionRepository.findByIdsIn(new ArrayList(sessionIdsToFetch));
        HashMap<String, Session> lookupMap = new HashMap<String, Session>(sessions.size());
        for (Session s : sessions) {
            lookupMap.put(s.getId(), s);
        }
        for (ObjectiveServiceVO vo : objectiveServiceVOList) {
            List links = vo.getObjectiveAndOkrBaseItemLinks();
            if (links == null || links.isEmpty()) continue;
            HashSet<Session> uniqueSessionsForVo = new HashSet<Session>();
            for (BaseItemLink link : links) {
                Session foundSession;
                String linkSessionId = link.getSessionId();
                if (linkSessionId == null || (foundSession = (Session)lookupMap.get(linkSessionId)) == null) continue;
                uniqueSessionsForVo.add(foundSession);
            }
            if (uniqueSessionsForVo.isEmpty()) continue;
            sessionMap.put(vo.getSessionId(), new ArrayList(uniqueSessionsForVo));
        }
        return sessionMap;
    }

    public Map<String, SessionBoard> findSessionBoardsMapByIdIn(List<String> sessionBoardIds, String tenant) {
        if (sessionBoardIds == null || sessionBoardIds.isEmpty()) {
            return new HashMap<String, SessionBoard>();
        }
        int estimatedSize = (int)((double)sessionBoardIds.size() * 0.8);
        HashMap<String, SessionBoard> sessionBoardMap = new HashMap<String, SessionBoard>(estimatedSize > 0 ? estimatedSize : 16);
        List ids = KendisUtils.getListAsObjectIds(sessionBoardIds);
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", (Object)ids)).append("tenant", (Object)tenant).append("archive", (Object)false));
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("sId", (Object)"$session.$id").append("tIds", (Object)"$teams.$id"));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectStage);
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        try (Cursor cursor = collection.aggregate(pipeline, options);){
            while (cursor.hasNext()) {
                String sIdStr;
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                Object rawSessionId = dbObject.get("sId");
                if (rawSessionId == null || sessionBoardMap.containsKey(sIdStr = rawSessionId.toString())) continue;
                SessionBoard sessionBoard = new SessionBoard();
                sessionBoard.setId(DBUtils.getIdFromDBObject((BasicDBObject)dbObject, (String[])new String[0]));
                sessionBoard.setSession(new Session(sIdStr));
                Object rawTeamIds = dbObject.get("tIds");
                if (rawTeamIds instanceof List) {
                    List tIdList = (List)rawTeamIds;
                    ArrayList<Team> teams = new ArrayList<Team>(tIdList.size());
                    for (Object tIdObj : tIdList) {
                        ObjectId tId;
                        if (!(tIdObj instanceof ObjectId) || (tId = (ObjectId)tIdObj) == null) continue;
                        teams.add(new Team(tId.toString()));
                    }
                    sessionBoard.setTeams(teams);
                }
                sessionBoardMap.put(sIdStr, sessionBoard);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoardMap;
    }

    private Map<BaseItemLink, Set<BaseItem>> groupBaseItemsByBaseItemLinks(List<BaseItem> baseItems) {
        HashMap<BaseItemLink, Set<BaseItem>> baseItemLinkToBaseItemMap = new HashMap<BaseItemLink, Set<BaseItem>>();
        if (!PropertyValidator.isValid(baseItems)) {
            return baseItemLinkToBaseItemMap;
        }
        for (BaseItem baseItem : baseItems) {
            for (BaseItemLink baseItemLink : baseItem.getBaseItemLinks()) {
                baseItemLinkToBaseItemMap.computeIfAbsent(baseItemLink, k -> new HashSet()).add(baseItem);
            }
        }
        return baseItemLinkToBaseItemMap;
    }
}

