/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.mongodb.WriteResult;
import com.viztrend.safe.persistence.repository.GraphRepository;
import com.viztrend.safe.service.GraphAuditLogService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class GraphRepositoryImpl
implements GraphRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(String.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private GraphAuditLogService graphAuditLogService;

    public List<Map> findAllBoards() {
        return this.mongoTemplate.findAll(Map.class, "canvasBoards");
    }

    public Map findBoardById(String id, String tenant) {
        if (tenant == null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(id)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        return (Map)this.mongoTemplate.findOne(query, Map.class, "canvasBoard");
    }

    public List<Map> findNodesByBoradId(String boardId, String tenant) {
        if (tenant == null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        return this.mongoTemplate.find(query, Map.class, "canvasNodes");
    }

    public List<Map> findLinksByBoardId(String boardId, String tenant) {
        if (tenant == null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        return this.mongoTemplate.find(query, Map.class, "canvasLinks");
    }

    public void saveBoard(String board) {
        try {
            this.mongoTemplate.insert((Object)board, "canvasBoards");
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public List<Map> saveNode(HashMap<String, Object> params) {
        ArrayList<Map> nodeIdList = new ArrayList<Map>();
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            items.forEach(node -> {
                this.mongoTemplate.insert(node, "canvasNodes");
                HashMap nodeId = new HashMap();
                nodeId.put(node.get("key"), node.get("_id").toString());
                nodeIdList.add(nodeId);
            });
            params.put("items", items);
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Created);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return nodeIdList;
    }

    public List<Map> saveLink(HashMap<String, Object> params) {
        ArrayList<Map> linkIdList = new ArrayList<Map>();
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            items.forEach(link -> {
                this.mongoTemplate.insert(link, "canvasLinks");
                HashMap linkId = new HashMap();
                linkId.put(link.get("key"), link.get("_id"));
                linkIdList.add(linkId);
            });
            params.put("items", items);
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Created);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return linkIdList;
    }

    public String saveTemplate(String boardId, Map template) {
        String id = null;
        try {
            this.mongoTemplate.insert((Object)template, "canvasTemplate");
            id = template.get("_id").toString();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return id;
    }

    public List<Map> findTemplatesByUserId(String userId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        return this.mongoTemplate.find(query, Map.class, "canvasTemplate");
    }

    public Map findTemplateById(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        return (Map)this.mongoTemplate.findOne(query, Map.class, "canvasTemplate");
    }

    public void saveAllNodes(HashMap<String, Object> params) {
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            this.mongoTemplate.insert((Collection)items, "canvasNodes");
            params.put("items", items);
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Created);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void saveAllLinks(HashMap<String, Object> params) {
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            this.mongoTemplate.insert((Collection)items, "canvasLinks");
            params.put("items", items);
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Created);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public String updateBoard(Map board) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{board.get("_id").toString()}));
        Update update = new Update();
        board.forEach((key, value) -> update.set(key.toString(), value));
        Map result = (Map)this.mongoTemplate.findAndModify(query, update, Map.class, "canvasBoards");
        return result.get("_id").toString();
    }

    public List updateNode(HashMap<String, Object> params) {
        ArrayList updatedNodeIds = new ArrayList();
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            items.forEach(node -> {
                if (node.containsKey("__gohashid")) {
                    node.remove("__gohashid");
                }
                if (PropertyValidator.isValid(node.get("_id"))) {
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{node.get("_id").toString()}));
                    Update update = new Update();
                    node.forEach((key, value) -> update.set(key.toString(), value));
                    Map result = (Map)this.mongoTemplate.findAndModify(query, update, Map.class, "canvasNodes");
                    if (PropertyValidator.isValid((Object)result)) {
                        updatedNodeIds.add(result.get("_id").toString());
                    }
                }
            });
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Updated);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return updatedNodeIds;
    }

    public List updateLink(HashMap<String, Object> params) {
        ArrayList updatedLinkIds = new ArrayList();
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            items.forEach(link -> {
                if (link.containsKey("_id")) {
                    if (link.containsKey("__gohashid")) {
                        link.remove("__gohashid");
                    }
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{link.get("_id").toString()}));
                    Update update = new Update();
                    link.forEach((key, value) -> update.set(key.toString(), value));
                    Map result = (Map)this.mongoTemplate.findAndModify(query, update, Map.class, "canvasLinks");
                    if (PropertyValidator.isValid((Object)result)) {
                        updatedLinkIds.add(result.get("_id").toString());
                    }
                }
            });
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Updated);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return updatedLinkIds;
    }

    public WriteResult removeBoard(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{id}));
        return this.mongoTemplate.remove(query, "canvasBoards");
    }

    public int removeNode(HashMap<String, Object> params) {
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            items.forEach(node -> {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{node.get("_id")}));
                this.mongoTemplate.remove(query, "canvasNodes");
            });
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Deleted);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return 0;
        }
        return 1;
    }

    public int removeLink(HashMap<String, Object> params) {
        String boardId = (String)params.get("boardId");
        List items = (List)params.get("items");
        try {
            items.forEach(link -> {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").in(new Object[]{link.get("key")}));
                this.mongoTemplate.remove(query, "canvasLinks");
            });
            HashMap hashMap = this.graphAuditLogService.saveAuditLog(params, GraphAuditLogService.LogActionType.Deleted);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return 0;
        }
        return 1;
    }

    public WriteResult removeTemplate(String boardId, String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(new Object[]{id}));
        return this.mongoTemplate.remove(query, "canvasTemplate");
    }
}

