/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.repository;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MapReduceCommand;
import com.mongodb.WriteResult;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.BoardFilter;
import com.viztrend.safe.persistence.entity.CanvasBoard;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Counters;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.LockedObject;
import com.viztrend.safe.persistence.entity.PiSystemRole;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Severity;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CountersRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemLogMapRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SeverityRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.service.ReleaseTrainServiceImpl;
import com.viztrend.safe.service.SprintReportServics;
import com.viztrend.safe.service.TFSserviceImpl;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.BacklogItemVO;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="customRepository")
public class CustomRepositoryImpl<T>
implements CustomRepository {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private ItemLogMapRepository itemLogMapRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomRepositoryImpl.class);
    @Autowired
    private CountersRepository countersRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SeverityRepository severityRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private ALMSyncServiceImpl aLMSyncServiceImpl;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private ReleaseTrainServiceImpl releaseTrainService;
    @Autowired
    private SprintReportServics sprintReportServics;
    @Autowired
    private TFSserviceImpl tfsServiceImpl;
    @Autowired
    private BacklogItemRepository backlogItemRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public long findActiveUserCountAndActiveGuesUserUserCount(String companyId, boolean includeGuestUsers) {
        Long userCount = 0L;
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies.company.$id").is((Object)new ObjectId(companyId)));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies.isArchive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies.isActive").is((Object)true));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userCompanies.isGuest").is((Object)includeGuestUsers));
            query.fields().include("_id");
            query.fields().include("userCompanies");
            userCount = this.mongoTemplate.count(query, User.class);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return userCount;
    }

    public void saveItem(Object baseEntity) {
        Object entityId = null;
        try {
            this.mongoTemplate.save(baseEntity);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void saveItemTTL(Map<String, Object> data, long ttlSeconds) {
        String collection = EnumKendis.DUPLICATE_ITEMS.name();
        if (!this.mongoTemplate.collectionExists(collection)) {
            this.mongoTemplate.createCollection(collection);
            Index index = new Index().on("expireAt", Sort.Direction.ASC).expire(0L, TimeUnit.SECONDS);
            this.mongoTemplate.indexOps(collection).ensureIndex((IndexDefinition)index);
        }
        Document doc = new Document(data);
        doc.put("expireAt", (Object)new Date(System.currentTimeMillis() + ttlSeconds * 1000L));
        this.mongoTemplate.insert((Object)doc, collection);
    }

    public List<DBObject> findItemTTL(String id) {
        String collection = EnumKendis.DUPLICATE_ITEMS.name();
        List result = null;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        DBCursor cursor = this.mongoTemplate.getCollection(collection).find(query.getQueryObject());
        result = cursor.toArray();
        cursor.close();
        return result;
    }

    public List<DBObject> retreiveItemsOnly(String id, List<String> types, List<String> fieldsToInclude) throws Exception {
        if (!PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            return new ArrayList<DBObject>();
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        if (PropertyValidator.isValid(types)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").in(types));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(id)));
        if (PropertyValidator.isValid(fieldsToInclude)) {
            for (String field : fieldsToInclude) {
                query.fields().include(field);
            }
        }
        DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("item").find(query.getQueryObject());
        dbCursorPrefix.sort((DBObject)new BasicDBObject("sequence", (Object)1));
        return dbCursorPrefix.toArray();
    }

    public void updateSessionBoardsParent(String oldBoardId, String newParentBoardId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"parentBoard").is((Object)oldBoardId));
        Update update = new Update();
        update.set("parentBoard", (Object)newParentBoardId);
        this.mongoTemplate.updateMulti(query, update, SessionBoard.class);
    }

    public void updateItemAlmRevision(String itemId, String rev) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)itemId));
        Update update = new Update();
        update.set("almRevision", (Object)rev);
        this.mongoTemplate.updateMulti(query, update, Item.class);
    }

    public void enableAlmAccountsDebugMode(boolean debugMode) {
        Query query = new Query();
        if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getCurrentCompany() != null) {
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        }
        Update update = new Update();
        update.set("debug", (Object)debugMode);
        this.mongoTemplate.updateMulti(query, update, AlmAccount.class);
    }

    public void markDefaultWorkFlow(String wfId) {
        Query query = new Query();
        Criteria crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"id").ne((Object)wfId), Criteria.where((String)"isDefault").is((Object)true)});
        query.addCriteria((CriteriaDefinition)crt);
        Update update = new Update();
        update.set("isDefault", (Object)false);
        this.mongoTemplate.updateMulti(query, update, WorkFlow.class);
        query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)wfId));
        update = new Update();
        update.set("isDefault", (Object)true);
        this.mongoTemplate.updateMulti(query, update, WorkFlow.class);
    }

    public void updateKendisOnlyCreateEnabled(String sessionId, Boolean kendisOnlyCreateEnabled) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)sessionId));
        Update update = new Update();
        update.set("kendisOnlyCreateEnabled", (Object)kendisOnlyCreateEnabled);
        this.mongoTemplate.updateMulti(query, update, Session.class);
    }

    public void updateActiveSessionBoard(String sessionId, String activeSessionBoardId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)sessionId));
        Update update = new Update();
        update.set("activeSessionBoard", (Object)activeSessionBoardId);
        this.mongoTemplate.updateMulti(query, update, Session.class);
    }

    public void updateAlmAccountWebhookURL(String almAccountId, String webhookURL) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)almAccountId));
        Update update = new Update();
        update.set("webhookURL", (Object)webhookURL);
        this.mongoTemplate.updateMulti(query, update, AlmAccount.class);
    }

    public void fixMultiCompanyIssueForNordea() {
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        try {
            if (PropertyValidator.isValid((Object)tenant) && tenant.equals("e3b746fb-b59c-4b4d-ac98-3a664cb8d02f")) {
                UserContextUtil.getUserContext().setSkipTenant(true);
            }
        }
        finally {
            UserContextUtil.getUserContext().setSkipTenant(false);
        }
    }

    public void removeUserFromGroups(String userId) {
        Update update = new Update();
        update.pull("users", (Object)userId);
        this.mongoTemplate.updateMulti(new Query(), update, Group.class);
    }

    public void setSessionBoardParent(String boardId, String parentBoardId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)boardId));
        Update update = new Update();
        update.set("parentBoard", (Object)parentBoardId);
        this.mongoTemplate.updateMulti(query, update, SessionBoard.class);
    }

    public void updateDependencyCountInSession(String SessionId, int count) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)SessionId));
        Update update = new Update();
        update.inc("dependencyCount", (Number)count);
        this.mongoTemplate.findAndModify(query, update, Session.class);
    }

    public void addCustomIdInDependency(List linkIds) {
        ArrayList<Pair> queries = new ArrayList<Pair>();
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, ItemLink.class);
        for (int i = 0; i < linkIds.size(); ++i) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is(linkIds.get(i)));
            Update update = new Update();
            update.set("customId", (Object)(i + 1));
            queries.add(Pair.of((Object)query, (Object)update));
        }
        bulkOps.updateMulti(queries);
        bulkOps.execute();
    }

    public void updateTeamSequenceByBoardId(String boardId, String[] teamSequence) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)boardId));
        Update update = new Update();
        update.set("teamSequence", (Object)teamSequence);
        this.mongoTemplate.updateFirst(query, update, SessionBoard.class);
    }

    public void lockSessionBoard(String boardId, Boolean lock) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)boardId));
        Update update = new Update();
        if (lock.booleanValue()) {
            update.set("status", (Object)"Closed");
        } else {
            update.set("status", (Object)"Open");
        }
        this.mongoTemplate.updateMulti(query, update, SessionBoard.class);
    }

    public void updatePaymentPackageConfig(String key, Boolean value) {
        Query query = new Query();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)cid));
        Update update = new Update();
        update.set("paymentPackageConfig." + key, (Object)value);
        this.mongoTemplate.findAndModify(query, update, Company.class);
    }

    public void updateCustomization(String key, Boolean value) {
        Query query = new Query();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)cid).and("tenant").is((Object)tenant));
        Update update = new Update();
        update.set("customization." + key, (Object)value);
        this.mongoTemplate.findAndModify(query, update, Company.class);
    }

    public void updateExternalLinksTitle(String key, String title) {
        Query query = new Query();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)cid).and("tenant").is((Object)tenant));
        Update update = new Update();
        update.set(key, (Object)title);
        this.mongoTemplate.findAndModify(query, update, Company.class);
    }

    public void updateExternalLinksPresent(String key, boolean value) {
        Query query = new Query();
        String cid = UserContextUtil.getUserContext().getCurrentCompanyId();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)cid).and("tenant").is((Object)tenant));
        Update update = new Update();
        update.set(key, (Object)value);
        this.mongoTemplate.findAndModify(query, update, Company.class);
    }

    public User findUserByAlmAccount(String userId, String almAccId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)userId).and("almCredentials").elemMatch(Criteria.where((String)"almAccId").is((Object)almAccId)));
            User user = (User)this.mongoTemplate.findOne(query, User.class);
            return user;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public User findAlmUserByLoggedInUserId(String userId, String almUsername) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)userId).and("almCredentials").elemMatch(Criteria.where((String)"almUsername").is((Object)almUsername)));
            User user = (User)this.mongoTemplate.findOne(query, User.class);
            return user;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public Item findAlmUserByLoggedInUserId(String containerId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers").elemMatch(Criteria.where((String)"$id").is((Object)containerId)));
            Item user = (Item)this.mongoTemplate.findOne(query, Item.class);
            return user;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public void getSubItemEstimatesAndUpdateInParent(String parentId) {
        TypedAggregation agg = Aggregation.newAggregation(Item.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[0]).sum("storyPoints").as("storyPoints"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{Aggregation.previousOperation(), "storyPoints"})});
        AggregationResults result = this.mongoTemplate.aggregate(agg, MapReduceCommand.OutputType.class);
        List stateStatsList = result.getMappedResults();
    }

    public void updateItemStoryPoints(String itemId, Double storyPoints) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)itemId));
        Update update = new Update();
        update.set("subItemEstimate", (Object)storyPoints);
        this.mongoTemplate.updateFirst(query, update, Item.class);
    }

    public void updateFeauteParent(String itemId, Object parent) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)itemId));
        Update update = new Update();
        update.set("jiraFieldByKey." + JiraField.FIXED.parent.name(), parent);
        this.mongoTemplate.updateFirst(query, update, Item.class);
    }

    public void removeItemsJraFilterId(String jiraFilterId, String sessionBoardId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"jiraFilter").is((Object)jiraFilterId), Criteria.where((String)"sessionBoards.id").is((Object)sessionBoardId)}));
        Update update = new Update();
        update.set("jiraFilter", null);
        this.mongoTemplate.updateMulti(query, update, Item.class);
    }

    public void setArchive(String id, Boolean archive, Class c) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = new Update();
        update.set("archive", (Object)archive);
        this.mongoTemplate.updateMulti(query, update, c);
    }

    public void deleteAttachmentFromWorkspace(String workspaceId, String attachmentId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)workspaceId));
        Update update = new Update().pull("attachments", (Object)new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)attachmentId)));
        this.mongoTemplate.updateFirst(query, update, WorkSpace.class);
    }

    public WriteResult incrementValue(String _id, String key, Number value, Class type) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)_id));
        Update update = new Update();
        update.inc(key, value);
        return this.mongoTemplate.updateFirst(query, update, type);
    }

    public void setActive(String id, String cid, boolean active, Class c) {
        Query query = new Query();
        Criteria crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id), Criteria.where((String)"userCompanies.company.id").is((Object)cid), Criteria.where((String)"userCompanies.isArchive").is((Object)false)});
        query.addCriteria((CriteriaDefinition)crt);
        Update update = new Update();
        update.set("userCompanies.$.isActive", (Object)active);
        this.mongoTemplate.updateMulti(query, update, c);
    }

    public void setRowStatus(String id, int rowStatus, Class c) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = new Update();
        update.set("rowStatus", (Object)rowStatus);
        this.mongoTemplate.updateMulti(query, update, c);
    }

    public void markStatusAsDelete(Collection ids, String collectionType, String tenant) {
        HashSet usedStatusIds = new HashSet();
        if (!"".equals(collectionType)) {
            if (WorkFlow.WorkFlowType.General.name().equals(collectionType) || collectionType == null) {
                this.getUsedStatusIdsByAggregation(null, ids, usedStatusIds, tenant, BacklogItem.class);
                this.getUsedStatusIdsByAggregation(null, ids, usedStatusIds, tenant, Item.class);
            } else if (WorkFlow.WorkFlowType.Dependency.name().equals(collectionType)) {
                this.getUsedStatusIdsByAggregation("wfStatus.$id", ids, usedStatusIds, tenant, ItemLink.class);
                this.getUsedStatusIdsByAggregation("wfStatus.$id", ids, usedStatusIds, tenant, ItemJiraDependency.class);
            } else if (WorkFlow.WorkFlowType.Risk.name().equals(collectionType)) {
                this.getUsedStatusIdsByAggregation(null, ids, usedStatusIds, tenant, Risk.class);
                this.getUsedStatusIdsByAggregation(null, ids, usedStatusIds, tenant, RiskRegister.class);
            } else {
                this.getUsedStatusIdsByAggregation(null, ids, usedStatusIds, tenant, BaseItem.class);
            }
        }
        ArrayList unusedStatusIds = new ArrayList();
        for (Object id : ids) {
            if (usedStatusIds.contains(id)) continue;
            unusedStatusIds.add(id);
        }
        if (!usedStatusIds.isEmpty()) {
            Query updateQuery = new Query();
            updateQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(usedStatusIds));
            updateQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            Update update = new Update();
            update.set("isDeleted", (Object)true);
            this.mongoTemplate.updateMulti(updateQuery, update, Status.class);
            LOGGER.debug("marked deleted statuses [" + tenant + "] : " + ((Object)usedStatusIds).toString());
        }
        if (!unusedStatusIds.isEmpty()) {
            Query deleteQuery = new Query();
            deleteQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(unusedStatusIds));
            deleteQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            this.mongoTemplate.remove(deleteQuery, Status.class);
            LOGGER.debug("removed statuses [" + tenant + "]: " + ((Object)unusedStatusIds).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Object> getUsedStatusIdsByAggregation(String property, Collection ids, Set<Object> usedStatusIds, String tenant, Class<?> entityClass) {
        try (Cursor db = null;){
            if (property == null) {
                property = "status.$id";
            }
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(entityClass));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
            BasicDBObject in = new BasicDBObject("$in", (Object)ids);
            BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject(property, (Object)in).append("tenant", (Object)tenant));
            BasicDBObject group = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)("{ _id: '$" + property + "' }")));
            BasicDBObject project = new BasicDBObject((Map)BasicDBObject.parse((String)"{ $project: { statusId: {'$toString':'$_id'}, _id: 0 } }"));
            List<DBObject> pipeline = Arrays.asList(match, group, project);
            db = collection.aggregate(pipeline, ao);
            while (db.hasNext()) {
                DBObject o = (DBObject)db.next();
                String id = (String)o.get("statusId");
                usedStatusIds.add(ObjectId.isValid((String)id) ? new ObjectId(id) : id);
            }
        }
        return usedStatusIds;
    }

    public List<User> findUnarchviedUsersByCompany(String cid) {
        try {
            Query query = new Query();
            Criteria crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"userCompanies.company.id").is((Object)cid), Criteria.where((String)"userCompanies.isArchive").is((Object)false)});
            query.addCriteria((CriteriaDefinition)crt);
            List user = this.mongoTemplate.find(query, User.class);
            return user;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public List<User> findActiveUsersByCompany(String cid) {
        Query query = new Query();
        Criteria crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"userCompanies.company.id").is((Object)cid), Criteria.where((String)"userCompanies.isActive").is((Object)true)});
        query.addCriteria((CriteriaDefinition)crt);
        List user = this.mongoTemplate.find(query, User.class);
        return user;
    }

    public void setBulkArchive(List ids, boolean archive, Class c) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in((Collection)ids));
        Update update = new Update();
        update.set("archive", (Object)archive);
        this.mongoTemplate.updateMulti(query, update, c);
    }

    public void setBulkArchiveUserStoriesByParent(Item parent, boolean archive) {
        Thread t = new Thread(() -> {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").is((Object)new ObjectId(parent.getId())));
            DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("item").find(query.getQueryObject());
            if (dbCursorPrefix != null && dbCursorPrefix.size() > 0) {
                List usList = dbCursorPrefix.toArray();
                Update update = new Update();
                update.set("archive", (Object)archive);
                this.mongoTemplate.updateMulti(query, update, Item.class);
                if (parent.getSessionBoards() != null && parent.getSessionBoards().size() > 0 && parent.getSessionBoards().get(0) != null) {
                    SessionBoard board = (SessionBoard)parent.getSessionBoards().get(0);
                    HashSet itemIds = new HashSet();
                    ArrayList logs = new ArrayList();
                    ArrayList logMaps = new ArrayList();
                    HashMap removedItems = new HashMap();
                    for (DBObject us : usList) {
                        HashMap<String, Object> itm = new HashMap<String, Object>();
                        itm.put("id", String.valueOf(us.get("_id")));
                        itm.put("title", us.get("title"));
                        itm.put("jiraKey", us.get("jiraKey"));
                        itm.put("jiraId", us.get("jiraId"));
                        itm.put("tfsId", us.get("tfsId"));
                        itm.put("kendisKey", us.get("kendisKey"));
                        removedItems.put((String)itm.get("id"), itm);
                    }
                    board.setTenant(((SessionBoard)parent.getSessionBoards().get(0)).getTenant());
                    KendisUtils.createLogsForDelete(removedItems, (SessionBoard)board, logs, logMaps, itemIds);
                    if (logMaps.size() > 0) {
                        this.itemLogRepository.save(logs);
                        this.itemLogMapRepository.save(logMaps);
                        this.releaseTrainService.syncWithBoards(board.getTenant(), board, itemIds);
                    }
                }
            }
        });
        t.start();
    }

    public void saveLogsForDeletedItems(List<Item> items) {
        Thread t = new Thread(() -> {
            if (PropertyValidator.isValid((Collection)items)) {
                HashSet itemIds = new HashSet();
                SessionBoard board = null;
                ArrayList logs = new ArrayList();
                ArrayList logMaps = new ArrayList();
                HashMap removedItems = new HashMap();
                for (Item item : items) {
                    if (board == null) {
                        board = (SessionBoard)item.getSessionBoards().get(0);
                    }
                    HashMap<String, String> itm = new HashMap<String, String>();
                    itm.put("id", item.getId());
                    itm.put("title", item.getTitle());
                    itm.put("jiraKey", item.getJiraKey());
                    itm.put("jiraId", item.getJiraId());
                    itm.put("tfsId", item.getTfsId());
                    itm.put("kendisKey", item.getKendisKey());
                    removedItems.put((String)itm.get("id"), itm);
                }
                KendisUtils.createLogsForDelete(removedItems, board, logs, logMaps, itemIds);
                if (logMaps.size() > 0) {
                    this.itemLogRepository.save(logs);
                    this.itemLogMapRepository.save(logMaps);
                    this.releaseTrainService.syncWithBoards(board.getTenant(), board, itemIds);
                }
            }
        });
        t.start();
    }

    public void updateJiraNotifySetting(String sessionId, Boolean notifyJiraUsers) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)sessionId));
        Update update = new Update();
        update.set("notifyJiraUsers", (Object)notifyJiraUsers);
        this.mongoTemplate.updateMulti(query, update, Session.class);
    }

    public void updateAlmErrorFlag(String itemId, boolean almErrorFlag) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(itemId)));
        Update update = new Update();
        update.set("errorInAlmSync", (Object)almErrorFlag);
        this.mongoTemplate.updateMulti(query, update, Item.class);
    }

    public void setJiraIssueConvertedToItem(List ids, boolean converted) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)ids));
        Update update = new Update();
        update.set("convertedToItem", (Object)converted);
        this.mongoTemplate.updateMulti(query, update, JiraIssue.class);
    }

    public List<WorkFlow> findAllByTfsProjectIsNullAndWorkflowTypeNullOrGiven(String workFlowType) {
        Query query = new Query();
        Criteria crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"tfsProject").is(null), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"workflowType").is((Object)workFlowType), Criteria.where((String)"workflowType").is(null)})});
        query.addCriteria((CriteriaDefinition)crt);
        List workflows = this.mongoTemplate.find(query, WorkFlow.class);
        return workflows;
    }

    public void updateJiraDependencyStatusOnItemStatus(Map statusMap, Map linkStatusMap, String sessionBoardId) {
        Update update;
        Criteria crt;
        Query query;
        Set openLinks = (Set)statusMap.get("Open");
        Set resolveLinks = (Set)statusMap.get("Resolved");
        Iterator i = openLinks.iterator();
        Iterator j = resolveLinks.iterator();
        ArrayList<Pair> queries = new ArrayList<Pair>();
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, ItemJiraDependency.class);
        while (i.hasNext()) {
            query = new Query();
            crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"jiraDependencyId").is(i.next()), Criteria.where((String)"sessionBoardId").is((Object)sessionBoardId)});
            query.addCriteria((CriteriaDefinition)crt);
            update = new Update();
            update.set("wfStatus", linkStatusMap.get("ToDo"));
            queries.add(Pair.of((Object)query, (Object)update));
        }
        while (j.hasNext()) {
            query = new Query();
            crt = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"jiraDependencyId").is(j.next()), Criteria.where((String)"sessionBoardId").is((Object)sessionBoardId)});
            query.addCriteria((CriteriaDefinition)crt);
            update = new Update();
            update.set("wfStatus", linkStatusMap.get("Done"));
            queries.add(Pair.of((Object)query, (Object)update));
        }
        if (queries.size() > 0) {
            bulkOps.updateMulti(queries);
            bulkOps.execute();
        }
    }

    public void updateMultipleItemLinkOnAlmLinking(List links) {
        List ItemLinks = links;
        ArrayList<Pair> queries = new ArrayList<Pair>();
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, ItemLink.class);
        for (int i = 0; i < ItemLinks.size(); ++i) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)((ItemLink)ItemLinks.get(i)).getId()));
            Update update = new Update();
            update.set("almLinkId", (Object)((ItemLink)ItemLinks.get(i)).getAlmLinkId());
            queries.add(Pair.of((Object)query, (Object)update));
        }
        if (PropertyValidator.isValid(queries)) {
            bulkOps.updateMulti(queries);
            bulkOps.execute();
        }
    }

    public void updateItemLinkOnAlmLinking(ItemLink link, String linktype) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)link.getId()));
        Update update = new Update();
        update.set("almLinkId", (Object)link.getAlmLinkId());
        if (linktype == "TFS") {
            update.set("syncTfs", (Object)link.getSyncTfs());
        }
        this.mongoTemplate.updateMulti(query, update, ItemLink.class);
    }

    public void deleteItemLink(ItemLink link) {
        Query query = new Query();
        ArrayList<Boolean> archive = new ArrayList<Boolean>();
        archive.add(true);
        archive.add(false);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(link.getId())));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(archive));
        this.mongoTemplate.remove(query, ItemLink.class);
    }

    public ItemLink getItemLink(String id) {
        Query query = new Query();
        ArrayList<Boolean> archive = new ArrayList<Boolean>();
        archive.add(true);
        archive.add(false);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(archive));
        return (ItemLink)this.mongoTemplate.findById((Object)id, ItemLink.class);
    }

    public List<ItemLink> getItemLink(List id) {
        Query query = new Query();
        ArrayList<Boolean> archive = new ArrayList<Boolean>();
        archive.add(true);
        archive.add(false);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)id));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(archive));
        return this.mongoTemplate.find(query, ItemLink.class);
    }

    public List<ItemJiraDependency> getJiraDependencyBySourceAndTargetId(String sourceId, String targetId) {
        Query query = new Query();
        Criteria crt = new Criteria().orOperator(new Criteria[]{new Criteria().andOperator(new Criteria[]{Criteria.where((String)"sourceTFSItem.tfsId").is((Object)sourceId), Criteria.where((String)"targetTFSItem.tfsId").is((Object)targetId)}), new Criteria().andOperator(new Criteria[]{Criteria.where((String)"sourceTFSItem.tfsId").is((Object)targetId), Criteria.where((String)"targetTFSItem.tfsId").is((Object)sourceId)})});
        query.addCriteria((CriteriaDefinition)crt);
        List jiraDep = this.mongoTemplate.find(query, ItemJiraDependency.class);
        return jiraDep;
    }

    public List<CanvasBoard> getKendisSystemTemplates(Boolean value) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isSystem").is((Object)value));
        List boards = this.mongoTemplate.find(query, CanvasBoard.class);
        return boards;
    }

    public String getNextSeq(String identified, Integer initVal, Integer interval) {
        if (initVal == null) {
            initVal = 1;
        }
        if (interval == null) {
            interval = 1;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)identified));
        Update update = new Update().inc("seq", (Number)interval);
        FindAndModifyOptions options = new FindAndModifyOptions().returnNew(true);
        Counters savedCounter = null;
        savedCounter = (Counters)this.mongoTemplate.findAndModify(query, update, options, Counters.class);
        if (!PropertyValidator.isValid((Object)savedCounter)) {
            savedCounter = new Counters();
            savedCounter.setId(identified);
            savedCounter.setSeq(initVal.intValue());
            savedCounter = (Counters)this.countersRepository.save((Object)savedCounter);
        }
        return String.valueOf(savedCounter.getSeq());
    }

    public String generateKey(String type) {
        String companyId = UserContextUtil.getUserContext().getCurrentCompanyId();
        int key = Integer.valueOf(this.getNextSeq(companyId + ":" + type, null, null));
        if (WorkFlow.WorkFlowType.ActionPoint.name().equals(type)) {
            return "AP-" + key;
        }
        if (WorkFlow.WorkFlowType.Impediment.name().equals(type)) {
            return "IMP-" + key;
        }
        if (WorkFlow.WorkFlowType.Objective.name().equals(type)) {
            return "OBJ-" + key;
        }
        if (EnumBaseItemTypes.BATCH_GROUP.getName().equals(type)) {
            return "BG-" + key;
        }
        StringBuilder initial = new StringBuilder();
        for (int i = 0; i < type.length(); ++i) {
            if (!Character.isUpperCase(type.charAt(i))) continue;
            initial.append(type.charAt(i));
        }
        return initial.append("-").append(key).toString();
    }

    public String generateKey(String type, String companyId) {
        int key = Integer.valueOf(this.getNextSeq(companyId + ":" + type, null, null));
        if (WorkFlow.WorkFlowType.ActionPoint.name().equals(type)) {
            return "AP-" + key;
        }
        if (WorkFlow.WorkFlowType.Impediment.name().equals(type)) {
            return "IMP-" + key;
        }
        if (WorkFlow.WorkFlowType.Objective.name().equals(type)) {
            return "OBJ-" + key;
        }
        if (EnumBaseItemTypes.BATCH_GROUP.getName().equals(type)) {
            return "BG-" + key;
        }
        StringBuilder initial = new StringBuilder();
        for (int i = 0; i < type.length(); ++i) {
            if (!Character.isUpperCase(type.charAt(i))) continue;
            initial.append(type.charAt(i));
        }
        return initial.append("-").append(key).toString();
    }

    public void bulkLogs(String sessionBoardId, Collection<Item> parent, List<Item> children, Map<String, HashMap<String, ? super Object>> removedItems, String tenant) {
        Thread t = new Thread(() -> {
            try {
                HashSet itemIds = new HashSet();
                ArrayList logs = new ArrayList();
                ArrayList logMaps = new ArrayList();
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardId)));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.fields().include("_id");
                query.fields().include("state");
                query.fields().include("session");
                SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
                if (parent != null && parent.size() > 0) {
                    KendisUtils.createLogs((Collection)parent, (State)sessionBoard.getState(), logs, logMaps, itemIds);
                }
                if (children != null && children.size() > 0) {
                    KendisUtils.createLogs((Collection)children, (State)sessionBoard.getState(), logs, logMaps, itemIds);
                }
                if (removedItems != null && removedItems.size() > 0) {
                    KendisUtils.createLogsForDelete((Map)removedItems, (SessionBoard)sessionBoard, logs, logMaps, itemIds);
                }
                if (logs.size() > 0) {
                    this.itemLogRepository.save(logs);
                    this.itemLogMapRepository.save(logMaps);
                }
                if (itemIds.size() > 0) {
                    this.releaseTrainService.syncWithBoards(tenant, sessionBoard, itemIds);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        });
        t.start();
    }

    public void bulkLogs2(String sessionBoardId, List<Item> parent, List<Item> children, List<Item> removedItems, String tenant) {
        Thread t = new Thread(() -> {
            try {
                HashSet itemIds = new HashSet();
                ArrayList logs = new ArrayList();
                ArrayList logMaps = new ArrayList();
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(sessionBoardId)));
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.fields().include("_id");
                query.fields().include("state");
                query.fields().include("session");
                SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
                if (parent != null && parent.size() > 0) {
                    KendisUtils.createLogs((Collection)parent, (State)sessionBoard.getState(), logs, logMaps, itemIds);
                }
                if (children != null && children.size() > 0) {
                    KendisUtils.createLogs((Collection)children, (State)sessionBoard.getState(), logs, logMaps, itemIds);
                }
                if (removedItems != null && removedItems.size() > 0) {
                    KendisUtils.createLogsForDelete((List)removedItems, (SessionBoard)sessionBoard, logs, logMaps, itemIds);
                }
                if (logs.size() > 0) {
                    this.itemLogRepository.save(logs);
                    this.itemLogMapRepository.save(logMaps);
                    this.releaseTrainService.syncWithBoards(tenant, sessionBoard, itemIds);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        });
        t.start();
    }

    public void bulkLogs(Collection<BacklogItem> items, String tenant) {
        Thread t = new Thread(() -> {
            try {
                ArrayList logs = new ArrayList();
                KendisUtils.createLogs((Collection)items, logs);
                if (logs.size() > 0) {
                    this.itemLogRepository.save(logs);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        });
        t.start();
    }

    public WorkFlow createDefaultWorkflow(String workFlowTitle, String workFlowType) {
        WorkFlow defaultScheme = new WorkFlow();
        defaultScheme.setTitle(workFlowTitle);
        defaultScheme.setDefault(false);
        defaultScheme.setWorkflowType(workFlowType);
        defaultScheme = (WorkFlow)this.workFlowRepository.save((Object)defaultScheme);
        if (workFlowType.equals(WorkFlow.WorkFlowType.Severity.name())) {
            List severities = KendisUtils.getDeaultSeverities();
            for (Severity severity : severities) {
                severity.setWorkFlow(defaultScheme);
            }
            this.severityRepository.save((Iterable)severities);
        } else {
            ArrayList<Status> statusList = new ArrayList<Status>();
            for (int j = 0; j < 2; ++j) {
                Status status;
                int i;
                if (j == 0) {
                    for (i = 0; i < 3; ++i) {
                        status = new Status();
                        status.setCategory("ToDo");
                        status.setArchive(false);
                        status.setWorkFlow(defaultScheme);
                        if (i == 0) {
                            status.setTitle("Waiting for Acceptance");
                        } else if (i == 1) {
                            status.setTitle("Accepted");
                        } else {
                            status.setTitle("Not Started");
                        }
                        statusList.add(status);
                    }
                    continue;
                }
                if (j != 1) continue;
                for (i = 0; i < 2; ++i) {
                    status = new Status();
                    status.setCategory("Done");
                    status.setArchive(false);
                    status.setWorkFlow(defaultScheme);
                    if (i == 0) {
                        status.setTitle("Done");
                    } else if (i == 1) {
                        status.setTitle("Done with Acceptance");
                    }
                    statusList.add(status);
                }
            }
            this.statusRepository.save(statusList);
        }
        return defaultScheme;
    }

    public Query buildQuerySprints(boolean isSpillOver) throws Exception {
        Date now = new Date();
        long dateInMillis = now.getTime();
        String property = "";
        property = isSpillOver ? "endTime" : "startTime";
        Query query = new Query();
        Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)property).gte((Object)dateInMillis).andOperator(new Criteria[]{Criteria.where((String)property).lt((Object)(dateInMillis + 300000L))})});
        query.addCriteria((CriteriaDefinition)criteria);
        query.fields().include("_id");
        query.fields().include("tenant");
        return query;
    }

    public void autoStartEndSprint(String uname, List<State> states, List<SessionBoard> boards, Collection<Container> sprints, boolean isSpillOver) throws Exception {
        if (PropertyValidator.isValid(states)) {
            Query query = this.buildQuerySprints(isSpillOver);
            sprints = this.mongoTemplate.find(query, Container.class);
            boards = this.sessionBoardRepository.findByContainersIn((Collection)sprints);
            uname = EnumKendis.KENDIS_AUTO_PROCESS.getCode();
        }
        HashMap map = new HashMap();
        HashMap<String, String> sMap = new HashMap<String, String>();
        if (PropertyValidator.isValid((Collection)sprints)) {
            HashMap<String, Boolean> autoSpints = new HashMap<String, Boolean>();
            for (Container sprint : sprints) {
                autoSpints.put(sprint.getId(), true);
            }
            HashMap tsvByCompany = new HashMap();
            ArrayList<String> tids = new ArrayList<String>();
            ArrayList<String> sids = new ArrayList<String>();
            for (Object board : boards) {
                if (!PropertyValidator.isValid((Object)board.getSession()) || !board.getId().equals(board.getSession().getActiveSessionBoard())) continue;
                ArrayList<String> tids2 = new ArrayList<String>();
                ArrayList<String> sids2 = new ArrayList<String>();
                List bTeams = board.getTeams();
                List bSprints = board.getContainers();
                for (Team team : bTeams) {
                    tids.add(team.getId());
                    tids2.add(team.getId());
                }
                for (Container sprint : bSprints) {
                    if (!autoSpints.containsKey(sprint.getId())) continue;
                    sids.add(sprint.getId());
                    sids2.add(sprint.getId());
                    sMap.put(sprint.getId(), board.getSession().getId());
                }
                KendisUtils.putStartEndSprintParam(map, (SessionBoard)board, tids2, sids2);
                tsvByCompany.put(board.getTenant(), new ArrayList());
            }
            if (!map.isEmpty()) {
                HashMap response = this.saveSpillOverOver(uname, map, tids, sids, null, null, Boolean.valueOf(isSpillOver), null, null, true);
                try {
                    if (isSpillOver) {
                        for (Container sprint : sprints) {
                            if (!sMap.containsKey(sprint.getId())) continue;
                            this.sprintReportServics.sprintReportGenration((String)sMap.get(sprint.getId()), sprint.getId(), null, null, uname);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in sprintReportGenration");
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                try {
                    List companies = this.companyRepository.findByTenantIn(tsvByCompany.keySet());
                    response.remove("auditMap");
                    Gson gson = new GsonBuilder().setDateFormat(0, 0).create();
                    List tsvs = (List)response.get("velocities");
                    for (TeamSprintVelocity tsv : tsvs) {
                        if (tsvByCompany.get(tsv.getTenant()) == null) continue;
                        ((List)tsvByCompany.get(tsv.getTenant())).add(tsv);
                    }
                    for (Company company : companies) {
                        if (tsvByCompany.get(company.getTenant()) == null) continue;
                        response.put("velocities", tsvByCompany.get(company.getTenant()));
                        PushSender.sendPushMsg((String)company.getId(), (String)gson.toJson((Object)response));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in auto sprint start/end Scheduler push");
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
            }
        }
    }

    public void forceEndSprints(String uname, SessionBoard board, List<Container> containers) throws Exception {
        ArrayList<String> bids = new ArrayList<String>();
        ArrayList<String> tids = new ArrayList<String>();
        bids.add(board.getId());
        for (Object team : board.getTeams()) {
            tids.add(team.getId());
        }
        HashMap<String, Container> sprints = new HashMap<String, Container>();
        for (Container sprint : containers) {
            sprints.put(sprint.getId(), sprint);
        }
        List tsvs = this.teamSprintVelocityRepository.findBySessionBoardIdInAndSprintIdInAndTeamIdIn(bids, sprints.keySet(), tids);
        for (TeamSprintVelocity tsv : tsvs) {
            if (!sprints.containsKey(tsv.getSprintId()) || !PropertyValidator.isValid((Object)tsv.getLastBaseLineDate()) || !PropertyValidator.isValid((Object)tsv.getLastBaseLineAuditLogId()) || !PropertyValidator.isValid((Object)tsv.getLastSpillOverDate()) || !PropertyValidator.isValid((Object)tsv.getLastSpillOverAuditLogId())) continue;
            sprints.remove(tsv.getSprintId());
        }
        if (!sprints.isEmpty()) {
            this.autoStartEndSprint(uname, null, (List)new /* Unavailable Anonymous Inner Class!! */, sprints.values(), true);
        }
    }

    public List<DBObject> getByObjectId(Collection ids, Class<?> clazz) throws Exception {
        ArrayList<DBObject> tcs = new ArrayList();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        DBCursor dbc = this.mongoTemplate.getCollection(KendisUtils.dbName(clazz)).find(query.getQueryObject());
        tcs = dbc.toArray();
        dbc.close();
        return tcs;
    }

    public List<DBObject> getByObjectId(List<Object> ids, Class<?> clazz, List<String> refs, Set<String> refIds) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        DBCursor dbc = this.mongoTemplate.getCollection(KendisUtils.dbName(clazz)).find(query.getQueryObject());
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        while (dbc.hasNext()) {
            DBObject dbo = dbc.next();
            if (clazz.equals(User.class)) {
                dbo.put("password", null);
                dbo.put("almCredentials", null);
                dbo.put("userPreferences", null);
            }
            DBUtils.parseDocument((DBObject)dbo);
            DBUtils.parseDbProperty((DBObject)dbo, (String)"conversations", (boolean)true);
            DBUtils.parseDbProperty((DBObject)dbo, (String)"userCompanies", (boolean)true);
            DBUtils.parseDbProperty((DBObject)dbo, (String)"workFlow", (boolean)false);
            if (PropertyValidator.isValid(refs)) {
                for (String ref : refs) {
                    if (ref == null || !dbo.containsField(ref)) continue;
                    DBUtils.parseDbProperty((DBObject)dbo, (String)ref, (boolean)false);
                    refIds.add((String)((Map)dbo.get(ref)).get("id"));
                }
            }
            if (clazz.equals(ItemJiraDependency.class) && dbo.containsField("targetJiraIssue")) {
                Map issue = (Map)dbo.get("targetJiraIssue");
                Map fields = (Map)issue.get("fields");
                ArrayList keys = new ArrayList(fields.keySet());
                for (int i = 0; i < keys.size(); ++i) {
                    Map field;
                    String key = (String)keys.get(i);
                    if (fields.get(key) == null || !(fields.get(key) instanceof Map) || (field = (Map)fields.get(key)) == null || field.get("id") != null) continue;
                    field.put("id", field.get("_id"));
                    field.put("_id", null);
                    field.put("statusCategory", null);
                }
            }
            result.add(dbo);
        }
        return result;
    }

    public TFSAlmConfigurations findTeamMappingByConfigurationId(String configId) {
        StringBuilder matchJson = new StringBuilder();
        matchJson.append("{    $match: {      _id: ObjectId(\"" + configId + "\")    }  },");
        BasicDBObject matchPipe = new BasicDBObject();
        matchPipe.append("$match", (Object)new BasicDBObject().append("_id", (Object)new ObjectId(configId)));
        ArrayList<BasicDBObject> pipline = new ArrayList<BasicDBObject>();
        pipline.add(matchPipe);
        StringBuilder filterJson = new StringBuilder();
        filterJson.append("{    $project: {      teamMappings: {        $map: {          input: \"$teamMappings\",          as: \"mapping\",          in: {            kendisTeamId: \"$$mapping.kendisTeamId\",            tfsAreaPath: \"$$mapping.tfsAreaPath\",            tfsAreaPathsForTeam: \"$$mapping.tfsAreaPathsForTeam\",            tfsBacklogIteration: \"$$mapping.tfsBacklogIteration\",            includeSubAreaPaths: \"$$mapping.includeSubAreaPaths\",            hasTeamProjectInAreaPath: \"$$mapping.hasTeamProjectInAreaPath\"          }        }      }    }  }");
        BasicDBObject filterPipe = BasicDBObject.parse((String)filterJson.toString());
        pipline.add(filterPipe);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TFSAlmConfigurations.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor db = collection.aggregate(pipline, ao);
        if (db.hasNext()) {
            DBObject configObject = (DBObject)db.next();
            TFSAlmConfigurations almConfig = new TFSAlmConfigurations();
            if (configObject.containsKey("teamMappings")) {
                BasicDBList teamMappingsList = (BasicDBList)configObject.get("teamMappings");
                ArrayList<TFSTeamMapping> teamMappings = new ArrayList<TFSTeamMapping>();
                almConfig.setTeamMappings(teamMappings);
                for (int i = 0; i < teamMappingsList.size(); ++i) {
                    DBObject teamMappingObj = (DBObject)teamMappingsList.get(i);
                    TFSTeamMapping tm = new TFSTeamMapping();
                    teamMappings.add(tm);
                    tm.setKendisTeamId((String)teamMappingObj.get("kendisTeamId"));
                    tm.setTfsAreaPath((String)teamMappingObj.get("tfsAreaPath"));
                    if (teamMappingObj.containsKey("tfsAreaPathsForTeam")) {
                        BasicDBList tfsAreaPathsForTeamList = (BasicDBList)teamMappingObj.get("tfsAreaPathsForTeam");
                        ArrayList<String> tfsAreaPathsForTeam = new ArrayList<String>();
                        for (int j = 0; j < tfsAreaPathsForTeamList.size(); ++j) {
                            String tfsAreaPathsForTeamValue = (String)tfsAreaPathsForTeamList.get(j);
                            tfsAreaPathsForTeam.add(tfsAreaPathsForTeamValue);
                        }
                        tm.setTfsAreaPathsForTeam(tfsAreaPathsForTeam);
                    }
                    if (teamMappingObj.containsKey("includeSubAreaPaths")) {
                        tm.setIncludeSubAreaPaths((Boolean)teamMappingObj.get("includeSubAreaPaths"));
                    }
                    if (!teamMappingObj.containsKey("hasTeamProjectInAreaPath")) continue;
                    tm.setHasTeamProjectInAreaPath(((Boolean)teamMappingObj.get("hasTeamProjectInAreaPath")).booleanValue());
                }
            }
            return almConfig;
        }
        return null;
    }

    public Map<String, Object> findJiraItemsByFilter(String boardId, Collection filterIds, Map<String, String> jiraIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (UserContextUtil.getUserContext() != null) {
            ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
            BasicDBObject where = new BasicDBObject();
            where.append("tenant", (Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant());
            where.append("archive", (Object)new BasicDBObject("$ne", (Object)true));
            where.append("jiraId", (Object)BasicDBObject.parse((String)"{'$exists' : true}"));
            where.append("jiraFilter", (Object)new BasicDBObject("$in", (Object)filterIds));
            where.append("sessionBoards.$id", (Object)new BasicDBObject("$in", (Object)new /* Unavailable Anonymous Inner Class!! */));
            pipe.add(new BasicDBObject("$match", (Object)where));
            pipe.add(BasicDBObject.parse((String)"{ '$project': { 'id': { '$toString': '$_id' }, '_id':0, 'jiraKey' : '$jiraKey', 'jiraId':'$jiraId','jiraFilter':{'$toString':'$jiraFilter'} }  }"));
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
            Cursor db = collection.aggregate(pipe, ao);
            while (db.hasNext()) {
                Map map = (Map)db.next();
                ArrayList list = (ArrayList)result.get(map.get("jiraFilter"));
                if (jiraIds != null) {
                    jiraIds.put((String)map.get("id"), (String)map.get("jiraId"));
                }
                if (list == null) {
                    list = new ArrayList();
                }
                if (list.size() == 0 || ((List)list.get(list.size() - 1)).size() == 100) {
                    list.add(new ArrayList());
                }
                ((List)list.get(list.size() - 1)).add(map.get("jiraKey"));
                result.put((String)map.get("jiraFilter"), list);
            }
        }
        return result;
    }

    public List<DBObject> findItemsByAggregation(String tenant, List sessionBoardIds, HashMap<String, Object> params, Boolean count, Query query) {
        if (UserContextUtil.getUserContext() != null) {
            tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        }
        boolean usingGroupBy = false;
        boolean notCount = !Boolean.TRUE.equals(count);
        boolean lookupStatus = true;
        boolean lookupIssueType = true;
        boolean lookupTeamContainer = true;
        boolean lookupItemLinks = false;
        boolean lookupItemJiraDependency = false;
        String jiraDateFormat = null;
        String parent = Item.Type.Feature.name();
        String child = Item.Type.UserStory.name();
        String sortOpt = "{'backlogSequence':1}";
        String miniItem = "{'id':{'$toString':'$_id'},'tcId':{'$ifNull':[{'$toString':{'$arrayElemAt':['$teamContainers._id',0]}},'0']}}";
        StringBuilder groups = new StringBuilder();
        ArrayList<BasicDBObject> pipe = new ArrayList<BasicDBObject>();
        BasicDBObject project = null;
        BasicDBObject where = new BasicDBObject();
        where.append("tenant", (Object)tenant);
        where.append("archive", (Object)new BasicDBObject("$ne", (Object)true));
        if (PropertyValidator.isValid((Collection)sessionBoardIds)) {
            where.append("sessionBoards.$id", (Object)new BasicDBObject("$in", (Object)sessionBoardIds));
        }
        String configFieldKeys = null;
        if (PropertyValidator.isValid(params)) {
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> statuses = new ArrayList<String>();
            if (Boolean.TRUE.equals(params.get("parent"))) {
                types.add(parent);
            }
            if (Boolean.TRUE.equals(params.get("child"))) {
                types.add(child);
                miniItem = "'$$ROOT'";
            }
            if (Boolean.TRUE.equals(params.get("open"))) {
                statuses.add(EnumStatusCategory.OPEN.getCode());
                statuses.add(EnumStatusCategory.INPROGRESS.getCode());
            }
            if (Boolean.TRUE.equals(params.get("done"))) {
                statuses.add(EnumStatusCategory.DONE.getCode());
            }
            if (Boolean.TRUE.equals(params.get("misc"))) {
                statuses.add(EnumStatusCategory.MISC.getCode());
                statuses.add(null);
            }
            if (types.size() > 0) {
                where.append("type", (Object)new BasicDBObject("$in", types));
            }
            if (statuses.size() > 0) {
                where.append("status.category", (Object)new BasicDBObject("$in", statuses));
            }
            BasicDBList or = new BasicDBList();
            if (PropertyValidator.isValid((Object)params.get("planned"))) {
                or.add((Object)new BasicDBObject("teamContainers._id", (Object)BasicDBObject.parse((String)"{'$exists' : true}")).append("status.category", (Object)new BasicDBObject("$in", params.get("planned"))));
            }
            if (PropertyValidator.isValid((Object)params.get("backlog"))) {
                or.add((Object)new BasicDBObject("teamContainers._id", (Object)BasicDBObject.parse((String)"{'$exists' : false}")).append("status.category", (Object)new BasicDBObject("$in", params.get("backlog"))));
            }
            if (or.size() > 0) {
                where.append("$or", (Object)or);
            }
            if (params.get("plain") == null) {
                usingGroupBy = true;
                if (notCount) {
                    groups.append("{'_id': {'stats': {'$cond': [ {'$eq':['$type','").append(child).append("']}, {");
                    groups.append(" 'parentId':{'$ifNull':[{'$toString':'$parent.$id'},'0']}");
                    groups.append(",'statusCat':{'$ifNull':[{'$toString':'$status.category'},'Misc']}");
                    groups.append(",'teamId':{'$ifNull':[{'$toString':{'$arrayElemAt':['$teamContainers.team.$id',0]}},'0']}");
                    groups.append(",'containerId':{'$ifNull':[{'$toString':{'$arrayElemAt':['$teamContainers.container.$id',0]}},'0']}");
                    groups.append("} ,{'parentId':'").append(parent).append("','statusCat':'").append(parent).append("','teamId':'").append(parent).append("','containerId':'").append(parent).append("'} ] } }");
                    groups.append(", 'storyPoints':{'$sum':{'$cond':[{'$eq':['$type','").append(child).append("']},{'$ifNull':['$storyPoints',0]},0]}}");
                    groups.append(", 'ids':{'$addToSet':{'$cond':[{'$eq':['$type','").append(child).append("']},'',{'$toString':'$_id'}]}}");
                    groups.append(", 'items':{'$push':  {'$cond':[{'$eq':['$type','").append(child).append("']},").append(miniItem).append(",'$$ROOT']}  }}");
                }
                jiraDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
            }
            if (PropertyValidator.isValid((Object)params.get("sortOpt"))) {
                sortOpt = (String)params.get("sortOpt");
            }
            configFieldKeys = (String)params.get("configFieldKeys");
        }
        if (query != null) {
            DBObject fields = query.getQueryObject();
            Set keys = fields.keySet();
            for (String key : keys) {
                where.append(key, fields.get(key));
            }
            DBObject projection = query.getFieldsObject();
            if (PropertyValidator.isValid((Object)projection)) {
                if (!projection.containsField("")) {
                    project = new BasicDBObject("$project", (Object)projection);
                }
                lookupStatus = false;
                lookupIssueType = false;
                lookupTeamContainer = notCount && projection.containsField("teamContainers");
                lookupItemLinks = notCount && projection.containsField("itemLinks");
                boolean bl = lookupItemJiraDependency = notCount && projection.containsField("jiraDependencies");
            }
        }
        if (lookupStatus) {
            pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'status','localField':'status.$id','foreignField':'_id','as':'status'}")));
            pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$status','preserveNullAndEmptyArrays':true}}"));
        }
        if (lookupIssueType) {
            pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'issueType','localField':'issueType.$id','foreignField':'_id','as':'issueType'}")));
            pipe.add(BasicDBObject.parse((String)"{'$unwind':{'path':'$issueType','preserveNullAndEmptyArrays':true}}"));
        }
        if (lookupTeamContainer) {
            pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'teamContainer','localField':'teamContainers.$id','foreignField':'_id','as':'teamContainers'}")));
        }
        if (lookupItemLinks) {
            pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'itemLink','localField':'itemLinks.$id','foreignField':'_id','as':'itemLinks'}")));
        }
        if (lookupItemJiraDependency) {
            pipe.add(new BasicDBObject("$lookup", (Object)BasicDBObject.parse((String)"{'from':'itemJiraDependency','localField':'jiraDependencies.$id','foreignField':'_id','as':'jiraDependencies'}")));
        }
        pipe.add(new BasicDBObject("$match", (Object)where));
        pipe.add(BasicDBObject.parse((String)"{'$unset': ['mapJiraFields', 'jiraFieldMap'] }"));
        if (PropertyValidator.isValid(configFieldKeys)) {
            pipe.add(BasicDBObject.parse((String)("{ $set: { jiraFieldByKey: { $arrayToObject: { $filter: { input: { $map: { input: { $objectToArray: '$jiraFieldByKey' }, as: 'f', in: { k: '$$f.k', v: { $switch: { branches: [ { case: { $eq: [{ $type: '$$f.v' }, 'array'] }, then: { $concat: [ '{', { $reduce: { input: { $map: { input: '$$f.v', as: 'item', in: { $concat: [ '\\\"', { $ifNull: [ '$$item.accountId', { $toString: '$$item.id' }, '$$item.key', { $toString: '$$item.value' }, { $toString: '$$item' } ] }, '\\\":\\\"', { $ifNull: [ '$$item.displayName', '$$item.title', '$$item.value', '$$item.name', '$$item.key', '$$item.accountId', '$$item.id', '$$item' ] }, '\\\"' ] } } }, initialValue: '', in: { $concat: [ '$$value', { $cond: [ { $eq: ['$$value', ''] }, '', ', ' ] }, '$$this' ] } } }, '}' ] } }, { case: { $and: [ { $eq: [{ $type: '$$f.v' }, 'object'] }, { $not: { $in: ['$$f.k', ['parent', 'issuetype']] } } ] }, then: { $concat: [ '{', '\\\"', { $ifNull: [ '$$f.v.accountId', { $toString: '$$f.v.id' }, '$$f.v.key', { $toString: '$$f.v.value' }, '' ] }, '\\\":\\\"', { $ifNull: [ '$$f.v.displayName', '$$f.v.title', '$$f.v.value', '$$f.v.name', '$$f.v.key', '$$f.v.accountId', '$$f.v.id', '' ] }, '\\\"}', ] } } ], default: '$$f.v' } } } } }, as: 'item', cond: { $and: [ {'$in':['$$item.k',['" + configFieldKeys + "']]}, { $ne: ['$$item.v', null] }, { $ne: ['$$item.v', '{}'] } ] } } } } } }")));
            pipe.add(BasicDBObject.parse((String)"{'$set':{'jiraFieldByKey.parent':{'$mergeObjects':[{},{'id':'$jiraFieldByKey.parent.id','key':'$jiraFieldByKey.parent.key','name':'$jiraFieldByKey.parent.name','self':'$jiraFieldByKey.parent.self','fields':{'summary':'$jiraFieldByKey.parent.fields.summary','issuetype':{'id':'$jiraFieldByKey.parent.fields.issuetype.id','name':'$jiraFieldByKey.parent.fields.issuetype.name','iconUrl':'$jiraFieldByKey.parent.fields.issuetype.iconUrl'}}}]},'jiraFieldByKey.issuetype':{'$mergeObjects':[{},{'id':'$jiraFieldByKey.issuetype.id','name':'$jiraFieldByKey.issuetype.name','iconUrl':'$jiraFieldByKey.issuetype.iconUrl'}]}}}"));
        }
        if (lookupStatus) {
            pipe.add(BasicDBObject.parse((String)"{'$set':{'status':{'$mergeObjects':[{},{'_id':'$status._id','title':'$status.title','category':'$status.category','sessionId':'$status.sessionId'}]}}}"));
        }
        if (notCount) {
            query.getSortObject();
            pipe.add(new BasicDBObject("$sort", (Object)BasicDBObject.parse((String)sortOpt)));
        }
        if (project != null && notCount) {
            pipe.add(project);
        }
        if (Boolean.TRUE.equals(count)) {
            groups.append("{_id: '',total:{$sum:1}}");
        }
        if (notCount && query != null && query.getLimit() > 0) {
            pipe.add(new BasicDBObject("$skip", (Object)query.getSkip()));
            pipe.add(new BasicDBObject("$limit", (Object)query.getLimit()));
        }
        if (groups.length() > 0) {
            pipe.add(new BasicDBObject("$group", (Object)BasicDBObject.parse((String)groups.toString())));
        }
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        Cursor db = collection.aggregate(pipe, ao);
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        Item item = null;
        while (db.hasNext()) {
            DBObject group = (DBObject)db.next();
            if (usingGroupBy) {
                BasicDBList items = (BasicDBList)group.get("items");
                if (PropertyValidator.isValid((Collection)items)) {
                    item = new Item();
                    Collection configFields = (Collection)params.get("configFields");
                    for (int i = 0; i < items.size(); ++i) {
                        Map jiraFields;
                        DBObject dbo = (DBObject)items.get(i);
                        DBUtils.parseDocument((DBObject)dbo);
                        Map map = jiraFields = dbo.containsField("jiraFieldByKey") ? (Map)dbo.get("jiraFieldByKey") : null;
                        if (jiraFields == null) continue;
                        item.setId((String)dbo.get("id"));
                        if (configFields != null) {
                            item.simplifyCustomValues(jiraFields, configFields, null, jiraDateFormat);
                        }
                        if (!PropertyValidator.isValid((Object)item.getJiraFieldTextByKey())) continue;
                        dbo.put("jiraFieldTextByKey", (Object)item.getJiraFieldTextByKey());
                    }
                }
            } else {
                DBUtils.parseDocument((DBObject)group);
            }
            result.add(group);
        }
        db.close();
        return result;
    }

    public Map<String, Object> findTeamContainers(List<String> tcIds, String boardId) throws Exception {
        Map<String, Object> tcMap = new HashMap<String, Object>();
        List sb = null;
        sb = this.getByObjectId((Collection)KendisUtils.getListAsObjectIds((String)boardId), SessionBoard.class);
        if (PropertyValidator.isValid((Collection)sb)) {
            List teams = (List)((DBObject)sb.get(0)).get("teams");
            List sprints = (List)((DBObject)sb.get(0)).get("containers");
            ArrayList<ObjectId> tids = new ArrayList<ObjectId>();
            ArrayList<Object> sids = new ArrayList<Object>();
            for (DBRef dbRef : teams) {
                tids.add(new ObjectId(String.valueOf(dbRef.getId())));
            }
            for (DBRef dbRef : sprints) {
                String sid = String.valueOf(dbRef.getId());
                if (ObjectId.isValid((String)sid)) {
                    sids.add(new ObjectId(sid));
                    continue;
                }
                sids.add(sid);
            }
            tcMap = this.findTeamContainers(tcIds, tids, sids, null, null);
        }
        return tcMap;
    }

    public Map<String, Object> findTeamContainers(List<String> tcIds, List<ObjectId> tids, List<Object> sids, Map<String, Object> tMap, Map<String, Object> cMap) {
        DBCursor cursor = null;
        Query query = null;
        HashMap<String, Object> tcMAP = new HashMap<String, Object>();
        List teams = null;
        List sprints = null;
        try {
            int i;
            HashMap<String, Object> row;
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"container.$id").in(sids));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"team.$id").in(tids));
            cursor = this.mongoTemplate.getCollection(KendisUtils.dbName(TeamContainer.class)).find(query.getQueryObject());
            List tcs = cursor.toArray();
            cursor.close();
            String[] keys = new String[]{"id", "title", "label", "color", "startDate", "endDate", "isIPSprint", "originItemId"};
            if (cMap == null) {
                cMap = new HashMap<String, Object>();
                sprints = this.getByObjectId(sids, Container.class);
                for (DBObject sprint : sprints) {
                    sprint.put("id", (Object)String.valueOf(sprint.get("_id")));
                    row = new HashMap<String, Object>();
                    for (i = 0; i < keys.length; ++i) {
                        if (!sprint.containsField(keys[i])) continue;
                        row.put(keys[i], sprint.get(keys[i]));
                    }
                    cMap.put((String)sprint.get("id"), row);
                }
            }
            if (tMap == null) {
                tMap = new HashMap<String, Object>();
                teams = this.getByObjectId(tids, Team.class);
                for (DBObject team : teams) {
                    team.put("id", (Object)String.valueOf(team.get("_id")));
                    row = new HashMap();
                    for (i = 0; i < 4; ++i) {
                        if (!team.containsField(keys[i])) continue;
                        row.put(keys[i], team.get(keys[i]));
                    }
                    tMap.put((String)team.get("id"), row);
                }
            }
            for (DBObject tc : tcs) {
                DBRef refT = (DBRef)tc.get("team");
                DBRef refC = (DBRef)tc.get("container");
                if (refT == null || refC == null) continue;
                String id = String.valueOf(tc.get("_id"));
                tcIds.add(id);
                HashMap<String, Object> mtc = new HashMap<String, Object>();
                mtc.put("id", id);
                mtc.put("team", tMap.get(String.valueOf(refT.getId())));
                mtc.put("container", cMap.get(String.valueOf(refC.getId())));
                tcMAP.put(id, mtc);
            }
            tcs.clear();
            tcs = null;
            if (sprints != null) {
                sprints.clear();
                sprints = null;
            }
            if (teams != null) {
                teams.clear();
                teams = null;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return tcMAP;
    }

    public List<Item> findBuckets(Session session, Collection<String> issueTypes, List<Boolean> archives) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"jiraId").exists(false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tfsId").exists(false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").in(archives));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(session.getActiveSessionBoard())));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"issueType.$id").in((Collection)KendisUtils.getListAsObjectIds2(issueTypes)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant()));
        return this.mongoTemplate.find(query, Item.class);
    }

    public void addItemsAsBuckets(Session session) {
        Set types = session.getBuckets().keySet();
        HashMap<String, Integer> exists = new HashMap<String, Integer>();
        ArrayList<String> almIds = new ArrayList<String>();
        almIds.add(null);
        if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
            almIds.add(((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getId());
        } else if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
            almIds.add(session.getTfsAlmConfigurations().getAlmAccount().getId());
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isBucket").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").in(almIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant()));
        List iTypes = this.mongoTemplate.find(query, IssueType.class);
        ArrayList<Boolean> archive = new ArrayList<Boolean>();
        archive.add(true);
        archive.add(false);
        archive.add(null);
        List ids = iTypes.stream().map(IssueType::getId).collect(Collectors.toList());
        ids.addAll(types);
        List items = this.findBuckets(session, ids, archive);
        int index = 0;
        for (Item item : items) {
            if (!session.getBucketEnabled().booleanValue() || !session.getBuckets().containsKey(item.getIssueType().getId())) {
                item.setArchive(true);
            } else {
                exists.put(item.getIssueType().getId(), index);
                item.setArchive(false);
            }
            ++index;
        }
        if (session.getBucketEnabled().booleanValue()) {
            ArrayList<SessionBoard> boards = new ArrayList<SessionBoard>();
            boards.add(new SessionBoard(session.getActiveSessionBoard()));
            List statuses = this.statusRepository.findByWorkFlowAndCategory(session.getItemWorkFlow(), EnumStatusCategory.OPEN.getCode());
            for (String typeId : types) {
                if (!exists.containsKey(typeId) && exists.get(typeId) == null) {
                    Item _new = new Item();
                    _new.setId(String.valueOf(ObjectId.get()));
                    _new.setIssueType(new IssueType());
                    _new.setTitle(((IssueType)session.getBuckets().get(typeId)).getTitle());
                    _new.getIssueType().setId(typeId);
                    _new.setSessionBoards(boards);
                    _new.setType(Item.Type.Feature.name());
                    _new.setStatus((Status)statuses.get(0));
                    items.add(_new);
                    continue;
                }
                if (exists.get(typeId) == null || (Integer)exists.get(typeId) >= items.size()) continue;
                ((Item)items.get((Integer)exists.get(typeId))).setTitle(((IssueType)session.getBuckets().get(typeId)).getTitle());
            }
        }
        this.itemRepository.save((Iterable)items);
    }

    public void addAuditLogEntryInActiveSprintForSingleItem(Item item) {
        try {
            if (!PropertyValidator.isValid((Object)item)) {
                return;
            }
            if (!this.isItemInActiveSprint(item)) {
                return;
            }
            User loggedInUser = PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getLoggedInUser()) ? UserContextUtil.getUserContext().getLoggedInUser() : null;
            TeamContainer teamContainer = PropertyValidator.isValid((Collection)item.getTeamContainers()) ? (TeamContainer)item.getTeamContainers().get(0) : null;
            SessionBoard sessionBoard = (SessionBoard)item.getSessionBoards().get(0);
            String userName = PropertyValidator.isValid((Object)loggedInUser) ? loggedInUser.getUserName() : "Webhook";
            if (PropertyValidator.isValid((Object)teamContainer) && PropertyValidator.isValid((Object)sessionBoard)) {
                this.addAuditLogEntryForSprintChange(userName, item, sessionBoard, teamContainer.getTeam(), teamContainer.getContainer());
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void addAuditLogEntryForSprintChange(String userName, Item item, SessionBoard board, Team team, Container container) {
        boolean isSpillOver = false;
        try {
            List<Item> itemsForAuditLog = Collections.singletonList(item);
            if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)container)) {
                List<String> teamIds = Collections.singletonList(team.getId());
                List<String> sprintIds = Collections.singletonList(container.getId());
                HashMap map = new HashMap();
                KendisUtils.putStartEndSprintParam(map, (SessionBoard)board, teamIds, sprintIds);
                this.saveSpillOverOver(userName, map, teamIds, sprintIds, null, null, Boolean.valueOf(isSpillOver), null, itemsForAuditLog, false);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private boolean isItemInActiveSprint(Item item) {
        if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Collection)item.getTeamContainers()) && PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            SessionBoard itemSessionBoard = (SessionBoard)item.getSessionBoards().get(0);
            TeamContainer teamContainer = (TeamContainer)item.getTeamContainers().get(0);
            if (PropertyValidator.isValid((Object)teamContainer.getTeam()) && PropertyValidator.isValid((Object)teamContainer.getContainer()) && PropertyValidator.isValid((Object)itemSessionBoard)) {
                TeamSprintVelocity teamSprintVelocity = this.teamSprintVelocityRepository.findBySessionBoardIdAndTeamIdAndSprintId(itemSessionBoard.getId(), teamContainer.getTeam().getId(), teamContainer.getContainer().getId());
                if (!PropertyValidator.isValid((Object)teamSprintVelocity)) {
                    return false;
                }
                return PropertyValidator.isValid((Object)teamSprintVelocity.getLastBaseLineAuditLogId()) && !PropertyValidator.isValid((Object)teamSprintVelocity.getLastSpillOverAuditLogId());
            }
        }
        return false;
    }

    public Map<String, List<String[]>> removeEmptyCards(Collection<String> parentIds, boolean useThread) {
        String cid = UserContextUtil.getUserContext().getCurrentCompany().getId();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        if (!useThread) {
            return this.findAndRemoveEmptyCards(parentIds, cid, tenant);
        }
        new Thread(() -> {
            try {
                Thread.sleep(800L);
                this.findAndRemoveEmptyCards(parentIds, cid, tenant);
            }
            catch (Exception e) {
                LOGGER.error("Error while finding and removing empty cards asynchronously for company {}." + StringUtils.getTraceString((Throwable)e));
            }
        }).start();
        return null;
    }

    public void removeEmptyCards(Collection<String> parentIds, String cid, String tenant) {
        new Thread(() -> this.findAndRemoveEmptyCards(parentIds, cid, tenant)).start();
    }

    public Map<String, List<String[]>> findAndRemoveEmptyCards(Collection<String> parentIds, String cid, String tenant) {
        HashMap<String, List<String[]>> keys = new HashMap<String, List<String[]>>();
        if (PropertyValidator.isValid((Object)cid) && PropertyValidator.isValid((Object)tenant)) {
            try {
                List items = this.itemRepository.findByIdInOrParentIdInAndTeamContainersExists(parentIds, parentIds, Boolean.valueOf(true));
                HashMap<String, Integer> parentTCMap = new HashMap<String, Integer>();
                HashSet<String> childTcs = new HashSet<String>();
                for (int i = 0; i < items.size(); ++i) {
                    Item item = (Item)items.get(i);
                    if (!PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
                    if (item.getType().equals(Item.Type.Feature.name())) {
                        for (TeamContainer tc : item.getTeamContainers()) {
                            parentTCMap.put(tc.getId(), i);
                        }
                        continue;
                    }
                    if (!PropertyValidator.isValid(item.getTeamContainers().get(0))) continue;
                    childTcs.add(((TeamContainer)item.getTeamContainers().get(0)).getId());
                }
                Sets.SetView parentTCsWithOutChild = Sets.difference(parentTCMap.keySet(), childTcs);
                Query query = new Query();
                query.fields().include("_id");
                query.fields().include("sourceTeamContainerId");
                query.fields().include("targetTeamContainerId");
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"sourceTeamContainerId").in((Collection)parentTCsWithOutChild), Criteria.where((String)"targetTeamContainerId").in((Collection)parentTCsWithOutChild)}));
                List links = this.mongoTemplate.find(query, ItemLink.class);
                HashSet<String> linkedTCs = new HashSet<String>();
                for (ItemLink link : links) {
                    linkedTCs.add(link.getSourceTeamContainerId());
                    linkedTCs.add(link.getTargetTeamContainerId());
                }
                Sets.SetView parentTCsWithOutDependencies = Sets.difference((Set)parentTCsWithOutChild, linkedTCs);
                HashMap<String, StringBuilder> itemToTCsMap = new HashMap<String, StringBuilder>();
                HashSet<ObjectId> itemIdsToUpdate = new HashSet<ObjectId>();
                StringBuilder cases = new StringBuilder();
                for (String string : parentTCsWithOutDependencies) {
                    int index;
                    Item item = (Item)items.get((Integer)parentTCMap.get(string));
                    if (!PropertyValidator.isValid((Object)item.getTfsId()) && !PropertyValidator.isValid((Object)item.getJiraId()) || !PropertyValidator.isValid((Collection)item.getTeamContainers())) continue;
                    TeamContainer tc = null;
                    if (PropertyValidator.isValid((Collection)item.getTeamContainers()) && (index = item.getTeamContainers().indexOf(new TeamContainer(string))) > -1 && index < item.getTeamContainers().size()) {
                        tc = (TeamContainer)item.getTeamContainers().get(index);
                    }
                    if (tc == null) continue;
                    String itemId = item.getId();
                    itemIdsToUpdate.add(new ObjectId(itemId));
                    if (itemToTCsMap.get(itemId) == null) {
                        itemToTCsMap.put(itemId, new StringBuilder());
                    }
                    if (((StringBuilder)itemToTCsMap.get(itemId)).length() > 0) {
                        ((StringBuilder)itemToTCsMap.get(itemId)).append(",");
                    }
                    ((StringBuilder)itemToTCsMap.get(itemId)).append("ObjectId('").append(tc.getId()).append("')");
                    if (keys == null) continue;
                    if (keys.get(itemId) == null) {
                        keys.put(itemId, new ArrayList());
                    }
                    ((List)keys.get(item.getId())).add(new String[]{tc.getTeam().getId(), tc.getContainer().getId()});
                }
                if (!itemIdsToUpdate.isEmpty()) {
                    for (Map.Entry entry : itemToTCsMap.entrySet()) {
                        String key = (String)entry.getKey();
                        StringBuilder val = (StringBuilder)entry.getValue();
                        if (cases.length() > 0) {
                            cases.append(",");
                        }
                        cases.append("{'case':{'$eq':['$_id',ObjectId('").append(key).append("')]},'then':{'$filter':{'input':'$teamContainers','cond':{'$not':{'$in':['$$this.$id',[").append(val.toString()).append("]]}}}}}");
                    }
                    if (cases.length() > 0) {
                        StringBuilder json = new StringBuilder("{");
                        json.append("'teamContainers':{$switch:{branches:[").append(cases.toString()).append("],default:'$teamContainers' } }");
                        json.append(" }");
                        DBCollection dBCollection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
                        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
                        BasicDBObject in = new BasicDBObject("$in", itemIdsToUpdate);
                        BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)in));
                        BasicDBObject addFields = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)json.toString()));
                        BasicDBObject merge = new BasicDBObject("$merge", (Object)BasicDBObject.parse((String)"{into:'item',whenMatched:'merge',whenNotMatched:'discard'}"));
                        List<DBObject> pipeline = Arrays.asList(match, addFields, merge);
                        Cursor db = dBCollection.aggregate(pipeline, ao);
                        db.close();
                        if (keys != null) {
                            Gson gson = new Gson();
                            HashMap<String, Object> response = new HashMap<String, Object>();
                            HashMap<String, String> metaMap = new HashMap<String, String>();
                            response.put("type", "Board");
                            metaMap.put("event", "EMPTY_CELL");
                            metaMap.put("type", "Board");
                            response.put("metaMap", gson.toJson(metaMap));
                            response.put("removedTcKeys", keys);
                            PushSender.sendPushMsg((String)cid, (String)gson.toJson(response));
                            return keys;
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }

    public HashMap<String, Object> saveSpillOverOver(String uname, Map<String, Object> mapBidByTidSid, List<String> tids, List<String> sids, String cid, String syncId, Boolean isSpillOver, JiraSprint jiraSprint, List<Item> itemsForAuditLog, boolean updateTSV) throws Exception {
        Gson gson = new GsonBuilder().setDateFormat(0, 0).create();
        HashMap<String, Object> response = new HashMap<String, Object>();
        ArrayList tcIds = new ArrayList();
        ArrayList<SessionBoard> sb = new ArrayList<SessionBoard>();
        HashMap baseLineDataIds = new HashMap();
        HashMap<Object, AuditLog> auditMap = new HashMap<Object, AuditLog>();
        HashMap iMap = new HashMap();
        HashMap _baseLines = new HashMap();
        HashMap<String, TeamSprintVelocity> velMap = new HashMap<String, TeamSprintVelocity>();
        List bids = (List)mapBidByTidSid.get("bids");
        Date now = new Date();
        List<TeamSprintVelocity> tcVels = null;
        boolean isSpecficItemsUpdate = false;
        boolean debug = mapBidByTidSid.get("debug") != null;
        String token = "_";
        try {
            for (String bid : bids) {
                sb.add(new SessionBoard(bid));
            }
            if (debug) {
                LOGGER.debug("1..... start-end Sprint ..... srvice.....");
            }
            List items = null;
            Map tcMAP = this.findTeamContainers(tcIds, KendisUtils.getListAsObjectIds(tids), KendisUtils.getListAsObjectIds2(sids), null, null);
            tcVels = this.teamSprintVelocityRepository.findBySessionBoardIdInAndSprintIdInAndTeamIdIn((Collection)bids, sids, tids);
            if (!isSpillOver.booleanValue()) {
                if (!PropertyValidator.isValid(itemsForAuditLog)) {
                    items = this.itemRepository.findBySessionBoardsInAndTeamContainersIdInAndTypeAndArchiveNot(sb, tcIds, Item.Type.UserStory.name(), Boolean.valueOf(true));
                } else {
                    items = itemsForAuditLog;
                    isSpecficItemsUpdate = true;
                }
            }
            if (debug) {
                LOGGER.debug("2..... start-end Sprint ..... fetched.....");
            }
            if (PropertyValidator.isValid((Collection)tcVels)) {
                for (TeamSprintVelocity tcVel : tcVels) {
                    if (!isSpillOver.booleanValue()) {
                        tcVel.setCommitedLoad(Double.valueOf(0.0));
                    }
                    String tid_sid = tcVel.getTeamId() + token + tcVel.getSprintId();
                    velMap.put(tid_sid, tcVel);
                    if (!isSpillOver.booleanValue()) continue;
                }
            } else {
                tcVels = new ArrayList();
            }
            if (baseLineDataIds.size() > 0) {
                Object lastAudit;
                if (debug) {
                    LOGGER.debug("3..... start-end Sprint ..... pervuios start sprints from AuditLog using findByIdIn.....");
                }
                if (PropertyValidator.isValid((Collection)(lastAudit = this.auditLogRepository.findByIdIn(baseLineDataIds.keySet())))) {
                    3 T = new /* Unavailable Anonymous Inner Class!! */;
                    for (int i = 0; i < lastAudit.size(); ++i) {
                        if (!baseLineDataIds.containsKey(((AuditLog)lastAudit.get(i)).getId())) continue;
                        _baseLines.put(baseLineDataIds.get(((AuditLog)lastAudit.get(i)).getId()), gson.fromJson(((AuditLog)lastAudit.get(i)).getAuditData(), T.getType()));
                    }
                }
                if (debug) {
                    LOGGER.debug("4..... start-end Sprint ..... AuditLog fetching done.....");
                }
            }
            for (Object bid : bids) {
                List bTids = (List)mapBidByTidSid.get("tids_" + (String)bid);
                List bSids = (List)mapBidByTidSid.get("sids_" + (String)bid);
                if (!PropertyValidator.isValid((Collection)bTids) || bTids.size() <= 0 || !PropertyValidator.isValid((Collection)bSids) || bSids.size() <= 0) continue;
                for (String sprintId : bSids) {
                    for (String teamId : bTids) {
                        String tid_sid = teamId + token + sprintId;
                        if (!velMap.containsKey(tid_sid)) {
                            TeamSprintVelocity tsv = new TeamSprintVelocity();
                            tsv.setTeamId(teamId);
                            tsv.setSprintId(sprintId);
                            tsv.setVelocity(Double.valueOf(0.0));
                            tsv.setCommitedLoad(Double.valueOf(0.0));
                            tsv.setSessionBoardId((String)mapBidByTidSid.get(tid_sid));
                            if (mapBidByTidSid.containsKey(tsv.getSessionBoardId())) {
                                tsv.setTenant((String)mapBidByTidSid.get("tenant_" + tsv.getSessionBoardId()));
                            }
                            velMap.put(tid_sid, tsv);
                            tcVels.add(tsv);
                        }
                        iMap.put(tid_sid, new HashMap());
                    }
                }
            }
            if (debug) {
                LOGGER.debug("5..... start-end Sprint ..... Team/Sprint Vel Map created");
            }
            List baords = null;
            if (PropertyValidator.isValid((Collection)items)) {
                if (debug) {
                    LOGGER.debug("6..... start-end Sprint ..... processing items size [" + items.size() + "] ");
                }
                for (Item item2 : items) {
                    String key2;
                    Map tc = null;
                    if (PropertyValidator.isValid((Collection)item2.getTeamContainers()) && PropertyValidator.isValid(item2.getTeamContainers().get(0))) {
                        tc = (Map)tcMAP.get(((TeamContainer)item2.getTeamContainers().get(0)).getId());
                    }
                    if (!PropertyValidator.isValid(tc)) continue;
                    if (baords == null) {
                        baords = item2.getSessionBoards();
                    }
                    String key = item2.getJiraId();
                    Item feature = item2.getParent();
                    List parenTcs = feature.getTeamContainers();
                    if (!PropertyValidator.isValid((Object)key)) {
                        key = item2.getTfsId();
                    }
                    if (!PropertyValidator.isValid((Object)key)) {
                        key = item2.getOriginItemId();
                    }
                    if (!PropertyValidator.isValid((Object)key)) {
                        key = item2.getId();
                    }
                    if (!PropertyValidator.isValid((Object)feature) || !PropertyValidator.isValid((Collection)parenTcs)) continue;
                    String tid_sid = ((Map)tc.get("team")).get("id") + token + ((Map)tc.get("container")).get("id");
                    item2.setSessionBoards(baords);
                    HashMap trimedItem = item2.toMap();
                    ArrayList<Map> tcList = new ArrayList<Map>();
                    if (tc != null) {
                        tcList.add(tc);
                    }
                    trimedItem.put("teamContainers", tcList);
                    HashMap parent = feature.toMap();
                    String featureKey = null;
                    String featureKeyLink = null;
                    HashMap _parent = (HashMap)trimedItem.get("parent");
                    if (PropertyValidator.isValid((Object)_parent)) {
                        if (PropertyValidator.isValid((Object)feature.getJiraId())) {
                            featureKey = feature.getJiraKey();
                            _parent.put("keyType", "jiraKey");
                            _parent.put("jiraIssueTypeId", feature.getJiraIssueTypeId());
                        } else if (PropertyValidator.isValid((Object)feature.getTfsId())) {
                            featureKey = feature.getTfsId();
                            featureKeyLink = feature.getTfsURL();
                            _parent.put("keyType", "tfsId");
                            _parent.put("tfsItemTypeIcon", feature.getTfsItemTypeIcon());
                        } else if (PropertyValidator.isValid((Object)feature.getKendisKey())) {
                            featureKey = feature.getKendisKey();
                            featureKeyLink = feature.getExternalReferenceURL();
                            _parent.put("keyType", "kendisKey");
                        } else if (PropertyValidator.isValid((Object)feature.getJiraKey())) {
                            featureKey = feature.getJiraKey();
                            featureKeyLink = feature.getExternalReferenceURL();
                            _parent.put("keyType", "kendisKey");
                        }
                        _parent.put("key", featureKey);
                        _parent.put("keyLink", featureKeyLink);
                    }
                    if (!PropertyValidator.isValid((Object)(key2 = feature.getJiraId()))) {
                        key2 = feature.getTfsId();
                    }
                    if (!PropertyValidator.isValid((Object)key2)) {
                        key2 = feature.getOriginItemId();
                    }
                    if (!PropertyValidator.isValid((Object)key2)) {
                        key2 = feature.getId();
                    }
                    if (iMap.get(tid_sid) != null && !((Map)iMap.get(tid_sid)).containsKey(key2)) {
                        tcList = new ArrayList();
                        if (PropertyValidator.isValid((Collection)parenTcs)) {
                            for (int j = 0; j < parenTcs.size(); ++j) {
                                tc = (Map)tcMAP.get(((TeamContainer)parenTcs.get(j)).getId());
                                if (tc == null) continue;
                                tcList.add(tc);
                            }
                        }
                        parent.put("teamContainers", tcList);
                        ((Map)iMap.get(tid_sid)).put(key2, parent);
                    }
                    ((Map)iMap.get(tid_sid)).put(key, trimedItem);
                    TeamSprintVelocity tsv = (TeamSprintVelocity)velMap.get(tid_sid);
                    if (!updateTSV) continue;
                    if (isSpillOver.booleanValue()) {
                        tsv.setLastSpillOverDate(now);
                        continue;
                    }
                    tsv.setCommitedLoad(Double.valueOf(tsv.getCommitedLoad() + item2.getStoryPoints()));
                    tsv.setLastBaseLineDate(now);
                }
            }
            if (debug) {
                LOGGER.debug("7..... start-end Sprint ..... processing for new Audit logs");
            }
            Set tids_sids = iMap.keySet();
            for (Object tid_sid : tids_sids) {
                if (!PropertyValidator.isValid(iMap.get(tid_sid))) continue;
                Set keys = ((Map)iMap.get(tid_sid)).keySet();
                for (String key : keys) {
                    if (!_baseLines.containsKey(tid_sid)) continue;
                    ((Map)_baseLines.get(tid_sid)).remove(key);
                }
                if (!auditMap.containsKey(tid_sid)) {
                    AuditLog log = new AuditLog();
                    log.setId(ObjectId.get().toHexString());
                    log.setCreatedBy(uname);
                    log.setUpdatedBy(uname);
                    log.setCreatedOn(now);
                    log.setUpdatedOn(now);
                    log.setEventType(isSpillOver != false ? "SPILL_OVER" : "BASE_LINE");
                    log.setSessionBoardId((String)mapBidByTidSid.get(tid_sid));
                    log.setAuditMeta(new HashMap());
                    if (PropertyValidator.isValid((Collection)itemsForAuditLog)) {
                        log.setLinkedBaseLineAuditLogId(PropertyValidator.isValid(velMap.get(tid_sid)) ? ((TeamSprintVelocity)velMap.get(tid_sid)).getLastBaseLineAuditLogId() : null);
                        List<Object> itemKeys = new ArrayList();
                        if (PropertyValidator.isValid((Collection)items)) {
                            itemKeys = items.stream().map(item -> {
                                if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                                    return item.getJiraKey();
                                }
                                if (PropertyValidator.isValid((Object)item.getTfsId())) {
                                    return item.getTfsId();
                                }
                                return item.getKendisKey();
                            }).collect(Collectors.toList());
                            log.getAuditMeta().put("itemKeys", itemKeys);
                        }
                    }
                    if (mapBidByTidSid.containsKey(log.getSessionBoardId())) {
                        log.setTenant((String)mapBidByTidSid.get("tenant_" + log.getSessionBoardId()));
                    }
                    String[] team_sprint = ((String)tid_sid).split(token);
                    log.getAuditMeta().put("teamId", team_sprint[0]);
                    log.getAuditMeta().put("sprintId", team_sprint[1]);
                    auditMap.put(tid_sid, log);
                }
                if (isSpillOver.booleanValue()) {
                    if (_baseLines.containsKey(tid_sid)) {
                        ((AuditLog)auditMap.get(tid_sid)).setAuditData(gson.toJson(_baseLines.get(tid_sid)));
                        continue;
                    }
                    ((AuditLog)auditMap.get(tid_sid)).setAuditData(gson.toJson(new HashMap()));
                    continue;
                }
                ((AuditLog)auditMap.get(tid_sid)).setAuditData(gson.toJson(iMap.get(tid_sid)));
            }
            if (debug) {
                LOGGER.debug("8..... start-end Sprint ..... processed new Audit logs size [" + auditMap.size() + "]");
            }
            ArrayList<AuditLog> missed = new ArrayList<AuditLog>();
            for (String key : tids_sids) {
                if (!velMap.containsKey(key) || !auditMap.containsKey(key)) continue;
                if (isSpillOver.booleanValue()) {
                    if (PropertyValidator.isValid((Object)((TeamSprintVelocity)velMap.get(key)).getLastBaseLineDate()) && PropertyValidator.isValid((Object)((TeamSprintVelocity)velMap.get(key)).getLastBaseLineAuditLogId())) {
                        if (!updateTSV) continue;
                        ((TeamSprintVelocity)velMap.get(key)).setLastSpillOverAuditLogId(((AuditLog)auditMap.get(key)).getId());
                        ((TeamSprintVelocity)velMap.get(key)).setLastSpillOverDate(now);
                        continue;
                    }
                    if (updateTSV) {
                        velMap.remove(key);
                    }
                    AuditLog empty = (AuditLog)auditMap.remove(key);
                    empty.setEventType("SKIP_SPILL_OVER");
                    missed.add(empty);
                    continue;
                }
                if (PropertyValidator.isValid((Object)((TeamSprintVelocity)velMap.get(key)).getLastBaseLineAuditLogId()) && auditMap.containsKey(key)) {
                    ((AuditLog)auditMap.get(key)).setEventType("BASE_LINE_2");
                }
                if (updateTSV) {
                    ((TeamSprintVelocity)velMap.get(key)).setLastBaseLineAuditLogId(((AuditLog)auditMap.get(key)).getId());
                    ((TeamSprintVelocity)velMap.get(key)).setLastBaseLineDate(now);
                    ((TeamSprintVelocity)velMap.get(key)).setLastSpillOverAuditLogId(null);
                    continue;
                }
                if (!isSpecficItemsUpdate) continue;
                ((AuditLog)auditMap.get(key)).setEventType("ITEM_ADD");
            }
            boolean saveData = true;
            if (isSpillOver.booleanValue()) {
                // empty if block
            }
            if (saveData) {
                this.auditLogRepository.save(auditMap.values());
                if (debug) {
                    LOGGER.debug("9..... start-end Sprint ..... saved Audit logs");
                }
                if (updateTSV) {
                    tcVels = this.teamSprintVelocityRepository.save(tcVels);
                }
                if (debug) {
                    LOGGER.debug("10..... start-end Sprint ..... saved Team/Sprint Vel");
                }
            } else {
                auditMap = new HashMap();
                tcVels = new ArrayList();
            }
            if (missed.size() > 0) {
                this.auditLogRepository.save(missed);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        response.put("type", "Board");
        metaMap.put("event", "Velocity");
        metaMap.put("type", "Board");
        if (syncId == null) {
            metaMap.put("isJira", true);
        } else {
            metaMap.put("syncId", syncId);
        }
        if (bids.size() == 1) {
            metaMap.put("boardId", bids.get(0));
        }
        response.put("metaMap", gson.toJson(metaMap));
        response.put("auditMap", gson.toJson(auditMap));
        response.put("velocities", tcVels);
        response.put("sprintIds", sids);
        if (jiraSprint != null) {
            response.put("sprintJiraId", jiraSprint.getId());
            response.put("sprintState", jiraSprint.getState());
        }
        response.put("time", now.getTime());
        if (isSpillOver.booleanValue()) {
            response.put("isSpillOver", isSpillOver);
        }
        response.put("end_action", mapBidByTidSid.get("end_action"));
        if (PropertyValidator.isValid((Object)syncId)) {
            PushSender.sendMsg((String)gson.toJson(response));
            if (debug) {
                LOGGER.debug("11..... start-end Sprint ..... pushed");
            }
        } else if (PropertyValidator.isValid((Object)cid)) {
            PushSender.sendPushMsg((String)cid, (String)gson.toJson(response));
            if (debug) {
                LOGGER.debug("12..... start-end Sprint ..... pushed");
            }
        } else {
            response.put("auditMap", auditMap);
        }
        return response;
    }

    public List<CanvasBoard> getSystemTemplates(Boolean isSystem) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isSystem").is((Object)true));
        List boards = this.mongoTemplate.find(query, CanvasBoard.class);
        return boards;
    }

    public void checkIfSessionLocked(String sessionId, String currentEvent) throws ViztrendJiraException {
        this.checkIfSessionLockedWithTime(sessionId, currentEvent, Long.valueOf(599999L));
    }

    public void checkIfSessionLocked(String sessionId, String currentEvent, String type) throws ViztrendJiraException {
        this.checkIfSessionLockedWithTime(sessionId, currentEvent, Long.valueOf(599999L), type);
    }

    public void checkIfSolutionBoardLocked(String sessionId, String currentEvent, String type) throws ViztrendJiraException {
        this.checkIfSolutionBoardLockedWithTime(sessionId, currentEvent, Long.valueOf(599999L), type);
    }

    public void checkIfRiskRegisterLocked(String sessionId, String currentEvent, String type) throws ViztrendJiraException {
        this.checkIfRiskRegisterLockedWithTime(sessionId, currentEvent, Long.valueOf(599999L), type);
    }

    public boolean isLockedObjectFound(String sessionId, String currentEvent, Long waitTime) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is(null));
        LockedObject locked = (LockedObject)this.mongoTemplate.findOne(query, LockedObject.class);
        if (PropertyValidator.isValid((Object)locked)) {
            return System.currentTimeMillis() - locked.getLockTime() <= waitTime;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkIfSessionLockedWithTime(String sessionId, String currentEvent, Long waitTime) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        if ("NOTIFICATION_EVENT".equals(currentEvent)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"lockedForEvent").is((Object)currentEvent));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is(null));
        LockedObject locked = (LockedObject)this.mongoTemplate.findOne(query, LockedObject.class);
        if (!PropertyValidator.isValid((Object)locked)) {
            this.mongoTemplate.save((Object)new LockedObject(sessionId, currentEvent, Long.valueOf(System.currentTimeMillis())));
            return;
        }
        Long diff = System.currentTimeMillis() - locked.getLockTime();
        if (diff > waitTime) {
            this.removeSessionLock(sessionId);
            this.mongoTemplate.save((Object)new LockedObject(sessionId, currentEvent, Long.valueOf(System.currentTimeMillis())));
            return;
        }
        if (!"NOTIFICATION_EVENT".equals(currentEvent)) throw new ViztrendJiraException(true, Integer.valueOf(Integer.parseInt(HttpStatus.LOCKED.toString())), "Please wait. " + locked.getLockedForEvent() + " is being done by another user.");
        throw new ViztrendJiraException(true, Integer.valueOf(Integer.parseInt(HttpStatus.LOCKED.toString())), "" + (waitTime - diff));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkIfSessionLockedWithTime(String sessionId, String currentEvent, Long waitTime, String type) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        LockedObject locked = (LockedObject)this.mongoTemplate.findOne(query, LockedObject.class);
        if (PropertyValidator.isValid((Object)locked)) {
            if (System.currentTimeMillis() - locked.getLockTime() <= waitTime) throw new ViztrendJiraException(true, Integer.valueOf(Integer.parseInt(HttpStatus.LOCKED.toString())), "Please wait. " + locked.getLockedForEvent() + " is being done by another user.");
            this.removeSessionLock2(sessionId, type);
            this.mongoTemplate.save((Object)new LockedObject(sessionId, currentEvent, Long.valueOf(System.currentTimeMillis()), type));
            return;
        } else {
            this.mongoTemplate.save((Object)new LockedObject(sessionId, currentEvent, Long.valueOf(System.currentTimeMillis()), type));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkIfRiskRegisterLockedWithTime(String riskRegisterId, String currentEvent, Long waitTime, String type) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisterId").is((Object)riskRegisterId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        LockedObject locked = (LockedObject)this.mongoTemplate.findOne(query, LockedObject.class);
        LockedObject newLocked = new LockedObject();
        newLocked.setRiskRegisterId(riskRegisterId);
        newLocked.setType(type);
        newLocked.setLockedForEvent(currentEvent);
        newLocked.setLockTime(Long.valueOf(System.currentTimeMillis()));
        if (PropertyValidator.isValid((Object)locked)) {
            if (System.currentTimeMillis() - locked.getLockTime() <= waitTime) throw new ViztrendJiraException(true, Integer.valueOf(Integer.parseInt(HttpStatus.LOCKED.toString())), "Please wait. " + locked.getLockedForEvent() + " is being done by another user.");
            this.removeRiskRegisterLock(riskRegisterId, type);
            this.mongoTemplate.save((Object)newLocked);
            return;
        } else {
            this.mongoTemplate.save((Object)newLocked);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkIfSolutionBoardLockedWithTime(String solutionBoardId, String currentEvent, Long waitTime, String type) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoardId").is((Object)solutionBoardId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        LockedObject locked = (LockedObject)this.mongoTemplate.findOne(query, LockedObject.class);
        LockedObject newLocked = new LockedObject();
        newLocked.setSolutionBoardId(solutionBoardId);
        newLocked.setType(type);
        newLocked.setLockedForEvent(currentEvent);
        newLocked.setLockTime(Long.valueOf(System.currentTimeMillis()));
        if (PropertyValidator.isValid((Object)locked)) {
            if (System.currentTimeMillis() - locked.getLockTime() <= waitTime) throw new ViztrendJiraException(true, Integer.valueOf(Integer.parseInt(HttpStatus.LOCKED.toString())), "Please wait. " + locked.getLockedForEvent() + " is being done by another user.");
            this.removeSolutionBoardLock(solutionBoardId, type);
            this.mongoTemplate.save((Object)newLocked);
            return;
        } else {
            this.mongoTemplate.save((Object)newLocked);
        }
    }

    public void removeSessionLock(String sessionId) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is(null));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public void removeSessionLock(String sessionId, String event) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"lockedForEvent").is((Object)event));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is(null));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public void removeSessionLock2(String sessionId, String type) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public void removeSolutionBoardLock(String solutionBoardId, String type) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoardId").is((Object)solutionBoardId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public void removeRiskRegisterLock(String riskRegisterId, String type) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisterId").is((Object)riskRegisterId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public void checkIfReleaseTrainLocked(String releaseTrainId, String currentEvent) throws ViztrendJiraException {
        this.checkIfReleaseTrainLockedWithTime(releaseTrainId, currentEvent, Long.valueOf(599999L));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkIfReleaseTrainLockedWithTime(String releaseTrainId, String currentEvent, Long waitTime) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"releaseTrainId").is((Object)releaseTrainId));
        LockedObject locked = (LockedObject)this.mongoTemplate.findOne(query, LockedObject.class);
        if (PropertyValidator.isValid((Object)locked)) {
            if (System.currentTimeMillis() - locked.getLockTime() <= waitTime) throw new ViztrendJiraException(true, Integer.valueOf(Integer.parseInt(HttpStatus.LOCKED.toString())), "Please wait. " + locked.getLockedForEvent() + " is being done by another user.");
            this.removeSessionLock(releaseTrainId);
            LockedObject obj = new LockedObject();
            obj.setReleaseTrainId(releaseTrainId);
            obj.setLockedForEvent(currentEvent);
            obj.setLockTime(Long.valueOf(System.currentTimeMillis()));
            this.mongoTemplate.save((Object)obj);
            return;
        } else {
            LockedObject obj = new LockedObject();
            obj.setReleaseTrainId(releaseTrainId);
            obj.setLockedForEvent(currentEvent);
            obj.setLockTime(Long.valueOf(System.currentTimeMillis()));
            this.mongoTemplate.save((Object)obj);
        }
    }

    public void removeReleaseTrainLock(String releaseTrainId) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"releaseTrainId").is((Object)releaseTrainId));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public void removeReleaseTrainLock(String releaseTrainId, String event) throws ViztrendJiraException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"releaseTrainId").is((Object)releaseTrainId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"lockedForEvent").is((Object)event));
        this.mongoTemplate.remove(query, LockedObject.class);
    }

    public SessionBoard getSessionBoardbyId(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        query.fields().include("containers");
        List sessionBoardList = this.mongoTemplate.find(query, SessionBoard.class);
        if (PropertyValidator.isValid((Collection)sessionBoardList)) {
            return (SessionBoard)sessionBoardList.get(0);
        }
        return null;
    }

    public PiSystemRole findSystemRoleByTitle(String title) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").regex("^" + title));
        List piSystemRoleList = this.mongoTemplate.find(query, PiSystemRole.class);
        if (PropertyValidator.isValid((Collection)piSystemRoleList)) {
            return (PiSystemRole)piSystemRoleList.get(0);
        }
        return null;
    }

    public void updateNoticationCount(String sessionBoardId, Integer count) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(sessionBoardId)));
        Update update = new Update();
        update.set("noticationCounter", (Object)count);
        this.getMongoTemplate().updateFirst(query, update, SessionBoard.class);
    }

    public void updateSyncTimer(String sessionBoardId, Integer count) throws Exception {
        if (ObjectId.isValid((String)sessionBoardId)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(sessionBoardId)));
            Update update = new Update();
            if (count == null) {
                count = 5;
            }
            update.set("syncTimer", (Object)count);
            this.getMongoTemplate().updateFirst(query, update, Session.class);
        }
    }

    public void findActivityUpToDate(String sessionBoardId, Date date) {
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        BasicDBObject sort = new BasicDBObject("$sort", (Object)new BasicDBObject("createdOn", (Object)-1));
        BasicDBObject group = new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)"$itemId").append("doc", (Object)new BasicDBObject("$first", (Object)"$$ROOT")));
        BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject("itemType", (Object)"Item").append("tenant", (Object)tenant).append("sessionBoard.$id", (Object)new ObjectId(sessionBoardId)));
        DBCollection collection = this.mongoTemplate.getCollection("itemLog");
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.FALSE).build();
        List<DBObject> pipeline = Arrays.asList(match, sort, group);
        Cursor db = collection.aggregate(pipeline, ao);
        HashSet<String> logIds = new HashSet<String>();
        while (db.hasNext()) {
            DBObject dbo = (DBObject)db.next();
            Map doc = (Map)dbo.get("doc");
            logIds.add(String.valueOf(doc.get("_id")));
        }
    }

    public List<DBObject> findItemLogForAddedInSession(String tenant, Date start, Date end, String property, Collection keys, Class<?> clazz, boolean test) {
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(clazz));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        BasicDBObject clauses = new BasicDBObject("detail.type", (Object)Item.Type.Feature.name()).append("tenant", (Object)tenant).append(property, (Object)new BasicDBObject("$in", (Object)keys)).append("eventType", (Object)new BasicDBObject("$in", (Object)new /* Unavailable Anonymous Inner Class!! */)).append("tenant", (Object)tenant);
        if (start == null || end != null) {
            // empty if block
        }
        ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
        BasicDBObject match = new BasicDBObject("$match", (Object)clauses);
        BasicDBObject field = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{ '_id': {'$toString': '$_id'}, '_date': {'$dateToString': {'format': '%Y-%m-%d', 'date': '$eventTime'}}, 'issueTypeId': {'$cond': {'if': '$detail.issueType', 'then': '$detail.issueType.id', 'else' : '0'}}, 'event_type': { '$cond' : { 'if' : { '$eq': [ '$eventType', 'CREATED' ] } , 'then' : '$eventType', 'else' : { '$cond' : { 'if' : { '$gt': [ {'$subtract': [ '$detail.updatedOn', '$detail.createdOn' ]} , 999 ] } , 'then' : '', 'else' : 'CREATED' } } } } }"));
        BasicDBObject group1 = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id': {'$concat': ['$_date', '_','$issueTypeId']}, 'logs': {'$addToSet': '$itemId'}}"));
        if (!test) {
            pipeline.add(field);
            pipeline.add(match);
            pipeline.add(group1);
        } else {
            group1 = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id': '$itemId', 'logs': {'$push': '$$ROOT'}}"));
            BasicDBObject project1 = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{'_id':0,'row':{'$reduce':{'input':'$logs','initialValue':{'prev':null,'results':[]},'in':{'data':'$$this','prev':'$$this.lastLogDiff','results':{'$concatArrays':['$$value.results',[{'old_value':'$$value.data.detail.status','issueTypeId':'$$value.data.issueTypeId','old_value_time':'$$value.data._date','diff':{'$subtract':['$$this.lastLogDiff','$$value.prev']}}]]}}}}}"));
            BasicDBObject $unwind = new BasicDBObject("$unwind", (Object)"$row.results");
            BasicDBObject project2 = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{'_id': '$row.data.itemId', 'data': '$row.data', 'itemId': '$row.itemId', 'old_value': '$row.results.old_value', 'old_value_time': '$row.data._date', 'seconds': '$row.results.diff'}"));
            BasicDBObject group2 = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id': {'$concat': ['$old_value_time', '_','$data.issueTypeId']}, 'total': {'$sum': '$seconds'}, 'logs': {'$addToSet': '$$ROOT.data.itemId'}}"));
            pipeline.add(field);
            pipeline.add(match);
            pipeline.add(group1);
            pipeline.add(project1);
            pipeline.add($unwind);
            pipeline.add(project2);
            pipeline.add(group2);
        }
        Cursor db = collection.aggregate(pipeline, ao);
        ArrayList<DBObject> dbos = new ArrayList<DBObject>();
        while (db.hasNext()) {
            dbos.add((DBObject)db.next());
        }
        db.close();
        return dbos;
    }

    public List<DBObject> findItemLog(String tenant, Date start, Date end, String change, String property, Collection keys, Class<?> clazz, Integer test) {
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(clazz));
        AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
        BasicDBObject clauses = new BasicDBObject("actions." + change, (Object)BasicDBObject.parse((String)"{'$exists' : true}")).append("tenant", (Object)tenant).append(property, (Object)new BasicDBObject("$in", (Object)keys));
        if (start != null && end != null) {
            BasicDBList and = new BasicDBList();
            and.add((Object)new BasicDBObject("eventTime", (Object)new BasicDBObject("$gte", (Object)start)));
            and.add((Object)new BasicDBObject("eventTime", (Object)new BasicDBObject("$lte", (Object)end)));
            clauses.append("$and", (Object)and);
        }
        BasicDBObject match = new BasicDBObject("$match", (Object)clauses);
        BasicDBObject field = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)"{'_id':{'$toString':'$_id'},'_date':{'$dateToString':{'format':'%Y-%m-%d','date':'$eventTime'}},'lastLogDiff':{'$toLong':'$eventTime'}}"));
        BasicDBObject group1 = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id': '$itemId', 'logs': {'$push': '$$ROOT'}}"));
        BasicDBObject project1 = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{'_id':0,'row':{'$reduce':{'input':'$logs','initialValue':{'prev':null,'results':[]},'in':{'data':'$$this','prev':'$$this.lastLogDiff','results':{'$concatArrays':['$$value.results',[{'old_value':'$$value.data.detail.status','old_value_time':'$$value.data._date','diff':{'$subtract':['$$this.lastLogDiff','$$value.prev']}}]]}}}}}"));
        BasicDBObject $unwind = new BasicDBObject("$unwind", (Object)"$row.results");
        BasicDBObject project2 = new BasicDBObject("$project", (Object)BasicDBObject.parse((String)"{'_id':'$row.data.itemId','data':'$row.data','itemId':'$row.itemId','old_value':'$row.results.old_value','old_value_time':'$row.results.old_value_time','seconds':'$row.results.diff'}"));
        BasicDBObject group2 = new BasicDBObject("$group", (Object)BasicDBObject.parse((String)"{'_id': {'$concat': ['$old_value_time','_', '$old_value.category']}, 'total': {'$sum': '$seconds'}, 'logs': {'$addToSet': '$$ROOT.data.itemId'}}"));
        if (ItemLog.class.equals(clazz)) {
            BasicDBObject $fn = new BasicDBObject("$function", (Object)new BasicDBObject("args", Arrays.asList("$changes")).append("lang", (Object)"js").append("body", (Object)"function(jsonString) { return JSON.parse(jsonString) }"));
            ((BasicDBObject)field.get("$addFields")).append("actions", (Object)new BasicDBObject("$cond", (Object)new BasicDBObject("if", (Object)"$actions").append("then", (Object)"$actions").append("else", (Object)$fn)));
        }
        ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
        pipeline.add(field);
        pipeline.add(match);
        if (test > 0) {
            pipeline.add(group1);
        }
        if (test > 1) {
            pipeline.add(project1);
        }
        if (test > 2) {
            pipeline.add($unwind);
        }
        if (test > 3) {
            pipeline.add(project2);
        }
        if (test > 4) {
            pipeline.add(group2);
        }
        Cursor db = collection.aggregate(pipeline, ao);
        ArrayList<DBObject> dbos = new ArrayList<DBObject>();
        while (db.hasNext()) {
            dbos.add((DBObject)db.next());
        }
        db.close();
        LOGGER.debug(((Object)pipeline).toString());
        return dbos;
    }

    public void setBulkArchiveUserStoriesByParents(List parents, SessionBoard board, boolean archive) {
        Thread t = new Thread(() -> {
            ArrayList<ObjectId> parentIds = new ArrayList<ObjectId>();
            for (Object parent : parents) {
                parentIds.add(new ObjectId(((Item)parent).getId()));
            }
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in(parentIds));
            DBCursor dbCursorPrefix = this.mongoTemplate.getCollection("item").find(query.getQueryObject());
            if (dbCursorPrefix != null && dbCursorPrefix.size() > 0) {
                List usList = dbCursorPrefix.toArray();
                Update update = new Update();
                update.set("archive", (Object)archive);
                this.mongoTemplate.updateMulti(query, update, Item.class);
                HashSet itemIds = new HashSet();
                ArrayList logs = new ArrayList();
                ArrayList logMaps = new ArrayList();
                HashMap removedItems = new HashMap();
                for (DBObject us : usList) {
                    HashMap<String, Object> itm = new HashMap<String, Object>();
                    itm.put("id", String.valueOf(us.get("_id")));
                    itm.put("title", us.get("title"));
                    itm.put("jiraKey", us.get("jiraKey"));
                    itm.put("tfsId", us.get("tfsId"));
                    itm.put("kendisKey", us.get("kendisKey"));
                    removedItems.put((String)itm.get("id"), itm);
                }
                KendisUtils.createLogsForDelete(removedItems, (SessionBoard)board, logs, logMaps, itemIds);
                if (logMaps.size() > 0) {
                    this.itemLogRepository.save(logs);
                    this.itemLogMapRepository.save(logMaps);
                    this.releaseTrainService.syncWithBoards(board.getTenant(), board, itemIds);
                }
            }
        });
        t.start();
    }

    public void updateAlmErrorFlagBulk(List itemIds, boolean almErrorFlag) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in((Collection)itemIds));
        Update update = new Update();
        update.set("errorInAlmSync", (Object)almErrorFlag);
        this.mongoTemplate.updateMulti(query, update, Item.class);
    }

    public List<WorkSpaceAccessRole> findWorkspaceAccessRoles(User user, Query query) {
        ArrayList<ObjectId> workSpaceIds = new ArrayList<ObjectId>();
        if (query == null) {
            query = new Query();
            query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}), Criteria.where((String)"rowStatus").is((Object)0)}));
        }
        query.fields().include("_id");
        List workspaces = this.mongoTemplate.find(query, WorkSpace.class);
        for (WorkSpace rawitem : workspaces) {
            workSpaceIds.add(new ObjectId(rawitem.getId()));
        }
        Query query2 = new Query();
        Criteria crt = new Criteria().andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"group").in((Collection)user.getGroups())}), Criteria.where((String)"workSpace.$id").in(workSpaceIds)});
        query2.addCriteria((CriteriaDefinition)crt);
        List workspaceAccessRoles = this.mongoTemplate.find(query2, WorkSpaceAccessRole.class);
        return workspaceAccessRoles;
    }

    public List<WorkSpaceAccessRole> findWorkspaceAccessRoles(User user) {
        return this.findWorkspaceAccessRoles(user, null);
    }

    public List<BacklogItemVO> findBacklogItemsAlmIds(Collection ids, Collection<String> keys, String artId, String almId, boolean idsOnly, String tenant) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        if (PropertyValidator.isValid((Object)almId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"almAccountId").is((Object)almId));
        }
        if (ids != null) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(ids));
        }
        if (keys != null) {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"almItemId").in(keys), Criteria.where((String)"almKey").in(keys)}));
        }
        query.fields().include("id");
        query.fields().include("almAccountId");
        query.fields().include("almItemId");
        query.fields().include("almKey");
        query.fields().include("kendisKey");
        if (!idsOnly) {
            query.fields().include("artRelationMap");
            query.fields().include("parentRelationMap");
            query.fields().include("childRelationMap");
        }
        return this.mongoTemplate.find(query, BacklogItemVO.class, KendisUtils.dbName(BacklogItem.class));
    }

    private List<BacklogItemVO> findBacklogItemIds(Query query, Collection<String> keys, String tenant) {
        if (query == null) {
            query = new Query();
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.fields().include("id");
        query.fields().include("almAccountId");
        query.fields().include("almItemId");
        query.fields().include("almKey");
        return this.mongoTemplate.find(query, BacklogItemVO.class, KendisUtils.dbName(BacklogItem.class));
    }

    public void savePartialSyncFlag(String artId, String step, String value) {
        Update update = new Update();
        if (step == null) {
            update.set("syncFlag", null);
        } else {
            update.set("syncFlag", (Object)new /* Unavailable Anonymous Inner Class!! */);
        }
        Query query = new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)new ObjectId(artId)));
        this.mongoTemplate.updateFirst(query, update, WorkSpace.class);
    }

    public void savePartialBacklog(BacklogItem backlogItem) {
        ArrayList<Pair> queries = new ArrayList<Pair>();
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BacklogItem.class);
        Query query = new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)new ObjectId(backlogItem.getId())));
        Update update = new Update();
        queries.add(Pair.of((Object)query, (Object)update));
        update.set("almItemId", (Object)backlogItem.getAlmItemId());
        update.set("almKey", (Object)backlogItem.getAlmKey());
        update.set("url", (Object)backlogItem.getUrl());
        update.set("almAccountId", (Object)backlogItem.getAlmAccountId());
        if (bulkOps != null && queries != null && queries.size() > 0) {
            bulkOps.updateMulti(queries);
            bulkOps.execute();
        }
    }

    public void savePartialBacklog(Integer direction, Collection<String> artIds, Integer levelIndex, String type, Integer saveCount, Integer total, List<BacklogItemVO> backlogVOs, Collection<String> keys, ResyncParamsVO syncUtils, AlmAccount almAccount) throws Exception {
        boolean multiple = true;
        if (artIds == null) {
            artIds = new ArrayList<String>();
            if (syncUtils.releaseTrainId != null) {
                artIds.add((String)syncUtils.releaseTrainId);
            }
            multiple = false;
        }
        HashMap push = syncUtils.pushData(keys, artIds);
        Collection<Object> savedList = null;
        if (backlogVOs == null) {
            backlogVOs = this.findBacklogItemsAlmIds(null, keys, null, almAccount.getId(), false, almAccount.getTenant());
        }
        ArrayList<Pair> queries = null;
        BulkOperations bulkOps = null;
        if (saveCount != null) {
            queries = new ArrayList<Pair>();
            bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BacklogItem.class);
        }
        for (BacklogItemVO item : backlogVOs) {
            BacklogItem bItem = syncUtils.getBacklogItem(item.getAlmItemId());
            if (bItem == null) continue;
            String id = item.getId();
            Update update = null;
            if (queries != null) {
                Query query = new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)new ObjectId(id)));
                update = new Update();
                queries.add(Pair.of((Object)query, (Object)update));
                update.set("title", (Object)bItem.getTitle());
                update.set("storyPoints", (Object)bItem.getStoryPoints());
                update.set("fields.AlmSyncError", null);
                update.set("fields.AlmErrorMessage", null);
                if (bItem.getFields() != null) {
                    if (bItem.getFields().get("DueDate") != null) {
                        update.set("fields.DueDate", bItem.getFields().get("DueDate"));
                    }
                    if (bItem.getFields().get("StartDate") != null) {
                        update.set("fields.StartDate", bItem.getFields().get("StartDate"));
                    }
                    if (bItem.getFields().get("EndDate") != null) {
                        update.set("fields.EndDate", bItem.getFields().get("EndDate"));
                    }
                }
                if (bItem.getAlmFields() != null && syncUtils.fields != null) {
                    for (JiraField jiraField : syncUtils.fields) {
                        update.set("almFields." + jiraField.getJiraId(), bItem.getAlmFields().get(jiraField.getJiraId()));
                    }
                }
            }
            Map arts = item.getArtRelationMap();
            if (multiple && arts != null) {
                artIds = item.artIds != null ? item.artIds : arts.keySet();
            }
            for (String artId : artIds) {
                List oldPrnt = null;
                List oldChld = null;
                if (item.getParentRelationMap() != null) {
                    oldPrnt = (List)item.getParentRelationMap().get(artId);
                }
                if (item.getChildRelationMap() != null) {
                    oldChld = (List)item.getChildRelationMap().get(artId);
                }
                if (update != null) {
                    if (arts.get(artId) == null) {
                        update.set("artRelationMap." + artId, bItem.getArtRelationMap().get(artId));
                    }
                    if (!syncUtils.isWebhook) {
                        update.set("parentRelationMap." + artId, new ArrayList());
                        update.set("childRelationMap." + artId, new ArrayList());
                    } else {
                        if (oldPrnt == null) {
                            update.set("parentRelationMap." + artId, new ArrayList());
                        } else {
                            update.set("parentRelationMap." + artId, (Object)oldPrnt);
                        }
                        if (oldChld == null) {
                            update.set("childRelationMap." + artId, new ArrayList());
                        } else {
                            update.set("childRelationMap." + artId, (Object)oldChld);
                        }
                    }
                }
                if (oldPrnt != null) {
                    for (BaseItemLink map : oldPrnt) {
                        ((Map)syncUtils.backlogOldParent.get(artId)).put(id, String.valueOf(map.getBacklogItemId()));
                    }
                }
                if (oldChld == null) continue;
                for (BaseItemLink map : oldChld) {
                    String kendisId = String.valueOf(map.getBacklogItemId());
                    ((Map)syncUtils.backlogOldParent.get(artId)).put(kendisId, id);
                    if (direction == null || direction >= 0 || PropertyValidator.isValid((Object)syncUtils.filter) && PropertyValidator.isValid((Object)syncUtils.filter.getId())) continue;
                    ((Map)syncUtils.backlogParentId.get(artId)).put(kendisId + "_parent_up", id);
                }
            }
            syncUtils.backlogAlmIds.put(bItem.getAlmItemId(), id);
            syncUtils.backlogAlmIds.put(bItem.getAlmKey(), id);
            syncUtils.backlogAlmIds.put(id, bItem.getAlmItemId());
            syncUtils.backlogAlmIds.put(id + "_key", bItem.getAlmKey());
            syncUtils.backlog.remove(bItem.getId());
            syncUtils.backlog.put(id, bItem);
            bItem.setId(id);
            bItem.setIsNew(Boolean.valueOf(false));
        }
        if (saveCount == null) {
            return;
        }
        if (bulkOps != null && queries != null && queries.size() > 0) {
            bulkOps.updateMulti(queries);
            bulkOps.execute();
            savedList = syncUtils.backlog.values();
        }
        savedList = new ArrayList();
        Set ids = syncUtils.backlog.keySet();
        for (String id : ids) {
            BacklogItem bItem = (BacklogItem)syncUtils.backlog.get(id);
            if (Boolean.FALSE.equals(bItem.getIsNew())) continue;
            savedList.add(bItem);
        }
        if (savedList.size() > 0) {
            this.backlogItemRepository.save(savedList);
        }
        push.put("isJira", true);
        push.put("cid", syncUtils.cid);
        push.put("partialSyncing", "items");
        push.put("item_count_total", total);
        push.put("item_count_saved", saveCount);
        push.put("item_level", levelIndex);
        push.put("item_level_value", levelIndex + "");
        push.put("item_link_type", type);
        if (syncUtils.syncId != null) {
            this.releaseTrainService.pushResyncUpdates("ResyncProgress", syncUtils.syncId, (Map)push, true);
        }
    }

    public void bulkUpdateBacklogItems(List<BacklogItem> itemsToBeSaved) {
        if (!PropertyValidator.isValid(itemsToBeSaved)) {
            return;
        }
        ArrayList updateQueries = new ArrayList();
        ArrayList insertQueries = new ArrayList();
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BacklogItem.class);
        List itemsToSaveIds = itemsToBeSaved.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List itemsBeforeSave = this.backlogItemRepository.findByIdIn(new ArrayList(itemsToSaveIds));
        Set itemsBeforeSaveIds = itemsBeforeSave.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        Map<Boolean, List<BacklogItem>> partitionedItems = itemsToBeSaved.stream().collect(Collectors.partitioningBy(backlogItem -> itemsBeforeSaveIds.contains(backlogItem.getId())));
        List<BacklogItem> itemsToInsert = partitionedItems.get(false);
        List<BacklogItem> itemsToUpdate = partitionedItems.get(true);
        try {
            itemsToUpdate.forEach(backlogItem -> {
                String id = backlogItem.getId();
                Query query = new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)new ObjectId(id)));
                Update update = this.getUpdateForBacklogItem(backlogItem);
                updateQueries.add(Pair.of((Object)query, (Object)update));
            });
            if (bulkOps != null && updateQueries.size() > 0) {
                bulkOps.upsert(updateQueries);
                bulkOps.execute();
            }
            if (bulkOps != null && itemsToInsert.size() > 0) {
                bulkOps.insert(itemsToInsert);
                bulkOps.execute();
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void bulkUpdateBacklogItemsLinkIds(List<BacklogItem> itemsToUpdate) {
        if (!PropertyValidator.isValid(itemsToUpdate)) {
            return;
        }
        try {
            BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BacklogItem.class);
            ArrayList updateQueries = new ArrayList();
            itemsToUpdate.forEach(backlogItem -> {
                String id = backlogItem.getId();
                Query query = new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)new ObjectId(id)));
                Update update = new Update().set("dependencyLinkIds", (Object)backlogItem.getDependencyLinkIds());
                updateQueries.add(Pair.of((Object)query, (Object)update));
            });
            if (updateQueries.size() > 0) {
                bulkOps.upsert(updateQueries);
                bulkOps.execute();
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private Update getUpdateForBacklogItem(BacklogItem backlogItem) {
        Update update = new Update();
        update.setOnInsert("id", (Object)backlogItem.getId());
        if (backlogItem.getTitle() != null) {
            update.set("title", (Object)backlogItem.getTitle());
        } else {
            update.unset("title");
        }
        if (backlogItem.getType() != null) {
            update.set("type", (Object)backlogItem.getType());
        } else {
            update.unset("type");
        }
        if (backlogItem.getFieldsTemplate() != null) {
            update.set("fieldsTemplate", (Object)backlogItem.getFieldsTemplate());
        } else {
            update.unset("fieldsTemplate");
        }
        if (backlogItem.getDescription() != null) {
            update.set("description", (Object)backlogItem.getDescription());
        } else {
            update.unset("description");
        }
        if (backlogItem.getStatus() != null) {
            update.set("status", (Object)backlogItem.getStatus());
        } else {
            update.unset("status");
        }
        if (backlogItem.getBaseItemLinks() != null) {
            update.set("baseItemLinks", (Object)backlogItem.getBaseItemLinks());
        } else {
            update.unset("baseItemLinks");
        }
        if (backlogItem.getSequence() != null) {
            update.set("sequence", (Object)backlogItem.getSequence());
        } else {
            update.unset("sequence");
        }
        if (backlogItem.getKey() != null) {
            update.set("key", (Object)backlogItem.getKey());
        } else {
            update.unset("key");
        }
        if (backlogItem.getAlmKey() != null) {
            update.set("bvPlan", (Object)backlogItem.getBvPlan());
        } else {
            update.unset("bvPlan");
        }
        if (backlogItem.getAlmKey() != null) {
            update.set("bvActual", (Object)backlogItem.getBvActual());
        } else {
            update.unset("bvActual");
        }
        if (backlogItem.getStarred() != null) {
            update.set("starred", (Object)backlogItem.getStarred());
        } else {
            update.unset("starred");
        }
        if (backlogItem.getIsDefaultGroup() != null) {
            update.set("isDefaultGroup", (Object)backlogItem.getIsDefaultGroup());
        } else {
            update.unset("isDefaultGroup");
        }
        if (backlogItem.getNotifyWatchers() != null) {
            update.set("notifyWatchers", (Object)backlogItem.getNotifyWatchers());
        } else {
            update.unset("notifyWatchers");
        }
        if (backlogItem.getItemType() != null) {
            update.set("itemType", (Object)backlogItem.getItemType());
        } else {
            update.unset("itemType");
        }
        if (backlogItem.getParent() != null) {
            update.set("parent", (Object)backlogItem.getParent());
        } else {
            update.unset("parent");
        }
        if (backlogItem.getLinkedCardWeights() != null) {
            update.set("linkedCardWeights", (Object)backlogItem.getLinkedCardWeights());
        } else {
            update.unset("linkedCardWeights");
        }
        if (backlogItem.getCompletionCriteria() != null) {
            update.set("completionCriteria", (Object)backlogItem.getCompletionCriteria());
        } else {
            update.unset("completionCriteria");
        }
        if (backlogItem.getImageIcon() != null) {
            update.set("imageIcon", (Object)backlogItem.getImageIcon());
        } else {
            update.unset("imageIcon");
        }
        if (backlogItem.getHeaderColor() != null) {
            update.set("headerColor", (Object)backlogItem.getHeaderColor());
        } else {
            update.unset("headerColor");
        }
        if (backlogItem.getFetchedBy() != null) {
            update.set("fetchedBy", (Object)backlogItem.getFetchedBy());
        } else {
            update.unset("fetchedBy");
        }
        if (PropertyValidator.isValid((Object)backlogItem.getFields())) {
            backlogItem.getFields().forEach((k, v) -> update.set("fields." + k, v));
        }
        if (PropertyValidator.isValid((Object)backlogItem.getAlmFields())) {
            backlogItem.getAlmFields().forEach((k, v) -> update.set("almFields." + k, v));
        }
        if (backlogItem.getAlmAccountId() != null) {
            update.set("almAccountId", (Object)backlogItem.getAlmAccountId());
        } else {
            update.unset("almAccountId");
        }
        if (backlogItem.getAlmItemId() != null) {
            update.set("almItemId", (Object)backlogItem.getAlmItemId());
        } else {
            update.unset("almItemId");
        }
        if (backlogItem.getUrl() != null) {
            update.set("url", (Object)backlogItem.getUrl());
        } else {
            update.unset("url");
        }
        if (backlogItem.getAlmType() != null) {
            update.set("almType", (Object)backlogItem.getAlmType());
        } else {
            update.unset("almType");
        }
        if (backlogItem.getAlmKey() != null) {
            update.set("almKey", (Object)backlogItem.getAlmKey());
        } else {
            update.unset("almKey");
        }
        if (backlogItem.getFilterIds() != null) {
            update.set("filterIds", (Object)backlogItem.getFilterIds());
        } else {
            update.unset("filterIds");
        }
        if (backlogItem.getKendisKey() != null) {
            update.set("kendisKey", (Object)backlogItem.getKendisKey());
        } else {
            update.unset("kendisKey");
        }
        if (backlogItem.getStoryPoints() != null) {
            update.set("storyPoints", (Object)backlogItem.getStoryPoints());
        } else {
            update.unset("storyPoints");
        }
        if (backlogItem.getBacklogLevel() != null) {
            update.set("backlogLevel", (Object)backlogItem.getBacklogLevel());
        } else {
            update.unset("backlogLevel");
        }
        if (backlogItem.getOtherRequirements() != null) {
            update.set("otherRequirements", (Object)backlogItem.getOtherRequirements());
        } else {
            update.unset("otherRequirements");
        }
        if (backlogItem.getDirty() != null) {
            update.set("dirty", (Object)backlogItem.getDirty());
        } else {
            update.unset("dirty");
        }
        if (backlogItem.getArtRelationMap() != null) {
            update.set("artRelationMap", (Object)backlogItem.getArtRelationMap());
        } else {
            update.unset("artRelationMap");
        }
        if (backlogItem.getParentRelationMap() != null) {
            update.set("parentRelationMap", (Object)backlogItem.getParentRelationMap());
        } else {
            update.unset("parentRelationMap");
        }
        if (backlogItem.getChildRelationMap() != null) {
            update.set("childRelationMap", (Object)backlogItem.getChildRelationMap());
        } else {
            update.unset("childRelationMap");
        }
        if (backlogItem.getBoardRelations() != null) {
            update.set("boardRelations", (Object)backlogItem.getBoardRelations());
        } else {
            update.unset("boardRelations");
        }
        if (backlogItem.getBatchRelations() != null) {
            update.set("batchRelations", (Object)backlogItem.getBatchRelations());
        } else {
            update.unset("batchRelations");
        }
        if (backlogItem.getObjectiveRelations() != null) {
            update.set("objectiveRelations", (Object)backlogItem.getObjectiveRelations());
        } else {
            update.unset("objectiveRelations");
        }
        if (backlogItem.getKeyResultRelations() != null) {
            update.set("keyResultRelations", (Object)backlogItem.getKeyResultRelations());
        } else {
            update.unset("keyResultRelations");
        }
        if (backlogItem.getTeamContainerRelations() != null) {
            update.set("teamContainerRelations", (Object)backlogItem.getTeamContainerRelations());
        } else {
            update.unset("teamContainerRelations");
        }
        if (backlogItem.getSolutionRelations() != null) {
            update.set("solutionRelations", (Object)backlogItem.getSolutionRelations());
        } else {
            update.unset("solutionRelations");
        }
        if (backlogItem.getItemRelations() != null) {
            update.set("itemRelations", (Object)backlogItem.getItemRelations());
        } else {
            update.unset("itemRelations");
        }
        if (backlogItem.getAlmErrors() != null) {
            update.set("almErrors", (Object)backlogItem.getAlmErrors());
        } else {
            update.unset("almErrors");
        }
        if (backlogItem.getShowError() != null) {
            update.set("showError", (Object)backlogItem.getShowError());
        } else {
            update.unset("showError");
        }
        if (backlogItem.getRelations() != null) {
            update.set("relations", (Object)backlogItem.getRelations());
        } else {
            update.unset("relations");
        }
        return update;
    }

    public void savePartialParentChildInBacklog(ResyncParamsVO syncUtils, String tenant) {
        try {
            BacklogItem item;
            Collection<Object> ids;
            HashMap<String, String> relations = (HashMap<String, String>)syncUtils.backlogParentId.get(syncUtils.releaseTrainId);
            Map oldLinks = (Map)syncUtils.backlogOldParent.get(syncUtils.releaseTrainId);
            if (PropertyValidator.isValid((Object)oldLinks)) {
                if (relations == null) {
                    relations = new HashMap<String, String>();
                }
                HashSet<ObjectId> list = new HashSet<ObjectId>();
                ids = oldLinks.keySet();
                for (Object child : ids) {
                    String parent = (String)oldLinks.get(child);
                    if (!ObjectId.isValid((String)child)) continue;
                    String jiraId = (String)syncUtils.backlogAlmIds.get(child);
                    if (relations.get(child) != null || relations.get((String)child + "parent_up") != null || relations.get(jiraId) != null || relations.get(jiraId + "parent_up") != null) continue;
                    if (syncUtils.backlogAlmIds.get(child) == null) {
                        list.add(new ObjectId((String)child));
                        relations.put((String)child + "_kendis_parent_up", parent);
                    }
                    if (syncUtils.backlogAlmIds.get(parent) != null) continue;
                    list.add(new ObjectId(parent));
                    relations.put((String)child + "_kendis_parent_up", parent);
                }
                List vos = this.findBacklogItemsAlmIds(list, null, null, "", true, tenant);
                if (PropertyValidator.isValid((Collection)vos)) {
                    for (BacklogItemVO vo : vos) {
                        if (vo.getAlmItemId() != null || syncUtils.backlogAlmIds.get(vo.getId()) != null) continue;
                        syncUtils.backlogAlmIds.put(vo.getId(), vo.getId());
                    }
                }
            }
            if (relations == null) {
                return;
            }
            if (relations.isEmpty()) {
                return;
            }
            HashMap<String, Object> push = new HashMap<String, Object>();
            push.put("releaseTrainId", syncUtils.releaseTrainId);
            push.put("isJira", true);
            push.put("cid", syncUtils.cid);
            push.put("partialSyncing", "links");
            if (syncUtils.syncId != null) {
                this.releaseTrainService.pushResyncUpdates("ResyncProgress", syncUtils.syncId, push, true);
            }
            ids = new ArrayList();
            String cKey = "childRelationMap." + syncUtils.releaseTrainId;
            HashSet<String> cIds = new HashSet<String>();
            StringBuilder cCases = new StringBuilder();
            HashMap<String, BacklogItem> cMap = new HashMap<String, BacklogItem>();
            String pKey = "parentRelationMap." + syncUtils.releaseTrainId;
            HashSet<String> pIds = new HashSet<String>();
            StringBuilder pCases = new StringBuilder();
            HashMap<String, BacklogItem> pMap = new HashMap<String, BacklogItem>();
            Set childKeys = relations.keySet();
            for (Iterator childKey : childKeys) {
                boolean validRelation;
                String parentKey = (String)relations.get(childKey);
                String childKendisId = (String)syncUtils.backlogAlmIds.get(childKey);
                String parentKendisId = (String)syncUtils.backlogAlmIds.get(parentKey);
                boolean bl = validRelation = parentKendisId != null && childKendisId != null;
                if (!validRelation && parentKey != null && ((String)((Object)childKey)).indexOf("_parent_up") > -1) {
                    parentKendisId = parentKey;
                    childKendisId = ((String)((Object)childKey)).replace("_kendis_parent_up", "").replace("_parent_up", "");
                    boolean bl2 = validRelation = parentKendisId != null && childKendisId != null;
                }
                if (!validRelation) continue;
                if (!pMap.containsKey(childKendisId)) {
                    pMap.put(childKendisId, new BacklogItem());
                }
                if (!cMap.containsKey(parentKendisId)) {
                    cMap.put(parentKendisId, new BacklogItem());
                }
                ((BacklogItem)pMap.get(childKendisId)).linkToParent(syncUtils.releaseTrainId, parentKendisId).setTenant(tenant);
                ((BacklogItem)cMap.get(parentKendisId)).linkToChild(syncUtils.releaseTrainId, childKendisId).setTenant(tenant);
                pIds.add(parentKendisId);
                cIds.add(childKendisId);
                if (oldLinks == null || !parentKendisId.equals(oldLinks.get(childKendisId))) continue;
                oldLinks.remove(childKendisId);
            }
            Gson gson = new GsonBuilder().registerTypeAdapter(ObjectId.class, (Object)new /* Unavailable Anonymous Inner Class!! */).create();
            for (String id : cIds) {
                item = (BacklogItem)pMap.get(id);
                if (item == null || !item.getParentRelationMap().containsKey(syncUtils.releaseTrainId)) continue;
                ids.add(new ObjectId(id));
                if (pCases.length() > 0) {
                    pCases.append(",");
                }
                pCases.append("{case:{$eq:['$_id',ObjectId('").append(id).append("')]},then:").append("{$setUnion:[").append(gson.toJson(item.getParentRelationMap().get(syncUtils.releaseTrainId))).append(",{'$ifNull' : ['$").append(pKey).append("',[]]}]}}");
            }
            for (String id : pIds) {
                item = (BacklogItem)cMap.get(id);
                if (item == null || !item.getChildRelationMap().containsKey(syncUtils.releaseTrainId)) continue;
                ids.add(new ObjectId(id));
                if (cCases.length() > 0) {
                    cCases.append(",");
                }
                cCases.append("{case:{$eq:['$_id',ObjectId('").append(id).append("')]},then:").append("{$setUnion:[").append(gson.toJson(item.getChildRelationMap().get(syncUtils.releaseTrainId))).append(",{'$ifNull' : ['$").append(cKey).append("',[]]}]}}");
            }
            if (cCases.length() > 0 || pCases.length() > 0) {
                StringBuilder json = new StringBuilder("{");
                if (cCases.length() > 0) {
                    json.append("'").append(cKey).append("':{$switch:{branches:[").append(cCases.toString()).append("],default:'$").append(cKey).append("' } }");
                }
                if (json.length() > 1) {
                    json.append(",");
                }
                if (pCases.length() > 0) {
                    json.append("'").append(pKey).append("':{$switch:{branches:[").append(pCases.toString()).append("],default:'$").append(pKey).append("' } }");
                }
                json.append(" }");
                DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
                AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
                BasicDBObject in = new BasicDBObject("$in", ids);
                BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)in).append("almAccountId", (Object)syncUtils.almConfigurations.getAlmAccount().getId()));
                BasicDBObject addFields = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)json.toString()));
                BasicDBObject merge = new BasicDBObject("$merge", (Object)BasicDBObject.parse((String)"{into:'backlogItem',whenMatched:'merge',whenNotMatched:'discard'}"));
                List<DBObject> pipeline = Arrays.asList(match, addFields, merge);
                Cursor db = collection.aggregate(pipeline, ao);
                db.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("savePartialParentChildInBacklog for art : " + syncUtils.releaseTrainId);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void removePartialParentChildInBacklog(ResyncParamsVO syncUtils) {
        try {
            String artId = syncUtils.releaseTrainId;
            Map relations = (Map)syncUtils.backlogOldParent.get(artId);
            HashMap saved = (HashMap)syncUtils.backlogParentId.get(artId);
            if (relations == null) {
                return;
            }
            if (saved == null) {
                saved = new HashMap();
            }
            if (relations.size() > 0) {
                ArrayList<Pair> queries = new ArrayList<Pair>();
                BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BacklogItem.class);
                Set ids = relations.keySet();
                String pKey = "parentRelationMap." + artId;
                String cKey = "childRelationMap." + artId;
                for (String id : ids) {
                    ObjectId oid = new ObjectId(id);
                    ObjectId pid = new ObjectId((String)relations.get(id));
                    String c = (String)syncUtils.backlogAlmIds.get(id);
                    String p = (String)syncUtils.backlogAlmIds.get(relations.get(id));
                    if (c != null && p != null && p.equals(saved.get(c))) continue;
                    c = (String)syncUtils.backlogAlmIds.get(id + "_key");
                    p = (String)syncUtils.backlogAlmIds.get((String)relations.get(id) + "_key");
                    if (c != null && p != null && p.equals(saved.get(c))) continue;
                    queries.add(Pair.of((Object)new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)oid).and(pKey + ".backlogItemId").is((Object)pid)), (Object)new Update().pull(pKey, (Object)BasicDBObject.parse((String)("{'backlogItemId' : ObjectId('" + pid + "')}}")))));
                    queries.add(Pair.of((Object)new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)pid).and(cKey + ".backlogItemId").is((Object)oid)), (Object)new Update().pull(cKey, (Object)BasicDBObject.parse((String)("{'backlogItemId' : ObjectId('" + id + "')}}")))));
                }
                if (queries.size() > 0) {
                    bulkOps.updateMulti(queries);
                    bulkOps.execute();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("removePartialParentChildInBacklog for art : " + syncUtils.releaseTrainId);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    public void savePartialSatusInBacklog(HashMap<String, Object> push, ResyncParamsVO syncUtils, Map<String, Status> statusMap) {
        if (push == null) {
            push = syncUtils.pushData(null, null);
            push.put("partialSyncing", "status");
        }
        push.put("isJira", true);
        push.put("cid", syncUtils.cid);
        if (syncUtils.syncId != null) {
            KendisUtils.pushProgressUpdates((String)"ResyncProgress", (String)syncUtils.syncId, (Object)push, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        }
        StringBuilder cases = new StringBuilder();
        Set keys = syncUtils.backlogSatuses.keySet();
        ArrayList<ObjectId> oids = new ArrayList<ObjectId>();
        for (String key : keys) {
            Set issueIds;
            if (statusMap == null || statusMap.get(key) == null || (issueIds = (Set)syncUtils.backlogSatuses.get(key)) == null) continue;
            for (String id : issueIds) {
                if (!syncUtils.backlogAlmIds.containsKey(id) || syncUtils.backlogAlmIds.get(id) == null) continue;
                oids.add(new ObjectId((String)syncUtils.backlogAlmIds.get(id)));
                if (cases.length() > 0) {
                    cases.append(",");
                }
                cases.append("{case:{$eq:['$_id',ObjectId('").append((String)syncUtils.backlogAlmIds.get(id)).append("')]},then:ObjectId('").append(statusMap.get(key).getId()).append("')}");
            }
        }
        if (cases.length() > 0) {
            StringBuilder json = new StringBuilder("{");
            json.append("'status.$ref':'status',");
            json.append("'status.$id':{$switch:{branches:[").append(cases.toString()).append("],default:'$status.$id' } }");
            if (syncUtils.filter != null && syncUtils.filter.getId() != null) {
                json.append(",filterIds:{$setUnion:['$filterIds',['").append(syncUtils.filter.getId()).append("']]}");
            }
            json.append(" }");
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
            BasicDBObject in = new BasicDBObject("$in", oids);
            BasicDBObject match = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)in));
            BasicDBObject addFields = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)json.toString()));
            BasicDBObject merge = new BasicDBObject("$merge", (Object)BasicDBObject.parse((String)"{into:'backlogItem',whenMatched:'merge',whenNotMatched:'discard'}"));
            List<DBObject> pipeline = Arrays.asList(match, addFields, merge);
            Cursor db = collection.aggregate(pipeline, ao);
            db.close();
        }
    }

    public void savePartialPiLinksInBacklog(ResyncParamsVO syncUtils, Collection<String> almItemIds, Map<String, BacklogItem> backlog) {
        if (syncUtils != null && syncUtils.syncId != null) {
            HashMap<String, Object> push = new HashMap<String, Object>();
            push.put("releaseTrainId", syncUtils.releaseTrainId);
            push.put("isJira", true);
            push.put("cid", syncUtils.cid);
            push.put("partialSyncing", "piLinks");
            this.releaseTrainService.pushResyncUpdates("ResyncProgress", syncUtils.syncId, push, true);
        }
        StringBuilder tcCases = new StringBuilder();
        StringBuilder bCases = new StringBuilder();
        StringBuilder sCases = new StringBuilder();
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        Gson gson = new Gson();
        for (String key : almItemIds) {
            BacklogItem item = backlog.get(key);
            if (item == null || item.getId() == null || !ObjectId.isValid((String)item.getId())) continue;
            ids.add(new ObjectId(item.getId()));
            if (bCases.length() > 0) {
                bCases.append(",");
            }
            bCases.append("{case:{$eq:['$_id',ObjectId('").append(item.getId()).append("')]},then:").append(gson.toJson((Object)item.getBoardRelations())).append("}");
            if (tcCases.length() > 0) {
                tcCases.append(",");
            }
            tcCases.append("{case:{$eq:['$_id',ObjectId('").append(item.getId()).append("')]},then:").append(gson.toJson((Object)item.getTeamContainerRelations())).append("}");
            if (sCases.length() > 0) {
                sCases.append(",");
            }
            sCases.append("{case:{$eq:['$_id',ObjectId('").append(item.getId()).append("')]},then:").append(gson.toJson((Object)item.getSolutionRelations())).append("}");
        }
        if (bCases.length() + tcCases.length() + sCases.length() > 0) {
            StringBuilder json = new StringBuilder("{");
            if (bCases.length() > 0) {
                json.append("'boardRelations':{$switch:{branches:[").append(bCases.toString()).append("],default:'$boardRelations' } }");
            }
            if (json.length() > 1) {
                json.append(",");
            }
            if (tcCases.length() > 0) {
                json.append("'teamContainerRelations':{$switch:{branches:[").append(tcCases.toString()).append("],default:'$teamContainerRelations' } }");
            }
            if (json.length() > 1) {
                json.append(",");
            }
            if (sCases.length() > 0) {
                json.append("'solutionRelations':{$switch:{branches:[").append(sCases.toString()).append("],default:'$solutionRelations' } }");
            }
            json.append(" }");
            DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(BacklogItem.class));
            AggregationOptions ao = AggregationOptions.builder().allowDiskUse(Boolean.TRUE).build();
            BasicDBObject in = new BasicDBObject("$in", ids);
            in = new BasicDBObject("_id", (Object)in);
            if (syncUtils != null && syncUtils.almConfigurations != null) {
                in.append("almAccountId", (Object)syncUtils.almConfigurations.getAlmAccount().getId());
            }
            BasicDBObject match = new BasicDBObject("$match", (Object)in);
            BasicDBObject addFields = new BasicDBObject("$addFields", (Object)BasicDBObject.parse((String)json.toString()));
            BasicDBObject merge = new BasicDBObject("$merge", (Object)BasicDBObject.parse((String)"{into:'backlogItem',whenMatched:'merge',whenNotMatched:'discard'}"));
            List<DBObject> pipeline = Arrays.asList(match, addFields, merge);
            Cursor db = collection.aggregate(pipeline, ao);
            db.close();
        }
    }

    public void onJiraRemoveIssue(Boolean archive, String cid, Set<String> backLogItemJiraIds, Set<String> specificParents, AlmAccount alm) throws Exception {
        List backlogVOs;
        ResyncParamsVO syncUtils = new ResyncParamsVO();
        syncUtils.almConfigurations = new AlmConfigurations(alm);
        syncUtils.syncId = null;
        syncUtils.cid = cid;
        syncUtils.releaseTrainId = "isJira";
        syncUtils.backlogAlmIds = new HashMap();
        syncUtils.backlogParentId = new HashMap();
        syncUtils.backlogOldParent = new HashMap();
        HashSet<String> artIds = new HashSet<String>();
        HashSet<String> itemKeys = new HashSet<String>();
        ArrayList parenIds = new ArrayList();
        HashMap map = new HashMap();
        HashMap<String, String> idByJiraId = new HashMap<String, String>();
        ArrayList<Pair> queries = null;
        BulkOperations bulkOps = null;
        if (specificParents == null) {
            queries = new ArrayList<Pair>();
            bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, BacklogItem.class);
        } else if (specificParents != null) {
            backlogVOs = this.findBacklogItemsAlmIds(null, specificParents, null, alm.getId(), true, alm.getTenant());
            for (BacklogItemVO vo : backlogVOs) {
                idByJiraId.put(vo.getId(), vo.getAlmItemId());
            }
        }
        backlogVOs = this.findBacklogItemsAlmIds(null, backLogItemJiraIds, null, alm.getId(), false, alm.getTenant());
        for (BacklogItemVO vo : backlogVOs) {
            Map oldPrnt;
            Map arts;
            String id = vo.getId();
            String almKey = vo.getAlmKey();
            itemKeys.add(almKey);
            Query query = null;
            if (queries != null) {
                query = new Query().addCriteria((CriteriaDefinition)new Criteria("id").is((Object)new ObjectId(id)));
            }
            if ((arts = vo.getArtRelationMap()) != null) {
                for (String artId : arts.keySet()) {
                    if (syncUtils.backlogOldParent.get(artId) == null) {
                        syncUtils.backlogOldParent.put(artId, new HashMap());
                    }
                    artIds.add(artId);
                    if (query == null) continue;
                    Update update = new Update();
                    queries.add(Pair.of((Object)query, (Object)update));
                    update.set("artRelationMap." + artId + ".rowStatus", (Object)(archive != false ? 1 : 0));
                    if (!archive.booleanValue()) continue;
                    update.set("archive", (Object)archive);
                }
            }
            if ((oldPrnt = vo.getParentRelationMap()) == null) continue;
            Set keys = oldPrnt.keySet();
            for (String artId : keys) {
                List links = (List)oldPrnt.get(artId);
                for (BaseItemLink link : links) {
                    String parentId = String.valueOf(link.getBacklogItemId());
                    if (specificParents == null) {
                        ((Map)syncUtils.backlogOldParent.get(artId)).put(id, parentId);
                        continue;
                    }
                    if (idByJiraId.get(parentId) == null) continue;
                    ((Map)syncUtils.backlogOldParent.get(artId)).put(id, parentId);
                }
            }
        }
        HashMap responseMap = syncUtils.pushData(itemKeys, artIds);
        Object parents = null;
        if (specificParents == null) {
            responseMap.put("partialSyncing", "remove");
        } else if (specificParents != null) {
            responseMap.put("partialSyncing", "unlinks");
        }
        Iterator iterator = artIds.iterator();
        while (iterator.hasNext()) {
            String artId;
            syncUtils.releaseTrainId = artId = (String)iterator.next();
            this.removePartialParentChildInBacklog(syncUtils);
        }
        if (bulkOps != null && queries != null && queries.size() > 0) {
            bulkOps.updateMulti(queries);
            bulkOps.execute();
        }
        responseMap.put("isJira", true);
        responseMap.put("cid", syncUtils.cid);
    }

    public List<State> findBySequence(int sequence) {
        LinkedList<State> states = new LinkedList<State>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("sequence", (Object)sequence).append("archive", (Object)false));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(State.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor cursor = collection.aggregate(pipeline, aggregationOptions);){
            while (cursor.hasNext()) {
                State state = new State();
                state.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)cursor.next()), (String[])new String[0]));
                states.add(state);
            }
        }
        return states;
    }

    public List<ItemSyncMapper> findItemSyncMapperBySessionBoard(SessionBoard sessionBoard, String tenant) {
        if (!PropertyValidator.isValid((Object)sessionBoard)) {
            return Collections.emptyList();
        }
        LinkedList<ItemSyncMapper> itemSyncMappers = new LinkedList<ItemSyncMapper>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("sessionBoard.$id", (Object)new ObjectId(sessionBoard.getId())).append("tenant", (Object)tenant).append("archive", (Object)false));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("container", (Object)1).append("team", (Object)1).append("tfsSprint.iterationPath", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(ItemSyncMapper.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor cursor = collection.aggregate(pipeline, aggregationOptions);){
            while (cursor.hasNext()) {
                BasicDBObject mapperObj = (BasicDBObject)cursor.next();
                ItemSyncMapper mapper = new ItemSyncMapper();
                mapper.setId(DBUtils.getIdFromDBObject((BasicDBObject)mapperObj, (String[])new String[0]));
                if (PropertyValidator.isValid((Object)mapperObj.get("team"))) {
                    DBRef teamRef = (DBRef)mapperObj.get("team");
                    mapper.setTeam(new Team(teamRef.getId().toString()));
                }
                if (PropertyValidator.isValid((Object)mapperObj.get("container"))) {
                    DBRef containerRef = (DBRef)mapperObj.get("container");
                    mapper.setContainer(new Container(containerRef.getId().toString()));
                }
                if (PropertyValidator.isValid((Object)mapperObj.get("tfsSprint"))) {
                    BasicDBObject tfsSprintObj = (BasicDBObject)mapperObj.get("tfsSprint");
                    Sprint tfsSprint = new Sprint();
                    tfsSprint.setIterationPath(tfsSprintObj.get("iterationPath").toString());
                    mapper.setTfsSprint(tfsSprint);
                }
                itemSyncMappers.add(mapper);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            throw new RuntimeException(e);
        }
        return itemSyncMappers;
    }

    public List<BasicDBObject> findByTenantAndUserTypeNotAndArchiveFalseAndRowStatus(String tenant, String userType) {
        LinkedList<BasicDBObject> users = new LinkedList<BasicDBObject>();
        BasicDBObject matchConditions = new BasicDBObject().append("tenant", (Object)tenant);
        matchConditions.append("archive", (Object)Boolean.FALSE);
        matchConditions.append("rowStatus", (Object)0);
        matchConditions.append("userType", (Object)BasicDBObject.parse((String)("{\"$ne\":\"" + userType + "\"}")));
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)matchConditions);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("email", (Object)1).append("fullName", (Object)1).append("userName", (Object)1).append("firstName", (Object)1).append("lastName", (Object)1).append("picturePath", (Object)1).append("backgroundColor", (Object)1).append("userType", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(User.class));
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor cursor = collection.aggregate(pipeLine, options);){
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                dbObject.put((Object)"id", (Object)String.valueOf(dbObject.get("_id")));
                dbObject.removeField("_id");
                users.add(dbObject);
            }
        }
        return users;
    }

    public List<BasicDBObject> findByUserCompanies_Company_Id(String companyId) {
        if (!PropertyValidator.isValid((Object)companyId)) {
            return Collections.emptyList();
        }
        LinkedList<BasicDBObject> users = new LinkedList<BasicDBObject>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("userCompanies.company.$id", (Object)new ObjectId(companyId)));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("email", (Object)1).append("fullName", (Object)1).append("userName", (Object)1).append("firstName", (Object)1).append("lastName", (Object)1).append("picturePath", (Object)1).append("backgroundColor", (Object)1).append("userType", (Object)1));
        List<DBObject> pipeLine = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(User.class));
        AggregationOptions options = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor cursor = collection.aggregate(pipeLine, options);){
            while (cursor.hasNext()) {
                BasicDBObject dbObject = (BasicDBObject)cursor.next();
                dbObject.put((Object)"id", (Object)String.valueOf(dbObject.get("_id")));
                dbObject.removeField("_id");
                users.add(dbObject);
            }
        }
        return users;
    }

    public boolean isBoardLinked(ObjectId riskRegisterId) throws Exception {
        if (!PropertyValidator.isValid((Object)riskRegisterId)) {
            return false;
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("riskRegister.$id", (Object)riskRegisterId).append("archive", (Object)false).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        BasicDBObject matchStage2 = new BasicDBObject("$match", (Object)new BasicDBObject().append("riskRegisters.$id", (Object)riskRegisterId).append("archive", (Object)false).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        BasicDBObject lookupStage = DBUtils.createLookup((String)"sessionBoard", (String)"_id", (String)"session.$id", (String)"sessionBoards");
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject("sessionBoards", (Object)new BasicDBObject("$size", (Object)"$sessionBoards")));
        BasicDBObject matchStageForSize = new BasicDBObject("$match", (Object)new BasicDBObject("sessionBoards", (Object)new BasicDBObject("$gt", (Object)0)));
        BasicDBObject limitStage = new BasicDBObject("$limit", (Object)1);
        BasicDBObject solutionBoardLookup = DBUtils.createLookup((String)"solutionBoard", (String)"solutionBoard.$id", (String)"_id", (String)"solutionBoard");
        BasicDBObject collectionLookup = DBUtils.createLookup((String)"workSpace", (String)"workSpace.$id", (String)"_id", (String)"workSpace");
        List<DBObject> pipeline = Arrays.asList(matchStage, lookupStage, projectionStage, matchStageForSize, limitStage);
        List<DBObject> pipeline2 = Arrays.asList(matchStage2, solutionBoardLookup, limitStage);
        List<DBObject> pipeline3 = Arrays.asList(matchStage2, collectionLookup, limitStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        DBCollection collection2 = this.mongoTemplate.getCollection(KendisUtils.dbName(SolutionBoard.class));
        DBCollection collection3 = this.mongoTemplate.getCollection(KendisUtils.dbName(WorkSpace.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try {
            Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);
            if (dbCursor.hasNext()) {
                return true;
            }
            dbCursor = collection2.aggregate(pipeline2, aggregationOptions);
            if (dbCursor.hasNext()) {
                return true;
            }
            dbCursor = collection3.aggregate(pipeline3, aggregationOptions);
            if (dbCursor.hasNext()) {
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            throw new Exception(ex);
        }
        return false;
    }

    public List<Risk> findRiskByLinkedSessionId(String sessionId, String riskRegisterId) {
        try {
            if (!PropertyValidator.isValid((Object)sessionId)) {
                return new LinkedList<Risk>();
            }
            Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"riskRegister.$id").is((Object)new ObjectId(riskRegisterId)), Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"linkedPiBoards").size(0), Criteria.where((String)"linkedPiBoards").exists(false), Criteria.where((String)"linkedPiBoards.id").is((Object)sessionId)})}));
            return this.mongoTemplate.find(query, Risk.class);
        }
        catch (Exception ex) {
            LOGGER.error("Error finding risks by linked session ID: " + StringUtils.getTraceString((Throwable)ex));
            return new LinkedList<Risk>();
        }
    }

    public List<Risk> findRiskByLinkedSolutionBoardId(String solutionBoardId, String riskRegisterId) {
        try {
            if (!PropertyValidator.isValid((Object)solutionBoardId)) {
                return new LinkedList<Risk>();
            }
            Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"riskRegister.$id").is((Object)new ObjectId(riskRegisterId)), Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"linkedSolutionBoards").size(0), Criteria.where((String)"linkedSolutionBoards").exists(false), Criteria.where((String)"linkedSolutionBoards.id").is((Object)solutionBoardId)})}));
            return this.mongoTemplate.find(query, Risk.class);
        }
        catch (Exception ex) {
            LOGGER.error("Error finding risks by linked solution board ID: " + StringUtils.getTraceString((Throwable)ex));
            return new LinkedList<Risk>();
        }
    }

    public List<Risk> findRiskByLinkedOrgCollection(String workSpaceId, String riskRegisterId) {
        try {
            if (!PropertyValidator.isValid((Object)workSpaceId)) {
                return new LinkedList<Risk>();
            }
            Query query = new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"riskRegister.$id").is((Object)new ObjectId(riskRegisterId)), Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"linkedOrgCollections").size(0), Criteria.where((String)"linkedOrgCollections").exists(false), Criteria.where((String)"linkedOrgCollections.id").is((Object)workSpaceId)})}));
            return this.mongoTemplate.find(query, Risk.class);
        }
        catch (Exception ex) {
            LOGGER.error("Error finding risks by linked collection ID: " + StringUtils.getTraceString((Throwable)ex));
            return new LinkedList<Risk>();
        }
    }

    public List<Session> findSessionsByRiskRegisterId(String riskRegisterId) {
        if (!PropertyValidator.isValid((Object)riskRegisterId) && !ObjectId.isValid((String)riskRegisterId)) {
            LOGGER.debug("Invalid or undefined riskRegisterId: {}", (Object)riskRegisterId);
            return new LinkedList<Session>();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegister.$id").is((Object)new ObjectId(riskRegisterId)));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("almEnabled");
        query.fields().include("parentItem");
        query.fields().include("childItem");
        query.fields().include("jiraFlaggedFieldEnabled");
        query.fields().include("kendisFlaggedFieldEnabled");
        query.fields().include("activeSessionBoard");
        return this.mongoTemplate.find(query, Session.class);
    }

    public List<SolutionBoard> findSolutionBoardsByRiskRegisterId(String riskRegisterId) {
        if (!PropertyValidator.isValid((Object)riskRegisterId)) {
            return new LinkedList<SolutionBoard>();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters.$id").in(new Object[]{new ObjectId(riskRegisterId)}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        query.fields().include("_id");
        query.fields().include("title");
        return this.mongoTemplate.find(query, SolutionBoard.class);
    }

    public List<WorkSpace> findOrgCollectionByRiskRegisterId(String riskRegisterId) {
        if (!PropertyValidator.isValid((Object)riskRegisterId)) {
            return new LinkedList<WorkSpace>();
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters.$id").in(new Object[]{new ObjectId(riskRegisterId)}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        query.fields().include("_id");
        query.fields().include("title");
        return this.mongoTemplate.find(query, WorkSpace.class);
    }

    public List<Session> findSessionsByRiskRegisterIdIn(List<ObjectId> riskRegisterId) {
        LinkedList<Session> sessions = new LinkedList<Session>();
        if (!PropertyValidator.isValid(riskRegisterId)) {
            return sessions;
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("riskRegister.$id", (Object)new BasicDBObject("$in", riskRegisterId)).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()).append("archive", (Object)false));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("title", (Object)1).append("almEnabled", (Object)1).append("parentItem", (Object)1).append("childItem", (Object)1).append("jiraFlaggedFieldEnabled", (Object)1).append("kendisFlaggedFieldEnabled", (Object)1).append("activeSessionBoard", (Object)1).append("riskRegister", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                Session session = new Session((BasicDBObject)object);
                sessions.add(session);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return sessions;
    }

    public List<SolutionBoard> fetchSolutionBoardListWithIdTitle() {
        Query query = new Query();
        query.fields().include("_id");
        query.fields().include("title");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        List solutionBoards = this.mongoTemplate.find(query, SolutionBoard.class);
        return solutionBoards;
    }

    public List<String> fetchSolutionBoardIdsWithLinkedRiskRegisters() {
        Query query = new Query();
        query.fields().include("_id");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters").exists(true).ne(null).not().size(0));
        List solutionBoards = this.mongoTemplate.find(query, SolutionBoard.class);
        return solutionBoards.stream().map(BaseEntity::getId).collect(Collectors.toList());
    }

    public List<WorkSpace> fetchCollectionListWithIdTitle() {
        Query query = new Query();
        query.fields().include("_id");
        query.fields().include("title");
        query.fields().include("type");
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        List collections = this.mongoTemplate.find(query, WorkSpace.class);
        return collections;
    }

    public List<SolutionBoard> fetchSolutionBoardWithLinkedRiskRegisters() {
        Query solutionQuery = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        solutionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        solutionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        solutionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters").exists(true).ne(null).not().size(0));
        solutionQuery.fields().include("_id");
        solutionQuery.fields().include("title");
        solutionQuery.fields().include("riskRegisters");
        List solutionBoards = this.mongoTemplate.find(solutionQuery, SolutionBoard.class);
        return solutionBoards;
    }

    public List<WorkSpace> fetchCollectionListWithLinkedRiskRegisters() {
        Query collectionQuery = new Query();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        collectionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        collectionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        collectionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters").exists(true).ne(null).not().size(0));
        collectionQuery.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}));
        collectionQuery.fields().include("_id");
        collectionQuery.fields().include("title");
        collectionQuery.fields().include("riskRegisters");
        collectionQuery.fields().include("type");
        List collections = this.mongoTemplate.find(collectionQuery, WorkSpace.class);
        return collections;
    }

    public boolean isRiskRegisterLinkedToAnyBoard(String riskRegisterId) {
        try {
            if (!PropertyValidator.isValid((Object)riskRegisterId) || !ObjectId.isValid((String)riskRegisterId)) {
                return false;
            }
            ObjectId riskRegisterObjectId = new ObjectId(riskRegisterId);
            String tenant = UserContextUtil.getUserContext().getLoggedInUser().getTenant();
            Query sessionQuery = new Query();
            sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegister.$id").is((Object)riskRegisterObjectId));
            sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            sessionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            long sessionCount = this.mongoTemplate.count(sessionQuery, Session.class);
            if (sessionCount > 0L) {
                return true;
            }
            Query solutionBoardQuery = new Query();
            solutionBoardQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters.$id").is((Object)riskRegisterObjectId));
            solutionBoardQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            solutionBoardQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            long solutionBoardCount = this.mongoTemplate.count(solutionBoardQuery, SolutionBoard.class);
            if (solutionBoardCount > 0L) {
                return true;
            }
            Query collectionQuery = new Query();
            collectionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"riskRegisters.$id").is((Object)riskRegisterObjectId));
            collectionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            collectionQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
            collectionQuery.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"isModule").is(null), Criteria.where((String)"isModule").is((Object)false)}));
            long collectionCount = this.mongoTemplate.count(collectionQuery, WorkSpace.class);
            return collectionCount > 0L;
        }
        catch (Exception ex) {
            LOGGER.error("Error checking if risk register is linked to any board: " + StringUtils.getTraceString((Throwable)ex));
            return true;
        }
    }

    public Session findSessionById(String id) {
        if (!PropertyValidator.isValid((Object)id)) {
            return null;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
        query.fields().include("_id");
        query.fields().include("activeSessionBoard");
        return (Session)this.mongoTemplate.findOne(query, Session.class);
    }

    public void updateRiskRegisterForSessions(List<ObjectId> sessionIds, RiskRegister riskRegister) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sessionIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        Update update = new Update();
        update.set("riskRegister", (Object)riskRegister);
        this.mongoTemplate.updateMulti(query, update, Session.class);
    }

    public void updateRiskRegisterForSolutionBoards(List<ObjectId> solBoardIds, RiskRegister riskRegister) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(solBoardIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        DBRef riskRegisterRef = new DBRef("riskRegister", (Object)riskRegister.getId());
        Update update = new Update().push("riskRegisters", (Object)riskRegisterRef);
        this.mongoTemplate.updateMulti(query, update, SolutionBoard.class);
    }

    public void updateRiskRegisterForCollections(List<ObjectId> orgIds, RiskRegister riskRegister) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(orgIds));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        DBRef riskRegisterRef = new DBRef("riskRegister", (Object)riskRegister.getId());
        Update update = new Update().push("riskRegisters", (Object)riskRegisterRef);
        this.mongoTemplate.updateMulti(query, update, WorkSpace.class);
    }

    public List<ItemSyncMapper> findBySessionBoardAndTenantAndArchive(String boardId, String tenant, boolean archive) {
        if (!PropertyValidator.isValid((Object)boardId) || !PropertyValidator.isValid((Object)tenant)) {
            return new LinkedList<ItemSyncMapper>();
        }
        if (!ObjectId.isValid((String)boardId)) {
            return new LinkedList<ItemSyncMapper>();
        }
        LinkedList<ItemSyncMapper> syncMappers = new LinkedList<ItemSyncMapper>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("sessionBoard.$id", (Object)new ObjectId(boardId)).append("tenant", (Object)tenant).append("archive", (Object)archive).append("sprint", (Object)new BasicDBObject("$exists", (Object)true)));
        BasicDBObject sprintLookup = DBUtils.createLookup((String)"sprint", (String)"sprint.$id", (String)"_id", (String)"sprint");
        BasicDBObject unwindSprint = DBUtils.createUnWind((String)"$sprint");
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("sprint._id", (Object)1).append("sprint.jiraId", (Object)1).append("team", (Object)1).append("container", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, sprintLookup, unwindSprint, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(ItemSyncMapper.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                BasicDBObject object = (BasicDBObject)dbCursor.next();
                ItemSyncMapper syncMapper = new ItemSyncMapper();
                syncMapper.setId(DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]));
                if (PropertyValidator.isValid((Object)object.get("sprint"))) {
                    BasicDBObject sprintObj = (BasicDBObject)object.get("sprint");
                    Sprint sprint = new Sprint();
                    sprint.setId(DBUtils.getIdFromDBObject((BasicDBObject)sprintObj, (String[])new String[0]));
                    sprint.setJiraId(sprintObj.getString("jiraId"));
                    syncMapper.setSprint(sprint);
                }
                if (PropertyValidator.isValid((Object)object.get("team"))) {
                    Team team = new Team();
                    DBRef teamRef = (DBRef)object.get("team");
                    team.setId(teamRef.getId().toString());
                    syncMapper.setTeam(team);
                }
                if (PropertyValidator.isValid((Object)object.get("container"))) {
                    Container container = new Container();
                    DBRef containerRef = (DBRef)object.get("container");
                    container.setId(containerRef.getId().toString());
                    syncMapper.setContainer(container);
                }
                syncMappers.add(syncMapper);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
        return syncMappers;
    }

    public void parseSyncMapperBySprintId(ResyncParamsVO syncUtils) {
        try {
            if (syncUtils.syncMappersBySprintId == null) {
                syncUtils.syncMapper = this.findBySessionBoardAndTenantAndArchive(syncUtils.getBoardId(), syncUtils.session.getTenant(), false);
                syncUtils.syncMappersBySprintId = new HashMap();
                syncUtils.syncMappersByTeamId = new HashMap();
                for (int i = 0; i < syncUtils.syncMapper.size(); ++i) {
                    if (!PropertyValidator.isValid((Object)((ItemSyncMapper)syncUtils.syncMapper.get(i)).getSprint()) || !PropertyValidator.isValid((Object)((ItemSyncMapper)syncUtils.syncMapper.get(i)).getTeam())) continue;
                    String sid = ((ItemSyncMapper)syncUtils.syncMapper.get(i)).getSprint().getJiraId();
                    String tid = ((ItemSyncMapper)syncUtils.syncMapper.get(i)).getTeam().getId();
                    if (sid != null) {
                        if (!syncUtils.syncMappersBySprintId.containsKey(sid)) {
                            syncUtils.syncMappersBySprintId.put(sid, new ArrayList());
                        }
                        ((List)syncUtils.syncMappersBySprintId.get(sid)).add(i);
                    }
                    if (tid == null) continue;
                    if (!syncUtils.syncMappersByTeamId.containsKey(tid)) {
                        syncUtils.syncMappersByTeamId.put(tid, new ArrayList());
                    }
                    ((List)syncUtils.syncMappersByTeamId.get(tid)).add(i);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            syncUtils.syncMappersBySprintId = new HashMap();
            syncUtils.syncMappersByTeamId = new HashMap();
            syncUtils.syncMapper = new LinkedList();
        }
    }

    public Map<String, List<Item>> findAndMapItemsByParent(List<String> itemIds, String tenant) {
        if (!PropertyValidator.isValid(itemIds)) {
            return Collections.emptyMap();
        }
        List parentIds = itemIds.stream().map(ObjectId::new).collect(Collectors.toList());
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"parent.$id").in(parentIds).and("tenant").is((Object)tenant));
        GroupOperation group = Aggregation.group((String[])new String[]{"parent.$id"}).push((Object)new BasicDBObject("_id", (Object)"$_id").append("storyPoints", (Object)"$storyPoints")).as("items");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "item", BasicDBObject.class);
        return results.getMappedResults().stream().collect(Collectors.toMap(x$0 -> DBUtils.getIdFromDBObject((BasicDBObject)x$0, (String[])new String[0]), result -> {
            List itemsList = (List)result.get("items");
            return itemsList.stream().map(dbObject -> {
                Item item = new Item();
                item.setId(DBUtils.getIdFromDBObject((BasicDBObject)dbObject, (String[])new String[0]));
                item.setStoryPoints(Double.valueOf(dbObject.getDouble("storyPoints")));
                return item;
            }).collect(Collectors.toList());
        }));
    }

    public Map calculateDataForFeatureDependenciesBySessions(ArrayList list) {
        HashMap<String, Integer> tableHash = new HashMap<String, Integer>();
        HashMap<String, Boolean> itemsMap = new HashMap<String, Boolean>();
        HashMap<String, List> sessionIdsMapByItemId = new HashMap<String, List>();
        HashMap<String, Boolean> duplicateJiraDependenciesMap = new HashMap<String, Boolean>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap board = (HashMap)list.get(i);
            String boardId = (String)board.get("sessionId");
            List items = (List)board.get("items");
            for (int j1 = 0; j1 < list.size(); ++j1) {
                HashMap subBoard = (HashMap)list.get(j1);
                String boardId2 = (String)subBoard.get("sessionId");
                if (!PropertyValidator.isValid(tableHash.get(boardId + "-" + boardId2))) {
                    tableHash.put(boardId + "-" + boardId2, 0);
                }
                if (i != 0) continue;
                List items2 = (List)subBoard.get("items");
                for (int j11 = 0; j11 < items2.size(); ++j11) {
                    HashMap item2 = (HashMap)items2.get(j11);
                    itemsMap.put((String)item2.get("id"), true);
                    String almId = null;
                    if (PropertyValidator.isValid(item2.get("tfsId"))) {
                        almId = (String)item2.get("tfsId");
                    } else if (PropertyValidator.isValid(item2.get("jiraId"))) {
                        almId = (String)item2.get("jiraId");
                    }
                    if (!PropertyValidator.isValid((Object)almId)) continue;
                    if (!PropertyValidator.isValid(sessionIdsMapByItemId.get(almId))) {
                        sessionIdsMapByItemId.put(almId, new ArrayList());
                    }
                    List sessionsIds = (List)sessionIdsMapByItemId.get(almId);
                    sessionsIds.add(boardId2);
                    sessionIdsMapByItemId.put(almId, sessionsIds);
                }
            }
            for (int j = 0; j < items.size(); ++j) {
                int ii;
                HashMap item = (HashMap)items.get(j);
                List itemLinks = (List)item.get("itemLinks");
                List jiraDependencies = (List)item.get("jiraDependencies");
                if (PropertyValidator.isValid((Collection)itemLinks)) {
                    for (ii = 0; ii < itemLinks.size(); ++ii) {
                        HashMap itemLink = (HashMap)itemLinks.get(ii);
                        if (PropertyValidator.isValid(itemLink.get("almLinkId"))) {
                            if (PropertyValidator.isValid(duplicateJiraDependenciesMap.get((String)itemLink.get("almLinkId")))) continue;
                            duplicateJiraDependenciesMap.put((String)itemLink.get("almLinkId"), true);
                        }
                        if (!PropertyValidator.isValid(itemLink.get("sourceSessionId"))) {
                            if (!PropertyValidator.isValid(tableHash.get(boardId + "-" + boardId))) {
                                tableHash.put(boardId + "-" + boardId, 0);
                            }
                            tableHash.put(boardId + "-" + boardId, (Integer)tableHash.get(boardId + "-" + boardId) + 1);
                            continue;
                        }
                        if (!PropertyValidator.isValid(itemLink.get("sourceSessionId")) || !PropertyValidator.isValid(itemLink.get("targetSessionId")) || !PropertyValidator.isValid(itemsMap.get(itemLink.get("targetItemId")))) continue;
                        String sourceSessionId = (String)itemLink.get("sourceSessionId");
                        String targetSessionId = (String)itemLink.get("targetSessionId");
                        if (!PropertyValidator.isValid(tableHash.get(sourceSessionId + "-" + targetSessionId))) {
                            tableHash.put(sourceSessionId + "-" + targetSessionId, 0);
                        }
                        tableHash.put(sourceSessionId + "-" + targetSessionId, (Integer)tableHash.get(sourceSessionId + "-" + targetSessionId) + 1);
                    }
                }
                if (!PropertyValidator.isValid((Collection)jiraDependencies)) continue;
                for (ii = 0; ii < jiraDependencies.size(); ++ii) {
                    HashMap jiraDependency = (HashMap)jiraDependencies.get(ii);
                    String sourceAlmId = null;
                    String targetAlmId = null;
                    String key = null;
                    String key2 = null;
                    if (PropertyValidator.isValid(jiraDependency.get("sourceTFSItem")) && PropertyValidator.isValid(jiraDependency.get("targetTFSItem"))) {
                        Map sourceTFSItem = (Map)jiraDependency.get("sourceTFSItem");
                        Map targetTFSItem = (Map)jiraDependency.get("targetTFSItem");
                        sourceAlmId = (String)sourceTFSItem.get("tfsId");
                        targetAlmId = (String)targetTFSItem.get("tfsId");
                        key = sourceAlmId + "-" + targetAlmId;
                        key2 = targetAlmId + "-" + sourceAlmId;
                    } else if (PropertyValidator.isValid(jiraDependency.get("targetJiraIssue"))) {
                        Map targetJiraIssue = (Map)jiraDependency.get("targetJiraIssue");
                        sourceAlmId = (String)targetJiraIssue.get("jiraParentId");
                        targetAlmId = (String)targetJiraIssue.get("jiraId");
                        key2 = key = (String)jiraDependency.get("jiraDependencyId");
                    }
                    if (PropertyValidator.isValid(duplicateJiraDependenciesMap.get(key)) || PropertyValidator.isValid(duplicateJiraDependenciesMap.get(key2))) continue;
                    List sourceSessionIds = (List)sessionIdsMapByItemId.get(sourceAlmId);
                    List targetSessionsIds = (List)sessionIdsMapByItemId.get(targetAlmId);
                    if (PropertyValidator.isValid((Collection)sourceSessionIds) && PropertyValidator.isValid((Collection)targetSessionsIds)) {
                        for (String sourceSessionId : sourceSessionIds) {
                            for (String targetSessionId : targetSessionsIds) {
                                if (!PropertyValidator.isValid(tableHash.get(sourceSessionId + "-" + targetSessionId))) {
                                    tableHash.put(sourceSessionId + "-" + targetSessionId, 0);
                                }
                                tableHash.put(sourceSessionId + "-" + targetSessionId, (Integer)tableHash.get(sourceSessionId + "-" + targetSessionId) + 1);
                            }
                        }
                    }
                    duplicateJiraDependenciesMap.put(key, true);
                    duplicateJiraDependenciesMap.put(key2, true);
                }
            }
        }
        return tableHash;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map calculateDataForFeatureDependenciesByTeams(ArrayList list) {
        HashMap tableHash = new HashMap();
        HashMap<String, HashMap> itemsMap = new HashMap<String, HashMap>();
        HashMap<String, List> sessionIdsMapByItemId = new HashMap<String, List>();
        HashMap<String, Boolean> duplicateJiraDependenciesMap = new HashMap<String, Boolean>();
        HashMap itemsTeamMapBySessionsIds = new HashMap();
        HashMap<String, List> teamsBySessionId = new HashMap<String, List>();
        int i = 0;
        block0: while (i < list.size()) {
            HashMap board = (HashMap)list.get(i);
            String boardId = (String)board.get("sessionId");
            List items = (List)board.get("items");
            List teams = (List)board.get("teams");
            int j1 = 0;
            while (true) {
                if (j1 >= list.size()) break;
                HashMap subBoard = (HashMap)list.get(j1);
                String boardId2 = (String)subBoard.get("sessionId");
                List subTeams = (List)subBoard.get("teams");
                teamsBySessionId.put(boardId2, subTeams);
                if (!PropertyValidator.isValid(tableHash.get(boardId + "-" + boardId2))) {
                    HashMap<String, Integer> teamMap = new HashMap<String, Integer>();
                    for (int t1 = 0; t1 < teams.size(); ++t1) {
                        String sTeamId = (String)((Map)teams.get(t1)).get("id");
                        for (int t2 = 0; t2 < subTeams.size(); ++t2) {
                            String tTeamId = (String)((Map)subTeams.get(t2)).get("id");
                            if (!PropertyValidator.isValid((Object)sTeamId) || !PropertyValidator.isValid((Object)tTeamId)) continue;
                            teamMap.put(sTeamId + "-" + tTeamId, 0);
                        }
                    }
                    tableHash.put(boardId + "-" + boardId2, teamMap);
                }
                if (i == 0) {
                    List items2 = (List)subBoard.get("items");
                    for (int j11 = 0; j11 < items2.size(); ++j11) {
                        HashMap item2 = (HashMap)items2.get(j11);
                        itemsMap.put((String)item2.get("id"), item2);
                        String almId = null;
                        if (PropertyValidator.isValid(item2.get("tfsId"))) {
                            almId = (String)item2.get("tfsId");
                        } else if (PropertyValidator.isValid(item2.get("jiraId"))) {
                            almId = (String)item2.get("jiraId");
                        }
                        if (!PropertyValidator.isValid((Object)almId)) continue;
                        if (!PropertyValidator.isValid(sessionIdsMapByItemId.get(almId))) {
                            sessionIdsMapByItemId.put(almId, new ArrayList());
                        }
                        List sessionsIds = (List)sessionIdsMapByItemId.get(almId);
                        sessionsIds.add(boardId2);
                        sessionIdsMapByItemId.put(almId, sessionsIds);
                        if (!PropertyValidator.isValid(itemsTeamMapBySessionsIds.get(boardId2))) {
                            itemsTeamMapBySessionsIds.put(boardId2, new HashMap());
                        }
                        Map itemMap = (Map)itemsTeamMapBySessionsIds.get(boardId2);
                        List tCs = (List)item2.get("teamContainers");
                        if (!PropertyValidator.isValid((Collection)tCs)) continue;
                        Map team = (Map)((Map)tCs.get(0)).get("team");
                        itemMap.put(almId, team.get("id"));
                    }
                }
                ++j1;
            }
            int j = 0;
            while (true) {
                List jiraDependencies;
                block34: {
                    Map sourceTeam;
                    List itemLinks;
                    block35: {
                        block33: {
                            if (j >= items.size()) break block33;
                            HashMap item = (HashMap)items.get(j);
                            List sourceTCs = (List)item.get("teamContainers");
                            itemLinks = (List)item.get("itemLinks");
                            jiraDependencies = (List)item.get("jiraDependencies");
                            if (!PropertyValidator.isValid((Collection)sourceTCs) || !PropertyValidator.isValid(sourceTCs.get(0))) break block34;
                            sourceTeam = (Map)((Map)sourceTCs.get(0)).get("team");
                            if (!PropertyValidator.isValid((Collection)itemLinks)) break block34;
                            break block35;
                        }
                        ++i;
                        continue block0;
                    }
                    for (int ii = 0; ii < itemLinks.size(); ++ii) {
                        List targetTCs;
                        HashMap itemLink = (HashMap)itemLinks.get(ii);
                        if (PropertyValidator.isValid(itemLink.get("almLinkId"))) {
                            if (PropertyValidator.isValid(duplicateJiraDependenciesMap.get((String)itemLink.get("almLinkId")))) continue;
                            duplicateJiraDependenciesMap.put((String)itemLink.get("almLinkId"), true);
                        }
                        String targetItemId = null;
                        if (PropertyValidator.isValid(itemLink.get("targetFeatureId"))) {
                            targetItemId = (String)itemLink.get("targetFeatureId");
                        } else if (PropertyValidator.isValid(itemLink.get("targetItemId"))) {
                            targetItemId = (String)itemLink.get("targetItemId");
                        }
                        Map targetItem = (Map)itemsMap.get(targetItemId);
                        if (!PropertyValidator.isValid((Object)targetItem) || !PropertyValidator.isValid((Collection)(targetTCs = (List)targetItem.get("teamContainers"))) || !PropertyValidator.isValid(targetTCs.get(0))) continue;
                        Map targetTeam = (Map)((Map)targetTCs.get(0)).get("team");
                        Map teamMatrix = null;
                        if (!PropertyValidator.isValid(itemLink.get("sourceSessionId"))) {
                            teamMatrix = (Map)tableHash.get(boardId + "-" + boardId);
                            if (!PropertyValidator.isValid((Object)teamMatrix)) {
                                this.creatTeamMatrixBySession(boardId, boardId, tableHash, teamsBySessionId);
                                teamMatrix = (Map)tableHash.get(boardId + "-" + boardId);
                            }
                        } else if (PropertyValidator.isValid(itemLink.get("sourceSessionId")) && PropertyValidator.isValid(itemLink.get("targetSessionId")) && PropertyValidator.isValid(itemsMap.get(itemLink.get("targetItemId")))) {
                            String sourceSessionId = (String)itemLink.get("sourceSessionId");
                            String targetSessionId = (String)itemLink.get("targetSessionId");
                            teamMatrix = (Map)tableHash.get(sourceSessionId + "-" + targetSessionId);
                            if (!PropertyValidator.isValid((Object)teamMatrix)) {
                                this.creatTeamMatrixBySession(sourceSessionId, targetSessionId, tableHash, teamsBySessionId);
                                teamMatrix = (Map)tableHash.get(sourceSessionId + "-" + targetSessionId);
                            }
                        }
                        if (!PropertyValidator.isValid(teamMatrix) || !PropertyValidator.isValid((Object)sourceTeam) || !PropertyValidator.isValid((Object)targetTeam) || !PropertyValidator.isValid(teamMatrix.get(sourceTeam.get("id") + "-" + targetTeam.get("id")))) continue;
                        teamMatrix.put(sourceTeam.get("id") + "-" + targetTeam.get("id"), (Integer)teamMatrix.get(sourceTeam.get("id") + "-" + targetTeam.get("id")) + 1);
                    }
                }
                if (PropertyValidator.isValid((Collection)jiraDependencies)) {
                    for (int ii = 0; ii < jiraDependencies.size(); ++ii) {
                        HashMap jiraDependency = (HashMap)jiraDependencies.get(ii);
                        String sourceAlmId = null;
                        String targetAlmId = null;
                        String key = null;
                        String key2 = null;
                        if (PropertyValidator.isValid(jiraDependency.get("sourceTFSItem")) && PropertyValidator.isValid(jiraDependency.get("targetTFSItem"))) {
                            Map sourceTFSItem = (Map)jiraDependency.get("sourceTFSItem");
                            Map targetTFSItem = (Map)jiraDependency.get("targetTFSItem");
                            sourceAlmId = (String)sourceTFSItem.get("tfsId");
                            targetAlmId = (String)targetTFSItem.get("tfsId");
                            key = sourceAlmId + "-" + targetAlmId;
                            key2 = targetAlmId + "-" + sourceAlmId;
                        } else if (PropertyValidator.isValid(jiraDependency.get("targetJiraIssue"))) {
                            Map targetJiraIssue = (Map)jiraDependency.get("targetJiraIssue");
                            sourceAlmId = (String)targetJiraIssue.get("jiraParentId");
                            targetAlmId = (String)targetJiraIssue.get("jiraId");
                            key2 = key = (String)jiraDependency.get("jiraDependencyId");
                        }
                        if (PropertyValidator.isValid(duplicateJiraDependenciesMap.get(key)) || PropertyValidator.isValid(duplicateJiraDependenciesMap.get(key2))) continue;
                        List sourceSessionIds = (List)sessionIdsMapByItemId.get(sourceAlmId);
                        List targetSessionsIds = (List)sessionIdsMapByItemId.get(targetAlmId);
                        if (PropertyValidator.isValid((Collection)sourceSessionIds) && PropertyValidator.isValid((Collection)targetSessionsIds)) {
                            for (String sourceSessionId : sourceSessionIds) {
                                String sourceTeamId;
                                Map sourceSessionMap = (Map)itemsTeamMapBySessionsIds.get(sourceSessionId);
                                if (!PropertyValidator.isValid((Object)sourceSessionMap) || !PropertyValidator.isValid((Object)(sourceTeamId = (String)sourceSessionMap.get(sourceAlmId)))) continue;
                                for (String targetSessionId : targetSessionsIds) {
                                    String targetTeamId;
                                    Map targetSessionMap = (Map)itemsTeamMapBySessionsIds.get(targetSessionId);
                                    if (!PropertyValidator.isValid((Object)targetSessionMap) || !PropertyValidator.isValid((Object)(targetTeamId = (String)targetSessionMap.get(targetAlmId)))) continue;
                                    Map teamMatrix = (Map)tableHash.get(sourceSessionId + "-" + targetSessionId);
                                    if (!PropertyValidator.isValid((Object)teamMatrix)) {
                                        this.creatTeamMatrixBySession(sourceSessionId, targetSessionId, tableHash, teamsBySessionId);
                                        teamMatrix = (Map)tableHash.get(sourceSessionId + "-" + targetSessionId);
                                    }
                                    if (!PropertyValidator.isValid(teamMatrix.get(sourceTeamId + "-" + targetTeamId))) continue;
                                    teamMatrix.put(sourceTeamId + "-" + targetTeamId, (Integer)teamMatrix.get(sourceTeamId + "-" + targetTeamId) + 1);
                                }
                            }
                        }
                        duplicateJiraDependenciesMap.put(key, true);
                        duplicateJiraDependenciesMap.put(key2, true);
                    }
                }
                ++j;
            }
            break;
        }
        return tableHash;
    }

    public void creatTeamMatrixBySession(String sourceSessionId, String targetSessionId, Map tableHash, Map teamsBySessionId) {
        List sourceTeams = (List)teamsBySessionId.get(sourceSessionId);
        List targetTeams = (List)teamsBySessionId.get(targetSessionId);
        HashMap<String, Integer> teamMap = new HashMap<String, Integer>();
        for (int t1 = 0; t1 < sourceTeams.size(); ++t1) {
            String sTeamId = (String)((Map)sourceTeams.get(t1)).get("id");
            for (int t2 = 0; t2 < targetTeams.size(); ++t2) {
                String tTeamId = (String)((Map)targetTeams.get(t2)).get("id");
                if (!PropertyValidator.isValid((Object)sTeamId) || !PropertyValidator.isValid((Object)tTeamId)) continue;
                teamMap.put(sTeamId + "-" + tTeamId, 0);
            }
        }
        tableHash.put(sourceSessionId + "-" + targetSessionId, teamMap);
    }

    public Map calculateDataForFeatureDependenciesByFeatureTab(ArrayList list, ArrayList boards) throws Exception {
        int i;
        HashMap tableHash = new HashMap();
        HashMap<String, Integer> tableHashByBoards = new HashMap<String, Integer>();
        HashMap tableHashByBoardsByTeams = new HashMap();
        for (i = 0; i < boards.size(); ++i) {
            HashMap board = (HashMap)boards.get(i);
            String boardId = (String)board.get("sessionId");
            List teams = (List)board.get("teams");
            for (int j = 0; j < boards.size(); ++j) {
                HashMap board2 = (HashMap)boards.get(j);
                String boardId2 = (String)board2.get("sessionId");
                List subTeams = (List)board2.get("teams");
                if (!PropertyValidator.isValid(tableHashByBoards.get(boardId + "-" + boardId2))) {
                    tableHashByBoards.put(boardId + "-" + boardId2, 0);
                }
                if (PropertyValidator.isValid(tableHashByBoardsByTeams.get(boardId + "-" + boardId2))) continue;
                HashMap<String, Integer> teamMap = new HashMap<String, Integer>();
                for (int t1 = 0; t1 < teams.size(); ++t1) {
                    String sTeamId = (String)((Map)teams.get(t1)).get("id");
                    for (int t2 = 0; t2 < subTeams.size(); ++t2) {
                        String tTeamId = (String)((Map)subTeams.get(t2)).get("id");
                        if (!PropertyValidator.isValid((Object)sTeamId) || !PropertyValidator.isValid((Object)tTeamId)) continue;
                        teamMap.put(sTeamId + "-" + tTeamId, 0);
                    }
                }
                tableHashByBoardsByTeams.put(boardId + "-" + boardId2, teamMap);
            }
        }
        for (i = 0; i < list.size(); ++i) {
            Map teamMatrix;
            HashMap dep = (HashMap)list.get(i);
            HashMap sBoard = (HashMap)dep.get("sBoard");
            HashMap sTeam = (HashMap)dep.get("sTeam");
            String sourceSessionId = null;
            String sTeamId = null;
            if (PropertyValidator.isValid((Object)sBoard)) {
                sourceSessionId = (String)sBoard.get("sessionId");
            }
            if (PropertyValidator.isValid((Object)sTeam)) {
                sTeamId = (String)sTeam.get("id");
            }
            HashMap tBoard = (HashMap)dep.get("tBoard");
            HashMap tTeam = (HashMap)dep.get("tTeam");
            String targetSessionId = null;
            String tTeamId = null;
            if (PropertyValidator.isValid((Object)tBoard)) {
                targetSessionId = (String)tBoard.get("sessionId");
            }
            if (PropertyValidator.isValid((Object)tTeam)) {
                tTeamId = (String)tTeam.get("id");
            }
            if (!PropertyValidator.isValid((Object)sourceSessionId) || !PropertyValidator.isValid((Object)targetSessionId)) continue;
            if (!PropertyValidator.isValid(tableHashByBoards.get(sourceSessionId + "-" + targetSessionId))) {
                tableHashByBoards.put(sourceSessionId + "-" + targetSessionId, 0);
            }
            tableHashByBoards.put(sourceSessionId + "-" + targetSessionId, (Integer)tableHashByBoards.get(sourceSessionId + "-" + targetSessionId) + 1);
            if (!PropertyValidator.isValid((Object)sTeamId) || !PropertyValidator.isValid((Object)tTeamId) || !PropertyValidator.isValid((Object)(teamMatrix = (Map)tableHashByBoardsByTeams.get(sourceSessionId + "-" + targetSessionId)))) continue;
            if (!PropertyValidator.isValid(teamMatrix.get(sTeamId + "-" + tTeamId))) {
                teamMatrix.put(sTeamId + "-" + tTeamId, 0);
            }
            teamMatrix.put(sTeamId + "-" + tTeamId, (Integer)teamMatrix.get(sTeamId + "-" + tTeamId) + 1);
        }
        tableHash.put("data", tableHashByBoards);
        tableHash.put("dataByTeams", tableHashByBoardsByTeams);
        return tableHash;
    }

    public int countByStatusIdAndRegister(List<String> ids, String statusId, String riskRegisterId) {
        Integer riskCount = 0;
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (String sid : ids) {
            objectIds.add(new ObjectId(sid));
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(objectIds).and("status.$id").is((Object)new ObjectId(statusId)).and("riskRegister.$id").is((Object)new ObjectId(riskRegisterId)));
        riskCount = (int)this.mongoTemplate.count(query, Risk.class);
        return riskCount;
    }

    public void createDefaulBuckets() {
        ArrayList<IssueType> defaultList = new ArrayList<IssueType>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isBucket").is((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"isDefault").is((Object)true));
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getCurrentCompany().getTenant()));
        }
        query.fields().include("_id");
        query.fields().include("title");
        Long count = this.mongoTemplate.count(query, IssueType.class);
        if (!PropertyValidator.isValid((Object)count) || count < 1L) {
            defaultList.add(new IssueType(ObjectId.get().toString(), "(Global) Unparented Stories", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
            defaultList.add(new IssueType(ObjectId.get().toString(), "(Global) Bugs", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
            this.issueTypeRepository.save(defaultList);
        }
    }

    public void inlineSaveRisk(Map map) {
        Update update;
        String riskId = (String)map.get("riskId");
        String fieldToUpdate = (String)map.get("fieldToUpdate");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)riskId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        if (fieldToUpdate.equalsIgnoreCase("status")) {
            Map newValue = (Map)map.get("value");
            DBRef statusRef = new DBRef("status", newValue.get("id"));
            update = new Update().set(fieldToUpdate, (Object)statusRef);
        } else if (fieldToUpdate.equalsIgnoreCase("responsible")) {
            Map newValue = (Map)map.get("value");
            DBRef responsibleRef = new DBRef("user", newValue.get("id"));
            update = new Update().set(fieldToUpdate, (Object)responsibleRef);
        } else if (fieldToUpdate.equalsIgnoreCase("raisedDate")) {
            String newValue = (String)map.get("value");
            Instant instant = Instant.parse(newValue);
            Date raisedDate = Date.from(instant);
            update = new Update().set(fieldToUpdate, (Object)raisedDate);
        } else if (fieldToUpdate.equalsIgnoreCase("resolutionDate")) {
            String newValue = (String)map.get("value");
            Instant instant = Instant.parse(newValue);
            Date resolutionDate = Date.from(instant);
            update = new Update().set(fieldToUpdate, (Object)resolutionDate);
        } else {
            update = new Update().set(fieldToUpdate, map.get("value"));
        }
        this.mongoTemplate.updateFirst(query, update, Risk.class);
    }

    public void updateRiskRegisterLastUpdatedOnSavingRisk(String riskRegisterId, Date str) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)riskRegisterId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
        Update update = new Update().set("updatedOn", (Object)str);
        this.mongoTemplate.updateFirst(query, update, RiskRegister.class);
    }

    public boolean updateRiskRegisterTitle(String riskRegisterId, String registerName) {
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)riskRegisterId));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
            Update update = new Update().set("registerName", (Object)registerName).set("updatedOn", (Object)new Date());
            this.mongoTemplate.updateFirst(query, update, RiskRegister.class);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error updating risk register title for ID: {}", (Object)riskRegisterId, (Object)e);
            return false;
        }
    }

    public void updateSosReminderSent(String sosId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)sosId));
        Update update = new Update().set("reminderSent", (Object)true);
        this.mongoTemplate.updateFirst(query, update, "scrumOfScrums");
    }

    public boolean checkFilterNameExists(String sessionId, String filterName) throws Exception {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId).and("filterName").is((Object)filterName));
        return this.mongoTemplate.exists(query, "boardFilter");
    }

    public List<BoardFilter> findDependencyFiltersBySessionAndUser(String sessionId, String userId) {
        Query query = new Query();
        try {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"dependency"));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionId").is((Object)sessionId));
            Criteria userCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"userId").is(null), Criteria.where((String)"userId").is((Object)userId)});
            query.addCriteria((CriteriaDefinition)userCriteria);
            return this.mongoTemplate.find(query, BoardFilter.class);
        }
        catch (Exception e) {
            LOGGER.error("Error Finding Dependency Filters", (Object)StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public List<Company> findActiveCompaines() {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").ne((Object)1));
        Date now = new Date();
        Criteria expiryActive = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"expiryDate").ne(null), Criteria.where((String)"expiryDate").gte((Object)now)});
        Criteria nextPaymentActive = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"expiryDate").is(null), Criteria.where((String)"nextPaymentDate").ne(null), Criteria.where((String)"nextPaymentDate").gte((Object)now)});
        query.addCriteria((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{expiryActive, nextPaymentActive}));
        query.fields().include("_id");
        query.fields().include("name");
        query.fields().include("expiryDate");
        query.fields().include("nextPaymentDate");
        query.fields().include("tenant");
        return this.mongoTemplate.find(query, Company.class);
    }

    public List<String> getActiveAlmAccounts(List companies) {
        List companyList = companies;
        List tenantIds = companyList.stream().map(BaseEntity::getTenant).filter(Objects::nonNull).collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").in(tenantIds));
        query.fields().include("_id");
        List accounts = this.mongoTemplate.find(query, AlmAccount.class);
        return accounts.stream().map(a -> a.getId().toString()).collect(Collectors.toList());
    }

    public Map<String, Object> fetchTeamsAndContainersFromSessions(List<Session> sessions) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (sessions == null || sessions.isEmpty()) {
            result.put("teams", new ArrayList());
            result.put("containers", new ArrayList());
            return result;
        }
        ArrayList<ObjectId> sessionBoardIds = new ArrayList<ObjectId>();
        HashMap<String, Session> sessionMap = new HashMap<String, Session>();
        for (Session session : sessions) {
            if (session.getActiveSessionBoard() == null) continue;
            sessionBoardIds.add(new ObjectId(session.getActiveSessionBoard()));
            sessionMap.put(session.getActiveSessionBoard(), session);
        }
        if (sessionBoardIds.isEmpty()) {
            result.put("teams", new ArrayList());
            result.put("containers", new ArrayList());
            return result;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(sessionBoardIds));
        query.fields().include("teams").include("containers").include("_id");
        List sessionBoards = this.mongoTemplate.find(query, SessionBoard.class);
        HashMap uniqueTeams = new HashMap();
        HashMap uniqueContainers = new HashMap();
        for (SessionBoard board : sessionBoards) {
            if (board.getTeams() != null) {
                for (Team team : board.getTeams()) {
                    String teamId;
                    if (team == null || team.getId() == null || uniqueTeams.containsKey(teamId = team.getId().toString())) continue;
                    HashMap<String, String> teamMap = new HashMap<String, String>();
                    teamMap.put("id", teamId);
                    teamMap.put("title", team.getTitle() != null ? team.getTitle() : "");
                    uniqueTeams.put(teamId, teamMap);
                }
            }
            if (board.getContainers() == null) continue;
            Session session = (Session)sessionMap.get(board.getId().toString());
            String sessionId = session != null ? session.getId().toString() : "";
            String sessionTitle = session != null ? session.getTitle() : "";
            for (Container container : board.getContainers()) {
                String containerId;
                if (container == null || container.getId() == null || uniqueContainers.containsKey(containerId = container.getId().toString())) continue;
                HashMap<String, String> containerMap = new HashMap<String, String>();
                containerMap.put("id", containerId);
                containerMap.put("title", container.getTitle() != null ? container.getTitle() : "");
                containerMap.put("sessionId", sessionId);
                containerMap.put("sessionTitle", sessionTitle);
                uniqueContainers.put(containerId, containerMap);
            }
        }
        result.put("teams", new ArrayList(uniqueTeams.values()));
        result.put("containers", new ArrayList(uniqueContainers.values()));
        return result;
    }
}

