/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.alm.entity.ALMFilter;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BacklogSettings;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.CheckInsSettings;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Role;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.WorkSpaceType;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class WorkSpace
extends BaseEntity {
    private static final long serialVersionUID = 1L;
    private String key;
    private String title;
    private String description;
    private boolean isDefault = false;
    private Double sequence = new Double(System.nanoTime() / 100000L);
    private String shortName;
    private String color;
    private List<HashMap> modules;
    private HashMap<String, String> syncFlag;
    private Boolean isModule = Boolean.FALSE;
    private String moduleType;
    private String workspaceLinksTitle;
    private String workspaceLinksDescription;
    @Transient
    List<WorkSpaceAccessRole> accessRoles;
    @Transient
    List<Session> sessions;
    private HashMap<String, String> ignoreItemsInResync;
    private Integer level = -1;
    private List<String> linkedWorkSpaces;
    private HashMap<String, BacklogSettings> backlogSettingsMap;
    @DBRef
    private List<AlmAccount> linkedAlmAccounts;
    private List<ALMFilter> almFilters;
    private List<Attachment> attachments;
    @DBRef
    private WorkFlow workflow;
    @DBRef
    private WorkSpaceType type;
    private String linkedAlmHierarchy;
    @DBRef
    private ArrayList<PiSite> sites;
    private List<String> columnSettings;
    private List<String> customViewColumnSettings;
    @DBRef
    private FieldsLayout kendisOnlyLayout;
    private CheckInsSettings checkInsSettings;
    @DBRef
    private List<RiskRegister> riskRegisters;

    public WorkSpace() {
    }

    public WorkSpace(String id) {
        super(id);
    }

    public String getTitle() {
        return this.title;
    }

    public WorkSpace(String id, String title) {
        super(id);
        this.title = title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<WorkSpaceAccessRole> getAccessRoles() {
        return this.accessRoles;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public void setAccessRoles(List<WorkSpaceAccessRole> accessRoles) {
        this.accessRoles = accessRoles;
    }

    public List<AlmAccount> getLinkedAlmAccounts() {
        return this.linkedAlmAccounts;
    }

    public void setLinkedAlmAccounts(List<AlmAccount> linkedAlmAccounts) {
        this.linkedAlmAccounts = linkedAlmAccounts;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkSpace other = (WorkSpace)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public List<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(List<Session> sessions) {
        this.sessions = sessions;
    }

    public String log() {
        StringBuilder info = new StringBuilder();
        info.append("WorkSpace {");
        info.append("id:");
        info.append(this.getId());
        info.append(",");
        info.append("title:");
        info.append(this.getTitle());
        info.append(",");
        info.append("accessRoles:{");
        if (PropertyValidator.isValid((Collection)this.getAccessRoles())) {
            for (WorkSpaceAccessRole workSpaceAccessRole : this.getAccessRoles()) {
                info.append("{");
                info.append("id:");
                info.append(workSpaceAccessRole.getId());
                info.append(",");
                if (PropertyValidator.isValid((Object)workSpaceAccessRole.getGroup())) {
                    info.append("isGroup:");
                    info.append(true);
                    info.append(",");
                    info.append("isLDAP:");
                    info.append(workSpaceAccessRole.getGroup().isLdap());
                    info.append(",");
                    info.append("Title:");
                    info.append(workSpaceAccessRole.getGroup().getTitle());
                    info.append(",");
                } else {
                    info.append("isGroup:");
                    info.append(false);
                    info.append(",");
                    info.append("isLDAP:");
                    info.append(workSpaceAccessRole.getUser().isLdap());
                    info.append(",");
                    info.append("Title:");
                    info.append(workSpaceAccessRole.getUser().getUserName());
                    info.append(",");
                }
                info.append("Roles:{");
                if (PropertyValidator.isValid((Collection)workSpaceAccessRole.getRoles())) {
                    for (Role role : workSpaceAccessRole.getRoles()) {
                        info.append("id:");
                        info.append(role.getId());
                        info.append(",");
                        info.append("id:");
                        info.append(role.getTitle());
                    }
                }
                info.append("}");
                info.append(",");
                info.append("}");
            }
            info.append("}");
        }
        info.append("}");
        return info.toString();
    }

    public String toString() {
        1 builder = new /* Unavailable Anonymous Inner Class!! */;
        return builder.toString();
    }

    public List<ALMFilter> getAlmFilters() {
        return this.almFilters;
    }

    public void setAlmFilters(List<ALMFilter> almFilters) {
        this.almFilters = almFilters;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<String> getLinkedWorkSpaces() {
        return this.linkedWorkSpaces;
    }

    public void setLinkedWorkSpaces(List<String> linkedWorkSpaces) {
        this.linkedWorkSpaces = linkedWorkSpaces;
    }

    public HashMap<String, BacklogSettings> getBacklogSettingsMap() {
        return this.backlogSettingsMap;
    }

    public void setBacklogSettingsMap(HashMap<String, BacklogSettings> backlogSettingsMap) {
        this.backlogSettingsMap = backlogSettingsMap;
    }

    public WorkFlow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(WorkFlow workflow) {
        this.workflow = workflow;
    }

    public WorkSpaceType getType() {
        return this.type;
    }

    public void setType(WorkSpaceType type) {
        this.type = type;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<HashMap> getModules() {
        return this.modules;
    }

    public void setModules(List<HashMap> modules) {
        this.modules = modules;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public String getLinkedAlmHierarchy() {
        return this.linkedAlmHierarchy;
    }

    public void setLinkedAlmHierarchy(String linkedAlmHierarchy) {
        this.linkedAlmHierarchy = linkedAlmHierarchy;
    }

    public Boolean getIsModule() {
        return this.isModule;
    }

    public void setIsModule(Boolean isModule) {
        this.isModule = isModule;
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

    public HashMap<String, String> getSyncFlag() {
        return this.syncFlag;
    }

    public void setSyncFlag(HashMap<String, String> syncFlag) {
        this.syncFlag = syncFlag;
    }

    public ArrayList<PiSite> getSites() {
        return this.sites;
    }

    public void setSites(ArrayList<PiSite> sites) {
        this.sites = sites;
    }

    public HashMap<String, String> getIgnoreItemsInResync() {
        return this.ignoreItemsInResync;
    }

    public void setIgnoreItemsInResync(HashMap<String, String> ignoreItemsInResync) {
        this.ignoreItemsInResync = ignoreItemsInResync;
    }

    public FieldsLayout getKendisOnlyLayout() {
        return this.kendisOnlyLayout;
    }

    public void setKendisOnlyLayout(FieldsLayout kendisOnlyLayout) {
        this.kendisOnlyLayout = kendisOnlyLayout;
    }

    public CheckInsSettings getCheckInsSettings() {
        return this.checkInsSettings;
    }

    public void setCheckInsSettings(CheckInsSettings checkInsSettings) {
        this.checkInsSettings = checkInsSettings;
    }

    public List<String> getColumnSettings() {
        return this.columnSettings;
    }

    public void setColumnSettings(List<String> columnSettings) {
        this.columnSettings = columnSettings;
    }

    public List<RiskRegister> getRiskRegisters() {
        return this.riskRegisters;
    }

    public void setRiskRegisters(List<RiskRegister> riskRegisters) {
        this.riskRegisters = riskRegisters;
    }

    public List<String> getCustomViewColumnSettings() {
        return this.customViewColumnSettings;
    }

    public void setCustomViewColumnSettings(List<String> customViewColumnSettings) {
        this.customViewColumnSettings = customViewColumnSettings;
    }

    public String getWorkspaceLinksTitle() {
        return this.workspaceLinksTitle;
    }

    public String getWorkspaceLinksDescription() {
        return this.workspaceLinksDescription;
    }

    public void setWorkspaceLinksTitle(String workspaceLinksTitle) {
        this.workspaceLinksTitle = workspaceLinksTitle;
    }

    public void setWorkspaceLinksDescription(String workspaceLinksDescription) {
        this.workspaceLinksDescription = workspaceLinksDescription;
    }
}

