/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.User;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.mapping.DBRef;

@GenerateLog
@JsonIgnoreProperties(ignoreUnknown=true)
public class Watcher
extends BaseEntity {
    private String email;
    private String type;
    private List<String> exclusionListIds = new ArrayList();
    @DBRef
    private User user;
    @DBRef
    private Group group;
    private String entityType;
    private String entityId;

    public Watcher(User user) {
        this.user = user;
    }

    public Watcher() {
    }

    public Watcher(String id) {
        super(id);
    }

    public String getTitle() {
        if (this.user != null) {
            return this.user.getFullName();
        }
        if (this.group != null) {
            return this.group.getTitle();
        }
        return "N/A";
    }

    public String getWatcherId() {
        if (this.user != null) {
            return this.user.getId();
        }
        if (this.group != null) {
            return this.group.getId();
        }
        return "";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getExclusionListIds() {
        return this.exclusionListIds;
    }

    public void setExclusionListIds(List<String> exclusionListIds) {
        this.exclusionListIds = exclusionListIds;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }
}

