/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mongodb.BasicDBObject;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.PasswordHistory;
import com.viztrend.safe.persistence.entity.Role;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.UserPreferences;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.annotation.Transient;

public class User
extends BaseEntity
implements Comparable<User> {
    private String userName;
    private String fullName;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    private String mfaCodeSec;
    private String firstName;
    private String contact;
    private String samlUserId;
    private boolean locked;
    private String lastName;
    private String email;
    private Set<String> groups;
    private Set<Role> roles;
    private Integer rightLevel;
    private String backgroundColor;
    private Integer skipTutorial;
    private Boolean isAdmin = Boolean.FALSE;
    private List<String> externalReferenceGroups;
    @Transient
    private Boolean isActive = Boolean.TRUE;
    @Transient
    @Deprecated
    private Boolean isSuperAdmin = Boolean.FALSE;
    @Transient
    private Boolean isGuest = Boolean.FALSE;
    @Transient
    private UserCompany loggedInUserCompany;
    @Transient
    private String installationId;
    @Transient
    private Long signedUpTimeStamp;
    @Transient
    private String imgPath;
    private String picturePath;
    @Transient
    private String nameSpace;
    @Transient
    private long trialDaysLeft = 0L;
    @Transient
    private Boolean isPaid;
    @Transient
    private Boolean isValid;
    @Transient
    private LdapUser ldapUser;
    @Transient
    private boolean filledUpSurvey;
    private boolean ldap = false;
    private boolean okta = false;
    @Transient
    private Boolean isTemp = false;
    private Boolean isJiraPluginUser = false;
    private UserType userType = UserType.KENDIS;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Transient
    private String paymentKey;
    @Transient
    private List<WorkSpaceAccessRole> accessRoles;
    @Transient
    private List<String> permissions;
    @Transient
    private String oldPassword;
    @Transient
    private boolean debug;
    @JsonIgnore
    private boolean requireMFACode;
    @Transient
    private String mfaCode;
    @Transient
    private String mfaRecCode;
    @Transient
    private Boolean selected;
    @Transient
    private String intercomUserHash;
    private String recoveryMFACode;
    private Boolean forcedMFA;
    private Date mfaCreatedDate;
    private Date reckeyUpdatedDate;
    private Date mfaDisableDate;
    @JsonIgnore
    private int tressPassCount;
    @JsonIgnore
    private List<PasswordHistory> passwordHistory;
    private List<AlmAccUser> almCredentials;
    private List<UserCompany> userCompanies;
    private UserPreferences userPreferences;
    private String resetPasswordEncryption;
    @Transient
    private boolean isGuestUserConversion = false;

    public User() {
        this.setBackgroundColor(this.getRandomColor());
    }

    public User(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.userName = object.getString("userName");
        this.firstName = object.getString("firstName");
        this.lastName = object.getString("lastName");
        this.fullName = object.getString("fullName");
        this.email = object.getString("email");
        this.picturePath = object.getString("picturePath");
        this.backgroundColor = object.getString("backgroundColor");
        this.imgPath = object.getString("imgPath");
    }

    public User(String id) {
        super(id);
        this.setBackgroundColor(this.getRandomColor());
    }

    public User(String id, String userName, String fullName, String firstName, String lastName, String email, List<AlmAccUser> almCredentials) {
        super(id);
        this.userName = userName;
        this.fullName = fullName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.almCredentials = almCredentials;
    }

    public User(Map<String, Object> user) {
        this.fullName = (String)user.get("fullName");
        this.userName = (String)user.get("userName");
        this.firstName = (String)user.get("firstName");
        this.lastName = (String)user.get("lastname");
        this.password = (String)user.get("password");
        this.isActive = (Boolean)user.get("isActive");
        this.ldap = (Boolean)user.get("ldap");
        this.groups = new HashSet();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Date getMfaCreatedDate() {
        return this.mfaCreatedDate;
    }

    public void setMfaCreatedDate(Date mfaCreatedDate) {
        this.mfaCreatedDate = mfaCreatedDate;
    }

    public Date getMfaDisableDate() {
        return this.mfaDisableDate;
    }

    public void setMfaDisableDate(Date mfaDisableDate) {
        this.mfaDisableDate = mfaDisableDate;
    }

    public Date getreckeyUpdatedDate() {
        return this.reckeyUpdatedDate;
    }

    public void setreckeyUpdatedDate(Date date) {
        this.reckeyUpdatedDate = date;
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean isOkta() {
        return this.okta;
    }

    public void setOkta(boolean okta) {
        this.okta = okta;
    }

    public void setLastName(String lastname) {
        this.lastName = lastname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setValidUserName(String userName) {
        this.userName = userName;
        if (!this.hasValidUserName().booleanValue()) {
            this.userName = null;
        }
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public Integer getRightLevel() {
        return this.rightLevel;
    }

    public void setRightLevel(Integer rightLevel) {
        this.rightLevel = rightLevel;
    }

    public Set<String> getGroups() {
        if (!PropertyValidator.isValid((Collection)this.groups)) {
            return new HashSet<String>();
        }
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public String getPicturePath() {
        return this.picturePath;
    }

    public void setPicturePath(String picturePath) {
        this.picturePath = picturePath;
    }

    public Boolean getIsSuperAdmin() {
        return this.isSuperAdmin;
    }

    public void setIsSuperAdmin(Boolean isSuperAdmin) {
        this.isSuperAdmin = isSuperAdmin;
    }

    public List<WorkSpaceAccessRole> getAccessRoles() {
        return this.accessRoles;
    }

    public void setAccessRoles(List<WorkSpaceAccessRole> accessRoles) {
        this.accessRoles = accessRoles;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public List<AlmAccUser> getAlmCredentials() {
        return this.almCredentials;
    }

    public void setAlmCredentials(List<AlmAccUser> almCredentials) {
        this.almCredentials = almCredentials;
    }

    @Override
    public int compareTo(User o) {
        if (o != null && (o.getEmail() != null && o.getEmail().equals(this.getEmail()) || o.getUserName() != null && o.getUserName().equals(this.getUserName()))) {
            return 0;
        }
        return -1;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public Boolean getIsActive(String companyId) {
        for (UserCompany uc : this.userCompanies) {
            if (!uc.getCompany().getId().equals(UserContextUtil.getUserContext().getCurrentCompanyId())) continue;
            return uc.getIsActive();
        }
        return true;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public Boolean hasValidEmail() {
        if (PropertyValidator.isValid((Object)this.email)) {
            String regex = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+([a-zA-Z0-9]+)$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(this.email);
            return matcher.matches();
        }
        return false;
    }

    public Boolean hasValidUserName() {
        return this.hasValidEmail();
    }

    public List<UserCompany> getUserCompanies() {
        return this.userCompanies;
    }

    public void setUserCompanies(List<UserCompany> userCompanies) {
        this.userCompanies = userCompanies;
    }

    public LdapUser getLdapUser() {
        return this.ldapUser;
    }

    public void setLdapUser(LdapUser ldapUser) {
        this.ldapUser = ldapUser;
    }

    public boolean isLdap() {
        return this.ldap;
    }

    public void setLdap(boolean ldap) {
        this.ldap = ldap;
    }

    public UserCompany getLoggedInUserCompany() {
        return this.loggedInUserCompany;
    }

    public void setLoggedInUserCompany(UserCompany loggedInUserCompany) {
        this.loggedInUserCompany = loggedInUserCompany;
    }

    public long getTrialDaysLeft() {
        return this.trialDaysLeft;
    }

    public void setTrialDaysLeft(long trialDaysLeft) {
        this.trialDaysLeft = trialDaysLeft;
    }

    public Long getSignedUpTimeStamp() {
        if (this.getCreatedOn() != null) {
            return this.getCreatedOn().getTime() / 1000L;
        }
        return null;
    }

    public void setSignedUpTimeStamp(Long signedUpTimeStamp) {
        this.signedUpTimeStamp = signedUpTimeStamp;
    }

    public Boolean getIsPaid() {
        return this.isPaid;
    }

    public void setIsPaid(Boolean isPaid) {
        this.isPaid = isPaid;
    }

    public Boolean getIsJiraPluginUser() {
        return this.isJiraPluginUser;
    }

    public void setforcedMFA(Boolean forcedMFA) {
        this.forcedMFA = forcedMFA;
    }

    public Boolean getforcedMFA() {
        return this.forcedMFA;
    }

    public void setIsJiraPluginUser(Boolean isJiraPluginUser) {
        this.isJiraPluginUser = isJiraPluginUser;
    }

    public String getPaymentKey() {
        return this.paymentKey;
    }

    public void setPaymentKey(String paymentKey) {
        this.paymentKey = paymentKey;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getResetPasswordEncryption() {
        return this.resetPasswordEncryption;
    }

    public void setResetPasswordEncryption(String resetPasswordEncryption) {
        this.resetPasswordEncryption = resetPasswordEncryption;
    }

    private String getRandomColor() {
        ArrayList<String> colorList = new ArrayList<String>();
        colorList.add("#1991EB");
        colorList.add("#F85359");
        colorList.add("#6B47DB");
        colorList.add("#F9BF3B");
        colorList.add("#0747A6");
        colorList.add("#34495E");
        colorList.add("#2ECC71");
        colorList.add("#DB0A5B");
        colorList.add("#674172");
        colorList.add("#4ECDC4");
        colorList.add("#F39C12");
        colorList.add("#1C2227");
        colorList.add("#446CB3");
        colorList.add("#D2527F");
        colorList.add("#E87E04");
        colorList.add("#019875");
        colorList.add("#6C7A89");
        colorList.add("#9A12B3");
        colorList.add("#3A539B");
        colorList.add("#1E824C");
        colorList.add("#C6A21A");
        colorList.add("#336E7B");
        colorList.add("#C0392B");
        colorList.add("#013243");
        Random rand = new Random();
        return (String)colorList.get(rand.nextInt(colorList.size()));
    }

    public String log() {
        StringBuilder info = new StringBuilder();
        info.append("User {");
        info.append("id:");
        info.append(this.getId());
        info.append(",");
        info.append("userName:");
        info.append(this.getUserName());
        info.append(",");
        info.append("fullName:");
        info.append(this.getFullName());
        info.append(",");
        info.append("email:");
        info.append(this.getEmail());
        info.append(",");
        info.append("isAdmin:");
        info.append(this.getIsAdmin());
        info.append(",");
        info.append("LDAP:");
        info.append(this.isLdap());
        info.append(",");
        info.append("tenant:");
        info.append(this.getTenant());
        info.append(",");
        info.append("trialDaysLeft:");
        info.append(this.getTrialDaysLeft());
        info.append(",");
        info.append("createdOn:");
        info.append(this.getCreatedOn());
        info.append(",");
        info.append("accessRoles:{");
        if (PropertyValidator.isValid((Collection)this.getAccessRoles())) {
            for (WorkSpaceAccessRole workSpaceAccessRole : this.getAccessRoles()) {
                info.append("{");
                info.append("id:");
                info.append(workSpaceAccessRole.getId());
                info.append(",");
                if (PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) {
                    info.append("workSpace:");
                    info.append("{");
                    info.append("id:");
                    info.append(workSpaceAccessRole.getWorkSpace().getId());
                    info.append(",");
                    info.append("title:");
                    info.append(workSpaceAccessRole.getWorkSpace().getTitle());
                    info.append("}");
                    info.append(",");
                }
                if (PropertyValidator.isValid((Object)workSpaceAccessRole.getGroup())) {
                    info.append("isGroup:");
                    info.append(true);
                    info.append(",");
                    info.append("isLDAP:");
                    info.append(workSpaceAccessRole.getGroup().isLdap());
                    info.append(",");
                    info.append("Title:");
                    info.append(workSpaceAccessRole.getGroup().getTitle());
                    info.append(",");
                } else {
                    info.append("isGroup:");
                    info.append(false);
                    info.append(",");
                    info.append("isLDAP:");
                    info.append(workSpaceAccessRole.getUser().isLdap());
                    info.append(",");
                    info.append("Title:");
                    info.append(workSpaceAccessRole.getUser().getUserName());
                    info.append(",");
                }
                info.append("Roles:{");
                if (PropertyValidator.isValid((Collection)workSpaceAccessRole.getRoles())) {
                    for (Role role : workSpaceAccessRole.getRoles()) {
                        info.append("id:");
                        info.append(role.getId());
                        info.append(",");
                        info.append("id:");
                        info.append(role.getTitle());
                    }
                }
                info.append("}");
                info.append(",");
                info.append("}");
            }
            info.append("}");
        }
        info.append("groups:{");
        if (PropertyValidator.isValid((Collection)this.getGroups())) {
            for (String group : this.getGroups()) {
                info.append(group);
                info.append(",");
            }
            info.append("}");
        }
        info.append("}");
        return info.toString();
    }

    public String toString() {
        1 builder = new /* Unavailable Anonymous Inner Class!! */;
        return builder.toString();
    }

    public boolean isUserInCompany(String cid) {
        boolean found = false;
        if (PropertyValidator.isValid((Collection)this.userCompanies)) {
            for (int i = 0; i < this.userCompanies.size(); ++i) {
                if (((UserCompany)this.userCompanies.get(i)).getCompany() == null || !cid.equals(((UserCompany)this.userCompanies.get(i)).getCompany().getId())) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public Integer getSkipTutorial() {
        return this.skipTutorial;
    }

    public void setSkipTutorial(Integer skipTutorial) {
        this.skipTutorial = skipTutorial;
    }

    public boolean isFilledUpSurvey() {
        return this.filledUpSurvey;
    }

    public void setFilledUpSurvey(boolean filledUpSurvey) {
        this.filledUpSurvey = filledUpSurvey;
    }

    public Boolean getIsTemp() {
        return this.isTemp;
    }

    public void setIsTemp(Boolean isTemp) {
        this.isTemp = isTemp;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public boolean isDebug() {
        if (UserContextUtil.getUserContext() != null) {
            return UserContextUtil.getUserContext().isDebug();
        }
        return false;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isRequireMFACode() {
        return this.requireMFACode;
    }

    public void setRequireMFACode(boolean requireMFACode) {
        this.requireMFACode = requireMFACode;
    }

    public String getMfaRecCode() {
        return this.mfaRecCode;
    }

    public void setMfaRecCode(String code) {
        this.mfaRecCode = code;
    }

    public String getMfaCode() {
        return this.mfaCode;
    }

    public void setrecoveryMFACode(String recoveryCode) {
        this.recoveryMFACode = recoveryCode;
    }

    public String getrecoveryMFACode() {
        return this.recoveryMFACode;
    }

    public void setMfaCode(String mfaCode) {
        this.mfaCode = mfaCode;
    }

    public String getMfaCodeSec() {
        return this.mfaCodeSec;
    }

    public void setMfaCodeSec(String mfaCodeSec) {
        this.mfaCodeSec = mfaCodeSec;
    }

    public List<PasswordHistory> getPasswordHistory() {
        return this.passwordHistory;
    }

    public void setPasswordHistory(List<PasswordHistory> passwordHistory) {
        this.passwordHistory = passwordHistory;
    }

    public int getTressPassCount() {
        return this.tressPassCount;
    }

    public void setTressPassCount(int tressPassCount) {
        this.tressPassCount = tressPassCount;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String getIntercomUserHash() {
        return this.intercomUserHash;
    }

    public void setIntercomUserHash(String intercomUserHash) {
        this.intercomUserHash = intercomUserHash;
    }

    public String getImgPath() {
        return this.imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public Boolean getIsValid() {
        if (this.userType == UserType.KENDIS) {
            boolean valid;
            boolean bl = valid = !this.isArchive();
            if (valid && UserContextUtil.getUserContext() != null) {
                String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
                return this.isUserInCompany(loggedinCompanyId);
            }
            return valid;
        }
        return this.getRowStatus() == 0;
    }

    public String getInstallationId() {
        return this.installationId;
    }

    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public List<String> getExternalReferenceGroups() {
        return this.externalReferenceGroups;
    }

    public void setExternalReferenceGroups(List<String> externalReferenceGroups) {
        this.externalReferenceGroups = externalReferenceGroups;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Boolean getIsGuest() {
        return this.isGuest;
    }

    public void setIsGuest(Boolean isGuest) {
        this.isGuest = isGuest;
    }

    public String getSamlUserId() {
        return this.samlUserId;
    }

    public void setSamlUserId(String samlUserId) {
        this.samlUserId = samlUserId;
    }

    public boolean getIsGuestUserConversion() {
        return this.isGuestUserConversion;
    }

    public void setGuestUserConversion(boolean guestUserConversion) {
        this.isGuestUserConversion = guestUserConversion;
    }
}

