/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkFlowItemType;
import com.viztrend.safe.utils.DBUtils;
import java.util.HashMap;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class Status
extends BaseEntity {
    @PushField
    private String title;
    private String color;
    @DBRef(lazy=true)
    private WorkFlow workFlow;
    @DBRef(lazy=true)
    private WorkFlowItemType workFlowItemType;
    @PushField
    private String category;
    private String itemType;
    private String jiraProjKey;
    private String jiraIssueTypeId;
    private String jiraStatusId;
    private String jiraStatusCatId;
    private String jiraStatusOriginalCategory;
    private boolean updated;
    private String tfsId;
    private String tfsProject;
    private String tfsProjectId;
    private String sessionId;
    private String solutionId;
    private String almId;
    private Boolean isDeleted;
    private Boolean isDeletedFromAlm;
    private Boolean syncRequired;
    private HashMap<String, String> categoryMappingByCollectionId;

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        result = 31 * result + (this.jiraIssueTypeId == null ? 0 : this.jiraIssueTypeId.hashCode());
        result = 31 * result + (this.jiraProjKey == null ? 0 : this.jiraProjKey.hashCode());
        result = 31 * result + (this.jiraStatusId == null ? 0 : this.jiraStatusId.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Status)) {
            return false;
        }
        Status other = (Status)obj;
        if (this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType)) {
            return false;
        }
        if (this.jiraIssueTypeId == null ? other.jiraIssueTypeId != null : !this.jiraIssueTypeId.equals(other.jiraIssueTypeId)) {
            return false;
        }
        if (this.jiraProjKey == null ? other.jiraProjKey != null : !this.jiraProjKey.equals(other.jiraProjKey)) {
            return false;
        }
        if (this.jiraStatusId == null ? other.jiraStatusId != null : !this.jiraStatusId.equals(other.jiraStatusId)) {
            return false;
        }
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    public HashMap<String, ? super Object> toSimpleObject() {
        HashMap<String, String> rowData = new HashMap<String, String>();
        rowData.put("id", this.id);
        rowData.put("title", this.title);
        rowData.put("category", this.category);
        return rowData;
    }

    public Status() {
    }

    public Status(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.title = object.getString("title");
        this.color = object.getString("color");
        this.category = object.getString("category");
        this.jiraProjKey = object.getString("jiraProjKey");
        this.jiraIssueTypeId = object.getString("jiraIssueTypeId");
        this.jiraStatusId = object.getString("jiraStatusId");
        this.jiraStatusCatId = object.getString("jiraStatusCatId");
        this.jiraStatusOriginalCategory = object.getString("jiraStatusOriginalCategory");
        this.tfsId = object.getString("tfsId");
        this.tfsProject = object.getString("tfsProject");
        this.tfsProjectId = object.getString("tfsProjectId");
        this.sessionId = object.getString("sessionId");
        this.solutionId = object.getString("solutionId");
        this.almId = object.getString("almId");
        this.tenant = object.getString("tenant");
        this.rowStatus = object.containsField("rowStatus") ? Integer.valueOf(object.getInt("rowStatus")) : null;
    }

    public Status(String id) {
        super(id);
    }

    public Status(String id, String title) {
        super(id);
        this.title = title;
    }

    public Status(Status st) {
        this.setJiraProjKey(st.getJiraProjKey());
        this.setJiraIssueTypeId(st.getJiraIssueTypeId());
        this.setJiraStatusCatId(st.getJiraStatusCatId());
        this.setJiraStatusId(st.getJiraStatusId());
        this.setTitle(st.getTitle());
        this.setColor(st.getColor());
        this.setCategory(st.getCategory());
    }

    public Status(DBObject vo) {
        super(String.valueOf(vo.get("_id")));
        this.title = (String)vo.get("title");
        this.color = (String)vo.get("color");
        this.category = (String)vo.get("category");
        this.itemType = (String)vo.get("itemType");
        this.jiraProjKey = (String)vo.get("jiraProjKey");
        this.jiraIssueTypeId = (String)vo.get("jiraIssueTypeId");
        this.jiraStatusId = (String)vo.get("jiraStatusId");
        this.jiraStatusCatId = (String)vo.get("jiraStatusCatId");
        this.tfsProject = (String)vo.get("tfsProject");
        this.tfsProjectId = (String)vo.get("tfsProjectId");
        this.sessionId = (String)vo.get("sessionId");
    }

    public Status(String title, String color, String category, ItemType itemType, String jiraProjKey, String jiraIssueTypeId, String jiraStatusId, String jiraStatusCatId) {
        this.title = title;
        this.color = color;
        this.category = category;
        this.jiraProjKey = jiraProjKey;
        this.jiraIssueTypeId = jiraIssueTypeId;
        this.jiraStatusId = jiraStatusId;
        this.jiraStatusCatId = jiraStatusCatId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Status [");
        if (this.title != null) {
            builder.append("title=");
            builder.append(this.title);
            builder.append(", ");
        }
        if (this.itemType != null) {
            builder.append("itemType=");
            builder.append(this.itemType);
            builder.append(", ");
        }
        if (this.category != null) {
            builder.append("category=");
            builder.append(this.category);
            builder.append(", ");
        }
        if (this.jiraProjKey != null) {
            builder.append("jiraProjKey=");
            builder.append(this.jiraProjKey);
            builder.append(", ");
        }
        if (this.jiraIssueTypeId != null) {
            builder.append("jiraIssueTypeId=");
            builder.append(this.jiraIssueTypeId);
            builder.append(", ");
        }
        if (this.jiraStatusId != null) {
            builder.append("jiraStatusId=");
            builder.append(this.jiraStatusId);
            builder.append(", ");
        }
        if (this.jiraStatusCatId != null) {
            builder.append("jiraStatusCatId=");
            builder.append(this.jiraStatusCatId);
            builder.append(", ");
        }
        if (this.color != null) {
            builder.append("color=");
            builder.append(this.color);
        }
        builder.append("]");
        return builder.toString();
    }

    public Status(String id, String title, String color) {
        super(id);
        this.title = title;
        this.color = color;
    }

    public Status(String id, String title, String color, String category) {
        super(id);
        this.title = title;
        this.color = color;
        this.category = category;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getJiraProjKey() {
        return this.jiraProjKey;
    }

    public void setJiraProjKey(String jiraProjKey) {
        this.jiraProjKey = jiraProjKey;
    }

    public String getJiraIssueTypeId() {
        return this.jiraIssueTypeId;
    }

    public void setJiraIssueTypeId(String jiraIssueTypeId) {
        this.jiraIssueTypeId = jiraIssueTypeId;
    }

    public String getJiraStatusId() {
        return this.jiraStatusId;
    }

    public void setJiraStatusId(String jiraStatusId) {
        this.jiraStatusId = jiraStatusId;
    }

    public String getJiraStatusCatId() {
        return this.jiraStatusCatId;
    }

    public void setJiraStatusCatId(String jiraStatusCatId) {
        this.jiraStatusCatId = jiraStatusCatId;
    }

    public WorkFlow getWorkFlow() {
        return this.workFlow;
    }

    public void setWorkFlow(WorkFlow workflow) {
        this.workFlow = workflow;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public WorkFlowItemType getWorkFlowItemType() {
        return this.workFlowItemType;
    }

    public void setWorkFlowItemType(WorkFlowItemType workFlowItemType) {
        this.workFlowItemType = workFlowItemType;
    }

    public String getTfsProject() {
        return this.tfsProject;
    }

    public void setTfsProject(String tfsProject) {
        this.tfsProject = tfsProject;
    }

    public String getTfsProjectId() {
        return this.tfsProjectId;
    }

    public void setTfsProjectId(String tfsProjectId) {
        this.tfsProjectId = tfsProjectId;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.solutionId = solutionId;
    }

    public String getJiraStatusOriginalCategory() {
        return this.jiraStatusOriginalCategory;
    }

    public void setJiraStatusOriginalCategory(String jiraStatusOriginalCategory) {
        this.jiraStatusOriginalCategory = jiraStatusOriginalCategory;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public String getTfsId() {
        return this.tfsId;
    }

    public void setTfsId(String tfsId) {
        this.tfsId = tfsId;
    }

    public Boolean getIsDeletedFromAlm() {
        return this.isDeletedFromAlm;
    }

    public void setIsDeletedFromAlm(Boolean isDeletedFromAlm) {
        this.isDeletedFromAlm = isDeletedFromAlm;
    }

    public String getAlmId() {
        return this.almId;
    }

    public void setAlmId(String almId) {
        this.almId = almId;
    }

    public Boolean getSyncRequired() {
        return this.syncRequired;
    }

    public void setSyncRequired(Boolean syncRequired) {
        this.syncRequired = syncRequired;
    }

    public HashMap<String, String> getCategoryMappingByCollectionId() {
        return this.categoryMappingByCollectionId;
    }

    public void setCategoryMappingByCollectionId(HashMap<String, String> categoryMappingByCollectionId) {
        this.categoryMappingByCollectionId = categoryMappingByCollectionId;
    }
}

