/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.mongodb.BasicDBObject;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.ObjectiveValue;
import com.viztrend.safe.persistence.entity.PiSite;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class SessionBoard
extends BaseEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionBoard.class);
    private static final long serialVersionUID = -2090588755867450749L;
    private String status;
    private Date creationDate;
    @DBRef
    private Session session;
    @DBRef
    private State state;
    public static String OPEN = "Open";
    public static String CLOSED = "Closed";
    private String parentBoard;
    @DBRef
    private List<Container> containers;
    @DBRef
    private List<Team> teams;
    private String[] teamSequence;
    @Transient
    private List<Item> items;
    @Transient
    private List<SessionBoard> linkedBoards;
    @Transient
    private List<TeamSprintVelocity> teamSprintVelocities;
    @Transient
    private AlmAccount almAccount;
    @Transient
    private Integer serverTimeZone;
    @Transient
    private String kendisBaseUrl;
    @Transient
    private List<User> users;
    private String level1;
    private String level2;
    private List<String> objectiveIds;
    private HashMap<String, Objective> objectivesMap;
    private Integer noticationCounter;
    @Transient
    private Boolean isResyncing = null;
    @Transient
    private Boolean starred = Boolean.FALSE;
    @Transient
    private Double sequence;
    private Boolean tzEnabled = Boolean.FALSE;
    private PiSite tzSite;
    private String tzStartTime;
    private String tzEndTime;
    private Long tzStartTimeDiff;
    private Long tzEndTimeDiff;
    @Transient
    public String localZone;
    private String scheduleType;
    private List<String> userListForSprintReportEmail;
    @PushField
    protected Date stateChangeDate;

    public SessionBoard() {
    }

    public SessionBoard(String id, Session session) {
        this.id = id;
        Session boardSession = new Session();
        boardSession.setId(session.getId());
        boardSession.setTitle(session.getTitle());
        this.session = boardSession;
    }

    public SessionBoard(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.status = object.getString("status");
        this.session = new Session((BasicDBObject)object.get("session"));
    }

    public SessionBoard(SessionBoard sb) {
        this.status = sb.status;
        this.creationDate = sb.creationDate;
        this.session = sb.session;
        this.parentBoard = sb.parentBoard;
        this.containers = sb.containers;
        this.teams = sb.teams;
        this.teamSequence = sb.teamSequence;
        this.items = sb.items;
        this.linkedBoards = sb.linkedBoards;
        this.teamSprintVelocities = sb.teamSprintVelocities;
        this.almAccount = sb.almAccount;
        this.serverTimeZone = sb.serverTimeZone;
        this.kendisBaseUrl = sb.kendisBaseUrl;
        this.level1 = sb.level1;
        this.level2 = sb.level2;
        this.objectiveIds = sb.objectiveIds;
        this.objectivesMap = sb.objectivesMap;
        this.noticationCounter = sb.noticationCounter;
        this.isResyncing = sb.isResyncing;
    }

    public SessionBoard(String id, String parentBoard, Date creationDate, State state, Date createdOn, String createdBy) {
        super(id);
        this.parentBoard = parentBoard;
        this.creationDate = creationDate;
        this.state = state;
        this.createdOn = createdOn;
        this.createdBy = createdBy;
    }

    public SessionBoard(String id, Session session, List<Container> containers, List<Team> teams, State state, Date creationDate, Date createdOn, String createdBy, Boolean starred) {
        super(id);
        this.creationDate = creationDate;
        this.state = new State(state.getId(), state.getTitle(), state.getActionNarrative(), state.getDoneNarrative());
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.starred = starred;
        this.session = new Session(session.getId(), session.getTitle(), session.getActiveSessionBoard(), session.getStartDate(), session.getEndDate(), session.getPlanningStartDate(), session.getPlanningEndDate(), session.getWorkSpace(), session.getCreatedOn(), session.getCreatedOn(), session.getCreatedBy(), Integer.valueOf(session.getRowStatus()), session.getLoadOldObjectivesView(), session.getSequence(), session.getLoadNewStructureMilestones(), session.getRiskRegister());
        if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
            this.session.setAlmType("tfs");
        }
        this.teams = new ArrayList();
        for (Team team : teams) {
            this.teams.add(new Team(team.getId(), team.getTitle()));
        }
        this.containers = new ArrayList();
        for (Container container : containers) {
            this.containers.add(new Container(container.getId()));
        }
        this.isResyncing = null;
        this.kendisBaseUrl = null;
        this.level1 = null;
        this.level2 = null;
        this.serverTimeZone = null;
        this.status = null;
        this.teamSequence = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionBoard other = (SessionBoard)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public void copyObjectives(Map<String, String> newItemsIdsMapByOldId) {
        if (PropertyValidator.isValid((Object)this.getObjectivesMap())) {
            HashMap oMap = this.getObjectivesMap();
            Set keys = oMap.keySet();
            for (String k : keys) {
                List ovs;
                Objective tempO = (Objective)oMap.get(k);
                if (k == null) {
                    oMap.remove(k);
                    if (tempO.getId() == null) {
                        tempO.setId(ObjectId.get().toString());
                    }
                    oMap.put(tempO.getId(), tempO);
                    if (!PropertyValidator.isValid((Collection)this.getObjectiveIds())) {
                        this.setObjectiveIds(new ArrayList());
                    }
                    this.getObjectiveIds().add(tempO.getId());
                }
                if (!PropertyValidator.isValid((Collection)(ovs = tempO.getValues()))) continue;
                for (int i = 0; i < ovs.size(); ++i) {
                    List ids = ((ObjectiveValue)ovs.get(i)).getItemIds();
                    HashMap externalIds = new HashMap();
                    if (PropertyValidator.isValid((Collection)ids)) {
                        for (int j = 0; j < ids.size(); ++j) {
                            String oldId = (String)ids.get(j);
                            String newId = newItemsIdsMapByOldId.get(ids.get(j));
                            if (newId != null) {
                                ids.set(j, newId);
                                if (((ObjectiveValue)ovs.get(i)).getExternalItemIds() == null || ((ObjectiveValue)ovs.get(i)).getExternalItemIds().get(oldId) == null) continue;
                                externalIds.put(newId, ((ObjectiveValue)ovs.get(i)).getExternalItemIds().get(oldId));
                                continue;
                            }
                            if (((ObjectiveValue)ovs.get(i)).getExternalItemIds() == null || ((ObjectiveValue)ovs.get(i)).getExternalItemIds().get(oldId) == null) continue;
                            ids.set(j, oldId);
                            externalIds.put(oldId, ((ObjectiveValue)ovs.get(i)).getExternalItemIds().get(oldId));
                        }
                    }
                    ((ObjectiveValue)ovs.get(i)).setExternalItemIds(externalIds);
                }
            }
        }
    }

    public Container checkActiveSprint() {
        Long date = new Date().getTime();
        Container active = null;
        Container previous = null;
        for (int index = 0; index < this.containers.size(); ++index) {
            Container container = (Container)this.containers.get(index);
            Long spStartDate = container.getStartDate().getTime();
            Long spEndDate = container.getEndDate().getTime();
            if (date < spStartDate || date > spEndDate || PropertyValidator.isValid(active)) continue;
            active = container;
            if (PropertyValidator.isValid(previous) || index <= 0) continue;
            previous = (Container)this.containers.get(index - 1);
        }
        return active;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public void setTeams(List<Team> teams) {
        this.teams = teams;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public SessionBoard(String id) {
        this.id = id;
    }

    public AlmAccount getAlmAccount() {
        return this.almAccount;
    }

    public void setAlmAccount(AlmAccount almAccount) {
        this.almAccount = almAccount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getParentBoard() {
        return this.parentBoard;
    }

    public void setParentBoard(String parentBoard) {
        this.parentBoard = parentBoard;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getLevel1() {
        return this.level1;
    }

    public void setLevel1(String level1) {
        this.level1 = level1;
    }

    public String getLevel2() {
        return this.level2;
    }

    public void setLevel2(String level2) {
        this.level2 = level2;
    }

    public List<SessionBoard> getLinkedBoards() {
        return this.linkedBoards;
    }

    public void setLinkedBoards(List<SessionBoard> linkedBoards) {
        this.linkedBoards = linkedBoards;
    }

    public List<TeamSprintVelocity> getTeamSprintVelocities() {
        return this.teamSprintVelocities;
    }

    public void setTeamSprintVelocities(List<TeamSprintVelocity> teamSprintVelocities) {
        this.teamSprintVelocities = teamSprintVelocities;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Integer getServerTimeZone() {
        return this.serverTimeZone;
    }

    public void setServerTimeZone(Integer serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public String[] getTeamSequence() {
        return this.teamSequence;
    }

    public void setTeamSequence(String[] teamSequence) {
        this.teamSequence = teamSequence;
    }

    public String getKendisBaseUrl() {
        return this.kendisBaseUrl;
    }

    public void setKendisBaseUrl(String kendisBaseUrl) {
        this.kendisBaseUrl = kendisBaseUrl;
    }

    public List<String> getObjectiveIds() {
        return this.objectiveIds;
    }

    public void setObjectiveIds(List<String> objectiveIds) {
        this.objectiveIds = objectiveIds;
    }

    public HashMap<String, Objective> getObjectivesMap() {
        return this.objectivesMap;
    }

    public void setObjectivesMap(HashMap<String, Objective> objectivesMap) {
        this.objectivesMap = objectivesMap;
    }

    public Boolean getIsResyncing() {
        return this.isResyncing;
    }

    public void setIsResyncing(Boolean isResyncing) {
        this.isResyncing = isResyncing;
    }

    public Boolean getStarred() {
        return this.starred;
    }

    public void setStarred(Boolean starred) {
        this.starred = starred;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public Integer getNoticationCounter() {
        return this.noticationCounter;
    }

    public void setNoticationCounter(Integer noticationCounter) {
        this.noticationCounter = noticationCounter;
    }

    public List<Container> calcSchedulerTime(String clientZone, List<Container> containers) {
        String toZoneId = PropertyValidator.isValid((Object)this.getTzSite()) ? this.getTzSite().getTimeZone() : TimeZone.getDefault().getID();
        String sTime = PropertyValidator.isValid((Object)this.getTzStartTime()) ? this.getTzStartTime() : "18:15";
        String eTime = PropertyValidator.isValid((Object)this.getTzEndTime()) ? this.getTzEndTime() : "18:00";
        Long sDiff = (PropertyValidator.isValid((Object)this.getTzStartTimeDiff()) ? this.getTzStartTimeDiff() : 0L) * 86400000L;
        Long eDiff = (PropertyValidator.isValid((Object)this.getTzEndTimeDiff()) ? this.getTzEndTimeDiff() : 0L) * 86400000L;
        ArrayList<Container> sprints = null;
        boolean sameZone = false;
        if (TimeZone.getDefault().getID().equals(toZoneId)) {
            sameZone = true;
        }
        SimpleDateFormat ddmmyyyy = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        ddmmyyyy.setTimeZone(TimeZone.getTimeZone(toZoneId));
        for (Container container : containers) {
            try {
                if (container.getStartDate() == null || container.getEndDate() == null) continue;
                if (Boolean.TRUE.equals(this.getTzEnabled())) {
                    String clientTime = ddmmyyyy.format(container.getStartDate().getTime());
                    if (!sameZone) {
                        clientTime = clientTime.split(" ")[0] + " " + sTime;
                    }
                    Date date = ddmmyyyy.parse(clientTime);
                    Long millis = 0L;
                    container.setStartTime(Long.valueOf(date.getTime() + millis + sDiff));
                    clientTime = ddmmyyyy.format(container.getEndDate());
                    if (!sameZone) {
                        clientTime = clientTime.split(" ")[0] + " " + eTime;
                    }
                    date = ddmmyyyy.parse(clientTime);
                    millis = 0L;
                    container.setEndTime(Long.valueOf(date.getTime() + millis + eDiff));
                } else {
                    container.setStartTime(null);
                    container.setEndTime(null);
                }
                if (sprints == null) {
                    sprints = new ArrayList<Container>();
                }
                sprints.add(container);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return sprints;
    }

    public Boolean getTzEnabled() {
        return this.tzEnabled;
    }

    public void setTzEnabled(Boolean tzEnabled) {
        this.tzEnabled = tzEnabled;
    }

    public PiSite getTzSite() {
        return this.tzSite;
    }

    public void setTzSite(PiSite tzSite) {
        this.tzSite = tzSite;
    }

    public String getTzStartTime() {
        return this.tzStartTime;
    }

    public void setTzStartTime(String tzStartTime) {
        this.tzStartTime = tzStartTime;
    }

    public String getTzEndTime() {
        return this.tzEndTime;
    }

    public void setTzEndTime(String tzEndTime) {
        this.tzEndTime = tzEndTime;
    }

    public Long getTzStartTimeDiff() {
        return this.tzStartTimeDiff;
    }

    public void setTzStartTimeDiff(Long tzStartTimeDiff) {
        this.tzStartTimeDiff = tzStartTimeDiff;
    }

    public Long getTzEndTimeDiff() {
        return this.tzEndTimeDiff;
    }

    public void setTzEndTimeDiff(Long tzEndTimeDiff) {
        this.tzEndTimeDiff = tzEndTimeDiff;
    }

    public String getLocalZone() {
        return this.localZone;
    }

    public void setLocalZone(String localZone) {
        this.localZone = localZone;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public List<String> getUserListForSprintReportEmail() {
        return this.userListForSprintReportEmail;
    }

    public void setUserListForSprintReportEmail(List<String> userListForSprintReportEmail) {
        this.userListForSprintReportEmail = userListForSprintReportEmail;
    }

    public Date getStateChangeDate() {
        return this.stateChangeDate;
    }

    public void setStateChangeDate(Date stateChangeDate) {
        this.stateChangeDate = stateChangeDate;
    }
}

