/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.mongodb.BasicDBObject;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.enums.EnumJiraContainer;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.FieldMapping;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemParent;
import com.viztrend.safe.persistence.entity.Questionnaire;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.ScoreCard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.TeamSetting;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class Session
extends BaseEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(Session.class);
    private static final long serialVersionUID = 3463411353641727135L;
    private Double sequence = new Double(System.nanoTime() / 100000L);
    private String title;
    private String prefix;
    private String prefixColor;
    private String description;
    private String jiraBaseURL;
    private String parentItem = "Feature";
    private String childItem = "User story";
    private String parentItems = "Features";
    private String childItems = "User stories";
    private String teamLabel = "Team";
    private String teamsLabel = "Teams";
    private String sprintLabel = "Sprint";
    private String sprintsLabel = "Sprints";
    private String parentItemColor;
    private String childItemColor;
    private String parentItemTextColor;
    private String childItemTextColor;
    private String dependencyPrefix;
    private ArrayList<Map<String, String>> itemsAddedFromKanban;
    private Boolean hidePiJourney = true;
    private Boolean isJiraColorsEnabled = Boolean.FALSE;
    private Boolean newSystemLinkTypes = Boolean.FALSE;
    @DBRef
    private WorkFlow itemWorkFlow;
    @DBRef
    private RiskRegister riskRegister;
    @DBRef
    private List<Questionnaire> confidenceVoteSurvey;
    @DBRef
    private WorkFlow subItemWorkFlow;
    @DBRef
    private WorkFlow dependencyWorkFlow;
    @DBRef
    private StateScheme stateScheme;
    @DBRef
    private List<AlmConfigurations> almConfigurations;
    @DBRef
    private TFSAlmConfigurations tfsAlmConfigurations;
    @DBRef
    private ScoreCard scoreCard;
    private Boolean wsjfEnabled = Boolean.FALSE;
    private Boolean wsjfWithMappingEnabled = Boolean.FALSE;
    private Boolean okrEnabled = Boolean.FALSE;
    private Boolean uncommittedObjEnabled = Boolean.TRUE;
    private Boolean wsjfAlmEnabled = Boolean.FALSE;
    private Boolean wsjfKendisEnabled = Boolean.FALSE;
    private String wsjfAlmFieldKey;
    private Boolean setWsjfAlmFieldForAllProjects = Boolean.FALSE;
    private Boolean almEnabled = Boolean.FALSE;
    private Boolean useEnabler = Boolean.FALSE;
    @Transient
    private String almType;
    private String itemLinkStatusDependentOn = "-1";
    private Boolean reOpenDependencyIfItemReOpen = Boolean.FALSE;
    private Boolean ignoreUpdateIfManualResolvedForItem = Boolean.TRUE;
    private String subItemLinkStatusDependentOn = "-1";
    private Boolean reOpenDependencyIfSubItemReOpen = Boolean.FALSE;
    private Boolean ignoreUpdateIfManualResolvedForSubItem = Boolean.TRUE;
    private Boolean dependencyReceiveLimit = Boolean.TRUE;
    private Boolean originIdSynched = Boolean.FALSE;
    private String enablerColor;
    private String sessionType;
    private String jiraContainer = EnumJiraContainer.SPRINT.getCode();
    private String activeSessionBoard;
    private List<Map<String, Object>> inspectAndAdaptBoards;
    private String inspectAndAdaptSessionDateTime;
    private List<String> cartTypeIds;
    private Map<String, Object> inspectAndAdaptSetting;
    @Transient
    private State activeState;
    private Date startDate;
    private Date endDate;
    private Date planningStartDate;
    private Date planningEndDate;
    private String piNumber;
    private Boolean teamFieldEnable = Boolean.FALSE;
    private String teamFieldTeamName;
    private String teamFieldTeamRefrence;
    private String milestoneSchemeId;
    private String phaseSchemeId;
    private List<String> jiraLinkTypes;
    private String jiraFeatureParentLinkType;
    private String jiraFeatureParentIssueType;
    private Set<String> jiraLinkTypesCached;
    private String objectivePrefix;
    @DBRef
    private WorkSpace workSpace;
    private String enablerItem = "Enabler";
    private Boolean jiraSynapseRTEnabled = Boolean.FALSE;
    private Boolean readOnlyWithOutALMProfile = Boolean.FALSE;
    private Boolean jiraDependencyEnabled = Boolean.FALSE;
    private Boolean kendisLinkTypeDisabled = Boolean.FALSE;
    private Boolean jiraFeatureParentEnabled = Boolean.FALSE;
    private Boolean areaPathDisabled = Boolean.FALSE;
    private Boolean flaggedFieldEnabled = Boolean.FALSE;
    private Boolean kendisFlaggedFieldEnabled = Boolean.FALSE;
    private Boolean jiraFlaggedFieldEnabled = Boolean.FALSE;
    private Boolean jiraSharedSprintFieldEnabled = Boolean.FALSE;
    private Boolean startSprintWebhookEnabled = Boolean.TRUE;
    private Boolean endSprintWebhookEnabled = Boolean.TRUE;
    private Boolean bucketEnabled = Boolean.FALSE;
    private Boolean kendisOnlyCreateEnabled = Boolean.TRUE;
    private Integer syncTimer = 5;
    private Boolean hideMilestonesBar;
    private String milestoneWidgetHeader = "ID";
    private ItemJiraFieldMap jiraSharedSprintField;
    private ItemJiraFieldMap jiraFlaggedField;
    private Boolean additionalFieldsEnabled;
    private String additionalFieldsJiraTimeZone;
    private List<String> additionalFieldsTypesFeature;
    private List<String> additionalFieldsTypesUserStory;
    private List<ItemJiraFieldMap> fieldsValuesForColors;
    private List<ItemJiraFieldMap> additionalFieldsValuesFeature;
    private List<ItemJiraFieldMap> additionalFieldsValuesUserStory;
    @Transient
    private List<String> additionalFieldsIdsFeature;
    @Transient
    private List<String> additionalFieldsIdsUserStory;
    private ItemParent itemParent;
    private Boolean notifyJiraUsers = Boolean.TRUE;
    private Boolean useObjectives = Boolean.TRUE;
    private HashMap<String, Boolean> jiraButtons = new HashMap();
    @Transient
    private List<JiraIssueLinkType> jiraIssueLinkTypes;
    @Transient
    private List<JiraIssueType> jiraIssueTypes;
    private Map<String, IssueType> buckets;
    private List<TeamSetting> teamSettings;
    private String startDateAction;
    private String lineArrowDirection = "Successor";
    private String reverseDependencyDirection = "Successor";
    private Boolean loadOldObjectivesView = true;
    private Boolean loadNewStructureMilestones = false;
    private Date lastChangesSyncTime;
    @DBRef
    private List<State> autoUpdateEnabledStates = null;
    private HashMap<String, String> ignoreItemsInResync;
    @DBRef
    private FieldsLayout kendisOnlyLayout;
    private boolean disabledForDashboardListing = Boolean.TRUE;
    private boolean autoFillStartEndDate = false;
    private List<String> excludeTfsStatuses;
    private List<String> excludeTfsItemTypes;
    private Boolean resyncRequired = Boolean.FALSE;
    @Transient
    public Boolean loggedUserHasAlm = false;

    public Session() {
    }

    public Session(String id) {
        super(id);
    }

    public Session(String id, String title) {
        super(id);
        this.title = title;
    }

    public Session(String id, String title, String parentItem, String childItem) {
        super(id);
        this.title = title;
        this.parentItem = parentItem;
        this.childItem = childItem;
    }

    public Session(BasicDBObject object) {
        com.mongodb.DBRef ref;
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.title = object.getString("title");
        this.almEnabled = object.getBoolean("almEnabled");
        this.parentItem = object.getString("parentItem");
        this.childItem = object.getString("childItem");
        this.jiraBaseURL = object.getString("jiraBaseURL");
        if (object.containsField("activeSessionBoard")) {
            this.activeSessionBoard = object.getString("activeSessionBoard");
        }
        if (object.containsField("rowStatus")) {
            this.rowStatus = object.getInt("rowStatus");
        }
        if (object.containsField("loadOldObjectivesView")) {
            this.loadOldObjectivesView = object.getBoolean("loadOldObjectivesView");
        }
        if (object.containsField("sequence")) {
            this.sequence = object.getDouble("sequence");
        }
        BasicDBObject almConfigObj = DBUtils.getBasicDBObjectFromDBObject((Object)object.get("almConfigurations"));
        BasicDBObject tfsAlmConfigObj = DBUtils.getBasicDBObjectFromDBObject((Object)object.get("tfsAlmConfigurations"));
        if (!DBUtils.isEmptyObject((Object)almConfigObj)) {
            AlmConfigurations almConfig = new AlmConfigurations(almConfigObj);
            if (!DBUtils.isEmptyObject((Object)almConfig)) {
                this.almConfigurations = new ArrayList();
                this.almConfigurations.add(almConfig);
            }
        } else if (!DBUtils.isEmptyObject((Object)tfsAlmConfigObj)) {
            this.tfsAlmConfigurations = new TFSAlmConfigurations(tfsAlmConfigObj);
        }
        if (!DBUtils.isEmptyObject((Object)object.getBoolean("jiraFlaggedFieldEnabled"))) {
            this.jiraFlaggedFieldEnabled = object.getBoolean("jiraFlaggedFieldEnabled");
        }
        if (!DBUtils.isEmptyObject((Object)object.getBoolean("kendisFlaggedFieldEnabled"))) {
            this.kendisFlaggedFieldEnabled = object.getBoolean("kendisFlaggedFieldEnabled");
        }
        if (!DBUtils.isEmptyObject((Object)object.get("additionalFieldsValuesFeature"))) {
            this.additionalFieldsValuesFeature = DBUtils.getListOfItemJiraFieldMapFromDBObject((Object)object.get("additionalFieldsValuesFeature"));
        }
        if (!DBUtils.isEmptyObject((Object)object.get("additionalFieldsValuesUserStory"))) {
            this.additionalFieldsValuesUserStory = DBUtils.getListOfItemJiraFieldMapFromDBObject((Object)object.get("additionalFieldsValuesUserStory"));
        }
        if (PropertyValidator.isValid((Object)(ref = (com.mongodb.DBRef)object.get("riskRegister")))) {
            this.riskRegister = new RiskRegister();
            this.riskRegister.setId(ref.getId().toString());
        }
        if (PropertyValidator.isValid((Object)(ref = (com.mongodb.DBRef)object.get("workSpace")))) {
            this.workSpace = new WorkSpace();
            this.workSpace.setId(ref.getId().toString());
        }
    }

    public Session(String id, String title, String activeSessionBoard, Date startDate, Date endDate, Date planningStartDate, Date planningEndDate, WorkSpace workSpace, Date updatedOn, Date createdOn, String createdBy, Integer rowStatus, Boolean loadOldObjectivesView, Double sequence, Boolean loadNewStructureMilestones, RiskRegister riskRegister) {
        super(id);
        this.title = title;
        this.activeSessionBoard = activeSessionBoard;
        this.startDate = startDate;
        this.endDate = endDate;
        this.planningStartDate = planningStartDate;
        this.planningEndDate = planningEndDate;
        this.workSpace = new WorkSpace(workSpace.getId());
        this.createdOn = createdOn;
        this.createdBy = createdBy;
        this.updatedOn = updatedOn;
        this.rowStatus = rowStatus;
        this.loadOldObjectivesView = loadOldObjectivesView;
        this.sequence = sequence;
        this.loadNewStructureMilestones = loadNewStructureMilestones;
        this.workSpace = new WorkSpace(workSpace.getId(), workSpace.getTitle());
        this.additionalFieldsEnabled = null;
        this.additionalFieldsJiraTimeZone = null;
        this.additionalFieldsTypesFeature = null;
        this.additionalFieldsTypesUserStory = null;
        this.additionalFieldsValuesFeature = null;
        this.additionalFieldsValuesUserStory = null;
        this.almEnabled = null;
        this.areaPathDisabled = null;
        this.cartTypeIds = null;
        this.parentItem = null;
        this.parentItems = null;
        this.parentItemColor = null;
        this.parentItemTextColor = null;
        this.childItem = null;
        this.childItems = null;
        this.childItemColor = null;
        this.childItemTextColor = null;
        this.clientTimeZone = null;
        this.dependencyPrefix = null;
        this.objectivePrefix = null;
        this.dependencyReceiveLimit = null;
        this.enablerColor = null;
        this.flaggedFieldEnabled = null;
        this.ignoreUpdateIfManualResolvedForItem = null;
        this.ignoreUpdateIfManualResolvedForSubItem = null;
        this.jiraDependencyEnabled = null;
        this.jiraFlaggedFieldEnabled = null;
        this.jiraSharedSprintFieldEnabled = null;
        this.jiraSynapseRTEnabled = null;
        this.endSprintWebhookEnabled = null;
        this.startSprintWebhookEnabled = null;
        this.kendisFlaggedFieldEnabled = null;
        this.loggedUserHasAlm = null;
        this.readOnlyWithOutALMProfile = null;
        this.reOpenDependencyIfItemReOpen = null;
        this.reOpenDependencyIfSubItemReOpen = null;
        this.useObjectives = null;
        this.useEnabler = null;
        this.notifyJiraUsers = null;
        this.enablerItem = null;
        this.teamFieldEnable = null;
        this.jiraContainer = null;
        this.originIdSynched = null;
        this.subItemLinkStatusDependentOn = null;
        this.itemLinkStatusDependentOn = null;
        this.jiraButtons = null;
        if (PropertyValidator.isValid((Object)riskRegister)) {
            this.riskRegister = new RiskRegister();
            this.riskRegister.setId(riskRegister.getId());
        }
    }

    public Session(String id, String title, String activeSessionBoard, String childItem, String childItems, String parentItem, String parentItems, String prefix, String sprintLabel, String sprintsLabel, String teamLabel, String teamsLabel) {
        super(id);
        this.title = title;
        this.activeSessionBoard = activeSessionBoard;
        this.childItem = childItem;
        this.childItems = childItems;
        this.parentItem = parentItem;
        this.parentItems = parentItems;
        this.prefix = prefix;
        this.sprintLabel = sprintLabel;
        this.sprintsLabel = sprintsLabel;
        this.teamLabel = teamLabel;
        this.teamsLabel = teamsLabel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public BacklogMapping nexusFeatureMapping(String projectKey) {
        List jiraFilters;
        BacklogMapping feaMapping = null;
        if (PropertyValidator.isValid((Collection)this.getAlmConfigurations()) && PropertyValidator.isValid(this.getAlmConfigurations().get(0)) && PropertyValidator.isValid((Collection)(jiraFilters = ((AlmConfigurations)this.getAlmConfigurations().get(0)).getFeatureFilter()))) {
            for (JiraFilter jf : jiraFilters) {
                if (!jf.getIsNexus().booleanValue() || !PropertyValidator.isValid((Collection)jf.getFeatureLinkMappings()) || !PropertyValidator.isValid(jf.getFeatureLinkMappings().get(0)) || !PropertyValidator.isValid((Object)((BacklogMappingLinks)jf.getFeatureLinkMappings().get(0)).getFeatureMapping()) || !((BacklogMappingLinks)jf.getFeatureLinkMappings().get(0)).getFeatureMapping().getProjectKey().equals(projectKey)) continue;
                feaMapping = ((BacklogMappingLinks)jf.getFeatureLinkMappings().get(0)).getFeatureMapping();
                break;
            }
        }
        return feaMapping;
    }

    public Set<ItemJiraFieldMap> combineAdditionalFields(List<JiraField> fields, JiraField sprintField, boolean retAsSet, AlmAccount almAccount) {
        JiraField field;
        HashSet<ItemJiraFieldMap> extraFields = new HashSet<ItemJiraFieldMap>();
        if (PropertyValidator.isValid((Collection)this.fieldsValuesForColors)) {
            for (ItemJiraFieldMap o : this.fieldsValuesForColors) {
                if (retAsSet) {
                    extraFields.add(o);
                }
                if (fields == null) continue;
                field = new JiraField(o.getKey(), o.getKey(), o.getKey());
                fields.add(field);
            }
        }
        if (Boolean.TRUE.equals(this.additionalFieldsEnabled)) {
            if (PropertyValidator.isValid((Collection)this.additionalFieldsValuesFeature)) {
                for (ItemJiraFieldMap o : this.additionalFieldsValuesFeature) {
                    if (this.clientTimeZone != null && o.getJiraType().toLowerCase().indexOf("date") > -1) {
                        if (this.additionalFieldsJiraTimeZone != null) {
                            o.setClientTimeZone(this.additionalFieldsJiraTimeZone);
                        } else {
                            o.setClientTimeZone(this.clientTimeZone);
                        }
                    }
                    if (retAsSet) {
                        extraFields.add(o);
                    }
                    if (fields == null) continue;
                    field = new JiraField(o.getKey(), o.getKey(), o.getKey());
                    fields.add(field);
                }
            }
            if (PropertyValidator.isValid((Collection)this.additionalFieldsValuesUserStory)) {
                for (ItemJiraFieldMap o : this.additionalFieldsValuesUserStory) {
                    if (this.clientTimeZone != null && o.getJiraType().toLowerCase().indexOf("date") > -1) {
                        if (this.additionalFieldsJiraTimeZone != null) {
                            o.setClientTimeZone(this.additionalFieldsJiraTimeZone);
                        } else {
                            o.setClientTimeZone(this.clientTimeZone);
                        }
                    }
                    if (retAsSet) {
                        extraFields.add(o);
                    }
                    if (fields == null) continue;
                    fields.add(new JiraField(o.getKey(), o.getKey(), o.getKey()));
                }
            }
        }
        if (PropertyValidator.isValid((Object)this.jiraFlaggedField)) {
            if (retAsSet) {
                extraFields.add(this.jiraFlaggedField);
            }
            if (fields != null) {
                fields.add(new JiraField(this.jiraFlaggedField.getKey(), this.jiraFlaggedField.getKey(), this.jiraFlaggedField.getKey()));
            }
        }
        if (PropertyValidator.isValid((Object)this.jiraSharedSprintField)) {
            if (retAsSet) {
                extraFields.add(this.jiraSharedSprintField);
            }
            if (fields != null) {
                fields.add(new JiraField(this.jiraSharedSprintField.getKey(), this.jiraSharedSprintField.getKey(), this.jiraSharedSprintField.getKey()));
            }
        }
        if (this.wsjfAlmEnabled.booleanValue()) {
            if (retAsSet) {
                // empty if block
            }
            if (fields != null) {
                fields.add(new JiraField(this.wsjfAlmFieldKey, this.wsjfAlmFieldKey, this.wsjfAlmFieldKey));
            }
        }
        if (retAsSet) {
            extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.reporter.name(), null, "JSONObject"));
            extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.assignee.name(), null, "JSONObject"));
            extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.issuetype.name(), null, "JSONObject"));
            extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.updated.name(), null, "string"));
            extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.created.name(), null, "string"));
            extraFields.add(new ItemJiraFieldMap(JiraField.FIXED.parent.name(), null, "JSONObject"));
            if (sprintField != null) {
                extraFields.add(new ItemJiraFieldMap(sprintField.getJiraId(), null, "JSONArray"));
            }
        }
        if (fields != null) {
            fields.add(new JiraField(JiraField.FIXED.reporter.name(), JiraField.FIXED.reporter.name(), JiraField.FIXED.reporter.name()));
            fields.add(new JiraField(JiraField.FIXED.assignee.name(), JiraField.FIXED.assignee.name(), JiraField.FIXED.assignee.name()));
            fields.add(new JiraField(JiraField.FIXED.issuetype.name(), JiraField.FIXED.issuetype.name(), JiraField.FIXED.issuetype.name()));
            fields.add(new JiraField(JiraField.FIXED.updated.name(), JiraField.FIXED.updated.name(), JiraField.FIXED.updated.name()));
            fields.add(new JiraField(JiraField.FIXED.created.name(), JiraField.FIXED.created.name(), JiraField.FIXED.created.name()));
            fields.add(new JiraField(JiraField.FIXED.parent.name(), JiraField.FIXED.parent.name(), JiraField.FIXED.parent.name()));
            if (sprintField != null) {
                fields.add(sprintField);
            }
        }
        if (fields != null && this.scoreCard != null && this.scoreCard.getMappings() != null) {
            for (FieldMapping fm : this.scoreCard.getMappings()) {
                extraFields.add(new ItemJiraFieldMap(fm.getMappedToFieldId(), null, "string"));
                fields.add(new JiraField(fm.getMappedToFieldId(), fm.getMappedToFieldId(), fm.getMappedToFieldId()));
            }
        }
        return extraFields;
    }

    public Boolean getLoadOldObjectivesView() {
        return this.loadOldObjectivesView;
    }

    public void setLoadOldObjectivesView(Boolean loadOldObjectivesView) {
        this.loadOldObjectivesView = loadOldObjectivesView;
    }

    public Boolean getLoadNewStructureMilestones() {
        return this.loadNewStructureMilestones;
    }

    public void setLoadNewStructureMilestones(Boolean loadNewStructureMilestones) {
        this.loadNewStructureMilestones = loadNewStructureMilestones;
    }

    public List<ItemJiraFieldMap> getFieldsValuesForColors() {
        return this.fieldsValuesForColors;
    }

    public void setFieldsValuesForColors(List<ItemJiraFieldMap> fieldsValuesForColors) {
        this.fieldsValuesForColors = fieldsValuesForColors;
    }

    public List<String> getCartTypeIds() {
        return this.cartTypeIds;
    }

    public void setCartTypeIds(List<String> cartTypeIds) {
        this.cartTypeIds = cartTypeIds;
    }

    public List<Map<String, Object>> getInspectAndAdaptBoards() {
        return this.inspectAndAdaptBoards;
    }

    public void setInspectAndAdaptBoards(List<Map<String, Object>> inspectAndAdaptBoards) {
        this.inspectAndAdaptBoards = inspectAndAdaptBoards;
    }

    public Map<String, Object> getInspectAndAdaptSetting() {
        return this.inspectAndAdaptSetting;
    }

    public void setInspectAndAdaptSetting(Map<String, Object> inspectAndAdaptSetting) {
        this.inspectAndAdaptSetting = inspectAndAdaptSetting;
    }

    public String getInspectAndAdaptSessionDateTime() {
        return this.inspectAndAdaptSessionDateTime;
    }

    public void setInspectAndAdaptSessionDateTime(String inspectAndAdaptSessionDateTime) {
        this.inspectAndAdaptSessionDateTime = inspectAndAdaptSessionDateTime;
    }

    public RiskRegister getRiskRegister() {
        return this.riskRegister;
    }

    public List<Questionnaire> getConfidenceVoteSurvey() {
        return this.confidenceVoteSurvey;
    }

    public void setConfidenceVoteSurvey(List<Questionnaire> confidenceVoteSurvey) {
        this.confidenceVoteSurvey = confidenceVoteSurvey;
    }

    public void setRiskRegister(RiskRegister riskRegister) {
        this.riskRegister = riskRegister;
    }

    public WorkFlow getItemWorkFlow() {
        return this.itemWorkFlow;
    }

    public void setItemWorkFlow(WorkFlow workFlow) {
        this.itemWorkFlow = workFlow;
    }

    public StateScheme getStateScheme() {
        return this.stateScheme;
    }

    public void setStateScheme(StateScheme stateScheme) {
        this.stateScheme = stateScheme;
    }

    public WorkFlow getSubItemWorkFlow() {
        return this.subItemWorkFlow;
    }

    public void setSubItemWorkFlow(WorkFlow subItemWorkFlow) {
        this.subItemWorkFlow = subItemWorkFlow;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getJiraBaseURL() {
        return this.jiraBaseURL;
    }

    public void setJiraBaseURL(String jiraBaseURL) {
        this.jiraBaseURL = jiraBaseURL;
    }

    public String getParentItem() {
        return this.parentItem;
    }

    public String getParentItems() {
        return this.parentItems;
    }

    public void setParentItem(String parentItem) {
        this.parentItem = parentItem;
    }

    public void setParentItems(String parentItems) {
        this.parentItems = parentItems;
    }

    public String getChildItem() {
        return this.childItem;
    }

    public String getChildItems() {
        return this.childItems;
    }

    public void setChildItem(String childItem) {
        this.childItem = childItem;
    }

    public void setChildItems(String childItems) {
        this.childItems = childItems;
    }

    public List<AlmConfigurations> getAlmConfigurations() {
        return this.almConfigurations;
    }

    public void setAlmConfigurations(List<AlmConfigurations> almConfigurations) {
        this.almConfigurations = almConfigurations;
    }

    public Boolean getAlmEnabled() {
        return this.almEnabled;
    }

    public void setAlmEnabled(Boolean almEnabled) {
        this.almEnabled = almEnabled;
    }

    public Boolean getUseEnabler() {
        return this.useEnabler;
    }

    public void setUseEnabler(Boolean useEnabler) {
        this.useEnabler = useEnabler;
    }

    public String getJiraContainer() {
        return this.jiraContainer;
    }

    public void setJiraContainer(String jiraContainer) {
        this.jiraContainer = jiraContainer;
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public void setWorkSpace(WorkSpace workSpace) {
        this.workSpace = workSpace;
    }

    public Boolean getLoggedUserHasAlm() {
        return this.loggedUserHasAlm;
    }

    public void setLoggedUserHasAlm(Boolean loggedUserHasAlm) {
        this.loggedUserHasAlm = loggedUserHasAlm;
    }

    public String getEnablerColor() {
        return this.enablerColor;
    }

    public void setEnablerColor(String enablerColor) {
        this.enablerColor = enablerColor;
    }

    public String getActiveSessionBoard() {
        return this.activeSessionBoard;
    }

    public void setActiveSessionBoard(String activeSessionBoard) {
        this.activeSessionBoard = activeSessionBoard;
    }

    public String getEnablerItem() {
        return this.enablerItem;
    }

    public void setEnablerItem(String enablerItem) {
        this.enablerItem = enablerItem;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public Boolean getNotifyJiraUsers() {
        return this.notifyJiraUsers;
    }

    public void setNotifyJiraUsers(Boolean getNotifyJiraUsers) {
        this.notifyJiraUsers = getNotifyJiraUsers;
    }

    public Boolean getUseObjectives() {
        return this.useObjectives;
    }

    public void setUseObjectives(Boolean useObjectives) {
        this.useObjectives = useObjectives;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getPiNumber() {
        return this.piNumber;
    }

    public void setPiNumber(String piNumber) {
        this.piNumber = piNumber;
    }

    public List<String> getJiraLinkTypes() {
        return this.jiraLinkTypes;
    }

    public void setJiraLinkTypes(List<String> jiraLinkTypes) {
        this.jiraLinkTypes = jiraLinkTypes;
    }

    public Boolean getJiraFeatureParentEnabled() {
        return this.jiraFeatureParentEnabled;
    }

    public void setJiraFeatureParentEnabled(Boolean jiraFeatureParentEnabled) {
        this.jiraFeatureParentEnabled = jiraFeatureParentEnabled;
    }

    public String getJiraFeatureParentLinkType() {
        return this.jiraFeatureParentLinkType;
    }

    public void setJiraFeatureParentLinkType(String jiraFeatureParentLinkType) {
        this.jiraFeatureParentLinkType = jiraFeatureParentLinkType;
    }

    public String getJiraFeatureParentIssueType() {
        return this.jiraFeatureParentIssueType;
    }

    public void setJiraFeatureParentIssueType(String jiraFeatureParentIssueType) {
        this.jiraFeatureParentIssueType = jiraFeatureParentIssueType;
    }

    public HashMap<String, Boolean> getJiraButtons() {
        return this.jiraButtons;
    }

    public void setJiraButtons(HashMap<String, Boolean> jiraButtons) {
        this.jiraButtons = jiraButtons;
    }

    public Boolean getOriginIdSynched() {
        return this.originIdSynched;
    }

    public void setOriginIdSynched(Boolean originIdSynched) {
        this.originIdSynched = originIdSynched;
    }

    public Boolean getFlaggedFieldEnabled() {
        return this.flaggedFieldEnabled;
    }

    public void setFlaggedFieldEnabled(Boolean flaggedFieldEnabled) {
        this.flaggedFieldEnabled = flaggedFieldEnabled;
    }

    public Boolean getKendisFlaggedFieldEnabled() {
        return this.kendisFlaggedFieldEnabled;
    }

    public void setKendisFlaggedFieldEnabled(Boolean kendisFlaggedFieldEnabled) {
        this.kendisFlaggedFieldEnabled = kendisFlaggedFieldEnabled;
    }

    public Boolean getJiraFlaggedFieldEnabled() {
        return this.jiraFlaggedFieldEnabled;
    }

    public void setJiraFlaggedFieldEnabled(Boolean jiraFlaggedFieldEnabled) {
        this.jiraFlaggedFieldEnabled = jiraFlaggedFieldEnabled;
    }

    public ItemJiraFieldMap getJiraFlaggedField() {
        return this.jiraFlaggedField;
    }

    public void setJiraFlaggedField(ItemJiraFieldMap jiraFlaggedField) {
        this.jiraFlaggedField = jiraFlaggedField;
    }

    public Boolean getJiraDependencyEnabled() {
        return this.jiraDependencyEnabled;
    }

    public void setJiraDependencyEnabled(Boolean jiraDependencyEnabled) {
        this.jiraDependencyEnabled = jiraDependencyEnabled;
    }

    public Set<String> getJiraLinkTypesCached() {
        return this.jiraLinkTypesCached;
    }

    public void setJiraLinkTypesCached(Set<String> jiraLinkTypesCached) {
        this.jiraLinkTypesCached = jiraLinkTypesCached;
    }

    public Date getPlanningStartDate() {
        return this.planningStartDate;
    }

    public void setPlanningStartDate(Date planningStartDate) {
        this.planningStartDate = planningStartDate;
    }

    public Date getPlanningEndDate() {
        return this.planningEndDate;
    }

    public void setPlanningEndDate(Date planningEndDate) {
        this.planningEndDate = planningEndDate;
    }

    public ItemParent getItemParent() {
        return this.itemParent;
    }

    public void setItemParent(ItemParent itemParent) {
        this.itemParent = itemParent;
    }

    public List<JiraIssueLinkType> getJiraIssueLinkTypes() {
        return this.jiraIssueLinkTypes;
    }

    public void setJiraIssueLinkTypes(List<JiraIssueLinkType> jiraIssueLinkTypes) {
        this.jiraIssueLinkTypes = jiraIssueLinkTypes;
    }

    public List<JiraIssueType> getJiraIssueTypes() {
        return this.jiraIssueTypes;
    }

    public void setJiraIssueTypes(List<JiraIssueType> jiraIssueTypes) {
        this.jiraIssueTypes = jiraIssueTypes;
    }

    public TFSAlmConfigurations getTfsAlmConfigurations() {
        return this.tfsAlmConfigurations;
    }

    public void setTfsAlmConfigurations(TFSAlmConfigurations tfsAlmConfigurations) {
        this.tfsAlmConfigurations = tfsAlmConfigurations;
    }

    public Boolean getJiraSynapseRTEnabled() {
        return this.jiraSynapseRTEnabled;
    }

    public void setJiraSynapseRTEnabled(Boolean jiraSynapseRTEnabled) {
        this.jiraSynapseRTEnabled = jiraSynapseRTEnabled;
    }

    public String getItemLinkStatusDependentOn() {
        return this.itemLinkStatusDependentOn;
    }

    public void setItemLinkStatusDependentOn(String itemLinkStatusDependentOn) {
        this.itemLinkStatusDependentOn = itemLinkStatusDependentOn;
    }

    public Boolean getReOpenDependencyIfItemReOpen() {
        return this.reOpenDependencyIfItemReOpen;
    }

    public void setReOpenDependencyIfItemReOpen(Boolean reOpenDependencyIfItemReOpen) {
        this.reOpenDependencyIfItemReOpen = reOpenDependencyIfItemReOpen;
    }

    public Boolean getIgnoreUpdateIfManualResolvedForItem() {
        return this.ignoreUpdateIfManualResolvedForItem;
    }

    public void setIgnoreUpdateIfManualResolvedForItem(Boolean ignoreUpdateIfMannualResolvedForItem) {
        this.ignoreUpdateIfManualResolvedForItem = ignoreUpdateIfMannualResolvedForItem;
    }

    public String getSubItemLinkStatusDependentOn() {
        return this.subItemLinkStatusDependentOn;
    }

    public void setSubItemLinkStatusDependentOn(String subItemLinkStatusDependentOn) {
        this.subItemLinkStatusDependentOn = subItemLinkStatusDependentOn;
    }

    public Boolean getReOpenDependencyIfSubItemReOpen() {
        return this.reOpenDependencyIfSubItemReOpen;
    }

    public void setReOpenDependencyIfSubItemReOpen(Boolean reOpenDependencyIfSubItemReOpen) {
        this.reOpenDependencyIfSubItemReOpen = reOpenDependencyIfSubItemReOpen;
    }

    public Boolean getIgnoreUpdateIfManualResolvedForSubItem() {
        return this.ignoreUpdateIfManualResolvedForSubItem;
    }

    public void setIgnoreUpdateIfManualResolvedForSubItem(Boolean ignoreUpdateIfMannualResolvedForSubItem) {
        this.ignoreUpdateIfManualResolvedForSubItem = ignoreUpdateIfMannualResolvedForSubItem;
    }

    public Boolean getJiraSharedSprintFieldEnabled() {
        return this.jiraSharedSprintFieldEnabled;
    }

    public void setJiraSharedSprintFieldEnabled(Boolean jiraSharedSprintFieldEnabled) {
        this.jiraSharedSprintFieldEnabled = jiraSharedSprintFieldEnabled;
    }

    public ItemJiraFieldMap getJiraSharedSprintField() {
        return this.jiraSharedSprintField;
    }

    public void setJiraSharedSprintField(ItemJiraFieldMap jiraSharedSprintField) {
        this.jiraSharedSprintField = jiraSharedSprintField;
    }

    public Boolean getStartSprintWebhookEnabled() {
        return this.startSprintWebhookEnabled;
    }

    public void setStartSprintWebhookEnabled(Boolean startSprintWebhookEnabled) {
        this.startSprintWebhookEnabled = startSprintWebhookEnabled;
    }

    public Boolean getEndSprintWebhookEnabled() {
        return this.endSprintWebhookEnabled;
    }

    public void setEndSprintWebhookEnabled(Boolean endSprintWebhookEnabled) {
        this.endSprintWebhookEnabled = endSprintWebhookEnabled;
    }

    public Boolean getBucketEnabled() {
        return this.bucketEnabled;
    }

    public void setBucketEnabled(Boolean bucketEnabled) {
        this.bucketEnabled = bucketEnabled;
    }

    public Boolean getKendisOnlyCreateEnabled() {
        return this.kendisOnlyCreateEnabled;
    }

    public void setKendisOnlyCreateEnabled(Boolean kendisOnlyCreateEnabled) {
        this.kendisOnlyCreateEnabled = kendisOnlyCreateEnabled;
    }

    public String getParentItemColor() {
        return this.parentItemColor;
    }

    public void setParentItemColor(String parentItemColor) {
        this.parentItemColor = parentItemColor;
    }

    public String getChildItemColor() {
        return this.childItemColor;
    }

    public void setChildItemColor(String childItemColor) {
        this.childItemColor = childItemColor;
    }

    public Boolean getTeamFieldEnable() {
        return this.teamFieldEnable;
    }

    public void setTeamFieldEnable(Boolean teamFieldEnable) {
        this.teamFieldEnable = teamFieldEnable;
    }

    public String getTeamFieldTeamName() {
        return this.teamFieldTeamName;
    }

    public void setTeamFieldTeamName(String teamFieldTeamName) {
        this.teamFieldTeamName = teamFieldTeamName;
    }

    public String getTeamFieldTeamRefrence() {
        return this.teamFieldTeamRefrence;
    }

    public void setTeamFieldTeamRefrence(String teamFieldTeamRefrence) {
        this.teamFieldTeamRefrence = teamFieldTeamRefrence;
    }

    public Boolean getAdditionalFieldsEnabled() {
        return this.additionalFieldsEnabled;
    }

    public void setAdditionalFieldsEnabled(Boolean additionalFieldsEnabled) {
        this.additionalFieldsEnabled = additionalFieldsEnabled;
    }

    public String getAdditionalFieldsJiraTimeZone() {
        return this.additionalFieldsJiraTimeZone;
    }

    public void setAdditionalFieldsJiraTimeZone(String additionalFieldsJiraTimeZone) {
        this.additionalFieldsJiraTimeZone = additionalFieldsJiraTimeZone;
    }

    public List<String> getAdditionalFieldsTypesFeature() {
        return this.additionalFieldsTypesFeature;
    }

    public void setAdditionalFieldsTypesFeature(List<String> additionalFieldsTypesFeature) {
        this.additionalFieldsTypesFeature = additionalFieldsTypesFeature;
    }

    public List<String> getAdditionalFieldsTypesUserStory() {
        return this.additionalFieldsTypesUserStory;
    }

    public void setAdditionalFieldsTypesUserStory(List<String> additionalFieldsTypesUserStory) {
        this.additionalFieldsTypesUserStory = additionalFieldsTypesUserStory;
    }

    public List<ItemJiraFieldMap> getAdditionalFieldsValuesFeature() {
        return this.additionalFieldsValuesFeature;
    }

    public void setAdditionalFieldsValuesFeature(List<ItemJiraFieldMap> additionalFieldsValuesFeature) {
        this.additionalFieldsValuesFeature = additionalFieldsValuesFeature;
    }

    public List<ItemJiraFieldMap> getAdditionalFieldsValuesUserStory() {
        return this.additionalFieldsValuesUserStory;
    }

    public void setAdditionalFieldsValuesUserStory(List<ItemJiraFieldMap> additionalFieldsValuesUserStory) {
        this.additionalFieldsValuesUserStory = additionalFieldsValuesUserStory;
    }

    public List<String> getAdditionalFieldsIdsFeature() {
        return this.additionalFieldsIdsFeature;
    }

    public void setAdditionalFieldsIdsFeature(List<String> additionalFieldsIdsFeature) {
        this.additionalFieldsIdsFeature = additionalFieldsIdsFeature;
    }

    public List<String> getAdditionalFieldsIdsUserStory() {
        return this.additionalFieldsIdsUserStory;
    }

    public void setAdditionalFieldsIdsUserStory(List<String> additionalFieldsIdsUserStory) {
        this.additionalFieldsIdsUserStory = additionalFieldsIdsUserStory;
    }

    public String getParentItemTextColor() {
        return this.parentItemTextColor;
    }

    public void setParentItemTextColor(String parentItemTextColor) {
        this.parentItemTextColor = parentItemTextColor;
    }

    public String getChildItemTextColor() {
        return this.childItemTextColor;
    }

    public void setChildItemTextColor(String childItemTextColor) {
        this.childItemTextColor = childItemTextColor;
    }

    public Boolean getAreaPathDisabled() {
        return this.areaPathDisabled;
    }

    public void setAreaPathDisabled(Boolean areaPathDisabled) {
        this.areaPathDisabled = areaPathDisabled;
    }

    public WorkFlow getDependencyWorkFlow() {
        return this.dependencyWorkFlow;
    }

    public void setDependencyWorkFlow(WorkFlow dependencyWorkFlow) {
        this.dependencyWorkFlow = dependencyWorkFlow;
    }

    public State getActiveState() {
        return this.activeState;
    }

    public void setActiveState(State activeState) {
        this.activeState = activeState;
    }

    public Boolean getDependencyReceiveLimit() {
        return this.dependencyReceiveLimit;
    }

    public void setDependencyReceiveLimit(Boolean dependencyReceiveLimit) {
        this.dependencyReceiveLimit = dependencyReceiveLimit;
    }

    public Boolean getReadOnlyWithOutALMProfile() {
        return this.readOnlyWithOutALMProfile;
    }

    public void setReadOnlyWithOutALMProfile(Boolean readOnlyWithOutALMProfile) {
        this.readOnlyWithOutALMProfile = readOnlyWithOutALMProfile;
    }

    public List<TeamSetting> getTeamSettings() {
        return this.teamSettings;
    }

    public void setTeamSettings(List<TeamSetting> teamSettings) {
        this.teamSettings = teamSettings;
    }

    public String getDependencyPrefix() {
        return this.dependencyPrefix;
    }

    public void setDependencyPrefix(String dependencyPrefix) {
        this.dependencyPrefix = dependencyPrefix;
    }

    public String getObjectivePrefix() {
        return this.objectivePrefix;
    }

    public void setObjectivePrefix(String objectivePrefix) {
        this.objectivePrefix = objectivePrefix;
    }

    public Boolean getHidePiJourney() {
        return this.hidePiJourney;
    }

    public void setHidePiJourney(Boolean hidePiJourney) {
        this.hidePiJourney = hidePiJourney;
    }

    public ScoreCard getScoreCard() {
        return this.scoreCard;
    }

    public void setScoreCard(ScoreCard scoreCard) {
        this.scoreCard = scoreCard;
    }

    public Boolean getWsjfEnabled() {
        return this.wsjfEnabled;
    }

    public void setWsjfEnabled(Boolean wsjfEnabled) {
        this.wsjfEnabled = wsjfEnabled;
    }

    public Boolean getOkrEnabled() {
        return this.okrEnabled;
    }

    public void setOkrEnabled(Boolean okrEnabled) {
        this.okrEnabled = okrEnabled;
    }

    public Boolean getUncommittedObjEnabled() {
        return this.uncommittedObjEnabled;
    }

    public void setUncommittedObjEnabled(Boolean uncommittedObjEnabled) {
        this.uncommittedObjEnabled = uncommittedObjEnabled;
    }

    public String getAlmType() {
        return this.almType;
    }

    public void setAlmType(String almType) {
        this.almType = almType;
    }

    public Boolean getwsjfAlmEnabled() {
        return this.wsjfAlmEnabled;
    }

    public void setwsjfAlmEnabled(Boolean wsjfAlmEnabled) {
        this.wsjfAlmEnabled = wsjfAlmEnabled;
    }

    public Boolean getWsjfKendisEnabled() {
        return this.wsjfKendisEnabled;
    }

    public void setWsjfKendisEnabled(Boolean wsjfKendisEnabled) {
        this.wsjfKendisEnabled = wsjfKendisEnabled;
    }

    public String getwsjfAlmFieldKey() {
        return this.wsjfAlmFieldKey;
    }

    public void setwsjfAlmFieldKey(String wsjfAlmFieldKey) {
        this.wsjfAlmFieldKey = wsjfAlmFieldKey;
    }

    public Boolean getSetWsjfAlmFieldForAllProjects() {
        return this.setWsjfAlmFieldForAllProjects;
    }

    public void setSetWsjfAlmFieldForAllProjects(Boolean setWsjfAlmFieldForAllProjects) {
        this.setWsjfAlmFieldForAllProjects = setWsjfAlmFieldForAllProjects;
    }

    public String getStartDateAction() {
        return this.startDateAction;
    }

    public void setStartDateAction(String startDateAction) {
        this.startDateAction = startDateAction;
    }

    public String getTeamLabel() {
        return this.teamLabel;
    }

    public void setTeamLabel(String teamLabel) {
        this.teamLabel = teamLabel;
    }

    public String getTeamsLabel() {
        return this.teamsLabel;
    }

    public void setTeamsLabel(String teamsLabel) {
        this.teamsLabel = teamsLabel;
    }

    public String getSprintLabel() {
        return this.sprintLabel;
    }

    public void setSprintLabel(String sprintLabel) {
        this.sprintLabel = sprintLabel;
    }

    public String getSprintsLabel() {
        return this.sprintsLabel;
    }

    public void setSprintsLabel(String sprintsLabel) {
        this.sprintsLabel = sprintsLabel;
    }

    public String getMilestoneSchemeId() {
        return this.milestoneSchemeId;
    }

    public void setMilestoneSchemeId(String milestoneSchemeId) {
        this.milestoneSchemeId = milestoneSchemeId;
    }

    public String getLineArrowDirection() {
        return this.lineArrowDirection;
    }

    public void setLineArrowDirection(String lineArrowDirection) {
        this.lineArrowDirection = lineArrowDirection;
    }

    public Boolean getNewSystemLinkTypes() {
        return this.newSystemLinkTypes;
    }

    public void setNewSystemLinkTypes(Boolean newSystemLinkTypes) {
        this.newSystemLinkTypes = newSystemLinkTypes;
    }

    public String getPhaseSchemeId() {
        return this.phaseSchemeId;
    }

    public void setPhaseSchemeId(String phaseSchemeId) {
        this.phaseSchemeId = phaseSchemeId;
    }

    public Boolean getIsJiraColorsEnabled() {
        return this.isJiraColorsEnabled;
    }

    public void setIsJiraColorsEnabled(Boolean isJiraColorsEnabled) {
        this.isJiraColorsEnabled = isJiraColorsEnabled;
    }

    public List<State> getAutoUpdateEnabledStates() {
        return this.autoUpdateEnabledStates;
    }

    public void setAutoUpdateEnabledStates(List<State> autoUpdateEnabledStates) {
        this.autoUpdateEnabledStates = autoUpdateEnabledStates;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefixColor() {
        return this.prefixColor;
    }

    public void setPrefixColor(String prefixColor) {
        this.prefixColor = prefixColor;
    }

    public ArrayList<Map<String, String>> getItemsAddedFromKanban() {
        return this.itemsAddedFromKanban;
    }

    public void setItemsAddedFromKanban(ArrayList<Map<String, String>> itemsAddedFromKanban) {
        this.itemsAddedFromKanban = itemsAddedFromKanban;
    }

    public Date getLastChangesSyncTime() {
        return this.lastChangesSyncTime;
    }

    public void setLastChangesSyncTime(Date lastChangesSyncTime) {
        this.lastChangesSyncTime = lastChangesSyncTime;
    }

    public Boolean getWsjfWithMappingEnabled() {
        return this.wsjfWithMappingEnabled;
    }

    public void setWsjfWithMappingEnabled(Boolean wsjfWithMappingEnabled) {
        this.wsjfWithMappingEnabled = wsjfWithMappingEnabled;
    }

    public HashMap<String, String> getIgnoreItemsInResync() {
        return this.ignoreItemsInResync;
    }

    public void setIgnoreItemsInResync(HashMap<String, String> ignoreItemsInResync) {
        this.ignoreItemsInResync = ignoreItemsInResync;
    }

    public FieldsLayout getKendisOnlyLayout() {
        return this.kendisOnlyLayout;
    }

    public void setKendisOnlyLayout(FieldsLayout kendisOnlyLayout) {
        this.kendisOnlyLayout = kendisOnlyLayout;
    }

    public boolean isDisabledForDashboardListing() {
        return this.disabledForDashboardListing;
    }

    public void setDisabledForDashboardListing(boolean disabledForDashboardListing) {
        this.disabledForDashboardListing = disabledForDashboardListing;
    }

    public Boolean getHideMilestonesBar() {
        return this.hideMilestonesBar;
    }

    public void setHideMilestonesBar(Boolean hideMilestonesBar) {
        this.hideMilestonesBar = hideMilestonesBar;
    }

    public String getMilestoneWidgetHeader() {
        return this.milestoneWidgetHeader;
    }

    public void setMilestoneWidgetHeader(String milestoneWidgetHeader) {
        this.milestoneWidgetHeader = milestoneWidgetHeader;
    }

    public Map<String, IssueType> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Map<String, IssueType> buckets) {
        this.buckets = buckets;
    }

    public String getReverseDependencyDirection() {
        return this.reverseDependencyDirection;
    }

    public void setReverseDependencyDirection(String reverseDependencyDirection) {
        this.reverseDependencyDirection = reverseDependencyDirection;
    }

    public Boolean getKendisLinkTypeDisabled() {
        return this.kendisLinkTypeDisabled;
    }

    public void setKendisLinkTypeDisabled(Boolean kendisLinkTypeDisabled) {
        this.kendisLinkTypeDisabled = kendisLinkTypeDisabled;
    }

    public Integer getSyncTimer() {
        return this.syncTimer;
    }

    public void setSyncTimer(Integer syncTimer) {
        this.syncTimer = syncTimer;
    }

    public boolean isAutoFillStartEndDate() {
        return this.autoFillStartEndDate;
    }

    public void setAutoFillStartEndDate(boolean autoFillStartEndDate) {
        this.autoFillStartEndDate = autoFillStartEndDate;
    }

    public List<String> getExcludeTfsStatuses() {
        return this.excludeTfsStatuses;
    }

    public void setExcludeTfsStatuses(List<String> excludeTfsStatuses) {
        this.excludeTfsStatuses = excludeTfsStatuses;
    }

    public List<String> getExcludeTfsItemTypes() {
        return this.excludeTfsItemTypes;
    }

    public void setExcludeTfsItemTypes(List<String> excludeTfsItemTypes) {
        this.excludeTfsItemTypes = excludeTfsItemTypes;
    }

    public Boolean getResyncRequired() {
        return this.resyncRequired;
    }

    public void setResyncRequired(Boolean resyncRequired) {
        this.resyncRequired = resyncRequired;
    }
}

