/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.mongodb.core.mapping.DBRef;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Scrum
extends BaseEntity {
    private static final long serialVersionUID = 7936961165246591856L;
    @GenerateFieldlog
    private String notes;
    @GenerateFieldlog
    @DBRef
    private Team team;
    @DBRef
    private User scrumMaster;
    @DBRef
    private User productOwner;
    @DBRef
    private List<User> otherParticipants;
    private Set<String> remainderList;

    public void initializeRemainderListFromEmailConfig(HashMap<String, Object> emailConfiguration) {
        HashSet<String> remainder = new HashSet<String>();
        if (PropertyValidator.isValid(emailConfiguration)) {
            if (Boolean.TRUE.equals(emailConfiguration.get("Highlights"))) {
                remainder.add("Highlights");
            }
            if (Boolean.TRUE.equals(emailConfiguration.get(WorkFlow.WorkFlowType.Impediment.name()))) {
                remainder.add(WorkFlow.WorkFlowType.Impediment.name());
            }
            if (Boolean.TRUE.equals(emailConfiguration.get(WorkFlow.WorkFlowType.ActionPoint.name()))) {
                remainder.add(WorkFlow.WorkFlowType.ActionPoint.name());
            }
        }
        this.remainderList = remainder;
    }

    public Scrum() {
    }

    public Scrum(String id) {
        super(id);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public User getScrumMaster() {
        return this.scrumMaster;
    }

    public void setScrumMaster(User scrumMaster) {
        this.scrumMaster = scrumMaster;
    }

    public User getProductOwner() {
        return this.productOwner;
    }

    public void setProductOwner(User productOwner) {
        this.productOwner = productOwner;
    }

    public List<User> getOtherParticipants() {
        return this.otherParticipants;
    }

    public void setOtherParticipants(List<User> otherParticipants) {
        this.otherParticipants = otherParticipants;
    }

    public Set<String> getRemainderList() {
        if (this.remainderList == null) {
            this.remainderList = new HashSet();
        }
        return this.remainderList;
    }

    public void setRemainderList(Set<String> remainderList) {
        this.remainderList = remainderList;
    }
}

