/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.enums.EnumStatusCategory;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Objective;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.utils.PropertyValidator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectiveValue
extends BaseEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveValue.class);
    private String title;
    private String type;
    private Integer planValue;
    private Integer actualValue;
    private List<String> itemIds;
    private Map<String, String> externalItemIds;

    public ObjectiveValue() {
    }

    public ObjectiveValue(String id) {
        super(id);
    }

    public ObjectiveValue(String title, String type, Integer planValue, Integer actualValue, List<String> itemIds, Map<String, String> externalItemIds) {
        this.title = title;
        this.type = type;
        this.planValue = planValue;
        this.actualValue = actualValue;
        this.itemIds = itemIds;
        this.externalItemIds = externalItemIds;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getPlanValue() {
        return this.planValue;
    }

    public void setPlanValue(Integer planValue) {
        this.planValue = planValue;
    }

    public Integer getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(Integer actualValue) {
        this.actualValue = actualValue;
    }

    public List<String> getItemIds() {
        return this.itemIds;
    }

    public void setItemIds(List<String> itemIds) {
        this.itemIds = itemIds;
    }

    public Map<String, String> getExternalItemIds() {
        return this.externalItemIds;
    }

    public void setExternalItemIds(Map<String, String> externalItemIds) {
        this.externalItemIds = externalItemIds;
    }

    public Object valueByKey(String key, Objective o, HashMap<String, Object> map) throws RuntimeException {
        Object ret = null;
        if (PropertyValidator.isValid((Object)key)) {
            if ("name".equals(key)) {
                ret = o.getTitle();
                if (PropertyValidator.isValid((Object)o.getTeamId()) && !PropertyValidator.isValid((Object)o.getTitle()) && map.get(o.getTeamId()) != null) {
                    ret = ((Team)map.get(o.getTeamId())).getTitle();
                }
            } else if ("title".equals(key)) {
                ret = this.title;
            } else if ("plan".equals(key)) {
                ret = this.planValue;
            } else if ("actual".equals(key)) {
                ret = this.actualValue;
            } else if ("type".equals(key)) {
                ret = "stretch".equals(this.type.toLowerCase()) || "strech".equals(this.type.toLowerCase()) ? "Uncommitted" : "Normal";
            } else if ("links".equals(key)) {
                StringBuilder links = new StringBuilder();
                if (PropertyValidator.isValid((Collection)this.itemIds)) {
                    for (int i = 0; i < this.itemIds.size(); ++i) {
                        Item item = (Item)map.get(this.itemIds.get(i));
                        if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Object)item.getTfsId())) {
                            if (links.length() > 0) {
                                links.append(", ");
                            }
                            links.append(item.getTfsId());
                            continue;
                        }
                        if (PropertyValidator.isValid((Object)item) && PropertyValidator.isValid((Object)item.getJiraKey())) {
                            if (links.length() > 0) {
                                links.append(", ");
                            }
                            links.append(item.getJiraKey());
                            continue;
                        }
                        if (this.externalItemIds == null || !PropertyValidator.isValid(this.externalItemIds.get(this.itemIds.get(i)))) continue;
                        if (links.length() > 0) {
                            links.append(", ");
                        }
                        links.append((String)this.externalItemIds.get(this.itemIds.get(i)));
                    }
                }
                ret = links;
            } else {
                String[] prog = key.split("_");
                if ("completion".equals(prog[0])) {
                    Integer i;
                    Double sum;
                    HashMap<String, Double> catMap = new HashMap<String, Double>();
                    ArrayList<HashMap> progMap = new ArrayList<HashMap>();
                    catMap.put(EnumStatusCategory.OPEN.getCode(), 0.0);
                    catMap.put(EnumStatusCategory.INPROGRESS.getCode(), 0.0);
                    catMap.put(EnumStatusCategory.DONE.getCode(), 0.0);
                    catMap.put(EnumStatusCategory.MISC.getCode(), 0.0);
                    progMap.add((HashMap)catMap.clone());
                    progMap.add((HashMap)catMap.clone());
                    progMap.add((HashMap)catMap.clone());
                    progMap.add((HashMap)catMap.clone());
                    progMap.add((HashMap)catMap.clone());
                    progMap.add((HashMap)catMap.clone());
                    if (PropertyValidator.isValid((Collection)this.itemIds)) {
                        HashMap childmap = (HashMap)map.get("childmap");
                        if (!PropertyValidator.isValid((Object)childmap)) {
                            childmap = new HashMap();
                        }
                        for (int i2 = 0; i2 < this.itemIds.size(); ++i2) {
                            Item item;
                            if (!PropertyValidator.isValid(this.itemIds.get(i2)) || !PropertyValidator.isValid((Object)(item = (Item)map.get(this.itemIds.get(i2)))) || !PropertyValidator.isValid((Object)item.getStatus()) || !PropertyValidator.isValid((Object)item.getStatus().getCategory())) continue;
                            ((HashMap)progMap.get(1)).put(item.getStatus().getCategory(), (Double)((HashMap)progMap.get(1)).get(item.getStatus().getCategory()) + 1.0);
                            List userstories = (List)childmap.get(item.getId());
                            if (PropertyValidator.isValid((Collection)userstories)) {
                                for (int j = 0; j < userstories.size(); ++j) {
                                    Item us = (Item)userstories.get(j);
                                    if (!PropertyValidator.isValid((Object)us) || !PropertyValidator.isValid((Object)us.getStatus()) || !PropertyValidator.isValid((Object)us.getStatus().getCategory())) continue;
                                    ((HashMap)progMap.get(2)).put(us.getStatus().getCategory(), (Double)((HashMap)progMap.get(2)).get(us.getStatus().getCategory()) + 1.0);
                                    ((HashMap)progMap.get(3)).put(us.getStatus().getCategory(), (Double)((HashMap)progMap.get(3)).get(us.getStatus().getCategory()) + us.getStoryPoints());
                                    if (!PropertyValidator.isValid((Object)o.getTeamId()) || "0".equals(o.getTeamId())) {
                                        ((HashMap)progMap.get(4)).put(us.getStatus().getCategory(), (Double)((HashMap)progMap.get(4)).get(us.getStatus().getCategory()) + 1.0);
                                        ((HashMap)progMap.get(5)).put(us.getStatus().getCategory(), (Double)((HashMap)progMap.get(5)).get(us.getStatus().getCategory()) + us.getStoryPoints());
                                        continue;
                                    }
                                    if (!PropertyValidator.isValid((Object)o.getTeamId()) || !PropertyValidator.isValid((Collection)us.getTeamContainers()) || !PropertyValidator.isValid(us.getTeamContainers().get(0)) || !PropertyValidator.isValid((Object)((TeamContainer)us.getTeamContainers().get(0)).getTeam()) || !o.getTeamId().equals(((TeamContainer)us.getTeamContainers().get(0)).getTeam().getId())) continue;
                                    ((HashMap)progMap.get(4)).put(us.getStatus().getCategory(), (Double)((HashMap)progMap.get(4)).get(us.getStatus().getCategory()) + 1.0);
                                    ((HashMap)progMap.get(5)).put(us.getStatus().getCategory(), (Double)((HashMap)progMap.get(5)).get(us.getStatus().getCategory()) + us.getStoryPoints());
                                }
                                continue;
                            }
                            if (!Item.Type.UserStory.name().equals(item.getType())) continue;
                            ((HashMap)progMap.get(2)).put(item.getStatus().getCategory(), (Double)((HashMap)progMap.get(2)).get(item.getStatus().getCategory()) + 1.0);
                            ((HashMap)progMap.get(3)).put(item.getStatus().getCategory(), (Double)((HashMap)progMap.get(3)).get(item.getStatus().getCategory()) + item.getStoryPoints());
                            ((HashMap)progMap.get(4)).put(item.getStatus().getCategory(), (Double)((HashMap)progMap.get(4)).get(item.getStatus().getCategory()) + 1.0);
                            ((HashMap)progMap.get(5)).put(item.getStatus().getCategory(), (Double)((HashMap)progMap.get(5)).get(item.getStatus().getCategory()) + item.getStoryPoints());
                        }
                    }
                    sum = (sum = Double.valueOf((Double)((HashMap)progMap.get(i = new Integer(prog[1]))).get("ToDo") + (Double)((HashMap)progMap.get(i)).get("InProgress") + (Double)((HashMap)progMap.get(i)).get("Done"))) > 0.0 ? Double.valueOf(100.0 * ((Double)((HashMap)progMap.get(i)).get("Done") / sum)) : Double.valueOf(0.0);
                    DecimalFormat df = new DecimalFormat("##.##");
                    ret = df.format(sum);
                }
            }
        }
        if (ret == null) {
            return "";
        }
        return ret.toString();
    }
}

