/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.ObjectiveValue;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Objective
extends BaseEntity {
    private String title;
    private String teamId;
    private List<ObjectiveValue> values;

    public Objective() {
    }

    public Objective(String id) {
        super(id);
    }

    public Objective(String title, String teamId, List<HashMap<String, Object>> values) {
        this.title = title;
        this.teamId = teamId;
        if (PropertyValidator.isValid(values)) {
            this.values = new ArrayList();
            for (HashMap<String, Object> o : values) {
                ObjectiveValue ov = new ObjectiveValue((String)o.get("title"), (String)o.get("type"), (Integer)o.get("planValue"), (Integer)o.get("actualValue"), (List)((ArrayList)o.get("itemIds")), (Map)o.get("externalItemIds"));
                ov.setId((String)o.get("id"));
                if (!PropertyValidator.isValid((Object)ov.getId())) {
                    ov.setId(UUID.randomUUID().toString());
                }
                this.values.add(ov);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public List<ObjectiveValue> getValues() {
        return this.values;
    }

    public void setValues(List<ObjectiveValue> values) {
        this.values = values;
    }

    public void copy(Objective obj) {
        this.title = obj.title;
        this.teamId = obj.teamId;
        this.values = null;
        if (PropertyValidator.isValid((Collection)obj.getValues())) {
            this.values = new ArrayList();
            for (ObjectiveValue o : obj.getValues()) {
                ObjectiveValue ov = new ObjectiveValue(o.getTitle(), o.getType(), o.getPlanValue(), o.getActualValue(), o.getItemIds(), o.getExternalItemIds());
                ov.setId(o.getId());
                this.values.add(ov);
            }
        }
    }
}

