/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemLogDetail {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemLogDetail.class);
    @JsonIgnoreProperties(ignoreUnknown=true, value={"eventType", "mongoTemplate", "rowStatus", "source", "oldSate", "backlogSequence", "subItemEstimate", "linkType", "linkTypes", "metaMap", "externalReferenceURL", "jiraFilter", "jiraProjectKey", "jiraIssueTypeId", "jiraIssueType", "mapJiraFields", "jiraDependencies", "jiraItemJson", "linkedItems", "isEnabler", "errorInAlmSync", "almWarning", "almErrorMessage", "compositeJiraKey", "deletedInJira", "oldJiraKey", "webHookActivityBy", "webhookSequence", "jiraFieldMap", "jiraFieldByKey", "syncDueDate", "flagged", "issueTypes", "itemLinks", "generatedId", "workFlow", "jiraStatusCatId", "sessionId", "isDeleted", "target", "lastUpdate", "phoenixTC", "conversations", "watcherList", "userCompanies", "almCredentials", "requireMFACode", "recoveryMFACode", "workSpaces", "fieldsTemplate", "fields", "baseItemLinks", "parentRelations", "childRelations", "artRelations", "boardRelations", "batchRelations", "teamContainerRelations", "solutionRelations", "relations"})
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.NON_EMPTY)
    Object object;

    public ItemLogDetail() {
    }

    public ItemLogDetail(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Map<String, Object> clean(ObjectMapper mapper) {
        Map map;
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        if (!((map = (Map)mapper.convertValue((Object)this, Map.class)).get("object") instanceof Map)) {
            if (this.object != null) {
                LOGGER.debug(this.object.toString());
            }
            return null;
        }
        if ((map = (Map)map.get("object")).containsKey("_id")) {
            map.put("id", String.valueOf(map.get("_id")));
            map.remove("_id");
        }
        if (map.get("status") != null) {
            map.put("status", new ItemLogDetail(map.get("status")).clean(mapper));
        }
        if (this.object instanceof Item) {
            if (map.get("fetchedBy") != null) {
                map.put("fetchedBy", new ItemLogDetail(map.get("fetchedBy")).clean(mapper));
            }
            if (map.get("parent") != null) {
                Map parent = (Map)map.get("parent");
                parent.put("sessionBoards", null);
                parent.put("teamContainers", null);
                parent.put("fetchedBy", null);
                map.put("parent", new ItemLogDetail((Object)parent).clean(mapper));
            }
            if (map.get("teamContainers") != null) {
                map.put("teamContainers", this.toSimpleList((List)map.get("teamContainers"), mapper, map));
                map.remove("tempSequence");
            }
            if (map.get("sessionBoards") != null) {
                List boards = (List)map.get("sessionBoards");
                if (boards != null && boards.size() > 0 && boards.get(0) != null && ((HashMap)boards.get(0)).get("state") != null) {
                    map.put("sessionBoardState", new ItemLogDetail(((HashMap)boards.get(0)).get("state")).clean(mapper));
                }
                map.remove("sessionBoards");
            }
        } else if (this.object instanceof ItemLink) {
            Map user;
            if (map.get("sourceItem") != null) {
                map.put("sourceItem", new ItemLogDetail(map.get("sourceItem")).clean(mapper));
            }
            if (map.get("targetItem") != null) {
                map.put("targetItem", new ItemLogDetail(map.get("targetItem")).clean(mapper));
            }
            if (map.get("wfStatus") != null) {
                map.put("wfStatus", new ItemLogDetail(map.get("wfStatus")).clean(mapper));
            }
            if (map.get("responsible") != null) {
                user = (Map)map.get("responsible");
                map.put("responsible", new /* Unavailable Anonymous Inner Class!! */);
            }
            if (map.get("reporter") != null) {
                user = (Map)map.get("reporter");
                map.put("reporter", new /* Unavailable Anonymous Inner Class!! */);
            }
        } else if (this.object instanceof BaseItem) {
            // empty if block
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (map.get(key) != null) continue;
            it.remove();
        }
        return map;
    }

    public List<Object> toSimpleList(List list, ObjectMapper mapper, Map<String, Object> rootItem) {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        ArrayList<Object> list2 = new ArrayList<Object>();
        Iterator it2 = list.iterator();
        Item us = null;
        SessionBoard sb = null;
        if (this.object instanceof Item && PropertyValidator.isValid((Collection)(us = (Item)this.object).getSessionBoards())) {
            sb = (SessionBoard)us.getSessionBoards().get(0);
        }
        int index = -1;
        while (it2.hasNext()) {
            ++index;
            Map map = new ItemLogDetail(it2.next()).clean(mapper);
            if (rootItem != null) {
                this.parseTeamContainers(mapper, rootItem, map, sb);
            }
            list2.add(map);
        }
        return list2;
    }

    private void parseTeamContainers(ObjectMapper mapper, Map<String, Object> rootItem, Map<String, Object> ittMap, SessionBoard sb) {
        int i;
        if (ittMap.get("team") != null) {
            Map team = (Map)ittMap.get("team");
            if (team != null && (team.get("title") == null || team.get("label") == null) && sb != null) {
                if (PropertyValidator.isValid((Object)sb) && sb.getTeams() != null) {
                    for (i = 0; i < sb.getTeams().size(); ++i) {
                        if (!((Team)sb.getTeams().get(i)).getId().equals(team.get("id"))) continue;
                        team = new ItemLogDetail(sb.getTeams().get(i)).clean(mapper);
                        break;
                    }
                }
            } else {
                team = new ItemLogDetail((Object)team).clean(mapper);
            }
            ittMap.put("team", team);
        }
        if (ittMap.get("container") != null) {
            Map container = (Map)ittMap.get("container");
            if (container != null && (container.get("title") == null || container.get("label") == null) && sb != null) {
                if (PropertyValidator.isValid((Object)sb) && sb.getContainers() != null) {
                    for (i = 0; i < sb.getContainers().size(); ++i) {
                        if (!((Container)sb.getContainers().get(i)).getId().equals(container.get("id"))) continue;
                        container = new ItemLogDetail(sb.getContainers().get(i)).clean(mapper);
                        break;
                    }
                }
            } else {
                container = new ItemLogDetail((Object)container).clean(mapper);
            }
            ittMap.put("container", container);
            Double seq = (Double)container.get("sequence");
            if (Item.Type.Feature.name().equals(rootItem.get("type")) && (rootItem.get("tempSequence") == null || seq > (Double)rootItem.get("tempSequence"))) {
                rootItem.put("tempSequence", seq);
                rootItem.put(ItemLog.Changes.phoenixSequence.name(), seq);
                rootItem.put("phoenixTC", ittMap);
                ((Item)this.object).setPhoenixSequence(seq);
            }
        }
    }
}

