/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.google.gson.Gson;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssueFields;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.vos.ItemLinkVO;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import org.joda.time.LocalDateTime;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

@GenerateLog
public class Item
extends BaseEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(Item.class);
    @PushField
    @GenerateFieldlog
    private String title;
    @PushField
    @GenerateFieldlog
    private String description;
    @PushField
    @GenerateFieldlog
    private String type;
    @PushField
    @GenerateFieldlog
    private Double storyPoints = 0.0;
    @Transient
    private String storyPointsValue;
    @PushField
    @GenerateFieldlog
    private Date dueDate;
    private Date lastSyncDate;
    @PushField
    private Double sequence = new Double(System.nanoTime() / 100000L);
    @PushField
    private Double backlogSequence = new Double(System.nanoTime() / 100000L);
    @PushField
    private Double subItemEstimate = 0.0;
    @PushField
    private JiraIssueLinkType linkType;
    @PushField
    private List<JiraIssueLinkType> linkTypes;
    @PushField
    private Map<String, List<JiraIssueLinkType>> linkTypesByKey;
    @PushField
    private List<String> tfsLinkTypes;
    @PushField
    public static String USER_STORY = "UserStory";
    @PushField
    public static String FEATURE = "Feature";
    @PushField
    public static String EPIC = "Epic";
    @PushField
    @GenerateFieldlog
    @DBRef(lazy=true)
    private Status status;
    @PushField
    @DBRef(lazy=true)
    private Item parent;
    @PushField
    private String externalReferenceURL;
    @PushField
    private String jiraId;
    @PushField
    @GenerateFieldlog
    private String tfsId;
    @PushField
    @GenerateFieldlog
    private String tfsURL;
    @PushField
    private String tfsApiURL;
    @PushField
    @GenerateFieldlog
    private String tfsProjectId;
    @PushField
    @GenerateFieldlog
    private String tfsProject;
    @PushField
    @GenerateFieldlog
    private String tfsItemType;
    @PushField
    @GenerateFieldlog
    private String tfsItemTypeIcon;
    @PushField
    private String tfsFilter;
    @PushField
    private String tfsAreaPath;
    @PushField
    private String tfsIterationPath;
    @PushField
    private String almId;
    @PushField
    @GenerateFieldlog
    private String kendisKey;
    @PushField
    @GenerateFieldlog
    private String kendisId;
    @PushField
    @GenerateFieldlog
    private String jiraKey;
    @PushField
    private String jiraFilter;
    @PushField
    private Set<String> taggedFilters;
    @PushField
    private String jiraProjectKey;
    @PushField
    private String jiraIssueTypeId;
    @PushField
    private JiraIssueType jiraIssueType;
    @PushField
    @GenerateFieldlog
    private String jiraURL;
    private HashMap<String, Object> mapJiraFields;
    @PushField
    @DBRef(lazy=true)
    private List<ItemLink> itemLinks;
    @PushField
    @DBRef(lazy=true)
    private ArrayList<ItemLink> solutionSourceItemLinks;
    @PushField
    @DBRef(lazy=true)
    private ArrayList<ItemLink> solutionTargetItemLinks;
    @PushField
    @DBRef(lazy=true)
    private List<ItemJiraDependency> jiraDependencies;
    @PushField
    @DBRef(lazy=true)
    private List<ItemJiraDependency> solutionAlmDependencies;
    @PushField
    @DBRef(lazy=true)
    private List<SessionBoard> sessionBoards;
    @DBRef(lazy=true)
    private SolutionBoard solutionBoard;
    @PushField
    @GenerateFieldlog
    @DBRef(lazy=false)
    private List<TeamContainer> teamContainers;
    @Transient
    private HashMap<String, Object> jiraItemJson;
    @Transient
    private List<ItemLinkVO> itemLinksVO = null;
    @Transient
    private Map<String, Object> states = new HashMap();
    @PushField
    private Boolean isEnabler = Boolean.FALSE;
    @PushField
    private Boolean errorInAlmSync = Boolean.FALSE;
    @PushField
    private Boolean almWarning = Boolean.FALSE;
    @PushField
    private String almErrorMessage;
    private String compositeJiraKey;
    private boolean deletedInJira = Boolean.FALSE;
    private String oldJiraKey;
    @Transient
    private String webHookActivityBy;
    @PushField
    @GenerateFieldlog
    @DBRef
    private IssueType issueType;
    @Transient
    private HashMap<String, Boolean> issueTypes;
    private Long webhookSequence;
    private List<ItemJiraFieldMap> jiraFieldMap;
    private Map<String, Object> jiraFieldByKey;
    @Transient
    private Map<String, String> jiraFieldTextByKey;
    @PushField
    private Map<String, Object> tfsFieldByKey;
    @PushField
    private List<ItemJiraFieldMap> tfsFieldMap;
    private List<Map<String, String>> tfsRelations;
    @Transient
    private boolean syncStoryPoints = true;
    @Transient
    private boolean syncDueDate = true;
    @PushField
    @GenerateFieldlog
    private Boolean flagged = Boolean.FALSE;
    private Double phoenixSequence;
    @Transient
    private TeamContainer phoenixTC;
    @Transient
    private boolean multipleExistence;
    @Transient
    public String parentKey;
    @Transient
    private Team team;
    @Transient
    private Container container;
    private List<Risk> linkedRisks;
    @DBRef
    private User fetchedBy;
    @PushField
    @GenerateFieldlog
    private Date startDate;
    @PushField
    @GenerateFieldlog
    private Date endDate;
    @Transient
    private Object oldState;
    @PushField
    @GenerateFieldlog
    private Double score;
    @PushField
    @GenerateFieldlog
    private Double almScoreField;
    @PushField
    @GenerateFieldlog
    private Map<String, Object> scoreParams;
    private List<String> childItems;
    @Transient
    private List<Item> subItems;
    @Transient
    private String recoveryItemLinkId;
    private String almRevision;
    private Date almUpdatedOn;
    @GenerateFieldlog
    @DBRef
    private List<BaseItemLink> baseItemLinks;
    @PushField
    private Map<String, Object> fields;
    @GenerateFieldlog
    private Boolean starred;
    @PushField
    @DBRef
    private ItemType itemType;
    private Boolean notifyWatchers = true;
    private Long jiraWebhookTimeStamp;
    @Transient
    private Boolean syncWithART;
    @Transient
    private Boolean isAlmLinked;
    @Transient
    private Boolean sendToAlm;
    @Transient
    private List<BaseItem> batches = new ArrayList();

    public String getTfsItemTypeIcon() {
        return this.tfsItemTypeIcon;
    }

    public void setTfsItemTypeIcon(String tfsItemTypeIcon) {
        this.tfsItemTypeIcon = tfsItemTypeIcon;
    }

    public String getTfsIterationPath() {
        return this.tfsIterationPath;
    }

    public void setTfsIterationPath(String tfsIterationPath) {
        this.tfsIterationPath = tfsIterationPath;
    }

    public Item() {
    }

    public Item(String id) {
        super(id);
    }

    public Item(Item itemVo) {
        super(itemVo.id);
        this.title = itemVo.title;
        this.tfsId = itemVo.tfsId;
        this.tfsApiURL = itemVo.tfsApiURL;
        this.tfsURL = itemVo.tfsURL;
        this.tfsItemType = itemVo.tfsItemType;
        this.tfsItemTypeIcon = itemVo.tfsItemTypeIcon;
        this.tfsProject = itemVo.tfsProject;
        this.tfsProjectId = itemVo.tfsProjectId;
        this.tfsLinkTypes = itemVo.tfsLinkTypes;
        this.tfsFilter = itemVo.tfsFilter;
        this.tfsFieldMap = itemVo.tfsFieldMap;
        this.tfsAreaPath = itemVo.tfsAreaPath;
        this.tfsIterationPath = itemVo.tfsIterationPath;
        this.tfsFieldByKey = itemVo.tfsFieldByKey;
        this.setOriginItemId(itemVo.getOriginItemId());
        this.kendisKey = itemVo.kendisKey;
        this.description = itemVo.description;
        this.type = itemVo.type;
        this.storyPoints = itemVo.storyPoints;
        this.dueDate = itemVo.dueDate;
        this.startDate = itemVo.startDate;
        this.endDate = itemVo.endDate;
        this.sequence = itemVo.sequence;
        this.score = itemVo.score;
        this.almScoreField = itemVo.almScoreField;
        this.scoreParams = itemVo.scoreParams;
        this.backlogSequence = itemVo.backlogSequence;
        if (PropertyValidator.isValid((Object)itemVo.status)) {
            this.status = new Status(itemVo.status.getId(), itemVo.status.getTitle(), itemVo.status.getColor(), itemVo.status.getCategory());
        }
        if (PropertyValidator.isValid((Object)itemVo.parent)) {
            this.parent = new Item(itemVo.parent.getId());
            this.parent.setFlagged(itemVo.parent.getFlagged());
        }
        if (PropertyValidator.isValid((Collection)itemVo.linkTypes)) {
            this.linkTypes = new ArrayList();
            for (JiraIssueLinkType linkType : itemVo.linkTypes) {
                if (!PropertyValidator.isValid((Object)linkType)) continue;
                this.linkTypes.add(linkType);
            }
        }
        this.subItemEstimate = itemVo.subItemEstimate;
        this.jiraId = itemVo.jiraId;
        this.jiraKey = itemVo.jiraKey;
        this.jiraFilter = itemVo.jiraFilter;
        this.flagged = itemVo.flagged;
        if (PropertyValidator.isValid((Collection)itemVo.itemLinks)) {
            this.itemLinks = new ArrayList();
            for (ItemLink itemLink : itemVo.itemLinks) {
                if (!PropertyValidator.isValid((Object)itemLink)) continue;
                this.itemLinks.add(itemLink);
            }
        }
        if (PropertyValidator.isValid((Collection)itemVo.jiraDependencies)) {
            this.jiraDependencies = itemVo.getJiraDependencies();
        }
        this.jiraIssueTypeId = itemVo.jiraIssueTypeId;
        this.errorInAlmSync = itemVo.errorInAlmSync;
        this.almWarning = itemVo.almWarning;
        this.almErrorMessage = itemVo.almErrorMessage;
        this.externalReferenceURL = itemVo.externalReferenceURL;
        if (PropertyValidator.isValid((Collection)itemVo.teamContainers)) {
            this.teamContainers = new ArrayList();
            itemVo.teamContainers.forEach(tc -> {
                if (PropertyValidator.isValid((Object)tc) && PropertyValidator.isValid((Object)tc.getId()) && PropertyValidator.isValid((Object)tc.getTeam()) && PropertyValidator.isValid((Object)tc.getTeam().getId()) && PropertyValidator.isValid((Object)tc.getContainer()) && PropertyValidator.isValid((Object)tc.getContainer().getId())) {
                    TeamContainer ntc = new TeamContainer(tc.getId(), new Team(tc.getTeam().getId(), tc.getTeam().getTitle(), tc.getTeam().getColor(), tc.getTeam().getOriginItemId(), tc.getTeam().getDuplicateOfId()), new Container(tc.getContainer().getId(), tc.getContainer().getTitle(), tc.getContainer().getSequence(), tc.getContainer().getOriginItemId(), tc.getContainer().getDuplicateOfId()), tc.getSequence(), tc.getOriginItemId(), tc.getDuplicateOfId());
                    this.teamContainers.add(ntc);
                }
            });
        }
        if (PropertyValidator.isValid((Object)this.isEnabler)) {
            this.isEnabler = itemVo.isEnabler;
        }
        if (PropertyValidator.isValid((Object)itemVo.issueType)) {
            this.issueType = itemVo.issueType;
        }
        this.deletedInJira = itemVo.deletedInJira;
    }

    public Item(Item itemVo, Boolean isReport) {
        super(itemVo.id);
        this.title = itemVo.title;
        this.description = itemVo.description;
        this.type = itemVo.type;
        this.storyPoints = itemVo.storyPoints;
        this.dueDate = itemVo.dueDate;
        this.startDate = itemVo.startDate;
        this.endDate = itemVo.endDate;
        this.sequence = itemVo.sequence;
        this.backlogSequence = itemVo.backlogSequence;
        this.flagged = itemVo.flagged;
        this.tfsId = itemVo.tfsId;
        this.tfsApiURL = itemVo.tfsApiURL;
        this.tfsURL = itemVo.tfsURL;
        this.tfsItemType = itemVo.tfsItemType;
        this.tfsItemTypeIcon = itemVo.tfsItemTypeIcon;
        this.tfsProject = itemVo.tfsProject;
        this.tfsProjectId = itemVo.tfsProjectId;
        this.tfsLinkTypes = itemVo.tfsLinkTypes;
        this.tfsFilter = itemVo.tfsFilter;
        this.tfsFieldMap = itemVo.tfsFieldMap;
        this.tfsAreaPath = itemVo.tfsAreaPath;
        this.tfsIterationPath = itemVo.tfsIterationPath;
        this.setOriginItemId(itemVo.getOriginItemId());
        if (PropertyValidator.isValid((Object)itemVo.status)) {
            this.status = new Status(itemVo.status.getId(), itemVo.status.getTitle(), itemVo.status.getColor(), itemVo.status.getCategory());
        }
        if (PropertyValidator.isValid((Object)itemVo.parent)) {
            this.parent = new Item(itemVo.parent.getId());
            this.parent.setJiraId(itemVo.parent.getJiraId());
            this.parent.setIssueType(itemVo.parent.getIssueType());
        }
        this.subItemEstimate = itemVo.subItemEstimate;
        this.jiraId = itemVo.jiraId;
        this.jiraKey = itemVo.jiraKey;
        this.jiraFilter = itemVo.jiraFilter;
        this.itemLinks = itemVo.itemLinks;
        if (PropertyValidator.isValid((Collection)itemVo.itemLinks)) {
            this.itemLinks = new ArrayList();
            for (ItemLink itemLink : itemVo.itemLinks) {
                if (!PropertyValidator.isValid((Object)itemLink)) continue;
                this.itemLinks.add(itemLink);
            }
        }
        if (PropertyValidator.isValid((Collection)itemVo.jiraDependencies)) {
            this.jiraDependencies = new ArrayList();
            for (ItemJiraDependency dependency : itemVo.jiraDependencies) {
                if (!PropertyValidator.isValid((Object)dependency)) continue;
                this.jiraDependencies.add(dependency);
            }
        }
        this.jiraIssueTypeId = itemVo.jiraIssueTypeId;
        this.errorInAlmSync = itemVo.errorInAlmSync;
        this.almWarning = itemVo.almWarning;
        this.externalReferenceURL = itemVo.externalReferenceURL;
        if (PropertyValidator.isValid((Collection)itemVo.teamContainers)) {
            this.teamContainers = new ArrayList();
            itemVo.teamContainers.forEach(tc -> {
                if (PropertyValidator.isValid((Object)tc) && PropertyValidator.isValid((Object)tc.getId()) && PropertyValidator.isValid((Object)tc.getTeam()) && PropertyValidator.isValid((Object)tc.getTeam().getId()) && PropertyValidator.isValid((Object)tc.getContainer()) && PropertyValidator.isValid((Object)tc.getContainer().getId())) {
                    TeamContainer ntc = new TeamContainer(tc.getId(), new Team(tc.getTeam().getId(), tc.getTeam().getTitle(), tc.getTeam().getColor(), tc.getTeam().getOriginItemId(), tc.getTeam().getDuplicateOfId()), new Container(tc.getContainer().getId(), tc.getContainer().getTitle(), tc.getContainer().getSequence(), tc.getContainer().getOriginItemId(), tc.getContainer().getDuplicateOfId()), tc.getSequence(), tc.getOriginItemId(), tc.getDuplicateOfId());
                    ntc.getTeam().setColor(tc.getTeam().getColor());
                    ntc.getTeam().setLabel(tc.getTeam().getLabel());
                    ntc.getContainer().setLabel(tc.getContainer().getLabel());
                    this.teamContainers.add(ntc);
                }
            });
        }
        if (PropertyValidator.isValid((Object)this.isEnabler)) {
            this.isEnabler = itemVo.isEnabler;
        }
        if (PropertyValidator.isValid((Object)itemVo.issueType)) {
            this.issueType = itemVo.issueType;
        }
        this.deletedInJira = itemVo.deletedInJira;
        if (PropertyValidator.isValid((Collection)itemVo.sessionBoards)) {
            this.sessionBoards = new ArrayList();
            for (SessionBoard sb : itemVo.sessionBoards) {
                SessionBoard sbCopy = new SessionBoard(sb.id);
                Session s = new Session();
                s.setId(sb.getSession().getId());
                s.setTitle(sb.getSession().getTitle());
                if (isReport.booleanValue()) {
                    s.setParentItem(sb.getSession().getParentItem());
                    s.setChildItem(sb.getSession().getChildItem());
                    s.setJiraFlaggedFieldEnabled(sb.getSession().getJiraFlaggedFieldEnabled());
                    s.setKendisFlaggedFieldEnabled(sb.getSession().getKendisFlaggedFieldEnabled());
                    s.setAlmEnabled(sb.getSession().getAlmEnabled());
                    s.setAlmConfigurations(sb.getSession().getAlmConfigurations());
                    s.setDependencyPrefix(sb.getSession().getDependencyPrefix());
                }
                sbCopy.setSession(s);
                this.sessionBoards.add(sbCopy);
            }
        }
        this.createdBy = itemVo.createdBy;
        this.createdOn = itemVo.createdOn;
        this.updatedBy = itemVo.updatedBy;
        this.updatedOn = itemVo.updatedOn;
    }

    public Item(DBObject itemVo, Status status, IssueType issueType, Item parent, ArrayList<ItemLink> ssItemLinks, ArrayList<ItemLink> stItemLinks, ArrayList<ItemJiraDependency> almLinks, ArrayList<ItemJiraDependency> almSolLinks, ArrayList<TeamContainer> teamContainers, ArrayList<JiraIssueLinkType> jiraLinkTypes) {
        super(String.valueOf(itemVo.get("_id")));
        this.kendisKey = (String)itemVo.get("kendisKey");
        this.title = (String)itemVo.get("title");
        this.description = (String)itemVo.get("description");
        this.type = (String)itemVo.get("type");
        this.storyPoints = (Double)itemVo.get("storyPoints");
        this.dueDate = (Date)itemVo.get("dueDate");
        this.startDate = (Date)itemVo.get("startDate");
        this.endDate = (Date)itemVo.get("endDate");
        this.sequence = (Double)itemVo.get("sequence");
        this.backlogSequence = (Double)itemVo.get("backlogSequence");
        this.flagged = (Boolean)itemVo.get("flagged");
        this.setOriginItemId((String)itemVo.get("originItemId"));
        this.setDuplicateOfId((String)itemVo.get("duplicateOfId"));
        this.status = status;
        this.parent = parent;
        this.almId = (String)itemVo.get("almId");
        this.tfsId = (String)itemVo.get("tfsId");
        this.tfsApiURL = (String)itemVo.get("tfsApiURL");
        this.tfsURL = (String)itemVo.get("tfsURL");
        this.jiraURL = (String)itemVo.get("jiraURL");
        this.tfsItemType = (String)itemVo.get("tfsItemType");
        this.tfsItemTypeIcon = (String)itemVo.get("tfsItemTypeIcon");
        this.tfsProject = (String)itemVo.get("tfsProject");
        this.tfsProjectId = (String)itemVo.get("tfsProjectId");
        this.tfsFilter = (String)itemVo.get("tfsFilter");
        this.tfsAreaPath = (String)itemVo.get("tfsAreaPath");
        this.tfsIterationPath = (String)itemVo.get("tfsIterationPath");
        BasicDBList _tfsLinkTypes = (BasicDBList)itemVo.get("tfsLinkTypes");
        if (PropertyValidator.isValid((Collection)_tfsLinkTypes)) {
            ArrayList<String> tfsLinkTypes = new ArrayList<String>();
            for (Object value : _tfsLinkTypes) {
                tfsLinkTypes.add(value.toString());
            }
            this.tfsLinkTypes = tfsLinkTypes;
        }
        if (itemVo.get("tfsFieldMap") != null) {
            BasicDBList _tfsFieldMap = (BasicDBList)itemVo.get("tfsFieldMap");
            ArrayList<ItemJiraFieldMap> tfsFieldMap = new ArrayList<ItemJiraFieldMap>();
            for (int i = 0; i < _tfsFieldMap.size(); ++i) {
                if (!PropertyValidator.isValid((Object)_tfsFieldMap.get(i))) continue;
                DBObject obj = (DBObject)_tfsFieldMap.get(i);
                tfsFieldMap.add(new ItemJiraFieldMap(obj));
            }
            this.tfsFieldMap = tfsFieldMap;
        }
        if (itemVo.get("tfsFieldByKey") != null) {
            DBObject _tfsFieldByKey = (DBObject)itemVo.get("tfsFieldByKey");
            this.tfsFieldByKey = (Map)_tfsFieldByKey;
        }
        if (itemVo.get("jiraFieldTextByKey") != null) {
            DBObject _jiraFieldTextByKey = (DBObject)itemVo.get("jiraFieldTextByKey");
            this.jiraFieldTextByKey = (Map)_jiraFieldTextByKey;
        }
        this.subItemEstimate = (Double)itemVo.get("subItemEstimate");
        this.jiraId = (String)itemVo.get("jiraId");
        this.jiraKey = (String)itemVo.get("jiraKey");
        this.jiraFilter = (String)itemVo.get("jiraFilter");
        this.jiraProjectKey = (String)itemVo.get("jiraProjectKey");
        this.almRevision = (String)itemVo.get("almRevision");
        this.solutionSourceItemLinks = ssItemLinks;
        this.itemLinks = stItemLinks;
        this.jiraDependencies = almLinks;
        this.jiraIssueTypeId = (String)itemVo.get("jiraIssueTypeId");
        this.errorInAlmSync = (Boolean)itemVo.get("errorInAlmSync");
        this.almWarning = (Boolean)itemVo.get("almWarning");
        this.externalReferenceURL = (String)itemVo.get("externalReferenceURL");
        this.score = (Double)itemVo.get("score");
        this.almScoreField = (Double)itemVo.get("almScoreField");
        this.scoreParams = (Map)itemVo.get("scoreParams");
        this.teamContainers = teamContainers;
        Object isEnabler = itemVo.get("isEnabler");
        if (PropertyValidator.isValid((Object)isEnabler)) {
            this.isEnabler = (Boolean)isEnabler;
        }
        this.issueType = issueType;
        this.deletedInJira = (Boolean)itemVo.get("deletedInJira");
        if (PropertyValidator.isValid(jiraLinkTypes)) {
            this.linkTypes = jiraLinkTypes;
        }
        this.createdBy = (String)itemVo.get("createdBy");
        this.createdOn = (Date)itemVo.get("createdOn");
        this.updatedBy = (String)itemVo.get("updatedBy");
        this.updatedOn = (Date)itemVo.get("updatedOn");
        if (PropertyValidator.isValid((Object)itemVo.get("fields"))) {
            this.setFields((Map)itemVo.get("fields"));
        }
    }

    public Item(DBObject itemVo, SessionBoard sessionBoard, Status status, IssueType issueType, Item parent, ArrayList<ItemLink> itemLinks, ArrayList<ItemJiraDependency> jiraLinks, ArrayList<TeamContainer> teamContainers, ArrayList<JiraIssueLinkType> jiraLinkTypes) {
        super(String.valueOf(itemVo.get("_id")));
        DBObject _tfsFieldByKey;
        this.kendisKey = (String)itemVo.get("kendisKey");
        this.kendisId = (String)itemVo.get("kendisId");
        this.title = (String)itemVo.get("title");
        this.description = (String)itemVo.get("description");
        this.type = (String)itemVo.get("type");
        this.storyPoints = (Double)itemVo.get("storyPoints");
        this.dueDate = (Date)itemVo.get("dueDate");
        this.startDate = (Date)itemVo.get("startDate");
        this.endDate = (Date)itemVo.get("endDate");
        this.sequence = (Double)itemVo.get("sequence");
        this.backlogSequence = (Double)itemVo.get("backlogSequence");
        this.flagged = (Boolean)itemVo.get("flagged");
        this.setOriginItemId((String)itemVo.get("originItemId"));
        this.setDuplicateOfId((String)itemVo.get("duplicateOfId"));
        this.status = status;
        this.parent = parent;
        this.tfsId = (String)itemVo.get("tfsId");
        this.tfsApiURL = (String)itemVo.get("tfsApiURL");
        this.tfsURL = (String)itemVo.get("tfsURL");
        this.tfsItemType = (String)itemVo.get("tfsItemType");
        this.tfsItemTypeIcon = (String)itemVo.get("tfsItemTypeIcon");
        this.tfsProject = (String)itemVo.get("tfsProject");
        this.tfsProjectId = (String)itemVo.get("tfsProjectId");
        this.tfsFilter = (String)itemVo.get("tfsFilter");
        this.tfsAreaPath = (String)itemVo.get("tfsAreaPath");
        this.tfsIterationPath = (String)itemVo.get("tfsIterationPath");
        this.score = (Double)itemVo.get("score");
        this.almScoreField = (Double)itemVo.get("almScoreField");
        this.scoreParams = (Map)itemVo.get("scoreParams");
        this.almRevision = (String)itemVo.get("almRevision");
        BasicDBList _tfsLinkTypes = (BasicDBList)itemVo.get("tfsLinkTypes");
        if (PropertyValidator.isValid((Collection)_tfsLinkTypes)) {
            ArrayList<String> tfsLinkTypes = new ArrayList<String>();
            for (Object value : _tfsLinkTypes) {
                tfsLinkTypes.add(value.toString());
            }
            this.tfsLinkTypes = tfsLinkTypes;
        }
        if (itemVo.get("tfsFieldMap") != null) {
            BasicDBList _tfsFieldMap = (BasicDBList)itemVo.get("tfsFieldMap");
            ArrayList<ItemJiraFieldMap> tfsFieldMap = new ArrayList<ItemJiraFieldMap>();
            for (int i = 0; i < _tfsFieldMap.size(); ++i) {
                if (!PropertyValidator.isValid((Object)_tfsFieldMap.get(i))) continue;
                DBObject obj = (DBObject)_tfsFieldMap.get(i);
                tfsFieldMap.add(new ItemJiraFieldMap(obj));
            }
            this.tfsFieldMap = tfsFieldMap;
        }
        if (itemVo.get("tfsFieldByKey") != null) {
            _tfsFieldByKey = (DBObject)itemVo.get("tfsFieldByKey");
            this.tfsFieldByKey = (Map)_tfsFieldByKey;
        }
        if (itemVo.get("jiraFieldByKey") != null) {
            _tfsFieldByKey = (DBObject)itemVo.get("jiraFieldByKey");
            this.jiraFieldByKey = (Map)_tfsFieldByKey;
        }
        if (itemVo.get("fields") != null) {
            this.setFields((Map)itemVo.get("fields"));
        }
        this.subItemEstimate = (Double)itemVo.get("subItemEstimate");
        this.jiraId = (String)itemVo.get("jiraId");
        this.jiraKey = (String)itemVo.get("jiraKey");
        this.jiraFilter = (String)itemVo.get("jiraFilter");
        this.jiraURL = (String)itemVo.get("jiraURL");
        this.jiraProjectKey = (String)itemVo.get("jiraProjectKey");
        if (PropertyValidator.isValid(itemLinks)) {
            this.itemLinks = itemLinks;
        }
        if (PropertyValidator.isValid(jiraLinks)) {
            this.jiraDependencies = jiraLinks;
        }
        this.jiraIssueTypeId = (String)itemVo.get("jiraIssueTypeId");
        this.errorInAlmSync = (Boolean)itemVo.get("errorInAlmSync");
        this.almWarning = (Boolean)itemVo.get("almWarning");
        this.externalReferenceURL = (String)itemVo.get("externalReferenceURL");
        this.teamContainers = teamContainers;
        Object isEnabler = itemVo.get("isEnabler");
        if (PropertyValidator.isValid((Object)isEnabler)) {
            this.isEnabler = (Boolean)isEnabler;
        }
        this.issueType = issueType;
        this.deletedInJira = (Boolean)itemVo.get("deletedInJira");
        if (PropertyValidator.isValid((Object)sessionBoard)) {
            this.sessionBoards = new ArrayList();
            SessionBoard sbCopy = new SessionBoard(sessionBoard.getId());
            Session s = new Session();
            s.setId(sessionBoard.getSession().getId());
            s.setTitle(sessionBoard.getSession().getTitle());
            s.setParentItem(sessionBoard.getSession().getParentItem());
            s.setChildItem(sessionBoard.getSession().getChildItem());
            s.setJiraFlaggedFieldEnabled(sessionBoard.getSession().getJiraFlaggedFieldEnabled());
            s.setKendisFlaggedFieldEnabled(sessionBoard.getSession().getKendisFlaggedFieldEnabled());
            s.setScoreCard(sessionBoard.getSession().getScoreCard());
            sbCopy.setSession(s);
            this.sessionBoards.add(sbCopy);
        }
        if (PropertyValidator.isValid(jiraLinkTypes)) {
            this.linkTypes = jiraLinkTypes;
        }
        this.createdBy = (String)itemVo.get("createdBy");
        this.createdOn = (Date)itemVo.get("createdOn");
        this.updatedBy = (String)itemVo.get("updatedBy");
        this.updatedOn = (Date)itemVo.get("updatedOn");
        this.startDate = (Date)itemVo.get("startDate");
        this.endDate = (Date)itemVo.get("endDate");
    }

    public Item(String id, String title, String description, String type, Double storyPoints, Date dueDate, Date startDate, Date endDate, Double sequence, Status status, Boolean flagged, Item parent, String jiraId, String jiraKey, String tfsId, List<ItemLink> itemLinks, List<TeamContainer> teamContainers, Boolean isEnabler) {
        super(id);
        this.title = title;
        this.description = description;
        this.type = type;
        this.storyPoints = storyPoints;
        this.dueDate = dueDate;
        this.startDate = startDate;
        this.endDate = endDate;
        this.sequence = sequence;
        this.flagged = flagged;
        if (PropertyValidator.isValid((Object)status)) {
            this.status = new Status(status.getId(), status.getTitle());
        }
        if (PropertyValidator.isValid((Object)parent)) {
            this.parent = new Item(parent.getId());
        }
        this.jiraId = jiraId;
        this.jiraKey = jiraKey;
        this.tfsId = tfsId;
        this.itemLinks = itemLinks;
        if (PropertyValidator.isValid(teamContainers)) {
            this.teamContainers = new ArrayList();
            teamContainers.forEach(tc -> {
                TeamContainer ntc = new TeamContainer(tc.getId(), tc.getTeam(), tc.getContainer(), tc.getSequence(), tc.getOriginItemId(), tc.getDuplicateOfId());
                this.teamContainers.add(ntc);
            });
        }
        if (PropertyValidator.isValid((Object)isEnabler)) {
            this.isEnabler = isEnabler;
        }
    }

    public Item getParent(Item itemVo, boolean lazyFetch) {
        Item parent = new Item();
        parent.setId(itemVo.getId());
        parent.setTitle(itemVo.getTitle());
        parent.setTfsId(itemVo.getTfsId());
        parent.setTfsApiURL(itemVo.getTfsApiURL());
        parent.setTfsURL(itemVo.getTfsURL());
        parent.setTfsItemType(itemVo.getTfsItemType());
        parent.setTfsProject(itemVo.getTfsProject());
        parent.setTfsProjectId(itemVo.getTfsProjectId());
        parent.setTfsLinkTypes(itemVo.getTfsLinkTypes());
        parent.setTfsFilter(itemVo.getTfsFilter());
        parent.setTfsFieldMap(itemVo.getTfsFieldMap());
        parent.setTfsAreaPath(itemVo.getTfsAreaPath());
        parent.setTfsIterationPath(itemVo.getTfsIterationPath());
        parent.setAlmRevision(itemVo.getAlmRevision());
        parent.setOriginItemId(itemVo.getOriginItemId());
        parent.setTfsFieldByKey(itemVo.getTfsFieldByKey());
        parent.setKendisKey(itemVo.getKendisKey());
        parent.setDescription(itemVo.getDescription());
        parent.setType(itemVo.getType());
        parent.setStoryPoints(itemVo.getStoryPoints());
        parent.setDueDate(itemVo.getDueDate());
        parent.setSequence(itemVo.getSequence());
        parent.setBacklogSequence(itemVo.getBacklogSequence());
        if (lazyFetch) {
            if (PropertyValidator.isValid((Object)itemVo.getStatus())) {
                parent.setStatus(new Status(itemVo.getStatus().getId(), itemVo.getStatus().getTitle(), itemVo.getStatus().getColor(), itemVo.getStatus().getCategory()));
            }
            if (PropertyValidator.isValid((Object)itemVo.getParent())) {
                parent.setParent(new Item(itemVo.getParent().getId()));
                parent.getParent().setFlagged(itemVo.getParent().getFlagged());
            }
            if (PropertyValidator.isValid((Collection)itemVo.getLinkTypes())) {
                parent.setLinkTypes(new ArrayList());
                for (JiraIssueLinkType linkType : itemVo.getLinkTypes()) {
                    if (!PropertyValidator.isValid((Object)linkType)) continue;
                    parent.getLinkTypes().add(linkType);
                }
            }
            parent.setSubItemEstimate(itemVo.getSubItemEstimate());
            parent.setJiraId(itemVo.getJiraId());
            parent.setJiraKey(itemVo.getJiraKey());
            parent.setJiraFilter(itemVo.getJiraFilter());
            parent.setFlagged(itemVo.getFlagged());
            if (PropertyValidator.isValid((Collection)itemVo.getItemLinks())) {
                parent.setItemLinks(new ArrayList());
                for (ItemLink itemLink : itemVo.getItemLinks()) {
                    if (!PropertyValidator.isValid((Object)itemLink)) continue;
                    parent.getItemLinks().add(itemLink);
                }
            }
            if (PropertyValidator.isValid((Collection)itemVo.getJiraDependencies())) {
                parent.setJiraDependencies(itemVo.getJiraDependencies());
            }
            parent.setJiraIssueTypeId(itemVo.getJiraIssueTypeId());
            parent.setErrorInAlmSync(itemVo.getErrorInAlmSync());
            parent.setAlmWarning(itemVo.getAlmWarning());
            parent.setAlmErrorMessage(itemVo.getAlmErrorMessage());
            parent.setExternalReferenceURL(itemVo.getExternalReferenceURL());
            if (PropertyValidator.isValid((Collection)itemVo.getTeamContainers())) {
                parent.setTeamContainers(new ArrayList());
                itemVo.getTeamContainers().forEach(tc -> {
                    if (PropertyValidator.isValid((Object)tc) && PropertyValidator.isValid((Object)tc.getId()) && PropertyValidator.isValid((Object)tc.getTeam()) && PropertyValidator.isValid((Object)tc.getTeam().getId()) && PropertyValidator.isValid((Object)tc.getContainer()) && PropertyValidator.isValid((Object)tc.getContainer().getId())) {
                        TeamContainer ntc = new TeamContainer(tc.getId(), new Team(tc.getTeam().getId(), tc.getTeam().getTitle(), tc.getTeam().getColor(), tc.getTeam().getOriginItemId(), tc.getTeam().getDuplicateOfId()), new Container(tc.getContainer().getId(), tc.getContainer().getTitle(), tc.getContainer().getSequence(), tc.getContainer().getOriginItemId(), tc.getContainer().getDuplicateOfId()), tc.getSequence(), tc.getOriginItemId(), tc.getDuplicateOfId());
                        parent.getTeamContainers().add(ntc);
                    }
                });
            }
            if (PropertyValidator.isValid((Object)itemVo.getIsEnabler())) {
                parent.setIsEnabler(itemVo.getIsEnabler());
            }
            if (PropertyValidator.isValid((Object)itemVo.getIssueType())) {
                parent.setIssueType(itemVo.getIssueType());
            }
            parent.setDeletedInJira(itemVo.isDeletedInJira());
        }
        return parent;
    }

    public void assignKey(String key) {
        if (this.getFields() == null) {
            this.setFields(new HashMap());
        }
        this.getFields().put("externalKey", key);
        this.getFields().put("externalLink", this.getExternalReferenceURL());
    }

    public String plainId() {
        if (this.jiraId != null) {
            return this.jiraId;
        }
        if (this.tfsId != null) {
            return this.tfsId;
        }
        return this.id;
    }

    public Item getParent() {
        return this.parent;
    }

    public void setParent(Item parent) {
        this.parent = parent;
    }

    public List<TeamContainer> getTeamContainers() {
        return this.teamContainers;
    }

    public void setTeamContainers(List<TeamContainer> teamContainers) {
        this.teamContainers = teamContainers;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SessionBoard> getSessionBoards() {
        return this.sessionBoards;
    }

    public void setSessionBoards(List<SessionBoard> sessionBoards) {
        this.sessionBoards = sessionBoards;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Double getStoryPoints() {
        return this.storyPoints;
    }

    public void setStoryPoints(Double storyPoints) {
        this.storyPoints = storyPoints;
    }

    public String getStoryPointsValue() {
        return this.storyPointsValue;
    }

    public void setStoryPointsValue(String storyPointsValue) {
        this.storyPointsValue = storyPointsValue;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public List<ItemLink> getItemLinks() {
        if (PropertyValidator.isValid((Collection)this.itemLinks)) {
            this.itemLinks.remove(null);
        }
        return this.itemLinks;
    }

    public void setItemLinks(List<ItemLink> itemLinks) {
        this.itemLinks = itemLinks;
    }

    public String getJiraId() {
        return this.jiraId;
    }

    public void setJiraId(String jiraId) {
        this.jiraId = jiraId;
    }

    public String getJiraKey() {
        return this.jiraKey;
    }

    public void setJiraKey(String jiraKey) {
        this.jiraKey = jiraKey;
    }

    public String getJiraURL() {
        return this.jiraURL;
    }

    public void setJiraURL(String jiraURL) {
        this.jiraURL = jiraURL;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Item [");
        if (this.jiraProjectKey != null) {
            builder.append("jiraProjectKey=");
            builder.append(this.jiraProjectKey);
            builder.append(", ");
        }
        if (this.jiraKey != null) {
            builder.append("jiraKey=");
            builder.append(this.jiraKey);
            builder.append(", ");
        }
        if (this.jiraId != null) {
            builder.append("jiraId=");
            builder.append(this.jiraId);
            builder.append(", ");
        }
        if (this.type != null) {
            builder.append("type=");
            builder.append(this.type);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("ID=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.title != null) {
            builder.append("title=");
            builder.append(this.title);
            builder.append(", ");
        }
        if (this.storyPoints != null) {
            builder.append("storyPoints=");
            builder.append(this.storyPoints);
            builder.append(", ");
        }
        if (this.dueDate != null) {
            builder.append("dueDate=");
            builder.append(this.dueDate);
            builder.append(", ");
        }
        if (this.sequence != null) {
            builder.append("sequence=");
            builder.append(this.sequence);
            builder.append(", ");
        }
        if (this.getMetaMap() != null) {
            builder.append("metaMap=");
            builder.append(this.getMetaMap());
            builder.append(", ");
        }
        if (this.parent != null) {
            builder.append("parent=");
            builder.append(this.parent);
            builder.append(", ");
        }
        if (this.sessionBoards != null) {
            builder.append("sessionBoards=");
            builder.append(this.sessionBoards);
            builder.append(", ");
        }
        if (this.teamContainers != null) {
            builder.append("teamContainers=");
            builder.append(this.teamContainers);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
        }
        builder.append("]");
        return builder.toString();
    }

    public HashMap<String, Object> getJiraItemJson() {
        return this.jiraItemJson;
    }

    public void setJiraItemJson(HashMap<String, Object> jiraItemJson) {
        this.jiraItemJson = jiraItemJson;
    }

    public List<ItemLinkVO> getItemLinksVO() {
        return this.itemLinksVO;
    }

    public void setItemLinksVO(List<ItemLinkVO> linkedItems) {
        this.itemLinksVO = linkedItems;
    }

    public Map<String, Object> getStates() {
        return this.states;
    }

    public void setStates(Map<String, Object> states) {
        this.states = states;
    }

    public Boolean getIsEnabler() {
        return this.isEnabler;
    }

    public void setIsEnabler(Boolean isEnabler) {
        this.isEnabler = isEnabler;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        return this.getId() == null || other.getId() == null || this.getId().equals(other.getId());
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getJiraIssueTypeId() {
        return this.jiraIssueTypeId;
    }

    public void setJiraIssueTypeId(String jiraIssueTypeId) {
        this.jiraIssueTypeId = jiraIssueTypeId;
    }

    public Boolean getErrorInAlmSync() {
        return this.errorInAlmSync;
    }

    public void setErrorInAlmSync(Boolean errorInAlmSync) {
        this.errorInAlmSync = errorInAlmSync;
    }

    public String getAlmErrorMessage() {
        return this.almErrorMessage;
    }

    public void setAlmErrorMessage(String almErrorMessage) {
        this.almErrorMessage = almErrorMessage;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public Double getSubItemEstimate() {
        return this.subItemEstimate;
    }

    public void setSubItemEstimate(Double subItemEstimate) {
        this.subItemEstimate = subItemEstimate;
    }

    public Boolean getAlmWarning() {
        return this.almWarning;
    }

    public void setAlmWarning(Boolean almWarning) {
        this.almWarning = almWarning;
    }

    public Double getBacklogSequence() {
        return this.backlogSequence;
    }

    public void setBacklogSequence(Double backlogSequence) {
        this.backlogSequence = backlogSequence;
    }

    public JiraIssueLinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(JiraIssueLinkType linkType) {
        this.linkType = linkType;
    }

    public String getCompositeJiraKey() {
        return this.compositeJiraKey;
    }

    public void setCompositeJiraKey(String compositeJiraKey) {
        this.compositeJiraKey = compositeJiraKey;
    }

    public JiraIssueType getJiraIssueType() {
        return this.jiraIssueType;
    }

    public void setJiraIssueType(JiraIssueType jiraIssueType) {
        this.jiraIssueType = jiraIssueType;
    }

    public String getJiraFilter() {
        return this.jiraFilter;
    }

    public void setJiraFilter(String jiraFilter) {
        this.jiraFilter = jiraFilter;
    }

    public HashMap<String, Object> getMapJiraFields() {
        return this.mapJiraFields;
    }

    public void setMapJiraFields(HashMap<String, Object> mapJiraFields) {
        this.mapJiraFields = mapJiraFields;
    }

    public boolean isDeletedInJira() {
        return this.deletedInJira;
    }

    public void setDeletedInJira(boolean deletedInJira) {
        this.deletedInJira = deletedInJira;
    }

    public String getOldJiraKey() {
        return this.oldJiraKey;
    }

    public void setOldJiraKey(String oldJiraKey) {
        this.oldJiraKey = oldJiraKey;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
    }

    public List<JiraIssueLinkType> getLinkTypes() {
        return this.linkTypes;
    }

    public void setLinkTypes(List<JiraIssueLinkType> linkTypes) {
        this.linkTypes = linkTypes;
    }

    public Map<String, List<JiraIssueLinkType>> getLinkTypesByKey() {
        return this.linkTypesByKey;
    }

    public void setLinkTypesByKey(Map<String, List<JiraIssueLinkType>> linkTypesByKey) {
        this.linkTypesByKey = linkTypesByKey;
    }

    public String getWebHookActivityBy() {
        return this.webHookActivityBy;
    }

    public void setWebHookActivityBy(String webHookActivityBy) {
        this.webHookActivityBy = webHookActivityBy;
    }

    public Long getWebhookSequence() {
        return this.webhookSequence;
    }

    public void setWebhookSequence(Long webhookSequence) {
        this.webhookSequence = webhookSequence;
    }

    public List<ItemJiraFieldMap> getJiraFieldMap() {
        return this.jiraFieldMap;
    }

    public void setJiraFieldMap(List<ItemJiraFieldMap> jiraFieldMap) {
        this.jiraFieldMap = jiraFieldMap;
    }

    public Map<String, Object> getJiraFieldByKey() {
        return this.jiraFieldByKey;
    }

    public void setJiraFieldByKey(Map<String, Object> jiraFieldByKey) {
        this.jiraFieldByKey = jiraFieldByKey;
    }

    public Map<String, String> getJiraFieldTextByKey() {
        return this.jiraFieldTextByKey;
    }

    public void setJiraFieldTextByKey(Map<String, String> jiraFieldTextByKey) {
        this.jiraFieldTextByKey = jiraFieldTextByKey;
    }

    public boolean isSyncStoryPoints() {
        return this.syncStoryPoints;
    }

    public void setSyncStoryPoints(boolean syncStoryPoints) {
        this.syncStoryPoints = syncStoryPoints;
    }

    public boolean isSyncDueDate() {
        return this.syncDueDate;
    }

    public void setSyncDueDate(boolean syncDueDate) {
        this.syncDueDate = syncDueDate;
    }

    public String getExternalReferenceURL() {
        return this.externalReferenceURL;
    }

    public void setExternalReferenceURL(String externalReferenceURL) {
        this.externalReferenceURL = externalReferenceURL;
    }

    public HashMap<String, Boolean> getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(HashMap<String, Boolean> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public boolean isNewMappingAppliedOnItem(List<TeamContainer> subItemExistingTCs, ResyncParamsVO syncUtils) {
        boolean newSubItemMappingApplied = false;
        boolean ifCellHasJiraSprint = false;
        if (PropertyValidator.isValid(subItemExistingTCs)) {
            List indexes;
            TeamContainer usTC = subItemExistingTCs.get(0);
            if (syncUtils.syncMappersByTeamId != null && PropertyValidator.isValid((Object)usTC) && PropertyValidator.isValid((Object)usTC.getTeam()) && PropertyValidator.isValid((Object)usTC.getContainer()) && PropertyValidator.isValid((Object)usTC.getTeam().getId()) && PropertyValidator.isValid((Object)usTC.getContainer().getId()) && PropertyValidator.isValid((Collection)(indexes = (List)syncUtils.syncMappersByTeamId.get(usTC.getTeam().getId())))) {
                for (Integer index : indexes) {
                    ItemSyncMapper x = (ItemSyncMapper)syncUtils.syncMapper.get(index);
                    if (!PropertyValidator.isValid((Object)x.getTeam()) || !PropertyValidator.isValid((Object)x.getContainer()) || !PropertyValidator.isValid((Object)x.getTeam().getId()) || !PropertyValidator.isValid((Object)x.getContainer().getId()) || !usTC.getTeam().getId().equals(x.getTeam().getId()) || !usTC.getContainer().getId().equals(x.getContainer().getId()) || !PropertyValidator.isValid((Object)x.getSprint()) || !PropertyValidator.isValid((Object)x.getSprint().getJiraId())) continue;
                    this.setTeamContainers(new ArrayList());
                    newSubItemMappingApplied = true;
                    ifCellHasJiraSprint = true;
                    break;
                }
                if (ifCellHasJiraSprint) {
                    this.setTeamContainers(new ArrayList());
                    newSubItemMappingApplied = true;
                } else {
                    newSubItemMappingApplied = false;
                }
            }
        }
        return newSubItemMappingApplied;
    }

    public Object valueByKey(String key, Map<String, HashMap<String, Object>> infoMap) {
        Object ret = null;
        if ("jiraKey".equals(key)) {
            ret = PropertyValidator.isValid((Object)this.getJiraKey()) ? this.getJiraKey() : (PropertyValidator.isValid((Object)this.getTfsId()) ? this.getTfsId() : null);
        } else if ("kendisKey".equals(key)) {
            ret = this.getKendisKey();
        } else if ("jiraId".equals(key)) {
            ret = this.getJiraId();
        } else if ("tfsId".equals(key)) {
            ret = this.getTfsId();
        } else if ("tfsURL".equals(key)) {
            ret = this.getTfsURL();
        } else if ("parent".equals(key) && this.getParent() != null) {
            ret = this.getParent().getJiraKey();
        } else if ("title".equals(key)) {
            ret = this.getTitle();
        } else if ("jiraIssueTypeId".equals(key)) {
            ret = this.getJiraIssueTypeId();
        } else if ("itemType".equals(key)) {
            ret = this.getType().equals(FEATURE) ? "Parent" : "Child";
        } else if ("status".equals(key)) {
            ret = PropertyValidator.isValid((Object)this.getStatus()) ? this.getStatus().getTitle() : "";
        } else if ("score".equals(key)) {
            ret = this.getScore();
        } else if ("almScoreField".equals(key)) {
            ret = this.getAlmScoreField();
        } else if (key != null && "param1".equals(key) && PropertyValidator.isValid((Object)this.getScoreParams())) {
            ret = this.getScoreParams().get(key);
        } else if (key != null && "param2".equals(key) && PropertyValidator.isValid((Object)this.getScoreParams())) {
            ret = this.getScoreParams().get(key);
        } else if (key != null && "param3".equals(key) && PropertyValidator.isValid((Object)this.getScoreParams())) {
            ret = this.getScoreParams().get(key);
        } else if (key != null && "param4".equals(key) && PropertyValidator.isValid((Object)this.getScoreParams())) {
            ret = this.getScoreParams().get(key);
        } else if (key != null && (key.startsWith("stories") || "progress".equals(key)) && infoMap.get(this.id) != null) {
            if (!USER_STORY.equals(this.type)) {
                ret = (Integer)Optional.ofNullable(infoMap.get(this.id).get("c_ToDo")).orElse(0) + (Integer)Optional.ofNullable(infoMap.get(this.id).get("c_InProgress")).orElse(0) + (Integer)Optional.ofNullable(infoMap.get(this.id).get("c_Done")).orElse(0);
                if ("progress".equals(key)) {
                    if (infoMap.get(this.id).get("c_Done") != null && (Integer)infoMap.get(this.id).get("c_Done") > 0) {
                        BigDecimal bd = new BigDecimal(new Double(infoMap.get(this.id).get("c_Done").toString()) / new Double(ret.toString()) * 100.0);
                        bd = bd.setScale(2, 4);
                        ret = Float.valueOf(bd.floatValue());
                    } else {
                        ret = 0;
                    }
                } else if (key.startsWith("stories_")) {
                    ret = (Integer)Optional.ofNullable(infoMap.get(this.id).get(key.replace("stories_", ""))).orElse(0);
                }
            }
        } else if (("storyPoints".equals(key) || "stProgress".equals(key) || "spProgress".equals(key)) && infoMap.get(this.id) != null) {
            if (USER_STORY.equals(this.type)) {
                if ("storyPoints".equals(key) && PropertyValidator.isValid((Object)this.getStoryPoints())) {
                    ret = this.getStoryPoints().toString();
                }
            } else {
                ret = (Double)Optional.ofNullable(infoMap.get(this.id).get("sp_ToDo")).orElse(0.0) + (Double)Optional.ofNullable(infoMap.get(this.id).get("sp_InProgress")).orElse(0.0) + (Double)Optional.ofNullable(infoMap.get(this.id).get("sp_Done")).orElse(0.0);
                if ("stProgress".equals(key) || "spProgress".equals(key)) {
                    if (infoMap.get(this.id).get("sp_Done") != null && (Double)infoMap.get(this.id).get("sp_Done") > 0.0) {
                        BigDecimal bd = new BigDecimal((Double)infoMap.get(this.id).get("sp_Done") / (Double)ret * 100.0);
                        bd = bd.setScale(2, 4);
                        ret = Float.valueOf(bd.floatValue());
                    } else {
                        ret = 0;
                    }
                }
            }
        } else if ("issueType".equals(key)) {
            if (USER_STORY.equals(this.type)) {
                List boards = this.getSessionBoards();
                if (PropertyValidator.isValid((Collection)boards) && ((SessionBoard)boards.get(0)).getSession() != null && ((SessionBoard)boards.get(0)).getSession().getChildItem() != null) {
                    ret = ((SessionBoard)boards.get(0)).getSession().getChildItem().toString();
                }
            } else if (this.getIssueTypes() != null) {
                ret = String.join((CharSequence)", ", this.getIssueTypes().keySet());
            } else if (this.getIssueType() == null) {
                List boards = this.getSessionBoards();
                if (PropertyValidator.isValid((Collection)boards) && ((SessionBoard)boards.get(0)).getSession() != null && ((SessionBoard)boards.get(0)).getSession().getParentItem() != null) {
                    ret = ((SessionBoard)boards.get(0)).getSession().getParentItem().toString();
                }
            } else {
                ret = this.getIssueType().getTitle();
            }
        } else if ("itemLinks".equals(key)) {
            List links = this.getItemLinks();
            ArrayList<ItemLink> itemLinks = new ArrayList<ItemLink>();
            if (PropertyValidator.isValid((Collection)links)) {
                for (ItemLink itemLink : links) {
                    if (!PropertyValidator.isValid((Object)itemLink)) continue;
                    itemLinks.add(itemLink);
                }
            }
            ret = itemLinks == null ? "" : (itemLinks.size() > 0 ? Integer.valueOf(itemLinks.size()) : "");
        } else if (("teams".equals(key) || "teamsLabel".equals(key) || "sprints".equals(key) || "sprintsLabel".equals(key)) && infoMap.get(this.id) != null) {
            ret = infoMap.get(this.id).get(key);
        } else if ("sessionBoards".equals(key)) {
            List boards = this.getSessionBoards();
            if (PropertyValidator.isValid((Collection)boards)) {
                StringBuilder bName = new StringBuilder();
                for (SessionBoard b : boards) {
                    if (bName.length() > 0) {
                        bName.append(", ");
                    }
                    bName.append(b.getSession().getTitle());
                }
                ret = bName.toString();
            }
        } else if ("phoenixTeam".equals(key)) {
            if (PropertyValidator.isValid((Collection)this.getTeamContainers())) {
                ArrayList<Object> maxTcs = new ArrayList<Object>();
                double maxSequence = 0.0;
                for (Object tc : this.getTeamContainers()) {
                    if (tc.getContainer().getSequence() > maxSequence) {
                        maxSequence = tc.getContainer().getSequence();
                        maxTcs = new ArrayList();
                        maxTcs.add(tc);
                        continue;
                    }
                    if (tc.getContainer().getSequence() != maxSequence) continue;
                    maxTcs.add(tc);
                }
                String teams = "";
                for (TeamContainer teamContainer : maxTcs) {
                    if (teams.length() > 0) {
                        teams = teams + ", ";
                    }
                    teams = teams + teamContainer.getTeam().getTitle();
                }
                ret = teams;
            }
        } else if ("phoenixSprint".equals(key)) {
            if (PropertyValidator.isValid((Collection)this.getTeamContainers())) {
                ArrayList<TeamContainer> maxTcs = new ArrayList<TeamContainer>();
                double maxSequence = 0.0;
                for (TeamContainer tc : this.getTeamContainers()) {
                    if (tc.getContainer().getSequence() > maxSequence) {
                        maxSequence = tc.getContainer().getSequence();
                        maxTcs = new ArrayList();
                        maxTcs.add(tc);
                        continue;
                    }
                    if (tc.getContainer().getSequence() != maxSequence) continue;
                    maxTcs.add(tc);
                }
                ret = ((TeamContainer)maxTcs.get(0)).getContainer().getTitle();
            }
        } else if ("createdBy".equals(key)) {
            ret = this.getCreatedBy();
        } else if ("createdOn".equals(key)) {
            ret = this.getCreatedOn();
        } else if ("updatedBy".equals(key)) {
            ret = this.getUpdatedBy();
        } else if ("updatedOn".equals(key)) {
            ret = this.getUpdatedOn();
        } else if ("dueDate".equals(key)) {
            ret = this.getDueDate();
        } else if ("jiraDependency".equals(key)) {
            ret = this.getJiraDependencies() == null ? "0" : "" + this.getJiraDependencies().size();
        } else if (this.jiraFieldTextByKey != null && this.jiraFieldTextByKey.containsKey(key)) {
            ret = this.jiraFieldTextByKey.get(key);
        } else if (this.getFields() != null && this.getFields().containsKey(key)) {
            Map fields = this.getFields();
            if (fields.get(key) instanceof String) {
                String str = ((String)fields.get(key)).replaceAll("<[^>]*>", "");
                str = str.replaceAll("&nbsp;", "\n");
                return str;
            }
            if (fields.get(key) instanceof List) {
                ArrayList objs = (ArrayList)fields.get(key);
                String str = "";
                for (int i = 0; i < objs.size(); ++i) {
                    Map obj = (Map)objs.get(i);
                    str = str + obj.get("title");
                    if (i >= objs.size() - 1) continue;
                    str = str + ", ";
                }
                return str;
            }
            if (fields.get(key) instanceof Object) {
                HashMap obj = (HashMap)fields.get(key);
                if (PropertyValidator.isValid(obj.get("title"))) {
                    return obj.get("title");
                }
                if (PropertyValidator.isValid(obj.get("fullName"))) {
                    return obj.get("fullName");
                }
                if (PropertyValidator.isValid(obj.get("name"))) {
                    String str = (String)obj.get("name");
                    String url = "";
                    if (PropertyValidator.isValid(obj.get("url"))) {
                        url = (String)obj.get("url");
                    }
                    return str + " : " + url;
                }
            }
        }
        if (ret == null) {
            return "";
        }
        return ret.toString();
    }

    public HashMap<String, ? super Object> toSimpleObject() {
        HashMap<String, Object> rowData = new HashMap<String, Object>();
        rowData.put("jiraId", this.valueByKey("jiraId", null));
        rowData.put("jiraKey", this.valueByKey("jiraKey", null));
        rowData.put("title", this.valueByKey("title", null));
        rowData.put("status", this.valueByKey("status", null));
        rowData.put("issueType", this.valueByKey("issueType", null));
        rowData.put("tfsId", this.valueByKey("tfsId", null));
        rowData.put("tfsURL", this.valueByKey("tfsURL", null));
        rowData.put("tfsItemTypeIcon", this.tfsItemTypeIcon);
        rowData.put("kendisKey", this.valueByKey("kendisKey", null));
        rowData.put("jiraIssueTypeId", this.valueByKey("jiraIssueTypeId", null));
        return rowData;
    }

    public HashMap<String, ? super Object> toMap() {
        HashMap item = this.toSimpleObject();
        item.put("id", this.getId());
        item.put("originItemId", this.getOriginItemId());
        item.put("jiraId", this.getJiraId());
        item.put("jiraKey", this.getJiraKey());
        item.put("tfsId", this.getTfsId());
        if (this.getStatus() != null) {
            item.put("status", this.getStatus().toSimpleObject());
        }
        if (this.externalReferenceURL != null) {
            item.put("externalReferenceURL", this.getExternalReferenceURL());
        }
        item.put("storyPoints", this.getStoryPoints());
        item.put("type", this.getType());
        if (this.getParent() != null) {
            HashMap<String, String> parent = new HashMap<String, String>();
            parent.put("id", this.getParent().getId());
            if (this.getParent().getTitle() != null) {
                parent.put("title", this.getParent().getTitle());
            }
            item.put("parent", parent);
        }
        return item;
    }

    public Map<String, ? super Object> toMap(Map<String, Team> teams, Map<String, Container> sprints) {
        HashMap o = this.toMap();
        if ((teams != null || sprints != null) && PropertyValidator.isValid((Collection)this.teamContainers) && PropertyValidator.isValid(this.teamContainers.get(0))) {
            ArrayList tcs = new ArrayList();
            int size = this.teamContainers.size();
            if (Type.UserStory.name().equals(this.type)) {
                size = 1;
            }
            for (int i = 0; i < size; ++i) {
                TeamContainer tc = (TeamContainer)this.teamContainers.get(i);
                HashMap<String, Serializable> otc = new HashMap<String, Serializable>();
                if (sprints != null && teams.get(tc.getTeam().getId()) != null) {
                    otc.put("team", teams.get(tc.getTeam().getId()).toSimpleObject());
                }
                if (sprints != null && sprints.get(tc.getContainer().getId()) != null) {
                    otc.put("sprint", sprints.get(tc.getContainer().getId()).toSimpleObject());
                }
                if (otc.isEmpty()) continue;
                otc.put("sequence", tc.getSequence());
                tcs.add(otc);
            }
            if (PropertyValidator.isValid(tcs)) {
                o.put("teamsAndSprints", tcs);
            }
        }
        return o;
    }

    public Boolean getFlagged() {
        return this.flagged;
    }

    public void setFlagged(Boolean flagged) {
        this.flagged = flagged;
    }

    public List<ItemJiraDependency> getJiraDependencies() {
        return this.jiraDependencies;
    }

    public void setJiraDependencies(List<ItemJiraDependency> jiraDependencies) {
        this.jiraDependencies = jiraDependencies;
    }

    public Double getPhoenixSequence() {
        return this.phoenixSequence;
    }

    public void setPhoenixSequence(Double phoenixSequence) {
        this.phoenixSequence = phoenixSequence;
    }

    public TeamContainer getPhoenixTC() {
        return this.phoenixTC;
    }

    public void setPhoenixTC(TeamContainer phoenixTC) {
        this.phoenixTC = phoenixTC;
    }

    public void putTestData() {
        if (this.jiraItemJson == null) {
            this.jiraItemJson = new HashMap();
        }
        this.jiraItemJson.put(LocalDateTime.now().toString(), Arrays.toString(Thread.currentThread().getStackTrace()).split(".invoke")[0]);
    }

    public void putFeatureParent(Object parent) {
        if (this.jiraFieldByKey == null) {
            this.jiraFieldByKey = new HashMap();
        }
        this.jiraFieldByKey.put(JiraField.FIXED.parent.toString(), parent);
    }

    public boolean storySprintChanged() {
        boolean changed = true;
        try {
            if (PropertyValidator.isValid((Collection)this.getTeamContainers()) && PropertyValidator.isValid((Object)this.getContainer()) && ((TeamContainer)this.getTeamContainers().get(0)).getContainer().equals((Object)this.getContainer())) {
                changed = false;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return changed;
    }

    public boolean storyTeamChanged() {
        boolean changed = true;
        try {
            if (PropertyValidator.isValid((Collection)this.getTeamContainers()) && PropertyValidator.isValid((Object)this.getTeam()) && ((TeamContainer)this.getTeamContainers().get(0)).getTeam().equals((Object)this.getTeam())) {
                changed = false;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return changed;
    }

    public void fillFromJira(String id, String key, String self, String type, String filter, AlmAccount almAccount) {
        this.type = type;
        this.jiraId = id;
        this.jiraKey = key;
        boolean isCloud = false;
        if (PropertyValidator.isValid((Object)almAccount.getJiraOauthToken())) {
            isCloud = almAccount.getJiraOauthToken().isCloud();
        }
        if (!isCloud && PropertyValidator.isValid((Object)self)) {
            String[] url = self.split("/rest");
            if (url.length > 0) {
                this.jiraURL = url[0] + "/browse/" + key;
            }
        } else if (PropertyValidator.isValid((Object)self)) {
            this.jiraURL = almAccount.getUrl() + "/browse/" + key;
        }
        if (PropertyValidator.isValid((Object)filter) && !filter.contains("AddExisting")) {
            this.jiraFilter = filter;
        }
    }

    public void fillFromJira(JiraIssueFields issueFieldsVO, Map<String, Object> issueFields, Map<String, Object> fields) {
        Double storyPoint;
        HashMap jiraProjectStylesByKey;
        if (this.id == null) {
            this.sequence = (Double)fields.get("sequence") + 1000.0;
            this.backlogSequence = (Double)fields.get("sequence") + 1000.0;
        }
        this.setSuspendActivity(true);
        if (issueFieldsVO == null) {
            this.title = (String)issueFields.get(JiraField.FIXED.summary.name());
            this.jiraProjectKey = (String)((Map)issueFields.get(JiraField.FIXED.project.name())).get("key");
            this.jiraIssueTypeId = (String)((Map)issueFields.get(JiraField.FIXED.issuetype.name())).get("id");
        } else {
            this.title = issueFieldsVO.getSummary();
            this.jiraProjectKey = issueFieldsVO.getProject().getKey();
            this.jiraIssueTypeId = issueFieldsVO.getIssuetype().getId();
        }
        if (fields.containsKey("sessionBoardId")) {
            this.sessionBoards = new ArrayList();
            this.sessionBoards.add(new SessionBoard((String)fields.get("sessionBoardId")));
        }
        if (PropertyValidator.isValid((Object)issueFields.get(((JiraField)fields.get("duedate")).getJiraId()))) {
            this.dueDate = PropertyValidator.parseDate((String)((String)issueFields.get(((JiraField)fields.get("duedate")).getJiraId())), (String)"yyyy-MM-dd");
        }
        if (PropertyValidator.isValid((Object)fields.get("startDate")) && PropertyValidator.isValid((Object)issueFields.get(((JiraField)fields.get("startDate")).getJiraId()))) {
            this.startDate = PropertyValidator.parseDate((String)((String)issueFields.get(((JiraField)fields.get("startDate")).getJiraId())), (String)"yyyy-MM-dd");
        }
        if (PropertyValidator.isValid((Object)fields.get("endDate")) && PropertyValidator.isValid((Object)issueFields.get(((JiraField)fields.get("endDate")).getJiraId()))) {
            this.endDate = PropertyValidator.parseDate((String)((String)issueFields.get(((JiraField)fields.get("endDate")).getJiraId())), (String)"yyyy-MM-dd");
        }
        String storyPointsFieldKey = "Story Points";
        if (fields.containsKey("jiraProjectStylesByKey") && (jiraProjectStylesByKey = (HashMap)fields.get("jiraProjectStylesByKey")).containsKey(this.getJiraProjectKey()) && PropertyValidator.isValid(jiraProjectStylesByKey.get(this.getJiraProjectKey())) && "next-gen".equals(jiraProjectStylesByKey.get(this.getJiraProjectKey())) && fields.containsKey("NG Story Points")) {
            storyPointsFieldKey = "NG Story Points";
        }
        if (PropertyValidator.isValid((Object)(storyPoint = (Double)issueFields.get(((JiraField)fields.get(storyPointsFieldKey)).getJiraId())))) {
            storyPoint = StringUtils.round((double)storyPoint, (int)2);
        }
        this.storyPoints = storyPoint;
    }

    public void putCustomeFieldValues(Map<String, Object> mapFields, Collection<ItemJiraFieldMap> extraFields, boolean isWebHookUpdate) {
        boolean check = false;
        boolean isFagged = this.getFlagged();
        if (this.jiraFieldByKey != null) {
            check = true;
        }
        if (!isWebHookUpdate) {
            this.jiraFieldByKey = null;
            this.jiraFieldMap = null;
        }
        for (ItemJiraFieldMap field : extraFields) {
            ItemJiraFieldMap itemField;
            ItemJiraFieldMap itemField2;
            String value;
            Object obj;
            Object valueInJira = mapFields.get(field.getKey());
            if (this.jiraFieldByKey == null) {
                this.jiraFieldByKey = new HashMap();
            }
            this.jiraFieldByKey.put(field.getKey(), valueInJira);
            if (!PropertyValidator.isValid((Object)valueInJira)) continue;
            if (field.getType().equals("JSONObject")) {
                obj = null;
                try {
                    obj = new JSONObject((Map)valueInJira);
                }
                catch (Exception e) {
                    LOGGER.error("Error :: " + this.id + "[" + this.jiraKey + ":" + field.getKey() + "] : " + StringUtils.getTraceString((Throwable)e));
                }
                try {
                    if (obj == null || !obj.has("id")) continue;
                    value = String.valueOf(obj.get("id"));
                    JSONObject jsonValue = new JSONObject();
                    jsonValue.put("id", (Object)value);
                    itemField2 = new ItemJiraFieldMap(field.getKey(), jsonValue.toString(), field.getType());
                    if (!PropertyValidator.isValid((Collection)this.jiraFieldMap)) {
                        this.jiraFieldMap = new ArrayList();
                    }
                    this.jiraFieldMap.add(itemField2);
                    if (!Boolean.TRUE.equals(field.getIsFlagged())) continue;
                    isFagged = true;
                }
                catch (JSONException e) {
                    String exp = StringUtils.getTraceString((Throwable)e);
                    LOGGER.error("Error :: " + this.id + "[" + this.jiraKey + ":" + field.getKey() + "] : " + exp);
                }
                continue;
            }
            if (field.getType().equals("JSONArray")) {
                ArrayList fieldArray;
                ArrayList objectArray = (ArrayList)valueInJira;
                if ("labels".equals(field.getJiraType()) || objectArray.size() > 0 && objectArray.get(0).getClass().getName().indexOf("String") > -1) {
                    fieldArray = (ArrayList)valueInJira;
                    if (!PropertyValidator.isValid((Collection)fieldArray)) continue;
                    Gson gson = new Gson();
                    itemField2 = new ItemJiraFieldMap(field.getKey(), gson.toJson((Object)fieldArray), field.getType());
                    if (!PropertyValidator.isValid((Collection)this.jiraFieldMap)) {
                        this.jiraFieldMap = new ArrayList();
                    }
                    this.jiraFieldMap.add(itemField2);
                    continue;
                }
                fieldArray = (ArrayList)valueInJira;
                ArrayList jobjects = new ArrayList();
                if (!PropertyValidator.isValid((Collection)fieldArray)) continue;
                for (Map fieldValue : fieldArray) {
                    String value2 = String.valueOf(fieldValue.get("id"));
                    Map<String, String> jobj = new HashMap<String, String>();
                    jobj.put("id", value2);
                    if (value2 == null && fieldValue.get("accountId") != null) {
                        jobj = fieldValue;
                    }
                    jobjects.add(jobj);
                }
                if (!PropertyValidator.isValid(jobjects)) continue;
                Gson gson = new Gson();
                ItemJiraFieldMap itemField3 = new ItemJiraFieldMap(field.getKey(), gson.toJson(jobjects), field.getType());
                itemField3.setJiraType(field.getJiraType());
                if (!PropertyValidator.isValid((Collection)this.jiraFieldMap)) {
                    this.jiraFieldMap = new ArrayList();
                }
                this.jiraFieldMap.add(itemField3);
                if (!Boolean.TRUE.equals(field.getIsFlagged())) continue;
                isFagged = true;
                continue;
            }
            if (field.getType().toLowerCase().equals("string")) {
                obj = null;
                try {
                    obj = (String)valueInJira;
                }
                catch (Exception e) {
                    LOGGER.warn("Warning :: object type is not string  " + this.id + "[" + this.jiraKey + ":" + field.getKey() + "] : " + e.getMessage());
                }
                itemField = new ItemJiraFieldMap(field.getKey(), (String)obj, field.getType());
                if (!PropertyValidator.isValid((Collection)this.jiraFieldMap)) {
                    this.jiraFieldMap = new ArrayList();
                }
                this.jiraFieldMap.add(itemField);
                continue;
            }
            if (field.getType().equals("Double")) {
                obj = null;
                try {
                    obj = (Double)valueInJira;
                }
                catch (Exception e) {
                    LOGGER.error("Error :: " + this.id + "[" + this.jiraKey + ":" + field.getKey() + "] : " + StringUtils.getTraceString((Throwable)e));
                }
                value = "";
                if (PropertyValidator.isValid((Object)obj)) {
                    value = String.valueOf(obj);
                }
                ItemJiraFieldMap itemField4 = new ItemJiraFieldMap(field.getKey(), value, field.getType());
                if (!PropertyValidator.isValid((Collection)this.jiraFieldMap)) {
                    this.jiraFieldMap = new ArrayList();
                }
                this.jiraFieldMap.add(itemField4);
                continue;
            }
            if (field.getJiraType() == null || !field.getJiraType().toLowerCase().equals("user")) continue;
            Gson gson = new Gson();
            itemField = new ItemJiraFieldMap(field.getKey(), gson.toJson(valueInJira), field.getType());
            itemField.setType("JSONObject");
            itemField.setJiraType(field.getJiraType());
            if (!PropertyValidator.isValid((Collection)this.jiraFieldMap)) {
                this.jiraFieldMap = new ArrayList();
            }
            this.jiraFieldMap.add(itemField);
            if (!Boolean.TRUE.equals(field.getIsFlagged())) continue;
            isFagged = true;
        }
        this.setFlagged(Boolean.valueOf(isFagged));
    }

    public boolean putCustomeValuesAsText(Map<String, Object> jiraFieldByKey, Collection<ItemJiraFieldMap> configFields, HashMap<String, Object> filters) {
        return this.simplifyCustomValues(jiraFieldByKey, configFields, filters, null);
    }

    public boolean simplifyCustomValues(Map<String, Object> jiraFieldByKey, Collection<ItemJiraFieldMap> configFields, HashMap<String, Object> filters, String dateTimeFormat) {
        HashMap<String, String> plainFields = new HashMap<String, String>();
        int found = 0;
        int totalFilters = 0;
        try {
            if (jiraFieldByKey != null) {
                Map jiraTypes = null;
                Map jiraTimeZone = null;
                ItemJiraFieldMap jiraField = null;
                if (PropertyValidator.isValid(configFields)) {
                    jiraField = configFields.iterator().next();
                    if (jiraField.jiraTypes == null) {
                        for (ItemJiraFieldMap addJF : configFields) {
                            if (jiraField.jiraTypes == null) {
                                jiraField.jiraTypes = new HashMap();
                            }
                            if (jiraField.jiraTimeZone == null) {
                                jiraField.jiraTimeZone = new HashMap();
                            }
                            jiraField.jiraTypes.put(addJF.getKey(), addJF.getJiraType());
                            if (!PropertyValidator.isValid((Object)addJF.getClientTimeZone())) continue;
                            jiraField.jiraTimeZone.put(addJF.getKey(), addJF.getClientTimeZone());
                        }
                    }
                    jiraTypes = jiraField.jiraTypes;
                    jiraTimeZone = jiraField.jiraTimeZone;
                }
                Set<String> keys = jiraFieldByKey.keySet();
                for (String _key : keys) {
                    boolean isArray;
                    String jiraType = "";
                    if (jiraTypes != null) {
                        jiraType = (String)jiraTypes.get(_key);
                    }
                    boolean isDate = false;
                    if (!PropertyValidator.isValid((Object)jiraType)) {
                        jiraType = "";
                    }
                    String fValue = null;
                    String fKey = _key + "-" + this.type;
                    if (filters != null) {
                        if (filters.containsKey(fKey)) {
                            ++totalFilters;
                            fValue = String.join((CharSequence)"|", (ArrayList)filters.get(fKey)).toLowerCase();
                        } else if (isDate && filters.containsKey(fKey + "Start")) {
                            ++totalFilters;
                        }
                    }
                    Object extraJF = jiraFieldByKey.get(_key);
                    StringBuilder plainValue = new StringBuilder();
                    if (!PropertyValidator.isValid((Object)extraJF)) {
                        plainFields.put(_key, "");
                        continue;
                    }
                    boolean bl = isDate = jiraType.indexOf("date") > -1;
                    if (extraJF instanceof Date) {
                        isDate = true;
                    }
                    String dateWithTimeZone = null;
                    if (extraJF instanceof String && !isDate && dateTimeFormat != null) {
                        dateWithTimeZone = dateTimeFormat;
                        SimpleDateFormat sdf = new SimpleDateFormat(dateWithTimeZone);
                        try {
                            if (sdf.parse((String)extraJF) != null) {
                                isDate = true;
                            }
                        }
                        catch (Exception e) {
                            dateWithTimeZone = null;
                        }
                    }
                    boolean bl2 = isArray = extraJF.getClass().getName().indexOf("List") > -1;
                    if (isArray) {
                        List value = (List)extraJF;
                        if (value.size() > 0) {
                            if (jiraType.equals("labels") || value.get(0).getClass().getName().toLowerCase().indexOf("string") > -1) {
                                for (int i = 0; i < value.size(); ++i) {
                                    if (plainValue.length() > 0) {
                                        plainValue.append(", ");
                                    }
                                    plainValue.append(value.get(i));
                                    String v = value.get(i).toString().toLowerCase();
                                    if (fValue == null || fValue.indexOf(v) <= -1 && v.indexOf(fValue) <= -1) continue;
                                    ++found;
                                }
                            } else {
                                for (int i = 0; i < value.size(); ++i) {
                                    Map o = (Map)value.get(i);
                                    if (plainValue.length() > 0) {
                                        plainValue.append(", ");
                                    }
                                    if (o.containsKey("displayName")) {
                                        plainValue.append(o.get("displayName"));
                                    } else if (o.containsKey("value")) {
                                        plainValue.append(o.get("value"));
                                    } else if (o.containsKey("name")) {
                                        plainValue.append(o.get("name"));
                                    } else if (o.containsKey("title")) {
                                        plainValue.append(o.get("title"));
                                    } else if (o.containsKey("key")) {
                                        plainValue.append(o.get("key"));
                                    }
                                    if (fValue == null) continue;
                                    if (o.get("id") != null && fValue.indexOf(o.get("id").toString().toLowerCase()) > -1) {
                                        ++found;
                                        continue;
                                    }
                                    if (o.get("accountId") == null || fValue.indexOf(o.get("accountId").toString().toLowerCase()) <= -1) continue;
                                    ++found;
                                }
                            }
                        }
                    } else if (extraJF.getClass().getName().indexOf("Object") > -1 || extraJF.getClass().getName().indexOf("Map") > -1) {
                        Map o = (Map)extraJF;
                        if (plainValue.length() > 0) {
                            plainValue.append(", ");
                        }
                        if (o.containsKey("displayName")) {
                            plainValue.append(o.get("displayName"));
                        } else if (o.containsKey("title")) {
                            plainValue.append(o.get("title"));
                        } else if (o.containsKey("value")) {
                            plainValue.append(o.get("value"));
                        } else if (o.containsKey("name")) {
                            plainValue.append(o.get("name"));
                        } else if (o.containsKey("key")) {
                            plainValue.append(o.get("key"));
                        }
                        Map oChild = null;
                        if (o.containsKey("child") && (oChild = (Map)o.get("child")).containsKey("value")) {
                            plainValue.append(" - ").append(oChild.get("value"));
                        }
                        if (fValue != null) {
                            if (fValue.indexOf("_child_") > -1) {
                                if (o.containsKey("child") && oChild != null) {
                                    String val = o.get("id").toString() + "_child_" + oChild.get("id");
                                    if (o.get("id") != null && fValue.indexOf(val) > -1) {
                                        ++found;
                                    }
                                }
                            } else if (o.get("id") != null && fValue.indexOf(o.get("id").toString().toLowerCase()) > -1) {
                                ++found;
                            } else if (o.get("accountId") != null && fValue.indexOf(o.get("accountId").toString().toLowerCase()) > -1) {
                                ++found;
                            }
                        }
                    } else if (jiraType.equals("number")) {
                        if (plainValue.length() > 0) {
                            plainValue.append(", ");
                        }
                        plainValue.append(extraJF);
                        if (fValue != null && (fValue.indexOf(extraJF.toString().toLowerCase()) > -1 || extraJF.toString().toLowerCase().indexOf(fValue) > -1)) {
                            ++found;
                        }
                    } else if (isDate) {
                        TimeZone local = TimeZone.getDefault();
                        if (jiraTimeZone != null && PropertyValidator.isValid(jiraTimeZone.get(_key))) {
                            local = TimeZone.getTimeZone((String)jiraTimeZone.get(_key));
                        }
                        Date date = null;
                        if (extraJF != null || dateWithTimeZone != null) {
                            SimpleDateFormat formatter;
                            if (extraJF instanceof Date) {
                                formatter = new SimpleDateFormat("dd MMM, yy");
                                extraJF = formatter.format(extraJF);
                            } else if (jiraType.indexOf("time") > -1) {
                                Calendar calendar = Calendar.getInstance();
                                SimpleDateFormat df = new SimpleDateFormat(dateWithTimeZone == null ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : dateWithTimeZone);
                                df.setTimeZone(local);
                                String offSet = "0000";
                                String dateText = extraJF.toString();
                                offSet = dateText.substring(dateText.length() - 5, dateText.length());
                                String time = dateText.replace(offSet, "");
                                TimeZone jZone = TimeZone.getTimeZone("GMT" + offSet);
                                df.setTimeZone(jZone);
                                date = df.parse(time);
                                calendar.setTime(date);
                                calendar.add(14, local.getRawOffset());
                                date = calendar.getTime();
                                df = new SimpleDateFormat("dd MMM, yy hh:mm aa");
                                extraJF = df.format(date);
                            } else {
                                formatter = new SimpleDateFormat("yyyy-MM-dd");
                                date = formatter.parse((String)extraJF);
                                formatter = new SimpleDateFormat("dd MMM, yy");
                                extraJF = formatter.format(date);
                            }
                        }
                        if (plainValue.length() > 0) {
                            plainValue.append(", ");
                        }
                        plainValue.append(extraJF);
                        if (filters != null && date != null && filters.containsKey(fKey + "Start")) {
                            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                            Date d1 = df.parse((String)filters.get(fKey + "Start"));
                            Date d2 = df.parse((String)filters.get(fKey + "End"));
                            if (date.getTime() >= d1.getTime() && date.getTime() <= d2.getTime()) {
                                ++found;
                            }
                        }
                    } else {
                        if (plainValue.length() > 0) {
                            plainValue.append(", ");
                        }
                        plainValue.append(extraJF);
                    }
                    plainFields.put(_key, plainValue.toString());
                }
            }
            if (filters != null && filters.containsKey("jiraFilterCount")) {
                filters.put("jiraFilterCount", totalFilters);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error :: [" + this.id + "] : " + e);
        }
        if (filters != null) {
            if (jiraFieldByKey != null) {
                return found >= totalFilters;
            }
            return totalFilters <= 0;
        }
        this.jiraFieldTextByKey = plainFields;
        return true;
    }

    public TeamContainer calcPhoenixTC() {
        Double seq = null;
        TeamContainer tc = null;
        if (this.teamContainers != null && this.teamContainers.size() > 0) {
            for (int i = 0; i < this.teamContainers.size(); ++i) {
                if (!PropertyValidator.isValid(this.teamContainers.get(i)) || !PropertyValidator.isValid((Object)((TeamContainer)this.teamContainers.get(i)).getContainer()) || seq != null && !(seq < ((TeamContainer)this.teamContainers.get(i)).getContainer().getSequence())) continue;
                seq = ((TeamContainer)this.teamContainers.get(i)).getContainer().getSequence();
                tc = (TeamContainer)this.teamContainers.get(i);
            }
        }
        return tc;
    }

    public Double maxPhoenixSequence() {
        Double seq = null;
        if (this.teamContainers != null && this.teamContainers.size() > 0) {
            for (int i = 0; i < this.teamContainers.size(); ++i) {
                if (!PropertyValidator.isValid(this.teamContainers.get(i)) || !PropertyValidator.isValid((Object)((TeamContainer)this.teamContainers.get(i)).getContainer()) || seq != null && !(seq < ((TeamContainer)this.teamContainers.get(i)).getContainer().getSequence())) continue;
                seq = ((TeamContainer)this.teamContainers.get(i)).getContainer().getSequence();
            }
        }
        return seq;
    }

    public void applyTeamContainers(List<TeamContainer> teamContainers, Map<String, Boolean> itemLinksMap) {
        if (PropertyValidator.isValid(teamContainers)) {
            for (int i = 0; i < teamContainers.size(); ++i) {
                if (itemLinksMap == null || itemLinksMap.get(teamContainers.get(i).getId()) == null) continue;
                if (!PropertyValidator.isValid((Collection)this.teamContainers)) {
                    this.teamContainers = new ArrayList();
                }
                this.teamContainers.add(teamContainers.get(i));
            }
        }
    }

    public boolean hasTeamContainers(List<TeamContainer> teamContainers, Map<String, Boolean> itemLinksMap) {
        if (PropertyValidator.isValid(teamContainers)) {
            for (int i = 0; i < teamContainers.size(); ++i) {
                if (itemLinksMap == null || itemLinksMap.get(teamContainers.get(i).getId()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Item copyWithoutTC() {
        return new Item(this.id, this.title, this.description, this.type, null, this.dueDate, this.startDate, this.endDate, null, this.status, this.flagged, null, this.jiraId, this.jiraKey, this.tfsId, null, null, this.isEnabler);
    }

    public void copyRefData(Item item) {
        ItemLink link;
        int i;
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            this.teamContainers = new ArrayList();
            for (i = 0; i < item.getTeamContainers().size(); ++i) {
                TeamContainer tc = (TeamContainer)item.getTeamContainers().get(i);
                if (!PropertyValidator.isValid((Object)tc)) continue;
                this.teamContainers.add(new TeamContainer(tc.getId()));
            }
        }
        if (PropertyValidator.isValid((Collection)item.getItemLinks())) {
            this.itemLinks = new ArrayList();
            for (i = 0; i < item.getItemLinks().size(); ++i) {
                link = (ItemLink)item.getItemLinks().get(i);
                if (!PropertyValidator.isValid((Object)link)) continue;
                this.itemLinks.add(new ItemLink(link.getId()));
            }
        }
        if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
            this.jiraDependencies = new ArrayList();
            for (i = 0; i < item.getJiraDependencies().size(); ++i) {
                link = (ItemJiraDependency)item.getJiraDependencies().get(i);
                if (!PropertyValidator.isValid((Object)link)) continue;
                this.jiraDependencies.add(new ItemJiraDependency(link.getId()));
            }
        }
    }

    public void applySprintDates(Session session, Date startDateFromPopup, Date endDateFromPopup) {
        if (startDateFromPopup != null && endDateFromPopup != null) {
            this.startDate = startDateFromPopup;
            this.endDate = endDateFromPopup;
        } else {
            TeamContainer tc;
            if ("0".equals(session.getStartDateAction())) {
                return;
            }
            if (PropertyValidator.isValid((Collection)this.teamContainers) && PropertyValidator.isValid(this.teamContainers.get(0)) && PropertyValidator.isValid((Object)(tc = (TeamContainer)this.teamContainers.get(0)).getContainer()) && PropertyValidator.isValid((Object)tc.getContainer().getStartDate()) && PropertyValidator.isValid((Object)tc.getContainer().getEndDate())) {
                Long startS = tc.getContainer().getStartDate().getTime();
                Long endS = tc.getContainer().getEndDate().getTime();
                if (PropertyValidator.isValid((Object)this.startDate) && PropertyValidator.isValid((Object)this.endDate)) {
                    if (this.endDate.getTime() < startS || this.endDate.getTime() > endS) {
                        this.endDate.setTime(endS);
                    }
                    boolean changeStartDate = false;
                    if (!PropertyValidator.isValid((Object)session.getStartDateAction()) || "1".equals(session.getStartDateAction())) {
                        if (this.startDate.getTime() > this.endDate.getTime()) {
                            changeStartDate = true;
                        }
                    } else {
                        changeStartDate = true;
                    }
                    if (changeStartDate && (this.startDate.getTime() < startS || this.startDate.getTime() > endS)) {
                        this.startDate.setTime(startS);
                    }
                } else {
                    this.startDate = new Date(startS);
                    this.endDate = new Date(endS);
                }
            }
        }
    }

    public List<String> getChildItems() {
        return this.childItems;
    }

    public void setChildItems(List<String> childItems) {
        this.childItems = childItems;
    }

    public List<Item> getSubItems() {
        return this.subItems;
    }

    public void setSubItems(List<Item> subItems) {
        this.subItems = subItems;
    }

    public String getTfsProject() {
        return this.tfsProject;
    }

    public void setTfsProject(String tfsProject) {
        this.tfsProject = tfsProject;
    }

    public String getTfsItemType() {
        return this.tfsItemType;
    }

    public void setTfsItemType(String tfsItemType) {
        this.tfsItemType = tfsItemType;
    }

    public String getTfsId() {
        return this.tfsId;
    }

    public void setTfsId(String tfsId) {
        this.tfsId = tfsId;
    }

    public String getTfsProjectId() {
        return this.tfsProjectId;
    }

    public void setTfsProjectId(String tfsProjectId) {
        this.tfsProjectId = tfsProjectId;
    }

    public List<String> getTfsLinkTypes() {
        return this.tfsLinkTypes;
    }

    public void setTfsLinkTypes(List<String> tfsLinkTypes) {
        this.tfsLinkTypes = tfsLinkTypes;
    }

    public String getTfsFilter() {
        return this.tfsFilter;
    }

    public void setTfsFilter(String tfsFilter) {
        this.tfsFilter = tfsFilter;
    }

    public String getTfsURL() {
        return this.tfsURL;
    }

    public void setTfsURL(String tfsURL) {
        this.tfsURL = tfsURL;
    }

    public String getTfsApiURL() {
        return this.tfsApiURL;
    }

    public void setTfsApiURL(String tfsApiURL) {
        this.tfsApiURL = tfsApiURL;
    }

    public String getKendisKey() {
        return this.kendisKey;
    }

    public String importKey() {
        if (this.kendisKey == null || "".equals(this.kendisKey)) {
            return this.id;
        }
        return this.kendisKey;
    }

    public void setKendisKey(String kendisKey) {
        this.kendisKey = kendisKey;
    }

    public String getKendisId() {
        return this.kendisId;
    }

    public void setKendisId(String kendisId) {
        this.kendisId = kendisId;
    }

    public List<ItemJiraFieldMap> getTfsFieldMap() {
        return this.tfsFieldMap;
    }

    public void setTfsFieldMap(List<ItemJiraFieldMap> tfsFieldMap) {
        this.tfsFieldMap = tfsFieldMap;
    }

    public boolean isMultipleExistence() {
        return this.multipleExistence;
    }

    public void setMultipleExistence(boolean multipleExistence) {
        this.multipleExistence = multipleExistence;
    }

    public String getTfsAreaPath() {
        return this.tfsAreaPath;
    }

    public void setTfsAreaPath(String tfsAreaPath) {
        this.tfsAreaPath = tfsAreaPath;
    }

    public User getFetchedBy() {
        return this.fetchedBy;
    }

    public void setFetchedBy(User fetchedBy) {
        this.fetchedBy = fetchedBy;
    }

    public String getRecoveryItemLinkId() {
        return this.recoveryItemLinkId;
    }

    public void setRecoveryItemLinkId(String recoveryItemLinkId) {
        this.recoveryItemLinkId = recoveryItemLinkId;
    }

    public SolutionBoard getSolutionBoard() {
        return this.solutionBoard;
    }

    public void setSolutionBoard(SolutionBoard solutionBoard) {
        this.solutionBoard = solutionBoard;
    }

    public ArrayList<ItemLink> getSolutionSourceItemLinks() {
        return this.solutionSourceItemLinks;
    }

    public void setSolutionSourceItemLinks(ArrayList<ItemLink> solutionSourceItemLinks) {
        this.solutionSourceItemLinks = solutionSourceItemLinks;
    }

    public ArrayList<ItemLink> getSolutionTargetItemLinks() {
        return this.solutionTargetItemLinks;
    }

    public void setSolutionTargetItemLinks(ArrayList<ItemLink> solutionTargetItemLinks) {
        this.solutionTargetItemLinks = solutionTargetItemLinks;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<ItemJiraDependency> getSolutionAlmDependencies() {
        return this.solutionAlmDependencies;
    }

    public void setSolutionAlmDependencies(List<ItemJiraDependency> solutionAlmDependencies) {
        this.solutionAlmDependencies = solutionAlmDependencies;
    }

    public String getAlmId() {
        return this.almId;
    }

    public void setAlmId(String almId) {
        this.almId = almId;
    }

    public Map<String, Object> getScoreParams() {
        return this.scoreParams;
    }

    public void setScoreParams(Map<String, Object> scoreParams) {
        this.scoreParams = scoreParams;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Double getAlmScoreField() {
        return this.almScoreField;
    }

    public void setAlmScoreField(Double almScoreField) {
        this.almScoreField = almScoreField;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public String getAlmRevision() {
        return this.almRevision;
    }

    public void setAlmRevision(String almRevision) {
        this.almRevision = almRevision;
    }

    public List<BaseItemLink> getBaseItemLinks() {
        return this.baseItemLinks;
    }

    public void setBaseItemLinks(List<BaseItemLink> baseItemLinks) {
        this.baseItemLinks = baseItemLinks;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public Boolean getStarred() {
        return this.starred;
    }

    public void setStarred(Boolean starred) {
        this.starred = starred;
    }

    public Boolean getNotifyWatchers() {
        return this.notifyWatchers;
    }

    public void setNotifyWatchers(Boolean notifyWatchers) {
        this.notifyWatchers = notifyWatchers;
    }

    public Map<String, Object> getTfsFieldByKey() {
        return this.tfsFieldByKey;
    }

    public void setTfsFieldByKey(Map<String, Object> tfsFieldByKey) {
        this.tfsFieldByKey = tfsFieldByKey;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public void setItemType(ItemType itemType) {
        this.itemType = itemType;
    }

    public Long getJiraWebhookTimeStamp() {
        return this.jiraWebhookTimeStamp;
    }

    public void setJiraWebhookTimeStamp(Long jiraWebhookTimeStamp) {
        this.jiraWebhookTimeStamp = jiraWebhookTimeStamp;
    }

    public Boolean getSyncWithART() {
        return this.syncWithART;
    }

    public void setSyncWithART(Boolean syncWithART) {
        this.syncWithART = syncWithART;
    }

    public Set<String> getTaggedFilters() {
        return this.taggedFilters;
    }

    public void setTaggedFilters(Set<String> taggedFilters) {
        this.taggedFilters = taggedFilters;
    }

    public Date getAlmUpdatedOn() {
        return this.almUpdatedOn;
    }

    public void setAlmUpdatedOn(Date almUpdatedOn) {
        this.almUpdatedOn = almUpdatedOn;
    }

    public List<BaseItem> getBatches() {
        return this.batches;
    }

    public void setBatches(List<BaseItem> batches) {
        this.batches = batches;
    }

    public void setPropertyValue(String property, String value) {
        switch (property) {
            case "status": {
                this.status = new Status(value);
                break;
            }
            case "storyPoints": {
                this.storyPoints = Double.parseDouble(value);
                break;
            }
            case "parent": {
                this.parent = new Item(value);
            }
        }
    }

    public List<Map<String, String>> getTfsRelations() {
        return this.tfsRelations;
    }

    public void setTfsRelations(List<Map<String, String>> tfsRelations) {
        this.tfsRelations = tfsRelations;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public Boolean getIsAlmLinked() {
        return this.isAlmLinked;
    }

    public void setIsAlmLinked(Boolean isAlmLinked) {
        this.isAlmLinked = isAlmLinked;
    }

    public Boolean getSendToAlm() {
        return this.sendToAlm;
    }

    public void setSendToAlm(Boolean sendToAlm) {
        this.sendToAlm = sendToAlm;
    }
}

