/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mongodb.BasicDBObject;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.security.core.context.SecurityContextHolder;

public class IssueType
implements Serializable {
    private static final long serialVersionUID = -7463455653944325796L;
    @PushField
    @Id
    @GenerateFieldlog
    private String id;
    @JsonIgnore
    private String tenant = this.retCurrentTenant();
    private boolean archive;
    @PushField
    private String title;
    @PushField
    private String color;
    @PushField
    private String almAccountId;
    @PushField
    private List<String> jiraTypes;
    @PushField
    private List<String> tfsTypes;
    @PushField
    private String tfsProcessId;
    @PushField
    private List<Map<String, String>> almTypes;
    @PushField
    private Boolean isBucket = Boolean.FALSE;
    @PushField
    private Boolean isDefault = Boolean.FALSE;
    @PushField
    private Boolean isAbove;
    @PushField
    private Boolean colorUpdated = Boolean.FALSE;
    @PushField
    private String textColor = "#000000";
    private Double sequence = new Double(System.nanoTime() / 100000L);

    public Boolean getColorUpdated() {
        return this.colorUpdated;
    }

    public void setColorUpdated(Boolean colorUpdated) {
        this.colorUpdated = colorUpdated;
    }

    public IssueType() {
    }

    public IssueType(String id, String title) {
        this.setId(id);
        this.title = title;
    }

    public IssueType(BasicDBObject object) {
        ObjectId id = (ObjectId)object.get("_id");
        this.id = id.toString();
        this.title = (String)object.get("title");
        this.color = (String)object.get("color");
        this.colorUpdated = (Boolean)object.get("colorUpdated");
        this.archive = (Boolean)object.get("archive");
        this.textColor = (String)object.get("textColor");
        this.sequence = (Double)object.get("sequence");
    }

    public IssueType(String id, String title, String color) {
        this.title = title;
        this.color = color;
    }

    public IssueType(String id, String title, String color, String tenant) {
        this.title = title;
        this.color = color;
        this.tenant = tenant;
    }

    public IssueType(String id, String title, Boolean isBucket, Boolean isDefault, Boolean isAbove) {
        this.title = title;
        this.isBucket = isBucket;
        this.isDefault = isDefault;
        this.isAbove = isAbove;
        this.jiraTypes = new ArrayList();
        this.tfsTypes = new ArrayList();
        this.almTypes = new ArrayList();
        this.sequence = new Double(System.nanoTime() / 100000L);
    }

    public String getTitle() {
        return this.title;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String retCurrentTenant() {
        if (SecurityContextHolder.getContext().getAuthentication() != null && !SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = null;
                if (secureUser.getUserContextDTO() != null) {
                    tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                }
                return tenant;
            }
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("apiUser") && null != UserContextDTO.getFromLocalThread() && null != UserContextDTO.getFromLocalThread().get("apiKeyTenant")) {
                return (String)UserContextDTO.getFromLocalThread().get("apiKeyTenant");
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public List<String> getJiraTypes() {
        return this.jiraTypes;
    }

    public void setJiraTypes(List<String> jiraTypes) {
        this.jiraTypes = jiraTypes;
    }

    public List<String> getTfsTypes() {
        return this.tfsTypes;
    }

    public void setTfsTypes(List<String> tfsTypes) {
        this.tfsTypes = tfsTypes;
    }

    public String getTfsProcessId() {
        return this.tfsProcessId;
    }

    public void setTfsProcessId(String tfsProcessId) {
        this.tfsProcessId = tfsProcessId;
    }

    public List<Map<String, String>> getAlmTypes() {
        return this.almTypes;
    }

    public void setAlmTypes(List<Map<String, String>> almTypes) {
        this.almTypes = almTypes;
    }

    public String getAlmAccountId() {
        return this.almAccountId;
    }

    public void setAlmAccountId(String almAccountId) {
        this.almAccountId = almAccountId;
    }

    public Boolean getIsBucket() {
        return this.isBucket;
    }

    public void setIsBucket(Boolean isBucket) {
        this.isBucket = isBucket;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsAbove() {
        return this.isAbove;
    }

    public void setIsAbove(Boolean isAbove) {
        this.isAbove = isAbove;
    }
}

