/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Customize;
import com.viztrend.safe.persistence.entity.PaymentDetails;
import com.viztrend.safe.persistence.entity.PaymentPackageConfig;
import com.viztrend.safe.persistence.entity.SecurityPolicy;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.annotation.Transient;

public class Company
extends BaseEntity {
    private String name;
    private boolean riskEnabled;
    private String urlPrefix;
    private String url;
    private Customize customization;
    private Date expiryDate;
    private Date nextPaymentDate;
    private long userCount;
    private long duration;
    private boolean guestEnabled;
    private long guestUserCount = 0L;
    private long planPrice;
    private long totalPrice;
    private float vatPct;
    private boolean retry;
    private boolean enableArt = false;
    private String paymentFormat = "old";
    private List<String> itemTypes;
    private boolean learningHubEnabled = false;
    @JsonIgnore
    private String paymentKey;
    private Boolean manualPayment;
    @Transient
    private Long signedUpTimeStamp;
    @Transient
    private Boolean isPremium = Boolean.TRUE;
    private Boolean prompForProfile = Boolean.TRUE;
    private Long paymentDateTimeStamp;
    private String signupSource;
    private PaymentPackageConfig paymentPackageConfig;
    private SecurityPolicy securityPolicy;
    private HashMap<String, String> info;
    private PaymentDetails paymentDetails;

    public List<String> getItemTypes() {
        return this.itemTypes;
    }

    public void setItemTypes(List<String> itemTypes) {
        this.itemTypes = itemTypes;
    }

    public Company(String tenant, String name) {
        this.name = name;
    }

    public Company() {
    }

    public Company(String id) {
        super(id);
    }

    public Boolean getManualPayment() {
        if (!PropertyValidator.isValid((Object)this.getPaymentDetails())) {
            return true;
        }
        return false;
    }

    public Long getPaymentDateTimeStamp() {
        if (this.getNextPaymentDate() != null) {
            return this.getNextPaymentDate().getTime() / 1000L;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public Customize getCustomization() {
        return this.customization;
    }

    public void setCustomization(Customize customization) {
        this.customization = customization;
    }

    public HashMap<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(HashMap<String, String> info) {
        this.info = info;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public long getUserCount() {
        return this.userCount;
    }

    public void setUserCount(long userCount) {
        this.userCount = userCount;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getPaymentKey() {
        return this.paymentKey;
    }

    public void setPaymentKey(String paymentKey) {
        this.paymentKey = paymentKey;
    }

    public Long getSignedUpTimeStamp() {
        if (this.getCreatedOn() != null) {
            return this.getCreatedOn().getTime() / 1000L;
        }
        return null;
    }

    public void setSignedUpTimeStamp(Long signedUpTimeStamp) {
        this.signedUpTimeStamp = signedUpTimeStamp;
    }

    public Date getNextPaymentDate() {
        return this.nextPaymentDate;
    }

    public void setNextPaymentDate(Date nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
    }

    public PaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(PaymentDetails paymentDetails) {
        this.paymentDetails = paymentDetails;
    }

    public long getPlanPrice() {
        return this.planPrice;
    }

    public void setPlanPrice(long planPrice) {
        this.planPrice = planPrice;
    }

    public long getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(long totalPrice) {
        this.totalPrice = totalPrice;
    }

    public float getVatPct() {
        return this.vatPct;
    }

    public void setVatPct(float vatPct) {
        this.vatPct = vatPct;
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public boolean isRiskEnabled() {
        return this.riskEnabled;
    }

    public void setRiskEnabled(boolean riskEnabled) {
        this.riskEnabled = riskEnabled;
    }

    public void setManualPayment(Boolean manualPayment) {
        this.manualPayment = manualPayment;
    }

    public void setPaymentDateTimeStamp(Long paymentDateTimeStamp) {
        this.paymentDateTimeStamp = paymentDateTimeStamp;
    }

    public String getSignupSource() {
        return this.signupSource;
    }

    public void setSignupSource(String signupSource) {
        this.signupSource = signupSource;
    }

    public PaymentPackageConfig getPaymentPackageConfig() {
        return this.paymentPackageConfig;
    }

    public void setPaymentPackageConfig(PaymentPackageConfig paymentPackageConfig) {
        this.paymentPackageConfig = paymentPackageConfig;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public Boolean getPrompForProfile() {
        return this.prompForProfile;
    }

    public void setPrompForProfile(Boolean prompForProfile) {
        this.prompForProfile = prompForProfile;
    }

    public Boolean getIsPremium() {
        if (PropertyValidator.isValid((Object)this.getPaymentPackageConfig())) {
            if (PropertyValidator.isValid((Object)this.getPaymentPackageConfig().getSAML()) && this.getPaymentPackageConfig().getSAML().equals(Boolean.TRUE) || PropertyValidator.isValid((Object)this.getPaymentPackageConfig().getLiveChat()) && this.getPaymentPackageConfig().getLiveChat().equals(Boolean.TRUE) || PropertyValidator.isValid((Object)this.getPaymentPackageConfig().getoAuth()) && this.getPaymentPackageConfig().getoAuth().equals(Boolean.TRUE) || PropertyValidator.isValid((Object)this.getPaymentPackageConfig().getSecurity()) && this.getPaymentPackageConfig().getSecurity().equals(Boolean.TRUE) || PropertyValidator.isValid((Object)this.getPaymentPackageConfig().getSolutionBoard()) && this.getPaymentPackageConfig().getSolutionBoard().equals(Boolean.TRUE)) {
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean checkFlagOnORG(String flag) {
        return !PropertyValidator.isValid((Object)this.getPaymentPackageConfig()) || !PropertyValidator.isValid((Object)this.getPaymentPackageConfig().getOrgFlags()) || !Boolean.FALSE.equals(this.getPaymentPackageConfig().getOrgFlags().get(flag.startsWith("org_") ? flag : "org_" + flag));
    }

    public void setIsPremium(Boolean isPremium) {
        this.isPremium = isPremium;
    }

    public long getGuestUserCount() {
        return this.guestUserCount;
    }

    public void setGuestUserCount(long guestUserCount) {
        this.guestUserCount = guestUserCount;
    }

    public boolean isGuestEnabled() {
        return this.guestEnabled;
    }

    public void setGuestEnabled(boolean guestEnabled) {
        this.guestEnabled = guestEnabled;
    }

    public boolean isEnableArt() {
        return this.enableArt;
    }

    public void setEnableArt(boolean enableArt) {
        this.enableArt = enableArt;
    }

    public String getPaymentFormat() {
        return this.paymentFormat;
    }

    public void setPaymentFormat(String paymentFormat) {
        this.paymentFormat = paymentFormat;
    }

    public boolean isLearningHubEnabled() {
        return this.learningHubEnabled;
    }

    public void setLearningHubEnabled(boolean learningHubEnabled) {
        this.learningHubEnabled = learningHubEnabled;
    }
}

