/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssueLink;
import com.viztrend.safe.alm.jira.bo.TFSIssue;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.annotations.RenameField;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.FieldTemplate;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemType;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.Constants;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

@GenerateLog
@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseItem
extends BaseEntity {
    private static final long serialVersionUID = 4300223488459700134L;
    @PushField
    @GenerateFieldlog
    @RenameField(value="GroupType")
    private String title;
    @PushField
    @GenerateFieldlog
    private String type;
    @DBRef
    private FieldTemplate fieldsTemplate;
    @PushField
    @GenerateFieldlog
    private String description;
    @PushField
    @GenerateFieldlog
    @DBRef
    protected Status status;
    @PushField
    @DBRef(lazy=true)
    private List<BaseItemLink> baseItemLinks;
    @PushField
    private Double sequence = new Double(System.nanoTime() / 100000L);
    @PushField
    private String key;
    @PushField
    @GenerateFieldlog
    private Double bvPlan = 0.0;
    @PushField
    @GenerateFieldlog
    private Double bvActual = 0.0;
    @PushField
    @GenerateFieldlog
    private Map<String, Object> fields;
    @PushField
    private Map<String, Object> almFields;
    @PushField
    @GenerateFieldlog
    private Boolean starred;
    @PushField
    @GenerateFieldlog
    private Boolean isDefaultGroup = false;
    @PushField
    private Boolean notifyWatchers = true;
    @Transient
    private List<String> mentionUsers;
    @PushField
    @DBRef
    private ItemType itemType;
    @PushField
    @DBRef
    private BaseItem parent;
    @Transient
    private SessionBoard sessionBoard;
    @Transient
    private List<BaseItem> baseItemList;
    @Transient
    private List<Item> linkedItems;
    @Transient
    private List<String> linkedItemsIds;
    @Transient
    private Map<String, Object> linkedItemsById;
    @PushField
    private Double linkedCardWeights = 1.0;
    @Transient
    private List<BaseItem> selectedLinkedGroups;
    @Transient
    private boolean includeInFilter;
    @PushField
    private String completionCriteria;
    @DBRef
    private Attachment imageIcon;
    private String headerColor;
    private String linkedCustomView;
    @DBRef
    private User fetchedBy;
    @Transient
    private Map<String, List<BacklogItem>> backlogItemsMap = new ConcurrentHashMap();
    @PushField
    private Map<String, BaseItemLink> relationMap = new HashMap();
    private TFSIssue tfsIssue;
    @Transient
    private Map<String, BaseItem> baseItemsMap = new HashMap();
    @Transient
    private Map<String, BaseItem> objectivesMap = new HashMap();
    @Transient
    private double progress = 0.0;
    @Transient
    private Collection<JiraIssueLink> issuelinks;

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public Map<String, Object> getAlmFields() {
        return this.almFields;
    }

    public void setAlmFields(Map<String, Object> almFields) {
        this.almFields = almFields;
    }

    public FieldTemplate getFieldsTemplate() {
        return this.fieldsTemplate;
    }

    public BaseItem() {
    }

    public BaseItem(String id) {
        super(id);
    }

    public BaseItem(String id, String key, String title, ItemType itemType, List<BaseItemLink> baseItemLinks, Status status) {
        super(id);
        this.key = key;
        this.title = title;
        this.itemType = itemType;
        this.baseItemLinks = baseItemLinks;
        this.status = status;
    }

    public void links(Map<String, BaseItemLink> baseItemLinksMap) {
        ArrayList<BaseItemLink> links = new ArrayList<BaseItemLink>();
        for (BaseItemLink baseItemLink : this.baseItemLinks) {
            BaseItemLink l;
            if (baseItemLink == null || (l = baseItemLinksMap.get(baseItemLink.getId())) == null) continue;
            links.add(l);
        }
        this.baseItemLinks = links;
    }

    public Collection<Map<String, Object>> issuelinks() {
        if (this.fields != null) {
            return (Collection)this.fields.get(JiraField.FIXED.issuelinks.name());
        }
        return null;
    }

    public String jiraFied(String field, String property) {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(field);
            if (map != null) {
                return (String)map.get(property);
            }
            return "";
        }
        return "";
    }

    public void putValues(Map<String, Object> input, FieldTemplate template) {
        if (this.fields == null) {
            this.fields = new HashMap();
        }
        if (PropertyValidator.isValid(input) && PropertyValidator.isValid((Object)template)) {
            List itemTemplateFields = template.getConfiguredFields();
            for (Fields itemField : itemTemplateFields) {
                if (!input.containsKey(itemField.getId())) continue;
                if (Constants.CLASS_BY_TYPE.containsKey(itemField.getType())) {
                    HashMap obj = (HashMap)input.get(itemField.getId());
                    HashMap<String, Boolean> ref = new HashMap<String, Boolean>();
                    ref.put("$ref", Constants.CLASS_BY_TYPE.containsKey(itemField.getType()));
                    ref.put("$id", (Boolean)new ObjectId(obj.get("id").toString()));
                    this.fields.put(itemField.getId(), ref);
                    continue;
                }
                this.fields.put(itemField.getId(), input.get(itemField.getId()));
            }
        }
    }

    public void setFieldsTemplate(FieldTemplate fieldsTemplate) {
        this.fieldsTemplate = fieldsTemplate;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Double getSequence() {
        return this.sequence;
    }

    public void setSequence(Double sequence) {
        this.sequence = sequence;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<BaseItemLink> getBaseItemLinks() {
        return this.baseItemLinks;
    }

    public void setBaseItemLinks(List<BaseItemLink> impedimentContainers) {
        this.baseItemLinks = impedimentContainers;
    }

    public Boolean getStarred() {
        return this.starred;
    }

    public void setStarred(Boolean starred) {
        this.starred = starred;
    }

    public Boolean getNotifyWatchers() {
        return this.notifyWatchers;
    }

    public void setNotifyWatchers(Boolean notifyWatchers) {
        this.notifyWatchers = notifyWatchers;
    }

    public List<String> getMentionUsers() {
        return this.mentionUsers;
    }

    public void setMentionUsers(List<String> mentionUsers) {
        this.mentionUsers = mentionUsers;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public void setItemType(ItemType itemType) {
        this.itemType = itemType;
    }

    public BaseItem getParent() {
        return this.parent;
    }

    public void setParent(BaseItem parent) {
        this.parent = parent;
    }

    public SessionBoard getSessionBoard() {
        return this.sessionBoard;
    }

    public void setSessionBoard(SessionBoard sessionBoard) {
        this.sessionBoard = sessionBoard;
    }

    public Double getBvPlan() {
        return this.bvPlan;
    }

    public void setBvPlan(Double bvPlan) {
        this.bvPlan = bvPlan;
    }

    public Double getBvActual() {
        return this.bvActual;
    }

    public void setBvActual(Double bvActual) {
        this.bvActual = bvActual;
    }

    public List<BaseItem> getBaseItemList() {
        return this.baseItemList;
    }

    public void setBaseItemList(List<BaseItem> baseItemList) {
        this.baseItemList = baseItemList;
    }

    public List<Item> getLinkedItems() {
        return this.linkedItems;
    }

    public void setLinkedItems(List<Item> linkedItems) {
        this.linkedItems = linkedItems;
    }

    public List<String> getLinkedItemsIds() {
        return this.linkedItemsIds;
    }

    public void setLinkedItemsIds(List<String> linkedItemsIds) {
        this.linkedItemsIds = linkedItemsIds;
    }

    public Map<String, Object> getLinkedItemsById() {
        return this.linkedItemsById;
    }

    public void setLinkedItemsById(Map<String, Object> linkedItemsById) {
        this.linkedItemsById = linkedItemsById;
    }

    public Double getLinkedCardWeights() {
        return this.linkedCardWeights;
    }

    public void setLinkedCardWeights(Double linkedCardWeights) {
        this.linkedCardWeights = linkedCardWeights;
    }

    public List<BaseItem> getSelectedLinkedGroups() {
        return this.selectedLinkedGroups;
    }

    public void setSelectedLinkedGroups(List<BaseItem> selectedLinkedGroups) {
        this.selectedLinkedGroups = selectedLinkedGroups;
    }

    public String getCompletionCriteria() {
        return this.completionCriteria;
    }

    public void setCompletionCriteria(String completionCriteria) {
        this.completionCriteria = completionCriteria;
    }

    public String getHeaderColor() {
        return this.headerColor;
    }

    public void setHeaderColor(String headerColor) {
        this.headerColor = headerColor;
    }

    public User getFetchedBy() {
        return this.fetchedBy;
    }

    public void setFetchedBy(User fetchedBy) {
        this.fetchedBy = fetchedBy;
    }

    public Boolean getIsDefaultGroup() {
        return this.isDefaultGroup;
    }

    public void setIsDefaultGroup(Boolean isDefaultGroup) {
        this.isDefaultGroup = isDefaultGroup;
    }

    public Attachment getImageIcon() {
        return this.imageIcon;
    }

    public void setImageIcon(Attachment imageIcon) {
        this.imageIcon = imageIcon;
    }

    public Map<String, BaseItemLink> getRelationMap() {
        return this.relationMap;
    }

    public void setRelationMap(Map<String, BaseItemLink> relationMap) {
        this.relationMap = relationMap;
    }

    public BaseItem(BaseItem other) {
        this.id = other.id;
        this.title = other.title;
        this.type = other.type;
        this.fieldsTemplate = other.fieldsTemplate;
        this.description = other.description;
        this.status = other.status;
        this.sequence = other.sequence;
        this.key = other.key;
        this.bvPlan = other.bvPlan;
        this.bvActual = other.bvActual;
        this.starred = other.starred;
        this.isDefaultGroup = other.isDefaultGroup;
        this.notifyWatchers = other.notifyWatchers;
        this.itemType = other.itemType;
        this.parent = other.parent;
        this.sessionBoard = other.sessionBoard;
        this.linkedCardWeights = other.linkedCardWeights;
        this.completionCriteria = other.completionCriteria;
        this.imageIcon = other.imageIcon;
        this.headerColor = other.headerColor;
        this.fetchedBy = other.fetchedBy;
        this.tfsIssue = other.tfsIssue;
        this.setArchive(other.isArchive());
        this.createdOn = other.createdOn;
        if (PropertyValidator.isValid((Collection)other.baseItemLinks)) {
            this.baseItemLinks = new ArrayList(other.baseItemLinks);
        }
        if (PropertyValidator.isValid((Object)other.fields)) {
            this.fields = new HashMap(other.fields);
        }
        if (PropertyValidator.isValid((Collection)other.mentionUsers)) {
            this.mentionUsers = new ArrayList(other.mentionUsers);
        }
        if (PropertyValidator.isValid((Collection)other.issuelinks)) {
            this.issuelinks = new ArrayList(other.issuelinks);
        }
        if (PropertyValidator.isValid((Collection)other.baseItemList)) {
            this.baseItemList = new ArrayList(other.baseItemList);
        }
        if (PropertyValidator.isValid((Collection)other.linkedItems)) {
            this.linkedItems = new ArrayList(other.linkedItems);
        }
        if (PropertyValidator.isValid((Collection)other.linkedItemsIds)) {
            this.linkedItemsIds = new ArrayList(other.linkedItemsIds);
        }
        if (PropertyValidator.isValid((Object)other.linkedItemsById)) {
            this.linkedItemsById = new HashMap(other.linkedItemsById);
        }
        if (PropertyValidator.isValid((Object)other.lastUpdate)) {
            this.lastUpdate = new HashMap(other.lastUpdate);
        }
        if (PropertyValidator.isValid((Object)other.baseItemsMap)) {
            this.baseItemsMap = new HashMap(other.baseItemsMap);
        }
        if (PropertyValidator.isValid((Object)other.backlogItemsMap)) {
            this.backlogItemsMap = new HashMap(other.backlogItemsMap);
        }
        if (PropertyValidator.isValid((Object)other.objectivesMap)) {
            this.objectivesMap = new HashMap(other.objectivesMap);
        }
        this.progress = other.progress;
    }

    public Map<String, List<BacklogItem>> getBacklogItemsMap() {
        return this.backlogItemsMap;
    }

    public void setBacklogItemsMap(Map<String, List<BacklogItem>> backlogItemsMap) {
        this.backlogItemsMap = backlogItemsMap;
    }

    public Map<String, BaseItem> getBaseItemsMap() {
        return this.baseItemsMap;
    }

    public void setBaseItemsMap(Map<String, BaseItem> baseItemsMap) {
        this.baseItemsMap = baseItemsMap;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public boolean isIncludeInFilter() {
        return this.includeInFilter;
    }

    public void setIncludeInFilter(boolean includeInFilter) {
        this.includeInFilter = includeInFilter;
    }

    public String getLinkedCustomView() {
        return this.linkedCustomView;
    }

    public void setLinkedCustomView(String linkedCustomView) {
        this.linkedCustomView = linkedCustomView;
    }

    public Map<String, BaseItem> getObjectivesMap() {
        return this.objectivesMap;
    }

    public void setObjectivesMap(Map<String, BaseItem> objectivesMap) {
        this.objectivesMap = objectivesMap;
    }
}

