/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.Expose;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.security.core.context.SecurityContextHolder;

public class BaseEntity
implements Serializable {
    @Id
    @PushField
    @GenerateFieldlog
    protected String id;
    @PushField
    @CreatedBy
    protected String createdBy;
    @PushField
    @CreatedDate
    protected Date createdOn;
    @PushField
    @LastModifiedBy
    protected String updatedBy;
    @PushField
    @LastModifiedDate
    protected Date updatedOn;
    @Transient
    private String eventType;
    private String generatedId;
    @JsonIgnore
    @Transient
    private String actionType;
    @JsonIgnore
    @GenerateFieldlog
    private boolean archive;
    private String duplicateOfId;
    private String duplicateToId;
    @JsonIgnore
    public String tenant = this.retCurrentTenant();
    @JsonIgnore
    @Transient
    @Expose(serialize=false, deserialize=false)
    protected transient MongoTemplate mongoTemplate;
    @JsonIgnore
    @Transient
    private boolean suspendActivity = false;
    @JsonIgnore
    @Transient
    private boolean suspendPush = false;
    @Transient
    public String clientTimeZone = null;
    protected Integer rowStatus = 0;
    private String originItemId;
    private String nextStateId;
    @Transient
    private int source = 0;
    @GenerateFieldlog
    @Transient
    @PushField
    private String metaMap;
    @Transient
    protected Map<String, Object> lastUpdate;
    @Transient
    protected Object oldSate;

    public BaseEntity() {
    }

    public BaseEntity(String id) {
        this.id = id;
    }

    public String retCurrentTenant() {
        if (SecurityContextHolder.getContext().getAuthentication() != null && !SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("anonymousUser")) {
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = null;
                if (secureUser.getUserContextDTO() != null) {
                    tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                }
                return tenant;
            }
            if (SecurityContextHolder.getContext().getAuthentication().getPrincipal().equals("apiUser") && null != UserContextDTO.getFromLocalThread() && null != UserContextDTO.getFromLocalThread().get("apiKeyTenant")) {
                String tenant = (String)UserContextDTO.getFromLocalThread().get("apiKeyTenant");
                return tenant;
            }
        }
        return null;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getOldSate() {
        return this.oldSate;
    }

    public void setOldSate(Object oldSate) {
        this.oldSate = oldSate;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public void setGeneratedId(String generatedId) {
        this.generatedId = generatedId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getDuplicateOfId() {
        return this.duplicateOfId;
    }

    public void setDuplicateOfId(String duplicateOfId) {
        this.duplicateOfId = duplicateOfId;
    }

    public String getDuplicateToId() {
        return this.duplicateToId;
    }

    public void setDuplicateToId(String duplicateToId) {
        this.duplicateToId = duplicateToId;
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
    }

    public boolean isSuspendActivity() {
        return this.suspendActivity;
    }

    public void setSuspendActivity(boolean suspendActivity) {
        this.suspendActivity = suspendActivity;
    }

    public boolean isSuspendPush() {
        return this.suspendPush;
    }

    public void setSuspendPush(boolean suspendPush) {
        this.suspendPush = suspendPush;
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public int getRowStatus() {
        return this.rowStatus;
    }

    public void setRowStatus(int rowStatus) {
        this.rowStatus = rowStatus;
    }

    public String getOriginItemId() {
        return this.originItemId;
    }

    public String getNextStateId() {
        return this.nextStateId;
    }

    public void setNextStateId(String nextStateId) {
        this.nextStateId = nextStateId;
    }

    public void setOriginItemId(String originItemId) {
        this.originItemId = originItemId;
    }

    public String getClientTimeZone() {
        return this.clientTimeZone;
    }

    public void setClientTimeZone(String clientTimeZone) {
        this.clientTimeZone = clientTimeZone;
    }

    public String getMetaMap() {
        return this.metaMap;
    }

    public void setMetaMap(String metaMap) {
        this.metaMap = metaMap;
    }

    public Map<String, Object> getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Map<String, Object> lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Object getLastUpdatedValue(String key) {
        if (this.lastUpdate == null) {
            return null;
        }
        return this.lastUpdate.get(key);
    }

    public void putLastUpdatedValue(String key, Object value) {
        if (this.lastUpdate == null) {
            this.lastUpdate = new HashMap();
        }
        this.lastUpdate.put(key, value);
    }

    public void removeChange(String key, Object value) {
        if (this.lastUpdate != null) {
            if (this.lastUpdate.get(key) != null) {
                if (this.lastUpdate.get(key).equals(value)) {
                    this.lastUpdate.remove(key);
                }
            } else if (value == null) {
                this.lastUpdate.remove(key);
            }
        }
    }
}

