/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Transient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BacklogMappingLinks {
    private String id;
    private String name;
    private String projectKey;
    private String projectName;
    private BacklogMapping featureMapping;
    private BacklogMapping teamMapping;
    private List<JiraIssueLinkType> linkTypes;
    private JiraIssueLinkType linkType;
    private String wsjfProjectField;
    private String wsjfProjectFieldForUnplannedFeatures;
    public Map<String, Boolean> jiraIssueTypes;
    @Transient
    private Boolean isNexus = Boolean.FALSE;
    @Transient
    private String action;

    public BacklogMappingLinks(List<JiraIssueLinkType> linkTypes) {
        this.linkTypes = linkTypes;
    }

    public BacklogMappingLinks(String projectKey, List<JiraIssueLinkType> linkTypes) {
        this.projectKey = projectKey;
        this.linkTypes = linkTypes;
    }

    public BacklogMappingLinks(List<JiraIssueLinkType> linkTypes, List<JiraIssueType> jiraIssueTypes) {
        this.linkTypes = linkTypes;
        if (jiraIssueTypes != null) {
            this.jiraIssueTypes = new HashMap();
            for (JiraIssueType jiraIssueType : jiraIssueTypes) {
                this.jiraIssueTypes.put(jiraIssueType.getId(), true);
            }
        }
    }

    public BacklogMappingLinks() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public BacklogMapping getFeatureMapping() {
        return this.featureMapping;
    }

    public void setFeatureMapping(BacklogMapping featureMapping) {
        this.featureMapping = featureMapping;
    }

    public BacklogMapping getTeamMapping() {
        return this.teamMapping;
    }

    public void setTeamMapping(BacklogMapping teamMapping) {
        this.teamMapping = teamMapping;
    }

    public List<JiraIssueLinkType> getLinkTypes() {
        return this.linkTypes;
    }

    public void setLinkTypes(List<JiraIssueLinkType> linkTypes) {
        this.linkTypes = linkTypes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BacklogMappingLinks)) {
            return false;
        }
        BacklogMappingLinks other = (BacklogMappingLinks)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BacklogMappingLinks [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.projectKey != null) {
            builder.append("projectKey=");
            builder.append(this.projectKey);
            builder.append(", ");
        }
        if (this.featureMapping != null) {
            builder.append("featureMapping=");
            builder.append(this.featureMapping);
            builder.append(", ");
        }
        if (this.teamMapping != null) {
            builder.append("teamMapping=");
            builder.append(this.teamMapping);
            builder.append(", ");
        }
        if (this.linkTypes != null) {
            builder.append("linkType=");
            builder.append(this.linkTypes);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JiraIssueLinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(JiraIssueLinkType linkType) {
        this.linkType = linkType;
    }

    public Boolean isNexus() {
        return this.isNexus;
    }

    public void setNexus(Boolean isNexus) {
        this.isNexus = isNexus;
    }

    public String getWsjfProjectField() {
        return this.wsjfProjectField;
    }

    public void setWsjfProjectField(String wsjfProjectField) {
        this.wsjfProjectField = wsjfProjectField;
    }

    public String getWsjfProjectFieldForUnplannedFeatures() {
        return this.wsjfProjectFieldForUnplannedFeatures;
    }

    public void setWsjfProjectFieldForUnplannedFeatures(String wsjfProjectFieldForUnplannedFeatures) {
        this.wsjfProjectFieldForUnplannedFeatures = wsjfProjectFieldForUnplannedFeatures;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

