/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.annotations.GenerateFieldlog;
import com.viztrend.safe.annotations.GenerateLog;
import com.viztrend.safe.annotations.PushField;
import com.viztrend.safe.enums.EnumBaseItemTypes;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.utils.PropertyValidator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@GenerateLog
public class BacklogItem
extends BaseItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklogItem.class);
    private static final long serialVersionUID = 6720975048602918968L;
    @PushField
    private String almAccountId;
    @PushField
    private String almItemId;
    @PushField
    private String url;
    @PushField
    private String almType;
    @PushField
    private String almKey;
    @PushField
    private Set<String> filterIds;
    @PushField
    private String kendisKey;
    @PushField
    @GenerateFieldlog
    private Double storyPoints = 0.0;
    @PushField
    private Integer backlogLevel;
    @PushField
    @GenerateFieldlog
    private String otherRequirements;
    private Boolean dirty = false;
    @PushField
    @GenerateFieldlog
    private Map<String, BaseItemLink> artRelationMap = new HashMap();
    @PushField
    private Map<String, List<BaseItemLink>> parentRelationMap = new HashMap();
    @PushField
    private Map<String, List<BaseItemLink>> childRelationMap = new HashMap();
    @PushField
    @GenerateFieldlog
    private List<BaseItemLink> boardRelations = new ArrayList();
    @PushField
    @GenerateFieldlog
    private List<BaseItemLink> batchRelations = new ArrayList();
    @PushField
    private List<BaseItemLink> objectiveRelations = new ArrayList();
    @PushField
    private List<BaseItemLink> keyResultRelations = new ArrayList();
    @PushField
    private List<BaseItemLink> teamContainerRelations = new ArrayList();
    @PushField
    private List<BaseItemLink> solutionRelations = new ArrayList();
    @PushField
    @GenerateFieldlog
    private List<BaseItemLink> itemRelations = new ArrayList();
    @PushField
    @GenerateFieldlog
    private List<BaseItemLink> milestoneRelations = new ArrayList();
    private List<AlmError> almErrors = new ArrayList();
    private Boolean showError = false;
    private List<Team> teamData;
    private List<Container> containerData;
    private List<Session> boardsData;
    private List<SolutionBoard> solutionBoardsData;
    private Double totalEstimate;
    private List<String> dependencyLinkIds;
    @Transient
    private List<ItemJiraDependency> dependencyLinks;
    @Transient
    private String issueType;
    @PushField
    @GenerateFieldlog
    private List<BaseItemLink> relations = new ArrayList();
    @Transient
    private ArrayList<BacklogItem> parents;
    @Transient
    private Boolean isNew;
    private BaseItemLink timeCapsuleRelation;
    private List<BaseItemLink> sectionRelations;
    @Transient
    private Object oldState;
    @Transient
    private Map<String, Object> parentMap = new HashMap();

    public Double getTotalEstimate() {
        return this.totalEstimate;
    }

    public void setTotalEstimate(Double totalEstimate) {
        this.totalEstimate = totalEstimate;
    }

    public List<SolutionBoard> getSolutionBoardsData() {
        return this.solutionBoardsData;
    }

    public void setSolutionBoardsData(List<SolutionBoard> solutionBoardsData) {
        this.solutionBoardsData = solutionBoardsData;
    }

    public List<Session> getBoardsData() {
        return this.boardsData;
    }

    public void setBoardsData(List<Session> boardsData) {
        this.boardsData = boardsData;
    }

    public List<Team> getTeamData() {
        return this.teamData;
    }

    public void setTeamData(List<Team> teamData) {
        this.teamData = teamData;
    }

    public List<Container> getContainerData() {
        return this.containerData;
    }

    public void setContainerData(List<Container> containerData) {
        this.containerData = containerData;
    }

    public ArrayList<BacklogItem> getParents() {
        return this.parents;
    }

    public void setParents(ArrayList<BacklogItem> parents) {
        this.parents = parents;
    }

    public BacklogItem() {
    }

    public BacklogItem(String id) {
        super(id);
    }

    public BacklogItem(String id, String almItemId) {
        super(id);
        this.almItemId = almItemId;
    }

    public BacklogItem(String id, User createdBy) {
        super(id);
        this.createdOn = new Date();
        if (createdBy != null) {
            this.createdBy = createdBy.getUserName();
        }
    }

    public BacklogItem(BacklogItem value) {
        this.id = value.getId();
        this.almKey = value.getAlmKey();
        this.status = value.getStatus();
        this.otherRequirements = value.otherRequirements;
        this.almAccountId = value.almAccountId;
        this.almItemId = value.almItemId;
        this.url = value.url;
        this.almType = value.almType;
        this.almKey = value.almKey;
        this.filterIds = value.filterIds;
        this.kendisKey = value.kendisKey;
        this.storyPoints = value.storyPoints;
        this.backlogLevel = value.backlogLevel;
        this.dirty = value.dirty;
        this.artRelationMap = value.artRelationMap;
        this.parentRelationMap = value.parentRelationMap;
        this.childRelationMap = value.childRelationMap;
        this.boardRelations = value.boardRelations;
        this.batchRelations = value.batchRelations;
        this.objectiveRelations = value.objectiveRelations;
        this.keyResultRelations = value.keyResultRelations;
        this.teamContainerRelations = value.teamContainerRelations;
        this.solutionRelations = value.solutionRelations;
        this.itemRelations = value.itemRelations;
        this.milestoneRelations = value.milestoneRelations;
        this.almErrors = value.almErrors;
        this.showError = value.showError;
        this.teamData = value.teamData;
        this.containerData = value.containerData;
        this.boardsData = value.boardsData;
        this.solutionBoardsData = value.solutionBoardsData;
        this.totalEstimate = value.totalEstimate;
        this.relations = value.relations;
        this.parents = value.parents;
        this.isNew = value.isNew;
        this.timeCapsuleRelation = value.timeCapsuleRelation;
        this.sectionRelations = value.sectionRelations;
        this.oldState = value.oldState;
        this.parentMap = value.parentMap;
        this.setBaseItemLinks(value.getBaseItemLinks());
        this.createdOn = value.createdOn;
        this.setTitle(value.getTitle());
        this.setType(value.getType());
        this.setArchive(value.isArchive());
        if (PropertyValidator.isValid((Object)value.getBacklogItemsMap())) {
            HashMap backlogItemMap = new HashMap();
            for (Map.Entry entry : backlogItemMap.entrySet()) {
                List backlogItems = backlogItemMap.getOrDefault(entry.getKey(), new ArrayList());
                backlogItems.addAll((Collection)entry.getValue());
                backlogItemMap.put(entry.getKey(), backlogItems);
            }
            this.setBacklogItemsMap(backlogItemMap);
        }
        if (PropertyValidator.isValid((Object)value.getFields())) {
            this.setFields(new HashMap(value.getFields()));
        }
    }

    public Map<String, Object> fields(BacklogItem parent) {
        HashMap<String, Object> fields = (HashMap<String, Object>)this.getLastUpdatedValue("fieldsBackup");
        if (!PropertyValidator.isValid((Object)fields)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.registerModule((Module)new SimpleModule().addSerializer(ObjectId.class, (JsonSerializer)new /* Unavailable Anonymous Inner Class!! */));
            fields = new HashMap<String, Object>();
            fields.putAll(this.getFields());
            fields.put("artRelationMap", mapper.convertValue((Object)this.getArtRelationMap(), Map.class));
            fields.put("childRelationMap", mapper.convertValue((Object)this.getChildRelationMap(), Map.class));
            fields.put("parentRelationMap", mapper.convertValue((Object)this.getParentRelationMap(), Map.class));
            if (parent != null) {
                fields.put("parent", new /* Unavailable Anonymous Inner Class!! */);
            }
            this.putLastUpdatedValue("fieldsBackup", fields);
        }
        return fields;
    }

    public Item convertToPiItem(Item item, BacklogItem parent, SessionBoard board) {
        Map fields;
        if (item == null) {
            item = new Item();
            item.setId(ObjectId.get().toString());
            item.setType(Item.Type.Feature.name());
            item.setSessionBoards(new ArrayList());
            item.getSessionBoards().add(board);
        }
        if ((fields = this.fields(parent)) != null) {
            SimpleDateFormat yyyy_mm_dd = new SimpleDateFormat("yyyy-MM-dd'T00:00:00.000Z'");
            Object val = fields.get("StartDate");
            try {
                if (val != null) {
                    if (val instanceof Date) {
                        item.setStartDate((Date)val);
                    }
                    if (val instanceof Long) {
                        item.setStartDate(new Date((Long)val));
                    }
                    if (val instanceof String) {
                        item.setStartDate(yyyy_mm_dd.parse((String)val));
                    }
                }
                if ((val = fields.get("EndDate")) != null) {
                    if (val instanceof Date) {
                        item.setEndDate((Date)val);
                    }
                    if (val instanceof Long) {
                        item.setEndDate(new Date((Long)val));
                    }
                    if (val instanceof String) {
                        item.setEndDate(yyyy_mm_dd.parse((String)val));
                    }
                }
                if ((val = fields.get("DueDate")) != null) {
                    if (val instanceof Date) {
                        item.setDueDate((Date)val);
                    }
                    if (val instanceof Long) {
                        item.setDueDate(new Date((Long)val));
                    }
                    if (val instanceof String) {
                        item.setDueDate(yyyy_mm_dd.parse((String)val));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred parsing date formate from backlog item to pi item", (Throwable)e);
            }
        }
        item.setFields(fields);
        item.setExternalReferenceURL((String)fields.get("externalLink"));
        item.setKendisKey(this.getKendisKey());
        item.setJiraKey(item.getKendisKey());
        item.setTitle(this.getTitle());
        item.setStatus(this.getStatus());
        item.setKendisId(this.getId());
        item.setStoryPoints(Double.valueOf(this.getStoryPoints() == null ? 0.0 : this.getStoryPoints()));
        item.setDescription(this.getDescription());
        return item;
    }

    public void removeExtraLinks(String artId, Set<BaseItemLink> links) {
        if (links != null) {
            ArrayList<BaseItemLink> remove = new ArrayList<BaseItemLink>();
            for (BaseItemLink link : links) {
                if (!artId.equals(link.getReleaseTrainId())) continue;
                remove.add(link);
            }
            links.removeAll(remove);
        }
    }

    public void initLinks(String artId) {
        this.boardRelations = new ArrayList();
        this.teamContainerRelations = new ArrayList();
        this.solutionRelations = new ArrayList();
    }

    public void addLinkMap(BaseItemLink link) {
        ArrayList<BaseItemLink> list = null;
        if (link.getLinkType().equals(EnumKendis.ART_BOARD_LINK.getCode())) {
            list = this.boardRelations;
        }
        if (link.getLinkType().equals(EnumKendis.ART_TC_LINK.getCode())) {
            list = this.teamContainerRelations;
        }
        if (link.getLinkType().equals(EnumKendis.ART_SOLUTION_BOARD_LINK.getCode())) {
            list = this.solutionRelations;
        }
        if (link.getLinkType().equals(EnumBaseItemTypes.BATCH.getName())) {
            list = this.batchRelations;
        }
        if (EnumKendis.OBJECTIVE.getCode().equals(link.getLinkType())) {
            list = this.objectiveRelations;
        }
        if (EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(link.getLinkType())) {
            list = this.keyResultRelations;
        }
        if (link.getLinkType().equals(EnumBaseItemTypes.MILESTONES.getName())) {
            list = this.milestoneRelations;
        }
        if (link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())) {
            list = this.itemRelations;
        }
        if (list == null) {
            list = new ArrayList<BaseItemLink>();
        }
        list.add(link);
        if (link.getLinkType().equals(EnumKendis.ART_BOARD_LINK.getCode())) {
            this.boardRelations = list;
        }
        if (link.getLinkType().equals(EnumKendis.ART_TC_LINK.getCode())) {
            this.teamContainerRelations = list;
        }
        if (link.getLinkType().equals(EnumKendis.ART_SOLUTION_BOARD_LINK.getCode())) {
            this.solutionRelations = list;
        }
        if (link.getLinkType().equals(EnumBaseItemTypes.BATCH.getName())) {
            this.batchRelations = list;
        }
        if (EnumKendis.OBJECTIVE.getCode().equals(link.getLinkType())) {
            this.objectiveRelations = list;
        }
        if (EnumKendis.OBJECTIVE_KEY_RESULT.getCode().equals(link.getLinkType())) {
            this.keyResultRelations = list;
        }
        if (link.getLinkType().equals(EnumBaseItemTypes.MILESTONES.getName())) {
            this.milestoneRelations = list;
        }
        if (link.getLinkType().equals(EnumKendis.BACKLOG_ITEM.getCode())) {
            this.itemRelations = list;
        }
    }

    public BaseItemLink linkToRTE(String artId, Integer level) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(artId);
        link.setBacklogLevel(level);
        link.setBacklogItemId(new ObjectId(this.getId()));
        link.setLinkType(EnumKendis.ART_MAIN_LINK.getCode());
        link.setId(link.getLinkType() + "_" + artId);
        this.artRelationMap.put(artId, link);
        if (this.childRelationMap.get(artId) == null) {
            this.childRelationMap.put(artId, new ArrayList());
        }
        if (this.parentRelationMap.get(artId) == null) {
            this.parentRelationMap.put(artId, new ArrayList());
        }
        return link;
    }

    public BaseItemLink linkToObjCustomView(String objCustomViewId, Integer level) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(objCustomViewId);
        link.setBacklogLevel(level);
        link.setBacklogItemId(new ObjectId(this.getId()));
        link.setLinkType(EnumKendis.OBJ_CUSTOM_VIEW_LINK.getCode());
        link.setId(link.getLinkType() + "_" + objCustomViewId);
        this.artRelationMap.put(objCustomViewId, link);
        return link;
    }

    public BaseItemLink linkToParent(String artId, String itemId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setBacklogItemId(new ObjectId(itemId));
        link.setLinkType(EnumKendis.ART_PARENT_LINK.getCode());
        link.setCustomId(link.getLinkType() + "_" + artId + "_" + itemId);
        ArrayList<BaseItemLink> relations = (ArrayList<BaseItemLink>)this.parentRelationMap.get(artId);
        if (relations == null) {
            relations = new ArrayList<BaseItemLink>();
            this.parentRelationMap.put(artId, relations);
        }
        relations.add(link);
        return link;
    }

    public void removeLink(String link, String artId, String itemId) {
        List relations = null;
        if (link.equals(EnumKendis.ART_PARENT_LINK.getCode())) {
            relations = (List)this.parentRelationMap.get(artId);
        }
        if (link.equals(EnumKendis.ART_CHILD_LINK.getCode())) {
            relations = (List)this.childRelationMap.get(artId);
        }
        if (relations != null) {
            relations.remove(new BaseItemLink(link + "_" + artId + "_" + itemId));
        }
    }

    public boolean removeParentLink(String artId, String itemId) {
        boolean removed = false;
        List relations = (List)this.parentRelationMap.get(artId);
        if (PropertyValidator.isValid((Collection)relations) && PropertyValidator.isValid((Collection)relations)) {
            removed = relations.removeIf(link -> itemId.equals(link.getBacklogItemId().toString()));
            this.parentRelationMap.put(artId, relations);
        }
        return removed;
    }

    public BaseItemLink linkToChild(String artId, String itemId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setBacklogItemId(new ObjectId(itemId));
        link.setLinkType(EnumKendis.ART_CHILD_LINK.getCode());
        link.setCustomId(link.getLinkType() + "_" + artId + "_" + itemId);
        ArrayList<BaseItemLink> relations = (ArrayList<BaseItemLink>)this.childRelationMap.get(artId);
        if (relations == null) {
            relations = new ArrayList<BaseItemLink>();
            this.childRelationMap.put(artId, relations);
        }
        relations.add(link);
        return link;
    }

    public boolean removeChildLink(String artId, String itemId) {
        boolean removed = false;
        List relations = (List)this.childRelationMap.get(artId);
        if (PropertyValidator.isValid((Collection)relations)) {
            removed = relations.removeIf(link -> itemId.equals(link.getBacklogItemId().toString()));
            this.childRelationMap.put(artId, relations);
        }
        return removed;
    }

    public BaseItemLink linkToBatch(String artId, String batchId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setBaseItemId(batchId);
        link.setLinkType(EnumBaseItemTypes.BATCH.getName());
        link.setId(link.getLinkType() + "_" + batchId);
        this.addLinkMap(link);
        return link;
    }

    public void linkToTimeline(String artId, String timelineId, String linkType) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(artId);
        link.setBaseItemId(timelineId);
        link.setLinkType(linkType);
        this.relations.add(link);
    }

    public Boolean unlinkFromTimeline(String timelineId) {
        return this.relations.removeIf(baseItemLink -> baseItemLink.getLinkType().equals(EnumKendis.TIMELINE_RELATION.getCode()) && baseItemLink.getBaseItemId().equals(timelineId));
    }

    public BaseItemLink linkToBacklogItem(String artId, String backlogItemId, String almItemId, String almType) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        if (PropertyValidator.isValid((Object)artId)) {
            link.setReleaseTrainId(artId);
        }
        if (PropertyValidator.isValid((Object)backlogItemId)) {
            link.setBaseItemId(backlogItemId);
            link.setId(EnumKendis.BACKLOG_ITEM.getCode() + "_" + backlogItemId);
        }
        if (PropertyValidator.isValid((Object)almItemId) && PropertyValidator.isValid((Object)almType)) {
            link.setAlmItemId(almItemId);
            link.setAlmType(almType);
        }
        link.setLinkType(EnumKendis.BACKLOG_ITEM.getCode());
        this.addLinkMap(link);
        return link;
    }

    public BaseItemLink linkToObjectives(String artId, String objectiveId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setBaseItemId(objectiveId);
        link.setLinkType(EnumKendis.OBJECTIVE.getCode());
        link.setId(link.getLinkType() + "_" + objectiveId);
        this.addLinkMap(link);
        return link;
    }

    public BaseItemLink linkToKeyResults(String artId, String keyResultId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setBaseItemId(keyResultId);
        link.setLinkType(EnumKendis.OBJECTIVE_KEY_RESULT.getCode());
        link.setId(link.getLinkType() + "_" + keyResultId);
        this.addLinkMap(link);
        return link;
    }

    public BaseItemLink linkToTeamSprint(String artId, String boardId, String tcId, String tid, String sid) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(artId);
        link.setTeamId(tid);
        link.setSprintId(sid);
        link.setTeamContainerId(tcId);
        link.setSessionBoardId(boardId);
        link.setLinkType(EnumKendis.ART_TC_LINK.getCode());
        link.setId(link.getLinkType() + "_" + artId + "_" + tid + "_" + sid);
        this.addLinkMap(link);
        return link;
    }

    public BaseItemLink linkToBoard(String artId, String boardId, String sessionId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(artId);
        link.setSessionId(sessionId);
        link.setSessionBoardId(boardId);
        link.setLinkType(EnumKendis.ART_BOARD_LINK.getCode());
        link.setId(link.getLinkType() + "_" + artId + "_" + boardId);
        this.addLinkMap(link);
        return link;
    }

    public BaseItemLink linkToSolutionBoard(String artId, String boardId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(artId);
        link.setSolutionId(boardId);
        link.setLinkType(EnumKendis.ART_SOLUTION_BOARD_LINK.getCode());
        link.setId(link.getLinkType() + "_" + artId + "_" + boardId);
        this.addLinkMap(link);
        return link;
    }

    public void removeBoardLink(String boardId, String sessionId, List<String> removedArtIds, List<String> removedBoardIds) {
        BaseItemLink removed = null;
        List relations = this.boardRelations;
        if (PropertyValidator.isValid((Collection)relations)) {
            for (BaseItemLink link : relations) {
                if (!boardId.equals(link.getSessionBoardId()) || (sessionId == null || !sessionId.equals(link.getSessionId())) && sessionId != null) continue;
                removed = link;
                break;
            }
            if (removed != null) {
                relations.remove(removed);
            }
        }
        if (removed != null) {
            removedBoardIds.add(removed.getSessionBoardId());
            removedArtIds.add(removed.getReleaseTrainId());
        }
    }

    public BaseItemLink linkToMilestone(String artId, String backlogItemId) {
        BaseItemLink link = new BaseItemLink();
        link.setIsSystemLink(Boolean.valueOf(true));
        link.setReleaseTrainId(artId);
        link.setBaseItemId(backlogItemId);
        link.setLinkType(EnumBaseItemTypes.MILESTONES.getName());
        this.addLinkMap(link);
        return link;
    }

    public boolean unlinkWithMilestone(String artId, String backlogItemId) {
        if (PropertyValidator.isValid((Object)artId)) {
            return this.milestoneRelations.removeIf(baseItemLink -> baseItemLink.getBaseItemId().equals(backlogItemId) && baseItemLink.getReleaseTrainId().equals(artId));
        }
        return this.milestoneRelations.removeIf(baseItemLink -> baseItemLink.getBaseItemId().equals(backlogItemId));
    }

    public void fillChildrenIds(ArrayList<String> childIds, List<BaseItemLink> links) {
        if (links != null) {
            for (BaseItemLink obj : links) {
                Object link;
                if (obj instanceof BaseItemLink) {
                    link = obj;
                    childIds.add(link.getBacklogItemId().toString());
                    continue;
                }
                link = (Map)obj;
                ObjectId _id = (ObjectId)link.get("backlogItemId");
                childIds.add(_id.toString());
            }
        }
    }

    public void parseBoardFromDB(String mainId, DBObject dbo, Map<String, String[]> mapTC, boolean overwrite, Map<String, String> artMap) {
        List sb;
        if (dbo.containsField("sessionBoards") && (sb = (List)dbo.get("sessionBoards")) != null && sb.size() > 0) {
            List list;
            String bid = String.valueOf(((DBRef)sb.get(0)).getId());
            String artId = artMap.get(bid);
            String sessionId = artMap.get("session_" + bid);
            this.linkToBoard(artId, bid, sessionId);
            if (overwrite) {
                this.boardRelations = new ArrayList();
                this.teamContainerRelations = new ArrayList();
            }
            if (dbo.containsField("teamContainers") && (list = (List)dbo.get("teamContainers")) != null && list.size() > 0) {
                for (DBRef ref : list) {
                    String tc = String.valueOf(ref.getId());
                    this.linkToTeamSprint(artId, bid, tc, mapTC.get(tc)[0], mapTC.get(tc)[1]);
                }
            }
        }
        if (dbo.containsField("solutionBoard")) {
            DBRef sol = (DBRef)dbo.get("solutionBoard");
            if (overwrite) {
                this.solutionRelations = new ArrayList();
            }
            this.linkToSolutionBoard(mainId, String.valueOf(sol.getId()));
        }
    }

    public String getAlmAccountId() {
        return this.almAccountId;
    }

    public void setAlmAccountId(String almAccountId) {
        this.almAccountId = almAccountId;
    }

    public String getAlmItemId() {
        return this.almItemId;
    }

    public void setAlmItemId(String almItemId) {
        this.almItemId = almItemId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAlmType() {
        return this.almType;
    }

    public void setAlmType(String almType) {
        this.almType = almType;
    }

    public Set<String> getFilterIds() {
        return this.filterIds;
    }

    public void setFilterIds(Set<String> filterIds) {
        this.filterIds = filterIds;
    }

    public Double getStoryPoints() {
        return this.storyPoints;
    }

    public void setStoryPoints(Double storyPoints) {
        this.storyPoints = storyPoints;
    }

    public Integer getBacklogLevel() {
        return this.backlogLevel;
    }

    public void setBacklogLevel(Integer backlogLevel) {
        this.backlogLevel = backlogLevel;
    }

    public String getAlmKey() {
        return this.almKey;
    }

    public void setAlmKey(String almKey) {
        this.almKey = almKey;
    }

    public List<BaseItemLink> getRelations() {
        return this.relations;
    }

    public void setRelations(List<BaseItemLink> relations) {
        this.relations = relations;
    }

    public List<BaseItemLink> getBoardRelations() {
        return this.boardRelations;
    }

    public void setBoardRelations(List<BaseItemLink> boardRelations) {
        this.boardRelations = boardRelations;
    }

    public List<BaseItemLink> getBatchRelations() {
        return this.batchRelations;
    }

    public void setBatchRelations(List<BaseItemLink> batchRelations) {
        this.batchRelations = batchRelations;
    }

    public List<BaseItemLink> getObjectiveRelations() {
        return this.objectiveRelations;
    }

    public void setObjectiveRelations(List<BaseItemLink> objectiveRelations) {
        this.objectiveRelations = objectiveRelations;
    }

    public List<BaseItemLink> getKeyResultRelations() {
        return this.keyResultRelations;
    }

    public void setKeyResultRelations(List<BaseItemLink> keyResultRelations) {
        this.keyResultRelations = keyResultRelations;
    }

    public List<BaseItemLink> getTeamContainerRelations() {
        return this.teamContainerRelations;
    }

    public void setTeamContainerRelations(List<BaseItemLink> teamContainerRelations) {
        this.teamContainerRelations = teamContainerRelations;
    }

    public List<BaseItemLink> getSolutionRelations() {
        return this.solutionRelations;
    }

    public void setSolutionRelations(List<BaseItemLink> solutionRelations) {
        this.solutionRelations = solutionRelations;
    }

    public Boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(Boolean dirty) {
        this.dirty = dirty;
    }

    public String getOtherRequirements() {
        return this.otherRequirements;
    }

    public void setOtherRequirements(String otherRequirements) {
        this.otherRequirements = otherRequirements;
    }

    public String getKendisKey() {
        return this.kendisKey;
    }

    public void setKendisKey(String kendisKey) {
        this.kendisKey = kendisKey;
    }

    public Map<String, BaseItemLink> getArtRelationMap() {
        return this.artRelationMap;
    }

    public void setArtRelationMap(Map<String, BaseItemLink> artRelationMap) {
        this.artRelationMap = artRelationMap;
    }

    public Map<String, List<BaseItemLink>> getParentRelationMap() {
        return this.parentRelationMap;
    }

    public void setParentRelationMap(Map<String, List<BaseItemLink>> parentRelationMap) {
        this.parentRelationMap = parentRelationMap;
    }

    public Map<String, List<BaseItemLink>> getChildRelationMap() {
        return this.childRelationMap;
    }

    public void setChildRelationMap(Map<String, List<BaseItemLink>> childRelationMap) {
        this.childRelationMap = childRelationMap;
    }

    public Boolean getIsNew() {
        return this.isNew;
    }

    public void setIsNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public List<AlmError> getAlmErrors() {
        return this.almErrors;
    }

    public void setAlmErrors(List<AlmError> almErrors) {
        this.almErrors = almErrors;
    }

    public Boolean getShowError() {
        return this.showError;
    }

    public void setShowError(Boolean showError) {
        this.showError = showError;
    }

    public List<BaseItemLink> getItemRelations() {
        return this.itemRelations;
    }

    public void setItemRelations(List<BaseItemLink> itemRelations) {
        this.itemRelations = itemRelations;
    }

    public BaseItemLink getTimeCapsuleRelation() {
        return this.timeCapsuleRelation;
    }

    public void setTimeCapsuleRelation(BaseItemLink timeCapsuleRelation) {
        this.timeCapsuleRelation = timeCapsuleRelation;
    }

    public List<BaseItemLink> getMilestoneRelations() {
        return this.milestoneRelations;
    }

    public void setMilestoneRelations(List<BaseItemLink> milestoneRelations) {
        this.milestoneRelations = milestoneRelations;
    }

    public Map<String, Object> getParentMap() {
        return this.parentMap;
    }

    public void setParentMap(Map<String, Object> parentMap) {
        this.parentMap = parentMap;
    }

    public List<BaseItemLink> getSectionRelations() {
        return this.sectionRelations;
    }

    public void setSectionRelations(List<BaseItemLink> sectionRelations) {
        this.sectionRelations = sectionRelations;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public List<ItemJiraDependency> getDependencyLinks() {
        return this.dependencyLinks;
    }

    public void setDependencyLinks(List<ItemJiraDependency> dependencyLinks) {
        this.dependencyLinks = dependencyLinks;
    }

    public List<String> getDependencyLinkIds() {
        return this.dependencyLinkIds;
    }

    public void setDependencyLinkIds(List<String> dependencyLinkIds) {
        this.dependencyLinkIds = dependencyLinkIds;
    }
}

