/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Item;
import java.util.Calendar;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class AlmInfo
extends BaseEntity {
    @DBRef(lazy=true)
    private Item item;
    private String sessionBoardId;
    private String almInfoMessage;
    private String description;
    private int type = -1;
    private Boolean isResolved = Boolean.FALSE;
    private String requestJson;
    private String endPoint;
    private Long timeInMillis = Calendar.getInstance().getTimeInMillis();

    public AlmInfo() {
    }

    public AlmInfo(String id) {
        this.id = id;
    }

    public AlmInfo(String almInfoMessage, String description, int type, String sessionBoardId, Item item) {
        this.almInfoMessage = almInfoMessage;
        this.description = description;
        this.type = type;
        this.sessionBoardId = sessionBoardId;
        this.setItem(item);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AlmInfo)) {
            return false;
        }
        AlmInfo other = (AlmInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlmError [");
        builder.append("type=");
        builder.append(this.type);
        builder.append(", ");
        if (this.almInfoMessage != null) {
            builder.append("almInfoMessage=");
            builder.append(this.almInfoMessage);
            builder.append(", ");
        }
        if (this.isResolved != null) {
            builder.append("isResolved=");
            builder.append(this.isResolved);
            builder.append(", ");
        }
        if (this.getItem() != null) {
            builder.append("item=");
            builder.append(this.getItem());
            builder.append(", ");
        }
        if (this.sessionBoardId != null) {
            builder.append("sessionBoardId=");
            builder.append(this.sessionBoardId);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        if (this.createdOn != null) {
            builder.append("createdOn=");
            builder.append(this.createdOn);
            builder.append(", ");
        }
        if (this.createdBy != null) {
            builder.append("createdBy=");
            builder.append(this.createdBy);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSessionBoardId() {
        return this.sessionBoardId;
    }

    public void setSessionBoardId(String sessionBoardId) {
        this.sessionBoardId = sessionBoardId;
    }

    public Boolean getIsResolved() {
        return this.isResolved;
    }

    public void setIsResolved(Boolean isResolved) {
        this.isResolved = isResolved;
    }

    public String getRequestJson() {
        return this.requestJson;
    }

    public void setRequestJson(String requestJson) {
        this.requestJson = requestJson;
    }

    public Long getTimeInMillis() {
        return this.timeInMillis;
    }

    public void setTimeInMillis(Long timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }
}

