/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.viztrend.safe.alm.jira.bo.JiraConnect;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.Arrays;
import java.util.Calendar;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class AlmError
extends BaseEntity {
    @DBRef(lazy=true)
    private Item item;
    private String sessionBoardId;
    private String almErrorMessage;
    private String description;
    private String reason;
    private String type;
    private Boolean isTaggedUserAlm;
    private Boolean isResolved = Boolean.FALSE;
    private String requestJson;
    private String errorJson;
    private Integer httpErrorCode;
    private String endPoint;
    private String userName;
    private String trace;
    private String itemId;
    private Long timeInMillis = Calendar.getInstance().getTimeInMillis();
    private String actualLocation;

    public AlmError() {
    }

    public AlmError(String id) {
        this.id = id;
    }

    public AlmError(String almErrorMessage, String description, String type, String sessionBoardId, Item item) {
        this.almErrorMessage = almErrorMessage;
        this.description = description;
        this.type = type;
        this.sessionBoardId = sessionBoardId;
        this.setItem(item);
    }

    public void addInfo(String endPoint, String userName, AlmAccount alm) {
        this.endPoint = endPoint;
        if (Boolean.TRUE.equals(alm.getIsTaggedUser())) {
            this.type = "Profile";
            this.isTaggedUserAlm = true;
        }
        this.userName = PropertyValidator.isValid((Object)alm.getJiraOauthToken()) ? alm.getUsername() : (alm.isUsingJiraConnect() ? "Jira connect" : userName);
        this.trace = Arrays.toString(Thread.currentThread().getStackTrace()).split(".invoke")[0];
    }

    public void addInfo(JiraConnect connect, AlmAccount alm) {
        this.endPoint = connect.getUrl();
        if (Boolean.TRUE.equals(alm.getIsTaggedUser())) {
            this.type = "Profile";
            this.isTaggedUserAlm = true;
        }
        this.userName = "Jira connect";
        this.trace = Arrays.toString(Thread.currentThread().getStackTrace()).split(".invoke")[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AlmError)) {
            return false;
        }
        AlmError other = (AlmError)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlmError [");
        if (this.type != null) {
            builder.append("type=");
            builder.append(this.type);
            builder.append(", ");
        }
        if (this.almErrorMessage != null) {
            builder.append("almErrorMessage=");
            builder.append(this.almErrorMessage);
            builder.append(", ");
        }
        if (this.isResolved != null) {
            builder.append("isResolved=");
            builder.append(this.isResolved);
            builder.append(", ");
        }
        if (this.getItem() != null) {
            builder.append("item=");
            builder.append(this.getItem());
            builder.append(", ");
        }
        if (this.sessionBoardId != null) {
            builder.append("sessionBoardId=");
            builder.append(this.sessionBoardId);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        if (this.createdOn != null) {
            builder.append("createdOn=");
            builder.append(this.createdOn);
            builder.append(", ");
        }
        if (this.createdBy != null) {
            builder.append("createdBy=");
            builder.append(this.createdBy);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getAlmErrorMessage() {
        return this.almErrorMessage;
    }

    public void setAlmErrorMessage(String almErrorMessage) {
        this.almErrorMessage = almErrorMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSessionBoardId() {
        return this.sessionBoardId;
    }

    public void setSessionBoardId(String sessionBoardId) {
        this.sessionBoardId = sessionBoardId;
    }

    public Boolean getIsResolved() {
        return this.isResolved;
    }

    public void setIsResolved(Boolean isResolved) {
        this.isResolved = isResolved;
    }

    public Integer getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public void setHttpErrorCode(Integer httpErrorCode) {
        this.httpErrorCode = httpErrorCode;
    }

    public String getErrorJson() {
        return this.errorJson;
    }

    public void setErrorJson(String errorJson) {
        this.errorJson = errorJson;
    }

    public String getRequestJson() {
        return this.requestJson;
    }

    public void setRequestJson(String requestJson) {
        this.requestJson = requestJson;
    }

    public Long getTimeInMillis() {
        return this.timeInMillis;
    }

    public void setTimeInMillis(Long timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public String getActualLocation() {
        return this.actualLocation;
    }

    public void setActualLocation(String actualLocation) {
        this.actualLocation = actualLocation;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Boolean getIsTaggedUserAlm() {
        return this.isTaggedUserAlm;
    }

    public void setIsTaggedUserAlm(Boolean isTaggedUserAlm) {
        this.isTaggedUserAlm = isTaggedUserAlm;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }
}

