/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.persistence.entity;

import com.mongodb.BasicDBObject;
import com.viztrend.safe.alm.jira.bo.JiraFilter;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.BacklogMappingLinks;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.vos.FilterActionsVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;

public class AlmConfigurations
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 7186059256268364799L;
    private String type;
    private String name;
    @DBRef
    private AlmAccount almAccount;
    private List<JiraFilter> featureFilter;
    private List<JiraFilter> enablerFilter;
    @Transient
    private List<FilterActionsVO> featureFilterActions;
    @Transient
    private List<FilterActionsVO> enablerFilterActions;
    private Boolean useFeature = Boolean.TRUE;
    private Boolean isForEnabler;
    private List<BacklogMapping> featureMappings;
    private List<BacklogMapping> teamMappings;
    private List<BacklogMappingLinks> storyLinkMappings;
    private List<BacklogMappingLinks> featureLinkMappings;
    private List<JiraIssueLinkType> defaultLinkTypes;

    public AlmConfigurations() {
    }

    public AlmConfigurations(BasicDBObject object) {
        this.id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
        this.type = object.getString("type");
        this.name = object.getString("name");
        this.almAccount = new AlmAccount((BasicDBObject)object.get("almAccount"));
    }

    public AlmConfigurations(AlmAccount almAccount) {
        this.almAccount = almAccount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlmConfigurations [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.almAccount != null) {
            builder.append("almAccount=");
            builder.append(this.almAccount);
            builder.append(", ");
        }
        if (this.enablerFilter != null) {
            builder.append("enablerFilter=");
            builder.append(this.enablerFilter);
            builder.append(", ");
        }
        if (this.featureFilter != null) {
            builder.append("featureFilter=");
            builder.append(this.featureFilter);
            builder.append(", ");
        }
        if (this.useFeature != null) {
            builder.append("useFeature=");
            builder.append(this.useFeature);
            builder.append(", ");
        }
        if (this.featureMappings != null) {
            builder.append("featureMappings=");
            builder.append(this.featureMappings);
            builder.append(", ");
        }
        if (this.teamMappings != null) {
            builder.append("teamMappings=");
            builder.append(this.teamMappings);
            builder.append(", ");
        }
        if (this.storyLinkMappings != null) {
            builder.append("storyLinkMappings=");
            builder.append(this.storyLinkMappings);
            builder.append(", ");
        }
        if (this.featureLinkMappings != null) {
            builder.append("featureLinkMappings=");
            builder.append(this.featureLinkMappings);
            builder.append(", ");
        }
        if (this.type != null) {
            builder.append("type=");
            builder.append(this.type);
            builder.append(", ");
        }
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.isForEnabler != null) {
            builder.append("isForEnabler=");
            builder.append(this.isForEnabler);
        }
        builder.append("]");
        return builder.toString();
    }

    public AlmConfigurations(String id) {
        this.id = id;
    }

    public AlmConfigurations(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AlmAccount getAlmAccount() {
        return this.almAccount;
    }

    public void setAlmAccount(AlmAccount almAccount) {
        this.almAccount = almAccount;
    }

    public Boolean getIsForEnabler() {
        return this.isForEnabler;
    }

    public void setIsForEnabler(Boolean isForEnabler) {
        this.isForEnabler = isForEnabler;
    }

    public List<BacklogMapping> getFeatureMappings() {
        return this.featureMappings;
    }

    public void setFeatureMappings(List<BacklogMapping> featureMappings) {
        this.featureMappings = featureMappings;
    }

    public List<BacklogMapping> getTeamMappings() {
        return this.teamMappings;
    }

    public void setTeamMappings(List<BacklogMapping> teamMappings) {
        this.teamMappings = teamMappings;
    }

    public List<BacklogMappingLinks> getStoryLinkMappings() {
        return this.storyLinkMappings;
    }

    public void setStoryLinkMappings(List<BacklogMappingLinks> storyLinkMappings) {
        this.storyLinkMappings = storyLinkMappings;
    }

    public Boolean getUseFeature() {
        return this.useFeature;
    }

    public void setUseFeature(Boolean useFeature) {
        this.useFeature = useFeature;
    }

    public List<JiraFilter> getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(List<JiraFilter> featureFilter) {
        this.featureFilter = featureFilter;
    }

    public List<JiraFilter> getEnablerFilter() {
        return this.enablerFilter;
    }

    public void setEnablerFilter(List<JiraFilter> enablerFilter) {
        this.enablerFilter = enablerFilter;
    }

    public List<FilterActionsVO> getFeatureFilterActions() {
        return this.featureFilterActions;
    }

    public void setFeatureFilterActions(List<FilterActionsVO> featureFilterActions) {
        this.featureFilterActions = featureFilterActions;
    }

    public List<FilterActionsVO> getEnablerFilterActions() {
        return this.enablerFilterActions;
    }

    public void setEnablerFilterActions(List<FilterActionsVO> enablerFilterActions) {
        this.enablerFilterActions = enablerFilterActions;
    }

    public List<BacklogMappingLinks> getFeatureLinkMappings() {
        return this.featureLinkMappings;
    }

    public void setFeatureLinkMappings(List<BacklogMappingLinks> featureLinkMappings) {
        this.featureLinkMappings = featureLinkMappings;
    }

    public List<JiraIssueLinkType> getDefaultLinkTypes() {
        return this.defaultLinkTypes;
    }

    public void setDefaultLinkTypes(List<JiraIssueLinkType> defaultLinkTypes) {
        this.defaultLinkTypes = defaultLinkTypes;
    }

    public void addInFeatureMappings(Collection<BacklogMappingLinks> linkMappings) {
        if (PropertyValidator.isValid(linkMappings)) {
            for (BacklogMappingLinks filterLinkMapping : linkMappings) {
                JiraIssueType issueType;
                String id;
                boolean mappingFoundFlag = false;
                BacklogMapping existingProjectLinkMapping = null;
                if (PropertyValidator.isValid((Collection)this.getFeatureMappings())) {
                    for (BacklogMapping projectLinkMapping : this.getFeatureMappings()) {
                        if (!PropertyValidator.isValid((Object)filterLinkMapping.getProjectKey()) || !filterLinkMapping.getProjectKey().equals(projectLinkMapping.getProjectKey())) continue;
                        existingProjectLinkMapping = projectLinkMapping;
                        mappingFoundFlag = true;
                        break;
                    }
                    if (mappingFoundFlag && PropertyValidator.isValid((Collection)existingProjectLinkMapping.getDefaultLinkTypes())) {
                        for (JiraIssueLinkType linkType : filterLinkMapping.getLinkTypes()) {
                            existingProjectLinkMapping.getDefaultLinkTypes().add(0, linkType.getId() + "-" + linkType.getDirection());
                        }
                        continue;
                    }
                    if (mappingFoundFlag && !PropertyValidator.isValid((Collection)existingProjectLinkMapping.getDefaultLinkTypes())) {
                        existingProjectLinkMapping.setDefaultLinkTypes(new ArrayList());
                        for (JiraIssueLinkType linkType : filterLinkMapping.getLinkTypes()) {
                            existingProjectLinkMapping.getDefaultLinkTypes().add(linkType.getId() + "-" + linkType.getDirection());
                        }
                        continue;
                    }
                    if (mappingFoundFlag) continue;
                    existingProjectLinkMapping = new BacklogMapping();
                    id = UUID.randomUUID().toString();
                    existingProjectLinkMapping.setBacklogId(id);
                    existingProjectLinkMapping.setBoardId("-1");
                    existingProjectLinkMapping.setBoardName("Select Board");
                    issueType = new JiraIssueType();
                    issueType.setId("-1");
                    issueType.setName("Select Type");
                    issueType.setSubtask("false");
                    existingProjectLinkMapping.setItemType(issueType);
                    existingProjectLinkMapping.setBoardName("Select Board");
                    existingProjectLinkMapping.setTeamId(id);
                    existingProjectLinkMapping.setProjectKey(filterLinkMapping.getProjectKey());
                    existingProjectLinkMapping.setDefaultLinkTypes(new ArrayList());
                    for (JiraIssueLinkType linkType : filterLinkMapping.getLinkTypes()) {
                        existingProjectLinkMapping.getDefaultLinkTypes().add(linkType.getId() + "-" + linkType.getDirection());
                    }
                    if (filterLinkMapping.isNexus().booleanValue()) continue;
                    this.getFeatureMappings().add(existingProjectLinkMapping);
                    continue;
                }
                existingProjectLinkMapping = new BacklogMapping();
                id = UUID.randomUUID().toString();
                existingProjectLinkMapping.setBacklogId(id);
                existingProjectLinkMapping.setBoardId("-1");
                existingProjectLinkMapping.setBoardName("Select Board");
                issueType = new JiraIssueType();
                issueType.setId("-1");
                issueType.setName("Select Type");
                issueType.setSubtask("false");
                existingProjectLinkMapping.setItemType(issueType);
                existingProjectLinkMapping.setBoardName("Select Board");
                existingProjectLinkMapping.setTeamId(id);
                existingProjectLinkMapping.setProjectKey(filterLinkMapping.getProjectKey());
                existingProjectLinkMapping.setDefaultLinkTypes(new ArrayList());
                for (JiraIssueLinkType linkType : filterLinkMapping.getLinkTypes()) {
                    existingProjectLinkMapping.getDefaultLinkTypes().add(linkType.getId() + "-" + linkType.getDirection());
                }
                if (filterLinkMapping.isNexus().booleanValue()) continue;
                this.getFeatureMappings().add(existingProjectLinkMapping);
            }
        }
    }
}

