/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.mapper;

import com.viztrend.safe.dto.WorkSpaceLinksGroupDTO;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.WorkSpaceLink;
import com.viztrend.safe.persistence.entity.WorkSpaceLinksGroup;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceLinkRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class WorkSpaceLinksGroupMapper {
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected WorkSpaceLinkRepository workSpaceLinkRepository;

    @Named(value="baseMapping")
    @Mappings(value={@Mapping(source="creator", target="creator", qualifiedByName={"mapCreatorIdToUser"}), @Mapping(source="links", target="links", qualifiedByName={"mapStringListToWorkSpaceLinkList"})})
    public abstract WorkSpaceLinksGroupDTO toDto(WorkSpaceLinksGroup var1);

    public abstract List<WorkSpaceLinksGroupDTO> toDTOList(List<WorkSpaceLinksGroup> var1);

    @Mappings(value={@Mapping(source="group", target="."), @Mapping(target="links", ignore=true), @Mapping(target="creator", ignore=true)})
    public abstract WorkSpaceLinksGroupDTO toDTOWithLinksAndCreator(WorkSpaceLinksGroup var1);

    @Named(value="mapCreatorIdToUser")
    protected User mapCreatorIdToUser(String creatorId) {
        if (creatorId == null) {
            return null;
        }
        User user = new User();
        user.setId(creatorId);
        return user;
    }

    @Named(value="mapStringToWorkSpaceLink")
    protected WorkSpaceLink mapStringToWorkSpaceLink(String id) {
        if (id == null) {
            return null;
        }
        WorkSpaceLink link = new WorkSpaceLink();
        link.setId(id);
        return link;
    }

    @Named(value="mapStringListToWorkSpaceLinkList")
    protected List<WorkSpaceLink> mapStringListToWorkSpaceLinkList(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        return stringList.stream().map(arg_0 -> this.mapStringToWorkSpaceLink(arg_0)).collect(Collectors.toList());
    }

    @AfterMapping
    protected void withCreatorAndLinks(WorkSpaceLinksGroup group, @MappingTarget WorkSpaceLinksGroupDTO dto) {
        if (group.getCreator() != null) {
            dto.setCreator(this.userRepository.findById(group.getCreator()));
        }
        if (group.getLinks() != null && !group.getLinks().isEmpty()) {
            List links = this.workSpaceLinkRepository.findAllWorkspaceLinksByIdIn(group.getLinks());
            dto.setLinks(links);
        }
    }
}

