/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.mapper;

import com.viztrend.safe.dto.FieldOptionDTO;
import com.viztrend.safe.dto.ModuleContextDTO;
import com.viztrend.safe.dto.SystemFieldResponseDTO;
import com.viztrend.safe.dto.SystemFieldsListResponseDTO;
import com.viztrend.safe.enums.EnumFieldIdentifier;
import com.viztrend.safe.persistence.entity.Context;
import com.viztrend.safe.persistence.entity.Fields;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring")
public interface SystemFieldMapper {
    public static final SystemFieldMapper INSTANCE = (SystemFieldMapper)Mappers.getMapper(SystemFieldMapper.class);

    default public SystemFieldResponseDTO toSystemFieldResponseDTO(Fields field) {
        if (field == null) {
            return null;
        }
        return SystemFieldResponseDTO.builder().id(field.getId()).title(field.getTitle()).description(field.getDescription()).type(field.getType()).code(field.getCode()).identifier(this.enumToString(field.getIdentifier())).isRequired(field.getIsRequired()).isCustomisable(field.getIsCustomisable()).allowedObjects(this.toFieldOptionDTOList(field.getAllowedObjects())).moduleContexts(this.toModuleContextDTOList(field.getModuleContexts())).build();
    }

    @Named(value="enumToString")
    default public String enumToString(EnumFieldIdentifier identifier) {
        return identifier != null ? identifier.name() : null;
    }

    public List<SystemFieldResponseDTO> toSystemFieldResponseDTOList(List<Fields> var1);

    default public SystemFieldsListResponseDTO toSystemFieldsListResponseDTO(List<Fields> fields) {
        if (fields == null) {
            return SystemFieldsListResponseDTO.builder().fields(null).totalCount(Integer.valueOf(0)).build();
        }
        List fieldDTOs = this.toSystemFieldResponseDTOList(fields);
        return SystemFieldsListResponseDTO.builder().fields(fieldDTOs).totalCount(Integer.valueOf(fields.size())).build();
    }

    default public FieldOptionDTO toFieldOptionDTO(HashMap<String, String> option) {
        if (option == null) {
            return null;
        }
        return FieldOptionDTO.builder().id(option.get("id")).title(option.get("title")).build();
    }

    default public List<FieldOptionDTO> toFieldOptionDTOList(List<HashMap<String, String>> options) {
        if (options == null) {
            return null;
        }
        return options.stream().map(arg_0 -> this.toFieldOptionDTO(arg_0)).collect(Collectors.toList());
    }

    default public ModuleContextDTO toModuleContextDTO(Context context) {
        if (context == null) {
            return null;
        }
        return ModuleContextDTO.builder().itemTypeId(context.getItemTypeId()).isVisible(context.getIsVisible()).isMandatory(context.getIsMandatory()).build();
    }

    default public List<ModuleContextDTO> toModuleContextDTOList(List<Context> contexts) {
        if (contexts == null) {
            return null;
        }
        return contexts.stream().map(arg_0 -> this.toModuleContextDTO(arg_0)).collect(Collectors.toList());
    }
}

